/*

 helper function for srs_init.c -- populating the SPATIAL_REF_SYS table

 this code was autogenerated by "auto_epsg_ext" on Thu Mar  3 12:51:49 2022

 Author: Sandro Furieri a.furieri@lqt.it

 -----------------------------------------------------------------------------

 Version: MPL 1.1/GPL 2.0/LGPL 2.1

 The contents of this file are subject to the Mozilla Public License Version
 1.1 (the "License"); you may not use this file except in compliance with
 the License. You may obtain a copy of the License at
 http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
for the specific language governing rights and limitations under the
License.

The Original Code is the SpatiaLite library

The Initial Developer of the Original Code is Alessandro Furieri

Portions created by the Initial Developer are Copyright (C) 2008
the Initial Developer. All Rights Reserved.

Contributor(s):

Alternatively, the contents of this file may be used under the terms of
either the GNU General Public License Version 2 or later (the "GPL"), or
the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
in which case the provisions of the GPL or the LGPL are applicable instead
of those above. If you wish to allow use of your version of this file only
under the terms of either the GPL or the LGPL, and not to allow others to
use your version of this file under the terms of the MPL, indicate your
decision by deleting the provisions above and replace them with the notice
and other provisions required by the GPL or the LGPL. If you do not delete
the provisions above, a recipient may use your version of this file under
the terms of any one of the MPL, the GPL or the LGPL.

*/

#if defined(_WIN32) && !defined(__MINGW32__)
#include "config-msvc.h"
#else
#include "config.h"
#endif

#include <spatialite_private.h>

#ifndef OMIT_EPSG    /* full EPSG initialization enabled */

SPATIALITE_PRIVATE void
initialize_epsg_36 (int filter, struct epsg_defs **first, struct epsg_defs **last)
{
/* initializing the EPSG defs list */
    struct epsg_defs *p;
    p = add_epsg_def_ex (filter, first, last, 7037, "epsg", 7037,
        "RGR92 (lon-lat)", 1, 0,
        "GRS 1980", "Greenwich",
        "Reseau_Geodesique_de_la_Reunion_1992", "none", "degree",
        "Geodetic longitude", "East", "Geodetic latitude", "North");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"RGR92 (lon-lat)\",DATUM[\"Reseau_Geodesique_de_");
    add_srs_wkt (p, 1,
        "la_Reunion_1992\",SPHEROID[\"GRS 1980\",6378137,298.2572");
    add_srs_wkt (p, 2,
        "22101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "6627\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 4,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"9122\"]],AXIS[\"Longitude\",EAST],AXIS[\"Latitude\"");
    add_srs_wkt (p, 6,
        ",NORTH],AUTHORITY[\"EPSG\",\"7037\"]]");
    p = add_epsg_def_ex (filter, first, last, 7038, "epsg", 7038,
        "RGM04 (lon-lat)", 1, 0,
        "GRS 1980", "Greenwich",
        "Reseau_Geodesique_de_Mayotte_2004", "none", "degree",
        "Geodetic longitude", "East", "Geodetic latitude", "North");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"RGM04 (lon-lat)\",DATUM[\"Reseau Geodesique de");
    add_srs_wkt (p, 1,
        " Mayotte 2004\",ELLIPSOID[\"GRS 1980\",6378137,298.25722");
    add_srs_wkt (p, 2,
        "2101,LENGTHUNIT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,AN");
    add_srs_wkt (p, 3,
        "GLEUNIT[\"degree\",0.0174532925199433]],CS[ellipsoidal,3");
    add_srs_wkt (p, 4,
        "],AXIS[\"geodetic longitude (Lon)\",east,ORDER[1],ANGLEU");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433]],AXIS[\"geodetic lati");
    add_srs_wkt (p, 6,
        "tude (Lat)\",north,ORDER[2],ANGLEUNIT[\"degree\",0.01745");
    add_srs_wkt (p, 7,
        "32925199433]],AXIS[\"ellipsoidal height (h)\",up,ORDER[3");
    add_srs_wkt (p, 8,
        "],LENGTHUNIT[\"metre\",1]],USAGE[SCOPE[\"GIS.\"],AREA[\"");
    add_srs_wkt (p, 9,
        "Mayotte - onshore and offshore.\"],BBOX[-14.49,43.68,-11");
    add_srs_wkt (p, 10,
        ".33,46.7]],ID[\"EPSG\",7038]]");
    p = add_epsg_def_ex (filter, first, last, 7039, "epsg", 7039,
        "RGM04 (lon-lat)", 1, 0,
        "GRS 1980", "Greenwich",
        "Reseau_Geodesique_de_Mayotte_2004", "none", "degree",
        "Geodetic longitude", "East", "Geodetic latitude", "North");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"RGM04 (lon-lat)\",DATUM[\"Reseau_Geodesique_de_");
    add_srs_wkt (p, 1,
        "Mayotte_2004\",SPHEROID[\"GRS 1980\",6378137,298.2572221");
    add_srs_wkt (p, 2,
        "01,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"10");
    add_srs_wkt (p, 3,
        "36\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 4,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"9122\"]],AXIS[\"Longitude\",EAST],AXIS[\"Latitude\",N");
    add_srs_wkt (p, 6,
        "ORTH],AUTHORITY[\"EPSG\",\"7039\"]]");
    p = add_epsg_def_ex (filter, first, last, 7040, "epsg", 7040,
        "RGFG95 (lon-lat)", 1, 0,
        "GRS 1980", "Greenwich",
        "Reseau_Geodesique_Francais_Guyane_1995", "none", "degree",
        "Geodetic longitude", "East", "Geodetic latitude", "North");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"RGFG95 (lon-lat)\",DATUM[\"Reseau Geodesique F");
    add_srs_wkt (p, 1,
        "rancais Guyane 1995\",ELLIPSOID[\"GRS 1980\",6378137,298");
    add_srs_wkt (p, 2,
        ".257222101,LENGTHUNIT[\"metre\",1]]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 3,
        ",0,ANGLEUNIT[\"degree\",0.0174532925199433]],CS[ellipsoi");
    add_srs_wkt (p, 4,
        "dal,3],AXIS[\"geodetic longitude (Lon)\",east,ORDER[1],A");
    add_srs_wkt (p, 5,
        "NGLEUNIT[\"degree\",0.0174532925199433]],AXIS[\"geodetic");
    add_srs_wkt (p, 6,
        " latitude (Lat)\",north,ORDER[2],ANGLEUNIT[\"degree\",0.");
    add_srs_wkt (p, 7,
        "0174532925199433]],AXIS[\"ellipsoidal height (h)\",up,OR");
    add_srs_wkt (p, 8,
        "DER[3],LENGTHUNIT[\"metre\",1]],USAGE[SCOPE[\"GIS.\"],AR");
    add_srs_wkt (p, 9,
        "EA[\"French Guiana - onshore and offshore.\"],BBOX[2.11,");
    add_srs_wkt (p, 10,
        "-54.61,8.88,-49.45]],ID[\"EPSG\",7040]]");
    p = add_epsg_def_ex (filter, first, last, 7041, "epsg", 7041,
        "RGFG95 (lon-lat)", 1, 0,
        "GRS 1980", "Greenwich",
        "Reseau_Geodesique_Francais_Guyane_1995", "none", "degree",
        "Geodetic longitude", "East", "Geodetic latitude", "North");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"RGFG95 (lon-lat)\",DATUM[\"Reseau_Geodesique_Fr");
    add_srs_wkt (p, 1,
        "ancais_Guyane_1995\",SPHEROID[\"GRS 1980\",6378137,298.2");
    add_srs_wkt (p, 2,
        "57222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"6624\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AXIS[\"Longitude\",EAST],AXIS[\"Latitu");
    add_srs_wkt (p, 6,
        "de\",NORTH],AUTHORITY[\"EPSG\",\"7041\"]]");
    p = add_epsg_def_ex (filter, first, last, 7042, "epsg", 7042,
        "RGF93 v1 (lon-lat)", 1, 0,
        "GRS 1980", "Greenwich",
        "Reseau_Geodesique_Francais_1993_v1", "none", "degree",
        "Geodetic longitude", "East", "Geodetic latitude", "North");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"RGF93 v1 (lon-lat)\",DATUM[\"Reseau Geodesique");
    add_srs_wkt (p, 1,
        " Francais 1993 v1\",ELLIPSOID[\"GRS 1980\",6378137,298.2");
    add_srs_wkt (p, 2,
        "57222101,LENGTHUNIT[\"metre\",1]]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 3,
        "0,ANGLEUNIT[\"degree\",0.0174532925199433]],CS[ellipsoid");
    add_srs_wkt (p, 4,
        "al,3],AXIS[\"geodetic longitude (Lon)\",east,ORDER[1],AN");
    add_srs_wkt (p, 5,
        "GLEUNIT[\"degree\",0.0174532925199433]],AXIS[\"geodetic ");
    add_srs_wkt (p, 6,
        "latitude (Lat)\",north,ORDER[2],ANGLEUNIT[\"degree\",0.0");
    add_srs_wkt (p, 7,
        "174532925199433]],AXIS[\"ellipsoidal height (h)\",up,ORD");
    add_srs_wkt (p, 8,
        "ER[3],LENGTHUNIT[\"metre\",1]],USAGE[SCOPE[\"GIS.\"],ARE");
    add_srs_wkt (p, 9,
        "A[\"France - onshore and offshore, mainland and Corsica.");
    add_srs_wkt (p, 10,
        "\"],BBOX[41.15,-9.86,51.56,10.38]],ID[\"EPSG\",7042]]");
    p = add_epsg_def_ex (filter, first, last, 7057, "epsg", 7057,
        "NAD83(2011) / IaRCS zone 1", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=43.2 +lat_0=43.2 +lon_0=-95.25 +k_0=1.0");
    add_proj4text (p, 1,
        "00052 +x_0=3505207.010414021 +y_0=2926085.852171705 +ell");
    add_proj4text (p, 2,
        "ps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / IaRCS zone 1\",GEOGCS[\"NAD83(201");
    add_srs_wkt (p, 1,
        "1)\",DATUM[\"NAD83_National_Spatial_Reference_System_201");
    add_srs_wkt (p, 2,
        "1\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lambert_Con");
    add_srs_wkt (p, 7,
        "formal_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",43.");
    add_srs_wkt (p, 8,
        "2],PARAMETER[\"central_meridian\",-95.25],PARAMETER[\"sc");
    add_srs_wkt (p, 9,
        "ale_factor\",1.000052],PARAMETER[\"false_easting\",11500");
    add_srs_wkt (p, 10,
        "000],PARAMETER[\"false_northing\",9600000],UNIT[\"US sur");
    add_srs_wkt (p, 11,
        "vey foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"");
    add_srs_wkt (p, 12,
        "]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHO");
    add_srs_wkt (p, 13,
        "RITY[\"EPSG\",\"7057\"]]");
    p = add_epsg_def_ex (filter, first, last, 7058, "epsg", 7058,
        "NAD83(2011) / IaRCS zone 2", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=43.16666666666666 +lat_0=43.16666666666");
    add_proj4text (p, 1,
        "666 +lon_0=-92.75 +k_0=1.000043 +x_0=3810007.62001524 +y");
    add_proj4text (p, 2,
        "_0=2987045.974091948 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / IaRCS zone 2\",GEOGCS[\"NAD83(201");
    add_srs_wkt (p, 1,
        "1)\",DATUM[\"NAD83_National_Spatial_Reference_System_201");
    add_srs_wkt (p, 2,
        "1\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lambert_Con");
    add_srs_wkt (p, 7,
        "formal_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",43.");
    add_srs_wkt (p, 8,
        "1666666666667],PARAMETER[\"central_meridian\",-92.75],PA");
    add_srs_wkt (p, 9,
        "RAMETER[\"scale_factor\",1.000043],PARAMETER[\"false_eas");
    add_srs_wkt (p, 10,
        "ting\",12500000],PARAMETER[\"false_northing\",9800000],U");
    add_srs_wkt (p, 11,
        "NIT[\"US survey foot\",0.304800609601219,AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",");
    add_srs_wkt (p, 13,
        "NORTH],AUTHORITY[\"EPSG\",\"7058\"]]");
    p = add_epsg_def_ex (filter, first, last, 7059, "epsg", 7059,
        "NAD83(2011) / IaRCS zone 3", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=40.25 +lon_0=-91.2 +k=1.000035 +x_0=4");
    add_proj4text (p, 1,
        "114808.229616459 +y_0=2529845.05969012 +ellps=GRS80 +uni");
    add_proj4text (p, 2,
        "ts=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / IaRCS zone 3\",GEOGCS[\"NAD83(201");
    add_srs_wkt (p, 1,
        "1)\",DATUM[\"NAD83_National_Spatial_Reference_System_201");
    add_srs_wkt (p, 2,
        "1\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 7,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",40.25],PARA");
    add_srs_wkt (p, 8,
        "METER[\"central_meridian\",-91.2],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 9,
        "or\",1.000035],PARAMETER[\"false_easting\",13500000],PAR");
    add_srs_wkt (p, 10,
        "AMETER[\"false_northing\",8300000],UNIT[\"US survey foot");
    add_srs_wkt (p, 11,
        "\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[");
    add_srs_wkt (p, 12,
        "\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 13,
        "PSG\",\"7059\"]]");
    p = add_epsg_def_ex (filter, first, last, 7060, "epsg", 7060,
        "NAD83(2011) / IaRCS zone 4", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=42.53333333333333 +lat_0=42.53333333333");
    add_proj4text (p, 1,
        "333 +lon_0=-94.83333333333333 +k_0=1.000045 +x_0=4419608");
    add_proj4text (p, 2,
        ".839217679 +y_0=2621285.242570485 +ellps=GRS80 +units=us");
    add_proj4text (p, 3,
        "-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / IaRCS zone 4\",GEOGCS[\"NAD83(201");
    add_srs_wkt (p, 1,
        "1)\",DATUM[\"NAD83_National_Spatial_Reference_System_201");
    add_srs_wkt (p, 2,
        "1\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lambert_Con");
    add_srs_wkt (p, 7,
        "formal_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",42.");
    add_srs_wkt (p, 8,
        "5333333333333],PARAMETER[\"central_meridian\",-94.833333");
    add_srs_wkt (p, 9,
        "3333333],PARAMETER[\"scale_factor\",1.000045],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"false_easting\",14500000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 11,
        ",8600000],UNIT[\"US survey foot\",0.304800609601219,AUTH");
    add_srs_wkt (p, 12,
        "ORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 13,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"7060\"]]");
    p = add_epsg_def_ex (filter, first, last, 7061, "epsg", 7061,
        "NAD83(2011) / IaRCS zone 5", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=42.65 +lat_0=42.65 +lon_0=-92.25 +k_0=1");
    add_proj4text (p, 1,
        ".000032 +x_0=4724409.448818898 +y_0=2712725.425450851 +e");
    add_proj4text (p, 2,
        "llps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / IaRCS zone 5\",GEOGCS[\"NAD83(201");
    add_srs_wkt (p, 1,
        "1)\",DATUM[\"NAD83_National_Spatial_Reference_System_201");
    add_srs_wkt (p, 2,
        "1\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lambert_Con");
    add_srs_wkt (p, 7,
        "formal_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",42.");
    add_srs_wkt (p, 8,
        "65],PARAMETER[\"central_meridian\",-92.25],PARAMETER[\"s");
    add_srs_wkt (p, 9,
        "cale_factor\",1.000032],PARAMETER[\"false_easting\",1550");
    add_srs_wkt (p, 10,
        "0000],PARAMETER[\"false_northing\",8900000],UNIT[\"US su");
    add_srs_wkt (p, 11,
        "rvey foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"");
    add_srs_wkt (p, 12,
        "]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHO");
    add_srs_wkt (p, 13,
        "RITY[\"EPSG\",\"7061\"]]");
    p = add_epsg_def_ex (filter, first, last, 7062, "epsg", 7062,
        "NAD83(2011) / IaRCS zone 6", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=40.25 +lon_0=-95.73333333333333 +k=1.");
    add_proj4text (p, 1,
        "000039 +x_0=5029210.058420117 +y_0=2011684.023368047 +el");
    add_proj4text (p, 2,
        "lps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / IaRCS zone 6\",GEOGCS[\"NAD83(201");
    add_srs_wkt (p, 1,
        "1)\",DATUM[\"NAD83_National_Spatial_Reference_System_201");
    add_srs_wkt (p, 2,
        "1\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 7,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",40.25],PARA");
    add_srs_wkt (p, 8,
        "METER[\"central_meridian\",-95.7333333333333],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"scale_factor\",1.000039],PARAMETER[\"false_easting\",1");
    add_srs_wkt (p, 10,
        "6500000],PARAMETER[\"false_northing\",6600000],UNIT[\"US");
    add_srs_wkt (p, 11,
        " survey foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 12,
        "03\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],A");
    add_srs_wkt (p, 13,
        "UTHORITY[\"EPSG\",\"7062\"]]");
    p = add_epsg_def_ex (filter, first, last, 7063, "epsg", 7063,
        "NAD83(2011) / IaRCS zone 7", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=40.25 +lon_0=-94.63333333333334 +k=1.");
    add_proj4text (p, 1,
        "000045 +x_0=5334010.668021336 +y_0=2072644.145288291 +el");
    add_proj4text (p, 2,
        "lps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / IaRCS zone 7\",GEOGCS[\"NAD83(201");
    add_srs_wkt (p, 1,
        "1)\",DATUM[\"NAD83_National_Spatial_Reference_System_201");
    add_srs_wkt (p, 2,
        "1\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 7,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",40.25],PARA");
    add_srs_wkt (p, 8,
        "METER[\"central_meridian\",-94.6333333333333],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"scale_factor\",1.000045],PARAMETER[\"false_easting\",1");
    add_srs_wkt (p, 10,
        "7500000],PARAMETER[\"false_northing\",6800000],UNIT[\"US");
    add_srs_wkt (p, 11,
        " survey foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 12,
        "03\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],A");
    add_srs_wkt (p, 13,
        "UTHORITY[\"EPSG\",\"7063\"]]");
    p = add_epsg_def_ex (filter, first, last, 7064, "epsg", 7064,
        "NAD83(2011) / IaRCS zone 8", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=40.25 +lon_0=-93.71666666666667 +k=1.");
    add_proj4text (p, 1,
        "000033 +x_0=5638811.277622555 +y_0=2133604.267208535 +el");
    add_proj4text (p, 2,
        "lps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / IaRCS zone 8\",GEOGCS[\"NAD83(201");
    add_srs_wkt (p, 1,
        "1)\",DATUM[\"NAD83_National_Spatial_Reference_System_201");
    add_srs_wkt (p, 2,
        "1\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 7,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",40.25],PARA");
    add_srs_wkt (p, 8,
        "METER[\"central_meridian\",-93.7166666666667],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"scale_factor\",1.000033],PARAMETER[\"false_easting\",1");
    add_srs_wkt (p, 10,
        "8500000],PARAMETER[\"false_northing\",7000000],UNIT[\"US");
    add_srs_wkt (p, 11,
        " survey foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 12,
        "03\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],A");
    add_srs_wkt (p, 13,
        "UTHORITY[\"EPSG\",\"7064\"]]");
    p = add_epsg_def_ex (filter, first, last, 7065, "epsg", 7065,
        "NAD83(2011) / IaRCS zone 9", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=40.25 +lon_0=-92.81666666666666 +k=1.");
    add_proj4text (p, 1,
        "000027 +x_0=5943611.887223775 +y_0=2194564.389128779 +el");
    add_proj4text (p, 2,
        "lps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / IaRCS zone 9\",GEOGCS[\"NAD83(201");
    add_srs_wkt (p, 1,
        "1)\",DATUM[\"NAD83_National_Spatial_Reference_System_201");
    add_srs_wkt (p, 2,
        "1\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 7,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",40.25],PARA");
    add_srs_wkt (p, 8,
        "METER[\"central_meridian\",-92.8166666666667],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"scale_factor\",1.000027],PARAMETER[\"false_easting\",1");
    add_srs_wkt (p, 10,
        "9500000],PARAMETER[\"false_northing\",7200000],UNIT[\"US");
    add_srs_wkt (p, 11,
        " survey foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 12,
        "03\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],A");
    add_srs_wkt (p, 13,
        "UTHORITY[\"EPSG\",\"7065\"]]");
    p = add_epsg_def_ex (filter, first, last, 7066, "epsg", 7066,
        "NAD83(2011) / IaRCS zone 10", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=41.83333333333334 +lat_0=41.83333333333");
    add_proj4text (p, 1,
        "334 +lon_0=-91.66666666666667 +k_0=1.00002 +x_0=6248412.");
    add_proj4text (p, 2,
        "496824994 +y_0=2438404.876809754 +ellps=GRS80 +units=us-");
    add_proj4text (p, 3,
        "ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / IaRCS zone 10\",GEOGCS[\"NAD83(20");
    add_srs_wkt (p, 1,
        "11)\",DATUM[\"NAD83_National_Spatial_Reference_System_20");
    add_srs_wkt (p, 2,
        "11\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],PRI");
    add_srs_wkt (p, 4,
        "MEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lambert_Con");
    add_srs_wkt (p, 7,
        "formal_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",41.");
    add_srs_wkt (p, 8,
        "8333333333333],PARAMETER[\"central_meridian\",-91.666666");
    add_srs_wkt (p, 9,
        "6666667],PARAMETER[\"scale_factor\",1.00002],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",20500000],PARAMETER[\"false_northing\",8");
    add_srs_wkt (p, 11,
        "000000],UNIT[\"US survey foot\",0.304800609601219,AUTHOR");
    add_srs_wkt (p, 12,
        "ITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"No");
    add_srs_wkt (p, 13,
        "rthing\",NORTH],AUTHORITY[\"EPSG\",\"7066\"]]");
    p = add_epsg_def_ex (filter, first, last, 7067, "epsg", 7067,
        "NAD83(2011) / IaRCS zone 11", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=40.25 +lon_0=-90.53333333333333 +k=1.");
    add_proj4text (p, 1,
        "000027 +x_0=6553213.106426213 +y_0=2316484.632969266 +el");
    add_proj4text (p, 2,
        "lps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / IaRCS zone 11\",GEOGCS[\"NAD83(20");
    add_srs_wkt (p, 1,
        "11)\",DATUM[\"NAD83_National_Spatial_Reference_System_20");
    add_srs_wkt (p, 2,
        "11\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],PRI");
    add_srs_wkt (p, 4,
        "MEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 7,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",40.25],PARA");
    add_srs_wkt (p, 8,
        "METER[\"central_meridian\",-90.5333333333333],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"scale_factor\",1.000027],PARAMETER[\"false_easting\",2");
    add_srs_wkt (p, 10,
        "1500000],PARAMETER[\"false_northing\",7600000],UNIT[\"US");
    add_srs_wkt (p, 11,
        " survey foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 12,
        "03\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],A");
    add_srs_wkt (p, 13,
        "UTHORITY[\"EPSG\",\"7067\"]]");
    p = add_epsg_def_ex (filter, first, last, 7068, "epsg", 7068,
        "NAD83(2011) / IaRCS zone 12", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=40.91666666666666 +lat_0=40.91666666666");
    add_proj4text (p, 1,
        "666 +lon_0=-93.75 +k_0=1.000037 +x_0=6858013.716027432 +");
    add_proj4text (p, 2,
        "y_0=1889763.779527559 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / IaRCS zone 12\",GEOGCS[\"NAD83(20");
    add_srs_wkt (p, 1,
        "11)\",DATUM[\"NAD83_National_Spatial_Reference_System_20");
    add_srs_wkt (p, 2,
        "11\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],PRI");
    add_srs_wkt (p, 4,
        "MEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lambert_Con");
    add_srs_wkt (p, 7,
        "formal_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",40.");
    add_srs_wkt (p, 8,
        "9166666666667],PARAMETER[\"central_meridian\",-93.75],PA");
    add_srs_wkt (p, 9,
        "RAMETER[\"scale_factor\",1.000037],PARAMETER[\"false_eas");
    add_srs_wkt (p, 10,
        "ting\",22500000],PARAMETER[\"false_northing\",6200000],U");
    add_srs_wkt (p, 11,
        "NIT[\"US survey foot\",0.304800609601219,AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",");
    add_srs_wkt (p, 13,
        "NORTH],AUTHORITY[\"EPSG\",\"7068\"]]");
    p = add_epsg_def_ex (filter, first, last, 7069, "epsg", 7069,
        "NAD83(2011) / IaRCS zone 13", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=40.25 +lon_0=-91.91666666666667 +k=1.");
    add_proj4text (p, 1,
        "00002 +x_0=7162814.325628651 +y_0=1950723.901447803 +ell");
    add_proj4text (p, 2,
        "ps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / IaRCS zone 13\",GEOGCS[\"NAD83(20");
    add_srs_wkt (p, 1,
        "11)\",DATUM[\"NAD83_National_Spatial_Reference_System_20");
    add_srs_wkt (p, 2,
        "11\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],PRI");
    add_srs_wkt (p, 4,
        "MEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 7,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",40.25],PARA");
    add_srs_wkt (p, 8,
        "METER[\"central_meridian\",-91.9166666666667],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"scale_factor\",1.00002],PARAMETER[\"false_easting\",23");
    add_srs_wkt (p, 10,
        "500000],PARAMETER[\"false_northing\",6400000],UNIT[\"US ");
    add_srs_wkt (p, 11,
        "survey foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 12,
        "3\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AU");
    add_srs_wkt (p, 13,
        "THORITY[\"EPSG\",\"7069\"]]");
    p = add_epsg_def_ex (filter, first, last, 7070, "epsg", 7070,
        "NAD83(2011) / IaRCS zone 14", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=40.25 +lon_0=-91.25 +k=1.000018 +x_0=");
    add_proj4text (p, 1,
        "7467614.93522987 +y_0=1889763.779527559 +ellps=GRS80 +un");
    add_proj4text (p, 2,
        "its=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / IaRCS zone 14\",GEOGCS[\"NAD83(20");
    add_srs_wkt (p, 1,
        "11)\",DATUM[\"NAD83_National_Spatial_Reference_System_20");
    add_srs_wkt (p, 2,
        "11\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],PRI");
    add_srs_wkt (p, 4,
        "MEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 7,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",40.25],PARA");
    add_srs_wkt (p, 8,
        "METER[\"central_meridian\",-91.25],PARAMETER[\"scale_fac");
    add_srs_wkt (p, 9,
        "tor\",1.000018],PARAMETER[\"false_easting\",24500000],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"false_northing\",6200000],UNIT[\"US survey foo");
    add_srs_wkt (p, 11,
        "t\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS");
    add_srs_wkt (p, 12,
        "[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 13,
        "EPSG\",\"7070\"]]");
    p = add_epsg_def_ex (filter, first, last, 7072, "epsg", 7072,
        "RGTAAF07", 1, 1,
        "GRS 1980", "Greenwich",
        "Reseau_Geodesique_des_Terres_Australes_et_Antarctiques_Francaises_2007", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"RGTAAF07\",DATUM[\"Reseau Geodesique des Terre");
    add_srs_wkt (p, 1,
        "s Australes et Antarctiques Francaises 2007\",ELLIPSOID[");
    add_srs_wkt (p, 2,
        "\"GRS 1980\",6378137,298.257222101,LENGTHUNIT[\"metre\",");
    add_srs_wkt (p, 3,
        "1]]],PRIMEM[\"Greenwich\",0,ANGLEUNIT[\"degree\",0.01745");
    add_srs_wkt (p, 4,
        "32925199433]],CS[ellipsoidal,3],AXIS[\"geodetic latitude");
    add_srs_wkt (p, 5,
        " (Lat)\",north,ORDER[1],ANGLEUNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 6,
        "5199433]],AXIS[\"geodetic longitude (Lon)\",east,ORDER[2");
    add_srs_wkt (p, 7,
        "],ANGLEUNIT[\"degree\",0.0174532925199433]],AXIS[\"ellip");
    add_srs_wkt (p, 8,
        "soidal height (h)\",up,ORDER[3],LENGTHUNIT[\"metre\",1]]");
    add_srs_wkt (p, 9,
        ",USAGE[SCOPE[\"Geodesy; air, land and sea navigation and");
    add_srs_wkt (p, 10,
        " safety of life purposes.\"],AREA[\"French Southern Terr");
    add_srs_wkt (p, 11,
        "itories - onshore and offshore: Amsterdam and St Paul, C");
    add_srs_wkt (p, 12,
        "rozet, Europa and Kerguelen. Antarctica - Adelie Land co");
    add_srs_wkt (p, 13,
        "astal area.\"],BBOX[-67.13,37.98,-20.91,142]],ID[\"EPSG\"");
    add_srs_wkt (p, 14,
        ",7072]]");
    p = add_epsg_def_ex (filter, first, last, 7073, "epsg", 7073,
        "RGTAAF07", 1, 1,
        "GRS 1980", "Greenwich",
        "Reseau_Geodesique_des_Terres_Australes_et_Antarctiques_Francaises_2007", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"RGTAAF07\",DATUM[\"Reseau_Geodesique_des_Terres");
    add_srs_wkt (p, 1,
        "_Australes_et_Antarctiques_Francaises_2007\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 3,
        "19\"]],AUTHORITY[\"EPSG\",\"1113\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 4,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 5,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitud");
    add_srs_wkt (p, 6,
        "e\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "7073\"]]");
    p = add_epsg_def_ex (filter, first, last, 7074, "epsg", 7074,
        "RGTAAF07 / UTM zone 37S", 0, 0,
        "GRS 1980", "Greenwich",
        "Reseau_Geodesique_des_Terres_Australes_et_Antarctiques_Francaises_2007", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=37 +south +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"RGTAAF07 / UTM zone 37S\",GEOGCS[\"RGTAAF07\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"Reseau_Geodesique_des_Terres_Australes_et_Antarct");
    add_srs_wkt (p, 2,
        "iques_Francaises_2007\",SPHEROID[\"GRS 1980\",6378137,29");
    add_srs_wkt (p, 3,
        "8.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 4,
        "SG\",\"1113\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"7073\"]],PROJE");
    add_srs_wkt (p, 7,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 8,
        "rigin\",0],PARAMETER[\"central_meridian\",39],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"scale_factor\",0.9996],PARAMETER[\"false_easting\",500");
    add_srs_wkt (p, 10,
        "000],PARAMETER[\"false_northing\",10000000],UNIT[\"metre");
    add_srs_wkt (p, 11,
        "\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST");
    add_srs_wkt (p, 12,
        "],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"7074\"]]");
    p = add_epsg_def_ex (filter, first, last, 7075, "epsg", 7075,
        "RGTAAF07 / UTM zone 38S", 0, 0,
        "GRS 1980", "Greenwich",
        "Reseau_Geodesique_des_Terres_Australes_et_Antarctiques_Francaises_2007", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=38 +south +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"RGTAAF07 / UTM zone 38S\",GEOGCS[\"RGTAAF07\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"Reseau_Geodesique_des_Terres_Australes_et_Antarct");
    add_srs_wkt (p, 2,
        "iques_Francaises_2007\",SPHEROID[\"GRS 1980\",6378137,29");
    add_srs_wkt (p, 3,
        "8.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 4,
        "SG\",\"1113\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"7073\"]],PROJE");
    add_srs_wkt (p, 7,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 8,
        "rigin\",0],PARAMETER[\"central_meridian\",45],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"scale_factor\",0.9996],PARAMETER[\"false_easting\",500");
    add_srs_wkt (p, 10,
        "000],PARAMETER[\"false_northing\",10000000],UNIT[\"metre");
    add_srs_wkt (p, 11,
        "\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST");
    add_srs_wkt (p, 12,
        "],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"7075\"]]");
    p = add_epsg_def_ex (filter, first, last, 7076, "epsg", 7076,
        "RGTAAF07 / UTM zone 39S", 0, 0,
        "GRS 1980", "Greenwich",
        "Reseau_Geodesique_des_Terres_Australes_et_Antarctiques_Francaises_2007", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=39 +south +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"RGTAAF07 / UTM zone 39S\",GEOGCS[\"RGTAAF07\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"Reseau_Geodesique_des_Terres_Australes_et_Antarct");
    add_srs_wkt (p, 2,
        "iques_Francaises_2007\",SPHEROID[\"GRS 1980\",6378137,29");
    add_srs_wkt (p, 3,
        "8.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 4,
        "SG\",\"1113\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"7073\"]],PROJE");
    add_srs_wkt (p, 7,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 8,
        "rigin\",0],PARAMETER[\"central_meridian\",51],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"scale_factor\",0.9996],PARAMETER[\"false_easting\",500");
    add_srs_wkt (p, 10,
        "000],PARAMETER[\"false_northing\",10000000],UNIT[\"metre");
    add_srs_wkt (p, 11,
        "\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST");
    add_srs_wkt (p, 12,
        "],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"7076\"]]");
    p = add_epsg_def_ex (filter, first, last, 7077, "epsg", 7077,
        "RGTAAF07 / UTM zone 40S", 0, 0,
        "GRS 1980", "Greenwich",
        "Reseau_Geodesique_des_Terres_Australes_et_Antarctiques_Francaises_2007", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=40 +south +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"RGTAAF07 / UTM zone 40S\",GEOGCS[\"RGTAAF07\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"Reseau_Geodesique_des_Terres_Australes_et_Antarct");
    add_srs_wkt (p, 2,
        "iques_Francaises_2007\",SPHEROID[\"GRS 1980\",6378137,29");
    add_srs_wkt (p, 3,
        "8.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 4,
        "SG\",\"1113\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"7073\"]],PROJE");
    add_srs_wkt (p, 7,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 8,
        "rigin\",0],PARAMETER[\"central_meridian\",57],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"scale_factor\",0.9996],PARAMETER[\"false_easting\",500");
    add_srs_wkt (p, 10,
        "000],PARAMETER[\"false_northing\",10000000],UNIT[\"metre");
    add_srs_wkt (p, 11,
        "\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST");
    add_srs_wkt (p, 12,
        "],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"7077\"]]");
    p = add_epsg_def_ex (filter, first, last, 7078, "epsg", 7078,
        "RGTAAF07 / UTM zone 41S", 0, 0,
        "GRS 1980", "Greenwich",
        "Reseau_Geodesique_des_Terres_Australes_et_Antarctiques_Francaises_2007", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=41 +south +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"RGTAAF07 / UTM zone 41S\",GEOGCS[\"RGTAAF07\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"Reseau_Geodesique_des_Terres_Australes_et_Antarct");
    add_srs_wkt (p, 2,
        "iques_Francaises_2007\",SPHEROID[\"GRS 1980\",6378137,29");
    add_srs_wkt (p, 3,
        "8.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 4,
        "SG\",\"1113\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"7073\"]],PROJE");
    add_srs_wkt (p, 7,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 8,
        "rigin\",0],PARAMETER[\"central_meridian\",63],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"scale_factor\",0.9996],PARAMETER[\"false_easting\",500");
    add_srs_wkt (p, 10,
        "000],PARAMETER[\"false_northing\",10000000],UNIT[\"metre");
    add_srs_wkt (p, 11,
        "\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST");
    add_srs_wkt (p, 12,
        "],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"7078\"]]");
    p = add_epsg_def_ex (filter, first, last, 7079, "epsg", 7079,
        "RGTAAF07 / UTM zone 42S", 0, 0,
        "GRS 1980", "Greenwich",
        "Reseau_Geodesique_des_Terres_Australes_et_Antarctiques_Francaises_2007", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=42 +south +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"RGTAAF07 / UTM zone 42S\",GEOGCS[\"RGTAAF07\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"Reseau_Geodesique_des_Terres_Australes_et_Antarct");
    add_srs_wkt (p, 2,
        "iques_Francaises_2007\",SPHEROID[\"GRS 1980\",6378137,29");
    add_srs_wkt (p, 3,
        "8.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 4,
        "SG\",\"1113\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"7073\"]],PROJE");
    add_srs_wkt (p, 7,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 8,
        "rigin\",0],PARAMETER[\"central_meridian\",69],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"scale_factor\",0.9996],PARAMETER[\"false_easting\",500");
    add_srs_wkt (p, 10,
        "000],PARAMETER[\"false_northing\",10000000],UNIT[\"metre");
    add_srs_wkt (p, 11,
        "\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST");
    add_srs_wkt (p, 12,
        "],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"7079\"]]");
    p = add_epsg_def_ex (filter, first, last, 7080, "epsg", 7080,
        "RGTAAF07 / UTM zone 43S", 0, 0,
        "GRS 1980", "Greenwich",
        "Reseau_Geodesique_des_Terres_Australes_et_Antarctiques_Francaises_2007", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=43 +south +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"RGTAAF07 / UTM zone 43S\",GEOGCS[\"RGTAAF07\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"Reseau_Geodesique_des_Terres_Australes_et_Antarct");
    add_srs_wkt (p, 2,
        "iques_Francaises_2007\",SPHEROID[\"GRS 1980\",6378137,29");
    add_srs_wkt (p, 3,
        "8.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 4,
        "SG\",\"1113\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"7073\"]],PROJE");
    add_srs_wkt (p, 7,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 8,
        "rigin\",0],PARAMETER[\"central_meridian\",75],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"scale_factor\",0.9996],PARAMETER[\"false_easting\",500");
    add_srs_wkt (p, 10,
        "000],PARAMETER[\"false_northing\",10000000],UNIT[\"metre");
    add_srs_wkt (p, 11,
        "\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST");
    add_srs_wkt (p, 12,
        "],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"7080\"]]");
    p = add_epsg_def_ex (filter, first, last, 7081, "epsg", 7081,
        "RGTAAF07 / UTM zone 44S", 0, 0,
        "GRS 1980", "Greenwich",
        "Reseau_Geodesique_des_Terres_Australes_et_Antarctiques_Francaises_2007", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=44 +south +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"RGTAAF07 / UTM zone 44S\",GEOGCS[\"RGTAAF07\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"Reseau_Geodesique_des_Terres_Australes_et_Antarct");
    add_srs_wkt (p, 2,
        "iques_Francaises_2007\",SPHEROID[\"GRS 1980\",6378137,29");
    add_srs_wkt (p, 3,
        "8.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 4,
        "SG\",\"1113\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"7073\"]],PROJE");
    add_srs_wkt (p, 7,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 8,
        "rigin\",0],PARAMETER[\"central_meridian\",81],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"scale_factor\",0.9996],PARAMETER[\"false_easting\",500");
    add_srs_wkt (p, 10,
        "000],PARAMETER[\"false_northing\",10000000],UNIT[\"metre");
    add_srs_wkt (p, 11,
        "\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST");
    add_srs_wkt (p, 12,
        "],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"7081\"]]");
    p = add_epsg_def_ex (filter, first, last, 7084, "epsg", 7084,
        "RGF93 v1 (lon-lat)", 1, 0,
        "GRS 1980", "Greenwich",
        "Reseau_Geodesique_Francais_1993_v1", "none", "degree",
        "Geodetic longitude", "East", "Geodetic latitude", "North");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"RGF93 v1 (lon-lat)\",DATUM[\"Reseau_Geodesique_");
    add_srs_wkt (p, 1,
        "Francais_1993_v1\",SPHEROID[\"GRS 1980\",6378137,298.257");
    add_srs_wkt (p, 2,
        "222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 3,
        "\"6171\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8");
    add_srs_wkt (p, 4,
        "901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
        "PSG\",\"9122\"]],AXIS[\"Longitude\",EAST],AXIS[\"Latitud");
    add_srs_wkt (p, 6,
        "e\",NORTH],AUTHORITY[\"EPSG\",\"7084\"]]");
    p = add_epsg_def_ex (filter, first, last, 7085, "epsg", 7085,
        "RGAF09 (lon-lat)", 1, 0,
        "GRS 1980", "Greenwich",
        "Reseau_Geodesique_des_Antilles_Francaises_2009", "none", "degree",
        "Geodetic longitude", "East", "Geodetic latitude", "North");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"RGAF09 (lon-lat)\",DATUM[\"Reseau Geodesique d");
    add_srs_wkt (p, 1,
        "es Antilles Francaises 2009\",ELLIPSOID[\"GRS 1980\",637");
    add_srs_wkt (p, 2,
        "8137,298.257222101,LENGTHUNIT[\"metre\",1]]],PRIMEM[\"Gr");
    add_srs_wkt (p, 3,
        "eenwich\",0,ANGLEUNIT[\"degree\",0.0174532925199433]],CS");
    add_srs_wkt (p, 4,
        "[ellipsoidal,3],AXIS[\"geodetic longitude (Lon)\",east,O");
    add_srs_wkt (p, 5,
        "RDER[1],ANGLEUNIT[\"degree\",0.0174532925199433]],AXIS[\"");
    add_srs_wkt (p, 6,
        "geodetic latitude (Lat)\",north,ORDER[2],ANGLEUNIT[\"deg");
    add_srs_wkt (p, 7,
        "ree\",0.0174532925199433]],AXIS[\"ellipsoidal height (h)");
    add_srs_wkt (p, 8,
        "\",up,ORDER[3],LENGTHUNIT[\"metre\",1]],USAGE[SCOPE[\"GI");
    add_srs_wkt (p, 9,
        "S.\"],AREA[\"French Antilles onshore and offshore - Guad");
    add_srs_wkt (p, 10,
        "eloupe (including Grande Terre, Basse Terre, Marie Galan");
    add_srs_wkt (p, 11,
        "te, Les Saintes, Iles de la Petite Terre, La Desirade); ");
    add_srs_wkt (p, 12,
        "Martinique; St Barthélemy; St Martin.\"],BBOX[14.08,-63");
    add_srs_wkt (p, 13,
        ".66,18.53,-57.52]],ID[\"EPSG\",7085]]");
    p = add_epsg_def_ex (filter, first, last, 7086, "epsg", 7086,
        "RGAF09 (lon-lat)", 1, 0,
        "GRS 1980", "Greenwich",
        "Reseau_Geodesique_des_Antilles_Francaises_2009", "none", "degree",
        "Geodetic longitude", "East", "Geodetic latitude", "North");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"RGAF09 (lon-lat)\",DATUM[\"Reseau_Geodesique_de");
    add_srs_wkt (p, 1,
        "s_Antilles_Francaises_2009\",SPHEROID[\"GRS 1980\",63781");
    add_srs_wkt (p, 2,
        "37,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"1073\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"9122\"]],AXIS[\"Longitude\",EAST],AXIS");
    add_srs_wkt (p, 6,
        "[\"Latitude\",NORTH],AUTHORITY[\"EPSG\",\"7086\"]]");
    p = add_epsg_def_ex (filter, first, last, 7087, "epsg", 7087,
        "RGTAAF07 (lon-lat)", 1, 0,
        "GRS 1980", "Greenwich",
        "Reseau_Geodesique_des_Terres_Australes_et_Antarctiques_Francaises_2007", "none", "degree",
        "Geodetic longitude", "East", "Geodetic latitude", "North");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"RGTAAF07 (lon-lat)\",DATUM[\"Reseau Geodesique");
    add_srs_wkt (p, 1,
        " des Terres Australes et Antarctiques Francaises 2007\",");
    add_srs_wkt (p, 2,
        "ELLIPSOID[\"GRS 1980\",6378137,298.257222101,LENGTHUNIT[");
    add_srs_wkt (p, 3,
        "\"metre\",1]]],PRIMEM[\"Greenwich\",0,ANGLEUNIT[\"degree");
    add_srs_wkt (p, 4,
        "\",0.0174532925199433]],CS[ellipsoidal,3],AXIS[\"geodeti");
    add_srs_wkt (p, 5,
        "c longitude (Lon)\",east,ORDER[1],ANGLEUNIT[\"degree\",0");
    add_srs_wkt (p, 6,
        ".0174532925199433]],AXIS[\"geodetic latitude (Lat)\",nor");
    add_srs_wkt (p, 7,
        "th,ORDER[2],ANGLEUNIT[\"degree\",0.0174532925199433]],AX");
    add_srs_wkt (p, 8,
        "IS[\"ellipsoidal height (h)\",up,ORDER[3],LENGTHUNIT[\"m");
    add_srs_wkt (p, 9,
        "etre\",1]],USAGE[SCOPE[\"GIS.\"],AREA[\"French Southern ");
    add_srs_wkt (p, 10,
        "Territories - onshore and offshore: Amsterdam and St Pau");
    add_srs_wkt (p, 11,
        "l, Crozet, Europa and Kerguelen. Antarctica - Adelie Lan");
    add_srs_wkt (p, 12,
        "d coastal area.\"],BBOX[-67.13,37.98,-20.91,142]],ID[\"E");
    add_srs_wkt (p, 13,
        "PSG\",7087]]");
    p = add_epsg_def_ex (filter, first, last, 7088, "epsg", 7088,
        "RGTAAF07 (lon-lat) (deprecated)", 1, 0,
        "GRS 1980", "Greenwich",
        "Reseau_Geodesique_des_Terres_Australes_et_Antarctiques_Francaises_2007", "none", "degree",
        "Geodetic longitude", "East", "Geodetic latitude", "North");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"RGTAAF07 (lon-lat) (deprecated)\",DATUM[\"Resea");
    add_srs_wkt (p, 1,
        "u_Geodesique_des_Terres_Australes_et_Antarctiques_Franca");
    add_srs_wkt (p, 2,
        "ises_2007\",SPHEROID[\"GRS 1980\",6378137,298.257222101,");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1113\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AXIS[\"Longitude\",EAST],AXIS[\"Latitude\",NORT");
    add_srs_wkt (p, 7,
        "H],AUTHORITY[\"EPSG\",\"7088\"]]");
    p = add_epsg_def_ex (filter, first, last, 7109, "epsg", 7109,
        "NAD83(2011) / RMTCRS St Mary (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=48.5 +lon_0=-112.5 +k=1.00016 +x_0=15");
    add_proj4text (p, 1,
        "0000 +y_0=0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / RMTCRS St Mary (m)\",GEOGCS[\"NAD");
    add_srs_wkt (p, 1,
        "83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Syst");
    add_srs_wkt (p, 2,
        "em_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Trans");
    add_srs_wkt (p, 7,
        "verse_Mercator\"],PARAMETER[\"latitude_of_origin\",48.5]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"central_meridian\",-112.5],PARAMETER[\"scal");
    add_srs_wkt (p, 9,
        "e_factor\",1.00016],PARAMETER[\"false_easting\",150000],");
    add_srs_wkt (p, 10,
        "PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 11,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Nor");
    add_srs_wkt (p, 12,
        "thing\",NORTH],AUTHORITY[\"EPSG\",\"7109\"]]");
    p = add_epsg_def_ex (filter, first, last, 7110, "epsg", 7110,
        "NAD83(2011) / RMTCRS Blackfeet (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=48 +lon_0=-112.5 +k=1.00019 +x_0=1000");
    add_proj4text (p, 1,
        "00 +y_0=0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / RMTCRS Blackfeet (m)\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
        "AD83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Sy");
    add_srs_wkt (p, 2,
        "stem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",48],");
    add_srs_wkt (p, 8,
        "PARAMETER[\"central_meridian\",-112.5],PARAMETER[\"scale");
    add_srs_wkt (p, 9,
        "_factor\",1.00019],PARAMETER[\"false_easting\",100000],P");
    add_srs_wkt (p, 10,
        "ARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 11,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Nort");
    add_srs_wkt (p, 12,
        "hing\",NORTH],AUTHORITY[\"EPSG\",\"7110\"]]");
    p = add_epsg_def_ex (filter, first, last, 7111, "epsg", 7111,
        "NAD83(2011) / RMTCRS Milk River (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=48.5 +lat_0=48.5 +lon_0=-111 +k_0=1.000");
    add_proj4text (p, 1,
        "145 +x_0=150000 +y_0=200000 +ellps=GRS80 +units=m +no_de");
    add_proj4text (p, 2,
        "fs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / RMTCRS Milk River (m)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_S");
    add_srs_wkt (p, 2,
        "ystem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116");
    add_srs_wkt (p, 4,
        "\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]");
    add_srs_wkt (p, 5,
        "],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"La");
    add_srs_wkt (p, 7,
        "mbert_Conformal_Conic_1SP\"],PARAMETER[\"latitude_of_ori");
    add_srs_wkt (p, 8,
        "gin\",48.5],PARAMETER[\"central_meridian\",-111],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"scale_factor\",1.000145],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 10,
        ",150000],PARAMETER[\"false_northing\",200000],UNIT[\"met");
    add_srs_wkt (p, 11,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EA");
    add_srs_wkt (p, 12,
        "ST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"7111\"");
    add_srs_wkt (p, 13,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 7112, "epsg", 7112,
        "NAD83(2011) / RMTCRS Fort Belknap (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=48.5 +lat_0=48.5 +lon_0=-108.5 +k_0=1.0");
    add_proj4text (p, 1,
        "0012 +x_0=200000 +y_0=150000 +ellps=GRS80 +units=m +no_d");
    add_proj4text (p, 2,
        "efs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / RMTCRS Fort Belknap (m)\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Reference");
    add_srs_wkt (p, 2,
        "_System_2011\",SPHEROID[\"GRS 1980\",6378137,298.2572221");
    add_srs_wkt (p, 3,
        "01,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"11");
    add_srs_wkt (p, 4,
        "16\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"L");
    add_srs_wkt (p, 7,
        "ambert_Conformal_Conic_1SP\"],PARAMETER[\"latitude_of_or");
    add_srs_wkt (p, 8,
        "igin\",48.5],PARAMETER[\"central_meridian\",-108.5],PARA");
    add_srs_wkt (p, 9,
        "METER[\"scale_factor\",1.00012],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 10,
        "g\",200000],PARAMETER[\"false_northing\",150000],UNIT[\"");
    add_srs_wkt (p, 11,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 12,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"711");
    add_srs_wkt (p, 13,
        "2\"]]");
    p = add_epsg_def_ex (filter, first, last, 7113, "epsg", 7113,
        "NAD83(2011) / RMTCRS Fort Peck Assiniboine (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=48.33333333333334 +lat_0=48.33333333333");
    add_proj4text (p, 1,
        "334 +lon_0=-105.5 +k_0=1.00012 +x_0=200000 +y_0=100000 +");
    add_proj4text (p, 2,
        "ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / RMTCRS Fort Peck Assiniboine (m)\"");
    add_srs_wkt (p, 1,
        ",GEOGCS[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_R");
    add_srs_wkt (p, 2,
        "eference_System_2011\",SPHEROID[\"GRS 1980\",6378137,298");
    add_srs_wkt (p, 3,
        ".257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJE");
    add_srs_wkt (p, 7,
        "CTION[\"Lambert_Conformal_Conic_1SP\"],PARAMETER[\"latit");
    add_srs_wkt (p, 8,
        "ude_of_origin\",48.3333333333333],PARAMETER[\"central_me");
    add_srs_wkt (p, 9,
        "ridian\",-105.5],PARAMETER[\"scale_factor\",1.00012],PAR");
    add_srs_wkt (p, 10,
        "AMETER[\"false_easting\",200000],PARAMETER[\"false_north");
    add_srs_wkt (p, 11,
        "ing\",100000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 12,
        "\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUT");
    add_srs_wkt (p, 13,
        "HORITY[\"EPSG\",\"7113\"]]");
    p = add_epsg_def_ex (filter, first, last, 7114, "epsg", 7114,
        "NAD83(2011) / RMTCRS Fort Peck Sioux (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=48.33333333333334 +lat_0=48.33333333333");
    add_proj4text (p, 1,
        "334 +lon_0=-105.5 +k_0=1.00009 +x_0=100000 +y_0=50000 +e");
    add_proj4text (p, 2,
        "llps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / RMTCRS Fort Peck Sioux (m)\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Refere");
    add_srs_wkt (p, 2,
        "nce_System_2011\",SPHEROID[\"GRS 1980\",6378137,298.2572");
    add_srs_wkt (p, 3,
        "22101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Lambert_Conformal_Conic_1SP\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 8,
        "_origin\",48.3333333333333],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 9,
        "\",-105.5],PARAMETER[\"scale_factor\",1.00009],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"false_easting\",100000],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 11,
        "50000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AX");
    add_srs_wkt (p, 12,
        "IS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[");
    add_srs_wkt (p, 13,
        "\"EPSG\",\"7114\"]]");
    p = add_epsg_def_ex (filter, first, last, 7115, "epsg", 7115,
        "NAD83(2011) / RMTCRS Crow (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=44.75 +lon_0=-107.75 +k=1.000148 +x_0");
    add_proj4text (p, 1,
        "=200000 +y_0=0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / RMTCRS Crow (m)\",GEOGCS[\"NAD83(");
    add_srs_wkt (p, 1,
        "2011)\",DATUM[\"NAD83_National_Spatial_Reference_System_");
    add_srs_wkt (p, 2,
        "2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHO");
    add_srs_wkt (p, 3,
        "RITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],P");
    add_srs_wkt (p, 4,
        "RIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT");
    add_srs_wkt (p, 5,
        "[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122");
    add_srs_wkt (p, 6,
        "\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transver");
    add_srs_wkt (p, 7,
        "se_Mercator\"],PARAMETER[\"latitude_of_origin\",44.75],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"central_meridian\",-107.75],PARAMETER[\"scale");
    add_srs_wkt (p, 9,
        "_factor\",1.000148],PARAMETER[\"false_easting\",200000],");
    add_srs_wkt (p, 10,
        "PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 11,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Nor");
    add_srs_wkt (p, 12,
        "thing\",NORTH],AUTHORITY[\"EPSG\",\"7115\"]]");
    p = add_epsg_def_ex (filter, first, last, 7116, "epsg", 7116,
        "NAD83(2011) / RMTCRS Bobcat (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=46.25 +lat_0=46.25 +lon_0=-111.25 +k_0=");
    add_proj4text (p, 1,
        "1.000185 +x_0=100000 +y_0=100000 +ellps=GRS80 +units=m +");
    add_proj4text (p, 2,
        "no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / RMTCRS Bobcat (m)\",GEOGCS[\"NAD8");
    add_srs_wkt (p, 1,
        "3(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Syste");
    add_srs_wkt (p, 2,
        "m_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]]");
    add_srs_wkt (p, 4,
        ",PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UN");
    add_srs_wkt (p, 5,
        "IT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"91");
    add_srs_wkt (p, 6,
        "22\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lamber");
    add_srs_wkt (p, 7,
        "t_Conformal_Conic_1SP\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",46.25],PARAMETER[\"central_meridian\",-111.25],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"scale_factor\",1.000185],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 10,
        ",100000],PARAMETER[\"false_northing\",100000],UNIT[\"met");
    add_srs_wkt (p, 11,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EA");
    add_srs_wkt (p, 12,
        "ST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"7116\"");
    add_srs_wkt (p, 13,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 7117, "epsg", 7117,
        "NAD83(2011) / RMTCRS Billings (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=45.78333333333333 +lat_0=45.78333333333");
    add_proj4text (p, 1,
        "333 +lon_0=-108.4166666666667 +k_0=1.0001515 +x_0=200000");
    add_proj4text (p, 2,
        " +y_0=50000 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / RMTCRS Billings (m)\",GEOGCS[\"NA");
    add_srs_wkt (p, 1,
        "D83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Sys");
    add_srs_wkt (p, 2,
        "tem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lamb");
    add_srs_wkt (p, 7,
        "ert_Conformal_Conic_1SP\"],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 8,
        "n\",45.7833333333333],PARAMETER[\"central_meridian\",-10");
    add_srs_wkt (p, 9,
        "8.416666666667],PARAMETER[\"scale_factor\",1.0001515],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"false_easting\",200000],PARAMETER[\"false_nort");
    add_srs_wkt (p, 11,
        "hing\",50000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 12,
        "\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUT");
    add_srs_wkt (p, 13,
        "HORITY[\"EPSG\",\"7117\"]]");
    p = add_epsg_def_ex (filter, first, last, 7118, "epsg", 7118,
        "NAD83(2011) / RMTCRS Wind River (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=42.66666666666666 +lon_0=-108.3333333");
    add_proj4text (p, 1,
        "333333 +k=1.00024 +x_0=100000 +y_0=0 +ellps=GRS80 +units");
    add_proj4text (p, 2,
        "=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / RMTCRS Wind River (m)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_S");
    add_srs_wkt (p, 2,
        "ystem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116");
    add_srs_wkt (p, 4,
        "\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]");
    add_srs_wkt (p, 5,
        "],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Tr");
    add_srs_wkt (p, 7,
        "ansverse_Mercator\"],PARAMETER[\"latitude_of_origin\",42");
    add_srs_wkt (p, 8,
        ".6666666666667],PARAMETER[\"central_meridian\",-108.3333");
    add_srs_wkt (p, 9,
        "33333333],PARAMETER[\"scale_factor\",1.00024],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"false_easting\",100000],PARAMETER[\"false_northing\",0");
    add_srs_wkt (p, 11,
        "],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 12,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 13,
        "G\",\"7118\"]]");
    p = add_epsg_def_ex (filter, first, last, 7119, "epsg", 7119,
        "NAD83(2011) / RMTCRS St Mary (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=48.5 +lon_0=-112.5 +k=1.00016 +x_0=15");
    add_proj4text (p, 1,
        "0000.00001464 +y_0=0 +ellps=GRS80 +units=ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / RMTCRS St Mary (ft)\",GEOGCS[\"NA");
    add_srs_wkt (p, 1,
        "D83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Sys");
    add_srs_wkt (p, 2,
        "tem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",48.5");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"central_meridian\",-112.5],PARAMETER[\"sca");
    add_srs_wkt (p, 9,
        "le_factor\",1.00016],PARAMETER[\"false_easting\",492125.");
    add_srs_wkt (p, 10,
        "9843],PARAMETER[\"false_northing\",0],UNIT[\"foot\",0.30");
    add_srs_wkt (p, 11,
        "48,AUTHORITY[\"EPSG\",\"9002\"]],AXIS[\"Easting\",EAST],");
    add_srs_wkt (p, 12,
        "AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"7119\"]]");
    p = add_epsg_def_ex (filter, first, last, 7120, "epsg", 7120,
        "NAD83(2011) / RMTCRS Blackfeet (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=48 +lon_0=-112.5 +k=1.00019 +x_0=9999");
    add_proj4text (p, 1,
        "9.99999960001 +y_0=0 +ellps=GRS80 +units=ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / RMTCRS Blackfeet (ft)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_S");
    add_srs_wkt (p, 2,
        "ystem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116");
    add_srs_wkt (p, 4,
        "\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]");
    add_srs_wkt (p, 5,
        "],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Tr");
    add_srs_wkt (p, 7,
        "ansverse_Mercator\"],PARAMETER[\"latitude_of_origin\",48");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"central_meridian\",-112.5],PARAMETER[\"sca");
    add_srs_wkt (p, 9,
        "le_factor\",1.00019],PARAMETER[\"false_easting\",328083.");
    add_srs_wkt (p, 10,
        "9895],PARAMETER[\"false_northing\",0],UNIT[\"foot\",0.30");
    add_srs_wkt (p, 11,
        "48,AUTHORITY[\"EPSG\",\"9002\"]],AXIS[\"Easting\",EAST],");
    add_srs_wkt (p, 12,
        "AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"7120\"]]");
    p = add_epsg_def_ex (filter, first, last, 7121, "epsg", 7121,
        "NAD83(2011) / RMTCRS Milk River (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=48.5 +lat_0=48.5 +lon_0=-111 +k_0=1.000");
    add_proj4text (p, 1,
        "145 +x_0=150000.00001464 +y_0=199999.9999992 +ellps=GRS8");
    add_proj4text (p, 2,
        "0 +units=ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / RMTCRS Milk River (ft)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_S");
    add_srs_wkt (p, 2,
        "ystem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116");
    add_srs_wkt (p, 4,
        "\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]");
    add_srs_wkt (p, 5,
        "],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"La");
    add_srs_wkt (p, 7,
        "mbert_Conformal_Conic_1SP\"],PARAMETER[\"latitude_of_ori");
    add_srs_wkt (p, 8,
        "gin\",48.5],PARAMETER[\"central_meridian\",-111],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"scale_factor\",1.000145],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 10,
        ",492125.9843],PARAMETER[\"false_northing\",656167.979],U");
    add_srs_wkt (p, 11,
        "NIT[\"foot\",0.3048,AUTHORITY[\"EPSG\",\"9002\"]],AXIS[\"");
    add_srs_wkt (p, 12,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 13,
        "G\",\"7121\"]]");
    p = add_epsg_def_ex (filter, first, last, 7122, "epsg", 7122,
        "NAD83(2011) / RMTCRS Fort Belknap (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=48.5 +lat_0=48.5 +lon_0=-108.5 +k_0=1.0");
    add_proj4text (p, 1,
        "0012 +x_0=199999.9999992 +y_0=150000.00001464 +ellps=GRS");
    add_proj4text (p, 2,
        "80 +units=ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / RMTCRS Fort Belknap (ft)\",GEOGCS");
    add_srs_wkt (p, 1,
        "[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Referenc");
    add_srs_wkt (p, 2,
        "e_System_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222");
    add_srs_wkt (p, 3,
        "101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1");
    add_srs_wkt (p, 4,
        "116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 5,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 6,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"");
    add_srs_wkt (p, 7,
        "Lambert_Conformal_Conic_1SP\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 8,
        "rigin\",48.5],PARAMETER[\"central_meridian\",-108.5],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"scale_factor\",1.00012],PARAMETER[\"false_easti");
    add_srs_wkt (p, 10,
        "ng\",656167.979],PARAMETER[\"false_northing\",492125.984");
    add_srs_wkt (p, 11,
        "3],UNIT[\"foot\",0.3048,AUTHORITY[\"EPSG\",\"9002\"]],AX");
    add_srs_wkt (p, 12,
        "IS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[");
    add_srs_wkt (p, 13,
        "\"EPSG\",\"7122\"]]");
    p = add_epsg_def_ex (filter, first, last, 7123, "epsg", 7123,
        "NAD83(2011) / RMTCRS Fort Peck Assiniboine (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=48.33333333333334 +lat_0=48.33333333333");
    add_proj4text (p, 1,
        "334 +lon_0=-105.5 +k_0=1.00012 +x_0=199999.9999992 +y_0=");
    add_proj4text (p, 2,
        "99999.99999960001 +ellps=GRS80 +units=ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / RMTCRS Fort Peck Assiniboine (ft)");
    add_srs_wkt (p, 1,
        "\",GEOGCS[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial");
    add_srs_wkt (p, 2,
        "_Reference_System_2011\",SPHEROID[\"GRS 1980\",6378137,2");
    add_srs_wkt (p, 3,
        "98.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PRO");
    add_srs_wkt (p, 7,
        "JECTION[\"Lambert_Conformal_Conic_1SP\"],PARAMETER[\"lat");
    add_srs_wkt (p, 8,
        "itude_of_origin\",48.3333333333333],PARAMETER[\"central_");
    add_srs_wkt (p, 9,
        "meridian\",-105.5],PARAMETER[\"scale_factor\",1.00012],P");
    add_srs_wkt (p, 10,
        "ARAMETER[\"false_easting\",656167.979],PARAMETER[\"false");
    add_srs_wkt (p, 11,
        "_northing\",328083.9895],UNIT[\"foot\",0.3048,AUTHORITY[");
    add_srs_wkt (p, 12,
        "\"EPSG\",\"9002\"]],AXIS[\"Easting\",EAST],AXIS[\"Northi");
    add_srs_wkt (p, 13,
        "ng\",NORTH],AUTHORITY[\"EPSG\",\"7123\"]]");
    p = add_epsg_def_ex (filter, first, last, 7124, "epsg", 7124,
        "NAD83(2011) / RMTCRS Fort Peck Sioux (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=48.33333333333334 +lat_0=48.33333333333");
    add_proj4text (p, 1,
        "334 +lon_0=-105.5 +k_0=1.00009 +x_0=99999.99999960001 +y");
    add_proj4text (p, 2,
        "_0=49999.99971024 +ellps=GRS80 +units=ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / RMTCRS Fort Peck Sioux (ft)\",GEO");
    add_srs_wkt (p, 1,
        "GCS[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Refer");
    add_srs_wkt (p, 2,
        "ence_System_2011\",SPHEROID[\"GRS 1980\",6378137,298.257");
    add_srs_wkt (p, 3,
        "222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 4,
        "\"1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8");
    add_srs_wkt (p, 5,
        "901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"E");
    add_srs_wkt (p, 6,
        "PSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTIO");
    add_srs_wkt (p, 7,
        "N[\"Lambert_Conformal_Conic_1SP\"],PARAMETER[\"latitude_");
    add_srs_wkt (p, 8,
        "of_origin\",48.3333333333333],PARAMETER[\"central_meridi");
    add_srs_wkt (p, 9,
        "an\",-105.5],PARAMETER[\"scale_factor\",1.00009],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_easting\",328083.9895],PARAMETER[\"false_nort");
    add_srs_wkt (p, 11,
        "hing\",164041.9938],UNIT[\"foot\",0.3048,AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"9002\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",");
    add_srs_wkt (p, 13,
        "NORTH],AUTHORITY[\"EPSG\",\"7124\"]]");
    p = add_epsg_def_ex (filter, first, last, 7125, "epsg", 7125,
        "NAD83(2011) / RMTCRS Crow (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=44.75 +lon_0=-107.75 +k=1.000148 +x_0");
    add_proj4text (p, 1,
        "=199999.9999992 +y_0=0 +ellps=GRS80 +units=ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / RMTCRS Crow (ft)\",GEOGCS[\"NAD83");
    add_srs_wkt (p, 1,
        "(2011)\",DATUM[\"NAD83_National_Spatial_Reference_System");
    add_srs_wkt (p, 2,
        "_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 7,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",44.75],");
    add_srs_wkt (p, 8,
        "PARAMETER[\"central_meridian\",-107.75],PARAMETER[\"scal");
    add_srs_wkt (p, 9,
        "e_factor\",1.000148],PARAMETER[\"false_easting\",656167.");
    add_srs_wkt (p, 10,
        "979],PARAMETER[\"false_northing\",0],UNIT[\"foot\",0.304");
    add_srs_wkt (p, 11,
        "8,AUTHORITY[\"EPSG\",\"9002\"]],AXIS[\"Easting\",EAST],A");
    add_srs_wkt (p, 12,
        "XIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"7125\"]]");
    p = add_epsg_def_ex (filter, first, last, 7126, "epsg", 7126,
        "NAD83(2011) / RMTCRS Bobcat (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=46.25 +lat_0=46.25 +lon_0=-111.25 +k_0=");
    add_proj4text (p, 1,
        "1.000185 +x_0=99999.99999960001 +y_0=99999.99999960001 +");
    add_proj4text (p, 2,
        "ellps=GRS80 +units=ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / RMTCRS Bobcat (ft)\",GEOGCS[\"NAD");
    add_srs_wkt (p, 1,
        "83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Syst");
    add_srs_wkt (p, 2,
        "em_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lambe");
    add_srs_wkt (p, 7,
        "rt_Conformal_Conic_1SP\"],PARAMETER[\"latitude_of_origin");
    add_srs_wkt (p, 8,
        "\",46.25],PARAMETER[\"central_meridian\",-111.25],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"scale_factor\",1.000185],PARAMETER[\"false_easting");
    add_srs_wkt (p, 10,
        "\",328083.9895],PARAMETER[\"false_northing\",328083.9895");
    add_srs_wkt (p, 11,
        "],UNIT[\"foot\",0.3048,AUTHORITY[\"EPSG\",\"9002\"]],AXI");
    add_srs_wkt (p, 12,
        "S[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 13,
        "EPSG\",\"7126\"]]");
    p = add_epsg_def_ex (filter, first, last, 7127, "epsg", 7127,
        "NAD83(2011) / RMTCRS Billings (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=45.78333333333333 +lat_0=45.78333333333");
    add_proj4text (p, 1,
        "333 +lon_0=-108.4166666666667 +k_0=1.0001515 +x_0=199999");
    add_proj4text (p, 2,
        ".9999992 +y_0=50000.00001504 +ellps=GRS80 +units=ft +no_");
    add_proj4text (p, 3,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / RMTCRS Billings (ft)\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
        "AD83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Sy");
    add_srs_wkt (p, 2,
        "stem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lamb");
    add_srs_wkt (p, 7,
        "ert_Conformal_Conic_1SP\"],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 8,
        "n\",45.7833333333333],PARAMETER[\"central_meridian\",-10");
    add_srs_wkt (p, 9,
        "8.416666666667],PARAMETER[\"scale_factor\",1.0001515],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"false_easting\",656167.979],PARAMETER[\"false_");
    add_srs_wkt (p, 11,
        "northing\",164041.9948],UNIT[\"foot\",0.3048,AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"9002\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing");
    add_srs_wkt (p, 13,
        "\",NORTH],AUTHORITY[\"EPSG\",\"7127\"]]");
    p = add_epsg_def_ex (filter, first, last, 7128, "epsg", 7128,
        "NAD83(2011) / RMTCRS Wind River (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=42.66666666666666 +lon_0=-108.3333333");
    add_proj4text (p, 1,
        "333333 +k=1.00024 +x_0=99999.99998983997 +y_0=0 +ellps=G");
    add_proj4text (p, 2,
        "RS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / RMTCRS Wind River (ftUS)\",GEOGCS");
    add_srs_wkt (p, 1,
        "[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Referenc");
    add_srs_wkt (p, 2,
        "e_System_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222");
    add_srs_wkt (p, 3,
        "101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1");
    add_srs_wkt (p, 4,
        "116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 5,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 6,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"");
    add_srs_wkt (p, 7,
        "Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\",");
    add_srs_wkt (p, 8,
        "42.6666666666667],PARAMETER[\"central_meridian\",-108.33");
    add_srs_wkt (p, 9,
        "3333333333],PARAMETER[\"scale_factor\",1.00024],PARAMETE");
    add_srs_wkt (p, 10,
        "R[\"false_easting\",328083.3333],PARAMETER[\"false_north");
    add_srs_wkt (p, 11,
        "ing\",0],UNIT[\"US survey foot\",0.304800609601219,AUTHO");
    add_srs_wkt (p, 12,
        "RITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"N");
    add_srs_wkt (p, 13,
        "orthing\",NORTH],AUTHORITY[\"EPSG\",\"7128\"]]");
    p = add_epsg_def_ex (filter, first, last, 7131, "epsg", 7131,
        "NAD83(2011) / San Francisco CS13", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=37.75 +lon_0=-122.45 +k=1.000007 +x_0");
    add_proj4text (p, 1,
        "=48000 +y_0=24000 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / San Francisco CS13\",GEOGCS[\"NAD");
    add_srs_wkt (p, 1,
        "83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Syst");
    add_srs_wkt (p, 2,
        "em_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Trans");
    add_srs_wkt (p, 7,
        "verse_Mercator\"],PARAMETER[\"latitude_of_origin\",37.75");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"central_meridian\",-122.45],PARAMETER[\"sc");
    add_srs_wkt (p, 9,
        "ale_factor\",1.000007],PARAMETER[\"false_easting\",48000");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_northing\",24000],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 11,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS");
    add_srs_wkt (p, 12,
        "[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"7131\"]]");
    p = add_epsg_def_ex (filter, first, last, 7132, "epsg", 7132,
        "NAD83(2011) / San Francisco CS13 (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=37.75 +lon_0=-122.45 +k=1.000007 +x_0");
    add_proj4text (p, 1,
        "=48000 +y_0=24000 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / San Francisco CS13 (ftUS)\",GEOGC");
    add_srs_wkt (p, 1,
        "S[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Referen");
    add_srs_wkt (p, 2,
        "ce_System_2011\",SPHEROID[\"GRS 1980\",6378137,298.25722");
    add_srs_wkt (p, 3,
        "2101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",37.75],PARAMETER[\"central_meridian\",-122.45],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"scale_factor\",1.000007],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 10,
        ",157480],PARAMETER[\"false_northing\",78740],UNIT[\"US s");
    add_srs_wkt (p, 11,
        "urvey foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003");
    add_srs_wkt (p, 12,
        "\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUT");
    add_srs_wkt (p, 13,
        "HORITY[\"EPSG\",\"7132\"]]");
    p = add_epsg_def_ex (filter, first, last, 7133, "epsg", 7133,
        "RGTAAF07 (lon-lat)", 1, 0,
        "GRS 1980", "Greenwich",
        "Reseau_Geodesique_des_Terres_Australes_et_Antarctiques_Francaises_2007", "none", "degree",
        "Geodetic longitude", "East", "Geodetic latitude", "North");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"RGTAAF07 (lon-lat)\",DATUM[\"Reseau_Geodesique_");
    add_srs_wkt (p, 1,
        "des_Terres_Australes_et_Antarctiques_Francaises_2007\",S");
    add_srs_wkt (p, 2,
        "PHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"E");
    add_srs_wkt (p, 3,
        "PSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1113\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXI");
    add_srs_wkt (p, 6,
        "S[\"Longitude\",EAST],AXIS[\"Latitude\",NORTH],AUTHORITY");
    add_srs_wkt (p, 7,
        "[\"EPSG\",\"7133\"]]");
    p = add_epsg_def_ex (filter, first, last, 7135, "epsg", 7135,
        "IGD05", 1, 1,
        "WGS 84", "Greenwich",
        "Israeli_Geodetic_Datum_2005", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=WGS84 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"IGD05\",DATUM[\"Israeli Geodetic Datum 2005\",");
    add_srs_wkt (p, 1,
        "ELLIPSOID[\"WGS 84\",6378137,298.257223563,LENGTHUNIT[\"");
    add_srs_wkt (p, 2,
        "metre\",1]]],PRIMEM[\"Greenwich\",0,ANGLEUNIT[\"degree\"");
    add_srs_wkt (p, 3,
        ",0.0174532925199433]],CS[ellipsoidal,3],AXIS[\"geodetic ");
    add_srs_wkt (p, 4,
        "latitude (Lat)\",north,ORDER[1],ANGLEUNIT[\"degree\",0.0");
    add_srs_wkt (p, 5,
        "174532925199433]],AXIS[\"geodetic longitude (Lon)\",east");
    add_srs_wkt (p, 6,
        ",ORDER[2],ANGLEUNIT[\"degree\",0.0174532925199433]],AXIS");
    add_srs_wkt (p, 7,
        "[\"ellipsoidal height (h)\",up,ORDER[3],LENGTHUNIT[\"met");
    add_srs_wkt (p, 8,
        "re\",1]],USAGE[SCOPE[\"Geodesy.\"],AREA[\"Israel - onsho");
    add_srs_wkt (p, 9,
        "re and offshore.\"],BBOX[29.45,32.99,33.53,35.69]],ID[\"");
    add_srs_wkt (p, 10,
        "EPSG\",7135]]");
    p = add_epsg_def_ex (filter, first, last, 7136, "epsg", 7136,
        "IGD05", 1, 1,
        "WGS 84", "Greenwich",
        "Israeli_Geodetic_Datum_2005", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=WGS84 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"IGD05\",DATUM[\"Israeli_Geodetic_Datum_2005\",S");
    add_srs_wkt (p, 1,
        "PHEROID[\"WGS 84\",6378137,298.257223563,AUTHORITY[\"EPS");
    add_srs_wkt (p, 2,
        "G\",\"7030\"]],AUTHORITY[\"EPSG\",\"1114\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 3,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 4,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 5,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 6,
        "PSG\",\"7136\"]]");
    p = add_epsg_def_ex (filter, first, last, 7138, "epsg", 7138,
        "IGD05/12", 1, 1,
        "WGS 84", "Greenwich",
        "Israeli_Geodetic_Datum_2005_2012", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=WGS84 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"IGD05/12\",DATUM[\"Israeli Geodetic Datum 2005");
    add_srs_wkt (p, 1,
        "(2012)\",ELLIPSOID[\"WGS 84\",6378137,298.257223563,LENG");
    add_srs_wkt (p, 2,
        "THUNIT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,ANGLEUNIT[\"");
    add_srs_wkt (p, 3,
        "degree\",0.0174532925199433]],CS[ellipsoidal,3],AXIS[\"g");
    add_srs_wkt (p, 4,
        "eodetic latitude (Lat)\",north,ORDER[1],ANGLEUNIT[\"degr");
    add_srs_wkt (p, 5,
        "ee\",0.0174532925199433]],AXIS[\"geodetic longitude (Lon");
    add_srs_wkt (p, 6,
        ")\",east,ORDER[2],ANGLEUNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 7,
        "3]],AXIS[\"ellipsoidal height (h)\",up,ORDER[3],LENGTHUN");
    add_srs_wkt (p, 8,
        "IT[\"metre\",1]],USAGE[SCOPE[\"Geodesy.\"],AREA[\"Israel");
    add_srs_wkt (p, 9,
        " - onshore and offshore.\"],BBOX[29.45,32.99,33.53,35.69");
    add_srs_wkt (p, 10,
        "]],ID[\"EPSG\",7138]]");
    p = add_epsg_def_ex (filter, first, last, 7139, "epsg", 7139,
        "IGD05/12", 1, 1,
        "WGS 84", "Greenwich",
        "Israeli_Geodetic_Datum_2005_2012", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=WGS84 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"IGD05/12\",DATUM[\"Israeli_Geodetic_Datum_2005_");
    add_srs_wkt (p, 1,
        "2012\",SPHEROID[\"WGS 84\",6378137,298.257223563,AUTHORI");
    add_srs_wkt (p, 2,
        "TY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"1115\"]],PRI");
    add_srs_wkt (p, 3,
        "MEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 4,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 5,
        "],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"7139\"]]");
    p = add_epsg_def_ex (filter, first, last, 7142, "epsg", 7142,
        "Palestine 1923 / Palestine Grid modified", 0, 0,
        "Clarke 1880 (Benoit)", "Greenwich",
        "Palestine_1923", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=31.73409694444445 +lon_0=35.212080555");
    add_proj4text (p, 1,
        "55556 +k=1 +x_0=170251.555 +y_0=126867.909 +a=6378300.78");
    add_proj4text (p, 2,
        "9 +b=6356566.435 +towgs84=-275.7224,94.7824,340.8944,-8.");
    add_proj4text (p, 3,
        "001,-4.42,-11.821,1 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Palestine 1923 / Palestine Grid modified\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"Palestine 1923\",DATUM[\"Palestine_1923\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Clarke 1880 (Benoit)\",6378300.789,293.466315538981,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"7010\"]],AUTHORITY[\"EPSG\",\"6281\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AUTHORITY[\"EPSG\",\"4281\"]],PROJECTION[\"Trans");
    add_srs_wkt (p, 7,
        "verse_Mercator\"],PARAMETER[\"latitude_of_origin\",31.73");
    add_srs_wkt (p, 8,
        "40969444444],PARAMETER[\"central_meridian\",35.212080555");
    add_srs_wkt (p, 9,
        "5556],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_ea");
    add_srs_wkt (p, 10,
        "sting\",170251.555],PARAMETER[\"false_northing\",126867.");
    add_srs_wkt (p, 11,
        "909],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS");
    add_srs_wkt (p, 12,
        "[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 13,
        "EPSG\",\"7142\"]]");
    p = add_epsg_def_ex (filter, first, last, 7257, "epsg", 7257,
        "NAD83(2011) / InGCS Adams (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=40.55 +lon_0=-84.95 +k=1.000034 +x_0=");
    add_proj4text (p, 1,
        "240000 +y_0=36000 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / InGCS Adams (m)\",GEOGCS[\"NAD83(");
    add_srs_wkt (p, 1,
        "2011)\",DATUM[\"NAD83_National_Spatial_Reference_System_");
    add_srs_wkt (p, 2,
        "2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHO");
    add_srs_wkt (p, 3,
        "RITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],P");
    add_srs_wkt (p, 4,
        "RIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT");
    add_srs_wkt (p, 5,
        "[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122");
    add_srs_wkt (p, 6,
        "\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transver");
    add_srs_wkt (p, 7,
        "se_Mercator\"],PARAMETER[\"latitude_of_origin\",40.55],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"central_meridian\",-84.95],PARAMETER[\"scale_");
    add_srs_wkt (p, 9,
        "factor\",1.000034],PARAMETER[\"false_easting\",240000],P");
    add_srs_wkt (p, 10,
        "ARAMETER[\"false_northing\",36000],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 11,
        "ORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 12,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"7257\"]]");
    p = add_epsg_def_ex (filter, first, last, 7258, "epsg", 7258,
        "NAD83(2011) / InGCS Adams (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=40.55 +lon_0=-84.95 +k=1.000034 +x_0=");
    add_proj4text (p, 1,
        "240000 +y_0=36000 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / InGCS Adams (ftUS)\",GEOGCS[\"NAD");
    add_srs_wkt (p, 1,
        "83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Syst");
    add_srs_wkt (p, 2,
        "em_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Trans");
    add_srs_wkt (p, 7,
        "verse_Mercator\"],PARAMETER[\"latitude_of_origin\",40.55");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"central_meridian\",-84.95],PARAMETER[\"sca");
    add_srs_wkt (p, 9,
        "le_factor\",1.000034],PARAMETER[\"false_easting\",787400");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_northing\",118110],UNIT[\"US survey ");
    add_srs_wkt (p, 11,
        "foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],A");
    add_srs_wkt (p, 12,
        "XIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY");
    add_srs_wkt (p, 13,
        "[\"EPSG\",\"7258\"]]");
    p = add_epsg_def_ex (filter, first, last, 7259, "epsg", 7259,
        "NAD83(2011) / InGCS Allen (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=40.9 +lon_0=-85.05 +k=1.000031 +x_0=2");
    add_proj4text (p, 1,
        "40000 +y_0=36000 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / InGCS Allen (m)\",GEOGCS[\"NAD83(");
    add_srs_wkt (p, 1,
        "2011)\",DATUM[\"NAD83_National_Spatial_Reference_System_");
    add_srs_wkt (p, 2,
        "2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHO");
    add_srs_wkt (p, 3,
        "RITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],P");
    add_srs_wkt (p, 4,
        "RIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT");
    add_srs_wkt (p, 5,
        "[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122");
    add_srs_wkt (p, 6,
        "\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transver");
    add_srs_wkt (p, 7,
        "se_Mercator\"],PARAMETER[\"latitude_of_origin\",40.9],PA");
    add_srs_wkt (p, 8,
        "RAMETER[\"central_meridian\",-85.05],PARAMETER[\"scale_f");
    add_srs_wkt (p, 9,
        "actor\",1.000031],PARAMETER[\"false_easting\",240000],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"false_northing\",36000],UNIT[\"metre\",1,AUTHO");
    add_srs_wkt (p, 11,
        "RITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"N");
    add_srs_wkt (p, 12,
        "orthing\",NORTH],AUTHORITY[\"EPSG\",\"7259\"]]");
    p = add_epsg_def_ex (filter, first, last, 7260, "epsg", 7260,
        "NAD83(2011) / InGCS Allen (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=40.9 +lon_0=-85.05 +k=1.000031 +x_0=2");
    add_proj4text (p, 1,
        "40000 +y_0=36000 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / InGCS Allen (ftUS)\",GEOGCS[\"NAD");
    add_srs_wkt (p, 1,
        "83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Syst");
    add_srs_wkt (p, 2,
        "em_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Trans");
    add_srs_wkt (p, 7,
        "verse_Mercator\"],PARAMETER[\"latitude_of_origin\",40.9]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"central_meridian\",-85.05],PARAMETER[\"scal");
    add_srs_wkt (p, 9,
        "e_factor\",1.000031],PARAMETER[\"false_easting\",787400]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"false_northing\",118110],UNIT[\"US survey f");
    add_srs_wkt (p, 11,
        "oot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AX");
    add_srs_wkt (p, 12,
        "IS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[");
    add_srs_wkt (p, 13,
        "\"EPSG\",\"7260\"]]");
    p = add_epsg_def_ex (filter, first, last, 7261, "epsg", 7261,
        "NAD83(2011) / InGCS Bartholomew (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=39 +lon_0=-85.84999999999999 +k=1.000");
    add_proj4text (p, 1,
        "026 +x_0=240000 +y_0=36000 +ellps=GRS80 +units=m +no_def");
    add_proj4text (p, 2,
        "s");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / InGCS Bartholomew (m)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_S");
    add_srs_wkt (p, 2,
        "ystem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116");
    add_srs_wkt (p, 4,
        "\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]");
    add_srs_wkt (p, 5,
        "],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Tr");
    add_srs_wkt (p, 7,
        "ansverse_Mercator\"],PARAMETER[\"latitude_of_origin\",39");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"central_meridian\",-85.85],PARAMETER[\"sca");
    add_srs_wkt (p, 9,
        "le_factor\",1.000026],PARAMETER[\"false_easting\",240000");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_northing\",36000],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 11,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS");
    add_srs_wkt (p, 12,
        "[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"7261\"]]");
    p = add_epsg_def_ex (filter, first, last, 7262, "epsg", 7262,
        "NAD83(2011) / InGCS Bartholomew (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=39 +lon_0=-85.84999999999999 +k=1.000");
    add_proj4text (p, 1,
        "026 +x_0=240000 +y_0=36000 +ellps=GRS80 +units=us-ft +no");
    add_proj4text (p, 2,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / InGCS Bartholomew (ftUS)\",GEOGCS");
    add_srs_wkt (p, 1,
        "[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Referenc");
    add_srs_wkt (p, 2,
        "e_System_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222");
    add_srs_wkt (p, 3,
        "101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1");
    add_srs_wkt (p, 4,
        "116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 5,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 6,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"");
    add_srs_wkt (p, 7,
        "Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\",");
    add_srs_wkt (p, 8,
        "39],PARAMETER[\"central_meridian\",-85.85],PARAMETER[\"s");
    add_srs_wkt (p, 9,
        "cale_factor\",1.000026],PARAMETER[\"false_easting\",7874");
    add_srs_wkt (p, 10,
        "00],PARAMETER[\"false_northing\",118110],UNIT[\"US surve");
    add_srs_wkt (p, 11,
        "y foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]]");
    add_srs_wkt (p, 12,
        ",AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORI");
    add_srs_wkt (p, 13,
        "TY[\"EPSG\",\"7262\"]]");
    p = add_epsg_def_ex (filter, first, last, 7263, "epsg", 7263,
        "NAD83(2011) / InGCS Benton (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=40.45 +lon_0=-87.3 +k=1.000029 +x_0=2");
    add_proj4text (p, 1,
        "40000 +y_0=36000 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / InGCS Benton (m)\",GEOGCS[\"NAD83");
    add_srs_wkt (p, 1,
        "(2011)\",DATUM[\"NAD83_National_Spatial_Reference_System");
    add_srs_wkt (p, 2,
        "_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 7,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",40.45],");
    add_srs_wkt (p, 8,
        "PARAMETER[\"central_meridian\",-87.3],PARAMETER[\"scale_");
    add_srs_wkt (p, 9,
        "factor\",1.000029],PARAMETER[\"false_easting\",240000],P");
    add_srs_wkt (p, 10,
        "ARAMETER[\"false_northing\",36000],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 11,
        "ORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 12,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"7263\"]]");
    p = add_epsg_def_ex (filter, first, last, 7264, "epsg", 7264,
        "NAD83(2011) / InGCS Benton (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=40.45 +lon_0=-87.3 +k=1.000029 +x_0=2");
    add_proj4text (p, 1,
        "40000 +y_0=36000 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / InGCS Benton (ftUS)\",GEOGCS[\"NA");
    add_srs_wkt (p, 1,
        "D83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Sys");
    add_srs_wkt (p, 2,
        "tem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",40.4");
    add_srs_wkt (p, 8,
        "5],PARAMETER[\"central_meridian\",-87.3],PARAMETER[\"sca");
    add_srs_wkt (p, 9,
        "le_factor\",1.000029],PARAMETER[\"false_easting\",787400");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_northing\",118110],UNIT[\"US survey ");
    add_srs_wkt (p, 11,
        "foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],A");
    add_srs_wkt (p, 12,
        "XIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY");
    add_srs_wkt (p, 13,
        "[\"EPSG\",\"7264\"]]");
    p = add_epsg_def_ex (filter, first, last, 7265, "epsg", 7265,
        "NAD83(2011) / InGCS Blackford-Delaware (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=40.05 +lon_0=-85.40000000000001 +k=1.");
    add_proj4text (p, 1,
        "000038 +x_0=240000 +y_0=36000 +ellps=GRS80 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / InGCS Blackford-Delaware (m)\",GE");
    add_srs_wkt (p, 1,
        "OGCS[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Refe");
    add_srs_wkt (p, 2,
        "rence_System_2011\",SPHEROID[\"GRS 1980\",6378137,298.25");
    add_srs_wkt (p, 3,
        "7222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTI");
    add_srs_wkt (p, 7,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 8,
        "in\",40.05],PARAMETER[\"central_meridian\",-85.4],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"scale_factor\",1.000038],PARAMETER[\"false_easting");
    add_srs_wkt (p, 10,
        "\",240000],PARAMETER[\"false_northing\",36000],UNIT[\"me");
    add_srs_wkt (p, 11,
        "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",E");
    add_srs_wkt (p, 12,
        "AST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"7265\"");
    add_srs_wkt (p, 13,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 7266, "epsg", 7266,
        "NAD83(2011) / InGCS Blackford-Delaware (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=40.05 +lon_0=-85.40000000000001 +k=1.");
    add_proj4text (p, 1,
        "000038 +x_0=240000 +y_0=36000 +ellps=GRS80 +units=us-ft ");
    add_proj4text (p, 2,
        "+no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / InGCS Blackford-Delaware (ftUS)\"");
    add_srs_wkt (p, 1,
        ",GEOGCS[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_R");
    add_srs_wkt (p, 2,
        "eference_System_2011\",SPHEROID[\"GRS 1980\",6378137,298");
    add_srs_wkt (p, 3,
        ".257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJE");
    add_srs_wkt (p, 7,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 8,
        "rigin\",40.05],PARAMETER[\"central_meridian\",-85.4],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"scale_factor\",1.000038],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
        "ing\",787400],PARAMETER[\"false_northing\",118110],UNIT[");
    add_srs_wkt (p, 11,
        "\"US survey foot\",0.304800609601219,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 12,
        "\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORT");
    add_srs_wkt (p, 13,
        "H],AUTHORITY[\"EPSG\",\"7266\"]]");
    p = add_epsg_def_ex (filter, first, last, 7267, "epsg", 7267,
        "NAD83(2011) / InGCS Boone-Hendricks (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=39.6 +lon_0=-86.5 +k=1.000036 +x_0=24");
    add_proj4text (p, 1,
        "0000 +y_0=36000 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / InGCS Boone-Hendricks (m)\",GEOGC");
    add_srs_wkt (p, 1,
        "S[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Referen");
    add_srs_wkt (p, 2,
        "ce_System_2011\",SPHEROID[\"GRS 1980\",6378137,298.25722");
    add_srs_wkt (p, 3,
        "2101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",39.6],PARAMETER[\"central_meridian\",-86.5],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "scale_factor\",1.000036],PARAMETER[\"false_easting\",240");
    add_srs_wkt (p, 10,
        "000],PARAMETER[\"false_northing\",36000],UNIT[\"metre\",");
    add_srs_wkt (p, 11,
        "1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],A");
    add_srs_wkt (p, 12,
        "XIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"7267\"]]");
    p = add_epsg_def_ex (filter, first, last, 7268, "epsg", 7268,
        "NAD83(2011) / InGCS Boone-Hendricks (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=39.6 +lon_0=-86.5 +k=1.000036 +x_0=24");
    add_proj4text (p, 1,
        "0000 +y_0=36000 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / InGCS Boone-Hendricks (ftUS)\",GE");
    add_srs_wkt (p, 1,
        "OGCS[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Refe");
    add_srs_wkt (p, 2,
        "rence_System_2011\",SPHEROID[\"GRS 1980\",6378137,298.25");
    add_srs_wkt (p, 3,
        "7222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTI");
    add_srs_wkt (p, 7,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 8,
        "in\",39.6],PARAMETER[\"central_meridian\",-86.5],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"scale_factor\",1.000036],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 10,
        ",787400],PARAMETER[\"false_northing\",118110],UNIT[\"US ");
    add_srs_wkt (p, 11,
        "survey foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 12,
        "3\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AU");
    add_srs_wkt (p, 13,
        "THORITY[\"EPSG\",\"7268\"]]");
    p = add_epsg_def_ex (filter, first, last, 7269, "epsg", 7269,
        "NAD83(2011) / InGCS Brown (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=39 +lon_0=-86.3 +k=1.00003 +x_0=24000");
    add_proj4text (p, 1,
        "0 +y_0=36000 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / InGCS Brown (m)\",GEOGCS[\"NAD83(");
    add_srs_wkt (p, 1,
        "2011)\",DATUM[\"NAD83_National_Spatial_Reference_System_");
    add_srs_wkt (p, 2,
        "2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHO");
    add_srs_wkt (p, 3,
        "RITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],P");
    add_srs_wkt (p, 4,
        "RIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT");
    add_srs_wkt (p, 5,
        "[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122");
    add_srs_wkt (p, 6,
        "\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transver");
    add_srs_wkt (p, 7,
        "se_Mercator\"],PARAMETER[\"latitude_of_origin\",39],PARA");
    add_srs_wkt (p, 8,
        "METER[\"central_meridian\",-86.3],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 9,
        "or\",1.00003],PARAMETER[\"false_easting\",240000],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_northing\",36000],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 11,
        "[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"North");
    add_srs_wkt (p, 12,
        "ing\",NORTH],AUTHORITY[\"EPSG\",\"7269\"]]");
    p = add_epsg_def_ex (filter, first, last, 7270, "epsg", 7270,
        "NAD83(2011) / InGCS Brown (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=39 +lon_0=-86.3 +k=1.00003 +x_0=24000");
    add_proj4text (p, 1,
        "0 +y_0=36000 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / InGCS Brown (ftUS)\",GEOGCS[\"NAD");
    add_srs_wkt (p, 1,
        "83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Syst");
    add_srs_wkt (p, 2,
        "em_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Trans");
    add_srs_wkt (p, 7,
        "verse_Mercator\"],PARAMETER[\"latitude_of_origin\",39],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"central_meridian\",-86.3],PARAMETER[\"scale_f");
    add_srs_wkt (p, 9,
        "actor\",1.00003],PARAMETER[\"false_easting\",787400],PAR");
    add_srs_wkt (p, 10,
        "AMETER[\"false_northing\",118110],UNIT[\"US survey foot\"");
    add_srs_wkt (p, 11,
        ",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"");
    add_srs_wkt (p, 12,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 13,
        "G\",\"7270\"]]");
    p = add_epsg_def_ex (filter, first, last, 7271, "epsg", 7271,
        "NAD83(2011) / InGCS Carroll (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=40.4 +lon_0=-86.65000000000001 +k=1.0");
    add_proj4text (p, 1,
        "00026 +x_0=240000 +y_0=36000 +ellps=GRS80 +units=m +no_d");
    add_proj4text (p, 2,
        "efs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / InGCS Carroll (m)\",GEOGCS[\"NAD8");
    add_srs_wkt (p, 1,
        "3(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Syste");
    add_srs_wkt (p, 2,
        "m_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]]");
    add_srs_wkt (p, 4,
        ",PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UN");
    add_srs_wkt (p, 5,
        "IT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"91");
    add_srs_wkt (p, 6,
        "22\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transv");
    add_srs_wkt (p, 7,
        "erse_Mercator\"],PARAMETER[\"latitude_of_origin\",40.4],");
    add_srs_wkt (p, 8,
        "PARAMETER[\"central_meridian\",-86.65],PARAMETER[\"scale");
    add_srs_wkt (p, 9,
        "_factor\",1.000026],PARAMETER[\"false_easting\",240000],");
    add_srs_wkt (p, 10,
        "PARAMETER[\"false_northing\",36000],UNIT[\"metre\",1,AUT");
    add_srs_wkt (p, 11,
        "HORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 12,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"7271\"]]");
    p = add_epsg_def_ex (filter, first, last, 7272, "epsg", 7272,
        "NAD83(2011) / InGCS Carroll (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=40.4 +lon_0=-86.65000000000001 +k=1.0");
    add_proj4text (p, 1,
        "00026 +x_0=240000 +y_0=36000 +ellps=GRS80 +units=us-ft +");
    add_proj4text (p, 2,
        "no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / InGCS Carroll (ftUS)\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
        "AD83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Sy");
    add_srs_wkt (p, 2,
        "stem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",40.4");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"central_meridian\",-86.65],PARAMETER[\"sca");
    add_srs_wkt (p, 9,
        "le_factor\",1.000026],PARAMETER[\"false_easting\",787400");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_northing\",118110],UNIT[\"US survey ");
    add_srs_wkt (p, 11,
        "foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],A");
    add_srs_wkt (p, 12,
        "XIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY");
    add_srs_wkt (p, 13,
        "[\"EPSG\",\"7272\"]]");
    p = add_epsg_def_ex (filter, first, last, 7273, "epsg", 7273,
        "NAD83(2011) / InGCS Cass (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=40.55 +lon_0=-86.40000000000001 +k=1.");
    add_proj4text (p, 1,
        "000028 +x_0=240000 +y_0=36000 +ellps=GRS80 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / InGCS Cass (m)\",GEOGCS[\"NAD83(2");
    add_srs_wkt (p, 1,
        "011)\",DATUM[\"NAD83_National_Spatial_Reference_System_2");
    add_srs_wkt (p, 2,
        "011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],PR");
    add_srs_wkt (p, 4,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 5,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 6,
        "]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse");
    add_srs_wkt (p, 7,
        "_Mercator\"],PARAMETER[\"latitude_of_origin\",40.55],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"central_meridian\",-86.4],PARAMETER[\"scale_fac");
    add_srs_wkt (p, 9,
        "tor\",1.000028],PARAMETER[\"false_easting\",240000],PARA");
    add_srs_wkt (p, 10,
        "METER[\"false_northing\",36000],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 11,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Nor");
    add_srs_wkt (p, 12,
        "thing\",NORTH],AUTHORITY[\"EPSG\",\"7273\"]]");
    p = add_epsg_def_ex (filter, first, last, 7274, "epsg", 7274,
        "NAD83(2011) / InGCS Cass (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=40.55 +lon_0=-86.40000000000001 +k=1.");
    add_proj4text (p, 1,
        "000028 +x_0=240000 +y_0=36000 +ellps=GRS80 +units=us-ft ");
    add_proj4text (p, 2,
        "+no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / InGCS Cass (ftUS)\",GEOGCS[\"NAD8");
    add_srs_wkt (p, 1,
        "3(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Syste");
    add_srs_wkt (p, 2,
        "m_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]]");
    add_srs_wkt (p, 4,
        ",PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UN");
    add_srs_wkt (p, 5,
        "IT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"91");
    add_srs_wkt (p, 6,
        "22\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transv");
    add_srs_wkt (p, 7,
        "erse_Mercator\"],PARAMETER[\"latitude_of_origin\",40.55]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"central_meridian\",-86.4],PARAMETER[\"scale");
    add_srs_wkt (p, 9,
        "_factor\",1.000028],PARAMETER[\"false_easting\",787400],");
    add_srs_wkt (p, 10,
        "PARAMETER[\"false_northing\",118110],UNIT[\"US survey fo");
    add_srs_wkt (p, 11,
        "ot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXI");
    add_srs_wkt (p, 12,
        "S[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 13,
        "EPSG\",\"7274\"]]");
    p = add_epsg_def_ex (filter, first, last, 7275, "epsg", 7275,
        "NAD83(2011) / InGCS Clark-Floyd-Scott (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=38.15 +lon_0=-85.59999999999999 +k=1.");
    add_proj4text (p, 1,
        "000021 +x_0=240000 +y_0=36000 +ellps=GRS80 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / InGCS Clark-Floyd-Scott (m)\",GEO");
    add_srs_wkt (p, 1,
        "GCS[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Refer");
    add_srs_wkt (p, 2,
        "ence_System_2011\",SPHEROID[\"GRS 1980\",6378137,298.257");
    add_srs_wkt (p, 3,
        "222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 4,
        "\"1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8");
    add_srs_wkt (p, 5,
        "901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"E");
    add_srs_wkt (p, 6,
        "PSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTIO");
    add_srs_wkt (p, 7,
        "N[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 8,
        "n\",38.15],PARAMETER[\"central_meridian\",-85.6],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"scale_factor\",1.000021],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 10,
        ",240000],PARAMETER[\"false_northing\",36000],UNIT[\"metr");
    add_srs_wkt (p, 11,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 12,
        "T],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"7275\"]");
    add_srs_wkt (p, 13,
        "]");
    p = add_epsg_def_ex (filter, first, last, 7276, "epsg", 7276,
        "NAD83(2011) / InGCS Clark-Floyd-Scott (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=38.15 +lon_0=-85.59999999999999 +k=1.");
    add_proj4text (p, 1,
        "000021 +x_0=240000 +y_0=36000 +ellps=GRS80 +units=us-ft ");
    add_proj4text (p, 2,
        "+no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / InGCS Clark-Floyd-Scott (ftUS)\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Re");
    add_srs_wkt (p, 2,
        "ference_System_2011\",SPHEROID[\"GRS 1980\",6378137,298.");
    add_srs_wkt (p, 3,
        "257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 4,
        "\",\"1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 5,
        "\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[");
    add_srs_wkt (p, 6,
        "\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJEC");
    add_srs_wkt (p, 7,
        "TION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_or");
    add_srs_wkt (p, 8,
        "igin\",38.15],PARAMETER[\"central_meridian\",-85.6],PARA");
    add_srs_wkt (p, 9,
        "METER[\"scale_factor\",1.000021],PARAMETER[\"false_easti");
    add_srs_wkt (p, 10,
        "ng\",787400],PARAMETER[\"false_northing\",118110],UNIT[\"");
    add_srs_wkt (p, 11,
        "US survey foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH]");
    add_srs_wkt (p, 13,
        ",AUTHORITY[\"EPSG\",\"7276\"]]");
    p = add_epsg_def_ex (filter, first, last, 7277, "epsg", 7277,
        "NAD83(2011) / InGCS Clay (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=39.15 +lon_0=-87.15000000000001 +k=1.");
    add_proj4text (p, 1,
        "000024 +x_0=240000 +y_0=36000 +ellps=GRS80 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / InGCS Clay (m)\",GEOGCS[\"NAD83(2");
    add_srs_wkt (p, 1,
        "011)\",DATUM[\"NAD83_National_Spatial_Reference_System_2");
    add_srs_wkt (p, 2,
        "011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],PR");
    add_srs_wkt (p, 4,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 5,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 6,
        "]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse");
    add_srs_wkt (p, 7,
        "_Mercator\"],PARAMETER[\"latitude_of_origin\",39.15],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"central_meridian\",-87.15],PARAMETER[\"scale_fa");
    add_srs_wkt (p, 9,
        "ctor\",1.000024],PARAMETER[\"false_easting\",240000],PAR");
    add_srs_wkt (p, 10,
        "AMETER[\"false_northing\",36000],UNIT[\"metre\",1,AUTHOR");
    add_srs_wkt (p, 11,
        "ITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"No");
    add_srs_wkt (p, 12,
        "rthing\",NORTH],AUTHORITY[\"EPSG\",\"7277\"]]");
    p = add_epsg_def_ex (filter, first, last, 7278, "epsg", 7278,
        "NAD83(2011) / InGCS Clay (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=39.15 +lon_0=-87.15000000000001 +k=1.");
    add_proj4text (p, 1,
        "000024 +x_0=240000 +y_0=36000 +ellps=GRS80 +units=us-ft ");
    add_proj4text (p, 2,
        "+no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / InGCS Clay (ftUS)\",GEOGCS[\"NAD8");
    add_srs_wkt (p, 1,
        "3(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Syste");
    add_srs_wkt (p, 2,
        "m_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]]");
    add_srs_wkt (p, 4,
        ",PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UN");
    add_srs_wkt (p, 5,
        "IT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"91");
    add_srs_wkt (p, 6,
        "22\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transv");
    add_srs_wkt (p, 7,
        "erse_Mercator\"],PARAMETER[\"latitude_of_origin\",39.15]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"central_meridian\",-87.15],PARAMETER[\"scal");
    add_srs_wkt (p, 9,
        "e_factor\",1.000024],PARAMETER[\"false_easting\",787400]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"false_northing\",118110],UNIT[\"US survey f");
    add_srs_wkt (p, 11,
        "oot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AX");
    add_srs_wkt (p, 12,
        "IS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[");
    add_srs_wkt (p, 13,
        "\"EPSG\",\"7278\"]]");
    p = add_epsg_def_ex (filter, first, last, 7279, "epsg", 7279,
        "NAD83(2011) / InGCS Clinton (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=40.15 +lon_0=-86.59999999999999 +k=1.");
    add_proj4text (p, 1,
        "000032 +x_0=240000 +y_0=36000 +ellps=GRS80 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / InGCS Clinton (m)\",GEOGCS[\"NAD8");
    add_srs_wkt (p, 1,
        "3(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Syste");
    add_srs_wkt (p, 2,
        "m_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]]");
    add_srs_wkt (p, 4,
        ",PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UN");
    add_srs_wkt (p, 5,
        "IT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"91");
    add_srs_wkt (p, 6,
        "22\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transv");
    add_srs_wkt (p, 7,
        "erse_Mercator\"],PARAMETER[\"latitude_of_origin\",40.15]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"central_meridian\",-86.6],PARAMETER[\"scale");
    add_srs_wkt (p, 9,
        "_factor\",1.000032],PARAMETER[\"false_easting\",240000],");
    add_srs_wkt (p, 10,
        "PARAMETER[\"false_northing\",36000],UNIT[\"metre\",1,AUT");
    add_srs_wkt (p, 11,
        "HORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 12,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"7279\"]]");
    p = add_epsg_def_ex (filter, first, last, 7280, "epsg", 7280,
        "NAD83(2011) / InGCS Clinton (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=40.15 +lon_0=-86.59999999999999 +k=1.");
    add_proj4text (p, 1,
        "000032 +x_0=240000 +y_0=36000 +ellps=GRS80 +units=us-ft ");
    add_proj4text (p, 2,
        "+no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / InGCS Clinton (ftUS)\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
        "AD83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Sy");
    add_srs_wkt (p, 2,
        "stem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",40.1");
    add_srs_wkt (p, 8,
        "5],PARAMETER[\"central_meridian\",-86.6],PARAMETER[\"sca");
    add_srs_wkt (p, 9,
        "le_factor\",1.000032],PARAMETER[\"false_easting\",787400");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_northing\",118110],UNIT[\"US survey ");
    add_srs_wkt (p, 11,
        "foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],A");
    add_srs_wkt (p, 12,
        "XIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY");
    add_srs_wkt (p, 13,
        "[\"EPSG\",\"7280\"]]");
    p = add_epsg_def_ex (filter, first, last, 7281, "epsg", 7281,
        "NAD83(2011) / InGCS Crawford-Lawrence-Orange (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=38.1 +lon_0=-86.5 +k=1.000025 +x_0=24");
    add_proj4text (p, 1,
        "0000 +y_0=36000 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / InGCS Crawford-Lawrence-Orange (m");
    add_srs_wkt (p, 1,
        ")\",GEOGCS[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatia");
    add_srs_wkt (p, 2,
        "l_Reference_System_2011\",SPHEROID[\"GRS 1980\",6378137,");
    add_srs_wkt (p, 3,
        "298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",38.1],PARAMETER[\"central_meridian\",-86.5],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"scale_factor\",1.000025],PARAMETER[\"false_ea");
    add_srs_wkt (p, 10,
        "sting\",240000],PARAMETER[\"false_northing\",36000],UNIT");
    add_srs_wkt (p, 11,
        "[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eastin");
    add_srs_wkt (p, 12,
        "g\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 13,
        "7281\"]]");
    p = add_epsg_def_ex (filter, first, last, 7282, "epsg", 7282,
        "NAD83(2011) / InGCS Crawford-Lawrence-Orange (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=38.1 +lon_0=-86.5 +k=1.000025 +x_0=24");
    add_proj4text (p, 1,
        "0000 +y_0=36000 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / InGCS Crawford-Lawrence-Orange (f");
    add_srs_wkt (p, 1,
        "tUS)\",GEOGCS[\"NAD83(2011)\",DATUM[\"NAD83_National_Spa");
    add_srs_wkt (p, 2,
        "tial_Reference_System_2011\",SPHEROID[\"GRS 1980\",63781");
    add_srs_wkt (p, 3,
        "37,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]]");
    add_srs_wkt (p, 7,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 8,
        "e_of_origin\",38.1],PARAMETER[\"central_meridian\",-86.5");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"scale_factor\",1.000025],PARAMETER[\"false");
    add_srs_wkt (p, 10,
        "_easting\",787400],PARAMETER[\"false_northing\",118110],");
    add_srs_wkt (p, 11,
        "UNIT[\"US survey foot\",0.304800609601219,AUTHORITY[\"EP");
    add_srs_wkt (p, 12,
        "SG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 13,
        ",NORTH],AUTHORITY[\"EPSG\",\"7282\"]]");
    p = add_epsg_def_ex (filter, first, last, 7283, "epsg", 7283,
        "NAD83(2011) / InGCS Daviess-Greene (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=38.45 +lon_0=-87.09999999999999 +k=1.");
    add_proj4text (p, 1,
        "000018 +x_0=240000 +y_0=36000 +ellps=GRS80 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / InGCS Daviess-Greene (m)\",GEOGCS");
    add_srs_wkt (p, 1,
        "[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Referenc");
    add_srs_wkt (p, 2,
        "e_System_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222");
    add_srs_wkt (p, 3,
        "101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1");
    add_srs_wkt (p, 4,
        "116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 5,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 6,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"");
    add_srs_wkt (p, 7,
        "Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\",");
    add_srs_wkt (p, 8,
        "38.45],PARAMETER[\"central_meridian\",-87.1],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "scale_factor\",1.000018],PARAMETER[\"false_easting\",240");
    add_srs_wkt (p, 10,
        "000],PARAMETER[\"false_northing\",36000],UNIT[\"metre\",");
    add_srs_wkt (p, 11,
        "1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],A");
    add_srs_wkt (p, 12,
        "XIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"7283\"]]");
    p = add_epsg_def_ex (filter, first, last, 7284, "epsg", 7284,
        "NAD83(2011) / InGCS Daviess-Greene (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=38.45 +lon_0=-87.09999999999999 +k=1.");
    add_proj4text (p, 1,
        "000018 +x_0=240000 +y_0=36000 +ellps=GRS80 +units=us-ft ");
    add_proj4text (p, 2,
        "+no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / InGCS Daviess-Greene (ftUS)\",GEO");
    add_srs_wkt (p, 1,
        "GCS[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Refer");
    add_srs_wkt (p, 2,
        "ence_System_2011\",SPHEROID[\"GRS 1980\",6378137,298.257");
    add_srs_wkt (p, 3,
        "222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 4,
        "\"1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8");
    add_srs_wkt (p, 5,
        "901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"E");
    add_srs_wkt (p, 6,
        "PSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTIO");
    add_srs_wkt (p, 7,
        "N[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 8,
        "n\",38.45],PARAMETER[\"central_meridian\",-87.1],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"scale_factor\",1.000018],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 10,
        ",787400],PARAMETER[\"false_northing\",118110],UNIT[\"US ");
    add_srs_wkt (p, 11,
        "survey foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 12,
        "3\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AU");
    add_srs_wkt (p, 13,
        "THORITY[\"EPSG\",\"7284\"]]");
    p = add_epsg_def_ex (filter, first, last, 7285, "epsg", 7285,
        "NAD83(2011) / InGCS Dearborn-Ohio-Switzerland (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=38.65 +lon_0=-84.90000000000001 +k=1.");
    add_proj4text (p, 1,
        "000029 +x_0=240000 +y_0=36000 +ellps=GRS80 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / InGCS Dearborn-Ohio-Switzerland (");
    add_srs_wkt (p, 1,
        "m)\",GEOGCS[\"NAD83(2011)\",DATUM[\"NAD83_National_Spati");
    add_srs_wkt (p, 2,
        "al_Reference_System_2011\",SPHEROID[\"GRS 1980\",6378137");
    add_srs_wkt (p, 3,
        ",298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",38.65],PARAMETER[\"central_meridian\",-84.9],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"scale_factor\",1.000029],PARAMETER[\"false_e");
    add_srs_wkt (p, 10,
        "asting\",240000],PARAMETER[\"false_northing\",36000],UNI");
    add_srs_wkt (p, 11,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easti");
    add_srs_wkt (p, 12,
        "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 13,
        "7285\"]]");
    p = add_epsg_def_ex (filter, first, last, 7286, "epsg", 7286,
        "NAD83(2011) / InGCS Dearborn-Ohio-Switzerland (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=38.65 +lon_0=-84.90000000000001 +k=1.");
    add_proj4text (p, 1,
        "000029 +x_0=240000 +y_0=36000 +ellps=GRS80 +units=us-ft ");
    add_proj4text (p, 2,
        "+no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / InGCS Dearborn-Ohio-Switzerland (");
    add_srs_wkt (p, 1,
        "ftUS)\",GEOGCS[\"NAD83(2011)\",DATUM[\"NAD83_National_Sp");
    add_srs_wkt (p, 2,
        "atial_Reference_System_2011\",SPHEROID[\"GRS 1980\",6378");
    add_srs_wkt (p, 3,
        "137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORIT");
    add_srs_wkt (p, 4,
        "Y[\"EPSG\",\"1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]]");
    add_srs_wkt (p, 7,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 8,
        "e_of_origin\",38.65],PARAMETER[\"central_meridian\",-84.");
    add_srs_wkt (p, 9,
        "9],PARAMETER[\"scale_factor\",1.000029],PARAMETER[\"fals");
    add_srs_wkt (p, 10,
        "e_easting\",787400],PARAMETER[\"false_northing\",118110]");
    add_srs_wkt (p, 11,
        ",UNIT[\"US survey foot\",0.304800609601219,AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 13,
        ",NORTH],AUTHORITY[\"EPSG\",\"7286\"]]");
    p = add_epsg_def_ex (filter, first, last, 7287, "epsg", 7287,
        "NAD83(2011) / InGCS Decatur-Rush (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=39.1 +lon_0=-85.65000000000001 +k=1.0");
    add_proj4text (p, 1,
        "00036 +x_0=240000 +y_0=36000 +ellps=GRS80 +units=m +no_d");
    add_proj4text (p, 2,
        "efs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / InGCS Decatur-Rush (m)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_S");
    add_srs_wkt (p, 2,
        "ystem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116");
    add_srs_wkt (p, 4,
        "\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]");
    add_srs_wkt (p, 5,
        "],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Tr");
    add_srs_wkt (p, 7,
        "ansverse_Mercator\"],PARAMETER[\"latitude_of_origin\",39");
    add_srs_wkt (p, 8,
        ".1],PARAMETER[\"central_meridian\",-85.65],PARAMETER[\"s");
    add_srs_wkt (p, 9,
        "cale_factor\",1.000036],PARAMETER[\"false_easting\",2400");
    add_srs_wkt (p, 10,
        "00],PARAMETER[\"false_northing\",36000],UNIT[\"metre\",1");
    add_srs_wkt (p, 11,
        ",AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AX");
    add_srs_wkt (p, 12,
        "IS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"7287\"]]");
    p = add_epsg_def_ex (filter, first, last, 7288, "epsg", 7288,
        "NAD83(2011) / InGCS Decatur-Rush (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=39.1 +lon_0=-85.65000000000001 +k=1.0");
    add_proj4text (p, 1,
        "00036 +x_0=240000 +y_0=36000 +ellps=GRS80 +units=us-ft +");
    add_proj4text (p, 2,
        "no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / InGCS Decatur-Rush (ftUS)\",GEOGC");
    add_srs_wkt (p, 1,
        "S[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Referen");
    add_srs_wkt (p, 2,
        "ce_System_2011\",SPHEROID[\"GRS 1980\",6378137,298.25722");
    add_srs_wkt (p, 3,
        "2101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",39.1],PARAMETER[\"central_meridian\",-85.65],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"scale_factor\",1.000036],PARAMETER[\"false_easting\",7");
    add_srs_wkt (p, 10,
        "87400],PARAMETER[\"false_northing\",118110],UNIT[\"US su");
    add_srs_wkt (p, 11,
        "rvey foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"");
    add_srs_wkt (p, 12,
        "]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHO");
    add_srs_wkt (p, 13,
        "RITY[\"EPSG\",\"7288\"]]");
    p = add_epsg_def_ex (filter, first, last, 7289, "epsg", 7289,
        "NAD83(2011) / InGCS DeKalb (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=41.25 +lon_0=-84.95 +k=1.000036 +x_0=");
    add_proj4text (p, 1,
        "240000 +y_0=36000 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / InGCS DeKalb (m)\",GEOGCS[\"NAD83");
    add_srs_wkt (p, 1,
        "(2011)\",DATUM[\"NAD83_National_Spatial_Reference_System");
    add_srs_wkt (p, 2,
        "_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 7,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",41.25],");
    add_srs_wkt (p, 8,
        "PARAMETER[\"central_meridian\",-84.95],PARAMETER[\"scale");
    add_srs_wkt (p, 9,
        "_factor\",1.000036],PARAMETER[\"false_easting\",240000],");
    add_srs_wkt (p, 10,
        "PARAMETER[\"false_northing\",36000],UNIT[\"metre\",1,AUT");
    add_srs_wkt (p, 11,
        "HORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 12,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"7289\"]]");
    p = add_epsg_def_ex (filter, first, last, 7290, "epsg", 7290,
        "NAD83(2011) / InGCS DeKalb (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=41.25 +lon_0=-84.95 +k=1.000036 +x_0=");
    add_proj4text (p, 1,
        "240000 +y_0=36000 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / InGCS DeKalb (ftUS)\",GEOGCS[\"NA");
    add_srs_wkt (p, 1,
        "D83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Sys");
    add_srs_wkt (p, 2,
        "tem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",41.2");
    add_srs_wkt (p, 8,
        "5],PARAMETER[\"central_meridian\",-84.95],PARAMETER[\"sc");
    add_srs_wkt (p, 9,
        "ale_factor\",1.000036],PARAMETER[\"false_easting\",78740");
    add_srs_wkt (p, 10,
        "0],PARAMETER[\"false_northing\",118110],UNIT[\"US survey");
    add_srs_wkt (p, 11,
        " foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],");
    add_srs_wkt (p, 12,
        "AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORIT");
    add_srs_wkt (p, 13,
        "Y[\"EPSG\",\"7290\"]]");
    p = add_epsg_def_ex (filter, first, last, 7291, "epsg", 7291,
        "NAD83(2011) / InGCS Dubois-Martin (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=38.2 +lon_0=-86.95 +k=1.00002 +x_0=24");
    add_proj4text (p, 1,
        "0000 +y_0=36000 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / InGCS Dubois-Martin (m)\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Reference");
    add_srs_wkt (p, 2,
        "_System_2011\",SPHEROID[\"GRS 1980\",6378137,298.2572221");
    add_srs_wkt (p, 3,
        "01,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"11");
    add_srs_wkt (p, 4,
        "16\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"T");
    add_srs_wkt (p, 7,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",3");
    add_srs_wkt (p, 8,
        "8.2],PARAMETER[\"central_meridian\",-86.95],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "scale_factor\",1.00002],PARAMETER[\"false_easting\",2400");
    add_srs_wkt (p, 10,
        "00],PARAMETER[\"false_northing\",36000],UNIT[\"metre\",1");
    add_srs_wkt (p, 11,
        ",AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AX");
    add_srs_wkt (p, 12,
        "IS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"7291\"]]");
    p = add_epsg_def_ex (filter, first, last, 7292, "epsg", 7292,
        "NAD83(2011) / InGCS Dubois-Martin (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=38.2 +lon_0=-86.95 +k=1.00002 +x_0=24");
    add_proj4text (p, 1,
        "0000 +y_0=36000 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / InGCS Dubois-Martin (ftUS)\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Refere");
    add_srs_wkt (p, 2,
        "nce_System_2011\",SPHEROID[\"GRS 1980\",6378137,298.2572");
    add_srs_wkt (p, 3,
        "22101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",38.2],PARAMETER[\"central_meridian\",-86.95],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"scale_factor\",1.00002],PARAMETER[\"false_easting\",78");
    add_srs_wkt (p, 10,
        "7400],PARAMETER[\"false_northing\",118110],UNIT[\"US sur");
    add_srs_wkt (p, 11,
        "vey foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"");
    add_srs_wkt (p, 12,
        "]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHO");
    add_srs_wkt (p, 13,
        "RITY[\"EPSG\",\"7292\"]]");
    p = add_epsg_def_ex (filter, first, last, 7293, "epsg", 7293,
        "NAD83(2011) / InGCS Elkhart-Kosciusko-Wabash (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=40.65 +lon_0=-85.84999999999999 +k=1.");
    add_proj4text (p, 1,
        "000033 +x_0=240000 +y_0=36000 +ellps=GRS80 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / InGCS Elkhart-Kosciusko-Wabash (m");
    add_srs_wkt (p, 1,
        ")\",GEOGCS[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatia");
    add_srs_wkt (p, 2,
        "l_Reference_System_2011\",SPHEROID[\"GRS 1980\",6378137,");
    add_srs_wkt (p, 3,
        "298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",40.65],PARAMETER[\"central_meridian\",-85.85]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"scale_factor\",1.000033],PARAMETER[\"false_");
    add_srs_wkt (p, 10,
        "easting\",240000],PARAMETER[\"false_northing\",36000],UN");
    add_srs_wkt (p, 11,
        "IT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"East");
    add_srs_wkt (p, 12,
        "ing\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 13,
        "\"7293\"]]");
    p = add_epsg_def_ex (filter, first, last, 7294, "epsg", 7294,
        "NAD83(2011) / InGCS Elkhart-Kosciusko-Wabash (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=40.65 +lon_0=-85.84999999999999 +k=1.");
    add_proj4text (p, 1,
        "000033 +x_0=240000 +y_0=36000 +ellps=GRS80 +units=us-ft ");
    add_proj4text (p, 2,
        "+no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / InGCS Elkhart-Kosciusko-Wabash (f");
    add_srs_wkt (p, 1,
        "tUS)\",GEOGCS[\"NAD83(2011)\",DATUM[\"NAD83_National_Spa");
    add_srs_wkt (p, 2,
        "tial_Reference_System_2011\",SPHEROID[\"GRS 1980\",63781");
    add_srs_wkt (p, 3,
        "37,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]]");
    add_srs_wkt (p, 7,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 8,
        "e_of_origin\",40.65],PARAMETER[\"central_meridian\",-85.");
    add_srs_wkt (p, 9,
        "85],PARAMETER[\"scale_factor\",1.000033],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
        "se_easting\",787400],PARAMETER[\"false_northing\",118110");
    add_srs_wkt (p, 11,
        "],UNIT[\"US survey foot\",0.304800609601219,AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing");
    add_srs_wkt (p, 13,
        "\",NORTH],AUTHORITY[\"EPSG\",\"7294\"]]");
}

#endif /* full EPSG initialization enabled/disabled */

