#!/bin/sh

if [ -x "$(command -v Coco)" ]; then
  COCO=Coco
elif  [ -x "$(command -v cococpp)" ]; then
  COCO=cococpp
else
  echo "No coco implementation found!"
  exit 1
fi

echo "Using Coco command '${COCO}'..."

cd $(dirname $0)

# OSS (aka OSMScout style)
$COCO OSS/OSS.atg -namespace osmscout:oss -frames OSS -o OSS

sed -i s/\(L\"/\(\"/g OSS/Scanner.cpp
sed -i s/L\'/\'/g OSS/Scanner.cpp
sed -i s/wchar_t/char/g OSS/Scanner.cpp

sed -i s/L\"/\"/g OSS/Parser.cpp

cp OSS/Scanner.h ../include/osmscoutmap/oss/
cp OSS/Scanner.cpp ../src/osmscoutmap/oss

cp OSS/Parser.h ../include/osmscoutmap/oss/
cp OSS/Parser.cpp ../src/osmscoutmap/oss
