/* This file is automatically generated by Lemon from input grammar
** source file "grn_ecmascript.lemon".
*/
/*
** 2000-05-29
**
** The author disclaims copyright to this source code.  In place of
** a legal notice, here is a blessing:
**
**    May you do good and not evil.
**    May you find forgiveness for yourself and forgive others.
**    May you share freely, never taking more than you give.
**
*************************************************************************
** Driver template for the LEMON parser generator.
**
** The "lemon" program processes an LALR(1) input grammar file, then uses
** this template to construct a parser.  The "lemon" program inserts text
** at each "%%" line.  Also, any "P-a-r-s-e" identifer prefix (without the
** interstitial "-" characters) contained in this template is changed into
** the value of the %name directive from the grammar.  Otherwise, the content
** of this template is copied straight through into the generate parser
** source file.
**
** The following is the concatenation of all %include directives from the
** input grammar file:
*/
/************ Begin %include sections from the grammar ************************/
#line 4 "grn_ecmascript.lemon"

#ifdef assert
#  undef assert
#endif
#define assert GRN_ASSERT

  static void
  array_literal_end(efs_info *efsi, int n_elements)
  {
    grn_ctx *ctx = efsi->ctx;
    grn_expr *e = (grn_expr *)(efsi->e);

    grn_id uvector_domain = GRN_ID_NIL;
    int i;
    for (i = n_elements; i > 0; i--) {
      grn_expr_code *code = &(e->codes[e->codes_curr - i]);
      if (code->op != GRN_OP_PUSH) {
        ERR(GRN_FUNCTION_NOT_IMPLEMENTED,
            "[expr][array-literal] "
            "complex expression in array literal isn't supported yet: <%.*s>",
            (int)(efsi->str_end - efsi->str),
            efsi->str);
        return;
      }
      if (!(grn_obj_is_number_family_bulk(ctx, code->value) ||
            grn_obj_maybe_record_bulk(ctx, code->value))) {
        uvector_domain = GRN_ID_NIL;
        break;
      }
      if (i == n_elements) {
        uvector_domain = code->value->header.domain;
      } else {
        if (uvector_domain != code->value->header.domain) {
          uvector_domain = GRN_ID_NIL;
          break;
        }
      }
    }

    grn_obj *array_literal;
    if (uvector_domain == GRN_ID_NIL) {
      array_literal = grn_obj_open(ctx, GRN_VECTOR, 0, GRN_ID_NIL);
    } else {
      array_literal = grn_obj_open(ctx, GRN_UVECTOR, 0, uvector_domain);
    }
    if (!array_literal) {
      ERR(GRN_NO_MEMORY_AVAILABLE,
          "[expr][array-literal] couldn't create vector: <%.*s>",
          (int)(efsi->str_end - efsi->str),
          efsi->str);
      return;
    }
    grn_expr_take_obj(ctx, efsi->e, array_literal);

    for (i = n_elements; i > 0; i--) {
      grn_expr_code *code = &(e->codes[e->codes_curr - i]);
      grn_obj *element = code->value;
      if (uvector_domain == GRN_ID_NIL) {
        grn_vector_add_element_float(ctx,
                                     array_literal,
                                     GRN_TEXT_VALUE(element),
                                     GRN_TEXT_LEN(element),
                                     0,
                                     element->header.domain);
      } else {
        grn_bulk_write(ctx, array_literal, GRN_BULK_HEAD(element), GRN_BULK_VSIZE(element));
      }
      if (ctx->rc != GRN_SUCCESS) {
        char message[GRN_CTX_MSGSIZE];
        grn_strncpy(message, sizeof(message), ctx->errbuf, sizeof(ctx->errbuf));
        ERR(ctx->rc,
            "[expr][array-literal] failed to add an element: %s",
            message);
        return;
      }
    }
    for (i = 0; i < n_elements; i++) {
      grn_expr_dfi_pop(e);
      e->codes_curr -= 1;
    }

    grn_expr_append_obj(ctx, efsi->e, array_literal, GRN_OP_PUSH, 1);
  }

  static void
  object_literal_end(efs_info *efsi, int n_properties)
  {
    grn_ctx *ctx = efsi->ctx;
    grn_hash *object_literal =
      grn_hash_create(ctx,
                      NULL,
                      GRN_TABLE_MAX_KEY_SIZE,
                      sizeof(grn_obj),
                      GRN_OBJ_KEY_VAR_SIZE|GRN_OBJ_TEMPORARY|GRN_HASH_TINY);
    if (!object_literal) {
      ERR(GRN_NO_MEMORY_AVAILABLE,
          "[expr][object-literal] couldn't create hash table: <%.*s>",
          (int)(efsi->str_end - efsi->str),
          efsi->str);
      return;
    }

    grn_expr_take_obj(ctx, efsi->e, (grn_obj *)(object_literal));
    DB_OBJ(object_literal)->header.domain = GRN_DB_SHORT_TEXT;

    grn_expr *e = (grn_expr *)(efsi->e);
    int i;
    for (i = n_properties; i > 0; i--) {
      int base = e->codes_curr - (i * 3);
      grn_obj *name = e->codes[base].value;
      grn_obj *value = e->codes[base + 2].value;

      grn_obj *buf;
      int added;
      grn_id id = grn_hash_add(ctx,
                               object_literal,
                               GRN_TEXT_VALUE(name),
                               GRN_TEXT_LEN(name),
                               (void **)(&buf),
                               &added);
      if (id == GRN_ID_NIL) {
        grn_rc rc = ctx->rc;
        if (rc == GRN_SUCCESS) {
          rc = GRN_NO_MEMORY_AVAILABLE;
        }
        ERR(rc,
            "[expr][object-literal] failed to add a property: <%.*s>",
            (int)GRN_TEXT_LEN(name),
            GRN_TEXT_VALUE(name));
        return;
      }

      if (!added) {
        ERR(GRN_INVALID_ARGUMENT,
            "[expr][object-literal] duplicated property name: <%.*s>",
            (int)GRN_TEXT_LEN(name),
            GRN_TEXT_VALUE(name));
        return;
      }

      switch (value->header.type) {
      case GRN_TABLE_HASH_KEY :
      case GRN_COLUMN_FIX_SIZE :
      case GRN_COLUMN_VAR_SIZE :
      case GRN_COLUMN_INDEX :
        GRN_OBJ_INIT(buf, GRN_PTR, 0, GRN_ID_NIL);
        GRN_PTR_SET(ctx, buf, value);
        break;
      case GRN_VECTOR :
        GRN_OBJ_INIT(buf, value->header.type, 0, value->header.domain);
        grn_vector_copy(ctx, value, buf);
        break;
      default :
        GRN_OBJ_INIT(buf, value->header.type, 0, value->header.domain);
        GRN_TEXT_PUT(ctx, buf, GRN_TEXT_VALUE(value), GRN_TEXT_LEN(value));
        break;
      }
    }
    for (i = 0; i < n_properties; i++) {
      grn_expr_dfi_pop(e);
      e->codes_curr -= 3;
    }
    grn_expr_append_obj(ctx, efsi->e, (grn_obj *)(object_literal),
                        GRN_OP_PUSH, 1);
  }
#line 196 "grn_ecmascript.c"
/**************** End of %include directives **********************************/
/* These constants specify the various numeric values for terminal symbols.
***************** Begin token definitions *************************************/
#ifndef GRN_EXPR_TOKEN_START_OUTPUT_COLUMNS
#define GRN_EXPR_TOKEN_START_OUTPUT_COLUMNS            1
#define GRN_EXPR_TOKEN_START_ADJUSTER                  2
#define GRN_EXPR_TOKEN_START_SORT_KEYS                 3
#define GRN_EXPR_TOKEN_START_OPTIONS                   4
#define GRN_EXPR_TOKEN_START_QUERY_NO_SYNTAX_ERROR     5
#define GRN_EXPR_TOKEN_LOGICAL_AND                     6
#define GRN_EXPR_TOKEN_LOGICAL_AND_NOT                 7
#define GRN_EXPR_TOKEN_LOGICAL_OR                      8
#define GRN_EXPR_TOKEN_NEGATIVE                        9
#define GRN_EXPR_TOKEN_QSTRING                        10
#define GRN_EXPR_TOKEN_PARENL                         11
#define GRN_EXPR_TOKEN_PARENR                         12
#define GRN_EXPR_TOKEN_ADJUST                         13
#define GRN_EXPR_TOKEN_RELATIVE_OP                    14
#define GRN_EXPR_TOKEN_IDENTIFIER                     15
#define GRN_EXPR_TOKEN_BRACEL                         16
#define GRN_EXPR_TOKEN_BRACER                         17
#define GRN_EXPR_TOKEN_EVAL                           18
#define GRN_EXPR_TOKEN_COMMA                          19
#define GRN_EXPR_TOKEN_ASSIGN                         20
#define GRN_EXPR_TOKEN_STAR_ASSIGN                    21
#define GRN_EXPR_TOKEN_SLASH_ASSIGN                   22
#define GRN_EXPR_TOKEN_MOD_ASSIGN                     23
#define GRN_EXPR_TOKEN_PLUS_ASSIGN                    24
#define GRN_EXPR_TOKEN_MINUS_ASSIGN                   25
#define GRN_EXPR_TOKEN_SHIFTL_ASSIGN                  26
#define GRN_EXPR_TOKEN_SHIFTR_ASSIGN                  27
#define GRN_EXPR_TOKEN_SHIFTRR_ASSIGN                 28
#define GRN_EXPR_TOKEN_AND_ASSIGN                     29
#define GRN_EXPR_TOKEN_XOR_ASSIGN                     30
#define GRN_EXPR_TOKEN_OR_ASSIGN                      31
#define GRN_EXPR_TOKEN_QUESTION                       32
#define GRN_EXPR_TOKEN_COLON                          33
#define GRN_EXPR_TOKEN_BITWISE_OR                     34
#define GRN_EXPR_TOKEN_BITWISE_XOR                    35
#define GRN_EXPR_TOKEN_BITWISE_AND                    36
#define GRN_EXPR_TOKEN_EQUAL                          37
#define GRN_EXPR_TOKEN_NOT_EQUAL                      38
#define GRN_EXPR_TOKEN_LESS                           39
#define GRN_EXPR_TOKEN_GREATER                        40
#define GRN_EXPR_TOKEN_LESS_EQUAL                     41
#define GRN_EXPR_TOKEN_GREATER_EQUAL                  42
#define GRN_EXPR_TOKEN_IN                             43
#define GRN_EXPR_TOKEN_MATCH                          44
#define GRN_EXPR_TOKEN_NEAR                           45
#define GRN_EXPR_TOKEN_NEAR_NO_OFFSET                 46
#define GRN_EXPR_TOKEN_NEAR_PHRASE                    47
#define GRN_EXPR_TOKEN_ORDERED_NEAR_PHRASE            48
#define GRN_EXPR_TOKEN_NEAR_PHRASE_PRODUCT            49
#define GRN_EXPR_TOKEN_ORDERED_NEAR_PHRASE_PRODUCT    50
#define GRN_EXPR_TOKEN_SIMILAR                        51
#define GRN_EXPR_TOKEN_TERM_EXTRACT                   52
#define GRN_EXPR_TOKEN_QUORUM                         53
#define GRN_EXPR_TOKEN_LCP                            54
#define GRN_EXPR_TOKEN_PREFIX                         55
#define GRN_EXPR_TOKEN_SUFFIX                         56
#define GRN_EXPR_TOKEN_REGEXP                         57
#define GRN_EXPR_TOKEN_SHIFTL                         58
#define GRN_EXPR_TOKEN_SHIFTR                         59
#define GRN_EXPR_TOKEN_SHIFTRR                        60
#define GRN_EXPR_TOKEN_PLUS                           61
#define GRN_EXPR_TOKEN_MINUS                          62
#define GRN_EXPR_TOKEN_STAR                           63
#define GRN_EXPR_TOKEN_SLASH                          64
#define GRN_EXPR_TOKEN_MOD                            65
#define GRN_EXPR_TOKEN_DELETE                         66
#define GRN_EXPR_TOKEN_INCR                           67
#define GRN_EXPR_TOKEN_DECR                           68
#define GRN_EXPR_TOKEN_NOT                            69
#define GRN_EXPR_TOKEN_BITWISE_NOT                    70
#define GRN_EXPR_TOKEN_EXACT                          71
#define GRN_EXPR_TOKEN_PARTIAL                        72
#define GRN_EXPR_TOKEN_UNSPLIT                        73
#define GRN_EXPR_TOKEN_DECIMAL                        74
#define GRN_EXPR_TOKEN_HEX_INTEGER                    75
#define GRN_EXPR_TOKEN_STRING                         76
#define GRN_EXPR_TOKEN_BOOLEAN                        77
#define GRN_EXPR_TOKEN_NULL                           78
#define GRN_EXPR_TOKEN_BRACKETL                       79
#define GRN_EXPR_TOKEN_BRACKETR                       80
#define GRN_EXPR_TOKEN_DOT                            81
#define GRN_EXPR_TOKEN_NONEXISTENT_COLUMN             82
#endif
/**************** End token definitions ***************************************/

/* The next sections is a series of control #defines.
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used to store the integer codes
**                       that represent terminal and non-terminal symbols.
**                       "unsigned char" is used if there are fewer than
**                       256 symbols.  Larger types otherwise.
**    YYNOCODE           is a number of type YYCODETYPE that is not used for
**                       any terminal or nonterminal symbol.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       (also known as: "terminal symbols") have fall-back
**                       values which should be used if the original symbol
**                       would not parse.  This permits keywords to sometimes
**                       be used as identifiers, for example.
**    YYACTIONTYPE       is the data type used for "action codes" - numbers
**                       that indicate what to do in response to the next
**                       token.
**    grn_expr_parserTOKENTYPE     is the data type used for minor type for terminal
**                       symbols.  Background: A "minor type" is a semantic
**                       value associated with a terminal or non-terminal
**                       symbols.  For example, for an "ID" terminal symbol,
**                       the minor type might be the name of the identifier.
**                       Each non-terminal can have a different minor type.
**                       Terminal symbols all have the same minor type, though.
**                       This macros defines the minor type for terminal 
**                       symbols.
**    YYMINORTYPE        is the data type used for all minor types.
**                       This is typically a union of many types, one of
**                       which is grn_expr_parserTOKENTYPE.  The entry in the union
**                       for terminal symbols is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    grn_expr_parserARG_SDECL     A static variable declaration for the %extra_argument
**    grn_expr_parserARG_PDECL     A parameter declaration for the %extra_argument
**    grn_expr_parserARG_PARAM     Code to pass %extra_argument as a subroutine parameter
**    grn_expr_parserARG_STORE     Code to store %extra_argument into yypParser
**    grn_expr_parserARG_FETCH     Code to extract %extra_argument from yypParser
**    grn_expr_parserCTX_*         As grn_expr_parserARG_ except for %extra_context
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYNTOKEN           Number of terminal symbols
**    YY_MAX_SHIFT       Maximum value for shift actions
**    YY_MIN_SHIFTREDUCE Minimum value for shift-reduce actions
**    YY_MAX_SHIFTREDUCE Maximum value for shift-reduce actions
**    YY_ERROR_ACTION    The yy_action[] code for syntax error
**    YY_ACCEPT_ACTION   The yy_action[] code for accept
**    YY_NO_ACTION       The yy_action[] code for no-op
**    YY_MIN_REDUCE      Minimum value for reduce actions
**    YY_MAX_REDUCE      Maximum value for reduce actions
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/************* Begin control #defines *****************************************/
#define YYCODETYPE unsigned char
#define YYNOCODE 122
#define YYACTIONTYPE unsigned short int
#define grn_expr_parserTOKENTYPE  int 
typedef union {
  int yyinit;
  grn_expr_parserTOKENTYPE yy0;
  void * yy181;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define grn_expr_parserARG_SDECL  efs_info *efsi ;
#define grn_expr_parserARG_PDECL , efs_info *efsi 
#define grn_expr_parserARG_PARAM ,efsi 
#define grn_expr_parserARG_FETCH  efs_info *efsi =yypParser->efsi ;
#define grn_expr_parserARG_STORE yypParser->efsi =efsi ;
#define grn_expr_parserCTX_SDECL
#define grn_expr_parserCTX_PDECL
#define grn_expr_parserCTX_PARAM
#define grn_expr_parserCTX_FETCH
#define grn_expr_parserCTX_STORE
#define YYNSTATE             166
#define YYNRULE              149
#define YYNRULE_WITH_ACTION  104
#define YYNTOKEN             83
#define YY_MAX_SHIFT         165
#define YY_MIN_SHIFTREDUCE   253
#define YY_MAX_SHIFTREDUCE   401
#define YY_ERROR_ACTION      402
#define YY_ACCEPT_ACTION     403
#define YY_NO_ACTION         404
#define YY_MIN_REDUCE        405
#define YY_MAX_REDUCE        553
/************* End control #defines *******************************************/
#define YY_NLOOKAHEAD ((int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])))

/* Define the yytestcase() macro to be a no-op if is not already defined
** otherwise.
**
** Applications can choose to define yytestcase() in the %include section
** to a macro that can assist in verifying code coverage.  For production
** code the yytestcase() macro should be turned off.  But it is useful
** for testing.
*/
#ifndef yytestcase
# define yytestcase(X)
#endif


/* Next are the tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N <= YY_MAX_SHIFT             Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   N between YY_MIN_SHIFTREDUCE       Shift to an arbitrary state then
**     and YY_MAX_SHIFTREDUCE           reduce by rule N-YY_MIN_SHIFTREDUCE.
**
**   N == YY_ERROR_ACTION               A syntax error has occurred.
**
**   N == YY_ACCEPT_ACTION              The parser accepts its input.
**
**   N == YY_NO_ACTION                  No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
**   N between YY_MIN_REDUCE            Reduce by rule N-YY_MIN_REDUCE
**     and YY_MAX_REDUCE
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as either:
**
**    (A)   N = yy_action[ yy_shift_ofst[S] + X ]
**    (B)   N = yy_default[S]
**
** The (A) formula is preferred.  The B formula is used instead if
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X.
**
** The formulas above are for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
**
*********** Begin parsing tables **********************************************/
#define YY_ACTTAB_COUNT (2027)
static const YYACTIONTYPE yy_action[] = {
 /*     0 */   405,    3,   81,    4,   98,   83,  133,  486,  157,  409,
 /*    10 */   366,    2,  408,   62,   94,  147,    1,   88,   80,  403,
 /*    20 */    90,  131,  332,   88,   87,   85,   90,   85,  131,  131,
 /*    30 */   102,  144,  104,  160,  159,  158,  139,   99,  121,  135,
 /*    40 */   122,  122,  122,  102,   85,  500,  152,   85,   97,   96,
 /*    50 */    92,   91,  366,   84,  367,   95,   94,  165,   11,  150,
 /*    60 */    80,   75,   74,  414,  513,  414,   78,   77,   76,   73,
 /*    70 */    72,   70,   69,   68,  391,  392,  393,  394,  395,    8,
 /*    80 */   145,  479,  538,    6,   85,  414,   85,  145,  145,  102,
 /*    90 */   144,  104,  160,  159,  158,  139,   99,  121,  135,  122,
 /*   100 */   122,  122,  102,   85,  487,  157,   85,   89,  133,  486,
 /*   110 */   157,  366,    2,   89,   62,   94,  147,    1,    9,   80,
 /*   120 */    89,  137,  389,   82,  397,   85,   89,   85,  137,  137,
 /*   130 */   102,  144,  104,  160,  159,  158,  139,   99,  121,  135,
 /*   140 */   122,  122,  122,  102,   85,  511,    9,   85,   71,  412,
 /*   150 */   389,   82,  366,   84,  411,   95,   94,  165,   11,  337,
 /*   160 */    80,  129,   75,   74,    5,   30,   23,   78,   77,   76,
 /*   170 */    73,   72,   70,   69,   68,  391,  392,  393,  394,  395,
 /*   180 */     8,  391,  392,  393,  394,  395,    8,   34,   33,   27,
 /*   190 */    31,  512,  129,  152,   32,  410,   75,   74,  345,   64,
 /*   200 */    63,   78,   77,   76,   73,   72,   70,   69,   68,  391,
 /*   210 */   392,  393,  394,  395,    8,  130,    7,  346,   85,   29,
 /*   220 */    85,  499,  499,  102,  144,  104,  160,  159,  158,  139,
 /*   230 */    99,  121,  135,  122,  122,  122,  102,   85,  388,    9,
 /*   240 */    85,   71,  407,  389,   82,   29,  494,   61,   60,   59,
 /*   250 */   128,   85,   86,   85,  508,  508,  102,  144,  104,  160,
 /*   260 */   159,  158,  139,   99,  121,  135,  122,  122,  122,  102,
 /*   270 */    85,   25,   82,   85,   79,   67,   66,   39,   38,  261,
 /*   280 */   336,   29,  504,  406,   10,  148,  156,  325,  326,   75,
 /*   290 */    65,  549,   93,  514,   78,   77,   76,   73,   72,   70,
 /*   300 */    69,   68,  391,  392,  393,  394,  395,    8,  350,   85,
 /*   310 */   354,   85,  499,  499,  102,  144,  104,  160,  159,  158,
 /*   320 */   139,   99,  121,  135,  122,  122,  122,  102,   85,  149,
 /*   330 */   151,   85,  328,  349,   35,  398,   24,  496,   37,   36,
 /*   340 */    26,   85,  404,   85,  508,  508,  102,  144,  104,  160,
 /*   350 */   159,  158,  139,   99,  121,  135,  122,  122,  122,  102,
 /*   360 */    85,  404,  404,   85,  404,  404,  404,  404,  404,  404,
 /*   370 */   404,  404,  505,   85,  510,   85,  491,  491,  102,  144,
 /*   380 */   104,  160,  159,  158,  139,   99,  121,  135,  122,  122,
 /*   390 */   122,  102,   85,   29,  404,   85,  404,  404,  404,  404,
 /*   400 */   132,   85,  404,   85,  482,  482,  102,  144,  104,  160,
 /*   410 */   159,  158,  139,   99,  121,  135,  122,  122,  122,  102,
 /*   420 */    85,  404,  404,   85,  134,  404,  404,  404,  137,  404,
 /*   430 */   404,  404,   85,  404,   85,  137,  137,  102,  144,  104,
 /*   440 */   160,  159,  158,  139,   99,  121,  135,  122,  122,  122,
 /*   450 */   102,   85,  404,  404,   85,  404,  404,  404,  404,  140,
 /*   460 */   404,  404,  404,   85,  404,   85,  140,  140,  102,  144,
 /*   470 */   104,  160,  159,  158,  139,   99,  121,  135,  122,  122,
 /*   480 */   122,  102,   85,  404,    9,   85,   71,  145,  389,   82,
 /*   490 */   404,   85,  404,   85,  145,  145,  102,  144,  104,  160,
 /*   500 */   159,  158,  139,   99,  121,  135,  122,  122,  122,  102,
 /*   510 */    85,  404,    9,   85,   71,  404,  389,   82,   28,   22,
 /*   520 */    21,   20,   19,   18,   17,   16,   15,   14,   13,   12,
 /*   530 */   404,  404,  404,  404,   75,   74,  404,  404,  404,   78,
 /*   540 */    77,   76,   73,   72,   70,   69,   68,  391,  392,  393,
 /*   550 */   394,  395,    8,  404,    9,  355,   71,  404,  389,   82,
 /*   560 */   404,  404,   75,   74,  404,  325,  326,   78,   77,   76,
 /*   570 */    73,   72,   70,   69,   68,  391,  392,  146,  394,  395,
 /*   580 */     8,  404,  404,  404,   85,  404,   85,  427,  427,  102,
 /*   590 */   144,  104,  160,  159,  158,  139,   99,  121,  135,  122,
 /*   600 */   122,  122,  102,   85,   75,   74,   85,  404,  404,   78,
 /*   610 */    77,   76,   73,   72,   70,   69,   68,  391,  392,  393,
 /*   620 */   394,  395,    8,  404,  404,   85,  404,   85,  426,  426,
 /*   630 */   102,  144,  104,  160,  159,  158,  139,   99,  121,  135,
 /*   640 */   122,  122,  122,  102,   85,  404,   85,   85,   85,  425,
 /*   650 */   425,  102,  144,  104,  160,  159,  158,  139,   99,  121,
 /*   660 */   135,  122,  122,  122,  102,   85,  404,   85,   85,   85,
 /*   670 */   424,  424,  102,  144,  104,  160,  159,  158,  139,   99,
 /*   680 */   121,  135,  122,  122,  122,  102,   85,  404,   85,   85,
 /*   690 */    85,  423,  423,  102,  144,  104,  160,  159,  158,  139,
 /*   700 */    99,  121,  135,  122,  122,  122,  102,   85,  404,   85,
 /*   710 */    85,   85,  422,  422,  102,  144,  104,  160,  159,  158,
 /*   720 */   139,   99,  121,  135,  122,  122,  122,  102,   85,  404,
 /*   730 */    85,   85,   85,  421,  421,  102,  144,  104,  160,  159,
 /*   740 */   158,  139,   99,  121,  135,  122,  122,  122,  102,   85,
 /*   750 */   404,   85,   85,   85,  420,  420,  102,  144,  104,  160,
 /*   760 */   159,  158,  139,   99,  121,  135,  122,  122,  122,  102,
 /*   770 */    85,  404,   85,   85,   85,  419,  419,  102,  144,  104,
 /*   780 */   160,  159,  158,  139,   99,  121,  135,  122,  122,  122,
 /*   790 */   102,   85,  404,   85,   85,   85,  418,  418,  102,  144,
 /*   800 */   104,  160,  159,  158,  139,   99,  121,  135,  122,  122,
 /*   810 */   122,  102,   85,  404,   85,   85,   85,  417,  417,  102,
 /*   820 */   144,  104,  160,  159,  158,  139,   99,  121,  135,  122,
 /*   830 */   122,  122,  102,   85,  404,   85,   85,   85,  492,  492,
 /*   840 */   102,  144,  104,  160,  159,  158,  139,   99,  121,  135,
 /*   850 */   122,  122,  122,  102,   85,  404,   85,   85,   85,  548,
 /*   860 */   548,  102,  144,  104,  160,  159,  158,  139,   99,  121,
 /*   870 */   135,  122,  122,  122,  102,   85,  404,   85,   85,   85,
 /*   880 */   483,  483,  102,  144,  104,  160,  159,  158,  139,   99,
 /*   890 */   121,  135,  122,  122,  122,  102,   85,  404,   85,   85,
 /*   900 */    85,  428,  428,  102,  144,  104,  160,  159,  158,  139,
 /*   910 */    99,  121,  135,  122,  122,  122,  102,   85,  404,   85,
 /*   920 */    85,   85,  164,  164,  102,  144,  104,  160,  159,  158,
 /*   930 */   139,   99,  121,  135,  122,  122,  122,  102,   85,  404,
 /*   940 */    85,   85,   85,  416,  416,  102,  144,  104,  160,  159,
 /*   950 */   158,  139,   99,  121,  135,  122,  122,  122,  102,   85,
 /*   960 */   404,   85,   85,   85,  415,  415,  102,  144,  104,  160,
 /*   970 */   159,  158,  139,   99,  121,  135,  122,  122,  122,  102,
 /*   980 */    85,  404,  404,   85,   58,   57,   56,   55,   54,   53,
 /*   990 */    52,   51,   50,   49,   48,   47,   46,   45,   44,   43,
 /*  1000 */    42,   41,   40,   85,  404,   85,  404,  404,  141,  404,
 /*  1010 */   103,  160,  159,  158,  139,   99,  121,  135,  122,  122,
 /*  1020 */   122,  141,   85,  404,   85,   85,   85,  404,  404,  141,
 /*  1030 */   404,  404,  153,  159,  158,  139,   99,  121,  135,  122,
 /*  1040 */   122,  122,  141,   85,  404,   85,   85,   85,  404,  404,
 /*  1050 */   141,  404,  404,  154,  159,  158,  139,   99,  121,  135,
 /*  1060 */   122,  122,  122,  141,   85,  404,   85,   85,   85,  404,
 /*  1070 */   404,  141,  404,  404,  155,  159,  158,  139,   99,  121,
 /*  1080 */   135,  122,  122,  122,  141,   85,  404,   85,   85,   85,
 /*  1090 */   404,  404,  141,  404,  404,  163,  159,  158,  139,   99,
 /*  1100 */   121,  135,  122,  122,  122,  141,   85,  404,   85,   85,
 /*  1110 */    85,  404,  404,  141,  404,  404,  404,  162,  158,  139,
 /*  1120 */    99,  121,  135,  122,  122,  122,  141,   85,  404,   85,
 /*  1130 */    85,   85,  404,  404,  141,  404,  404,  404,  404,  161,
 /*  1140 */   139,   99,  121,  135,  122,  122,  122,  141,   85,  404,
 /*  1150 */    85,   85,   85,  404,  404,  141,  404,  404,  404,  404,
 /*  1160 */   404,  143,   99,  121,  135,  122,  122,  122,  141,   85,
 /*  1170 */   404,   85,   85,   85,  404,  404,  141,  404,  404,  404,
 /*  1180 */   404,  404,  404,  100,  121,  135,  122,  122,  122,  141,
 /*  1190 */    85,  404,   85,   85,   85,  404,  404,  141,  404,  404,
 /*  1200 */   404,  404,  404,  404,  101,  121,  135,  122,  122,  122,
 /*  1210 */   141,   85,  516,  404,   85,  404,  404,  404,   97,   96,
 /*  1220 */    92,   91,  366,   84,  404,   95,   94,  165,   11,  509,
 /*  1230 */    80,  404,  404,  404,  404,   97,   96,   92,   91,  366,
 /*  1240 */    84,  404,   95,   94,  165,   11,   85,   80,   85,  404,
 /*  1250 */   404,  141,  404,  404,  404,  404,  404,  404,  404,  105,
 /*  1260 */   135,  122,  122,  122,  141,   85,  404,   85,   85,   85,
 /*  1270 */   404,  404,  141,  404,  404,  404,  404,  404,  404,  404,
 /*  1280 */   106,  135,  122,  122,  122,  141,   85,  404,   85,   85,
 /*  1290 */    85,  404,  404,  141,  404,  404,  404,  404,  404,  404,
 /*  1300 */   404,  107,  135,  122,  122,  122,  141,   85,  404,   85,
 /*  1310 */    85,   85,  404,  404,  141,  404,  404,  404,  404,  404,
 /*  1320 */   404,  404,  108,  135,  122,  122,  122,  141,   85,  404,
 /*  1330 */    85,   85,   85,  404,  404,  141,  404,  404,  404,  404,
 /*  1340 */   404,  404,  404,  109,  135,  122,  122,  122,  141,   85,
 /*  1350 */   404,   85,   85,   85,  404,  404,  141,  404,  404,  404,
 /*  1360 */   404,  404,  404,  404,  110,  135,  122,  122,  122,  141,
 /*  1370 */    85,  404,   85,   85,   85,  404,  404,  141,  404,  404,
 /*  1380 */   404,  404,  404,  404,  404,  111,  135,  122,  122,  122,
 /*  1390 */   141,   85,  404,   85,   85,   85,  404,  404,  141,  404,
 /*  1400 */   404,  404,  404,  404,  404,  404,  112,  135,  122,  122,
 /*  1410 */   122,  141,   85,  404,   85,   85,   85,  404,  404,  141,
 /*  1420 */   404,  404,  404,  404,  404,  404,  404,  113,  135,  122,
 /*  1430 */   122,  122,  141,   85,  404,   85,   85,   85,  404,  404,
 /*  1440 */   141,  404,  404,  404,  404,  404,  404,  404,  114,  135,
 /*  1450 */   122,  122,  122,  141,   85,  404,   85,   85,   85,  404,
 /*  1460 */   404,  141,  404,  404,  404,  404,  404,  404,  404,  115,
 /*  1470 */   135,  122,  122,  122,  141,   85,  404,   85,   85,   85,
 /*  1480 */   404,  404,  141,  404,  404,  404,  404,  404,  404,  404,
 /*  1490 */   116,  135,  122,  122,  122,  141,   85,  404,   85,   85,
 /*  1500 */    85,  404,  404,  141,  404,  404,  404,  404,  404,  404,
 /*  1510 */   404,  117,  135,  122,  122,  122,  141,   85,  404,   85,
 /*  1520 */    85,   85,  404,  404,  141,  404,  404,  404,  404,  404,
 /*  1530 */   404,  404,  118,  135,  122,  122,  122,  141,   85,  404,
 /*  1540 */    85,   85,   85,  404,  404,  141,  404,  404,  404,  404,
 /*  1550 */   404,  404,  404,  119,  135,  122,  122,  122,  141,   85,
 /*  1560 */   404,   85,   85,   85,  404,  404,  141,  404,  404,  404,
 /*  1570 */   404,  404,  404,  404,  120,  135,  122,  122,  122,  141,
 /*  1580 */    85,  404,   85,   85,   85,  404,  404,  141,  404,  404,
 /*  1590 */   404,  404,  404,  404,  404,  123,  135,  122,  122,  122,
 /*  1600 */   141,   85,  404,   85,   85,   85,  404,  404,  141,  404,
 /*  1610 */   404,  404,  404,  404,  404,  404,  125,  135,  122,  122,
 /*  1620 */   122,  141,   85,  404,   85,   85,   85,  404,  404,  141,
 /*  1630 */   404,  404,  404,  404,  404,  404,  404,  127,  135,  122,
 /*  1640 */   122,  122,  141,   85,  404,   85,   85,   85,  404,  404,
 /*  1650 */   141,  404,  404,  404,  404,  404,  404,  404,  404,  136,
 /*  1660 */   122,  122,  122,  141,   85,  404,   85,   85,   85,  404,
 /*  1670 */   404,  141,  404,  404,  404,  404,  404,  404,  404,  404,
 /*  1680 */   138,  122,  122,  122,  141,   85,  404,   85,   85,   85,
 /*  1690 */   404,  404,  141,  404,   85,  410,   85,  404,  404,  141,
 /*  1700 */   404,  142,  122,  122,  122,  141,   85,  404,  404,   85,
 /*  1710 */   473,  473,  141,   85,  404,   85,   85,   85,  404,  404,
 /*  1720 */   141,  404,  404,  404,  404,  404,  404,  404,  404,  404,
 /*  1730 */   124,  124,  124,  141,   85,  404,   85,   85,   85,  404,
 /*  1740 */   404,  141,  404,  404,  404,  404,  404,  404,  404,  404,
 /*  1750 */   404,  126,  126,  126,  141,   85,  404,   85,   85,   85,
 /*  1760 */   404,  404,  141,  404,  404,  404,  404,  404,  404,  404,
 /*  1770 */   404,  404,  404,  470,  470,  141,   85,  404,   85,   85,
 /*  1780 */    85,  404,  404,  141,  404,   85,  404,   85,  404,  404,
 /*  1790 */   141,  404,  404,  404,  465,  465,  141,   85,  404,  404,
 /*  1800 */    85,  464,  464,  141,   85,  404,   85,   85,   85,  404,
 /*  1810 */   404,  141,  404,  404,  404,  404,  404,  404,  404,  404,
 /*  1820 */   404,  404,  476,  476,  141,   85,  404,   85,   85,   85,
 /*  1830 */   404,  404,  141,  404,  404,  404,  404,  404,  404,  404,
 /*  1840 */   404,  404,  404,  475,  475,  141,   85,  404,   85,   85,
 /*  1850 */    85,  404,  404,  141,  404,  404,  404,  404,  404,  404,
 /*  1860 */   404,  404,  404,  404,  474,  474,  141,   85,  404,   85,
 /*  1870 */    85,   85,  404,  404,  141,  404,   85,  404,   85,  404,
 /*  1880 */   404,  141,  404,  404,  404,  473,  473,  141,   85,  404,
 /*  1890 */   404,   85,  472,  472,  141,   85,  404,   85,   85,   85,
 /*  1900 */   404,  404,  141,  404,  404,  404,  404,  404,  404,  404,
 /*  1910 */   404,  404,  404,  471,  471,  141,   85,  404,   85,   85,
 /*  1920 */    85,  404,  404,  141,  404,  404,  404,  404,  404,  404,
 /*  1930 */   404,  404,  404,  404,  469,  469,  141,   85,  404,   85,
 /*  1940 */    85,   85,  404,  404,  141,  404,  404,  404,  404,  404,
 /*  1950 */   404,  404,  404,  404,  404,  468,  468,  141,   85,  404,
 /*  1960 */    85,   85,   85,  404,  404,  141,  404,   85,  404,   85,
 /*  1970 */   404,  404,  141,  404,  404,  404,  467,  467,  141,   85,
 /*  1980 */   404,  404,   85,  466,  466,  141,   85,  404,   85,   85,
 /*  1990 */    85,  404,  404,  141,  404,  404,  404,  404,  404,  404,
 /*  2000 */   404,  404,  404,  404,  463,  463,  141,   85,  515,  404,
 /*  2010 */    85,  404,  404,  404,  404,  404,  404,  404,  366,   84,
 /*  2020 */   404,   95,   94,  165,   11,  404,   80,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */    91,    1,    2,    3,    4,    5,  114,  115,  116,   91,
 /*    10 */    10,   11,   91,   13,   14,   15,   16,   85,   18,   84,
 /*    20 */    85,   86,   17,   91,   19,   90,   91,   92,   93,   94,
 /*    30 */    95,   96,   97,   98,   99,  100,  101,  102,  103,  104,
 /*    40 */   105,  106,  107,  108,  109,  119,  120,  112,    6,    7,
 /*    50 */     8,    9,   10,   11,   12,   13,   14,   15,   16,   15,
 /*    60 */    18,   61,   62,   90,    0,   92,   66,   67,   68,   69,
 /*    70 */    70,   71,   72,   73,   74,   75,   76,   77,   78,   79,
 /*    80 */    86,  110,  111,   19,   90,  112,   92,   93,   94,   95,
 /*    90 */    96,   97,   98,   99,  100,  101,  102,  103,  104,  105,
 /*   100 */   106,  107,  108,  109,  115,  116,  112,   85,  114,  115,
 /*   110 */   116,   10,   11,   91,   13,   14,   15,   16,   11,   18,
 /*   120 */    85,   86,   15,   16,   76,   90,   91,   92,   93,   94,
 /*   130 */    95,   96,   97,   98,   99,  100,  101,  102,  103,  104,
 /*   140 */   105,  106,  107,  108,  109,    0,   11,  112,   13,   91,
 /*   150 */    15,   16,   10,   11,   91,   13,   14,   15,   16,   12,
 /*   160 */    18,   88,   61,   62,   19,    8,   19,   66,   67,   68,
 /*   170 */    69,   70,   71,   72,   73,   74,   75,   76,   77,   78,
 /*   180 */    79,   74,   75,   76,   77,   78,   79,    6,    7,   32,
 /*   190 */     9,    0,  119,  120,   13,   91,   61,   62,   63,   61,
 /*   200 */    62,   66,   67,   68,   69,   70,   71,   72,   73,   74,
 /*   210 */    75,   76,   77,   78,   79,   87,   11,   82,   90,   19,
 /*   220 */    92,   93,   94,   95,   96,   97,   98,   99,  100,  101,
 /*   230 */   102,  103,  104,  105,  106,  107,  108,  109,   12,   11,
 /*   240 */   112,   13,   91,   15,   16,   19,  118,   58,   59,   60,
 /*   250 */    89,   90,   61,   92,   93,   94,   95,   96,   97,   98,
 /*   260 */    99,  100,  101,  102,  103,  104,  105,  106,  107,  108,
 /*   270 */   109,   19,   16,  112,   63,   64,   65,   37,   38,   17,
 /*   280 */    80,   19,  121,   91,   79,   90,   81,   67,   68,   61,
 /*   290 */    62,   33,   14,    0,   66,   67,   68,   69,   70,   71,
 /*   300 */    72,   73,   74,   75,   76,   77,   78,   79,   76,   90,
 /*   310 */    82,   92,   93,   94,   95,   96,   97,   98,   99,  100,
 /*   320 */   101,  102,  103,  104,  105,  106,  107,  108,  109,   44,
 /*   330 */    63,  112,   80,   74,   34,   15,   33,  118,   36,   35,
 /*   340 */    33,   90,  122,   92,   93,   94,   95,   96,   97,   98,
 /*   350 */    99,  100,  101,  102,  103,  104,  105,  106,  107,  108,
 /*   360 */   109,  122,  122,  112,  122,  122,  122,  122,  122,  122,
 /*   370 */   122,  122,  121,   90,    0,   92,   93,   94,   95,   96,
 /*   380 */    97,   98,   99,  100,  101,  102,  103,  104,  105,  106,
 /*   390 */   107,  108,  109,   19,  122,  112,  122,  122,  122,  122,
 /*   400 */   117,   90,  122,   92,   93,   94,   95,   96,   97,   98,
 /*   410 */    99,  100,  101,  102,  103,  104,  105,  106,  107,  108,
 /*   420 */   109,  122,  122,  112,  113,  122,  122,  122,   86,  122,
 /*   430 */   122,  122,   90,  122,   92,   93,   94,   95,   96,   97,
 /*   440 */    98,   99,  100,  101,  102,  103,  104,  105,  106,  107,
 /*   450 */   108,  109,  122,  122,  112,  122,  122,  122,  122,   86,
 /*   460 */   122,  122,  122,   90,  122,   92,   93,   94,   95,   96,
 /*   470 */    97,   98,   99,  100,  101,  102,  103,  104,  105,  106,
 /*   480 */   107,  108,  109,  122,   11,  112,   13,   86,   15,   16,
 /*   490 */   122,   90,  122,   92,   93,   94,   95,   96,   97,   98,
 /*   500 */    99,  100,  101,  102,  103,  104,  105,  106,  107,  108,
 /*   510 */   109,  122,   11,  112,   13,  122,   15,   16,   20,   21,
 /*   520 */    22,   23,   24,   25,   26,   27,   28,   29,   30,   31,
 /*   530 */   122,  122,  122,  122,   61,   62,  122,  122,  122,   66,
 /*   540 */    67,   68,   69,   70,   71,   72,   73,   74,   75,   76,
 /*   550 */    77,   78,   79,  122,   11,   82,   13,  122,   15,   16,
 /*   560 */   122,  122,   61,   62,  122,   67,   68,   66,   67,   68,
 /*   570 */    69,   70,   71,   72,   73,   74,   75,   76,   77,   78,
 /*   580 */    79,  122,  122,  122,   90,  122,   92,   93,   94,   95,
 /*   590 */    96,   97,   98,   99,  100,  101,  102,  103,  104,  105,
 /*   600 */   106,  107,  108,  109,   61,   62,  112,  122,  122,   66,
 /*   610 */    67,   68,   69,   70,   71,   72,   73,   74,   75,   76,
 /*   620 */    77,   78,   79,  122,  122,   90,  122,   92,   93,   94,
 /*   630 */    95,   96,   97,   98,   99,  100,  101,  102,  103,  104,
 /*   640 */   105,  106,  107,  108,  109,  122,   90,  112,   92,   93,
 /*   650 */    94,   95,   96,   97,   98,   99,  100,  101,  102,  103,
 /*   660 */   104,  105,  106,  107,  108,  109,  122,   90,  112,   92,
 /*   670 */    93,   94,   95,   96,   97,   98,   99,  100,  101,  102,
 /*   680 */   103,  104,  105,  106,  107,  108,  109,  122,   90,  112,
 /*   690 */    92,   93,   94,   95,   96,   97,   98,   99,  100,  101,
 /*   700 */   102,  103,  104,  105,  106,  107,  108,  109,  122,   90,
 /*   710 */   112,   92,   93,   94,   95,   96,   97,   98,   99,  100,
 /*   720 */   101,  102,  103,  104,  105,  106,  107,  108,  109,  122,
 /*   730 */    90,  112,   92,   93,   94,   95,   96,   97,   98,   99,
 /*   740 */   100,  101,  102,  103,  104,  105,  106,  107,  108,  109,
 /*   750 */   122,   90,  112,   92,   93,   94,   95,   96,   97,   98,
 /*   760 */    99,  100,  101,  102,  103,  104,  105,  106,  107,  108,
 /*   770 */   109,  122,   90,  112,   92,   93,   94,   95,   96,   97,
 /*   780 */    98,   99,  100,  101,  102,  103,  104,  105,  106,  107,
 /*   790 */   108,  109,  122,   90,  112,   92,   93,   94,   95,   96,
 /*   800 */    97,   98,   99,  100,  101,  102,  103,  104,  105,  106,
 /*   810 */   107,  108,  109,  122,   90,  112,   92,   93,   94,   95,
 /*   820 */    96,   97,   98,   99,  100,  101,  102,  103,  104,  105,
 /*   830 */   106,  107,  108,  109,  122,   90,  112,   92,   93,   94,
 /*   840 */    95,   96,   97,   98,   99,  100,  101,  102,  103,  104,
 /*   850 */   105,  106,  107,  108,  109,  122,   90,  112,   92,   93,
 /*   860 */    94,   95,   96,   97,   98,   99,  100,  101,  102,  103,
 /*   870 */   104,  105,  106,  107,  108,  109,  122,   90,  112,   92,
 /*   880 */    93,   94,   95,   96,   97,   98,   99,  100,  101,  102,
 /*   890 */   103,  104,  105,  106,  107,  108,  109,  122,   90,  112,
 /*   900 */    92,   93,   94,   95,   96,   97,   98,   99,  100,  101,
 /*   910 */   102,  103,  104,  105,  106,  107,  108,  109,  122,   90,
 /*   920 */   112,   92,   93,   94,   95,   96,   97,   98,   99,  100,
 /*   930 */   101,  102,  103,  104,  105,  106,  107,  108,  109,  122,
 /*   940 */    90,  112,   92,   93,   94,   95,   96,   97,   98,   99,
 /*   950 */   100,  101,  102,  103,  104,  105,  106,  107,  108,  109,
 /*   960 */   122,   90,  112,   92,   93,   94,   95,   96,   97,   98,
 /*   970 */    99,  100,  101,  102,  103,  104,  105,  106,  107,  108,
 /*   980 */   109,  122,  122,  112,   39,   40,   41,   42,   43,   44,
 /*   990 */    45,   46,   47,   48,   49,   50,   51,   52,   53,   54,
 /*  1000 */    55,   56,   57,   90,  122,   92,  122,  122,   95,  122,
 /*  1010 */    97,   98,   99,  100,  101,  102,  103,  104,  105,  106,
 /*  1020 */   107,  108,  109,  122,   90,  112,   92,  122,  122,   95,
 /*  1030 */   122,  122,   98,   99,  100,  101,  102,  103,  104,  105,
 /*  1040 */   106,  107,  108,  109,  122,   90,  112,   92,  122,  122,
 /*  1050 */    95,  122,  122,   98,   99,  100,  101,  102,  103,  104,
 /*  1060 */   105,  106,  107,  108,  109,  122,   90,  112,   92,  122,
 /*  1070 */   122,   95,  122,  122,   98,   99,  100,  101,  102,  103,
 /*  1080 */   104,  105,  106,  107,  108,  109,  122,   90,  112,   92,
 /*  1090 */   122,  122,   95,  122,  122,   98,   99,  100,  101,  102,
 /*  1100 */   103,  104,  105,  106,  107,  108,  109,  122,   90,  112,
 /*  1110 */    92,  122,  122,   95,  122,  122,  122,   99,  100,  101,
 /*  1120 */   102,  103,  104,  105,  106,  107,  108,  109,  122,   90,
 /*  1130 */   112,   92,  122,  122,   95,  122,  122,  122,  122,  100,
 /*  1140 */   101,  102,  103,  104,  105,  106,  107,  108,  109,  122,
 /*  1150 */    90,  112,   92,  122,  122,   95,  122,  122,  122,  122,
 /*  1160 */   122,  101,  102,  103,  104,  105,  106,  107,  108,  109,
 /*  1170 */   122,   90,  112,   92,  122,  122,   95,  122,  122,  122,
 /*  1180 */   122,  122,  122,  102,  103,  104,  105,  106,  107,  108,
 /*  1190 */   109,  122,   90,  112,   92,  122,  122,   95,  122,  122,
 /*  1200 */   122,  122,  122,  122,  102,  103,  104,  105,  106,  107,
 /*  1210 */   108,  109,    0,  122,  112,  122,  122,  122,    6,    7,
 /*  1220 */     8,    9,   10,   11,  122,   13,   14,   15,   16,    0,
 /*  1230 */    18,  122,  122,  122,  122,    6,    7,    8,    9,   10,
 /*  1240 */    11,  122,   13,   14,   15,   16,   90,   18,   92,  122,
 /*  1250 */   122,   95,  122,  122,  122,  122,  122,  122,  122,  103,
 /*  1260 */   104,  105,  106,  107,  108,  109,  122,   90,  112,   92,
 /*  1270 */   122,  122,   95,  122,  122,  122,  122,  122,  122,  122,
 /*  1280 */   103,  104,  105,  106,  107,  108,  109,  122,   90,  112,
 /*  1290 */    92,  122,  122,   95,  122,  122,  122,  122,  122,  122,
 /*  1300 */   122,  103,  104,  105,  106,  107,  108,  109,  122,   90,
 /*  1310 */   112,   92,  122,  122,   95,  122,  122,  122,  122,  122,
 /*  1320 */   122,  122,  103,  104,  105,  106,  107,  108,  109,  122,
 /*  1330 */    90,  112,   92,  122,  122,   95,  122,  122,  122,  122,
 /*  1340 */   122,  122,  122,  103,  104,  105,  106,  107,  108,  109,
 /*  1350 */   122,   90,  112,   92,  122,  122,   95,  122,  122,  122,
 /*  1360 */   122,  122,  122,  122,  103,  104,  105,  106,  107,  108,
 /*  1370 */   109,  122,   90,  112,   92,  122,  122,   95,  122,  122,
 /*  1380 */   122,  122,  122,  122,  122,  103,  104,  105,  106,  107,
 /*  1390 */   108,  109,  122,   90,  112,   92,  122,  122,   95,  122,
 /*  1400 */   122,  122,  122,  122,  122,  122,  103,  104,  105,  106,
 /*  1410 */   107,  108,  109,  122,   90,  112,   92,  122,  122,   95,
 /*  1420 */   122,  122,  122,  122,  122,  122,  122,  103,  104,  105,
 /*  1430 */   106,  107,  108,  109,  122,   90,  112,   92,  122,  122,
 /*  1440 */    95,  122,  122,  122,  122,  122,  122,  122,  103,  104,
 /*  1450 */   105,  106,  107,  108,  109,  122,   90,  112,   92,  122,
 /*  1460 */   122,   95,  122,  122,  122,  122,  122,  122,  122,  103,
 /*  1470 */   104,  105,  106,  107,  108,  109,  122,   90,  112,   92,
 /*  1480 */   122,  122,   95,  122,  122,  122,  122,  122,  122,  122,
 /*  1490 */   103,  104,  105,  106,  107,  108,  109,  122,   90,  112,
 /*  1500 */    92,  122,  122,   95,  122,  122,  122,  122,  122,  122,
 /*  1510 */   122,  103,  104,  105,  106,  107,  108,  109,  122,   90,
 /*  1520 */   112,   92,  122,  122,   95,  122,  122,  122,  122,  122,
 /*  1530 */   122,  122,  103,  104,  105,  106,  107,  108,  109,  122,
 /*  1540 */    90,  112,   92,  122,  122,   95,  122,  122,  122,  122,
 /*  1550 */   122,  122,  122,  103,  104,  105,  106,  107,  108,  109,
 /*  1560 */   122,   90,  112,   92,  122,  122,   95,  122,  122,  122,
 /*  1570 */   122,  122,  122,  122,  103,  104,  105,  106,  107,  108,
 /*  1580 */   109,  122,   90,  112,   92,  122,  122,   95,  122,  122,
 /*  1590 */   122,  122,  122,  122,  122,  103,  104,  105,  106,  107,
 /*  1600 */   108,  109,  122,   90,  112,   92,  122,  122,   95,  122,
 /*  1610 */   122,  122,  122,  122,  122,  122,  103,  104,  105,  106,
 /*  1620 */   107,  108,  109,  122,   90,  112,   92,  122,  122,   95,
 /*  1630 */   122,  122,  122,  122,  122,  122,  122,  103,  104,  105,
 /*  1640 */   106,  107,  108,  109,  122,   90,  112,   92,  122,  122,
 /*  1650 */    95,  122,  122,  122,  122,  122,  122,  122,  122,  104,
 /*  1660 */   105,  106,  107,  108,  109,  122,   90,  112,   92,  122,
 /*  1670 */   122,   95,  122,  122,  122,  122,  122,  122,  122,  122,
 /*  1680 */   104,  105,  106,  107,  108,  109,  122,   90,  112,   92,
 /*  1690 */   122,  122,   95,  122,   90,   91,   92,  122,  122,   95,
 /*  1700 */   122,  104,  105,  106,  107,  108,  109,  122,  122,  112,
 /*  1710 */   106,  107,  108,  109,  122,   90,  112,   92,  122,  122,
 /*  1720 */    95,  122,  122,  122,  122,  122,  122,  122,  122,  122,
 /*  1730 */   105,  106,  107,  108,  109,  122,   90,  112,   92,  122,
 /*  1740 */   122,   95,  122,  122,  122,  122,  122,  122,  122,  122,
 /*  1750 */   122,  105,  106,  107,  108,  109,  122,   90,  112,   92,
 /*  1760 */   122,  122,   95,  122,  122,  122,  122,  122,  122,  122,
 /*  1770 */   122,  122,  122,  106,  107,  108,  109,  122,   90,  112,
 /*  1780 */    92,  122,  122,   95,  122,   90,  122,   92,  122,  122,
 /*  1790 */    95,  122,  122,  122,  106,  107,  108,  109,  122,  122,
 /*  1800 */   112,  106,  107,  108,  109,  122,   90,  112,   92,  122,
 /*  1810 */   122,   95,  122,  122,  122,  122,  122,  122,  122,  122,
 /*  1820 */   122,  122,  106,  107,  108,  109,  122,   90,  112,   92,
 /*  1830 */   122,  122,   95,  122,  122,  122,  122,  122,  122,  122,
 /*  1840 */   122,  122,  122,  106,  107,  108,  109,  122,   90,  112,
 /*  1850 */    92,  122,  122,   95,  122,  122,  122,  122,  122,  122,
 /*  1860 */   122,  122,  122,  122,  106,  107,  108,  109,  122,   90,
 /*  1870 */   112,   92,  122,  122,   95,  122,   90,  122,   92,  122,
 /*  1880 */   122,   95,  122,  122,  122,  106,  107,  108,  109,  122,
 /*  1890 */   122,  112,  106,  107,  108,  109,  122,   90,  112,   92,
 /*  1900 */   122,  122,   95,  122,  122,  122,  122,  122,  122,  122,
 /*  1910 */   122,  122,  122,  106,  107,  108,  109,  122,   90,  112,
 /*  1920 */    92,  122,  122,   95,  122,  122,  122,  122,  122,  122,
 /*  1930 */   122,  122,  122,  122,  106,  107,  108,  109,  122,   90,
 /*  1940 */   112,   92,  122,  122,   95,  122,  122,  122,  122,  122,
 /*  1950 */   122,  122,  122,  122,  122,  106,  107,  108,  109,  122,
 /*  1960 */    90,  112,   92,  122,  122,   95,  122,   90,  122,   92,
 /*  1970 */   122,  122,   95,  122,  122,  122,  106,  107,  108,  109,
 /*  1980 */   122,  122,  112,  106,  107,  108,  109,  122,   90,  112,
 /*  1990 */    92,  122,  122,   95,  122,  122,  122,  122,  122,  122,
 /*  2000 */   122,  122,  122,  122,  106,  107,  108,  109,    0,  122,
 /*  2010 */   112,  122,  122,  122,  122,  122,  122,  122,   10,   11,
 /*  2020 */   122,   13,   14,   15,   16,  122,   18,  122,  122,  122,
 /*  2030 */   122,  122,  122,  122,  122,  122,  122,  122,  122,  122,
 /*  2040 */   122,  122,  122,  122,  122,  122,  122,  122,  122,  122,
 /*  2050 */   122,  122,  122,  122,  122,  122,  122,  122,  122,  122,
 /*  2060 */   122,  122,  122,  122,  122,  122,  122,  122,  122,  122,
 /*  2070 */   122,  122,  122,  122,  122,  122,  122,  122,  122,  122,
 /*  2080 */   122,  122,  122,  122,  122,  122,  122,  122,  122,  122,
 /*  2090 */   122,  122,   83,   83,   83,   83,   83,   83,   83,   83,
 /*  2100 */    83,   83,   83,   83,   83,   83,   83,   83,   83,   83,
};
#define YY_SHIFT_COUNT    (165)
#define YY_SHIFT_MIN      (0)
#define YY_SHIFT_MAX      (2008)
static const unsigned short int yy_shift_ofst[] = {
 /*     0 */     0,  501,  101,  135,  228,  135,  228,  543,  543,  543,
 /*    10 */   543,  543,  543,  543,  543,  543,  543,  543,  543,  543,
 /*    20 */   543,  543,  543,  543,  543,  543,  543,  543,  543,  543,
 /*    30 */   543,  543,  543,  543,  543,  543,  543,  543,  543,  543,
 /*    40 */   543,  543,  543,  543,  543,  543,  543,  543,  543,  543,
 /*    50 */   543,  543,  543,  543,  543,  543,  543,  543,  543,  543,
 /*    60 */   543,  543,  101,  543,  543,  473,  543,  543,  543,  543,
 /*    70 */   543,  543,  543,  543,  543,  543,  543,  543,  543,  543,
 /*    80 */   107,   44,   48, 2008,  142,  205,   44,   48, 1212,   42,
 /*    90 */  1229,  142,  142,  142,  142,  142,  142,  142,  256,  945,
 /*   100 */   945,  945,  498,  181,  181,  189,  189,  189,  189,  189,
 /*   110 */   189,  189,  189,  189,  189,  189,  189,  189,  189,  189,
 /*   120 */   189,  189,  211,  189,  211,  189,  211,  189,   64,  191,
 /*   130 */   145,  374,  147,    5,  252,  138,  138,  226,  138,  240,
 /*   140 */   200,  220,  138,  240,  157,  262,  258,  278,  293,  232,
 /*   150 */   285,  259,  267,  300,  300,  300,  320,  303,  302,  304,
 /*   160 */   300,  302,  304,  300,  307,  278,
};
#define YY_REDUCE_COUNT (98)
#define YY_REDUCE_MIN   (-108)
#define YY_REDUCE_MAX   (1898)
static const short yy_reduce_ofst[] = {
 /*     0 */   -65,   -6,   35,  128,  161,  219,  251,  283,  311,  342,
 /*    10 */   373,  401,  494,  535,  556,  577,  598,  619,  640,  661,
 /*    20 */   682,  703,  724,  745,  766,  787,  808,  829,  850,  871,
 /*    30 */   913,  934,  955,  976,  997, 1018, 1039, 1060, 1081, 1102,
 /*    40 */  1156, 1177, 1198, 1219, 1240, 1261, 1282, 1303, 1324, 1345,
 /*    50 */  1366, 1387, 1408, 1429, 1450, 1471, 1492, 1513, 1534, 1555,
 /*    60 */  1576, 1597, 1604, 1625, 1646, 1667, 1688, 1695, 1716, 1737,
 /*    70 */  1758, 1779, 1786, 1807, 1667, 1828, 1849, 1870, 1877, 1898,
 /*    80 */   -27,   73, -108,  -68,   22,  -29,  -74,  -11,  -91,  -91,
 /*    90 */   -91,  -82,  -79,   58,   63,  104,  151,  192,  195,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */   402,  485,  402,  493,  503,  495,  402,  490,  481,  402,
 /*    10 */   402,  402,  402,  402,  402,  402,  402,  402,  402,  402,
 /*    20 */   402,  402,  402,  402,  402,  402,  402,  402,  402,  402,
 /*    30 */   402,  402,  402,  402,  402,  402,  402,  402,  402,  402,
 /*    40 */   402,  402,  402,  402,  402,  402,  402,  402,  402,  402,
 /*    50 */   402,  402,  402,  402,  402,  402,  402,  402,  402,  402,
 /*    60 */   402,  402,  402,  402,  402,  402,  402,  402,  402,  402,
 /*    70 */   402,  402,  402,  402,  402,  402,  402,  402,  402,  402,
 /*    80 */   402,  551,  485,  402,  402,  536,  402,  402,  402,  402,
 /*    90 */   402,  402,  402,  402,  402,  402,  402,  402,  402,  528,
 /*   100 */   438,  437,  534,  429,  523,  457,  456,  455,  454,  453,
 /*   110 */   452,  451,  450,  449,  448,  447,  446,  445,  444,  443,
 /*   120 */   442,  529,  531,  441,  462,  440,  461,  439,  402,  402,
 /*   130 */   402,  402,  402,  402,  402,  530,  460,  402,  459,  527,
 /*   140 */   402,  534,  458,  436,  522,  402,  545,  541,  402,  402,
 /*   150 */   402,  402,  553,  433,  432,  431,  402,  402,  526,  525,
 /*   160 */   524,  435,  434,  430,  402,  402,
};
/********** End of lemon-generated parsing tables *****************************/

/* The next table maps tokens (terminal symbols) into fallback tokens.  
** If a construct like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammar, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
**
** This feature can be used, for example, to cause some keywords in a language
** to revert to identifiers if they keyword does not apply in the context where
** it appears.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
**
** After the "shift" half of a SHIFTREDUCE action, the stateno field
** actually contains the reduce action for the second half of the
** SHIFTREDUCE.
*/
struct yyStackEntry {
  YYACTIONTYPE stateno;  /* The state-number, or reduce action in SHIFTREDUCE */
  YYCODETYPE major;      /* The major token value.  This is the code
                         ** number for the token at this stack level */
  YYMINORTYPE minor;     /* The user-supplied minor token value.  This
                         ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  yyStackEntry *yytos;          /* Pointer to top element of the stack */
#ifdef YYTRACKMAXSTACKDEPTH
  int yyhwm;                    /* High-water mark of the stack */
#endif
#ifndef YYNOERRORRECOVERY
  int yyerrcnt;                 /* Shifts left before out of the error */
#endif
  grn_expr_parserARG_SDECL                /* A place to hold %extra_argument */
  grn_expr_parserCTX_SDECL                /* A place to hold %extra_context */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
  yyStackEntry yystk0;          /* First stack entry */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
  yyStackEntry *yystackEnd;            /* Last entry in the stack */
#endif
};
typedef struct yyParser yyParser;

#include <assert.h>
#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void grn_expr_parserTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#if defined(YYCOVERAGE) || !defined(NDEBUG)
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  /*    0 */ "$",
  /*    1 */ "START_OUTPUT_COLUMNS",
  /*    2 */ "START_ADJUSTER",
  /*    3 */ "START_SORT_KEYS",
  /*    4 */ "START_OPTIONS",
  /*    5 */ "START_QUERY_NO_SYNTAX_ERROR",
  /*    6 */ "LOGICAL_AND",
  /*    7 */ "LOGICAL_AND_NOT",
  /*    8 */ "LOGICAL_OR",
  /*    9 */ "NEGATIVE",
  /*   10 */ "QSTRING",
  /*   11 */ "PARENL",
  /*   12 */ "PARENR",
  /*   13 */ "ADJUST",
  /*   14 */ "RELATIVE_OP",
  /*   15 */ "IDENTIFIER",
  /*   16 */ "BRACEL",
  /*   17 */ "BRACER",
  /*   18 */ "EVAL",
  /*   19 */ "COMMA",
  /*   20 */ "ASSIGN",
  /*   21 */ "STAR_ASSIGN",
  /*   22 */ "SLASH_ASSIGN",
  /*   23 */ "MOD_ASSIGN",
  /*   24 */ "PLUS_ASSIGN",
  /*   25 */ "MINUS_ASSIGN",
  /*   26 */ "SHIFTL_ASSIGN",
  /*   27 */ "SHIFTR_ASSIGN",
  /*   28 */ "SHIFTRR_ASSIGN",
  /*   29 */ "AND_ASSIGN",
  /*   30 */ "XOR_ASSIGN",
  /*   31 */ "OR_ASSIGN",
  /*   32 */ "QUESTION",
  /*   33 */ "COLON",
  /*   34 */ "BITWISE_OR",
  /*   35 */ "BITWISE_XOR",
  /*   36 */ "BITWISE_AND",
  /*   37 */ "EQUAL",
  /*   38 */ "NOT_EQUAL",
  /*   39 */ "LESS",
  /*   40 */ "GREATER",
  /*   41 */ "LESS_EQUAL",
  /*   42 */ "GREATER_EQUAL",
  /*   43 */ "IN",
  /*   44 */ "MATCH",
  /*   45 */ "NEAR",
  /*   46 */ "NEAR_NO_OFFSET",
  /*   47 */ "NEAR_PHRASE",
  /*   48 */ "ORDERED_NEAR_PHRASE",
  /*   49 */ "NEAR_PHRASE_PRODUCT",
  /*   50 */ "ORDERED_NEAR_PHRASE_PRODUCT",
  /*   51 */ "SIMILAR",
  /*   52 */ "TERM_EXTRACT",
  /*   53 */ "QUORUM",
  /*   54 */ "LCP",
  /*   55 */ "PREFIX",
  /*   56 */ "SUFFIX",
  /*   57 */ "REGEXP",
  /*   58 */ "SHIFTL",
  /*   59 */ "SHIFTR",
  /*   60 */ "SHIFTRR",
  /*   61 */ "PLUS",
  /*   62 */ "MINUS",
  /*   63 */ "STAR",
  /*   64 */ "SLASH",
  /*   65 */ "MOD",
  /*   66 */ "DELETE",
  /*   67 */ "INCR",
  /*   68 */ "DECR",
  /*   69 */ "NOT",
  /*   70 */ "BITWISE_NOT",
  /*   71 */ "EXACT",
  /*   72 */ "PARTIAL",
  /*   73 */ "UNSPLIT",
  /*   74 */ "DECIMAL",
  /*   75 */ "HEX_INTEGER",
  /*   76 */ "STRING",
  /*   77 */ "BOOLEAN",
  /*   78 */ "NULL",
  /*   79 */ "BRACKETL",
  /*   80 */ "BRACKETR",
  /*   81 */ "DOT",
  /*   82 */ "NONEXISTENT_COLUMN",
  /*   83 */ "suppress_unused_variable_warning",
  /*   84 */ "input",
  /*   85 */ "query",
  /*   86 */ "expression",
  /*   87 */ "output_columns",
  /*   88 */ "adjuster",
  /*   89 */ "sort_keys",
  /*   90 */ "object_literal",
  /*   91 */ "query_element",
  /*   92 */ "primary_expression",
  /*   93 */ "assignment_expression",
  /*   94 */ "conditional_expression",
  /*   95 */ "lefthand_side_expression",
  /*   96 */ "logical_or_expression",
  /*   97 */ "logical_and_expression",
  /*   98 */ "bitwise_or_expression",
  /*   99 */ "bitwise_xor_expression",
  /*  100 */ "bitwise_and_expression",
  /*  101 */ "equality_expression",
  /*  102 */ "relational_expression",
  /*  103 */ "shift_expression",
  /*  104 */ "additive_expression",
  /*  105 */ "multiplicative_expression",
  /*  106 */ "unary_expression",
  /*  107 */ "postfix_expression",
  /*  108 */ "call_expression",
  /*  109 */ "member_expression",
  /*  110 */ "arguments",
  /*  111 */ "member_expression_part",
  /*  112 */ "array_literal",
  /*  113 */ "element_list",
  /*  114 */ "property_list",
  /*  115 */ "property",
  /*  116 */ "property_name",
  /*  117 */ "argument_list",
  /*  118 */ "output_column",
  /*  119 */ "adjust_expression",
  /*  120 */ "adjust_match_expression",
  /*  121 */ "sort_key",
};
#endif /* defined(YYCOVERAGE) || !defined(NDEBUG) */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "query ::= query query_element",
 /*   1 */ "query ::= query LOGICAL_AND query_element",
 /*   2 */ "query ::= query LOGICAL_AND_NOT query_element",
 /*   3 */ "query ::= query LOGICAL_OR query_element",
 /*   4 */ "query ::= query NEGATIVE query_element",
 /*   5 */ "query_element ::= ADJUST query_element",
 /*   6 */ "query_element ::= RELATIVE_OP query_element",
 /*   7 */ "query_element ::= IDENTIFIER RELATIVE_OP query_element",
 /*   8 */ "query_element ::= BRACEL expression BRACER",
 /*   9 */ "query_element ::= EVAL primary_expression",
 /*  10 */ "expression ::= expression COMMA assignment_expression",
 /*  11 */ "assignment_expression ::= lefthand_side_expression ASSIGN assignment_expression",
 /*  12 */ "assignment_expression ::= lefthand_side_expression STAR_ASSIGN assignment_expression",
 /*  13 */ "assignment_expression ::= lefthand_side_expression SLASH_ASSIGN assignment_expression",
 /*  14 */ "assignment_expression ::= lefthand_side_expression MOD_ASSIGN assignment_expression",
 /*  15 */ "assignment_expression ::= lefthand_side_expression PLUS_ASSIGN assignment_expression",
 /*  16 */ "assignment_expression ::= lefthand_side_expression MINUS_ASSIGN assignment_expression",
 /*  17 */ "assignment_expression ::= lefthand_side_expression SHIFTL_ASSIGN assignment_expression",
 /*  18 */ "assignment_expression ::= lefthand_side_expression SHIFTR_ASSIGN assignment_expression",
 /*  19 */ "assignment_expression ::= lefthand_side_expression SHIFTRR_ASSIGN assignment_expression",
 /*  20 */ "assignment_expression ::= lefthand_side_expression AND_ASSIGN assignment_expression",
 /*  21 */ "assignment_expression ::= lefthand_side_expression XOR_ASSIGN assignment_expression",
 /*  22 */ "assignment_expression ::= lefthand_side_expression OR_ASSIGN assignment_expression",
 /*  23 */ "conditional_expression ::= logical_or_expression QUESTION assignment_expression COLON assignment_expression",
 /*  24 */ "logical_or_expression ::= logical_or_expression LOGICAL_OR logical_and_expression",
 /*  25 */ "logical_and_expression ::= logical_and_expression LOGICAL_AND bitwise_or_expression",
 /*  26 */ "logical_and_expression ::= logical_and_expression LOGICAL_AND_NOT bitwise_or_expression",
 /*  27 */ "logical_and_expression ::= logical_and_expression ADJUST bitwise_or_expression",
 /*  28 */ "logical_and_expression ::= logical_and_expression NEGATIVE bitwise_or_expression",
 /*  29 */ "bitwise_or_expression ::= bitwise_or_expression BITWISE_OR bitwise_xor_expression",
 /*  30 */ "bitwise_xor_expression ::= bitwise_xor_expression BITWISE_XOR bitwise_and_expression",
 /*  31 */ "bitwise_and_expression ::= bitwise_and_expression BITWISE_AND equality_expression",
 /*  32 */ "equality_expression ::= equality_expression EQUAL relational_expression",
 /*  33 */ "equality_expression ::= equality_expression NOT_EQUAL relational_expression",
 /*  34 */ "relational_expression ::= relational_expression LESS shift_expression",
 /*  35 */ "relational_expression ::= relational_expression GREATER shift_expression",
 /*  36 */ "relational_expression ::= relational_expression LESS_EQUAL shift_expression",
 /*  37 */ "relational_expression ::= relational_expression GREATER_EQUAL shift_expression",
 /*  38 */ "relational_expression ::= relational_expression IN shift_expression",
 /*  39 */ "relational_expression ::= relational_expression MATCH shift_expression",
 /*  40 */ "relational_expression ::= relational_expression NEAR shift_expression",
 /*  41 */ "relational_expression ::= relational_expression NEAR_NO_OFFSET shift_expression",
 /*  42 */ "relational_expression ::= relational_expression NEAR_PHRASE shift_expression",
 /*  43 */ "relational_expression ::= relational_expression ORDERED_NEAR_PHRASE shift_expression",
 /*  44 */ "relational_expression ::= relational_expression NEAR_PHRASE_PRODUCT shift_expression",
 /*  45 */ "relational_expression ::= relational_expression ORDERED_NEAR_PHRASE_PRODUCT shift_expression",
 /*  46 */ "relational_expression ::= relational_expression SIMILAR shift_expression",
 /*  47 */ "relational_expression ::= relational_expression TERM_EXTRACT shift_expression",
 /*  48 */ "relational_expression ::= relational_expression QUORUM shift_expression",
 /*  49 */ "relational_expression ::= relational_expression LCP shift_expression",
 /*  50 */ "relational_expression ::= relational_expression PREFIX shift_expression",
 /*  51 */ "relational_expression ::= relational_expression SUFFIX shift_expression",
 /*  52 */ "relational_expression ::= relational_expression REGEXP shift_expression",
 /*  53 */ "shift_expression ::= shift_expression SHIFTL additive_expression",
 /*  54 */ "shift_expression ::= shift_expression SHIFTR additive_expression",
 /*  55 */ "shift_expression ::= shift_expression SHIFTRR additive_expression",
 /*  56 */ "additive_expression ::= additive_expression PLUS multiplicative_expression",
 /*  57 */ "additive_expression ::= additive_expression MINUS multiplicative_expression",
 /*  58 */ "multiplicative_expression ::= multiplicative_expression STAR unary_expression",
 /*  59 */ "multiplicative_expression ::= multiplicative_expression SLASH unary_expression",
 /*  60 */ "multiplicative_expression ::= multiplicative_expression MOD unary_expression",
 /*  61 */ "unary_expression ::= DELETE unary_expression",
 /*  62 */ "unary_expression ::= INCR unary_expression",
 /*  63 */ "unary_expression ::= DECR unary_expression",
 /*  64 */ "unary_expression ::= PLUS unary_expression",
 /*  65 */ "unary_expression ::= MINUS unary_expression",
 /*  66 */ "unary_expression ::= NOT unary_expression",
 /*  67 */ "unary_expression ::= BITWISE_NOT unary_expression",
 /*  68 */ "unary_expression ::= ADJUST unary_expression",
 /*  69 */ "unary_expression ::= EXACT unary_expression",
 /*  70 */ "unary_expression ::= PARTIAL unary_expression",
 /*  71 */ "unary_expression ::= UNSPLIT unary_expression",
 /*  72 */ "postfix_expression ::= lefthand_side_expression INCR",
 /*  73 */ "postfix_expression ::= lefthand_side_expression DECR",
 /*  74 */ "call_expression ::= member_expression arguments",
 /*  75 */ "array_literal ::= BRACKETL element_list BRACKETR",
 /*  76 */ "element_list ::=",
 /*  77 */ "element_list ::= assignment_expression",
 /*  78 */ "element_list ::= element_list COMMA assignment_expression",
 /*  79 */ "object_literal ::= BRACEL property_list BRACER",
 /*  80 */ "property_list ::=",
 /*  81 */ "property_list ::= property",
 /*  82 */ "property_list ::= property_list COMMA property",
 /*  83 */ "member_expression_part ::= BRACKETL expression BRACKETR",
 /*  84 */ "arguments ::= PARENL argument_list PARENR",
 /*  85 */ "argument_list ::=",
 /*  86 */ "argument_list ::= assignment_expression",
 /*  87 */ "argument_list ::= argument_list COMMA assignment_expression",
 /*  88 */ "output_columns ::=",
 /*  89 */ "output_columns ::= output_column",
 /*  90 */ "output_columns ::= output_columns COMMA",
 /*  91 */ "output_columns ::= output_columns COMMA output_column",
 /*  92 */ "output_column ::= STAR",
 /*  93 */ "output_column ::= NONEXISTENT_COLUMN",
 /*  94 */ "output_column ::= assignment_expression",
 /*  95 */ "adjuster ::= adjuster PLUS adjust_expression",
 /*  96 */ "adjust_expression ::= adjust_match_expression STAR DECIMAL",
 /*  97 */ "adjust_match_expression ::= IDENTIFIER MATCH STRING",
 /*  98 */ "sort_keys ::=",
 /*  99 */ "sort_keys ::= sort_key",
 /* 100 */ "sort_keys ::= sort_keys COMMA sort_key",
 /* 101 */ "sort_key ::= NONEXISTENT_COLUMN",
 /* 102 */ "sort_key ::= MINUS NONEXISTENT_COLUMN",
 /* 103 */ "sort_key ::= assignment_expression",
 /* 104 */ "input ::= query",
 /* 105 */ "input ::= expression",
 /* 106 */ "input ::= START_OUTPUT_COLUMNS output_columns",
 /* 107 */ "input ::= START_ADJUSTER adjuster",
 /* 108 */ "input ::= START_SORT_KEYS sort_keys",
 /* 109 */ "input ::= START_OPTIONS object_literal",
 /* 110 */ "input ::= START_QUERY_NO_SYNTAX_ERROR",
 /* 111 */ "input ::= START_QUERY_NO_SYNTAX_ERROR query",
 /* 112 */ "query ::= query_element",
 /* 113 */ "query_element ::= QSTRING",
 /* 114 */ "query_element ::= PARENL query PARENR",
 /* 115 */ "expression ::= assignment_expression",
 /* 116 */ "assignment_expression ::= conditional_expression",
 /* 117 */ "conditional_expression ::= logical_or_expression",
 /* 118 */ "logical_or_expression ::= logical_and_expression",
 /* 119 */ "logical_and_expression ::= bitwise_or_expression",
 /* 120 */ "bitwise_or_expression ::= bitwise_xor_expression",
 /* 121 */ "bitwise_xor_expression ::= bitwise_and_expression",
 /* 122 */ "bitwise_and_expression ::= equality_expression",
 /* 123 */ "equality_expression ::= relational_expression",
 /* 124 */ "relational_expression ::= shift_expression",
 /* 125 */ "shift_expression ::= additive_expression",
 /* 126 */ "additive_expression ::= multiplicative_expression",
 /* 127 */ "multiplicative_expression ::= unary_expression",
 /* 128 */ "unary_expression ::= postfix_expression",
 /* 129 */ "postfix_expression ::= lefthand_side_expression",
 /* 130 */ "lefthand_side_expression ::= call_expression",
 /* 131 */ "lefthand_side_expression ::= member_expression",
 /* 132 */ "member_expression ::= primary_expression",
 /* 133 */ "member_expression ::= member_expression member_expression_part",
 /* 134 */ "primary_expression ::= object_literal",
 /* 135 */ "primary_expression ::= PARENL expression PARENR",
 /* 136 */ "primary_expression ::= IDENTIFIER",
 /* 137 */ "primary_expression ::= array_literal",
 /* 138 */ "primary_expression ::= DECIMAL",
 /* 139 */ "primary_expression ::= HEX_INTEGER",
 /* 140 */ "primary_expression ::= STRING",
 /* 141 */ "primary_expression ::= BOOLEAN",
 /* 142 */ "primary_expression ::= NULL",
 /* 143 */ "property ::= property_name COLON assignment_expression",
 /* 144 */ "property_name ::= STRING",
 /* 145 */ "member_expression_part ::= DOT IDENTIFIER",
 /* 146 */ "adjuster ::=",
 /* 147 */ "adjuster ::= adjust_expression",
 /* 148 */ "adjust_expression ::= adjust_match_expression",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.  Return the number
** of errors.  Return 0 on success.
*/
static int yyGrowStack(yyParser *p){
  int newSize;
  int idx;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  idx = p->yytos ? (int)(p->yytos - p->yystack) : 0;
  if( p->yystack==&p->yystk0 ){
    pNew = malloc(newSize*sizeof(pNew[0]));
    if( pNew ) pNew[0] = p->yystk0;
  }else{
    pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  }
  if( pNew ){
    p->yystack = pNew;
    p->yytos = &p->yystack[idx];
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows from %d to %d entries.\n",
              yyTracePrompt, p->yystksz, newSize);
    }
#endif
    p->yystksz = newSize;
  }
  return pNew==0; 
}
#endif

/* Datatype of the argument to the memory allocated passed as the
** second argument to grn_expr_parserAlloc() below.  This can be changed by
** putting an appropriate #define in the %include section of the input
** grammar.
*/
#ifndef YYMALLOCARGTYPE
# define YYMALLOCARGTYPE size_t
#endif

/* Initialize a new parser that has already been allocated.
*/
void grn_expr_parserInit(void *yypRawParser grn_expr_parserCTX_PDECL){
  yyParser *yypParser = (yyParser*)yypRawParser;
  grn_expr_parserCTX_STORE
#ifdef YYTRACKMAXSTACKDEPTH
  yypParser->yyhwm = 0;
#endif
#if YYSTACKDEPTH<=0
  yypParser->yytos = NULL;
  yypParser->yystack = NULL;
  yypParser->yystksz = 0;
  if( yyGrowStack(yypParser) ){
    yypParser->yystack = &yypParser->yystk0;
    yypParser->yystksz = 1;
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  yypParser->yytos = yypParser->yystack;
  yypParser->yystack[0].stateno = 0;
  yypParser->yystack[0].major = 0;
#if YYSTACKDEPTH>0
  yypParser->yystackEnd = &yypParser->yystack[YYSTACKDEPTH-1];
#endif
}

#ifndef grn_expr_parser_ENGINEALWAYSONSTACK
/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to grn_expr_parser and grn_expr_parserFree.
*/
void *grn_expr_parserAlloc(void *(*mallocProc)(YYMALLOCARGTYPE) grn_expr_parserCTX_PDECL){
  yyParser *yypParser;
  yypParser = (yyParser*)(*mallocProc)( (YYMALLOCARGTYPE)sizeof(yyParser) );
  if( yypParser ){
    grn_expr_parserCTX_STORE
    grn_expr_parserInit(yypParser grn_expr_parserCTX_PARAM);
  }
  return (void*)yypParser;
}
#endif /* grn_expr_parser_ENGINEALWAYSONSTACK */


/* The following function deletes the "minor type" or semantic value
** associated with a symbol.  The symbol can be either a terminal
** or nonterminal. "yymajor" is the symbol code, and "yypminor" is
** a pointer to the value to be deleted.  The code used to do the 
** deletions is derived from the %destructor and/or %token_destructor
** directives of the input grammar.
*/
static void yy_destructor(
  yyParser *yypParser,    /* The parser */
  YYCODETYPE yymajor,     /* Type code for object to destroy */
  YYMINORTYPE *yypminor   /* The object to be destroyed */
){
  grn_expr_parserARG_FETCH
  grn_expr_parserCTX_FETCH
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are *not* used
    ** inside the C code.
    */
/********* Begin destructor definitions ***************************************/
    case 83: /* suppress_unused_variable_warning */
{
#line 174 "grn_ecmascript.lemon"

  (void)efsi;

#line 1430 "grn_ecmascript.c"
}
      break;
/********* End destructor definitions *****************************************/
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
*/
static void yy_pop_parser_stack(yyParser *pParser){
  yyStackEntry *yytos;
  assert( pParser->yytos!=0 );
  assert( pParser->yytos > pParser->yystack );
  yytos = pParser->yytos--;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yy_destructor(pParser, yytos->major, &yytos->minor);
}

/*
** Clear all secondary memory allocations from the parser
*/
void grn_expr_parserFinalize(void *p){
  yyParser *pParser = (yyParser*)p;
  while( pParser->yytos>pParser->yystack ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  if( pParser->yystack!=&pParser->yystk0 ) free(pParser->yystack);
#endif
}

#ifndef grn_expr_parser_ENGINEALWAYSONSTACK
/* 
** Deallocate and destroy a parser.  Destructors are called for
** all stack elements before shutting the parser down.
**
** If the YYPARSEFREENEVERNULL macro exists (for example because it
** is defined in a %include section of the input grammar) then it is
** assumed that the input pointer is never NULL.
*/
void grn_expr_parserFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
#ifndef YYPARSEFREENEVERNULL
  if( p==0 ) return;
#endif
  grn_expr_parserFinalize(p);
  (*freeProc)(p);
}
#endif /* grn_expr_parser_ENGINEALWAYSONSTACK */

/*
** Return the peak depth of the stack for a parser.
*/
#ifdef YYTRACKMAXSTACKDEPTH
int grn_expr_parserStackPeak(void *p){
  yyParser *pParser = (yyParser*)p;
  return pParser->yyhwm;
}
#endif

/* This array of booleans keeps track of the parser statement
** coverage.  The element yycoverage[X][Y] is set when the parser
** is in state X and has a lookahead token Y.  In a well-tested
** systems, every element of this matrix should end up being set.
*/
#if defined(YYCOVERAGE)
static unsigned char yycoverage[YYNSTATE][YYNTOKEN];
#endif

/*
** Write into out a description of every state/lookahead combination that
**
**   (1)  has not been used by the parser, and
**   (2)  is not a syntax error.
**
** Return the number of missed state/lookahead combinations.
*/
#if defined(YYCOVERAGE)
int grn_expr_parserCoverage(FILE *out){
  int stateno, iLookAhead, i;
  int nMissed = 0;
  for(stateno=0; stateno<YYNSTATE; stateno++){
    i = yy_shift_ofst[stateno];
    for(iLookAhead=0; iLookAhead<YYNTOKEN; iLookAhead++){
      if( yy_lookahead[i+iLookAhead]!=iLookAhead ) continue;
      if( yycoverage[stateno][iLookAhead]==0 ) nMissed++;
      if( out ){
        fprintf(out,"State %d lookahead %s %s\n", stateno,
                yyTokenName[iLookAhead],
                yycoverage[stateno][iLookAhead] ? "ok" : "missed");
      }
    }
  }
  return nMissed;
}
#endif

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_shift_action(
  YYCODETYPE iLookAhead,    /* The look-ahead token */
  YYACTIONTYPE stateno      /* Current state number */
){
  int i;

  if( stateno>YY_MAX_SHIFT ) return stateno;
  assert( stateno <= YY_SHIFT_COUNT );
#if defined(YYCOVERAGE)
  yycoverage[stateno][iLookAhead] = 1;
#endif
  do{
    i = yy_shift_ofst[stateno];
    assert( i>=0 );
    assert( i<=YY_ACTTAB_COUNT );
    assert( i+YYNTOKEN<=(int)YY_NLOOKAHEAD );
    assert( iLookAhead!=YYNOCODE );
    assert( iLookAhead < YYNTOKEN );
    i += iLookAhead;
    assert( i<(int)YY_NLOOKAHEAD );
    if( yy_lookahead[i]!=iLookAhead ){
#ifdef YYFALLBACK
      YYCODETYPE iFallback;            /* Fallback token */
      assert( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0]) );
      iFallback = yyFallback[iLookAhead];
      if( iFallback!=0 ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        assert( yyFallback[iFallback]==0 ); /* Fallback loop must terminate */
        iLookAhead = iFallback;
        continue;
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        assert( j<(int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])) );
        if( yy_lookahead[j]==YYWILDCARD && iLookAhead>0 ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead],
               yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
      return yy_default[stateno];
    }else{
      assert( i>=0 && i<(int)(sizeof(yy_action)/sizeof(yy_action[0])) );
      return yy_action[i];
    }
  }while(1);
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_reduce_action(
  YYACTIONTYPE stateno,     /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
#ifdef YYERRORSYMBOL
  if( stateno>YY_REDUCE_COUNT ){
    return yy_default[stateno];
  }
#else
  assert( stateno<=YY_REDUCE_COUNT );
#endif
  i = yy_reduce_ofst[stateno];
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
#ifdef YYERRORSYMBOL
  if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }
#else
  assert( i>=0 && i<YY_ACTTAB_COUNT );
  assert( yy_lookahead[i]==iLookAhead );
#endif
  return yy_action[i];
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser){
   grn_expr_parserARG_FETCH
   grn_expr_parserCTX_FETCH
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */
/******** Begin %stack_overflow code ******************************************/
/******** End %stack_overflow code ********************************************/
   grn_expr_parserARG_STORE /* Suppress warning about unused %extra_argument var */
   grn_expr_parserCTX_STORE
}

/*
** Print tracing information for a SHIFT action
*/
#ifndef NDEBUG
static void yyTraceShift(yyParser *yypParser, int yyNewState, const char *zTag){
  if( yyTraceFILE ){
    if( yyNewState<YYNSTATE ){
      fprintf(yyTraceFILE,"%s%s '%s', go to state %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState);
    }else{
      fprintf(yyTraceFILE,"%s%s '%s', pending reduce %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState - YY_MIN_REDUCE);
    }
  }
}
#else
# define yyTraceShift(X,Y,Z)
#endif

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  YYACTIONTYPE yyNewState,      /* The new state to shift in */
  YYCODETYPE yyMajor,           /* The major token to shift in */
  grn_expr_parserTOKENTYPE yyMinor        /* The minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yytos++;
#ifdef YYTRACKMAXSTACKDEPTH
  if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
    yypParser->yyhwm++;
    assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack) );
  }
#endif
#if YYSTACKDEPTH>0 
  if( yypParser->yytos>yypParser->yystackEnd ){
    yypParser->yytos--;
    yyStackOverflow(yypParser);
    return;
  }
#else
  if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz] ){
    if( yyGrowStack(yypParser) ){
      yypParser->yytos--;
      yyStackOverflow(yypParser);
      return;
    }
  }
#endif
  if( yyNewState > YY_MAX_SHIFT ){
    yyNewState += YY_MIN_REDUCE - YY_MIN_SHIFTREDUCE;
  }
  yytos = yypParser->yytos;
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor.yy0 = yyMinor;
  yyTraceShift(yypParser, yyNewState, "Shift");
}

/* For rule J, yyRuleInfoLhs[J] contains the symbol on the left-hand side
** of that rule */
static const YYCODETYPE yyRuleInfoLhs[] = {
    85,  /* (0) query ::= query query_element */
    85,  /* (1) query ::= query LOGICAL_AND query_element */
    85,  /* (2) query ::= query LOGICAL_AND_NOT query_element */
    85,  /* (3) query ::= query LOGICAL_OR query_element */
    85,  /* (4) query ::= query NEGATIVE query_element */
    91,  /* (5) query_element ::= ADJUST query_element */
    91,  /* (6) query_element ::= RELATIVE_OP query_element */
    91,  /* (7) query_element ::= IDENTIFIER RELATIVE_OP query_element */
    91,  /* (8) query_element ::= BRACEL expression BRACER */
    91,  /* (9) query_element ::= EVAL primary_expression */
    86,  /* (10) expression ::= expression COMMA assignment_expression */
    93,  /* (11) assignment_expression ::= lefthand_side_expression ASSIGN assignment_expression */
    93,  /* (12) assignment_expression ::= lefthand_side_expression STAR_ASSIGN assignment_expression */
    93,  /* (13) assignment_expression ::= lefthand_side_expression SLASH_ASSIGN assignment_expression */
    93,  /* (14) assignment_expression ::= lefthand_side_expression MOD_ASSIGN assignment_expression */
    93,  /* (15) assignment_expression ::= lefthand_side_expression PLUS_ASSIGN assignment_expression */
    93,  /* (16) assignment_expression ::= lefthand_side_expression MINUS_ASSIGN assignment_expression */
    93,  /* (17) assignment_expression ::= lefthand_side_expression SHIFTL_ASSIGN assignment_expression */
    93,  /* (18) assignment_expression ::= lefthand_side_expression SHIFTR_ASSIGN assignment_expression */
    93,  /* (19) assignment_expression ::= lefthand_side_expression SHIFTRR_ASSIGN assignment_expression */
    93,  /* (20) assignment_expression ::= lefthand_side_expression AND_ASSIGN assignment_expression */
    93,  /* (21) assignment_expression ::= lefthand_side_expression XOR_ASSIGN assignment_expression */
    93,  /* (22) assignment_expression ::= lefthand_side_expression OR_ASSIGN assignment_expression */
    94,  /* (23) conditional_expression ::= logical_or_expression QUESTION assignment_expression COLON assignment_expression */
    96,  /* (24) logical_or_expression ::= logical_or_expression LOGICAL_OR logical_and_expression */
    97,  /* (25) logical_and_expression ::= logical_and_expression LOGICAL_AND bitwise_or_expression */
    97,  /* (26) logical_and_expression ::= logical_and_expression LOGICAL_AND_NOT bitwise_or_expression */
    97,  /* (27) logical_and_expression ::= logical_and_expression ADJUST bitwise_or_expression */
    97,  /* (28) logical_and_expression ::= logical_and_expression NEGATIVE bitwise_or_expression */
    98,  /* (29) bitwise_or_expression ::= bitwise_or_expression BITWISE_OR bitwise_xor_expression */
    99,  /* (30) bitwise_xor_expression ::= bitwise_xor_expression BITWISE_XOR bitwise_and_expression */
   100,  /* (31) bitwise_and_expression ::= bitwise_and_expression BITWISE_AND equality_expression */
   101,  /* (32) equality_expression ::= equality_expression EQUAL relational_expression */
   101,  /* (33) equality_expression ::= equality_expression NOT_EQUAL relational_expression */
   102,  /* (34) relational_expression ::= relational_expression LESS shift_expression */
   102,  /* (35) relational_expression ::= relational_expression GREATER shift_expression */
   102,  /* (36) relational_expression ::= relational_expression LESS_EQUAL shift_expression */
   102,  /* (37) relational_expression ::= relational_expression GREATER_EQUAL shift_expression */
   102,  /* (38) relational_expression ::= relational_expression IN shift_expression */
   102,  /* (39) relational_expression ::= relational_expression MATCH shift_expression */
   102,  /* (40) relational_expression ::= relational_expression NEAR shift_expression */
   102,  /* (41) relational_expression ::= relational_expression NEAR_NO_OFFSET shift_expression */
   102,  /* (42) relational_expression ::= relational_expression NEAR_PHRASE shift_expression */
   102,  /* (43) relational_expression ::= relational_expression ORDERED_NEAR_PHRASE shift_expression */
   102,  /* (44) relational_expression ::= relational_expression NEAR_PHRASE_PRODUCT shift_expression */
   102,  /* (45) relational_expression ::= relational_expression ORDERED_NEAR_PHRASE_PRODUCT shift_expression */
   102,  /* (46) relational_expression ::= relational_expression SIMILAR shift_expression */
   102,  /* (47) relational_expression ::= relational_expression TERM_EXTRACT shift_expression */
   102,  /* (48) relational_expression ::= relational_expression QUORUM shift_expression */
   102,  /* (49) relational_expression ::= relational_expression LCP shift_expression */
   102,  /* (50) relational_expression ::= relational_expression PREFIX shift_expression */
   102,  /* (51) relational_expression ::= relational_expression SUFFIX shift_expression */
   102,  /* (52) relational_expression ::= relational_expression REGEXP shift_expression */
   103,  /* (53) shift_expression ::= shift_expression SHIFTL additive_expression */
   103,  /* (54) shift_expression ::= shift_expression SHIFTR additive_expression */
   103,  /* (55) shift_expression ::= shift_expression SHIFTRR additive_expression */
   104,  /* (56) additive_expression ::= additive_expression PLUS multiplicative_expression */
   104,  /* (57) additive_expression ::= additive_expression MINUS multiplicative_expression */
   105,  /* (58) multiplicative_expression ::= multiplicative_expression STAR unary_expression */
   105,  /* (59) multiplicative_expression ::= multiplicative_expression SLASH unary_expression */
   105,  /* (60) multiplicative_expression ::= multiplicative_expression MOD unary_expression */
   106,  /* (61) unary_expression ::= DELETE unary_expression */
   106,  /* (62) unary_expression ::= INCR unary_expression */
   106,  /* (63) unary_expression ::= DECR unary_expression */
   106,  /* (64) unary_expression ::= PLUS unary_expression */
   106,  /* (65) unary_expression ::= MINUS unary_expression */
   106,  /* (66) unary_expression ::= NOT unary_expression */
   106,  /* (67) unary_expression ::= BITWISE_NOT unary_expression */
   106,  /* (68) unary_expression ::= ADJUST unary_expression */
   106,  /* (69) unary_expression ::= EXACT unary_expression */
   106,  /* (70) unary_expression ::= PARTIAL unary_expression */
   106,  /* (71) unary_expression ::= UNSPLIT unary_expression */
   107,  /* (72) postfix_expression ::= lefthand_side_expression INCR */
   107,  /* (73) postfix_expression ::= lefthand_side_expression DECR */
   108,  /* (74) call_expression ::= member_expression arguments */
   112,  /* (75) array_literal ::= BRACKETL element_list BRACKETR */
   113,  /* (76) element_list ::= */
   113,  /* (77) element_list ::= assignment_expression */
   113,  /* (78) element_list ::= element_list COMMA assignment_expression */
    90,  /* (79) object_literal ::= BRACEL property_list BRACER */
   114,  /* (80) property_list ::= */
   114,  /* (81) property_list ::= property */
   114,  /* (82) property_list ::= property_list COMMA property */
   111,  /* (83) member_expression_part ::= BRACKETL expression BRACKETR */
   110,  /* (84) arguments ::= PARENL argument_list PARENR */
   117,  /* (85) argument_list ::= */
   117,  /* (86) argument_list ::= assignment_expression */
   117,  /* (87) argument_list ::= argument_list COMMA assignment_expression */
    87,  /* (88) output_columns ::= */
    87,  /* (89) output_columns ::= output_column */
    87,  /* (90) output_columns ::= output_columns COMMA */
    87,  /* (91) output_columns ::= output_columns COMMA output_column */
   118,  /* (92) output_column ::= STAR */
   118,  /* (93) output_column ::= NONEXISTENT_COLUMN */
   118,  /* (94) output_column ::= assignment_expression */
    88,  /* (95) adjuster ::= adjuster PLUS adjust_expression */
   119,  /* (96) adjust_expression ::= adjust_match_expression STAR DECIMAL */
   120,  /* (97) adjust_match_expression ::= IDENTIFIER MATCH STRING */
    89,  /* (98) sort_keys ::= */
    89,  /* (99) sort_keys ::= sort_key */
    89,  /* (100) sort_keys ::= sort_keys COMMA sort_key */
   121,  /* (101) sort_key ::= NONEXISTENT_COLUMN */
   121,  /* (102) sort_key ::= MINUS NONEXISTENT_COLUMN */
   121,  /* (103) sort_key ::= assignment_expression */
    84,  /* (104) input ::= query */
    84,  /* (105) input ::= expression */
    84,  /* (106) input ::= START_OUTPUT_COLUMNS output_columns */
    84,  /* (107) input ::= START_ADJUSTER adjuster */
    84,  /* (108) input ::= START_SORT_KEYS sort_keys */
    84,  /* (109) input ::= START_OPTIONS object_literal */
    84,  /* (110) input ::= START_QUERY_NO_SYNTAX_ERROR */
    84,  /* (111) input ::= START_QUERY_NO_SYNTAX_ERROR query */
    85,  /* (112) query ::= query_element */
    91,  /* (113) query_element ::= QSTRING */
    91,  /* (114) query_element ::= PARENL query PARENR */
    86,  /* (115) expression ::= assignment_expression */
    93,  /* (116) assignment_expression ::= conditional_expression */
    94,  /* (117) conditional_expression ::= logical_or_expression */
    96,  /* (118) logical_or_expression ::= logical_and_expression */
    97,  /* (119) logical_and_expression ::= bitwise_or_expression */
    98,  /* (120) bitwise_or_expression ::= bitwise_xor_expression */
    99,  /* (121) bitwise_xor_expression ::= bitwise_and_expression */
   100,  /* (122) bitwise_and_expression ::= equality_expression */
   101,  /* (123) equality_expression ::= relational_expression */
   102,  /* (124) relational_expression ::= shift_expression */
   103,  /* (125) shift_expression ::= additive_expression */
   104,  /* (126) additive_expression ::= multiplicative_expression */
   105,  /* (127) multiplicative_expression ::= unary_expression */
   106,  /* (128) unary_expression ::= postfix_expression */
   107,  /* (129) postfix_expression ::= lefthand_side_expression */
    95,  /* (130) lefthand_side_expression ::= call_expression */
    95,  /* (131) lefthand_side_expression ::= member_expression */
   109,  /* (132) member_expression ::= primary_expression */
   109,  /* (133) member_expression ::= member_expression member_expression_part */
    92,  /* (134) primary_expression ::= object_literal */
    92,  /* (135) primary_expression ::= PARENL expression PARENR */
    92,  /* (136) primary_expression ::= IDENTIFIER */
    92,  /* (137) primary_expression ::= array_literal */
    92,  /* (138) primary_expression ::= DECIMAL */
    92,  /* (139) primary_expression ::= HEX_INTEGER */
    92,  /* (140) primary_expression ::= STRING */
    92,  /* (141) primary_expression ::= BOOLEAN */
    92,  /* (142) primary_expression ::= NULL */
   115,  /* (143) property ::= property_name COLON assignment_expression */
   116,  /* (144) property_name ::= STRING */
   111,  /* (145) member_expression_part ::= DOT IDENTIFIER */
    88,  /* (146) adjuster ::= */
    88,  /* (147) adjuster ::= adjust_expression */
   119,  /* (148) adjust_expression ::= adjust_match_expression */
};

/* For rule J, yyRuleInfoNRhs[J] contains the negative of the number
** of symbols on the right-hand side of that rule. */
static const signed char yyRuleInfoNRhs[] = {
   -2,  /* (0) query ::= query query_element */
   -3,  /* (1) query ::= query LOGICAL_AND query_element */
   -3,  /* (2) query ::= query LOGICAL_AND_NOT query_element */
   -3,  /* (3) query ::= query LOGICAL_OR query_element */
   -3,  /* (4) query ::= query NEGATIVE query_element */
   -2,  /* (5) query_element ::= ADJUST query_element */
   -2,  /* (6) query_element ::= RELATIVE_OP query_element */
   -3,  /* (7) query_element ::= IDENTIFIER RELATIVE_OP query_element */
   -3,  /* (8) query_element ::= BRACEL expression BRACER */
   -2,  /* (9) query_element ::= EVAL primary_expression */
   -3,  /* (10) expression ::= expression COMMA assignment_expression */
   -3,  /* (11) assignment_expression ::= lefthand_side_expression ASSIGN assignment_expression */
   -3,  /* (12) assignment_expression ::= lefthand_side_expression STAR_ASSIGN assignment_expression */
   -3,  /* (13) assignment_expression ::= lefthand_side_expression SLASH_ASSIGN assignment_expression */
   -3,  /* (14) assignment_expression ::= lefthand_side_expression MOD_ASSIGN assignment_expression */
   -3,  /* (15) assignment_expression ::= lefthand_side_expression PLUS_ASSIGN assignment_expression */
   -3,  /* (16) assignment_expression ::= lefthand_side_expression MINUS_ASSIGN assignment_expression */
   -3,  /* (17) assignment_expression ::= lefthand_side_expression SHIFTL_ASSIGN assignment_expression */
   -3,  /* (18) assignment_expression ::= lefthand_side_expression SHIFTR_ASSIGN assignment_expression */
   -3,  /* (19) assignment_expression ::= lefthand_side_expression SHIFTRR_ASSIGN assignment_expression */
   -3,  /* (20) assignment_expression ::= lefthand_side_expression AND_ASSIGN assignment_expression */
   -3,  /* (21) assignment_expression ::= lefthand_side_expression XOR_ASSIGN assignment_expression */
   -3,  /* (22) assignment_expression ::= lefthand_side_expression OR_ASSIGN assignment_expression */
   -5,  /* (23) conditional_expression ::= logical_or_expression QUESTION assignment_expression COLON assignment_expression */
   -3,  /* (24) logical_or_expression ::= logical_or_expression LOGICAL_OR logical_and_expression */
   -3,  /* (25) logical_and_expression ::= logical_and_expression LOGICAL_AND bitwise_or_expression */
   -3,  /* (26) logical_and_expression ::= logical_and_expression LOGICAL_AND_NOT bitwise_or_expression */
   -3,  /* (27) logical_and_expression ::= logical_and_expression ADJUST bitwise_or_expression */
   -3,  /* (28) logical_and_expression ::= logical_and_expression NEGATIVE bitwise_or_expression */
   -3,  /* (29) bitwise_or_expression ::= bitwise_or_expression BITWISE_OR bitwise_xor_expression */
   -3,  /* (30) bitwise_xor_expression ::= bitwise_xor_expression BITWISE_XOR bitwise_and_expression */
   -3,  /* (31) bitwise_and_expression ::= bitwise_and_expression BITWISE_AND equality_expression */
   -3,  /* (32) equality_expression ::= equality_expression EQUAL relational_expression */
   -3,  /* (33) equality_expression ::= equality_expression NOT_EQUAL relational_expression */
   -3,  /* (34) relational_expression ::= relational_expression LESS shift_expression */
   -3,  /* (35) relational_expression ::= relational_expression GREATER shift_expression */
   -3,  /* (36) relational_expression ::= relational_expression LESS_EQUAL shift_expression */
   -3,  /* (37) relational_expression ::= relational_expression GREATER_EQUAL shift_expression */
   -3,  /* (38) relational_expression ::= relational_expression IN shift_expression */
   -3,  /* (39) relational_expression ::= relational_expression MATCH shift_expression */
   -3,  /* (40) relational_expression ::= relational_expression NEAR shift_expression */
   -3,  /* (41) relational_expression ::= relational_expression NEAR_NO_OFFSET shift_expression */
   -3,  /* (42) relational_expression ::= relational_expression NEAR_PHRASE shift_expression */
   -3,  /* (43) relational_expression ::= relational_expression ORDERED_NEAR_PHRASE shift_expression */
   -3,  /* (44) relational_expression ::= relational_expression NEAR_PHRASE_PRODUCT shift_expression */
   -3,  /* (45) relational_expression ::= relational_expression ORDERED_NEAR_PHRASE_PRODUCT shift_expression */
   -3,  /* (46) relational_expression ::= relational_expression SIMILAR shift_expression */
   -3,  /* (47) relational_expression ::= relational_expression TERM_EXTRACT shift_expression */
   -3,  /* (48) relational_expression ::= relational_expression QUORUM shift_expression */
   -3,  /* (49) relational_expression ::= relational_expression LCP shift_expression */
   -3,  /* (50) relational_expression ::= relational_expression PREFIX shift_expression */
   -3,  /* (51) relational_expression ::= relational_expression SUFFIX shift_expression */
   -3,  /* (52) relational_expression ::= relational_expression REGEXP shift_expression */
   -3,  /* (53) shift_expression ::= shift_expression SHIFTL additive_expression */
   -3,  /* (54) shift_expression ::= shift_expression SHIFTR additive_expression */
   -3,  /* (55) shift_expression ::= shift_expression SHIFTRR additive_expression */
   -3,  /* (56) additive_expression ::= additive_expression PLUS multiplicative_expression */
   -3,  /* (57) additive_expression ::= additive_expression MINUS multiplicative_expression */
   -3,  /* (58) multiplicative_expression ::= multiplicative_expression STAR unary_expression */
   -3,  /* (59) multiplicative_expression ::= multiplicative_expression SLASH unary_expression */
   -3,  /* (60) multiplicative_expression ::= multiplicative_expression MOD unary_expression */
   -2,  /* (61) unary_expression ::= DELETE unary_expression */
   -2,  /* (62) unary_expression ::= INCR unary_expression */
   -2,  /* (63) unary_expression ::= DECR unary_expression */
   -2,  /* (64) unary_expression ::= PLUS unary_expression */
   -2,  /* (65) unary_expression ::= MINUS unary_expression */
   -2,  /* (66) unary_expression ::= NOT unary_expression */
   -2,  /* (67) unary_expression ::= BITWISE_NOT unary_expression */
   -2,  /* (68) unary_expression ::= ADJUST unary_expression */
   -2,  /* (69) unary_expression ::= EXACT unary_expression */
   -2,  /* (70) unary_expression ::= PARTIAL unary_expression */
   -2,  /* (71) unary_expression ::= UNSPLIT unary_expression */
   -2,  /* (72) postfix_expression ::= lefthand_side_expression INCR */
   -2,  /* (73) postfix_expression ::= lefthand_side_expression DECR */
   -2,  /* (74) call_expression ::= member_expression arguments */
   -3,  /* (75) array_literal ::= BRACKETL element_list BRACKETR */
    0,  /* (76) element_list ::= */
   -1,  /* (77) element_list ::= assignment_expression */
   -3,  /* (78) element_list ::= element_list COMMA assignment_expression */
   -3,  /* (79) object_literal ::= BRACEL property_list BRACER */
    0,  /* (80) property_list ::= */
   -1,  /* (81) property_list ::= property */
   -3,  /* (82) property_list ::= property_list COMMA property */
   -3,  /* (83) member_expression_part ::= BRACKETL expression BRACKETR */
   -3,  /* (84) arguments ::= PARENL argument_list PARENR */
    0,  /* (85) argument_list ::= */
   -1,  /* (86) argument_list ::= assignment_expression */
   -3,  /* (87) argument_list ::= argument_list COMMA assignment_expression */
    0,  /* (88) output_columns ::= */
   -1,  /* (89) output_columns ::= output_column */
   -2,  /* (90) output_columns ::= output_columns COMMA */
   -3,  /* (91) output_columns ::= output_columns COMMA output_column */
   -1,  /* (92) output_column ::= STAR */
   -1,  /* (93) output_column ::= NONEXISTENT_COLUMN */
   -1,  /* (94) output_column ::= assignment_expression */
   -3,  /* (95) adjuster ::= adjuster PLUS adjust_expression */
   -3,  /* (96) adjust_expression ::= adjust_match_expression STAR DECIMAL */
   -3,  /* (97) adjust_match_expression ::= IDENTIFIER MATCH STRING */
    0,  /* (98) sort_keys ::= */
   -1,  /* (99) sort_keys ::= sort_key */
   -3,  /* (100) sort_keys ::= sort_keys COMMA sort_key */
   -1,  /* (101) sort_key ::= NONEXISTENT_COLUMN */
   -2,  /* (102) sort_key ::= MINUS NONEXISTENT_COLUMN */
   -1,  /* (103) sort_key ::= assignment_expression */
   -1,  /* (104) input ::= query */
   -1,  /* (105) input ::= expression */
   -2,  /* (106) input ::= START_OUTPUT_COLUMNS output_columns */
   -2,  /* (107) input ::= START_ADJUSTER adjuster */
   -2,  /* (108) input ::= START_SORT_KEYS sort_keys */
   -2,  /* (109) input ::= START_OPTIONS object_literal */
   -1,  /* (110) input ::= START_QUERY_NO_SYNTAX_ERROR */
   -2,  /* (111) input ::= START_QUERY_NO_SYNTAX_ERROR query */
   -1,  /* (112) query ::= query_element */
   -1,  /* (113) query_element ::= QSTRING */
   -3,  /* (114) query_element ::= PARENL query PARENR */
   -1,  /* (115) expression ::= assignment_expression */
   -1,  /* (116) assignment_expression ::= conditional_expression */
   -1,  /* (117) conditional_expression ::= logical_or_expression */
   -1,  /* (118) logical_or_expression ::= logical_and_expression */
   -1,  /* (119) logical_and_expression ::= bitwise_or_expression */
   -1,  /* (120) bitwise_or_expression ::= bitwise_xor_expression */
   -1,  /* (121) bitwise_xor_expression ::= bitwise_and_expression */
   -1,  /* (122) bitwise_and_expression ::= equality_expression */
   -1,  /* (123) equality_expression ::= relational_expression */
   -1,  /* (124) relational_expression ::= shift_expression */
   -1,  /* (125) shift_expression ::= additive_expression */
   -1,  /* (126) additive_expression ::= multiplicative_expression */
   -1,  /* (127) multiplicative_expression ::= unary_expression */
   -1,  /* (128) unary_expression ::= postfix_expression */
   -1,  /* (129) postfix_expression ::= lefthand_side_expression */
   -1,  /* (130) lefthand_side_expression ::= call_expression */
   -1,  /* (131) lefthand_side_expression ::= member_expression */
   -1,  /* (132) member_expression ::= primary_expression */
   -2,  /* (133) member_expression ::= member_expression member_expression_part */
   -1,  /* (134) primary_expression ::= object_literal */
   -3,  /* (135) primary_expression ::= PARENL expression PARENR */
   -1,  /* (136) primary_expression ::= IDENTIFIER */
   -1,  /* (137) primary_expression ::= array_literal */
   -1,  /* (138) primary_expression ::= DECIMAL */
   -1,  /* (139) primary_expression ::= HEX_INTEGER */
   -1,  /* (140) primary_expression ::= STRING */
   -1,  /* (141) primary_expression ::= BOOLEAN */
   -1,  /* (142) primary_expression ::= NULL */
   -3,  /* (143) property ::= property_name COLON assignment_expression */
   -1,  /* (144) property_name ::= STRING */
   -2,  /* (145) member_expression_part ::= DOT IDENTIFIER */
    0,  /* (146) adjuster ::= */
   -1,  /* (147) adjuster ::= adjust_expression */
   -1,  /* (148) adjust_expression ::= adjust_match_expression */
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
**
** The yyLookahead and yyLookaheadToken parameters provide reduce actions
** access to the lookahead token (if any).  The yyLookahead will be YYNOCODE
** if the lookahead token has already been consumed.  As this procedure is
** only called from one place, optimizing compilers will in-line it, which
** means that the extra parameters have no performance impact.
*/
static YYACTIONTYPE yy_reduce(
  yyParser *yypParser,         /* The parser */
  unsigned int yyruleno,       /* Number of the rule by which to reduce */
  int yyLookahead,             /* Lookahead token, or YYNOCODE if none */
  grn_expr_parserTOKENTYPE yyLookaheadToken  /* Value of the lookahead token */
  grn_expr_parserCTX_PDECL                   /* %extra_context */
){
  int yygoto;                     /* The next state */
  YYACTIONTYPE yyact;             /* The next action */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  grn_expr_parserARG_FETCH
  (void)yyLookahead;
  (void)yyLookaheadToken;
  yymsp = yypParser->yytos;

  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
/********** Begin reduce actions **********************************************/
        YYMINORTYPE yylhsminor;
      case 0: /* query ::= query query_element */
#line 220 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, grn_int32_value_at(&efsi->op_stack, -1), 2);
}
#line 2068 "grn_ecmascript.c"
        break;
      case 1: /* query ::= query LOGICAL_AND query_element */
      case 25: /* logical_and_expression ::= logical_and_expression LOGICAL_AND bitwise_or_expression */ yytestcase(yyruleno==25);
#line 223 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_AND, 2);
}
#line 2076 "grn_ecmascript.c"
        break;
      case 2: /* query ::= query LOGICAL_AND_NOT query_element */
      case 26: /* logical_and_expression ::= logical_and_expression LOGICAL_AND_NOT bitwise_or_expression */ yytestcase(yyruleno==26);
#line 226 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_AND_NOT, 2);
}
#line 2084 "grn_ecmascript.c"
        break;
      case 3: /* query ::= query LOGICAL_OR query_element */
      case 24: /* logical_or_expression ::= logical_or_expression LOGICAL_OR logical_and_expression */ yytestcase(yyruleno==24);
#line 229 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_OR, 2);
}
#line 2092 "grn_ecmascript.c"
        break;
      case 4: /* query ::= query NEGATIVE query_element */
#line 232 "grn_ecmascript.lemon"
{
  float weight;
  GRN_FLOAT32_POP(&efsi->weight_stack, weight);
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_ADJUST, 2);
}
#line 2101 "grn_ecmascript.c"
        break;
      case 5: /* query_element ::= ADJUST query_element */
#line 241 "grn_ecmascript.lemon"
{
  float weight;
  GRN_FLOAT32_POP(&efsi->weight_stack, weight);
}
#line 2109 "grn_ecmascript.c"
        break;
      case 6: /* query_element ::= RELATIVE_OP query_element */
#line 245 "grn_ecmascript.lemon"
{
  int mode;
  GRN_INT32_POP(&efsi->mode_stack, mode);
}
#line 2117 "grn_ecmascript.c"
        break;
      case 7: /* query_element ::= IDENTIFIER RELATIVE_OP query_element */
#line 249 "grn_ecmascript.lemon"
{
  int mode;
  grn_obj *c;
  GRN_PTR_POP(&efsi->column_stack, c);
  GRN_INT32_POP(&efsi->mode_stack, mode);
  switch (mode) {
  case GRN_OP_NEAR :
  case GRN_OP_NEAR_NO_OFFSET :
    {
      int max_interval;
      GRN_INT32_POP(&efsi->max_interval_stack, max_interval);
      grn_obj *max_element_intervals;
      GRN_PTR_POP(&efsi->max_element_intervals_stack,
                  max_element_intervals);
      int min_interval;
      GRN_INT32_POP(&efsi->min_interval_stack, min_interval);
    }
    break;
  case GRN_OP_NEAR_PHRASE :
  case GRN_OP_ORDERED_NEAR_PHRASE :
  case GRN_OP_NEAR_PHRASE_PRODUCT :
  case GRN_OP_ORDERED_NEAR_PHRASE_PRODUCT :
    {
      int max_interval;
      GRN_INT32_POP(&efsi->max_interval_stack, max_interval);
      int additional_last_interval;
      GRN_INT32_POP(&efsi->additional_last_interval_stack,
                    additional_last_interval);
      grn_obj *max_element_intervals;
      GRN_PTR_POP(&efsi->max_element_intervals_stack,
                  max_element_intervals);
      int min_interval;
      GRN_INT32_POP(&efsi->min_interval_stack, min_interval);
    }
    break;
  case GRN_OP_SIMILAR :
    {
      int similarity_threshold;
      GRN_INT32_POP(&efsi->similarity_threshold_stack, similarity_threshold);
    }
    break;
  case GRN_OP_QUORUM :
    {
      int quorum_threshold;
      GRN_INT32_POP(&efsi->quorum_threshold_stack, quorum_threshold);
    }
    break;
  default :
    break;
  }
}
#line 2172 "grn_ecmascript.c"
        break;
      case 8: /* query_element ::= BRACEL expression BRACER */
      case 9: /* query_element ::= EVAL primary_expression */ yytestcase(yyruleno==9);
#line 300 "grn_ecmascript.lemon"
{
  efsi->flags = efsi->default_flags;
}
#line 2180 "grn_ecmascript.c"
        break;
      case 10: /* expression ::= expression COMMA assignment_expression */
#line 308 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_COMMA, 2);
}
#line 2187 "grn_ecmascript.c"
        break;
      case 11: /* assignment_expression ::= lefthand_side_expression ASSIGN assignment_expression */
#line 313 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_ASSIGN, 2);
}
#line 2194 "grn_ecmascript.c"
        break;
      case 12: /* assignment_expression ::= lefthand_side_expression STAR_ASSIGN assignment_expression */
#line 316 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_STAR_ASSIGN, 2);
}
#line 2201 "grn_ecmascript.c"
        break;
      case 13: /* assignment_expression ::= lefthand_side_expression SLASH_ASSIGN assignment_expression */
#line 319 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_SLASH_ASSIGN, 2);
}
#line 2208 "grn_ecmascript.c"
        break;
      case 14: /* assignment_expression ::= lefthand_side_expression MOD_ASSIGN assignment_expression */
#line 322 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_MOD_ASSIGN, 2);
}
#line 2215 "grn_ecmascript.c"
        break;
      case 15: /* assignment_expression ::= lefthand_side_expression PLUS_ASSIGN assignment_expression */
#line 325 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_PLUS_ASSIGN, 2);
}
#line 2222 "grn_ecmascript.c"
        break;
      case 16: /* assignment_expression ::= lefthand_side_expression MINUS_ASSIGN assignment_expression */
#line 328 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_MINUS_ASSIGN, 2);
}
#line 2229 "grn_ecmascript.c"
        break;
      case 17: /* assignment_expression ::= lefthand_side_expression SHIFTL_ASSIGN assignment_expression */
#line 331 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_SHIFTL_ASSIGN, 2);
}
#line 2236 "grn_ecmascript.c"
        break;
      case 18: /* assignment_expression ::= lefthand_side_expression SHIFTR_ASSIGN assignment_expression */
#line 334 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_SHIFTR_ASSIGN, 2);
}
#line 2243 "grn_ecmascript.c"
        break;
      case 19: /* assignment_expression ::= lefthand_side_expression SHIFTRR_ASSIGN assignment_expression */
#line 337 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_SHIFTRR_ASSIGN, 2);
}
#line 2250 "grn_ecmascript.c"
        break;
      case 20: /* assignment_expression ::= lefthand_side_expression AND_ASSIGN assignment_expression */
#line 340 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_AND_ASSIGN, 2);
}
#line 2257 "grn_ecmascript.c"
        break;
      case 21: /* assignment_expression ::= lefthand_side_expression XOR_ASSIGN assignment_expression */
#line 343 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_XOR_ASSIGN, 2);
}
#line 2264 "grn_ecmascript.c"
        break;
      case 22: /* assignment_expression ::= lefthand_side_expression OR_ASSIGN assignment_expression */
#line 346 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_OR_ASSIGN, 2);
}
#line 2271 "grn_ecmascript.c"
        break;
      case 23: /* conditional_expression ::= logical_or_expression QUESTION assignment_expression COLON assignment_expression */
#line 351 "grn_ecmascript.lemon"
{
  grn_expr *e = (grn_expr *)efsi->e;
  e->codes[yymsp[-3].minor.yy0].nargs = yymsp[-1].minor.yy0 - yymsp[-3].minor.yy0;
  e->codes[yymsp[-1].minor.yy0].nargs = e->codes_curr - yymsp[-1].minor.yy0 - 1;
}
#line 2280 "grn_ecmascript.c"
        break;
      case 27: /* logical_and_expression ::= logical_and_expression ADJUST bitwise_or_expression */
#line 369 "grn_ecmascript.lemon"
{
  float weight;
  GRN_FLOAT32_POP(&efsi->weight_stack, weight);
  grn_expr_append_const_float32(efsi->ctx, efsi->e, weight, GRN_OP_AND, 2);
}
#line 2289 "grn_ecmascript.c"
        break;
      case 28: /* logical_and_expression ::= logical_and_expression NEGATIVE bitwise_or_expression */
#line 374 "grn_ecmascript.lemon"
{
  float weight;
  GRN_FLOAT32_POP(&efsi->weight_stack, weight);
  grn_expr_append_const_float32(efsi->ctx, efsi->e, weight, GRN_OP_ADJUST, 2);
}
#line 2298 "grn_ecmascript.c"
        break;
      case 29: /* bitwise_or_expression ::= bitwise_or_expression BITWISE_OR bitwise_xor_expression */
#line 381 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_BITWISE_OR, 2);
}
#line 2305 "grn_ecmascript.c"
        break;
      case 30: /* bitwise_xor_expression ::= bitwise_xor_expression BITWISE_XOR bitwise_and_expression */
#line 386 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_BITWISE_XOR, 2);
}
#line 2312 "grn_ecmascript.c"
        break;
      case 31: /* bitwise_and_expression ::= bitwise_and_expression BITWISE_AND equality_expression */
#line 391 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_BITWISE_AND, 2);
}
#line 2319 "grn_ecmascript.c"
        break;
      case 32: /* equality_expression ::= equality_expression EQUAL relational_expression */
#line 396 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_EQUAL, 2);
}
#line 2326 "grn_ecmascript.c"
        break;
      case 33: /* equality_expression ::= equality_expression NOT_EQUAL relational_expression */
#line 399 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_NOT_EQUAL, 2);
}
#line 2333 "grn_ecmascript.c"
        break;
      case 34: /* relational_expression ::= relational_expression LESS shift_expression */
#line 404 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_LESS, 2);
}
#line 2340 "grn_ecmascript.c"
        break;
      case 35: /* relational_expression ::= relational_expression GREATER shift_expression */
#line 407 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_GREATER, 2);
}
#line 2347 "grn_ecmascript.c"
        break;
      case 36: /* relational_expression ::= relational_expression LESS_EQUAL shift_expression */
#line 410 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_LESS_EQUAL, 2);
}
#line 2354 "grn_ecmascript.c"
        break;
      case 37: /* relational_expression ::= relational_expression GREATER_EQUAL shift_expression */
#line 413 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_GREATER_EQUAL, 2);
}
#line 2361 "grn_ecmascript.c"
        break;
      case 38: /* relational_expression ::= relational_expression IN shift_expression */
#line 416 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_IN, 2);
}
#line 2368 "grn_ecmascript.c"
        break;
      case 39: /* relational_expression ::= relational_expression MATCH shift_expression */
      case 97: /* adjust_match_expression ::= IDENTIFIER MATCH STRING */ yytestcase(yyruleno==97);
#line 419 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_MATCH, 2);
}
#line 2376 "grn_ecmascript.c"
        break;
      case 40: /* relational_expression ::= relational_expression NEAR shift_expression */
#line 422 "grn_ecmascript.lemon"
{
  int n_args = 2;
  do {
    int max_interval;
    GRN_INT32_POP(&efsi->max_interval_stack, max_interval);
    grn_expr_append_const_int(efsi->ctx, efsi->e, max_interval,
                              GRN_OP_PUSH, 1);
    n_args++;
    grn_obj *max_element_intervals;
    GRN_PTR_POP(&efsi->max_element_intervals_stack,
                max_element_intervals);
    int min_interval;
    GRN_INT32_POP(&efsi->min_interval_stack, min_interval);
    if (!max_element_intervals) {
      break;
    }
    grn_expr_append_obj(efsi->ctx, efsi->e, max_element_intervals,
                        GRN_OP_PUSH, 1);
    grn_expr_take_obj(efsi->ctx, efsi->e, max_element_intervals);
    n_args++;
    grn_expr_append_const_int(efsi->ctx, efsi->e, min_interval,
                              GRN_OP_PUSH, 1);
    n_args++;
  } while (false);
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_NEAR, n_args);
}
#line 2406 "grn_ecmascript.c"
        break;
      case 41: /* relational_expression ::= relational_expression NEAR_NO_OFFSET shift_expression */
#line 448 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_NEAR_NO_OFFSET, 2);
}
#line 2413 "grn_ecmascript.c"
        break;
      case 42: /* relational_expression ::= relational_expression NEAR_PHRASE shift_expression */
#line 451 "grn_ecmascript.lemon"
{
  int n_args = 2;
  do {
    int max_interval;
    GRN_INT32_POP(&efsi->max_interval_stack, max_interval);
    grn_expr_append_const_int(efsi->ctx, efsi->e, max_interval,
                              GRN_OP_PUSH, 1);
    n_args++;
    int additional_last_interval;
    GRN_INT32_POP(&efsi->additional_last_interval_stack,
                  additional_last_interval);
    grn_expr_append_const_int(efsi->ctx, efsi->e, additional_last_interval,
                              GRN_OP_PUSH, 1);
    n_args++;
    grn_obj *max_element_intervals;
    GRN_PTR_POP(&efsi->max_element_intervals_stack,
                max_element_intervals);
    int min_interval;
    GRN_INT32_POP(&efsi->min_interval_stack, min_interval);
    if (!max_element_intervals) {
      break;
    }
    grn_expr_append_obj(efsi->ctx, efsi->e, max_element_intervals,
                        GRN_OP_PUSH, 1);
    grn_expr_take_obj(efsi->ctx, efsi->e, max_element_intervals);
    n_args++;
    grn_expr_append_const_int(efsi->ctx, efsi->e, min_interval,
                              GRN_OP_PUSH, 1);
    n_args++;
  } while (false);
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_NEAR_PHRASE, n_args);
}
#line 2449 "grn_ecmascript.c"
        break;
      case 43: /* relational_expression ::= relational_expression ORDERED_NEAR_PHRASE shift_expression */
#line 483 "grn_ecmascript.lemon"
{
  int n_args = 2;
  do {
    int max_interval;
    GRN_INT32_POP(&efsi->max_interval_stack, max_interval);
    grn_expr_append_const_int(efsi->ctx, efsi->e, max_interval,
                              GRN_OP_PUSH, 1);
    n_args++;
    int additional_last_interval;
    GRN_INT32_POP(&efsi->additional_last_interval_stack,
                  additional_last_interval);
    grn_expr_append_const_int(efsi->ctx, efsi->e, additional_last_interval,
                              GRN_OP_PUSH, 1);
    n_args++;
    grn_obj *max_element_intervals;
    GRN_PTR_POP(&efsi->max_element_intervals_stack,
                max_element_intervals);
    int min_interval;
    GRN_INT32_POP(&efsi->min_interval_stack, min_interval);
    if (!max_element_intervals) {
      break;
    }
    grn_expr_append_obj(efsi->ctx, efsi->e, max_element_intervals,
                        GRN_OP_PUSH, 1);
    grn_expr_take_obj(efsi->ctx, efsi->e, max_element_intervals);
    n_args++;
    grn_expr_append_const_int(efsi->ctx, efsi->e, min_interval,
                              GRN_OP_PUSH, 1);
    n_args++;
  } while (false);
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_ORDERED_NEAR_PHRASE, n_args);
}
#line 2485 "grn_ecmascript.c"
        break;
      case 44: /* relational_expression ::= relational_expression NEAR_PHRASE_PRODUCT shift_expression */
#line 515 "grn_ecmascript.lemon"
{
  int n_args = 2;
  do {
    int max_interval;
    GRN_INT32_POP(&efsi->max_interval_stack, max_interval);
    grn_expr_append_const_int(efsi->ctx, efsi->e, max_interval,
                              GRN_OP_PUSH, 1);
    n_args++;
    int additional_last_interval;
    GRN_INT32_POP(&efsi->additional_last_interval_stack,
                  additional_last_interval);
    grn_expr_append_const_int(efsi->ctx, efsi->e, additional_last_interval,
                              GRN_OP_PUSH, 1);
    n_args++;
    grn_obj *max_element_intervals;
    GRN_PTR_POP(&efsi->max_element_intervals_stack,
                max_element_intervals);
    int min_interval;
    GRN_INT32_POP(&efsi->min_interval_stack, min_interval);
    if (!max_element_intervals) {
      break;
    }
    grn_expr_append_obj(efsi->ctx, efsi->e, max_element_intervals,
                        GRN_OP_PUSH, 1);
    grn_expr_take_obj(efsi->ctx, efsi->e, max_element_intervals);
    n_args++;
    grn_expr_append_const_int(efsi->ctx, efsi->e, min_interval,
                              GRN_OP_PUSH, 1);
    n_args++;
  } while (false);
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_NEAR_PHRASE_PRODUCT, n_args);
}
#line 2521 "grn_ecmascript.c"
        break;
      case 45: /* relational_expression ::= relational_expression ORDERED_NEAR_PHRASE_PRODUCT shift_expression */
#line 547 "grn_ecmascript.lemon"
{
  int n_args = 2;
  do {
    int max_interval;
    GRN_INT32_POP(&efsi->max_interval_stack, max_interval);
    grn_expr_append_const_int(efsi->ctx, efsi->e, max_interval,
                              GRN_OP_PUSH, 1);
    n_args++;
    int additional_last_interval;
    GRN_INT32_POP(&efsi->additional_last_interval_stack,
                  additional_last_interval);
    grn_expr_append_const_int(efsi->ctx, efsi->e, additional_last_interval,
                              GRN_OP_PUSH, 1);
    n_args++;
    grn_obj *max_element_intervals;
    GRN_PTR_POP(&efsi->max_element_intervals_stack,
                max_element_intervals);
    int min_interval;
    GRN_INT32_POP(&efsi->min_interval_stack, min_interval);
    if (!max_element_intervals) {
      break;
    }
    grn_expr_append_obj(efsi->ctx, efsi->e, max_element_intervals,
                        GRN_OP_PUSH, 1);
    grn_expr_take_obj(efsi->ctx, efsi->e, max_element_intervals);
    n_args++;
    grn_expr_append_const_int(efsi->ctx, efsi->e, min_interval,
                              GRN_OP_PUSH, 1);
    n_args++;
  } while (false);
  grn_expr_append_op(efsi->ctx,
                     efsi->e,
                     GRN_OP_ORDERED_NEAR_PHRASE_PRODUCT,
                     n_args);
}
#line 2560 "grn_ecmascript.c"
        break;
      case 46: /* relational_expression ::= relational_expression SIMILAR shift_expression */
#line 582 "grn_ecmascript.lemon"
{
  {
    int similarity_threshold;
    GRN_INT32_POP(&efsi->similarity_threshold_stack, similarity_threshold);
    grn_expr_append_const_int(efsi->ctx, efsi->e, similarity_threshold,
                              GRN_OP_PUSH, 1);
  }
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_SIMILAR, 3);
}
#line 2573 "grn_ecmascript.c"
        break;
      case 47: /* relational_expression ::= relational_expression TERM_EXTRACT shift_expression */
#line 591 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_TERM_EXTRACT, 2);
}
#line 2580 "grn_ecmascript.c"
        break;
      case 48: /* relational_expression ::= relational_expression QUORUM shift_expression */
#line 594 "grn_ecmascript.lemon"
{
  {
    int quorum_threshold;
    GRN_INT32_POP(&efsi->quorum_threshold_stack, quorum_threshold);
    grn_expr_append_const_int(efsi->ctx, efsi->e, quorum_threshold,
                              GRN_OP_PUSH, 1);
  }
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_QUORUM, 3);
}
#line 2593 "grn_ecmascript.c"
        break;
      case 49: /* relational_expression ::= relational_expression LCP shift_expression */
#line 603 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_LCP, 2);
}
#line 2600 "grn_ecmascript.c"
        break;
      case 50: /* relational_expression ::= relational_expression PREFIX shift_expression */
#line 606 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_PREFIX, 2);
}
#line 2607 "grn_ecmascript.c"
        break;
      case 51: /* relational_expression ::= relational_expression SUFFIX shift_expression */
#line 609 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_SUFFIX, 2);
}
#line 2614 "grn_ecmascript.c"
        break;
      case 52: /* relational_expression ::= relational_expression REGEXP shift_expression */
#line 612 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_REGEXP, 2);
}
#line 2621 "grn_ecmascript.c"
        break;
      case 53: /* shift_expression ::= shift_expression SHIFTL additive_expression */
#line 617 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_SHIFTL, 2);
}
#line 2628 "grn_ecmascript.c"
        break;
      case 54: /* shift_expression ::= shift_expression SHIFTR additive_expression */
#line 620 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_SHIFTR, 2);
}
#line 2635 "grn_ecmascript.c"
        break;
      case 55: /* shift_expression ::= shift_expression SHIFTRR additive_expression */
#line 623 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_SHIFTRR, 2);
}
#line 2642 "grn_ecmascript.c"
        break;
      case 56: /* additive_expression ::= additive_expression PLUS multiplicative_expression */
      case 95: /* adjuster ::= adjuster PLUS adjust_expression */ yytestcase(yyruleno==95);
#line 628 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_PLUS, 2);
}
#line 2650 "grn_ecmascript.c"
        break;
      case 57: /* additive_expression ::= additive_expression MINUS multiplicative_expression */
#line 631 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_MINUS, 2);
}
#line 2657 "grn_ecmascript.c"
        break;
      case 58: /* multiplicative_expression ::= multiplicative_expression STAR unary_expression */
      case 96: /* adjust_expression ::= adjust_match_expression STAR DECIMAL */ yytestcase(yyruleno==96);
#line 636 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_STAR, 2);
}
#line 2665 "grn_ecmascript.c"
        break;
      case 59: /* multiplicative_expression ::= multiplicative_expression SLASH unary_expression */
#line 639 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_SLASH, 2);
}
#line 2672 "grn_ecmascript.c"
        break;
      case 60: /* multiplicative_expression ::= multiplicative_expression MOD unary_expression */
#line 642 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_MOD, 2);
}
#line 2679 "grn_ecmascript.c"
        break;
      case 61: /* unary_expression ::= DELETE unary_expression */
#line 647 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_DELETE, 1);
}
#line 2686 "grn_ecmascript.c"
        break;
      case 62: /* unary_expression ::= INCR unary_expression */
#line 650 "grn_ecmascript.lemon"
{
  grn_ctx *ctx = efsi->ctx;
  grn_expr *e = (grn_expr *)(efsi->e);
  grn_expr_dfi *dfi_;
  unsigned int const_p;

  dfi_ = grn_expr_dfi_pop(e);
  const_p = CONSTP(dfi_->code->value);
  grn_expr_dfi_put(ctx, e, dfi_->type, dfi_->domain, dfi_->code);
  if (const_p) {
    ERR(GRN_SYNTAX_ERROR,
        "constant can't be incremented: <%.*s>",
        (int)(efsi->str_end - efsi->str), efsi->str);
  } else {
    grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_INCR, 1);
  }
}
#line 2707 "grn_ecmascript.c"
        break;
      case 63: /* unary_expression ::= DECR unary_expression */
#line 667 "grn_ecmascript.lemon"
{
  grn_ctx *ctx = efsi->ctx;
  grn_expr *e = (grn_expr *)(efsi->e);
  grn_expr_dfi *dfi_;
  unsigned int const_p;

  dfi_ = grn_expr_dfi_pop(e);
  const_p = CONSTP(dfi_->code->value);
  grn_expr_dfi_put(ctx, e, dfi_->type, dfi_->domain, dfi_->code);
  if (const_p) {
    ERR(GRN_SYNTAX_ERROR,
        "constant can't be decremented: <%.*s>",
        (int)(efsi->str_end - efsi->str), efsi->str);
  } else {
    grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_DECR, 1);
  }
}
#line 2728 "grn_ecmascript.c"
        break;
      case 64: /* unary_expression ::= PLUS unary_expression */
#line 684 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_PLUS, 1);
}
#line 2735 "grn_ecmascript.c"
        break;
      case 65: /* unary_expression ::= MINUS unary_expression */
#line 687 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_MINUS, 1);
}
#line 2742 "grn_ecmascript.c"
        break;
      case 66: /* unary_expression ::= NOT unary_expression */
#line 690 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_NOT, 1);
}
#line 2749 "grn_ecmascript.c"
        break;
      case 67: /* unary_expression ::= BITWISE_NOT unary_expression */
#line 693 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_BITWISE_NOT, 1);
}
#line 2756 "grn_ecmascript.c"
        break;
      case 68: /* unary_expression ::= ADJUST unary_expression */
#line 696 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_ADJUST, 1);
}
#line 2763 "grn_ecmascript.c"
        break;
      case 69: /* unary_expression ::= EXACT unary_expression */
#line 699 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_EXACT, 1);
}
#line 2770 "grn_ecmascript.c"
        break;
      case 70: /* unary_expression ::= PARTIAL unary_expression */
#line 702 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_PARTIAL, 1);
}
#line 2777 "grn_ecmascript.c"
        break;
      case 71: /* unary_expression ::= UNSPLIT unary_expression */
#line 705 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_UNSPLIT, 1);
}
#line 2784 "grn_ecmascript.c"
        break;
      case 72: /* postfix_expression ::= lefthand_side_expression INCR */
#line 710 "grn_ecmascript.lemon"
{
  grn_ctx *ctx = efsi->ctx;
  grn_expr *e = (grn_expr *)(efsi->e);
  grn_expr_dfi *dfi_;
  unsigned int const_p;

  dfi_ = grn_expr_dfi_pop(e);
  const_p = CONSTP(dfi_->code->value);
  grn_expr_dfi_put(ctx, e, dfi_->type, dfi_->domain, dfi_->code);
  if (const_p) {
    ERR(GRN_SYNTAX_ERROR,
        "constant can't be incremented: <%.*s>",
        (int)(efsi->str_end - efsi->str), efsi->str);
  } else {
    grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_INCR_POST, 1);
  }
}
#line 2805 "grn_ecmascript.c"
        break;
      case 73: /* postfix_expression ::= lefthand_side_expression DECR */
#line 727 "grn_ecmascript.lemon"
{
  grn_ctx *ctx = efsi->ctx;
  grn_expr *e = (grn_expr *)(efsi->e);
  grn_expr_dfi *dfi_;
  unsigned int const_p;

  dfi_ = grn_expr_dfi_pop(e);
  const_p = CONSTP(dfi_->code->value);
  grn_expr_dfi_put(ctx, e, dfi_->type, dfi_->domain, dfi_->code);
  if (const_p) {
    ERR(GRN_SYNTAX_ERROR,
        "constant can't be decremented: <%.*s>",
        (int)(efsi->str_end - efsi->str), efsi->str);
  } else {
    grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_DECR_POST, 1);
  }
}
#line 2826 "grn_ecmascript.c"
        break;
      case 74: /* call_expression ::= member_expression arguments */
#line 748 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_CALL, yymsp[0].minor.yy0);
}
#line 2833 "grn_ecmascript.c"
        break;
      case 75: /* array_literal ::= BRACKETL element_list BRACKETR */
#line 765 "grn_ecmascript.lemon"
{
  array_literal_end(efsi, yymsp[-1].minor.yy0);
}
#line 2840 "grn_ecmascript.c"
        break;
      case 76: /* element_list ::= */
      case 80: /* property_list ::= */ yytestcase(yyruleno==80);
      case 88: /* output_columns ::= */ yytestcase(yyruleno==88);
      case 98: /* sort_keys ::= */ yytestcase(yyruleno==98);
#line 769 "grn_ecmascript.lemon"
{
  yymsp[1].minor.yy0 = 0;
}
#line 2850 "grn_ecmascript.c"
        break;
      case 77: /* element_list ::= assignment_expression */
      case 81: /* property_list ::= property */ yytestcase(yyruleno==81);
      case 94: /* output_column ::= assignment_expression */ yytestcase(yyruleno==94);
      case 103: /* sort_key ::= assignment_expression */ yytestcase(yyruleno==103);
#line 772 "grn_ecmascript.lemon"
{
  yymsp[0].minor.yy0 = 1;
}
#line 2860 "grn_ecmascript.c"
        break;
      case 78: /* element_list ::= element_list COMMA assignment_expression */
      case 82: /* property_list ::= property_list COMMA property */ yytestcase(yyruleno==82);
#line 775 "grn_ecmascript.lemon"
{
  yylhsminor.yy0 = yymsp[-2].minor.yy0 + 1;
}
#line 2868 "grn_ecmascript.c"
  yymsp[-2].minor.yy0 = yylhsminor.yy0;
        break;
      case 79: /* object_literal ::= BRACEL property_list BRACER */
#line 779 "grn_ecmascript.lemon"
{
  object_literal_end(efsi, yymsp[-1].minor.yy0);
}
#line 2876 "grn_ecmascript.c"
        break;
      case 83: /* member_expression_part ::= BRACKETL expression BRACKETR */
#line 796 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_GET_MEMBER, 2);
}
#line 2883 "grn_ecmascript.c"
        break;
      case 84: /* arguments ::= PARENL argument_list PARENR */
#line 801 "grn_ecmascript.lemon"
{ yymsp[-2].minor.yy0 = yymsp[-1].minor.yy0; }
#line 2888 "grn_ecmascript.c"
        break;
      case 85: /* argument_list ::= */
#line 802 "grn_ecmascript.lemon"
{ yymsp[1].minor.yy0 = 0; }
#line 2893 "grn_ecmascript.c"
        break;
      case 86: /* argument_list ::= assignment_expression */
#line 803 "grn_ecmascript.lemon"
{ yymsp[0].minor.yy0 = 1; }
#line 2898 "grn_ecmascript.c"
        break;
      case 87: /* argument_list ::= argument_list COMMA assignment_expression */
#line 804 "grn_ecmascript.lemon"
{ yylhsminor.yy0 = yymsp[-2].minor.yy0 + 1; }
#line 2903 "grn_ecmascript.c"
  yymsp[-2].minor.yy0 = yylhsminor.yy0;
        break;
      case 89: /* output_columns ::= output_column */
      case 99: /* sort_keys ::= sort_key */ yytestcase(yyruleno==99);
#line 809 "grn_ecmascript.lemon"
{
  yylhsminor.yy0 = yymsp[0].minor.yy0;
}
#line 2912 "grn_ecmascript.c"
  yymsp[0].minor.yy0 = yylhsminor.yy0;
        break;
      case 90: /* output_columns ::= output_columns COMMA */
#line 814 "grn_ecmascript.lemon"
{
  yylhsminor.yy0 = yymsp[-1].minor.yy0;
}
#line 2920 "grn_ecmascript.c"
  yymsp[-1].minor.yy0 = yylhsminor.yy0;
        break;
      case 91: /* output_columns ::= output_columns COMMA output_column */
      case 100: /* sort_keys ::= sort_keys COMMA sort_key */ yytestcase(yyruleno==100);
#line 819 "grn_ecmascript.lemon"
{
  if (yymsp[-2].minor.yy0 == 0) {
    yylhsminor.yy0 = yymsp[0].minor.yy0;
  } else if (yymsp[0].minor.yy0 == 0) {
    yylhsminor.yy0 = yymsp[-2].minor.yy0;
  } else {
    if (yymsp[0].minor.yy0 == 1) {
      grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_COMMA, 2);
    }
    yylhsminor.yy0 = 1;
  }
}
#line 2938 "grn_ecmascript.c"
  yymsp[-2].minor.yy0 = yylhsminor.yy0;
        break;
      case 92: /* output_column ::= STAR */
#line 832 "grn_ecmascript.lemon"
{
  grn_ctx *ctx = efsi->ctx;
  grn_obj *expr = efsi->e;
  grn_obj *variable = grn_expr_get_var_by_offset(ctx, expr, 0);
  if (variable) {
    grn_id table_id = GRN_OBJ_GET_DOMAIN(variable);
    grn_obj *table = grn_ctx_at(ctx, table_id);
    grn_obj columns_buffer;
    int n_columns;
    grn_obj **columns;

    GRN_PTR_INIT(&columns_buffer, GRN_OBJ_VECTOR, GRN_ID_NIL);
    grn_obj_columns(ctx, table, "*", strlen("*"), &columns_buffer);
    n_columns = GRN_BULK_VSIZE(&columns_buffer) / sizeof(grn_obj *);
    columns = (grn_obj **)GRN_BULK_HEAD(&columns_buffer);

    if (n_columns == 0) {
      /* do nothing */
    } else if (n_columns == 1) {
      grn_obj *column = columns[0];
      grn_expr_append_const(ctx, expr, column, GRN_OP_GET_VALUE, 1);
      grn_expr_take_obj(ctx, expr, column);
    } else {
      grn_expr *e = (grn_expr *)expr;
      grn_bool have_column;
      int i;

      have_column = (e->codes_curr > 0);
      for (i = 0; i < n_columns; i++) {
        grn_obj *column = columns[i];
        grn_expr_append_const(ctx, expr, column, GRN_OP_GET_VALUE, 1);
        if (have_column || i > 0) {
          grn_expr_append_op(ctx, expr, GRN_OP_COMMA, 2);
        }
        grn_expr_take_obj(ctx, expr, column);
      }
    }

    grn_obj_unref(ctx, table);
    GRN_OBJ_FIN(ctx, &columns_buffer);

    yymsp[0].minor.yy0 = n_columns;
  } else {
    /* TODO: report error */
    yymsp[0].minor.yy0 = 0;
  }
}
#line 2990 "grn_ecmascript.c"
        break;
      case 93: /* output_column ::= NONEXISTENT_COLUMN */
      case 101: /* sort_key ::= NONEXISTENT_COLUMN */ yytestcase(yyruleno==101);
#line 879 "grn_ecmascript.lemon"
{
  yymsp[0].minor.yy0 = 0;
}
#line 2998 "grn_ecmascript.c"
        break;
      case 102: /* sort_key ::= MINUS NONEXISTENT_COLUMN */
#line 925 "grn_ecmascript.lemon"
{
  yymsp[-1].minor.yy0 = 0;
}
#line 3005 "grn_ecmascript.c"
        break;
      default:
      /* (104) input ::= query */ yytestcase(yyruleno==104);
      /* (105) input ::= expression */ yytestcase(yyruleno==105);
      /* (106) input ::= START_OUTPUT_COLUMNS output_columns */ yytestcase(yyruleno==106);
      /* (107) input ::= START_ADJUSTER adjuster */ yytestcase(yyruleno==107);
      /* (108) input ::= START_SORT_KEYS sort_keys */ yytestcase(yyruleno==108);
      /* (109) input ::= START_OPTIONS object_literal */ yytestcase(yyruleno==109);
      /* (110) input ::= START_QUERY_NO_SYNTAX_ERROR */ yytestcase(yyruleno==110);
      /* (111) input ::= START_QUERY_NO_SYNTAX_ERROR query */ yytestcase(yyruleno==111);
      /* (112) query ::= query_element (OPTIMIZED OUT) */ assert(yyruleno!=112);
      /* (113) query_element ::= QSTRING */ yytestcase(yyruleno==113);
      /* (114) query_element ::= PARENL query PARENR */ yytestcase(yyruleno==114);
      /* (115) expression ::= assignment_expression (OPTIMIZED OUT) */ assert(yyruleno!=115);
      /* (116) assignment_expression ::= conditional_expression (OPTIMIZED OUT) */ assert(yyruleno!=116);
      /* (117) conditional_expression ::= logical_or_expression */ yytestcase(yyruleno==117);
      /* (118) logical_or_expression ::= logical_and_expression */ yytestcase(yyruleno==118);
      /* (119) logical_and_expression ::= bitwise_or_expression */ yytestcase(yyruleno==119);
      /* (120) bitwise_or_expression ::= bitwise_xor_expression */ yytestcase(yyruleno==120);
      /* (121) bitwise_xor_expression ::= bitwise_and_expression */ yytestcase(yyruleno==121);
      /* (122) bitwise_and_expression ::= equality_expression */ yytestcase(yyruleno==122);
      /* (123) equality_expression ::= relational_expression */ yytestcase(yyruleno==123);
      /* (124) relational_expression ::= shift_expression */ yytestcase(yyruleno==124);
      /* (125) shift_expression ::= additive_expression */ yytestcase(yyruleno==125);
      /* (126) additive_expression ::= multiplicative_expression */ yytestcase(yyruleno==126);
      /* (127) multiplicative_expression ::= unary_expression (OPTIMIZED OUT) */ assert(yyruleno!=127);
      /* (128) unary_expression ::= postfix_expression (OPTIMIZED OUT) */ assert(yyruleno!=128);
      /* (129) postfix_expression ::= lefthand_side_expression */ yytestcase(yyruleno==129);
      /* (130) lefthand_side_expression ::= call_expression (OPTIMIZED OUT) */ assert(yyruleno!=130);
      /* (131) lefthand_side_expression ::= member_expression */ yytestcase(yyruleno==131);
      /* (132) member_expression ::= primary_expression (OPTIMIZED OUT) */ assert(yyruleno!=132);
      /* (133) member_expression ::= member_expression member_expression_part */ yytestcase(yyruleno==133);
      /* (134) primary_expression ::= object_literal (OPTIMIZED OUT) */ assert(yyruleno!=134);
      /* (135) primary_expression ::= PARENL expression PARENR */ yytestcase(yyruleno==135);
      /* (136) primary_expression ::= IDENTIFIER */ yytestcase(yyruleno==136);
      /* (137) primary_expression ::= array_literal (OPTIMIZED OUT) */ assert(yyruleno!=137);
      /* (138) primary_expression ::= DECIMAL */ yytestcase(yyruleno==138);
      /* (139) primary_expression ::= HEX_INTEGER */ yytestcase(yyruleno==139);
      /* (140) primary_expression ::= STRING */ yytestcase(yyruleno==140);
      /* (141) primary_expression ::= BOOLEAN */ yytestcase(yyruleno==141);
      /* (142) primary_expression ::= NULL */ yytestcase(yyruleno==142);
      /* (143) property ::= property_name COLON assignment_expression */ yytestcase(yyruleno==143);
      /* (144) property_name ::= STRING */ yytestcase(yyruleno==144);
      /* (145) member_expression_part ::= DOT IDENTIFIER */ yytestcase(yyruleno==145);
      /* (146) adjuster ::= */ yytestcase(yyruleno==146);
      /* (147) adjuster ::= adjust_expression (OPTIMIZED OUT) */ assert(yyruleno!=147);
      /* (148) adjust_expression ::= adjust_match_expression */ yytestcase(yyruleno==148);
        break;
/********** End reduce actions ************************************************/
  };
  assert( yyruleno<sizeof(yyRuleInfoLhs)/sizeof(yyRuleInfoLhs[0]) );
  yygoto = yyRuleInfoLhs[yyruleno];
  yysize = yyRuleInfoNRhs[yyruleno];
  yyact = yy_find_reduce_action(yymsp[yysize].stateno,(YYCODETYPE)yygoto);

  /* There are no SHIFTREDUCE actions on nonterminals because the table
  ** generator has simplified them to pure REDUCE actions. */
  assert( !(yyact>YY_MAX_SHIFT && yyact<=YY_MAX_SHIFTREDUCE) );

  /* It is not possible for a REDUCE to be followed by an error */
  assert( yyact!=YY_ERROR_ACTION );

  yymsp += yysize+1;
  yypParser->yytos = yymsp;
  yymsp->stateno = (YYACTIONTYPE)yyact;
  yymsp->major = (YYCODETYPE)yygoto;
  yyTraceShift(yypParser, yyact, "... then shift");
  return yyact;
}

/*
** The following code executes when the parse fails
*/
#ifndef YYNOERRORRECOVERY
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  grn_expr_parserARG_FETCH
  grn_expr_parserCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
/************ Begin %parse_failure code ***************************************/
/************ End %parse_failure code *****************************************/
  grn_expr_parserARG_STORE /* Suppress warning about unused %extra_argument variable */
  grn_expr_parserCTX_STORE
}
#endif /* YYNOERRORRECOVERY */

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  grn_expr_parserTOKENTYPE yyminor         /* The minor type of the error token */
){
  grn_expr_parserARG_FETCH
  grn_expr_parserCTX_FETCH
#define TOKEN yyminor
/************ Begin %syntax_error code ****************************************/
#line 180 "grn_ecmascript.lemon"

  {
    grn_ctx *ctx = efsi->ctx;
    grn_obj message;
    GRN_TEXT_INIT(&message, 0);
    GRN_TEXT_PUT(ctx, &message, efsi->str, efsi->cur - efsi->str);
    GRN_TEXT_PUTC(ctx, &message, '|');
    if (efsi->cur < efsi->str_end) {
      GRN_TEXT_PUTC(ctx, &message, efsi->cur[0]);
      GRN_TEXT_PUTC(ctx, &message, '|');
      GRN_TEXT_PUT(ctx, &message,
                   efsi->cur + 1, efsi->str_end - (efsi->cur + 1));
    } else {
      GRN_TEXT_PUTC(ctx, &message, '|');
    }
    if (ctx->rc == GRN_SUCCESS) {
      ERR(GRN_SYNTAX_ERROR, "Syntax error: <%.*s>",
          (int)GRN_TEXT_LEN(&message), GRN_TEXT_VALUE(&message));
    } else {
      char errbuf[GRN_CTX_MSGSIZE];
      grn_strcpy(errbuf, GRN_CTX_MSGSIZE, ctx->errbuf);
      ERR(ctx->rc, "Syntax error: <%.*s>: %s",
          (int)GRN_TEXT_LEN(&message), GRN_TEXT_VALUE(&message),
          errbuf);
    }
    GRN_OBJ_FIN(ctx, &message);
  }
#line 3140 "grn_ecmascript.c"
/************ End %syntax_error code ******************************************/
  grn_expr_parserARG_STORE /* Suppress warning about unused %extra_argument variable */
  grn_expr_parserCTX_STORE
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  grn_expr_parserARG_FETCH
  grn_expr_parserCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  assert( yypParser->yytos==yypParser->yystack );
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
/*********** Begin %parse_accept code *****************************************/
/*********** End %parse_accept code *******************************************/
  grn_expr_parserARG_STORE /* Suppress warning about unused %extra_argument variable */
  grn_expr_parserCTX_STORE
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "grn_expr_parserAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void grn_expr_parser(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  grn_expr_parserTOKENTYPE yyminor       /* The value for the token */
  grn_expr_parserARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  YYACTIONTYPE yyact;   /* The parser action. */
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  int yyendofinput;     /* True if we are at the end of input */
#endif
#ifdef YYERRORSYMBOL
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
#endif
  yyParser *yypParser = (yyParser*)yyp;  /* The parser */
  grn_expr_parserCTX_FETCH
  grn_expr_parserARG_STORE

  assert( yypParser->yytos!=0 );
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  yyendofinput = (yymajor==0);
#endif

  yyact = yypParser->yytos->stateno;
#ifndef NDEBUG
  if( yyTraceFILE ){
    if( yyact < YY_MIN_REDUCE ){
      fprintf(yyTraceFILE,"%sInput '%s' in state %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact);
    }else{
      fprintf(yyTraceFILE,"%sInput '%s' with pending reduce %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact-YY_MIN_REDUCE);
    }
  }
#endif

  while(1){ /* Exit by "break" */
    assert( yypParser->yytos>=yypParser->yystack );
    assert( yyact==yypParser->yytos->stateno );
    yyact = yy_find_shift_action((YYCODETYPE)yymajor,yyact);
    if( yyact >= YY_MIN_REDUCE ){
      unsigned int yyruleno = yyact - YY_MIN_REDUCE; /* Reduce by this rule */
#ifndef NDEBUG
      assert( yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) );
      if( yyTraceFILE ){
        int yysize = yyRuleInfoNRhs[yyruleno];
        if( yysize ){
          fprintf(yyTraceFILE, "%sReduce %d [%s]%s, pop back to state %d.\n",
            yyTracePrompt,
            yyruleno, yyRuleName[yyruleno],
            yyruleno<YYNRULE_WITH_ACTION ? "" : " without external action",
            yypParser->yytos[yysize].stateno);
        }else{
          fprintf(yyTraceFILE, "%sReduce %d [%s]%s.\n",
            yyTracePrompt, yyruleno, yyRuleName[yyruleno],
            yyruleno<YYNRULE_WITH_ACTION ? "" : " without external action");
        }
      }
#endif /* NDEBUG */

      /* Check that the stack is large enough to grow by a single entry
      ** if the RHS of the rule is empty.  This ensures that there is room
      ** enough on the stack to push the LHS value */
      if( yyRuleInfoNRhs[yyruleno]==0 ){
#ifdef YYTRACKMAXSTACKDEPTH
        if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
          yypParser->yyhwm++;
          assert( yypParser->yyhwm ==
                  (int)(yypParser->yytos - yypParser->yystack));
        }
#endif
#if YYSTACKDEPTH>0 
        if( yypParser->yytos>=yypParser->yystackEnd ){
          yyStackOverflow(yypParser);
          break;
        }
#else
        if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz-1] ){
          if( yyGrowStack(yypParser) ){
            yyStackOverflow(yypParser);
            break;
          }
        }
#endif
      }
      yyact = yy_reduce(yypParser,yyruleno,yymajor,yyminor grn_expr_parserCTX_PARAM);
    }else if( yyact <= YY_MAX_SHIFTREDUCE ){
      yy_shift(yypParser,yyact,(YYCODETYPE)yymajor,yyminor);
#ifndef YYNOERRORRECOVERY
      yypParser->yyerrcnt--;
#endif
      break;
    }else if( yyact==YY_ACCEPT_ACTION ){
      yypParser->yytos--;
      yy_accept(yypParser);
      return;
    }else{
      assert( yyact == YY_ERROR_ACTION );
      yyminorunion.yy0 = yyminor;
#ifdef YYERRORSYMBOL
      int yymx;
#endif
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminor);
      }
      yymx = yypParser->yytos->major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yypParser, (YYCODETYPE)yymajor, &yyminorunion);
        yymajor = YYNOCODE;
      }else{
        while( yypParser->yytos > yypParser->yystack ){
          yyact = yy_find_reduce_action(yypParser->yytos->stateno,
                                        YYERRORSYMBOL);
          if( yyact<=YY_MAX_SHIFTREDUCE ) break;
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yytos <= yypParser->yystack || yymajor==0 ){
          yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
          yypParser->yyerrcnt = -1;
#endif
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          yy_shift(yypParser,yyact,YYERRORSYMBOL,yyminor);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
      if( yymajor==YYNOCODE ) break;
      yyact = yypParser->yytos->stateno;
#elif defined(YYNOERRORRECOVERY)
      /* If the YYNOERRORRECOVERY macro is defined, then do not attempt to
      ** do any kind of error recovery.  Instead, simply invoke the syntax
      ** error routine and continue going as if nothing had happened.
      **
      ** Applications can set this macro (for example inside %include) if
      ** they intend to abandon the parse upon the first syntax error seen.
      */
      yy_syntax_error(yypParser,yymajor, yyminor);
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      break;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor, yyminor);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
        yypParser->yyerrcnt = -1;
#endif
      }
      break;
#endif
    }
  }
#ifndef NDEBUG
  if( yyTraceFILE ){
    yyStackEntry *i;
    char cDiv = '[';
    fprintf(yyTraceFILE,"%sReturn. Stack=",yyTracePrompt);
    for(i=&yypParser->yystack[1]; i<=yypParser->yytos; i++){
      fprintf(yyTraceFILE,"%c%s", cDiv, yyTokenName[i->major]);
      cDiv = ' ';
    }
    fprintf(yyTraceFILE,"]\n");
  }
#endif
  return;
}

/*
** Return the fallback token corresponding to canonical token iToken, or
** 0 if iToken has no fallback.
*/
int grn_expr_parserFallback(int iToken){
#ifdef YYFALLBACK
  assert( iToken<(int)(sizeof(yyFallback)/sizeof(yyFallback[0])) );
  return yyFallback[iToken];
#else
  (void)iToken;
  return 0;
#endif
}
