/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */

/* This file is automatically generated using bindtool */

#include <pybind11/complex.h>
#include <pybind11/pybind11.h>
#include <pybind11/stl.h>

namespace py = pybind11;

#include <gnuradio/qtgui/utils.h>
#include <qwt_legend.h>
#include <qwt_painter.h>
#include <qwt_plot.h>
#include <qwt_plot_canvas.h>
#include <qwt_plot_curve.h>
#include <qwt_plot_magnifier.h>
#include <qwt_plot_marker.h>
#include <qwt_plot_panner.h>
#include <qwt_plot_zoomer.h>
#include <qwt_scale_engine.h>
#include <qwt_scale_widget.h>
#include <qwt_symbol.h>

#include <gnuradio/qtgui/const_sink_c.h>
// pydoc.h is automatically generated in the build directory
#include <const_sink_c_pydoc.h>

void bind_const_sink_c(py::module& m)
{

    using const_sink_c = ::gr::qtgui::const_sink_c;


    py::class_<const_sink_c,
               gr::sync_block,
               gr::block,
               gr::basic_block,
               std::shared_ptr<const_sink_c>>(m, "const_sink_c", D(const_sink_c))

        .def(py::init(&const_sink_c::make),
             py::arg("size"),
             py::arg("name"),
             py::arg("nconnections") = 1,
             py::arg("parent") = nullptr,
             D(const_sink_c, make))


        .def("exec_", &const_sink_c::exec_, D(const_sink_c, exec_))


        .def(
            "qwidget",
            [](const_sink_c& self) {
                return reinterpret_cast<uintptr_t>(self.qwidget());
            },
            D(const_sink_c, qwidget))


        .def("set_y_axis",
             &const_sink_c::set_y_axis,
             py::arg("min"),
             py::arg("max"),
             D(const_sink_c, set_y_axis))


        .def("set_x_axis",
             &const_sink_c::set_x_axis,
             py::arg("min"),
             py::arg("max"),
             D(const_sink_c, set_x_axis))


        .def("set_update_time",
             &const_sink_c::set_update_time,
             py::arg("t"),
             D(const_sink_c, set_update_time))


        .def("set_title",
             &const_sink_c::set_title,
             py::arg("title"),
             D(const_sink_c, set_title))


        .def("set_line_label",
             &const_sink_c::set_line_label,
             py::arg("which"),
             py::arg("label"),
             D(const_sink_c, set_line_label))


        .def("set_line_color",
             &const_sink_c::set_line_color,
             py::arg("which"),
             py::arg("color"),
             D(const_sink_c, set_line_color))


        .def("set_line_width",
             &const_sink_c::set_line_width,
             py::arg("which"),
             py::arg("width"),
             D(const_sink_c, set_line_width))


        .def("set_line_style",
             &const_sink_c::set_line_style,
             py::arg("which"),
             py::arg("style"),
             D(const_sink_c, set_line_style))


        .def("set_line_marker",
             &const_sink_c::set_line_marker,
             py::arg("which"),
             py::arg("marker"),
             D(const_sink_c, set_line_marker))


        .def("set_nsamps",
             &const_sink_c::set_nsamps,
             py::arg("newsize"),
             D(const_sink_c, set_nsamps))


        .def("set_line_alpha",
             &const_sink_c::set_line_alpha,
             py::arg("which"),
             py::arg("alpha"),
             D(const_sink_c, set_line_alpha))


        .def("set_trigger_mode",
             &const_sink_c::set_trigger_mode,
             py::arg("mode"),
             py::arg("slope"),
             py::arg("level"),
             py::arg("channel"),
             py::arg("tag_key") = "",
             D(const_sink_c, set_trigger_mode))


        .def("title", &const_sink_c::title, D(const_sink_c, title))


        .def("line_label",
             &const_sink_c::line_label,
             py::arg("which"),
             D(const_sink_c, line_label))


        .def("line_color",
             &const_sink_c::line_color,
             py::arg("which"),
             D(const_sink_c, line_color))


        .def("line_width",
             &const_sink_c::line_width,
             py::arg("which"),
             D(const_sink_c, line_width))


        .def("line_style",
             &const_sink_c::line_style,
             py::arg("which"),
             D(const_sink_c, line_style))


        .def("line_marker",
             &const_sink_c::line_marker,
             py::arg("which"),
             D(const_sink_c, line_marker))


        .def("line_alpha",
             &const_sink_c::line_alpha,
             py::arg("which"),
             D(const_sink_c, line_alpha))


        .def("set_size",
             &const_sink_c::set_size,
             py::arg("width"),
             py::arg("height"),
             D(const_sink_c, set_size))


        .def("enable_menu",
             &const_sink_c::enable_menu,
             py::arg("en") = true,
             D(const_sink_c, enable_menu))


        .def("enable_autoscale",
             &const_sink_c::enable_autoscale,
             py::arg("en"),
             D(const_sink_c, enable_autoscale))


        .def("enable_grid",
             &const_sink_c::enable_grid,
             py::arg("en"),
             D(const_sink_c, enable_grid))


        .def("enable_axis_labels",
             &const_sink_c::enable_axis_labels,
             py::arg("en") = true,
             D(const_sink_c, enable_axis_labels))


        .def("disable_legend",
             &const_sink_c::disable_legend,
             D(const_sink_c, disable_legend))


        .def("nsamps", &const_sink_c::nsamps, D(const_sink_c, nsamps))


        .def("reset", &const_sink_c::reset, D(const_sink_c, reset))

        ;
}
