;; NOTE: Assertions have been generated by update_lit_checks.py --all-items and should not be edited.
;; RUN: foreach %s %t wasm-opt -all --gufa -S -o - | filecheck %s

(module
  ;; CHECK:      (type $0 (func (param externref anyref)))

  ;; CHECK:      (export "externals" (func $externals))

  ;; CHECK:      (func $externals (type $0) (param $ext externref) (param $any anyref)
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (ref.cast (ref struct)
  ;; CHECK-NEXT:    (any.convert_extern
  ;; CHECK-NEXT:     (local.get $ext)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (extern.convert_any
  ;; CHECK-NEXT:    (local.get $any)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $externals (export "externals") (param $ext externref) (param $any anyref)
    ;; We must not turn these into unreachable code, as the function is
    ;; exported.
    (drop
      (ref.cast (ref struct)
        (any.convert_extern
          (local.get $ext)
        )
      )
    )
    (drop
      (extern.convert_any
        (local.get $any)
      )
    )
  )

  ;; CHECK:      (func $non-exported (type $0) (param $ext externref) (param $any anyref)
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (block ;; (replaces unreachable RefCast we can't emit)
  ;; CHECK-NEXT:    (drop
  ;; CHECK-NEXT:     (any.convert_extern
  ;; CHECK-NEXT:      (unreachable)
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (unreachable)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (extern.convert_any
  ;; CHECK-NEXT:    (unreachable)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $non-exported (param $ext externref) (param $any anyref)
    ;; This is not exported, so the params are dead code, and can be turned
    ;; unreachable.
    (drop
      (ref.cast (ref struct)
        (any.convert_extern
          (local.get $ext)
        )
      )
    )
    (drop
      (extern.convert_any
        (local.get $any)
      )
    )
  )
)
