#ifndef _FSMSTATE_H_INCLUDED_
#define _FSMSTATE_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// FSMState.h
// ----------
// Dragon final state machine state class definition
//                                                         
// (C)opyright 2007 by Bjoern Lemke
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.  If not, write to
// the Free Software Foundation, 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
//
// INTERFACE MODULE
//
// Class: FSMState
// 
// Description: description of a state of the dragon final state machine
//
///////////////////////////////////////////////////////////////////////////////

#include <lfcbase/Chain.h>

// DEFINES

enum StateType { START, FINAL, ANY, NONE };

#define EPSILON 0


class FSMState {

 public:

  FSMState();
  FSMState(const FSMState& x);
  FSMState(unsigned long num, StateType type = NONE, const Chain& token = "");
  ~FSMState();
  void setType(StateType type);
  unsigned long Num();
  StateType Type();
  const Chain& Token();
  FSMState operator = (const FSMState& x);
  bool operator < (FSMState x);
  bool operator > (FSMState x);
  bool operator == (FSMState x);

  friend ostream& operator << (ostream& s, FSMState& x);
    
 private:

  StateType _type;
  unsigned long _num;
  Chain _token;
};


#endif



