/*
This file is auto-generated from the public API of the zstd library.
It is released under the same BSD license.

BSD License

For Zstandard software

Copyright (c) Meta Platforms, Inc. and affiliates. All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

 * Redistributions of source code must retain the above copyright notice, this
   list of conditions and the following disclaimer.

 * Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.

 * Neither the name Facebook, nor Meta, nor the names of its contributors may
   be used to endorse or promote products derived from this software without
   specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
/* automatically generated by rust-bindgen 0.71.1 */

pub const ZSTD_VERSION_MAJOR: u32 = 1;
pub const ZSTD_VERSION_MINOR: u32 = 5;
pub const ZSTD_VERSION_RELEASE: u32 = 7;
pub const ZSTD_VERSION_NUMBER: u32 = 10507;
pub const ZSTD_CLEVEL_DEFAULT: u32 = 3;
pub const ZSTD_MAGICNUMBER: u32 = 4247762216;
pub const ZSTD_MAGIC_DICTIONARY: u32 = 3962610743;
pub const ZSTD_MAGIC_SKIPPABLE_START: u32 = 407710288;
pub const ZSTD_MAGIC_SKIPPABLE_MASK: u32 = 4294967280;
pub const ZSTD_BLOCKSIZELOG_MAX: u32 = 17;
pub const ZSTD_BLOCKSIZE_MAX: u32 = 131072;
pub const ZSTD_CONTENTSIZE_UNKNOWN: i32 = -1;
pub const ZSTD_CONTENTSIZE_ERROR: i32 = -2;
pub const ZSTD_FRAMEHEADERSIZE_MAX: u32 = 18;
pub const ZSTD_SKIPPABLEHEADERSIZE: u32 = 8;
pub const ZSTD_WINDOWLOG_MAX_32: u32 = 30;
pub const ZSTD_WINDOWLOG_MAX_64: u32 = 31;
pub const ZSTD_WINDOWLOG_MIN: u32 = 10;
pub const ZSTD_HASHLOG_MIN: u32 = 6;
pub const ZSTD_CHAINLOG_MAX_32: u32 = 29;
pub const ZSTD_CHAINLOG_MAX_64: u32 = 30;
pub const ZSTD_CHAINLOG_MIN: u32 = 6;
pub const ZSTD_SEARCHLOG_MIN: u32 = 1;
pub const ZSTD_MINMATCH_MAX: u32 = 7;
pub const ZSTD_MINMATCH_MIN: u32 = 3;
pub const ZSTD_TARGETLENGTH_MAX: u32 = 131072;
pub const ZSTD_TARGETLENGTH_MIN: u32 = 0;
pub const ZSTD_BLOCKSIZE_MAX_MIN: u32 = 1024;
pub const ZSTD_OVERLAPLOG_MIN: u32 = 0;
pub const ZSTD_OVERLAPLOG_MAX: u32 = 9;
pub const ZSTD_WINDOWLOG_LIMIT_DEFAULT: u32 = 27;
pub const ZSTD_LDM_HASHLOG_MIN: u32 = 6;
pub const ZSTD_LDM_MINMATCH_MIN: u32 = 4;
pub const ZSTD_LDM_MINMATCH_MAX: u32 = 4096;
pub const ZSTD_LDM_BUCKETSIZELOG_MIN: u32 = 1;
pub const ZSTD_LDM_BUCKETSIZELOG_MAX: u32 = 8;
pub const ZSTD_LDM_HASHRATELOG_MIN: u32 = 0;
pub const ZSTD_TARGETCBLOCKSIZE_MIN: u32 = 1340;
pub const ZSTD_TARGETCBLOCKSIZE_MAX: u32 = 131072;
pub const ZSTD_SRCSIZEHINT_MIN: u32 = 0;
pub const ZSTD_BLOCKSPLITTER_LEVEL_MAX: u32 = 6;
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum ZSTD_ErrorCode {
    ZSTD_error_no_error = 0,
    ZSTD_error_GENERIC = 1,
    ZSTD_error_prefix_unknown = 10,
    ZSTD_error_version_unsupported = 12,
    ZSTD_error_frameParameter_unsupported = 14,
    ZSTD_error_frameParameter_windowTooLarge = 16,
    ZSTD_error_corruption_detected = 20,
    ZSTD_error_checksum_wrong = 22,
    ZSTD_error_literals_headerWrong = 24,
    ZSTD_error_dictionary_corrupted = 30,
    ZSTD_error_dictionary_wrong = 32,
    ZSTD_error_dictionaryCreation_failed = 34,
    ZSTD_error_parameter_unsupported = 40,
    ZSTD_error_parameter_combination_unsupported = 41,
    ZSTD_error_parameter_outOfBound = 42,
    ZSTD_error_tableLog_tooLarge = 44,
    ZSTD_error_maxSymbolValue_tooLarge = 46,
    ZSTD_error_maxSymbolValue_tooSmall = 48,
    ZSTD_error_cannotProduce_uncompressedBlock = 49,
    ZSTD_error_stabilityCondition_notRespected = 50,
    ZSTD_error_stage_wrong = 60,
    ZSTD_error_init_missing = 62,
    ZSTD_error_memory_allocation = 64,
    ZSTD_error_workSpace_tooSmall = 66,
    ZSTD_error_dstSize_tooSmall = 70,
    ZSTD_error_srcSize_wrong = 72,
    ZSTD_error_dstBuffer_null = 74,
    ZSTD_error_noForwardProgress_destFull = 80,
    ZSTD_error_noForwardProgress_inputEmpty = 82,
    ZSTD_error_frameIndex_tooLarge = 100,
    ZSTD_error_seekableIO = 102,
    ZSTD_error_dstBuffer_wrong = 104,
    ZSTD_error_srcBuffer_wrong = 105,
    ZSTD_error_sequenceProducer_failed = 106,
    ZSTD_error_externalSequences_invalid = 107,
    ZSTD_error_maxCode = 120,
}
extern "C" {
    pub fn ZSTD_getErrorString(
        code: ZSTD_ErrorCode,
    ) -> *const ::core::ffi::c_char;
}
extern "C" {
    #[doc = " ZSTD_versionNumber() :\n  Return runtime library version, the value is (MAJOR*100*100 + MINOR*100 + RELEASE)."]
    pub fn ZSTD_versionNumber() -> ::core::ffi::c_uint;
}
extern "C" {
    #[doc = " ZSTD_versionString() :\n  Return runtime library version, like \"1.4.5\". Requires v1.3.0+."]
    pub fn ZSTD_versionString() -> *const ::core::ffi::c_char;
}
extern "C" {
    #[doc = "  Simple Core API\n/\n/*! ZSTD_compress() :\n  Compresses `src` content as a single zstd compressed frame into already allocated `dst`.\n  NOTE: Providing `dstCapacity >= ZSTD_compressBound(srcSize)` guarantees that zstd will have\n        enough space to successfully compress the data.\n  @return : compressed size written into `dst` (<= `dstCapacity),\n            or an error code if it fails (which can be tested using ZSTD_isError())."]
    pub fn ZSTD_compress(
        dst: *mut ::core::ffi::c_void,
        dstCapacity: usize,
        src: *const ::core::ffi::c_void,
        srcSize: usize,
        compressionLevel: ::core::ffi::c_int,
    ) -> usize;
}
extern "C" {
    #[doc = " ZSTD_decompress() :\n `compressedSize` : must be the _exact_ size of some number of compressed and/or skippable frames.\n  Multiple compressed frames can be decompressed at once with this method.\n  The result will be the concatenation of all decompressed frames, back to back.\n `dstCapacity` is an upper bound of originalSize to regenerate.\n  First frame's decompressed size can be extracted using ZSTD_getFrameContentSize().\n  If maximum upper bound isn't known, prefer using streaming mode to decompress data.\n @return : the number of bytes decompressed into `dst` (<= `dstCapacity`),\n           or an errorCode if it fails (which can be tested using ZSTD_isError())."]
    pub fn ZSTD_decompress(
        dst: *mut ::core::ffi::c_void,
        dstCapacity: usize,
        src: *const ::core::ffi::c_void,
        compressedSize: usize,
    ) -> usize;
}
extern "C" {
    pub fn ZSTD_getFrameContentSize(
        src: *const ::core::ffi::c_void,
        srcSize: usize,
    ) -> ::core::ffi::c_ulonglong;
}
extern "C" {
    #[doc = " ZSTD_getDecompressedSize() (obsolete):\n  This function is now obsolete, in favor of ZSTD_getFrameContentSize().\n  Both functions work the same way, but ZSTD_getDecompressedSize() blends\n  \"empty\", \"unknown\" and \"error\" results to the same return value (0),\n  while ZSTD_getFrameContentSize() gives them separate return values.\n @return : decompressed size of `src` frame content _if known and not empty_, 0 otherwise."]
    pub fn ZSTD_getDecompressedSize(
        src: *const ::core::ffi::c_void,
        srcSize: usize,
    ) -> ::core::ffi::c_ulonglong;
}
extern "C" {
    #[doc = " ZSTD_findFrameCompressedSize() : Requires v1.4.0+\n `src` should point to the start of a ZSTD frame or skippable frame.\n `srcSize` must be >= first frame size\n @return : the compressed size of the first frame starting at `src`,\n           suitable to pass as `srcSize` to `ZSTD_decompress` or similar,\n           or an error code if input is invalid\n  Note 1: this method is called _find*() because it's not enough to read the header,\n          it may have to scan through the frame's content, to reach its end.\n  Note 2: this method also works with Skippable Frames. In which case,\n          it returns the size of the complete skippable frame,\n          which is always equal to its content size + 8 bytes for headers."]
    pub fn ZSTD_findFrameCompressedSize(
        src: *const ::core::ffi::c_void,
        srcSize: usize,
    ) -> usize;
}
extern "C" {
    pub fn ZSTD_compressBound(srcSize: usize) -> usize;
}
extern "C" {
    pub fn ZSTD_isError(result: usize) -> ::core::ffi::c_uint;
}
extern "C" {
    pub fn ZSTD_getErrorCode(functionResult: usize) -> ZSTD_ErrorCode;
}
extern "C" {
    pub fn ZSTD_getErrorName(result: usize) -> *const ::core::ffi::c_char;
}
extern "C" {
    pub fn ZSTD_minCLevel() -> ::core::ffi::c_int;
}
extern "C" {
    pub fn ZSTD_maxCLevel() -> ::core::ffi::c_int;
}
extern "C" {
    pub fn ZSTD_defaultCLevel() -> ::core::ffi::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ZSTD_CCtx_s {
    _unused: [u8; 0],
}
#[doc = "  Explicit context"]
pub type ZSTD_CCtx = ZSTD_CCtx_s;
extern "C" {
    pub fn ZSTD_createCCtx() -> *mut ZSTD_CCtx;
}
extern "C" {
    pub fn ZSTD_freeCCtx(cctx: *mut ZSTD_CCtx) -> usize;
}
extern "C" {
    #[doc = " ZSTD_compressCCtx() :\n  Same as ZSTD_compress(), using an explicit ZSTD_CCtx.\n  Important : in order to mirror `ZSTD_compress()` behavior,\n  this function compresses at the requested compression level,\n  __ignoring any other advanced parameter__ .\n  If any advanced parameter was set using the advanced API,\n  they will all be reset. Only @compressionLevel remains."]
    pub fn ZSTD_compressCCtx(
        cctx: *mut ZSTD_CCtx,
        dst: *mut ::core::ffi::c_void,
        dstCapacity: usize,
        src: *const ::core::ffi::c_void,
        srcSize: usize,
        compressionLevel: ::core::ffi::c_int,
    ) -> usize;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ZSTD_DCtx_s {
    _unused: [u8; 0],
}
pub type ZSTD_DCtx = ZSTD_DCtx_s;
extern "C" {
    pub fn ZSTD_createDCtx() -> *mut ZSTD_DCtx;
}
extern "C" {
    pub fn ZSTD_freeDCtx(dctx: *mut ZSTD_DCtx) -> usize;
}
extern "C" {
    #[doc = " ZSTD_decompressDCtx() :\n  Same as ZSTD_decompress(),\n  requires an allocated ZSTD_DCtx.\n  Compatible with sticky parameters (see below)."]
    pub fn ZSTD_decompressDCtx(
        dctx: *mut ZSTD_DCtx,
        dst: *mut ::core::ffi::c_void,
        dstCapacity: usize,
        src: *const ::core::ffi::c_void,
        srcSize: usize,
    ) -> usize;
}
#[repr(u32)]
#[doc = "  Advanced compression API (Requires v1.4.0+)"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum ZSTD_strategy {
    ZSTD_fast = 1,
    ZSTD_dfast = 2,
    ZSTD_greedy = 3,
    ZSTD_lazy = 4,
    ZSTD_lazy2 = 5,
    ZSTD_btlazy2 = 6,
    ZSTD_btopt = 7,
    ZSTD_btultra = 8,
    ZSTD_btultra2 = 9,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum ZSTD_cParameter {
    ZSTD_c_compressionLevel = 100,
    ZSTD_c_windowLog = 101,
    ZSTD_c_hashLog = 102,
    ZSTD_c_chainLog = 103,
    ZSTD_c_searchLog = 104,
    ZSTD_c_minMatch = 105,
    ZSTD_c_targetLength = 106,
    ZSTD_c_strategy = 107,
    ZSTD_c_targetCBlockSize = 130,
    ZSTD_c_enableLongDistanceMatching = 160,
    ZSTD_c_ldmHashLog = 161,
    ZSTD_c_ldmMinMatch = 162,
    ZSTD_c_ldmBucketSizeLog = 163,
    ZSTD_c_ldmHashRateLog = 164,
    ZSTD_c_contentSizeFlag = 200,
    ZSTD_c_checksumFlag = 201,
    ZSTD_c_dictIDFlag = 202,
    ZSTD_c_nbWorkers = 400,
    ZSTD_c_jobSize = 401,
    ZSTD_c_overlapLog = 402,
    ZSTD_c_experimentalParam1 = 500,
    ZSTD_c_experimentalParam2 = 10,
    ZSTD_c_experimentalParam3 = 1000,
    ZSTD_c_experimentalParam4 = 1001,
    ZSTD_c_experimentalParam5 = 1002,
    ZSTD_c_experimentalParam7 = 1004,
    ZSTD_c_experimentalParam8 = 1005,
    ZSTD_c_experimentalParam9 = 1006,
    ZSTD_c_experimentalParam10 = 1007,
    ZSTD_c_experimentalParam11 = 1008,
    ZSTD_c_experimentalParam12 = 1009,
    ZSTD_c_experimentalParam13 = 1010,
    ZSTD_c_experimentalParam14 = 1011,
    ZSTD_c_experimentalParam15 = 1012,
    ZSTD_c_experimentalParam16 = 1013,
    ZSTD_c_experimentalParam17 = 1014,
    ZSTD_c_experimentalParam18 = 1015,
    ZSTD_c_experimentalParam19 = 1016,
    ZSTD_c_experimentalParam20 = 1017,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ZSTD_bounds {
    pub error: usize,
    pub lowerBound: ::core::ffi::c_int,
    pub upperBound: ::core::ffi::c_int,
}
extern "C" {
    #[doc = " ZSTD_cParam_getBounds() :\n  All parameters must belong to an interval with lower and upper bounds,\n  otherwise they will either trigger an error or be automatically clamped.\n @return : a structure, ZSTD_bounds, which contains\n         - an error status field, which must be tested using ZSTD_isError()\n         - lower and upper bounds, both inclusive"]
    pub fn ZSTD_cParam_getBounds(cParam: ZSTD_cParameter) -> ZSTD_bounds;
}
extern "C" {
    #[doc = " ZSTD_CCtx_setParameter() :\n  Set one compression parameter, selected by enum ZSTD_cParameter.\n  All parameters have valid bounds. Bounds can be queried using ZSTD_cParam_getBounds().\n  Providing a value beyond bound will either clamp it, or trigger an error (depending on parameter).\n  Setting a parameter is generally only possible during frame initialization (before starting compression).\n  Exception : when using multi-threading mode (nbWorkers >= 1),\n              the following parameters can be updated _during_ compression (within same frame):\n              => compressionLevel, hashLog, chainLog, searchLog, minMatch, targetLength and strategy.\n              new parameters will be active for next job only (after a flush()).\n @return : an error code (which can be tested using ZSTD_isError())."]
    pub fn ZSTD_CCtx_setParameter(
        cctx: *mut ZSTD_CCtx,
        param: ZSTD_cParameter,
        value: ::core::ffi::c_int,
    ) -> usize;
}
extern "C" {
    #[doc = " ZSTD_CCtx_setPledgedSrcSize() :\n  Total input data size to be compressed as a single frame.\n  Value will be written in frame header, unless if explicitly forbidden using ZSTD_c_contentSizeFlag.\n  This value will also be controlled at end of frame, and trigger an error if not respected.\n @result : 0, or an error code (which can be tested with ZSTD_isError()).\n  Note 1 : pledgedSrcSize==0 actually means zero, aka an empty frame.\n           In order to mean \"unknown content size\", pass constant ZSTD_CONTENTSIZE_UNKNOWN.\n           ZSTD_CONTENTSIZE_UNKNOWN is default value for any new frame.\n  Note 2 : pledgedSrcSize is only valid once, for the next frame.\n           It's discarded at the end of the frame, and replaced by ZSTD_CONTENTSIZE_UNKNOWN.\n  Note 3 : Whenever all input data is provided and consumed in a single round,\n           for example with ZSTD_compress2(),\n           or invoking immediately ZSTD_compressStream2(,,,ZSTD_e_end),\n           this value is automatically overridden by srcSize instead."]
    pub fn ZSTD_CCtx_setPledgedSrcSize(
        cctx: *mut ZSTD_CCtx,
        pledgedSrcSize: ::core::ffi::c_ulonglong,
    ) -> usize;
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum ZSTD_ResetDirective {
    ZSTD_reset_session_only = 1,
    ZSTD_reset_parameters = 2,
    ZSTD_reset_session_and_parameters = 3,
}
extern "C" {
    #[doc = " ZSTD_CCtx_reset() :\n  There are 2 different things that can be reset, independently or jointly :\n  - The session : will stop compressing current frame, and make CCtx ready to start a new one.\n                  Useful after an error, or to interrupt any ongoing compression.\n                  Any internal data not yet flushed is cancelled.\n                  Compression parameters and dictionary remain unchanged.\n                  They will be used to compress next frame.\n                  Resetting session never fails.\n  - The parameters : changes all parameters back to \"default\".\n                  This also removes any reference to any dictionary or external sequence producer.\n                  Parameters can only be changed between 2 sessions (i.e. no compression is currently ongoing)\n                  otherwise the reset fails, and function returns an error value (which can be tested using ZSTD_isError())\n  - Both : similar to resetting the session, followed by resetting parameters."]
    pub fn ZSTD_CCtx_reset(
        cctx: *mut ZSTD_CCtx,
        reset: ZSTD_ResetDirective,
    ) -> usize;
}
extern "C" {
    #[doc = " ZSTD_compress2() :\n  Behave the same as ZSTD_compressCCtx(), but compression parameters are set using the advanced API.\n  (note that this entry point doesn't even expose a compression level parameter).\n  ZSTD_compress2() always starts a new frame.\n  Should cctx hold data from a previously unfinished frame, everything about it is forgotten.\n  - Compression parameters are pushed into CCtx before starting compression, using ZSTD_CCtx_set*()\n  - The function is always blocking, returns when compression is completed.\n  NOTE: Providing `dstCapacity >= ZSTD_compressBound(srcSize)` guarantees that zstd will have\n        enough space to successfully compress the data, though it is possible it fails for other reasons.\n @return : compressed size written into `dst` (<= `dstCapacity),\n           or an error code if it fails (which can be tested using ZSTD_isError())."]
    pub fn ZSTD_compress2(
        cctx: *mut ZSTD_CCtx,
        dst: *mut ::core::ffi::c_void,
        dstCapacity: usize,
        src: *const ::core::ffi::c_void,
        srcSize: usize,
    ) -> usize;
}
#[repr(u32)]
#[doc = "  Advanced decompression API (Requires v1.4.0+)"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum ZSTD_dParameter {
    ZSTD_d_windowLogMax = 100,
    ZSTD_d_experimentalParam1 = 1000,
    ZSTD_d_experimentalParam2 = 1001,
    ZSTD_d_experimentalParam3 = 1002,
    ZSTD_d_experimentalParam4 = 1003,
    ZSTD_d_experimentalParam5 = 1004,
    ZSTD_d_experimentalParam6 = 1005,
}
extern "C" {
    #[doc = " ZSTD_dParam_getBounds() :\n  All parameters must belong to an interval with lower and upper bounds,\n  otherwise they will either trigger an error or be automatically clamped.\n @return : a structure, ZSTD_bounds, which contains\n         - an error status field, which must be tested using ZSTD_isError()\n         - both lower and upper bounds, inclusive"]
    pub fn ZSTD_dParam_getBounds(dParam: ZSTD_dParameter) -> ZSTD_bounds;
}
extern "C" {
    #[doc = " ZSTD_DCtx_setParameter() :\n  Set one compression parameter, selected by enum ZSTD_dParameter.\n  All parameters have valid bounds. Bounds can be queried using ZSTD_dParam_getBounds().\n  Providing a value beyond bound will either clamp it, or trigger an error (depending on parameter).\n  Setting a parameter is only possible during frame initialization (before starting decompression).\n @return : 0, or an error code (which can be tested using ZSTD_isError())."]
    pub fn ZSTD_DCtx_setParameter(
        dctx: *mut ZSTD_DCtx,
        param: ZSTD_dParameter,
        value: ::core::ffi::c_int,
    ) -> usize;
}
extern "C" {
    #[doc = " ZSTD_DCtx_reset() :\n  Return a DCtx to clean state.\n  Session and parameters can be reset jointly or separately.\n  Parameters can only be reset when no active frame is being decompressed.\n @return : 0, or an error code, which can be tested with ZSTD_isError()"]
    pub fn ZSTD_DCtx_reset(
        dctx: *mut ZSTD_DCtx,
        reset: ZSTD_ResetDirective,
    ) -> usize;
}
#[doc = "  Streaming"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ZSTD_inBuffer_s {
    #[doc = "< start of input buffer"]
    pub src: *const ::core::ffi::c_void,
    #[doc = "< size of input buffer"]
    pub size: usize,
    #[doc = "< position where reading stopped. Will be updated. Necessarily 0 <= pos <= size"]
    pub pos: usize,
}
#[doc = "  Streaming"]
pub type ZSTD_inBuffer = ZSTD_inBuffer_s;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ZSTD_outBuffer_s {
    #[doc = "< start of output buffer"]
    pub dst: *mut ::core::ffi::c_void,
    #[doc = "< size of output buffer"]
    pub size: usize,
    #[doc = "< position where writing stopped. Will be updated. Necessarily 0 <= pos <= size"]
    pub pos: usize,
}
pub type ZSTD_outBuffer = ZSTD_outBuffer_s;
pub type ZSTD_CStream = ZSTD_CCtx;
extern "C" {
    pub fn ZSTD_createCStream() -> *mut ZSTD_CStream;
}
extern "C" {
    pub fn ZSTD_freeCStream(zcs: *mut ZSTD_CStream) -> usize;
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum ZSTD_EndDirective {
    ZSTD_e_continue = 0,
    ZSTD_e_flush = 1,
    ZSTD_e_end = 2,
}
extern "C" {
    #[doc = " ZSTD_compressStream2() : Requires v1.4.0+\n  Behaves about the same as ZSTD_compressStream, with additional control on end directive.\n  - Compression parameters are pushed into CCtx before starting compression, using ZSTD_CCtx_set*()\n  - Compression parameters cannot be changed once compression is started (save a list of exceptions in multi-threading mode)\n  - output->pos must be <= dstCapacity, input->pos must be <= srcSize\n  - output->pos and input->pos will be updated. They are guaranteed to remain below their respective limit.\n  - endOp must be a valid directive\n  - When nbWorkers==0 (default), function is blocking : it completes its job before returning to caller.\n  - When nbWorkers>=1, function is non-blocking : it copies a portion of input, distributes jobs to internal worker threads, flush to output whatever is available,\n                                                  and then immediately returns, just indicating that there is some data remaining to be flushed.\n                                                  The function nonetheless guarantees forward progress : it will return only after it reads or write at least 1+ byte.\n  - Exception : if the first call requests a ZSTD_e_end directive and provides enough dstCapacity, the function delegates to ZSTD_compress2() which is always blocking.\n  - @return provides a minimum amount of data remaining to be flushed from internal buffers\n            or an error code, which can be tested using ZSTD_isError().\n            if @return != 0, flush is not fully completed, there is still some data left within internal buffers.\n            This is useful for ZSTD_e_flush, since in this case more flushes are necessary to empty all buffers.\n            For ZSTD_e_end, @return == 0 when internal buffers are fully flushed and frame is completed.\n  - after a ZSTD_e_end directive, if internal buffer is not fully flushed (@return != 0),\n            only ZSTD_e_end or ZSTD_e_flush operations are allowed.\n            Before starting a new compression job, or changing compression parameters,\n            it is required to fully flush internal buffers.\n  - note: if an operation ends with an error, it may leave @cctx in an undefined state.\n          Therefore, it's UB to invoke ZSTD_compressStream2() of ZSTD_compressStream() on such a state.\n          In order to be re-employed after an error, a state must be reset,\n          which can be done explicitly (ZSTD_CCtx_reset()),\n          or is sometimes implied by methods starting a new compression job (ZSTD_initCStream(), ZSTD_compressCCtx())"]
    pub fn ZSTD_compressStream2(
        cctx: *mut ZSTD_CCtx,
        output: *mut ZSTD_outBuffer,
        input: *mut ZSTD_inBuffer,
        endOp: ZSTD_EndDirective,
    ) -> usize;
}
extern "C" {
    pub fn ZSTD_CStreamInSize() -> usize;
}
extern "C" {
    pub fn ZSTD_CStreamOutSize() -> usize;
}
extern "C" {
    #[doc = " Equivalent to:\n\n     ZSTD_CCtx_reset(zcs, ZSTD_reset_session_only);\n     ZSTD_CCtx_refCDict(zcs, NULL); // clear the dictionary (if any)\n     ZSTD_CCtx_setParameter(zcs, ZSTD_c_compressionLevel, compressionLevel);\n\n Note that ZSTD_initCStream() clears any previously set dictionary. Use the new API\n to compress with a dictionary."]
    pub fn ZSTD_initCStream(
        zcs: *mut ZSTD_CStream,
        compressionLevel: ::core::ffi::c_int,
    ) -> usize;
}
extern "C" {
    #[doc = " Alternative for ZSTD_compressStream2(zcs, output, input, ZSTD_e_continue).\n NOTE: The return value is different. ZSTD_compressStream() returns a hint for\n the next read size (if non-zero and not an error). ZSTD_compressStream2()\n returns the minimum nb of bytes left to flush (if non-zero and not an error)."]
    pub fn ZSTD_compressStream(
        zcs: *mut ZSTD_CStream,
        output: *mut ZSTD_outBuffer,
        input: *mut ZSTD_inBuffer,
    ) -> usize;
}
extern "C" {
    #[doc = " Equivalent to ZSTD_compressStream2(zcs, output, &emptyInput, ZSTD_e_flush)."]
    pub fn ZSTD_flushStream(
        zcs: *mut ZSTD_CStream,
        output: *mut ZSTD_outBuffer,
    ) -> usize;
}
extern "C" {
    #[doc = " Equivalent to ZSTD_compressStream2(zcs, output, &emptyInput, ZSTD_e_end)."]
    pub fn ZSTD_endStream(
        zcs: *mut ZSTD_CStream,
        output: *mut ZSTD_outBuffer,
    ) -> usize;
}
pub type ZSTD_DStream = ZSTD_DCtx;
extern "C" {
    pub fn ZSTD_createDStream() -> *mut ZSTD_DStream;
}
extern "C" {
    pub fn ZSTD_freeDStream(zds: *mut ZSTD_DStream) -> usize;
}
extern "C" {
    #[doc = " ZSTD_initDStream() :\n Initialize/reset DStream state for new decompression operation.\n Call before new decompression operation using same DStream.\n\n Note : This function is redundant with the advanced API and equivalent to:\n     ZSTD_DCtx_reset(zds, ZSTD_reset_session_only);\n     ZSTD_DCtx_refDDict(zds, NULL);"]
    pub fn ZSTD_initDStream(zds: *mut ZSTD_DStream) -> usize;
}
extern "C" {
    #[doc = " ZSTD_decompressStream() :\n Streaming decompression function.\n Call repetitively to consume full input updating it as necessary.\n Function will update both input and output `pos` fields exposing current state via these fields:\n - `input.pos < input.size`, some input remaining and caller should provide remaining input\n   on the next call.\n - `output.pos < output.size`, decoder flushed internal output buffer.\n - `output.pos == output.size`, unflushed data potentially present in the internal buffers,\n   check ZSTD_decompressStream() @return value,\n   if > 0, invoke it again to flush remaining data to output.\n Note : with no additional input, amount of data flushed <= ZSTD_BLOCKSIZE_MAX.\n\n @return : 0 when a frame is completely decoded and fully flushed,\n           or an error code, which can be tested using ZSTD_isError(),\n           or any other value > 0, which means there is some decoding or flushing to do to complete current frame.\n\n Note: when an operation returns with an error code, the @zds state may be left in undefined state.\n       It's UB to invoke `ZSTD_decompressStream()` on such a state.\n       In order to re-use such a state, it must be first reset,\n       which can be done explicitly (`ZSTD_DCtx_reset()`),\n       or is implied for operations starting some new decompression job (`ZSTD_initDStream`, `ZSTD_decompressDCtx()`, `ZSTD_decompress_usingDict()`)"]
    pub fn ZSTD_decompressStream(
        zds: *mut ZSTD_DStream,
        output: *mut ZSTD_outBuffer,
        input: *mut ZSTD_inBuffer,
    ) -> usize;
}
extern "C" {
    pub fn ZSTD_DStreamInSize() -> usize;
}
extern "C" {
    pub fn ZSTD_DStreamOutSize() -> usize;
}
extern "C" {
    #[doc = "  Simple dictionary API\n/\n/*! ZSTD_compress_usingDict() :\n  Compression at an explicit compression level using a Dictionary.\n  A dictionary can be any arbitrary data segment (also called a prefix),\n  or a buffer with specified information (see zdict.h).\n  Note : This function loads the dictionary, resulting in significant startup delay.\n         It's intended for a dictionary used only once.\n  Note 2 : When `dict == NULL || dictSize < 8` no dictionary is used."]
    pub fn ZSTD_compress_usingDict(
        ctx: *mut ZSTD_CCtx,
        dst: *mut ::core::ffi::c_void,
        dstCapacity: usize,
        src: *const ::core::ffi::c_void,
        srcSize: usize,
        dict: *const ::core::ffi::c_void,
        dictSize: usize,
        compressionLevel: ::core::ffi::c_int,
    ) -> usize;
}
extern "C" {
    #[doc = " ZSTD_decompress_usingDict() :\n  Decompression using a known Dictionary.\n  Dictionary must be identical to the one used during compression.\n  Note : This function loads the dictionary, resulting in significant startup delay.\n         It's intended for a dictionary used only once.\n  Note : When `dict == NULL || dictSize < 8` no dictionary is used."]
    pub fn ZSTD_decompress_usingDict(
        dctx: *mut ZSTD_DCtx,
        dst: *mut ::core::ffi::c_void,
        dstCapacity: usize,
        src: *const ::core::ffi::c_void,
        srcSize: usize,
        dict: *const ::core::ffi::c_void,
        dictSize: usize,
    ) -> usize;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ZSTD_CDict_s {
    _unused: [u8; 0],
}
#[doc = "  Bulk processing dictionary API"]
pub type ZSTD_CDict = ZSTD_CDict_s;
extern "C" {
    #[doc = " ZSTD_createCDict() :\n  When compressing multiple messages or blocks using the same dictionary,\n  it's recommended to digest the dictionary only once, since it's a costly operation.\n  ZSTD_createCDict() will create a state from digesting a dictionary.\n  The resulting state can be used for future compression operations with very limited startup cost.\n  ZSTD_CDict can be created once and shared by multiple threads concurrently, since its usage is read-only.\n @dictBuffer can be released after ZSTD_CDict creation, because its content is copied within CDict.\n  Note 1 : Consider experimental function `ZSTD_createCDict_byReference()` if you prefer to not duplicate @dictBuffer content.\n  Note 2 : A ZSTD_CDict can be created from an empty @dictBuffer,\n      in which case the only thing that it transports is the @compressionLevel.\n      This can be useful in a pipeline featuring ZSTD_compress_usingCDict() exclusively,\n      expecting a ZSTD_CDict parameter with any data, including those without a known dictionary."]
    pub fn ZSTD_createCDict(
        dictBuffer: *const ::core::ffi::c_void,
        dictSize: usize,
        compressionLevel: ::core::ffi::c_int,
    ) -> *mut ZSTD_CDict;
}
extern "C" {
    #[doc = " ZSTD_freeCDict() :\n  Function frees memory allocated by ZSTD_createCDict().\n  If a NULL pointer is passed, no operation is performed."]
    pub fn ZSTD_freeCDict(CDict: *mut ZSTD_CDict) -> usize;
}
extern "C" {
    #[doc = " ZSTD_compress_usingCDict() :\n  Compression using a digested Dictionary.\n  Recommended when same dictionary is used multiple times.\n  Note : compression level is _decided at dictionary creation time_,\n     and frame parameters are hardcoded (dictID=yes, contentSize=yes, checksum=no)"]
    pub fn ZSTD_compress_usingCDict(
        cctx: *mut ZSTD_CCtx,
        dst: *mut ::core::ffi::c_void,
        dstCapacity: usize,
        src: *const ::core::ffi::c_void,
        srcSize: usize,
        cdict: *const ZSTD_CDict,
    ) -> usize;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ZSTD_DDict_s {
    _unused: [u8; 0],
}
pub type ZSTD_DDict = ZSTD_DDict_s;
extern "C" {
    #[doc = " ZSTD_createDDict() :\n  Create a digested dictionary, ready to start decompression operation without startup delay.\n  dictBuffer can be released after DDict creation, as its content is copied inside DDict."]
    pub fn ZSTD_createDDict(
        dictBuffer: *const ::core::ffi::c_void,
        dictSize: usize,
    ) -> *mut ZSTD_DDict;
}
extern "C" {
    #[doc = " ZSTD_freeDDict() :\n  Function frees memory allocated with ZSTD_createDDict()\n  If a NULL pointer is passed, no operation is performed."]
    pub fn ZSTD_freeDDict(ddict: *mut ZSTD_DDict) -> usize;
}
extern "C" {
    #[doc = " ZSTD_decompress_usingDDict() :\n  Decompression using a digested Dictionary.\n  Recommended when same dictionary is used multiple times."]
    pub fn ZSTD_decompress_usingDDict(
        dctx: *mut ZSTD_DCtx,
        dst: *mut ::core::ffi::c_void,
        dstCapacity: usize,
        src: *const ::core::ffi::c_void,
        srcSize: usize,
        ddict: *const ZSTD_DDict,
    ) -> usize;
}
extern "C" {
    #[doc = " ZSTD_getDictID_fromDict() : Requires v1.4.0+\n  Provides the dictID stored within dictionary.\n  if @return == 0, the dictionary is not conformant with Zstandard specification.\n  It can still be loaded, but as a content-only dictionary."]
    pub fn ZSTD_getDictID_fromDict(
        dict: *const ::core::ffi::c_void,
        dictSize: usize,
    ) -> ::core::ffi::c_uint;
}
extern "C" {
    #[doc = " ZSTD_getDictID_fromCDict() : Requires v1.5.0+\n  Provides the dictID of the dictionary loaded into `cdict`.\n  If @return == 0, the dictionary is not conformant to Zstandard specification, or empty.\n  Non-conformant dictionaries can still be loaded, but as content-only dictionaries."]
    pub fn ZSTD_getDictID_fromCDict(
        cdict: *const ZSTD_CDict,
    ) -> ::core::ffi::c_uint;
}
extern "C" {
    #[doc = " ZSTD_getDictID_fromDDict() : Requires v1.4.0+\n  Provides the dictID of the dictionary loaded into `ddict`.\n  If @return == 0, the dictionary is not conformant to Zstandard specification, or empty.\n  Non-conformant dictionaries can still be loaded, but as content-only dictionaries."]
    pub fn ZSTD_getDictID_fromDDict(
        ddict: *const ZSTD_DDict,
    ) -> ::core::ffi::c_uint;
}
extern "C" {
    #[doc = " ZSTD_getDictID_fromFrame() : Requires v1.4.0+\n  Provides the dictID required to decompressed the frame stored within `src`.\n  If @return == 0, the dictID could not be decoded.\n  This could for one of the following reasons :\n  - The frame does not require a dictionary to be decoded (most common case).\n  - The frame was built with dictID intentionally removed. Whatever dictionary is necessary is a hidden piece of information.\n    Note : this use case also happens when using a non-conformant dictionary.\n  - `srcSize` is too small, and as a result, the frame header could not be decoded (only possible if `srcSize < ZSTD_FRAMEHEADERSIZE_MAX`).\n  - This is not a Zstandard frame.\n  When identifying the exact failure cause, it's possible to use ZSTD_getFrameHeader(), which will provide a more precise error code."]
    pub fn ZSTD_getDictID_fromFrame(
        src: *const ::core::ffi::c_void,
        srcSize: usize,
    ) -> ::core::ffi::c_uint;
}
extern "C" {
    #[doc = " ZSTD_CCtx_loadDictionary() : Requires v1.4.0+\n  Create an internal CDict from `dict` buffer.\n  Decompression will have to use same dictionary.\n @result : 0, or an error code (which can be tested with ZSTD_isError()).\n  Special: Loading a NULL (or 0-size) dictionary invalidates previous dictionary,\n           meaning \"return to no-dictionary mode\".\n  Note 1 : Dictionary is sticky, it will be used for all future compressed frames,\n           until parameters are reset, a new dictionary is loaded, or the dictionary\n           is explicitly invalidated by loading a NULL dictionary.\n  Note 2 : Loading a dictionary involves building tables.\n           It's also a CPU consuming operation, with non-negligible impact on latency.\n           Tables are dependent on compression parameters, and for this reason,\n           compression parameters can no longer be changed after loading a dictionary.\n  Note 3 :`dict` content will be copied internally.\n           Use experimental ZSTD_CCtx_loadDictionary_byReference() to reference content instead.\n           In such a case, dictionary buffer must outlive its users.\n  Note 4 : Use ZSTD_CCtx_loadDictionary_advanced()\n           to precisely select how dictionary content must be interpreted.\n  Note 5 : This method does not benefit from LDM (long distance mode).\n           If you want to employ LDM on some large dictionary content,\n           prefer employing ZSTD_CCtx_refPrefix() described below."]
    pub fn ZSTD_CCtx_loadDictionary(
        cctx: *mut ZSTD_CCtx,
        dict: *const ::core::ffi::c_void,
        dictSize: usize,
    ) -> usize;
}
extern "C" {
    #[doc = " ZSTD_CCtx_refCDict() : Requires v1.4.0+\n  Reference a prepared dictionary, to be used for all future compressed frames.\n  Note that compression parameters are enforced from within CDict,\n  and supersede any compression parameter previously set within CCtx.\n  The parameters ignored are labelled as \"superseded-by-cdict\" in the ZSTD_cParameter enum docs.\n  The ignored parameters will be used again if the CCtx is returned to no-dictionary mode.\n  The dictionary will remain valid for future compressed frames using same CCtx.\n @result : 0, or an error code (which can be tested with ZSTD_isError()).\n  Special : Referencing a NULL CDict means \"return to no-dictionary mode\".\n  Note 1 : Currently, only one dictionary can be managed.\n           Referencing a new dictionary effectively \"discards\" any previous one.\n  Note 2 : CDict is just referenced, its lifetime must outlive its usage within CCtx."]
    pub fn ZSTD_CCtx_refCDict(
        cctx: *mut ZSTD_CCtx,
        cdict: *const ZSTD_CDict,
    ) -> usize;
}
extern "C" {
    #[doc = " ZSTD_CCtx_refPrefix() : Requires v1.4.0+\n  Reference a prefix (single-usage dictionary) for next compressed frame.\n  A prefix is **only used once**. Tables are discarded at end of frame (ZSTD_e_end).\n  Decompression will need same prefix to properly regenerate data.\n  Compressing with a prefix is similar in outcome as performing a diff and compressing it,\n  but performs much faster, especially during decompression (compression speed is tunable with compression level).\n  This method is compatible with LDM (long distance mode).\n @result : 0, or an error code (which can be tested with ZSTD_isError()).\n  Special: Adding any prefix (including NULL) invalidates any previous prefix or dictionary\n  Note 1 : Prefix buffer is referenced. It **must** outlive compression.\n           Its content must remain unmodified during compression.\n  Note 2 : If the intention is to diff some large src data blob with some prior version of itself,\n           ensure that the window size is large enough to contain the entire source.\n           See ZSTD_c_windowLog.\n  Note 3 : Referencing a prefix involves building tables, which are dependent on compression parameters.\n           It's a CPU consuming operation, with non-negligible impact on latency.\n           If there is a need to use the same prefix multiple times, consider loadDictionary instead.\n  Note 4 : By default, the prefix is interpreted as raw content (ZSTD_dct_rawContent).\n           Use experimental ZSTD_CCtx_refPrefix_advanced() to alter dictionary interpretation."]
    pub fn ZSTD_CCtx_refPrefix(
        cctx: *mut ZSTD_CCtx,
        prefix: *const ::core::ffi::c_void,
        prefixSize: usize,
    ) -> usize;
}
extern "C" {
    #[doc = " ZSTD_DCtx_loadDictionary() : Requires v1.4.0+\n  Create an internal DDict from dict buffer, to be used to decompress all future frames.\n  The dictionary remains valid for all future frames, until explicitly invalidated, or\n  a new dictionary is loaded.\n @result : 0, or an error code (which can be tested with ZSTD_isError()).\n  Special : Adding a NULL (or 0-size) dictionary invalidates any previous dictionary,\n            meaning \"return to no-dictionary mode\".\n  Note 1 : Loading a dictionary involves building tables,\n           which has a non-negligible impact on CPU usage and latency.\n           It's recommended to \"load once, use many times\", to amortize the cost\n  Note 2 :`dict` content will be copied internally, so `dict` can be released after loading.\n           Use ZSTD_DCtx_loadDictionary_byReference() to reference dictionary content instead.\n  Note 3 : Use ZSTD_DCtx_loadDictionary_advanced() to take control of\n           how dictionary content is loaded and interpreted."]
    pub fn ZSTD_DCtx_loadDictionary(
        dctx: *mut ZSTD_DCtx,
        dict: *const ::core::ffi::c_void,
        dictSize: usize,
    ) -> usize;
}
extern "C" {
    #[doc = " ZSTD_DCtx_refDDict() : Requires v1.4.0+\n  Reference a prepared dictionary, to be used to decompress next frames.\n  The dictionary remains active for decompression of future frames using same DCtx.\n\n  If called with ZSTD_d_refMultipleDDicts enabled, repeated calls of this function\n  will store the DDict references in a table, and the DDict used for decompression\n  will be determined at decompression time, as per the dict ID in the frame.\n  The memory for the table is allocated on the first call to refDDict, and can be\n  freed with ZSTD_freeDCtx().\n\n  If called with ZSTD_d_refMultipleDDicts disabled (the default), only one dictionary\n  will be managed, and referencing a dictionary effectively \"discards\" any previous one.\n\n @result : 0, or an error code (which can be tested with ZSTD_isError()).\n  Special: referencing a NULL DDict means \"return to no-dictionary mode\".\n  Note 2 : DDict is just referenced, its lifetime must outlive its usage from DCtx."]
    pub fn ZSTD_DCtx_refDDict(
        dctx: *mut ZSTD_DCtx,
        ddict: *const ZSTD_DDict,
    ) -> usize;
}
extern "C" {
    #[doc = " ZSTD_DCtx_refPrefix() : Requires v1.4.0+\n  Reference a prefix (single-usage dictionary) to decompress next frame.\n  This is the reverse operation of ZSTD_CCtx_refPrefix(),\n  and must use the same prefix as the one used during compression.\n  Prefix is **only used once**. Reference is discarded at end of frame.\n  End of frame is reached when ZSTD_decompressStream() returns 0.\n @result : 0, or an error code (which can be tested with ZSTD_isError()).\n  Note 1 : Adding any prefix (including NULL) invalidates any previously set prefix or dictionary\n  Note 2 : Prefix buffer is referenced. It **must** outlive decompression.\n           Prefix buffer must remain unmodified up to the end of frame,\n           reached when ZSTD_decompressStream() returns 0.\n  Note 3 : By default, the prefix is treated as raw content (ZSTD_dct_rawContent).\n           Use ZSTD_CCtx_refPrefix_advanced() to alter dictMode (Experimental section)\n  Note 4 : Referencing a raw content prefix has almost no cpu nor memory cost.\n           A full dictionary is more costly, as it requires building tables."]
    pub fn ZSTD_DCtx_refPrefix(
        dctx: *mut ZSTD_DCtx,
        prefix: *const ::core::ffi::c_void,
        prefixSize: usize,
    ) -> usize;
}
extern "C" {
    #[doc = " ZSTD_sizeof_*() : Requires v1.4.0+\n  These functions give the _current_ memory usage of selected object.\n  Note that object memory usage can evolve (increase or decrease) over time."]
    pub fn ZSTD_sizeof_CCtx(cctx: *const ZSTD_CCtx) -> usize;
}
extern "C" {
    pub fn ZSTD_sizeof_DCtx(dctx: *const ZSTD_DCtx) -> usize;
}
extern "C" {
    pub fn ZSTD_sizeof_CStream(zcs: *const ZSTD_CStream) -> usize;
}
extern "C" {
    pub fn ZSTD_sizeof_DStream(zds: *const ZSTD_DStream) -> usize;
}
extern "C" {
    pub fn ZSTD_sizeof_CDict(cdict: *const ZSTD_CDict) -> usize;
}
extern "C" {
    pub fn ZSTD_sizeof_DDict(ddict: *const ZSTD_DDict) -> usize;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ZSTD_CCtx_params_s {
    _unused: [u8; 0],
}
pub type ZSTD_CCtx_params = ZSTD_CCtx_params_s;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ZSTD_Sequence {
    pub offset: ::core::ffi::c_uint,
    pub litLength: ::core::ffi::c_uint,
    pub matchLength: ::core::ffi::c_uint,
    pub rep: ::core::ffi::c_uint,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ZSTD_compressionParameters {
    #[doc = "< largest match distance : larger == more compression, more memory needed during decompression"]
    pub windowLog: ::core::ffi::c_uint,
    #[doc = "< fully searched segment : larger == more compression, slower, more memory (useless for fast)"]
    pub chainLog: ::core::ffi::c_uint,
    #[doc = "< dispatch table : larger == faster, more memory"]
    pub hashLog: ::core::ffi::c_uint,
    #[doc = "< nb of searches : larger == more compression, slower"]
    pub searchLog: ::core::ffi::c_uint,
    #[doc = "< match length searched : larger == faster decompression, sometimes less compression"]
    pub minMatch: ::core::ffi::c_uint,
    #[doc = "< acceptable match size for optimal parser (only) : larger == more compression, slower"]
    pub targetLength: ::core::ffi::c_uint,
    #[doc = "< see ZSTD_strategy definition above"]
    pub strategy: ZSTD_strategy,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ZSTD_frameParameters {
    #[doc = "< 1: content size will be in frame header (when known)"]
    pub contentSizeFlag: ::core::ffi::c_int,
    #[doc = "< 1: generate a 32-bits checksum using XXH64 algorithm at end of frame, for error detection"]
    pub checksumFlag: ::core::ffi::c_int,
    #[doc = "< 1: no dictID will be saved into frame header (dictID is only useful for dictionary compression)"]
    pub noDictIDFlag: ::core::ffi::c_int,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ZSTD_parameters {
    pub cParams: ZSTD_compressionParameters,
    pub fParams: ZSTD_frameParameters,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum ZSTD_dictContentType_e {
    ZSTD_dct_auto = 0,
    ZSTD_dct_rawContent = 1,
    ZSTD_dct_fullDict = 2,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum ZSTD_dictLoadMethod_e {
    #[doc = "< Copy dictionary content internally"]
    ZSTD_dlm_byCopy = 0,
    #[doc = "< Reference dictionary content -- the dictionary buffer must outlive its users."]
    ZSTD_dlm_byRef = 1,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum ZSTD_format_e {
    ZSTD_f_zstd1 = 0,
    ZSTD_f_zstd1_magicless = 1,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum ZSTD_forceIgnoreChecksum_e {
    ZSTD_d_validateChecksum = 0,
    ZSTD_d_ignoreChecksum = 1,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum ZSTD_refMultipleDDicts_e {
    ZSTD_rmd_refSingleDDict = 0,
    ZSTD_rmd_refMultipleDDicts = 1,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum ZSTD_dictAttachPref_e {
    ZSTD_dictDefaultAttach = 0,
    ZSTD_dictForceAttach = 1,
    ZSTD_dictForceCopy = 2,
    ZSTD_dictForceLoad = 3,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum ZSTD_literalCompressionMode_e {
    #[doc = "< Automatically determine the compression mode based on the compression level.\n   Negative compression levels will be uncompressed, and positive compression\n   levels will be compressed."]
    ZSTD_lcm_auto = 0,
    #[doc = "< Always attempt Huffman compression. Uncompressed literals will still be\n   emitted if Huffman compression is not profitable."]
    ZSTD_lcm_huffman = 1,
    #[doc = "< Always emit uncompressed literals."]
    ZSTD_lcm_uncompressed = 2,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum ZSTD_ParamSwitch_e {
    ZSTD_ps_auto = 0,
    ZSTD_ps_enable = 1,
    ZSTD_ps_disable = 2,
}
extern "C" {
    #[doc = " ZSTD_findDecompressedSize() :\n  `src` should point to the start of a series of ZSTD encoded and/or skippable frames\n  `srcSize` must be the _exact_ size of this series\n       (i.e. there should be a frame boundary at `src + srcSize`)\n  @return : - decompressed size of all data in all successive frames\n            - if the decompressed size cannot be determined: ZSTD_CONTENTSIZE_UNKNOWN\n            - if an error occurred: ZSTD_CONTENTSIZE_ERROR\n\n   note 1 : decompressed size is an optional field, that may not be present, especially in streaming mode.\n            When `return==ZSTD_CONTENTSIZE_UNKNOWN`, data to decompress could be any size.\n            In which case, it's necessary to use streaming mode to decompress data.\n   note 2 : decompressed size is always present when compression is done with ZSTD_compress()\n   note 3 : decompressed size can be very large (64-bits value),\n            potentially larger than what local system can handle as a single memory segment.\n            In which case, it's necessary to use streaming mode to decompress data.\n   note 4 : If source is untrusted, decompressed size could be wrong or intentionally modified.\n            Always ensure result fits within application's authorized limits.\n            Each application can set its own limits.\n   note 5 : ZSTD_findDecompressedSize handles multiple frames, and so it must traverse the input to\n            read each contained frame header.  This is fast as most of the data is skipped,\n            however it does mean that all frame data must be present and valid."]
    pub fn ZSTD_findDecompressedSize(
        src: *const ::core::ffi::c_void,
        srcSize: usize,
    ) -> ::core::ffi::c_ulonglong;
}
extern "C" {
    #[doc = " ZSTD_decompressBound() :\n  `src` should point to the start of a series of ZSTD encoded and/or skippable frames\n  `srcSize` must be the _exact_ size of this series\n       (i.e. there should be a frame boundary at `src + srcSize`)\n  @return : - upper-bound for the decompressed size of all data in all successive frames\n            - if an error occurred: ZSTD_CONTENTSIZE_ERROR\n\n  note 1  : an error can occur if `src` contains an invalid or incorrectly formatted frame.\n  note 2  : the upper-bound is exact when the decompressed size field is available in every ZSTD encoded frame of `src`.\n            in this case, `ZSTD_findDecompressedSize` and `ZSTD_decompressBound` return the same value.\n  note 3  : when the decompressed size field isn't available, the upper-bound for that frame is calculated by:\n              upper-bound = # blocks * min(128 KB, Window_Size)"]
    pub fn ZSTD_decompressBound(
        src: *const ::core::ffi::c_void,
        srcSize: usize,
    ) -> ::core::ffi::c_ulonglong;
}
extern "C" {
    #[doc = " ZSTD_frameHeaderSize() :\n  srcSize must be large enough, aka >= ZSTD_FRAMEHEADERSIZE_PREFIX.\n @return : size of the Frame Header,\n           or an error code (if srcSize is too small)"]
    pub fn ZSTD_frameHeaderSize(
        src: *const ::core::ffi::c_void,
        srcSize: usize,
    ) -> usize;
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum ZSTD_FrameType_e {
    ZSTD_frame = 0,
    ZSTD_skippableFrame = 1,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ZSTD_FrameHeader {
    pub frameContentSize: ::core::ffi::c_ulonglong,
    pub windowSize: ::core::ffi::c_ulonglong,
    pub blockSizeMax: ::core::ffi::c_uint,
    pub frameType: ZSTD_FrameType_e,
    pub headerSize: ::core::ffi::c_uint,
    pub dictID: ::core::ffi::c_uint,
    pub checksumFlag: ::core::ffi::c_uint,
    pub _reserved1: ::core::ffi::c_uint,
    pub _reserved2: ::core::ffi::c_uint,
}
extern "C" {
    #[doc = " ZSTD_getFrameHeader() :\n  decode Frame Header into `zfhPtr`, or requires larger `srcSize`.\n @return : 0 => header is complete, `zfhPtr` is correctly filled,\n          >0 => `srcSize` is too small, @return value is the wanted `srcSize` amount, `zfhPtr` is not filled,\n           or an error code, which can be tested using ZSTD_isError()"]
    pub fn ZSTD_getFrameHeader(
        zfhPtr: *mut ZSTD_FrameHeader,
        src: *const ::core::ffi::c_void,
        srcSize: usize,
    ) -> usize;
}
extern "C" {
    #[doc = " ZSTD_getFrameHeader_advanced() :\n  same as ZSTD_getFrameHeader(),\n  with added capability to select a format (like ZSTD_f_zstd1_magicless)"]
    pub fn ZSTD_getFrameHeader_advanced(
        zfhPtr: *mut ZSTD_FrameHeader,
        src: *const ::core::ffi::c_void,
        srcSize: usize,
        format: ZSTD_format_e,
    ) -> usize;
}
extern "C" {
    #[doc = " ZSTD_decompressionMargin() :\n Zstd supports in-place decompression, where the input and output buffers overlap.\n In this case, the output buffer must be at least (Margin + Output_Size) bytes large,\n and the input buffer must be at the end of the output buffer.\n\n  _______________________ Output Buffer ________________________\n |                                                              |\n |                                        ____ Input Buffer ____|\n |                                       |                      |\n v                                       v                      v\n |---------------------------------------|-----------|----------|\n ^                                                   ^          ^\n |___________________ Output_Size ___________________|_ Margin _|\n\n NOTE: See also ZSTD_DECOMPRESSION_MARGIN().\n NOTE: This applies only to single-pass decompression through ZSTD_decompress() or\n ZSTD_decompressDCtx().\n NOTE: This function supports multi-frame input.\n\n @param src The compressed frame(s)\n @param srcSize The size of the compressed frame(s)\n @returns The decompression margin or an error that can be checked with ZSTD_isError()."]
    pub fn ZSTD_decompressionMargin(
        src: *const ::core::ffi::c_void,
        srcSize: usize,
    ) -> usize;
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum ZSTD_SequenceFormat_e {
    ZSTD_sf_noBlockDelimiters = 0,
    ZSTD_sf_explicitBlockDelimiters = 1,
}
extern "C" {
    #[doc = " ZSTD_sequenceBound() :\n `srcSize` : size of the input buffer\n  @return : upper-bound for the number of sequences that can be generated\n            from a buffer of srcSize bytes\n\n  note : returns number of sequences - to get bytes, multiply by sizeof(ZSTD_Sequence)."]
    pub fn ZSTD_sequenceBound(srcSize: usize) -> usize;
}
extern "C" {
    #[doc = " ZSTD_generateSequences() :\n WARNING: This function is meant for debugging and informational purposes ONLY!\n Its implementation is flawed, and it will be deleted in a future version.\n It is not guaranteed to succeed, as there are several cases where it will give\n up and fail. You should NOT use this function in production code.\n\n This function is deprecated, and will be removed in a future version.\n\n Generate sequences using ZSTD_compress2(), given a source buffer.\n\n @param zc The compression context to be used for ZSTD_compress2(). Set any\n           compression parameters you need on this context.\n @param outSeqs The output sequences buffer of size @p outSeqsSize\n @param outSeqsCapacity The size of the output sequences buffer.\n                    ZSTD_sequenceBound(srcSize) is an upper bound on the number\n                    of sequences that can be generated.\n @param src The source buffer to generate sequences from of size @p srcSize.\n @param srcSize The size of the source buffer.\n\n Each block will end with a dummy sequence\n with offset == 0, matchLength == 0, and litLength == length of last literals.\n litLength may be == 0, and if so, then the sequence of (of: 0 ml: 0 ll: 0)\n simply acts as a block delimiter.\n\n @returns The number of sequences generated, necessarily less than\n          ZSTD_sequenceBound(srcSize), or an error code that can be checked\n          with ZSTD_isError()."]
    pub fn ZSTD_generateSequences(
        zc: *mut ZSTD_CCtx,
        outSeqs: *mut ZSTD_Sequence,
        outSeqsCapacity: usize,
        src: *const ::core::ffi::c_void,
        srcSize: usize,
    ) -> usize;
}
extern "C" {
    #[doc = " ZSTD_mergeBlockDelimiters() :\n Given an array of ZSTD_Sequence, remove all sequences that represent block delimiters/last literals\n by merging them into the literals of the next sequence.\n\n As such, the final generated result has no explicit representation of block boundaries,\n and the final last literals segment is not represented in the sequences.\n\n The output of this function can be fed into ZSTD_compressSequences() with CCtx\n setting of ZSTD_c_blockDelimiters as ZSTD_sf_noBlockDelimiters\n @return : number of sequences left after merging"]
    pub fn ZSTD_mergeBlockDelimiters(
        sequences: *mut ZSTD_Sequence,
        seqsSize: usize,
    ) -> usize;
}
extern "C" {
    #[doc = " ZSTD_compressSequences() :\n Compress an array of ZSTD_Sequence, associated with @src buffer, into dst.\n @src contains the entire input (not just the literals).\n If @srcSize > sum(sequence.length), the remaining bytes are considered all literals\n If a dictionary is included, then the cctx should reference the dict (see: ZSTD_CCtx_refCDict(), ZSTD_CCtx_loadDictionary(), etc.).\n The entire source is compressed into a single frame.\n\n The compression behavior changes based on cctx params. In particular:\n    If ZSTD_c_blockDelimiters == ZSTD_sf_noBlockDelimiters, the array of ZSTD_Sequence is expected to contain\n    no block delimiters (defined in ZSTD_Sequence). Block boundaries are roughly determined based on\n    the block size derived from the cctx, and sequences may be split. This is the default setting.\n\n    If ZSTD_c_blockDelimiters == ZSTD_sf_explicitBlockDelimiters, the array of ZSTD_Sequence is expected to contain\n    valid block delimiters (defined in ZSTD_Sequence). Behavior is undefined if no block delimiters are provided.\n\n    When ZSTD_c_blockDelimiters == ZSTD_sf_explicitBlockDelimiters, it's possible to decide generating repcodes\n    using the advanced parameter ZSTD_c_repcodeResolution. Repcodes will improve compression ratio, though the benefit\n    can vary greatly depending on Sequences. On the other hand, repcode resolution is an expensive operation.\n    By default, it's disabled at low (<10) compression levels, and enabled above the threshold (>=10).\n    ZSTD_c_repcodeResolution makes it possible to directly manage this processing in either direction.\n\n    If ZSTD_c_validateSequences == 0, this function blindly accepts the Sequences provided. Invalid Sequences cause undefined\n    behavior. If ZSTD_c_validateSequences == 1, then the function will detect invalid Sequences (see doc/zstd_compression_format.md for\n    specifics regarding offset/matchlength requirements) and then bail out and return an error.\n\n    In addition to the two adjustable experimental params, there are other important cctx params.\n    - ZSTD_c_minMatch MUST be set as less than or equal to the smallest match generated by the match finder. It has a minimum value of ZSTD_MINMATCH_MIN.\n    - ZSTD_c_compressionLevel accordingly adjusts the strength of the entropy coder, as it would in typical compression.\n    - ZSTD_c_windowLog affects offset validation: this function will return an error at higher debug levels if a provided offset\n      is larger than what the spec allows for a given window log and dictionary (if present). See: doc/zstd_compression_format.md\n\n Note: Repcodes are, as of now, always re-calculated within this function, ZSTD_Sequence.rep is effectively unused.\n Dev Note: Once ability to ingest repcodes become available, the explicit block delims mode must respect those repcodes exactly,\n         and cannot emit an RLE block that disagrees with the repcode history.\n @return : final compressed size, or a ZSTD error code."]
    pub fn ZSTD_compressSequences(
        cctx: *mut ZSTD_CCtx,
        dst: *mut ::core::ffi::c_void,
        dstCapacity: usize,
        inSeqs: *const ZSTD_Sequence,
        inSeqsSize: usize,
        src: *const ::core::ffi::c_void,
        srcSize: usize,
    ) -> usize;
}
extern "C" {
    #[doc = " ZSTD_compressSequencesAndLiterals() :\n This is a variant of ZSTD_compressSequences() which,\n instead of receiving (src,srcSize) as input parameter, receives (literals,litSize),\n aka all the literals, already extracted and laid out into a single continuous buffer.\n This can be useful if the process generating the sequences also happens to generate the buffer of literals,\n thus skipping an extraction + caching stage.\n It's a speed optimization, useful when the right conditions are met,\n but it also features the following limitations:\n - Only supports explicit delimiter mode\n - Currently does not support Sequences validation (so input Sequences are trusted)\n - Not compatible with frame checksum, which must be disabled\n - If any block is incompressible, will fail and return an error\n - @litSize must be == sum of all @.litLength fields in @inSeqs. Any discrepancy will generate an error.\n - @litBufCapacity is the size of the underlying buffer into which literals are written, starting at address @literals.\n   @litBufCapacity must be at least 8 bytes larger than @litSize.\n - @decompressedSize must be correct, and correspond to the sum of all Sequences. Any discrepancy will generate an error.\n @return : final compressed size, or a ZSTD error code."]
    pub fn ZSTD_compressSequencesAndLiterals(
        cctx: *mut ZSTD_CCtx,
        dst: *mut ::core::ffi::c_void,
        dstCapacity: usize,
        inSeqs: *const ZSTD_Sequence,
        nbSequences: usize,
        literals: *const ::core::ffi::c_void,
        litSize: usize,
        litBufCapacity: usize,
        decompressedSize: usize,
    ) -> usize;
}
extern "C" {
    #[doc = " ZSTD_writeSkippableFrame() :\n Generates a zstd skippable frame containing data given by src, and writes it to dst buffer.\n\n Skippable frames begin with a 4-byte magic number. There are 16 possible choices of magic number,\n ranging from ZSTD_MAGIC_SKIPPABLE_START to ZSTD_MAGIC_SKIPPABLE_START+15.\n As such, the parameter magicVariant controls the exact skippable frame magic number variant used,\n so the magic number used will be ZSTD_MAGIC_SKIPPABLE_START + magicVariant.\n\n Returns an error if destination buffer is not large enough, if the source size is not representable\n with a 4-byte unsigned int, or if the parameter magicVariant is greater than 15 (and therefore invalid).\n\n @return : number of bytes written or a ZSTD error."]
    pub fn ZSTD_writeSkippableFrame(
        dst: *mut ::core::ffi::c_void,
        dstCapacity: usize,
        src: *const ::core::ffi::c_void,
        srcSize: usize,
        magicVariant: ::core::ffi::c_uint,
    ) -> usize;
}
extern "C" {
    #[doc = " ZSTD_readSkippableFrame() :\n Retrieves the content of a zstd skippable frame starting at @src, and writes it to @dst buffer.\n\n The parameter @magicVariant will receive the magicVariant that was supplied when the frame was written,\n i.e. magicNumber - ZSTD_MAGIC_SKIPPABLE_START.\n This can be NULL if the caller is not interested in the magicVariant.\n\n Returns an error if destination buffer is not large enough, or if the frame is not skippable.\n\n @return : number of bytes written or a ZSTD error."]
    pub fn ZSTD_readSkippableFrame(
        dst: *mut ::core::ffi::c_void,
        dstCapacity: usize,
        magicVariant: *mut ::core::ffi::c_uint,
        src: *const ::core::ffi::c_void,
        srcSize: usize,
    ) -> usize;
}
extern "C" {
    #[doc = " ZSTD_isSkippableFrame() :\n  Tells if the content of `buffer` starts with a valid Frame Identifier for a skippable frame."]
    pub fn ZSTD_isSkippableFrame(
        buffer: *const ::core::ffi::c_void,
        size: usize,
    ) -> ::core::ffi::c_uint;
}
extern "C" {
    #[doc = " ZSTD_estimate*() :\n  These functions make it possible to estimate memory usage\n  of a future {D,C}Ctx, before its creation.\n  This is useful in combination with ZSTD_initStatic(),\n  which makes it possible to employ a static buffer for ZSTD_CCtx* state.\n\n  ZSTD_estimateCCtxSize() will provide a memory budget large enough\n  to compress data of any size using one-shot compression ZSTD_compressCCtx() or ZSTD_compress2()\n  associated with any compression level up to max specified one.\n  The estimate will assume the input may be arbitrarily large,\n  which is the worst case.\n\n  Note that the size estimation is specific for one-shot compression,\n  it is not valid for streaming (see ZSTD_estimateCStreamSize*())\n  nor other potential ways of using a ZSTD_CCtx* state.\n\n  When srcSize can be bound by a known and rather \"small\" value,\n  this knowledge can be used to provide a tighter budget estimation\n  because the ZSTD_CCtx* state will need less memory for small inputs.\n  This tighter estimation can be provided by employing more advanced functions\n  ZSTD_estimateCCtxSize_usingCParams(), which can be used in tandem with ZSTD_getCParams(),\n  and ZSTD_estimateCCtxSize_usingCCtxParams(), which can be used in tandem with ZSTD_CCtxParams_setParameter().\n  Both can be used to estimate memory using custom compression parameters and arbitrary srcSize limits.\n\n  Note : only single-threaded compression is supported.\n  ZSTD_estimateCCtxSize_usingCCtxParams() will return an error code if ZSTD_c_nbWorkers is >= 1."]
    pub fn ZSTD_estimateCCtxSize(
        maxCompressionLevel: ::core::ffi::c_int,
    ) -> usize;
}
extern "C" {
    pub fn ZSTD_estimateCCtxSize_usingCParams(
        cParams: ZSTD_compressionParameters,
    ) -> usize;
}
extern "C" {
    pub fn ZSTD_estimateCCtxSize_usingCCtxParams(
        params: *const ZSTD_CCtx_params,
    ) -> usize;
}
extern "C" {
    pub fn ZSTD_estimateDCtxSize() -> usize;
}
extern "C" {
    #[doc = " ZSTD_estimateCStreamSize() :\n  ZSTD_estimateCStreamSize() will provide a memory budget large enough for streaming compression\n  using any compression level up to the max specified one.\n  It will also consider src size to be arbitrarily \"large\", which is a worst case scenario.\n  If srcSize is known to always be small, ZSTD_estimateCStreamSize_usingCParams() can provide a tighter estimation.\n  ZSTD_estimateCStreamSize_usingCParams() can be used in tandem with ZSTD_getCParams() to create cParams from compressionLevel.\n  ZSTD_estimateCStreamSize_usingCCtxParams() can be used in tandem with ZSTD_CCtxParams_setParameter(). Only single-threaded compression is supported. This function will return an error code if ZSTD_c_nbWorkers is >= 1.\n  Note : CStream size estimation is only correct for single-threaded compression.\n  ZSTD_estimateCStreamSize_usingCCtxParams() will return an error code if ZSTD_c_nbWorkers is >= 1.\n  Note 2 : ZSTD_estimateCStreamSize* functions are not compatible with the Block-Level Sequence Producer API at this time.\n  Size estimates assume that no external sequence producer is registered.\n\n  ZSTD_DStream memory budget depends on frame's window Size.\n  This information can be passed manually, using ZSTD_estimateDStreamSize,\n  or deducted from a valid frame Header, using ZSTD_estimateDStreamSize_fromFrame();\n  Any frame requesting a window size larger than max specified one will be rejected.\n  Note : if streaming is init with function ZSTD_init?Stream_usingDict(),\n         an internal ?Dict will be created, which additional size is not estimated here.\n         In this case, get total size by adding ZSTD_estimate?DictSize"]
    pub fn ZSTD_estimateCStreamSize(
        maxCompressionLevel: ::core::ffi::c_int,
    ) -> usize;
}
extern "C" {
    pub fn ZSTD_estimateCStreamSize_usingCParams(
        cParams: ZSTD_compressionParameters,
    ) -> usize;
}
extern "C" {
    pub fn ZSTD_estimateCStreamSize_usingCCtxParams(
        params: *const ZSTD_CCtx_params,
    ) -> usize;
}
extern "C" {
    pub fn ZSTD_estimateDStreamSize(maxWindowSize: usize) -> usize;
}
extern "C" {
    pub fn ZSTD_estimateDStreamSize_fromFrame(
        src: *const ::core::ffi::c_void,
        srcSize: usize,
    ) -> usize;
}
extern "C" {
    #[doc = " ZSTD_estimate?DictSize() :\n  ZSTD_estimateCDictSize() will bet that src size is relatively \"small\", and content is copied, like ZSTD_createCDict().\n  ZSTD_estimateCDictSize_advanced() makes it possible to control compression parameters precisely, like ZSTD_createCDict_advanced().\n  Note : dictionaries created by reference (`ZSTD_dlm_byRef`) are logically smaller."]
    pub fn ZSTD_estimateCDictSize(
        dictSize: usize,
        compressionLevel: ::core::ffi::c_int,
    ) -> usize;
}
extern "C" {
    pub fn ZSTD_estimateCDictSize_advanced(
        dictSize: usize,
        cParams: ZSTD_compressionParameters,
        dictLoadMethod: ZSTD_dictLoadMethod_e,
    ) -> usize;
}
extern "C" {
    pub fn ZSTD_estimateDDictSize(
        dictSize: usize,
        dictLoadMethod: ZSTD_dictLoadMethod_e,
    ) -> usize;
}
extern "C" {
    #[doc = " ZSTD_initStatic*() :\n  Initialize an object using a pre-allocated fixed-size buffer.\n  workspace: The memory area to emplace the object into.\n             Provided pointer *must be 8-bytes aligned*.\n             Buffer must outlive object.\n  workspaceSize: Use ZSTD_estimate*Size() to determine\n                 how large workspace must be to support target scenario.\n @return : pointer to object (same address as workspace, just different type),\n           or NULL if error (size too small, incorrect alignment, etc.)\n  Note : zstd will never resize nor malloc() when using a static buffer.\n         If the object requires more memory than available,\n         zstd will just error out (typically ZSTD_error_memory_allocation).\n  Note 2 : there is no corresponding \"free\" function.\n           Since workspace is allocated externally, it must be freed externally too.\n  Note 3 : cParams : use ZSTD_getCParams() to convert a compression level\n           into its associated cParams.\n  Limitation 1 : currently not compatible with internal dictionary creation, triggered by\n                 ZSTD_CCtx_loadDictionary(), ZSTD_initCStream_usingDict() or ZSTD_initDStream_usingDict().\n  Limitation 2 : static cctx currently not compatible with multi-threading.\n  Limitation 3 : static dctx is incompatible with legacy support."]
    pub fn ZSTD_initStaticCCtx(
        workspace: *mut ::core::ffi::c_void,
        workspaceSize: usize,
    ) -> *mut ZSTD_CCtx;
}
extern "C" {
    pub fn ZSTD_initStaticCStream(
        workspace: *mut ::core::ffi::c_void,
        workspaceSize: usize,
    ) -> *mut ZSTD_CStream;
}
extern "C" {
    pub fn ZSTD_initStaticDCtx(
        workspace: *mut ::core::ffi::c_void,
        workspaceSize: usize,
    ) -> *mut ZSTD_DCtx;
}
extern "C" {
    pub fn ZSTD_initStaticDStream(
        workspace: *mut ::core::ffi::c_void,
        workspaceSize: usize,
    ) -> *mut ZSTD_DStream;
}
extern "C" {
    pub fn ZSTD_initStaticCDict(
        workspace: *mut ::core::ffi::c_void,
        workspaceSize: usize,
        dict: *const ::core::ffi::c_void,
        dictSize: usize,
        dictLoadMethod: ZSTD_dictLoadMethod_e,
        dictContentType: ZSTD_dictContentType_e,
        cParams: ZSTD_compressionParameters,
    ) -> *const ZSTD_CDict;
}
extern "C" {
    pub fn ZSTD_initStaticDDict(
        workspace: *mut ::core::ffi::c_void,
        workspaceSize: usize,
        dict: *const ::core::ffi::c_void,
        dictSize: usize,
        dictLoadMethod: ZSTD_dictLoadMethod_e,
        dictContentType: ZSTD_dictContentType_e,
    ) -> *const ZSTD_DDict;
}
#[doc = " Custom memory allocation :\n  These prototypes make it possible to pass your own allocation/free functions.\n  ZSTD_customMem is provided at creation time, using ZSTD_create*_advanced() variants listed below.\n  All allocation/free operations will be completed using these custom variants instead of regular <stdlib.h> ones."]
pub type ZSTD_allocFunction = ::core::option::Option<
    unsafe extern "C" fn(
        opaque: *mut ::core::ffi::c_void,
        size: usize,
    ) -> *mut ::core::ffi::c_void,
>;
pub type ZSTD_freeFunction = ::core::option::Option<
    unsafe extern "C" fn(
        opaque: *mut ::core::ffi::c_void,
        address: *mut ::core::ffi::c_void,
    ),
>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ZSTD_customMem {
    pub customAlloc: ZSTD_allocFunction,
    pub customFree: ZSTD_freeFunction,
    pub opaque: *mut ::core::ffi::c_void,
}
extern "C" {
    #[doc = "< this constant defers to stdlib's functions"]
    pub static ZSTD_defaultCMem: ZSTD_customMem;
}
extern "C" {
    pub fn ZSTD_createCCtx_advanced(
        customMem: ZSTD_customMem,
    ) -> *mut ZSTD_CCtx;
}
extern "C" {
    pub fn ZSTD_createCStream_advanced(
        customMem: ZSTD_customMem,
    ) -> *mut ZSTD_CStream;
}
extern "C" {
    pub fn ZSTD_createDCtx_advanced(
        customMem: ZSTD_customMem,
    ) -> *mut ZSTD_DCtx;
}
extern "C" {
    pub fn ZSTD_createDStream_advanced(
        customMem: ZSTD_customMem,
    ) -> *mut ZSTD_DStream;
}
extern "C" {
    pub fn ZSTD_createCDict_advanced(
        dict: *const ::core::ffi::c_void,
        dictSize: usize,
        dictLoadMethod: ZSTD_dictLoadMethod_e,
        dictContentType: ZSTD_dictContentType_e,
        cParams: ZSTD_compressionParameters,
        customMem: ZSTD_customMem,
    ) -> *mut ZSTD_CDict;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct POOL_ctx_s {
    _unused: [u8; 0],
}
#[doc = " Thread pool :\n  These prototypes make it possible to share a thread pool among multiple compression contexts.\n  This can limit resources for applications with multiple threads where each one uses\n  a threaded compression mode (via ZSTD_c_nbWorkers parameter).\n  ZSTD_createThreadPool creates a new thread pool with a given number of threads.\n  Note that the lifetime of such pool must exist while being used.\n  ZSTD_CCtx_refThreadPool assigns a thread pool to a context (use NULL argument value\n  to use an internal thread pool).\n  ZSTD_freeThreadPool frees a thread pool, accepts NULL pointer."]
pub type ZSTD_threadPool = POOL_ctx_s;
extern "C" {
    pub fn ZSTD_createThreadPool(numThreads: usize) -> *mut ZSTD_threadPool;
}
extern "C" {
    pub fn ZSTD_freeThreadPool(pool: *mut ZSTD_threadPool);
}
extern "C" {
    pub fn ZSTD_CCtx_refThreadPool(
        cctx: *mut ZSTD_CCtx,
        pool: *mut ZSTD_threadPool,
    ) -> usize;
}
extern "C" {
    pub fn ZSTD_createCDict_advanced2(
        dict: *const ::core::ffi::c_void,
        dictSize: usize,
        dictLoadMethod: ZSTD_dictLoadMethod_e,
        dictContentType: ZSTD_dictContentType_e,
        cctxParams: *const ZSTD_CCtx_params,
        customMem: ZSTD_customMem,
    ) -> *mut ZSTD_CDict;
}
extern "C" {
    pub fn ZSTD_createDDict_advanced(
        dict: *const ::core::ffi::c_void,
        dictSize: usize,
        dictLoadMethod: ZSTD_dictLoadMethod_e,
        dictContentType: ZSTD_dictContentType_e,
        customMem: ZSTD_customMem,
    ) -> *mut ZSTD_DDict;
}
extern "C" {
    #[doc = " ZSTD_createCDict_byReference() :\n  Create a digested dictionary for compression\n  Dictionary content is just referenced, not duplicated.\n  As a consequence, `dictBuffer` **must** outlive CDict,\n  and its content must remain unmodified throughout the lifetime of CDict.\n  note: equivalent to ZSTD_createCDict_advanced(), with dictLoadMethod==ZSTD_dlm_byRef"]
    pub fn ZSTD_createCDict_byReference(
        dictBuffer: *const ::core::ffi::c_void,
        dictSize: usize,
        compressionLevel: ::core::ffi::c_int,
    ) -> *mut ZSTD_CDict;
}
extern "C" {
    #[doc = " ZSTD_getCParams() :\n @return ZSTD_compressionParameters structure for a selected compression level and estimated srcSize.\n `estimatedSrcSize` value is optional, select 0 if not known"]
    pub fn ZSTD_getCParams(
        compressionLevel: ::core::ffi::c_int,
        estimatedSrcSize: ::core::ffi::c_ulonglong,
        dictSize: usize,
    ) -> ZSTD_compressionParameters;
}
extern "C" {
    #[doc = " ZSTD_getParams() :\n  same as ZSTD_getCParams(), but @return a full `ZSTD_parameters` object instead of sub-component `ZSTD_compressionParameters`.\n  All fields of `ZSTD_frameParameters` are set to default : contentSize=1, checksum=0, noDictID=0"]
    pub fn ZSTD_getParams(
        compressionLevel: ::core::ffi::c_int,
        estimatedSrcSize: ::core::ffi::c_ulonglong,
        dictSize: usize,
    ) -> ZSTD_parameters;
}
extern "C" {
    #[doc = " ZSTD_checkCParams() :\n  Ensure param values remain within authorized range.\n @return 0 on success, or an error code (can be checked with ZSTD_isError())"]
    pub fn ZSTD_checkCParams(params: ZSTD_compressionParameters) -> usize;
}
extern "C" {
    #[doc = " ZSTD_adjustCParams() :\n  optimize params for a given `srcSize` and `dictSize`.\n `srcSize` can be unknown, in which case use ZSTD_CONTENTSIZE_UNKNOWN.\n `dictSize` must be `0` when there is no dictionary.\n  cPar can be invalid : all parameters will be clamped within valid range in the @return struct.\n  This function never fails (wide contract)"]
    pub fn ZSTD_adjustCParams(
        cPar: ZSTD_compressionParameters,
        srcSize: ::core::ffi::c_ulonglong,
        dictSize: usize,
    ) -> ZSTD_compressionParameters;
}
extern "C" {
    #[doc = " ZSTD_CCtx_setCParams() :\n  Set all parameters provided within @p cparams into the working @p cctx.\n  Note : if modifying parameters during compression (MT mode only),\n         note that changes to the .windowLog parameter will be ignored.\n @return 0 on success, or an error code (can be checked with ZSTD_isError()).\n         On failure, no parameters are updated."]
    pub fn ZSTD_CCtx_setCParams(
        cctx: *mut ZSTD_CCtx,
        cparams: ZSTD_compressionParameters,
    ) -> usize;
}
extern "C" {
    #[doc = " ZSTD_CCtx_setFParams() :\n  Set all parameters provided within @p fparams into the working @p cctx.\n @return 0 on success, or an error code (can be checked with ZSTD_isError())."]
    pub fn ZSTD_CCtx_setFParams(
        cctx: *mut ZSTD_CCtx,
        fparams: ZSTD_frameParameters,
    ) -> usize;
}
extern "C" {
    #[doc = " ZSTD_CCtx_setParams() :\n  Set all parameters provided within @p params into the working @p cctx.\n @return 0 on success, or an error code (can be checked with ZSTD_isError())."]
    pub fn ZSTD_CCtx_setParams(
        cctx: *mut ZSTD_CCtx,
        params: ZSTD_parameters,
    ) -> usize;
}
extern "C" {
    #[doc = " ZSTD_compress_advanced() :\n  Note : this function is now DEPRECATED.\n         It can be replaced by ZSTD_compress2(), in combination with ZSTD_CCtx_setParameter() and other parameter setters.\n  This prototype will generate compilation warnings."]
    pub fn ZSTD_compress_advanced(
        cctx: *mut ZSTD_CCtx,
        dst: *mut ::core::ffi::c_void,
        dstCapacity: usize,
        src: *const ::core::ffi::c_void,
        srcSize: usize,
        dict: *const ::core::ffi::c_void,
        dictSize: usize,
        params: ZSTD_parameters,
    ) -> usize;
}
extern "C" {
    #[doc = " ZSTD_compress_usingCDict_advanced() :\n  Note : this function is now DEPRECATED.\n         It can be replaced by ZSTD_compress2(), in combination with ZSTD_CCtx_loadDictionary() and other parameter setters.\n  This prototype will generate compilation warnings."]
    pub fn ZSTD_compress_usingCDict_advanced(
        cctx: *mut ZSTD_CCtx,
        dst: *mut ::core::ffi::c_void,
        dstCapacity: usize,
        src: *const ::core::ffi::c_void,
        srcSize: usize,
        cdict: *const ZSTD_CDict,
        fParams: ZSTD_frameParameters,
    ) -> usize;
}
extern "C" {
    #[doc = " ZSTD_CCtx_loadDictionary_byReference() :\n  Same as ZSTD_CCtx_loadDictionary(), but dictionary content is referenced, instead of being copied into CCtx.\n  It saves some memory, but also requires that `dict` outlives its usage within `cctx`"]
    pub fn ZSTD_CCtx_loadDictionary_byReference(
        cctx: *mut ZSTD_CCtx,
        dict: *const ::core::ffi::c_void,
        dictSize: usize,
    ) -> usize;
}
extern "C" {
    #[doc = " ZSTD_CCtx_loadDictionary_advanced() :\n  Same as ZSTD_CCtx_loadDictionary(), but gives finer control over\n  how to load the dictionary (by copy ? by reference ?)\n  and how to interpret it (automatic ? force raw mode ? full mode only ?)"]
    pub fn ZSTD_CCtx_loadDictionary_advanced(
        cctx: *mut ZSTD_CCtx,
        dict: *const ::core::ffi::c_void,
        dictSize: usize,
        dictLoadMethod: ZSTD_dictLoadMethod_e,
        dictContentType: ZSTD_dictContentType_e,
    ) -> usize;
}
extern "C" {
    #[doc = " ZSTD_CCtx_refPrefix_advanced() :\n  Same as ZSTD_CCtx_refPrefix(), but gives finer control over\n  how to interpret prefix content (automatic ? force raw mode (default) ? full mode only ?)"]
    pub fn ZSTD_CCtx_refPrefix_advanced(
        cctx: *mut ZSTD_CCtx,
        prefix: *const ::core::ffi::c_void,
        prefixSize: usize,
        dictContentType: ZSTD_dictContentType_e,
    ) -> usize;
}
extern "C" {
    #[doc = " ZSTD_CCtx_getParameter() :\n  Get the requested compression parameter value, selected by enum ZSTD_cParameter,\n  and store it into int* value.\n @return : 0, or an error code (which can be tested with ZSTD_isError())."]
    pub fn ZSTD_CCtx_getParameter(
        cctx: *const ZSTD_CCtx,
        param: ZSTD_cParameter,
        value: *mut ::core::ffi::c_int,
    ) -> usize;
}
extern "C" {
    #[doc = " ZSTD_CCtx_params :\n  Quick howto :\n  - ZSTD_createCCtxParams() : Create a ZSTD_CCtx_params structure\n  - ZSTD_CCtxParams_setParameter() : Push parameters one by one into\n                                     an existing ZSTD_CCtx_params structure.\n                                     This is similar to\n                                     ZSTD_CCtx_setParameter().\n  - ZSTD_CCtx_setParametersUsingCCtxParams() : Apply parameters to\n                                    an existing CCtx.\n                                    These parameters will be applied to\n                                    all subsequent frames.\n  - ZSTD_compressStream2() : Do compression using the CCtx.\n  - ZSTD_freeCCtxParams() : Free the memory, accept NULL pointer.\n\n  This can be used with ZSTD_estimateCCtxSize_advanced_usingCCtxParams()\n  for static allocation of CCtx for single-threaded compression."]
    pub fn ZSTD_createCCtxParams() -> *mut ZSTD_CCtx_params;
}
extern "C" {
    pub fn ZSTD_freeCCtxParams(params: *mut ZSTD_CCtx_params) -> usize;
}
extern "C" {
    #[doc = " ZSTD_CCtxParams_reset() :\n  Reset params to default values."]
    pub fn ZSTD_CCtxParams_reset(params: *mut ZSTD_CCtx_params) -> usize;
}
extern "C" {
    #[doc = " ZSTD_CCtxParams_init() :\n  Initializes the compression parameters of cctxParams according to\n  compression level. All other parameters are reset to their default values."]
    pub fn ZSTD_CCtxParams_init(
        cctxParams: *mut ZSTD_CCtx_params,
        compressionLevel: ::core::ffi::c_int,
    ) -> usize;
}
extern "C" {
    #[doc = " ZSTD_CCtxParams_init_advanced() :\n  Initializes the compression and frame parameters of cctxParams according to\n  params. All other parameters are reset to their default values."]
    pub fn ZSTD_CCtxParams_init_advanced(
        cctxParams: *mut ZSTD_CCtx_params,
        params: ZSTD_parameters,
    ) -> usize;
}
extern "C" {
    #[doc = " ZSTD_CCtxParams_setParameter() : Requires v1.4.0+\n  Similar to ZSTD_CCtx_setParameter.\n  Set one compression parameter, selected by enum ZSTD_cParameter.\n  Parameters must be applied to a ZSTD_CCtx using\n  ZSTD_CCtx_setParametersUsingCCtxParams().\n @result : a code representing success or failure (which can be tested with\n           ZSTD_isError())."]
    pub fn ZSTD_CCtxParams_setParameter(
        params: *mut ZSTD_CCtx_params,
        param: ZSTD_cParameter,
        value: ::core::ffi::c_int,
    ) -> usize;
}
extern "C" {
    #[doc = " ZSTD_CCtxParams_getParameter() :\n Similar to ZSTD_CCtx_getParameter.\n Get the requested value of one compression parameter, selected by enum ZSTD_cParameter.\n @result : 0, or an error code (which can be tested with ZSTD_isError())."]
    pub fn ZSTD_CCtxParams_getParameter(
        params: *const ZSTD_CCtx_params,
        param: ZSTD_cParameter,
        value: *mut ::core::ffi::c_int,
    ) -> usize;
}
extern "C" {
    #[doc = " ZSTD_CCtx_setParametersUsingCCtxParams() :\n  Apply a set of ZSTD_CCtx_params to the compression context.\n  This can be done even after compression is started,\n    if nbWorkers==0, this will have no impact until a new compression is started.\n    if nbWorkers>=1, new parameters will be picked up at next job,\n       with a few restrictions (windowLog, pledgedSrcSize, nbWorkers, jobSize, and overlapLog are not updated)."]
    pub fn ZSTD_CCtx_setParametersUsingCCtxParams(
        cctx: *mut ZSTD_CCtx,
        params: *const ZSTD_CCtx_params,
    ) -> usize;
}
extern "C" {
    #[doc = " ZSTD_compressStream2_simpleArgs() :\n  Same as ZSTD_compressStream2(),\n  but using only integral types as arguments.\n  This variant might be helpful for binders from dynamic languages\n  which have troubles handling structures containing memory pointers."]
    pub fn ZSTD_compressStream2_simpleArgs(
        cctx: *mut ZSTD_CCtx,
        dst: *mut ::core::ffi::c_void,
        dstCapacity: usize,
        dstPos: *mut usize,
        src: *const ::core::ffi::c_void,
        srcSize: usize,
        srcPos: *mut usize,
        endOp: ZSTD_EndDirective,
    ) -> usize;
}
extern "C" {
    #[doc = " ZSTD_isFrame() :\n  Tells if the content of `buffer` starts with a valid Frame Identifier.\n  Note : Frame Identifier is 4 bytes. If `size < 4`, @return will always be 0.\n  Note 2 : Legacy Frame Identifiers are considered valid only if Legacy Support is enabled.\n  Note 3 : Skippable Frame Identifiers are considered valid."]
    pub fn ZSTD_isFrame(
        buffer: *const ::core::ffi::c_void,
        size: usize,
    ) -> ::core::ffi::c_uint;
}
extern "C" {
    #[doc = " ZSTD_createDDict_byReference() :\n  Create a digested dictionary, ready to start decompression operation without startup delay.\n  Dictionary content is referenced, and therefore stays in dictBuffer.\n  It is important that dictBuffer outlives DDict,\n  it must remain read accessible throughout the lifetime of DDict"]
    pub fn ZSTD_createDDict_byReference(
        dictBuffer: *const ::core::ffi::c_void,
        dictSize: usize,
    ) -> *mut ZSTD_DDict;
}
extern "C" {
    #[doc = " ZSTD_DCtx_loadDictionary_byReference() :\n  Same as ZSTD_DCtx_loadDictionary(),\n  but references `dict` content instead of copying it into `dctx`.\n  This saves memory if `dict` remains around.,\n  However, it's imperative that `dict` remains accessible (and unmodified) while being used, so it must outlive decompression."]
    pub fn ZSTD_DCtx_loadDictionary_byReference(
        dctx: *mut ZSTD_DCtx,
        dict: *const ::core::ffi::c_void,
        dictSize: usize,
    ) -> usize;
}
extern "C" {
    #[doc = " ZSTD_DCtx_loadDictionary_advanced() :\n  Same as ZSTD_DCtx_loadDictionary(),\n  but gives direct control over\n  how to load the dictionary (by copy ? by reference ?)\n  and how to interpret it (automatic ? force raw mode ? full mode only ?)."]
    pub fn ZSTD_DCtx_loadDictionary_advanced(
        dctx: *mut ZSTD_DCtx,
        dict: *const ::core::ffi::c_void,
        dictSize: usize,
        dictLoadMethod: ZSTD_dictLoadMethod_e,
        dictContentType: ZSTD_dictContentType_e,
    ) -> usize;
}
extern "C" {
    #[doc = " ZSTD_DCtx_refPrefix_advanced() :\n  Same as ZSTD_DCtx_refPrefix(), but gives finer control over\n  how to interpret prefix content (automatic ? force raw mode (default) ? full mode only ?)"]
    pub fn ZSTD_DCtx_refPrefix_advanced(
        dctx: *mut ZSTD_DCtx,
        prefix: *const ::core::ffi::c_void,
        prefixSize: usize,
        dictContentType: ZSTD_dictContentType_e,
    ) -> usize;
}
extern "C" {
    #[doc = " ZSTD_DCtx_setMaxWindowSize() :\n  Refuses allocating internal buffers for frames requiring a window size larger than provided limit.\n  This protects a decoder context from reserving too much memory for itself (potential attack scenario).\n  This parameter is only useful in streaming mode, since no internal buffer is allocated in single-pass mode.\n  By default, a decompression context accepts all window sizes <= (1 << ZSTD_WINDOWLOG_LIMIT_DEFAULT)\n @return : 0, or an error code (which can be tested using ZSTD_isError())."]
    pub fn ZSTD_DCtx_setMaxWindowSize(
        dctx: *mut ZSTD_DCtx,
        maxWindowSize: usize,
    ) -> usize;
}
extern "C" {
    #[doc = " ZSTD_DCtx_getParameter() :\n  Get the requested decompression parameter value, selected by enum ZSTD_dParameter,\n  and store it into int* value.\n @return : 0, or an error code (which can be tested with ZSTD_isError())."]
    pub fn ZSTD_DCtx_getParameter(
        dctx: *mut ZSTD_DCtx,
        param: ZSTD_dParameter,
        value: *mut ::core::ffi::c_int,
    ) -> usize;
}
extern "C" {
    #[doc = " ZSTD_DCtx_setFormat() :\n  This function is REDUNDANT. Prefer ZSTD_DCtx_setParameter().\n  Instruct the decoder context about what kind of data to decode next.\n  This instruction is mandatory to decode data without a fully-formed header,\n  such ZSTD_f_zstd1_magicless for example.\n @return : 0, or an error code (which can be tested using ZSTD_isError())."]
    pub fn ZSTD_DCtx_setFormat(
        dctx: *mut ZSTD_DCtx,
        format: ZSTD_format_e,
    ) -> usize;
}
extern "C" {
    #[doc = " ZSTD_decompressStream_simpleArgs() :\n  Same as ZSTD_decompressStream(),\n  but using only integral types as arguments.\n  This can be helpful for binders from dynamic languages\n  which have troubles handling structures containing memory pointers."]
    pub fn ZSTD_decompressStream_simpleArgs(
        dctx: *mut ZSTD_DCtx,
        dst: *mut ::core::ffi::c_void,
        dstCapacity: usize,
        dstPos: *mut usize,
        src: *const ::core::ffi::c_void,
        srcSize: usize,
        srcPos: *mut usize,
    ) -> usize;
}
extern "C" {
    #[doc = " ZSTD_initCStream_srcSize() :\n This function is DEPRECATED, and equivalent to:\n     ZSTD_CCtx_reset(zcs, ZSTD_reset_session_only);\n     ZSTD_CCtx_refCDict(zcs, NULL); // clear the dictionary (if any)\n     ZSTD_CCtx_setParameter(zcs, ZSTD_c_compressionLevel, compressionLevel);\n     ZSTD_CCtx_setPledgedSrcSize(zcs, pledgedSrcSize);\n\n pledgedSrcSize must be correct. If it is not known at init time, use\n ZSTD_CONTENTSIZE_UNKNOWN. Note that, for compatibility with older programs,\n \"0\" also disables frame content size field. It may be enabled in the future.\n This prototype will generate compilation warnings."]
    pub fn ZSTD_initCStream_srcSize(
        zcs: *mut ZSTD_CStream,
        compressionLevel: ::core::ffi::c_int,
        pledgedSrcSize: ::core::ffi::c_ulonglong,
    ) -> usize;
}
extern "C" {
    #[doc = " ZSTD_initCStream_usingDict() :\n This function is DEPRECATED, and is equivalent to:\n     ZSTD_CCtx_reset(zcs, ZSTD_reset_session_only);\n     ZSTD_CCtx_setParameter(zcs, ZSTD_c_compressionLevel, compressionLevel);\n     ZSTD_CCtx_loadDictionary(zcs, dict, dictSize);\n\n Creates of an internal CDict (incompatible with static CCtx), except if\n dict == NULL or dictSize < 8, in which case no dict is used.\n Note: dict is loaded with ZSTD_dct_auto (treated as a full zstd dictionary if\n it begins with ZSTD_MAGIC_DICTIONARY, else as raw content) and ZSTD_dlm_byCopy.\n This prototype will generate compilation warnings."]
    pub fn ZSTD_initCStream_usingDict(
        zcs: *mut ZSTD_CStream,
        dict: *const ::core::ffi::c_void,
        dictSize: usize,
        compressionLevel: ::core::ffi::c_int,
    ) -> usize;
}
extern "C" {
    #[doc = " ZSTD_initCStream_advanced() :\n This function is DEPRECATED, and is equivalent to:\n     ZSTD_CCtx_reset(zcs, ZSTD_reset_session_only);\n     ZSTD_CCtx_setParams(zcs, params);\n     ZSTD_CCtx_setPledgedSrcSize(zcs, pledgedSrcSize);\n     ZSTD_CCtx_loadDictionary(zcs, dict, dictSize);\n\n dict is loaded with ZSTD_dct_auto and ZSTD_dlm_byCopy.\n pledgedSrcSize must be correct.\n If srcSize is not known at init time, use value ZSTD_CONTENTSIZE_UNKNOWN.\n This prototype will generate compilation warnings."]
    pub fn ZSTD_initCStream_advanced(
        zcs: *mut ZSTD_CStream,
        dict: *const ::core::ffi::c_void,
        dictSize: usize,
        params: ZSTD_parameters,
        pledgedSrcSize: ::core::ffi::c_ulonglong,
    ) -> usize;
}
extern "C" {
    #[doc = " ZSTD_initCStream_usingCDict() :\n This function is DEPRECATED, and equivalent to:\n     ZSTD_CCtx_reset(zcs, ZSTD_reset_session_only);\n     ZSTD_CCtx_refCDict(zcs, cdict);\n\n note : cdict will just be referenced, and must outlive compression session\n This prototype will generate compilation warnings."]
    pub fn ZSTD_initCStream_usingCDict(
        zcs: *mut ZSTD_CStream,
        cdict: *const ZSTD_CDict,
    ) -> usize;
}
extern "C" {
    #[doc = " ZSTD_initCStream_usingCDict_advanced() :\n   This function is DEPRECATED, and is equivalent to:\n     ZSTD_CCtx_reset(zcs, ZSTD_reset_session_only);\n     ZSTD_CCtx_setFParams(zcs, fParams);\n     ZSTD_CCtx_setPledgedSrcSize(zcs, pledgedSrcSize);\n     ZSTD_CCtx_refCDict(zcs, cdict);\n\n same as ZSTD_initCStream_usingCDict(), with control over frame parameters.\n pledgedSrcSize must be correct. If srcSize is not known at init time, use\n value ZSTD_CONTENTSIZE_UNKNOWN.\n This prototype will generate compilation warnings."]
    pub fn ZSTD_initCStream_usingCDict_advanced(
        zcs: *mut ZSTD_CStream,
        cdict: *const ZSTD_CDict,
        fParams: ZSTD_frameParameters,
        pledgedSrcSize: ::core::ffi::c_ulonglong,
    ) -> usize;
}
extern "C" {
    #[doc = " ZSTD_resetCStream() :\n This function is DEPRECATED, and is equivalent to:\n     ZSTD_CCtx_reset(zcs, ZSTD_reset_session_only);\n     ZSTD_CCtx_setPledgedSrcSize(zcs, pledgedSrcSize);\n Note: ZSTD_resetCStream() interprets pledgedSrcSize == 0 as ZSTD_CONTENTSIZE_UNKNOWN, but\n       ZSTD_CCtx_setPledgedSrcSize() does not do the same, so ZSTD_CONTENTSIZE_UNKNOWN must be\n       explicitly specified.\n\n  start a new frame, using same parameters from previous frame.\n  This is typically useful to skip dictionary loading stage, since it will reuse it in-place.\n  Note that zcs must be init at least once before using ZSTD_resetCStream().\n  If pledgedSrcSize is not known at reset time, use macro ZSTD_CONTENTSIZE_UNKNOWN.\n  If pledgedSrcSize > 0, its value must be correct, as it will be written in header, and controlled at the end.\n  For the time being, pledgedSrcSize==0 is interpreted as \"srcSize unknown\" for compatibility with older programs,\n  but it will change to mean \"empty\" in future version, so use macro ZSTD_CONTENTSIZE_UNKNOWN instead.\n @return : 0, or an error code (which can be tested using ZSTD_isError())\n  This prototype will generate compilation warnings."]
    pub fn ZSTD_resetCStream(
        zcs: *mut ZSTD_CStream,
        pledgedSrcSize: ::core::ffi::c_ulonglong,
    ) -> usize;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ZSTD_frameProgression {
    pub ingested: ::core::ffi::c_ulonglong,
    pub consumed: ::core::ffi::c_ulonglong,
    pub produced: ::core::ffi::c_ulonglong,
    pub flushed: ::core::ffi::c_ulonglong,
    pub currentJobID: ::core::ffi::c_uint,
    pub nbActiveWorkers: ::core::ffi::c_uint,
}
extern "C" {
    pub fn ZSTD_getFrameProgression(
        cctx: *const ZSTD_CCtx,
    ) -> ZSTD_frameProgression;
}
extern "C" {
    #[doc = " ZSTD_toFlushNow() :\n  Tell how many bytes are ready to be flushed immediately.\n  Useful for multithreading scenarios (nbWorkers >= 1).\n  Probe the oldest active job, defined as oldest job not yet entirely flushed,\n  and check its output buffer.\n @return : amount of data stored in oldest job and ready to be flushed immediately.\n  if @return == 0, it means either :\n  + there is no active job (could be checked with ZSTD_frameProgression()), or\n  + oldest job is still actively compressing data,\n    but everything it has produced has also been flushed so far,\n    therefore flush speed is limited by production speed of oldest job\n    irrespective of the speed of concurrent (and newer) jobs."]
    pub fn ZSTD_toFlushNow(cctx: *mut ZSTD_CCtx) -> usize;
}
extern "C" {
    #[doc = " This function is deprecated, and is equivalent to:\n\n     ZSTD_DCtx_reset(zds, ZSTD_reset_session_only);\n     ZSTD_DCtx_loadDictionary(zds, dict, dictSize);\n\n note: no dictionary will be used if dict == NULL or dictSize < 8"]
    pub fn ZSTD_initDStream_usingDict(
        zds: *mut ZSTD_DStream,
        dict: *const ::core::ffi::c_void,
        dictSize: usize,
    ) -> usize;
}
extern "C" {
    #[doc = " This function is deprecated, and is equivalent to:\n\n     ZSTD_DCtx_reset(zds, ZSTD_reset_session_only);\n     ZSTD_DCtx_refDDict(zds, ddict);\n\n note : ddict is referenced, it must outlive decompression session"]
    pub fn ZSTD_initDStream_usingDDict(
        zds: *mut ZSTD_DStream,
        ddict: *const ZSTD_DDict,
    ) -> usize;
}
extern "C" {
    #[doc = " This function is deprecated, and is equivalent to:\n\n     ZSTD_DCtx_reset(zds, ZSTD_reset_session_only);\n\n reuse decompression parameters from previous init; saves dictionary loading"]
    pub fn ZSTD_resetDStream(zds: *mut ZSTD_DStream) -> usize;
}
pub type ZSTD_sequenceProducer_F = ::core::option::Option<
    unsafe extern "C" fn(
        sequenceProducerState: *mut ::core::ffi::c_void,
        outSeqs: *mut ZSTD_Sequence,
        outSeqsCapacity: usize,
        src: *const ::core::ffi::c_void,
        srcSize: usize,
        dict: *const ::core::ffi::c_void,
        dictSize: usize,
        compressionLevel: ::core::ffi::c_int,
        windowSize: usize,
    ) -> usize,
>;
extern "C" {
    #[doc = " ZSTD_registerSequenceProducer() :\n Instruct zstd to use a block-level external sequence producer function.\n\n The sequenceProducerState must be initialized by the caller, and the caller is\n responsible for managing its lifetime. This parameter is sticky across\n compressions. It will remain set until the user explicitly resets compression\n parameters.\n\n Sequence producer registration is considered to be an \"advanced parameter\",\n part of the \"advanced API\". This means it will only have an effect on compression\n APIs which respect advanced parameters, such as compress2() and compressStream2().\n Older compression APIs such as compressCCtx(), which predate the introduction of\n \"advanced parameters\", will ignore any external sequence producer setting.\n\n The sequence producer can be \"cleared\" by registering a NULL function pointer. This\n removes all limitations described above in the \"LIMITATIONS\" section of the API docs.\n\n The user is strongly encouraged to read the full API documentation (above) before\n calling this function."]
    pub fn ZSTD_registerSequenceProducer(
        cctx: *mut ZSTD_CCtx,
        sequenceProducerState: *mut ::core::ffi::c_void,
        sequenceProducer: ZSTD_sequenceProducer_F,
    );
}
extern "C" {
    #[doc = " ZSTD_CCtxParams_registerSequenceProducer() :\n Same as ZSTD_registerSequenceProducer(), but operates on ZSTD_CCtx_params.\n This is used for accurate size estimation with ZSTD_estimateCCtxSize_usingCCtxParams(),\n which is needed when creating a ZSTD_CCtx with ZSTD_initStaticCCtx().\n\n If you are using the external sequence producer API in a scenario where ZSTD_initStaticCCtx()\n is required, then this function is for you. Otherwise, you probably don't need it.\n\n See tests/zstreamtest.c for example usage."]
    pub fn ZSTD_CCtxParams_registerSequenceProducer(
        params: *mut ZSTD_CCtx_params,
        sequenceProducerState: *mut ::core::ffi::c_void,
        sequenceProducer: ZSTD_sequenceProducer_F,
    );
}
extern "C" {
    #[doc = "Buffer-less streaming compression (synchronous mode)\n\nA ZSTD_CCtx object is required to track streaming operations.\nUse ZSTD_createCCtx() / ZSTD_freeCCtx() to manage resource.\nZSTD_CCtx object can be reused multiple times within successive compression operations.\n\nStart by initializing a context.\nUse ZSTD_compressBegin(), or ZSTD_compressBegin_usingDict() for dictionary compression.\n\nThen, consume your input using ZSTD_compressContinue().\nThere are some important considerations to keep in mind when using this advanced function :\n- ZSTD_compressContinue() has no internal buffer. It uses externally provided buffers only.\n- Interface is synchronous : input is consumed entirely and produces 1+ compressed blocks.\n- Caller must ensure there is enough space in `dst` to store compressed data under worst case scenario.\nWorst case evaluation is provided by ZSTD_compressBound().\nZSTD_compressContinue() doesn't guarantee recover after a failed compression.\n- ZSTD_compressContinue() presumes prior input ***is still accessible and unmodified*** (up to maximum distance size, see WindowLog).\nIt remembers all previous contiguous blocks, plus one separated memory segment (which can itself consists of multiple contiguous blocks)\n- ZSTD_compressContinue() detects that prior input has been overwritten when `src` buffer overlaps.\nIn which case, it will \"discard\" the relevant memory section from its history.\n\nFinish a frame with ZSTD_compressEnd(), which will write the last block(s) and optional checksum.\nIt's possible to use srcSize==0, in which case, it will write a final empty block to end the frame.\nWithout last block mark, frames are considered unfinished (hence corrupted) by compliant decoders.\n\n`ZSTD_CCtx` object can be reused (ZSTD_compressBegin()) to compress again."]
    pub fn ZSTD_compressBegin(
        cctx: *mut ZSTD_CCtx,
        compressionLevel: ::core::ffi::c_int,
    ) -> usize;
}
extern "C" {
    pub fn ZSTD_compressBegin_usingDict(
        cctx: *mut ZSTD_CCtx,
        dict: *const ::core::ffi::c_void,
        dictSize: usize,
        compressionLevel: ::core::ffi::c_int,
    ) -> usize;
}
extern "C" {
    pub fn ZSTD_compressBegin_usingCDict(
        cctx: *mut ZSTD_CCtx,
        cdict: *const ZSTD_CDict,
    ) -> usize;
}
extern "C" {
    pub fn ZSTD_copyCCtx(
        cctx: *mut ZSTD_CCtx,
        preparedCCtx: *const ZSTD_CCtx,
        pledgedSrcSize: ::core::ffi::c_ulonglong,
    ) -> usize;
}
extern "C" {
    pub fn ZSTD_compressContinue(
        cctx: *mut ZSTD_CCtx,
        dst: *mut ::core::ffi::c_void,
        dstCapacity: usize,
        src: *const ::core::ffi::c_void,
        srcSize: usize,
    ) -> usize;
}
extern "C" {
    pub fn ZSTD_compressEnd(
        cctx: *mut ZSTD_CCtx,
        dst: *mut ::core::ffi::c_void,
        dstCapacity: usize,
        src: *const ::core::ffi::c_void,
        srcSize: usize,
    ) -> usize;
}
extern "C" {
    pub fn ZSTD_compressBegin_advanced(
        cctx: *mut ZSTD_CCtx,
        dict: *const ::core::ffi::c_void,
        dictSize: usize,
        params: ZSTD_parameters,
        pledgedSrcSize: ::core::ffi::c_ulonglong,
    ) -> usize;
}
extern "C" {
    pub fn ZSTD_compressBegin_usingCDict_advanced(
        cctx: *mut ZSTD_CCtx,
        cdict: *const ZSTD_CDict,
        fParams: ZSTD_frameParameters,
        pledgedSrcSize: ::core::ffi::c_ulonglong,
    ) -> usize;
}
extern "C" {
    #[doc = "Buffer-less streaming decompression (synchronous mode)\n\nA ZSTD_DCtx object is required to track streaming operations.\nUse ZSTD_createDCtx() / ZSTD_freeDCtx() to manage it.\nA ZSTD_DCtx object can be reused multiple times.\n\nFirst typical operation is to retrieve frame parameters, using ZSTD_getFrameHeader().\nFrame header is extracted from the beginning of compressed frame, so providing only the frame's beginning is enough.\nData fragment must be large enough to ensure successful decoding.\n`ZSTD_frameHeaderSize_max` bytes is guaranteed to always be large enough.\nresult  : 0 : successful decoding, the `ZSTD_frameHeader` structure is correctly filled.\n>0 : `srcSize` is too small, please provide at least result bytes on next attempt.\nerrorCode, which can be tested using ZSTD_isError().\n\nIt fills a ZSTD_FrameHeader structure with important information to correctly decode the frame,\nsuch as the dictionary ID, content size, or maximum back-reference distance (`windowSize`).\nNote that these values could be wrong, either because of data corruption, or because a 3rd party deliberately spoofs false information.\nAs a consequence, check that values remain within valid application range.\nFor example, do not allocate memory blindly, check that `windowSize` is within expectation.\nEach application can set its own limits, depending on local restrictions.\nFor extended interoperability, it is recommended to support `windowSize` of at least 8 MB.\n\nZSTD_decompressContinue() needs previous data blocks during decompression, up to `windowSize` bytes.\nZSTD_decompressContinue() is very sensitive to contiguity,\nif 2 blocks don't follow each other, make sure that either the compressor breaks contiguity at the same place,\nor that previous contiguous segment is large enough to properly handle maximum back-reference distance.\nThere are multiple ways to guarantee this condition.\n\nThe most memory efficient way is to use a round buffer of sufficient size.\nSufficient size is determined by invoking ZSTD_decodingBufferSize_min(),\nwhich can return an error code if required value is too large for current system (in 32-bits mode).\nIn a round buffer methodology, ZSTD_decompressContinue() decompresses each block next to previous one,\nup to the moment there is not enough room left in the buffer to guarantee decoding another full block,\nwhich maximum size is provided in `ZSTD_frameHeader` structure, field `blockSizeMax`.\nAt which point, decoding can resume from the beginning of the buffer.\nNote that already decoded data stored in the buffer should be flushed before being overwritten.\n\nThere are alternatives possible, for example using two or more buffers of size `windowSize` each, though they consume more memory.\n\nFinally, if you control the compression process, you can also ignore all buffer size rules,\nas long as the encoder and decoder progress in \"lock-step\",\naka use exactly the same buffer sizes, break contiguity at the same place, etc.\n\nOnce buffers are setup, start decompression, with ZSTD_decompressBegin().\nIf decompression requires a dictionary, use ZSTD_decompressBegin_usingDict() or ZSTD_decompressBegin_usingDDict().\n\nThen use ZSTD_nextSrcSizeToDecompress() and ZSTD_decompressContinue() alternatively.\nZSTD_nextSrcSizeToDecompress() tells how many bytes to provide as 'srcSize' to ZSTD_decompressContinue().\nZSTD_decompressContinue() requires this _exact_ amount of bytes, or it will fail.\n\nresult of ZSTD_decompressContinue() is the number of bytes regenerated within 'dst' (necessarily <= dstCapacity).\nIt can be zero : it just means ZSTD_decompressContinue() has decoded some metadata item.\nIt can also be an error code, which can be tested with ZSTD_isError().\n\nA frame is fully decoded when ZSTD_nextSrcSizeToDecompress() returns zero.\nContext can then be reset to start a new decompression.\n\nNote : it's possible to know if next input to present is a header or a block, using ZSTD_nextInputType().\nThis information is not required to properly decode a frame.\n\n== Special case : skippable frames ==\n\nSkippable frames allow integration of user-defined data into a flow of concatenated frames.\nSkippable frames will be ignored (skipped) by decompressor.\nThe format of skippable frames is as follows :\na) Skippable frame ID - 4 Bytes, Little endian format, any value from 0x184D2A50 to 0x184D2A5F\nb) Frame Size - 4 Bytes, Little endian format, unsigned 32-bits\nc) Frame Content - any content (User Data) of length equal to Frame Size\nFor skippable frames ZSTD_getFrameHeader() returns zfhPtr->frameType==ZSTD_skippableFrame.\nFor skippable frames ZSTD_decompressContinue() always returns 0 : it only skips the content."]
    pub fn ZSTD_decodingBufferSize_min(
        windowSize: ::core::ffi::c_ulonglong,
        frameContentSize: ::core::ffi::c_ulonglong,
    ) -> usize;
}
extern "C" {
    pub fn ZSTD_decompressBegin(dctx: *mut ZSTD_DCtx) -> usize;
}
extern "C" {
    pub fn ZSTD_decompressBegin_usingDict(
        dctx: *mut ZSTD_DCtx,
        dict: *const ::core::ffi::c_void,
        dictSize: usize,
    ) -> usize;
}
extern "C" {
    pub fn ZSTD_decompressBegin_usingDDict(
        dctx: *mut ZSTD_DCtx,
        ddict: *const ZSTD_DDict,
    ) -> usize;
}
extern "C" {
    pub fn ZSTD_nextSrcSizeToDecompress(dctx: *mut ZSTD_DCtx) -> usize;
}
extern "C" {
    pub fn ZSTD_decompressContinue(
        dctx: *mut ZSTD_DCtx,
        dst: *mut ::core::ffi::c_void,
        dstCapacity: usize,
        src: *const ::core::ffi::c_void,
        srcSize: usize,
    ) -> usize;
}
extern "C" {
    pub fn ZSTD_copyDCtx(dctx: *mut ZSTD_DCtx, preparedDCtx: *const ZSTD_DCtx);
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum ZSTD_nextInputType_e {
    ZSTDnit_frameHeader = 0,
    ZSTDnit_blockHeader = 1,
    ZSTDnit_block = 2,
    ZSTDnit_lastBlock = 3,
    ZSTDnit_checksum = 4,
    ZSTDnit_skippableFrame = 5,
}
extern "C" {
    pub fn ZSTD_nextInputType(dctx: *mut ZSTD_DCtx) -> ZSTD_nextInputType_e;
}
extern "C" {
    #[doc = "This API is deprecated in favor of the regular compression API.\nYou can get the frame header down to 2 bytes by setting:\n- ZSTD_c_format = ZSTD_f_zstd1_magicless\n- ZSTD_c_contentSizeFlag = 0\n- ZSTD_c_checksumFlag = 0\n- ZSTD_c_dictIDFlag = 0\n\nThis API is not as well tested as our normal API, so we recommend not using it.\nWe will be removing it in a future version. If the normal API doesn't provide\nthe functionality you need, please open a GitHub issue.\n\nBlock functions produce and decode raw zstd blocks, without frame metadata.\nFrame metadata cost is typically ~12 bytes, which can be non-negligible for very small blocks (< 100 bytes).\nBut users will have to take in charge needed metadata to regenerate data, such as compressed and content sizes.\n\nA few rules to respect :\n- Compressing and decompressing require a context structure\n+ Use ZSTD_createCCtx() and ZSTD_createDCtx()\n- It is necessary to init context before starting\n+ compression : any ZSTD_compressBegin*() variant, including with dictionary\n+ decompression : any ZSTD_decompressBegin*() variant, including with dictionary\n- Block size is limited, it must be <= ZSTD_getBlockSize() <= ZSTD_BLOCKSIZE_MAX == 128 KB\n+ If input is larger than a block size, it's necessary to split input data into multiple blocks\n+ For inputs larger than a single block, consider using regular ZSTD_compress() instead.\nFrame metadata is not that costly, and quickly becomes negligible as source size grows larger than a block.\n- When a block is considered not compressible enough, ZSTD_compressBlock() result will be 0 (zero) !\n===> In which case, nothing is produced into `dst` !\n+ User __must__ test for such outcome and deal directly with uncompressed data\n+ A block cannot be declared incompressible if ZSTD_compressBlock() return value was != 0.\nDoing so would mess up with statistics history, leading to potential data corruption.\n+ ZSTD_decompressBlock() _doesn't accept uncompressed data as input_ !!\n+ In case of multiple successive blocks, should some of them be uncompressed,\ndecoder must be informed of their existence in order to follow proper history.\nUse ZSTD_insertBlock() for such a case."]
    pub fn ZSTD_getBlockSize(cctx: *const ZSTD_CCtx) -> usize;
}
extern "C" {
    pub fn ZSTD_compressBlock(
        cctx: *mut ZSTD_CCtx,
        dst: *mut ::core::ffi::c_void,
        dstCapacity: usize,
        src: *const ::core::ffi::c_void,
        srcSize: usize,
    ) -> usize;
}
extern "C" {
    pub fn ZSTD_decompressBlock(
        dctx: *mut ZSTD_DCtx,
        dst: *mut ::core::ffi::c_void,
        dstCapacity: usize,
        src: *const ::core::ffi::c_void,
        srcSize: usize,
    ) -> usize;
}
extern "C" {
    pub fn ZSTD_insertBlock(
        dctx: *mut ZSTD_DCtx,
        blockStart: *const ::core::ffi::c_void,
        blockSize: usize,
    ) -> usize;
}
