import datetime
from typing import ClassVar

from ..core import WesternCalendar

class Switzerland(WesternCalendar):
    include_berchtolds_day: ClassVar[bool]
    include_st_josephs_day: ClassVar[bool]
    def has_berchtolds_day(self, year: int) -> bool: ...
    def get_federal_thanksgiving_monday(self, year: int) -> tuple[datetime.date, str]: ...

class Aargau(Switzerland): ...
class AppenzellInnerrhoden(Switzerland): ...
class AppenzellAusserrhoden(Switzerland): ...
class Bern(Switzerland): ...
class BaselLandschaft(Switzerland): ...
class BaselStadt(Switzerland): ...
class Fribourg(Switzerland): ...

class Geneva(Switzerland):
    def get_genevan_fast(self, year: int) -> tuple[datetime.date, str]: ...

class Glarus(Switzerland): ...
class Graubunden(Switzerland): ...
class Jura(Switzerland): ...
class Luzern(Switzerland): ...
class Neuchatel(Switzerland): ...
class Nidwalden(Switzerland): ...
class Obwalden(Switzerland): ...
class StGallen(Switzerland): ...
class Schaffhausen(Switzerland): ...
class Solothurn(Switzerland): ...
class Schwyz(Switzerland): ...
class Thurgau(Switzerland): ...
class Ticino(Switzerland): ...
class Uri(Switzerland): ...
class Vaud(Switzerland): ...
class Valais(Switzerland): ...
class Zug(Switzerland): ...
class Zurich(Switzerland): ...
