import re
from typing import ClassVar, Final

from docutils import nodes
from docutils.transforms import Transform

__docformat__: Final = "reStructuredText"

class TitlePromoter(Transform):
    def promote_title(self, node: nodes.Element) -> bool: ...
    def promote_subtitle(self, node: nodes.Element) -> bool: ...
    def candidate_index(self, node: nodes.Element) -> tuple[nodes.Node, int] | tuple[None, None]: ...

class DocTitle(TitlePromoter):
    default_priority: ClassVar[int]
    def set_metadata(self) -> None: ...
    def apply(self) -> None: ...

class SectionSubTitle(TitlePromoter):
    default_priority: ClassVar[int]
    def apply(self) -> None: ...

class DocInfo(Transform):
    default_priority: ClassVar[int]
    biblio_nodes: ClassVar[dict[str, type[nodes.Element]]]
    rcs_keyword_substitutions: ClassVar[list[tuple[re.Pattern[str], str]]]
    def apply(self) -> None: ...
    def extract_bibliographic(self, field_list): ...
    def check_empty_biblio_field(self, field, name) -> bool: ...
    def check_compound_biblio_field(self, field, name) -> bool: ...
    def extract_authors(self, field, name, docinfo) -> None: ...
    def authors_from_one_paragraph(self, field) -> list[list[nodes.Text]]: ...
    def authors_from_bullet_list(self, field): ...
    def authors_from_paragraphs(self, field): ...
