
####### Expanded from @PACKAGE_INIT@ by configure_package_config_file() #######
####### Any changes to this file will be overwritten by the next CMake run ####
####### The input file was rabbitmq-c-config.cmake.in                            ########

get_filename_component(PACKAGE_PREFIX_DIR "${CMAKE_CURRENT_LIST_DIR}/../../../" ABSOLUTE)

macro(set_and_check _var _file)
  set(${_var} "${_file}")
  if(NOT EXISTS "${_file}")
    message(FATAL_ERROR "File or directory ${_file} referenced by variable ${_var} does not exist !")
  endif()
endmacro()

macro(check_required_components _NAME)
  foreach(comp ${${_NAME}_FIND_COMPONENTS})
    if(NOT ${_NAME}_${comp}_FOUND)
      if(${_NAME}_FIND_REQUIRED_${comp})
        set(${_NAME}_FOUND FALSE)
      endif()
    endif()
  endforeach()
endmacro()

####################################################################################

set(RMQ_USES_OPENSSL ON)

include(CMakeFindDependencyMacro)

if (RMQ_USES_OPENSSL)
  find_dependency(OpenSSL REQUIRED)
  if(OPENSSL_VERSION)
    if(OPENSSL_VERSION VERSION_LESS RMQ_OPENSSL_MIN_VERSION)
      MESSAGE(FATAL_ERROR "Found OpenSSL version 3.5.0 but 1.1.1 or later is required")
    endif()
  endif()
endif ()

include(${CMAKE_CURRENT_LIST_DIR}/rabbitmq-targets.cmake)
check_required_components(rabbitmq-c)
