#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscobjectlistremovereference_ PETSCOBJECTLISTREMOVEREFERENCE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscobjectlistremovereference_ petscobjectlistremovereference
#endif
PETSC_EXTERN void petscobjectlistremovereference_(PetscObjectList *a, char b[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  PetscBool null_a = !*(void**) a ? PETSC_TRUE : PETSC_FALSE;
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  CHKFORTRANNULLOBJECT(a);
  *ierr = PetscObjectListRemoveReference(a, c_b);
  if (*ierr) return;
  FREECHAR(b, c_b);
  if (! null_a && !*(void**) a) *(void **) a = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscobjectlistadd_ PETSCOBJECTLISTADD
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscobjectlistadd_ petscobjectlistadd
#endif
PETSC_EXTERN void petscobjectlistadd_(PetscObjectList *a, char b[], PetscObject *c, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  PetscBool null_a = !*(void**) a ? PETSC_TRUE : PETSC_FALSE;
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  CHKFORTRANNULLOBJECT(a);
  *ierr = PetscObjectListAdd(a, c_b, *c);
  if (*ierr) return;
  FREECHAR(b, c_b);
  if (! null_a && !*(void**) a) *(void **) a = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscobjectlistdestroy_ PETSCOBJECTLISTDESTROY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscobjectlistdestroy_ petscobjectlistdestroy
#endif
PETSC_EXTERN void petscobjectlistdestroy_(PetscObjectList *a, PetscErrorCode *ierr)
{
  PETSC_FORTRAN_OBJECT_F_DESTROYED_TO_C_NULL(a);
  PetscBool null_a = !*(void**) a ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(a);
  *ierr = PetscObjectListDestroy(a);
  if (*ierr) return;
  if (! null_a && !*(void**) a) *(void **) a = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscobjectlistfind_ PETSCOBJECTLISTFIND
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscobjectlistfind_ petscobjectlistfind
#endif
PETSC_EXTERN void petscobjectlistfind_(PetscObjectList *a, char b[], PetscObject *c, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  CHKFORTRANNULLOBJECT(c);
  *ierr = PetscObjectListFind(*a, c_b, c);
  if (*ierr) return;
  FREECHAR(b, c_b);
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscobjectlistreversefind_ PETSCOBJECTLISTREVERSEFIND
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscobjectlistreversefind_ petscobjectlistreversefind
#endif
PETSC_EXTERN void petscobjectlistreversefind_(PetscObjectList *a, PetscObject *b, char c[], PetscBool *d, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_c)
{
  char* c_c = PETSC_NULLPTR;
  CHKFORTRANNULLBOOL(d);
  *ierr = PetscObjectListReverseFind(*a, *b, (const char **)&c_c, d);
  if (*ierr) return;
  *ierr = PetscStrncpy((char *)c, c_c, l_c);
  if (*ierr) return;
  FIXRETURNCHAR(PETSC_TRUE, c, l_c);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscobjectlistduplicate_ PETSCOBJECTLISTDUPLICATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscobjectlistduplicate_ petscobjectlistduplicate
#endif
PETSC_EXTERN void petscobjectlistduplicate_(PetscObjectList *a, PetscObjectList *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = PetscObjectListDuplicate(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
