#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscgoogledriverefresh_ PETSCGOOGLEDRIVEREFRESH
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscgoogledriverefresh_ petscgoogledriverefresh
#endif
PETSC_EXTERN void petscgoogledriverefresh_(MPI_Fint *a, char b[], char c[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b, PETSC_FORTRAN_CHARLEN_T l_c)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  *ierr = PetscGoogleDriveRefresh(MPI_Comm_f2c(*(a)), c_b, c, l_c);
  if (*ierr) return;
  FREECHAR(b, c_b);
  FIXRETURNCHAR(PETSC_TRUE, c, l_c);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscgoogledriveupload_ PETSCGOOGLEDRIVEUPLOAD
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscgoogledriveupload_ petscgoogledriveupload
#endif
PETSC_EXTERN void petscgoogledriveupload_(MPI_Fint *a, char b[], char c[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b, PETSC_FORTRAN_CHARLEN_T l_c)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  char* c_c;
  FIXCHAR(c, l_c, c_c);
  *ierr = PetscGoogleDriveUpload(MPI_Comm_f2c(*(a)), c_b, c_c);
  if (*ierr) return;
  FREECHAR(b, c_b);
  FREECHAR(c, c_c);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscgoogledriveauthorize_ PETSCGOOGLEDRIVEAUTHORIZE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscgoogledriveauthorize_ petscgoogledriveauthorize
#endif
PETSC_EXTERN void petscgoogledriveauthorize_(MPI_Fint *a, char b[], char c[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b, PETSC_FORTRAN_CHARLEN_T l_c)
{
  *ierr = PetscGoogleDriveAuthorize(MPI_Comm_f2c(*(a)), b, c, l_c);
  if (*ierr) return;
  FIXRETURNCHAR(PETSC_TRUE, b, l_b);
  FIXRETURNCHAR(PETSC_TRUE, c, l_c);
}
