#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscviewer.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscviewermatlabputarray_ PETSCVIEWERMATLABPUTARRAY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscviewermatlabputarray_ petscviewermatlabputarray
#endif
PETSC_EXTERN void petscviewermatlabputarray_(PetscViewer *a, int *b, int *c, const PetscScalar *d, char e[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_e)
{
  char* c_e;
  FIXCHAR(e, l_e, c_e);
  PetscViewer v_a = PetscPatchDefaultViewers(a);
  CHKFORTRANNULLSCALAR(d);
  *ierr = PetscViewerMatlabPutArray(v_a, *b, *c, d, c_e);
  if (*ierr) return;
  FREECHAR(e, c_e);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscviewer.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscviewermatlabputvariable_ PETSCVIEWERMATLABPUTVARIABLE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscviewermatlabputvariable_ petscviewermatlabputvariable
#endif
PETSC_EXTERN void petscviewermatlabputvariable_(PetscViewer *a, char b[], void *c, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  PetscViewer v_a = PetscPatchDefaultViewers(a);
  *ierr = PetscViewerMatlabPutVariable(v_a, c_b, c);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscviewer.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscviewermatlabgetarray_ PETSCVIEWERMATLABGETARRAY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscviewermatlabgetarray_ petscviewermatlabgetarray
#endif
PETSC_EXTERN void petscviewermatlabgetarray_(PetscViewer *a, int *b, int *c, PetscScalar d[], char e[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_e)
{
  char* c_e;
  FIXCHAR(e, l_e, c_e);
  PetscViewer v_a = PetscPatchDefaultViewers(a);
  CHKFORTRANNULLSCALAR(d);
  *ierr = PetscViewerMatlabGetArray(v_a, *b, *c, d, c_e);
  if (*ierr) return;
  FREECHAR(e, c_e);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscviewer.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscviewermatlabopen_ PETSCVIEWERMATLABOPEN
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscviewermatlabopen_ petscviewermatlabopen
#endif
PETSC_EXTERN void petscviewermatlabopen_(MPI_Fint *a, char b[], PetscFileMode *c, PetscViewer *d, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  PetscBool null_d = !*(void**) d ? PETSC_TRUE : PETSC_FALSE;
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  CHKFORTRANNULLOBJECT(d);
  *ierr = PetscViewerMatlabOpen(MPI_Comm_f2c(*(a)), c_b, *c, d);
  if (*ierr) return;
  FREECHAR(b, c_b);
  if (! null_d && !*(void**) d) *(void **) d = (void *)-2;
}
