#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscviewer.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscviewerglvissetprecision_ PETSCVIEWERGLVISSETPRECISION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscviewerglvissetprecision_ petscviewerglvissetprecision
#endif
PETSC_EXTERN void petscviewerglvissetprecision_(PetscViewer *a, PetscInt *b, PetscErrorCode *ierr)
{
  PetscViewer v_a = PetscPatchDefaultViewers(a);
  *ierr = PetscViewerGLVisSetPrecision(v_a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscviewer.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscviewerglvissetsnapid_ PETSCVIEWERGLVISSETSNAPID
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscviewerglvissetsnapid_ petscviewerglvissetsnapid
#endif
PETSC_EXTERN void petscviewerglvissetsnapid_(PetscViewer *a, PetscInt *b, PetscErrorCode *ierr)
{
  PetscViewer v_a = PetscPatchDefaultViewers(a);
  *ierr = PetscViewerGLVisSetSnapId(v_a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscviewer.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscviewerglvisopen_ PETSCVIEWERGLVISOPEN
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscviewerglvisopen_ petscviewerglvisopen
#endif
PETSC_EXTERN void petscviewerglvisopen_(MPI_Fint *a, PetscViewerGLVisType *b, char c[], PetscInt *d, PetscViewer *e, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_c)
{
  PetscBool null_e = !*(void**) e ? PETSC_TRUE : PETSC_FALSE;
  char* c_c;
  FIXCHAR(c, l_c, c_c);
  CHKFORTRANNULLOBJECT(e);
  *ierr = PetscViewerGLVisOpen(MPI_Comm_f2c(*(a)), *b, c_c, *d, e);
  if (*ierr) return;
  FREECHAR(c, c_c);
  if (! null_e && !*(void**) e) *(void **) e = (void *)-2;
}
