#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsrhssplitsetis_ TSRHSSPLITSETIS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsrhssplitsetis_ tsrhssplitsetis
#endif
PETSC_EXTERN void tsrhssplitsetis_(TS *a, char b[], IS *c, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  *ierr = TSRHSSplitSetIS(*a, c_b, *c);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsrhssplitgetis_ TSRHSSPLITGETIS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsrhssplitgetis_ tsrhssplitgetis
#endif
PETSC_EXTERN void tsrhssplitgetis_(TS *a, char b[], IS *c, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  CHKFORTRANNULLOBJECT(c);
  *ierr = TSRHSSplitGetIS(*a, c_b, c);
  if (*ierr) return;
  FREECHAR(b, c_b);
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsrhssplitgetsubts_ TSRHSSPLITGETSUBTS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsrhssplitgetsubts_ tsrhssplitgetsubts
#endif
PETSC_EXTERN void tsrhssplitgetsubts_(TS *a, char b[], TS *c, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  CHKFORTRANNULLOBJECT(c);
  *ierr = TSRHSSplitGetSubTS(*a, c_b, c);
  if (*ierr) return;
  FREECHAR(b, c_b);
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsrhssplitgetsnes_ TSRHSSPLITGETSNES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsrhssplitgetsnes_ tsrhssplitgetsnes
#endif
PETSC_EXTERN void tsrhssplitgetsnes_(TS *a, SNES *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = TSRHSSplitGetSNES(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsrhssplitsetsnes_ TSRHSSPLITSETSNES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsrhssplitsetsnes_ tsrhssplitsetsnes
#endif
PETSC_EXTERN void tsrhssplitsetsnes_(TS *a, SNES *b, PetscErrorCode *ierr)
{
  *ierr = TSRHSSplitSetSNES(*a, *b);
  if (*ierr) return;
}
