#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscviewer.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscviewersocketopen_ PETSCVIEWERSOCKETOPEN
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscviewersocketopen_ petscviewersocketopen
#endif
PETSC_EXTERN void petscviewersocketopen_(MPI_Fint *a, char b[], int *c, PetscViewer *d, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  PetscBool null_d = !*(void**) d ? PETSC_TRUE : PETSC_FALSE;
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  CHKFORTRANNULLOBJECT(d);
  *ierr = PetscViewerSocketOpen(MPI_Comm_f2c(*(a)), c_b, *c, d);
  if (*ierr) return;
  FREECHAR(b, c_b);
  if (! null_d && !*(void**) d) *(void **) d = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscviewer.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscviewersocketsetconnection_ PETSCVIEWERSOCKETSETCONNECTION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscviewersocketsetconnection_ petscviewersocketsetconnection
#endif
PETSC_EXTERN void petscviewersocketsetconnection_(PetscViewer *a, char b[], int *c, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  PetscViewer v_a = PetscPatchDefaultViewers(a);
  *ierr = PetscViewerSocketSetConnection(v_a, c_b, *c);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscopensocket_ PETSCOPENSOCKET
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscopensocket_ petscopensocket
#endif
PETSC_EXTERN void petscopensocket_(char a[], int *b, int *c, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_a)
{
  char* c_a;
  FIXCHAR(a, l_a, c_a);
  *ierr = PetscOpenSocket(c_a, *b, c);
  if (*ierr) return;
  FREECHAR(a, c_a);
}
