#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexsetisoperiodicfacesf_ DMPLEXSETISOPERIODICFACESF
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexsetisoperiodicfacesf_ dmplexsetisoperiodicfacesf
#endif
PETSC_EXTERN void dmplexsetisoperiodicfacesf_(DM *a, PetscInt *b, PetscSF *c, PetscErrorCode *ierr)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(c);
  *ierr = DMPlexSetIsoperiodicFaceSF(*a, *b, c);
  if (*ierr) return;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexsetisoperiodicfacetransform_ DMPLEXSETISOPERIODICFACETRANSFORM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexsetisoperiodicfacetransform_ dmplexsetisoperiodicfacetransform
#endif
PETSC_EXTERN void dmplexsetisoperiodicfacetransform_(DM *a, PetscInt *b, const PetscScalar c[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLSCALAR(c);
  *ierr = DMPlexSetIsoperiodicFaceTransform(*a, *b, c);
  if (*ierr) return;
}
