#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscshmcommget_ PETSCSHMCOMMGET
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscshmcommget_ petscshmcommget
#endif
PETSC_EXTERN void petscshmcommget_(MPI_Fint *a, PetscShmComm *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = PetscShmCommGet(MPI_Comm_f2c(*(a)), b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscshmcommglobaltolocal_ PETSCSHMCOMMGLOBALTOLOCAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscshmcommglobaltolocal_ petscshmcommglobaltolocal
#endif
PETSC_EXTERN void petscshmcommglobaltolocal_(PetscShmComm *a, PetscMPIInt *b, PetscMPIInt *c, PetscErrorCode *ierr)
{
  *ierr = PetscShmCommGlobalToLocal(*a, *b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscshmcommlocaltoglobal_ PETSCSHMCOMMLOCALTOGLOBAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscshmcommlocaltoglobal_ petscshmcommlocaltoglobal
#endif
PETSC_EXTERN void petscshmcommlocaltoglobal_(PetscShmComm *a, PetscMPIInt *b, PetscMPIInt *c, PetscErrorCode *ierr)
{
  *ierr = PetscShmCommLocalToGlobal(*a, *b, c);
  if (*ierr) return;
}
