#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matkaijgetaij_ MATKAIJGETAIJ
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matkaijgetaij_ matkaijgetaij
#endif
PETSC_EXTERN void matkaijgetaij_(Mat *a, Mat *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = MatKAIJGetAIJ(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matkaijsetaij_ MATKAIJSETAIJ
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matkaijsetaij_ matkaijsetaij
#endif
PETSC_EXTERN void matkaijsetaij_(Mat *a, Mat *b, PetscErrorCode *ierr)
{
  *ierr = MatKAIJSetAIJ(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matkaijsets_ MATKAIJSETS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matkaijsets_ matkaijsets
#endif
PETSC_EXTERN void matkaijsets_(Mat *a, PetscInt *b, PetscInt *c, const PetscScalar d[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLSCALAR(d);
  *ierr = MatKAIJSetS(*a, *b, *c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matkaijgetscaledidentity_ MATKAIJGETSCALEDIDENTITY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matkaijgetscaledidentity_ matkaijgetscaledidentity
#endif
PETSC_EXTERN void matkaijgetscaledidentity_(Mat *a, PetscBool *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(b);
  *ierr = MatKAIJGetScaledIdentity(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matkaijsett_ MATKAIJSETT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matkaijsett_ matkaijsett
#endif
PETSC_EXTERN void matkaijsett_(Mat *a, PetscInt *b, PetscInt *c, const PetscScalar d[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLSCALAR(d);
  *ierr = MatKAIJSetT(*a, *b, *c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matcreatekaij_ MATCREATEKAIJ
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matcreatekaij_ matcreatekaij
#endif
PETSC_EXTERN void matcreatekaij_(Mat *a, PetscInt *b, PetscInt *c, const PetscScalar d[], const PetscScalar e[], Mat *f, PetscErrorCode *ierr)
{
  PetscBool null_f = !*(void**) f ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLSCALAR(d);
  CHKFORTRANNULLSCALAR(e);
  CHKFORTRANNULLOBJECT(f);
  *ierr = MatCreateKAIJ(*a, *b, *c, d, e, f);
  if (*ierr) return;
  if (! null_f && !*(void**) f) *(void **) f = (void *)-2;
}
