window.search = Object.assign(window.search, JSON.parse('{"doc_urls":["title-page.html#helix","install.html#installing-helix","install.html#pre-built-binaries","package-managers.html#package-managers","package-managers.html#linux","package-managers.html#ubuntudebian","package-managers.html#ubuntu-ppa","package-managers.html#fedorarhel","package-managers.html#arch-linux-extra","package-managers.html#nixos","package-managers.html#flatpak","package-managers.html#snap","package-managers.html#appimage","package-managers.html#macos","package-managers.html#homebrew-core","package-managers.html#macports","package-managers.html#windows","package-managers.html#winget","package-managers.html#scoop","package-managers.html#chocolatey","package-managers.html#msys2","building-from-source.html#building-from-source","building-from-source.html#configuring-helixs-runtime-files","building-from-source.html#validating-the-installation","building-from-source.html#configure-the-desktop-shortcut","building-from-source.html#building-the-debian-package","usage.html#using-helix","usage.html#modes","usage.html#buffers","usage.html#selection-first-editing","usage.html#multiple-selections","usage.html#motions","registers.html#registers","registers.html#user-defined-registers","registers.html#default-registers","registers.html#special-registers","surround.html#surround","textobjects.html#selecting-and-manipulating-text-with-textobjects","textobjects.html#navigating-using-tree-sitter-textobjects","syntax-aware-motions.html#moving-the-selection-with-syntax-aware-motions","pickers.html#using-pickers","pickers.html#filtering-picker-results","keymap.html#keymap","keymap.html#normal-mode","keymap.html#movement","keymap.html#changes","keymap.html#selection-manipulation","keymap.html#search","keymap.html#minor-modes","keymap.html#insert-mode","keymap.html#select--extend-mode","keymap.html#picker","keymap.html#prompt","command-line.html#command-line","command-line.html#quoting","command-line.html#flags","command-line.html#expansions","command-line.html#exceptions","commands.html#commands","commands.html#typable-commands","commands.html#static-commands","lang-support.html#language-support","ecosystem.html#ecosystem","from-vim.html#migrating-from-vim","other-software.html#helix-mode-in-other-software","other-software.html#other-editors","other-software.html#shells","other-software.html#other-software","configuration.html#configuration","editor.html#editor","editor.html#editor-section","editor.html#editorclipboard-provider-section","editor.html#editorstatusline-section","editor.html#editorlsp-section","editor.html#editorcursor-shape-section","editor.html#editorfile-picker-section","editor.html#editorauto-pairs-section","editor.html#editorauto-save-section","editor.html#editorsearch-section","editor.html#editorwhitespace-section","editor.html#editorindent-guides-section","editor.html#editorgutters-section","editor.html#editorsoft-wrap-section","editor.html#editorsmart-tab-section","editor.html#editorinline-diagnostics-section","themes.html#themes","themes.html#creating-a-theme","themes.html#overview","themes.html#the-details-of-theme-creation","themes.html#color-palettes","themes.html#modifiers","themes.html#underline-style","themes.html#inheritance","themes.html#scopes","remapping.html#key-remapping","remapping.html#minor-modes","remapping.html#special-keys-and-modifiers","languages.html#languages","languages.html#languagestoml-files","languages.html#language-configuration","languages.html#file-type-detection-and-the-file-types-key","languages.html#configuring-the-formatter-command","languages.html#language-server-configuration","languages.html#configuring-language-servers-for-a-language","languages.html#tree-sitter-grammar-configuration","languages.html#choosing-grammars","guides/index.html#guides","guides/adding_languages.html#adding-new-languages-to-helix","guides/adding_languages.html#language-configuration","guides/adding_languages.html#grammar-configuration","guides/adding_languages.html#queries","guides/adding_languages.html#common-issues","guides/textobject.html#adding-textobject-queries","guides/textobject.html#queries-for-textobject-based-navigation","guides/indent.html#adding-indent-queries","guides/indent.html#indent-queries","guides/indent.html#capture-types","guides/indent.html#predicates","guides/indent.html#scopes","guides/injection.html#adding-injection-queries","guides/injection.html#capture-types","guides/injection.html#settings","guides/injection.html#predicates"],"index":{"documentStore":{"docInfo":{"0":{"body":38,"breadcrumbs":2,"title":1},"1":{"body":30,"breadcrumbs":3,"title":2},"10":{"body":10,"breadcrumbs":4,"title":1},"100":{"body":140,"breadcrumbs":8,"title":6},"101":{"body":22,"breadcrumbs":5,"title":3},"102":{"body":149,"breadcrumbs":5,"title":3},"103":{"body":214,"breadcrumbs":6,"title":4},"104":{"body":90,"breadcrumbs":6,"title":4},"105":{"body":38,"breadcrumbs":4,"title":2},"106":{"body":15,"breadcrumbs":2,"title":1},"107":{"body":9,"breadcrumbs":7,"title":4},"108":{"body":60,"breadcrumbs":5,"title":2},"109":{"body":30,"breadcrumbs":5,"title":2},"11":{"body":17,"breadcrumbs":4,"title":1},"110":{"body":30,"breadcrumbs":4,"title":1},"111":{"body":53,"breadcrumbs":5,"title":2},"112":{"body":87,"breadcrumbs":7,"title":3},"113":{"body":35,"breadcrumbs":8,"title":4},"114":{"body":116,"breadcrumbs":7,"title":3},"115":{"body":127,"breadcrumbs":6,"title":2},"116":{"body":549,"breadcrumbs":6,"title":2},"117":{"body":114,"breadcrumbs":5,"title":1},"118":{"body":115,"breadcrumbs":5,"title":1},"119":{"body":56,"breadcrumbs":7,"title":3},"12":{"body":46,"breadcrumbs":4,"title":1},"120":{"body":64,"breadcrumbs":6,"title":2},"121":{"body":50,"breadcrumbs":5,"title":1},"122":{"body":28,"breadcrumbs":5,"title":1},"13":{"body":0,"breadcrumbs":4,"title":1},"14":{"body":3,"breadcrumbs":5,"title":2},"15":{"body":4,"breadcrumbs":4,"title":1},"16":{"body":7,"breadcrumbs":4,"title":1},"17":{"body":33,"breadcrumbs":4,"title":1},"18":{"body":3,"breadcrumbs":4,"title":1},"19":{"body":3,"breadcrumbs":4,"title":1},"2":{"body":55,"breadcrumbs":4,"title":3},"20":{"body":12,"breadcrumbs":4,"title":1},"21":{"body":154,"breadcrumbs":5,"title":2},"22":{"body":216,"breadcrumbs":7,"title":4},"23":{"body":20,"breadcrumbs":5,"title":2},"24":{"body":68,"breadcrumbs":6,"title":3},"25":{"body":118,"breadcrumbs":6,"title":3},"26":{"body":21,"breadcrumbs":3,"title":2},"27":{"body":38,"breadcrumbs":2,"title":1},"28":{"body":19,"breadcrumbs":2,"title":1},"29":{"body":30,"breadcrumbs":4,"title":3},"3":{"body":23,"breadcrumbs":5,"title":2},"30":{"body":29,"breadcrumbs":3,"title":2},"31":{"body":26,"breadcrumbs":2,"title":1},"32":{"body":33,"breadcrumbs":3,"title":1},"33":{"body":48,"breadcrumbs":5,"title":3},"34":{"body":27,"breadcrumbs":4,"title":2},"35":{"body":72,"breadcrumbs":4,"title":2},"36":{"body":71,"breadcrumbs":3,"title":1},"37":{"body":102,"breadcrumbs":6,"title":4},"38":{"body":46,"breadcrumbs":7,"title":5},"39":{"body":145,"breadcrumbs":9,"title":5},"4":{"body":5,"breadcrumbs":4,"title":1},"40":{"body":26,"breadcrumbs":4,"title":2},"41":{"body":119,"breadcrumbs":5,"title":3},"42":{"body":71,"breadcrumbs":3,"title":1},"43":{"body":11,"breadcrumbs":4,"title":2},"44":{"body":165,"breadcrumbs":3,"title":1},"45":{"body":226,"breadcrumbs":3,"title":1},"46":{"body":265,"breadcrumbs":4,"title":2},"47":{"body":51,"breadcrumbs":3,"title":1},"48":{"body":894,"breadcrumbs":4,"title":2},"49":{"body":194,"breadcrumbs":4,"title":2},"5":{"body":19,"breadcrumbs":4,"title":1},"50":{"body":59,"breadcrumbs":5,"title":3},"51":{"body":82,"breadcrumbs":3,"title":1},"52":{"body":136,"breadcrumbs":3,"title":1},"53":{"body":53,"breadcrumbs":5,"title":2},"54":{"body":123,"breadcrumbs":4,"title":1},"55":{"body":44,"breadcrumbs":4,"title":1},"56":{"body":347,"breadcrumbs":4,"title":1},"57":{"body":224,"breadcrumbs":4,"title":1},"58":{"body":4,"breadcrumbs":3,"title":1},"59":{"body":847,"breadcrumbs":4,"title":2},"6":{"body":16,"breadcrumbs":5,"title":2},"60":{"body":2665,"breadcrumbs":4,"title":2},"61":{"body":659,"breadcrumbs":5,"title":2},"62":{"body":6,"breadcrumbs":2,"title":1},"63":{"body":53,"breadcrumbs":5,"title":2},"64":{"body":51,"breadcrumbs":7,"title":3},"65":{"body":62,"breadcrumbs":5,"title":1},"66":{"body":21,"breadcrumbs":5,"title":1},"67":{"body":15,"breadcrumbs":5,"title":1},"68":{"body":102,"breadcrumbs":2,"title":1},"69":{"body":48,"breadcrumbs":3,"title":1},"7":{"body":4,"breadcrumbs":4,"title":1},"70":{"body":537,"breadcrumbs":4,"title":2},"71":{"body":63,"breadcrumbs":5,"title":3},"72":{"body":292,"breadcrumbs":4,"title":2},"73":{"body":145,"breadcrumbs":4,"title":2},"74":{"body":41,"breadcrumbs":5,"title":3},"75":{"body":151,"breadcrumbs":5,"title":3},"76":{"body":62,"breadcrumbs":5,"title":3},"77":{"body":45,"breadcrumbs":5,"title":3},"78":{"body":30,"breadcrumbs":4,"title":2},"79":{"body":73,"breadcrumbs":4,"title":2},"8":{"body":30,"breadcrumbs":6,"title":3},"80":{"body":40,"breadcrumbs":5,"title":3},"81":{"body":121,"breadcrumbs":4,"title":2},"82":{"body":84,"breadcrumbs":5,"title":3},"83":{"body":136,"breadcrumbs":5,"title":3},"84":{"body":165,"breadcrumbs":5,"title":3},"85":{"body":14,"breadcrumbs":3,"title":1},"86":{"body":28,"breadcrumbs":4,"title":2},"87":{"body":68,"breadcrumbs":3,"title":1},"88":{"body":0,"breadcrumbs":5,"title":3},"89":{"body":83,"breadcrumbs":4,"title":2},"9":{"body":64,"breadcrumbs":4,"title":1},"90":{"body":28,"breadcrumbs":3,"title":1},"91":{"body":16,"breadcrumbs":4,"title":2},"92":{"body":21,"breadcrumbs":3,"title":1},"93":{"body":697,"breadcrumbs":3,"title":1},"94":{"body":251,"breadcrumbs":5,"title":2},"95":{"body":66,"breadcrumbs":5,"title":2},"96":{"body":125,"breadcrumbs":6,"title":3},"97":{"body":9,"breadcrumbs":3,"title":1},"98":{"body":63,"breadcrumbs":4,"title":2},"99":{"body":342,"breadcrumbs":4,"title":2}},"docs":{"0":{"body":"Docs for bleeding edge master can be found at https://docs.helix-editor.com/master . See the usage section for a quick overview of the editor, keymap section for all available keybindings and the configuration section for defining custom keybindings, setting themes, etc. For everything else (e.g., how to install supported language servers), see the Helix Wiki . Refer the FAQ for common questions.","breadcrumbs":"Helix » Helix","id":"0","title":"Helix"},"1":{"body":"The typical way to install Helix is via your operating system\'s package manager . Note that: To get the latest nightly version of Helix, you need to build from source . To take full advantage of Helix, install the language servers for your preferred programming languages. See the wiki for instructions.","breadcrumbs":"Installation » Installing Helix","id":"1","title":"Installing Helix"},"10":{"body":"Helix is available on Flathub : flatpak install flathub com.helix_editor.Helix\\nflatpak run com.helix_editor.Helix","breadcrumbs":"Installation » Package Managers » Flatpak","id":"10","title":"Flatpak"},"100":{"body":"Helix determines which language configuration to use based on the file-types key from the above section. file-types is a list of strings or tables, for example: file-types = [\\"toml\\", { glob = \\"Makefile\\" }, { glob = \\".git/config\\" }, { glob = \\".github/workflows/*.yaml\\" } ] When determining a language configuration to use, Helix searches the file-types with the following priorities: Glob: values in glob tables are checked against the full path of the given file. Globs are standard Unix-style path globs (e.g. the kind you use in Shell) and can be used to match paths for a specific prefix, suffix, directory, etc. In the above example, the { glob = \\"Makefile\\" } config would match files with the name Makefile, the { glob = \\".git/config\\" } config would match config files in .git directories, and the { glob = \\".github/workflows/*.yaml\\" } config would match any yaml files in .github/workflow directories. Note that globs should always use the Unix path separator / even on Windows systems; the matcher will automatically take the machine-specific separators into account. If the glob isn\'t an absolute path or doesn\'t already start with a glob prefix, */ will automatically be added to ensure it matches for any subdirectory. Extension: if there are no glob matches, any file-types string that matches the file extension of a given file wins. In the example above, the \\"toml\\" config matches files like Cargo.toml or languages.toml.","breadcrumbs":"Configuration » Languages » File-type detection and the file-types key","id":"100","title":"File-type detection and the file-types key"},"101":{"body":"Command line expansions are supported in the arguments of the formatter command. In particular, the %{buffer_name} variable can be passed as argument to the formatter: formatter = { command = \\"mylang-formatter\\" , args = [\\"--stdin\\", \\"--stdin-filename %{buffer_name}\\"] }","breadcrumbs":"Configuration » Languages » Configuring the formatter command","id":"101","title":"Configuring the formatter command"},"102":{"body":"Language servers are configured separately in the table language-server in the same file as the languages languages.toml For example: [language-server.mylang-lsp]\\ncommand = \\"mylang-lsp\\"\\nargs = [\\"--stdio\\"]\\nconfig = { provideFormatter = true }\\nenvironment = { \\"ENV1\\" = \\"value1\\", \\"ENV2\\" = \\"value2\\" } [language-server.efm-lsp-prettier]\\ncommand = \\"efm-langserver\\" [language-server.efm-lsp-prettier.config]\\ndocumentFormatting = true\\nlanguages = { typescript = [ { formatCommand =\\"prettier --stdin-filepath ${INPUT}\\", formatStdin = true } ] } These are the available options for a language server. Key Description command The name or path of the language server binary to execute. Binaries must be in $PATH args A list of arguments to pass to the language server binary config Language server initialization options timeout The maximum time a request to the language server may take, in seconds. Defaults to 20 environment Any environment variables that will be used when starting the language server { \\"KEY1\\" = \\"Value1\\", \\"KEY2\\" = \\"Value2\\" } required-root-patterns A list of glob patterns to look for in the working directory. The language server is started if at least one of them is found. A format sub-table within config can be used to pass extra formatting options to Document Formatting Requests . For example, with typescript: [language-server.typescript-language-server]\\n# pass format options according to https://github.com/typescript-language-server/typescript-language-server#workspacedidchangeconfiguration omitting the \\"[language].format.\\" prefix.\\nconfig = { format = { \\"semicolons\\" = \\"insert\\", \\"insertSpaceBeforeFunctionParenthesis\\" = true } }","breadcrumbs":"Configuration » Languages » Language Server configuration","id":"102","title":"Language Server configuration"},"103":{"body":"The language-servers attribute in a language tells helix which language servers are used for this language. They have to be defined in the [language-server] table as described in the previous section. Different languages can use the same language server instance, e.g. typescript-language-server is used for javascript, jsx, tsx and typescript by default. The definition order of language servers affects the order in the results list of code action menu. In case multiple language servers are specified in the language-servers attribute of a language, it\'s often useful to only enable/disable certain language-server features for these language servers. As an example, efm-lsp-prettier of the previous example is used only with a formatting command prettier, so everything else should be handled by the typescript-language-server (which is configured by default). The language configuration for typescript could look like this: [[language]]\\nname = \\"typescript\\"\\nlanguage-servers = [ { name = \\"efm-lsp-prettier\\", only-features = [ \\"format\\" ] }, \\"typescript-language-server\\" ] or equivalent: [[language]]\\nname = \\"typescript\\"\\nlanguage-servers = [ { name = \\"typescript-language-server\\", except-features = [ \\"format\\" ] }, \\"efm-lsp-prettier\\" ] Each requested LSP feature is prioritized in the order of the language-servers array. For example, the first goto-definition supported language server (in this case typescript-language-server) will be taken for the relevant LSP request (command goto_definition). The features diagnostics, code-action, completion, document-symbols and workspace-symbols are an exception to that rule, as they are working for all language servers at the same time and are merged together, if enabled for the language. If no except-features or only-features is given, all features for the language server are enabled. If a language server itself doesn\'t support a feature, the next language server array entry will be tried (and so on). The list of supported features is: format goto-definition goto-declaration goto-type-definition goto-reference goto-implementation signature-help hover document-highlight completion code-action workspace-command document-symbols workspace-symbols diagnostics rename-symbol inlay-hints","breadcrumbs":"Configuration » Languages » Configuring Language Servers for a language","id":"103","title":"Configuring Language Servers for a language"},"104":{"body":"The source for a language\'s tree-sitter grammar is specified in a [[grammar]] section in languages.toml. For example: [[grammar]]\\nname = \\"mylang\\"\\nsource = { git = \\"https://github.com/example/mylang\\", rev = \\"a250c4582510ff34767ec3b7dcdd3c24e8c8aa68\\" } Grammar configuration takes these keys: Key Description name The name of the tree-sitter grammar source The method of fetching the grammar - a table with a schema defined below Where source is a table with either these keys when using a grammar from a git repository: Key Description git A git remote URL from which the grammar should be cloned rev The revision (commit hash or tag) which should be fetched subpath A path within the grammar directory which should be built. Some grammar repositories host multiple grammars (for example tree-sitter-typescript and tree-sitter-ocaml) in subdirectories. This key is used to point hx --grammar build to the correct path for compilation. When omitted, the root of repository is used","breadcrumbs":"Configuration » Languages » Tree-sitter grammar configuration","id":"104","title":"Tree-sitter grammar configuration"},"105":{"body":"You may use a top-level use-grammars key to control which grammars are fetched and built when using hx --grammar fetch and hx --grammar build. # Note: this key must come **before** the [[language]] and [[grammar]] sections\\nuse-grammars = { only = [ \\"rust\\", \\"c\\", \\"cpp\\" ] }\\n# or\\nuse-grammars = { except = [ \\"yaml\\", \\"json\\" ] } When omitted, all grammars are fetched and built.","breadcrumbs":"Configuration » Languages » Choosing grammars","id":"105","title":"Choosing grammars"},"106":{"body":"This section contains guides for adding new language server configurations, tree-sitter grammars, textobject queries, and other similar items.","breadcrumbs":"Guides » Guides","id":"106","title":"Guides"},"107":{"body":"In order to add a new language to Helix, you will need to follow the steps below.","breadcrumbs":"Guides » Adding languages » Adding new languages to Helix","id":"107","title":"Adding new languages to Helix"},"108":{"body":"Add a new [[language]] entry in the languages.toml file and provide the necessary configuration for the new language. For more information on language configuration, refer to the language configuration section of the documentation. A new language server can be added by extending the [language-server] table in the same file. If you are adding a new language or updating an existing language server configuration, run the command cargo xtask docgen to update the Language Support documentation. 💡 If you are adding a new Language Server configuration, make sure to update the Language Server Wiki with the installation instructions.","breadcrumbs":"Guides » Adding languages » Language configuration","id":"108","title":"Language configuration"},"109":{"body":"If a tree-sitter grammar is available for the new language, add a new [[grammar]] entry to the languages.toml file. If you are testing the grammar locally, you can use the source.path key with an absolute path to the grammar. However, before submitting a pull request, make sure to switch to using source.git.","breadcrumbs":"Guides » Adding languages » Grammar configuration","id":"109","title":"Grammar configuration"},"11":{"body":"Helix is available on Snapcraft and can be installed with: snap install --classic helix This will install Helix as both /snap/bin/helix and /snap/bin/hx, so make sure /snap/bin is in your PATH.","breadcrumbs":"Installation » Package Managers » Snap","id":"11","title":"Snap"},"110":{"body":"In order to provide syntax highlighting and indentation for the new language, you will need to add queries. Create a new directory for the language with the path runtime/queries/<name>/. Refer to the tree-sitter website for more information on writing queries. A list of highlight captures can be found on the themes page .","breadcrumbs":"Guides » Adding languages » Queries","id":"110","title":"Queries"},"111":{"body":"If you encounter errors when running Helix after switching branches, you may need to update the tree-sitter grammars. Run the command hx --grammar fetch to fetch the grammars and hx --grammar build to build any out-of-date grammars. If a parser is causing a segfault, or you want to remove it, make sure to remove the compiled parser located at runtime/grammars/<name>.so. If you are attempting to add queries and Helix is unable to locate them, ensure that the environment variable HELIX_RUNTIME is set to the location of the runtime folder you\'re developing in.","breadcrumbs":"Guides » Adding languages » Common issues","id":"111","title":"Common issues"},"112":{"body":"Helix supports textobjects that are language specific, such as functions, classes, etc. These textobjects require an accompanying tree-sitter grammar and a textobjects.scm query file to work properly. Tree-sitter allows us to query the source code syntax tree and capture specific parts of it. The queries are written in a lisp dialect. More information on how to write queries can be found in the official tree-sitter documentation . Query files should be placed in runtime/queries/{language}/textobjects.scm when contributing to Helix. Note that to test the query files locally you should put them under your local runtime directory (~/.config/helix/runtime on Linux for example). The following captures are recognized: Capture Name function.inside function.around class.inside class.around test.inside test.around parameter.inside parameter.around comment.inside comment.around entry.inside entry.around Example query files can be found in the helix GitHub repository.","breadcrumbs":"Guides » Adding textobject queries » Adding textobject queries","id":"112","title":"Adding textobject queries"},"113":{"body":"Tree-sitter based navigation in Helix is done using captures in the following order: object.movement object.around object.inside For example if a function.around capture has been already defined for a language in its textobjects.scm file, function navigation should also work automatically. function.movement should be defined only if the node captured by function.around doesn\'t make sense in a navigation context.","breadcrumbs":"Guides » Adding textobject queries » Queries for textobject based navigation","id":"113","title":"Queries for textobject based navigation"},"114":{"body":"Helix uses tree-sitter to correctly indent new lines. This requires a tree- sitter grammar and an indent.scm query file placed in runtime/queries/ {language}/indents.scm. The indentation for a line is calculated by traversing the syntax tree from the lowest node at the beginning of the new line (see Indent queries ). Each of these nodes contributes to the total indent when it is captured by the query (in what way depends on the name of the capture. Note that it matters where these added indents begin. For example, multiple indent level increases that start on the same line only increase the total indent level by 1. See Capture types . By default, Helix uses the hybrid indentation heuristic. This means that indent queries are not used to compute the expected absolute indentation of a line but rather the expected difference in indentation between the new and an already existing line. This difference is then added to the actual indentation of the already existing line. Since this makes errors in the indent queries harder to find, it is recommended to disable it when testing via :set indent-heuristic tree-sitter. The rest of this guide assumes that the tree-sitter heuristic is used.","breadcrumbs":"Guides » Adding indent queries » Adding indent queries","id":"114","title":"Adding indent queries"},"115":{"body":"When Helix is inserting a new line through o, O, or <ret>, to determine the indent level for the new line, the query in indents.scm is run on the document. The starting position of the query is the end of the line above where a new line will be inserted. For o, the inserted line is the line below the cursor, so that starting position of the query is the end of the current line. fn need_hero(some_hero: Hero, life: Life) -> { matches!(some_hero, Hero { // ←─────────────────╮ strong: true,//←╮ ↑ ↑ │ fast: true, // │ │ ╰── query start │ sure: true, // │ ╰───── cursor ├─ traversal soon: true, // ╰──────── new line inserted │ start node }) && // │\\n// ↑ │\\n// ╰───────────────────────────────────────────────╯ some_hero > life\\n} For O, the newly inserted line is the current line, so the starting position of the query is the end of the line above the cursor. fn need_hero(some_hero: Hero, life: Life) -> { // ←─╮ matches!(some_hero, Hero { // ←╮ ↑ │ strong: true,// ↑ ╭───╯ │ │ fast: true, // │ │ query start ─╯ │ sure: true, // ╰───┼ cursor ├─ traversal soon: true, // ╰ new line inserted │ start node }) && // │ some_hero > life // │\\n} // ←──────────────────────────────────────────────╯ From this starting node, the syntax tree is traversed up until the root node. Each indent capture is collected along the way, and then combined according to their capture types and scopes to a final indent level for the line.","breadcrumbs":"Guides » Adding indent queries » Indent queries","id":"115","title":"Indent queries"},"116":{"body":"@indent (default scope tail): Increase the indent level by 1. Multiple occurrences in the same line do not stack. If there is at least one @indent and one @outdent capture on the same line, the indent level isn\'t changed at all. @outdent (default scope all): Decrease the indent level by 1. The same rules as for @indent apply. @indent.always (default scope tail): Increase the indent level by 1. Multiple occurrences on the same line do stack. The final indent level is @indent.always – @outdent.always. If an @indent and an @indent.always are on the same line, the @indent is ignored. @outdent.always (default scope all): Decrease the indent level by 1. The same rules as for @indent.always apply. @align (default scope all): Align everything inside this node to some anchor. The anchor is given by the start of the node captured by @anchor in the same pattern. Every pattern with an @align should contain exactly one @anchor. Indent (and outdent) for nodes below (in terms of their starting line) the @align node is added to the indentation required for alignment. @extend: Extend the range of this node to the end of the line and to lines that are indented more than the line that this node starts on. This is useful for languages like Python, where for the purpose of indentation some nodes (like functions or classes) should also contain indented lines that follow them. @extend.prevent-once: Prevents the first extension of an ancestor of this node. For example, in Python a return expression always ends the block that it is in. Note that this only stops the extension of the next @extend capture. If multiple ancestors are captured, only the extension of the innermost one is prevented. All other ancestors are unaffected (regardless of whether the innermost ancestor would actually have been extended). @indent / @outdent Consider this example: fn shout(things: Vec<Thing>) { // ↑ // ├───────────────────────╮ indent level // @indent ├┄┄┄┄┄┄┄┄┄┄┄┄┄┄ // │ let it_all = |out| { things.filter(|thing| { // │ 1 // ↑ ↑ │ // ├───────────────────────┼─────┼┄┄┄┄┄┄┄┄┄┄┄┄┄┄ // @indent @indent │ // │ 2 thing.can_do_with(out) // │ })}; // ├┄┄┄┄┄┄┄┄┄┄┄┄┄┄ //↑↑↑ │ 1\\n} //╰┼┴──────────────────────────────────────────────┴┄┄┄┄┄┄┄┄┄┄┄┄┄┄\\n// 3x @outdent ((block) @indent)\\n[\\"}\\" \\")\\"] @outdent Note how on the second line, we have two blocks begin on the same line. In this case, since both captures occur on the same line, they are combined and only result in a net increase of 1. Also note that the closing }s are part of the @indent captures, but the 3 @outdents also combine into 1 and result in that line losing one indent level. @extend / @extend.prevent-once For an example of where @extend can be useful, consider Python, which is whitespace-sensitive. ] (parenthesized_expression) (function_definition) (class_definition)\\n] @indent class Hero: def __init__(self, strong, fast, sure, soon):# ←─╮ self.is_strong = strong # │ self.is_fast = fast # ╭─── query start │ self.is_sure = sure # │ ╭─ cursor │ self.is_soon = soon # │ │ │ # ↑ ↑ │ │ │ # │ ╰──────╯ │ │ # ╰─────────────────────╯ │ # ├─ traversal def need_hero(self, life): # │ start node return ( # │ self.is_strong # │ and self.is_fast # │ and self.is_sure # │ and self.is_soon # │ and self > life # │ ) # ←─────────────────────────────────────────╯ Without braces to catch the scope of the function, the smallest descendant of the cursor on a line feed ends up being the entire inside of the class. Because of this, it will miss the entire function node and its indent capture, leading to an indent level one too small. To address this case, @extend tells helix to \\"extend\\" the captured node\'s span to the line feed and every consecutive line that has a greater indent level than the line of the node. (parenthesized_expression) @indent ] (function_definition) (class_definition)\\n] @indent @extend class Hero: def __init__(self, strong, fast, sure, soon):# ←─╮ self.is_strong = strong # │ self.is_fast = fast # ╭─── query start ├─ traversal self.is_sure = sure # │ ╭─ cursor │ start node self.is_soon = soon # │ │ ←───────────────╯ # ↑ ↑ │ │ # │ ╰──────╯ │ # ╰─────────────────────╯ def need_hero(self, life): return ( self.is_strong and self.is_fast and self.is_sure and self.is_soon and self > life ) Furthermore, there are some cases where extending to everything with a greater indent level may not be desirable. Consider the need_hero function above. If our cursor is on the last line of the returned expression. class Hero: def __init__(self, strong, fast, sure, soon): self.is_strong = strong self.is_fast = fast self.is_sure = sure self.is_soon = soon def need_hero(self, life): return ( self.is_strong and self.is_fast and self.is_sure and self.is_soon and self > life ) # ←─── cursor #←────────── where cursor should go on new line In Python, the are a few tokens that will always end a scope, such as a return statement. Since the scope ends, so should the indent level. But because the function span is extended to every line with a greater indent level, a new line would just continue on the same level. And an @outdent would not help us here either, since it would cause everything in the parentheses to become outdented as well. To help, we need to signal an end to the extension. We can do this with @extend.prevent-once. (parenthesized_expression) @indent ] (function_definition) (class_definition)\\n] @indent @extend (return_statement) @extend.prevent-once @indent.always / @outdent.always As mentioned before, normally if there is more than one @indent or @outdent capture on the same line, they are combined. Sometimes, there are cases when you may want to ensure that every indent capture is additive, regardless of how many occur on the same line. Consider this example in YAML. - foo: bar\\n# ↑ ↑\\n# │ ╰─────────────── start of map\\n# ╰───────────────── start of list element baz: quux # ←─── cursor # ←───────────── where the cursor should go on a new line garply: waldo - quux: bar: baz xyzzy: thud fred: plugh In YAML, you often have lists of maps. In these cases, the syntax is such that the list element and the map both start on the same line. But we really do want to start an indentation for each of these so that subsequent keys in the map hang over the list and align properly. This is where @indent.always helps. ((block_sequence_item) @item @indent.always @extend (#not-one-line? @item)) ((block_mapping_pair key: (_) @key value: (_) @val (#not-same-line? @key @val) ) @indent.always @extend\\n)","breadcrumbs":"Guides » Adding indent queries » Capture types","id":"116","title":"Capture types"},"117":{"body":"In some cases, an S-expression cannot express exactly what pattern should be matched. For that, tree-sitter allows for predicates to appear anywhere within a pattern, similar to how #set! declarations work: (some_kind (child_kind) @indent (#predicate? arg1 arg2 ...)\\n) The number of arguments depends on the predicate that\'s used. Each argument is either a capture (@name) or a string (\\"some string\\"). The following predicates are supported by tree-sitter: #eq?/#not-eq?: The first argument (a capture) must/must not be equal to the second argument (a capture or a string). #match?/#not-match?: The first argument (a capture) must/must not match the regex given in the second argument (a string). #any-of?/#not-any-of?: The first argument (a capture) must/must not be one of the other arguments (strings). Additionally, we support some custom predicates for indent queries: #not-kind-eq?: The kind of the first argument (a capture) must not be equal to the second argument (a string). #same-line?/#not-same-line?: The captures given by the 2 arguments must/must not start on the same line. #one-line?/#not-one-line?: The captures given by the fist argument must/must span a total of one line.","breadcrumbs":"Guides » Adding indent queries » Predicates","id":"117","title":"Predicates"},"118":{"body":"Added indents don\'t always apply to the whole node. For example, in most cases when a node should be indented, we actually only want everything except for its first line to be indented. For this, there are several scopes (more scopes may be added in the future if required): tail: This scope applies to everything except for the first line of the captured node. all: This scope applies to the whole captured node. This is only different from tail when the captured node is the first node on its line. For example, imagine we have the following function fn aha() { // ←─────────────────────────────────────╮ let take = \\"on me\\"; // ←──────────────╮ scope: │ let take = \\"me on\\"; // ├─ \\"tail\\" ├─ (block) @indent let ill = be_gone_days(1 || 2); // │ │\\n} // ←───────────────────────────────────┴──────────┴─ \\"}\\" @outdent // scope: \\"all\\" We can write the following query with the #set! declaration: ((block) @indent (#set! \\"scope\\" \\"tail\\"))\\n(\\"}\\" @outdent (#set! \\"scope\\" \\"all\\")) As we can see, the \\"tail\\" scope covers the node, except for the first line. Everything up to and including the closing brace gets an indent level of 1. Then, on the closing brace, we encounter an outdent with a scope of \\"all\\", which means the first line is included, and the indent level is cancelled out on this line. (Note these scopes are the defaults for @indent and @outdent—they are written explicitly for demonstration.)","breadcrumbs":"Guides » Adding indent queries » Scopes","id":"118","title":"Scopes"},"119":{"body":"Writing language injection queries allows one to highlight a specific node as a different language. In addition to the standard language injection options used by tree-sitter, there are a few Helix specific extensions that allow for more control. An example of a simple query that would highlight all strings as bash in Nix: ((string_expression (string_fragment) @injection.content) (#set! injection.language \\"bash\\")) Another example is this query, which highlights links in comments and keywords like \\"TODO\\", by reusing the dedicated \\"comment\\" language: ((comment) @injection.content (#set! injection.language \\"comment\\"))","breadcrumbs":"Guides » Adding injection queries » Adding Injection Queries","id":"119","title":"Adding Injection Queries"},"12":{"body":"Install Helix using the Linux AppImage format. Download the official Helix AppImage from the latest releases page. chmod +x helix-*.AppImage # change permission for executable mode\\n./helix-*.AppImage # run helix You can optionally add the .desktop file . Helix must be installed in PATH with the name hx. For example: mkdir -p \\"$HOME/.local/bin\\"\\nmv helix-*.AppImage \\"$HOME/.local/bin/hx\\" and make sure ~/.local/bin is in your PATH.","breadcrumbs":"Installation » Package Managers » AppImage","id":"12","title":"AppImage"},"120":{"body":"@injection.language (standard): The captured node may contain the language name used to highlight the node captured by @injection.content. @injection.content (standard): Marks the content to be highlighted as the language captured with @injection.language et al . @injection.filename (extension): The captured node may contain a filename with a file-extension known to Helix, highlighting @injection.content as that language. This uses the language extensions defined in both the default languages.toml distributed with Helix, as well as user defined languages. @injection.shebang (extension): The captured node may contain a shebang used to choose a language to highlight as. This also uses the shebangs defined in the default and user languages.toml.","breadcrumbs":"Guides » Adding injection queries » Capture Types","id":"120","title":"Capture Types"},"121":{"body":"injection.combined (standard): Indicates that all the matching nodes in the tree should have their content parsed as one nested document. injection.language (standard): Forces the captured content to be highlighted as the given language injection.include-children (standard): Indicates that the content node’s entire text should be re-parsed, including the text of its child nodes. By default, child nodes’ text will be excluded from the injected document. injection.include-unnamed-children (extension): Same as injection.include-children but only for unnamed child nodes.","breadcrumbs":"Guides » Adding injection queries » Settings","id":"121","title":"Settings"},"122":{"body":"#eq? (standard): The first argument (a capture) must be equal to the second argument (a capture or a string). #match? (standard): The first argument (a capture) must match the regex given in the second argument (a string). #any-of? (standard): The first argument (a capture) must be one of the other arguments (strings).","breadcrumbs":"Guides » Adding injection queries » Predicates","id":"122","title":"Predicates"},"13":{"body":"","breadcrumbs":"Installation » Package Managers » macOS","id":"13","title":"macOS"},"14":{"body":"brew install helix","breadcrumbs":"Installation » Package Managers » Homebrew Core","id":"14","title":"Homebrew Core"},"15":{"body":"sudo port install helix","breadcrumbs":"Installation » Package Managers » MacPorts","id":"15","title":"MacPorts"},"16":{"body":"Install on Windows using Winget , Scoop , Chocolatey or MSYS2 .","breadcrumbs":"Installation » Package Managers » Windows","id":"16","title":"Windows"},"17":{"body":"Windows Package Manager winget command-line tool is by default available on Windows 11 and modern versions of Windows 10 as a part of the App Installer. You can get App Installer from the Microsoft Store . If it\'s already installed, make sure it is updated with the latest version. winget install Helix.Helix","breadcrumbs":"Installation » Package Managers » Winget","id":"17","title":"Winget"},"18":{"body":"scoop install helix","breadcrumbs":"Installation » Package Managers » Scoop","id":"18","title":"Scoop"},"19":{"body":"choco install helix","breadcrumbs":"Installation » Package Managers » Chocolatey","id":"19","title":"Chocolatey"},"2":{"body":"Download pre-built binaries from the GitHub Releases page . The tarball contents include an hx binary and a runtime directory. To set up Helix: Add the hx binary to your system\'s $PATH to allow it to be used from the command line. Copy the runtime directory to a location that hx searches for runtime files. A typical location on Linux/macOS is ~/.config/helix/runtime. To see the runtime directories that hx searches, run hx --health. If necessary, you can override the default runtime location by setting the HELIX_RUNTIME environment variable.","breadcrumbs":"Installation » Pre-built binaries","id":"2","title":"Pre-built binaries"},"20":{"body":"For 64-bit Windows 8.1 or above: pacman -S mingw-w64-ucrt-x86_64-helix","breadcrumbs":"Installation » Package Managers » MSYS2","id":"20","title":"MSYS2"},"21":{"body":"Configuring Helix\'s runtime files Linux and macOS Windows Multiple runtime directories Note to packagers Validating the installation Configure the desktop shortcut Building the Debian package Requirements: Clone the Helix GitHub repository into a directory of your choice. The examples in this documentation assume installation into either ~/src/ on Linux and macOS, or %userprofile%\\\\src\\\\ on Windows. The Rust toolchain The Git version control system A C++14 compatible compiler to build the tree-sitter grammars, for example GCC or Clang If you are using the musl-libc standard library instead of glibc the following environment variable must be set during the build to ensure tree-sitter grammars can be loaded correctly: RUSTFLAGS=\\"-C target-feature=-crt-static\\" Clone the repository: git clone https://github.com/helix-editor/helix\\ncd helix Compile from source: # Reproducible\\ncargo install --path helix-term --locked # Optimized\\ncargo install \\\\ --profile opt \\\\ --config \'build.rustflags=\\"-C target-cpu=native\\"\' \\\\ --path helix-term \\\\ --locked Either command will create the hx executable and construct the tree-sitter grammars in the local runtime folder. 💡 If you do not want to fetch or build grammars, set an environment variable HELIX_DISABLE_AUTO_GRAMMAR_BUILD 💡 Tree-sitter grammars can be fetched and compiled if not pre-packaged. Fetch grammars with hx --grammar fetch and compile them with hx --grammar build. This will install them in the runtime directory within the user\'s helix config directory (more details below ).","breadcrumbs":"Installation » Building from source » Building from source","id":"21","title":"Building from source"},"22":{"body":"Linux and macOS The runtime directory is one below the Helix source, so either export a HELIX_RUNTIME environment variable to point to that directory and add it to your ~/.bashrc or equivalent: export HELIX_RUNTIME=~/src/helix/runtime Or, create a symbolic link: ln -Tsf $PWD/runtime ~/.config/helix/runtime Windows Either set the HELIX_RUNTIME environment variable to point to the runtime files using the Windows setting (search for Edit environment variables for your account) or use the setx command in Cmd: setx HELIX_RUNTIME \\"%userprofile%\\\\src\\\\helix\\\\runtime\\" 💡 %userprofile% resolves to your user directory like C:\\\\Users\\\\Your-Name\\\\ for example. Or, create a symlink in %appdata%\\\\helix\\\\ that links to the source code directory: Method Command PowerShell New-Item -ItemType Junction -Target \\"runtime\\" -Path \\"$Env:AppData\\\\helix\\\\runtime\\" Cmd cd %appdata%\\\\helix mklink /D runtime \\"%userprofile%\\\\src\\\\helix\\\\runtime\\" 💡 On Windows, creating a symbolic link may require running PowerShell or Cmd as an administrator. Multiple runtime directories When Helix finds multiple runtime directories it will search through them for files in the following order: runtime/ sibling directory to $CARGO_MANIFEST_DIR directory (this is intended for developing and testing helix only). runtime/ subdirectory of OS-dependent helix user config directory. $HELIX_RUNTIME Distribution-specific fallback directory (set at compile time—not run time— with the HELIX_DEFAULT_RUNTIME environment variable) runtime/ subdirectory of path to Helix executable. This order also sets the priority for selecting which file will be used if multiple runtime directories have files with the same name. Note to packagers If you are making a package of Helix for end users, to provide a good out of the box experience, you should set the HELIX_DEFAULT_RUNTIME environment variable at build time (before invoking cargo build) to a directory which will store the final runtime files after installation. For example, say you want to package the runtime into /usr/lib/helix/runtime. The rough steps a build script could follow are: export HELIX_DEFAULT_RUNTIME=/usr/lib/helix/runtime cargo build --profile opt --locked cp -r runtime $BUILD_DIR/usr/lib/helix/ cp target/opt/hx $BUILD_DIR/usr/bin/hx This way the resulting hx binary will always look for its runtime directory in /usr/lib/helix/runtime if the user has no custom runtime in ~/.config/helix or HELIX_RUNTIME.","breadcrumbs":"Installation » Building from source » Configuring Helix\'s runtime files","id":"22","title":"Configuring Helix\'s runtime files"},"23":{"body":"To make sure everything is set up as expected you should run the Helix health check: hx --health For more information on the health check results refer to Health check .","breadcrumbs":"Installation » Building from source » Validating the installation","id":"23","title":"Validating the installation"},"24":{"body":"If your desktop environment supports the XDG desktop menu you can configure Helix to show up in the application menu by copying the provided .desktop and icon files to their correct folders: cp contrib/Helix.desktop ~/.local/share/applications\\ncp contrib/helix.png ~/.icons # or ~/.local/share/icons It is recommended to convert the links in the .desktop file to absolute paths to avoid potential problems: sed -i -e \\"s|Exec=hx %F|Exec=$(readlink -f ~/.cargo/bin/hx) %F|g\\" \\\\ -e \\"s|Icon=helix|Icon=$(readlink -f ~/.icons/helix.png)|g\\" ~/.local/share/applications/Helix.desktop To use another terminal than the system default, you can modify the .desktop file. For example, to use kitty: sed -i \\"s|Exec=hx %F|Exec=kitty hx %F|g\\" ~/.local/share/applications/Helix.desktop\\nsed -i \\"s|Terminal=true|Terminal=false|g\\" ~/.local/share/applications/Helix.desktop","breadcrumbs":"Installation » Building from source » Configure the desktop shortcut","id":"24","title":"Configure the desktop shortcut"},"25":{"body":"If the .deb file provided on the release page uses a libc version higher than that used by your Debian, Ubuntu, or Mint system, you can build the package from source to match your system\'s dependencies. Install cargo-deb, the tool used for building the .deb file: cargo install cargo-deb After cloning and entering the Helix repository as previously described, use the following command to build the release binary and package it into a .deb file in a single step. cargo deb -- --locked 💡 This locks you into the --release profile. But you can also build helix in any way you like. As long as you leave a target/release/hx file, it will get packaged with cargo deb --no-build 💡 Don\'t worry about the following: warning: Failed to find dependency specification Cargo deb just reports which packaged files it didn\'t derive dependencies for. But so far the dependency deriving seams very good, even if some of the grammar files are skipped. You can find the resulted .deb in target/debian/. It should contain everything it needs, including the completions for bash, fish, zsh .desktop file icon (though desktop environments might use their own since the name of the package is correctly helix) launcher to the binary with the runtime","breadcrumbs":"Installation » Building from source » Building the Debian package","id":"25","title":"Building the Debian package"},"26":{"body":"For a full interactive introduction to Helix, refer to the tutor which can be accessed via the command hx --tutor or :tutor. 💡 Currently, not all functionality is fully documented, please refer to the key mappings list.","breadcrumbs":"Usage » Using Helix","id":"26","title":"Using Helix"},"27":{"body":"Helix is a modal editor, meaning it has different modes for different tasks. The main modes are: Normal mode : For navigation and editing commands. This is the default mode. Insert mode : For typing text directly into the document. Access by typing i in normal mode. Select/extend mode : For making selections and performing operations on them. Access by typing v in normal mode.","breadcrumbs":"Usage » Modes","id":"27","title":"Modes"},"28":{"body":"Buffers are in-memory representations of files. You can have multiple buffers open at once. Use pickers or commands like :buffer-next and :buffer-previous to open buffers or switch between them.","breadcrumbs":"Usage » Buffers","id":"28","title":"Buffers"},"29":{"body":"Inspired by Kakoune , Helix follows the selection → action model. This means that whatever you are going to act on (a word, a paragraph, a line, etc.) is selected first and the action itself (delete, change, yank, etc.) comes second. A cursor is simply a single width selection.","breadcrumbs":"Usage » Selection-first editing","id":"29","title":"Selection-first editing"},"3":{"body":"Linux Ubuntu/Debian Ubuntu (PPA) Fedora/RHEL Arch Linux extra NixOS Flatpak Snap AppImage macOS Homebrew Core MacPorts Windows Winget Scoop Chocolatey MSYS2 Packaging status","breadcrumbs":"Installation » Package Managers » Package managers","id":"3","title":"Package managers"},"30":{"body":"Also inspired by Kakoune, multiple selections are a core mode of interaction in Helix. For example, the standard way of replacing multiple instances of a word is to first select all instances (so there is one selection per instance) and then use the change action (c) to edit them all at the same time.","breadcrumbs":"Usage » Multiple selections","id":"30","title":"Multiple selections"},"31":{"body":"Motions are commands that move the cursor or modify selections. They\'re used for navigation and text manipulation. Examples include w to move to the next word, or f to find a character. See the Movement section of the keymap for more motions.","breadcrumbs":"Usage » Motions","id":"31","title":"Motions"},"32":{"body":"User-defined registers Default registers Special registers In Helix, registers are storage locations for text and other data, such as the result of a search. Registers can be used to cut, copy, and paste text, similar to the clipboard in other text editors. Usage is similar to Vim, with \\" being used to select a register.","breadcrumbs":"Usage » Registers » Registers","id":"32","title":"Registers"},"33":{"body":"Helix allows you to create your own named registers for storing text, for example: \\"ay - Yank the current selection to register a. \\"op - Paste the text in register o after the selection. If a register is selected before invoking a change or delete command, the selection will be stored in the register and the action will be carried out: \\"hc - Store the selection in register h and then change it (delete and enter insert mode). \\"md - Store the selection in register m and delete it.","breadcrumbs":"Usage » Registers » User-defined registers","id":"33","title":"User-defined registers"},"34":{"body":"Commands that use registers, like yank (y), use a default register if none is specified. These registers are used as defaults: Register character Contains / Last search : Last executed command \\" Last yanked text @ Last recorded macro","breadcrumbs":"Usage » Registers » Default registers","id":"34","title":"Default registers"},"35":{"body":"Some registers have special behavior when read from and written to. Register character When read When written _ No values are returned All values are discarded # Selection indices (first selection is 1, second is 2, etc.) This register is not writable . Contents of the current selections This register is not writable % Name of the current file This register is not writable + Reads from the system clipboard Joins and yanks to the system clipboard * Reads from the primary clipboard Joins and yanks to the primary clipboard When yanking multiple selections to the clipboard registers, the selections are joined with newlines. Pasting from these registers will paste multiple selections if the clipboard was last yanked to by the Helix session. Otherwise the clipboard contents are pasted as one selection.","breadcrumbs":"Usage » Registers » Special registers","id":"35","title":"Special registers"},"36":{"body":"Helix includes built-in functionality similar to vim-surround . The keymappings have been inspired from vim-sandwich : Surround demo Key Sequence Action ms<char> (after selecting text) Add surround characters to selection mr<char_to_replace><new_char> Replace the closest surround characters md<char_to_delete> Delete the closest surround characters You can use counts to act on outer pairs. Surround can also act on multiple selections. For example, to change every occurrence of (use) to [use]: % to select the whole file s to split the selections on a search term Input use and hit Enter mr([ to replace the parentheses with square brackets Multiple characters are currently not supported, but planned for future release.","breadcrumbs":"Usage » Surround » Surround","id":"36","title":"Surround"},"37":{"body":"In Helix, textobjects are a way to select, manipulate and operate on a piece of text in a structured way. They allow you to refer to blocks of text based on their structure or purpose, such as a word, sentence, paragraph, or even a function or block of code. Textobject demo Textobject tree-sitter demo ma - Select around the object (va in Vim, <alt-a> in Kakoune) mi - Select inside the object (vi in Vim, <alt-i> in Kakoune) Key after mi or ma Textobject selected w Word W WORD p Paragraph (, [, \', etc. Specified surround pairs m The closest surround pair f Function t Type (or Class) a Argument/parameter c Comment T Test g Change 💡 f, t, etc. need a tree-sitter grammar active for the current document and a special tree-sitter query file to work properly. Only some grammars currently have the query file implemented. Contributions are welcome!","breadcrumbs":"Usage » Textobjects » Selecting and manipulating text with textobjects","id":"37","title":"Selecting and manipulating text with textobjects"},"38":{"body":"Navigating between functions, classes, parameters, and other elements is possible using tree-sitter and textobject queries. For example to move to the next function use ]f, to move to previous type use [t, and so on. Tree-sitter-nav-demo For the full reference see the unimpaired section of the key bind documentation. 💡 This feature relies on tree-sitter textobjects and requires the corresponding query file to work properly.","breadcrumbs":"Usage » Textobjects » Navigating using tree-sitter textobjects","id":"38","title":"Navigating using tree-sitter textobjects"},"39":{"body":"Alt-p, Alt-o, Alt-i, and Alt-n (or Alt and arrow keys) allow you to move the selection according to its location in the syntax tree. For example, many languages have the following syntax for function calls: func(arg1, arg2, arg3); A function call might be parsed by tree-sitter into a tree like the following. (call function: (identifier) ; func arguments: (arguments ; (arg1, arg2, arg3) (identifier) ; arg1 (identifier) ; arg2 (identifier))) ; arg3 Use :tree-sitter-subtree to view the syntax tree of the primary selection. In a more intuitive tree format: ┌────┐ │call│ ┌─────┴────┴─────┐ │ │\\n┌─────▼────┐ ┌────▼────┐\\n│identifier│ │arguments│\\n│ \\"func\\" │ ┌────┴───┬─────┴───┐\\n└──────────┘ │ │ │ │ │ │ ┌─────────▼┐ ┌────▼─────┐ ┌▼─────────┐ │identifier│ │identifier│ │identifier│ │ \\"arg1\\" │ │ \\"arg2\\" │ │ \\"arg3\\" │ └──────────┘ └──────────┘ └──────────┘ If you have a selection that wraps arg1 (see the tree above), and you use Alt-n, it will select the next sibling in the syntax tree: arg2. // before\\nfunc([arg1], arg2, arg3)\\n// after\\nfunc(arg1, [arg2], arg3); Similarly, Alt-o will expand the selection to the parent node, in this case, the arguments node. func[(arg1, arg2, arg3)]; There is also some nuanced behavior that prevents you from getting stuck on a node with no sibling. When using Alt-p with a selection on arg1, the previous child node will be selected. In the event that arg1 does not have a previous sibling, the selection will move up the syntax tree and select the previous element. As a result, using Alt-p with a selection on arg1 will move the selection to the \\"func\\" identifier.","breadcrumbs":"Usage » Syntax aware motions » Moving the selection with syntax-aware motions","id":"39","title":"Moving the selection with syntax-aware motions"},"4":{"body":"The following third party repositories are available:","breadcrumbs":"Installation » Package Managers » Linux","id":"4","title":"Linux"},"40":{"body":"Helix has a variety of pickers, which are interactive windows used to select various kinds of items. These include a file picker, global search picker, and more. Most pickers are accessed via keybindings in space mode . Pickers have their own keymap for navigation.","breadcrumbs":"Usage » Pickers » Using pickers","id":"40","title":"Using pickers"},"41":{"body":"Most pickers perform fuzzy matching using fzf syntax . Two exceptions are the global search picker, which uses regex, and the workspace symbol picker, which passes search terms to the language server. Note that OR operations (|) are not currently supported. If a picker shows multiple columns, you may apply the filter to a specific column by prefixing the column name with %. Column names can be shortened to any prefix, so %p, %pa or %pat all mean the same as %path. For example, a query of helix %p .toml !lang in the global search picker searches for the term \\"helix\\" within files with paths ending in \\".toml\\" but not including \\"lang\\". You can insert the contents of a register using Ctrl-r followed by a register name. For example, one could insert the currently selected text using Ctrl-r-., or the directory of the current file using Ctrl-r-% followed by Ctrl-w to remove the last path section. The global search picker will use the contents of the search register if you press Enter without typing a filter. For example, pressing *-Space-/-Enter will start a global search for the currently selected text.","breadcrumbs":"Usage » Pickers » Filtering Picker Results","id":"41","title":"Filtering Picker Results"},"42":{"body":"Normal mode Movement Changes Shell Selection manipulation Search Minor modes View mode Goto mode Match mode Window mode Space mode Popup Completion Menu Signature-help Popup Unimpaired Insert mode Select / extend mode Picker Prompt 💡 Mappings marked ( LSP ) require an active language server for the file. 💡 Mappings marked ( TS ) require a tree-sitter grammar for the file type. ⚠️ Some terminals\' default key mappings conflict with Helix\'s. If any of the mappings described on this page do not work as expected, check your terminal\'s mappings to ensure they do not conflict. See the wiki for known conflicts.","breadcrumbs":"Usage » Keymap » Keymap","id":"42","title":"Keymap"},"43":{"body":"Normal mode is the default mode when you launch helix. You can return to it from other modes by pressing the Escape key.","breadcrumbs":"Usage » Keymap » Normal mode","id":"43","title":"Normal mode"},"44":{"body":"NOTE: Unlike Vim, f, F, t and T are not confined to the current line. Key Description Command h, Left Move left move_char_left j, Down Move down move_visual_line_down k, Up Move up move_visual_line_up l, Right Move right move_char_right w Move next word start move_next_word_start b Move previous word start move_prev_word_start e Move next word end move_next_word_end W Move next WORD start move_next_long_word_start B Move previous WORD start move_prev_long_word_start E Move next WORD end move_next_long_word_end t Find till next char find_till_char f Find next char find_next_char T Find till previous char till_prev_char F Find previous char find_prev_char G Go to line number <n> goto_line Alt-. Repeat last motion (f, t, m, [ or ]) repeat_last_motion Home Move to the start of the line goto_line_start End Move to the end of the line goto_line_end Ctrl-b, PageUp Move page up page_up Ctrl-f, PageDown Move page down page_down Ctrl-u Move cursor and page half page up page_cursor_half_up Ctrl-d Move cursor and page half page down page_cursor_half_down Ctrl-i Jump forward on the jumplist jump_forward Ctrl-o Jump backward on the jumplist jump_backward Ctrl-s Save the current selection to the jumplist save_selection","breadcrumbs":"Usage » Keymap » Movement","id":"44","title":"Movement"},"45":{"body":"Key Description Command r Replace with a character replace R Replace with yanked text replace_with_yanked ~ Switch case of the selected text switch_case ` Set the selected text to lower case switch_to_lowercase Alt-` Set the selected text to upper case switch_to_uppercase i Insert before selection insert_mode a Insert after selection (append) append_mode I Insert at the start of the line insert_at_line_start A Insert at the end of the line insert_at_line_end o Open new line below selection open_below O Open new line above selection open_above . Repeat last insert N/A u Undo change undo U Redo change redo Alt-u Move backward in history earlier Alt-U Move forward in history later y Yank selection yank p Paste after selection paste_after P Paste before selection paste_before \\" <reg> Select a register to yank to or paste from select_register > Indent selection indent < Unindent selection unindent = Format selection ( LSP ) format_selections d Delete selection delete_selection Alt-d Delete selection, without yanking delete_selection_noyank c Change selection (delete and enter insert mode) change_selection Alt-c Change selection (delete and enter insert mode, without yanking) change_selection_noyank Ctrl-a Increment object (number) under cursor increment Ctrl-x Decrement object (number) under cursor decrement Q Start/stop macro recording to the selected register (experimental) record_macro q Play back a recorded macro from the selected register (experimental) replay_macro Shell Key Description Command | Pipe each selection through shell command, replacing with output shell_pipe Alt-| Pipe each selection into shell command, ignoring output shell_pipe_to ! Run shell command, inserting output before each selection shell_insert_output Alt-! Run shell command, appending output after each selection shell_append_output $ Pipe each selection into shell command, keep selections where command returned 0 shell_keep_pipe","breadcrumbs":"Usage » Keymap » Changes","id":"45","title":"Changes"},"46":{"body":"Key Description Command s Select all regex matches inside selections select_regex S Split selection into sub selections on regex matches split_selection Alt-s Split selection on newlines split_selection_on_newline Alt-minus Merge selections merge_selections Alt-_ Merge consecutive selections merge_consecutive_selections & Align selection in columns align_selections _ Trim whitespace from the selection trim_selections ; Collapse selection onto a single cursor collapse_selection Alt-; Flip selection cursor and anchor flip_selections Alt-: Ensures the selection is in forward direction ensure_selections_forward , Keep only the primary selection keep_primary_selection Alt-, Remove the primary selection remove_primary_selection C Copy selection onto the next line (Add cursor below) copy_selection_on_next_line Alt-C Copy selection onto the previous line (Add cursor above) copy_selection_on_prev_line ( Rotate main selection backward rotate_selections_backward ) Rotate main selection forward rotate_selections_forward Alt-( Rotate selection contents backward rotate_selection_contents_backward Alt-) Rotate selection contents forward rotate_selection_contents_forward % Select entire file select_all x Select current line, if already selected, extend to next line extend_line_below X Extend selection to line bounds (line-wise selection) extend_to_line_bounds Alt-x Shrink selection to line bounds (line-wise selection) shrink_to_line_bounds J Join lines inside selection join_selections Alt-J Join lines inside selection and select the inserted space join_selections_space K Keep selections matching the regex keep_selections Alt-K Remove selections matching the regex remove_selections Ctrl-c Comment/uncomment the selections toggle_comments Alt-o, Alt-up Expand selection to parent syntax node ( TS ) expand_selection Alt-i, Alt-down Shrink syntax tree object selection ( TS ) shrink_selection Alt-p, Alt-left Select previous sibling node in syntax tree ( TS ) select_prev_sibling Alt-n, Alt-right Select next sibling node in syntax tree ( TS ) select_next_sibling Alt-a Select all sibling nodes in syntax tree ( TS ) select_all_siblings Alt-I, Alt-Shift-down Select all children nodes in syntax tree ( TS ) select_all_children Alt-e Move to end of parent node in syntax tree ( TS ) move_parent_node_end Alt-b Move to start of parent node in syntax tree ( TS ) move_parent_node_start","breadcrumbs":"Usage » Keymap » Selection manipulation","id":"46","title":"Selection manipulation"},"47":{"body":"Search commands all operate on the / register by default. To use a different register, use \\"<char>. Key Description Command / Search for regex pattern search ? Search for previous pattern rsearch n Select next search match search_next N Select previous search match search_prev * Use current selection as the search pattern, automatically wrapping with \\\\b on word boundaries search_selection_detect_word_boundaries Alt-* Use current selection as the search pattern search_selection","breadcrumbs":"Usage » Keymap » Search","id":"47","title":"Search"},"48":{"body":"These sub-modes are accessible from normal mode and typically switch back to normal mode after a command. Key Description Command v Enter select (extend) mode select_mode g Enter goto mode N/A m Enter match mode N/A : Enter command mode command_mode z Enter view mode N/A Z Enter sticky view mode N/A Ctrl-w Enter window mode N/A Space Enter space mode N/A These modes (except command mode) can be configured by remapping keys . View mode Accessed by typing z in normal mode . View mode is intended for scrolling and manipulating the view without changing the selection. The \\"sticky\\" variant of this mode (accessed by typing Z in normal mode) is persistent and can be exited using the escape key. This is useful when you\'re simply looking over text and not actively editing it. Key Description Command z, c Vertically center the line align_view_center t Align the line to the top of the screen align_view_top b Align the line to the bottom of the screen align_view_bottom m Align the line to the middle of the screen (horizontally) align_view_middle j, down Scroll the view downwards scroll_down k, up Scroll the view upwards scroll_up Ctrl-f, PageDown Move page down page_down Ctrl-b, PageUp Move page up page_up Ctrl-u Move cursor and page half page up page_cursor_half_up Ctrl-d Move cursor and page half page down page_cursor_half_down Goto mode Accessed by typing g in normal mode . Jumps to various locations. Key Description Command g Go to line number <n> else start of file goto_file_start | Go to column number <n> else start of line goto_column e Go to the end of the file goto_last_line f Go to files in the selections goto_file h Go to the start of the line goto_line_start l Go to the end of the line goto_line_end s Go to first non-whitespace character of the line goto_first_nonwhitespace t Go to the top of the screen goto_window_top c Go to the middle of the screen goto_window_center b Go to the bottom of the screen goto_window_bottom d Go to definition ( LSP ) goto_definition y Go to type definition ( LSP ) goto_type_definition r Go to references ( LSP ) goto_reference i Go to implementation ( LSP ) goto_implementation a Go to the last accessed/alternate file goto_last_accessed_file m Go to the last modified/alternate file goto_last_modified_file n Go to next buffer goto_next_buffer p Go to previous buffer goto_previous_buffer . Go to last modification in current file goto_last_modification j Move down textual (instead of visual) line move_line_down k Move up textual (instead of visual) line move_line_up w Show labels at each word and select the word that belongs to the entered labels goto_word Match mode Accessed by typing m in normal mode . Please refer to the relevant sections for detailed explanations about surround and textobjects . Key Description Command m Goto matching bracket ( TS ) match_brackets s <char> Surround current selection with <char> surround_add r <from><to> Replace surround character <from> with <to> surround_replace d <char> Delete surround character <char> surround_delete a <object> Select around textobject select_textobject_around i <object> Select inside textobject select_textobject_inner TODO: Mappings for selecting syntax nodes (a superset of [). Window mode Accessed by typing Ctrl-w in normal mode . This layer is similar to Vim keybindings as Kakoune does not support windows. Key Description Command w, Ctrl-w Switch to next window rotate_view v, Ctrl-v Vertical right split vsplit s, Ctrl-s Horizontal bottom split hsplit f Go to files in the selections in horizontal splits goto_file F Go to files in the selections in vertical splits goto_file h, Ctrl-h, Left Move to left split jump_view_left j, Ctrl-j, Down Move to split below jump_view_down k, Ctrl-k, Up Move to split above jump_view_up l, Ctrl-l, Right Move to right split jump_view_right q, Ctrl-q Close current window wclose o, Ctrl-o Only keep the current window, closing all the others wonly H Swap window to the left swap_view_left J Swap window downwards swap_view_down K Swap window upwards swap_view_up L Swap window to the right swap_view_right Space mode Accessed by typing Space in normal mode . This layer is a kludge of mappings, mostly pickers. Key Description Command f Open file picker at LSP workspace root file_picker F Open file picker at current working directory file_picker_in_current_directory b Open buffer picker buffer_picker j Open jumplist picker jumplist_picker g Open changed file picker changed_file_picker G Debug (experimental) N/A k Show documentation for item under cursor in a popup ( LSP ) hover s Open document symbol picker ( LSP ) symbol_picker S Open workspace symbol picker ( LSP ) workspace_symbol_picker d Open document diagnostics picker ( LSP ) diagnostics_picker D Open workspace diagnostics picker ( LSP ) workspace_diagnostics_picker r Rename symbol ( LSP ) rename_symbol a Apply code action ( LSP ) code_action h Select symbol references ( LSP ) select_references_to_symbol_under_cursor \' Open last fuzzy picker last_picker w Enter window mode N/A c Comment/uncomment selections toggle_comments C Block comment/uncomment selections toggle_block_comments Alt-c Line comment/uncomment selections toggle_line_comments p Paste system clipboard after selections paste_clipboard_after P Paste system clipboard before selections paste_clipboard_before y Yank selections to clipboard yank_to_clipboard Y Yank main selection to clipboard yank_main_selection_to_clipboard R Replace selections by clipboard contents replace_selections_with_clipboard / Global search in workspace folder global_search ? Open command palette command_palette 💡 Global search displays results in a fuzzy picker, use Space + \' to bring it back up after opening a file. Popup Displays documentation for item under cursor. Remapping currently not supported. Key Description Ctrl-u Scroll up Ctrl-d Scroll down Completion Menu Displays documentation for the selected completion item. Remapping currently not supported. Key Description Shift-Tab, Ctrl-p, Up Previous entry Tab, Ctrl-n, Down Next entry Enter Close menu and accept completion Ctrl-c Close menu and reject completion Any other keypresses result in the completion being accepted. Signature-help Popup Displays the signature of the selected completion item. Remapping currently not supported. Key Description Alt-p Previous signature Alt-n Next signature Unimpaired These mappings are in the style of vim-unimpaired . Key Description Command ]d Go to next diagnostic ( LSP ) goto_next_diag [d Go to previous diagnostic ( LSP ) goto_prev_diag ]D Go to last diagnostic in document ( LSP ) goto_last_diag [D Go to first diagnostic in document ( LSP ) goto_first_diag ]f Go to next function ( TS ) goto_next_function [f Go to previous function ( TS ) goto_prev_function ]t Go to next type definition ( TS ) goto_next_class [t Go to previous type definition ( TS ) goto_prev_class ]a Go to next argument/parameter ( TS ) goto_next_parameter [a Go to previous argument/parameter ( TS ) goto_prev_parameter ]c Go to next comment ( TS ) goto_next_comment [c Go to previous comment ( TS ) goto_prev_comment ]T Go to next test ( TS ) goto_next_test [T Go to previous test ( TS ) goto_prev_test ]p Go to next paragraph goto_next_paragraph [p Go to previous paragraph goto_prev_paragraph ]g Go to next change goto_next_change [g Go to previous change goto_prev_change ]G Go to last change goto_last_change [G Go to first change goto_first_change ]Space Add newline below add_newline_below [Space Add newline above add_newline_above","breadcrumbs":"Usage » Keymap » Minor modes","id":"48","title":"Minor modes"},"49":{"body":"Accessed by typing i in normal mode . Insert mode bindings are minimal by default. Helix is designed to be a modal editor, and this is reflected in the user experience and internal mechanics. Changes to the text are only saved for undos when escaping from insert mode to normal mode. 💡 New users are strongly encouraged to learn the modal editing paradigm to get the smoothest experience. Key Description Command Escape Switch to normal mode normal_mode Ctrl-s Commit undo checkpoint commit_undo_checkpoint Ctrl-x Autocomplete completion Ctrl-r Insert a register content insert_register Ctrl-w, Alt-Backspace Delete previous word delete_word_backward Alt-d, Alt-Delete Delete next word delete_word_forward Ctrl-u Delete to start of line kill_to_line_start Ctrl-k Delete to end of line kill_to_line_end Ctrl-h, Backspace, Shift-Backspace Delete previous char delete_char_backward Ctrl-d, Delete Delete next char delete_char_forward Ctrl-j, Enter Insert new line insert_newline These keys are not recommended, but are included for new users less familiar with modal editors. Key Description Command Up Move to previous line move_line_up Down Move to next line move_line_down Left Backward a char move_char_left Right Forward a char move_char_right PageUp Move one page up page_up PageDown Move one page down page_down Home Move to line start goto_line_start End Move to line end goto_line_end_newline As you become more comfortable with modal editing, you may want to disable some insert mode bindings. You can do this by editing your config.toml file. [keys.insert]\\nup = \\"no_op\\"\\ndown = \\"no_op\\"\\nleft = \\"no_op\\"\\nright = \\"no_op\\"\\npageup = \\"no_op\\"\\npagedown = \\"no_op\\"\\nhome = \\"no_op\\"\\nend = \\"no_op\\"","breadcrumbs":"Usage » Keymap » Insert mode","id":"49","title":"Insert mode"},"5":{"body":"Install the Debian package from the release page. If you are running a system older than Ubuntu 22.04, Mint 21, or Debian 12, you can build the .deb file locally from source .","breadcrumbs":"Installation » Package Managers » Ubuntu/Debian","id":"5","title":"Ubuntu/Debian"},"50":{"body":"Accessed by typing v in normal mode . Select mode echoes Normal mode, but changes any movements to extend selections rather than replace them. Goto motions are also changed to extend, so that vgl, for example, extends the selection to the end of the line. Search is also affected. By default, n and N will remove the current selection and select the next instance of the search term. Toggling this mode before pressing n or N makes it possible to keep the current selection. Toggling it on and off during your iterative searching allows you to selectively add search terms to your selections.","breadcrumbs":"Usage » Keymap » Select / extend mode","id":"50","title":"Select / extend mode"},"51":{"body":"Keys to use within picker. Remapping currently not supported. See the documentation page on pickers for more info. Prompt keybinds also work in pickers, except where they conflict with picker keybinds. Key Description Shift-Tab, Up, Ctrl-p Previous entry Tab, Down, Ctrl-n Next entry PageUp, Ctrl-u Page up PageDown, Ctrl-d Page down Home Go to first entry End Go to last entry Enter Open selected Alt-Enter Open selected in the background without closing the picker Ctrl-s Open horizontally Ctrl-v Open vertically Ctrl-t Toggle preview Escape, Ctrl-c Close picker","breadcrumbs":"Usage » Keymap » Picker","id":"51","title":"Picker"},"52":{"body":"Keys to use within prompt, Remapping currently not supported. Key Description Escape, Ctrl-c Close prompt Alt-b, Ctrl-Left Backward a word Ctrl-b, Left Backward a char Alt-f, Ctrl-Right Forward a word Ctrl-f, Right Forward a char Ctrl-e, End Move prompt end Ctrl-a, Home Move prompt start Ctrl-w, Alt-Backspace, Ctrl-Backspace Delete previous word Alt-d, Alt-Delete, Ctrl-Delete Delete next word Ctrl-u Delete to start of line Ctrl-k Delete to end of line Backspace, Ctrl-h, Shift-Backspace Delete previous char Delete, Ctrl-d Delete next char Ctrl-s Insert a word under doc cursor, may be changed to Ctrl-r Ctrl-w later Ctrl-p, Up Select previous history Ctrl-n, Down Select next history Ctrl-r Insert the content of the register selected by following input char Tab Select next completion item BackTab Select previous completion item Enter Open selected","breadcrumbs":"Usage » Keymap » Prompt","id":"52","title":"Prompt"},"53":{"body":"Quoting Flags Expansions Exceptions The command line is used for executing typable commands like :write or :quit. Press : to activate the command line. Typable commands optionally accept arguments. :write for example accepts an optional path to write the file contents. The command line also supports a quoting syntax for arguments, flags to modify command behaviors, and expansions - a way to insert values from the editor. Most commands support these features but some have custom parsing rules (see the exceptions below).","breadcrumbs":"Usage » Command line » Command line","id":"53","title":"Command line"},"54":{"body":"By default, command arguments are split on tabs and space characters. :open README.md CHANGELOG.md for example should open two files, README.md and CHANGELOG.md. Arguments that contain spaces can be surrounded in single quotes (\') or backticks (`) to prevent the space from separating the argument, like :open \'a b.txt\'. Double quotes may be used the same way, but double quotes expand their inner content. :echo \\"%{cursor_line}\\" for example may print 1 because of the expansion for the cursor_line variable. :echo \'%{cursor_line}\' though prints %{cursor_line} literally: content within single quotes or backticks is interpreted as-is. On Unix systems the backslash character may be used to escape certain characters depending on where it is used. Within an argument which isn\'t surround in quotes, the backslash can be used to escape the space or tab characters: :open a\\\\ b.txt is equivalent to :open \'a b.txt\'. The backslash may also be used to escape quote characters (\', `, \\") or the percent token (%) when used at the beginning of an argument. :echo \\\\%%sh{foo} for example prints %sh{foo} instead of invoking a foo shell command and :echo \\\\\\"quote prints \\"quote. The backslash character is treated literally in any other situation on Unix systems and always on Windows: :echo \\\\n always prints \\\\n.","breadcrumbs":"Usage » Command line » Quoting","id":"54","title":"Quoting"},"55":{"body":"Command flags are optional switches that can be used to alter the behavior of a command. For example the :sort command accepts an optional --reverse (or -r for short) flag which causes the sort command to reverse the sorting direction. Typing the - character shows completions for the current command\'s flags, if any. The -- flag specifies the end of flags. All arguments after -- are treated as positional arguments: :open -- -a.txt opens a file called -a.txt.","breadcrumbs":"Usage » Command line » Flags","id":"55","title":"Flags"},"56":{"body":"Expansions are patterns that Helix recognizes and replaces within the command line. Helix recognizes anything starting with a percent token (%) as an expansion, for example %sh{echo hi!}. Expansions are particularly useful when used in commands like :echo or :noop for executing simple scripts. For example: [keys.normal]\\n# Print the current line\'s git blame information to the statusline.\\nspace.B = \\":echo %sh{git blame -L %{cursor_line},+1 %{buffer_name}}\\" Expansions take the form %[<kind>]<open><contents><close>. In %sh{echo hi!}, for example, the kind is sh - the shell expansion - and the contents are \\"echo hi!\\", with { and } acting as opening and closing delimiters. The following open/close characters are recognized as expansion delimiter pairs: (/), [/], {/} and </>. Plus the single characters \', \\" or | may be used instead: %{cursor_line} is equivalent to %<cursor_line>, %[cursor_line] or %|cursor_line|. To escape a percent character instead of treating it as an expansion, use two percent characters consecutively. To execute a shell command like date -u +\'%Y-%m-%d\', double the percent characters: :echo %sh{date -u +\'%%Y-%%m-%%d\'}. When no <kind> is provided, Helix will expand a variable . For example %{cursor_line} can be used as in argument to insert the line number. :echo %{cursor_line} for instance may print 1 to the statusline. The following variables are supported: Name Description cursor_line The line number of the primary cursor in the currently focused document, starting at 1. cursor_column The column number of the primary cursor in the currently focused document, starting at 1. This is counted as the number of grapheme clusters from the start of the line rather than bytes or codepoints. buffer_name The relative path of the currently focused document. [scratch] is expanded instead for scratch buffers. line_ending A string containing the line ending of the currently focused document. For example on Unix systems this is usually a line-feed character (\\\\n) but on Windows systems this may be a carriage-return plus a line-feed (\\\\r\\\\n). The line ending kind of the currently focused document can be inspected with the :line-ending command. language A string containing the language name of the currently focused document. selection A string containing the contents of the primary selection of the currently focused document. selection_line_start The line number of the start of the primary selection in the currently focused document, starting at 1. selection_line_end The line number of the end of the primary selection in the currently focused document, starting at 1. Aside from editor variables, the following expansions may be used: Unicode %u{..}. The contents may contain up to six hexadecimal numbers corresponding to a Unicode codepoint value. For example :echo %u{25CF} prints ● to the statusline. Shell %sh{..}. The contents are passed to the configured shell command. For example :echo %sh{echo \\"20 * 5\\" | bc} may print 100 on the statusline on when using a shell with echo and the bc calculator installed. Shell expansions are evaluated recursively. %sh{echo \'%{buffer_name}:%{cursor_line}\'} for example executes a command like echo \'README.md:1\': the variables within the %sh{..} expansion are evaluated before executing the shell command. As mentioned above, double quotes can be used to surround arguments containing spaces but also support expansions within the quoted content unlike singe quotes or backticks. For example :echo \\"circle: %u{25CF}\\" prints circle: ● to the statusline while :echo \'circle: %u{25CF}\' prints circle: %u{25CF}. Note that expansions are only evaluated once the Enter key is pressed in command mode.","breadcrumbs":"Usage » Command line » Expansions","id":"56","title":"Expansions"},"57":{"body":"The following commands support expansions but otherwise pass the given argument directly to the shell program without interpreting quotes: :insert-output :append-output :pipe :pipe-to :run-shell-command For example executing :sh echo \\"%{buffer_name}:%{cursor_column}\\" would pass text like echo \\"README.md:1\\" as an argument to the shell program: the expansions are evaluated but not the quotes. As mentioned above, percent characters can be used in shell commands by doubling the percent character. To insert the output of a command like date -u +\'%Y-%m-%d\' use :insert-output date -u +\'%%Y-%%m-%%d\'. The :set-option and :toggle-option commands use regular parsing for the first argument - the config option name - and parse the rest depending on the config option\'s type. :set-option interprets the second argument as a string for string config options and parses everything else as JSON. :toggle-option\'s behavior depends on the JSON type of the config option supplied as the first argument: Booleans: only the config option name should be provided. For example :toggle-option auto-format will flip the auto-format option. Strings: the rest of the command line is parsed with regular quoting rules. For example :toggle-option indent-heuristic hybrid tree-sitter simple cycles through \\"hybrid\\", \\"tree-sitter\\" and \\"simple\\" values on each invocation of the command. Numbers, arrays and objects: the rest of the command line is parsed as a stream of JSON values. For example :toggle-option rulers [81] [51, 73] cycles through [81] and [51, 73]. When providing multiple values to :toggle-option there should be no duplicates. :toggle-option indent-heuristic hybrid simple tree-sitter simple for example would only toggle between \\"hybrid\\" and \\"tree-sitter\\" values. :lsp-workspace-command works similarly to :toggle-option. The first argument (if present) is parsed according to normal rules. The rest of the line is parsed as JSON values. Unlike :toggle-option, string arguments for a command must be quoted. For example :lsp-workspace-command lsp.Command \\"foo\\" \\"bar\\".","breadcrumbs":"Usage » Command line » Exceptions","id":"57","title":"Exceptions"},"58":{"body":"Typable commands Static commands","breadcrumbs":"Usage » Commands » Commands","id":"58","title":"Commands"},"59":{"body":"Typable commands are used from command mode and may take arguments. Command mode can be activated by pressing :. The built-in typable commands are: Name Description :quit, :q Close the current view. :quit!, :q! Force close the current view, ignoring unsaved changes. :open, :o, :edit, :e Open a file from disk into the current view. :buffer-close, :bc, :bclose Close the current buffer. :buffer-close!, :bc!, :bclose! Close the current buffer forcefully, ignoring unsaved changes. :buffer-close-others, :bco, :bcloseother Close all buffers but the currently focused one. :buffer-close-others!, :bco!, :bcloseother! Force close all buffers but the currently focused one. :buffer-close-all, :bca, :bcloseall Close all buffers without quitting. :buffer-close-all!, :bca!, :bcloseall! Force close all buffers ignoring unsaved changes without quitting. :buffer-next, :bn, :bnext Goto next buffer. :buffer-previous, :bp, :bprev Goto previous buffer. :write, :w Write changes to disk. Accepts an optional path (:write some/path.txt) :write!, :w! Force write changes to disk creating necessary subdirectories. Accepts an optional path (:write! some/path.txt) :write-buffer-close, :wbc Write changes to disk and closes the buffer. Accepts an optional path (:write-buffer-close some/path.txt) :write-buffer-close!, :wbc! Force write changes to disk creating necessary subdirectories and closes the buffer. Accepts an optional path (:write-buffer-close! some/path.txt) :new, :n Create a new scratch buffer. :format, :fmt Format the file using an external formatter or language server. :indent-style Set the indentation style for editing. (\'t\' for tabs or 1-16 for number of spaces.) :line-ending Set the document\'s default line ending. Options: crlf, lf. :earlier, :ear Jump back to an earlier point in edit history. Accepts a number of steps or a time span. :later, :lat Jump to a later point in edit history. Accepts a number of steps or a time span. :write-quit, :wq, :x Write changes to disk and close the current view. Accepts an optional path (:wq some/path.txt) :write-quit!, :wq!, :x! Write changes to disk and close the current view forcefully. Accepts an optional path (:wq! some/path.txt) :write-all, :wa Write changes from all buffers to disk. :write-all!, :wa! Forcefully write changes from all buffers to disk creating necessary subdirectories. :write-quit-all, :wqa, :xa Write changes from all buffers to disk and close all views. :write-quit-all!, :wqa!, :xa! Write changes from all buffers to disk and close all views forcefully (ignoring unsaved changes). :quit-all, :qa Close all views. :quit-all!, :qa! Force close all views ignoring unsaved changes. :cquit, :cq Quit with exit code (default 1). Accepts an optional integer exit code (:cq 2). :cquit!, :cq! Force quit with exit code (default 1) ignoring unsaved changes. Accepts an optional integer exit code (:cq! 2). :theme Change the editor theme (show current theme if no name specified). :yank-join Yank joined selections. A separator can be provided as first argument. Default value is newline. :clipboard-yank Yank main selection into system clipboard. :clipboard-yank-join Yank joined selections into system clipboard. A separator can be provided as first argument. Default value is newline. :primary-clipboard-yank Yank main selection into system primary clipboard. :primary-clipboard-yank-join Yank joined selections into system primary clipboard. A separator can be provided as first argument. Default value is newline. :clipboard-paste-after Paste system clipboard after selections. :clipboard-paste-before Paste system clipboard before selections. :clipboard-paste-replace Replace selections with content of system clipboard. :primary-clipboard-paste-after Paste primary clipboard after selections. :primary-clipboard-paste-before Paste primary clipboard before selections. :primary-clipboard-paste-replace Replace selections with content of system primary clipboard. :show-clipboard-provider Show clipboard provider name in status bar. :change-current-directory, :cd Change the current working directory. :show-directory, :pwd Show the current working directory. :encoding Set encoding. Based on https://encoding.spec.whatwg.org. :character-info, :char Get info about the character under the primary cursor. :reload, :rl Discard changes and reload from the source file. :reload-all, :rla Discard changes and reload all documents from the source files. :update, :u Write changes only if the file has been modified. :lsp-workspace-command Open workspace command picker :lsp-restart Restarts the given language servers, or all language servers that are used by the current file if no arguments are supplied :lsp-stop Stops the given language servers, or all language servers that are used by the current file if no arguments are supplied :tree-sitter-scopes Display tree sitter scopes, primarily for theming and development. :tree-sitter-highlight-name Display name of tree-sitter highlight scope under the cursor. :debug-start, :dbg Start a debug session from a given template with given parameters. :debug-remote, :dbg-tcp Connect to a debug adapter by TCP address and start a debugging session from a given template with given parameters. :debug-eval Evaluate expression in current debug context. :vsplit, :vs Open the file in a vertical split. :vsplit-new, :vnew Open a scratch buffer in a vertical split. :hsplit, :hs, :sp Open the file in a horizontal split. :hsplit-new, :hnew Open a scratch buffer in a horizontal split. :tutor Open the tutorial. :goto, :g Goto line number. :set-language, :lang Set the language of current buffer (show current language if no value specified). :set-option, :set Set a config option at runtime.For example to disable smart case search, use :set search.smart-case false. :toggle-option, :toggle Toggle a config option at runtime.For example to toggle smart case search, use :toggle search.smart-case. :get-option, :get Get the current value of a config option. :sort Sort ranges in selection. :reflow Hard-wrap the current selection of lines to a given width. :tree-sitter-subtree, :ts-subtree Display the smallest tree-sitter subtree that spans the primary selection, primarily for debugging queries. :config-reload Refresh user config. :config-open Open the user config.toml file. :config-open-workspace Open the workspace config.toml file. :log-open Open the helix log file. :insert-output Run shell command, inserting output before each selection. :append-output Run shell command, appending output after each selection. :pipe, :| Pipe each selection to the shell command. :pipe-to Pipe each selection to the shell command, ignoring output. :run-shell-command, :sh, :! Run a shell command :reset-diff-change, :diffget, :diffg Reset the diff change at the cursor position. :clear-register Clear given register. If no argument is provided, clear all registers. :redraw Clear and re-render the whole UI :move, :mv Move the current buffer and its corresponding file to a different path :yank-diagnostic Yank diagnostic(s) under primary cursor to register, or clipboard by default :read, :r Load a file into buffer :echo Prints the given arguments to the statusline. :noop Does nothing.","breadcrumbs":"Usage » Commands » Typable commands","id":"59","title":"Typable commands"},"6":{"body":"Add the PPA for Helix: sudo add-apt-repository ppa:maveonair/helix-editor\\nsudo apt update\\nsudo apt install helix","breadcrumbs":"Installation » Package Managers » Ubuntu (PPA)","id":"6","title":"Ubuntu (PPA)"},"60":{"body":"Static commands take no arguments and can be bound to keys. Static commands can also be executed from the command picker (<space>?). The built-in static commands are: Name Description Default keybinds no_op Do nothing move_char_left Move left normal: h, <left>, insert: <left> move_char_right Move right normal: l, <right>, insert: <right> move_line_up Move up normal: gk move_line_down Move down normal: gj move_visual_line_up Move up normal: k, <up>, insert: <up> move_visual_line_down Move down normal: j, <down>, insert: <down> extend_char_left Extend left select: h, <left> extend_char_right Extend right select: l, <right> extend_line_up Extend up select: gk extend_line_down Extend down select: gj extend_visual_line_up Extend up select: k, <up> extend_visual_line_down Extend down select: j, <down> copy_selection_on_next_line Copy selection on next line normal: C, select: C copy_selection_on_prev_line Copy selection on previous line normal: <A-C>, select: <A-C> move_next_word_start Move to start of next word normal: w move_prev_word_start Move to start of previous word normal: b move_next_word_end Move to end of next word normal: e move_prev_word_end Move to end of previous word move_next_long_word_start Move to start of next long word normal: W move_prev_long_word_start Move to start of previous long word normal: B move_next_long_word_end Move to end of next long word normal: E move_prev_long_word_end Move to end of previous long word move_next_sub_word_start Move to start of next sub word move_prev_sub_word_start Move to start of previous sub word move_next_sub_word_end Move to end of next sub word move_prev_sub_word_end Move to end of previous sub word move_parent_node_end Move to end of the parent node normal: <A-e> move_parent_node_start Move to beginning of the parent node normal: <A-b> extend_next_word_start Extend to start of next word select: w extend_prev_word_start Extend to start of previous word select: b extend_next_word_end Extend to end of next word select: e extend_prev_word_end Extend to end of previous word extend_next_long_word_start Extend to start of next long word select: W extend_prev_long_word_start Extend to start of previous long word select: B extend_next_long_word_end Extend to end of next long word select: E extend_prev_long_word_end Extend to end of prev long word extend_next_sub_word_start Extend to start of next sub word extend_prev_sub_word_start Extend to start of previous sub word extend_next_sub_word_end Extend to end of next sub word extend_prev_sub_word_end Extend to end of prev sub word extend_parent_node_end Extend to end of the parent node select: <A-e> extend_parent_node_start Extend to beginning of the parent node select: <A-b> find_till_char Move till next occurrence of char normal: t find_next_char Move to next occurrence of char normal: f extend_till_char Extend till next occurrence of char select: t extend_next_char Extend to next occurrence of char select: f till_prev_char Move till previous occurrence of char normal: T find_prev_char Move to previous occurrence of char normal: F extend_till_prev_char Extend till previous occurrence of char select: T extend_prev_char Extend to previous occurrence of char select: F repeat_last_motion Repeat last motion normal: <A-.>, select: <A-.> replace Replace with new char normal: r, select: r switch_case Switch (toggle) case normal: ~, select: ~ switch_to_uppercase Switch to uppercase normal: <A-`>, select: <A-`> switch_to_lowercase Switch to lowercase normal: `, select: ` page_up Move page up normal: <C-b>, Z<C-b>, z<C-b>, <pageup>, Z<pageup>, z<pageup>, select: <C-b>, Z<C-b>, z<C-b>, <pageup>, Z<pageup>, z<pageup>, insert: <pageup> page_down Move page down normal: <C-f>, Z<C-f>, z<C-f>, <pagedown>, Z<pagedown>, z<pagedown>, select: <C-f>, Z<C-f>, z<C-f>, <pagedown>, Z<pagedown>, z<pagedown>, insert: <pagedown> half_page_up Move half page up half_page_down Move half page down page_cursor_up Move page and cursor up page_cursor_down Move page and cursor down page_cursor_half_up Move page and cursor half up normal: <C-u>, Z<C-u>, z<C-u>, Z<backspace>, z<backspace>, select: <C-u>, Z<C-u>, z<C-u>, Z<backspace>, z<backspace> page_cursor_half_down Move page and cursor half down normal: <C-d>, Z<C-d>, z<C-d>, Z<space>, z<space>, select: <C-d>, Z<C-d>, z<C-d>, Z<space>, z<space> select_all Select whole document normal: %, select: % select_regex Select all regex matches inside selections normal: s, select: s split_selection Split selections on regex matches normal: S, select: S split_selection_on_newline Split selection on newlines normal: <A-s>, select: <A-s> merge_selections Merge selections normal: <A-minus>, select: <A-minus> merge_consecutive_selections Merge consecutive selections normal: <A-_>, select: <A-_> search Search for regex pattern normal: /, Z/, z/, select: /, Z/, z/ rsearch Reverse search for regex pattern normal: ?, Z?, z?, select: ?, Z?, z? search_next Select next search match normal: n, Zn, zn, select: Zn, zn search_prev Select previous search match normal: N, ZN, zN, select: ZN, zN extend_search_next Add next search match to selection select: n extend_search_prev Add previous search match to selection select: N search_selection Use current selection as search pattern normal: <A-*>, select: <A-*> search_selection_detect_word_boundaries Use current selection as the search pattern, automatically wrapping with \\\\b on word boundaries normal: *, select: * make_search_word_bounded Modify current search to make it word bounded global_search Global search in workspace folder normal: <space>/, select: <space>/ extend_line Select current line, if already selected, extend to another line based on the anchor extend_line_below Select current line, if already selected, extend to next line normal: x, select: x extend_line_above Select current line, if already selected, extend to previous line select_line_above Select current line, if already selected, extend or shrink line above based on the anchor select_line_below Select current line, if already selected, extend or shrink line below based on the anchor extend_to_line_bounds Extend selection to line bounds normal: X, select: X shrink_to_line_bounds Shrink selection to line bounds normal: <A-x>, select: <A-x> delete_selection Delete selection normal: d, select: d delete_selection_noyank Delete selection without yanking normal: <A-d>, select: <A-d> change_selection Change selection normal: c, select: c change_selection_noyank Change selection without yanking normal: <A-c>, select: <A-c> collapse_selection Collapse selection into single cursor normal: ;, select: ; flip_selections Flip selection cursor and anchor normal: <A-;>, select: <A-;> ensure_selections_forward Ensure all selections face forward normal: <A-:>, select: <A-:> insert_mode Insert before selection normal: i, select: i append_mode Append after selection normal: a, select: a command_mode Enter command mode normal: :, select: : file_picker Open file picker normal: <space>f, select: <space>f file_picker_in_current_buffer_directory Open file picker at current buffer\'s directory file_picker_in_current_directory Open file picker at current working directory normal: <space>F, select: <space>F file_explorer Open file explorer in workspace root normal: <space>e, select: <space>e file_explorer_in_current_buffer_directory Open file explorer at current buffer\'s directory normal: <space>E, select: <space>E file_explorer_in_current_directory Open file explorer at current working directory code_action Perform code action normal: <space>a, select: <space>a buffer_picker Open buffer picker normal: <space>b, select: <space>b jumplist_picker Open jumplist picker normal: <space>j, select: <space>j symbol_picker Open symbol picker normal: <space>s, select: <space>s changed_file_picker Open changed file picker normal: <space>g, select: <space>g select_references_to_symbol_under_cursor Select symbol references normal: <space>h, select: <space>h workspace_symbol_picker Open workspace symbol picker normal: <space>S, select: <space>S diagnostics_picker Open diagnostic picker normal: <space>d, select: <space>d workspace_diagnostics_picker Open workspace diagnostic picker normal: <space>D, select: <space>D last_picker Open last picker normal: <space>\', select: <space>\' insert_at_line_start Insert at start of line normal: I, select: I insert_at_line_end Insert at end of line normal: A, select: A open_below Open new line below selection normal: o, select: o open_above Open new line above selection normal: O, select: O normal_mode Enter normal mode normal: <esc>, select: v, insert: <esc> select_mode Enter selection extend mode normal: v exit_select_mode Exit selection mode select: <esc> goto_definition Goto definition normal: gd, select: gd goto_declaration Goto declaration normal: gD, select: gD add_newline_above Add newline above normal: [<space>, select: [<space> add_newline_below Add newline below normal: ]<space>, select: ]<space> goto_type_definition Goto type definition normal: gy, select: gy goto_implementation Goto implementation normal: gi, select: gi goto_file_start Goto line number else file start normal: gg goto_file_end Goto file end extend_to_file_start Extend to line number else file start select: gg extend_to_file_end Extend to file end goto_file Goto files/URLs in selections normal: gf, select: gf goto_file_hsplit Goto files in selections (hsplit) normal: <C-w>f, <space>wf, select: <C-w>f, <space>wf goto_file_vsplit Goto files in selections (vsplit) normal: <C-w>F, <space>wF, select: <C-w>F, <space>wF goto_reference Goto references normal: gr, select: gr goto_window_top Goto window top normal: gt, select: gt goto_window_center Goto window center normal: gc, select: gc goto_window_bottom Goto window bottom normal: gb, select: gb goto_last_accessed_file Goto last accessed file normal: ga, select: ga goto_last_modified_file Goto last modified file normal: gm, select: gm goto_last_modification Goto last modification normal: g., select: g. goto_line Goto line normal: G, select: G goto_last_line Goto last line normal: ge extend_to_last_line Extend to last line select: ge goto_first_diag Goto first diagnostic normal: [D, select: [D goto_last_diag Goto last diagnostic normal: ]D, select: ]D goto_next_diag Goto next diagnostic normal: ]d, select: ]d goto_prev_diag Goto previous diagnostic normal: [d, select: [d goto_next_change Goto next change normal: ]g, select: ]g goto_prev_change Goto previous change normal: [g, select: [g goto_first_change Goto first change normal: [G, select: [G goto_last_change Goto last change normal: ]G, select: ]G goto_line_start Goto line start normal: gh, <home>, select: gh, insert: <home> goto_line_end Goto line end normal: gl, <end>, select: gl goto_column Goto column normal: g| extend_to_column Extend to column select: g| goto_next_buffer Goto next buffer normal: gn, select: gn goto_previous_buffer Goto previous buffer normal: gp, select: gp goto_line_end_newline Goto newline at line end insert: <end> goto_first_nonwhitespace Goto first non-blank in line normal: gs, select: gs trim_selections Trim whitespace from selections normal: _, select: _ extend_to_line_start Extend to line start select: <home> extend_to_first_nonwhitespace Extend to first non-blank in line extend_to_line_end Extend to line end select: <end> extend_to_line_end_newline Extend to line end signature_help Show signature help smart_tab Insert tab if all cursors have all whitespace to their left; otherwise, run a separate command. insert: <tab> insert_tab Insert tab char insert: <S-tab> insert_newline Insert newline char insert: <C-j>, <ret> delete_char_backward Delete previous char insert: <C-h>, <backspace>, <S-backspace> delete_char_forward Delete next char insert: <C-d>, <del> delete_word_backward Delete previous word insert: <C-w>, <A-backspace> delete_word_forward Delete next word insert: <A-d>, <A-del> kill_to_line_start Delete till start of line insert: <C-u> kill_to_line_end Delete till end of line insert: <C-k> undo Undo change normal: u, select: u redo Redo change normal: U, select: U earlier Move backward in history normal: <A-u>, select: <A-u> later Move forward in history normal: <A-U>, select: <A-U> commit_undo_checkpoint Commit changes to new checkpoint insert: <C-s> yank Yank selection normal: y, select: y yank_to_clipboard Yank selections to clipboard normal: <space>y, select: <space>y yank_to_primary_clipboard Yank selections to primary clipboard yank_joined Join and yank selections yank_joined_to_clipboard Join and yank selections to clipboard yank_main_selection_to_clipboard Yank main selection to clipboard normal: <space>Y, select: <space>Y yank_joined_to_primary_clipboard Join and yank selections to primary clipboard yank_main_selection_to_primary_clipboard Yank main selection to primary clipboard replace_with_yanked Replace with yanked text normal: R, select: R replace_selections_with_clipboard Replace selections by clipboard content normal: <space>R, select: <space>R replace_selections_with_primary_clipboard Replace selections by primary clipboard paste_after Paste after selection normal: p, select: p paste_before Paste before selection normal: P, select: P paste_clipboard_after Paste clipboard after selections normal: <space>p, select: <space>p paste_clipboard_before Paste clipboard before selections normal: <space>P, select: <space>P paste_primary_clipboard_after Paste primary clipboard after selections paste_primary_clipboard_before Paste primary clipboard before selections indent Indent selection normal: <gt>, select: <gt> unindent Unindent selection normal: <lt>, select: <lt> format_selections Format selection normal: =, select: = join_selections Join lines inside selection normal: J, select: J join_selections_space Join lines inside selection and select spaces normal: <A-J>, select: <A-J> keep_selections Keep selections matching regex normal: K, select: K remove_selections Remove selections matching regex normal: <A-K>, select: <A-K> align_selections Align selections in column normal: &, select: & keep_primary_selection Keep primary selection normal: ,, select: , remove_primary_selection Remove primary selection normal: <A-,>, select: <A-,> completion Invoke completion popup insert: <C-x> hover Show docs for item under cursor normal: <space>k, select: <space>k toggle_comments Comment/uncomment selections normal: <C-c>, <space>c, select: <C-c>, <space>c toggle_line_comments Line comment/uncomment selections normal: <space><A-c>, select: <space><A-c> toggle_block_comments Block comment/uncomment selections normal: <space>C, select: <space>C rotate_selections_forward Rotate selections forward normal: ), select: ) rotate_selections_backward Rotate selections backward normal: (, select: ( rotate_selection_contents_forward Rotate selection contents forward normal: <A-)>, select: <A-)> rotate_selection_contents_backward Rotate selections contents backward normal: <A-(>, select: <A-(> reverse_selection_contents Reverse selections contents expand_selection Expand selection to parent syntax node normal: <A-o>, <A-up>, select: <A-o>, <A-up> shrink_selection Shrink selection to previously expanded syntax node normal: <A-i>, <A-down>, select: <A-i>, <A-down> select_next_sibling Select next sibling in the syntax tree normal: <A-n>, <A-right>, select: <A-n>, <A-right> select_prev_sibling Select previous sibling the in syntax tree normal: <A-p>, <A-left>, select: <A-p>, <A-left> select_all_siblings Select all siblings of the current node normal: <A-a>, select: <A-a> select_all_children Select all children of the current node normal: <A-I>, <S-A-down>, select: <A-I>, <S-A-down> jump_forward Jump forward on jumplist normal: <C-i>, <tab>, select: <C-i>, <tab> jump_backward Jump backward on jumplist normal: <C-o>, select: <C-o> save_selection Save current selection to jumplist normal: <C-s>, select: <C-s> jump_view_right Jump to right split normal: <C-w>l, <space>wl, <C-w><C-l>, <C-w><right>, <space>w<C-l>, <space>w<right>, select: <C-w>l, <space>wl, <C-w><C-l>, <C-w><right>, <space>w<C-l>, <space>w<right> jump_view_left Jump to left split normal: <C-w>h, <space>wh, <C-w><C-h>, <C-w><left>, <space>w<C-h>, <space>w<left>, select: <C-w>h, <space>wh, <C-w><C-h>, <C-w><left>, <space>w<C-h>, <space>w<left> jump_view_up Jump to split above normal: <C-w>k, <C-w><up>, <space>wk, <C-w><C-k>, <space>w<up>, <space>w<C-k>, select: <C-w>k, <C-w><up>, <space>wk, <C-w><C-k>, <space>w<up>, <space>w<C-k> jump_view_down Jump to split below normal: <C-w>j, <space>wj, <C-w><C-j>, <C-w><down>, <space>w<C-j>, <space>w<down>, select: <C-w>j, <space>wj, <C-w><C-j>, <C-w><down>, <space>w<C-j>, <space>w<down> swap_view_right Swap with right split normal: <C-w>L, <space>wL, select: <C-w>L, <space>wL swap_view_left Swap with left split normal: <C-w>H, <space>wH, select: <C-w>H, <space>wH swap_view_up Swap with split above normal: <C-w>K, <space>wK, select: <C-w>K, <space>wK swap_view_down Swap with split below normal: <C-w>J, <space>wJ, select: <C-w>J, <space>wJ transpose_view Transpose splits normal: <C-w>t, <space>wt, <C-w><C-t>, <space>w<C-t>, select: <C-w>t, <space>wt, <C-w><C-t>, <space>w<C-t> rotate_view Goto next window normal: <C-w>w, <space>ww, <C-w><C-w>, <space>w<C-w>, select: <C-w>w, <space>ww, <C-w><C-w>, <space>w<C-w> rotate_view_reverse Goto previous window hsplit Horizontal bottom split normal: <C-w>s, <space>ws, <C-w><C-s>, <space>w<C-s>, select: <C-w>s, <space>ws, <C-w><C-s>, <space>w<C-s> hsplit_new Horizontal bottom split scratch buffer normal: <C-w>ns, <space>wns, <C-w>n<C-s>, <space>wn<C-s>, select: <C-w>ns, <space>wns, <C-w>n<C-s>, <space>wn<C-s> vsplit Vertical right split normal: <C-w>v, <space>wv, <C-w><C-v>, <space>w<C-v>, select: <C-w>v, <space>wv, <C-w><C-v>, <space>w<C-v> vsplit_new Vertical right split scratch buffer normal: <C-w>nv, <space>wnv, <C-w>n<C-v>, <space>wn<C-v>, select: <C-w>nv, <space>wnv, <C-w>n<C-v>, <space>wn<C-v> wclose Close window normal: <C-w>q, <space>wq, <C-w><C-q>, <space>w<C-q>, select: <C-w>q, <space>wq, <C-w><C-q>, <space>w<C-q> wonly Close windows except current normal: <C-w>o, <space>wo, <C-w><C-o>, <space>w<C-o>, select: <C-w>o, <space>wo, <C-w><C-o>, <space>w<C-o> select_register Select register normal: \\", select: \\" insert_register Insert register insert: <C-r> copy_between_registers Copy between two registers align_view_middle Align view middle normal: Zm, zm, select: Zm, zm align_view_top Align view top normal: Zt, zt, select: Zt, zt align_view_center Align view center normal: Zc, Zz, zc, zz, select: Zc, Zz, zc, zz align_view_bottom Align view bottom normal: Zb, zb, select: Zb, zb scroll_up Scroll view up normal: Zk, zk, Z<up>, z<up>, select: Zk, zk, Z<up>, z<up> scroll_down Scroll view down normal: Zj, zj, Z<down>, z<down>, select: Zj, zj, Z<down>, z<down> match_brackets Goto matching bracket normal: mm, select: mm surround_add Surround add normal: ms, select: ms surround_replace Surround replace normal: mr, select: mr surround_delete Surround delete normal: md, select: md select_textobject_around Select around object normal: ma, select: ma select_textobject_inner Select inside object normal: mi, select: mi goto_next_function Goto next function normal: ]f, select: ]f goto_prev_function Goto previous function normal: [f, select: [f goto_next_class Goto next type definition normal: ]t, select: ]t goto_prev_class Goto previous type definition normal: [t, select: [t goto_next_parameter Goto next parameter normal: ]a, select: ]a goto_prev_parameter Goto previous parameter normal: [a, select: [a goto_next_comment Goto next comment normal: ]c, select: ]c goto_prev_comment Goto previous comment normal: [c, select: [c goto_next_test Goto next test normal: ]T, select: ]T goto_prev_test Goto previous test normal: [T, select: [T goto_next_entry Goto next pairing normal: ]e, select: ]e goto_prev_entry Goto previous pairing normal: [e, select: [e goto_next_paragraph Goto next paragraph normal: ]p, select: ]p goto_prev_paragraph Goto previous paragraph normal: [p, select: [p dap_launch Launch debug target normal: <space>Gl, select: <space>Gl dap_restart Restart debugging session normal: <space>Gr, select: <space>Gr dap_toggle_breakpoint Toggle breakpoint normal: <space>Gb, select: <space>Gb dap_continue Continue program execution normal: <space>Gc, select: <space>Gc dap_pause Pause program execution normal: <space>Gh, select: <space>Gh dap_step_in Step in normal: <space>Gi, select: <space>Gi dap_step_out Step out normal: <space>Go, select: <space>Go dap_next Step to next normal: <space>Gn, select: <space>Gn dap_variables List variables normal: <space>Gv, select: <space>Gv dap_terminate End debug session normal: <space>Gt, select: <space>Gt dap_edit_condition Edit breakpoint condition on current line normal: <space>G<C-c>, select: <space>G<C-c> dap_edit_log Edit breakpoint log message on current line normal: <space>G<C-l>, select: <space>G<C-l> dap_switch_thread Switch current thread normal: <space>Gst, select: <space>Gst dap_switch_stack_frame Switch stack frame normal: <space>Gsf, select: <space>Gsf dap_enable_exceptions Enable exception breakpoints normal: <space>Ge, select: <space>Ge dap_disable_exceptions Disable exception breakpoints normal: <space>GE, select: <space>GE shell_pipe Pipe selections through shell command normal: |, select: | shell_pipe_to Pipe selections into shell command ignoring output normal: <A-|>, select: <A-|> shell_insert_output Insert shell command output before selections normal: !, select: ! shell_append_output Append shell command output after selections normal: <A-!>, select: <A-!> shell_keep_pipe Filter selections with shell predicate normal: $, select: $ suspend Suspend and return to shell normal: <C-z>, select: <C-z> rename_symbol Rename symbol normal: <space>r, select: <space>r increment Increment item under cursor normal: <C-a>, select: <C-a> decrement Decrement item under cursor normal: <C-x>, select: <C-x> record_macro Record macro normal: Q, select: Q replay_macro Replay macro normal: q, select: q command_palette Open command palette normal: <space>?, select: <space>? goto_word Jump to a two-character label normal: gw extend_to_word Extend to a two-character label select: gw goto_next_tabstop Goto next snippet placeholder goto_prev_tabstop Goto next snippet placeholder rotate_selections_first Make the first selection your primary one rotate_selections_last Make the last selection your primary one","breadcrumbs":"Usage » Commands » Static Commands","id":"60","title":"Static Commands"},"61":{"body":"The following languages and Language Servers are supported. To use Language Server features, you must first configure the appropriate Language Server. You can check the language support in your installed helix version with hx --health. Also see the Language Configuration docs and the Adding Languages guide for more language configuration information. Language Syntax Highlighting Treesitter Textobjects Auto Indent Default language servers ada ✓ ✓ ada_language_server adl ✓ ✓ ✓ agda ✓ alloy ✓ amber ✓ amber-lsp astro ✓ astro-ls awk ✓ ✓ awk-language-server bash ✓ ✓ ✓ bash-language-server bass ✓ bass beancount ✓ beancount-language-server bibtex ✓ texlab bicep ✓ bicep-langserver bitbake ✓ bitbake-language-server blade ✓ blueprint ✓ blueprint-compiler c ✓ ✓ ✓ clangd c-sharp ✓ ✓ OmniSharp cabal haskell-language-server-wrapper caddyfile ✓ ✓ ✓ cairo ✓ ✓ ✓ cairo-language-server capnp ✓ ✓ cel ✓ circom ✓ circom-lsp clarity ✓ clarinet clojure ✓ clojure-lsp cmake ✓ ✓ ✓ neocmakelsp, cmake-language-server codeql ✓ ✓ codeql comment ✓ common-lisp ✓ ✓ cl-lsp cpon ✓ ✓ cpp ✓ ✓ ✓ clangd crystal ✓ ✓ ✓ crystalline, ameba-ls css ✓ ✓ vscode-css-language-server csv ✓ cue ✓ cuelsp cylc ✓ ✓ ✓ d ✓ ✓ ✓ serve-d dart ✓ ✓ ✓ dart dbml ✓ debian ✓ devicetree ✓ dts-lsp dhall ✓ ✓ dhall-lsp-server diff ✓ djot ✓ docker-compose ✓ ✓ ✓ docker-compose-langserver, yaml-language-server dockerfile ✓ ✓ docker-langserver dot ✓ dot-language-server dtd ✓ dune ✓ dunstrc ✓ earthfile ✓ ✓ ✓ earthlyls edoc ✓ eex ✓ ejs ✓ elisp ✓ elixir ✓ ✓ ✓ elixir-ls elm ✓ ✓ elm-language-server elvish ✓ elvish env ✓ ✓ erb ✓ erlang ✓ ✓ erlang_ls, elp esdl ✓ fennel ✓ fennel-ls fga ✓ ✓ ✓ fidl ✓ fish ✓ ✓ ✓ fish-lsp forth ✓ forth-lsp fortran ✓ ✓ fortls fsharp ✓ fsautocomplete gas ✓ ✓ asm-lsp gdscript ✓ ✓ ✓ gemini ✓ gherkin ✓ ghostty ✓ git-attributes ✓ git-commit ✓ ✓ git-config ✓ ✓ git-ignore ✓ git-notes ✓ git-rebase ✓ gjs ✓ ✓ ✓ typescript-language-server, vscode-eslint-language-server, ember-language-server gleam ✓ ✓ gleam glimmer ✓ ember-language-server glsl ✓ ✓ ✓ glsl_analyzer gn ✓ go ✓ ✓ ✓ gopls, golangci-lint-langserver godot-resource ✓ ✓ gomod ✓ gopls gotmpl ✓ gopls gowork ✓ gopls gpr ✓ ada_language_server graphql ✓ ✓ graphql-lsp gren ✓ ✓ groovy ✓ gts ✓ ✓ ✓ typescript-language-server, vscode-eslint-language-server, ember-language-server hare ✓ haskell ✓ ✓ haskell-language-server-wrapper haskell-persistent ✓ hcl ✓ ✓ ✓ terraform-ls heex ✓ ✓ elixir-ls helm ✓ helm_ls hocon ✓ ✓ ✓ hoon ✓ hosts ✓ html ✓ vscode-html-language-server, superhtml htmldjango ✓ djlsp, vscode-html-language-server, superhtml hurl ✓ ✓ ✓ hyprlang ✓ ✓ hyprls idris idris2-lsp iex ✓ ini ✓ ink ✓ inko ✓ ✓ ✓ janet ✓ java ✓ ✓ ✓ jdtls javascript ✓ ✓ ✓ typescript-language-server jinja ✓ jjdescription ✓ jq ✓ ✓ jq-lsp jsdoc ✓ json ✓ ✓ ✓ vscode-json-language-server json-ld ✓ ✓ ✓ vscode-json-language-server json5 ✓ jsonc ✓ ✓ vscode-json-language-server jsonnet ✓ jsonnet-language-server jsx ✓ ✓ ✓ typescript-language-server julia ✓ ✓ ✓ julia just ✓ ✓ ✓ just-lsp kdl ✓ ✓ ✓ koka ✓ ✓ koka kotlin ✓ ✓ ✓ kotlin-language-server koto ✓ ✓ ✓ koto-ls latex ✓ ✓ texlab ld ✓ ✓ ldif ✓ lean ✓ lean ledger ✓ llvm ✓ ✓ ✓ llvm-mir ✓ ✓ ✓ llvm-mir-yaml ✓ ✓ log ✓ lpf ✓ lua ✓ ✓ ✓ lua-language-server luau ✓ ✓ ✓ luau-lsp mail ✓ ✓ make ✓ ✓ markdoc ✓ markdoc-ls markdown ✓ marksman, markdown-oxide markdown-rustdoc ✓ markdown.inline ✓ matlab ✓ ✓ ✓ mermaid ✓ meson ✓ ✓ mesonlsp mint mint mojo ✓ ✓ ✓ pixi move ✓ msbuild ✓ ✓ nasm ✓ ✓ asm-lsp nestedtext ✓ ✓ ✓ nginx ✓ nickel ✓ ✓ nls nim ✓ ✓ ✓ nimlangserver nix ✓ ✓ ✓ nil, nixd nu ✓ nu nunjucks ✓ ocaml ✓ ✓ ocamllsp ocaml-interface ✓ ocamllsp odin ✓ ✓ ✓ ols ohm ✓ ✓ ✓ opencl ✓ ✓ ✓ clangd openscad ✓ openscad-lsp org ✓ pascal ✓ ✓ pasls passwd ✓ pem ✓ perl ✓ ✓ ✓ perlnavigator pest ✓ ✓ ✓ pest-language-server php ✓ ✓ ✓ intelephense php-only ✓ pkgbuild ✓ ✓ ✓ termux-language-server, bash-language-server pkl ✓ ✓ pkl-lsp po ✓ ✓ pod ✓ ponylang ✓ ✓ ✓ powershell ✓ prisma ✓ ✓ prisma-language-server prolog ✓ ✓ swipl properties ✓ ✓ protobuf ✓ ✓ ✓ buf, pb, protols prql ✓ pug ✓ purescript ✓ ✓ purescript-language-server python ✓ ✓ ✓ ty, ruff, jedi-language-server, pylsp qml ✓ ✓ ✓ qmlls quarto ✓ ✓ quint ✓ quint-language-server r ✓ R racket ✓ ✓ racket regex ✓ rego ✓ regols rescript ✓ ✓ rescript-language-server rmarkdown ✓ ✓ R robot ✓ robotframework_ls ron ✓ ✓ rst ✓ ruby ✓ ✓ ✓ ruby-lsp, solargraph rust ✓ ✓ ✓ rust-analyzer rust-format-args ✓ rust-format-args-macro ✓ ✓ ✓ sage ✓ ✓ scala ✓ ✓ ✓ metals scheme ✓ ✓ scss ✓ vscode-css-language-server slang ✓ ✓ ✓ slangd slint ✓ ✓ ✓ slint-lsp smali ✓ ✓ smithy ✓ cs sml ✓ snakemake ✓ ✓ pylsp solidity ✓ ✓ solc sourcepawn ✓ ✓ sourcepawn-studio spade ✓ ✓ spade-language-server spicedb ✓ sql ✓ ✓ sshclientconfig ✓ starlark ✓ ✓ ✓ starpls strace ✓ supercollider ✓ svelte ✓ ✓ svelteserver sway ✓ ✓ ✓ forc swift ✓ ✓ sourcekit-lsp systemd ✓ systemd-lsp t32 ✓ tablegen ✓ ✓ ✓ tact ✓ ✓ ✓ task ✓ tcl ✓ ✓ teal ✓ teal-language-server templ ✓ templ tera ✓ textproto ✓ ✓ ✓ tfvars ✓ ✓ terraform-ls thrift ✓ tlaplus ✓ todotxt ✓ toml ✓ ✓ taplo, tombi tsq ✓ ts_query_ls tsx ✓ ✓ ✓ typescript-language-server twig ✓ typescript ✓ ✓ ✓ typescript-language-server typespec ✓ ✓ ✓ tsp-server typst ✓ tinymist ungrammar ✓ unison ✓ ✓ ✓ uxntal ✓ v ✓ ✓ ✓ v-analyzer vala ✓ ✓ vala-language-server vento ✓ verilog ✓ ✓ svlangserver vhdl ✓ vhdl_ls vhs ✓ vue ✓ vue-language-server wast ✓ wat ✓ wat_server webc ✓ werk ✓ wesl ✓ ✓ wgsl ✓ wgsl-analyzer wit ✓ ✓ wren ✓ ✓ ✓ xit ✓ xml ✓ ✓ xtc ✓ yaml ✓ ✓ ✓ yaml-language-server, ansible-language-server yara ✓ yls yuck ✓ zig ✓ ✓ ✓ zls","breadcrumbs":"Usage » Language support » Language Support","id":"61","title":"Language Support"},"62":{"body":"This section has information related to the wider Helix ecosystem.","breadcrumbs":"Ecosystem » Ecosystem","id":"62","title":"Ecosystem"},"63":{"body":"Helix\'s editing model is strongly inspired from Vim and Kakoune, and a notable difference from Vim (and the most striking similarity to Kakoune) is that Helix follows the selection → action model. This means that whatever you are going to act on (a word, a paragraph, a line, etc.) is selected first and the action itself (delete, change, yank, etc.) comes second. A cursor is simply a single width selection. See also Kakoune\'s Migrating from Vim and Helix\'s Migrating from Vim . TODO: Mention textobjects, surround, registers","breadcrumbs":"Ecosystem » Migrating from Vim » Migrating from Vim","id":"63","title":"Migrating from Vim"},"64":{"body":"Helix\' keymap and interaction model ( Using Helix ) is easier to adopt if it can be used consistently in many editing contexts. Yet, certain use cases cannot easily be addressed directly in Helix. Similar to vim, this leads to the creation of \\"Helix mode\\" in various other software products, allowing Helix-style editing for a greater variety of use cases. \\"Helix mode\\" is frequently still in early stages or missing entirely. For such cases, we also link to relevant bugs or discussions.","breadcrumbs":"Ecosystem » Helix mode in other software » Helix mode in other software","id":"64","title":"Helix mode in other software"},"65":{"body":"Editor Plugin or feature providing Helix editing Comments Vim helix.vim config IntelliJ IDEA / Android Studio IdeaVim plugin + helix.idea.vim config Minimum recommended version is IdeaVim 2.19.0. Visual Studio VsVim plugin + helix.vs.vim config Visual Studio Code Dance extension, or its Helix fork The Helix fork has diverged. You can also use the original Dance and tweak its keybindings directly (try this config ). Visual Studio Code Helix for VS Code extension Zed native via keybindings ( Bug ) CodeMirror codemirror-helix","breadcrumbs":"Ecosystem » Helix mode in other software » Other editors","id":"65","title":"Other editors"},"66":{"body":"Shell Plugin or feature providing Helix editing Fish Feature Request Fish fish-helix Zsh helix-zsh or zsh-helix-mode Nushell Feature Request","breadcrumbs":"Ecosystem » Helix mode in other software » Shells","id":"66","title":"Shells"},"67":{"body":"Software Plugin or feature providing Helix editing. Comments Obsidian Obsidian-Helix Uses codemirror-helix listed above.","breadcrumbs":"Ecosystem » Helix mode in other software » Other software","id":"67","title":"Other software"},"68":{"body":"To override global configuration parameters, create a config.toml file located in your config directory: Linux and Mac: ~/.config/helix/config.toml Windows: %AppData%\\\\helix\\\\config.toml 💡 You can easily open the config file by typing :config-open within Helix normal mode. Example config: theme = \\"onedark\\" [editor]\\nline-number = \\"relative\\"\\nmouse = false [editor.cursor-shape]\\ninsert = \\"bar\\"\\nnormal = \\"block\\"\\nselect = \\"underline\\" [editor.file-picker]\\nhidden = false You can use a custom configuration file by specifying it with the -c or --config command line argument, for example hx -c path/to/custom-config.toml. You can reload the config file by issuing the :config-reload command. Alternatively, on Unix operating systems, you can reload it by sending the USR1 signal to the Helix process, such as by using the command pkill -USR1 hx. Finally, you can have a config.toml local to a project by putting it under a .helix directory in your repository. Its settings will be merged with the configuration directory config.toml and the built-in configuration.","breadcrumbs":"Configuration » Configuration","id":"68","title":"Configuration"},"69":{"body":"[editor] Section [editor.clipboard-provider] Section [editor.statusline] Section [editor.lsp] Section [editor.cursor-shape] Section [editor.file-picker] Section [editor.auto-pairs] Section [editor.auto-save] Section [editor.search] Section [editor.whitespace] Section [editor.indent-guides] Section [editor.gutters] Section [editor.gutters.line-numbers] Section [editor.gutters.diagnostics] Section [editor.gutters.diff] Section [editor.gutters.spacer] Section [editor.soft-wrap] Section [editor.smart-tab] Section [editor.inline-diagnostics] Section","breadcrumbs":"Configuration » Editor » Editor","id":"69","title":"Editor"},"7":{"body":"sudo dnf install helix","breadcrumbs":"Installation » Package Managers » Fedora/RHEL","id":"7","title":"Fedora/RHEL"},"70":{"body":"Key Description Default scrolloff Number of lines of padding around the edge of the screen when scrolling 5 mouse Enable mouse mode true default-yank-register Default register used for yank/paste \\" middle-click-paste Middle click paste support true scroll-lines Number of lines to scroll per scroll wheel step 3 shell Shell to use when running external commands Unix: [\\"sh\\", \\"-c\\"]Windows: [\\"cmd\\", \\"/C\\"] line-number Line number display: absolute simply shows each line\'s number, while relative shows the distance from the current line. When unfocused or in insert mode, relative will still show absolute line numbers absolute cursorline Highlight all lines with a cursor false cursorcolumn Highlight all columns with a cursor false continue-comments if helix should automatically add a line comment token if you create a new line inside a comment. true gutters Gutters to display: Available are diagnostics and diff and line-numbers and spacer, note that diagnostics also includes other features like breakpoints, 1-width padding will be inserted if gutters is non-empty [\\"diagnostics\\", \\"spacer\\", \\"line-numbers\\", \\"spacer\\", \\"diff\\"] auto-completion Enable automatic pop up of auto-completion true path-completion Enable filepath completion. Show files and directories if an existing path at the cursor was recognized, either absolute or relative to the current opened document or current working directory (if the buffer is not yet saved). Defaults to true. true auto-format Enable automatic formatting on save true idle-timeout Time in milliseconds since last keypress before idle timers trigger. 250 completion-timeout Time in milliseconds after typing a word character before completions are shown, set to 5 for instant. 250 preview-completion-insert Whether to apply completion item instantly when selected true completion-trigger-len The min-length of word under cursor to trigger autocompletion 2 completion-replace Set to true to make completions always replace the entire word and not just the part before the cursor false auto-info Whether to display info boxes true true-color Set to true to override automatic detection of terminal truecolor support in the event of a false negative false undercurl Set to true to override automatic detection of terminal undercurl support in the event of a false negative false rulers List of column positions at which to display the rulers. Can be overridden by language specific rulers in languages.toml file [] bufferline Renders a line at the top of the editor displaying open buffers. Can be always, never or multiple (only shown if more than one buffer is in use) never color-modes Whether to color the mode indicator with different colors depending on the mode itself false text-width Maximum line length. Used for the :reflow command and soft-wrapping if soft-wrap.wrap-at-text-width is set 80 workspace-lsp-roots Directories relative to the workspace root that are treated as LSP roots. Should only be set in .helix/config.toml [] default-line-ending The line ending to use for new documents. Can be native, lf, crlf, ff, cr or nel. native uses the platform\'s native line ending (crlf on Windows, otherwise lf). native insert-final-newline Whether to automatically insert a trailing line-ending on write if missing true atomic-save Whether to use atomic operations to write documents to disk. This prevents data loss if the editor is interrupted while writing the file, but may confuse some file watching/hot reloading programs. true trim-final-newlines Whether to automatically remove line-endings after the final one on write false trim-trailing-whitespace Whether to automatically remove whitespace preceding line endings on write false popup-border Draw border around popup, menu, all, or none none indent-heuristic How the indentation for a newly inserted line is computed: simple just copies the indentation level from the previous line, tree-sitter computes the indentation based on the syntax tree and hybrid combines both approaches. If the chosen heuristic is not available, a different one will be used as a fallback (the fallback order being hybrid -> tree-sitter -> simple). hybrid jump-label-alphabet The characters that are used to generate two character jump labels. Characters at the start of the alphabet are used first. \\"abcdefghijklmnopqrstuvwxyz\\" end-of-line-diagnostics Minimum severity of diagnostics to render at the end of the line. Set to disable to disable entirely. Refer to the setting about inline-diagnostics for more details \\"disable\\" clipboard-provider Which API to use for clipboard interaction. One of pasteboard (MacOS), wayland, x-clip, x-sel, win-32-yank, termux, tmux, windows, termcode, none, or a custom command set. Platform and environment specific. editor-config Whether to read settings from EditorConfig files true","breadcrumbs":"Configuration » Editor » [editor] Section","id":"70","title":"[editor] Section"},"71":{"body":"Helix can be configured either to use a builtin clipboard configuration or to use a provided command. For instance, setting it to use OSC 52 termcodes, the configuration would be: [editor]\\nclipboard-provider = \\"termcode\\" Alternatively, Helix can be configured to use arbitrary commands for clipboard integration: [editor.clipboard-provider.custom]\\nyank = { command = \\"cat\\", args = [\\"test.txt\\"] }\\npaste = { command = \\"tee\\", args = [\\"test.txt\\"] }\\nprimary-yank = { command = \\"cat\\", args = [\\"test-primary.txt\\"] } # optional\\nprimary-paste = { command = \\"tee\\", args = [\\"test-primary.txt\\"] } # optional For custom commands the contents of the yank/paste is communicated over stdin/stdout.","breadcrumbs":"Configuration » Editor » [editor.clipboard-provider] Section","id":"71","title":"[editor.clipboard-provider] Section"},"72":{"body":"Allows configuring the statusline at the bottom of the editor. The configuration distinguishes between three areas of the status line: [ ... ... LEFT ... ... | ... ... ... CENTER ... ... ... | ... ... RIGHT ... ... ] Statusline elements can be defined as follows: [editor.statusline]\\nleft = [\\"mode\\", \\"spinner\\"]\\ncenter = [\\"file-name\\"]\\nright = [\\"diagnostics\\", \\"selections\\", \\"position\\", \\"file-encoding\\", \\"file-line-ending\\", \\"file-type\\"]\\nseparator = \\"│\\"\\nmode.normal = \\"NORMAL\\"\\nmode.insert = \\"INSERT\\"\\nmode.select = \\"SELECT\\"\\ndiagnostics = [\\"warning\\", \\"error\\"]\\nworkspace-diagnostics = [\\"warning\\", \\"error\\"] The [editor.statusline] key takes the following sub-keys: Key Description Default left A list of elements aligned to the left of the statusline [\\"mode\\", \\"spinner\\", \\"file-name\\", \\"read-only-indicator\\", \\"file-modification-indicator\\"] center A list of elements aligned to the middle of the statusline [] right A list of elements aligned to the right of the statusline [\\"diagnostics\\", \\"selections\\", \\"register\\", \\"position\\", \\"file-encoding\\"] separator The character used to separate elements in the statusline \\"│\\" mode.normal The text shown in the mode element for normal mode \\"NOR\\" mode.insert The text shown in the mode element for insert mode \\"INS\\" mode.select The text shown in the mode element for select mode \\"SEL\\" diagnostics A list of severities which are displayed for the current buffer [\\"warning\\", \\"error\\"] workspace-diagnostics A list of severities which are displayed for the workspace [\\"warning\\", \\"error\\"] The following statusline elements can be configured: Key Description mode The current editor mode (mode.normal/mode.insert/mode.select) spinner A progress spinner indicating LSP activity file-name The path/name of the opened file file-absolute-path The absolute path/name of the opened file file-base-name The basename of the opened file file-modification-indicator The indicator to show whether the file is modified (a [+] appears when there are unsaved changes) file-encoding The encoding of the opened file if it differs from UTF-8 file-line-ending The file line endings (CRLF or LF) file-indent-style The file indentation style read-only-indicator An indicator that shows [readonly] when a file cannot be written total-line-numbers The total line numbers of the opened file file-type The type of the opened file diagnostics The number of warnings and/or errors workspace-diagnostics The number of warnings and/or errors on workspace selections The primary selection index out of the number of active selections primary-selection-length The number of characters currently in primary selection position The cursor position position-percentage The cursor position as a percentage of the total number of lines separator The string defined in editor.statusline.separator (defaults to \\"│\\") spacer Inserts a space between elements (multiple/contiguous spacers may be specified) version-control The current branch name or detached commit hash of the opened workspace register The current selected register","breadcrumbs":"Configuration » Editor » [editor.statusline] Section","id":"72","title":"[editor.statusline] Section"},"73":{"body":"Key Description Default enable Enables LSP integration. Setting to false will completely disable language servers regardless of language settings. true display-messages Display LSP window/showMessage messages below statusline [1] true display-progress-messages Display LSP progress messages below statusline [1] false auto-signature-help Enable automatic popup of signature help (parameter hints) true display-inlay-hints Display inlay hints [2] false inlay-hints-length-limit Maximum displayed length (non-zero number) of inlay hints Unset by default display-color-swatches Show color swatches next to colors true display-signature-help-docs Display docs under signature help popup true snippets Enables snippet completions. Requires a server restart (:lsp-restart) to take effect after :config-reload/:set. true goto-reference-include-declaration Include declaration in the goto references popup. true By default, a progress spinner is shown in the statusline beside the file path. You may also have to activate them in the language server config for them to appear, not just in Helix. Inlay hints in Helix are still being improved on and may be a little bit laggy/janky under some circumstances. Please report any bugs you see so we can fix them!","breadcrumbs":"Configuration » Editor » [editor.lsp] Section","id":"73","title":"[editor.lsp] Section"},"74":{"body":"Defines the shape of cursor in each mode. Valid values for these options are block, bar, underline, or hidden. 💡 Due to limitations of the terminal environment, only the primary cursor can change shape. Key Description Default normal Cursor shape in normal mode block insert Cursor shape in insert mode block select Cursor shape in select mode block","breadcrumbs":"Configuration » Editor » [editor.cursor-shape] Section","id":"74","title":"[editor.cursor-shape] Section"},"75":{"body":"Set options for file picker and global search. Ignoring a file means it is not visible in the Helix file picker and global search. All git related options are only enabled in a git repository. Key Description Default hidden Enables ignoring hidden files true follow-symlinks Follow symlinks instead of ignoring them true deduplicate-links Ignore symlinks that point at files already shown in the picker true parents Enables reading ignore files from parent directories true ignore Enables reading .ignore files true git-ignore Enables reading .gitignore files true git-global Enables reading global .gitignore, whose path is specified in git\'s config: core.excludesfile option true git-exclude Enables reading .git/info/exclude files true max-depth Set with an integer value for maximum depth to recurse Unset by default Ignore files can be placed locally as .ignore or put in your home directory as ~/.ignore. They support the usual ignore and negative ignore (unignore) rules used in .gitignore files. Additionally, you can use Helix-specific ignore files by creating a local .helix/ignore file in the current workspace or a global ignore file located in your Helix config directory: Linux and Mac: ~/.config/helix/ignore Windows: %AppData%\\\\helix\\\\ignore Example: # unignore in file picker and global search\\n!.github/\\n!.gitignore\\n!.gitattributes","breadcrumbs":"Configuration » Editor » [editor.file-picker] Section","id":"75","title":"[editor.file-picker] Section"},"76":{"body":"Enables automatic insertion of pairs to parentheses, brackets, etc. Can be a simple boolean value, or a specific mapping of pairs of single characters. To disable auto-pairs altogether, set auto-pairs to false: [editor]\\nauto-pairs = false # defaults to `true` The default pairs are (){}[]\'\'\\"\\"``, but these can be customized by setting auto-pairs to a TOML table: [editor.auto-pairs]\\n\'(\' = \')\'\\n\'{\' = \'}\'\\n\'[\' = \']\'\\n\'\\"\' = \'\\"\'\\n\'`\' = \'`\'\\n\'<\' = \'>\' Additionally, this setting can be used in a language config. Unless the editor setting is false, this will override the editor config in documents with this language. Example languages.toml that adds <> and removes \'\' [[language]]\\nname = \\"rust\\" [language.auto-pairs]\\n\'(\' = \')\'\\n\'{\' = \'}\'\\n\'[\' = \']\'\\n\'\\"\' = \'\\"\'\\n\'`\' = \'`\'\\n\'<\' = \'>\'","breadcrumbs":"Configuration » Editor » [editor.auto-pairs] Section","id":"76","title":"[editor.auto-pairs] Section"},"77":{"body":"Control auto save behavior. Key Description Default focus-lost Enable automatic saving on the focus moving away from Helix. Requires focus event support from your terminal false after-delay.enable Enable automatic saving after auto-save.after-delay.timeout milliseconds have passed since last edit. false after-delay.timeout Time in milliseconds since last edit before auto save timer triggers. 3000","breadcrumbs":"Configuration » Editor » [editor.auto-save] Section","id":"77","title":"[editor.auto-save] Section"},"78":{"body":"Search specific options. Key Description Default smart-case Enable smart case regex searching (case-insensitive unless pattern contains upper case characters) true wrap-around Whether the search should wrap after depleting the matches true","breadcrumbs":"Configuration » Editor » [editor.search] Section","id":"78","title":"[editor.search] Section"},"79":{"body":"Options for rendering whitespace with visible characters. Use :set whitespace.render all to temporarily enable visible whitespace. Key Description Default render Whether to render whitespace. May either be all or none, or a table with sub-keys space, nbsp, nnbsp, tab, and newline none characters Literal characters to use when rendering whitespace. Sub-keys may be any of tab, space, nbsp, nnbsp, newline or tabpad See example below Example [editor.whitespace]\\nrender = \\"all\\"\\n# or control each character\\n[editor.whitespace.render]\\nspace = \\"all\\"\\ntab = \\"all\\"\\nnbsp = \\"none\\"\\nnnbsp = \\"none\\"\\nnewline = \\"none\\" [editor.whitespace.characters]\\nspace = \\"·\\"\\nnbsp = \\"⍽\\"\\nnnbsp = \\"␣\\"\\ntab = \\"→\\"\\nnewline = \\"⏎\\"\\ntabpad = \\"·\\" # Tabs will look like \\"→···\\" (depending on tab width)","breadcrumbs":"Configuration » Editor » [editor.whitespace] Section","id":"79","title":"[editor.whitespace] Section"},"8":{"body":"Releases are available in the extra repository: sudo pacman -S helix 💡 When installed from the extra repository, run Helix with helix instead of hx. For example: helix --health to check health Additionally, a helix-git package is available in the AUR, which builds the master branch.","breadcrumbs":"Installation » Package Managers » Arch Linux extra","id":"8","title":"Arch Linux extra"},"80":{"body":"Options for rendering vertical indent guides. Key Description Default render Whether to render indent guides false character Literal character to use for rendering the indent guide │ skip-levels Number of indent levels to skip 0 Example: [editor.indent-guides]\\nrender = true\\ncharacter = \\"╎\\" # Some characters that work well: \\"▏\\", \\"┆\\", \\"┊\\", \\"⸽\\"\\nskip-levels = 1","breadcrumbs":"Configuration » Editor » [editor.indent-guides] Section","id":"80","title":"[editor.indent-guides] Section"},"81":{"body":"For simplicity, editor.gutters accepts an array of gutter types, which will use default settings for all gutter components. [editor]\\ngutters = [\\"diff\\", \\"diagnostics\\", \\"line-numbers\\", \\"spacer\\"] To customize the behavior of gutters, the [editor.gutters] section must be used. This section contains top level settings, as well as settings for specific gutter components as subsections. Key Description Default layout A vector of gutters to display [\\"diagnostics\\", \\"spacer\\", \\"line-numbers\\", \\"spacer\\", \\"diff\\"] Example: [editor.gutters]\\nlayout = [\\"diff\\", \\"diagnostics\\", \\"line-numbers\\", \\"spacer\\"] [editor.gutters.line-numbers] Section Options for the line number gutter Key Description Default min-width The minimum number of characters to use 3 Example: [editor.gutters.line-numbers]\\nmin-width = 1 [editor.gutters.diagnostics] Section Currently unused [editor.gutters.diff] Section The diff gutter option displays colored bars indicating whether a git diff represents that a line was added, removed or changed. These colors are controlled by the theme attributes diff.plus, diff.minus and diff.delta. Other diff providers will eventually be supported by a future plugin system. There are currently no options for this section. [editor.gutters.spacer] Section Currently unused","breadcrumbs":"Configuration » Editor » [editor.gutters] Section","id":"81","title":"[editor.gutters] Section"},"82":{"body":"Options for soft wrapping lines that exceed the view width: Key Description Default enable Whether soft wrapping is enabled. false max-wrap Maximum free space left at the end of the line. 20 max-indent-retain Maximum indentation to carry over when soft wrapping a line. 40 wrap-indicator Text inserted before soft wrapped lines, highlighted with ui.virtual.wrap ↪ wrap-at-text-width Soft wrap at text-width instead of using the full viewport size. false Example: [editor.soft-wrap]\\nenable = true\\nmax-wrap = 25 # increase value to reduce forced mid-word wrapping\\nmax-indent-retain = 0\\nwrap-indicator = \\"\\" # set wrap-indicator to \\"\\" to hide it","breadcrumbs":"Configuration » Editor » [editor.soft-wrap] Section","id":"82","title":"[editor.soft-wrap] Section"},"83":{"body":"Options for navigating and editing using tab key. Key Description Default enable If set to true, then when the cursor is in a position with non-whitespace to its left, instead of inserting a tab, it will run move_parent_node_end. If there is only whitespace to the left, then it inserts a tab as normal. With the default bindings, to explicitly insert a tab character, press Shift-tab. true supersede-menu Normally, when a menu is on screen, such as when auto complete is triggered, the tab key is bound to cycling through the items. This means when menus are on screen, one cannot use the tab key to trigger the smart-tab command. If this option is set to true, the smart-tab command always takes precedence, which means one cannot use the tab key to cycle through menu items. One of the other bindings must be used instead, such as arrow keys or C-n/C-p. false Due to lack of support for S-tab in some terminals, the default keybindings don\'t fully embrace smart-tab editing experience. If you enjoy smart-tab navigation and a terminal that supports the Enhanced Keyboard protocol , consider setting extra keybindings: [keys.normal]\\ntab = \\"move_parent_node_end\\"\\nS-tab = \\"move_parent_node_start\\" [keys.insert]\\nS-tab = \\"move_parent_node_start\\" [keys.select]\\ntab = \\"extend_parent_node_end\\"\\nS-tab = \\"extend_parent_node_start\\"","breadcrumbs":"Configuration » Editor » [editor.smart-tab] Section","id":"83","title":"[editor.smart-tab] Section"},"84":{"body":"Options for rendering diagnostics inside the text like shown below fn main() { let foo = bar; └─ no such value in this scope\\n} Key Description Default cursor-line The minimum severity that a diagnostic must have to be shown inline on the line that contains the primary cursor. Set to disable to not show any diagnostics inline. This option does not have any effect when in insert-mode and will only take effect 350ms after moving the cursor to a different line. \\"disable\\" other-lines The minimum severity that a diagnostic must have to be shown inline on a line that does not contain the cursor-line. Set to disable to not show any diagnostics inline. \\"disable\\" prefix-len How many horizontal bars ─ are rendered before the diagnostic text. 1 max-wrap Equivalent of the editor.soft-wrap.max-wrap option for diagnostics. 20 max-diagnostics Maximum number of diagnostics to render inline for a given line 10 The allowed values for cursor-line and other-lines are: error, warning, info, hint. The (first) diagnostic with the highest severity that is not shown inline is rendered at the end of the line (as long as its severity is higher than the end-of-line-diagnostics config option): fn main() { let baz = 1; let foo = bar; a local variable with a similar name exists: baz └─ no such value in this scope\\n} The new diagnostic rendering is not yet enabled by default. As soon as end of line or inline diagnostics are enabled the old diagnostics rendering is automatically disabled. The recommended default setting are: [editor]\\nend-of-line-diagnostics = \\"hint\\"\\n[editor.inline-diagnostics]\\ncursor-line = \\"warning\\" # show warnings and errors on the cursorline inline","breadcrumbs":"Configuration » Editor » [editor.inline-diagnostics] Section","id":"84","title":"[editor.inline-diagnostics] Section"},"85":{"body":"To use a theme add theme = \\"<name>\\" to the top of your config.toml file, or select it during runtime using :theme <name>.","breadcrumbs":"Configuration » Themes » Themes","id":"85","title":"Themes"},"86":{"body":"Create a file with the name of your theme as the file name (i.e mytheme.toml) and place it in your themes directory (i.e ~/.config/helix/themes or %AppData%\\\\helix\\\\themes on Windows). The directory might have to be created beforehand. 💡 The names \\"default\\" and \\"base16_default\\" are reserved for built-in themes and cannot be overridden by user-defined themes.","breadcrumbs":"Configuration » Themes » Creating a theme","id":"86","title":"Creating a theme"},"87":{"body":"Each line in the theme file is specified as below: key = { fg = \\"#ffffff\\", bg = \\"#000000\\", underline = { color = \\"#ff0000\\", style = \\"curl\\"}, modifiers = [\\"bold\\", \\"italic\\"] } Where key represents what you want to style, fg specifies the foreground color, bg the background color, underline the underline style/color, and modifiers is a list of style modifiers. bg, underline and modifiers can be omitted to defer to the defaults. To specify only the foreground color: key = \\"#ffffff\\" If the key contains a dot \'.\', it must be quoted to prevent it being parsed as a dotted key . \\"key.key\\" = \\"#ffffff\\" For inspiration, you can find the default theme.toml here and user-submitted themes here .","breadcrumbs":"Configuration » Themes » Overview","id":"87","title":"Overview"},"88":{"body":"","breadcrumbs":"Configuration » Themes » The details of theme creation","id":"88","title":"The details of theme creation"},"89":{"body":"It\'s recommended to define a palette of named colors, and refer to them in the configuration values in your theme. To do this, add a table called palette to your theme file: \\"ui.background\\" = \\"white\\"\\n\\"ui.text\\" = \\"black\\" [palette]\\nwhite = \\"#ffffff\\"\\nblack = \\"#000000\\" Keep in mind that the [palette] table includes all keys after its header, so it should be defined after the normal theme options. The default palette uses the terminal\'s default 16 colors, and the colors names are listed below. The [palette] section in the config file takes precedence over it and is merged into the default palette. Color Name default black red green yellow blue magenta cyan gray light-red light-green light-yellow light-blue light-magenta light-cyan light-gray white","breadcrumbs":"Configuration » Themes » Color palettes","id":"89","title":"Color palettes"},"9":{"body":"Helix is available in nixpkgs through the helix attribute, the unstable channel usually carries the latest release. Helix is also available as a flake in the project root. Use nix develop to spin up a reproducible development shell. Outputs are cached for each push to master using Cachix . The flake is configured to automatically make use of this cache assuming the user accepts the new settings on first use. If you are using a version of Nix without flakes enabled, install Cachix CLI and use cachix use helix to configure Nix to use cached outputs when possible.","breadcrumbs":"Installation » Package Managers » NixOS","id":"9","title":"NixOS"},"90":{"body":"The following values may be used as modifier, provided they are supported by your terminal emulator. Modifier bold dim italic underlined slow_blink rapid_blink reversed hidden crossed_out 💡 The underlined modifier is deprecated and only available for backwards compatibility. Its behavior is equivalent to setting underline.style=\\"line\\".","breadcrumbs":"Configuration » Themes » Modifiers","id":"90","title":"Modifiers"},"91":{"body":"One of the following values may be used as a value for underline.style, providing it is supported by your terminal emulator. Modifier line curl dashed dotted double_line","breadcrumbs":"Configuration » Themes » Underline style","id":"91","title":"Underline style"},"92":{"body":"Extend other themes by setting the inherits property to an existing theme. inherits = \\"boo_berry\\" # Override the theming for \\"keyword\\"s:\\n\\"keyword\\" = { fg = \\"gold\\" } # Override colors in the palette:\\n[palette]\\nberry = \\"#2A2A4D\\"","breadcrumbs":"Configuration » Themes » Inheritance","id":"92","title":"Inheritance"},"93":{"body":"The following is a list of scopes available to use for styling: Syntax highlighting These keys match tree-sitter scopes . When determining styling for a highlight, the longest matching theme key will be used. For example, if the highlight is function.builtin.static, the key function.builtin will be used instead of function. We use a similar set of scopes as Sublime Text . See also TextMate scopes. attribute - Class attributes, HTML tag attributes type - Types builtin - Primitive types provided by the language (int, usize) parameter - Generic type parameters (T) enum variant constructor constant (TODO: constant.other.placeholder for %v) builtin Special constants provided by the language (true, false, nil etc) boolean character escape numeric (numbers) integer float string (TODO: string.quoted.{single, double}, string.raw/.unquoted)? regexp - Regular expressions special path url symbol - Erlang/Elixir atoms, Ruby symbols, Clojure keywords comment - Code comments line - Single line comments (//) documentation - Line documentation comments (e.g. /// in Rust) block - Block comments (e.g. (/* */) documentation - Block documentation comments (e.g. /** */ in Rust) unused - Unused variables and patterns, e.g. _ and _foo variable - Variables builtin - Reserved language variables (self, this, super, etc.) parameter - Function parameters other member - Fields of composite data types (e.g. structs, unions) private - Private fields that use a unique syntax (currently just ECMAScript-based languages) label - .class, #id in CSS, etc. punctuation delimiter - Commas, colons bracket - Parentheses, angle brackets, etc. special - String interpolation brackets. keyword control conditional - if, else repeat - for, while, loop import - import, export return exception operator - or, in directive - Preprocessor directives (#if in C) function - fn, func storage - Keywords describing how things are stored type - The type of something, class, function, var, let, etc. modifier - Storage modifiers like static, mut, const, ref, etc. operator - ||, +=, > function builtin method private - Private methods that use a unique syntax (currently just ECMAScript-based languages) macro special (preprocessor in C) tag - Tags (e.g. <body> in HTML) builtin namespace special - derive in Rust, etc. markup heading marker 1, 2, 3, 4, 5, 6 - heading text for h1 through h6 list unnumbered numbered checked unchecked bold italic strikethrough link url - URLs pointed to by links label - non-URL link references text - URL and image descriptions in links quote raw inline block diff - version control changes plus - additions gutter - gutter indicator minus - deletions gutter - gutter indicator delta - modifications moved - renamed or moved files/changes conflict - merge conflicts gutter - gutter indicator Interface These scopes are used for theming the editor interface: markup normal completion - for completion doc popup UI hover - for hover popup UI heading completion - for completion doc popup UI hover - for hover popup UI raw inline completion - for completion doc popup UI hover - for hover popup UI Key Notes ui.background ui.background.separator Picker separator below input line ui.cursor ui.cursor.normal ui.cursor.insert ui.cursor.select ui.cursor.match Matching bracket etc. ui.cursor.primary Cursor with primary selection ui.cursor.primary.normal ui.cursor.primary.insert ui.cursor.primary.select ui.debug.breakpoint Breakpoint indicator, found in the gutter ui.debug.active Indicator for the line at which debugging execution is paused at, found in the gutter ui.gutter Gutter ui.gutter.selected Gutter for the line the cursor is on ui.linenr Line numbers ui.linenr.selected Line number for the line the cursor is on ui.statusline Statusline ui.statusline.inactive Statusline (unfocused document) ui.statusline.normal Statusline mode during normal mode ( only if editor.color-modes is enabled ) ui.statusline.insert Statusline mode during insert mode ( only if editor.color-modes is enabled ) ui.statusline.select Statusline mode during select mode ( only if editor.color-modes is enabled ) ui.statusline.separator Separator character in statusline ui.bufferline Style for the buffer line ui.bufferline.active Style for the active buffer in buffer line ui.bufferline.background Style for bufferline background ui.popup Documentation popups (e.g. Space + k) ui.popup.info Prompt for multiple key options ui.picker.header Header row area in pickers with multiple columns ui.picker.header.column Column names in pickers with multiple columns ui.picker.header.column.active The column name in pickers with multiple columns where the cursor is entering into. ui.window Borderlines separating splits ui.help Description box for commands ui.text Default text style, command prompts, popup text, etc. ui.text.focus The currently selected line in the picker ui.text.inactive Same as ui.text but when the text is inactive (e.g. suggestions) ui.text.info The key: command text in ui.popup.info boxes ui.text.directory Directory names in prompt completion ui.virtual.ruler Ruler columns (see the editor.rulers config ) ui.virtual.whitespace Visible whitespace characters ui.virtual.indent-guide Vertical indent width guides ui.virtual.inlay-hint Default style for inlay hints of all kinds ui.virtual.inlay-hint.parameter Style for inlay hints of kind parameter (language servers are not required to set a kind) ui.virtual.inlay-hint.type Style for inlay hints of kind type (language servers are not required to set a kind) ui.virtual.wrap Soft-wrap indicator (see the editor.soft-wrap config ) ui.virtual.jump-label Style for virtual jump labels ui.menu Code and command completion menus ui.menu.selected Selected autocomplete item ui.menu.scroll fg sets thumb color, bg sets track color of scrollbar ui.selection For selections in the editing area ui.selection.primary ui.highlight Highlighted lines in the picker preview ui.highlight.frameline Line at which debugging execution is paused at ui.cursorline.primary The line of the primary cursor ( if cursorline is enabled ) ui.cursorline.secondary The lines of any other cursors ( if cursorline is enabled ) ui.cursorcolumn.primary The column of the primary cursor ( if cursorcolumn is enabled ) ui.cursorcolumn.secondary The columns of any other cursors ( if cursorcolumn is enabled ) warning Diagnostics warning (gutter) error Diagnostics error (gutter) info Diagnostics info (gutter) hint Diagnostics hint (gutter) diagnostic Diagnostics fallback style (editing area) diagnostic.hint Diagnostics hint (editing area) diagnostic.info Diagnostics info (editing area) diagnostic.warning Diagnostics warning (editing area) diagnostic.error Diagnostics error (editing area) diagnostic.unnecessary Diagnostics with unnecessary tag (editing area) diagnostic.deprecated Diagnostics with deprecated tag (editing area) tabstop Snippet placeholder","breadcrumbs":"Configuration » Themes » Scopes","id":"93","title":"Scopes"},"94":{"body":"Helix currently supports one-way key remapping through a simple TOML configuration file. (More powerful solutions such as rebinding via commands will be available in the future). There are three kinds of commands that can be used in keymaps: Static commands: commands like move_char_right which are usually bound to keys and used for movement and editing. A list of static commands is available in the Keymap documentation and in the source code in helix-term/src/commands.rs at the invocation of static_commands! macro. Typable commands: commands that can be executed from command mode (:), for example :write!. See the Commands documentation for a list of available typeable commands or the TypableCommandList declaration in the source code at helix-term/src/commands/typed.rs . Macros: sequences of keys that are executed in order. These keybindings start with @ and then list any number of keys to be executed. For example @miw can be used to select the surrounding word. For now, macro keybindings are not allowed in keybinding sequences due to limitations in the way that command sequences are executed. Modifier keys (e.g. Alt+o) can be used like \\"<A-o>\\", e.g. \\"@miw<A-o>\\" To remap keys, create a config.toml file in your helix configuration directory (default ~/.config/helix on Linux systems) with a structure like this: 💡 To set a modifier + key as a keymap, type A-X = ... or C-X = ... for Alt + X or Ctrl + X. Combine with Shift using a dash, e.g. C-S-esc. Within macros, wrap them in <>, e.g. <A-X> and <C-X> to distinguish from the A or C keys. # At most one section each of \'keys.normal\', \'keys.insert\' and \'keys.select\'\\n[keys.normal]\\nC-s = \\":w\\" # Maps Ctrl-s to the typable command :w which is an alias for :write (save file)\\nC-o = \\":open ~/.config/helix/config.toml\\" # Maps Ctrl-o to opening of the helix config file\\na = \\"move_char_left\\" # Maps the \'a\' key to the move_char_left command\\nw = \\"move_line_up\\" # Maps the \'w\' key move_line_up\\n\\"C-S-esc\\" = \\"extend_line\\" # Maps Ctrl-Shift-Escape to extend_line\\ng = { a = \\"code_action\\" } # Maps `ga` to show possible code actions\\n\\"ret\\" = [\\"open_below\\", \\"normal_mode\\"] # Maps the enter key to open_below then re-enter normal mode\\n\\"A-x\\" = \\"@x<A-d>\\" # Maps Alt-x to a macro selecting the whole line and deleting it without yanking it [keys.insert]\\n\\"A-x\\" = \\"normal_mode\\" # Maps Alt-X to enter normal mode\\nj = { k = \\"normal_mode\\" } # Maps `jk` to exit insert mode","breadcrumbs":"Configuration » Key remapping » Key remapping","id":"94","title":"Key remapping"},"95":{"body":"Minor modes are accessed by pressing a key (usually from normal mode), giving access to dedicated bindings. Bindings can be modified or added by nesting definitions. [keys.insert.j]\\nk = \\"normal_mode\\" # Maps `jk` to exit insert mode [keys.normal.g]\\na = \\"code_action\\" # Maps `ga` to show possible code actions # invert `j` and `k` in view mode\\n[keys.normal.z]\\nj = \\"scroll_up\\"\\nk = \\"scroll_down\\" # create a new minor mode bound to `+`\\n[keys.normal.\\"+\\"]\\nm = \\":run-shell-command make\\"\\nc = \\":run-shell-command cargo build\\"\\nt = \\":run-shell-command cargo test\\"","breadcrumbs":"Configuration » Key remapping » Minor modes","id":"95","title":"Minor modes"},"96":{"body":"Ctrl, Shift and Alt modifiers are encoded respectively with the prefixes C-, S- and A-. The Super key - the Windows/Linux key or the Command key on Mac keyboards - is also supported when using a terminal emulator that supports the enhanced keyboard protocol . The super key is encoded with prefixes Meta-, Cmd- or Win-. These are all synonyms for the super modifier - binding a key with a Win- modifier will mean it can be used with the Windows/Linux key or the Command key. [keys.normal]\\nC-s = \\":write\\" # Ctrl and \'s\' to write\\nCmd-s = \\":write\\" # Cmd or Win or Meta and \'s\' to write Special keys are encoded as follows: Key name Representation Backspace \\"backspace\\" Space \\"space\\" Return/Enter \\"ret\\" Left \\"left\\" Right \\"right\\" Up \\"up\\" Down \\"down\\" Home \\"home\\" End \\"end\\" Page Up \\"pageup\\" Page Down \\"pagedown\\" Tab \\"tab\\" Delete \\"del\\" Insert \\"ins\\" Null \\"null\\" Escape \\"esc\\" Keys can be disabled by binding them to the no_op command. All other keys such as ?, !, - etc. can be used literally: [keys.normal]\\n\\"?\\" = \\":write\\"\\n\\"!\\" = \\":write\\"\\n\\"-\\" = \\":write\\" Note: - can\'t be used when combined with a modifier, for example Alt + - should be written as A-minus. A-- is not accepted.","breadcrumbs":"Configuration » Key remapping » Special keys and modifiers","id":"96","title":"Special keys and modifiers"},"97":{"body":"Language-specific settings and settings for language servers are configured in languages.toml files.","breadcrumbs":"Configuration » Languages » Languages","id":"97","title":"Languages"},"98":{"body":"There are three possible locations for a languages.toml file: In the Helix source code, which lives in the Helix repository . It provides the default configurations for languages and language servers. In your configuration directory . This overrides values from the built-in language configuration. For example, to disable auto-formatting for Rust: # in <config_dir>/helix/languages.toml [language-server.mylang-lsp]\\ncommand = \\"mylang-lsp\\" [[language]]\\nname = \\"rust\\"\\nauto-format = false In a .helix folder in your project. Language configuration may also be overridden local to a project by creating a languages.toml file in a .helix folder. Its settings will be merged with the language configuration in the configuration directory and the built-in configuration.","breadcrumbs":"Configuration » Languages » languages.toml files","id":"98","title":"languages.toml files"},"99":{"body":"Each language is configured by adding a [[language]] section to a languages.toml file. For example: [[language]]\\nname = \\"mylang\\"\\nscope = \\"source.mylang\\"\\ninjection-regex = \\"mylang\\"\\nfile-types = [\\"mylang\\", \\"myl\\"]\\ncomment-tokens = \\"#\\"\\nindent = { tab-width = 2, unit = \\" \\" }\\nformatter = { command = \\"mylang-formatter\\" , args = [\\"--stdin\\"] }\\nlanguage-servers = [ \\"mylang-lsp\\" ] These configuration keys are available: Key Description name The name of the language language-id The language-id for language servers, checkout the table at TextDocumentItem for the right id scope A string like source.js that identifies the language. Currently, we strive to match the scope names used by popular TextMate grammars and by the Linguist library. Usually source.<name> or text.<name> in case of markup languages injection-regex regex pattern that will be tested against a language name in order to determine whether this language should be used for a potential language injection site. file-types The filetypes of the language, for example [\\"yml\\", \\"yaml\\"]. See the file-type detection section below. shebangs The interpreters from the shebang line, for example [\\"sh\\", \\"bash\\"] roots A set of marker files to look for when trying to find the workspace root. For example Cargo.lock, yarn.lock auto-format Whether to autoformat this language when saving diagnostic-severity Minimal severity of diagnostic for it to be displayed. (Allowed values: error, warning, info, hint) comment-tokens The tokens to use as a comment token, either a single token \\"//\\" or an array [\\"//\\", \\"///\\", \\"//!\\"] (the first token will be used for commenting). Also configurable as comment-token for backwards compatibility block-comment-tokens The start and end tokens for a multiline comment either an array or single table of { start = \\"/*\\", end = \\"*/\\"}. The first set of tokens will be used for commenting, any pairs in the array can be uncommented indent The indent to use. Has sub keys unit (the text inserted into the document when indenting; usually set to N spaces or \\"\\\\t\\" for tabs) and tab-width (the number of spaces rendered for a tab) language-servers The Language Servers used for this language. See below for more information in the section Configuring Language Servers for a language grammar The tree-sitter grammar to use (defaults to the value of name) formatter The formatter for the language, it will take precedence over the lsp when defined. The formatter must be able to take the original file as input from stdin and write the formatted file to stdout. The filename of the current buffer can be passed as argument by using the %{buffer_name} expansion variable. See below for more information in the Configuring the formatter command soft-wrap editor.softwrap text-width Maximum line length. Used for the :reflow command and soft-wrapping if soft-wrap.wrap-at-text-width is set, defaults to editor.text-width rulers Overrides the editor.rulers config key for the language. path-completion Overrides the editor.path-completion config key for the language. workspace-lsp-roots Directories relative to the workspace root that are treated as LSP roots. Should only be set in .helix/config.toml. Overwrites the setting of the same name in config.toml if set. persistent-diagnostic-sources An array of LSP diagnostic sources assumed unchanged when the language server resends the same set of diagnostics. Helix can track the position for these diagnostics internally instead. Useful for diagnostics that are recomputed on save.","breadcrumbs":"Configuration » Languages » Language configuration","id":"99","title":"Language configuration"}},"length":123,"save":true},"fields":["title","body","breadcrumbs"],"index":{"body":{"root":{"0":{"0":{"0":{"0":{"0":{"0":{"df":2,"docs":{"87":{"tf":1.0},"89":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":3,"docs":{"45":{"tf":1.0},"80":{"tf":1.0},"82":{"tf":1.0}}},"1":{"0":{"0":{"df":1,"docs":{"56":{"tf":1.0}}},"df":2,"docs":{"17":{"tf":1.0},"84":{"tf":1.0}}},"1":{"df":1,"docs":{"17":{"tf":1.0}}},"2":{"df":1,"docs":{"5":{"tf":1.0}}},"6":{"df":2,"docs":{"59":{"tf":1.0},"89":{"tf":1.0}}},"df":13,"docs":{"114":{"tf":1.0},"116":{"tf":2.8284271247461903},"118":{"tf":1.0},"35":{"tf":1.0},"54":{"tf":1.0},"56":{"tf":2.23606797749979},"59":{"tf":1.7320508075688772},"70":{"tf":1.0},"73":{"tf":1.4142135623730951},"80":{"tf":1.0},"81":{"tf":1.0},"84":{"tf":1.4142135623730951},"93":{"tf":1.0}}},"2":{".":{"1":{"9":{".":{"0":{"df":1,"docs":{"65":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"0":{"df":4,"docs":{"102":{"tf":1.0},"56":{"tf":1.0},"82":{"tf":1.0},"84":{"tf":1.0}}},"1":{"df":1,"docs":{"5":{"tf":1.0}}},"2":{".":{"0":{"4":{"df":1,"docs":{"5":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"5":{"0":{"df":1,"docs":{"70":{"tf":1.4142135623730951}}},"df":1,"docs":{"82":{"tf":1.0}}},"a":{"2":{"a":{"4":{"d":{"df":1,"docs":{"92":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":9,"docs":{"116":{"tf":1.0},"117":{"tf":1.0},"118":{"tf":1.0},"35":{"tf":1.0},"59":{"tf":1.4142135623730951},"70":{"tf":1.0},"73":{"tf":1.0},"93":{"tf":1.0},"99":{"tf":1.0}}},"3":{"0":{"0":{"0":{"df":1,"docs":{"77":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"2":{"df":1,"docs":{"70":{"tf":1.0}}},"5":{"0":{"df":0,"docs":{},"m":{"df":1,"docs":{"84":{"tf":1.0}}}},"df":0,"docs":{}},"df":4,"docs":{"116":{"tf":1.0},"70":{"tf":1.0},"81":{"tf":1.0},"93":{"tf":1.0}},"x":{"df":1,"docs":{"116":{"tf":1.0}}}},"4":{"0":{"df":1,"docs":{"82":{"tf":1.0}}},"df":1,"docs":{"93":{"tf":1.0}}},"5":{"1":{"df":1,"docs":{"57":{"tf":1.4142135623730951}}},"2":{"df":1,"docs":{"71":{"tf":1.0}}},"df":3,"docs":{"56":{"tf":1.0},"70":{"tf":1.4142135623730951},"93":{"tf":1.0}}},"6":{"4":{"df":1,"docs":{"20":{"tf":1.0}}},"df":1,"docs":{"93":{"tf":1.0}}},"7":{"3":{"df":1,"docs":{"57":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"8":{".":{"1":{"df":1,"docs":{"20":{"tf":1.0}}},"df":0,"docs":{}},"0":{"df":1,"docs":{"70":{"tf":1.0}}},"1":{"df":1,"docs":{"57":{"tf":1.4142135623730951}}},"df":1,"docs":{"72":{"tf":1.0}}},"_":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"_":{"_":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"116":{"tf":1.7320508075688772}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":5,"docs":{"116":{"tf":1.4142135623730951},"35":{"tf":1.0},"46":{"tf":1.4142135623730951},"60":{"tf":2.0},"93":{"tf":1.0}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":1,"docs":{"93":{"tf":1.0}}}}}},"a":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"55":{"tf":1.4142135623730951}}}}}},"2":{"5":{"0":{"c":{"4":{"5":{"8":{"2":{"5":{"1":{"0":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"3":{"4":{"7":{"6":{"7":{"df":0,"docs":{},"e":{"c":{"3":{"b":{"7":{"d":{"c":{"d":{"d":{"3":{"c":{"2":{"4":{"df":0,"docs":{},"e":{"8":{"c":{"8":{"a":{"a":{"6":{"8":{"df":1,"docs":{"104":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"b":{"c":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"j":{"df":0,"docs":{},"k":{"df":0,"docs":{},"l":{"df":0,"docs":{},"m":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"q":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"v":{"df":0,"docs":{},"w":{"df":0,"docs":{},"x":{"df":0,"docs":{},"y":{"df":0,"docs":{},"z":{"df":1,"docs":{"70":{"tf":1.0}}}}}}}}}}}}}}}}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":12,"docs":{"100":{"tf":1.7320508075688772},"115":{"tf":1.4142135623730951},"116":{"tf":1.0},"20":{"tf":1.0},"39":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"48":{"tf":1.4142135623730951},"56":{"tf":1.0},"57":{"tf":1.0},"60":{"tf":2.23606797749979},"67":{"tf":1.0}}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":6,"docs":{"100":{"tf":1.0},"109":{"tf":1.0},"114":{"tf":1.0},"24":{"tf":1.0},"70":{"tf":2.0},"72":{"tf":1.4142135623730951}}}}}}}},"c":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":7,"docs":{"48":{"tf":1.4142135623730951},"53":{"tf":1.4142135623730951},"55":{"tf":1.0},"59":{"tf":3.1622776601683795},"81":{"tf":1.0},"9":{"tf":1.0},"96":{"tf":1.0}}}},"s":{"df":0,"docs":{},"s":{"df":8,"docs":{"26":{"tf":1.0},"27":{"tf":1.4142135623730951},"40":{"tf":1.0},"48":{"tf":2.6457513110645907},"49":{"tf":1.0},"50":{"tf":1.0},"60":{"tf":1.0},"95":{"tf":1.4142135623730951}},"e":{"d":{"/":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"48":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":1,"docs":{"112":{"tf":1.0}}}}},"df":0,"docs":{}}},"r":{"d":{"df":4,"docs":{"102":{"tf":1.0},"115":{"tf":1.0},"39":{"tf":1.0},"57":{"tf":1.0}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"100":{"tf":1.0},"22":{"tf":1.0}}}}}}},"df":0,"docs":{},"t":{"df":4,"docs":{"29":{"tf":1.0},"36":{"tf":1.4142135623730951},"56":{"tf":1.0},"63":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":10,"docs":{"103":{"tf":1.7320508075688772},"29":{"tf":1.4142135623730951},"30":{"tf":1.0},"33":{"tf":1.0},"36":{"tf":1.0},"48":{"tf":1.0},"60":{"tf":1.0},"63":{"tf":1.4142135623730951},"94":{"tf":1.0},"95":{"tf":1.0}}}},"v":{"df":8,"docs":{"37":{"tf":1.0},"42":{"tf":1.0},"48":{"tf":1.0},"53":{"tf":1.0},"59":{"tf":1.0},"72":{"tf":1.4142135623730951},"73":{"tf":1.0},"93":{"tf":1.0}}}},"u":{"a":{"df":0,"docs":{},"l":{"df":3,"docs":{"114":{"tf":1.0},"116":{"tf":1.0},"118":{"tf":1.0}}}},"df":0,"docs":{}}}},"d":{"a":{"_":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{"df":1,"docs":{"61":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":1,"docs":{"61":{"tf":1.0}},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"59":{"tf":1.0}}}}},"d":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"_":{"a":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}}}}},"df":0,"docs":{}},"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}},"df":18,"docs":{"107":{"tf":1.0},"108":{"tf":1.0},"109":{"tf":1.0},"110":{"tf":1.0},"111":{"tf":1.0},"12":{"tf":1.0},"2":{"tf":1.0},"22":{"tf":1.0},"36":{"tf":1.0},"46":{"tf":1.4142135623730951},"48":{"tf":1.4142135623730951},"50":{"tf":1.0},"6":{"tf":1.4142135623730951},"60":{"tf":2.23606797749979},"70":{"tf":1.0},"76":{"tf":1.0},"85":{"tf":1.0},"89":{"tf":1.0}},"i":{"df":0,"docs":{},"t":{"df":3,"docs":{"116":{"tf":1.0},"119":{"tf":1.0},"93":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":4,"docs":{"117":{"tf":1.0},"75":{"tf":1.0},"76":{"tf":1.0},"8":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":3,"docs":{"116":{"tf":1.0},"59":{"tf":1.0},"64":{"tf":1.0}}}}}}},"df":13,"docs":{"100":{"tf":1.0},"106":{"tf":1.0},"107":{"tf":1.0},"108":{"tf":1.7320508075688772},"112":{"tf":1.0},"114":{"tf":1.7320508075688772},"116":{"tf":1.0},"118":{"tf":1.4142135623730951},"119":{"tf":1.0},"61":{"tf":1.0},"81":{"tf":1.0},"95":{"tf":1.0},"99":{"tf":1.0}},"l":{"df":1,"docs":{"61":{"tf":1.0}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"22":{"tf":1.0}}}}}}}}},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"64":{"tf":1.0}}}}},"v":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"1":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"103":{"tf":1.0},"50":{"tf":1.0}}}},"df":0,"docs":{}}}},"g":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"100":{"tf":1.0},"99":{"tf":1.0}}}}}}},"d":{"a":{"df":1,"docs":{"61":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"h":{"a":{"df":1,"docs":{"118":{"tf":1.0}}},"df":0,"docs":{}},"l":{"df":1,"docs":{"120":{"tf":1.0}},"i":{"a":{"df":1,"docs":{"94":{"tf":1.0}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"46":{"tf":1.0},"60":{"tf":1.0}}}},"df":0,"docs":{}}}}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"_":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}}}}}}}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"d":{"d":{"df":0,"docs":{},"l":{"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}},"df":5,"docs":{"116":{"tf":2.449489742783178},"46":{"tf":1.0},"48":{"tf":1.7320508075688772},"60":{"tf":2.23606797749979},"72":{"tf":1.7320508075688772}}}}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":13,"docs":{"112":{"tf":1.0},"117":{"tf":1.0},"119":{"tf":1.4142135623730951},"2":{"tf":1.0},"33":{"tf":1.0},"37":{"tf":1.0},"39":{"tf":1.0},"50":{"tf":1.0},"64":{"tf":1.0},"72":{"tf":1.0},"84":{"tf":1.0},"94":{"tf":1.0},"99":{"tf":1.0}}},"y":{"df":1,"docs":{"61":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"115":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"h":{"a":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"70":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":0,"docs":{},"i":{"df":7,"docs":{"100":{"tf":1.0},"113":{"tf":1.0},"114":{"tf":1.4142135623730951},"17":{"tf":1.0},"46":{"tf":1.0},"60":{"tf":2.23606797749979},"75":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"t":{"+":{"df":0,"docs":{},"o":{"df":1,"docs":{"94":{"tf":1.0}}}},"df":12,"docs":{"37":{"tf":1.4142135623730951},"39":{"tf":3.0},"44":{"tf":1.0},"45":{"tf":2.6457513110645907},"46":{"tf":5.0},"47":{"tf":1.0},"48":{"tf":1.7320508075688772},"49":{"tf":1.7320508075688772},"51":{"tf":1.0},"52":{"tf":2.23606797749979},"94":{"tf":1.7320508075688772},"96":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"55":{"tf":1.0}},"n":{"df":2,"docs":{"68":{"tf":1.0},"71":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"76":{"tf":1.0}}}}}}}},"w":{"a":{"df":0,"docs":{},"y":{"df":7,"docs":{"100":{"tf":1.0},"116":{"tf":1.4142135623730951},"118":{"tf":1.0},"22":{"tf":1.0},"54":{"tf":1.4142135623730951},"70":{"tf":1.4142135623730951},"83":{"tf":1.0}}}},"df":0,"docs":{}}},"m":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"61":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"e":{"b":{"a":{"df":1,"docs":{"61":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"n":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"y":{"df":0,"docs":{},"z":{"df":1,"docs":{"61":{"tf":1.7320508075688772}}}}}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"116":{"tf":2.0}}}}}}},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":3,"docs":{"116":{"tf":2.0},"46":{"tf":1.0},"60":{"tf":2.0}}}}}},"d":{"/":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"72":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"65":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":1,"docs":{"93":{"tf":1.0}}}},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":3,"docs":{"119":{"tf":1.0},"24":{"tf":1.0},"60":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"61":{"tf":1.0}}}},"df":0,"docs":{}}},"y":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"56":{"tf":1.0}}}},"w":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"117":{"tf":1.0}}}}}}}},"p":{"df":0,"docs":{},"i":{"df":1,"docs":{"70":{"tf":1.0}}},"p":{"d":{"a":{"df":0,"docs":{},"t":{"a":{"%":{"\\\\":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"\\\\":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"68":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"75":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"86":{"tf":1.0}}}}}}},"df":1,"docs":{"22":{"tf":1.4142135623730951}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":1,"docs":{"17":{"tf":1.4142135623730951}},"e":{"a":{"df":0,"docs":{},"r":{"df":3,"docs":{"117":{"tf":1.0},"72":{"tf":1.0},"73":{"tf":1.0}}}},"df":0,"docs":{},"n":{"d":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"d":{"df":2,"docs":{"45":{"tf":1.0},"60":{"tf":1.0}}},"df":0,"docs":{}}}},"df":4,"docs":{"45":{"tf":1.4142135623730951},"57":{"tf":1.0},"59":{"tf":1.4142135623730951},"60":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"g":{"df":2,"docs":{"12":{"tf":2.449489742783178},"3":{"tf":1.0}}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"24":{"tf":1.0}}},"df":5,"docs":{"116":{"tf":1.4142135623730951},"118":{"tf":1.7320508075688772},"41":{"tf":1.0},"48":{"tf":1.0},"70":{"tf":1.0}}}},"r":{"df":0,"docs":{},"o":{"a":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"70":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"61":{"tf":1.0}}}}}}}},"t":{"df":1,"docs":{"6":{"tf":1.7320508075688772}}}},"r":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"71":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"c":{"df":0,"docs":{},"h":{"df":2,"docs":{"3":{"tf":1.0},"8":{"tf":1.0}}}},"df":0,"docs":{},"e":{"a":{"df":2,"docs":{"72":{"tf":1.0},"93":{"tf":3.0}}},"df":0,"docs":{}},"g":{"1":{"df":2,"docs":{"117":{"tf":1.0},"39":{"tf":2.6457513110645907}}},"2":{"df":2,"docs":{"117":{"tf":1.0},"39":{"tf":2.8284271247461903}}},"3":{"df":1,"docs":{"39":{"tf":2.6457513110645907}}},"df":5,"docs":{"101":{"tf":1.0},"102":{"tf":1.4142135623730951},"61":{"tf":1.4142135623730951},"71":{"tf":2.0},"99":{"tf":1.0}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"/":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":2,"docs":{"37":{"tf":1.0},"48":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":14,"docs":{"101":{"tf":1.4142135623730951},"102":{"tf":1.0},"117":{"tf":3.4641016151377544},"122":{"tf":2.449489742783178},"39":{"tf":2.0},"53":{"tf":1.4142135623730951},"54":{"tf":2.23606797749979},"55":{"tf":1.4142135623730951},"56":{"tf":1.4142135623730951},"57":{"tf":2.6457513110645907},"59":{"tf":2.8284271247461903},"60":{"tf":1.0},"68":{"tf":1.0},"99":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":5,"docs":{"37":{"tf":1.0},"48":{"tf":1.0},"60":{"tf":1.0},"70":{"tf":1.4142135623730951},"78":{"tf":1.0}}},"df":0,"docs":{}}}},"r":{"a":{"df":0,"docs":{},"y":{"df":4,"docs":{"103":{"tf":1.4142135623730951},"57":{"tf":1.0},"81":{"tf":1.0},"99":{"tf":2.0}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":2,"docs":{"39":{"tf":1.0},"83":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"56":{"tf":1.0}}},"df":0,"docs":{}},"m":{"df":1,"docs":{"61":{"tf":1.4142135623730951}}},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":4,"docs":{"114":{"tf":1.0},"21":{"tf":1.0},"9":{"tf":1.0},"99":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":1,"docs":{"61":{"tf":1.4142135623730951}}}}}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":2,"docs":{"70":{"tf":1.4142135623730951},"93":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"111":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":5,"docs":{"103":{"tf":1.4142135623730951},"61":{"tf":1.0},"81":{"tf":1.0},"9":{"tf":1.0},"93":{"tf":1.7320508075688772}}}}},"df":0,"docs":{}}}}},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"8":{"tf":1.0}}},"t":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":3,"docs":{"49":{"tf":1.0},"70":{"tf":1.0},"93":{"tf":1.0}}}}}}}}},"df":9,"docs":{"57":{"tf":1.4142135623730951},"61":{"tf":1.0},"70":{"tf":2.0},"73":{"tf":1.0},"76":{"tf":2.0},"77":{"tf":1.7320508075688772},"83":{"tf":1.0},"98":{"tf":1.4142135623730951},"99":{"tf":1.0}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"99":{"tf":1.0}}}},"df":0,"docs":{}}}}},"m":{"a":{"df":0,"docs":{},"t":{"df":10,"docs":{"100":{"tf":1.4142135623730951},"113":{"tf":1.0},"47":{"tf":1.0},"60":{"tf":1.0},"70":{"tf":2.8284271247461903},"73":{"tf":1.0},"76":{"tf":1.0},"77":{"tf":1.4142135623730951},"84":{"tf":1.0},"9":{"tf":1.0}}}},"df":0,"docs":{}}}}},"v":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":14,"docs":{"0":{"tf":1.0},"10":{"tf":1.0},"102":{"tf":1.0},"109":{"tf":1.0},"11":{"tf":1.0},"17":{"tf":1.0},"4":{"tf":1.0},"70":{"tf":1.4142135623730951},"8":{"tf":1.4142135623730951},"9":{"tf":1.4142135623730951},"90":{"tf":1.0},"93":{"tf":1.0},"94":{"tf":1.7320508075688772},"99":{"tf":1.0}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"24":{"tf":1.0}}},"df":0,"docs":{}}}},"w":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"39":{"tf":1.0}}},"y":{"df":1,"docs":{"77":{"tf":1.0}}}},"df":0,"docs":{},"k":{"df":1,"docs":{"61":{"tf":1.4142135623730951}}}},"y":{"df":1,"docs":{"33":{"tf":1.0}}}},"b":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"54":{"tf":1.7320508075688772}}}}}},"a":{"c":{"df":0,"docs":{},"k":{"df":3,"docs":{"45":{"tf":1.0},"48":{"tf":1.4142135623730951},"59":{"tf":1.0}},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":3,"docs":{"51":{"tf":1.0},"87":{"tf":1.0},"93":{"tf":1.0}}},"df":0,"docs":{}}}}}},"s":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"54":{"tf":2.0}}}}},"df":0,"docs":{}},"p":{"a":{"c":{"df":4,"docs":{"49":{"tf":1.7320508075688772},"52":{"tf":2.0},"60":{"tf":1.7320508075688772},"96":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}}},"t":{"a":{"b":{"df":1,"docs":{"52":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"k":{"df":2,"docs":{"54":{"tf":1.4142135623730951},"56":{"tf":1.0}}}},"df":0,"docs":{}}},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":8,"docs":{"44":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.4142135623730951},"49":{"tf":1.0},"52":{"tf":1.4142135623730951},"60":{"tf":2.0},"90":{"tf":1.0},"99":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{},"r":{"df":7,"docs":{"116":{"tf":1.4142135623730951},"57":{"tf":1.0},"59":{"tf":1.0},"68":{"tf":1.0},"74":{"tf":1.0},"81":{"tf":1.0},"84":{"tf":1.7320508075688772}}},"s":{"df":0,"docs":{},"e":{"1":{"6":{"_":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"86":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":8,"docs":{"100":{"tf":1.0},"113":{"tf":1.4142135623730951},"37":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.7320508075688772},"70":{"tf":1.0},"72":{"tf":1.0},"93":{"tf":1.4142135623730951}},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"72":{"tf":1.0}}}},"df":0,"docs":{}}},"h":{"df":4,"docs":{"119":{"tf":1.4142135623730951},"25":{"tf":1.0},"61":{"tf":1.7320508075688772},"99":{"tf":1.0}},"r":{"c":{"df":1,"docs":{"22":{"tf":1.0}}},"df":0,"docs":{}}},"s":{"df":1,"docs":{"61":{"tf":1.4142135623730951}}}},"z":{"df":2,"docs":{"116":{"tf":1.4142135623730951},"84":{"tf":1.4142135623730951}}}},"c":{"a":{"df":1,"docs":{"59":{"tf":1.4142135623730951}}},"df":2,"docs":{"56":{"tf":1.4142135623730951},"59":{"tf":1.4142135623730951}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"59":{"tf":1.4142135623730951}}}},"df":1,"docs":{"59":{"tf":1.4142135623730951}},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"59":{"tf":1.4142135623730951}}}}}}}}},"o":{"df":1,"docs":{"59":{"tf":1.4142135623730951}}}},"df":6,"docs":{"44":{"tf":1.7320508075688772},"46":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":2.0},"52":{"tf":1.4142135623730951},"60":{"tf":3.605551275463989}},"e":{"_":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"_":{"d":{"a":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{"(":{"1":{"df":1,"docs":{"118":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"a":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"61":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":2,"docs":{"116":{"tf":1.0},"49":{"tf":1.0}}}}},"df":6,"docs":{"116":{"tf":1.0},"32":{"tf":1.0},"48":{"tf":1.0},"70":{"tf":1.0},"73":{"tf":1.0},"87":{"tf":1.0}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":16,"docs":{"105":{"tf":1.0},"109":{"tf":1.0},"116":{"tf":1.0},"22":{"tf":1.0},"33":{"tf":1.0},"39":{"tf":1.0},"45":{"tf":1.7320508075688772},"48":{"tf":1.0},"50":{"tf":1.0},"56":{"tf":1.0},"59":{"tf":2.23606797749979},"60":{"tf":2.23606797749979},"70":{"tf":1.7320508075688772},"77":{"tf":1.0},"82":{"tf":1.0},"84":{"tf":1.0}},"e":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"86":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":4,"docs":{"114":{"tf":1.4142135623730951},"116":{"tf":1.0},"54":{"tf":1.0},"60":{"tf":1.4142135623730951}}}}},"h":{"a":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":8,"docs":{"35":{"tf":1.0},"39":{"tf":1.0},"53":{"tf":1.0},"55":{"tf":1.0},"57":{"tf":1.0},"77":{"tf":1.0},"81":{"tf":1.0},"90":{"tf":1.0}}}}}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"48":{"tf":1.0}}}},"w":{"df":18,"docs":{"104":{"tf":1.0},"107":{"tf":1.0},"115":{"tf":1.0},"116":{"tf":1.0},"21":{"tf":1.0},"22":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"48":{"tf":1.4142135623730951},"53":{"tf":1.0},"60":{"tf":2.23606797749979},"73":{"tf":1.4142135623730951},"79":{"tf":1.0},"84":{"tf":1.0},"87":{"tf":1.0},"89":{"tf":1.0},"93":{"tf":1.0},"99":{"tf":1.7320508075688772}}}}},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"92":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"73":{"tf":1.0}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":6,"docs":{"114":{"tf":1.0},"28":{"tf":1.0},"38":{"tf":1.0},"57":{"tf":1.0},"60":{"tf":1.0},"72":{"tf":1.4142135623730951}}}}}}}},"g":{"df":2,"docs":{"87":{"tf":1.7320508075688772},"93":{"tf":1.0}}},"i":{"b":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":1,"docs":{"61":{"tf":1.0}}}}}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":1,"docs":{"61":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":4,"docs":{"102":{"tf":1.7320508075688772},"2":{"tf":2.0},"22":{"tf":1.0},"25":{"tf":1.4142135623730951}}}}},"d":{"df":5,"docs":{"38":{"tf":1.0},"49":{"tf":1.4142135623730951},"83":{"tf":1.4142135623730951},"95":{"tf":1.4142135623730951},"96":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"t":{"b":{"a":{"df":0,"docs":{},"k":{"df":1,"docs":{"61":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":2,"docs":{"20":{"tf":1.0},"73":{"tf":1.0}}}},"l":{"a":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"89":{"tf":1.7320508075688772}}}},"d":{"df":0,"docs":{},"e":{"df":1,"docs":{"61":{"tf":1.0}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":1,"docs":{"56":{"tf":1.4142135623730951}}}},"n":{"df":0,"docs":{},"k":{"df":1,"docs":{"60":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"d":{"df":1,"docs":{"0":{"tf":1.0}}},"df":0,"docs":{}}},"o":{"c":{"df":0,"docs":{},"k":{"_":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":1,"docs":{"116":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"116":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}},"df":9,"docs":{"116":{"tf":1.7320508075688772},"118":{"tf":1.4142135623730951},"37":{"tf":1.4142135623730951},"48":{"tf":1.0},"60":{"tf":1.0},"68":{"tf":1.0},"74":{"tf":2.0},"93":{"tf":2.0},"99":{"tf":1.0}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"e":{"df":1,"docs":{"89":{"tf":1.4142135623730951}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"61":{"tf":1.4142135623730951}}}}}}}}}},"n":{"df":1,"docs":{"59":{"tf":1.0}},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"59":{"tf":1.0}}}}}},"o":{"d":{"df":0,"docs":{},"i":{"df":1,"docs":{"93":{"tf":1.0}}}},"df":0,"docs":{},"l":{"d":{"df":3,"docs":{"87":{"tf":1.0},"90":{"tf":1.0},"93":{"tf":1.0}}},"df":0,"docs":{}},"o":{"_":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"92":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"n":{"df":3,"docs":{"57":{"tf":1.0},"76":{"tf":1.0},"93":{"tf":1.0}}}},"df":0,"docs":{}}}},"r":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"70":{"tf":1.4142135623730951}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"93":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"h":{"df":4,"docs":{"11":{"tf":1.0},"116":{"tf":1.4142135623730951},"120":{"tf":1.0},"70":{"tf":1.0}}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":3,"docs":{"48":{"tf":1.7320508075688772},"60":{"tf":2.0},"72":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"n":{"d":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"47":{"tf":1.0},"60":{"tf":1.0}}}}},"df":5,"docs":{"46":{"tf":1.4142135623730951},"60":{"tf":2.0},"83":{"tf":1.0},"94":{"tf":1.0},"95":{"tf":1.0}}},"df":0,"docs":{}}},"x":{"df":3,"docs":{"22":{"tf":1.0},"70":{"tf":1.0},"93":{"tf":1.4142135623730951}}}},"p":{"df":1,"docs":{"59":{"tf":1.0}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":1,"docs":{"59":{"tf":1.0}}}}}},"r":{"a":{"c":{"df":0,"docs":{},"e":{"df":2,"docs":{"116":{"tf":1.0},"118":{"tf":1.4142135623730951}}},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":5,"docs":{"36":{"tf":1.0},"48":{"tf":1.0},"60":{"tf":1.0},"76":{"tf":1.0},"93":{"tf":2.0}}}}}},"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"h":{"df":3,"docs":{"111":{"tf":1.0},"72":{"tf":1.0},"8":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"k":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":3,"docs":{"60":{"tf":2.23606797749979},"70":{"tf":1.0},"93":{"tf":1.0}}}}}}}}},"df":0,"docs":{},"w":{"df":1,"docs":{"14":{"tf":1.0}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"48":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"f":{"df":1,"docs":{"61":{"tf":1.0}},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"\'":{"df":1,"docs":{"60":{"tf":1.4142135623730951}}},"_":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":3,"docs":{"101":{"tf":1.4142135623730951},"56":{"tf":1.4142135623730951},"99":{"tf":1.0}},"e":{"df":0,"docs":{},"}":{":":{"%":{"df":0,"docs":{},"{":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"n":{"df":1,"docs":{"57":{"tf":1.0}}}}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"56":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"k":{"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":9,"docs":{"28":{"tf":2.449489742783178},"48":{"tf":1.7320508075688772},"56":{"tf":1.0},"59":{"tf":5.656854249492381},"60":{"tf":2.23606797749979},"70":{"tf":1.7320508075688772},"72":{"tf":1.0},"93":{"tf":1.7320508075688772},"99":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"70":{"tf":1.0},"93":{"tf":1.0}}}}}}}}},"g":{"df":3,"docs":{"64":{"tf":1.0},"65":{"tf":1.0},"73":{"tf":1.0}}},"i":{"df":0,"docs":{},"l":{"d":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"f":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"21":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}},"_":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"/":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"r":{"/":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"/":{"df":0,"docs":{},"h":{"df":0,"docs":{},"x":{"df":1,"docs":{"22":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"b":{"/":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"df":1,"docs":{"22":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":10,"docs":{"1":{"tf":1.0},"104":{"tf":1.0},"105":{"tf":1.0},"111":{"tf":1.4142135623730951},"21":{"tf":2.449489742783178},"22":{"tf":2.0},"25":{"tf":2.449489742783178},"5":{"tf":1.0},"8":{"tf":1.0},"95":{"tf":1.0}}},"df":0,"docs":{},"t":{"df":9,"docs":{"104":{"tf":1.0},"105":{"tf":1.4142135623730951},"2":{"tf":1.4142135623730951},"36":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.0},"68":{"tf":1.0},"86":{"tf":1.0},"98":{"tf":1.4142135623730951}},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"71":{"tf":1.0},"93":{"tf":2.23606797749979}}}}}}}},"y":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"56":{"tf":1.0}}}}}},"c":{"\\"":{"]":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"70":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"+":{"+":{"1":{"4":{"df":1,"docs":{"21":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},":":{"\\\\":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"\\\\":{"df":0,"docs":{},"y":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"22":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"a":{"b":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"61":{"tf":1.0}}}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"9":{"tf":1.7320508075688772}},"i":{"df":0,"docs":{},"x":{"df":1,"docs":{"9":{"tf":1.7320508075688772}}}}}},"d":{"d":{"df":0,"docs":{},"y":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"61":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":1,"docs":{"61":{"tf":1.4142135623730951}}}}},"l":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":2,"docs":{"114":{"tf":1.0},"56":{"tf":1.0}}}}},"df":0,"docs":{},"l":{"df":3,"docs":{"39":{"tf":2.0},"55":{"tf":1.0},"89":{"tf":1.0}}}},"n":{"\'":{"df":0,"docs":{},"t":{"df":1,"docs":{"96":{"tf":1.0}}}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"118":{"tf":1.0}}}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":1,"docs":{"61":{"tf":1.0}}}},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":11,"docs":{"110":{"tf":1.0},"112":{"tf":1.7320508075688772},"113":{"tf":1.7320508075688772},"114":{"tf":1.7320508075688772},"115":{"tf":1.4142135623730951},"116":{"tf":3.3166247903554},"117":{"tf":2.8284271247461903},"118":{"tf":1.7320508075688772},"120":{"tf":2.449489742783178},"121":{"tf":1.0},"122":{"tf":2.0}}}}}},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{".":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"99":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"100":{"tf":1.0}}}}}}},"/":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"/":{"df":0,"docs":{},"h":{"df":0,"docs":{},"x":{"df":1,"docs":{"24":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"_":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":1,"docs":{"22":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}},"df":5,"docs":{"108":{"tf":1.0},"21":{"tf":1.4142135623730951},"22":{"tf":1.4142135623730951},"25":{"tf":2.449489742783178},"95":{"tf":1.4142135623730951}}}},"r":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"56":{"tf":1.0}}}},"df":3,"docs":{"33":{"tf":1.0},"82":{"tf":1.0},"9":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"e":{"df":11,"docs":{"103":{"tf":1.4142135623730951},"116":{"tf":2.23606797749979},"117":{"tf":1.0},"118":{"tf":1.0},"39":{"tf":1.0},"45":{"tf":1.7320508075688772},"59":{"tf":2.0},"60":{"tf":1.0},"64":{"tf":1.7320508075688772},"78":{"tf":2.0},"99":{"tf":1.0}}}},"t":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"116":{"tf":1.0}}}},"df":1,"docs":{"71":{"tf":1.4142135623730951}}},"u":{"df":0,"docs":{},"s":{"df":3,"docs":{"111":{"tf":1.0},"116":{"tf":1.0},"55":{"tf":1.0}}}}},"d":{"df":3,"docs":{"21":{"tf":1.0},"22":{"tf":1.0},"59":{"tf":1.0}}},"df":18,"docs":{"105":{"tf":1.0},"21":{"tf":1.4142135623730951},"30":{"tf":1.0},"37":{"tf":1.0},"45":{"tf":1.4142135623730951},"46":{"tf":1.7320508075688772},"48":{"tf":2.8284271247461903},"51":{"tf":1.0},"52":{"tf":1.0},"60":{"tf":10.816653826391969},"61":{"tf":1.4142135623730951},"68":{"tf":1.4142135623730951},"70":{"tf":1.0},"83":{"tf":1.0},"93":{"tf":1.4142135623730951},"94":{"tf":2.6457513110645907},"95":{"tf":1.0},"96":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"61":{"tf":1.0}}},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"48":{"tf":1.0},"60":{"tf":1.4142135623730951},"72":{"tf":1.7320508075688772}}}}}},"r":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":3,"docs":{"103":{"tf":1.0},"54":{"tf":1.0},"64":{"tf":1.0}}}}},"df":0,"docs":{}}}},"h":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":20,"docs":{"116":{"tf":1.0},"12":{"tf":1.0},"29":{"tf":1.0},"30":{"tf":1.0},"33":{"tf":1.4142135623730951},"36":{"tf":1.0},"37":{"tf":1.0},"42":{"tf":1.0},"45":{"tf":2.23606797749979},"48":{"tf":2.449489742783178},"49":{"tf":1.0},"50":{"tf":1.4142135623730951},"52":{"tf":1.0},"59":{"tf":4.898979485566356},"60":{"tf":3.1622776601683795},"63":{"tf":1.0},"72":{"tf":1.0},"74":{"tf":1.0},"81":{"tf":1.0},"93":{"tf":1.0}},"e":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"45":{"tf":1.0},"60":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"y":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":2,"docs":{"45":{"tf":1.0},"60":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"d":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"k":{"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{".":{"df":0,"docs":{},"m":{"d":{"df":1,"docs":{"54":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"9":{"tf":1.0}}}}}},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":21,"docs":{"31":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":2.0},"45":{"tf":1.0},"48":{"tf":1.7320508075688772},"54":{"tf":2.449489742783178},"55":{"tf":1.0},"56":{"tf":2.449489742783178},"57":{"tf":1.4142135623730951},"59":{"tf":1.4142135623730951},"60":{"tf":1.4142135623730951},"70":{"tf":2.0},"72":{"tf":1.4142135623730951},"76":{"tf":1.0},"78":{"tf":1.0},"79":{"tf":2.0},"80":{"tf":2.0},"81":{"tf":1.0},"83":{"tf":1.0},"93":{"tf":1.7320508075688772}}}},"df":0,"docs":{}},"df":7,"docs":{"44":{"tf":2.0},"47":{"tf":1.0},"48":{"tf":2.0},"49":{"tf":2.0},"52":{"tf":2.23606797749979},"59":{"tf":1.0},"60":{"tf":3.605551275463989}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"df":6,"docs":{"100":{"tf":1.0},"23":{"tf":1.7320508075688772},"42":{"tf":1.0},"61":{"tf":1.0},"8":{"tf":1.0},"93":{"tf":1.0}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"99":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"49":{"tf":1.0},"60":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"l":{"d":{"_":{"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"117":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":2,"docs":{"121":{"tf":1.7320508075688772},"39":{"tf":1.0}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":3,"docs":{"121":{"tf":1.7320508075688772},"46":{"tf":1.0},"60":{"tf":1.0}}}}}},"df":0,"docs":{}}},"m":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"12":{"tf":1.0}}},"df":0,"docs":{}}},"o":{"c":{"df":0,"docs":{},"o":{"df":1,"docs":{"19":{"tf":1.0}},"l":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":3,"docs":{"16":{"tf":1.0},"19":{"tf":1.0},"3":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"21":{"tf":1.0}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"s":{"df":2,"docs":{"105":{"tf":1.0},"120":{"tf":1.0}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"70":{"tf":1.0}}}}}}},"i":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"l":{"df":1,"docs":{"56":{"tf":2.0}}},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"61":{"tf":1.4142135623730951}}}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"73":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"l":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"d":{"df":1,"docs":{"61":{"tf":1.7320508075688772}}},"df":1,"docs":{"21":{"tf":1.0}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"61":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"61":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"s":{".":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"112":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"112":{"tf":1.0}}},"df":0,"docs":{}}}}}},"_":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"116":{"tf":1.7320508075688772}}}}}}}}},"df":0,"docs":{}},"df":5,"docs":{"112":{"tf":1.0},"116":{"tf":2.23606797749979},"37":{"tf":1.0},"38":{"tf":1.0},"93":{"tf":1.7320508075688772}},"i":{"c":{"df":1,"docs":{"11":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":1,"docs":{"61":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"59":{"tf":2.0}}}},"df":0,"docs":{}},"i":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"70":{"tf":1.4142135623730951}}}},"df":1,"docs":{"9":{"tf":1.0}},"p":{"b":{"df":0,"docs":{},"o":{"a":{"df":0,"docs":{},"r":{"d":{"df":7,"docs":{"32":{"tf":1.0},"35":{"tf":2.6457513110645907},"48":{"tf":2.23606797749979},"59":{"tf":4.795831523312719},"60":{"tf":3.4641016151377544},"70":{"tf":1.4142135623730951},"71":{"tf":1.7320508075688772}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":1,"docs":{"70":{"tf":1.0}}}},"o":{"df":0,"docs":{},"j":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":2,"docs":{"61":{"tf":1.4142135623730951},"93":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"e":{"df":3,"docs":{"104":{"tf":1.0},"21":{"tf":1.7320508075688772},"25":{"tf":1.0}}}},"s":{"df":0,"docs":{},"e":{"df":8,"docs":{"116":{"tf":1.0},"118":{"tf":1.4142135623730951},"48":{"tf":2.0},"51":{"tf":1.4142135623730951},"52":{"tf":1.0},"56":{"tf":1.0},"59":{"tf":5.0990195135927845},"60":{"tf":1.4142135623730951}},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"36":{"tf":1.4142135623730951},"37":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"56":{"tf":1.0}}}}}}}},"m":{"a":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":1,"docs":{"61":{"tf":1.4142135623730951}}}}},"d":{"df":3,"docs":{"22":{"tf":1.7320508075688772},"70":{"tf":1.0},"96":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"o":{"d":{"df":0,"docs":{},"e":{"_":{"a":{"c":{"df":0,"docs":{},"t":{"df":4,"docs":{"48":{"tf":1.0},"60":{"tf":1.0},"94":{"tf":1.0},"95":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":12,"docs":{"103":{"tf":1.7320508075688772},"112":{"tf":1.0},"22":{"tf":1.0},"37":{"tf":1.0},"48":{"tf":1.0},"59":{"tf":2.0},"60":{"tf":1.0},"65":{"tf":1.7320508075688772},"93":{"tf":1.4142135623730951},"94":{"tf":1.7320508075688772},"95":{"tf":1.0},"98":{"tf":1.0}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"65":{"tf":1.4142135623730951},"67":{"tf":1.0}}}}}}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"56":{"tf":1.4142135623730951}}}}}}},"q":{"df":0,"docs":{},"l":{"df":1,"docs":{"61":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"s":{"df":2,"docs":{"46":{"tf":1.0},"60":{"tf":1.0}},"e":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"46":{"tf":1.0},"60":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"115":{"tf":1.0}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"93":{"tf":1.0}}},"r":{"df":7,"docs":{"70":{"tf":2.0},"73":{"tf":1.7320508075688772},"81":{"tf":1.4142135623730951},"87":{"tf":2.0},"89":{"tf":2.23606797749979},"92":{"tf":1.0},"93":{"tf":1.4142135623730951}}}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"n":{"df":7,"docs":{"41":{"tf":2.0},"46":{"tf":1.0},"48":{"tf":1.0},"56":{"tf":1.0},"60":{"tf":1.7320508075688772},"70":{"tf":1.4142135623730951},"93":{"tf":2.8284271247461903}}}}}},"m":{".":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"_":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{".":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"df":1,"docs":{"10":{"tf":1.4142135623730951}}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":5,"docs":{"115":{"tf":1.0},"116":{"tf":1.7320508075688772},"70":{"tf":1.0},"94":{"tf":1.0},"96":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":3,"docs":{"105":{"tf":1.0},"29":{"tf":1.0},"63":{"tf":1.0}}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"49":{"tf":1.0}}}}}},"m":{"a":{"df":1,"docs":{"93":{"tf":1.0}},"n":{"d":{"\'":{"df":1,"docs":{"55":{"tf":1.0}}},"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"d":{"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}}},"df":0,"docs":{}}},"p":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":40,"docs":{"101":{"tf":2.0},"102":{"tf":1.7320508075688772},"103":{"tf":1.7320508075688772},"108":{"tf":1.0},"111":{"tf":1.0},"17":{"tf":1.0},"2":{"tf":1.0},"21":{"tf":1.0},"22":{"tf":1.4142135623730951},"25":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0},"31":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.4142135623730951},"44":{"tf":1.0},"45":{"tf":2.8284271247461903},"46":{"tf":1.0},"47":{"tf":1.4142135623730951},"48":{"tf":3.3166247903554},"49":{"tf":1.4142135623730951},"53":{"tf":2.8284271247461903},"54":{"tf":1.4142135623730951},"55":{"tf":2.0},"56":{"tf":2.8284271247461903},"57":{"tf":3.3166247903554},"58":{"tf":1.7320508075688772},"59":{"tf":3.605551275463989},"60":{"tf":3.4641016151377544},"68":{"tf":1.7320508075688772},"70":{"tf":1.7320508075688772},"71":{"tf":2.6457513110645907},"83":{"tf":1.4142135623730951},"93":{"tf":2.0},"94":{"tf":3.605551275463989},"95":{"tf":1.7320508075688772},"96":{"tf":1.7320508075688772},"98":{"tf":1.0},"99":{"tf":1.7320508075688772}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{".":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"112":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"112":{"tf":1.0}}},"df":0,"docs":{}}}}}},"/":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":3,"docs":{"46":{"tf":1.0},"48":{"tf":1.7320508075688772},"60":{"tf":1.7320508075688772}}}}},"df":0,"docs":{}}}},"df":10,"docs":{"119":{"tf":2.0},"37":{"tf":1.0},"48":{"tf":1.4142135623730951},"60":{"tf":1.4142135623730951},"61":{"tf":1.0},"65":{"tf":1.0},"67":{"tf":1.0},"70":{"tf":1.7320508075688772},"93":{"tf":2.449489742783178},"99":{"tf":2.8284271247461903}}}}},"i":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"o":{"_":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"49":{"tf":1.0},"60":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":5,"docs":{"104":{"tf":1.0},"49":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0},"72":{"tf":1.0}}}},"o":{"df":0,"docs":{},"n":{"df":3,"docs":{"0":{"tf":1.0},"111":{"tf":1.0},"61":{"tf":1.0}}}},"u":{"df":0,"docs":{},"n":{"df":1,"docs":{"71":{"tf":1.0}}}}},"p":{"a":{"df":0,"docs":{},"t":{"df":3,"docs":{"21":{"tf":1.0},"90":{"tf":1.0},"99":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":5,"docs":{"104":{"tf":1.0},"111":{"tf":1.0},"21":{"tf":2.0},"22":{"tf":1.0},"61":{"tf":1.0}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":13,"docs":{"103":{"tf":1.4142135623730951},"25":{"tf":1.0},"42":{"tf":1.0},"48":{"tf":2.449489742783178},"49":{"tf":1.0},"52":{"tf":1.4142135623730951},"55":{"tf":1.0},"60":{"tf":1.4142135623730951},"70":{"tf":3.3166247903554},"73":{"tf":1.4142135623730951},"83":{"tf":1.0},"93":{"tf":2.8284271247461903},"99":{"tf":1.4142135623730951}}}}},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"81":{"tf":1.4142135623730951}}},"s":{"df":1,"docs":{"61":{"tf":1.4142135623730951}},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"93":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"114":{"tf":1.0},"70":{"tf":1.4142135623730951}}}}}},"n":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"60":{"tf":1.0},"93":{"tf":1.0}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":6,"docs":{"49":{"tf":1.0},"59":{"tf":1.4142135623730951},"68":{"tf":2.0},"85":{"tf":1.0},"94":{"tf":1.0},"99":{"tf":1.0}}}}}}},"/":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"/":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":2,"docs":{"68":{"tf":1.0},"94":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"75":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":3,"docs":{"112":{"tf":1.0},"2":{"tf":1.0},"22":{"tf":1.0}}}}}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"86":{"tf":1.0}}}}}}},"df":2,"docs":{"22":{"tf":1.0},"94":{"tf":1.0}}}}}}}},"_":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{">":{"/":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"/":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"98":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":18,"docs":{"100":{"tf":2.23606797749979},"102":{"tf":2.0},"21":{"tf":1.4142135623730951},"22":{"tf":1.0},"57":{"tf":2.23606797749979},"59":{"tf":2.6457513110645907},"61":{"tf":1.0},"65":{"tf":2.0},"68":{"tf":2.6457513110645907},"70":{"tf":1.0},"73":{"tf":1.4142135623730951},"75":{"tf":1.4142135623730951},"76":{"tf":1.4142135623730951},"84":{"tf":1.0},"89":{"tf":1.0},"93":{"tf":1.4142135623730951},"94":{"tf":1.0},"99":{"tf":1.4142135623730951}},"u":{"df":0,"docs":{},"r":{"df":24,"docs":{"0":{"tf":1.0},"100":{"tf":1.4142135623730951},"101":{"tf":1.0},"102":{"tf":1.4142135623730951},"103":{"tf":1.7320508075688772},"104":{"tf":1.4142135623730951},"106":{"tf":1.0},"108":{"tf":2.449489742783178},"109":{"tf":1.0},"21":{"tf":1.4142135623730951},"22":{"tf":1.0},"24":{"tf":1.4142135623730951},"48":{"tf":1.0},"56":{"tf":1.0},"61":{"tf":1.7320508075688772},"68":{"tf":2.23606797749979},"71":{"tf":2.0},"72":{"tf":1.7320508075688772},"89":{"tf":1.0},"9":{"tf":1.4142135623730951},"94":{"tf":1.4142135623730951},"97":{"tf":1.0},"98":{"tf":2.6457513110645907},"99":{"tf":2.449489742783178}}}}},"n":{"df":1,"docs":{"44":{"tf":1.0}}}},"l":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"42":{"tf":1.7320508075688772},"51":{"tf":1.0},"93":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"70":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"59":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":4,"docs":{"116":{"tf":1.0},"46":{"tf":1.0},"56":{"tf":1.0},"60":{"tf":1.0}}}}},"df":0,"docs":{}},"i":{"d":{"df":2,"docs":{"116":{"tf":2.0},"83":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"64":{"tf":1.0}}}}},"t":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{".":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"a":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"93":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}},"df":1,"docs":{"93":{"tf":1.4142135623730951}}}}},"df":1,"docs":{"93":{"tf":1.0}},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"21":{"tf":1.0}},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"93":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":11,"docs":{"106":{"tf":1.0},"116":{"tf":1.4142135623730951},"120":{"tf":1.7320508075688772},"25":{"tf":1.0},"34":{"tf":1.0},"54":{"tf":1.0},"56":{"tf":2.23606797749979},"78":{"tf":1.0},"81":{"tf":1.0},"84":{"tf":1.4142135623730951},"87":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":15,"docs":{"120":{"tf":1.0},"121":{"tf":1.7320508075688772},"2":{"tf":1.0},"35":{"tf":1.4142135623730951},"41":{"tf":1.4142135623730951},"46":{"tf":1.4142135623730951},"48":{"tf":1.0},"49":{"tf":1.0},"52":{"tf":1.0},"53":{"tf":1.0},"54":{"tf":1.4142135623730951},"56":{"tf":2.23606797749979},"59":{"tf":1.4142135623730951},"60":{"tf":2.0},"71":{"tf":1.0}}}},"x":{"df":0,"docs":{},"t":{"df":3,"docs":{"113":{"tf":1.0},"59":{"tf":1.0},"64":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":3,"docs":{"116":{"tf":1.0},"60":{"tf":1.0},"70":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"i":{"b":{"/":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{".":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"k":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":1,"docs":{"24":{"tf":1.0}}}}}}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"24":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":3,"docs":{"112":{"tf":1.0},"114":{"tf":1.0},"37":{"tf":1.0}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"l":{"df":8,"docs":{"105":{"tf":1.0},"119":{"tf":1.0},"21":{"tf":1.0},"72":{"tf":1.0},"77":{"tf":1.0},"79":{"tf":1.0},"81":{"tf":1.0},"93":{"tf":1.4142135623730951}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"24":{"tf":1.0}}}}}}},"p":{"df":0,"docs":{},"i":{"df":6,"docs":{"2":{"tf":1.0},"24":{"tf":1.0},"32":{"tf":1.0},"46":{"tf":1.4142135623730951},"60":{"tf":1.7320508075688772},"70":{"tf":1.0}}},"y":{"_":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"60":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"46":{"tf":1.0},"60":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"46":{"tf":1.0},"60":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"75":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":3,"docs":{"14":{"tf":1.0},"3":{"tf":1.0},"30":{"tf":1.0}}},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"104":{"tf":1.0},"24":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":3,"docs":{"114":{"tf":1.0},"21":{"tf":1.0},"25":{"tf":1.0}}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":3,"docs":{"38":{"tf":1.0},"56":{"tf":1.0},"59":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"36":{"tf":1.0},"56":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"118":{"tf":1.0}}}}}},"p":{"df":2,"docs":{"22":{"tf":1.4142135623730951},"24":{"tf":1.4142135623730951}},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"61":{"tf":1.0}}}},"p":{"df":2,"docs":{"105":{"tf":1.0},"61":{"tf":1.0}}},"u":{"=":{"df":0,"docs":{},"n":{"df":1,"docs":{"21":{"tf":1.0}}}},"df":0,"docs":{}}},"q":{"df":1,"docs":{"59":{"tf":2.0}},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"59":{"tf":1.4142135623730951}}}}}},"r":{"df":1,"docs":{"70":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"t":{"df":12,"docs":{"110":{"tf":1.0},"21":{"tf":1.0},"22":{"tf":1.7320508075688772},"33":{"tf":1.0},"59":{"tf":2.0},"68":{"tf":1.0},"70":{"tf":1.0},"75":{"tf":1.0},"86":{"tf":1.7320508075688772},"94":{"tf":1.0},"95":{"tf":1.0},"98":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"64":{"tf":1.0},"88":{"tf":1.0}}}}}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"f":{"df":3,"docs":{"59":{"tf":1.0},"70":{"tf":1.4142135623730951},"72":{"tf":1.0}}}},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"d":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"90":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"t":{"df":1,"docs":{"21":{"tf":1.0}}},"y":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"61":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"61":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"s":{"df":1,"docs":{"61":{"tf":1.0}},"s":{"df":2,"docs":{"61":{"tf":1.7320508075688772},"93":{"tf":1.0}}},"v":{"df":1,"docs":{"61":{"tf":1.0}}}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":10,"docs":{"41":{"tf":2.0},"44":{"tf":2.6457513110645907},"45":{"tf":1.4142135623730951},"46":{"tf":1.0},"48":{"tf":4.47213595499958},"49":{"tf":3.0},"51":{"tf":2.8284271247461903},"52":{"tf":4.47213595499958},"94":{"tf":2.0},"96":{"tf":1.4142135623730951}}}}},"u":{"df":0,"docs":{},"e":{"df":1,"docs":{"61":{"tf":1.0}},"l":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":1,"docs":{"61":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"l":{"df":2,"docs":{"87":{"tf":1.0},"91":{"tf":1.0}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":25,"docs":{"115":{"tf":1.4142135623730951},"26":{"tf":1.0},"33":{"tf":1.0},"35":{"tf":1.4142135623730951},"36":{"tf":1.0},"37":{"tf":1.4142135623730951},"41":{"tf":2.0},"44":{"tf":1.4142135623730951},"46":{"tf":1.0},"47":{"tf":1.4142135623730951},"48":{"tf":2.8284271247461903},"50":{"tf":1.4142135623730951},"51":{"tf":1.0},"52":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":3.1622776601683795},"59":{"tf":4.58257569495584},"60":{"tf":4.358898943540674},"70":{"tf":1.7320508075688772},"72":{"tf":2.23606797749979},"75":{"tf":1.0},"81":{"tf":1.7320508075688772},"93":{"tf":1.7320508075688772},"94":{"tf":1.0},"99":{"tf":1.4142135623730951}}}}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"n":{"df":1,"docs":{"56":{"tf":1.0}}}}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"54":{"tf":2.0},"56":{"tf":2.6457513110645907}},"e":{"df":0,"docs":{},"}":{",":{"+":{"1":{"df":1,"docs":{"56":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"n":{"df":2,"docs":{"70":{"tf":1.0},"93":{"tf":1.4142135623730951}}}}}}}},"df":19,"docs":{"115":{"tf":2.0},"116":{"tf":2.8284271247461903},"29":{"tf":1.0},"31":{"tf":1.0},"44":{"tf":1.4142135623730951},"45":{"tf":1.4142135623730951},"46":{"tf":2.0},"48":{"tf":2.0},"52":{"tf":1.0},"56":{"tf":1.4142135623730951},"59":{"tf":2.0},"60":{"tf":3.1622776601683795},"63":{"tf":1.0},"70":{"tf":2.23606797749979},"72":{"tf":1.4142135623730951},"74":{"tf":2.23606797749979},"83":{"tf":1.0},"84":{"tf":2.449489742783178},"93":{"tf":2.8284271247461903}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":3,"docs":{"70":{"tf":1.0},"84":{"tf":1.0},"93":{"tf":1.4142135623730951}}}}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":9,"docs":{"0":{"tf":1.0},"117":{"tf":1.0},"22":{"tf":1.0},"53":{"tf":1.0},"68":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.0},"76":{"tf":1.0},"81":{"tf":1.0}}}}}},"t":{"df":1,"docs":{"32":{"tf":1.0}}}},"y":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"89":{"tf":1.4142135623730951}}}},"c":{"df":0,"docs":{},"l":{"df":2,"docs":{"57":{"tf":1.4142135623730951},"83":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"l":{"c":{"df":1,"docs":{"61":{"tf":1.0}}},"df":0,"docs":{}}}},"d":{"a":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"65":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"p":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":1,"docs":{"60":{"tf":1.0}}}}}}}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"a":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"60":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"60":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":1,"docs":{"60":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"n":{"a":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"60":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"l":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"60":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"60":{"tf":1.0}}}}}},"p":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"60":{"tf":1.0}}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"60":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"60":{"tf":1.0}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"60":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"c":{"df":0,"docs":{},"k":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"60":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":1,"docs":{"60":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"60":{"tf":1.0}}}}}}},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"_":{"b":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"k":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"60":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"v":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"60":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"61":{"tf":1.4142135623730951}}}},"s":{"df":0,"docs":{},"h":{"df":2,"docs":{"91":{"tf":1.0},"94":{"tf":1.0}}}},"t":{"a":{"df":3,"docs":{"32":{"tf":1.0},"70":{"tf":1.0},"93":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":3,"docs":{"111":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.4142135623730951}}}}},"b":{"df":0,"docs":{},"g":{"df":1,"docs":{"59":{"tf":1.4142135623730951}}},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"61":{"tf":1.0}}}}},"df":12,"docs":{"22":{"tf":1.0},"44":{"tf":1.0},"45":{"tf":1.4142135623730951},"48":{"tf":3.1622776601683795},"49":{"tf":1.4142135623730951},"51":{"tf":1.0},"52":{"tf":1.4142135623730951},"56":{"tf":1.4142135623730951},"57":{"tf":1.4142135623730951},"60":{"tf":4.47213595499958},"61":{"tf":1.4142135623730951},"94":{"tf":1.0}},"e":{"b":{"df":2,"docs":{"25":{"tf":3.0},"5":{"tf":1.0}},"i":{"a":{"df":0,"docs":{},"n":{"df":4,"docs":{"21":{"tf":1.0},"25":{"tf":1.4142135623730951},"5":{"tf":1.4142135623730951},"61":{"tf":1.0}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"g":{"df":4,"docs":{"48":{"tf":1.0},"59":{"tf":2.8284271247461903},"60":{"tf":1.7320508075688772},"93":{"tf":1.4142135623730951}}}}},"c":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":6,"docs":{"103":{"tf":1.0},"117":{"tf":1.0},"118":{"tf":1.0},"60":{"tf":1.0},"73":{"tf":1.4142135623730951},"94":{"tf":1.0}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"116":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"45":{"tf":1.4142135623730951},"60":{"tf":1.4142135623730951}}}}}}}}},"d":{"df":0,"docs":{},"i":{"c":{"df":2,"docs":{"119":{"tf":1.0},"95":{"tf":1.0}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"75":{"tf":1.0}}}}}},"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":43,"docs":{"102":{"tf":1.0},"103":{"tf":1.4142135623730951},"114":{"tf":1.0},"116":{"tf":2.23606797749979},"118":{"tf":1.0},"120":{"tf":1.4142135623730951},"121":{"tf":1.0},"17":{"tf":1.0},"2":{"tf":1.0},"24":{"tf":1.0},"27":{"tf":1.0},"32":{"tf":1.0},"34":{"tf":1.7320508075688772},"42":{"tf":1.0},"43":{"tf":1.0},"47":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.0},"54":{"tf":1.0},"59":{"tf":2.6457513110645907},"60":{"tf":1.0},"61":{"tf":1.0},"70":{"tf":2.23606797749979},"72":{"tf":1.4142135623730951},"73":{"tf":1.7320508075688772},"74":{"tf":1.0},"75":{"tf":1.4142135623730951},"76":{"tf":1.4142135623730951},"77":{"tf":1.0},"78":{"tf":1.0},"79":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.7320508075688772},"82":{"tf":1.0},"83":{"tf":1.7320508075688772},"84":{"tf":1.7320508075688772},"86":{"tf":1.0},"87":{"tf":1.4142135623730951},"89":{"tf":2.0},"93":{"tf":1.4142135623730951},"94":{"tf":1.0},"98":{"tf":1.0},"99":{"tf":1.4142135623730951}}}}}},"df":1,"docs":{"116":{"tf":2.449489742783178}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"87":{"tf":1.0}}}},"i":{"df":0,"docs":{},"n":{"df":12,"docs":{"0":{"tf":1.0},"103":{"tf":1.0},"104":{"tf":1.0},"113":{"tf":1.4142135623730951},"120":{"tf":1.7320508075688772},"32":{"tf":1.0},"33":{"tf":1.0},"72":{"tf":1.4142135623730951},"74":{"tf":1.0},"86":{"tf":1.0},"89":{"tf":1.4142135623730951},"99":{"tf":1.0}},"i":{"df":0,"docs":{},"t":{"df":4,"docs":{"103":{"tf":2.0},"48":{"tf":2.0},"60":{"tf":2.0},"95":{"tf":1.0}}}}}}},"l":{"a":{"df":0,"docs":{},"y":{".":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"77":{"tf":1.0}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"77":{"tf":1.4142135623730951}}}}}}}}}},"df":0,"docs":{}}},"df":2,"docs":{"60":{"tf":1.4142135623730951},"96":{"tf":1.0}},"e":{"df":0,"docs":{},"t":{"df":12,"docs":{"29":{"tf":1.0},"33":{"tf":1.7320508075688772},"36":{"tf":1.0},"45":{"tf":2.0},"48":{"tf":1.0},"49":{"tf":2.8284271247461903},"52":{"tf":3.0},"60":{"tf":3.0},"63":{"tf":1.0},"93":{"tf":1.0},"94":{"tf":1.0},"96":{"tf":1.0}},"e":{"_":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{"_":{"b":{"a":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":2,"docs":{"49":{"tf":1.0},"60":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":2,"docs":{"49":{"tf":1.0},"60":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"45":{"tf":1.0},"60":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"y":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":2,"docs":{"45":{"tf":1.0},"60":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"_":{"b":{"a":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":2,"docs":{"49":{"tf":1.0},"60":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":2,"docs":{"49":{"tf":1.0},"60":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"56":{"tf":1.4142135623730951},"93":{"tf":1.0}}}}}},"t":{"a":{"df":1,"docs":{"93":{"tf":1.0}}},"df":0,"docs":{}}},"m":{"df":0,"docs":{},"o":{"df":3,"docs":{"36":{"tf":1.0},"37":{"tf":1.4142135623730951},"38":{"tf":1.0}},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"118":{"tf":1.0}}}}}}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":8,"docs":{"114":{"tf":1.0},"117":{"tf":1.0},"22":{"tf":1.0},"25":{"tf":2.0},"54":{"tf":1.0},"57":{"tf":1.4142135623730951},"70":{"tf":1.0},"79":{"tf":1.0}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"78":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"c":{"df":2,"docs":{"90":{"tf":1.0},"93":{"tf":1.0}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"75":{"tf":1.4142135623730951}}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":2,"docs":{"25":{"tf":1.4142135623730951},"93":{"tf":1.0}}}}},"s":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"116":{"tf":1.0}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"i":{"b":{"df":4,"docs":{"103":{"tf":1.0},"25":{"tf":1.0},"42":{"tf":1.0},"93":{"tf":1.0}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":28,"docs":{"102":{"tf":1.0},"104":{"tf":1.4142135623730951},"44":{"tf":1.0},"45":{"tf":1.4142135623730951},"46":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":3.1622776601683795},"49":{"tf":1.4142135623730951},"51":{"tf":1.0},"52":{"tf":1.0},"56":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.0},"70":{"tf":1.0},"72":{"tf":1.4142135623730951},"73":{"tf":1.0},"74":{"tf":1.0},"75":{"tf":1.0},"77":{"tf":1.0},"78":{"tf":1.0},"79":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.4142135623730951},"82":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":1.0},"93":{"tf":1.4142135623730951},"99":{"tf":1.0}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":1,"docs":{"49":{"tf":1.0}}}},"r":{"df":1,"docs":{"116":{"tf":1.0}}}},"k":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":4,"docs":{"12":{"tf":1.0},"21":{"tf":1.0},"24":{"tf":2.449489742783178},"25":{"tf":1.4142135623730951}}}}}}},"t":{"a":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"72":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":4,"docs":{"21":{"tf":1.0},"48":{"tf":1.0},"70":{"tf":1.0},"88":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"100":{"tf":1.0},"70":{"tf":1.4142135623730951},"99":{"tf":1.0}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":4,"docs":{"100":{"tf":1.4142135623730951},"115":{"tf":1.0},"93":{"tf":1.0},"99":{"tf":1.0}}}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":4,"docs":{"111":{"tf":1.0},"22":{"tf":1.0},"59":{"tf":1.0},"9":{"tf":1.4142135623730951}}}}}},"i":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"61":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"h":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"61":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"i":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":11,"docs":{"103":{"tf":1.4142135623730951},"48":{"tf":2.449489742783178},"59":{"tf":1.0},"60":{"tf":2.449489742783178},"69":{"tf":1.0},"70":{"tf":2.449489742783178},"72":{"tf":2.8284271247461903},"81":{"tf":1.7320508075688772},"84":{"tf":4.123105625617661},"93":{"tf":3.4641016151377544},"99":{"tf":2.6457513110645907}},"i":{"c":{"(":{"df":1,"docs":{"59":{"tf":1.0}}},".":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":1,"docs":{"93":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"93":{"tf":1.0}}}}}}},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"93":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":1,"docs":{"93":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"93":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"w":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"93":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"k":{"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"112":{"tf":1.0}}}},"df":0,"docs":{}}}},"d":{"df":0,"docs":{},"n":{"\'":{"df":0,"docs":{},"t":{"df":1,"docs":{"25":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{".":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"a":{"df":1,"docs":{"81":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":1,"docs":{"81":{"tf":1.0}}}}}},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":1,"docs":{"81":{"tf":1.0}}}}}},"df":5,"docs":{"59":{"tf":1.4142135623730951},"61":{"tf":1.0},"70":{"tf":1.4142135623730951},"81":{"tf":2.449489742783178},"93":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":11,"docs":{"103":{"tf":1.0},"114":{"tf":1.4142135623730951},"118":{"tf":1.0},"119":{"tf":1.0},"27":{"tf":1.4142135623730951},"47":{"tf":1.0},"59":{"tf":1.0},"63":{"tf":1.0},"70":{"tf":1.4142135623730951},"72":{"tf":1.0},"84":{"tf":1.0}}}},"g":{"df":1,"docs":{"59":{"tf":1.0}},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"59":{"tf":1.0}}}}}}},"m":{"df":1,"docs":{"90":{"tf":1.0}}},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"46":{"tf":1.0},"55":{"tf":1.0},"93":{"tf":1.4142135623730951}},"l":{"df":0,"docs":{},"i":{"df":4,"docs":{"27":{"tf":1.0},"57":{"tf":1.0},"64":{"tf":1.0},"65":{"tf":1.0}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":20,"docs":{"100":{"tf":1.7320508075688772},"102":{"tf":1.0},"104":{"tf":1.0},"110":{"tf":1.0},"112":{"tf":1.0},"2":{"tf":1.7320508075688772},"21":{"tf":2.0},"22":{"tf":3.605551275463989},"41":{"tf":1.0},"48":{"tf":1.0},"59":{"tf":2.0},"60":{"tf":2.0},"68":{"tf":1.7320508075688772},"70":{"tf":1.7320508075688772},"75":{"tf":1.7320508075688772},"86":{"tf":1.4142135623730951},"93":{"tf":1.0},"94":{"tf":1.0},"98":{"tf":1.4142135623730951},"99":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"s":{"a":{"b":{"df":0,"docs":{},"l":{"df":10,"docs":{"114":{"tf":1.0},"49":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.0},"70":{"tf":1.7320508075688772},"73":{"tf":1.0},"76":{"tf":1.0},"84":{"tf":2.23606797749979},"96":{"tf":1.0},"98":{"tf":1.0}}}},"df":0,"docs":{}},"c":{"a":{"df":0,"docs":{},"r":{"d":{"df":2,"docs":{"35":{"tf":1.0},"59":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"64":{"tf":1.0}}}}}},"df":0,"docs":{},"k":{"df":2,"docs":{"59":{"tf":3.3166247903554},"70":{"tf":1.0}}},"p":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"y":{"df":7,"docs":{"48":{"tf":2.0},"59":{"tf":1.7320508075688772},"70":{"tf":2.23606797749979},"72":{"tf":1.4142135623730951},"73":{"tf":3.1622776601683795},"81":{"tf":1.4142135623730951},"99":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"a":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"70":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":2,"docs":{"72":{"tf":1.0},"94":{"tf":1.0}}}}}}}}},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"120":{"tf":1.0},"22":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"65":{"tf":1.0}}}}}}},"j":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":1,"docs":{"61":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"61":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"f":{"df":1,"docs":{"7":{"tf":1.0}}}},"o":{"c":{"df":6,"docs":{"0":{"tf":1.0},"52":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0},"73":{"tf":1.4142135623730951},"93":{"tf":1.7320508075688772}},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"108":{"tf":1.0}}}}},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"61":{"tf":1.7320508075688772}},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"61":{"tf":1.0}}}}}}}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"\'":{"df":1,"docs":{"59":{"tf":1.0}}},"df":21,"docs":{"102":{"tf":1.0},"103":{"tf":1.7320508075688772},"108":{"tf":1.4142135623730951},"112":{"tf":1.0},"115":{"tf":1.0},"121":{"tf":1.4142135623730951},"21":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"48":{"tf":2.6457513110645907},"51":{"tf":1.0},"56":{"tf":3.0},"59":{"tf":1.0},"60":{"tf":1.0},"70":{"tf":1.7320508075688772},"76":{"tf":1.0},"93":{"tf":2.449489742783178},"94":{"tf":1.4142135623730951},"99":{"tf":1.0}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"102":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"n":{"\'":{"df":0,"docs":{},"t":{"df":3,"docs":{"100":{"tf":1.0},"103":{"tf":1.0},"113":{"tf":1.0}}}},"df":0,"docs":{}}}},"n":{"\'":{"df":0,"docs":{},"t":{"df":3,"docs":{"118":{"tf":1.0},"25":{"tf":1.0},"83":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":1,"docs":{"113":{"tf":1.0}}}},"t":{"df":3,"docs":{"61":{"tf":1.4142135623730951},"87":{"tf":1.4142135623730951},"91":{"tf":1.0}}},"u":{"b":{"df":0,"docs":{},"l":{"df":4,"docs":{"54":{"tf":1.4142135623730951},"56":{"tf":1.4142135623730951},"57":{"tf":1.0},"93":{"tf":1.0}},"e":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"91":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"w":{"df":0,"docs":{},"n":{"df":8,"docs":{"44":{"tf":2.0},"46":{"tf":1.4142135623730951},"48":{"tf":2.6457513110645907},"49":{"tf":1.7320508075688772},"51":{"tf":1.4142135623730951},"52":{"tf":1.0},"60":{"tf":4.0},"96":{"tf":1.7320508075688772}},"l":{"df":0,"docs":{},"o":{"a":{"d":{"df":2,"docs":{"12":{"tf":1.0},"2":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"48":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"r":{"a":{"df":0,"docs":{},"w":{"df":1,"docs":{"70":{"tf":1.0}}}},"df":0,"docs":{}},"t":{"d":{"df":1,"docs":{"61":{"tf":1.0}}},"df":1,"docs":{"61":{"tf":1.0}}},"u":{"df":0,"docs":{},"e":{"df":3,"docs":{"74":{"tf":1.0},"83":{"tf":1.0},"94":{"tf":1.0}}},"n":{"df":0,"docs":{},"e":{"df":1,"docs":{"61":{"tf":1.0}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"c":{"df":1,"docs":{"61":{"tf":1.0}}},"df":0,"docs":{}}}}},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"57":{"tf":1.0}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"e":{"df":4,"docs":{"21":{"tf":1.0},"50":{"tf":1.0},"85":{"tf":1.0},"93":{"tf":1.7320508075688772}}}}}},"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"g":{"df":5,"docs":{"0":{"tf":1.0},"100":{"tf":1.0},"103":{"tf":1.0},"93":{"tf":2.8284271247461903},"94":{"tf":2.0}}}},"a":{"c":{"df":0,"docs":{},"h":{"df":16,"docs":{"103":{"tf":1.0},"114":{"tf":1.0},"115":{"tf":1.0},"116":{"tf":1.0},"117":{"tf":1.0},"45":{"tf":2.23606797749979},"48":{"tf":1.0},"57":{"tf":1.0},"59":{"tf":2.0},"70":{"tf":1.0},"74":{"tf":1.0},"79":{"tf":1.0},"87":{"tf":1.0},"9":{"tf":1.0},"94":{"tf":1.0},"99":{"tf":1.0}}}},"df":0,"docs":{},"r":{"df":1,"docs":{"59":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"64":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"45":{"tf":1.0},"59":{"tf":1.4142135623730951},"60":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"61":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"y":{"df":0,"docs":{},"l":{"df":1,"docs":{"61":{"tf":1.0}}}}}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"64":{"tf":1.0}}}},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"64":{"tf":1.0},"68":{"tf":1.0}}}}}}},"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":5,"docs":{"50":{"tf":1.0},"54":{"tf":2.23606797749979},"56":{"tf":3.3166247903554},"57":{"tf":1.4142135623730951},"59":{"tf":1.0}}}},"m":{"a":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"93":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"62":{"tf":1.4142135623730951}}}}}}}}}},"d":{"df":0,"docs":{},"g":{"df":2,"docs":{"0":{"tf":1.0},"70":{"tf":1.0}}},"i":{"df":0,"docs":{},"t":{"df":17,"docs":{"22":{"tf":1.0},"27":{"tf":1.0},"29":{"tf":1.0},"30":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.7320508075688772},"59":{"tf":2.0},"60":{"tf":1.4142135623730951},"63":{"tf":1.0},"64":{"tf":1.4142135623730951},"65":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.0},"77":{"tf":1.4142135623730951},"83":{"tf":1.4142135623730951},"93":{"tf":2.8284271247461903},"94":{"tf":1.0}},"o":{"df":0,"docs":{},"r":{".":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":3,"docs":{"69":{"tf":1.4142135623730951},"76":{"tf":1.4142135623730951},"77":{"tf":1.0}}}}}},"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"b":{"df":0,"docs":{},"o":{"a":{"df":0,"docs":{},"r":{"d":{"df":2,"docs":{"69":{"tf":1.0},"71":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"93":{"tf":1.7320508075688772}}}}},"m":{"/":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"0":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":3,"docs":{"68":{"tf":1.0},"69":{"tf":1.0},"74":{"tf":1.0}}}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":3,"docs":{"68":{"tf":1.0},"69":{"tf":1.0},"75":{"tf":1.0}}}}},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":2,"docs":{"69":{"tf":1.0},"81":{"tf":2.0}},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{".":{"d":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"69":{"tf":1.0},"81":{"tf":1.0}}}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":2,"docs":{"69":{"tf":1.0},"81":{"tf":1.0}}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"69":{"tf":1.0},"81":{"tf":1.4142135623730951}}}}},"s":{"df":0,"docs":{},"p":{"a":{"c":{"df":2,"docs":{"69":{"tf":1.0},"81":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}}},"i":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"69":{"tf":1.0},"80":{"tf":1.4142135623730951}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"69":{"tf":1.0},"84":{"tf":1.4142135623730951}}}}}}},"l":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":2,"docs":{"69":{"tf":1.0},"73":{"tf":1.0}}}}},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"99":{"tf":1.0}}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":2,"docs":{"93":{"tf":1.0},"99":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"h":{"df":2,"docs":{"69":{"tf":1.0},"78":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":2,"docs":{"69":{"tf":1.0},"83":{"tf":1.0}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":4,"docs":{"69":{"tf":1.0},"82":{"tf":1.4142135623730951},"84":{"tf":1.0},"93":{"tf":1.0}},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"99":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"t":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"69":{"tf":1.0},"72":{"tf":1.7320508075688772}},"e":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"72":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"99":{"tf":1.0}}}}}},"w":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"a":{"c":{"df":2,"docs":{"69":{"tf":1.0},"79":{"tf":1.4142135623730951}},"e":{".":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"79":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"79":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}},"/":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"df":1,"docs":{"21":{"tf":1.0}}}}}}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":1,"docs":{"70":{"tf":1.0}}}}}}}},"df":18,"docs":{"0":{"tf":1.0},"27":{"tf":1.0},"32":{"tf":1.0},"49":{"tf":1.4142135623730951},"53":{"tf":1.0},"56":{"tf":1.0},"59":{"tf":1.0},"6":{"tf":1.0},"65":{"tf":1.4142135623730951},"68":{"tf":1.0},"69":{"tf":1.4142135623730951},"70":{"tf":2.0},"71":{"tf":1.0},"72":{"tf":1.4142135623730951},"76":{"tf":1.7320508075688772},"81":{"tf":1.0},"84":{"tf":1.0},"93":{"tf":1.0}}}}}},"o":{"c":{"df":1,"docs":{"61":{"tf":1.0}}},"df":0,"docs":{}}},"df":7,"docs":{"24":{"tf":1.4142135623730951},"44":{"tf":1.4142135623730951},"46":{"tf":1.0},"48":{"tf":1.0},"52":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":3.1622776601683795}},"e":{"df":0,"docs":{},"x":{"df":1,"docs":{"61":{"tf":1.0}}}},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"73":{"tf":1.0},"84":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"m":{"df":2,"docs":{"102":{"tf":1.0},"103":{"tf":1.7320508075688772}}}},"j":{"df":1,"docs":{"61":{"tf":1.0}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":4,"docs":{"116":{"tf":1.4142135623730951},"38":{"tf":1.0},"39":{"tf":1.0},"72":{"tf":3.1622776601683795}}}}}}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":1,"docs":{"61":{"tf":1.0}}}},"x":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":1,"docs":{"61":{"tf":1.7320508075688772}}}}}},"m":{"df":1,"docs":{"61":{"tf":1.4142135623730951}}},"p":{"df":1,"docs":{"61":{"tf":1.0}}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"61":{"tf":1.4142135623730951}}}}}}},"m":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"61":{"tf":1.7320508075688772}}}},"r":{"a":{"c":{"df":1,"docs":{"83":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"70":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"l":{"df":3,"docs":{"90":{"tf":1.0},"91":{"tf":1.0},"96":{"tf":1.0}}}}},"n":{"a":{"b":{"df":0,"docs":{},"l":{"df":14,"docs":{"103":{"tf":1.4142135623730951},"60":{"tf":1.0},"70":{"tf":2.0},"73":{"tf":2.0},"75":{"tf":2.6457513110645907},"76":{"tf":1.0},"77":{"tf":1.4142135623730951},"78":{"tf":1.0},"79":{"tf":1.0},"82":{"tf":1.7320508075688772},"83":{"tf":1.0},"84":{"tf":1.4142135623730951},"9":{"tf":1.0},"93":{"tf":2.6457513110645907}},"e":{"/":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"103":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"o":{"d":{"df":3,"docs":{"59":{"tf":1.4142135623730951},"72":{"tf":2.0},"96":{"tf":1.7320508075688772}}},"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"111":{"tf":1.0},"118":{"tf":1.0}}}},"r":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"49":{"tf":1.0}}}},"df":0,"docs":{}}}}},"d":{"df":22,"docs":{"115":{"tf":1.7320508075688772},"116":{"tf":2.449489742783178},"22":{"tf":1.0},"41":{"tf":1.0},"44":{"tf":2.0},"45":{"tf":1.0},"46":{"tf":1.0},"48":{"tf":1.4142135623730951},"49":{"tf":2.0},"50":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.7320508075688772},"55":{"tf":1.0},"56":{"tf":2.0},"59":{"tf":1.4142135623730951},"60":{"tf":5.0990195135927845},"70":{"tf":2.8284271247461903},"72":{"tf":1.7320508075688772},"82":{"tf":1.0},"84":{"tf":2.0},"96":{"tf":1.4142135623730951},"99":{"tf":1.4142135623730951}}},"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"c":{"df":2,"docs":{"83":{"tf":1.0},"96":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"j":{"df":0,"docs":{},"o":{"df":0,"docs":{},"y":{"df":1,"docs":{"83":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":7,"docs":{"100":{"tf":1.0},"111":{"tf":1.0},"116":{"tf":1.0},"21":{"tf":1.0},"42":{"tf":1.0},"46":{"tf":1.0},"60":{"tf":1.0}},"e":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":2,"docs":{"46":{"tf":1.0},"60":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":13,"docs":{"25":{"tf":1.0},"33":{"tf":1.0},"36":{"tf":1.0},"41":{"tf":1.4142135623730951},"45":{"tf":1.4142135623730951},"48":{"tf":3.3166247903554},"49":{"tf":1.0},"51":{"tf":1.4142135623730951},"52":{"tf":1.0},"56":{"tf":1.0},"60":{"tf":1.7320508075688772},"93":{"tf":1.0},"94":{"tf":1.7320508075688772}}}},"i":{"df":0,"docs":{},"r":{"df":5,"docs":{"116":{"tf":1.4142135623730951},"121":{"tf":1.0},"46":{"tf":1.0},"64":{"tf":1.0},"70":{"tf":1.4142135623730951}}}},"r":{"df":0,"docs":{},"i":{"df":5,"docs":{"103":{"tf":1.0},"108":{"tf":1.0},"109":{"tf":1.0},"48":{"tf":1.4142135623730951},"51":{"tf":2.0}}},"y":{".":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"112":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"112":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"m":{"df":1,"docs":{"93":{"tf":1.0}}}},"v":{"1":{"df":1,"docs":{"102":{"tf":1.0}}},"2":{"df":1,"docs":{"102":{"tf":1.0}}},":":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"d":{"a":{"df":0,"docs":{},"t":{"a":{"\\\\":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"\\\\":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"22":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":1,"docs":{"61":{"tf":1.0}},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":9,"docs":{"102":{"tf":1.7320508075688772},"111":{"tf":1.0},"2":{"tf":1.0},"21":{"tf":1.4142135623730951},"22":{"tf":2.23606797749979},"24":{"tf":1.0},"25":{"tf":1.0},"70":{"tf":1.0},"74":{"tf":1.0}}}}}}}},"q":{"?":{"/":{"#":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"117":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":2,"docs":{"117":{"tf":1.4142135623730951},"122":{"tf":1.0}},"u":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"117":{"tf":1.4142135623730951},"122":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":6,"docs":{"103":{"tf":1.0},"22":{"tf":1.0},"54":{"tf":1.0},"56":{"tf":1.0},"84":{"tf":1.0},"90":{"tf":1.0}}}},"df":0,"docs":{}}}}},"r":{"b":{"df":1,"docs":{"61":{"tf":1.0}}},"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"/":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":1,"docs":{"93":{"tf":1.0}}}}}}}}},"_":{"df":0,"docs":{},"l":{"df":1,"docs":{"61":{"tf":1.0}}}},"df":1,"docs":{"61":{"tf":1.0}}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":6,"docs":{"111":{"tf":1.0},"114":{"tf":1.0},"72":{"tf":2.449489742783178},"84":{"tf":1.4142135623730951},"93":{"tf":1.7320508075688772},"99":{"tf":1.0}}}}}},"s":{"c":{"a":{"df":0,"docs":{},"p":{"df":10,"docs":{"43":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.4142135623730951},"51":{"tf":1.0},"52":{"tf":1.0},"54":{"tf":1.7320508075688772},"56":{"tf":1.0},"93":{"tf":1.0},"94":{"tf":1.0},"96":{"tf":1.0}}}},"df":3,"docs":{"60":{"tf":1.7320508075688772},"94":{"tf":1.4142135623730951},"96":{"tf":1.0}}},"d":{"df":0,"docs":{},"l":{"df":1,"docs":{"61":{"tf":1.0}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"61":{"tf":1.4142135623730951}}}}}}},"t":{"c":{"df":10,"docs":{"0":{"tf":1.0},"100":{"tf":1.0},"112":{"tf":1.0},"29":{"tf":1.4142135623730951},"35":{"tf":1.0},"37":{"tf":1.4142135623730951},"63":{"tf":1.4142135623730951},"76":{"tf":1.0},"93":{"tf":3.0},"96":{"tf":1.0}}},"df":1,"docs":{"120":{"tf":1.0}}},"v":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"59":{"tf":1.0}},"u":{"df":3,"docs":{"56":{"tf":1.7320508075688772},"57":{"tf":1.0},"59":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":3,"docs":{"100":{"tf":1.0},"25":{"tf":1.0},"37":{"tf":1.0}},"t":{"df":3,"docs":{"39":{"tf":1.0},"70":{"tf":1.4142135623730951},"77":{"tf":1.0}},"u":{"df":1,"docs":{"81":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"y":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":7,"docs":{"0":{"tf":1.0},"103":{"tf":1.0},"116":{"tf":1.7320508075688772},"118":{"tf":1.7320508075688772},"23":{"tf":1.0},"25":{"tf":1.0},"57":{"tf":1.0}}}}}}}},"x":{"a":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"116":{"tf":1.0},"117":{"tf":1.0}}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":41,"docs":{"100":{"tf":1.7320508075688772},"102":{"tf":1.4142135623730951},"103":{"tf":1.7320508075688772},"104":{"tf":1.4142135623730951},"112":{"tf":1.4142135623730951},"113":{"tf":1.0},"114":{"tf":1.0},"116":{"tf":2.0},"118":{"tf":1.4142135623730951},"119":{"tf":1.4142135623730951},"12":{"tf":1.0},"21":{"tf":1.4142135623730951},"22":{"tf":1.4142135623730951},"24":{"tf":1.0},"30":{"tf":1.0},"31":{"tf":1.0},"33":{"tf":1.0},"36":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":1.0},"41":{"tf":1.7320508075688772},"50":{"tf":1.0},"53":{"tf":1.0},"54":{"tf":1.7320508075688772},"55":{"tf":1.0},"56":{"tf":3.0},"57":{"tf":2.449489742783178},"59":{"tf":1.4142135623730951},"68":{"tf":1.4142135623730951},"75":{"tf":1.0},"76":{"tf":1.0},"79":{"tf":1.4142135623730951},"8":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.4142135623730951},"82":{"tf":1.0},"93":{"tf":1.0},"94":{"tf":1.4142135623730951},"96":{"tf":1.0},"98":{"tf":1.0},"99":{"tf":2.0}}}}}},"c":{"df":0,"docs":{},"e":{"df":1,"docs":{"82":{"tf":1.0}},"p":{"df":0,"docs":{},"t":{"df":10,"docs":{"103":{"tf":1.7320508075688772},"105":{"tf":1.0},"118":{"tf":1.7320508075688772},"41":{"tf":1.0},"48":{"tf":1.0},"51":{"tf":1.0},"53":{"tf":1.4142135623730951},"57":{"tf":1.0},"60":{"tf":1.7320508075688772},"93":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"u":{"d":{"df":2,"docs":{"121":{"tf":1.0},"75":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":11,"docs":{"102":{"tf":1.0},"12":{"tf":1.0},"21":{"tf":1.0},"22":{"tf":1.0},"34":{"tf":1.0},"53":{"tf":1.0},"56":{"tf":2.0},"57":{"tf":1.0},"60":{"tf":1.7320508075688772},"93":{"tf":1.4142135623730951},"94":{"tf":2.0}}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":5,"docs":{"108":{"tf":1.0},"114":{"tf":1.4142135623730951},"70":{"tf":1.0},"84":{"tf":1.0},"92":{"tf":1.0}}}},"t":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"60":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":5,"docs":{"48":{"tf":1.0},"59":{"tf":2.0},"60":{"tf":1.0},"94":{"tf":1.0},"95":{"tf":1.0}}}},"p":{"a":{"df":0,"docs":{},"n":{"d":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"46":{"tf":1.0},"60":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":5,"docs":{"39":{"tf":1.0},"46":{"tf":1.0},"54":{"tf":1.0},"56":{"tf":1.4142135623730951},"60":{"tf":1.4142135623730951}}},"df":0,"docs":{},"s":{"df":6,"docs":{"101":{"tf":1.0},"53":{"tf":1.4142135623730951},"54":{"tf":1.0},"56":{"tf":3.605551275463989},"57":{"tf":1.4142135623730951},"99":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"114":{"tf":1.4142135623730951},"23":{"tf":1.0},"42":{"tf":1.0}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":3,"docs":{"22":{"tf":1.0},"49":{"tf":1.4142135623730951},"83":{"tf":1.0}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"45":{"tf":1.4142135623730951},"48":{"tf":1.0}}}}}}}}},"l":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"48":{"tf":1.0}}}},"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"118":{"tf":1.0},"83":{"tf":1.0}}}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"60":{"tf":1.7320508075688772}}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":2,"docs":{"22":{"tf":1.7320508075688772},"93":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":4,"docs":{"116":{"tf":1.4142135623730951},"117":{"tf":1.4142135623730951},"59":{"tf":1.0},"93":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{".":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":1,"docs":{"116":{"tf":2.0}}}}}}},"_":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":1,"docs":{"60":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":1,"docs":{"60":{"tf":1.0}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"60":{"tf":1.0},"94":{"tf":1.4142135623730951}},"e":{"_":{"a":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":1,"docs":{"60":{"tf":1.0}}}}},"df":0,"docs":{}},"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":2,"docs":{"46":{"tf":1.0},"60":{"tf":1.0}}}}}}},"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":1,"docs":{"60":{"tf":1.0}}}}}},"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":1,"docs":{"60":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"_":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"60":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"60":{"tf":1.0}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"60":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"s":{"df":0,"docs":{},"u":{"b":{"_":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"60":{"tf":1.0}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"60":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"60":{"tf":1.0}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"60":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"p":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"60":{"tf":1.0},"83":{"tf":1.0}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":2,"docs":{"60":{"tf":1.0},"83":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"_":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"60":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"60":{"tf":1.0}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"60":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"s":{"df":0,"docs":{},"u":{"b":{"_":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"60":{"tf":1.0}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"60":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"60":{"tf":1.0}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"60":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"s":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"h":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"60":{"tf":1.0}}}}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":1,"docs":{"60":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"_":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"60":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"_":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"60":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"o":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"n":{"df":1,"docs":{"60":{"tf":1.0}}}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"60":{"tf":1.0}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"60":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"a":{"c":{"df":1,"docs":{"60":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}}}}},"df":0,"docs":{}}}}}},"l":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"60":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"_":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"46":{"tf":1.0},"60":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"60":{"tf":1.0}}}}}}}}},"df":1,"docs":{"60":{"tf":1.0}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"60":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"60":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"_":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":1,"docs":{"60":{"tf":1.0}}}}}},"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":1,"docs":{"60":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":8,"docs":{"108":{"tf":1.0},"116":{"tf":3.7416573867739413},"42":{"tf":1.0},"46":{"tf":1.4142135623730951},"48":{"tf":1.0},"50":{"tf":2.0},"60":{"tf":6.324555320336759},"92":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":6,"docs":{"100":{"tf":1.4142135623730951},"116":{"tf":2.0},"119":{"tf":1.0},"120":{"tf":2.0},"121":{"tf":1.0},"65":{"tf":1.4142135623730951}}}},"r":{"df":0,"docs":{},"n":{"df":2,"docs":{"59":{"tf":1.0},"70":{"tf":1.0}}}}},"r":{"a":{"df":4,"docs":{"102":{"tf":1.0},"3":{"tf":1.0},"8":{"tf":1.7320508075688772},"83":{"tf":1.0}}},"df":0,"docs":{}}}}},"f":{"a":{"c":{"df":0,"docs":{},"e":{"df":1,"docs":{"60":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"25":{"tf":1.0}}}},"l":{"df":0,"docs":{},"l":{"b":{"a":{"c":{"df":0,"docs":{},"k":{"df":3,"docs":{"22":{"tf":1.0},"70":{"tf":1.4142135623730951},"93":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"s":{"df":11,"docs":{"59":{"tf":1.0},"68":{"tf":1.4142135623730951},"70":{"tf":3.1622776601683795},"73":{"tf":1.7320508075688772},"76":{"tf":1.7320508075688772},"77":{"tf":1.4142135623730951},"80":{"tf":1.0},"82":{"tf":1.4142135623730951},"83":{"tf":1.0},"93":{"tf":1.0},"98":{"tf":1.0}}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"49":{"tf":1.0}}}},"df":0,"docs":{}}}}},"q":{"df":1,"docs":{"0":{"tf":1.0}}},"r":{"df":1,"docs":{"25":{"tf":1.0}}},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"115":{"tf":1.4142135623730951},"116":{"tf":2.449489742783178}}}}},"df":8,"docs":{"24":{"tf":1.4142135623730951},"31":{"tf":1.0},"37":{"tf":1.4142135623730951},"38":{"tf":1.0},"44":{"tf":2.449489742783178},"48":{"tf":2.8284271247461903},"52":{"tf":1.4142135623730951},"60":{"tf":3.7416573867739413}},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":9,"docs":{"103":{"tf":3.1622776601683795},"21":{"tf":1.0},"38":{"tf":1.0},"53":{"tf":1.0},"61":{"tf":1.0},"65":{"tf":1.0},"66":{"tf":1.7320508075688772},"67":{"tf":1.0},"70":{"tf":1.0}}}}}},"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"a":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":2,"docs":{"3":{"tf":1.0},"7":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"d":{"df":2,"docs":{"116":{"tf":1.4142135623730951},"56":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"n":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"61":{"tf":1.4142135623730951}}}}}},"t":{"c":{"df":0,"docs":{},"h":{"df":4,"docs":{"104":{"tf":1.4142135623730951},"105":{"tf":1.7320508075688772},"111":{"tf":1.4142135623730951},"21":{"tf":2.0}}}},"df":0,"docs":{}},"w":{"df":2,"docs":{"116":{"tf":1.0},"119":{"tf":1.0}}}},"f":{"0":{"0":{"0":{"0":{"df":1,"docs":{"87":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"70":{"tf":1.0}},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":2,"docs":{"87":{"tf":1.7320508075688772},"89":{"tf":1.0}}}}}}},"g":{"a":{"df":1,"docs":{"61":{"tf":1.0}}},"df":3,"docs":{"87":{"tf":1.4142135623730951},"92":{"tf":1.0},"93":{"tf":1.0}}},"i":{"d":{"df":0,"docs":{},"l":{"df":1,"docs":{"61":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"93":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"60":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"_":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"_":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"60":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"60":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}}}},"p":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"k":{"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"_":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"_":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"60":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":44,"docs":{"100":{"tf":3.7416573867739413},"102":{"tf":1.0},"108":{"tf":1.4142135623730951},"109":{"tf":1.0},"112":{"tf":2.0},"113":{"tf":1.0},"114":{"tf":1.0},"12":{"tf":1.0},"120":{"tf":1.0},"2":{"tf":1.0},"21":{"tf":1.0},"22":{"tf":2.449489742783178},"24":{"tf":1.7320508075688772},"25":{"tf":2.6457513110645907},"28":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.4142135623730951},"38":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.4142135623730951},"42":{"tf":1.4142135623730951},"46":{"tf":1.0},"48":{"tf":3.4641016151377544},"49":{"tf":1.0},"5":{"tf":1.0},"53":{"tf":1.0},"54":{"tf":1.0},"55":{"tf":1.0},"59":{"tf":3.7416573867739413},"60":{"tf":3.872983346207417},"68":{"tf":2.0},"70":{"tf":2.23606797749979},"72":{"tf":5.0},"73":{"tf":1.0},"75":{"tf":3.872983346207417},"85":{"tf":1.0},"86":{"tf":1.4142135623730951},"87":{"tf":1.0},"89":{"tf":1.4142135623730951},"94":{"tf":2.0},"97":{"tf":1.0},"98":{"tf":1.7320508075688772},"99":{"tf":2.6457513110645907}},"n":{"a":{"df":0,"docs":{},"m":{"df":3,"docs":{"101":{"tf":1.0},"120":{"tf":1.0},"99":{"tf":1.0}}}},"df":0,"docs":{}},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":2,"docs":{"102":{"tf":1.0},"70":{"tf":1.0}}}}},"df":0,"docs":{}},"s":{"/":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"93":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":1,"docs":{"60":{"tf":1.0}}}}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":1,"docs":{"99":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"41":{"tf":1.7320508075688772},"60":{"tf":1.0}}}}}},"n":{"a":{"df":0,"docs":{},"l":{"df":5,"docs":{"115":{"tf":1.0},"116":{"tf":1.0},"22":{"tf":1.0},"68":{"tf":1.0},"70":{"tf":1.7320508075688772}}}},"d":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"_":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{"df":2,"docs":{"44":{"tf":1.0},"60":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"_":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{"df":2,"docs":{"44":{"tf":1.0},"60":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"_":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{"df":2,"docs":{"44":{"tf":1.0},"60":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":7,"docs":{"114":{"tf":1.0},"22":{"tf":1.0},"25":{"tf":1.4142135623730951},"31":{"tf":1.0},"44":{"tf":2.0},"87":{"tf":1.0},"99":{"tf":1.0}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":19,"docs":{"103":{"tf":1.0},"116":{"tf":1.0},"117":{"tf":2.0},"118":{"tf":2.23606797749979},"122":{"tf":1.7320508075688772},"29":{"tf":1.4142135623730951},"30":{"tf":1.0},"35":{"tf":1.0},"48":{"tf":1.7320508075688772},"51":{"tf":1.0},"57":{"tf":1.7320508075688772},"59":{"tf":1.7320508075688772},"60":{"tf":2.23606797749979},"61":{"tf":1.0},"63":{"tf":1.0},"70":{"tf":1.0},"84":{"tf":1.0},"9":{"tf":1.0},"99":{"tf":1.4142135623730951}}}}},"s":{"df":0,"docs":{},"h":{"df":3,"docs":{"25":{"tf":1.0},"61":{"tf":1.4142135623730951},"66":{"tf":1.7320508075688772}}},"t":{"df":1,"docs":{"117":{"tf":1.0}}}},"x":{"df":1,"docs":{"73":{"tf":1.0}}}},"l":{"a":{"df":0,"docs":{},"g":{"df":2,"docs":{"53":{"tf":1.4142135623730951},"55":{"tf":2.449489742783178}}},"k":{"df":0,"docs":{},"e":{"df":1,"docs":{"9":{"tf":1.7320508075688772}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"u":{"b":{"df":1,"docs":{"10":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"p":{"a":{"df":0,"docs":{},"k":{"df":2,"docs":{"10":{"tf":1.7320508075688772},"3":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"46":{"tf":1.0},"60":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":3,"docs":{"46":{"tf":1.0},"57":{"tf":1.0},"60":{"tf":1.0}}}},"o":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"93":{"tf":1.0}}}},"df":0,"docs":{}}},"m":{"df":0,"docs":{},"t":{"df":1,"docs":{"59":{"tf":1.0}}}},"n":{"df":5,"docs":{"115":{"tf":1.4142135623730951},"116":{"tf":1.0},"118":{"tf":1.0},"84":{"tf":1.4142135623730951},"93":{"tf":1.0}}},"o":{"c":{"df":0,"docs":{},"u":{"df":1,"docs":{"77":{"tf":1.7320508075688772}},"s":{"df":2,"docs":{"56":{"tf":3.0},"59":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":6,"docs":{"111":{"tf":1.0},"21":{"tf":1.0},"24":{"tf":1.0},"48":{"tf":1.0},"60":{"tf":1.0},"98":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":25,"docs":{"100":{"tf":1.0},"107":{"tf":1.0},"112":{"tf":1.0},"113":{"tf":1.0},"116":{"tf":1.0},"117":{"tf":1.0},"118":{"tf":1.4142135623730951},"21":{"tf":1.0},"22":{"tf":1.4142135623730951},"25":{"tf":1.4142135623730951},"29":{"tf":1.0},"39":{"tf":1.4142135623730951},"4":{"tf":1.0},"41":{"tf":1.4142135623730951},"52":{"tf":1.0},"56":{"tf":1.7320508075688772},"57":{"tf":1.0},"61":{"tf":1.0},"63":{"tf":1.0},"72":{"tf":1.7320508075688772},"75":{"tf":1.4142135623730951},"90":{"tf":1.0},"91":{"tf":1.0},"93":{"tf":1.0},"96":{"tf":1.0}}}}}},"o":{"df":4,"docs":{"116":{"tf":1.0},"54":{"tf":1.0},"57":{"tf":1.0},"84":{"tf":1.4142135623730951}}},"r":{"c":{"df":4,"docs":{"121":{"tf":1.0},"59":{"tf":2.6457513110645907},"61":{"tf":1.0},"82":{"tf":1.0}},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"59":{"tf":2.0}}}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"87":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}}}},"k":{"df":1,"docs":{"65":{"tf":1.4142135623730951}}},"m":{"a":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"45":{"tf":1.0},"60":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"102":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":12,"docs":{"102":{"tf":2.23606797749979},"103":{"tf":2.0},"12":{"tf":1.0},"39":{"tf":1.0},"45":{"tf":1.0},"57":{"tf":1.4142135623730951},"59":{"tf":1.4142135623730951},"60":{"tf":1.0},"61":{"tf":1.4142135623730951},"70":{"tf":1.4142135623730951},"98":{"tf":1.4142135623730951},"99":{"tf":1.4142135623730951}},"s":{"df":0,"docs":{},"t":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"102":{"tf":1.0}}}}},"df":0,"docs":{}}},"t":{"df":3,"docs":{"101":{"tf":2.23606797749979},"59":{"tf":1.0},"99":{"tf":2.449489742783178}}}}},"df":1,"docs":{"56":{"tf":1.0}}},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"61":{"tf":1.4142135623730951}}},"l":{"df":1,"docs":{"61":{"tf":1.0}}},"r":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"61":{"tf":1.0}}}},"df":0,"docs":{}}},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":6,"docs":{"44":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.7320508075688772},"49":{"tf":1.0},"52":{"tf":1.4142135623730951},"60":{"tf":2.23606797749979}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"n":{"d":{"df":5,"docs":{"0":{"tf":1.0},"102":{"tf":1.0},"110":{"tf":1.0},"112":{"tf":1.4142135623730951},"93":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"r":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":1,"docs":{"60":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"d":{"df":1,"docs":{"116":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":1,"docs":{"82":{"tf":1.0}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"64":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"m":{">":{"<":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"48":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"s":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"61":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"p":{"df":1,"docs":{"61":{"tf":1.0}}}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":5,"docs":{"1":{"tf":1.0},"100":{"tf":1.0},"26":{"tf":1.0},"38":{"tf":1.0},"82":{"tf":1.0}},"i":{"df":2,"docs":{"26":{"tf":1.0},"83":{"tf":1.0}}}}},"n":{"c":{"(":{"[":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"1":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"1":{"df":1,"docs":{"39":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"[":{"(":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"1":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":2,"docs":{"39":{"tf":1.7320508075688772},"93":{"tf":1.0}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{".":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"112":{"tf":1.0},"113":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}}},"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"93":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":1,"docs":{"93":{"tf":1.0}}}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"112":{"tf":1.0}}},"df":0,"docs":{}}}}},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":1,"docs":{"113":{"tf":1.0}}}}}},"_":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"116":{"tf":1.7320508075688772}}}}}}}}},"df":0,"docs":{}},"df":12,"docs":{"112":{"tf":1.0},"113":{"tf":1.0},"116":{"tf":2.23606797749979},"118":{"tf":1.0},"26":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.4142135623730951},"38":{"tf":1.4142135623730951},"39":{"tf":1.7320508075688772},"48":{"tf":1.4142135623730951},"60":{"tf":1.4142135623730951},"93":{"tf":2.23606797749979}}}}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"116":{"tf":1.0}}}}}}}}}},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":4,"docs":{"118":{"tf":1.0},"36":{"tf":1.0},"81":{"tf":1.0},"94":{"tf":1.0}}}}},"z":{"df":0,"docs":{},"z":{"df":0,"docs":{},"i":{"df":2,"docs":{"41":{"tf":1.0},"48":{"tf":1.4142135623730951}}}}}},"z":{"df":0,"docs":{},"f":{"df":1,"docs":{"41":{"tf":1.0}}}},"|":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"e":{"c":{"=":{"$":{"(":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":1,"docs":{"24":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"24":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"g":{"df":1,"docs":{"24":{"tf":1.4142135623730951}}}}},"g":{"a":{"df":4,"docs":{"60":{"tf":1.4142135623730951},"61":{"tf":1.0},"94":{"tf":1.0},"95":{"tf":1.0}},"r":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"116":{"tf":1.0}}}}}}},"b":{"df":1,"docs":{"60":{"tf":1.4142135623730951}}},"c":{"c":{"df":1,"docs":{"21":{"tf":1.0}}},"df":1,"docs":{"60":{"tf":1.4142135623730951}}},"d":{"df":1,"docs":{"60":{"tf":2.0}},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"61":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":6,"docs":{"37":{"tf":1.0},"44":{"tf":1.0},"48":{"tf":3.0},"59":{"tf":1.0},"60":{"tf":3.7416573867739413},"94":{"tf":1.0}},"e":{"df":1,"docs":{"60":{"tf":1.4142135623730951}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":1,"docs":{"61":{"tf":1.0}}}}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"70":{"tf":1.0},"93":{"tf":1.0}}}}},"t":{"df":2,"docs":{"118":{"tf":1.0},"39":{"tf":1.0}}}},"f":{"df":1,"docs":{"60":{"tf":1.4142135623730951}}},"g":{"df":1,"docs":{"60":{"tf":1.4142135623730951}}},"h":{"df":1,"docs":{"60":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"61":{"tf":1.0}}}}}}},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"61":{"tf":1.0}}}}}}}},"i":{"df":1,"docs":{"60":{"tf":1.4142135623730951}},"t":{"\'":{"df":1,"docs":{"75":{"tf":1.0}}},"/":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":1,"docs":{"100":{"tf":1.4142135623730951}}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"/":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"d":{"df":1,"docs":{"75":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"75":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"df":8,"docs":{"100":{"tf":1.0},"104":{"tf":2.0},"21":{"tf":1.4142135623730951},"56":{"tf":1.0},"61":{"tf":2.449489742783178},"75":{"tf":2.23606797749979},"8":{"tf":1.0},"81":{"tf":1.0}},"h":{"df":0,"docs":{},"u":{"b":{"/":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":0,"docs":{},"f":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"100":{"tf":1.0}},"s":{"/":{"*":{".":{"df":0,"docs":{},"y":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"100":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}}}},"df":4,"docs":{"112":{"tf":1.0},"2":{"tf":1.0},"21":{"tf":1.0},"75":{"tf":1.0}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"75":{"tf":2.0}}}}}}}},"v":{"df":0,"docs":{},"e":{"df":1,"docs":{"95":{"tf":1.0}},"n":{"df":9,"docs":{"100":{"tf":1.4142135623730951},"103":{"tf":1.0},"116":{"tf":1.0},"117":{"tf":1.7320508075688772},"121":{"tf":1.0},"122":{"tf":1.0},"57":{"tf":1.0},"59":{"tf":3.0},"84":{"tf":1.0}}}}}},"j":{"df":2,"docs":{"60":{"tf":1.4142135623730951},"61":{"tf":1.0}}},"k":{"df":1,"docs":{"60":{"tf":1.4142135623730951}}},"l":{"df":1,"docs":{"60":{"tf":1.4142135623730951}},"e":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"61":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"i":{"b":{"c":{"df":1,"docs":{"21":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"61":{"tf":1.0}}}}}}},"o":{"b":{"a":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"h":{"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":6,"docs":{"40":{"tf":1.0},"41":{"tf":2.0},"48":{"tf":1.4142135623730951},"60":{"tf":1.0},"68":{"tf":1.0},"75":{"tf":2.449489742783178}}}},"df":2,"docs":{"100":{"tf":3.7416573867739413},"102":{"tf":1.0}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"l":{"_":{"a":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"y":{"df":0,"docs":{},"z":{"df":1,"docs":{"61":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":1,"docs":{"61":{"tf":1.0}}}}},"m":{"df":1,"docs":{"60":{"tf":1.4142135623730951}}},"n":{"df":2,"docs":{"60":{"tf":1.4142135623730951},"61":{"tf":1.0}}},"o":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"61":{"tf":1.0}}}}},"df":7,"docs":{"116":{"tf":1.4142135623730951},"29":{"tf":1.0},"44":{"tf":1.0},"48":{"tf":6.4031242374328485},"51":{"tf":1.4142135623730951},"61":{"tf":1.0},"63":{"tf":1.0}},"l":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"c":{"df":0,"docs":{},"i":{"df":1,"docs":{"61":{"tf":1.0}}}},"df":0,"docs":{}}}},"d":{"df":1,"docs":{"92":{"tf":1.0}}},"df":0,"docs":{}},"m":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"61":{"tf":1.0}}},"df":0,"docs":{}}},"o":{"d":{"df":2,"docs":{"22":{"tf":1.0},"25":{"tf":1.0}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"61":{"tf":2.0}}}},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"61":{"tf":1.0}}}}},"o":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"n":{"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}}}}}}}},"d":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"60":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":3,"docs":{"103":{"tf":1.0},"48":{"tf":1.0},"60":{"tf":1.0}}}}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":2,"docs":{"48":{"tf":1.7320508075688772},"60":{"tf":1.0}},"e":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"60":{"tf":1.0}}},"df":0,"docs":{}}},"h":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"60":{"tf":1.0}}}}}}}},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}}}}},"df":0,"docs":{}}},"v":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"60":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"_":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}}}}},"df":0,"docs":{}}},"d":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"g":{"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"a":{"c":{"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}}}}},"df":0,"docs":{}}}}}},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}}}}}}}}}}},"l":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"_":{"a":{"c":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"d":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}}}}},"df":0,"docs":{}}},"d":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"g":{"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}}}}},"m":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}},"i":{"df":0,"docs":{},"e":{"d":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"44":{"tf":1.0},"60":{"tf":1.0}},"e":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"49":{"tf":1.0},"60":{"tf":1.0}}}}}}}}},"df":3,"docs":{"44":{"tf":1.0},"48":{"tf":1.0},"60":{"tf":1.0}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":4,"docs":{"44":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0},"60":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"_":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}}}}}},"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}}}}},"df":0,"docs":{}},"l":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"m":{"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}}}}},"d":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"g":{"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"60":{"tf":1.0}}}}}}},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}}}},"df":0,"docs":{}}}},"p":{"a":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}}}}},"df":0,"docs":{}}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"t":{"a":{"b":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":1,"docs":{"60":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"_":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}}}}},"df":0,"docs":{}},"l":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"m":{"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}}}}},"d":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"g":{"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"60":{"tf":1.0}}}}}}},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}}}},"df":0,"docs":{}}}},"p":{"a":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}}}}},"df":0,"docs":{}}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"t":{"a":{"b":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":1,"docs":{"60":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"_":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"_":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"_":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}}}}}}}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"r":{"d":{"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":7,"docs":{"103":{"tf":2.449489742783178},"42":{"tf":1.0},"48":{"tf":1.7320508075688772},"50":{"tf":1.0},"59":{"tf":2.0},"60":{"tf":7.211102550927978},"73":{"tf":1.4142135623730951}}}},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":1,"docs":{"61":{"tf":1.0}}}}}}},"p":{"df":1,"docs":{"60":{"tf":1.4142135623730951}},"r":{"df":1,"docs":{"61":{"tf":1.0}}}},"r":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"r":{"df":12,"docs":{"104":{"tf":3.605551275463989},"105":{"tf":3.0},"106":{"tf":1.0},"109":{"tf":2.23606797749979},"111":{"tf":2.23606797749979},"112":{"tf":1.0},"114":{"tf":1.0},"21":{"tf":2.8284271247461903},"25":{"tf":1.0},"37":{"tf":1.4142135623730951},"42":{"tf":1.0},"99":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"56":{"tf":1.0}}}},"q":{"df":0,"docs":{},"l":{"df":1,"docs":{"61":{"tf":1.4142135623730951}}}}}},"y":{"df":1,"docs":{"89":{"tf":1.4142135623730951}}}},"df":1,"docs":{"60":{"tf":1.4142135623730951}},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"116":{"tf":1.7320508075688772},"64":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"89":{"tf":1.4142135623730951}}}},"n":{"df":1,"docs":{"61":{"tf":1.0}}}},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"df":1,"docs":{"61":{"tf":1.0}}}}}}},"s":{"df":1,"docs":{"60":{"tf":1.4142135623730951}}},"t":{"df":2,"docs":{"60":{"tf":2.0},"61":{"tf":1.0}}},"u":{"df":0,"docs":{},"i":{"d":{"df":6,"docs":{"106":{"tf":1.4142135623730951},"114":{"tf":1.0},"61":{"tf":1.0},"69":{"tf":1.0},"80":{"tf":2.23606797749979},"93":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"70":{"tf":1.7320508075688772},"81":{"tf":2.8284271247461903},"93":{"tf":3.7416573867739413}}}}}}},"w":{"df":1,"docs":{"60":{"tf":1.4142135623730951}}},"y":{"df":1,"docs":{"60":{"tf":1.4142135623730951}}}},"h":{"1":{"df":1,"docs":{"93":{"tf":1.0}}},"6":{"df":1,"docs":{"93":{"tf":1.0}}},"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"_":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":1,"docs":{"60":{"tf":1.0}}}}}},"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":1,"docs":{"60":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":3,"docs":{"44":{"tf":1.4142135623730951},"48":{"tf":1.4142135623730951},"60":{"tf":2.0}}}},"n":{"d":{"df":0,"docs":{},"l":{"df":1,"docs":{"103":{"tf":1.0}}}},"df":0,"docs":{},"g":{"df":1,"docs":{"116":{"tf":1.0}}}},"r":{"d":{"df":1,"docs":{"59":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"114":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":1,"docs":{"61":{"tf":1.0}}}},"s":{"df":0,"docs":{},"h":{"df":2,"docs":{"104":{"tf":1.0},"72":{"tf":1.0}}},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"61":{"tf":2.0}}}}}}},"c":{"df":1,"docs":{"33":{"tf":1.0}},"l":{"df":1,"docs":{"61":{"tf":1.0}}}},"df":6,"docs":{"33":{"tf":1.0},"44":{"tf":1.0},"48":{"tf":2.23606797749979},"49":{"tf":1.0},"52":{"tf":1.0},"60":{"tf":2.6457513110645907}},"e":{"a":{"d":{"df":1,"docs":{"93":{"tf":1.7320508075688772}},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"89":{"tf":1.0},"93":{"tf":1.0}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":4,"docs":{"2":{"tf":1.0},"23":{"tf":2.0},"61":{"tf":1.0},"8":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":1,"docs":{"61":{"tf":1.0}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"\'":{"df":4,"docs":{"21":{"tf":1.0},"22":{"tf":1.0},"42":{"tf":1.0},"63":{"tf":1.4142135623730951}}},".":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"df":1,"docs":{"17":{"tf":1.0}}}}}}},"i":{"d":{"df":0,"docs":{},"e":{"a":{".":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"65":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"65":{"tf":1.0}}}},"s":{".":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"65":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"/":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":2,"docs":{"70":{"tf":1.0},"99":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"75":{"tf":1.0}}}}}}}},"_":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"22":{"tf":1.4142135623730951}},"e":{"=":{"/":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"r":{"/":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"b":{"/":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"22":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"s":{"a":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"_":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"r":{"_":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"21":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":3,"docs":{"111":{"tf":1.0},"2":{"tf":1.0},"22":{"tf":2.23606797749979}},"e":{"=":{"df":0,"docs":{},"~":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"r":{"c":{"/":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"22":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}}},"df":62,"docs":{"0":{"tf":1.4142135623730951},"1":{"tf":2.0},"10":{"tf":1.0},"100":{"tf":1.4142135623730951},"103":{"tf":1.0},"107":{"tf":1.4142135623730951},"11":{"tf":1.7320508075688772},"111":{"tf":1.4142135623730951},"112":{"tf":1.7320508075688772},"113":{"tf":1.0},"114":{"tf":1.4142135623730951},"115":{"tf":1.0},"116":{"tf":1.0},"119":{"tf":1.0},"12":{"tf":2.6457513110645907},"120":{"tf":1.4142135623730951},"14":{"tf":1.0},"15":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.0},"2":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":2.23606797749979},"22":{"tf":2.449489742783178},"23":{"tf":1.0},"24":{"tf":1.0},"25":{"tf":1.7320508075688772},"26":{"tf":1.4142135623730951},"27":{"tf":1.0},"29":{"tf":1.0},"30":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.4142135623730951},"43":{"tf":1.0},"49":{"tf":1.0},"56":{"tf":1.7320508075688772},"59":{"tf":1.0},"6":{"tf":1.4142135623730951},"61":{"tf":1.0},"62":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":2.6457513110645907},"65":{"tf":2.23606797749979},"66":{"tf":2.0},"67":{"tf":1.7320508075688772},"68":{"tf":1.7320508075688772},"7":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.4142135623730951},"73":{"tf":1.4142135623730951},"75":{"tf":1.7320508075688772},"77":{"tf":1.0},"8":{"tf":2.23606797749979},"9":{"tf":2.0},"94":{"tf":2.23606797749979},"98":{"tf":2.0},"99":{"tf":1.0}}}},"m":{"_":{"df":0,"docs":{},"l":{"df":1,"docs":{"61":{"tf":1.0}}}},"df":1,"docs":{"61":{"tf":1.0}}},"p":{"df":6,"docs":{"103":{"tf":1.0},"116":{"tf":1.7320508075688772},"42":{"tf":1.0},"48":{"tf":1.0},"60":{"tf":1.0},"73":{"tf":2.0}}}},"r":{"df":0,"docs":{},"e":{"df":2,"docs":{"116":{"tf":1.0},"87":{"tf":1.4142135623730951}}},"o":{"df":2,"docs":{"115":{"tf":2.0},"116":{"tf":1.7320508075688772}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":3,"docs":{"114":{"tf":1.7320508075688772},"57":{"tf":1.4142135623730951},"70":{"tf":1.4142135623730951}}}}}}},"x":{"a":{"d":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"56":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"i":{"d":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":4,"docs":{"68":{"tf":1.0},"74":{"tf":1.0},"75":{"tf":1.4142135623730951},"90":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":1,"docs":{"82":{"tf":1.0}}}},"df":1,"docs":{"56":{"tf":1.7320508075688772}},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"25":{"tf":1.0},"84":{"tf":1.0}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"84":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":10,"docs":{"103":{"tf":1.0},"110":{"tf":1.4142135623730951},"119":{"tf":1.7320508075688772},"120":{"tf":2.0},"121":{"tf":1.0},"59":{"tf":1.4142135623730951},"61":{"tf":1.0},"70":{"tf":1.4142135623730951},"82":{"tf":1.0},"93":{"tf":2.0}}}}}}}}},"n":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"93":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":1,"docs":{"93":{"tf":1.0}}}}}},"df":5,"docs":{"103":{"tf":1.0},"73":{"tf":2.449489742783178},"84":{"tf":1.4142135623730951},"93":{"tf":2.6457513110645907},"99":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":4,"docs":{"45":{"tf":1.4142135623730951},"52":{"tf":1.4142135623730951},"59":{"tf":1.4142135623730951},"60":{"tf":1.4142135623730951}}}}}}},"t":{"df":1,"docs":{"36":{"tf":1.0}}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"59":{"tf":1.0}}}}},"o":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"61":{"tf":1.0}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"/":{".":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"a":{"df":0,"docs":{},"l":{"/":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"/":{"df":0,"docs":{},"h":{"df":0,"docs":{},"x":{"df":1,"docs":{"12":{"tf":1.0}}}}},"df":1,"docs":{"12":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"b":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":2,"docs":{"14":{"tf":1.0},"3":{"tf":1.0}}}}}},"df":7,"docs":{"44":{"tf":1.0},"49":{"tf":1.4142135623730951},"51":{"tf":1.0},"52":{"tf":1.0},"60":{"tf":1.7320508075688772},"75":{"tf":1.0},"96":{"tf":1.4142135623730951}}}},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"61":{"tf":1.0}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"z":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":5,"docs":{"48":{"tf":1.7320508075688772},"51":{"tf":1.0},"59":{"tf":1.4142135623730951},"60":{"tf":1.4142135623730951},"84":{"tf":1.0}}}}}}}},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"104":{"tf":1.0},"61":{"tf":1.0}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":4,"docs":{"103":{"tf":1.0},"48":{"tf":1.0},"60":{"tf":1.0},"93":{"tf":2.449489742783178}}}}}},"s":{"df":1,"docs":{"59":{"tf":1.0}},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"60":{"tf":1.0}}}}}},"df":3,"docs":{"48":{"tf":1.0},"59":{"tf":1.4142135623730951},"60":{"tf":1.4142135623730951}}}}}}},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"j":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":1,"docs":{"61":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":2,"docs":{"61":{"tf":1.7320508075688772},"93":{"tf":1.4142135623730951}}}},"t":{"df":0,"docs":{},"p":{"df":0,"docs":{},"s":{":":{"/":{"/":{"d":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"df":1,"docs":{"0":{"tf":1.0}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"c":{".":{"df":0,"docs":{},"w":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"w":{"df":0,"docs":{},"g":{".":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"59":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"u":{"b":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"/":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"/":{"df":0,"docs":{},"m":{"df":0,"docs":{},"y":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"104":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"df":1,"docs":{"21":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"102":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":1,"docs":{"61":{"tf":1.0}}}}},"x":{"df":13,"docs":{"104":{"tf":1.0},"105":{"tf":1.4142135623730951},"111":{"tf":1.4142135623730951},"12":{"tf":1.0},"2":{"tf":2.23606797749979},"21":{"tf":1.7320508075688772},"22":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":1.0},"26":{"tf":1.0},"61":{"tf":1.0},"68":{"tf":1.4142135623730951},"8":{"tf":1.0}}},"y":{"b":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"d":{"df":3,"docs":{"114":{"tf":1.0},"57":{"tf":2.0},"70":{"tf":1.7320508075688772}}},"df":0,"docs":{}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"61":{"tf":1.0}}}}},"df":1,"docs":{"61":{"tf":1.0}}}}}}},"i":{".":{"df":1,"docs":{"86":{"tf":1.4142135623730951}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"24":{"tf":1.4142135623730951},"25":{"tf":1.0}},"s":{"/":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{".":{"df":0,"docs":{},"p":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{")":{"df":0,"docs":{},"|":{"df":0,"docs":{},"g":{"df":1,"docs":{"24":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}},"d":{"df":2,"docs":{"93":{"tf":1.0},"99":{"tf":1.7320508075688772}},"e":{"a":{"df":1,"docs":{"65":{"tf":1.0}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"65":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":2,"docs":{"39":{"tf":3.0},"99":{"tf":1.0}}}}}}}},"l":{"df":1,"docs":{"70":{"tf":1.4142135623730951}}},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"61":{"tf":1.0}},"s":{"2":{"df":1,"docs":{"61":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":1,"docs":{"61":{"tf":1.0}}}},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":6,"docs":{"116":{"tf":1.0},"45":{"tf":1.0},"59":{"tf":2.6457513110645907},"60":{"tf":1.0},"61":{"tf":1.0},"75":{"tf":3.872983346207417}}}}}},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"118":{"tf":1.0}}}},"m":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"93":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"118":{"tf":1.0}}}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":4,"docs":{"103":{"tf":1.0},"37":{"tf":1.0},"48":{"tf":1.0},"60":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"93":{"tf":1.4142135623730951}}}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":1,"docs":{"73":{"tf":1.0}}}}}}},"n":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"93":{"tf":1.0}}}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"d":{"df":12,"docs":{"118":{"tf":1.4142135623730951},"121":{"tf":1.0},"2":{"tf":1.0},"25":{"tf":1.0},"31":{"tf":1.0},"36":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.0},"49":{"tf":1.0},"70":{"tf":1.0},"73":{"tf":1.4142135623730951},"89":{"tf":1.0}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":3,"docs":{"114":{"tf":1.4142135623730951},"116":{"tf":1.7320508075688772},"82":{"tf":1.0}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"45":{"tf":1.4142135623730951},"60":{"tf":1.4142135623730951}}}}}}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{".":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"y":{"df":1,"docs":{"116":{"tf":2.8284271247461903}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"m":{"df":1,"docs":{"114":{"tf":1.0}}}},"df":0,"docs":{}}},"df":17,"docs":{"110":{"tf":1.0},"114":{"tf":3.872983346207417},"115":{"tf":2.0},"116":{"tf":6.164414002968976},"117":{"tf":1.4142135623730951},"118":{"tf":2.8284271247461903},"45":{"tf":1.4142135623730951},"57":{"tf":1.4142135623730951},"59":{"tf":1.4142135623730951},"60":{"tf":1.4142135623730951},"61":{"tf":1.0},"70":{"tf":2.0},"72":{"tf":1.4142135623730951},"80":{"tf":2.0},"82":{"tf":1.7320508075688772},"93":{"tf":1.0},"99":{"tf":2.0}},"s":{".":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"m":{"df":1,"docs":{"115":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"x":{"df":1,"docs":{"72":{"tf":1.0}}}},"i":{"c":{"df":7,"docs":{"121":{"tf":1.4142135623730951},"35":{"tf":1.0},"70":{"tf":1.0},"72":{"tf":2.6457513110645907},"81":{"tf":1.0},"82":{"tf":1.7320508075688772},"93":{"tf":2.449489742783178}}},"df":0,"docs":{}}},"df":2,"docs":{"72":{"tf":1.0},"96":{"tf":1.0}},"f":{"df":0,"docs":{},"o":{"df":6,"docs":{"51":{"tf":1.0},"59":{"tf":1.4142135623730951},"70":{"tf":1.4142135623730951},"84":{"tf":1.0},"93":{"tf":1.7320508075688772},"99":{"tf":1.0}},"r":{"df":0,"docs":{},"m":{"df":8,"docs":{"108":{"tf":1.0},"110":{"tf":1.0},"112":{"tf":1.0},"23":{"tf":1.0},"56":{"tf":1.0},"61":{"tf":1.0},"62":{"tf":1.0},"99":{"tf":1.4142135623730951}}}}}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"92":{"tf":1.7320508075688772}}}}}}},"i":{"df":1,"docs":{"61":{"tf":1.0}},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"102":{"tf":1.0}}}}},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"119":{"tf":1.7320508075688772},"121":{"tf":1.0},"99":{"tf":1.7320508075688772}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"121":{"tf":1.0}}}}},"df":0,"docs":{}},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"119":{"tf":1.4142135623730951},"120":{"tf":1.7320508075688772}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"120":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"i":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"d":{"df":1,"docs":{"121":{"tf":1.7320508075688772}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"l":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"g":{"df":3,"docs":{"119":{"tf":1.4142135623730951},"120":{"tf":1.4142135623730951},"121":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"b":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"120":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"k":{"df":1,"docs":{"61":{"tf":1.0}},"o":{"df":1,"docs":{"61":{"tf":1.0}}}},"l":{"a":{"df":0,"docs":{},"y":{"df":3,"docs":{"103":{"tf":1.0},"73":{"tf":2.23606797749979},"93":{"tf":1.7320508075688772}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":3,"docs":{"70":{"tf":1.0},"84":{"tf":2.8284271247461903},"93":{"tf":1.4142135623730951}}}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"54":{"tf":1.0}},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"116":{"tf":1.4142135623730951}}}}}}}}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":5,"docs":{"102":{"tf":1.0},"36":{"tf":1.0},"52":{"tf":1.0},"93":{"tf":1.0},"99":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"78":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"t":{"_":{"a":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"45":{"tf":1.0},"60":{"tf":1.0}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":2,"docs":{"45":{"tf":1.0},"60":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"d":{"df":2,"docs":{"45":{"tf":1.0},"60":{"tf":1.0}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"49":{"tf":1.0},"60":{"tf":1.0}}}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"49":{"tf":1.0},"60":{"tf":1.0}}}}}}}},"t":{"a":{"b":{"df":1,"docs":{"60":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":28,"docs":{"102":{"tf":1.0},"115":{"tf":2.449489742783178},"27":{"tf":1.0},"33":{"tf":1.0},"41":{"tf":1.4142135623730951},"42":{"tf":1.0},"45":{"tf":2.8284271247461903},"46":{"tf":1.0},"49":{"tf":2.449489742783178},"52":{"tf":1.4142135623730951},"53":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.7320508075688772},"59":{"tf":1.4142135623730951},"60":{"tf":5.385164807134504},"68":{"tf":1.0},"70":{"tf":2.449489742783178},"72":{"tf":1.7320508075688772},"74":{"tf":1.4142135623730951},"76":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.7320508075688772},"84":{"tf":1.0},"93":{"tf":1.0},"94":{"tf":1.0},"95":{"tf":1.0},"96":{"tf":1.0},"99":{"tf":1.0}},"s":{"df":0,"docs":{},"p":{"a":{"c":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":1,"docs":{"102":{"tf":1.0}}}}}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"i":{"d":{"df":7,"docs":{"116":{"tf":1.4142135623730951},"37":{"tf":1.0},"46":{"tf":1.7320508075688772},"48":{"tf":1.0},"60":{"tf":2.0},"70":{"tf":1.0},"84":{"tf":1.0}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"56":{"tf":1.0}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"r":{"df":5,"docs":{"29":{"tf":1.0},"30":{"tf":1.0},"36":{"tf":1.0},"63":{"tf":1.0},"87":{"tf":1.0}}}}},"t":{"a":{"df":0,"docs":{},"l":{"df":23,"docs":{"0":{"tf":1.0},"1":{"tf":1.7320508075688772},"10":{"tf":1.0},"108":{"tf":1.0},"11":{"tf":1.7320508075688772},"12":{"tf":1.4142135623730951},"14":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":2.0},"18":{"tf":1.0},"19":{"tf":1.0},"21":{"tf":2.23606797749979},"22":{"tf":1.0},"23":{"tf":1.0},"25":{"tf":1.4142135623730951},"5":{"tf":1.0},"56":{"tf":1.0},"6":{"tf":1.0},"61":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}}},"n":{"c":{"df":5,"docs":{"103":{"tf":1.0},"30":{"tf":1.7320508075688772},"50":{"tf":1.0},"56":{"tf":1.0},"71":{"tf":1.0}}},"df":0,"docs":{},"t":{"df":1,"docs":{"70":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"70":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"a":{"d":{"df":10,"docs":{"21":{"tf":1.0},"48":{"tf":1.4142135623730951},"54":{"tf":1.0},"56":{"tf":1.7320508075688772},"75":{"tf":1.0},"8":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.4142135623730951},"93":{"tf":1.0},"99":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"1":{"tf":1.0},"108":{"tf":1.0}}}},"df":0,"docs":{}}}}},"t":{"df":1,"docs":{"93":{"tf":1.0}},"e":{"df":0,"docs":{},"g":{"df":3,"docs":{"59":{"tf":1.4142135623730951},"75":{"tf":1.0},"93":{"tf":1.0}},"r":{"df":2,"docs":{"71":{"tf":1.0},"73":{"tf":1.0}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":1,"docs":{"61":{"tf":1.0}}}}}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"j":{"df":1,"docs":{"65":{"tf":1.0}}}}}},"n":{"d":{"df":2,"docs":{"22":{"tf":1.0},"48":{"tf":1.0}}},"df":0,"docs":{}},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":5,"docs":{"26":{"tf":1.0},"30":{"tf":1.0},"40":{"tf":1.0},"64":{"tf":1.0},"70":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"f":{"a":{"c":{"df":2,"docs":{"61":{"tf":1.0},"93":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"n":{"df":2,"docs":{"49":{"tf":1.0},"99":{"tf":1.0}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"93":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":3,"docs":{"54":{"tf":1.0},"57":{"tf":1.4142135623730951},"99":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"70":{"tf":1.0}}}}}}}},"r":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"26":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"39":{"tf":1.0}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"95":{"tf":1.0}}}}},"o":{"c":{"df":2,"docs":{"57":{"tf":1.0},"94":{"tf":1.0}}},"df":0,"docs":{},"k":{"df":4,"docs":{"22":{"tf":1.0},"33":{"tf":1.0},"54":{"tf":1.0},"60":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"n":{"\'":{"df":0,"docs":{},"t":{"df":3,"docs":{"100":{"tf":1.0},"116":{"tf":1.0},"54":{"tf":1.0}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"u":{"df":2,"docs":{"111":{"tf":1.0},"68":{"tf":1.0}}}}},"t":{"\'":{"df":3,"docs":{"103":{"tf":1.0},"17":{"tf":1.0},"89":{"tf":1.0}}},"_":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"116":{"tf":1.0}}}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"l":{"df":3,"docs":{"87":{"tf":1.0},"90":{"tf":1.0},"93":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":10,"docs":{"106":{"tf":1.0},"116":{"tf":1.4142135623730951},"22":{"tf":1.0},"40":{"tf":1.0},"48":{"tf":2.0},"52":{"tf":1.4142135623730951},"60":{"tf":1.7320508075688772},"70":{"tf":1.0},"83":{"tf":1.4142135623730951},"93":{"tf":1.0}},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":1,"docs":{"22":{"tf":1.0}}}}}},"r":{"df":1,"docs":{"50":{"tf":1.0}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":4,"docs":{"103":{"tf":1.0},"29":{"tf":1.0},"63":{"tf":1.0},"70":{"tf":1.0}}}}}}}},"j":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"61":{"tf":1.0}}}}},"v":{"a":{"df":1,"docs":{"61":{"tf":1.0}},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":2,"docs":{"103":{"tf":1.0},"61":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"d":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":1,"docs":{"61":{"tf":1.0}}}}},"df":7,"docs":{"44":{"tf":1.0},"46":{"tf":1.4142135623730951},"48":{"tf":2.449489742783178},"49":{"tf":1.0},"60":{"tf":3.3166247903554},"94":{"tf":1.0},"95":{"tf":1.4142135623730951}},"e":{"d":{"df":0,"docs":{},"i":{"df":1,"docs":{"61":{"tf":1.0}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"j":{"a":{"df":1,"docs":{"61":{"tf":1.0}}},"df":0,"docs":{}}}},"j":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"61":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"k":{"df":2,"docs":{"94":{"tf":1.0},"95":{"tf":1.0}}},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"46":{"tf":1.0},"60":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"a":{"c":{"df":2,"docs":{"46":{"tf":1.0},"60":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}},"df":4,"docs":{"35":{"tf":1.7320508075688772},"46":{"tf":1.4142135623730951},"59":{"tf":2.449489742783178},"60":{"tf":2.23606797749979}}}}},"q":{"df":1,"docs":{"61":{"tf":1.4142135623730951}}},"s":{"d":{"df":0,"docs":{},"o":{"c":{"df":1,"docs":{"61":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"5":{"df":1,"docs":{"61":{"tf":1.0}}},"c":{"df":1,"docs":{"61":{"tf":1.0}}},"df":3,"docs":{"105":{"tf":1.0},"57":{"tf":2.0},"61":{"tf":2.23606797749979}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"61":{"tf":1.4142135623730951}}}}}}},"x":{"df":2,"docs":{"103":{"tf":1.0},"61":{"tf":1.0}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"a":{"df":1,"docs":{"61":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"m":{"df":0,"docs":{},"p":{"_":{"b":{"a":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":2,"docs":{"44":{"tf":1.0},"60":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":2,"docs":{"44":{"tf":1.0},"60":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"_":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"p":{"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"df":6,"docs":{"44":{"tf":1.4142135623730951},"48":{"tf":1.0},"59":{"tf":1.4142135623730951},"60":{"tf":2.6457513110645907},"70":{"tf":1.4142135623730951},"93":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"k":{"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":3,"docs":{"44":{"tf":1.7320508075688772},"48":{"tf":1.0},"60":{"tf":2.0}}}}}}}},"n":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"22":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"k":{"a":{"df":0,"docs":{},"k":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":5,"docs":{"29":{"tf":1.0},"30":{"tf":1.0},"37":{"tf":1.4142135623730951},"48":{"tf":1.0},"63":{"tf":1.4142135623730951}},"e":{"\'":{"df":1,"docs":{"63":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"d":{"df":0,"docs":{},"l":{"df":1,"docs":{"61":{"tf":1.0}}}},"df":9,"docs":{"44":{"tf":1.0},"46":{"tf":1.4142135623730951},"48":{"tf":2.449489742783178},"49":{"tf":1.0},"52":{"tf":1.0},"60":{"tf":3.3166247903554},"93":{"tf":1.0},"94":{"tf":1.0},"95":{"tf":1.7320508075688772}},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"46":{"tf":1.0},"60":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"46":{"tf":1.0},"60":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":6,"docs":{"45":{"tf":1.0},"46":{"tf":1.4142135623730951},"48":{"tf":1.0},"50":{"tf":1.0},"60":{"tf":1.4142135623730951},"89":{"tf":1.0}}}},"y":{".":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":1,"docs":{"87":{"tf":1.0}}}}}},"1":{"df":1,"docs":{"102":{"tf":1.0}}},"2":{"df":1,"docs":{"102":{"tf":1.0}}},"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":8,"docs":{"0":{"tf":1.4142135623730951},"40":{"tf":1.0},"48":{"tf":1.0},"51":{"tf":1.4142135623730951},"60":{"tf":1.0},"65":{"tf":1.4142135623730951},"83":{"tf":1.4142135623730951},"94":{"tf":1.7320508075688772}}},"df":0,"docs":{}}},"o":{"a":{"df":0,"docs":{},"r":{"d":{"df":2,"docs":{"83":{"tf":1.0},"96":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":43,"docs":{"100":{"tf":1.4142135623730951},"102":{"tf":1.0},"104":{"tf":2.23606797749979},"105":{"tf":1.4142135623730951},"109":{"tf":1.0},"116":{"tf":2.0},"26":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":1.0},"42":{"tf":1.0},"43":{"tf":1.0},"44":{"tf":1.0},"45":{"tf":1.4142135623730951},"46":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":3.4641016151377544},"49":{"tf":1.7320508075688772},"51":{"tf":1.4142135623730951},"52":{"tf":1.4142135623730951},"56":{"tf":1.0},"60":{"tf":1.0},"70":{"tf":1.0},"72":{"tf":2.0},"73":{"tf":1.0},"74":{"tf":1.0},"75":{"tf":1.0},"77":{"tf":1.0},"78":{"tf":1.0},"79":{"tf":1.7320508075688772},"80":{"tf":1.0},"81":{"tf":1.4142135623730951},"82":{"tf":1.0},"83":{"tf":2.449489742783178},"84":{"tf":1.0},"87":{"tf":2.23606797749979},"89":{"tf":1.0},"93":{"tf":2.449489742783178},"94":{"tf":3.4641016151377544},"95":{"tf":1.0},"96":{"tf":3.4641016151377544},"99":{"tf":2.23606797749979}},"m":{"a":{"df":0,"docs":{},"p":{"df":7,"docs":{"0":{"tf":1.0},"31":{"tf":1.0},"36":{"tf":1.0},"40":{"tf":1.0},"42":{"tf":1.0},"64":{"tf":1.0},"94":{"tf":1.7320508075688772}}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"48":{"tf":1.0},"70":{"tf":1.0}}}}}}},"s":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"j":{"df":1,"docs":{"95":{"tf":1.0}}}},"df":3,"docs":{"49":{"tf":1.0},"83":{"tf":1.0},"94":{"tf":1.4142135623730951}}}}}}}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"l":{".":{"df":0,"docs":{},"g":{"df":1,"docs":{"95":{"tf":1.0}}},"z":{"df":1,"docs":{"95":{"tf":1.0}}}},"df":0,"docs":{}}},"df":5,"docs":{"56":{"tf":1.0},"83":{"tf":1.0},"94":{"tf":1.4142135623730951},"95":{"tf":1.0},"96":{"tf":1.4142135623730951}}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"83":{"tf":1.0},"94":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"\\"":{"df":1,"docs":{"92":{"tf":1.0}}},"df":3,"docs":{"119":{"tf":1.0},"92":{"tf":1.0},"93":{"tf":1.7320508075688772}}},"df":0,"docs":{}}}}}},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"49":{"tf":1.0},"60":{"tf":1.0}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":2,"docs":{"49":{"tf":1.0},"60":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"n":{"d":{">":{"]":{"<":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{">":{"<":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"s":{">":{"<":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":1,"docs":{"56":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":6,"docs":{"100":{"tf":1.0},"117":{"tf":1.4142135623730951},"40":{"tf":1.0},"56":{"tf":1.7320508075688772},"93":{"tf":2.23606797749979},"94":{"tf":1.0}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"24":{"tf":1.0}}}}}},"l":{"df":0,"docs":{},"u":{"d":{"df":0,"docs":{},"g":{"df":1,"docs":{"48":{"tf":1.0}}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":2,"docs":{"120":{"tf":1.0},"42":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"k":{"a":{"df":1,"docs":{"61":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"61":{"tf":1.4142135623730951}}}}},"o":{"df":1,"docs":{"61":{"tf":1.4142135623730951}}}}}},"l":{"a":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":4,"docs":{"48":{"tf":1.4142135623730951},"60":{"tf":1.4142135623730951},"70":{"tf":1.4142135623730951},"93":{"tf":2.0}}}}},"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"83":{"tf":1.0}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"g":{"df":0,"docs":{},"y":{"/":{"df":0,"docs":{},"j":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"df":1,"docs":{"73":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"n":{"df":0,"docs":{},"g":{"df":2,"docs":{"41":{"tf":1.4142135623730951},"59":{"tf":1.0}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{"df":2,"docs":{"102":{"tf":1.0},"61":{"tf":2.0}}}}}},"u":{"a":{"df":0,"docs":{},"g":{"df":30,"docs":{"0":{"tf":1.0},"1":{"tf":1.4142135623730951},"100":{"tf":1.4142135623730951},"102":{"tf":4.358898943540674},"103":{"tf":5.656854249492381},"105":{"tf":1.0},"106":{"tf":1.0},"107":{"tf":1.4142135623730951},"108":{"tf":3.4641016151377544},"109":{"tf":1.0},"110":{"tf":1.4142135623730951},"112":{"tf":1.0},"113":{"tf":1.0},"116":{"tf":1.0},"119":{"tf":2.0},"120":{"tf":2.449489742783178},"121":{"tf":1.0},"39":{"tf":1.0},"41":{"tf":1.0},"42":{"tf":1.0},"56":{"tf":1.4142135623730951},"59":{"tf":2.8284271247461903},"61":{"tf":7.54983443527075},"70":{"tf":1.0},"73":{"tf":1.7320508075688772},"76":{"tf":1.7320508075688772},"93":{"tf":2.6457513110645907},"97":{"tf":1.7320508075688772},"98":{"tf":2.6457513110645907},"99":{"tf":5.0}},"e":{"\'":{"df":1,"docs":{"104":{"tf":1.0}}},".":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"76":{"tf":1.0}}}}}},"df":0,"docs":{}},"]":{".":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"102":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":11,"docs":{"100":{"tf":1.0},"102":{"tf":1.0},"104":{"tf":1.0},"108":{"tf":1.0},"109":{"tf":1.0},"120":{"tf":1.4142135623730951},"70":{"tf":1.0},"76":{"tf":1.0},"97":{"tf":1.0},"98":{"tf":1.7320508075688772},"99":{"tf":1.0}}}}}}},"df":0,"docs":{}},"}":{"/":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"m":{"df":1,"docs":{"114":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"k":{"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":11,"docs":{"116":{"tf":1.0},"34":{"tf":2.0},"35":{"tf":1.0},"41":{"tf":1.0},"44":{"tf":1.0},"45":{"tf":1.0},"48":{"tf":2.449489742783178},"51":{"tf":1.0},"60":{"tf":3.1622776601683795},"70":{"tf":1.0},"77":{"tf":1.4142135623730951}}}},"t":{"df":1,"docs":{"59":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":4,"docs":{"45":{"tf":1.0},"52":{"tf":1.0},"59":{"tf":1.4142135623730951},"60":{"tf":1.0}}},"s":{"df":0,"docs":{},"t":{"df":4,"docs":{"1":{"tf":1.0},"12":{"tf":1.0},"17":{"tf":1.0},"9":{"tf":1.0}}}},"x":{"df":1,"docs":{"61":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"h":{"df":2,"docs":{"43":{"tf":1.0},"60":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"25":{"tf":1.0}}}}}},"df":0,"docs":{}}},"y":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"48":{"tf":1.4142135623730951}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"81":{"tf":1.4142135623730951}}}}}}},"d":{"df":1,"docs":{"61":{"tf":1.4142135623730951}},"i":{"df":0,"docs":{},"f":{"df":1,"docs":{"61":{"tf":1.0}}}}},"df":4,"docs":{"44":{"tf":1.0},"48":{"tf":2.0},"56":{"tf":1.0},"60":{"tf":2.8284271247461903}},"e":{"a":{"d":{"df":2,"docs":{"116":{"tf":1.0},"64":{"tf":1.0}}},"df":0,"docs":{},"n":{"df":1,"docs":{"61":{"tf":1.4142135623730951}}},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"49":{"tf":1.0}}}},"v":{"df":1,"docs":{"25":{"tf":1.0}}}},"d":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"61":{"tf":1.0}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":10,"docs":{"44":{"tf":1.4142135623730951},"46":{"tf":1.0},"48":{"tf":1.7320508075688772},"49":{"tf":1.4142135623730951},"52":{"tf":1.4142135623730951},"60":{"tf":3.1622776601683795},"72":{"tf":2.0},"82":{"tf":1.0},"83":{"tf":1.4142135623730951},"96":{"tf":1.4142135623730951}}}},"n":{"df":2,"docs":{"70":{"tf":1.0},"84":{"tf":1.0}},"g":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":4,"docs":{"70":{"tf":1.4142135623730951},"72":{"tf":1.0},"73":{"tf":1.4142135623730951},"99":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"49":{"tf":1.0}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":8,"docs":{"105":{"tf":1.0},"114":{"tf":1.4142135623730951},"115":{"tf":1.4142135623730951},"116":{"tf":3.7416573867739413},"118":{"tf":1.4142135623730951},"70":{"tf":1.0},"80":{"tf":1.7320508075688772},"81":{"tf":1.0}}}}}},"f":{"df":3,"docs":{"59":{"tf":1.0},"70":{"tf":1.4142135623730951},"72":{"tf":1.0}}},"i":{"b":{"c":{"df":2,"docs":{"21":{"tf":1.0},"25":{"tf":1.0}}},"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"21":{"tf":1.0},"99":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":2,"docs":{"115":{"tf":2.449489742783178},"116":{"tf":2.449489742783178}}}},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":1,"docs":{"89":{"tf":2.6457513110645907}}}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":3,"docs":{"73":{"tf":1.0},"74":{"tf":1.0},"94":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"e":{"\'":{"df":2,"docs":{"56":{"tf":1.0},"70":{"tf":1.0}}},"?":{"/":{"#":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"117":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"56":{"tf":1.0}}},"df":0,"docs":{}}}},"df":33,"docs":{"101":{"tf":1.0},"114":{"tf":2.6457513110645907},"115":{"tf":3.605551275463989},"116":{"tf":5.196152422706632},"117":{"tf":2.0},"118":{"tf":2.449489742783178},"17":{"tf":1.0},"2":{"tf":1.0},"29":{"tf":1.0},"44":{"tf":2.0},"45":{"tf":2.0},"46":{"tf":3.1622776601683795},"48":{"tf":3.4641016151377544},"49":{"tf":2.6457513110645907},"50":{"tf":1.0},"52":{"tf":1.4142135623730951},"53":{"tf":2.0},"56":{"tf":3.3166247903554},"57":{"tf":1.7320508075688772},"59":{"tf":2.0},"60":{"tf":6.164414002968976},"63":{"tf":1.0},"68":{"tf":1.4142135623730951},"70":{"tf":4.898979485566356},"72":{"tf":2.6457513110645907},"81":{"tf":2.23606797749979},"82":{"tf":2.0},"84":{"tf":3.7416573867739413},"87":{"tf":1.0},"91":{"tf":1.0},"93":{"tf":4.0},"94":{"tf":1.0},"99":{"tf":1.4142135623730951}}},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"99":{"tf":1.0}}}}}}},"k":{"df":6,"docs":{"119":{"tf":1.0},"22":{"tf":1.7320508075688772},"24":{"tf":1.0},"64":{"tf":1.0},"75":{"tf":1.0},"93":{"tf":2.0}}},"t":{"df":1,"docs":{"61":{"tf":1.0}}},"u":{"df":0,"docs":{},"x":{"/":{"df":0,"docs":{},"m":{"a":{"c":{"df":0,"docs":{},"o":{"df":1,"docs":{"2":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":10,"docs":{"112":{"tf":1.0},"12":{"tf":1.0},"21":{"tf":1.4142135623730951},"22":{"tf":1.0},"3":{"tf":1.4142135623730951},"4":{"tf":1.0},"68":{"tf":1.0},"75":{"tf":1.0},"8":{"tf":1.0},"94":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"p":{"df":2,"docs":{"112":{"tf":1.0},"61":{"tf":1.0}}},"t":{"df":14,"docs":{"100":{"tf":1.0},"102":{"tf":1.4142135623730951},"103":{"tf":1.4142135623730951},"110":{"tf":1.0},"116":{"tf":2.0},"26":{"tf":1.0},"60":{"tf":1.0},"67":{"tf":1.0},"70":{"tf":1.0},"72":{"tf":2.23606797749979},"87":{"tf":1.0},"89":{"tf":1.0},"93":{"tf":1.4142135623730951},"94":{"tf":1.7320508075688772}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":4,"docs":{"54":{"tf":1.4142135623730951},"79":{"tf":1.0},"80":{"tf":1.0},"96":{"tf":1.0}}}},"t":{"df":0,"docs":{},"l":{"df":1,"docs":{"73":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"e":{"df":1,"docs":{"98":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"v":{"df":0,"docs":{},"m":{"df":1,"docs":{"61":{"tf":1.7320508075688772}}}}},"n":{"df":1,"docs":{"22":{"tf":1.0}}},"o":{"a":{"d":{"df":2,"docs":{"21":{"tf":1.0},"59":{"tf":1.0}}},"df":0,"docs":{}},"c":{"a":{"df":0,"docs":{},"l":{"/":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"12":{"tf":1.0}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"/":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"24":{"tf":1.0}},"i":{"c":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"/":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{".":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"k":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":1,"docs":{"24":{"tf":1.7320508075688772}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"24":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":8,"docs":{"109":{"tf":1.0},"112":{"tf":1.4142135623730951},"21":{"tf":1.0},"5":{"tf":1.0},"68":{"tf":1.0},"75":{"tf":1.4142135623730951},"84":{"tf":1.0},"98":{"tf":1.0}}},"t":{"df":8,"docs":{"111":{"tf":1.7320508075688772},"2":{"tf":1.7320508075688772},"32":{"tf":1.0},"39":{"tf":1.0},"48":{"tf":1.0},"68":{"tf":1.0},"75":{"tf":1.0},"98":{"tf":1.0}}}},"df":0,"docs":{},"k":{"df":3,"docs":{"21":{"tf":1.4142135623730951},"22":{"tf":1.0},"25":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"g":{"df":3,"docs":{"59":{"tf":1.4142135623730951},"60":{"tf":1.0},"61":{"tf":1.0}}},"n":{"df":0,"docs":{},"g":{"df":3,"docs":{"25":{"tf":1.0},"60":{"tf":2.8284271247461903},"84":{"tf":1.0}},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"93":{"tf":1.0}}}}}}},"o":{"df":0,"docs":{},"k":{"df":6,"docs":{"102":{"tf":1.0},"103":{"tf":1.0},"22":{"tf":1.0},"48":{"tf":1.0},"79":{"tf":1.0},"99":{"tf":1.0}}},"p":{"df":1,"docs":{"93":{"tf":1.0}}}},"s":{"df":0,"docs":{},"e":{"df":1,"docs":{"116":{"tf":1.0}}},"s":{"df":1,"docs":{"70":{"tf":1.0}}},"t":{"df":1,"docs":{"77":{"tf":1.0}}}},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"c":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"60":{"tf":1.0}}}},"df":0,"docs":{}},"df":1,"docs":{"45":{"tf":1.0}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"114":{"tf":1.0}}}}}}},"p":{"df":0,"docs":{},"f":{"df":1,"docs":{"61":{"tf":1.0}}}},"s":{"df":1,"docs":{"61":{"tf":3.0}},"p":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"57":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":13,"docs":{"102":{"tf":2.0},"103":{"tf":2.23606797749979},"42":{"tf":1.0},"45":{"tf":1.0},"48":{"tf":4.123105625617661},"57":{"tf":1.4142135623730951},"59":{"tf":1.7320508075688772},"61":{"tf":4.58257569495584},"70":{"tf":1.4142135623730951},"72":{"tf":1.0},"73":{"tf":2.0},"98":{"tf":1.4142135623730951},"99":{"tf":2.23606797749979}}}},"t":{"df":1,"docs":{"60":{"tf":1.4142135623730951}}},"u":{"a":{"df":1,"docs":{"61":{"tf":1.4142135623730951}},"u":{"df":1,"docs":{"61":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"m":{"a":{"c":{"df":3,"docs":{"68":{"tf":1.0},"75":{"tf":1.0},"96":{"tf":1.0}},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"100":{"tf":1.0}}}}},"o":{"df":5,"docs":{"13":{"tf":1.0},"21":{"tf":1.4142135623730951},"22":{"tf":1.0},"3":{"tf":1.0},"70":{"tf":1.0}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":2,"docs":{"15":{"tf":1.0},"3":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"o":{"df":6,"docs":{"34":{"tf":1.0},"45":{"tf":1.4142135623730951},"60":{"tf":1.4142135623730951},"61":{"tf":1.0},"93":{"tf":1.0},"94":{"tf":2.23606797749979}}}}},"df":2,"docs":{"37":{"tf":1.4142135623730951},"60":{"tf":1.4142135623730951}},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"a":{"df":1,"docs":{"89":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"61":{"tf":1.0}}},"n":{"df":6,"docs":{"27":{"tf":1.0},"46":{"tf":1.4142135623730951},"48":{"tf":1.0},"59":{"tf":1.4142135623730951},"60":{"tf":1.4142135623730951},"84":{"tf":1.4142135623730951}}}},"k":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"h":{"_":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"_":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"60":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":17,"docs":{"108":{"tf":1.0},"109":{"tf":1.0},"11":{"tf":1.0},"111":{"tf":1.0},"113":{"tf":1.0},"114":{"tf":1.0},"12":{"tf":1.0},"17":{"tf":1.0},"22":{"tf":1.0},"23":{"tf":1.0},"27":{"tf":1.0},"50":{"tf":1.0},"60":{"tf":1.7320508075688772},"61":{"tf":1.0},"70":{"tf":1.0},"9":{"tf":1.0},"95":{"tf":1.0}},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"100":{"tf":1.7320508075688772}}}}}}},"n":{"a":{"df":0,"docs":{},"g":{"df":3,"docs":{"1":{"tf":1.0},"17":{"tf":1.0},"3":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":4,"docs":{"116":{"tf":1.0},"39":{"tf":1.0},"64":{"tf":1.0},"84":{"tf":1.0}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":5,"docs":{"31":{"tf":1.0},"37":{"tf":1.4142135623730951},"42":{"tf":1.0},"46":{"tf":1.0},"48":{"tf":1.0}}}}}}},"p":{"df":7,"docs":{"116":{"tf":2.0},"26":{"tf":1.0},"42":{"tf":2.23606797749979},"48":{"tf":1.7320508075688772},"76":{"tf":1.0},"94":{"tf":3.1622776601683795},"95":{"tf":1.4142135623730951}}},"r":{"df":0,"docs":{},"k":{"d":{"df":0,"docs":{},"o":{"c":{"df":1,"docs":{"61":{"tf":1.4142135623730951}}},"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"61":{"tf":1.0}}}}}}}},"df":1,"docs":{"61":{"tf":1.7320508075688772}}}}}},"df":2,"docs":{"120":{"tf":1.0},"42":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"93":{"tf":1.0},"99":{"tf":1.0}}}},"s":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"61":{"tf":1.0}}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"p":{"df":2,"docs":{"93":{"tf":1.4142135623730951},"99":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"0":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}}}}}},"t":{"c":{"df":0,"docs":{},"h":{"?":{"/":{"#":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"117":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"_":{"b":{"df":0,"docs":{},"r":{"a":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":14,"docs":{"100":{"tf":2.8284271247461903},"117":{"tf":1.7320508075688772},"121":{"tf":1.0},"122":{"tf":1.4142135623730951},"25":{"tf":1.0},"41":{"tf":1.0},"42":{"tf":1.0},"46":{"tf":2.0},"47":{"tf":1.4142135623730951},"48":{"tf":1.7320508075688772},"60":{"tf":3.0},"78":{"tf":1.0},"93":{"tf":1.7320508075688772},"99":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"100":{"tf":1.0}}},"s":{"!":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":1,"docs":{"115":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{},"l":{"a":{"b":{"df":1,"docs":{"61":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"114":{"tf":1.0}}}}}},"x":{"df":3,"docs":{"75":{"tf":1.0},"82":{"tf":2.0},"84":{"tf":1.4142135623730951}},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":7,"docs":{"102":{"tf":1.0},"70":{"tf":1.0},"73":{"tf":1.0},"75":{"tf":1.0},"82":{"tf":1.4142135623730951},"84":{"tf":1.0},"99":{"tf":1.0}}}}}}}},"d":{"<":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"36":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":2,"docs":{"33":{"tf":1.0},"60":{"tf":1.4142135623730951}}},"df":7,"docs":{"33":{"tf":1.0},"37":{"tf":1.0},"44":{"tf":1.0},"48":{"tf":2.23606797749979},"56":{"tf":1.4142135623730951},"57":{"tf":1.4142135623730951},"95":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"n":{"df":9,"docs":{"114":{"tf":1.0},"118":{"tf":1.0},"27":{"tf":1.0},"29":{"tf":1.0},"41":{"tf":1.0},"63":{"tf":1.0},"75":{"tf":1.0},"83":{"tf":1.4142135623730951},"96":{"tf":1.0}}}},"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"49":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"93":{"tf":1.0}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"28":{"tf":1.0}}}}}},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":4,"docs":{"116":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.0},"63":{"tf":1.0}}}}}},"u":{"df":7,"docs":{"103":{"tf":1.0},"24":{"tf":1.4142135623730951},"42":{"tf":1.0},"48":{"tf":1.7320508075688772},"70":{"tf":1.0},"83":{"tf":2.0},"93":{"tf":1.0}}}},"r":{"df":0,"docs":{},"g":{"df":7,"docs":{"103":{"tf":1.0},"46":{"tf":1.4142135623730951},"60":{"tf":1.4142135623730951},"68":{"tf":1.0},"89":{"tf":1.0},"93":{"tf":1.0},"98":{"tf":1.0}},"e":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"46":{"tf":1.0},"60":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"46":{"tf":1.0},"60":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"m":{"a":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"61":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"61":{"tf":1.0}},"l":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":1,"docs":{"61":{"tf":1.0}}}}}}},"s":{"a":{"df":0,"docs":{},"g":{"df":2,"docs":{"60":{"tf":1.0},"73":{"tf":2.0}}}},"df":0,"docs":{}}},"t":{"a":{"df":1,"docs":{"96":{"tf":1.4142135623730951}},"l":{"df":1,"docs":{"61":{"tf":1.0}}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"d":{"df":3,"docs":{"104":{"tf":1.0},"22":{"tf":1.0},"93":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}},"i":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":1,"docs":{"17":{"tf":1.0}}}}}}}}},"d":{"d":{"df":0,"docs":{},"l":{"df":4,"docs":{"48":{"tf":1.4142135623730951},"60":{"tf":1.0},"70":{"tf":1.4142135623730951},"72":{"tf":1.0}}}},"df":1,"docs":{"82":{"tf":1.0}}},"df":2,"docs":{"37":{"tf":1.4142135623730951},"60":{"tf":1.4142135623730951}},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"63":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"70":{"tf":1.4142135623730951},"77":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"n":{"d":{"df":1,"docs":{"89":{"tf":1.0}}},"df":2,"docs":{"70":{"tf":1.0},"81":{"tf":1.4142135623730951}},"g":{"df":0,"docs":{},"w":{"df":1,"docs":{"20":{"tf":1.0}}}},"i":{"df":0,"docs":{},"m":{"df":2,"docs":{"49":{"tf":1.0},"99":{"tf":1.0}},"u":{"df":0,"docs":{},"m":{"df":4,"docs":{"65":{"tf":1.0},"70":{"tf":1.0},"81":{"tf":1.0},"84":{"tf":1.4142135623730951}}}}}},"o":{"df":0,"docs":{},"r":{"df":3,"docs":{"42":{"tf":1.0},"48":{"tf":1.0},"95":{"tf":1.7320508075688772}}}},"t":{"df":3,"docs":{"25":{"tf":1.0},"5":{"tf":1.0},"61":{"tf":1.4142135623730951}}},"u":{"df":4,"docs":{"46":{"tf":1.0},"60":{"tf":1.4142135623730951},"93":{"tf":1.0},"96":{"tf":1.0}}}},"r":{"df":1,"docs":{"61":{"tf":1.4142135623730951}}},"s":{"df":0,"docs":{},"s":{"df":3,"docs":{"116":{"tf":1.0},"64":{"tf":1.0},"70":{"tf":1.0}}}},"w":{"<":{"a":{"df":1,"docs":{"94":{"tf":1.0}}},"df":0,"docs":{}},"df":1,"docs":{"94":{"tf":1.0}}}},"k":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":1,"docs":{"12":{"tf":1.0}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":1,"docs":{"22":{"tf":1.0}}}}}}},"m":{"df":1,"docs":{"60":{"tf":1.4142135623730951}}},"o":{"d":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"27":{"tf":1.0},"49":{"tf":2.0}}}},"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"72":{"tf":1.4142135623730951}}}}}}}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"l":{"/":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"/":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"72":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":1,"docs":{"72":{"tf":1.4142135623730951}}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"72":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}}},"df":24,"docs":{"12":{"tf":1.0},"27":{"tf":3.0},"30":{"tf":1.0},"33":{"tf":1.0},"40":{"tf":1.0},"42":{"tf":3.0},"43":{"tf":2.0},"45":{"tf":1.4142135623730951},"48":{"tf":5.291502622129181},"49":{"tf":2.6457513110645907},"50":{"tf":2.23606797749979},"56":{"tf":1.0},"59":{"tf":1.4142135623730951},"60":{"tf":2.0},"64":{"tf":1.7320508075688772},"66":{"tf":1.0},"68":{"tf":1.0},"70":{"tf":2.23606797749979},"72":{"tf":3.1622776601683795},"74":{"tf":2.0},"84":{"tf":1.0},"93":{"tf":3.0},"94":{"tf":2.0},"95":{"tf":2.449489742783178}},"l":{"df":3,"docs":{"29":{"tf":1.0},"63":{"tf":1.4142135623730951},"64":{"tf":1.0}}},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"17":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"f":{"df":4,"docs":{"48":{"tf":1.0},"60":{"tf":1.0},"72":{"tf":1.4142135623730951},"93":{"tf":1.0}},"i":{"df":13,"docs":{"24":{"tf":1.0},"31":{"tf":1.0},"53":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.4142135623730951},"72":{"tf":1.0},"87":{"tf":2.0},"90":{"tf":2.0},"91":{"tf":1.0},"93":{"tf":1.4142135623730951},"94":{"tf":1.4142135623730951},"95":{"tf":1.0},"96":{"tf":2.23606797749979}},"e":{"d":{"/":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"48":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"j":{"df":0,"docs":{},"o":{"df":1,"docs":{"61":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"df":17,"docs":{"108":{"tf":1.0},"110":{"tf":1.0},"112":{"tf":1.0},"116":{"tf":1.4142135623730951},"118":{"tf":1.0},"119":{"tf":1.0},"21":{"tf":1.0},"23":{"tf":1.0},"31":{"tf":1.0},"39":{"tf":1.0},"40":{"tf":1.0},"49":{"tf":1.0},"51":{"tf":1.0},"61":{"tf":1.0},"70":{"tf":1.4142135623730951},"94":{"tf":1.0},"99":{"tf":1.4142135623730951}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"48":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":5,"docs":{"31":{"tf":1.7320508075688772},"39":{"tf":1.0},"44":{"tf":1.0},"50":{"tf":1.0},"60":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"s":{"df":2,"docs":{"68":{"tf":1.0},"70":{"tf":1.4142135623730951}}}},"v":{"df":0,"docs":{},"e":{"_":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":4,"docs":{"44":{"tf":1.0},"49":{"tf":1.0},"60":{"tf":1.0},"94":{"tf":1.4142135623730951}}}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":4,"docs":{"44":{"tf":1.0},"49":{"tf":1.0},"60":{"tf":1.0},"94":{"tf":1.0}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"_":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":3,"docs":{"48":{"tf":1.0},"49":{"tf":1.0},"60":{"tf":1.0}}}}}},"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":4,"docs":{"48":{"tf":1.0},"49":{"tf":1.0},"60":{"tf":1.0},"94":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"44":{"tf":1.0},"60":{"tf":1.0}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":2,"docs":{"44":{"tf":1.0},"60":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"s":{"df":0,"docs":{},"u":{"b":{"_":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"60":{"tf":1.0}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"60":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"44":{"tf":1.0},"60":{"tf":1.0}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":2,"docs":{"44":{"tf":1.0},"60":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"p":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":3,"docs":{"46":{"tf":1.0},"60":{"tf":1.0},"83":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":3,"docs":{"46":{"tf":1.0},"60":{"tf":1.0},"83":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"60":{"tf":1.0}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":2,"docs":{"44":{"tf":1.0},"60":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"s":{"df":0,"docs":{},"u":{"b":{"_":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"60":{"tf":1.0}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"60":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"60":{"tf":1.0}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":2,"docs":{"44":{"tf":1.0},"60":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"_":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":2,"docs":{"44":{"tf":1.0},"60":{"tf":1.0}}}}}},"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":2,"docs":{"44":{"tf":1.0},"60":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":15,"docs":{"31":{"tf":1.4142135623730951},"38":{"tf":1.4142135623730951},"39":{"tf":2.0},"44":{"tf":4.0},"45":{"tf":1.4142135623730951},"46":{"tf":1.4142135623730951},"48":{"tf":3.1622776601683795},"49":{"tf":2.449489742783178},"52":{"tf":1.4142135623730951},"59":{"tf":1.4142135623730951},"60":{"tf":5.830951894845301},"61":{"tf":1.0},"77":{"tf":1.0},"84":{"tf":1.0},"93":{"tf":1.4142135623730951}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":5,"docs":{"31":{"tf":1.0},"42":{"tf":1.0},"44":{"tf":1.0},"50":{"tf":1.0},"94":{"tf":1.0}}}}}}}}},"r":{"<":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"a":{"c":{"df":0,"docs":{},"e":{">":{"<":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"_":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"36":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":2,"docs":{"36":{"tf":1.0},"60":{"tf":1.4142135623730951}}},"s":{"<":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"36":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"61":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":1,"docs":{"60":{"tf":1.4142135623730951}},"y":{"df":0,"docs":{},"s":{"2":{"df":3,"docs":{"16":{"tf":1.0},"20":{"tf":1.0},"3":{"tf":1.0}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"99":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"l":{"df":14,"docs":{"103":{"tf":1.0},"104":{"tf":1.0},"114":{"tf":1.0},"116":{"tf":1.7320508075688772},"21":{"tf":1.0},"22":{"tf":1.7320508075688772},"28":{"tf":1.0},"30":{"tf":1.7320508075688772},"35":{"tf":1.4142135623730951},"36":{"tf":1.4142135623730951},"41":{"tf":1.0},"57":{"tf":1.0},"70":{"tf":1.0},"93":{"tf":2.0}},"e":{"/":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":1,"docs":{"72":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"s":{"df":0,"docs":{},"l":{"df":1,"docs":{"21":{"tf":1.0}}},"t":{"/":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"117":{"tf":2.23606797749979}}}}}}},"df":0,"docs":{}}},"t":{"df":1,"docs":{"93":{"tf":1.0}}}},"v":{"df":2,"docs":{"12":{"tf":1.0},"59":{"tf":1.0}}},"y":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":5,"docs":{"101":{"tf":1.0},"102":{"tf":1.0},"104":{"tf":1.0},"98":{"tf":1.0},"99":{"tf":2.23606797749979}}}}},"df":1,"docs":{"99":{"tf":1.0}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"86":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}}}},"n":{"/":{"a":{"df":2,"docs":{"45":{"tf":1.0},"48":{"tf":2.8284271247461903}}},"c":{"df":1,"docs":{"83":{"tf":1.0}}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":28,"docs":{"100":{"tf":1.0},"102":{"tf":1.0},"103":{"tf":2.0},"104":{"tf":1.7320508075688772},"112":{"tf":1.0},"114":{"tf":1.0},"117":{"tf":1.0},"12":{"tf":1.0},"120":{"tf":1.0},"22":{"tf":1.4142135623730951},"25":{"tf":1.0},"33":{"tf":1.0},"35":{"tf":1.0},"41":{"tf":1.7320508075688772},"56":{"tf":1.4142135623730951},"57":{"tf":1.4142135623730951},"59":{"tf":2.23606797749979},"60":{"tf":1.0},"72":{"tf":2.23606797749979},"76":{"tf":1.0},"84":{"tf":1.0},"85":{"tf":1.4142135623730951},"86":{"tf":1.7320508075688772},"89":{"tf":1.7320508075688772},"93":{"tf":1.7320508075688772},"96":{"tf":1.0},"98":{"tf":1.0},"99":{"tf":2.6457513110645907}},"s":{"df":0,"docs":{},"p":{"a":{"c":{"df":1,"docs":{"93":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"s":{"df":0,"docs":{},"m":{"df":1,"docs":{"61":{"tf":1.0}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":2,"docs":{"65":{"tf":1.0},"70":{"tf":2.0}}}}},"v":{"df":1,"docs":{"38":{"tf":1.0}},"i":{"df":0,"docs":{},"g":{"df":6,"docs":{"113":{"tf":2.0},"27":{"tf":1.0},"31":{"tf":1.0},"38":{"tf":1.4142135623730951},"40":{"tf":1.0},"83":{"tf":1.4142135623730951}}}}}},"b":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":1,"docs":{"79":{"tf":2.0}}}}},"df":13,"docs":{"39":{"tf":1.4142135623730951},"44":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.4142135623730951},"48":{"tf":2.23606797749979},"50":{"tf":2.0},"51":{"tf":1.0},"52":{"tf":1.0},"54":{"tf":1.4142135623730951},"56":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":2.449489742783178},"99":{"tf":1.0}},"e":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":3,"docs":{"108":{"tf":1.0},"2":{"tf":1.0},"59":{"tf":1.7320508075688772}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"d":{"_":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"116":{"tf":1.7320508075688772}}}}},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":1,"docs":{"115":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}}}}},"df":1,"docs":{"116":{"tf":1.0}}}}}}},"df":7,"docs":{"1":{"tf":1.0},"107":{"tf":1.0},"110":{"tf":1.0},"111":{"tf":1.0},"116":{"tf":1.0},"25":{"tf":1.0},"37":{"tf":1.0}}},"df":0,"docs":{}},"g":{"df":2,"docs":{"70":{"tf":1.4142135623730951},"75":{"tf":1.0}}},"l":{"df":1,"docs":{"70":{"tf":1.0}}},"o":{"c":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":1,"docs":{"61":{"tf":1.0}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"121":{"tf":1.0},"95":{"tf":1.0}},"e":{"d":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"61":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"t":{"df":1,"docs":{"116":{"tf":1.0}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"70":{"tf":1.4142135623730951}}}}},"w":{"df":17,"docs":{"106":{"tf":1.0},"107":{"tf":1.4142135623730951},"108":{"tf":2.23606797749979},"109":{"tf":1.4142135623730951},"110":{"tf":1.4142135623730951},"114":{"tf":1.7320508075688772},"115":{"tf":2.23606797749979},"116":{"tf":1.7320508075688772},"22":{"tf":1.0},"45":{"tf":1.4142135623730951},"49":{"tf":1.7320508075688772},"59":{"tf":2.0},"60":{"tf":2.0},"70":{"tf":1.4142135623730951},"84":{"tf":1.0},"9":{"tf":1.0},"95":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"115":{"tf":1.0},"70":{"tf":1.0}},"n":{"df":7,"docs":{"35":{"tf":1.0},"46":{"tf":1.0},"48":{"tf":1.4142135623730951},"59":{"tf":1.7320508075688772},"60":{"tf":2.23606797749979},"70":{"tf":1.4142135623730951},"79":{"tf":2.0}}}}}},"x":{"df":0,"docs":{},"t":{"df":17,"docs":{"103":{"tf":1.0},"116":{"tf":1.0},"28":{"tf":1.0},"31":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":1.0},"44":{"tf":2.449489742783178},"46":{"tf":1.7320508075688772},"47":{"tf":1.0},"48":{"tf":3.4641016151377544},"49":{"tf":1.7320508075688772},"50":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":2.0},"59":{"tf":1.4142135623730951},"60":{"tf":6.082762530298219},"73":{"tf":1.0}}}}},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"x":{"df":1,"docs":{"61":{"tf":1.0}}}}}},"i":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"61":{"tf":1.0}}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"1":{"tf":1.0}}}}}}},"l":{"df":2,"docs":{"61":{"tf":1.0},"93":{"tf":1.0}}},"m":{"df":1,"docs":{"61":{"tf":1.0}},"l":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{"df":1,"docs":{"61":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}},"x":{"d":{"df":1,"docs":{"61":{"tf":1.0}}},"df":3,"docs":{"119":{"tf":1.0},"61":{"tf":1.0},"9":{"tf":1.7320508075688772}},"o":{"df":2,"docs":{"3":{"tf":1.0},"9":{"tf":1.0}}},"p":{"df":0,"docs":{},"k":{"df":0,"docs":{},"g":{"df":1,"docs":{"9":{"tf":1.0}}}}}}},"l":{"df":1,"docs":{"61":{"tf":1.0}}},"n":{"b":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":1,"docs":{"79":{"tf":2.0}}}}},"df":0,"docs":{}},"o":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":3,"docs":{"49":{"tf":2.8284271247461903},"60":{"tf":1.0},"96":{"tf":1.0}}}}},"d":{"df":0,"docs":{},"e":{"\'":{"df":1,"docs":{"116":{"tf":1.0}}},"df":12,"docs":{"113":{"tf":1.0},"114":{"tf":1.4142135623730951},"115":{"tf":2.0},"116":{"tf":3.4641016151377544},"118":{"tf":2.6457513110645907},"119":{"tf":1.0},"120":{"tf":2.0},"121":{"tf":2.0},"39":{"tf":2.0},"46":{"tf":2.6457513110645907},"48":{"tf":1.0},"60":{"tf":2.8284271247461903}},"’":{"df":1,"docs":{"121":{"tf":1.0}}}}},"df":0,"docs":{},"n":{"df":6,"docs":{"48":{"tf":1.0},"60":{"tf":1.4142135623730951},"70":{"tf":1.0},"73":{"tf":1.0},"83":{"tf":1.0},"93":{"tf":1.0}},"e":{"df":3,"docs":{"34":{"tf":1.0},"70":{"tf":1.7320508075688772},"79":{"tf":2.23606797749979}}}},"o":{"df":0,"docs":{},"p":{"df":2,"docs":{"56":{"tf":1.0},"59":{"tf":1.0}}}},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"d":{"df":4,"docs":{"49":{"tf":1.0},"60":{"tf":1.0},"94":{"tf":1.7320508075688772},"95":{"tf":1.0}}},"df":0,"docs":{}}}},"df":17,"docs":{"116":{"tf":1.0},"27":{"tf":1.7320508075688772},"42":{"tf":1.0},"43":{"tf":1.4142135623730951},"48":{"tf":2.8284271247461903},"49":{"tf":1.7320508075688772},"50":{"tf":1.4142135623730951},"57":{"tf":1.0},"60":{"tf":14.89966442575134},"68":{"tf":1.4142135623730951},"72":{"tf":1.4142135623730951},"74":{"tf":1.4142135623730951},"83":{"tf":1.4142135623730951},"89":{"tf":1.0},"93":{"tf":1.4142135623730951},"94":{"tf":1.4142135623730951},"95":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"63":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":16,"docs":{"1":{"tf":1.0},"100":{"tf":1.0},"105":{"tf":1.0},"112":{"tf":1.0},"114":{"tf":1.0},"116":{"tf":1.7320508075688772},"118":{"tf":1.0},"21":{"tf":1.0},"22":{"tf":1.0},"41":{"tf":1.0},"44":{"tf":1.0},"56":{"tf":1.0},"61":{"tf":1.0},"70":{"tf":1.0},"93":{"tf":1.0},"96":{"tf":1.0}}},"h":{"df":2,"docs":{"59":{"tf":1.0},"60":{"tf":1.0}}}},"w":{"df":1,"docs":{"94":{"tf":1.0}}}},"u":{"a":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}},"df":1,"docs":{"61":{"tf":1.4142135623730951}},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"96":{"tf":1.4142135623730951}}}},"m":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":19,"docs":{"117":{"tf":1.0},"44":{"tf":1.0},"45":{"tf":1.4142135623730951},"48":{"tf":1.4142135623730951},"56":{"tf":2.6457513110645907},"57":{"tf":1.0},"59":{"tf":2.0},"60":{"tf":1.4142135623730951},"68":{"tf":1.0},"69":{"tf":1.0},"70":{"tf":2.8284271247461903},"72":{"tf":2.6457513110645907},"73":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":2.6457513110645907},"84":{"tf":1.0},"93":{"tf":2.0},"94":{"tf":1.0},"99":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"93":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"j":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"61":{"tf":1.0}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"66":{"tf":1.0}}}}}}}},"o":{"b":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{".":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"113":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"113":{"tf":1.0}}},"df":0,"docs":{}}}}},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":1,"docs":{"113":{"tf":1.0}}}}}},"df":6,"docs":{"37":{"tf":1.4142135623730951},"45":{"tf":1.4142135623730951},"46":{"tf":1.0},"48":{"tf":1.4142135623730951},"57":{"tf":1.0},"60":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"67":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"c":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":2,"docs":{"104":{"tf":1.0},"61":{"tf":1.4142135623730951}},"l":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":1,"docs":{"61":{"tf":1.4142135623730951}}}}}}}},"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"116":{"tf":1.4142135623730951}},"r":{"df":3,"docs":{"116":{"tf":1.4142135623730951},"36":{"tf":1.0},"60":{"tf":2.8284271247461903}}}}}},"df":0,"docs":{}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"61":{"tf":1.0}}}}},"df":10,"docs":{"115":{"tf":2.0},"33":{"tf":1.0},"39":{"tf":1.4142135623730951},"44":{"tf":1.0},"45":{"tf":1.4142135623730951},"46":{"tf":1.0},"48":{"tf":1.4142135623730951},"59":{"tf":1.0},"60":{"tf":3.4641016151377544},"94":{"tf":2.0}},"f":{"?":{"/":{"#":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"117":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":2,"docs":{"112":{"tf":1.0},"12":{"tf":1.0}}}},"df":0,"docs":{}}}},"h":{"df":0,"docs":{},"m":{"df":1,"docs":{"61":{"tf":1.0}}}},"l":{"d":{"df":1,"docs":{"84":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"5":{"tf":1.0}}}}},"df":1,"docs":{"61":{"tf":1.0}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":4,"docs":{"102":{"tf":1.0},"104":{"tf":1.0},"105":{"tf":1.0},"87":{"tf":1.0}}}},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"p":{"df":1,"docs":{"61":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"n":{"c":{"df":3,"docs":{"116":{"tf":2.0},"28":{"tf":1.0},"56":{"tf":1.0}}},"df":17,"docs":{"102":{"tf":1.0},"116":{"tf":2.8284271247461903},"117":{"tf":2.0},"119":{"tf":1.0},"121":{"tf":1.0},"122":{"tf":1.0},"22":{"tf":1.0},"30":{"tf":1.0},"35":{"tf":1.0},"41":{"tf":1.0},"49":{"tf":1.4142135623730951},"59":{"tf":1.4142135623730951},"60":{"tf":1.4142135623730951},"70":{"tf":2.0},"83":{"tf":1.7320508075688772},"91":{"tf":1.0},"94":{"tf":1.4142135623730951}},"e":{"d":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":1,"docs":{"68":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"46":{"tf":1.7320508075688772}}}}},"p":{"df":1,"docs":{"33":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"/":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":1,"docs":{"56":{"tf":1.0}}}}}},"df":0,"docs":{}},"_":{"a":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":2,"docs":{"45":{"tf":1.0},"60":{"tf":1.0}}}}},"df":0,"docs":{}},"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":3,"docs":{"45":{"tf":1.0},"60":{"tf":1.0},"94":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"l":{"df":1,"docs":{"61":{"tf":1.0}}}},"df":14,"docs":{"28":{"tf":1.4142135623730951},"45":{"tf":1.4142135623730951},"48":{"tf":3.4641016151377544},"51":{"tf":2.0},"52":{"tf":1.0},"54":{"tf":2.23606797749979},"55":{"tf":1.4142135623730951},"56":{"tf":1.0},"59":{"tf":3.7416573867739413},"60":{"tf":4.123105625617661},"68":{"tf":1.4142135623730951},"70":{"tf":1.4142135623730951},"72":{"tf":2.6457513110645907},"94":{"tf":1.4142135623730951}},"s":{"c":{"a":{"d":{"df":1,"docs":{"61":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"r":{"df":8,"docs":{"1":{"tf":1.0},"27":{"tf":1.0},"37":{"tf":1.0},"41":{"tf":1.0},"47":{"tf":1.0},"68":{"tf":1.0},"70":{"tf":1.0},"93":{"tf":1.4142135623730951}}}},"t":{"df":2,"docs":{"21":{"tf":1.0},"22":{"tf":1.0}},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"21":{"tf":1.0}}},"o":{"df":0,"docs":{},"n":{"\'":{"df":1,"docs":{"57":{"tf":1.4142135623730951}}},"df":19,"docs":{"102":{"tf":2.0},"119":{"tf":1.0},"12":{"tf":1.0},"53":{"tf":1.4142135623730951},"55":{"tf":1.4142135623730951},"57":{"tf":3.872983346207417},"59":{"tf":3.872983346207417},"71":{"tf":1.4142135623730951},"74":{"tf":1.0},"75":{"tf":1.7320508075688772},"78":{"tf":1.0},"79":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.7320508075688772},"82":{"tf":1.0},"83":{"tf":1.4142135623730951},"84":{"tf":2.0},"89":{"tf":1.0},"93":{"tf":1.0}}}}}}},"r":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":8,"docs":{"103":{"tf":1.7320508075688772},"107":{"tf":1.0},"110":{"tf":1.0},"113":{"tf":1.0},"22":{"tf":1.4142135623730951},"70":{"tf":1.0},"94":{"tf":1.0},"99":{"tf":1.0}}}}},"df":0,"docs":{},"g":{"df":1,"docs":{"61":{"tf":1.0}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"65":{"tf":1.0},"99":{"tf":1.0}}}}}}},"s":{"c":{"df":1,"docs":{"71":{"tf":1.0}}},"df":1,"docs":{"22":{"tf":1.0}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"48":{"tf":1.0},"59":{"tf":1.4142135623730951}},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":4,"docs":{"35":{"tf":1.0},"57":{"tf":1.0},"60":{"tf":1.0},"70":{"tf":1.0}}}}}}}}},"u":{"df":0,"docs":{},"t":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{".":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"y":{"df":1,"docs":{"116":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":2,"docs":{"116":{"tf":3.1622776601683795},"118":{"tf":1.7320508075688772}},"—":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":1,"docs":{"118":{"tf":1.0}}}}}}}}}}},"df":7,"docs":{"111":{"tf":1.0},"116":{"tf":1.0},"118":{"tf":1.0},"22":{"tf":1.0},"33":{"tf":1.0},"60":{"tf":1.0},"72":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"36":{"tf":1.0}}}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":5,"docs":{"45":{"tf":2.0},"57":{"tf":2.0},"59":{"tf":2.23606797749979},"60":{"tf":1.7320508075688772},"9":{"tf":1.4142135623730951}}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":6,"docs":{"116":{"tf":1.0},"48":{"tf":1.0},"71":{"tf":1.0},"82":{"tf":1.0},"89":{"tf":1.0},"99":{"tf":1.0}},"r":{"df":0,"docs":{},"i":{"d":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":3,"docs":{"70":{"tf":1.0},"86":{"tf":1.0},"98":{"tf":1.0}}}}},"df":7,"docs":{"2":{"tf":1.0},"68":{"tf":1.0},"70":{"tf":1.4142135623730951},"76":{"tf":1.0},"92":{"tf":1.4142135623730951},"98":{"tf":1.0},"99":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":2,"docs":{"0":{"tf":1.0},"87":{"tf":1.0}}}}}},"w":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"99":{"tf":1.0}}}}}}}}},"x":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"61":{"tf":1.0}}},"df":0,"docs":{}}}},"p":{"a":{"c":{"df":0,"docs":{},"k":{"a":{"df":0,"docs":{},"g":{"df":8,"docs":{"1":{"tf":1.0},"17":{"tf":1.0},"21":{"tf":1.7320508075688772},"22":{"tf":1.7320508075688772},"25":{"tf":2.449489742783178},"3":{"tf":1.4142135623730951},"5":{"tf":1.0},"8":{"tf":1.0}}}},"df":0,"docs":{}},"m":{"a":{"df":0,"docs":{},"n":{"df":2,"docs":{"20":{"tf":1.0},"8":{"tf":1.0}}}},"df":0,"docs":{}}},"d":{"df":1,"docs":{"70":{"tf":1.4142135623730951}}},"df":1,"docs":{"41":{"tf":1.0}},"g":{"df":0,"docs":{},"e":{"_":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"_":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":1,"docs":{"60":{"tf":1.0}}}}}},"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"_":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":3,"docs":{"44":{"tf":1.0},"48":{"tf":1.0},"60":{"tf":1.0}}}}}},"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":3,"docs":{"44":{"tf":1.0},"48":{"tf":1.0},"60":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"p":{"df":1,"docs":{"60":{"tf":1.0}}}}},"df":0,"docs":{}}}}}}},"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":4,"docs":{"44":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0},"60":{"tf":1.0}}}}}},"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":4,"docs":{"44":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0},"60":{"tf":1.0}}}}},"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":6,"docs":{"44":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.4142135623730951},"51":{"tf":1.0},"60":{"tf":1.7320508075688772},"96":{"tf":1.0}}}}}},"df":12,"docs":{"110":{"tf":1.0},"12":{"tf":1.0},"2":{"tf":1.0},"25":{"tf":1.0},"42":{"tf":1.0},"44":{"tf":2.449489742783178},"48":{"tf":2.449489742783178},"49":{"tf":1.4142135623730951},"5":{"tf":1.0},"51":{"tf":1.7320508075688772},"60":{"tf":2.8284271247461903},"96":{"tf":1.4142135623730951}},"u":{"df":0,"docs":{},"p":{"df":6,"docs":{"44":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.4142135623730951},"51":{"tf":1.0},"60":{"tf":1.7320508075688772},"96":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"r":{"df":7,"docs":{"36":{"tf":1.0},"37":{"tf":1.4142135623730951},"56":{"tf":1.0},"60":{"tf":1.4142135623730951},"69":{"tf":1.0},"76":{"tf":3.1622776601683795},"99":{"tf":1.0}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":4,"docs":{"48":{"tf":1.0},"60":{"tf":1.0},"89":{"tf":2.8284271247461903},"92":{"tf":1.4142135623730951}}}}}},"r":{"a":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"m":{"df":1,"docs":{"49":{"tf":1.0}}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":5,"docs":{"29":{"tf":1.0},"37":{"tf":1.4142135623730951},"48":{"tf":1.4142135623730951},"60":{"tf":1.4142135623730951},"63":{"tf":1.0}}}}},"df":0,"docs":{}}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":6,"docs":{"38":{"tf":1.0},"59":{"tf":1.4142135623730951},"60":{"tf":1.4142135623730951},"68":{"tf":1.0},"73":{"tf":1.0},"93":{"tf":2.23606797749979}},"e":{"df":0,"docs":{},"r":{".":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"112":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"112":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":4,"docs":{"39":{"tf":1.0},"46":{"tf":1.7320508075688772},"60":{"tf":2.23606797749979},"75":{"tf":1.4142135623730951}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":4,"docs":{"116":{"tf":1.0},"36":{"tf":1.0},"76":{"tf":1.0},"93":{"tf":1.0}},"i":{"df":0,"docs":{},"z":{"df":0,"docs":{},"e":{"d":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"116":{"tf":1.7320508075688772}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}}},"s":{"df":5,"docs":{"121":{"tf":1.4142135623730951},"39":{"tf":1.0},"53":{"tf":1.0},"57":{"tf":2.6457513110645907},"87":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"111":{"tf":1.4142135623730951}}}}},"t":{"df":4,"docs":{"112":{"tf":1.0},"116":{"tf":1.0},"17":{"tf":1.0},"70":{"tf":1.0}},"i":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"101":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"56":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":1,"docs":{"4":{"tf":1.0}}}}},"s":{"c":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"61":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"l":{"df":1,"docs":{"61":{"tf":1.0}}},"s":{"df":7,"docs":{"101":{"tf":1.0},"102":{"tf":1.7320508075688772},"41":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.4142135623730951},"77":{"tf":1.0},"99":{"tf":1.0}},"w":{"d":{"df":1,"docs":{"61":{"tf":1.0}}},"df":0,"docs":{}}},"t":{"df":9,"docs":{"32":{"tf":1.0},"33":{"tf":1.0},"35":{"tf":1.7320508075688772},"45":{"tf":1.7320508075688772},"48":{"tf":1.4142135623730951},"59":{"tf":3.1622776601683795},"60":{"tf":2.449489742783178},"70":{"tf":1.4142135623730951},"71":{"tf":1.4142135623730951}},"e":{"_":{"a":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":2,"docs":{"45":{"tf":1.0},"60":{"tf":1.0}}}}},"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"45":{"tf":1.0},"60":{"tf":1.0}}}}}}},"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"b":{"df":0,"docs":{},"o":{"a":{"df":0,"docs":{},"r":{"d":{"_":{"a":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}}}}},"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"_":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"b":{"df":0,"docs":{},"o":{"a":{"df":0,"docs":{},"r":{"d":{"_":{"a":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":1,"docs":{"60":{"tf":1.0}}}}},"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"60":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"b":{"df":0,"docs":{},"o":{"a":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"70":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"t":{"df":1,"docs":{"41":{"tf":1.0}},"h":{"/":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"72":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"o":{"/":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"68":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":21,"docs":{"100":{"tf":2.23606797749979},"102":{"tf":1.4142135623730951},"104":{"tf":1.4142135623730951},"109":{"tf":1.0},"11":{"tf":1.0},"110":{"tf":1.0},"12":{"tf":1.4142135623730951},"2":{"tf":1.0},"21":{"tf":1.4142135623730951},"22":{"tf":1.4142135623730951},"24":{"tf":1.0},"41":{"tf":1.7320508075688772},"53":{"tf":1.0},"56":{"tf":1.0},"59":{"tf":2.6457513110645907},"70":{"tf":1.4142135623730951},"72":{"tf":1.0},"73":{"tf":1.0},"75":{"tf":1.0},"93":{"tf":1.0},"99":{"tf":1.0}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":9,"docs":{"102":{"tf":1.4142135623730951},"116":{"tf":1.4142135623730951},"117":{"tf":1.4142135623730951},"47":{"tf":2.0},"56":{"tf":1.0},"60":{"tf":2.0},"78":{"tf":1.0},"93":{"tf":1.0},"99":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"s":{"df":2,"docs":{"60":{"tf":1.0},"93":{"tf":1.4142135623730951}}}}},"b":{"df":1,"docs":{"61":{"tf":1.0}}},"df":11,"docs":{"12":{"tf":1.0},"37":{"tf":1.0},"39":{"tf":1.7320508075688772},"41":{"tf":1.4142135623730951},"45":{"tf":1.4142135623730951},"46":{"tf":1.0},"48":{"tf":2.6457513110645907},"51":{"tf":1.0},"52":{"tf":1.0},"60":{"tf":3.1622776601683795},"83":{"tf":1.0}},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"61":{"tf":1.0}}},"r":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"72":{"tf":1.4142135623730951}}}},"df":3,"docs":{"54":{"tf":1.0},"56":{"tf":2.0},"57":{"tf":1.4142135623730951}}}}}},"df":2,"docs":{"30":{"tf":1.0},"70":{"tf":1.0}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":3,"docs":{"27":{"tf":1.0},"41":{"tf":1.0},"60":{"tf":1.0}}}}}},"l":{"df":1,"docs":{"61":{"tf":1.0}},"n":{"a":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":1,"docs":{"61":{"tf":1.0}}}}}},"df":0,"docs":{}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"12":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":3,"docs":{"48":{"tf":1.0},"61":{"tf":1.0},"99":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"61":{"tf":1.4142135623730951}}}}},"h":{"df":0,"docs":{},"p":{"df":1,"docs":{"61":{"tf":1.4142135623730951}}}},"i":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":12,"docs":{"28":{"tf":1.0},"40":{"tf":2.449489742783178},"41":{"tf":2.6457513110645907},"42":{"tf":1.0},"48":{"tf":3.4641016151377544},"51":{"tf":2.6457513110645907},"59":{"tf":1.0},"60":{"tf":3.4641016151377544},"68":{"tf":1.0},"69":{"tf":1.0},"75":{"tf":2.23606797749979},"93":{"tf":2.449489742783178}}}}}},"df":0,"docs":{},"e":{"c":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"e":{"df":4,"docs":{"45":{"tf":1.7320508075688772},"57":{"tf":1.4142135623730951},"59":{"tf":2.0},"60":{"tf":1.4142135623730951}}}},"x":{"df":0,"docs":{},"i":{"df":1,"docs":{"61":{"tf":1.0}}}}},"k":{"df":0,"docs":{},"g":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"61":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"68":{"tf":1.0}}}}},"l":{"df":1,"docs":{"61":{"tf":1.4142135623730951}}}},"l":{"a":{"c":{"df":0,"docs":{},"e":{"df":4,"docs":{"112":{"tf":1.0},"114":{"tf":1.0},"75":{"tf":1.0},"86":{"tf":1.0}},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"d":{"df":2,"docs":{"60":{"tf":1.4142135623730951},"93":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"n":{"df":1,"docs":{"36":{"tf":1.0}}},"t":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"\'":{"df":1,"docs":{"70":{"tf":1.0}}},"df":1,"docs":{"70":{"tf":1.0}}}}}}},"y":{"df":1,"docs":{"45":{"tf":1.0}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":3,"docs":{"26":{"tf":1.0},"48":{"tf":1.0},"73":{"tf":1.0}}}},"df":0,"docs":{}},"u":{"df":2,"docs":{"56":{"tf":1.4142135623730951},"93":{"tf":1.0}},"g":{"df":0,"docs":{},"h":{"df":1,"docs":{"116":{"tf":1.0}}},"i":{"df":0,"docs":{},"n":{"df":4,"docs":{"65":{"tf":1.7320508075688772},"66":{"tf":1.0},"67":{"tf":1.0},"81":{"tf":1.0}}}}}}},"o":{"d":{"df":1,"docs":{"61":{"tf":1.0}}},"df":1,"docs":{"61":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":5,"docs":{"104":{"tf":1.0},"22":{"tf":1.4142135623730951},"59":{"tf":1.4142135623730951},"75":{"tf":1.0},"93":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"y":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"61":{"tf":1.0}}}}},"df":0,"docs":{}}}},"p":{"df":1,"docs":{"70":{"tf":1.0}},"u":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"99":{"tf":1.0}}}},"df":0,"docs":{}},"p":{"df":6,"docs":{"42":{"tf":1.4142135623730951},"48":{"tf":1.7320508075688772},"60":{"tf":1.0},"70":{"tf":1.4142135623730951},"73":{"tf":1.7320508075688772},"93":{"tf":2.8284271247461903}}}}},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"15":{"tf":1.0}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":7,"docs":{"115":{"tf":1.7320508075688772},"55":{"tf":1.0},"59":{"tf":1.0},"70":{"tf":1.0},"72":{"tf":2.449489742783178},"83":{"tf":1.0},"99":{"tf":1.0}}}},"s":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"l":{"df":6,"docs":{"38":{"tf":1.0},"50":{"tf":1.0},"9":{"tf":1.0},"94":{"tf":1.0},"95":{"tf":1.0},"98":{"tf":1.0}}}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":2,"docs":{"24":{"tf":1.0},"99":{"tf":1.0}}}}}}},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"94":{"tf":1.0}},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":2,"docs":{"22":{"tf":1.4142135623730951},"61":{"tf":1.0}}}}}}}}}},"p":{"a":{":":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"/":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"df":1,"docs":{"6":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":2,"docs":{"3":{"tf":1.0},"6":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"e":{"d":{"df":4,"docs":{"70":{"tf":1.0},"83":{"tf":1.0},"89":{"tf":1.0},"99":{"tf":1.0}}},"df":0,"docs":{}}},"d":{"df":0,"docs":{},"i":{"c":{"df":3,"docs":{"117":{"tf":2.449489742783178},"122":{"tf":1.0},"60":{"tf":1.0}}},"df":0,"docs":{}}},"df":2,"docs":{"2":{"tf":1.4142135623730951},"21":{"tf":1.0}},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"1":{"tf":1.0}}}},"i":{"df":0,"docs":{},"x":{"df":5,"docs":{"100":{"tf":1.4142135623730951},"102":{"tf":1.0},"41":{"tf":1.4142135623730951},"84":{"tf":1.0},"96":{"tf":1.4142135623730951}}}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"93":{"tf":1.4142135623730951}}}}}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"57":{"tf":1.0}}}}},"s":{"df":8,"docs":{"41":{"tf":1.4142135623730951},"43":{"tf":1.0},"50":{"tf":1.0},"53":{"tf":1.0},"56":{"tf":1.0},"59":{"tf":1.0},"83":{"tf":1.0},"95":{"tf":1.0}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":1,"docs":{"102":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":2,"docs":{"102":{"tf":1.4142135623730951},"103":{"tf":2.0}}}}}}},"v":{"df":1,"docs":{"60":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":5,"docs":{"116":{"tf":1.4142135623730951},"39":{"tf":1.0},"54":{"tf":1.0},"70":{"tf":1.0},"87":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":3,"docs":{"51":{"tf":1.0},"70":{"tf":1.0},"93":{"tf":1.0}}}},"o":{"df":0,"docs":{},"u":{"df":14,"docs":{"103":{"tf":1.4142135623730951},"28":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":1.7320508075688772},"44":{"tf":2.0},"46":{"tf":1.4142135623730951},"47":{"tf":1.4142135623730951},"48":{"tf":3.3166247903554},"49":{"tf":1.7320508075688772},"51":{"tf":1.0},"52":{"tf":2.0},"59":{"tf":1.4142135623730951},"60":{"tf":5.656854249492381},"70":{"tf":1.0}},"s":{"df":2,"docs":{"25":{"tf":1.0},"60":{"tf":1.0}}}}}}}},"i":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":11,"docs":{"35":{"tf":1.4142135623730951},"39":{"tf":1.0},"46":{"tf":1.4142135623730951},"56":{"tf":2.23606797749979},"59":{"tf":3.605551275463989},"60":{"tf":3.1622776601683795},"71":{"tf":1.4142135623730951},"72":{"tf":1.7320508075688772},"74":{"tf":1.0},"84":{"tf":1.0},"93":{"tf":1.7320508075688772}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"59":{"tf":1.4142135623730951}}}}},"y":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"71":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"93":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"t":{"df":3,"docs":{"54":{"tf":2.23606797749979},"56":{"tf":2.449489742783178},"59":{"tf":1.0}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"103":{"tf":1.0}},"i":{"df":2,"docs":{"100":{"tf":1.0},"22":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"m":{"a":{"df":1,"docs":{"61":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"v":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"93":{"tf":2.0}}}},"df":0,"docs":{}}},"o":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"24":{"tf":1.0}}}}}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"68":{"tf":1.0}}}}}},"d":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"64":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":3,"docs":{"21":{"tf":1.0},"22":{"tf":1.0},"25":{"tf":1.0}}}}},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"df":4,"docs":{"1":{"tf":1.0},"57":{"tf":1.4142135623730951},"60":{"tf":1.4142135623730951},"70":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"72":{"tf":1.0},"73":{"tf":1.7320508075688772}}}}}}},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"68":{"tf":1.0},"9":{"tf":1.0},"98":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":1,"docs":{"61":{"tf":1.0}}}}},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":4,"docs":{"42":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":2.23606797749979},"93":{"tf":1.7320508075688772}}}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":4,"docs":{"112":{"tf":1.0},"116":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0}}}},"t":{"df":0,"docs":{},"i":{"df":2,"docs":{"61":{"tf":1.0},"92":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"o":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"f":{"df":1,"docs":{"61":{"tf":1.0}}}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":2,"docs":{"83":{"tf":1.0},"96":{"tf":1.0}}}}},"df":0,"docs":{},"l":{"df":1,"docs":{"61":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"i":{"d":{"df":19,"docs":{"108":{"tf":1.0},"110":{"tf":1.0},"22":{"tf":1.0},"24":{"tf":1.0},"25":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.4142135623730951},"59":{"tf":2.449489742783178},"65":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.0},"69":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.7320508075688772},"81":{"tf":1.0},"90":{"tf":1.0},"91":{"tf":1.0},"93":{"tf":1.4142135623730951},"98":{"tf":1.0}},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":1,"docs":{"102":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"r":{".":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"71":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"q":{"df":0,"docs":{},"l":{"df":1,"docs":{"61":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"g":{"df":1,"docs":{"61":{"tf":1.0}}},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"109":{"tf":1.0}}}},"n":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"93":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"61":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":2,"docs":{"116":{"tf":1.0},"37":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"9":{"tf":1.0}}}},"t":{"df":3,"docs":{"112":{"tf":1.0},"68":{"tf":1.0},"75":{"tf":1.0}}}},"w":{"d":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"22":{"tf":1.0}}}}}}}}},"df":1,"docs":{"59":{"tf":1.0}}},"df":0,"docs":{}},"y":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":1,"docs":{"61":{"tf":1.4142135623730951}}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"116":{"tf":2.0},"61":{"tf":1.0}}}}}}}},"q":{"a":{"df":1,"docs":{"59":{"tf":1.4142135623730951}}},"df":4,"docs":{"45":{"tf":1.4142135623730951},"48":{"tf":1.4142135623730951},"59":{"tf":1.4142135623730951},"60":{"tf":2.8284271247461903}},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"61":{"tf":1.0}},"l":{"df":1,"docs":{"61":{"tf":1.0}}}}},"u":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"61":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":15,"docs":{"106":{"tf":1.0},"110":{"tf":1.7320508075688772},"111":{"tf":1.0},"112":{"tf":2.8284271247461903},"113":{"tf":1.0},"114":{"tf":2.449489742783178},"115":{"tf":2.6457513110645907},"116":{"tf":1.4142135623730951},"117":{"tf":1.0},"118":{"tf":1.0},"119":{"tf":2.0},"37":{"tf":1.4142135623730951},"38":{"tf":1.4142135623730951},"41":{"tf":1.0},"59":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"0":{"tf":1.0}}}}}}}},"i":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"0":{"tf":1.0}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"61":{"tf":1.4142135623730951}}}},"t":{"df":2,"docs":{"53":{"tf":1.0},"59":{"tf":3.4641016151377544}}}},"o":{"df":0,"docs":{},"t":{"df":6,"docs":{"53":{"tf":1.4142135623730951},"54":{"tf":3.0},"56":{"tf":1.7320508075688772},"57":{"tf":2.0},"87":{"tf":1.0},"93":{"tf":1.0}}}},"u":{"df":0,"docs":{},"x":{"df":1,"docs":{"116":{"tf":1.4142135623730951}}}}}},"r":{"\\\\":{"df":0,"docs":{},"n":{"df":1,"docs":{"56":{"tf":1.0}}}},"a":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"61":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":2,"docs":{"116":{"tf":1.0},"59":{"tf":1.0}}}},"p":{"df":0,"docs":{},"i":{"d":{"_":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":1,"docs":{"90":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"w":{"df":1,"docs":{"93":{"tf":1.4142135623730951}}}},"df":10,"docs":{"22":{"tf":1.0},"41":{"tf":1.7320508075688772},"45":{"tf":1.4142135623730951},"48":{"tf":2.0},"49":{"tf":1.0},"52":{"tf":1.4142135623730951},"55":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":2.23606797749979},"61":{"tf":1.7320508075688772}},"e":{"a":{"d":{"df":5,"docs":{"35":{"tf":2.0},"59":{"tf":1.0},"70":{"tf":1.0},"72":{"tf":1.4142135623730951},"75":{"tf":2.23606797749979}},"m":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"m":{"d":{":":{"1":{"df":2,"docs":{"56":{"tf":1.0},"57":{"tf":1.0}}},"df":0,"docs":{}},"df":1,"docs":{"54":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"72":{"tf":1.0}}}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"116":{"tf":1.0}}}}}},"b":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"61":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"94":{"tf":1.0}}},"df":0,"docs":{}}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":3,"docs":{"112":{"tf":1.0},"56":{"tf":1.7320508075688772},"70":{"tf":1.0}}}},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":6,"docs":{"114":{"tf":1.0},"24":{"tf":1.0},"49":{"tf":1.0},"65":{"tf":1.0},"84":{"tf":1.0},"89":{"tf":1.0}}},"df":0,"docs":{}}}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"99":{"tf":1.0}}}}}},"r":{"d":{"_":{"df":0,"docs":{},"m":{"a":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":2,"docs":{"45":{"tf":1.0},"60":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":3,"docs":{"34":{"tf":1.0},"45":{"tf":1.4142135623730951},"60":{"tf":1.0}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":2,"docs":{"56":{"tf":1.0},"75":{"tf":1.0}}}}}},"d":{"df":1,"docs":{"89":{"tf":1.4142135623730951}},"o":{"df":2,"docs":{"45":{"tf":1.4142135623730951},"60":{"tf":1.4142135623730951}}},"r":{"a":{"df":0,"docs":{},"w":{"df":1,"docs":{"59":{"tf":1.0}}}},"df":0,"docs":{}},"u":{"c":{"df":1,"docs":{"82":{"tf":1.0}}},"df":0,"docs":{}}},"df":3,"docs":{"121":{"tf":1.0},"59":{"tf":1.0},"94":{"tf":1.0}},"f":{"df":1,"docs":{"93":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":14,"docs":{"0":{"tf":1.0},"103":{"tf":1.0},"108":{"tf":1.0},"110":{"tf":1.0},"23":{"tf":1.0},"26":{"tf":1.4142135623730951},"37":{"tf":1.0},"38":{"tf":1.0},"48":{"tf":1.7320508075688772},"60":{"tf":1.4142135623730951},"70":{"tf":1.0},"73":{"tf":1.4142135623730951},"89":{"tf":1.0},"93":{"tf":1.0}}}},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"49":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"w":{"df":3,"docs":{"59":{"tf":1.0},"70":{"tf":1.0},"99":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"59":{"tf":1.0}}}}}}},"g":{"a":{"df":0,"docs":{},"r":{"d":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"116":{"tf":1.4142135623730951},"73":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":1,"docs":{"45":{"tf":1.0}},"e":{"df":0,"docs":{},"x":{"df":9,"docs":{"117":{"tf":1.0},"122":{"tf":1.0},"41":{"tf":1.0},"46":{"tf":2.0},"47":{"tf":1.0},"60":{"tf":2.449489742783178},"61":{"tf":1.0},"78":{"tf":1.0},"99":{"tf":1.7320508075688772}},"p":{"df":1,"docs":{"93":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":14,"docs":{"32":{"tf":2.6457513110645907},"33":{"tf":2.8284271247461903},"34":{"tf":2.23606797749979},"35":{"tf":2.8284271247461903},"41":{"tf":1.7320508075688772},"45":{"tf":1.7320508075688772},"47":{"tf":1.4142135623730951},"49":{"tf":1.0},"52":{"tf":1.0},"59":{"tf":2.0},"60":{"tf":1.7320508075688772},"63":{"tf":1.0},"70":{"tf":1.4142135623730951},"72":{"tf":1.7320508075688772}}}}},"o":{"df":1,"docs":{"61":{"tf":1.0}},"l":{"df":1,"docs":{"61":{"tf":1.0}}}},"u":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":2,"docs":{"57":{"tf":1.4142135623730951},"93":{"tf":1.0}}}},"df":0,"docs":{}}}},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"48":{"tf":1.0}}}},"df":0,"docs":{}}},"l":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"62":{"tf":1.0},"75":{"tf":1.0}}}},"df":4,"docs":{"56":{"tf":1.0},"68":{"tf":1.0},"70":{"tf":2.0},"99":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"s":{"df":7,"docs":{"12":{"tf":1.0},"2":{"tf":1.0},"25":{"tf":1.7320508075688772},"36":{"tf":1.0},"5":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}}}},"df":0,"docs":{},"v":{"df":3,"docs":{"103":{"tf":1.0},"48":{"tf":1.0},"64":{"tf":1.0}}}},"i":{"df":1,"docs":{"38":{"tf":1.0}}},"o":{"a":{"d":{"/":{":":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"73":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":3,"docs":{"59":{"tf":2.23606797749979},"68":{"tf":1.7320508075688772},"70":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"m":{"a":{"df":0,"docs":{},"p":{"df":4,"docs":{"48":{"tf":2.0},"51":{"tf":1.0},"52":{"tf":1.0},"94":{"tf":1.7320508075688772}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":2,"docs":{"104":{"tf":1.0},"59":{"tf":1.0}}},"v":{"df":8,"docs":{"111":{"tf":1.4142135623730951},"41":{"tf":1.0},"46":{"tf":1.4142135623730951},"50":{"tf":1.0},"60":{"tf":1.4142135623730951},"70":{"tf":1.4142135623730951},"76":{"tf":1.0},"81":{"tf":1.0}},"e":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"46":{"tf":1.0},"60":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"46":{"tf":1.0},"60":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"n":{"a":{"df":0,"docs":{},"m":{"df":4,"docs":{"103":{"tf":1.0},"48":{"tf":1.0},"60":{"tf":1.0},"93":{"tf":1.0}},"e":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":6,"docs":{"59":{"tf":1.0},"70":{"tf":1.4142135623730951},"79":{"tf":2.23606797749979},"80":{"tf":2.23606797749979},"84":{"tf":2.449489742783178},"99":{"tf":1.0}}}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":2,"docs":{"44":{"tf":1.0},"60":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":4,"docs":{"44":{"tf":1.0},"45":{"tf":1.0},"60":{"tf":1.0},"93":{"tf":1.0}}}},"df":0,"docs":{}},"l":{"a":{"c":{"df":9,"docs":{"30":{"tf":1.0},"36":{"tf":1.4142135623730951},"45":{"tf":2.0},"48":{"tf":1.4142135623730951},"50":{"tf":1.0},"56":{"tf":1.0},"59":{"tf":2.0},"60":{"tf":2.449489742783178},"70":{"tf":1.4142135623730951}},"e":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"_":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"b":{"df":0,"docs":{},"o":{"a":{"df":0,"docs":{},"r":{"d":{"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"_":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"b":{"df":0,"docs":{},"o":{"a":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"60":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"_":{"df":0,"docs":{},"y":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":2,"docs":{"45":{"tf":1.0},"60":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"m":{"a":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":2,"docs":{"45":{"tf":1.0},"60":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":1,"docs":{"60":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":2,"docs":{"25":{"tf":1.0},"73":{"tf":1.0}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":10,"docs":{"104":{"tf":1.7320508075688772},"112":{"tf":1.0},"21":{"tf":1.4142135623730951},"25":{"tf":1.0},"4":{"tf":1.0},"6":{"tf":1.0},"68":{"tf":1.0},"75":{"tf":1.0},"8":{"tf":1.4142135623730951},"98":{"tf":1.0}}}}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":2,"docs":{"81":{"tf":1.0},"87":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"28":{"tf":1.0},"96":{"tf":1.0}}}}}}},"o":{"d":{"df":0,"docs":{},"u":{"c":{"df":2,"docs":{"21":{"tf":1.0},"9":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":4,"docs":{"102":{"tf":1.4142135623730951},"103":{"tf":1.4142135623730951},"109":{"tf":1.0},"66":{"tf":1.4142135623730951}}}}},"i":{"df":0,"docs":{},"r":{"df":12,"docs":{"102":{"tf":1.0},"112":{"tf":1.0},"114":{"tf":1.0},"116":{"tf":1.0},"118":{"tf":1.0},"21":{"tf":1.0},"22":{"tf":1.0},"38":{"tf":1.0},"42":{"tf":1.4142135623730951},"73":{"tf":1.0},"77":{"tf":1.0},"93":{"tf":1.4142135623730951}}}}}},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"61":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"99":{"tf":1.0}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"v":{"df":2,"docs":{"86":{"tf":1.0},"93":{"tf":1.0}}}},"t":{"df":1,"docs":{"59":{"tf":1.4142135623730951}}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"v":{"df":1,"docs":{"22":{"tf":1.0}}}},"u":{"df":0,"docs":{},"r":{"c":{"df":1,"docs":{"61":{"tf":1.0}}},"df":0,"docs":{}}}},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"96":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":3,"docs":{"59":{"tf":1.4142135623730951},"60":{"tf":1.0},"73":{"tf":1.4142135623730951}}}}},"df":2,"docs":{"114":{"tf":1.0},"57":{"tf":2.0}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":9,"docs":{"103":{"tf":1.0},"116":{"tf":1.4142135623730951},"22":{"tf":1.0},"23":{"tf":1.0},"25":{"tf":1.0},"32":{"tf":1.0},"39":{"tf":1.0},"41":{"tf":1.0},"48":{"tf":1.4142135623730951}}}}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"82":{"tf":1.4142135623730951}}}}},"df":4,"docs":{"115":{"tf":1.0},"60":{"tf":1.0},"94":{"tf":1.0},"96":{"tf":1.0}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"/":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"96":{"tf":1.0}}}}}},"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"116":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":7,"docs":{"116":{"tf":2.449489742783178},"35":{"tf":1.0},"43":{"tf":1.0},"45":{"tf":1.0},"56":{"tf":1.0},"60":{"tf":1.0},"93":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"119":{"tf":1.0}}}},"v":{"df":1,"docs":{"104":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":3,"docs":{"55":{"tf":1.4142135623730951},"60":{"tf":1.4142135623730951},"90":{"tf":1.0}},"e":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"60":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"104":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":9,"docs":{"44":{"tf":1.4142135623730951},"46":{"tf":1.0},"48":{"tf":2.0},"49":{"tf":1.4142135623730951},"52":{"tf":1.4142135623730951},"60":{"tf":3.3166247903554},"72":{"tf":2.0},"96":{"tf":1.4142135623730951},"99":{"tf":1.0}}}}}},"l":{"a":{"df":1,"docs":{"59":{"tf":1.0}}},"df":1,"docs":{"59":{"tf":1.0}}},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":1,"docs":{"61":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"o":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"61":{"tf":1.0}},"f":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"_":{"df":0,"docs":{},"l":{"df":1,"docs":{"61":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"n":{"df":1,"docs":{"61":{"tf":1.0}}},"o":{"df":0,"docs":{},"t":{"df":8,"docs":{"102":{"tf":1.0},"104":{"tf":1.0},"115":{"tf":1.0},"48":{"tf":1.0},"60":{"tf":1.0},"70":{"tf":1.7320508075688772},"9":{"tf":1.0},"99":{"tf":2.23606797749979}}}},"t":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"46":{"tf":2.0},"60":{"tf":2.0}},"e":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"s":{"_":{"b":{"a":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":2,"docs":{"46":{"tf":1.0},"60":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":2,"docs":{"46":{"tf":1.0},"60":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"s":{"_":{"b":{"a":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":2,"docs":{"46":{"tf":1.0},"60":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"60":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":2,"docs":{"46":{"tf":1.0},"60":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"l":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"60":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":1,"docs":{"60":{"tf":1.0}}}}}}}}},"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":1,"docs":{"22":{"tf":1.0}}}}},"w":{"df":1,"docs":{"93":{"tf":1.0}}}},"s":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"h":{"df":2,"docs":{"47":{"tf":1.0},"60":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"t":{"df":1,"docs":{"61":{"tf":1.0}}}},"u":{"b":{"df":0,"docs":{},"i":{"df":2,"docs":{"61":{"tf":1.4142135623730951},"93":{"tf":1.0}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":1,"docs":{"61":{"tf":1.0}}}},"l":{"df":0,"docs":{},"e":{"df":5,"docs":{"103":{"tf":1.0},"116":{"tf":1.4142135623730951},"53":{"tf":1.0},"57":{"tf":1.4142135623730951},"75":{"tf":1.0}},"r":{"df":4,"docs":{"57":{"tf":1.0},"70":{"tf":1.7320508075688772},"93":{"tf":1.0},"99":{"tf":1.0}}}}},"n":{"df":17,"docs":{"10":{"tf":1.0},"108":{"tf":1.0},"111":{"tf":1.4142135623730951},"115":{"tf":1.0},"12":{"tf":1.0},"2":{"tf":1.0},"22":{"tf":1.4142135623730951},"23":{"tf":1.0},"45":{"tf":1.4142135623730951},"5":{"tf":1.0},"57":{"tf":1.0},"59":{"tf":2.0},"60":{"tf":1.0},"70":{"tf":1.0},"8":{"tf":1.0},"83":{"tf":1.0},"95":{"tf":1.7320508075688772}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":7,"docs":{"111":{"tf":1.0},"112":{"tf":1.0},"2":{"tf":2.23606797749979},"21":{"tf":2.0},"22":{"tf":4.0},"25":{"tf":1.0},"85":{"tf":1.0}},"e":{".":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"59":{"tf":1.4142135623730951}}}}}},"/":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"/":{"<":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{">":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":1,"docs":{"111":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"114":{"tf":1.0}},"e":{"df":0,"docs":{},"s":{"/":{"<":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"110":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"{":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"}":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"b":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"m":{"df":1,"docs":{"112":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}}}}},"s":{"df":0,"docs":{},"t":{"d":{"df":0,"docs":{},"o":{"c":{"df":1,"docs":{"61":{"tf":1.0}}},"df":0,"docs":{}}},"df":6,"docs":{"105":{"tf":1.0},"21":{"tf":1.0},"61":{"tf":2.0},"76":{"tf":1.0},"93":{"tf":1.7320508075688772},"98":{"tf":1.4142135623730951}},"f":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"21":{"tf":1.0}}}},"df":0,"docs":{}}}}}}},"s":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":1,"docs":{"61":{"tf":1.0}}}},"m":{"df":0,"docs":{},"e":{"df":13,"docs":{"102":{"tf":1.0},"103":{"tf":1.4142135623730951},"108":{"tf":1.0},"114":{"tf":1.0},"116":{"tf":3.7416573867739413},"117":{"tf":1.7320508075688772},"121":{"tf":1.0},"22":{"tf":1.0},"30":{"tf":1.0},"41":{"tf":1.0},"54":{"tf":1.0},"93":{"tf":1.0},"99":{"tf":1.4142135623730951}}}},"n":{"d":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"36":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"v":{"df":0,"docs":{},"e":{".":{"a":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":1,"docs":{"77":{"tf":1.0}}}}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"44":{"tf":1.0},"60":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":8,"docs":{"44":{"tf":1.0},"49":{"tf":1.0},"60":{"tf":1.0},"69":{"tf":1.0},"70":{"tf":1.7320508075688772},"77":{"tf":2.23606797749979},"94":{"tf":1.0},"99":{"tf":1.4142135623730951}}}}},"c":{"a":{"df":0,"docs":{},"l":{"a":{"df":1,"docs":{"61":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"a":{"df":1,"docs":{"104":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":1,"docs":{"61":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":3,"docs":{"16":{"tf":1.0},"18":{"tf":1.4142135623730951},"3":{"tf":1.0}}}},"p":{"df":0,"docs":{},"e":{"df":7,"docs":{"115":{"tf":1.0},"116":{"tf":2.8284271247461903},"118":{"tf":3.4641016151377544},"59":{"tf":1.7320508075688772},"84":{"tf":1.4142135623730951},"93":{"tf":2.449489742783178},"99":{"tf":1.7320508075688772}}}}},"r":{"a":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"df":3,"docs":{"56":{"tf":1.4142135623730951},"59":{"tf":1.7320508075688772},"60":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":3,"docs":{"48":{"tf":2.449489742783178},"70":{"tf":1.0},"83":{"tf":1.4142135623730951}}}}},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":2,"docs":{"22":{"tf":1.0},"56":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"_":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":3,"docs":{"48":{"tf":1.0},"60":{"tf":1.0},"95":{"tf":1.0}}}}}},"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":3,"docs":{"48":{"tf":1.0},"60":{"tf":1.0},"95":{"tf":1.0}}}}},"b":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"93":{"tf":1.0}}}},"df":0,"docs":{}},"df":3,"docs":{"48":{"tf":2.23606797749979},"60":{"tf":1.4142135623730951},"70":{"tf":2.0}},"o":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":1,"docs":{"70":{"tf":1.0}}}}}}}}},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"61":{"tf":1.0}}}}},"df":15,"docs":{"116":{"tf":1.0},"117":{"tf":1.0},"20":{"tf":1.0},"36":{"tf":1.0},"44":{"tf":1.0},"46":{"tf":1.7320508075688772},"48":{"tf":2.449489742783178},"49":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.0},"60":{"tf":4.58257569495584},"8":{"tf":1.0},"83":{"tf":2.0},"94":{"tf":2.0},"96":{"tf":2.23606797749979}},"e":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"25":{"tf":1.0}}},"r":{"c":{"df":0,"docs":{},"h":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"59":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}},"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":2,"docs":{"47":{"tf":1.0},"60":{"tf":1.0}}}}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":2,"docs":{"47":{"tf":1.0},"60":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"47":{"tf":1.0},"60":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"_":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"47":{"tf":1.0},"60":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"df":16,"docs":{"100":{"tf":1.0},"2":{"tf":1.4142135623730951},"22":{"tf":1.4142135623730951},"32":{"tf":1.0},"34":{"tf":1.0},"36":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":2.6457513110645907},"42":{"tf":1.0},"47":{"tf":3.0},"48":{"tf":1.4142135623730951},"50":{"tf":2.0},"59":{"tf":1.4142135623730951},"60":{"tf":3.3166247903554},"75":{"tf":1.7320508075688772},"78":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":8,"docs":{"102":{"tf":1.0},"116":{"tf":1.0},"117":{"tf":1.7320508075688772},"122":{"tf":1.4142135623730951},"29":{"tf":1.0},"35":{"tf":1.0},"57":{"tf":1.0},"63":{"tf":1.0}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":31,"docs":{"0":{"tf":1.7320508075688772},"100":{"tf":1.0},"103":{"tf":1.0},"104":{"tf":1.0},"105":{"tf":1.0},"106":{"tf":1.0},"108":{"tf":1.0},"31":{"tf":1.0},"38":{"tf":1.0},"41":{"tf":1.0},"48":{"tf":1.0},"62":{"tf":1.0},"69":{"tf":4.358898943540674},"70":{"tf":1.0},"71":{"tf":1.0},"72":{"tf":1.0},"73":{"tf":1.0},"74":{"tf":1.0},"75":{"tf":1.0},"76":{"tf":1.0},"77":{"tf":1.0},"78":{"tf":1.0},"79":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":2.8284271247461903},"82":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":1.0},"89":{"tf":1.0},"94":{"tf":1.0},"99":{"tf":1.7320508075688772}}}}}}},"d":{"df":1,"docs":{"24":{"tf":1.7320508075688772}}},"df":0,"docs":{},"e":{"df":18,"docs":{"0":{"tf":1.4142135623730951},"1":{"tf":1.0},"114":{"tf":1.4142135623730951},"118":{"tf":1.0},"2":{"tf":1.0},"31":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":1.0},"42":{"tf":1.0},"51":{"tf":1.0},"53":{"tf":1.0},"61":{"tf":1.0},"63":{"tf":1.0},"73":{"tf":1.0},"79":{"tf":1.0},"93":{"tf":1.7320508075688772},"94":{"tf":1.0},"99":{"tf":1.7320508075688772}}},"g":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"111":{"tf":1.0}}}}}},"df":0,"docs":{}}},"l":{"df":2,"docs":{"70":{"tf":1.0},"72":{"tf":1.0}},"e":{"c":{"df":0,"docs":{},"t":{"/":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"_":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"46":{"tf":1.0},"60":{"tf":1.0}},"l":{"_":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":2,"docs":{"46":{"tf":1.0},"60":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"s":{"df":2,"docs":{"46":{"tf":1.0},"60":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"_":{"a":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":1,"docs":{"60":{"tf":1.0}}}}},"df":0,"docs":{}},"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"60":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"m":{"df":0,"docs":{},"o":{"d":{"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"s":{"df":2,"docs":{"46":{"tf":1.0},"60":{"tf":1.0}}}},"df":0,"docs":{}}}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"_":{"df":0,"docs":{},"s":{"df":2,"docs":{"46":{"tf":1.0},"60":{"tf":1.0}}}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":2,"docs":{"46":{"tf":1.0},"60":{"tf":1.0}}}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"45":{"tf":1.0},"60":{"tf":1.0}}}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"b":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"_":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}},"df":33,"docs":{"22":{"tf":1.0},"27":{"tf":1.0},"29":{"tf":2.0},"30":{"tf":2.0},"31":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":2.449489742783178},"35":{"tf":2.6457513110645907},"36":{"tf":2.23606797749979},"37":{"tf":2.23606797749979},"39":{"tf":3.4641016151377544},"40":{"tf":1.0},"41":{"tf":1.4142135623730951},"42":{"tf":1.4142135623730951},"44":{"tf":1.0},"45":{"tf":5.0990195135927845},"46":{"tf":6.324555320336759},"47":{"tf":2.0},"48":{"tf":4.58257569495584},"50":{"tf":3.0},"51":{"tf":1.4142135623730951},"52":{"tf":2.449489742783178},"56":{"tf":2.0},"59":{"tf":4.242640687119285},"60":{"tf":17.944358444926362},"63":{"tf":1.7320508075688772},"68":{"tf":1.0},"70":{"tf":1.0},"72":{"tf":3.1622776601683795},"74":{"tf":1.4142135623730951},"85":{"tf":1.0},"93":{"tf":2.23606797749979},"94":{"tf":1.4142135623730951}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"56":{"tf":1.0}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"56":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"f":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"116":{"tf":2.449489742783178}}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"116":{"tf":2.449489742783178}}}}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"116":{"tf":2.449489742783178}}}}}}},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"116":{"tf":2.449489742783178}}}}}},"df":0,"docs":{}}}},"df":2,"docs":{"116":{"tf":1.7320508075688772},"93":{"tf":1.0}}}},"m":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"102":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"n":{"d":{"df":1,"docs":{"68":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":1,"docs":{"113":{"tf":1.0}},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"116":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}}}}},"p":{"a":{"df":0,"docs":{},"r":{"df":7,"docs":{"100":{"tf":1.4142135623730951},"102":{"tf":1.0},"54":{"tf":1.0},"59":{"tf":1.7320508075688772},"60":{"tf":1.0},"72":{"tf":2.0},"93":{"tf":1.7320508075688772}}}},"df":0,"docs":{}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":2,"docs":{"36":{"tf":1.0},"94":{"tf":1.7320508075688772}}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"v":{"df":1,"docs":{"61":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"#":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"a":{"c":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"d":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"102":{"tf":1.0}}}}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},".":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"m":{"df":1,"docs":{"102":{"tf":1.4142135623730951}}}}},"m":{"df":0,"docs":{},"y":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":2,"docs":{"102":{"tf":1.0},"98":{"tf":1.0}}}}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"102":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}}},"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"102":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}}},"df":15,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"102":{"tf":3.3166247903554},"103":{"tf":4.795831523312719},"106":{"tf":1.0},"108":{"tf":2.23606797749979},"41":{"tf":1.0},"42":{"tf":1.0},"59":{"tf":2.23606797749979},"61":{"tf":7.211102550927978},"73":{"tf":1.7320508075688772},"93":{"tf":1.4142135623730951},"97":{"tf":1.0},"98":{"tf":1.0},"99":{"tf":2.449489742783178}}}}}},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":3,"docs":{"35":{"tf":1.0},"59":{"tf":1.4142135623730951},"60":{"tf":1.4142135623730951}}}}}}},"t":{"df":33,"docs":{"0":{"tf":1.0},"111":{"tf":1.0},"114":{"tf":1.0},"117":{"tf":1.0},"118":{"tf":1.7320508075688772},"119":{"tf":1.4142135623730951},"121":{"tf":1.0},"2":{"tf":1.4142135623730951},"21":{"tf":1.4142135623730951},"22":{"tf":2.23606797749979},"23":{"tf":1.0},"45":{"tf":1.4142135623730951},"57":{"tf":1.4142135623730951},"59":{"tf":3.0},"68":{"tf":1.0},"70":{"tf":3.1622776601683795},"71":{"tf":1.0},"73":{"tf":1.4142135623730951},"75":{"tf":1.4142135623730951},"76":{"tf":2.0},"79":{"tf":1.0},"81":{"tf":1.7320508075688772},"82":{"tf":1.0},"83":{"tf":1.7320508075688772},"84":{"tf":1.7320508075688772},"9":{"tf":1.0},"90":{"tf":1.0},"92":{"tf":1.0},"93":{"tf":2.23606797749979},"94":{"tf":1.0},"97":{"tf":1.4142135623730951},"98":{"tf":1.0},"99":{"tf":2.8284271247461903}},"x":{"df":1,"docs":{"22":{"tf":1.4142135623730951}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":5,"docs":{"118":{"tf":1.0},"70":{"tf":1.0},"72":{"tf":1.4142135623730951},"84":{"tf":2.0},"99":{"tf":1.4142135623730951}}}}}},"h":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":3,"docs":{"68":{"tf":1.0},"69":{"tf":1.0},"74":{"tf":2.449489742783178}}}},"r":{"df":0,"docs":{},"p":{"df":1,"docs":{"61":{"tf":1.0}}}}},"df":5,"docs":{"56":{"tf":1.7320508075688772},"57":{"tf":1.0},"59":{"tf":1.0},"70":{"tf":1.0},"99":{"tf":1.0}},"e":{"b":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":2,"docs":{"120":{"tf":1.4142135623730951},"99":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"_":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"45":{"tf":1.0},"60":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"45":{"tf":1.0},"60":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}}}}},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":2,"docs":{"45":{"tf":1.0},"60":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"p":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":2,"docs":{"45":{"tf":1.0},"60":{"tf":1.0}},"e":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":2,"docs":{"45":{"tf":1.0},"60":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"df":12,"docs":{"100":{"tf":1.0},"42":{"tf":1.0},"45":{"tf":2.449489742783178},"54":{"tf":1.0},"56":{"tf":2.6457513110645907},"57":{"tf":2.0},"59":{"tf":2.449489742783178},"60":{"tf":2.449489742783178},"66":{"tf":1.4142135623730951},"70":{"tf":1.4142135623730951},"9":{"tf":1.0},"95":{"tf":1.7320508075688772}}}}},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":8,"docs":{"46":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.0},"83":{"tf":1.0},"94":{"tf":1.4142135623730951},"96":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"21":{"tf":1.0},"24":{"tf":1.0}}}}},"df":1,"docs":{"55":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"41":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"116":{"tf":1.0}}}}},"df":0,"docs":{}}},"w":{"df":12,"docs":{"24":{"tf":1.0},"41":{"tf":1.0},"48":{"tf":1.4142135623730951},"55":{"tf":1.0},"59":{"tf":2.449489742783178},"60":{"tf":1.4142135623730951},"70":{"tf":2.0},"72":{"tf":1.4142135623730951},"73":{"tf":1.0},"84":{"tf":1.7320508075688772},"94":{"tf":1.0},"95":{"tf":1.0}},"n":{"df":5,"docs":{"70":{"tf":1.4142135623730951},"72":{"tf":1.7320508075688772},"73":{"tf":1.0},"75":{"tf":1.0},"84":{"tf":2.0}}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"46":{"tf":1.0},"60":{"tf":1.0}}}},"df":0,"docs":{}}}}},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"_":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"46":{"tf":1.0},"60":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":2,"docs":{"46":{"tf":1.4142135623730951},"60":{"tf":2.0}}}}}},"{":{"d":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"56":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":1,"docs":{"56":{"tf":2.0}}}}},"df":0,"docs":{}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":1,"docs":{"54":{"tf":1.4142135623730951}}}}},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"56":{"tf":1.0}}}}}}},"i":{"b":{"df":0,"docs":{},"l":{"df":4,"docs":{"22":{"tf":1.0},"39":{"tf":1.7320508075688772},"46":{"tf":1.7320508075688772},"60":{"tf":1.7320508075688772}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"116":{"tf":1.0},"68":{"tf":1.0}}},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":5,"docs":{"103":{"tf":1.0},"42":{"tf":1.0},"48":{"tf":2.0},"60":{"tf":1.0},"73":{"tf":2.0}},"e":{"_":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"p":{"df":1,"docs":{"60":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":9,"docs":{"106":{"tf":1.0},"117":{"tf":1.0},"32":{"tf":1.4142135623730951},"36":{"tf":1.0},"48":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":1.0},"84":{"tf":1.0},"93":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"39":{"tf":1.0},"57":{"tf":1.0}}}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"l":{"df":6,"docs":{"119":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":2.0},"70":{"tf":1.4142135623730951},"76":{"tf":1.0},"94":{"tf":1.0}},"i":{"c":{"df":1,"docs":{"81":{"tf":1.0}}},"df":4,"docs":{"29":{"tf":1.0},"48":{"tf":1.0},"63":{"tf":1.0},"70":{"tf":1.0}}}}}},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"56":{"tf":1.0}},"l":{"df":10,"docs":{"25":{"tf":1.0},"29":{"tf":1.0},"46":{"tf":1.0},"54":{"tf":1.4142135623730951},"56":{"tf":1.0},"60":{"tf":1.0},"63":{"tf":1.0},"76":{"tf":1.0},"93":{"tf":1.0},"99":{"tf":1.4142135623730951}}}}},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"99":{"tf":1.0}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":20,"docs":{"104":{"tf":2.23606797749979},"106":{"tf":1.0},"109":{"tf":1.0},"110":{"tf":1.0},"111":{"tf":1.0},"112":{"tf":1.7320508075688772},"113":{"tf":1.0},"114":{"tf":2.0},"117":{"tf":1.4142135623730951},"119":{"tf":1.0},"21":{"tf":2.0},"37":{"tf":1.7320508075688772},"38":{"tf":2.0},"39":{"tf":1.4142135623730951},"42":{"tf":1.0},"57":{"tf":2.0},"59":{"tf":2.449489742783178},"70":{"tf":1.4142135623730951},"93":{"tf":1.0},"99":{"tf":1.0}}}}},"u":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"54":{"tf":1.0}}}},"df":0,"docs":{}}},"x":{"df":1,"docs":{"56":{"tf":1.0}}},"z":{"df":0,"docs":{},"e":{"df":1,"docs":{"82":{"tf":1.0}}}}},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":2,"docs":{"25":{"tf":1.0},"80":{"tf":1.7320508075688772}}}}},"l":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"d":{"df":1,"docs":{"61":{"tf":1.0}}},"df":1,"docs":{"61":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"61":{"tf":1.4142135623730951}}}}},"o":{"df":0,"docs":{},"w":{"_":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":1,"docs":{"90":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"m":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"61":{"tf":1.0}}},"l":{"df":1,"docs":{"116":{"tf":1.0}},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"116":{"tf":1.0},"59":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"t":{"a":{"b":{"df":1,"docs":{"60":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":3,"docs":{"59":{"tf":1.4142135623730951},"78":{"tf":1.4142135623730951},"83":{"tf":2.0}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":1,"docs":{"61":{"tf":1.0}}}}}},"l":{"df":1,"docs":{"61":{"tf":1.0}}},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"49":{"tf":1.0}}}}}}}}}},"n":{"a":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"k":{"df":1,"docs":{"61":{"tf":1.0}}}},"df":0,"docs":{}}}},"p":{"/":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"/":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"df":1,"docs":{"11":{"tf":1.0}}}}}},"x":{"df":1,"docs":{"11":{"tf":1.0}}}}},"df":1,"docs":{"11":{"tf":1.0}}}}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":1,"docs":{"11":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":2,"docs":{"11":{"tf":1.4142135623730951},"3":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":3,"docs":{"60":{"tf":1.4142135623730951},"73":{"tf":1.4142135623730951},"93":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":4,"docs":{"70":{"tf":1.4142135623730951},"82":{"tf":2.23606797749979},"93":{"tf":1.0},"99":{"tf":1.7320508075688772}},"w":{"a":{"df":0,"docs":{},"r":{"df":2,"docs":{"64":{"tf":1.4142135623730951},"67":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}},"l":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":1,"docs":{"61":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"c":{"df":1,"docs":{"61":{"tf":1.0}}},"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"61":{"tf":1.0}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"94":{"tf":1.0}}}}},"m":{"df":0,"docs":{},"e":{"/":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"59":{"tf":2.449489742783178}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"_":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":1,"docs":{"115":{"tf":1.4142135623730951}}}}}},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"117":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"93":{"tf":1.0}}},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"116":{"tf":1.0}}}}}}},"o":{"df":0,"docs":{},"n":{"df":3,"docs":{"115":{"tf":1.4142135623730951},"116":{"tf":2.449489742783178},"84":{"tf":1.0}}}},"r":{"df":0,"docs":{},"t":{"df":2,"docs":{"55":{"tf":1.7320508075688772},"59":{"tf":1.4142135623730951}}}},"u":{"df":0,"docs":{},"r":{"c":{"df":11,"docs":{"1":{"tf":1.0},"104":{"tf":2.0},"112":{"tf":1.0},"21":{"tf":1.4142135623730951},"22":{"tf":1.4142135623730951},"25":{"tf":1.0},"5":{"tf":1.0},"59":{"tf":1.4142135623730951},"94":{"tf":1.4142135623730951},"98":{"tf":1.0},"99":{"tf":1.4142135623730951}},"e":{".":{"<":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"99":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"109":{"tf":1.0}}}}},"j":{"df":1,"docs":{"99":{"tf":1.0}}},"m":{"df":0,"docs":{},"y":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"99":{"tf":1.0}}}}},"df":0,"docs":{}}}},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"109":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"61":{"tf":1.0}}}}},"p":{"a":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":1,"docs":{"61":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"p":{"a":{"c":{"df":0,"docs":{},"e":{".":{"b":{"df":1,"docs":{"56":{"tf":1.0}}},"df":0,"docs":{}},">":{"<":{"a":{"df":1,"docs":{"60":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"a":{"df":1,"docs":{"60":{"tf":1.4142135623730951}}},"b":{"df":1,"docs":{"60":{"tf":1.4142135623730951}}},"c":{"df":1,"docs":{"60":{"tf":2.0}}},"d":{"df":1,"docs":{"60":{"tf":2.0}}},"df":1,"docs":{"60":{"tf":2.8284271247461903}},"f":{"df":1,"docs":{"60":{"tf":2.0}}},"g":{"<":{"c":{"df":1,"docs":{"60":{"tf":2.0}}},"df":0,"docs":{}},"b":{"df":1,"docs":{"60":{"tf":1.4142135623730951}}},"c":{"df":1,"docs":{"60":{"tf":1.4142135623730951}}},"df":1,"docs":{"60":{"tf":2.449489742783178}},"h":{"df":1,"docs":{"60":{"tf":1.4142135623730951}}},"i":{"df":1,"docs":{"60":{"tf":1.4142135623730951}}},"l":{"df":1,"docs":{"60":{"tf":1.4142135623730951}}},"n":{"df":1,"docs":{"60":{"tf":1.4142135623730951}}},"o":{"df":1,"docs":{"60":{"tf":1.4142135623730951}}},"r":{"df":1,"docs":{"60":{"tf":1.4142135623730951}}},"s":{"df":0,"docs":{},"f":{"df":1,"docs":{"60":{"tf":1.4142135623730951}}},"t":{"df":1,"docs":{"60":{"tf":1.4142135623730951}}}},"t":{"df":1,"docs":{"60":{"tf":1.4142135623730951}}},"v":{"df":1,"docs":{"60":{"tf":1.4142135623730951}}}},"h":{"df":1,"docs":{"60":{"tf":1.4142135623730951}}},"i":{"df":1,"docs":{"60":{"tf":2.0}}},"j":{"df":1,"docs":{"60":{"tf":1.4142135623730951}}},"k":{"df":1,"docs":{"60":{"tf":1.4142135623730951}}},"p":{"df":1,"docs":{"60":{"tf":2.0}}},"r":{"df":1,"docs":{"60":{"tf":2.0}}},"w":{"<":{"c":{"df":1,"docs":{"60":{"tf":4.47213595499958}}},"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":1,"docs":{"60":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":1,"docs":{"60":{"tf":1.4142135623730951}}}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":1,"docs":{"60":{"tf":1.4142135623730951}}}}}}},"u":{"df":0,"docs":{},"p":{"df":1,"docs":{"60":{"tf":1.4142135623730951}}}}},"df":1,"docs":{"60":{"tf":1.4142135623730951}},"f":{"df":1,"docs":{"60":{"tf":2.0}}},"h":{"df":1,"docs":{"60":{"tf":2.0}}},"j":{"df":1,"docs":{"60":{"tf":2.0}}},"k":{"df":1,"docs":{"60":{"tf":2.0}}},"l":{"df":1,"docs":{"60":{"tf":2.0}}},"n":{"<":{"c":{"df":1,"docs":{"60":{"tf":2.0}}},"df":0,"docs":{}},"df":1,"docs":{"60":{"tf":1.4142135623730951}},"v":{"df":1,"docs":{"60":{"tf":1.4142135623730951}}}},"o":{"df":1,"docs":{"60":{"tf":1.4142135623730951}}},"q":{"df":1,"docs":{"60":{"tf":1.4142135623730951}}},"t":{"df":1,"docs":{"60":{"tf":1.4142135623730951}}},"v":{"df":1,"docs":{"60":{"tf":1.4142135623730951}}},"w":{"df":1,"docs":{"60":{"tf":1.4142135623730951}}}}},"df":15,"docs":{"40":{"tf":1.0},"41":{"tf":1.0},"42":{"tf":1.0},"46":{"tf":1.0},"48":{"tf":2.6457513110645907},"54":{"tf":2.0},"56":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":3.4641016151377544},"72":{"tf":1.0},"79":{"tf":2.0},"82":{"tf":1.0},"93":{"tf":1.0},"96":{"tf":1.4142135623730951},"99":{"tf":1.4142135623730951}},"r":{"df":3,"docs":{"70":{"tf":1.7320508075688772},"72":{"tf":1.4142135623730951},"81":{"tf":2.0}}}}},"d":{"df":0,"docs":{},"e":{"df":1,"docs":{"61":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"n":{"df":3,"docs":{"116":{"tf":1.4142135623730951},"117":{"tf":1.0},"59":{"tf":1.7320508075688772}}}},"df":1,"docs":{"59":{"tf":1.0}},"e":{"c":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"l":{"df":5,"docs":{"32":{"tf":1.0},"35":{"tf":1.4142135623730951},"37":{"tf":1.0},"93":{"tf":2.23606797749979},"96":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"f":{"df":12,"docs":{"100":{"tf":1.4142135623730951},"112":{"tf":1.4142135623730951},"119":{"tf":1.4142135623730951},"22":{"tf":1.0},"25":{"tf":1.0},"41":{"tf":1.0},"70":{"tf":1.4142135623730951},"75":{"tf":1.0},"76":{"tf":1.0},"78":{"tf":1.0},"81":{"tf":1.0},"97":{"tf":1.0}},"i":{"df":10,"docs":{"103":{"tf":1.0},"104":{"tf":1.0},"34":{"tf":1.0},"37":{"tf":1.0},"55":{"tf":1.0},"59":{"tf":1.4142135623730951},"68":{"tf":1.0},"72":{"tf":1.0},"75":{"tf":1.0},"87":{"tf":1.7320508075688772}}}}}},"df":0,"docs":{}},"i":{"c":{"df":0,"docs":{},"e":{"d":{"b":{"df":1,"docs":{"61":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"n":{"df":1,"docs":{"9":{"tf":1.0}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"72":{"tf":2.0},"73":{"tf":1.0}}}}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"46":{"tf":1.0},"60":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"46":{"tf":1.0},"60":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"df":7,"docs":{"36":{"tf":1.0},"46":{"tf":1.4142135623730951},"48":{"tf":2.8284271247461903},"54":{"tf":1.0},"59":{"tf":2.0},"60":{"tf":3.872983346207417},"93":{"tf":1.0}}}}}},"q":{"df":0,"docs":{},"l":{"df":1,"docs":{"61":{"tf":1.0}}},"u":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"36":{"tf":1.0}}}},"df":0,"docs":{}}},"r":{"c":{"df":1,"docs":{"21":{"tf":1.0}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"h":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":1,"docs":{"61":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}},"t":{"a":{"c":{"df":0,"docs":{},"k":{"df":2,"docs":{"116":{"tf":1.4142135623730951},"60":{"tf":1.0}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":1,"docs":{"64":{"tf":1.0}}}},"n":{"d":{"a":{"df":0,"docs":{},"r":{"d":{"df":7,"docs":{"100":{"tf":1.0},"119":{"tf":1.0},"120":{"tf":1.4142135623730951},"121":{"tf":1.7320508075688772},"122":{"tf":1.7320508075688772},"21":{"tf":1.0},"30":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":1,"docs":{"61":{"tf":1.0}}}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"61":{"tf":1.0}}}},"t":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":1,"docs":{"45":{"tf":1.0}}}}}}},"df":19,"docs":{"100":{"tf":1.0},"102":{"tf":1.4142135623730951},"114":{"tf":1.0},"115":{"tf":2.8284271247461903},"116":{"tf":3.3166247903554},"117":{"tf":1.0},"41":{"tf":1.0},"44":{"tf":2.23606797749979},"45":{"tf":1.0},"46":{"tf":1.0},"48":{"tf":1.7320508075688772},"49":{"tf":1.4142135623730951},"52":{"tf":1.4142135623730951},"56":{"tf":2.6457513110645907},"59":{"tf":1.7320508075688772},"60":{"tf":4.242640687119285},"70":{"tf":1.0},"94":{"tf":1.0},"99":{"tf":1.4142135623730951}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"116":{"tf":1.0}}}}}}},"i":{"c":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"94":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":5,"docs":{"21":{"tf":1.0},"58":{"tf":1.0},"60":{"tf":2.0},"93":{"tf":1.0},"94":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"u":{"df":3,"docs":{"3":{"tf":1.0},"59":{"tf":1.0},"72":{"tf":1.0}},"s":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":5,"docs":{"56":{"tf":2.23606797749979},"59":{"tf":1.0},"72":{"tf":2.6457513110645907},"73":{"tf":1.7320508075688772},"93":{"tf":2.449489742783178}}}}}}}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"71":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":3,"docs":{"101":{"tf":1.4142135623730951},"102":{"tf":1.0},"99":{"tf":1.4142135623730951}}},"o":{"df":1,"docs":{"102":{"tf":1.0}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"99":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":6,"docs":{"107":{"tf":1.0},"22":{"tf":1.0},"25":{"tf":1.0},"59":{"tf":1.4142135623730951},"60":{"tf":1.7320508075688772},"70":{"tf":1.0}}}},"i":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"df":1,"docs":{"48":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":3,"docs":{"64":{"tf":1.0},"70":{"tf":1.0},"73":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"p":{"df":2,"docs":{"116":{"tf":1.0},"59":{"tf":1.4142135623730951}}},"r":{"a":{"df":0,"docs":{},"g":{"df":2,"docs":{"32":{"tf":1.0},"93":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"e":{"df":4,"docs":{"17":{"tf":1.0},"22":{"tf":1.0},"33":{"tf":2.0},"93":{"tf":1.0}}}}},"r":{"a":{"c":{"df":0,"docs":{},"e":{"df":1,"docs":{"61":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"57":{"tf":1.0}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":1,"docs":{"63":{"tf":1.0}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":1,"docs":{"93":{"tf":1.0}}}}}}}}}}},"n":{"df":0,"docs":{},"g":{".":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"d":{".":{"df":0,"docs":{},"{":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":1,"docs":{"93":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"r":{"a":{"df":0,"docs":{},"w":{"/":{".":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"93":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"119":{"tf":1.0}}}}}}}}},"f":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"119":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":9,"docs":{"100":{"tf":1.4142135623730951},"117":{"tf":2.449489742783178},"119":{"tf":1.0},"122":{"tf":1.7320508075688772},"56":{"tf":1.7320508075688772},"57":{"tf":2.0},"72":{"tf":1.0},"93":{"tf":1.4142135623730951},"99":{"tf":1.0}}}},"v":{"df":0,"docs":{},"e":{"df":1,"docs":{"99":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":2,"docs":{"115":{"tf":1.4142135623730951},"116":{"tf":2.449489742783178}},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"49":{"tf":1.0},"63":{"tf":1.0}}}}}}},"u":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"93":{"tf":1.0}},"u":{"df":0,"docs":{},"r":{"df":2,"docs":{"37":{"tf":1.4142135623730951},"94":{"tf":1.0}}}}}},"df":0,"docs":{}}},"u":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"39":{"tf":1.0}}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":2,"docs":{"61":{"tf":1.0},"65":{"tf":2.0}}}}},"df":0,"docs":{}},"y":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"/":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"87":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":8,"docs":{"100":{"tf":1.0},"48":{"tf":1.0},"59":{"tf":1.4142135623730951},"64":{"tf":1.0},"72":{"tf":1.4142135623730951},"87":{"tf":1.7320508075688772},"91":{"tf":1.0},"93":{"tf":3.3166247903554}}}}}},"u":{"b":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":4,"docs":{"100":{"tf":1.0},"104":{"tf":1.0},"22":{"tf":1.4142135623730951},"59":{"tf":1.7320508075688772}}}}}}},"df":0,"docs":{}}}}},"df":7,"docs":{"102":{"tf":1.0},"46":{"tf":1.0},"48":{"tf":1.0},"60":{"tf":2.8284271247461903},"72":{"tf":1.0},"79":{"tf":1.4142135623730951},"99":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"93":{"tf":1.0}}}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"109":{"tf":1.0},"87":{"tf":1.0}}}}},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"104":{"tf":1.0}}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"81":{"tf":1.0}}}},"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":1,"docs":{"116":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":2,"docs":{"39":{"tf":1.0},"59":{"tf":1.7320508075688772}}}}}},"c":{"df":0,"docs":{},"h":{"df":10,"docs":{"112":{"tf":1.0},"116":{"tf":1.4142135623730951},"32":{"tf":1.0},"37":{"tf":1.0},"64":{"tf":1.0},"68":{"tf":1.0},"83":{"tf":1.4142135623730951},"84":{"tf":1.4142135623730951},"94":{"tf":1.0},"96":{"tf":1.0}}}},"d":{"df":0,"docs":{},"o":{"df":4,"docs":{"15":{"tf":1.0},"6":{"tf":1.7320508075688772},"7":{"tf":1.0},"8":{"tf":1.0}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"df":1,"docs":{"100":{"tf":1.0}}}}}},"g":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"93":{"tf":1.0}}}}}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"61":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":2,"docs":{"93":{"tf":1.0},"96":{"tf":1.7320508075688772}},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"61":{"tf":1.4142135623730951}}}}}},"s":{"df":0,"docs":{},"e":{"d":{"df":1,"docs":{"83":{"tf":1.0}}},"df":0,"docs":{},"t":{"df":1,"docs":{"48":{"tf":1.0}}}}}}},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"57":{"tf":1.0},"59":{"tf":1.4142135623730951}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":25,"docs":{"0":{"tf":1.0},"101":{"tf":1.0},"103":{"tf":1.7320508075688772},"108":{"tf":1.0},"112":{"tf":1.0},"117":{"tf":1.4142135623730951},"24":{"tf":1.0},"36":{"tf":1.0},"41":{"tf":1.0},"48":{"tf":2.0},"51":{"tf":1.0},"52":{"tf":1.0},"53":{"tf":1.4142135623730951},"56":{"tf":1.4142135623730951},"57":{"tf":1.0},"61":{"tf":1.7320508075688772},"70":{"tf":1.7320508075688772},"75":{"tf":1.0},"77":{"tf":1.0},"81":{"tf":1.0},"83":{"tf":1.4142135623730951},"90":{"tf":1.0},"91":{"tf":1.0},"94":{"tf":1.0},"96":{"tf":1.4142135623730951}}}}}}},"r":{"df":0,"docs":{},"e":{"df":9,"docs":{"108":{"tf":1.0},"109":{"tf":1.0},"11":{"tf":1.0},"111":{"tf":1.0},"115":{"tf":1.4142135623730951},"116":{"tf":2.449489742783178},"12":{"tf":1.0},"17":{"tf":1.0},"23":{"tf":1.0}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"_":{"a":{"d":{"d":{"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}}}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"a":{"c":{"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":8,"docs":{"36":{"tf":2.6457513110645907},"37":{"tf":1.4142135623730951},"48":{"tf":2.0},"54":{"tf":1.4142135623730951},"56":{"tf":1.0},"60":{"tf":1.7320508075688772},"63":{"tf":1.0},"94":{"tf":1.0}}},"df":0,"docs":{}}}}}},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"60":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"61":{"tf":1.0}},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{"df":1,"docs":{"61":{"tf":1.0}}}}}}}}}},"l":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{"df":1,"docs":{"61":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}},"w":{"a":{"df":0,"docs":{},"p":{"_":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"_":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"p":{"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"df":2,"docs":{"48":{"tf":2.0},"60":{"tf":2.0}}},"t":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"73":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"y":{"df":1,"docs":{"61":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":1,"docs":{"61":{"tf":1.0}}}},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"61":{"tf":1.0}}}},"t":{"c":{"df":0,"docs":{},"h":{"_":{"c":{"a":{"df":0,"docs":{},"s":{"df":2,"docs":{"45":{"tf":1.0},"60":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"c":{"a":{"df":0,"docs":{},"s":{"df":2,"docs":{"45":{"tf":1.0},"60":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"c":{"a":{"df":0,"docs":{},"s":{"df":2,"docs":{"45":{"tf":1.0},"60":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"df":8,"docs":{"109":{"tf":1.0},"111":{"tf":1.0},"28":{"tf":1.0},"45":{"tf":1.0},"48":{"tf":1.4142135623730951},"49":{"tf":1.0},"55":{"tf":1.0},"60":{"tf":2.23606797749979}}}},"df":0,"docs":{}}}},"y":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"k":{"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":6,"docs":{"103":{"tf":2.23606797749979},"22":{"tf":1.4142135623730951},"41":{"tf":1.0},"48":{"tf":2.0},"60":{"tf":2.0},"93":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":2,"docs":{"22":{"tf":1.0},"75":{"tf":1.7320508075688772}}}}}}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"y":{"df":0,"docs":{},"m":{"df":1,"docs":{"96":{"tf":1.0}}}}}},"t":{"a":{"df":0,"docs":{},"x":{"df":14,"docs":{"110":{"tf":1.0},"112":{"tf":1.0},"114":{"tf":1.0},"115":{"tf":1.0},"116":{"tf":1.0},"39":{"tf":2.449489742783178},"41":{"tf":1.0},"46":{"tf":2.8284271247461903},"48":{"tf":1.0},"53":{"tf":1.0},"60":{"tf":2.0},"61":{"tf":1.0},"70":{"tf":1.0},"93":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"\'":{"df":3,"docs":{"1":{"tf":1.0},"2":{"tf":1.0},"25":{"tf":1.0}}},"d":{"df":1,"docs":{"61":{"tf":1.4142135623730951}}},"df":13,"docs":{"100":{"tf":1.0},"21":{"tf":1.0},"24":{"tf":1.0},"25":{"tf":1.0},"35":{"tf":1.4142135623730951},"48":{"tf":1.4142135623730951},"5":{"tf":1.0},"54":{"tf":1.4142135623730951},"56":{"tf":1.4142135623730951},"59":{"tf":2.8284271247461903},"68":{"tf":1.0},"81":{"tf":1.0},"94":{"tf":1.0}}}}}}},"|":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"e":{"c":{"=":{"df":0,"docs":{},"h":{"df":0,"docs":{},"x":{"df":1,"docs":{"24":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"i":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"=":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"df":0,"docs":{},"|":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"=":{"$":{"(":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":1,"docs":{"24":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"l":{"=":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"|":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"l":{"=":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"|":{"df":0,"docs":{},"g":{"df":1,"docs":{"24":{"tf":1.0}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}}},"t":{"3":{"2":{"df":1,"docs":{"61":{"tf":1.0}}},"df":0,"docs":{}},"a":{"b":{"df":11,"docs":{"48":{"tf":1.4142135623730951},"51":{"tf":1.4142135623730951},"52":{"tf":1.0},"54":{"tf":1.4142135623730951},"59":{"tf":1.0},"60":{"tf":2.449489742783178},"69":{"tf":1.0},"79":{"tf":2.449489742783178},"83":{"tf":4.358898943540674},"96":{"tf":1.4142135623730951},"99":{"tf":2.0}},"l":{"df":9,"docs":{"100":{"tf":1.4142135623730951},"102":{"tf":1.4142135623730951},"103":{"tf":1.0},"104":{"tf":1.4142135623730951},"108":{"tf":1.0},"76":{"tf":1.0},"79":{"tf":1.0},"89":{"tf":1.4142135623730951},"99":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"61":{"tf":1.0}}}}}}},"p":{"a":{"d":{"df":1,"docs":{"79":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":1,"docs":{"93":{"tf":1.0}}}}}}},"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"61":{"tf":1.0}}}},"df":0,"docs":{},"g":{"df":2,"docs":{"104":{"tf":1.0},"93":{"tf":2.23606797749979}}},"i":{"df":0,"docs":{},"l":{"df":2,"docs":{"116":{"tf":1.4142135623730951},"118":{"tf":2.23606797749979}}}},"k":{"df":0,"docs":{},"e":{"df":14,"docs":{"1":{"tf":1.0},"100":{"tf":1.0},"102":{"tf":1.0},"104":{"tf":1.0},"118":{"tf":1.4142135623730951},"56":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.0},"72":{"tf":1.0},"73":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":1.0},"89":{"tf":1.0},"99":{"tf":1.4142135623730951}},"n":{"df":1,"docs":{"103":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":1,"docs":{"61":{"tf":1.0}}}}},"r":{"b":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"2":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"/":{"d":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"25":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"/":{"df":0,"docs":{},"h":{"df":0,"docs":{},"x":{"df":1,"docs":{"22":{"tf":1.0}}}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"/":{"df":0,"docs":{},"h":{"df":0,"docs":{},"x":{"df":1,"docs":{"25":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":3,"docs":{"21":{"tf":1.4142135623730951},"22":{"tf":1.0},"60":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"k":{"df":2,"docs":{"27":{"tf":1.0},"61":{"tf":1.0}}}}},"c":{"df":0,"docs":{},"l":{"df":1,"docs":{"61":{"tf":1.0}}},"p":{"df":1,"docs":{"59":{"tf":1.4142135623730951}}}},"df":10,"docs":{"37":{"tf":1.7320508075688772},"38":{"tf":1.0},"44":{"tf":2.23606797749979},"48":{"tf":2.449489742783178},"51":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":4.0},"93":{"tf":1.0},"95":{"tf":1.0},"99":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"61":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"e":{"df":1,"docs":{"71":{"tf":1.4142135623730951}}},"l":{"df":0,"docs":{},"l":{"df":2,"docs":{"103":{"tf":1.0},"116":{"tf":1.0}}}},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"59":{"tf":1.4142135623730951}}}},"df":1,"docs":{"61":{"tf":1.4142135623730951}}},"o":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"79":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"r":{"a":{"df":1,"docs":{"61":{"tf":1.0}}},"df":0,"docs":{},"m":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"r":{"c":{"/":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"94":{"tf":1.0}}}},"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"d":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"94":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"c":{"df":0,"docs":{},"o":{"d":{"df":2,"docs":{"70":{"tf":1.0},"71":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":5,"docs":{"116":{"tf":1.0},"21":{"tf":1.4142135623730951},"36":{"tf":1.0},"41":{"tf":1.4142135623730951},"50":{"tf":1.4142135623730951}},"i":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"l":{"\'":{"df":2,"docs":{"42":{"tf":1.0},"89":{"tf":1.0}}},"df":0,"docs":{}}},"df":9,"docs":{"24":{"tf":1.0},"42":{"tf":1.0},"70":{"tf":1.4142135623730951},"74":{"tf":1.0},"77":{"tf":1.0},"83":{"tf":1.4142135623730951},"90":{"tf":1.0},"91":{"tf":1.0},"96":{"tf":1.0}}}},"u":{"df":0,"docs":{},"x":{"df":2,"docs":{"61":{"tf":1.0},"70":{"tf":1.0}}}}},"r":{"a":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":1,"docs":{"61":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"t":{".":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"112":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"112":{"tf":1.0}}},"df":0,"docs":{}}}}},"t":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"71":{"tf":1.4142135623730951}}}}}},"df":10,"docs":{"109":{"tf":1.0},"112":{"tf":1.0},"114":{"tf":1.0},"22":{"tf":1.0},"37":{"tf":1.0},"48":{"tf":1.4142135623730951},"60":{"tf":1.4142135623730951},"71":{"tf":1.4142135623730951},"95":{"tf":1.0},"99":{"tf":1.0}}}},"x":{"df":0,"docs":{},"l":{"a":{"b":{"df":1,"docs":{"61":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"t":{".":{"<":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"99":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"d":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"99":{"tf":1.0}}}}}}}}}}}},"df":0,"docs":{}}},"df":20,"docs":{"121":{"tf":1.7320508075688772},"27":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":1.7320508075688772},"33":{"tf":1.4142135623730951},"34":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.7320508075688772},"41":{"tf":1.4142135623730951},"45":{"tf":2.0},"48":{"tf":1.0},"49":{"tf":1.0},"57":{"tf":1.0},"60":{"tf":1.0},"70":{"tf":1.4142135623730951},"72":{"tf":1.7320508075688772},"82":{"tf":1.7320508075688772},"84":{"tf":1.4142135623730951},"93":{"tf":2.6457513110645907},"99":{"tf":1.7320508075688772}},"m":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"93":{"tf":1.0},"99":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"b":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":8,"docs":{"106":{"tf":1.0},"112":{"tf":1.7320508075688772},"113":{"tf":1.0},"37":{"tf":2.23606797749979},"38":{"tf":1.7320508075688772},"48":{"tf":1.7320508075688772},"61":{"tf":1.0},"63":{"tf":1.0}},"s":{".":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"m":{"df":2,"docs":{"112":{"tf":1.0},"113":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"61":{"tf":1.0}}}}}}},"u":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"48":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}},"f":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"61":{"tf":1.0}}}},"df":0,"docs":{}}},"h":{"a":{"df":0,"docs":{},"t":{"\'":{"df":1,"docs":{"117":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"87":{"tf":1.0}}}}}}},"df":12,"docs":{"0":{"tf":1.0},"110":{"tf":1.0},"59":{"tf":2.0},"68":{"tf":1.0},"81":{"tf":1.0},"85":{"tf":2.0},"86":{"tf":2.23606797749979},"87":{"tf":1.4142135623730951},"88":{"tf":1.0},"89":{"tf":1.7320508075688772},"92":{"tf":1.7320508075688772},"93":{"tf":1.4142135623730951}}}},"y":{"\'":{"df":0,"docs":{},"r":{"df":1,"docs":{"31":{"tf":1.0}}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{".":{"c":{"a":{"df":0,"docs":{},"n":{"_":{"d":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"(":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"116":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"93":{"tf":1.0}},"s":{".":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"|":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"116":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}},"r":{"d":{"df":1,"docs":{"4":{"tf":1.0}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":2,"docs":{"25":{"tf":1.0},"54":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":1,"docs":{"60":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":3,"docs":{"72":{"tf":1.0},"94":{"tf":1.0},"98":{"tf":1.0}}}},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":1,"docs":{"61":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":9,"docs":{"115":{"tf":1.0},"22":{"tf":1.0},"45":{"tf":1.0},"57":{"tf":1.4142135623730951},"60":{"tf":1.0},"83":{"tf":1.4142135623730951},"9":{"tf":1.0},"93":{"tf":1.0},"94":{"tf":1.0}}}}}}},"u":{"d":{"df":1,"docs":{"116":{"tf":1.0}}},"df":0,"docs":{},"m":{"b":{"df":1,"docs":{"93":{"tf":1.0}}},"df":0,"docs":{}}}},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"_":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{"df":2,"docs":{"44":{"tf":1.0},"60":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":2,"docs":{"44":{"tf":1.4142135623730951},"60":{"tf":2.449489742783178}}}},"m":{"df":0,"docs":{},"e":{"df":7,"docs":{"102":{"tf":1.0},"103":{"tf":1.0},"22":{"tf":1.4142135623730951},"30":{"tf":1.0},"59":{"tf":1.4142135623730951},"70":{"tf":1.4142135623730951},"77":{"tf":1.0}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"102":{"tf":1.0},"70":{"tf":1.4142135623730951}}}}},"r":{"df":2,"docs":{"70":{"tf":1.0},"77":{"tf":1.0}}},"—":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"22":{"tf":1.0}}}}}}}},"n":{"df":0,"docs":{},"y":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"61":{"tf":1.0}}}}}}}}},"l":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":1,"docs":{"61":{"tf":1.0}}}}}},"df":0,"docs":{}},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"x":{"df":1,"docs":{"70":{"tf":1.0}}}}},"o":{"d":{"df":0,"docs":{},"o":{"df":4,"docs":{"119":{"tf":1.0},"48":{"tf":1.0},"63":{"tf":1.0},"93":{"tf":1.4142135623730951}},"t":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"61":{"tf":1.0}}}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"103":{"tf":1.0}}}}},"g":{"df":0,"docs":{},"l":{"df":5,"docs":{"50":{"tf":1.4142135623730951},"51":{"tf":1.0},"57":{"tf":3.1622776601683795},"59":{"tf":2.23606797749979},"60":{"tf":1.4142135623730951}},"e":{"_":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"k":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":3,"docs":{"46":{"tf":1.0},"48":{"tf":1.0},"60":{"tf":1.0}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":5,"docs":{"116":{"tf":1.0},"54":{"tf":1.0},"56":{"tf":1.0},"70":{"tf":1.0},"99":{"tf":3.1622776601683795}}}}},"m":{"b":{"df":0,"docs":{},"i":{"df":1,"docs":{"61":{"tf":1.0}}}},"df":0,"docs":{},"l":{"df":5,"docs":{"100":{"tf":1.4142135623730951},"41":{"tf":1.4142135623730951},"61":{"tf":1.0},"76":{"tf":1.0},"94":{"tf":1.0}}}},"o":{"df":0,"docs":{},"l":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"21":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":2,"docs":{"17":{"tf":1.0},"25":{"tf":1.0}}}},"p":{"df":6,"docs":{"105":{"tf":1.0},"48":{"tf":1.4142135623730951},"60":{"tf":1.4142135623730951},"70":{"tf":1.0},"81":{"tf":1.0},"85":{"tf":1.0}}},"t":{"a":{"df":0,"docs":{},"l":{"df":3,"docs":{"114":{"tf":1.4142135623730951},"117":{"tf":1.0},"72":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}},"r":{"a":{"c":{"df":0,"docs":{},"k":{"df":2,"docs":{"93":{"tf":1.0},"99":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"70":{"tf":1.4142135623730951}}}},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":1,"docs":{"60":{"tf":1.0}},"e":{"_":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"60":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":3,"docs":{"114":{"tf":1.0},"115":{"tf":1.7320508075688772},"116":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":5,"docs":{"54":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.0},"70":{"tf":1.0},"99":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":24,"docs":{"104":{"tf":2.23606797749979},"106":{"tf":1.0},"109":{"tf":1.0},"110":{"tf":1.0},"111":{"tf":1.0},"112":{"tf":2.0},"113":{"tf":1.0},"114":{"tf":2.23606797749979},"115":{"tf":1.0},"117":{"tf":1.4142135623730951},"119":{"tf":1.0},"121":{"tf":1.0},"21":{"tf":2.0},"37":{"tf":1.7320508075688772},"38":{"tf":2.0},"39":{"tf":3.0},"42":{"tf":1.0},"46":{"tf":2.6457513110645907},"57":{"tf":2.0},"59":{"tf":2.449489742783178},"60":{"tf":1.4142135623730951},"70":{"tf":1.7320508075688772},"93":{"tf":1.0},"99":{"tf":1.0}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":1,"docs":{"61":{"tf":1.0}}}}}}}},"i":{"df":3,"docs":{"103":{"tf":1.0},"65":{"tf":1.0},"99":{"tf":1.0}},"g":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"70":{"tf":1.7320508075688772},"77":{"tf":1.0},"83":{"tf":1.4142135623730951}}}}}},"m":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"46":{"tf":1.0},"60":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":3,"docs":{"46":{"tf":1.0},"60":{"tf":1.0},"70":{"tf":1.4142135623730951}}}},"u":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"70":{"tf":1.0}}}}}}},"df":11,"docs":{"102":{"tf":2.0},"115":{"tf":2.8284271247461903},"70":{"tf":4.0},"73":{"tf":2.6457513110645907},"75":{"tf":2.8284271247461903},"76":{"tf":1.0},"78":{"tf":1.4142135623730951},"80":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.7320508075688772},"93":{"tf":1.0}}}}},"s":{"_":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"l":{"df":1,"docs":{"61":{"tf":1.0}}}},"df":0,"docs":{}}}}}}},"df":4,"docs":{"42":{"tf":1.0},"46":{"tf":2.8284271247461903},"48":{"tf":3.3166247903554},"59":{"tf":1.0}},"f":{"df":1,"docs":{"22":{"tf":1.0}}},"p":{"df":1,"docs":{"61":{"tf":1.0}}},"q":{"df":1,"docs":{"61":{"tf":1.0}}},"x":{"df":2,"docs":{"103":{"tf":1.0},"61":{"tf":1.0}}}},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"26":{"tf":1.7320508075688772},"59":{"tf":1.0}},"i":{"df":1,"docs":{"59":{"tf":1.0}}}}}}},"w":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"k":{"df":1,"docs":{"65":{"tf":1.0}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"g":{"df":1,"docs":{"61":{"tf":1.0}}}},"o":{"df":6,"docs":{"116":{"tf":1.0},"41":{"tf":1.0},"54":{"tf":1.0},"56":{"tf":1.0},"60":{"tf":1.7320508075688772},"70":{"tf":1.0}}}},"y":{"df":1,"docs":{"61":{"tf":1.0}},"p":{"a":{"b":{"df":0,"docs":{},"l":{"df":4,"docs":{"53":{"tf":1.4142135623730951},"58":{"tf":1.0},"59":{"tf":1.7320508075688772},"94":{"tf":1.4142135623730951}},"e":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"94":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"94":{"tf":1.0}}}},"df":0,"docs":{}},"df":24,"docs":{"100":{"tf":2.6457513110645907},"103":{"tf":1.0},"114":{"tf":1.0},"115":{"tf":1.0},"116":{"tf":1.0},"120":{"tf":1.0},"27":{"tf":1.7320508075688772},"37":{"tf":1.0},"38":{"tf":1.0},"41":{"tf":1.0},"42":{"tf":1.0},"48":{"tf":3.0},"49":{"tf":1.0},"50":{"tf":1.0},"55":{"tf":1.0},"57":{"tf":1.4142135623730951},"60":{"tf":1.7320508075688772},"68":{"tf":1.0},"70":{"tf":1.0},"72":{"tf":1.7320508075688772},"81":{"tf":1.0},"93":{"tf":2.8284271247461903},"94":{"tf":1.0},"99":{"tf":1.7320508075688772}},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":4,"docs":{"102":{"tf":1.4142135623730951},"103":{"tf":3.0},"104":{"tf":1.0},"61":{"tf":2.6457513110645907}}}}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"c":{"df":1,"docs":{"61":{"tf":1.0}}},"df":0,"docs":{}}}}},"i":{"c":{"df":3,"docs":{"1":{"tf":1.0},"2":{"tf":1.0},"48":{"tf":1.0}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"61":{"tf":1.0}}}}}}},"u":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"/":{"d":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"n":{"df":2,"docs":{"3":{"tf":1.0},"5":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":4,"docs":{"25":{"tf":1.0},"3":{"tf":1.0},"5":{"tf":1.0},"6":{"tf":1.0}}}}}}},"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"20":{"tf":1.0}}}}},"df":10,"docs":{"44":{"tf":1.0},"45":{"tf":2.0},"48":{"tf":1.4142135623730951},"49":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.0},"56":{"tf":1.7320508075688772},"57":{"tf":1.4142135623730951},"59":{"tf":1.0},"60":{"tf":3.872983346207417}},"i":{".":{"b":{"a":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"93":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":2,"docs":{"89":{"tf":1.0},"93":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"u":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"93":{"tf":1.0}},"e":{".":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"93":{"tf":1.0}}}},"df":0,"docs":{}},"b":{"a":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"93":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}}}},"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"93":{"tf":1.0}}}}}}}},"m":{"a":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"93":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":1,"docs":{"93":{"tf":1.0}}}}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"93":{"tf":1.0}}},"y":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"93":{"tf":1.0}}}}}}}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":1,"docs":{"93":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"93":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"93":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"n":{".":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"93":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"s":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"93":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}},"df":1,"docs":{"93":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"93":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"s":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"93":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}}}}}},"d":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{".":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"93":{"tf":1.0}}}},"df":0,"docs":{}},"b":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"k":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"93":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":1,"docs":{"93":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"93":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"p":{"df":1,"docs":{"93":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"93":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}},"df":1,"docs":{"93":{"tf":1.0}}}}}}}}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"r":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"93":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":1,"docs":{"93":{"tf":1.0}}}}}}}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{".":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"93":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"93":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":1,"docs":{"93":{"tf":1.0}}}}}},"p":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{".":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"a":{"d":{"df":1,"docs":{"93":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"n":{".":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"93":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"93":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":1,"docs":{"93":{"tf":1.4142135623730951}}}}}}},"df":1,"docs":{"93":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"93":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{".":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"93":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"t":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"93":{"tf":1.0}},"e":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"93":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"93":{"tf":1.0}}}}}}}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":1,"docs":{"93":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"93":{"tf":1.0}}}},"df":0,"docs":{}}},"p":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"93":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{".":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"93":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"u":{"df":1,"docs":{"93":{"tf":1.0}}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"n":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"93":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":1,"docs":{"93":{"tf":1.0}}}}}}},"df":2,"docs":{"89":{"tf":1.0},"93":{"tf":1.4142135623730951}}}}}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"l":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"93":{"tf":1.0}}},"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"y":{"df":1,"docs":{"93":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}}},"j":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":1,"docs":{"93":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"93":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"a":{"c":{"df":1,"docs":{"93":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"r":{"a":{"df":0,"docs":{},"p":{"df":2,"docs":{"82":{"tf":1.0},"93":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"93":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":2,"docs":{"59":{"tf":1.0},"93":{"tf":2.449489742783178}}},"n":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"111":{"tf":1.0}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"116":{"tf":1.0}}}},"df":0,"docs":{}}}}},"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"99":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"93":{"tf":1.0}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"99":{"tf":1.0}}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":1,"docs":{"70":{"tf":1.4142135623730951}}}}}},"df":9,"docs":{"112":{"tf":1.0},"45":{"tf":1.4142135623730951},"48":{"tf":1.4142135623730951},"52":{"tf":1.0},"59":{"tf":1.7320508075688772},"60":{"tf":1.7320508075688772},"68":{"tf":1.0},"70":{"tf":1.0},"73":{"tf":1.4142135623730951}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":5,"docs":{"68":{"tf":1.0},"74":{"tf":1.0},"87":{"tf":2.0},"90":{"tf":1.4142135623730951},"91":{"tf":1.0}},"e":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"l":{"df":1,"docs":{"91":{"tf":1.0}},"e":{"=":{"\\"":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"90":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}}},"o":{"df":3,"docs":{"45":{"tf":1.4142135623730951},"49":{"tf":1.4142135623730951},"60":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":2,"docs":{"70":{"tf":1.0},"93":{"tf":1.0}}}}},"df":0,"docs":{}}},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"61":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"i":{"c":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"56":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"75":{"tf":1.4142135623730951}}}}}},"m":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":3,"docs":{"38":{"tf":1.0},"42":{"tf":1.0},"48":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}},"n":{"d":{"df":2,"docs":{"45":{"tf":1.4142135623730951},"60":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"93":{"tf":1.0}}}},"q":{"df":0,"docs":{},"u":{"df":1,"docs":{"93":{"tf":1.4142135623730951}}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"61":{"tf":1.0}}}}},"t":{"df":1,"docs":{"99":{"tf":1.4142135623730951}}},"x":{"df":5,"docs":{"100":{"tf":1.4142135623730951},"54":{"tf":1.4142135623730951},"56":{"tf":1.0},"68":{"tf":1.0},"70":{"tf":1.0}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"76":{"tf":1.0},"78":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"k":{"df":3,"docs":{"44":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.0}}}}},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"121":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"93":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"m":{"b":{"df":1,"docs":{"93":{"tf":1.0}}},"df":0,"docs":{}}}},"s":{"a":{"df":0,"docs":{},"v":{"df":2,"docs":{"59":{"tf":2.449489742783178},"72":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":2,"docs":{"73":{"tf":1.0},"75":{"tf":1.0}}}},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"9":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"115":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"s":{"df":2,"docs":{"81":{"tf":1.4142135623730951},"93":{"tf":1.4142135623730951}}}}},"p":{"d":{"a":{"df":0,"docs":{},"t":{"df":5,"docs":{"108":{"tf":1.7320508075688772},"111":{"tf":1.0},"17":{"tf":1.0},"59":{"tf":1.0},"6":{"tf":1.0}}}},"df":0,"docs":{}},"df":18,"docs":{"115":{"tf":1.0},"116":{"tf":1.0},"118":{"tf":1.0},"2":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":1.0},"39":{"tf":1.0},"44":{"tf":2.0},"46":{"tf":1.0},"48":{"tf":2.8284271247461903},"49":{"tf":1.7320508075688772},"51":{"tf":1.4142135623730951},"52":{"tf":1.0},"56":{"tf":1.0},"60":{"tf":3.7416573867739413},"70":{"tf":1.0},"9":{"tf":1.0},"96":{"tf":1.7320508075688772}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"c":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"60":{"tf":1.0}}}},"df":0,"docs":{}},"df":2,"docs":{"45":{"tf":1.0},"78":{"tf":1.0}}}}},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"48":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"l":{"df":2,"docs":{"104":{"tf":1.0},"93":{"tf":2.23606797749979}}}},"s":{"a":{"df":0,"docs":{},"g":{"df":2,"docs":{"0":{"tf":1.0},"32":{"tf":1.0}}}},"df":65,"docs":{"100":{"tf":2.23606797749979},"102":{"tf":1.4142135623730951},"103":{"tf":2.23606797749979},"104":{"tf":1.7320508075688772},"105":{"tf":2.23606797749979},"109":{"tf":1.4142135623730951},"113":{"tf":1.0},"114":{"tf":2.0},"116":{"tf":1.4142135623730951},"117":{"tf":1.0},"119":{"tf":1.0},"12":{"tf":1.0},"120":{"tf":2.0},"16":{"tf":1.0},"2":{"tf":1.0},"21":{"tf":1.0},"22":{"tf":1.7320508075688772},"24":{"tf":1.4142135623730951},"25":{"tf":2.23606797749979},"26":{"tf":1.0},"28":{"tf":1.0},"30":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":1.4142135623730951},"34":{"tf":1.7320508075688772},"36":{"tf":2.0},"38":{"tf":2.0},"39":{"tf":2.0},"40":{"tf":1.4142135623730951},"41":{"tf":2.449489742783178},"47":{"tf":2.0},"48":{"tf":1.7320508075688772},"51":{"tf":1.0},"52":{"tf":1.0},"53":{"tf":1.0},"54":{"tf":2.449489742783178},"55":{"tf":1.0},"56":{"tf":2.8284271247461903},"57":{"tf":1.7320508075688772},"59":{"tf":2.449489742783178},"60":{"tf":1.4142135623730951},"61":{"tf":1.0},"64":{"tf":2.0},"65":{"tf":1.0},"67":{"tf":1.0},"68":{"tf":1.4142135623730951},"70":{"tf":3.3166247903554},"71":{"tf":2.0},"72":{"tf":1.0},"75":{"tf":1.4142135623730951},"76":{"tf":1.0},"79":{"tf":1.4142135623730951},"80":{"tf":1.0},"81":{"tf":1.7320508075688772},"82":{"tf":1.0},"83":{"tf":2.0},"85":{"tf":1.4142135623730951},"89":{"tf":1.0},"9":{"tf":2.8284271247461903},"90":{"tf":1.0},"91":{"tf":1.0},"93":{"tf":2.6457513110645907},"94":{"tf":2.23606797749979},"96":{"tf":2.0},"99":{"tf":3.3166247903554}},"e":{"df":0,"docs":{},"r":{"\'":{"df":1,"docs":{"21":{"tf":1.0}}},"df":9,"docs":{"120":{"tf":1.4142135623730951},"22":{"tf":2.0},"32":{"tf":1.0},"33":{"tf":1.0},"49":{"tf":1.7320508075688772},"59":{"tf":1.4142135623730951},"86":{"tf":1.0},"87":{"tf":1.0},"9":{"tf":1.0}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"22":{"tf":1.0}},"e":{"%":{"\\\\":{"df":0,"docs":{},"s":{"df":0,"docs":{},"r":{"c":{"\\\\":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"\\\\":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"22":{"tf":1.4142135623730951}}}}}}}}},"df":0,"docs":{}}}}}}},"df":1,"docs":{"21":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}}},"i":{"df":0,"docs":{},"z":{"df":1,"docs":{"93":{"tf":1.0}}}},"r":{"/":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"b":{"/":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"22":{"tf":1.4142135623730951}}}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"1":{"df":1,"docs":{"68":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"u":{"a":{"df":0,"docs":{},"l":{"df":6,"docs":{"56":{"tf":1.0},"75":{"tf":1.0},"9":{"tf":1.0},"94":{"tf":1.0},"95":{"tf":1.0},"99":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"f":{"df":1,"docs":{"72":{"tf":1.0}}}},"x":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"61":{"tf":1.0}}}},"df":0,"docs":{}}}},"{":{"2":{"5":{"c":{"df":0,"docs":{},"f":{"df":1,"docs":{"56":{"tf":2.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"v":{"a":{"df":1,"docs":{"37":{"tf":1.0}},"l":{"a":{"df":1,"docs":{"61":{"tf":1.4142135623730951}}},"df":1,"docs":{"116":{"tf":1.4142135623730951}},"i":{"d":{"df":3,"docs":{"21":{"tf":1.0},"23":{"tf":1.0},"74":{"tf":1.0}}},"df":0,"docs":{}},"u":{"df":17,"docs":{"100":{"tf":1.0},"116":{"tf":1.0},"35":{"tf":1.4142135623730951},"53":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":2.23606797749979},"59":{"tf":2.23606797749979},"74":{"tf":1.0},"75":{"tf":1.0},"76":{"tf":1.0},"82":{"tf":1.0},"84":{"tf":1.7320508075688772},"89":{"tf":1.0},"90":{"tf":1.0},"91":{"tf":1.4142135623730951},"98":{"tf":1.0},"99":{"tf":1.4142135623730951}},"e":{"1":{"df":1,"docs":{"102":{"tf":1.4142135623730951}}},"2":{"df":1,"docs":{"102":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"r":{"df":1,"docs":{"93":{"tf":1.0}},"i":{"a":{"b":{"df":0,"docs":{},"l":{"df":12,"docs":{"101":{"tf":1.0},"102":{"tf":1.0},"111":{"tf":1.0},"2":{"tf":1.0},"21":{"tf":1.4142135623730951},"22":{"tf":2.23606797749979},"54":{"tf":1.0},"56":{"tf":2.0},"60":{"tf":1.0},"84":{"tf":1.0},"93":{"tf":2.0},"99":{"tf":1.0}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"48":{"tf":1.0},"93":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":2,"docs":{"40":{"tf":1.0},"64":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"u":{"df":3,"docs":{"40":{"tf":1.0},"48":{"tf":1.0},"64":{"tf":1.0}}}}}}},"df":7,"docs":{"27":{"tf":1.0},"48":{"tf":1.7320508075688772},"50":{"tf":1.0},"51":{"tf":1.0},"60":{"tf":3.1622776601683795},"61":{"tf":1.4142135623730951},"93":{"tf":1.0}},"e":{"c":{"<":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"116":{"tf":1.0}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"81":{"tf":1.0}}}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"61":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"25":{"tf":1.0}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":1,"docs":{"61":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":9,"docs":{"1":{"tf":1.0},"17":{"tf":1.4142135623730951},"21":{"tf":1.0},"25":{"tf":1.0},"61":{"tf":1.0},"65":{"tf":1.0},"72":{"tf":1.0},"9":{"tf":1.0},"93":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"i":{"c":{"df":6,"docs":{"48":{"tf":1.7320508075688772},"51":{"tf":1.0},"59":{"tf":1.4142135623730951},"60":{"tf":1.4142135623730951},"80":{"tf":1.0},"93":{"tf":1.0}}},"df":0,"docs":{}}}}},"g":{"df":0,"docs":{},"l":{"df":1,"docs":{"50":{"tf":1.0}}}},"h":{"d":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"l":{"df":1,"docs":{"61":{"tf":1.0}}}},"df":1,"docs":{"61":{"tf":1.0}}}},"df":1,"docs":{"61":{"tf":1.0}}},"i":{"a":{"df":6,"docs":{"1":{"tf":1.0},"114":{"tf":1.0},"26":{"tf":1.0},"40":{"tf":1.0},"65":{"tf":1.0},"94":{"tf":1.0}}},"df":1,"docs":{"37":{"tf":1.0}},"e":{"df":0,"docs":{},"w":{"df":7,"docs":{"39":{"tf":1.0},"42":{"tf":1.0},"48":{"tf":2.6457513110645907},"59":{"tf":3.0},"60":{"tf":2.449489742783178},"82":{"tf":1.0},"95":{"tf":1.0}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"82":{"tf":1.0}}}}}}}},"m":{"df":8,"docs":{"32":{"tf":1.0},"36":{"tf":1.4142135623730951},"37":{"tf":1.4142135623730951},"44":{"tf":1.0},"48":{"tf":1.4142135623730951},"63":{"tf":2.23606797749979},"64":{"tf":1.0},"65":{"tf":1.0}}},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"93":{"tf":1.0}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"l":{"df":3,"docs":{"75":{"tf":1.0},"79":{"tf":1.4142135623730951},"93":{"tf":1.0}}}},"df":0,"docs":{}},"u":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"48":{"tf":1.4142135623730951},"65":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"59":{"tf":1.0}}}}},"s":{"c":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{"df":1,"docs":{"61":{"tf":3.0}}}},"df":0,"docs":{}}},"df":2,"docs":{"59":{"tf":1.0},"65":{"tf":1.0}},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"60":{"tf":1.0}}}}}},"df":3,"docs":{"48":{"tf":1.0},"59":{"tf":1.4142135623730951},"60":{"tf":1.4142135623730951}}}}}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"65":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"e":{"df":1,"docs":{"61":{"tf":1.4142135623730951}}}}},"w":{"6":{"4":{"df":1,"docs":{"20":{"tf":1.0}}},"df":0,"docs":{}},">":{"<":{"c":{"df":1,"docs":{"60":{"tf":4.47213595499958}}},"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":1,"docs":{"60":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":1,"docs":{"60":{"tf":1.4142135623730951}}}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":1,"docs":{"60":{"tf":1.4142135623730951}}}}}}},"u":{"df":0,"docs":{},"p":{"df":1,"docs":{"60":{"tf":1.4142135623730951}}}}},"df":1,"docs":{"60":{"tf":1.4142135623730951}},"f":{"df":1,"docs":{"60":{"tf":2.0}}},"h":{"df":1,"docs":{"60":{"tf":2.0}}},"j":{"df":1,"docs":{"60":{"tf":2.0}}},"k":{"df":1,"docs":{"60":{"tf":2.0}}},"l":{"df":1,"docs":{"60":{"tf":2.0}}},"n":{"<":{"c":{"df":1,"docs":{"60":{"tf":2.0}}},"df":0,"docs":{}},"df":1,"docs":{"60":{"tf":1.4142135623730951}},"v":{"df":1,"docs":{"60":{"tf":1.4142135623730951}}}},"o":{"df":1,"docs":{"60":{"tf":1.4142135623730951}}},"q":{"df":1,"docs":{"60":{"tf":1.4142135623730951}}},"t":{"df":1,"docs":{"60":{"tf":1.4142135623730951}}},"v":{"df":1,"docs":{"60":{"tf":1.4142135623730951}}},"w":{"df":1,"docs":{"60":{"tf":1.4142135623730951}}}},"a":{"df":1,"docs":{"59":{"tf":1.4142135623730951}},"l":{"d":{"df":0,"docs":{},"o":{"df":1,"docs":{"116":{"tf":1.0}}}},"df":0,"docs":{}},"n":{"df":0,"docs":{},"t":{"df":7,"docs":{"111":{"tf":1.0},"116":{"tf":1.4142135623730951},"118":{"tf":1.0},"21":{"tf":1.0},"22":{"tf":1.0},"49":{"tf":1.0},"87":{"tf":1.0}}}},"r":{"df":0,"docs":{},"n":{"df":5,"docs":{"25":{"tf":1.0},"72":{"tf":2.449489742783178},"84":{"tf":1.7320508075688772},"93":{"tf":1.7320508075688772},"99":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"61":{"tf":1.0}}}},"t":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{"df":1,"docs":{"61":{"tf":1.0}}}}}}},"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"/":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"70":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}},"df":1,"docs":{"61":{"tf":1.0}}},"y":{"df":10,"docs":{"1":{"tf":1.0},"114":{"tf":1.0},"115":{"tf":1.0},"22":{"tf":1.0},"25":{"tf":1.0},"30":{"tf":1.0},"37":{"tf":1.4142135623730951},"53":{"tf":1.0},"54":{"tf":1.0},"94":{"tf":1.4142135623730951}},"l":{"a":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"70":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"b":{"c":{"df":1,"docs":{"59":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}}}}}}},"df":10,"docs":{"31":{"tf":1.0},"37":{"tf":1.4142135623730951},"41":{"tf":1.0},"44":{"tf":1.4142135623730951},"48":{"tf":2.449489742783178},"49":{"tf":1.0},"52":{"tf":1.4142135623730951},"59":{"tf":1.4142135623730951},"60":{"tf":3.0},"94":{"tf":2.0}},"e":{"b":{"c":{"df":1,"docs":{"61":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"110":{"tf":1.0}}}}}},"df":0,"docs":{},"l":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"37":{"tf":1.0}}}}},"df":0,"docs":{},"l":{"df":4,"docs":{"116":{"tf":1.0},"120":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.0}}}},"r":{"df":0,"docs":{},"k":{"df":1,"docs":{"61":{"tf":1.0}}}},"s":{"df":0,"docs":{},"l":{"df":1,"docs":{"61":{"tf":1.0}}}}},"g":{"df":0,"docs":{},"s":{"df":0,"docs":{},"l":{"df":1,"docs":{"61":{"tf":1.4142135623730951}}}}},"h":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":2,"docs":{"29":{"tf":1.0},"63":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"70":{"tf":1.0}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":9,"docs":{"116":{"tf":1.0},"70":{"tf":2.8284271247461903},"72":{"tf":1.0},"78":{"tf":1.0},"79":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0},"99":{"tf":1.4142135623730951}}}}}}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"89":{"tf":1.7320508075688772}},"s":{"df":0,"docs":{},"p":{"a":{"c":{"df":8,"docs":{"116":{"tf":1.0},"46":{"tf":1.0},"48":{"tf":1.0},"60":{"tf":1.4142135623730951},"70":{"tf":1.4142135623730951},"79":{"tf":2.0},"83":{"tf":1.4142135623730951},"93":{"tf":1.0}},"e":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"79":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":5,"docs":{"118":{"tf":1.4142135623730951},"36":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.0},"94":{"tf":1.0}}}},"s":{"df":0,"docs":{},"e":{"df":1,"docs":{"75":{"tf":1.0}}}}}},"i":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"62":{"tf":1.0}}}},"t":{"df":0,"docs":{},"h":{"df":9,"docs":{"29":{"tf":1.0},"59":{"tf":1.0},"63":{"tf":1.0},"70":{"tf":1.7320508075688772},"79":{"tf":1.0},"81":{"tf":1.4142135623730951},"82":{"tf":1.7320508075688772},"93":{"tf":1.0},"99":{"tf":2.23606797749979}}}}},"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"df":4,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"108":{"tf":1.0},"42":{"tf":1.0}}}},"n":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"73":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}}}},"df":17,"docs":{"100":{"tf":1.0},"16":{"tf":1.4142135623730951},"17":{"tf":1.7320508075688772},"20":{"tf":1.0},"21":{"tf":1.4142135623730951},"22":{"tf":1.7320508075688772},"3":{"tf":1.0},"40":{"tf":1.0},"42":{"tf":1.0},"48":{"tf":3.3166247903554},"54":{"tf":1.0},"56":{"tf":1.0},"60":{"tf":2.6457513110645907},"68":{"tf":1.0},"70":{"tf":1.4142135623730951},"75":{"tf":1.0},"86":{"tf":1.0}},"s":{"/":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"x":{"df":1,"docs":{"96":{"tf":1.4142135623730951}}}}}}}},"df":0,"docs":{}}}}},"df":3,"docs":{"100":{"tf":1.0},"70":{"tf":1.0},"96":{"tf":1.7320508075688772}},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":3,"docs":{"16":{"tf":1.0},"17":{"tf":1.7320508075688772},"3":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"e":{"df":1,"docs":{"46":{"tf":1.4142135623730951}}}},"t":{"df":1,"docs":{"61":{"tf":1.0}},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":11,"docs":{"102":{"tf":1.0},"104":{"tf":1.0},"117":{"tf":1.0},"21":{"tf":1.0},"41":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.0},"54":{"tf":1.4142135623730951},"56":{"tf":1.7320508075688772},"68":{"tf":1.0},"94":{"tf":1.0}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":10,"docs":{"116":{"tf":1.0},"41":{"tf":1.0},"45":{"tf":1.4142135623730951},"48":{"tf":1.0},"51":{"tf":1.0},"57":{"tf":1.0},"59":{"tf":1.4142135623730951},"60":{"tf":1.4142135623730951},"9":{"tf":1.0},"94":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}}}}},"r":{"d":{"df":14,"docs":{"29":{"tf":1.0},"30":{"tf":1.0},"31":{"tf":1.0},"37":{"tf":1.7320508075688772},"44":{"tf":2.449489742783178},"47":{"tf":1.0},"48":{"tf":1.4142135623730951},"49":{"tf":1.4142135623730951},"52":{"tf":2.23606797749979},"60":{"tf":5.291502622129181},"63":{"tf":1.0},"70":{"tf":1.7320508075688772},"82":{"tf":1.0},"94":{"tf":1.0}}},"df":0,"docs":{},"k":{"df":15,"docs":{"102":{"tf":1.0},"103":{"tf":1.0},"112":{"tf":1.0},"113":{"tf":1.0},"117":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"42":{"tf":1.0},"48":{"tf":1.0},"51":{"tf":1.0},"57":{"tf":1.0},"59":{"tf":1.4142135623730951},"60":{"tf":1.4142135623730951},"70":{"tf":1.0},"80":{"tf":1.0}},"s":{"df":0,"docs":{},"p":{"a":{"c":{"df":10,"docs":{"103":{"tf":1.7320508075688772},"41":{"tf":1.0},"48":{"tf":2.0},"57":{"tf":1.4142135623730951},"59":{"tf":2.0},"60":{"tf":2.0},"70":{"tf":1.4142135623730951},"72":{"tf":2.449489742783178},"75":{"tf":1.0},"99":{"tf":1.7320508075688772}},"e":{"_":{"d":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"k":{"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"k":{"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"25":{"tf":1.0}}}}}},"q":{"a":{"df":1,"docs":{"59":{"tf":1.4142135623730951}}},"df":1,"docs":{"59":{"tf":2.0}}},"r":{"a":{"df":0,"docs":{},"p":{".":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"x":{"df":1,"docs":{"84":{"tf":1.0}}}},"df":0,"docs":{}},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":2,"docs":{"70":{"tf":1.0},"99":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":12,"docs":{"39":{"tf":1.0},"47":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.0},"69":{"tf":1.0},"70":{"tf":1.0},"78":{"tf":1.4142135623730951},"82":{"tf":3.7416573867739413},"84":{"tf":1.4142135623730951},"93":{"tf":1.4142135623730951},"94":{"tf":1.0},"99":{"tf":1.4142135623730951}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"61":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"61":{"tf":1.0}}}},"i":{"df":0,"docs":{},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"35":{"tf":1.7320508075688772}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":10,"docs":{"110":{"tf":1.0},"112":{"tf":1.0},"118":{"tf":1.0},"119":{"tf":1.0},"53":{"tf":1.7320508075688772},"59":{"tf":5.0},"70":{"tf":2.23606797749979},"94":{"tf":1.4142135623730951},"96":{"tf":2.6457513110645907},"99":{"tf":1.0}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":5,"docs":{"112":{"tf":1.0},"118":{"tf":1.0},"35":{"tf":1.4142135623730951},"72":{"tf":1.0},"96":{"tf":1.0}}}}}}}}},"x":{"8":{"6":{"_":{"6":{"4":{"df":1,"docs":{"20":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"<":{"a":{"df":1,"docs":{"94":{"tf":1.0}}},"df":0,"docs":{}},"a":{"df":1,"docs":{"59":{"tf":1.4142135623730951}}},"d":{"df":0,"docs":{},"g":{"df":1,"docs":{"24":{"tf":1.0}}}},"df":8,"docs":{"12":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.7320508075688772},"49":{"tf":1.0},"59":{"tf":1.4142135623730951},"60":{"tf":3.0},"70":{"tf":1.4142135623730951},"94":{"tf":3.1622776601683795}},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"61":{"tf":1.0}}}},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"61":{"tf":1.0}}}},"t":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"k":{"df":1,"docs":{"108":{"tf":1.0}}}}},"c":{"df":1,"docs":{"61":{"tf":1.0}}},"df":0,"docs":{}},"y":{"df":0,"docs":{},"z":{"df":0,"docs":{},"z":{"df":0,"docs":{},"i":{"df":1,"docs":{"116":{"tf":1.0}}}}}}},"y":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":5,"docs":{"100":{"tf":1.0},"105":{"tf":1.0},"116":{"tf":1.4142135623730951},"61":{"tf":2.0},"99":{"tf":1.0}}}},"n":{"df":0,"docs":{},"k":{"/":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"70":{"tf":1.0},"71":{"tf":1.0}}}}},"df":0,"docs":{}}},"_":{"df":0,"docs":{},"j":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"60":{"tf":1.0}},"e":{"d":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"b":{"df":0,"docs":{},"o":{"a":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"60":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"_":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"b":{"df":0,"docs":{},"o":{"a":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"60":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"m":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"b":{"df":0,"docs":{},"o":{"a":{"df":0,"docs":{},"r":{"d":{"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"_":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"b":{"df":0,"docs":{},"o":{"a":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"60":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"o":{"_":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"b":{"df":0,"docs":{},"o":{"a":{"df":0,"docs":{},"r":{"d":{"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"_":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"b":{"df":0,"docs":{},"o":{"a":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"60":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":12,"docs":{"29":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.4142135623730951},"35":{"tf":2.0},"45":{"tf":2.449489742783178},"48":{"tf":1.4142135623730951},"59":{"tf":3.4641016151377544},"60":{"tf":3.4641016151377544},"63":{"tf":1.0},"70":{"tf":1.4142135623730951},"71":{"tf":1.4142135623730951},"94":{"tf":1.0}}}},"r":{"a":{"df":1,"docs":{"61":{"tf":1.0}}},"df":0,"docs":{},"n":{".":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"99":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":6,"docs":{"34":{"tf":1.0},"45":{"tf":1.0},"48":{"tf":1.7320508075688772},"56":{"tf":1.4142135623730951},"57":{"tf":1.4142135623730951},"60":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"89":{"tf":1.4142135623730951}}}}}}},"l":{"df":1,"docs":{"61":{"tf":1.0}}},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"99":{"tf":1.0}}}},"o":{"df":0,"docs":{},"u":{"\'":{"df":0,"docs":{},"r":{"df":2,"docs":{"111":{"tf":1.0},"48":{"tf":1.0}}}},"df":0,"docs":{}}},"u":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"61":{"tf":1.0}}}},"df":0,"docs":{}}},"z":{"<":{"b":{"a":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"a":{"c":{"df":1,"docs":{"60":{"tf":2.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"c":{"df":1,"docs":{"60":{"tf":4.0}}},"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":1,"docs":{"60":{"tf":2.0}}}}}},"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":1,"docs":{"60":{"tf":2.0}}}}}},"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":1,"docs":{"60":{"tf":2.0}}}}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"p":{"a":{"c":{"df":0,"docs":{},"e":{"df":1,"docs":{"60":{"tf":2.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"p":{"df":1,"docs":{"60":{"tf":2.0}}}}},"b":{"df":1,"docs":{"60":{"tf":2.0}}},"c":{"df":1,"docs":{"60":{"tf":2.0}}},"df":2,"docs":{"48":{"tf":2.23606797749979},"60":{"tf":3.1622776601683795}},"e":{"d":{"df":1,"docs":{"65":{"tf":1.0}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":1,"docs":{"73":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"g":{"df":1,"docs":{"61":{"tf":1.0}}}},"j":{"df":1,"docs":{"60":{"tf":2.0}}},"k":{"df":1,"docs":{"60":{"tf":2.0}}},"l":{"df":1,"docs":{"61":{"tf":1.0}}},"m":{"df":1,"docs":{"60":{"tf":2.0}}},"n":{"df":1,"docs":{"60":{"tf":2.8284271247461903}}},"s":{"df":0,"docs":{},"h":{"df":2,"docs":{"25":{"tf":1.0},"66":{"tf":1.7320508075688772}}}},"t":{"df":1,"docs":{"60":{"tf":2.0}}},"z":{"df":1,"docs":{"60":{"tf":2.0}}}}}},"breadcrumbs":{"root":{"0":{"0":{"0":{"0":{"0":{"0":{"df":2,"docs":{"87":{"tf":1.0},"89":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":3,"docs":{"45":{"tf":1.0},"80":{"tf":1.0},"82":{"tf":1.0}}},"1":{"0":{"0":{"df":1,"docs":{"56":{"tf":1.0}}},"df":2,"docs":{"17":{"tf":1.0},"84":{"tf":1.0}}},"1":{"df":1,"docs":{"17":{"tf":1.0}}},"2":{"df":1,"docs":{"5":{"tf":1.0}}},"6":{"df":2,"docs":{"59":{"tf":1.0},"89":{"tf":1.0}}},"df":13,"docs":{"114":{"tf":1.0},"116":{"tf":2.8284271247461903},"118":{"tf":1.0},"35":{"tf":1.0},"54":{"tf":1.0},"56":{"tf":2.23606797749979},"59":{"tf":1.7320508075688772},"70":{"tf":1.0},"73":{"tf":1.4142135623730951},"80":{"tf":1.0},"81":{"tf":1.0},"84":{"tf":1.4142135623730951},"93":{"tf":1.0}}},"2":{".":{"1":{"9":{".":{"0":{"df":1,"docs":{"65":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"0":{"df":4,"docs":{"102":{"tf":1.0},"56":{"tf":1.0},"82":{"tf":1.0},"84":{"tf":1.0}}},"1":{"df":1,"docs":{"5":{"tf":1.0}}},"2":{".":{"0":{"4":{"df":1,"docs":{"5":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"5":{"0":{"df":1,"docs":{"70":{"tf":1.4142135623730951}}},"df":1,"docs":{"82":{"tf":1.0}}},"a":{"2":{"a":{"4":{"d":{"df":1,"docs":{"92":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":9,"docs":{"116":{"tf":1.0},"117":{"tf":1.0},"118":{"tf":1.0},"35":{"tf":1.0},"59":{"tf":1.4142135623730951},"70":{"tf":1.0},"73":{"tf":1.0},"93":{"tf":1.0},"99":{"tf":1.0}}},"3":{"0":{"0":{"0":{"df":1,"docs":{"77":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"2":{"df":1,"docs":{"70":{"tf":1.0}}},"5":{"0":{"df":0,"docs":{},"m":{"df":1,"docs":{"84":{"tf":1.0}}}},"df":0,"docs":{}},"df":4,"docs":{"116":{"tf":1.0},"70":{"tf":1.0},"81":{"tf":1.0},"93":{"tf":1.0}},"x":{"df":1,"docs":{"116":{"tf":1.0}}}},"4":{"0":{"df":1,"docs":{"82":{"tf":1.0}}},"df":1,"docs":{"93":{"tf":1.0}}},"5":{"1":{"df":1,"docs":{"57":{"tf":1.4142135623730951}}},"2":{"df":1,"docs":{"71":{"tf":1.0}}},"df":3,"docs":{"56":{"tf":1.0},"70":{"tf":1.4142135623730951},"93":{"tf":1.0}}},"6":{"4":{"df":1,"docs":{"20":{"tf":1.0}}},"df":1,"docs":{"93":{"tf":1.0}}},"7":{"3":{"df":1,"docs":{"57":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"8":{".":{"1":{"df":1,"docs":{"20":{"tf":1.0}}},"df":0,"docs":{}},"0":{"df":1,"docs":{"70":{"tf":1.0}}},"1":{"df":1,"docs":{"57":{"tf":1.4142135623730951}}},"df":1,"docs":{"72":{"tf":1.0}}},"_":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"_":{"_":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"116":{"tf":1.7320508075688772}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":5,"docs":{"116":{"tf":1.4142135623730951},"35":{"tf":1.0},"46":{"tf":1.4142135623730951},"60":{"tf":2.0},"93":{"tf":1.0}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":1,"docs":{"93":{"tf":1.0}}}}}},"a":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"55":{"tf":1.4142135623730951}}}}}},"2":{"5":{"0":{"c":{"4":{"5":{"8":{"2":{"5":{"1":{"0":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"3":{"4":{"7":{"6":{"7":{"df":0,"docs":{},"e":{"c":{"3":{"b":{"7":{"d":{"c":{"d":{"d":{"3":{"c":{"2":{"4":{"df":0,"docs":{},"e":{"8":{"c":{"8":{"a":{"a":{"6":{"8":{"df":1,"docs":{"104":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"b":{"c":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"j":{"df":0,"docs":{},"k":{"df":0,"docs":{},"l":{"df":0,"docs":{},"m":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"q":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"v":{"df":0,"docs":{},"w":{"df":0,"docs":{},"x":{"df":0,"docs":{},"y":{"df":0,"docs":{},"z":{"df":1,"docs":{"70":{"tf":1.0}}}}}}}}}}}}}}}}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":12,"docs":{"100":{"tf":1.7320508075688772},"115":{"tf":1.4142135623730951},"116":{"tf":1.0},"20":{"tf":1.0},"39":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"48":{"tf":1.4142135623730951},"56":{"tf":1.0},"57":{"tf":1.0},"60":{"tf":2.23606797749979},"67":{"tf":1.0}}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":6,"docs":{"100":{"tf":1.0},"109":{"tf":1.0},"114":{"tf":1.0},"24":{"tf":1.0},"70":{"tf":2.0},"72":{"tf":1.4142135623730951}}}}}}}},"c":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":7,"docs":{"48":{"tf":1.4142135623730951},"53":{"tf":1.4142135623730951},"55":{"tf":1.0},"59":{"tf":3.1622776601683795},"81":{"tf":1.0},"9":{"tf":1.0},"96":{"tf":1.0}}}},"s":{"df":0,"docs":{},"s":{"df":8,"docs":{"26":{"tf":1.0},"27":{"tf":1.4142135623730951},"40":{"tf":1.0},"48":{"tf":2.6457513110645907},"49":{"tf":1.0},"50":{"tf":1.0},"60":{"tf":1.0},"95":{"tf":1.4142135623730951}},"e":{"d":{"/":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"48":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":1,"docs":{"112":{"tf":1.0}}}}},"df":0,"docs":{}}},"r":{"d":{"df":4,"docs":{"102":{"tf":1.0},"115":{"tf":1.0},"39":{"tf":1.0},"57":{"tf":1.0}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"100":{"tf":1.0},"22":{"tf":1.0}}}}}}},"df":0,"docs":{},"t":{"df":4,"docs":{"29":{"tf":1.0},"36":{"tf":1.4142135623730951},"56":{"tf":1.0},"63":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":10,"docs":{"103":{"tf":1.7320508075688772},"29":{"tf":1.4142135623730951},"30":{"tf":1.0},"33":{"tf":1.0},"36":{"tf":1.0},"48":{"tf":1.0},"60":{"tf":1.0},"63":{"tf":1.4142135623730951},"94":{"tf":1.0},"95":{"tf":1.0}}}},"v":{"df":8,"docs":{"37":{"tf":1.0},"42":{"tf":1.0},"48":{"tf":1.0},"53":{"tf":1.0},"59":{"tf":1.0},"72":{"tf":1.4142135623730951},"73":{"tf":1.0},"93":{"tf":1.0}}}},"u":{"a":{"df":0,"docs":{},"l":{"df":3,"docs":{"114":{"tf":1.0},"116":{"tf":1.0},"118":{"tf":1.0}}}},"df":0,"docs":{}}}},"d":{"a":{"_":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{"df":1,"docs":{"61":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":1,"docs":{"61":{"tf":1.0}},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"59":{"tf":1.0}}}}},"d":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"_":{"a":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}}}}},"df":0,"docs":{}},"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}},"df":18,"docs":{"107":{"tf":1.0},"108":{"tf":1.0},"109":{"tf":1.0},"110":{"tf":1.0},"111":{"tf":1.0},"12":{"tf":1.0},"2":{"tf":1.0},"22":{"tf":1.0},"36":{"tf":1.0},"46":{"tf":1.4142135623730951},"48":{"tf":1.4142135623730951},"50":{"tf":1.0},"6":{"tf":1.4142135623730951},"60":{"tf":2.23606797749979},"70":{"tf":1.0},"76":{"tf":1.0},"85":{"tf":1.0},"89":{"tf":1.0}},"i":{"df":0,"docs":{},"t":{"df":3,"docs":{"116":{"tf":1.0},"119":{"tf":1.0},"93":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":4,"docs":{"117":{"tf":1.0},"75":{"tf":1.0},"76":{"tf":1.0},"8":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":3,"docs":{"116":{"tf":1.0},"59":{"tf":1.0},"64":{"tf":1.0}}}}}}},"df":22,"docs":{"100":{"tf":1.0},"106":{"tf":1.0},"107":{"tf":1.7320508075688772},"108":{"tf":2.0},"109":{"tf":1.0},"110":{"tf":1.0},"111":{"tf":1.0},"112":{"tf":1.7320508075688772},"113":{"tf":1.0},"114":{"tf":2.23606797749979},"115":{"tf":1.0},"116":{"tf":1.4142135623730951},"117":{"tf":1.0},"118":{"tf":1.7320508075688772},"119":{"tf":1.7320508075688772},"120":{"tf":1.0},"121":{"tf":1.0},"122":{"tf":1.0},"61":{"tf":1.0},"81":{"tf":1.0},"95":{"tf":1.0},"99":{"tf":1.0}},"l":{"df":1,"docs":{"61":{"tf":1.0}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"22":{"tf":1.0}}}}}}}}},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"64":{"tf":1.0}}}}},"v":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"1":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"103":{"tf":1.0},"50":{"tf":1.0}}}},"df":0,"docs":{}}}},"g":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"100":{"tf":1.0},"99":{"tf":1.0}}}}}}},"d":{"a":{"df":1,"docs":{"61":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"h":{"a":{"df":1,"docs":{"118":{"tf":1.0}}},"df":0,"docs":{}},"l":{"df":1,"docs":{"120":{"tf":1.0}},"i":{"a":{"df":1,"docs":{"94":{"tf":1.0}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"46":{"tf":1.0},"60":{"tf":1.0}}}},"df":0,"docs":{}}}}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"_":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}}}}}}}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"d":{"d":{"df":0,"docs":{},"l":{"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}},"df":5,"docs":{"116":{"tf":2.449489742783178},"46":{"tf":1.0},"48":{"tf":1.7320508075688772},"60":{"tf":2.23606797749979},"72":{"tf":1.7320508075688772}}}}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":13,"docs":{"112":{"tf":1.0},"117":{"tf":1.0},"119":{"tf":1.4142135623730951},"2":{"tf":1.0},"33":{"tf":1.0},"37":{"tf":1.0},"39":{"tf":1.0},"50":{"tf":1.0},"64":{"tf":1.0},"72":{"tf":1.0},"84":{"tf":1.0},"94":{"tf":1.0},"99":{"tf":1.0}}},"y":{"df":1,"docs":{"61":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"115":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"h":{"a":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"70":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":0,"docs":{},"i":{"df":7,"docs":{"100":{"tf":1.0},"113":{"tf":1.0},"114":{"tf":1.4142135623730951},"17":{"tf":1.0},"46":{"tf":1.0},"60":{"tf":2.23606797749979},"75":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"t":{"+":{"df":0,"docs":{},"o":{"df":1,"docs":{"94":{"tf":1.0}}}},"df":12,"docs":{"37":{"tf":1.4142135623730951},"39":{"tf":3.0},"44":{"tf":1.0},"45":{"tf":2.6457513110645907},"46":{"tf":5.0},"47":{"tf":1.0},"48":{"tf":1.7320508075688772},"49":{"tf":1.7320508075688772},"51":{"tf":1.0},"52":{"tf":2.23606797749979},"94":{"tf":1.7320508075688772},"96":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"55":{"tf":1.0}},"n":{"df":2,"docs":{"68":{"tf":1.0},"71":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"76":{"tf":1.0}}}}}}}},"w":{"a":{"df":0,"docs":{},"y":{"df":7,"docs":{"100":{"tf":1.0},"116":{"tf":1.4142135623730951},"118":{"tf":1.0},"22":{"tf":1.0},"54":{"tf":1.4142135623730951},"70":{"tf":1.4142135623730951},"83":{"tf":1.0}}}},"df":0,"docs":{}}},"m":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"61":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"e":{"b":{"a":{"df":1,"docs":{"61":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"n":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"y":{"df":0,"docs":{},"z":{"df":1,"docs":{"61":{"tf":1.7320508075688772}}}}}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"116":{"tf":2.0}}}}}}},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":3,"docs":{"116":{"tf":2.0},"46":{"tf":1.0},"60":{"tf":2.0}}}}}},"d":{"/":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"72":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"65":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":1,"docs":{"93":{"tf":1.0}}}},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":3,"docs":{"119":{"tf":1.0},"24":{"tf":1.0},"60":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"61":{"tf":1.0}}}},"df":0,"docs":{}}},"y":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"56":{"tf":1.0}}}},"w":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"117":{"tf":1.0}}}}}}}},"p":{"df":0,"docs":{},"i":{"df":1,"docs":{"70":{"tf":1.0}}},"p":{"d":{"a":{"df":0,"docs":{},"t":{"a":{"%":{"\\\\":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"\\\\":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"68":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"75":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"86":{"tf":1.0}}}}}}},"df":1,"docs":{"22":{"tf":1.4142135623730951}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":1,"docs":{"17":{"tf":1.4142135623730951}},"e":{"a":{"df":0,"docs":{},"r":{"df":3,"docs":{"117":{"tf":1.0},"72":{"tf":1.0},"73":{"tf":1.0}}}},"df":0,"docs":{},"n":{"d":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"d":{"df":2,"docs":{"45":{"tf":1.0},"60":{"tf":1.0}}},"df":0,"docs":{}}}},"df":4,"docs":{"45":{"tf":1.4142135623730951},"57":{"tf":1.0},"59":{"tf":1.4142135623730951},"60":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"g":{"df":2,"docs":{"12":{"tf":2.6457513110645907},"3":{"tf":1.0}}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"24":{"tf":1.0}}},"df":5,"docs":{"116":{"tf":1.4142135623730951},"118":{"tf":1.7320508075688772},"41":{"tf":1.0},"48":{"tf":1.0},"70":{"tf":1.0}}}},"r":{"df":0,"docs":{},"o":{"a":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"70":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"61":{"tf":1.0}}}}}}}},"t":{"df":1,"docs":{"6":{"tf":1.7320508075688772}}}},"r":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"71":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"c":{"df":0,"docs":{},"h":{"df":2,"docs":{"3":{"tf":1.0},"8":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"e":{"a":{"df":2,"docs":{"72":{"tf":1.0},"93":{"tf":3.0}}},"df":0,"docs":{}},"g":{"1":{"df":2,"docs":{"117":{"tf":1.0},"39":{"tf":2.6457513110645907}}},"2":{"df":2,"docs":{"117":{"tf":1.0},"39":{"tf":2.8284271247461903}}},"3":{"df":1,"docs":{"39":{"tf":2.6457513110645907}}},"df":5,"docs":{"101":{"tf":1.0},"102":{"tf":1.4142135623730951},"61":{"tf":1.4142135623730951},"71":{"tf":2.0},"99":{"tf":1.0}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"/":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":2,"docs":{"37":{"tf":1.0},"48":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":14,"docs":{"101":{"tf":1.4142135623730951},"102":{"tf":1.0},"117":{"tf":3.4641016151377544},"122":{"tf":2.449489742783178},"39":{"tf":2.0},"53":{"tf":1.4142135623730951},"54":{"tf":2.23606797749979},"55":{"tf":1.4142135623730951},"56":{"tf":1.4142135623730951},"57":{"tf":2.6457513110645907},"59":{"tf":2.8284271247461903},"60":{"tf":1.0},"68":{"tf":1.0},"99":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":5,"docs":{"37":{"tf":1.0},"48":{"tf":1.0},"60":{"tf":1.0},"70":{"tf":1.4142135623730951},"78":{"tf":1.0}}},"df":0,"docs":{}}}},"r":{"a":{"df":0,"docs":{},"y":{"df":4,"docs":{"103":{"tf":1.4142135623730951},"57":{"tf":1.0},"81":{"tf":1.0},"99":{"tf":2.0}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":2,"docs":{"39":{"tf":1.0},"83":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"56":{"tf":1.0}}},"df":0,"docs":{}},"m":{"df":1,"docs":{"61":{"tf":1.4142135623730951}}},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":4,"docs":{"114":{"tf":1.0},"21":{"tf":1.0},"9":{"tf":1.0},"99":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":1,"docs":{"61":{"tf":1.4142135623730951}}}}}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":2,"docs":{"70":{"tf":1.4142135623730951},"93":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"111":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":5,"docs":{"103":{"tf":1.4142135623730951},"61":{"tf":1.0},"81":{"tf":1.0},"9":{"tf":1.0},"93":{"tf":1.7320508075688772}}}}},"df":0,"docs":{}}}}},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"8":{"tf":1.0}}},"t":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":3,"docs":{"49":{"tf":1.0},"70":{"tf":1.0},"93":{"tf":1.0}}}}}}}}},"df":9,"docs":{"57":{"tf":1.4142135623730951},"61":{"tf":1.0},"70":{"tf":2.0},"73":{"tf":1.0},"76":{"tf":2.0},"77":{"tf":1.7320508075688772},"83":{"tf":1.0},"98":{"tf":1.4142135623730951},"99":{"tf":1.0}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"99":{"tf":1.0}}}},"df":0,"docs":{}}}}},"m":{"a":{"df":0,"docs":{},"t":{"df":10,"docs":{"100":{"tf":1.4142135623730951},"113":{"tf":1.0},"47":{"tf":1.0},"60":{"tf":1.0},"70":{"tf":2.8284271247461903},"73":{"tf":1.0},"76":{"tf":1.0},"77":{"tf":1.4142135623730951},"84":{"tf":1.0},"9":{"tf":1.0}}}},"df":0,"docs":{}}}}},"v":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":14,"docs":{"0":{"tf":1.0},"10":{"tf":1.0},"102":{"tf":1.0},"109":{"tf":1.0},"11":{"tf":1.0},"17":{"tf":1.0},"4":{"tf":1.0},"70":{"tf":1.4142135623730951},"8":{"tf":1.4142135623730951},"9":{"tf":1.4142135623730951},"90":{"tf":1.0},"93":{"tf":1.0},"94":{"tf":1.7320508075688772},"99":{"tf":1.0}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"24":{"tf":1.0}}},"df":0,"docs":{}}}},"w":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"39":{"tf":1.7320508075688772}}},"y":{"df":1,"docs":{"77":{"tf":1.0}}}},"df":0,"docs":{},"k":{"df":1,"docs":{"61":{"tf":1.4142135623730951}}}},"y":{"df":1,"docs":{"33":{"tf":1.0}}}},"b":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"54":{"tf":1.7320508075688772}}}}}},"a":{"c":{"df":0,"docs":{},"k":{"df":3,"docs":{"45":{"tf":1.0},"48":{"tf":1.4142135623730951},"59":{"tf":1.0}},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":3,"docs":{"51":{"tf":1.0},"87":{"tf":1.0},"93":{"tf":1.0}}},"df":0,"docs":{}}}}}},"s":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"54":{"tf":2.0}}}}},"df":0,"docs":{}},"p":{"a":{"c":{"df":4,"docs":{"49":{"tf":1.7320508075688772},"52":{"tf":2.0},"60":{"tf":1.7320508075688772},"96":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}}},"t":{"a":{"b":{"df":1,"docs":{"52":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"k":{"df":2,"docs":{"54":{"tf":1.4142135623730951},"56":{"tf":1.0}}}},"df":0,"docs":{}}},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":8,"docs":{"44":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.4142135623730951},"49":{"tf":1.0},"52":{"tf":1.4142135623730951},"60":{"tf":2.0},"90":{"tf":1.0},"99":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{},"r":{"df":7,"docs":{"116":{"tf":1.4142135623730951},"57":{"tf":1.0},"59":{"tf":1.0},"68":{"tf":1.0},"74":{"tf":1.0},"81":{"tf":1.0},"84":{"tf":1.7320508075688772}}},"s":{"df":0,"docs":{},"e":{"1":{"6":{"_":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"86":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":8,"docs":{"100":{"tf":1.0},"113":{"tf":1.7320508075688772},"37":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.7320508075688772},"70":{"tf":1.0},"72":{"tf":1.0},"93":{"tf":1.4142135623730951}},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"72":{"tf":1.0}}}},"df":0,"docs":{}}},"h":{"df":4,"docs":{"119":{"tf":1.4142135623730951},"25":{"tf":1.0},"61":{"tf":1.7320508075688772},"99":{"tf":1.0}},"r":{"c":{"df":1,"docs":{"22":{"tf":1.0}}},"df":0,"docs":{}}},"s":{"df":1,"docs":{"61":{"tf":1.4142135623730951}}}},"z":{"df":2,"docs":{"116":{"tf":1.4142135623730951},"84":{"tf":1.4142135623730951}}}},"c":{"a":{"df":1,"docs":{"59":{"tf":1.4142135623730951}}},"df":2,"docs":{"56":{"tf":1.4142135623730951},"59":{"tf":1.4142135623730951}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"59":{"tf":1.4142135623730951}}}},"df":1,"docs":{"59":{"tf":1.4142135623730951}},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"59":{"tf":1.4142135623730951}}}}}}}}},"o":{"df":1,"docs":{"59":{"tf":1.4142135623730951}}}},"df":6,"docs":{"44":{"tf":1.7320508075688772},"46":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":2.0},"52":{"tf":1.4142135623730951},"60":{"tf":3.605551275463989}},"e":{"_":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"_":{"d":{"a":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{"(":{"1":{"df":1,"docs":{"118":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"a":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"61":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":2,"docs":{"116":{"tf":1.0},"49":{"tf":1.0}}}}},"df":6,"docs":{"116":{"tf":1.0},"32":{"tf":1.0},"48":{"tf":1.0},"70":{"tf":1.0},"73":{"tf":1.0},"87":{"tf":1.0}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":16,"docs":{"105":{"tf":1.0},"109":{"tf":1.0},"116":{"tf":1.0},"22":{"tf":1.0},"33":{"tf":1.0},"39":{"tf":1.0},"45":{"tf":1.7320508075688772},"48":{"tf":1.0},"50":{"tf":1.0},"56":{"tf":1.0},"59":{"tf":2.23606797749979},"60":{"tf":2.23606797749979},"70":{"tf":1.7320508075688772},"77":{"tf":1.0},"82":{"tf":1.0},"84":{"tf":1.0}},"e":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"86":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":4,"docs":{"114":{"tf":1.4142135623730951},"116":{"tf":1.0},"54":{"tf":1.0},"60":{"tf":1.4142135623730951}}}}},"h":{"a":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":8,"docs":{"35":{"tf":1.0},"39":{"tf":1.0},"53":{"tf":1.0},"55":{"tf":1.0},"57":{"tf":1.0},"77":{"tf":1.0},"81":{"tf":1.0},"90":{"tf":1.0}}}}}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"48":{"tf":1.0}}}},"w":{"df":18,"docs":{"104":{"tf":1.0},"107":{"tf":1.0},"115":{"tf":1.0},"116":{"tf":1.0},"21":{"tf":1.0},"22":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"48":{"tf":1.4142135623730951},"53":{"tf":1.0},"60":{"tf":2.23606797749979},"73":{"tf":1.4142135623730951},"79":{"tf":1.0},"84":{"tf":1.0},"87":{"tf":1.0},"89":{"tf":1.0},"93":{"tf":1.0},"99":{"tf":1.7320508075688772}}}}},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"92":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"73":{"tf":1.0}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":6,"docs":{"114":{"tf":1.0},"28":{"tf":1.0},"38":{"tf":1.0},"57":{"tf":1.0},"60":{"tf":1.0},"72":{"tf":1.4142135623730951}}}}}}}},"g":{"df":2,"docs":{"87":{"tf":1.7320508075688772},"93":{"tf":1.0}}},"i":{"b":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":1,"docs":{"61":{"tf":1.0}}}}}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":1,"docs":{"61":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":4,"docs":{"102":{"tf":1.7320508075688772},"2":{"tf":2.23606797749979},"22":{"tf":1.0},"25":{"tf":1.4142135623730951}}}}},"d":{"df":5,"docs":{"38":{"tf":1.0},"49":{"tf":1.4142135623730951},"83":{"tf":1.4142135623730951},"95":{"tf":1.4142135623730951},"96":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"t":{"b":{"a":{"df":0,"docs":{},"k":{"df":1,"docs":{"61":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":2,"docs":{"20":{"tf":1.0},"73":{"tf":1.0}}}},"l":{"a":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"89":{"tf":1.7320508075688772}}}},"d":{"df":0,"docs":{},"e":{"df":1,"docs":{"61":{"tf":1.0}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":1,"docs":{"56":{"tf":1.4142135623730951}}}},"n":{"df":0,"docs":{},"k":{"df":1,"docs":{"60":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"d":{"df":1,"docs":{"0":{"tf":1.0}}},"df":0,"docs":{}}},"o":{"c":{"df":0,"docs":{},"k":{"_":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":1,"docs":{"116":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"116":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}},"df":9,"docs":{"116":{"tf":1.7320508075688772},"118":{"tf":1.4142135623730951},"37":{"tf":1.4142135623730951},"48":{"tf":1.0},"60":{"tf":1.0},"68":{"tf":1.0},"74":{"tf":2.0},"93":{"tf":2.0},"99":{"tf":1.0}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"e":{"df":1,"docs":{"89":{"tf":1.4142135623730951}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"61":{"tf":1.4142135623730951}}}}}}}}}},"n":{"df":1,"docs":{"59":{"tf":1.0}},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"59":{"tf":1.0}}}}}},"o":{"d":{"df":0,"docs":{},"i":{"df":1,"docs":{"93":{"tf":1.0}}}},"df":0,"docs":{},"l":{"d":{"df":3,"docs":{"87":{"tf":1.0},"90":{"tf":1.0},"93":{"tf":1.0}}},"df":0,"docs":{}},"o":{"_":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"92":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"n":{"df":3,"docs":{"57":{"tf":1.0},"76":{"tf":1.0},"93":{"tf":1.0}}}},"df":0,"docs":{}}}},"r":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"70":{"tf":1.4142135623730951}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"93":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"h":{"df":4,"docs":{"11":{"tf":1.0},"116":{"tf":1.4142135623730951},"120":{"tf":1.0},"70":{"tf":1.0}}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":3,"docs":{"48":{"tf":1.7320508075688772},"60":{"tf":2.0},"72":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"n":{"d":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"47":{"tf":1.0},"60":{"tf":1.0}}}}},"df":5,"docs":{"46":{"tf":1.4142135623730951},"60":{"tf":2.0},"83":{"tf":1.0},"94":{"tf":1.0},"95":{"tf":1.0}}},"df":0,"docs":{}}},"x":{"df":3,"docs":{"22":{"tf":1.0},"70":{"tf":1.0},"93":{"tf":1.4142135623730951}}}},"p":{"df":1,"docs":{"59":{"tf":1.0}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":1,"docs":{"59":{"tf":1.0}}}}}},"r":{"a":{"c":{"df":0,"docs":{},"e":{"df":2,"docs":{"116":{"tf":1.0},"118":{"tf":1.4142135623730951}}},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":5,"docs":{"36":{"tf":1.0},"48":{"tf":1.0},"60":{"tf":1.0},"76":{"tf":1.0},"93":{"tf":2.0}}}}}},"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"h":{"df":3,"docs":{"111":{"tf":1.0},"72":{"tf":1.0},"8":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"k":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":3,"docs":{"60":{"tf":2.23606797749979},"70":{"tf":1.0},"93":{"tf":1.0}}}}}}}}},"df":0,"docs":{},"w":{"df":1,"docs":{"14":{"tf":1.0}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"48":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"f":{"df":1,"docs":{"61":{"tf":1.0}},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"\'":{"df":1,"docs":{"60":{"tf":1.4142135623730951}}},"_":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":3,"docs":{"101":{"tf":1.4142135623730951},"56":{"tf":1.4142135623730951},"99":{"tf":1.0}},"e":{"df":0,"docs":{},"}":{":":{"%":{"df":0,"docs":{},"{":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"n":{"df":1,"docs":{"57":{"tf":1.0}}}}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"56":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"k":{"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":9,"docs":{"28":{"tf":2.6457513110645907},"48":{"tf":1.7320508075688772},"56":{"tf":1.0},"59":{"tf":5.656854249492381},"60":{"tf":2.23606797749979},"70":{"tf":1.7320508075688772},"72":{"tf":1.0},"93":{"tf":1.7320508075688772},"99":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"70":{"tf":1.0},"93":{"tf":1.0}}}}}}}}},"g":{"df":3,"docs":{"64":{"tf":1.0},"65":{"tf":1.0},"73":{"tf":1.0}}},"i":{"df":0,"docs":{},"l":{"d":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"f":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"21":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}},"_":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"/":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"r":{"/":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"/":{"df":0,"docs":{},"h":{"df":0,"docs":{},"x":{"df":1,"docs":{"22":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"b":{"/":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"df":1,"docs":{"22":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":12,"docs":{"1":{"tf":1.0},"104":{"tf":1.0},"105":{"tf":1.0},"111":{"tf":1.4142135623730951},"21":{"tf":2.8284271247461903},"22":{"tf":2.23606797749979},"23":{"tf":1.0},"24":{"tf":1.0},"25":{"tf":2.8284271247461903},"5":{"tf":1.0},"8":{"tf":1.0},"95":{"tf":1.0}}},"df":0,"docs":{},"t":{"df":9,"docs":{"104":{"tf":1.0},"105":{"tf":1.4142135623730951},"2":{"tf":1.7320508075688772},"36":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.0},"68":{"tf":1.0},"86":{"tf":1.0},"98":{"tf":1.4142135623730951}},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"71":{"tf":1.0},"93":{"tf":2.23606797749979}}}}}}}},"y":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"56":{"tf":1.0}}}}}},"c":{"\\"":{"]":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"70":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"+":{"+":{"1":{"4":{"df":1,"docs":{"21":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},":":{"\\\\":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"\\\\":{"df":0,"docs":{},"y":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"22":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"a":{"b":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"61":{"tf":1.0}}}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"9":{"tf":1.7320508075688772}},"i":{"df":0,"docs":{},"x":{"df":1,"docs":{"9":{"tf":1.7320508075688772}}}}}},"d":{"d":{"df":0,"docs":{},"y":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"61":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":1,"docs":{"61":{"tf":1.4142135623730951}}}}},"l":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":2,"docs":{"114":{"tf":1.0},"56":{"tf":1.0}}}}},"df":0,"docs":{},"l":{"df":3,"docs":{"39":{"tf":2.0},"55":{"tf":1.0},"89":{"tf":1.0}}}},"n":{"\'":{"df":0,"docs":{},"t":{"df":1,"docs":{"96":{"tf":1.0}}}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"118":{"tf":1.0}}}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":1,"docs":{"61":{"tf":1.0}}}},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":11,"docs":{"110":{"tf":1.0},"112":{"tf":1.7320508075688772},"113":{"tf":1.7320508075688772},"114":{"tf":1.7320508075688772},"115":{"tf":1.4142135623730951},"116":{"tf":3.4641016151377544},"117":{"tf":2.8284271247461903},"118":{"tf":1.7320508075688772},"120":{"tf":2.6457513110645907},"121":{"tf":1.0},"122":{"tf":2.0}}}}}},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{".":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"99":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"100":{"tf":1.0}}}}}}},"/":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"/":{"df":0,"docs":{},"h":{"df":0,"docs":{},"x":{"df":1,"docs":{"24":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"_":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":1,"docs":{"22":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}},"df":5,"docs":{"108":{"tf":1.0},"21":{"tf":1.4142135623730951},"22":{"tf":1.4142135623730951},"25":{"tf":2.449489742783178},"95":{"tf":1.4142135623730951}}}},"r":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"56":{"tf":1.0}}}},"df":3,"docs":{"33":{"tf":1.0},"82":{"tf":1.0},"9":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"e":{"df":11,"docs":{"103":{"tf":1.4142135623730951},"116":{"tf":2.23606797749979},"117":{"tf":1.0},"118":{"tf":1.0},"39":{"tf":1.0},"45":{"tf":1.7320508075688772},"59":{"tf":2.0},"60":{"tf":1.0},"64":{"tf":1.7320508075688772},"78":{"tf":2.0},"99":{"tf":1.0}}}},"t":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"116":{"tf":1.0}}}},"df":1,"docs":{"71":{"tf":1.4142135623730951}}},"u":{"df":0,"docs":{},"s":{"df":3,"docs":{"111":{"tf":1.0},"116":{"tf":1.0},"55":{"tf":1.0}}}}},"d":{"df":3,"docs":{"21":{"tf":1.0},"22":{"tf":1.0},"59":{"tf":1.0}}},"df":18,"docs":{"105":{"tf":1.0},"21":{"tf":1.4142135623730951},"30":{"tf":1.0},"37":{"tf":1.0},"45":{"tf":1.4142135623730951},"46":{"tf":1.7320508075688772},"48":{"tf":2.8284271247461903},"51":{"tf":1.0},"52":{"tf":1.0},"60":{"tf":10.816653826391969},"61":{"tf":1.4142135623730951},"68":{"tf":1.4142135623730951},"70":{"tf":1.0},"83":{"tf":1.0},"93":{"tf":1.4142135623730951},"94":{"tf":2.6457513110645907},"95":{"tf":1.0},"96":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"61":{"tf":1.0}}},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"48":{"tf":1.0},"60":{"tf":1.4142135623730951},"72":{"tf":1.7320508075688772}}}}}},"r":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":3,"docs":{"103":{"tf":1.0},"54":{"tf":1.0},"64":{"tf":1.0}}}}},"df":0,"docs":{}}}},"h":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":20,"docs":{"116":{"tf":1.0},"12":{"tf":1.0},"29":{"tf":1.0},"30":{"tf":1.0},"33":{"tf":1.4142135623730951},"36":{"tf":1.0},"37":{"tf":1.0},"42":{"tf":1.0},"45":{"tf":2.449489742783178},"48":{"tf":2.449489742783178},"49":{"tf":1.0},"50":{"tf":1.4142135623730951},"52":{"tf":1.0},"59":{"tf":4.898979485566356},"60":{"tf":3.1622776601683795},"63":{"tf":1.0},"72":{"tf":1.0},"74":{"tf":1.0},"81":{"tf":1.0},"93":{"tf":1.0}},"e":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"45":{"tf":1.0},"60":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"y":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":2,"docs":{"45":{"tf":1.0},"60":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"d":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"k":{"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{".":{"df":0,"docs":{},"m":{"d":{"df":1,"docs":{"54":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"9":{"tf":1.0}}}}}},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":21,"docs":{"31":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":2.0},"45":{"tf":1.0},"48":{"tf":1.7320508075688772},"54":{"tf":2.449489742783178},"55":{"tf":1.0},"56":{"tf":2.449489742783178},"57":{"tf":1.4142135623730951},"59":{"tf":1.4142135623730951},"60":{"tf":1.4142135623730951},"70":{"tf":2.0},"72":{"tf":1.4142135623730951},"76":{"tf":1.0},"78":{"tf":1.0},"79":{"tf":2.0},"80":{"tf":2.0},"81":{"tf":1.0},"83":{"tf":1.0},"93":{"tf":1.7320508075688772}}}},"df":0,"docs":{}},"df":7,"docs":{"44":{"tf":2.0},"47":{"tf":1.0},"48":{"tf":2.0},"49":{"tf":2.0},"52":{"tf":2.23606797749979},"59":{"tf":1.0},"60":{"tf":3.605551275463989}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"df":6,"docs":{"100":{"tf":1.0},"23":{"tf":1.7320508075688772},"42":{"tf":1.0},"61":{"tf":1.0},"8":{"tf":1.0},"93":{"tf":1.0}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"99":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"49":{"tf":1.0},"60":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"l":{"d":{"_":{"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"117":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":2,"docs":{"121":{"tf":1.7320508075688772},"39":{"tf":1.0}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":3,"docs":{"121":{"tf":1.7320508075688772},"46":{"tf":1.0},"60":{"tf":1.0}}}}}},"df":0,"docs":{}}},"m":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"12":{"tf":1.0}}},"df":0,"docs":{}}},"o":{"c":{"df":0,"docs":{},"o":{"df":1,"docs":{"19":{"tf":1.0}},"l":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":3,"docs":{"16":{"tf":1.0},"19":{"tf":1.4142135623730951},"3":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"21":{"tf":1.0}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"s":{"df":2,"docs":{"105":{"tf":1.4142135623730951},"120":{"tf":1.0}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"70":{"tf":1.0}}}}}}},"i":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"l":{"df":1,"docs":{"56":{"tf":2.0}}},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"61":{"tf":1.4142135623730951}}}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"73":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"l":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"d":{"df":1,"docs":{"61":{"tf":1.7320508075688772}}},"df":1,"docs":{"21":{"tf":1.0}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"61":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"61":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"s":{".":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"112":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"112":{"tf":1.0}}},"df":0,"docs":{}}}}}},"_":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"116":{"tf":1.7320508075688772}}}}}}}}},"df":0,"docs":{}},"df":5,"docs":{"112":{"tf":1.0},"116":{"tf":2.23606797749979},"37":{"tf":1.0},"38":{"tf":1.0},"93":{"tf":1.7320508075688772}},"i":{"c":{"df":1,"docs":{"11":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":1,"docs":{"61":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"59":{"tf":2.0}}}},"df":0,"docs":{}},"i":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"70":{"tf":1.4142135623730951}}}},"df":1,"docs":{"9":{"tf":1.0}},"p":{"b":{"df":0,"docs":{},"o":{"a":{"df":0,"docs":{},"r":{"d":{"df":7,"docs":{"32":{"tf":1.0},"35":{"tf":2.6457513110645907},"48":{"tf":2.23606797749979},"59":{"tf":4.795831523312719},"60":{"tf":3.4641016151377544},"70":{"tf":1.4142135623730951},"71":{"tf":1.7320508075688772}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":1,"docs":{"70":{"tf":1.0}}}},"o":{"df":0,"docs":{},"j":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":2,"docs":{"61":{"tf":1.4142135623730951},"93":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"e":{"df":3,"docs":{"104":{"tf":1.0},"21":{"tf":1.7320508075688772},"25":{"tf":1.0}}}},"s":{"df":0,"docs":{},"e":{"df":8,"docs":{"116":{"tf":1.0},"118":{"tf":1.4142135623730951},"48":{"tf":2.0},"51":{"tf":1.4142135623730951},"52":{"tf":1.0},"56":{"tf":1.0},"59":{"tf":5.0990195135927845},"60":{"tf":1.4142135623730951}},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"36":{"tf":1.4142135623730951},"37":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"56":{"tf":1.0}}}}}}}},"m":{"a":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":1,"docs":{"61":{"tf":1.4142135623730951}}}}},"d":{"df":3,"docs":{"22":{"tf":1.7320508075688772},"70":{"tf":1.0},"96":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"o":{"d":{"df":0,"docs":{},"e":{"_":{"a":{"c":{"df":0,"docs":{},"t":{"df":4,"docs":{"48":{"tf":1.0},"60":{"tf":1.0},"94":{"tf":1.0},"95":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":12,"docs":{"103":{"tf":1.7320508075688772},"112":{"tf":1.0},"22":{"tf":1.0},"37":{"tf":1.0},"48":{"tf":1.0},"59":{"tf":2.0},"60":{"tf":1.0},"65":{"tf":1.7320508075688772},"93":{"tf":1.4142135623730951},"94":{"tf":1.7320508075688772},"95":{"tf":1.0},"98":{"tf":1.0}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"65":{"tf":1.4142135623730951},"67":{"tf":1.0}}}}}}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"56":{"tf":1.4142135623730951}}}}}}},"q":{"df":0,"docs":{},"l":{"df":1,"docs":{"61":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"s":{"df":2,"docs":{"46":{"tf":1.0},"60":{"tf":1.0}},"e":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"46":{"tf":1.0},"60":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"115":{"tf":1.0}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"93":{"tf":1.0}}},"r":{"df":7,"docs":{"70":{"tf":2.0},"73":{"tf":1.7320508075688772},"81":{"tf":1.4142135623730951},"87":{"tf":2.0},"89":{"tf":2.449489742783178},"92":{"tf":1.0},"93":{"tf":1.4142135623730951}}}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"n":{"df":7,"docs":{"41":{"tf":2.0},"46":{"tf":1.0},"48":{"tf":1.0},"56":{"tf":1.0},"60":{"tf":1.7320508075688772},"70":{"tf":1.4142135623730951},"93":{"tf":2.8284271247461903}}}}}},"m":{".":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"_":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{".":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"df":1,"docs":{"10":{"tf":1.4142135623730951}}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":5,"docs":{"115":{"tf":1.0},"116":{"tf":1.7320508075688772},"70":{"tf":1.0},"94":{"tf":1.0},"96":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":3,"docs":{"105":{"tf":1.0},"29":{"tf":1.0},"63":{"tf":1.0}}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"49":{"tf":1.0}}}}}},"m":{"a":{"df":1,"docs":{"93":{"tf":1.0}},"n":{"d":{"\'":{"df":1,"docs":{"55":{"tf":1.0}}},"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"d":{"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}}},"df":0,"docs":{}}},"p":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":40,"docs":{"101":{"tf":2.23606797749979},"102":{"tf":1.7320508075688772},"103":{"tf":1.7320508075688772},"108":{"tf":1.0},"111":{"tf":1.0},"17":{"tf":1.0},"2":{"tf":1.0},"21":{"tf":1.0},"22":{"tf":1.4142135623730951},"25":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0},"31":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.4142135623730951},"44":{"tf":1.0},"45":{"tf":2.8284271247461903},"46":{"tf":1.0},"47":{"tf":1.4142135623730951},"48":{"tf":3.3166247903554},"49":{"tf":1.4142135623730951},"53":{"tf":3.1622776601683795},"54":{"tf":1.7320508075688772},"55":{"tf":2.23606797749979},"56":{"tf":3.0},"57":{"tf":3.4641016151377544},"58":{"tf":2.23606797749979},"59":{"tf":3.872983346207417},"60":{"tf":3.7416573867739413},"68":{"tf":1.7320508075688772},"70":{"tf":1.7320508075688772},"71":{"tf":2.6457513110645907},"83":{"tf":1.4142135623730951},"93":{"tf":2.0},"94":{"tf":3.605551275463989},"95":{"tf":1.7320508075688772},"96":{"tf":1.7320508075688772},"98":{"tf":1.0},"99":{"tf":1.7320508075688772}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{".":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"112":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"112":{"tf":1.0}}},"df":0,"docs":{}}}}}},"/":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":3,"docs":{"46":{"tf":1.0},"48":{"tf":1.7320508075688772},"60":{"tf":1.7320508075688772}}}}},"df":0,"docs":{}}}},"df":10,"docs":{"119":{"tf":2.0},"37":{"tf":1.0},"48":{"tf":1.4142135623730951},"60":{"tf":1.4142135623730951},"61":{"tf":1.0},"65":{"tf":1.0},"67":{"tf":1.0},"70":{"tf":1.7320508075688772},"93":{"tf":2.449489742783178},"99":{"tf":2.8284271247461903}}}}},"i":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"o":{"_":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"49":{"tf":1.0},"60":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":5,"docs":{"104":{"tf":1.0},"49":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0},"72":{"tf":1.0}}}},"o":{"df":0,"docs":{},"n":{"df":3,"docs":{"0":{"tf":1.0},"111":{"tf":1.4142135623730951},"61":{"tf":1.0}}}},"u":{"df":0,"docs":{},"n":{"df":1,"docs":{"71":{"tf":1.0}}}}},"p":{"a":{"df":0,"docs":{},"t":{"df":3,"docs":{"21":{"tf":1.0},"90":{"tf":1.0},"99":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":5,"docs":{"104":{"tf":1.0},"111":{"tf":1.0},"21":{"tf":2.0},"22":{"tf":1.0},"61":{"tf":1.0}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":13,"docs":{"103":{"tf":1.4142135623730951},"25":{"tf":1.0},"42":{"tf":1.0},"48":{"tf":2.449489742783178},"49":{"tf":1.0},"52":{"tf":1.4142135623730951},"55":{"tf":1.0},"60":{"tf":1.4142135623730951},"70":{"tf":3.3166247903554},"73":{"tf":1.4142135623730951},"83":{"tf":1.0},"93":{"tf":2.8284271247461903},"99":{"tf":1.4142135623730951}}}}},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"81":{"tf":1.4142135623730951}}},"s":{"df":1,"docs":{"61":{"tf":1.4142135623730951}},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"93":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"114":{"tf":1.0},"70":{"tf":1.4142135623730951}}}}}},"n":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"60":{"tf":1.0},"93":{"tf":1.0}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":6,"docs":{"49":{"tf":1.0},"59":{"tf":1.4142135623730951},"68":{"tf":2.0},"85":{"tf":1.0},"94":{"tf":1.0},"99":{"tf":1.0}}}}}}},"/":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"/":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":2,"docs":{"68":{"tf":1.0},"94":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"75":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":3,"docs":{"112":{"tf":1.0},"2":{"tf":1.0},"22":{"tf":1.0}}}}}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"86":{"tf":1.0}}}}}}},"df":2,"docs":{"22":{"tf":1.0},"94":{"tf":1.0}}}}}}}},"_":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{">":{"/":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"/":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"98":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":18,"docs":{"100":{"tf":2.23606797749979},"102":{"tf":2.0},"21":{"tf":1.4142135623730951},"22":{"tf":1.0},"57":{"tf":2.23606797749979},"59":{"tf":2.6457513110645907},"61":{"tf":1.0},"65":{"tf":2.0},"68":{"tf":2.6457513110645907},"70":{"tf":1.0},"73":{"tf":1.4142135623730951},"75":{"tf":1.4142135623730951},"76":{"tf":1.4142135623730951},"84":{"tf":1.0},"89":{"tf":1.0},"93":{"tf":1.4142135623730951},"94":{"tf":1.0},"99":{"tf":1.4142135623730951}},"u":{"df":0,"docs":{},"r":{"df":49,"docs":{"0":{"tf":1.0},"100":{"tf":1.7320508075688772},"101":{"tf":1.7320508075688772},"102":{"tf":2.0},"103":{"tf":2.23606797749979},"104":{"tf":2.0},"105":{"tf":1.0},"106":{"tf":1.0},"108":{"tf":2.6457513110645907},"109":{"tf":1.4142135623730951},"21":{"tf":1.4142135623730951},"22":{"tf":1.4142135623730951},"24":{"tf":1.7320508075688772},"48":{"tf":1.0},"56":{"tf":1.0},"61":{"tf":1.7320508075688772},"68":{"tf":2.6457513110645907},"69":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":2.23606797749979},"72":{"tf":2.0},"73":{"tf":1.0},"74":{"tf":1.0},"75":{"tf":1.0},"76":{"tf":1.0},"77":{"tf":1.0},"78":{"tf":1.0},"79":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":1.0},"85":{"tf":1.0},"86":{"tf":1.0},"87":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.4142135623730951},"9":{"tf":1.4142135623730951},"90":{"tf":1.0},"91":{"tf":1.0},"92":{"tf":1.0},"93":{"tf":1.0},"94":{"tf":1.7320508075688772},"95":{"tf":1.0},"96":{"tf":1.0},"97":{"tf":1.4142135623730951},"98":{"tf":2.8284271247461903},"99":{"tf":2.8284271247461903}}}}},"n":{"df":1,"docs":{"44":{"tf":1.0}}}},"l":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"42":{"tf":1.7320508075688772},"51":{"tf":1.0},"93":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"70":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"59":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":4,"docs":{"116":{"tf":1.0},"46":{"tf":1.0},"56":{"tf":1.0},"60":{"tf":1.0}}}}},"df":0,"docs":{}},"i":{"d":{"df":2,"docs":{"116":{"tf":2.0},"83":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"64":{"tf":1.0}}}}},"t":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{".":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"a":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"93":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}},"df":1,"docs":{"93":{"tf":1.4142135623730951}}}}},"df":1,"docs":{"93":{"tf":1.0}},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"21":{"tf":1.0}},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"93":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":11,"docs":{"106":{"tf":1.0},"116":{"tf":1.4142135623730951},"120":{"tf":1.7320508075688772},"25":{"tf":1.0},"34":{"tf":1.0},"54":{"tf":1.0},"56":{"tf":2.23606797749979},"78":{"tf":1.0},"81":{"tf":1.0},"84":{"tf":1.4142135623730951},"87":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":15,"docs":{"120":{"tf":1.0},"121":{"tf":1.7320508075688772},"2":{"tf":1.0},"35":{"tf":1.4142135623730951},"41":{"tf":1.4142135623730951},"46":{"tf":1.4142135623730951},"48":{"tf":1.0},"49":{"tf":1.0},"52":{"tf":1.0},"53":{"tf":1.0},"54":{"tf":1.4142135623730951},"56":{"tf":2.23606797749979},"59":{"tf":1.4142135623730951},"60":{"tf":2.0},"71":{"tf":1.0}}}},"x":{"df":0,"docs":{},"t":{"df":3,"docs":{"113":{"tf":1.0},"59":{"tf":1.0},"64":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":3,"docs":{"116":{"tf":1.0},"60":{"tf":1.0},"70":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"i":{"b":{"/":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{".":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"k":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":1,"docs":{"24":{"tf":1.0}}}}}}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"24":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":3,"docs":{"112":{"tf":1.0},"114":{"tf":1.0},"37":{"tf":1.0}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"l":{"df":8,"docs":{"105":{"tf":1.0},"119":{"tf":1.0},"21":{"tf":1.0},"72":{"tf":1.0},"77":{"tf":1.0},"79":{"tf":1.0},"81":{"tf":1.0},"93":{"tf":1.4142135623730951}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"24":{"tf":1.0}}}}}}},"p":{"df":0,"docs":{},"i":{"df":6,"docs":{"2":{"tf":1.0},"24":{"tf":1.0},"32":{"tf":1.0},"46":{"tf":1.4142135623730951},"60":{"tf":1.7320508075688772},"70":{"tf":1.0}}},"y":{"_":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"60":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"46":{"tf":1.0},"60":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"46":{"tf":1.0},"60":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"75":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":3,"docs":{"14":{"tf":1.4142135623730951},"3":{"tf":1.0},"30":{"tf":1.0}}},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"104":{"tf":1.0},"24":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":3,"docs":{"114":{"tf":1.0},"21":{"tf":1.0},"25":{"tf":1.0}}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":3,"docs":{"38":{"tf":1.0},"56":{"tf":1.0},"59":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"36":{"tf":1.0},"56":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"118":{"tf":1.0}}}}}},"p":{"df":2,"docs":{"22":{"tf":1.4142135623730951},"24":{"tf":1.4142135623730951}},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"61":{"tf":1.0}}}},"p":{"df":2,"docs":{"105":{"tf":1.0},"61":{"tf":1.0}}},"u":{"=":{"df":0,"docs":{},"n":{"df":1,"docs":{"21":{"tf":1.0}}}},"df":0,"docs":{}}},"q":{"df":1,"docs":{"59":{"tf":2.0}},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"59":{"tf":1.4142135623730951}}}}}},"r":{"df":1,"docs":{"70":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"t":{"df":12,"docs":{"110":{"tf":1.0},"21":{"tf":1.0},"22":{"tf":1.7320508075688772},"33":{"tf":1.0},"59":{"tf":2.0},"68":{"tf":1.0},"70":{"tf":1.0},"75":{"tf":1.0},"86":{"tf":2.0},"94":{"tf":1.0},"95":{"tf":1.0},"98":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"64":{"tf":1.0},"88":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"f":{"df":3,"docs":{"59":{"tf":1.0},"70":{"tf":1.4142135623730951},"72":{"tf":1.0}}}},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"d":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"90":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"t":{"df":1,"docs":{"21":{"tf":1.0}}},"y":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"61":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"61":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"s":{"df":1,"docs":{"61":{"tf":1.0}},"s":{"df":2,"docs":{"61":{"tf":1.7320508075688772},"93":{"tf":1.0}}},"v":{"df":1,"docs":{"61":{"tf":1.0}}}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":10,"docs":{"41":{"tf":2.0},"44":{"tf":2.6457513110645907},"45":{"tf":1.4142135623730951},"46":{"tf":1.0},"48":{"tf":4.47213595499958},"49":{"tf":3.0},"51":{"tf":2.8284271247461903},"52":{"tf":4.47213595499958},"94":{"tf":2.0},"96":{"tf":1.4142135623730951}}}}},"u":{"df":0,"docs":{},"e":{"df":1,"docs":{"61":{"tf":1.0}},"l":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":1,"docs":{"61":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"l":{"df":2,"docs":{"87":{"tf":1.0},"91":{"tf":1.0}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":25,"docs":{"115":{"tf":1.4142135623730951},"26":{"tf":1.0},"33":{"tf":1.0},"35":{"tf":1.4142135623730951},"36":{"tf":1.0},"37":{"tf":1.4142135623730951},"41":{"tf":2.0},"44":{"tf":1.4142135623730951},"46":{"tf":1.0},"47":{"tf":1.4142135623730951},"48":{"tf":2.8284271247461903},"50":{"tf":1.4142135623730951},"51":{"tf":1.0},"52":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":3.1622776601683795},"59":{"tf":4.58257569495584},"60":{"tf":4.358898943540674},"70":{"tf":1.7320508075688772},"72":{"tf":2.23606797749979},"75":{"tf":1.0},"81":{"tf":1.7320508075688772},"93":{"tf":1.7320508075688772},"94":{"tf":1.0},"99":{"tf":1.4142135623730951}}}}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"n":{"df":1,"docs":{"56":{"tf":1.0}}}}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"54":{"tf":2.0},"56":{"tf":2.6457513110645907}},"e":{"df":0,"docs":{},"}":{",":{"+":{"1":{"df":1,"docs":{"56":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"n":{"df":2,"docs":{"70":{"tf":1.0},"93":{"tf":1.4142135623730951}}}}}}}},"df":19,"docs":{"115":{"tf":2.0},"116":{"tf":2.8284271247461903},"29":{"tf":1.0},"31":{"tf":1.0},"44":{"tf":1.4142135623730951},"45":{"tf":1.4142135623730951},"46":{"tf":2.0},"48":{"tf":2.0},"52":{"tf":1.0},"56":{"tf":1.4142135623730951},"59":{"tf":2.0},"60":{"tf":3.1622776601683795},"63":{"tf":1.0},"70":{"tf":2.23606797749979},"72":{"tf":1.4142135623730951},"74":{"tf":2.23606797749979},"83":{"tf":1.0},"84":{"tf":2.449489742783178},"93":{"tf":2.8284271247461903}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":3,"docs":{"70":{"tf":1.0},"84":{"tf":1.0},"93":{"tf":1.4142135623730951}}}}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":9,"docs":{"0":{"tf":1.0},"117":{"tf":1.0},"22":{"tf":1.0},"53":{"tf":1.0},"68":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.0},"76":{"tf":1.0},"81":{"tf":1.0}}}}}},"t":{"df":1,"docs":{"32":{"tf":1.0}}}},"y":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"89":{"tf":1.4142135623730951}}}},"c":{"df":0,"docs":{},"l":{"df":2,"docs":{"57":{"tf":1.4142135623730951},"83":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"l":{"c":{"df":1,"docs":{"61":{"tf":1.0}}},"df":0,"docs":{}}}},"d":{"a":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"65":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"p":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":1,"docs":{"60":{"tf":1.0}}}}}}}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"a":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"60":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"60":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":1,"docs":{"60":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"n":{"a":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"60":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"l":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"60":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"60":{"tf":1.0}}}}}},"p":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"60":{"tf":1.0}}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"60":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"60":{"tf":1.0}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"60":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"c":{"df":0,"docs":{},"k":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"60":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":1,"docs":{"60":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"60":{"tf":1.0}}}}}}},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"_":{"b":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"k":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"60":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"v":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"60":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"61":{"tf":1.4142135623730951}}}},"s":{"df":0,"docs":{},"h":{"df":2,"docs":{"91":{"tf":1.0},"94":{"tf":1.0}}}},"t":{"a":{"df":3,"docs":{"32":{"tf":1.0},"70":{"tf":1.0},"93":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":3,"docs":{"111":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.4142135623730951}}}}},"b":{"df":0,"docs":{},"g":{"df":1,"docs":{"59":{"tf":1.4142135623730951}}},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"61":{"tf":1.0}}}}},"df":12,"docs":{"22":{"tf":1.0},"44":{"tf":1.0},"45":{"tf":1.4142135623730951},"48":{"tf":3.1622776601683795},"49":{"tf":1.4142135623730951},"51":{"tf":1.0},"52":{"tf":1.4142135623730951},"56":{"tf":1.4142135623730951},"57":{"tf":1.4142135623730951},"60":{"tf":4.47213595499958},"61":{"tf":1.4142135623730951},"94":{"tf":1.0}},"e":{"b":{"df":2,"docs":{"25":{"tf":3.0},"5":{"tf":1.0}},"i":{"a":{"df":0,"docs":{},"n":{"df":4,"docs":{"21":{"tf":1.0},"25":{"tf":1.7320508075688772},"5":{"tf":1.4142135623730951},"61":{"tf":1.0}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"g":{"df":4,"docs":{"48":{"tf":1.0},"59":{"tf":2.8284271247461903},"60":{"tf":1.7320508075688772},"93":{"tf":1.4142135623730951}}}}},"c":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":6,"docs":{"103":{"tf":1.0},"117":{"tf":1.0},"118":{"tf":1.0},"60":{"tf":1.0},"73":{"tf":1.4142135623730951},"94":{"tf":1.0}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"116":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"45":{"tf":1.4142135623730951},"60":{"tf":1.4142135623730951}}}}}}}}},"d":{"df":0,"docs":{},"i":{"c":{"df":2,"docs":{"119":{"tf":1.0},"95":{"tf":1.0}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"75":{"tf":1.0}}}}}},"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":43,"docs":{"102":{"tf":1.0},"103":{"tf":1.4142135623730951},"114":{"tf":1.0},"116":{"tf":2.23606797749979},"118":{"tf":1.0},"120":{"tf":1.4142135623730951},"121":{"tf":1.0},"17":{"tf":1.0},"2":{"tf":1.0},"24":{"tf":1.0},"27":{"tf":1.0},"32":{"tf":1.0},"34":{"tf":2.0},"42":{"tf":1.0},"43":{"tf":1.0},"47":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.0},"54":{"tf":1.0},"59":{"tf":2.6457513110645907},"60":{"tf":1.0},"61":{"tf":1.0},"70":{"tf":2.23606797749979},"72":{"tf":1.4142135623730951},"73":{"tf":1.7320508075688772},"74":{"tf":1.0},"75":{"tf":1.4142135623730951},"76":{"tf":1.4142135623730951},"77":{"tf":1.0},"78":{"tf":1.0},"79":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.7320508075688772},"82":{"tf":1.0},"83":{"tf":1.7320508075688772},"84":{"tf":1.7320508075688772},"86":{"tf":1.0},"87":{"tf":1.4142135623730951},"89":{"tf":2.0},"93":{"tf":1.4142135623730951},"94":{"tf":1.0},"98":{"tf":1.0},"99":{"tf":1.4142135623730951}}}}}},"df":1,"docs":{"116":{"tf":2.449489742783178}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"87":{"tf":1.0}}}},"i":{"df":0,"docs":{},"n":{"df":12,"docs":{"0":{"tf":1.0},"103":{"tf":1.0},"104":{"tf":1.0},"113":{"tf":1.4142135623730951},"120":{"tf":1.7320508075688772},"32":{"tf":1.0},"33":{"tf":1.4142135623730951},"72":{"tf":1.4142135623730951},"74":{"tf":1.0},"86":{"tf":1.0},"89":{"tf":1.4142135623730951},"99":{"tf":1.0}},"i":{"df":0,"docs":{},"t":{"df":4,"docs":{"103":{"tf":2.0},"48":{"tf":2.0},"60":{"tf":2.0},"95":{"tf":1.0}}}}}}},"l":{"a":{"df":0,"docs":{},"y":{".":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"77":{"tf":1.0}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"77":{"tf":1.4142135623730951}}}}}}}}}},"df":0,"docs":{}}},"df":2,"docs":{"60":{"tf":1.4142135623730951},"96":{"tf":1.0}},"e":{"df":0,"docs":{},"t":{"df":12,"docs":{"29":{"tf":1.0},"33":{"tf":1.7320508075688772},"36":{"tf":1.0},"45":{"tf":2.0},"48":{"tf":1.0},"49":{"tf":2.8284271247461903},"52":{"tf":3.0},"60":{"tf":3.0},"63":{"tf":1.0},"93":{"tf":1.0},"94":{"tf":1.0},"96":{"tf":1.0}},"e":{"_":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{"_":{"b":{"a":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":2,"docs":{"49":{"tf":1.0},"60":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":2,"docs":{"49":{"tf":1.0},"60":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"45":{"tf":1.0},"60":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"y":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":2,"docs":{"45":{"tf":1.0},"60":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"_":{"b":{"a":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":2,"docs":{"49":{"tf":1.0},"60":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":2,"docs":{"49":{"tf":1.0},"60":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"56":{"tf":1.4142135623730951},"93":{"tf":1.0}}}}}},"t":{"a":{"df":1,"docs":{"93":{"tf":1.0}}},"df":0,"docs":{}}},"m":{"df":0,"docs":{},"o":{"df":3,"docs":{"36":{"tf":1.0},"37":{"tf":1.4142135623730951},"38":{"tf":1.0}},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"118":{"tf":1.0}}}}}}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":8,"docs":{"114":{"tf":1.0},"117":{"tf":1.0},"22":{"tf":1.0},"25":{"tf":2.0},"54":{"tf":1.0},"57":{"tf":1.4142135623730951},"70":{"tf":1.0},"79":{"tf":1.0}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"78":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"c":{"df":2,"docs":{"90":{"tf":1.0},"93":{"tf":1.0}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"75":{"tf":1.4142135623730951}}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":2,"docs":{"25":{"tf":1.4142135623730951},"93":{"tf":1.0}}}}},"s":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"116":{"tf":1.0}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"i":{"b":{"df":4,"docs":{"103":{"tf":1.0},"25":{"tf":1.0},"42":{"tf":1.0},"93":{"tf":1.0}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":28,"docs":{"102":{"tf":1.0},"104":{"tf":1.4142135623730951},"44":{"tf":1.0},"45":{"tf":1.4142135623730951},"46":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":3.1622776601683795},"49":{"tf":1.4142135623730951},"51":{"tf":1.0},"52":{"tf":1.0},"56":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.0},"70":{"tf":1.0},"72":{"tf":1.4142135623730951},"73":{"tf":1.0},"74":{"tf":1.0},"75":{"tf":1.0},"77":{"tf":1.0},"78":{"tf":1.0},"79":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.4142135623730951},"82":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":1.0},"93":{"tf":1.4142135623730951},"99":{"tf":1.0}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":1,"docs":{"49":{"tf":1.0}}}},"r":{"df":1,"docs":{"116":{"tf":1.0}}}},"k":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":4,"docs":{"12":{"tf":1.0},"21":{"tf":1.0},"24":{"tf":2.6457513110645907},"25":{"tf":1.4142135623730951}}}}}}},"t":{"a":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"72":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":4,"docs":{"21":{"tf":1.0},"48":{"tf":1.0},"70":{"tf":1.0},"88":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"100":{"tf":1.4142135623730951},"70":{"tf":1.4142135623730951},"99":{"tf":1.0}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":4,"docs":{"100":{"tf":1.4142135623730951},"115":{"tf":1.0},"93":{"tf":1.0},"99":{"tf":1.0}}}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":4,"docs":{"111":{"tf":1.0},"22":{"tf":1.0},"59":{"tf":1.0},"9":{"tf":1.4142135623730951}}}}}},"i":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"61":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"h":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"61":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"i":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":11,"docs":{"103":{"tf":1.4142135623730951},"48":{"tf":2.449489742783178},"59":{"tf":1.0},"60":{"tf":2.449489742783178},"69":{"tf":1.0},"70":{"tf":2.449489742783178},"72":{"tf":2.8284271247461903},"81":{"tf":1.7320508075688772},"84":{"tf":4.242640687119285},"93":{"tf":3.4641016151377544},"99":{"tf":2.6457513110645907}},"i":{"c":{"(":{"df":1,"docs":{"59":{"tf":1.0}}},".":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":1,"docs":{"93":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"93":{"tf":1.0}}}}}}},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"93":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":1,"docs":{"93":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"93":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"w":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"93":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"k":{"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"112":{"tf":1.0}}}},"df":0,"docs":{}}}},"d":{"df":0,"docs":{},"n":{"\'":{"df":0,"docs":{},"t":{"df":1,"docs":{"25":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{".":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"a":{"df":1,"docs":{"81":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":1,"docs":{"81":{"tf":1.0}}}}}},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":1,"docs":{"81":{"tf":1.0}}}}}},"df":5,"docs":{"59":{"tf":1.4142135623730951},"61":{"tf":1.0},"70":{"tf":1.4142135623730951},"81":{"tf":2.449489742783178},"93":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":11,"docs":{"103":{"tf":1.0},"114":{"tf":1.4142135623730951},"118":{"tf":1.0},"119":{"tf":1.0},"27":{"tf":1.4142135623730951},"47":{"tf":1.0},"59":{"tf":1.0},"63":{"tf":1.0},"70":{"tf":1.4142135623730951},"72":{"tf":1.0},"84":{"tf":1.0}}}},"g":{"df":1,"docs":{"59":{"tf":1.0}},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"59":{"tf":1.0}}}}}}},"m":{"df":1,"docs":{"90":{"tf":1.0}}},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"46":{"tf":1.0},"55":{"tf":1.0},"93":{"tf":1.4142135623730951}},"l":{"df":0,"docs":{},"i":{"df":4,"docs":{"27":{"tf":1.0},"57":{"tf":1.0},"64":{"tf":1.0},"65":{"tf":1.0}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":20,"docs":{"100":{"tf":1.7320508075688772},"102":{"tf":1.0},"104":{"tf":1.0},"110":{"tf":1.0},"112":{"tf":1.0},"2":{"tf":1.7320508075688772},"21":{"tf":2.0},"22":{"tf":3.605551275463989},"41":{"tf":1.0},"48":{"tf":1.0},"59":{"tf":2.0},"60":{"tf":2.0},"68":{"tf":1.7320508075688772},"70":{"tf":1.7320508075688772},"75":{"tf":1.7320508075688772},"86":{"tf":1.4142135623730951},"93":{"tf":1.0},"94":{"tf":1.0},"98":{"tf":1.4142135623730951},"99":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"s":{"a":{"b":{"df":0,"docs":{},"l":{"df":10,"docs":{"114":{"tf":1.0},"49":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.0},"70":{"tf":1.7320508075688772},"73":{"tf":1.0},"76":{"tf":1.0},"84":{"tf":2.23606797749979},"96":{"tf":1.0},"98":{"tf":1.0}}}},"df":0,"docs":{}},"c":{"a":{"df":0,"docs":{},"r":{"d":{"df":2,"docs":{"35":{"tf":1.0},"59":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"64":{"tf":1.0}}}}}},"df":0,"docs":{},"k":{"df":2,"docs":{"59":{"tf":3.3166247903554},"70":{"tf":1.0}}},"p":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"y":{"df":7,"docs":{"48":{"tf":2.0},"59":{"tf":1.7320508075688772},"70":{"tf":2.23606797749979},"72":{"tf":1.4142135623730951},"73":{"tf":3.1622776601683795},"81":{"tf":1.4142135623730951},"99":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"a":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"70":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":2,"docs":{"72":{"tf":1.0},"94":{"tf":1.0}}}}}}}}},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"120":{"tf":1.0},"22":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"65":{"tf":1.0}}}}}}},"j":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":1,"docs":{"61":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"61":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"f":{"df":1,"docs":{"7":{"tf":1.0}}}},"o":{"c":{"df":6,"docs":{"0":{"tf":1.0},"52":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0},"73":{"tf":1.4142135623730951},"93":{"tf":1.7320508075688772}},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"108":{"tf":1.0}}}}},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"61":{"tf":1.7320508075688772}},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"61":{"tf":1.0}}}}}}}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"\'":{"df":1,"docs":{"59":{"tf":1.0}}},"df":21,"docs":{"102":{"tf":1.0},"103":{"tf":1.7320508075688772},"108":{"tf":1.4142135623730951},"112":{"tf":1.0},"115":{"tf":1.0},"121":{"tf":1.4142135623730951},"21":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"48":{"tf":2.6457513110645907},"51":{"tf":1.0},"56":{"tf":3.0},"59":{"tf":1.0},"60":{"tf":1.0},"70":{"tf":1.7320508075688772},"76":{"tf":1.0},"93":{"tf":2.449489742783178},"94":{"tf":1.4142135623730951},"99":{"tf":1.0}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"102":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"n":{"\'":{"df":0,"docs":{},"t":{"df":3,"docs":{"100":{"tf":1.0},"103":{"tf":1.0},"113":{"tf":1.0}}}},"df":0,"docs":{}}}},"n":{"\'":{"df":0,"docs":{},"t":{"df":3,"docs":{"118":{"tf":1.0},"25":{"tf":1.0},"83":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":1,"docs":{"113":{"tf":1.0}}}},"t":{"df":3,"docs":{"61":{"tf":1.4142135623730951},"87":{"tf":1.4142135623730951},"91":{"tf":1.0}}},"u":{"b":{"df":0,"docs":{},"l":{"df":4,"docs":{"54":{"tf":1.4142135623730951},"56":{"tf":1.4142135623730951},"57":{"tf":1.0},"93":{"tf":1.0}},"e":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"91":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"w":{"df":0,"docs":{},"n":{"df":8,"docs":{"44":{"tf":2.0},"46":{"tf":1.4142135623730951},"48":{"tf":2.6457513110645907},"49":{"tf":1.7320508075688772},"51":{"tf":1.4142135623730951},"52":{"tf":1.0},"60":{"tf":4.0},"96":{"tf":1.7320508075688772}},"l":{"df":0,"docs":{},"o":{"a":{"d":{"df":2,"docs":{"12":{"tf":1.0},"2":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"48":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"r":{"a":{"df":0,"docs":{},"w":{"df":1,"docs":{"70":{"tf":1.0}}}},"df":0,"docs":{}},"t":{"d":{"df":1,"docs":{"61":{"tf":1.0}}},"df":1,"docs":{"61":{"tf":1.0}}},"u":{"df":0,"docs":{},"e":{"df":3,"docs":{"74":{"tf":1.0},"83":{"tf":1.0},"94":{"tf":1.0}}},"n":{"df":0,"docs":{},"e":{"df":1,"docs":{"61":{"tf":1.0}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"c":{"df":1,"docs":{"61":{"tf":1.0}}},"df":0,"docs":{}}}}},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"57":{"tf":1.0}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"e":{"df":4,"docs":{"21":{"tf":1.0},"50":{"tf":1.0},"85":{"tf":1.0},"93":{"tf":1.7320508075688772}}}}}},"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"g":{"df":5,"docs":{"0":{"tf":1.0},"100":{"tf":1.0},"103":{"tf":1.0},"93":{"tf":2.8284271247461903},"94":{"tf":2.0}}}},"a":{"c":{"df":0,"docs":{},"h":{"df":16,"docs":{"103":{"tf":1.0},"114":{"tf":1.0},"115":{"tf":1.0},"116":{"tf":1.0},"117":{"tf":1.0},"45":{"tf":2.23606797749979},"48":{"tf":1.0},"57":{"tf":1.0},"59":{"tf":2.0},"70":{"tf":1.0},"74":{"tf":1.0},"79":{"tf":1.0},"87":{"tf":1.0},"9":{"tf":1.0},"94":{"tf":1.0},"99":{"tf":1.0}}}},"df":0,"docs":{},"r":{"df":1,"docs":{"59":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"64":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"45":{"tf":1.0},"59":{"tf":1.4142135623730951},"60":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"61":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"y":{"df":0,"docs":{},"l":{"df":1,"docs":{"61":{"tf":1.0}}}}}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"64":{"tf":1.0}}}},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"64":{"tf":1.0},"68":{"tf":1.0}}}}}}},"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":5,"docs":{"50":{"tf":1.0},"54":{"tf":2.23606797749979},"56":{"tf":3.3166247903554},"57":{"tf":1.4142135623730951},"59":{"tf":1.0}}}},"m":{"a":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"93":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":6,"docs":{"62":{"tf":2.0},"63":{"tf":1.0},"64":{"tf":1.0},"65":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.0}}}}}}}}}},"d":{"df":0,"docs":{},"g":{"df":2,"docs":{"0":{"tf":1.0},"70":{"tf":1.0}}},"i":{"df":0,"docs":{},"t":{"df":17,"docs":{"22":{"tf":1.0},"27":{"tf":1.0},"29":{"tf":1.4142135623730951},"30":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.7320508075688772},"59":{"tf":2.0},"60":{"tf":1.4142135623730951},"63":{"tf":1.0},"64":{"tf":1.4142135623730951},"65":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.0},"77":{"tf":1.4142135623730951},"83":{"tf":1.4142135623730951},"93":{"tf":2.8284271247461903},"94":{"tf":1.0}},"o":{"df":0,"docs":{},"r":{".":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":3,"docs":{"69":{"tf":1.4142135623730951},"76":{"tf":1.7320508075688772},"77":{"tf":1.4142135623730951}}}}}},"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"b":{"df":0,"docs":{},"o":{"a":{"df":0,"docs":{},"r":{"d":{"df":2,"docs":{"69":{"tf":1.0},"71":{"tf":1.7320508075688772}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"93":{"tf":1.7320508075688772}}}}},"m":{"/":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"0":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":3,"docs":{"68":{"tf":1.0},"69":{"tf":1.0},"74":{"tf":1.4142135623730951}}}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":3,"docs":{"68":{"tf":1.0},"69":{"tf":1.0},"75":{"tf":1.4142135623730951}}}}},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":2,"docs":{"69":{"tf":1.0},"81":{"tf":2.23606797749979}},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{".":{"d":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"69":{"tf":1.0},"81":{"tf":1.0}}}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":2,"docs":{"69":{"tf":1.0},"81":{"tf":1.0}}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"69":{"tf":1.0},"81":{"tf":1.4142135623730951}}}}},"s":{"df":0,"docs":{},"p":{"a":{"c":{"df":2,"docs":{"69":{"tf":1.0},"81":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}}},"i":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"69":{"tf":1.0},"80":{"tf":1.7320508075688772}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"69":{"tf":1.0},"84":{"tf":1.7320508075688772}}}}}}},"l":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":2,"docs":{"69":{"tf":1.0},"73":{"tf":1.4142135623730951}}}}},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"99":{"tf":1.0}}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":2,"docs":{"93":{"tf":1.0},"99":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"h":{"df":2,"docs":{"69":{"tf":1.0},"78":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":2,"docs":{"69":{"tf":1.0},"83":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":4,"docs":{"69":{"tf":1.0},"82":{"tf":1.7320508075688772},"84":{"tf":1.0},"93":{"tf":1.0}},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"99":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"t":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"69":{"tf":1.0},"72":{"tf":2.0}},"e":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"72":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"99":{"tf":1.0}}}}}},"w":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"a":{"c":{"df":2,"docs":{"69":{"tf":1.0},"79":{"tf":1.7320508075688772}},"e":{".":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"79":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"79":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}},"/":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"df":1,"docs":{"21":{"tf":1.0}}}}}}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":1,"docs":{"70":{"tf":1.0}}}}}}}},"df":27,"docs":{"0":{"tf":1.0},"27":{"tf":1.0},"32":{"tf":1.0},"49":{"tf":1.4142135623730951},"53":{"tf":1.0},"56":{"tf":1.0},"59":{"tf":1.0},"6":{"tf":1.0},"65":{"tf":1.7320508075688772},"68":{"tf":1.0},"69":{"tf":2.0},"70":{"tf":2.449489742783178},"71":{"tf":1.4142135623730951},"72":{"tf":1.7320508075688772},"73":{"tf":1.0},"74":{"tf":1.0},"75":{"tf":1.0},"76":{"tf":2.0},"77":{"tf":1.0},"78":{"tf":1.0},"79":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.4142135623730951},"82":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":1.4142135623730951},"93":{"tf":1.0}}}}}},"o":{"c":{"df":1,"docs":{"61":{"tf":1.0}}},"df":0,"docs":{}}},"df":7,"docs":{"24":{"tf":1.4142135623730951},"44":{"tf":1.4142135623730951},"46":{"tf":1.0},"48":{"tf":1.0},"52":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":3.1622776601683795}},"e":{"df":0,"docs":{},"x":{"df":1,"docs":{"61":{"tf":1.0}}}},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"73":{"tf":1.0},"84":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"m":{"df":2,"docs":{"102":{"tf":1.0},"103":{"tf":1.7320508075688772}}}},"j":{"df":1,"docs":{"61":{"tf":1.0}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":4,"docs":{"116":{"tf":1.4142135623730951},"38":{"tf":1.0},"39":{"tf":1.0},"72":{"tf":3.1622776601683795}}}}}}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":1,"docs":{"61":{"tf":1.0}}}},"x":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":1,"docs":{"61":{"tf":1.7320508075688772}}}}}},"m":{"df":1,"docs":{"61":{"tf":1.4142135623730951}}},"p":{"df":1,"docs":{"61":{"tf":1.0}}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"61":{"tf":1.4142135623730951}}}}}}},"m":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"61":{"tf":1.7320508075688772}}}},"r":{"a":{"c":{"df":1,"docs":{"83":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"70":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"l":{"df":3,"docs":{"90":{"tf":1.0},"91":{"tf":1.0},"96":{"tf":1.0}}}}},"n":{"a":{"b":{"df":0,"docs":{},"l":{"df":14,"docs":{"103":{"tf":1.4142135623730951},"60":{"tf":1.0},"70":{"tf":2.0},"73":{"tf":2.0},"75":{"tf":2.6457513110645907},"76":{"tf":1.0},"77":{"tf":1.4142135623730951},"78":{"tf":1.0},"79":{"tf":1.0},"82":{"tf":1.7320508075688772},"83":{"tf":1.0},"84":{"tf":1.4142135623730951},"9":{"tf":1.0},"93":{"tf":2.6457513110645907}},"e":{"/":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"103":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"o":{"d":{"df":3,"docs":{"59":{"tf":1.4142135623730951},"72":{"tf":2.0},"96":{"tf":1.7320508075688772}}},"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"111":{"tf":1.0},"118":{"tf":1.0}}}},"r":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"49":{"tf":1.0}}}},"df":0,"docs":{}}}}},"d":{"df":22,"docs":{"115":{"tf":1.7320508075688772},"116":{"tf":2.449489742783178},"22":{"tf":1.0},"41":{"tf":1.0},"44":{"tf":2.0},"45":{"tf":1.0},"46":{"tf":1.0},"48":{"tf":1.4142135623730951},"49":{"tf":2.0},"50":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.7320508075688772},"55":{"tf":1.0},"56":{"tf":2.0},"59":{"tf":1.4142135623730951},"60":{"tf":5.0990195135927845},"70":{"tf":2.8284271247461903},"72":{"tf":1.7320508075688772},"82":{"tf":1.0},"84":{"tf":2.0},"96":{"tf":1.4142135623730951},"99":{"tf":1.4142135623730951}}},"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"c":{"df":2,"docs":{"83":{"tf":1.0},"96":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"j":{"df":0,"docs":{},"o":{"df":0,"docs":{},"y":{"df":1,"docs":{"83":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":7,"docs":{"100":{"tf":1.0},"111":{"tf":1.0},"116":{"tf":1.0},"21":{"tf":1.0},"42":{"tf":1.0},"46":{"tf":1.0},"60":{"tf":1.0}},"e":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":2,"docs":{"46":{"tf":1.0},"60":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":13,"docs":{"25":{"tf":1.0},"33":{"tf":1.0},"36":{"tf":1.0},"41":{"tf":1.4142135623730951},"45":{"tf":1.4142135623730951},"48":{"tf":3.3166247903554},"49":{"tf":1.0},"51":{"tf":1.4142135623730951},"52":{"tf":1.0},"56":{"tf":1.0},"60":{"tf":1.7320508075688772},"93":{"tf":1.0},"94":{"tf":1.7320508075688772}}}},"i":{"df":0,"docs":{},"r":{"df":5,"docs":{"116":{"tf":1.4142135623730951},"121":{"tf":1.0},"46":{"tf":1.0},"64":{"tf":1.0},"70":{"tf":1.4142135623730951}}}},"r":{"df":0,"docs":{},"i":{"df":5,"docs":{"103":{"tf":1.0},"108":{"tf":1.0},"109":{"tf":1.0},"48":{"tf":1.4142135623730951},"51":{"tf":2.0}}},"y":{".":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"112":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"112":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"m":{"df":1,"docs":{"93":{"tf":1.0}}}},"v":{"1":{"df":1,"docs":{"102":{"tf":1.0}}},"2":{"df":1,"docs":{"102":{"tf":1.0}}},":":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"d":{"a":{"df":0,"docs":{},"t":{"a":{"\\\\":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"\\\\":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"22":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":1,"docs":{"61":{"tf":1.0}},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":9,"docs":{"102":{"tf":1.7320508075688772},"111":{"tf":1.0},"2":{"tf":1.0},"21":{"tf":1.4142135623730951},"22":{"tf":2.23606797749979},"24":{"tf":1.0},"25":{"tf":1.0},"70":{"tf":1.0},"74":{"tf":1.0}}}}}}}},"q":{"?":{"/":{"#":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"117":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":2,"docs":{"117":{"tf":1.4142135623730951},"122":{"tf":1.0}},"u":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"117":{"tf":1.4142135623730951},"122":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":6,"docs":{"103":{"tf":1.0},"22":{"tf":1.0},"54":{"tf":1.0},"56":{"tf":1.0},"84":{"tf":1.0},"90":{"tf":1.0}}}},"df":0,"docs":{}}}}},"r":{"b":{"df":1,"docs":{"61":{"tf":1.0}}},"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"/":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":1,"docs":{"93":{"tf":1.0}}}}}}}}},"_":{"df":0,"docs":{},"l":{"df":1,"docs":{"61":{"tf":1.0}}}},"df":1,"docs":{"61":{"tf":1.0}}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":6,"docs":{"111":{"tf":1.0},"114":{"tf":1.0},"72":{"tf":2.449489742783178},"84":{"tf":1.4142135623730951},"93":{"tf":1.7320508075688772},"99":{"tf":1.0}}}}}},"s":{"c":{"a":{"df":0,"docs":{},"p":{"df":10,"docs":{"43":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.4142135623730951},"51":{"tf":1.0},"52":{"tf":1.0},"54":{"tf":1.7320508075688772},"56":{"tf":1.0},"93":{"tf":1.0},"94":{"tf":1.0},"96":{"tf":1.0}}}},"df":3,"docs":{"60":{"tf":1.7320508075688772},"94":{"tf":1.4142135623730951},"96":{"tf":1.0}}},"d":{"df":0,"docs":{},"l":{"df":1,"docs":{"61":{"tf":1.0}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"61":{"tf":1.4142135623730951}}}}}}},"t":{"c":{"df":10,"docs":{"0":{"tf":1.0},"100":{"tf":1.0},"112":{"tf":1.0},"29":{"tf":1.4142135623730951},"35":{"tf":1.0},"37":{"tf":1.4142135623730951},"63":{"tf":1.4142135623730951},"76":{"tf":1.0},"93":{"tf":3.0},"96":{"tf":1.0}}},"df":1,"docs":{"120":{"tf":1.0}}},"v":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"59":{"tf":1.0}},"u":{"df":3,"docs":{"56":{"tf":1.7320508075688772},"57":{"tf":1.0},"59":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":3,"docs":{"100":{"tf":1.0},"25":{"tf":1.0},"37":{"tf":1.0}},"t":{"df":3,"docs":{"39":{"tf":1.0},"70":{"tf":1.4142135623730951},"77":{"tf":1.0}},"u":{"df":1,"docs":{"81":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"y":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":7,"docs":{"0":{"tf":1.0},"103":{"tf":1.0},"116":{"tf":1.7320508075688772},"118":{"tf":1.7320508075688772},"23":{"tf":1.0},"25":{"tf":1.0},"57":{"tf":1.0}}}}}}}},"x":{"a":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"116":{"tf":1.0},"117":{"tf":1.0}}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":41,"docs":{"100":{"tf":1.7320508075688772},"102":{"tf":1.4142135623730951},"103":{"tf":1.7320508075688772},"104":{"tf":1.4142135623730951},"112":{"tf":1.4142135623730951},"113":{"tf":1.0},"114":{"tf":1.0},"116":{"tf":2.0},"118":{"tf":1.4142135623730951},"119":{"tf":1.4142135623730951},"12":{"tf":1.0},"21":{"tf":1.4142135623730951},"22":{"tf":1.4142135623730951},"24":{"tf":1.0},"30":{"tf":1.0},"31":{"tf":1.0},"33":{"tf":1.0},"36":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":1.0},"41":{"tf":1.7320508075688772},"50":{"tf":1.0},"53":{"tf":1.0},"54":{"tf":1.7320508075688772},"55":{"tf":1.0},"56":{"tf":3.0},"57":{"tf":2.449489742783178},"59":{"tf":1.4142135623730951},"68":{"tf":1.4142135623730951},"75":{"tf":1.0},"76":{"tf":1.0},"79":{"tf":1.4142135623730951},"8":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.4142135623730951},"82":{"tf":1.0},"93":{"tf":1.0},"94":{"tf":1.4142135623730951},"96":{"tf":1.0},"98":{"tf":1.0},"99":{"tf":2.0}}}}}},"c":{"df":0,"docs":{},"e":{"df":1,"docs":{"82":{"tf":1.0}},"p":{"df":0,"docs":{},"t":{"df":10,"docs":{"103":{"tf":1.7320508075688772},"105":{"tf":1.0},"118":{"tf":1.7320508075688772},"41":{"tf":1.0},"48":{"tf":1.0},"51":{"tf":1.0},"53":{"tf":1.4142135623730951},"57":{"tf":1.4142135623730951},"60":{"tf":1.7320508075688772},"93":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"u":{"d":{"df":2,"docs":{"121":{"tf":1.0},"75":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":11,"docs":{"102":{"tf":1.0},"12":{"tf":1.0},"21":{"tf":1.0},"22":{"tf":1.0},"34":{"tf":1.0},"53":{"tf":1.0},"56":{"tf":2.0},"57":{"tf":1.0},"60":{"tf":1.7320508075688772},"93":{"tf":1.4142135623730951},"94":{"tf":2.0}}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":5,"docs":{"108":{"tf":1.0},"114":{"tf":1.4142135623730951},"70":{"tf":1.0},"84":{"tf":1.0},"92":{"tf":1.0}}}},"t":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"60":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":5,"docs":{"48":{"tf":1.0},"59":{"tf":2.0},"60":{"tf":1.0},"94":{"tf":1.0},"95":{"tf":1.0}}}},"p":{"a":{"df":0,"docs":{},"n":{"d":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"46":{"tf":1.0},"60":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":5,"docs":{"39":{"tf":1.0},"46":{"tf":1.0},"54":{"tf":1.0},"56":{"tf":1.4142135623730951},"60":{"tf":1.4142135623730951}}},"df":0,"docs":{},"s":{"df":6,"docs":{"101":{"tf":1.0},"53":{"tf":1.4142135623730951},"54":{"tf":1.0},"56":{"tf":3.7416573867739413},"57":{"tf":1.4142135623730951},"99":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"114":{"tf":1.4142135623730951},"23":{"tf":1.0},"42":{"tf":1.0}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":3,"docs":{"22":{"tf":1.0},"49":{"tf":1.4142135623730951},"83":{"tf":1.0}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"45":{"tf":1.4142135623730951},"48":{"tf":1.0}}}}}}}}},"l":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"48":{"tf":1.0}}}},"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"118":{"tf":1.0},"83":{"tf":1.0}}}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"60":{"tf":1.7320508075688772}}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":2,"docs":{"22":{"tf":1.7320508075688772},"93":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":4,"docs":{"116":{"tf":1.4142135623730951},"117":{"tf":1.4142135623730951},"59":{"tf":1.0},"93":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{".":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":1,"docs":{"116":{"tf":2.0}}}}}}},"_":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":1,"docs":{"60":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":1,"docs":{"60":{"tf":1.0}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"60":{"tf":1.0},"94":{"tf":1.4142135623730951}},"e":{"_":{"a":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":1,"docs":{"60":{"tf":1.0}}}}},"df":0,"docs":{}},"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":2,"docs":{"46":{"tf":1.0},"60":{"tf":1.0}}}}}}},"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":1,"docs":{"60":{"tf":1.0}}}}}},"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":1,"docs":{"60":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"_":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"60":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"60":{"tf":1.0}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"60":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"s":{"df":0,"docs":{},"u":{"b":{"_":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"60":{"tf":1.0}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"60":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"60":{"tf":1.0}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"60":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"p":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"60":{"tf":1.0},"83":{"tf":1.0}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":2,"docs":{"60":{"tf":1.0},"83":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"_":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"60":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"60":{"tf":1.0}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"60":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"s":{"df":0,"docs":{},"u":{"b":{"_":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"60":{"tf":1.0}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"60":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"60":{"tf":1.0}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"60":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"s":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"h":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"60":{"tf":1.0}}}}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":1,"docs":{"60":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"_":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"60":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"_":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"60":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"o":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"n":{"df":1,"docs":{"60":{"tf":1.0}}}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"60":{"tf":1.0}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"60":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"a":{"c":{"df":1,"docs":{"60":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}}}}},"df":0,"docs":{}}}}}},"l":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"60":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"_":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"46":{"tf":1.0},"60":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"60":{"tf":1.0}}}}}}}}},"df":1,"docs":{"60":{"tf":1.0}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"60":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"60":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"_":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":1,"docs":{"60":{"tf":1.0}}}}}},"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":1,"docs":{"60":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":8,"docs":{"108":{"tf":1.0},"116":{"tf":3.7416573867739413},"42":{"tf":1.0},"46":{"tf":1.4142135623730951},"48":{"tf":1.0},"50":{"tf":2.23606797749979},"60":{"tf":6.324555320336759},"92":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":6,"docs":{"100":{"tf":1.4142135623730951},"116":{"tf":2.0},"119":{"tf":1.0},"120":{"tf":2.0},"121":{"tf":1.0},"65":{"tf":1.4142135623730951}}}},"r":{"df":0,"docs":{},"n":{"df":2,"docs":{"59":{"tf":1.0},"70":{"tf":1.0}}}}},"r":{"a":{"df":4,"docs":{"102":{"tf":1.0},"3":{"tf":1.0},"8":{"tf":2.0},"83":{"tf":1.0}}},"df":0,"docs":{}}}}},"f":{"a":{"c":{"df":0,"docs":{},"e":{"df":1,"docs":{"60":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"25":{"tf":1.0}}}},"l":{"df":0,"docs":{},"l":{"b":{"a":{"c":{"df":0,"docs":{},"k":{"df":3,"docs":{"22":{"tf":1.0},"70":{"tf":1.4142135623730951},"93":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"s":{"df":11,"docs":{"59":{"tf":1.0},"68":{"tf":1.4142135623730951},"70":{"tf":3.1622776601683795},"73":{"tf":1.7320508075688772},"76":{"tf":1.7320508075688772},"77":{"tf":1.4142135623730951},"80":{"tf":1.0},"82":{"tf":1.4142135623730951},"83":{"tf":1.0},"93":{"tf":1.0},"98":{"tf":1.0}}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"49":{"tf":1.0}}}},"df":0,"docs":{}}}}},"q":{"df":1,"docs":{"0":{"tf":1.0}}},"r":{"df":1,"docs":{"25":{"tf":1.0}}},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"115":{"tf":1.4142135623730951},"116":{"tf":2.449489742783178}}}}},"df":8,"docs":{"24":{"tf":1.4142135623730951},"31":{"tf":1.0},"37":{"tf":1.4142135623730951},"38":{"tf":1.0},"44":{"tf":2.449489742783178},"48":{"tf":2.8284271247461903},"52":{"tf":1.4142135623730951},"60":{"tf":3.7416573867739413}},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":9,"docs":{"103":{"tf":3.1622776601683795},"21":{"tf":1.0},"38":{"tf":1.0},"53":{"tf":1.0},"61":{"tf":1.0},"65":{"tf":1.0},"66":{"tf":1.7320508075688772},"67":{"tf":1.0},"70":{"tf":1.0}}}}}},"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"a":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":2,"docs":{"3":{"tf":1.0},"7":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"d":{"df":2,"docs":{"116":{"tf":1.4142135623730951},"56":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"n":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"61":{"tf":1.4142135623730951}}}}}},"t":{"c":{"df":0,"docs":{},"h":{"df":4,"docs":{"104":{"tf":1.4142135623730951},"105":{"tf":1.7320508075688772},"111":{"tf":1.4142135623730951},"21":{"tf":2.0}}}},"df":0,"docs":{}},"w":{"df":2,"docs":{"116":{"tf":1.0},"119":{"tf":1.0}}}},"f":{"0":{"0":{"0":{"0":{"df":1,"docs":{"87":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"70":{"tf":1.0}},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":2,"docs":{"87":{"tf":1.7320508075688772},"89":{"tf":1.0}}}}}}},"g":{"a":{"df":1,"docs":{"61":{"tf":1.0}}},"df":3,"docs":{"87":{"tf":1.4142135623730951},"92":{"tf":1.0},"93":{"tf":1.0}}},"i":{"d":{"df":0,"docs":{},"l":{"df":1,"docs":{"61":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"93":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"60":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"_":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"_":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"60":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"60":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}}}},"p":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"k":{"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"_":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"_":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"60":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":44,"docs":{"100":{"tf":4.0},"102":{"tf":1.0},"108":{"tf":1.4142135623730951},"109":{"tf":1.0},"112":{"tf":2.0},"113":{"tf":1.0},"114":{"tf":1.0},"12":{"tf":1.0},"120":{"tf":1.0},"2":{"tf":1.0},"21":{"tf":1.0},"22":{"tf":2.6457513110645907},"24":{"tf":1.7320508075688772},"25":{"tf":2.6457513110645907},"28":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.4142135623730951},"38":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.4142135623730951},"42":{"tf":1.4142135623730951},"46":{"tf":1.0},"48":{"tf":3.4641016151377544},"49":{"tf":1.0},"5":{"tf":1.0},"53":{"tf":1.0},"54":{"tf":1.0},"55":{"tf":1.0},"59":{"tf":3.7416573867739413},"60":{"tf":3.872983346207417},"68":{"tf":2.0},"70":{"tf":2.23606797749979},"72":{"tf":5.0},"73":{"tf":1.0},"75":{"tf":3.872983346207417},"85":{"tf":1.0},"86":{"tf":1.4142135623730951},"87":{"tf":1.0},"89":{"tf":1.4142135623730951},"94":{"tf":2.0},"97":{"tf":1.0},"98":{"tf":2.0},"99":{"tf":2.6457513110645907}},"n":{"a":{"df":0,"docs":{},"m":{"df":3,"docs":{"101":{"tf":1.0},"120":{"tf":1.0},"99":{"tf":1.0}}}},"df":0,"docs":{}},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":2,"docs":{"102":{"tf":1.0},"70":{"tf":1.0}}}}},"df":0,"docs":{}},"s":{"/":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"93":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":1,"docs":{"60":{"tf":1.0}}}}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":1,"docs":{"99":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"41":{"tf":2.0},"60":{"tf":1.0}}}}}},"n":{"a":{"df":0,"docs":{},"l":{"df":5,"docs":{"115":{"tf":1.0},"116":{"tf":1.0},"22":{"tf":1.0},"68":{"tf":1.0},"70":{"tf":1.7320508075688772}}}},"d":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"_":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{"df":2,"docs":{"44":{"tf":1.0},"60":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"_":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{"df":2,"docs":{"44":{"tf":1.0},"60":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"_":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{"df":2,"docs":{"44":{"tf":1.0},"60":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":7,"docs":{"114":{"tf":1.0},"22":{"tf":1.0},"25":{"tf":1.4142135623730951},"31":{"tf":1.0},"44":{"tf":2.0},"87":{"tf":1.0},"99":{"tf":1.0}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":19,"docs":{"103":{"tf":1.0},"116":{"tf":1.0},"117":{"tf":2.0},"118":{"tf":2.23606797749979},"122":{"tf":1.7320508075688772},"29":{"tf":1.7320508075688772},"30":{"tf":1.0},"35":{"tf":1.0},"48":{"tf":1.7320508075688772},"51":{"tf":1.0},"57":{"tf":1.7320508075688772},"59":{"tf":1.7320508075688772},"60":{"tf":2.23606797749979},"61":{"tf":1.0},"63":{"tf":1.0},"70":{"tf":1.0},"84":{"tf":1.0},"9":{"tf":1.0},"99":{"tf":1.4142135623730951}}}}},"s":{"df":0,"docs":{},"h":{"df":3,"docs":{"25":{"tf":1.0},"61":{"tf":1.4142135623730951},"66":{"tf":1.7320508075688772}}},"t":{"df":1,"docs":{"117":{"tf":1.0}}}},"x":{"df":1,"docs":{"73":{"tf":1.0}}}},"l":{"a":{"df":0,"docs":{},"g":{"df":2,"docs":{"53":{"tf":1.4142135623730951},"55":{"tf":2.6457513110645907}}},"k":{"df":0,"docs":{},"e":{"df":1,"docs":{"9":{"tf":1.7320508075688772}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"u":{"b":{"df":1,"docs":{"10":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"p":{"a":{"df":0,"docs":{},"k":{"df":2,"docs":{"10":{"tf":2.0},"3":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"46":{"tf":1.0},"60":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":3,"docs":{"46":{"tf":1.0},"57":{"tf":1.0},"60":{"tf":1.0}}}},"o":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"93":{"tf":1.0}}}},"df":0,"docs":{}}},"m":{"df":0,"docs":{},"t":{"df":1,"docs":{"59":{"tf":1.0}}}},"n":{"df":5,"docs":{"115":{"tf":1.4142135623730951},"116":{"tf":1.0},"118":{"tf":1.0},"84":{"tf":1.4142135623730951},"93":{"tf":1.0}}},"o":{"c":{"df":0,"docs":{},"u":{"df":1,"docs":{"77":{"tf":1.7320508075688772}},"s":{"df":2,"docs":{"56":{"tf":3.0},"59":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":6,"docs":{"111":{"tf":1.0},"21":{"tf":1.0},"24":{"tf":1.0},"48":{"tf":1.0},"60":{"tf":1.0},"98":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":25,"docs":{"100":{"tf":1.0},"107":{"tf":1.0},"112":{"tf":1.0},"113":{"tf":1.0},"116":{"tf":1.0},"117":{"tf":1.0},"118":{"tf":1.4142135623730951},"21":{"tf":1.0},"22":{"tf":1.4142135623730951},"25":{"tf":1.4142135623730951},"29":{"tf":1.0},"39":{"tf":1.4142135623730951},"4":{"tf":1.0},"41":{"tf":1.4142135623730951},"52":{"tf":1.0},"56":{"tf":1.7320508075688772},"57":{"tf":1.0},"61":{"tf":1.0},"63":{"tf":1.0},"72":{"tf":1.7320508075688772},"75":{"tf":1.4142135623730951},"90":{"tf":1.0},"91":{"tf":1.0},"93":{"tf":1.0},"96":{"tf":1.0}}}}}},"o":{"df":4,"docs":{"116":{"tf":1.0},"54":{"tf":1.0},"57":{"tf":1.0},"84":{"tf":1.4142135623730951}}},"r":{"c":{"df":4,"docs":{"121":{"tf":1.0},"59":{"tf":2.6457513110645907},"61":{"tf":1.0},"82":{"tf":1.0}},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"59":{"tf":2.0}}}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"87":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}}}},"k":{"df":1,"docs":{"65":{"tf":1.4142135623730951}}},"m":{"a":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"45":{"tf":1.0},"60":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"102":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":12,"docs":{"102":{"tf":2.23606797749979},"103":{"tf":2.0},"12":{"tf":1.0},"39":{"tf":1.0},"45":{"tf":1.0},"57":{"tf":1.4142135623730951},"59":{"tf":1.4142135623730951},"60":{"tf":1.0},"61":{"tf":1.4142135623730951},"70":{"tf":1.4142135623730951},"98":{"tf":1.4142135623730951},"99":{"tf":1.4142135623730951}},"s":{"df":0,"docs":{},"t":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"102":{"tf":1.0}}}}},"df":0,"docs":{}}},"t":{"df":3,"docs":{"101":{"tf":2.449489742783178},"59":{"tf":1.0},"99":{"tf":2.449489742783178}}}}},"df":1,"docs":{"56":{"tf":1.0}}},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"61":{"tf":1.4142135623730951}}},"l":{"df":1,"docs":{"61":{"tf":1.0}}},"r":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"61":{"tf":1.0}}}},"df":0,"docs":{}}},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":6,"docs":{"44":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.7320508075688772},"49":{"tf":1.0},"52":{"tf":1.4142135623730951},"60":{"tf":2.23606797749979}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"n":{"d":{"df":5,"docs":{"0":{"tf":1.0},"102":{"tf":1.0},"110":{"tf":1.0},"112":{"tf":1.4142135623730951},"93":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"r":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":1,"docs":{"60":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"d":{"df":1,"docs":{"116":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":1,"docs":{"82":{"tf":1.0}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"64":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"m":{">":{"<":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"48":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"s":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"61":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"p":{"df":1,"docs":{"61":{"tf":1.0}}}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":5,"docs":{"1":{"tf":1.0},"100":{"tf":1.0},"26":{"tf":1.0},"38":{"tf":1.0},"82":{"tf":1.0}},"i":{"df":2,"docs":{"26":{"tf":1.0},"83":{"tf":1.0}}}}},"n":{"c":{"(":{"[":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"1":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"1":{"df":1,"docs":{"39":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"[":{"(":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"1":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":2,"docs":{"39":{"tf":1.7320508075688772},"93":{"tf":1.0}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{".":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"112":{"tf":1.0},"113":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}}},"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"93":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":1,"docs":{"93":{"tf":1.0}}}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"112":{"tf":1.0}}},"df":0,"docs":{}}}}},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":1,"docs":{"113":{"tf":1.0}}}}}},"_":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"116":{"tf":1.7320508075688772}}}}}}}}},"df":0,"docs":{}},"df":12,"docs":{"112":{"tf":1.0},"113":{"tf":1.0},"116":{"tf":2.23606797749979},"118":{"tf":1.0},"26":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.4142135623730951},"38":{"tf":1.4142135623730951},"39":{"tf":1.7320508075688772},"48":{"tf":1.4142135623730951},"60":{"tf":1.4142135623730951},"93":{"tf":2.23606797749979}}}}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"116":{"tf":1.0}}}}}}}}}},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":4,"docs":{"118":{"tf":1.0},"36":{"tf":1.0},"81":{"tf":1.0},"94":{"tf":1.0}}}}},"z":{"df":0,"docs":{},"z":{"df":0,"docs":{},"i":{"df":2,"docs":{"41":{"tf":1.0},"48":{"tf":1.4142135623730951}}}}}},"z":{"df":0,"docs":{},"f":{"df":1,"docs":{"41":{"tf":1.0}}}},"|":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"e":{"c":{"=":{"$":{"(":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":1,"docs":{"24":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"24":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"g":{"df":1,"docs":{"24":{"tf":1.4142135623730951}}}}},"g":{"a":{"df":4,"docs":{"60":{"tf":1.4142135623730951},"61":{"tf":1.0},"94":{"tf":1.0},"95":{"tf":1.0}},"r":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"116":{"tf":1.0}}}}}}},"b":{"df":1,"docs":{"60":{"tf":1.4142135623730951}}},"c":{"c":{"df":1,"docs":{"21":{"tf":1.0}}},"df":1,"docs":{"60":{"tf":1.4142135623730951}}},"d":{"df":1,"docs":{"60":{"tf":2.0}},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"61":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":6,"docs":{"37":{"tf":1.0},"44":{"tf":1.0},"48":{"tf":3.0},"59":{"tf":1.0},"60":{"tf":3.7416573867739413},"94":{"tf":1.0}},"e":{"df":1,"docs":{"60":{"tf":1.4142135623730951}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":1,"docs":{"61":{"tf":1.0}}}}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"70":{"tf":1.0},"93":{"tf":1.0}}}}},"t":{"df":2,"docs":{"118":{"tf":1.0},"39":{"tf":1.0}}}},"f":{"df":1,"docs":{"60":{"tf":1.4142135623730951}}},"g":{"df":1,"docs":{"60":{"tf":1.4142135623730951}}},"h":{"df":1,"docs":{"60":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"61":{"tf":1.0}}}}}}},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"61":{"tf":1.0}}}}}}}},"i":{"df":1,"docs":{"60":{"tf":1.4142135623730951}},"t":{"\'":{"df":1,"docs":{"75":{"tf":1.0}}},"/":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":1,"docs":{"100":{"tf":1.4142135623730951}}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"/":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"d":{"df":1,"docs":{"75":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"75":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"df":8,"docs":{"100":{"tf":1.0},"104":{"tf":2.0},"21":{"tf":1.4142135623730951},"56":{"tf":1.0},"61":{"tf":2.449489742783178},"75":{"tf":2.23606797749979},"8":{"tf":1.0},"81":{"tf":1.0}},"h":{"df":0,"docs":{},"u":{"b":{"/":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":0,"docs":{},"f":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"100":{"tf":1.0}},"s":{"/":{"*":{".":{"df":0,"docs":{},"y":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"100":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}}}},"df":4,"docs":{"112":{"tf":1.0},"2":{"tf":1.0},"21":{"tf":1.0},"75":{"tf":1.0}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"75":{"tf":2.0}}}}}}}},"v":{"df":0,"docs":{},"e":{"df":1,"docs":{"95":{"tf":1.0}},"n":{"df":9,"docs":{"100":{"tf":1.4142135623730951},"103":{"tf":1.0},"116":{"tf":1.0},"117":{"tf":1.7320508075688772},"121":{"tf":1.0},"122":{"tf":1.0},"57":{"tf":1.0},"59":{"tf":3.0},"84":{"tf":1.0}}}}}},"j":{"df":2,"docs":{"60":{"tf":1.4142135623730951},"61":{"tf":1.0}}},"k":{"df":1,"docs":{"60":{"tf":1.4142135623730951}}},"l":{"df":1,"docs":{"60":{"tf":1.4142135623730951}},"e":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"61":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"i":{"b":{"c":{"df":1,"docs":{"21":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"61":{"tf":1.0}}}}}}},"o":{"b":{"a":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"h":{"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":6,"docs":{"40":{"tf":1.0},"41":{"tf":2.0},"48":{"tf":1.4142135623730951},"60":{"tf":1.0},"68":{"tf":1.0},"75":{"tf":2.449489742783178}}}},"df":2,"docs":{"100":{"tf":3.7416573867739413},"102":{"tf":1.0}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"l":{"_":{"a":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"y":{"df":0,"docs":{},"z":{"df":1,"docs":{"61":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":1,"docs":{"61":{"tf":1.0}}}}},"m":{"df":1,"docs":{"60":{"tf":1.4142135623730951}}},"n":{"df":2,"docs":{"60":{"tf":1.4142135623730951},"61":{"tf":1.0}}},"o":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"61":{"tf":1.0}}}}},"df":7,"docs":{"116":{"tf":1.4142135623730951},"29":{"tf":1.0},"44":{"tf":1.0},"48":{"tf":6.4031242374328485},"51":{"tf":1.4142135623730951},"61":{"tf":1.0},"63":{"tf":1.0}},"l":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"c":{"df":0,"docs":{},"i":{"df":1,"docs":{"61":{"tf":1.0}}}},"df":0,"docs":{}}}},"d":{"df":1,"docs":{"92":{"tf":1.0}}},"df":0,"docs":{}},"m":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"61":{"tf":1.0}}},"df":0,"docs":{}}},"o":{"d":{"df":2,"docs":{"22":{"tf":1.0},"25":{"tf":1.0}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"61":{"tf":2.0}}}},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"61":{"tf":1.0}}}}},"o":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"n":{"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}}}}}}}},"d":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"60":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":3,"docs":{"103":{"tf":1.0},"48":{"tf":1.0},"60":{"tf":1.0}}}}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":2,"docs":{"48":{"tf":1.7320508075688772},"60":{"tf":1.0}},"e":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"60":{"tf":1.0}}},"df":0,"docs":{}}},"h":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"60":{"tf":1.0}}}}}}}},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}}}}},"df":0,"docs":{}}},"v":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"60":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"_":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}}}}},"df":0,"docs":{}}},"d":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"g":{"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"a":{"c":{"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}}}}},"df":0,"docs":{}}}}}},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}}}}}}}}}}},"l":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"_":{"a":{"c":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"d":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}}}}},"df":0,"docs":{}}},"d":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"g":{"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}}}}},"m":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}},"i":{"df":0,"docs":{},"e":{"d":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"44":{"tf":1.0},"60":{"tf":1.0}},"e":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"49":{"tf":1.0},"60":{"tf":1.0}}}}}}}}},"df":3,"docs":{"44":{"tf":1.0},"48":{"tf":1.0},"60":{"tf":1.0}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":4,"docs":{"44":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0},"60":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"_":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}}}}}},"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}}}}},"df":0,"docs":{}},"l":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"m":{"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}}}}},"d":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"g":{"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"60":{"tf":1.0}}}}}}},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}}}},"df":0,"docs":{}}}},"p":{"a":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}}}}},"df":0,"docs":{}}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"t":{"a":{"b":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":1,"docs":{"60":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"_":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}}}}},"df":0,"docs":{}},"l":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"m":{"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}}}}},"d":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"g":{"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"60":{"tf":1.0}}}}}}},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}}}},"df":0,"docs":{}}}},"p":{"a":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}}}}},"df":0,"docs":{}}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"t":{"a":{"b":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":1,"docs":{"60":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"_":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"_":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"_":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}}}}}}}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"r":{"d":{"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":7,"docs":{"103":{"tf":2.449489742783178},"42":{"tf":1.0},"48":{"tf":1.7320508075688772},"50":{"tf":1.0},"59":{"tf":2.0},"60":{"tf":7.211102550927978},"73":{"tf":1.4142135623730951}}}},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":1,"docs":{"61":{"tf":1.0}}}}}}},"p":{"df":1,"docs":{"60":{"tf":1.4142135623730951}},"r":{"df":1,"docs":{"61":{"tf":1.0}}}},"r":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"r":{"df":12,"docs":{"104":{"tf":3.7416573867739413},"105":{"tf":3.1622776601683795},"106":{"tf":1.0},"109":{"tf":2.449489742783178},"111":{"tf":2.23606797749979},"112":{"tf":1.0},"114":{"tf":1.0},"21":{"tf":2.8284271247461903},"25":{"tf":1.0},"37":{"tf":1.4142135623730951},"42":{"tf":1.0},"99":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"56":{"tf":1.0}}}},"q":{"df":0,"docs":{},"l":{"df":1,"docs":{"61":{"tf":1.4142135623730951}}}}}},"y":{"df":1,"docs":{"89":{"tf":1.4142135623730951}}}},"df":1,"docs":{"60":{"tf":1.4142135623730951}},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"116":{"tf":1.7320508075688772},"64":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"89":{"tf":1.4142135623730951}}}},"n":{"df":1,"docs":{"61":{"tf":1.0}}}},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"df":1,"docs":{"61":{"tf":1.0}}}}}}},"s":{"df":1,"docs":{"60":{"tf":1.4142135623730951}}},"t":{"df":2,"docs":{"60":{"tf":2.0},"61":{"tf":1.0}}},"u":{"df":0,"docs":{},"i":{"d":{"df":21,"docs":{"106":{"tf":2.0},"107":{"tf":1.0},"108":{"tf":1.0},"109":{"tf":1.0},"110":{"tf":1.0},"111":{"tf":1.0},"112":{"tf":1.0},"113":{"tf":1.0},"114":{"tf":1.4142135623730951},"115":{"tf":1.0},"116":{"tf":1.0},"117":{"tf":1.0},"118":{"tf":1.0},"119":{"tf":1.0},"120":{"tf":1.0},"121":{"tf":1.0},"122":{"tf":1.0},"61":{"tf":1.0},"69":{"tf":1.0},"80":{"tf":2.449489742783178},"93":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"70":{"tf":1.7320508075688772},"81":{"tf":2.8284271247461903},"93":{"tf":3.7416573867739413}}}}}}},"w":{"df":1,"docs":{"60":{"tf":1.4142135623730951}}},"y":{"df":1,"docs":{"60":{"tf":1.4142135623730951}}}},"h":{"1":{"df":1,"docs":{"93":{"tf":1.0}}},"6":{"df":1,"docs":{"93":{"tf":1.0}}},"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"_":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":1,"docs":{"60":{"tf":1.0}}}}}},"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":1,"docs":{"60":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":3,"docs":{"44":{"tf":1.4142135623730951},"48":{"tf":1.4142135623730951},"60":{"tf":2.0}}}},"n":{"d":{"df":0,"docs":{},"l":{"df":1,"docs":{"103":{"tf":1.0}}}},"df":0,"docs":{},"g":{"df":1,"docs":{"116":{"tf":1.0}}}},"r":{"d":{"df":1,"docs":{"59":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"114":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":1,"docs":{"61":{"tf":1.0}}}},"s":{"df":0,"docs":{},"h":{"df":2,"docs":{"104":{"tf":1.0},"72":{"tf":1.0}}},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"61":{"tf":2.0}}}}}}},"c":{"df":1,"docs":{"33":{"tf":1.0}},"l":{"df":1,"docs":{"61":{"tf":1.0}}}},"df":6,"docs":{"33":{"tf":1.0},"44":{"tf":1.0},"48":{"tf":2.23606797749979},"49":{"tf":1.0},"52":{"tf":1.0},"60":{"tf":2.6457513110645907}},"e":{"a":{"d":{"df":1,"docs":{"93":{"tf":1.7320508075688772}},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"89":{"tf":1.0},"93":{"tf":1.0}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":4,"docs":{"2":{"tf":1.0},"23":{"tf":2.0},"61":{"tf":1.0},"8":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":1,"docs":{"61":{"tf":1.0}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"\'":{"df":4,"docs":{"21":{"tf":1.0},"22":{"tf":1.4142135623730951},"42":{"tf":1.0},"63":{"tf":1.4142135623730951}}},".":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"df":1,"docs":{"17":{"tf":1.0}}}}}}},"i":{"d":{"df":0,"docs":{},"e":{"a":{".":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"65":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"65":{"tf":1.0}}}},"s":{".":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"65":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"/":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":2,"docs":{"70":{"tf":1.0},"99":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"75":{"tf":1.0}}}}}}}},"_":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"22":{"tf":1.4142135623730951}},"e":{"=":{"/":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"r":{"/":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"b":{"/":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"22":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"s":{"a":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"_":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"r":{"_":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"21":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":3,"docs":{"111":{"tf":1.0},"2":{"tf":1.0},"22":{"tf":2.23606797749979}},"e":{"=":{"df":0,"docs":{},"~":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"r":{"c":{"/":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"22":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}}},"df":62,"docs":{"0":{"tf":2.0},"1":{"tf":2.23606797749979},"10":{"tf":1.0},"100":{"tf":1.4142135623730951},"103":{"tf":1.0},"107":{"tf":1.7320508075688772},"11":{"tf":1.7320508075688772},"111":{"tf":1.4142135623730951},"112":{"tf":1.7320508075688772},"113":{"tf":1.0},"114":{"tf":1.4142135623730951},"115":{"tf":1.0},"116":{"tf":1.0},"119":{"tf":1.0},"12":{"tf":2.6457513110645907},"120":{"tf":1.4142135623730951},"14":{"tf":1.0},"15":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.0},"2":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":2.23606797749979},"22":{"tf":2.449489742783178},"23":{"tf":1.0},"24":{"tf":1.0},"25":{"tf":1.7320508075688772},"26":{"tf":1.7320508075688772},"27":{"tf":1.0},"29":{"tf":1.0},"30":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.4142135623730951},"43":{"tf":1.0},"49":{"tf":1.0},"56":{"tf":1.7320508075688772},"59":{"tf":1.0},"6":{"tf":1.4142135623730951},"61":{"tf":1.0},"62":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":3.0},"65":{"tf":2.449489742783178},"66":{"tf":2.23606797749979},"67":{"tf":2.0},"68":{"tf":1.7320508075688772},"7":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.4142135623730951},"73":{"tf":1.4142135623730951},"75":{"tf":1.7320508075688772},"77":{"tf":1.0},"8":{"tf":2.23606797749979},"9":{"tf":2.0},"94":{"tf":2.23606797749979},"98":{"tf":2.0},"99":{"tf":1.0}}}},"m":{"_":{"df":0,"docs":{},"l":{"df":1,"docs":{"61":{"tf":1.0}}}},"df":1,"docs":{"61":{"tf":1.0}}},"p":{"df":6,"docs":{"103":{"tf":1.0},"116":{"tf":1.7320508075688772},"42":{"tf":1.0},"48":{"tf":1.0},"60":{"tf":1.0},"73":{"tf":2.0}}}},"r":{"df":0,"docs":{},"e":{"df":2,"docs":{"116":{"tf":1.0},"87":{"tf":1.4142135623730951}}},"o":{"df":2,"docs":{"115":{"tf":2.0},"116":{"tf":1.7320508075688772}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":3,"docs":{"114":{"tf":1.7320508075688772},"57":{"tf":1.4142135623730951},"70":{"tf":1.4142135623730951}}}}}}},"x":{"a":{"d":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"56":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"i":{"d":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":4,"docs":{"68":{"tf":1.0},"74":{"tf":1.0},"75":{"tf":1.4142135623730951},"90":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":1,"docs":{"82":{"tf":1.0}}}},"df":1,"docs":{"56":{"tf":1.7320508075688772}},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"25":{"tf":1.0},"84":{"tf":1.0}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"84":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":10,"docs":{"103":{"tf":1.0},"110":{"tf":1.4142135623730951},"119":{"tf":1.7320508075688772},"120":{"tf":2.0},"121":{"tf":1.0},"59":{"tf":1.4142135623730951},"61":{"tf":1.0},"70":{"tf":1.4142135623730951},"82":{"tf":1.0},"93":{"tf":2.0}}}}}}}}},"n":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"93":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":1,"docs":{"93":{"tf":1.0}}}}}},"df":5,"docs":{"103":{"tf":1.0},"73":{"tf":2.449489742783178},"84":{"tf":1.4142135623730951},"93":{"tf":2.6457513110645907},"99":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":4,"docs":{"45":{"tf":1.4142135623730951},"52":{"tf":1.4142135623730951},"59":{"tf":1.4142135623730951},"60":{"tf":1.4142135623730951}}}}}}},"t":{"df":1,"docs":{"36":{"tf":1.0}}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"59":{"tf":1.0}}}}},"o":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"61":{"tf":1.0}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"/":{".":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"a":{"df":0,"docs":{},"l":{"/":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"/":{"df":0,"docs":{},"h":{"df":0,"docs":{},"x":{"df":1,"docs":{"12":{"tf":1.0}}}}},"df":1,"docs":{"12":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"b":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":2,"docs":{"14":{"tf":1.4142135623730951},"3":{"tf":1.0}}}}}},"df":7,"docs":{"44":{"tf":1.0},"49":{"tf":1.4142135623730951},"51":{"tf":1.0},"52":{"tf":1.0},"60":{"tf":1.7320508075688772},"75":{"tf":1.0},"96":{"tf":1.4142135623730951}}}},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"61":{"tf":1.0}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"z":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":5,"docs":{"48":{"tf":1.7320508075688772},"51":{"tf":1.0},"59":{"tf":1.4142135623730951},"60":{"tf":1.4142135623730951},"84":{"tf":1.0}}}}}}}},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"104":{"tf":1.0},"61":{"tf":1.0}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":4,"docs":{"103":{"tf":1.0},"48":{"tf":1.0},"60":{"tf":1.0},"93":{"tf":2.449489742783178}}}}}},"s":{"df":1,"docs":{"59":{"tf":1.0}},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"60":{"tf":1.0}}}}}},"df":3,"docs":{"48":{"tf":1.0},"59":{"tf":1.4142135623730951},"60":{"tf":1.4142135623730951}}}}}}},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"j":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":1,"docs":{"61":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":2,"docs":{"61":{"tf":1.7320508075688772},"93":{"tf":1.4142135623730951}}}},"t":{"df":0,"docs":{},"p":{"df":0,"docs":{},"s":{":":{"/":{"/":{"d":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"df":1,"docs":{"0":{"tf":1.0}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"c":{".":{"df":0,"docs":{},"w":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"w":{"df":0,"docs":{},"g":{".":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"59":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"u":{"b":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"/":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"/":{"df":0,"docs":{},"m":{"df":0,"docs":{},"y":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"104":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"df":1,"docs":{"21":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"102":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":1,"docs":{"61":{"tf":1.0}}}}},"x":{"df":13,"docs":{"104":{"tf":1.0},"105":{"tf":1.4142135623730951},"111":{"tf":1.4142135623730951},"12":{"tf":1.0},"2":{"tf":2.23606797749979},"21":{"tf":1.7320508075688772},"22":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":1.0},"26":{"tf":1.0},"61":{"tf":1.0},"68":{"tf":1.4142135623730951},"8":{"tf":1.0}}},"y":{"b":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"d":{"df":3,"docs":{"114":{"tf":1.0},"57":{"tf":2.0},"70":{"tf":1.7320508075688772}}},"df":0,"docs":{}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"61":{"tf":1.0}}}}},"df":1,"docs":{"61":{"tf":1.0}}}}}}},"i":{".":{"df":1,"docs":{"86":{"tf":1.4142135623730951}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"24":{"tf":1.4142135623730951},"25":{"tf":1.0}},"s":{"/":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{".":{"df":0,"docs":{},"p":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{")":{"df":0,"docs":{},"|":{"df":0,"docs":{},"g":{"df":1,"docs":{"24":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}},"d":{"df":2,"docs":{"93":{"tf":1.0},"99":{"tf":1.7320508075688772}},"e":{"a":{"df":1,"docs":{"65":{"tf":1.0}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"65":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":2,"docs":{"39":{"tf":3.0},"99":{"tf":1.0}}}}}}}},"l":{"df":1,"docs":{"70":{"tf":1.4142135623730951}}},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"61":{"tf":1.0}},"s":{"2":{"df":1,"docs":{"61":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":1,"docs":{"61":{"tf":1.0}}}},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":6,"docs":{"116":{"tf":1.0},"45":{"tf":1.0},"59":{"tf":2.6457513110645907},"60":{"tf":1.0},"61":{"tf":1.0},"75":{"tf":3.872983346207417}}}}}},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"118":{"tf":1.0}}}},"m":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"93":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"118":{"tf":1.0}}}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":4,"docs":{"103":{"tf":1.0},"37":{"tf":1.0},"48":{"tf":1.0},"60":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"93":{"tf":1.4142135623730951}}}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":1,"docs":{"73":{"tf":1.0}}}}}}},"n":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"93":{"tf":1.0}}}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"d":{"df":12,"docs":{"118":{"tf":1.4142135623730951},"121":{"tf":1.0},"2":{"tf":1.0},"25":{"tf":1.0},"31":{"tf":1.0},"36":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.0},"49":{"tf":1.0},"70":{"tf":1.0},"73":{"tf":1.4142135623730951},"89":{"tf":1.0}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":3,"docs":{"114":{"tf":1.4142135623730951},"116":{"tf":1.7320508075688772},"82":{"tf":1.0}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"45":{"tf":1.4142135623730951},"60":{"tf":1.4142135623730951}}}}}}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{".":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"y":{"df":1,"docs":{"116":{"tf":2.8284271247461903}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"m":{"df":1,"docs":{"114":{"tf":1.0}}}},"df":0,"docs":{}}},"df":17,"docs":{"110":{"tf":1.0},"114":{"tf":4.123105625617661},"115":{"tf":2.449489742783178},"116":{"tf":6.244997998398398},"117":{"tf":1.7320508075688772},"118":{"tf":3.0},"45":{"tf":1.4142135623730951},"57":{"tf":1.4142135623730951},"59":{"tf":1.4142135623730951},"60":{"tf":1.4142135623730951},"61":{"tf":1.0},"70":{"tf":2.0},"72":{"tf":1.4142135623730951},"80":{"tf":2.0},"82":{"tf":1.7320508075688772},"93":{"tf":1.0},"99":{"tf":2.0}},"s":{".":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"m":{"df":1,"docs":{"115":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"x":{"df":1,"docs":{"72":{"tf":1.0}}}},"i":{"c":{"df":7,"docs":{"121":{"tf":1.4142135623730951},"35":{"tf":1.0},"70":{"tf":1.0},"72":{"tf":2.6457513110645907},"81":{"tf":1.0},"82":{"tf":1.7320508075688772},"93":{"tf":2.449489742783178}}},"df":0,"docs":{}}},"df":2,"docs":{"72":{"tf":1.0},"96":{"tf":1.0}},"f":{"df":0,"docs":{},"o":{"df":6,"docs":{"51":{"tf":1.0},"59":{"tf":1.4142135623730951},"70":{"tf":1.4142135623730951},"84":{"tf":1.0},"93":{"tf":1.7320508075688772},"99":{"tf":1.0}},"r":{"df":0,"docs":{},"m":{"df":8,"docs":{"108":{"tf":1.0},"110":{"tf":1.0},"112":{"tf":1.0},"23":{"tf":1.0},"56":{"tf":1.0},"61":{"tf":1.0},"62":{"tf":1.0},"99":{"tf":1.4142135623730951}}}}}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"92":{"tf":2.0}}}}}}},"i":{"df":1,"docs":{"61":{"tf":1.0}},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"102":{"tf":1.0}}}}},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":5,"docs":{"119":{"tf":2.23606797749979},"120":{"tf":1.0},"121":{"tf":1.4142135623730951},"122":{"tf":1.0},"99":{"tf":1.7320508075688772}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"121":{"tf":1.0}}}}},"df":0,"docs":{}},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"119":{"tf":1.4142135623730951},"120":{"tf":1.7320508075688772}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"120":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"i":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"d":{"df":1,"docs":{"121":{"tf":1.7320508075688772}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"l":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"g":{"df":3,"docs":{"119":{"tf":1.4142135623730951},"120":{"tf":1.4142135623730951},"121":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"b":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"120":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"k":{"df":1,"docs":{"61":{"tf":1.0}},"o":{"df":1,"docs":{"61":{"tf":1.0}}}},"l":{"a":{"df":0,"docs":{},"y":{"df":3,"docs":{"103":{"tf":1.0},"73":{"tf":2.23606797749979},"93":{"tf":1.7320508075688772}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":3,"docs":{"70":{"tf":1.0},"84":{"tf":2.8284271247461903},"93":{"tf":1.4142135623730951}}}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"54":{"tf":1.0}},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"116":{"tf":1.4142135623730951}}}}}}}}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":5,"docs":{"102":{"tf":1.0},"36":{"tf":1.0},"52":{"tf":1.0},"93":{"tf":1.0},"99":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"78":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"t":{"_":{"a":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"45":{"tf":1.0},"60":{"tf":1.0}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":2,"docs":{"45":{"tf":1.0},"60":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"d":{"df":2,"docs":{"45":{"tf":1.0},"60":{"tf":1.0}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"49":{"tf":1.0},"60":{"tf":1.0}}}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"49":{"tf":1.0},"60":{"tf":1.0}}}}}}}},"t":{"a":{"b":{"df":1,"docs":{"60":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":28,"docs":{"102":{"tf":1.0},"115":{"tf":2.449489742783178},"27":{"tf":1.0},"33":{"tf":1.0},"41":{"tf":1.4142135623730951},"42":{"tf":1.0},"45":{"tf":2.8284271247461903},"46":{"tf":1.0},"49":{"tf":2.6457513110645907},"52":{"tf":1.4142135623730951},"53":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.7320508075688772},"59":{"tf":1.4142135623730951},"60":{"tf":5.385164807134504},"68":{"tf":1.0},"70":{"tf":2.449489742783178},"72":{"tf":1.7320508075688772},"74":{"tf":1.4142135623730951},"76":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.7320508075688772},"84":{"tf":1.0},"93":{"tf":1.0},"94":{"tf":1.0},"95":{"tf":1.0},"96":{"tf":1.0},"99":{"tf":1.0}},"s":{"df":0,"docs":{},"p":{"a":{"c":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":1,"docs":{"102":{"tf":1.0}}}}}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"i":{"d":{"df":7,"docs":{"116":{"tf":1.4142135623730951},"37":{"tf":1.0},"46":{"tf":1.7320508075688772},"48":{"tf":1.0},"60":{"tf":2.0},"70":{"tf":1.0},"84":{"tf":1.0}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"56":{"tf":1.0}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"r":{"df":5,"docs":{"29":{"tf":1.0},"30":{"tf":1.0},"36":{"tf":1.0},"63":{"tf":1.0},"87":{"tf":1.0}}}}},"t":{"a":{"df":0,"docs":{},"l":{"df":29,"docs":{"0":{"tf":1.0},"1":{"tf":2.23606797749979},"10":{"tf":1.4142135623730951},"108":{"tf":1.0},"11":{"tf":2.0},"12":{"tf":1.7320508075688772},"13":{"tf":1.0},"14":{"tf":1.4142135623730951},"15":{"tf":1.4142135623730951},"16":{"tf":1.4142135623730951},"17":{"tf":2.23606797749979},"18":{"tf":1.4142135623730951},"19":{"tf":1.4142135623730951},"2":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":2.449489742783178},"22":{"tf":1.4142135623730951},"23":{"tf":1.7320508075688772},"24":{"tf":1.0},"25":{"tf":1.7320508075688772},"3":{"tf":1.0},"4":{"tf":1.0},"5":{"tf":1.4142135623730951},"56":{"tf":1.0},"6":{"tf":1.4142135623730951},"61":{"tf":1.0},"7":{"tf":1.4142135623730951},"8":{"tf":1.4142135623730951},"9":{"tf":1.4142135623730951}}},"n":{"c":{"df":5,"docs":{"103":{"tf":1.0},"30":{"tf":1.7320508075688772},"50":{"tf":1.0},"56":{"tf":1.0},"71":{"tf":1.0}}},"df":0,"docs":{},"t":{"df":1,"docs":{"70":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"70":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"a":{"d":{"df":10,"docs":{"21":{"tf":1.0},"48":{"tf":1.4142135623730951},"54":{"tf":1.0},"56":{"tf":1.7320508075688772},"75":{"tf":1.0},"8":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.4142135623730951},"93":{"tf":1.0},"99":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"1":{"tf":1.0},"108":{"tf":1.0}}}},"df":0,"docs":{}}}}},"t":{"df":1,"docs":{"93":{"tf":1.0}},"e":{"df":0,"docs":{},"g":{"df":3,"docs":{"59":{"tf":1.4142135623730951},"75":{"tf":1.0},"93":{"tf":1.0}},"r":{"df":2,"docs":{"71":{"tf":1.0},"73":{"tf":1.0}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":1,"docs":{"61":{"tf":1.0}}}}}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"j":{"df":1,"docs":{"65":{"tf":1.0}}}}}},"n":{"d":{"df":2,"docs":{"22":{"tf":1.0},"48":{"tf":1.0}}},"df":0,"docs":{}},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":5,"docs":{"26":{"tf":1.0},"30":{"tf":1.0},"40":{"tf":1.0},"64":{"tf":1.0},"70":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"f":{"a":{"c":{"df":2,"docs":{"61":{"tf":1.0},"93":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"n":{"df":2,"docs":{"49":{"tf":1.0},"99":{"tf":1.0}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"93":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":3,"docs":{"54":{"tf":1.0},"57":{"tf":1.4142135623730951},"99":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"70":{"tf":1.0}}}}}}}},"r":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"26":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"39":{"tf":1.0}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"95":{"tf":1.0}}}}},"o":{"c":{"df":2,"docs":{"57":{"tf":1.0},"94":{"tf":1.0}}},"df":0,"docs":{},"k":{"df":4,"docs":{"22":{"tf":1.0},"33":{"tf":1.0},"54":{"tf":1.0},"60":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"n":{"\'":{"df":0,"docs":{},"t":{"df":3,"docs":{"100":{"tf":1.0},"116":{"tf":1.0},"54":{"tf":1.0}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"u":{"df":2,"docs":{"111":{"tf":1.4142135623730951},"68":{"tf":1.0}}}}},"t":{"\'":{"df":3,"docs":{"103":{"tf":1.0},"17":{"tf":1.0},"89":{"tf":1.0}}},"_":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"116":{"tf":1.0}}}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"l":{"df":3,"docs":{"87":{"tf":1.0},"90":{"tf":1.0},"93":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":10,"docs":{"106":{"tf":1.0},"116":{"tf":1.4142135623730951},"22":{"tf":1.0},"40":{"tf":1.0},"48":{"tf":2.0},"52":{"tf":1.4142135623730951},"60":{"tf":1.7320508075688772},"70":{"tf":1.0},"83":{"tf":1.4142135623730951},"93":{"tf":1.0}},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":1,"docs":{"22":{"tf":1.0}}}}}},"r":{"df":1,"docs":{"50":{"tf":1.0}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":4,"docs":{"103":{"tf":1.0},"29":{"tf":1.0},"63":{"tf":1.0},"70":{"tf":1.0}}}}}}}},"j":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"61":{"tf":1.0}}}}},"v":{"a":{"df":1,"docs":{"61":{"tf":1.0}},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":2,"docs":{"103":{"tf":1.0},"61":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"d":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":1,"docs":{"61":{"tf":1.0}}}}},"df":7,"docs":{"44":{"tf":1.0},"46":{"tf":1.4142135623730951},"48":{"tf":2.449489742783178},"49":{"tf":1.0},"60":{"tf":3.3166247903554},"94":{"tf":1.0},"95":{"tf":1.4142135623730951}},"e":{"d":{"df":0,"docs":{},"i":{"df":1,"docs":{"61":{"tf":1.0}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"j":{"a":{"df":1,"docs":{"61":{"tf":1.0}}},"df":0,"docs":{}}}},"j":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"61":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"k":{"df":2,"docs":{"94":{"tf":1.0},"95":{"tf":1.0}}},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"46":{"tf":1.0},"60":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"a":{"c":{"df":2,"docs":{"46":{"tf":1.0},"60":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}},"df":4,"docs":{"35":{"tf":1.7320508075688772},"46":{"tf":1.4142135623730951},"59":{"tf":2.449489742783178},"60":{"tf":2.23606797749979}}}}},"q":{"df":1,"docs":{"61":{"tf":1.4142135623730951}}},"s":{"d":{"df":0,"docs":{},"o":{"c":{"df":1,"docs":{"61":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"5":{"df":1,"docs":{"61":{"tf":1.0}}},"c":{"df":1,"docs":{"61":{"tf":1.0}}},"df":3,"docs":{"105":{"tf":1.0},"57":{"tf":2.0},"61":{"tf":2.23606797749979}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"61":{"tf":1.4142135623730951}}}}}}},"x":{"df":2,"docs":{"103":{"tf":1.0},"61":{"tf":1.0}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"a":{"df":1,"docs":{"61":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"m":{"df":0,"docs":{},"p":{"_":{"b":{"a":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":2,"docs":{"44":{"tf":1.0},"60":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":2,"docs":{"44":{"tf":1.0},"60":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"_":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"p":{"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"df":6,"docs":{"44":{"tf":1.4142135623730951},"48":{"tf":1.0},"59":{"tf":1.4142135623730951},"60":{"tf":2.6457513110645907},"70":{"tf":1.4142135623730951},"93":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"k":{"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":3,"docs":{"44":{"tf":1.7320508075688772},"48":{"tf":1.0},"60":{"tf":2.0}}}}}}}},"n":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"22":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"k":{"a":{"df":0,"docs":{},"k":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":5,"docs":{"29":{"tf":1.0},"30":{"tf":1.0},"37":{"tf":1.4142135623730951},"48":{"tf":1.0},"63":{"tf":1.4142135623730951}},"e":{"\'":{"df":1,"docs":{"63":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"d":{"df":0,"docs":{},"l":{"df":1,"docs":{"61":{"tf":1.0}}}},"df":9,"docs":{"44":{"tf":1.0},"46":{"tf":1.4142135623730951},"48":{"tf":2.449489742783178},"49":{"tf":1.0},"52":{"tf":1.0},"60":{"tf":3.3166247903554},"93":{"tf":1.0},"94":{"tf":1.0},"95":{"tf":1.7320508075688772}},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"46":{"tf":1.0},"60":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"46":{"tf":1.0},"60":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":6,"docs":{"45":{"tf":1.0},"46":{"tf":1.4142135623730951},"48":{"tf":1.0},"50":{"tf":1.0},"60":{"tf":1.4142135623730951},"89":{"tf":1.0}}}},"y":{".":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":1,"docs":{"87":{"tf":1.0}}}}}},"1":{"df":1,"docs":{"102":{"tf":1.0}}},"2":{"df":1,"docs":{"102":{"tf":1.0}}},"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":8,"docs":{"0":{"tf":1.4142135623730951},"40":{"tf":1.0},"48":{"tf":1.0},"51":{"tf":1.4142135623730951},"60":{"tf":1.0},"65":{"tf":1.4142135623730951},"83":{"tf":1.4142135623730951},"94":{"tf":1.7320508075688772}}},"df":0,"docs":{}}},"o":{"a":{"df":0,"docs":{},"r":{"d":{"df":2,"docs":{"83":{"tf":1.0},"96":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":43,"docs":{"100":{"tf":1.7320508075688772},"102":{"tf":1.0},"104":{"tf":2.23606797749979},"105":{"tf":1.4142135623730951},"109":{"tf":1.0},"116":{"tf":2.0},"26":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":1.0},"42":{"tf":1.0},"43":{"tf":1.0},"44":{"tf":1.0},"45":{"tf":1.4142135623730951},"46":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":3.4641016151377544},"49":{"tf":1.7320508075688772},"51":{"tf":1.4142135623730951},"52":{"tf":1.4142135623730951},"56":{"tf":1.0},"60":{"tf":1.0},"70":{"tf":1.0},"72":{"tf":2.0},"73":{"tf":1.0},"74":{"tf":1.0},"75":{"tf":1.0},"77":{"tf":1.0},"78":{"tf":1.0},"79":{"tf":1.7320508075688772},"80":{"tf":1.0},"81":{"tf":1.4142135623730951},"82":{"tf":1.0},"83":{"tf":2.449489742783178},"84":{"tf":1.0},"87":{"tf":2.23606797749979},"89":{"tf":1.0},"93":{"tf":2.449489742783178},"94":{"tf":3.7416573867739413},"95":{"tf":1.4142135623730951},"96":{"tf":3.7416573867739413},"99":{"tf":2.23606797749979}},"m":{"a":{"df":0,"docs":{},"p":{"df":17,"docs":{"0":{"tf":1.0},"31":{"tf":1.0},"36":{"tf":1.0},"40":{"tf":1.0},"42":{"tf":1.7320508075688772},"43":{"tf":1.0},"44":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.0},"64":{"tf":1.0},"94":{"tf":1.7320508075688772}}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"48":{"tf":1.0},"70":{"tf":1.0}}}}}}},"s":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"j":{"df":1,"docs":{"95":{"tf":1.0}}}},"df":3,"docs":{"49":{"tf":1.0},"83":{"tf":1.0},"94":{"tf":1.4142135623730951}}}}}}}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"l":{".":{"df":0,"docs":{},"g":{"df":1,"docs":{"95":{"tf":1.0}}},"z":{"df":1,"docs":{"95":{"tf":1.0}}}},"df":0,"docs":{}}},"df":5,"docs":{"56":{"tf":1.0},"83":{"tf":1.0},"94":{"tf":1.4142135623730951},"95":{"tf":1.0},"96":{"tf":1.4142135623730951}}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"83":{"tf":1.0},"94":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"\\"":{"df":1,"docs":{"92":{"tf":1.0}}},"df":3,"docs":{"119":{"tf":1.0},"92":{"tf":1.0},"93":{"tf":1.7320508075688772}}},"df":0,"docs":{}}}}}},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"49":{"tf":1.0},"60":{"tf":1.0}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":2,"docs":{"49":{"tf":1.0},"60":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"n":{"d":{">":{"]":{"<":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{">":{"<":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"s":{">":{"<":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":1,"docs":{"56":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":6,"docs":{"100":{"tf":1.0},"117":{"tf":1.4142135623730951},"40":{"tf":1.0},"56":{"tf":1.7320508075688772},"93":{"tf":2.23606797749979},"94":{"tf":1.0}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"24":{"tf":1.0}}}}}},"l":{"df":0,"docs":{},"u":{"d":{"df":0,"docs":{},"g":{"df":1,"docs":{"48":{"tf":1.0}}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":2,"docs":{"120":{"tf":1.0},"42":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"k":{"a":{"df":1,"docs":{"61":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"61":{"tf":1.4142135623730951}}}}},"o":{"df":1,"docs":{"61":{"tf":1.4142135623730951}}}}}},"l":{"a":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":4,"docs":{"48":{"tf":1.4142135623730951},"60":{"tf":1.4142135623730951},"70":{"tf":1.4142135623730951},"93":{"tf":2.0}}}}},"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"83":{"tf":1.0}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"g":{"df":0,"docs":{},"y":{"/":{"df":0,"docs":{},"j":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"df":1,"docs":{"73":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"n":{"df":0,"docs":{},"g":{"df":2,"docs":{"41":{"tf":1.4142135623730951},"59":{"tf":1.0}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{"df":2,"docs":{"102":{"tf":1.0},"61":{"tf":2.0}}}}}},"u":{"a":{"df":0,"docs":{},"g":{"df":33,"docs":{"0":{"tf":1.0},"1":{"tf":1.4142135623730951},"100":{"tf":1.7320508075688772},"101":{"tf":1.0},"102":{"tf":4.58257569495584},"103":{"tf":5.916079783099616},"104":{"tf":1.0},"105":{"tf":1.4142135623730951},"106":{"tf":1.0},"107":{"tf":2.0},"108":{"tf":3.7416573867739413},"109":{"tf":1.4142135623730951},"110":{"tf":1.7320508075688772},"111":{"tf":1.0},"112":{"tf":1.0},"113":{"tf":1.0},"116":{"tf":1.0},"119":{"tf":2.0},"120":{"tf":2.449489742783178},"121":{"tf":1.0},"39":{"tf":1.0},"41":{"tf":1.0},"42":{"tf":1.0},"56":{"tf":1.4142135623730951},"59":{"tf":2.8284271247461903},"61":{"tf":7.681145747868608},"70":{"tf":1.0},"73":{"tf":1.7320508075688772},"76":{"tf":1.7320508075688772},"93":{"tf":2.6457513110645907},"97":{"tf":2.23606797749979},"98":{"tf":2.8284271247461903},"99":{"tf":5.196152422706632}},"e":{"\'":{"df":1,"docs":{"104":{"tf":1.0}}},".":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"76":{"tf":1.0}}}}}},"df":0,"docs":{}},"]":{".":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"102":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":11,"docs":{"100":{"tf":1.0},"102":{"tf":1.0},"104":{"tf":1.0},"108":{"tf":1.0},"109":{"tf":1.0},"120":{"tf":1.4142135623730951},"70":{"tf":1.0},"76":{"tf":1.0},"97":{"tf":1.0},"98":{"tf":2.0},"99":{"tf":1.0}}}}}}},"df":0,"docs":{}},"}":{"/":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"m":{"df":1,"docs":{"114":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"k":{"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":11,"docs":{"116":{"tf":1.0},"34":{"tf":2.0},"35":{"tf":1.0},"41":{"tf":1.0},"44":{"tf":1.0},"45":{"tf":1.0},"48":{"tf":2.449489742783178},"51":{"tf":1.0},"60":{"tf":3.1622776601683795},"70":{"tf":1.0},"77":{"tf":1.4142135623730951}}}},"t":{"df":1,"docs":{"59":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":4,"docs":{"45":{"tf":1.0},"52":{"tf":1.0},"59":{"tf":1.4142135623730951},"60":{"tf":1.0}}},"s":{"df":0,"docs":{},"t":{"df":4,"docs":{"1":{"tf":1.0},"12":{"tf":1.0},"17":{"tf":1.0},"9":{"tf":1.0}}}},"x":{"df":1,"docs":{"61":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"h":{"df":2,"docs":{"43":{"tf":1.0},"60":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"25":{"tf":1.0}}}}}},"df":0,"docs":{}}},"y":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"48":{"tf":1.4142135623730951}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"81":{"tf":1.4142135623730951}}}}}}},"d":{"df":1,"docs":{"61":{"tf":1.4142135623730951}},"i":{"df":0,"docs":{},"f":{"df":1,"docs":{"61":{"tf":1.0}}}}},"df":4,"docs":{"44":{"tf":1.0},"48":{"tf":2.0},"56":{"tf":1.0},"60":{"tf":2.8284271247461903}},"e":{"a":{"d":{"df":2,"docs":{"116":{"tf":1.0},"64":{"tf":1.0}}},"df":0,"docs":{},"n":{"df":1,"docs":{"61":{"tf":1.4142135623730951}}},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"49":{"tf":1.0}}}},"v":{"df":1,"docs":{"25":{"tf":1.0}}}},"d":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"61":{"tf":1.0}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":10,"docs":{"44":{"tf":1.4142135623730951},"46":{"tf":1.0},"48":{"tf":1.7320508075688772},"49":{"tf":1.4142135623730951},"52":{"tf":1.4142135623730951},"60":{"tf":3.1622776601683795},"72":{"tf":2.0},"82":{"tf":1.0},"83":{"tf":1.4142135623730951},"96":{"tf":1.4142135623730951}}}},"n":{"df":2,"docs":{"70":{"tf":1.0},"84":{"tf":1.0}},"g":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":4,"docs":{"70":{"tf":1.4142135623730951},"72":{"tf":1.0},"73":{"tf":1.4142135623730951},"99":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"49":{"tf":1.0}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":8,"docs":{"105":{"tf":1.0},"114":{"tf":1.4142135623730951},"115":{"tf":1.4142135623730951},"116":{"tf":3.7416573867739413},"118":{"tf":1.4142135623730951},"70":{"tf":1.0},"80":{"tf":1.7320508075688772},"81":{"tf":1.0}}}}}},"f":{"df":3,"docs":{"59":{"tf":1.0},"70":{"tf":1.4142135623730951},"72":{"tf":1.0}}},"i":{"b":{"c":{"df":2,"docs":{"21":{"tf":1.0},"25":{"tf":1.0}}},"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"21":{"tf":1.0},"99":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":2,"docs":{"115":{"tf":2.449489742783178},"116":{"tf":2.449489742783178}}}},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":1,"docs":{"89":{"tf":2.6457513110645907}}}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":3,"docs":{"73":{"tf":1.0},"74":{"tf":1.0},"94":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"e":{"\'":{"df":2,"docs":{"56":{"tf":1.0},"70":{"tf":1.0}}},"?":{"/":{"#":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"117":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"56":{"tf":1.0}}},"df":0,"docs":{}}}},"df":35,"docs":{"101":{"tf":1.0},"114":{"tf":2.6457513110645907},"115":{"tf":3.605551275463989},"116":{"tf":5.196152422706632},"117":{"tf":2.0},"118":{"tf":2.449489742783178},"17":{"tf":1.0},"2":{"tf":1.0},"29":{"tf":1.0},"44":{"tf":2.0},"45":{"tf":2.0},"46":{"tf":3.1622776601683795},"48":{"tf":3.4641016151377544},"49":{"tf":2.6457513110645907},"50":{"tf":1.0},"52":{"tf":1.4142135623730951},"53":{"tf":2.449489742783178},"54":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":3.4641016151377544},"57":{"tf":2.0},"59":{"tf":2.0},"60":{"tf":6.164414002968976},"63":{"tf":1.0},"68":{"tf":1.4142135623730951},"70":{"tf":4.898979485566356},"72":{"tf":2.6457513110645907},"81":{"tf":2.23606797749979},"82":{"tf":2.0},"84":{"tf":3.7416573867739413},"87":{"tf":1.0},"91":{"tf":1.0},"93":{"tf":4.0},"94":{"tf":1.0},"99":{"tf":1.4142135623730951}}},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"99":{"tf":1.0}}}}}}},"k":{"df":6,"docs":{"119":{"tf":1.0},"22":{"tf":1.7320508075688772},"24":{"tf":1.0},"64":{"tf":1.0},"75":{"tf":1.0},"93":{"tf":2.0}}},"t":{"df":1,"docs":{"61":{"tf":1.0}}},"u":{"df":0,"docs":{},"x":{"/":{"df":0,"docs":{},"m":{"a":{"c":{"df":0,"docs":{},"o":{"df":1,"docs":{"2":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":10,"docs":{"112":{"tf":1.0},"12":{"tf":1.0},"21":{"tf":1.4142135623730951},"22":{"tf":1.0},"3":{"tf":1.4142135623730951},"4":{"tf":1.4142135623730951},"68":{"tf":1.0},"75":{"tf":1.0},"8":{"tf":1.4142135623730951},"94":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"p":{"df":2,"docs":{"112":{"tf":1.0},"61":{"tf":1.0}}},"t":{"df":14,"docs":{"100":{"tf":1.0},"102":{"tf":1.4142135623730951},"103":{"tf":1.4142135623730951},"110":{"tf":1.0},"116":{"tf":2.0},"26":{"tf":1.0},"60":{"tf":1.0},"67":{"tf":1.0},"70":{"tf":1.0},"72":{"tf":2.23606797749979},"87":{"tf":1.0},"89":{"tf":1.0},"93":{"tf":1.4142135623730951},"94":{"tf":1.7320508075688772}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":4,"docs":{"54":{"tf":1.4142135623730951},"79":{"tf":1.0},"80":{"tf":1.0},"96":{"tf":1.0}}}},"t":{"df":0,"docs":{},"l":{"df":1,"docs":{"73":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"e":{"df":1,"docs":{"98":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"v":{"df":0,"docs":{},"m":{"df":1,"docs":{"61":{"tf":1.7320508075688772}}}}},"n":{"df":1,"docs":{"22":{"tf":1.0}}},"o":{"a":{"d":{"df":2,"docs":{"21":{"tf":1.0},"59":{"tf":1.0}}},"df":0,"docs":{}},"c":{"a":{"df":0,"docs":{},"l":{"/":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"12":{"tf":1.0}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"/":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"24":{"tf":1.0}},"i":{"c":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"/":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{".":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"k":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":1,"docs":{"24":{"tf":1.7320508075688772}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"24":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":8,"docs":{"109":{"tf":1.0},"112":{"tf":1.4142135623730951},"21":{"tf":1.0},"5":{"tf":1.0},"68":{"tf":1.0},"75":{"tf":1.4142135623730951},"84":{"tf":1.0},"98":{"tf":1.0}}},"t":{"df":8,"docs":{"111":{"tf":1.7320508075688772},"2":{"tf":1.7320508075688772},"32":{"tf":1.0},"39":{"tf":1.0},"48":{"tf":1.0},"68":{"tf":1.0},"75":{"tf":1.0},"98":{"tf":1.0}}}},"df":0,"docs":{},"k":{"df":3,"docs":{"21":{"tf":1.4142135623730951},"22":{"tf":1.0},"25":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"g":{"df":3,"docs":{"59":{"tf":1.4142135623730951},"60":{"tf":1.0},"61":{"tf":1.0}}},"n":{"df":0,"docs":{},"g":{"df":3,"docs":{"25":{"tf":1.0},"60":{"tf":2.8284271247461903},"84":{"tf":1.0}},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"93":{"tf":1.0}}}}}}},"o":{"df":0,"docs":{},"k":{"df":6,"docs":{"102":{"tf":1.0},"103":{"tf":1.0},"22":{"tf":1.0},"48":{"tf":1.0},"79":{"tf":1.0},"99":{"tf":1.0}}},"p":{"df":1,"docs":{"93":{"tf":1.0}}}},"s":{"df":0,"docs":{},"e":{"df":1,"docs":{"116":{"tf":1.0}}},"s":{"df":1,"docs":{"70":{"tf":1.0}}},"t":{"df":1,"docs":{"77":{"tf":1.0}}}},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"c":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"60":{"tf":1.0}}}},"df":0,"docs":{}},"df":1,"docs":{"45":{"tf":1.0}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"114":{"tf":1.0}}}}}}},"p":{"df":0,"docs":{},"f":{"df":1,"docs":{"61":{"tf":1.0}}}},"s":{"df":1,"docs":{"61":{"tf":3.0}},"p":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"57":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":13,"docs":{"102":{"tf":2.0},"103":{"tf":2.23606797749979},"42":{"tf":1.0},"45":{"tf":1.0},"48":{"tf":4.123105625617661},"57":{"tf":1.4142135623730951},"59":{"tf":1.7320508075688772},"61":{"tf":4.58257569495584},"70":{"tf":1.4142135623730951},"72":{"tf":1.0},"73":{"tf":2.0},"98":{"tf":1.4142135623730951},"99":{"tf":2.23606797749979}}}},"t":{"df":1,"docs":{"60":{"tf":1.4142135623730951}}},"u":{"a":{"df":1,"docs":{"61":{"tf":1.4142135623730951}},"u":{"df":1,"docs":{"61":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"m":{"a":{"c":{"df":3,"docs":{"68":{"tf":1.0},"75":{"tf":1.0},"96":{"tf":1.0}},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"100":{"tf":1.0}}}}},"o":{"df":5,"docs":{"13":{"tf":1.4142135623730951},"21":{"tf":1.4142135623730951},"22":{"tf":1.0},"3":{"tf":1.0},"70":{"tf":1.0}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":2,"docs":{"15":{"tf":1.4142135623730951},"3":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"o":{"df":6,"docs":{"34":{"tf":1.0},"45":{"tf":1.4142135623730951},"60":{"tf":1.4142135623730951},"61":{"tf":1.0},"93":{"tf":1.0},"94":{"tf":2.23606797749979}}}}},"df":2,"docs":{"37":{"tf":1.4142135623730951},"60":{"tf":1.4142135623730951}},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"a":{"df":1,"docs":{"89":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"61":{"tf":1.0}}},"n":{"df":6,"docs":{"27":{"tf":1.0},"46":{"tf":1.4142135623730951},"48":{"tf":1.0},"59":{"tf":1.4142135623730951},"60":{"tf":1.4142135623730951},"84":{"tf":1.4142135623730951}}}},"k":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"h":{"_":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"_":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"60":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":17,"docs":{"108":{"tf":1.0},"109":{"tf":1.0},"11":{"tf":1.0},"111":{"tf":1.0},"113":{"tf":1.0},"114":{"tf":1.0},"12":{"tf":1.0},"17":{"tf":1.0},"22":{"tf":1.0},"23":{"tf":1.0},"27":{"tf":1.0},"50":{"tf":1.0},"60":{"tf":1.7320508075688772},"61":{"tf":1.0},"70":{"tf":1.0},"9":{"tf":1.0},"95":{"tf":1.0}},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"100":{"tf":1.7320508075688772}}}}}}},"n":{"a":{"df":0,"docs":{},"g":{"df":19,"docs":{"1":{"tf":1.0},"10":{"tf":1.0},"11":{"tf":1.0},"12":{"tf":1.0},"13":{"tf":1.0},"14":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.4142135623730951},"18":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0},"3":{"tf":1.7320508075688772},"4":{"tf":1.0},"5":{"tf":1.0},"6":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":4,"docs":{"116":{"tf":1.0},"39":{"tf":1.0},"64":{"tf":1.0},"84":{"tf":1.0}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":5,"docs":{"31":{"tf":1.0},"37":{"tf":1.7320508075688772},"42":{"tf":1.0},"46":{"tf":1.4142135623730951},"48":{"tf":1.0}}}}}}},"p":{"df":7,"docs":{"116":{"tf":2.0},"26":{"tf":1.0},"42":{"tf":2.23606797749979},"48":{"tf":1.7320508075688772},"76":{"tf":1.0},"94":{"tf":3.1622776601683795},"95":{"tf":1.4142135623730951}}},"r":{"df":0,"docs":{},"k":{"d":{"df":0,"docs":{},"o":{"c":{"df":1,"docs":{"61":{"tf":1.4142135623730951}}},"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"61":{"tf":1.0}}}}}}}},"df":1,"docs":{"61":{"tf":1.7320508075688772}}}}}},"df":2,"docs":{"120":{"tf":1.0},"42":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"93":{"tf":1.0},"99":{"tf":1.0}}}},"s":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"61":{"tf":1.0}}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"p":{"df":2,"docs":{"93":{"tf":1.4142135623730951},"99":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"0":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}}}}}},"t":{"c":{"df":0,"docs":{},"h":{"?":{"/":{"#":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"117":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"_":{"b":{"df":0,"docs":{},"r":{"a":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":14,"docs":{"100":{"tf":2.8284271247461903},"117":{"tf":1.7320508075688772},"121":{"tf":1.0},"122":{"tf":1.4142135623730951},"25":{"tf":1.0},"41":{"tf":1.0},"42":{"tf":1.0},"46":{"tf":2.0},"47":{"tf":1.4142135623730951},"48":{"tf":1.7320508075688772},"60":{"tf":3.0},"78":{"tf":1.0},"93":{"tf":1.7320508075688772},"99":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"100":{"tf":1.0}}},"s":{"!":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":1,"docs":{"115":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{},"l":{"a":{"b":{"df":1,"docs":{"61":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"114":{"tf":1.0}}}}}},"x":{"df":3,"docs":{"75":{"tf":1.0},"82":{"tf":2.0},"84":{"tf":1.4142135623730951}},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":7,"docs":{"102":{"tf":1.0},"70":{"tf":1.0},"73":{"tf":1.0},"75":{"tf":1.0},"82":{"tf":1.4142135623730951},"84":{"tf":1.0},"99":{"tf":1.0}}}}}}}},"d":{"<":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"36":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":2,"docs":{"33":{"tf":1.0},"60":{"tf":1.4142135623730951}}},"df":7,"docs":{"33":{"tf":1.0},"37":{"tf":1.0},"44":{"tf":1.0},"48":{"tf":2.23606797749979},"56":{"tf":1.4142135623730951},"57":{"tf":1.4142135623730951},"95":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"n":{"df":9,"docs":{"114":{"tf":1.0},"118":{"tf":1.0},"27":{"tf":1.0},"29":{"tf":1.0},"41":{"tf":1.0},"63":{"tf":1.0},"75":{"tf":1.0},"83":{"tf":1.4142135623730951},"96":{"tf":1.0}}}},"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"49":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"93":{"tf":1.0}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"28":{"tf":1.0}}}}}},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":4,"docs":{"116":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.0},"63":{"tf":1.0}}}}}},"u":{"df":7,"docs":{"103":{"tf":1.0},"24":{"tf":1.4142135623730951},"42":{"tf":1.0},"48":{"tf":1.7320508075688772},"70":{"tf":1.0},"83":{"tf":2.0},"93":{"tf":1.0}}}},"r":{"df":0,"docs":{},"g":{"df":7,"docs":{"103":{"tf":1.0},"46":{"tf":1.4142135623730951},"60":{"tf":1.4142135623730951},"68":{"tf":1.0},"89":{"tf":1.0},"93":{"tf":1.0},"98":{"tf":1.0}},"e":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"46":{"tf":1.0},"60":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"46":{"tf":1.0},"60":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"m":{"a":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"61":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"61":{"tf":1.0}},"l":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":1,"docs":{"61":{"tf":1.0}}}}}}},"s":{"a":{"df":0,"docs":{},"g":{"df":2,"docs":{"60":{"tf":1.0},"73":{"tf":2.0}}}},"df":0,"docs":{}}},"t":{"a":{"df":1,"docs":{"96":{"tf":1.4142135623730951}},"l":{"df":1,"docs":{"61":{"tf":1.0}}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"d":{"df":3,"docs":{"104":{"tf":1.0},"22":{"tf":1.0},"93":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}},"i":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":1,"docs":{"17":{"tf":1.0}}}}}}}}},"d":{"d":{"df":0,"docs":{},"l":{"df":4,"docs":{"48":{"tf":1.4142135623730951},"60":{"tf":1.0},"70":{"tf":1.4142135623730951},"72":{"tf":1.0}}}},"df":1,"docs":{"82":{"tf":1.0}}},"df":2,"docs":{"37":{"tf":1.4142135623730951},"60":{"tf":1.4142135623730951}},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"63":{"tf":2.23606797749979}}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"70":{"tf":1.4142135623730951},"77":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"n":{"d":{"df":1,"docs":{"89":{"tf":1.0}}},"df":2,"docs":{"70":{"tf":1.0},"81":{"tf":1.4142135623730951}},"g":{"df":0,"docs":{},"w":{"df":1,"docs":{"20":{"tf":1.0}}}},"i":{"df":0,"docs":{},"m":{"df":2,"docs":{"49":{"tf":1.0},"99":{"tf":1.0}},"u":{"df":0,"docs":{},"m":{"df":4,"docs":{"65":{"tf":1.0},"70":{"tf":1.0},"81":{"tf":1.0},"84":{"tf":1.4142135623730951}}}}}},"o":{"df":0,"docs":{},"r":{"df":3,"docs":{"42":{"tf":1.0},"48":{"tf":1.4142135623730951},"95":{"tf":2.0}}}},"t":{"df":3,"docs":{"25":{"tf":1.0},"5":{"tf":1.0},"61":{"tf":1.4142135623730951}}},"u":{"df":4,"docs":{"46":{"tf":1.0},"60":{"tf":1.4142135623730951},"93":{"tf":1.0},"96":{"tf":1.0}}}},"r":{"df":1,"docs":{"61":{"tf":1.4142135623730951}}},"s":{"df":0,"docs":{},"s":{"df":3,"docs":{"116":{"tf":1.0},"64":{"tf":1.0},"70":{"tf":1.0}}}},"w":{"<":{"a":{"df":1,"docs":{"94":{"tf":1.0}}},"df":0,"docs":{}},"df":1,"docs":{"94":{"tf":1.0}}}},"k":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":1,"docs":{"12":{"tf":1.0}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":1,"docs":{"22":{"tf":1.0}}}}}}},"m":{"df":1,"docs":{"60":{"tf":1.4142135623730951}}},"o":{"d":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"27":{"tf":1.0},"49":{"tf":2.0}}}},"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"72":{"tf":1.4142135623730951}}}}}}}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"l":{"/":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"/":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"72":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":1,"docs":{"72":{"tf":1.4142135623730951}}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"72":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}}},"df":26,"docs":{"12":{"tf":1.0},"27":{"tf":3.1622776601683795},"30":{"tf":1.0},"33":{"tf":1.0},"40":{"tf":1.0},"42":{"tf":3.0},"43":{"tf":2.23606797749979},"45":{"tf":1.4142135623730951},"48":{"tf":5.385164807134504},"49":{"tf":2.8284271247461903},"50":{"tf":2.449489742783178},"56":{"tf":1.0},"59":{"tf":1.4142135623730951},"60":{"tf":2.0},"64":{"tf":2.23606797749979},"65":{"tf":1.0},"66":{"tf":1.4142135623730951},"67":{"tf":1.0},"68":{"tf":1.0},"70":{"tf":2.23606797749979},"72":{"tf":3.1622776601683795},"74":{"tf":2.0},"84":{"tf":1.0},"93":{"tf":3.0},"94":{"tf":2.0},"95":{"tf":2.6457513110645907}},"l":{"df":3,"docs":{"29":{"tf":1.0},"63":{"tf":1.4142135623730951},"64":{"tf":1.0}}},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"17":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"f":{"df":4,"docs":{"48":{"tf":1.0},"60":{"tf":1.0},"72":{"tf":1.4142135623730951},"93":{"tf":1.0}},"i":{"df":13,"docs":{"24":{"tf":1.0},"31":{"tf":1.0},"53":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.4142135623730951},"72":{"tf":1.0},"87":{"tf":2.0},"90":{"tf":2.23606797749979},"91":{"tf":1.0},"93":{"tf":1.4142135623730951},"94":{"tf":1.4142135623730951},"95":{"tf":1.0},"96":{"tf":2.449489742783178}},"e":{"d":{"/":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"48":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"j":{"df":0,"docs":{},"o":{"df":1,"docs":{"61":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"df":17,"docs":{"108":{"tf":1.0},"110":{"tf":1.0},"112":{"tf":1.0},"116":{"tf":1.4142135623730951},"118":{"tf":1.0},"119":{"tf":1.0},"21":{"tf":1.0},"23":{"tf":1.0},"31":{"tf":1.0},"39":{"tf":1.0},"40":{"tf":1.0},"49":{"tf":1.0},"51":{"tf":1.0},"61":{"tf":1.0},"70":{"tf":1.4142135623730951},"94":{"tf":1.0},"99":{"tf":1.4142135623730951}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"48":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":5,"docs":{"31":{"tf":2.0},"39":{"tf":1.7320508075688772},"44":{"tf":1.0},"50":{"tf":1.0},"60":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"s":{"df":2,"docs":{"68":{"tf":1.0},"70":{"tf":1.4142135623730951}}}},"v":{"df":0,"docs":{},"e":{"_":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":4,"docs":{"44":{"tf":1.0},"49":{"tf":1.0},"60":{"tf":1.0},"94":{"tf":1.4142135623730951}}}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":4,"docs":{"44":{"tf":1.0},"49":{"tf":1.0},"60":{"tf":1.0},"94":{"tf":1.0}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"_":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":3,"docs":{"48":{"tf":1.0},"49":{"tf":1.0},"60":{"tf":1.0}}}}}},"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":4,"docs":{"48":{"tf":1.0},"49":{"tf":1.0},"60":{"tf":1.0},"94":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"44":{"tf":1.0},"60":{"tf":1.0}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":2,"docs":{"44":{"tf":1.0},"60":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"s":{"df":0,"docs":{},"u":{"b":{"_":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"60":{"tf":1.0}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"60":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"44":{"tf":1.0},"60":{"tf":1.0}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":2,"docs":{"44":{"tf":1.0},"60":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"p":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":3,"docs":{"46":{"tf":1.0},"60":{"tf":1.0},"83":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":3,"docs":{"46":{"tf":1.0},"60":{"tf":1.0},"83":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"60":{"tf":1.0}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":2,"docs":{"44":{"tf":1.0},"60":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"s":{"df":0,"docs":{},"u":{"b":{"_":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"60":{"tf":1.0}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"60":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"60":{"tf":1.0}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":2,"docs":{"44":{"tf":1.0},"60":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"_":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":2,"docs":{"44":{"tf":1.0},"60":{"tf":1.0}}}}}},"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":2,"docs":{"44":{"tf":1.0},"60":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":15,"docs":{"31":{"tf":1.4142135623730951},"38":{"tf":1.4142135623730951},"39":{"tf":2.23606797749979},"44":{"tf":4.0},"45":{"tf":1.4142135623730951},"46":{"tf":1.4142135623730951},"48":{"tf":3.1622776601683795},"49":{"tf":2.449489742783178},"52":{"tf":1.4142135623730951},"59":{"tf":1.4142135623730951},"60":{"tf":5.830951894845301},"61":{"tf":1.0},"77":{"tf":1.0},"84":{"tf":1.0},"93":{"tf":1.4142135623730951}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":5,"docs":{"31":{"tf":1.0},"42":{"tf":1.0},"44":{"tf":1.4142135623730951},"50":{"tf":1.0},"94":{"tf":1.0}}}}}}}}},"r":{"<":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"a":{"c":{"df":0,"docs":{},"e":{">":{"<":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"_":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"36":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":2,"docs":{"36":{"tf":1.0},"60":{"tf":1.4142135623730951}}},"s":{"<":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"36":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"61":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":1,"docs":{"60":{"tf":1.4142135623730951}},"y":{"df":0,"docs":{},"s":{"2":{"df":3,"docs":{"16":{"tf":1.0},"20":{"tf":1.4142135623730951},"3":{"tf":1.0}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"99":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"l":{"df":14,"docs":{"103":{"tf":1.0},"104":{"tf":1.0},"114":{"tf":1.0},"116":{"tf":1.7320508075688772},"21":{"tf":1.0},"22":{"tf":1.7320508075688772},"28":{"tf":1.0},"30":{"tf":2.0},"35":{"tf":1.4142135623730951},"36":{"tf":1.4142135623730951},"41":{"tf":1.0},"57":{"tf":1.0},"70":{"tf":1.0},"93":{"tf":2.0}},"e":{"/":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":1,"docs":{"72":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"s":{"df":0,"docs":{},"l":{"df":1,"docs":{"21":{"tf":1.0}}},"t":{"/":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"117":{"tf":2.23606797749979}}}}}}},"df":0,"docs":{}}},"t":{"df":1,"docs":{"93":{"tf":1.0}}}},"v":{"df":2,"docs":{"12":{"tf":1.0},"59":{"tf":1.0}}},"y":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":5,"docs":{"101":{"tf":1.0},"102":{"tf":1.0},"104":{"tf":1.0},"98":{"tf":1.0},"99":{"tf":2.23606797749979}}}}},"df":1,"docs":{"99":{"tf":1.0}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"86":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}}}},"n":{"/":{"a":{"df":2,"docs":{"45":{"tf":1.0},"48":{"tf":2.8284271247461903}}},"c":{"df":1,"docs":{"83":{"tf":1.0}}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":28,"docs":{"100":{"tf":1.0},"102":{"tf":1.0},"103":{"tf":2.0},"104":{"tf":1.7320508075688772},"112":{"tf":1.0},"114":{"tf":1.0},"117":{"tf":1.0},"12":{"tf":1.0},"120":{"tf":1.0},"22":{"tf":1.4142135623730951},"25":{"tf":1.0},"33":{"tf":1.0},"35":{"tf":1.0},"41":{"tf":1.7320508075688772},"56":{"tf":1.4142135623730951},"57":{"tf":1.4142135623730951},"59":{"tf":2.23606797749979},"60":{"tf":1.0},"72":{"tf":2.23606797749979},"76":{"tf":1.0},"84":{"tf":1.0},"85":{"tf":1.4142135623730951},"86":{"tf":1.7320508075688772},"89":{"tf":1.7320508075688772},"93":{"tf":1.7320508075688772},"96":{"tf":1.0},"98":{"tf":1.0},"99":{"tf":2.6457513110645907}},"s":{"df":0,"docs":{},"p":{"a":{"c":{"df":1,"docs":{"93":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"s":{"df":0,"docs":{},"m":{"df":1,"docs":{"61":{"tf":1.0}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":2,"docs":{"65":{"tf":1.0},"70":{"tf":2.0}}}}},"v":{"df":1,"docs":{"38":{"tf":1.0}},"i":{"df":0,"docs":{},"g":{"df":6,"docs":{"113":{"tf":2.23606797749979},"27":{"tf":1.0},"31":{"tf":1.0},"38":{"tf":1.7320508075688772},"40":{"tf":1.0},"83":{"tf":1.4142135623730951}}}}}},"b":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":1,"docs":{"79":{"tf":2.0}}}}},"df":13,"docs":{"39":{"tf":1.4142135623730951},"44":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.4142135623730951},"48":{"tf":2.23606797749979},"50":{"tf":2.0},"51":{"tf":1.0},"52":{"tf":1.0},"54":{"tf":1.4142135623730951},"56":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":2.449489742783178},"99":{"tf":1.0}},"e":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":3,"docs":{"108":{"tf":1.0},"2":{"tf":1.0},"59":{"tf":1.7320508075688772}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"d":{"_":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"116":{"tf":1.7320508075688772}}}}},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":1,"docs":{"115":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}}}}},"df":1,"docs":{"116":{"tf":1.0}}}}}}},"df":7,"docs":{"1":{"tf":1.0},"107":{"tf":1.0},"110":{"tf":1.0},"111":{"tf":1.0},"116":{"tf":1.0},"25":{"tf":1.0},"37":{"tf":1.0}}},"df":0,"docs":{}},"g":{"df":2,"docs":{"70":{"tf":1.4142135623730951},"75":{"tf":1.0}}},"l":{"df":1,"docs":{"70":{"tf":1.0}}},"o":{"c":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":1,"docs":{"61":{"tf":1.0}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"121":{"tf":1.0},"95":{"tf":1.0}},"e":{"d":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"61":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"t":{"df":1,"docs":{"116":{"tf":1.0}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"70":{"tf":1.4142135623730951}}}}},"w":{"df":17,"docs":{"106":{"tf":1.0},"107":{"tf":1.7320508075688772},"108":{"tf":2.23606797749979},"109":{"tf":1.4142135623730951},"110":{"tf":1.4142135623730951},"114":{"tf":1.7320508075688772},"115":{"tf":2.23606797749979},"116":{"tf":1.7320508075688772},"22":{"tf":1.0},"45":{"tf":1.4142135623730951},"49":{"tf":1.7320508075688772},"59":{"tf":2.0},"60":{"tf":2.0},"70":{"tf":1.4142135623730951},"84":{"tf":1.0},"9":{"tf":1.0},"95":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"115":{"tf":1.0},"70":{"tf":1.0}},"n":{"df":7,"docs":{"35":{"tf":1.0},"46":{"tf":1.0},"48":{"tf":1.4142135623730951},"59":{"tf":1.7320508075688772},"60":{"tf":2.23606797749979},"70":{"tf":1.4142135623730951},"79":{"tf":2.0}}}}}},"x":{"df":0,"docs":{},"t":{"df":17,"docs":{"103":{"tf":1.0},"116":{"tf":1.0},"28":{"tf":1.0},"31":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":1.0},"44":{"tf":2.449489742783178},"46":{"tf":1.7320508075688772},"47":{"tf":1.0},"48":{"tf":3.4641016151377544},"49":{"tf":1.7320508075688772},"50":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":2.0},"59":{"tf":1.4142135623730951},"60":{"tf":6.082762530298219},"73":{"tf":1.0}}}}},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"x":{"df":1,"docs":{"61":{"tf":1.0}}}}}},"i":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"61":{"tf":1.0}}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"1":{"tf":1.0}}}}}}},"l":{"df":2,"docs":{"61":{"tf":1.0},"93":{"tf":1.0}}},"m":{"df":1,"docs":{"61":{"tf":1.0}},"l":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{"df":1,"docs":{"61":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}},"x":{"d":{"df":1,"docs":{"61":{"tf":1.0}}},"df":3,"docs":{"119":{"tf":1.0},"61":{"tf":1.0},"9":{"tf":1.7320508075688772}},"o":{"df":2,"docs":{"3":{"tf":1.0},"9":{"tf":1.4142135623730951}}},"p":{"df":0,"docs":{},"k":{"df":0,"docs":{},"g":{"df":1,"docs":{"9":{"tf":1.0}}}}}}},"l":{"df":1,"docs":{"61":{"tf":1.0}}},"n":{"b":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":1,"docs":{"79":{"tf":2.0}}}}},"df":0,"docs":{}},"o":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":3,"docs":{"49":{"tf":2.8284271247461903},"60":{"tf":1.0},"96":{"tf":1.0}}}}},"d":{"df":0,"docs":{},"e":{"\'":{"df":1,"docs":{"116":{"tf":1.0}}},"df":12,"docs":{"113":{"tf":1.0},"114":{"tf":1.4142135623730951},"115":{"tf":2.0},"116":{"tf":3.4641016151377544},"118":{"tf":2.6457513110645907},"119":{"tf":1.0},"120":{"tf":2.0},"121":{"tf":2.0},"39":{"tf":2.0},"46":{"tf":2.6457513110645907},"48":{"tf":1.0},"60":{"tf":2.8284271247461903}},"’":{"df":1,"docs":{"121":{"tf":1.0}}}}},"df":0,"docs":{},"n":{"df":6,"docs":{"48":{"tf":1.0},"60":{"tf":1.4142135623730951},"70":{"tf":1.0},"73":{"tf":1.0},"83":{"tf":1.0},"93":{"tf":1.0}},"e":{"df":3,"docs":{"34":{"tf":1.0},"70":{"tf":1.7320508075688772},"79":{"tf":2.23606797749979}}}},"o":{"df":0,"docs":{},"p":{"df":2,"docs":{"56":{"tf":1.0},"59":{"tf":1.0}}}},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"d":{"df":4,"docs":{"49":{"tf":1.0},"60":{"tf":1.0},"94":{"tf":1.7320508075688772},"95":{"tf":1.0}}},"df":0,"docs":{}}}},"df":17,"docs":{"116":{"tf":1.0},"27":{"tf":1.7320508075688772},"42":{"tf":1.0},"43":{"tf":1.7320508075688772},"48":{"tf":2.8284271247461903},"49":{"tf":1.7320508075688772},"50":{"tf":1.4142135623730951},"57":{"tf":1.0},"60":{"tf":14.89966442575134},"68":{"tf":1.4142135623730951},"72":{"tf":1.4142135623730951},"74":{"tf":1.4142135623730951},"83":{"tf":1.4142135623730951},"89":{"tf":1.0},"93":{"tf":1.4142135623730951},"94":{"tf":1.4142135623730951},"95":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"63":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":16,"docs":{"1":{"tf":1.0},"100":{"tf":1.0},"105":{"tf":1.0},"112":{"tf":1.0},"114":{"tf":1.0},"116":{"tf":1.7320508075688772},"118":{"tf":1.0},"21":{"tf":1.0},"22":{"tf":1.0},"41":{"tf":1.0},"44":{"tf":1.0},"56":{"tf":1.0},"61":{"tf":1.0},"70":{"tf":1.0},"93":{"tf":1.0},"96":{"tf":1.0}}},"h":{"df":2,"docs":{"59":{"tf":1.0},"60":{"tf":1.0}}}},"w":{"df":1,"docs":{"94":{"tf":1.0}}}},"u":{"a":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}},"df":1,"docs":{"61":{"tf":1.4142135623730951}},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"96":{"tf":1.4142135623730951}}}},"m":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":19,"docs":{"117":{"tf":1.0},"44":{"tf":1.0},"45":{"tf":1.4142135623730951},"48":{"tf":1.4142135623730951},"56":{"tf":2.6457513110645907},"57":{"tf":1.0},"59":{"tf":2.0},"60":{"tf":1.4142135623730951},"68":{"tf":1.0},"69":{"tf":1.0},"70":{"tf":2.8284271247461903},"72":{"tf":2.6457513110645907},"73":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":2.6457513110645907},"84":{"tf":1.0},"93":{"tf":2.0},"94":{"tf":1.0},"99":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"93":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"j":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"61":{"tf":1.0}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"66":{"tf":1.0}}}}}}}},"o":{"b":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{".":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"113":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"113":{"tf":1.0}}},"df":0,"docs":{}}}}},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":1,"docs":{"113":{"tf":1.0}}}}}},"df":6,"docs":{"37":{"tf":1.4142135623730951},"45":{"tf":1.4142135623730951},"46":{"tf":1.0},"48":{"tf":1.4142135623730951},"57":{"tf":1.0},"60":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"67":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"c":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":2,"docs":{"104":{"tf":1.0},"61":{"tf":1.4142135623730951}},"l":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":1,"docs":{"61":{"tf":1.4142135623730951}}}}}}}},"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"116":{"tf":1.4142135623730951}},"r":{"df":3,"docs":{"116":{"tf":1.4142135623730951},"36":{"tf":1.0},"60":{"tf":2.8284271247461903}}}}}},"df":0,"docs":{}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"61":{"tf":1.0}}}}},"df":10,"docs":{"115":{"tf":2.0},"33":{"tf":1.0},"39":{"tf":1.4142135623730951},"44":{"tf":1.0},"45":{"tf":1.4142135623730951},"46":{"tf":1.0},"48":{"tf":1.4142135623730951},"59":{"tf":1.0},"60":{"tf":3.4641016151377544},"94":{"tf":2.0}},"f":{"?":{"/":{"#":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"117":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":2,"docs":{"112":{"tf":1.0},"12":{"tf":1.0}}}},"df":0,"docs":{}}}},"h":{"df":0,"docs":{},"m":{"df":1,"docs":{"61":{"tf":1.0}}}},"l":{"d":{"df":1,"docs":{"84":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"5":{"tf":1.0}}}}},"df":1,"docs":{"61":{"tf":1.0}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":4,"docs":{"102":{"tf":1.0},"104":{"tf":1.0},"105":{"tf":1.0},"87":{"tf":1.0}}}},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"p":{"df":1,"docs":{"61":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"n":{"c":{"df":3,"docs":{"116":{"tf":2.0},"28":{"tf":1.0},"56":{"tf":1.0}}},"df":17,"docs":{"102":{"tf":1.0},"116":{"tf":2.8284271247461903},"117":{"tf":2.0},"119":{"tf":1.0},"121":{"tf":1.0},"122":{"tf":1.0},"22":{"tf":1.0},"30":{"tf":1.0},"35":{"tf":1.0},"41":{"tf":1.0},"49":{"tf":1.4142135623730951},"59":{"tf":1.4142135623730951},"60":{"tf":1.4142135623730951},"70":{"tf":2.0},"83":{"tf":1.7320508075688772},"91":{"tf":1.0},"94":{"tf":1.4142135623730951}},"e":{"d":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":1,"docs":{"68":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"46":{"tf":1.7320508075688772}}}}},"p":{"df":1,"docs":{"33":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"/":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":1,"docs":{"56":{"tf":1.0}}}}}},"df":0,"docs":{}},"_":{"a":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":2,"docs":{"45":{"tf":1.0},"60":{"tf":1.0}}}}},"df":0,"docs":{}},"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":3,"docs":{"45":{"tf":1.0},"60":{"tf":1.0},"94":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"l":{"df":1,"docs":{"61":{"tf":1.0}}}},"df":14,"docs":{"28":{"tf":1.4142135623730951},"45":{"tf":1.4142135623730951},"48":{"tf":3.4641016151377544},"51":{"tf":2.0},"52":{"tf":1.0},"54":{"tf":2.23606797749979},"55":{"tf":1.4142135623730951},"56":{"tf":1.0},"59":{"tf":3.7416573867739413},"60":{"tf":4.123105625617661},"68":{"tf":1.4142135623730951},"70":{"tf":1.4142135623730951},"72":{"tf":2.6457513110645907},"94":{"tf":1.4142135623730951}},"s":{"c":{"a":{"d":{"df":1,"docs":{"61":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"r":{"df":8,"docs":{"1":{"tf":1.0},"27":{"tf":1.0},"37":{"tf":1.0},"41":{"tf":1.0},"47":{"tf":1.0},"68":{"tf":1.0},"70":{"tf":1.0},"93":{"tf":1.4142135623730951}}}},"t":{"df":2,"docs":{"21":{"tf":1.0},"22":{"tf":1.0}},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"21":{"tf":1.0}}},"o":{"df":0,"docs":{},"n":{"\'":{"df":1,"docs":{"57":{"tf":1.4142135623730951}}},"df":19,"docs":{"102":{"tf":2.0},"119":{"tf":1.0},"12":{"tf":1.0},"53":{"tf":1.4142135623730951},"55":{"tf":1.4142135623730951},"57":{"tf":3.872983346207417},"59":{"tf":3.872983346207417},"71":{"tf":1.4142135623730951},"74":{"tf":1.0},"75":{"tf":1.7320508075688772},"78":{"tf":1.0},"79":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.7320508075688772},"82":{"tf":1.0},"83":{"tf":1.4142135623730951},"84":{"tf":2.0},"89":{"tf":1.0},"93":{"tf":1.0}}}}}}},"r":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":8,"docs":{"103":{"tf":1.7320508075688772},"107":{"tf":1.0},"110":{"tf":1.0},"113":{"tf":1.0},"22":{"tf":1.4142135623730951},"70":{"tf":1.0},"94":{"tf":1.0},"99":{"tf":1.0}}}}},"df":0,"docs":{},"g":{"df":1,"docs":{"61":{"tf":1.0}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"65":{"tf":1.0},"99":{"tf":1.0}}}}}}},"s":{"c":{"df":1,"docs":{"71":{"tf":1.0}}},"df":1,"docs":{"22":{"tf":1.0}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"48":{"tf":1.0},"59":{"tf":1.4142135623730951}},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":4,"docs":{"35":{"tf":1.0},"57":{"tf":1.0},"60":{"tf":1.0},"70":{"tf":1.0}}}}}}}}},"u":{"df":0,"docs":{},"t":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{".":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"y":{"df":1,"docs":{"116":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":2,"docs":{"116":{"tf":3.1622776601683795},"118":{"tf":1.7320508075688772}},"—":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":1,"docs":{"118":{"tf":1.0}}}}}}}}}}},"df":7,"docs":{"111":{"tf":1.0},"116":{"tf":1.0},"118":{"tf":1.0},"22":{"tf":1.0},"33":{"tf":1.0},"60":{"tf":1.0},"72":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"36":{"tf":1.0}}}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":5,"docs":{"45":{"tf":2.0},"57":{"tf":2.0},"59":{"tf":2.23606797749979},"60":{"tf":1.7320508075688772},"9":{"tf":1.4142135623730951}}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":6,"docs":{"116":{"tf":1.0},"48":{"tf":1.0},"71":{"tf":1.0},"82":{"tf":1.0},"89":{"tf":1.0},"99":{"tf":1.0}},"r":{"df":0,"docs":{},"i":{"d":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":3,"docs":{"70":{"tf":1.0},"86":{"tf":1.0},"98":{"tf":1.0}}}}},"df":7,"docs":{"2":{"tf":1.0},"68":{"tf":1.0},"70":{"tf":1.4142135623730951},"76":{"tf":1.0},"92":{"tf":1.4142135623730951},"98":{"tf":1.0},"99":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":2,"docs":{"0":{"tf":1.0},"87":{"tf":1.4142135623730951}}}}}},"w":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"99":{"tf":1.0}}}}}}}}},"x":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"61":{"tf":1.0}}},"df":0,"docs":{}}}},"p":{"a":{"c":{"df":0,"docs":{},"k":{"a":{"df":0,"docs":{},"g":{"df":22,"docs":{"1":{"tf":1.0},"10":{"tf":1.0},"11":{"tf":1.0},"12":{"tf":1.0},"13":{"tf":1.0},"14":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.4142135623730951},"18":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":1.7320508075688772},"22":{"tf":1.7320508075688772},"25":{"tf":2.6457513110645907},"3":{"tf":2.0},"4":{"tf":1.0},"5":{"tf":1.4142135623730951},"6":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.4142135623730951},"9":{"tf":1.0}}}},"df":0,"docs":{}},"m":{"a":{"df":0,"docs":{},"n":{"df":2,"docs":{"20":{"tf":1.0},"8":{"tf":1.0}}}},"df":0,"docs":{}}},"d":{"df":1,"docs":{"70":{"tf":1.4142135623730951}}},"df":1,"docs":{"41":{"tf":1.0}},"g":{"df":0,"docs":{},"e":{"_":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"_":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":1,"docs":{"60":{"tf":1.0}}}}}},"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"_":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":3,"docs":{"44":{"tf":1.0},"48":{"tf":1.0},"60":{"tf":1.0}}}}}},"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":3,"docs":{"44":{"tf":1.0},"48":{"tf":1.0},"60":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"p":{"df":1,"docs":{"60":{"tf":1.0}}}}},"df":0,"docs":{}}}}}}},"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":4,"docs":{"44":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0},"60":{"tf":1.0}}}}}},"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":4,"docs":{"44":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0},"60":{"tf":1.0}}}}},"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":6,"docs":{"44":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.4142135623730951},"51":{"tf":1.0},"60":{"tf":1.7320508075688772},"96":{"tf":1.0}}}}}},"df":12,"docs":{"110":{"tf":1.0},"12":{"tf":1.0},"2":{"tf":1.0},"25":{"tf":1.0},"42":{"tf":1.0},"44":{"tf":2.449489742783178},"48":{"tf":2.449489742783178},"49":{"tf":1.4142135623730951},"5":{"tf":1.0},"51":{"tf":1.7320508075688772},"60":{"tf":2.8284271247461903},"96":{"tf":1.4142135623730951}},"u":{"df":0,"docs":{},"p":{"df":6,"docs":{"44":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.4142135623730951},"51":{"tf":1.0},"60":{"tf":1.7320508075688772},"96":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"r":{"df":7,"docs":{"36":{"tf":1.0},"37":{"tf":1.4142135623730951},"56":{"tf":1.0},"60":{"tf":1.4142135623730951},"69":{"tf":1.0},"76":{"tf":3.3166247903554},"99":{"tf":1.0}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":4,"docs":{"48":{"tf":1.0},"60":{"tf":1.0},"89":{"tf":3.0},"92":{"tf":1.4142135623730951}}}}}},"r":{"a":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"m":{"df":1,"docs":{"49":{"tf":1.0}}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":5,"docs":{"29":{"tf":1.0},"37":{"tf":1.4142135623730951},"48":{"tf":1.4142135623730951},"60":{"tf":1.4142135623730951},"63":{"tf":1.0}}}}},"df":0,"docs":{}}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":6,"docs":{"38":{"tf":1.0},"59":{"tf":1.4142135623730951},"60":{"tf":1.4142135623730951},"68":{"tf":1.0},"73":{"tf":1.0},"93":{"tf":2.23606797749979}},"e":{"df":0,"docs":{},"r":{".":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"112":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"112":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":4,"docs":{"39":{"tf":1.0},"46":{"tf":1.7320508075688772},"60":{"tf":2.23606797749979},"75":{"tf":1.4142135623730951}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":4,"docs":{"116":{"tf":1.0},"36":{"tf":1.0},"76":{"tf":1.0},"93":{"tf":1.0}},"i":{"df":0,"docs":{},"z":{"df":0,"docs":{},"e":{"d":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"116":{"tf":1.7320508075688772}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}}},"s":{"df":5,"docs":{"121":{"tf":1.4142135623730951},"39":{"tf":1.0},"53":{"tf":1.0},"57":{"tf":2.6457513110645907},"87":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"111":{"tf":1.4142135623730951}}}}},"t":{"df":4,"docs":{"112":{"tf":1.0},"116":{"tf":1.0},"17":{"tf":1.0},"70":{"tf":1.0}},"i":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"101":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"56":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":1,"docs":{"4":{"tf":1.0}}}}},"s":{"c":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"61":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"l":{"df":1,"docs":{"61":{"tf":1.0}}},"s":{"df":7,"docs":{"101":{"tf":1.0},"102":{"tf":1.7320508075688772},"41":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.4142135623730951},"77":{"tf":1.0},"99":{"tf":1.0}},"w":{"d":{"df":1,"docs":{"61":{"tf":1.0}}},"df":0,"docs":{}}},"t":{"df":9,"docs":{"32":{"tf":1.0},"33":{"tf":1.0},"35":{"tf":1.7320508075688772},"45":{"tf":1.7320508075688772},"48":{"tf":1.4142135623730951},"59":{"tf":3.1622776601683795},"60":{"tf":2.449489742783178},"70":{"tf":1.4142135623730951},"71":{"tf":1.4142135623730951}},"e":{"_":{"a":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":2,"docs":{"45":{"tf":1.0},"60":{"tf":1.0}}}}},"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"45":{"tf":1.0},"60":{"tf":1.0}}}}}}},"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"b":{"df":0,"docs":{},"o":{"a":{"df":0,"docs":{},"r":{"d":{"_":{"a":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}}}}},"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"_":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"b":{"df":0,"docs":{},"o":{"a":{"df":0,"docs":{},"r":{"d":{"_":{"a":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":1,"docs":{"60":{"tf":1.0}}}}},"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"60":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"b":{"df":0,"docs":{},"o":{"a":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"70":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"t":{"df":1,"docs":{"41":{"tf":1.0}},"h":{"/":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"72":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"o":{"/":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"68":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":21,"docs":{"100":{"tf":2.23606797749979},"102":{"tf":1.4142135623730951},"104":{"tf":1.4142135623730951},"109":{"tf":1.0},"11":{"tf":1.0},"110":{"tf":1.0},"12":{"tf":1.4142135623730951},"2":{"tf":1.0},"21":{"tf":1.4142135623730951},"22":{"tf":1.4142135623730951},"24":{"tf":1.0},"41":{"tf":1.7320508075688772},"53":{"tf":1.0},"56":{"tf":1.0},"59":{"tf":2.6457513110645907},"70":{"tf":1.4142135623730951},"72":{"tf":1.0},"73":{"tf":1.0},"75":{"tf":1.0},"93":{"tf":1.0},"99":{"tf":1.0}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":9,"docs":{"102":{"tf":1.4142135623730951},"116":{"tf":1.4142135623730951},"117":{"tf":1.4142135623730951},"47":{"tf":2.0},"56":{"tf":1.0},"60":{"tf":2.0},"78":{"tf":1.0},"93":{"tf":1.0},"99":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"s":{"df":2,"docs":{"60":{"tf":1.0},"93":{"tf":1.4142135623730951}}}}},"b":{"df":1,"docs":{"61":{"tf":1.0}}},"df":11,"docs":{"12":{"tf":1.0},"37":{"tf":1.0},"39":{"tf":1.7320508075688772},"41":{"tf":1.4142135623730951},"45":{"tf":1.4142135623730951},"46":{"tf":1.0},"48":{"tf":2.6457513110645907},"51":{"tf":1.0},"52":{"tf":1.0},"60":{"tf":3.1622776601683795},"83":{"tf":1.0}},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"61":{"tf":1.0}}},"r":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"72":{"tf":1.4142135623730951}}}},"df":3,"docs":{"54":{"tf":1.0},"56":{"tf":2.0},"57":{"tf":1.4142135623730951}}}}}},"df":2,"docs":{"30":{"tf":1.0},"70":{"tf":1.0}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":3,"docs":{"27":{"tf":1.0},"41":{"tf":1.0},"60":{"tf":1.0}}}}}},"l":{"df":1,"docs":{"61":{"tf":1.0}},"n":{"a":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":1,"docs":{"61":{"tf":1.0}}}}}},"df":0,"docs":{}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"12":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":3,"docs":{"48":{"tf":1.0},"61":{"tf":1.0},"99":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"61":{"tf":1.4142135623730951}}}}},"h":{"df":0,"docs":{},"p":{"df":1,"docs":{"61":{"tf":1.4142135623730951}}}},"i":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":12,"docs":{"28":{"tf":1.0},"40":{"tf":2.8284271247461903},"41":{"tf":3.0},"42":{"tf":1.0},"48":{"tf":3.4641016151377544},"51":{"tf":2.8284271247461903},"59":{"tf":1.0},"60":{"tf":3.4641016151377544},"68":{"tf":1.0},"69":{"tf":1.0},"75":{"tf":2.449489742783178},"93":{"tf":2.449489742783178}}}}}},"df":0,"docs":{},"e":{"c":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"e":{"df":4,"docs":{"45":{"tf":1.7320508075688772},"57":{"tf":1.4142135623730951},"59":{"tf":2.0},"60":{"tf":1.4142135623730951}}}},"x":{"df":0,"docs":{},"i":{"df":1,"docs":{"61":{"tf":1.0}}}}},"k":{"df":0,"docs":{},"g":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"61":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"68":{"tf":1.0}}}}},"l":{"df":1,"docs":{"61":{"tf":1.4142135623730951}}}},"l":{"a":{"c":{"df":0,"docs":{},"e":{"df":4,"docs":{"112":{"tf":1.0},"114":{"tf":1.0},"75":{"tf":1.0},"86":{"tf":1.0}},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"d":{"df":2,"docs":{"60":{"tf":1.4142135623730951},"93":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"n":{"df":1,"docs":{"36":{"tf":1.0}}},"t":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"\'":{"df":1,"docs":{"70":{"tf":1.0}}},"df":1,"docs":{"70":{"tf":1.0}}}}}}},"y":{"df":1,"docs":{"45":{"tf":1.0}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":3,"docs":{"26":{"tf":1.0},"48":{"tf":1.0},"73":{"tf":1.0}}}},"df":0,"docs":{}},"u":{"df":2,"docs":{"56":{"tf":1.4142135623730951},"93":{"tf":1.0}},"g":{"df":0,"docs":{},"h":{"df":1,"docs":{"116":{"tf":1.0}}},"i":{"df":0,"docs":{},"n":{"df":4,"docs":{"65":{"tf":1.7320508075688772},"66":{"tf":1.0},"67":{"tf":1.0},"81":{"tf":1.0}}}}}}},"o":{"d":{"df":1,"docs":{"61":{"tf":1.0}}},"df":1,"docs":{"61":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":5,"docs":{"104":{"tf":1.0},"22":{"tf":1.4142135623730951},"59":{"tf":1.4142135623730951},"75":{"tf":1.0},"93":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"y":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"61":{"tf":1.0}}}}},"df":0,"docs":{}}}},"p":{"df":1,"docs":{"70":{"tf":1.0}},"u":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"99":{"tf":1.0}}}},"df":0,"docs":{}},"p":{"df":6,"docs":{"42":{"tf":1.4142135623730951},"48":{"tf":1.7320508075688772},"60":{"tf":1.0},"70":{"tf":1.4142135623730951},"73":{"tf":1.7320508075688772},"93":{"tf":2.8284271247461903}}}}},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"15":{"tf":1.0}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":7,"docs":{"115":{"tf":1.7320508075688772},"55":{"tf":1.0},"59":{"tf":1.0},"70":{"tf":1.0},"72":{"tf":2.449489742783178},"83":{"tf":1.0},"99":{"tf":1.0}}}},"s":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"l":{"df":6,"docs":{"38":{"tf":1.0},"50":{"tf":1.0},"9":{"tf":1.0},"94":{"tf":1.0},"95":{"tf":1.0},"98":{"tf":1.0}}}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":2,"docs":{"24":{"tf":1.0},"99":{"tf":1.0}}}}}}},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"94":{"tf":1.0}},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":2,"docs":{"22":{"tf":1.4142135623730951},"61":{"tf":1.0}}}}}}}}}},"p":{"a":{":":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"/":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"df":1,"docs":{"6":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":2,"docs":{"3":{"tf":1.0},"6":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"e":{"d":{"df":4,"docs":{"70":{"tf":1.0},"83":{"tf":1.0},"89":{"tf":1.0},"99":{"tf":1.0}}},"df":0,"docs":{}}},"d":{"df":0,"docs":{},"i":{"c":{"df":3,"docs":{"117":{"tf":2.6457513110645907},"122":{"tf":1.4142135623730951},"60":{"tf":1.0}}},"df":0,"docs":{}}},"df":2,"docs":{"2":{"tf":1.7320508075688772},"21":{"tf":1.0}},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"1":{"tf":1.0}}}},"i":{"df":0,"docs":{},"x":{"df":5,"docs":{"100":{"tf":1.4142135623730951},"102":{"tf":1.0},"41":{"tf":1.4142135623730951},"84":{"tf":1.0},"96":{"tf":1.4142135623730951}}}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"93":{"tf":1.4142135623730951}}}}}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"57":{"tf":1.0}}}}},"s":{"df":8,"docs":{"41":{"tf":1.4142135623730951},"43":{"tf":1.0},"50":{"tf":1.0},"53":{"tf":1.0},"56":{"tf":1.0},"59":{"tf":1.0},"83":{"tf":1.0},"95":{"tf":1.0}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":1,"docs":{"102":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":2,"docs":{"102":{"tf":1.4142135623730951},"103":{"tf":2.0}}}}}}},"v":{"df":1,"docs":{"60":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":5,"docs":{"116":{"tf":1.4142135623730951},"39":{"tf":1.0},"54":{"tf":1.0},"70":{"tf":1.0},"87":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":3,"docs":{"51":{"tf":1.0},"70":{"tf":1.0},"93":{"tf":1.0}}}},"o":{"df":0,"docs":{},"u":{"df":14,"docs":{"103":{"tf":1.4142135623730951},"28":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":1.7320508075688772},"44":{"tf":2.0},"46":{"tf":1.4142135623730951},"47":{"tf":1.4142135623730951},"48":{"tf":3.3166247903554},"49":{"tf":1.7320508075688772},"51":{"tf":1.0},"52":{"tf":2.0},"59":{"tf":1.4142135623730951},"60":{"tf":5.656854249492381},"70":{"tf":1.0}},"s":{"df":2,"docs":{"25":{"tf":1.0},"60":{"tf":1.0}}}}}}}},"i":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":11,"docs":{"35":{"tf":1.4142135623730951},"39":{"tf":1.0},"46":{"tf":1.4142135623730951},"56":{"tf":2.23606797749979},"59":{"tf":3.605551275463989},"60":{"tf":3.1622776601683795},"71":{"tf":1.4142135623730951},"72":{"tf":1.7320508075688772},"74":{"tf":1.0},"84":{"tf":1.0},"93":{"tf":1.7320508075688772}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"59":{"tf":1.4142135623730951}}}}},"y":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"71":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"93":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"t":{"df":3,"docs":{"54":{"tf":2.23606797749979},"56":{"tf":2.449489742783178},"59":{"tf":1.0}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"103":{"tf":1.0}},"i":{"df":2,"docs":{"100":{"tf":1.0},"22":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"m":{"a":{"df":1,"docs":{"61":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"v":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"93":{"tf":2.0}}}},"df":0,"docs":{}}},"o":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"24":{"tf":1.0}}}}}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"68":{"tf":1.0}}}}}},"d":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"64":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":3,"docs":{"21":{"tf":1.0},"22":{"tf":1.0},"25":{"tf":1.0}}}}},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"df":4,"docs":{"1":{"tf":1.0},"57":{"tf":1.4142135623730951},"60":{"tf":1.4142135623730951},"70":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"72":{"tf":1.0},"73":{"tf":1.7320508075688772}}}}}}},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"68":{"tf":1.0},"9":{"tf":1.0},"98":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":1,"docs":{"61":{"tf":1.0}}}}},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":4,"docs":{"42":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":2.449489742783178},"93":{"tf":1.7320508075688772}}}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":4,"docs":{"112":{"tf":1.0},"116":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0}}}},"t":{"df":0,"docs":{},"i":{"df":2,"docs":{"61":{"tf":1.0},"92":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"o":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"f":{"df":1,"docs":{"61":{"tf":1.0}}}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":2,"docs":{"83":{"tf":1.0},"96":{"tf":1.0}}}}},"df":0,"docs":{},"l":{"df":1,"docs":{"61":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"i":{"d":{"df":19,"docs":{"108":{"tf":1.0},"110":{"tf":1.0},"22":{"tf":1.0},"24":{"tf":1.0},"25":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.4142135623730951},"59":{"tf":2.449489742783178},"65":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.0},"69":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":2.0},"81":{"tf":1.0},"90":{"tf":1.0},"91":{"tf":1.0},"93":{"tf":1.4142135623730951},"98":{"tf":1.0}},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":1,"docs":{"102":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"r":{".":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"71":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"q":{"df":0,"docs":{},"l":{"df":1,"docs":{"61":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"g":{"df":1,"docs":{"61":{"tf":1.0}}},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"109":{"tf":1.0}}}},"n":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"93":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"61":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":2,"docs":{"116":{"tf":1.0},"37":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"9":{"tf":1.0}}}},"t":{"df":3,"docs":{"112":{"tf":1.0},"68":{"tf":1.0},"75":{"tf":1.0}}}},"w":{"d":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"22":{"tf":1.0}}}}}}}}},"df":1,"docs":{"59":{"tf":1.0}}},"df":0,"docs":{}},"y":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":1,"docs":{"61":{"tf":1.4142135623730951}}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"116":{"tf":2.0},"61":{"tf":1.0}}}}}}}},"q":{"a":{"df":1,"docs":{"59":{"tf":1.4142135623730951}}},"df":4,"docs":{"45":{"tf":1.4142135623730951},"48":{"tf":1.4142135623730951},"59":{"tf":1.4142135623730951},"60":{"tf":2.8284271247461903}},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"61":{"tf":1.0}},"l":{"df":1,"docs":{"61":{"tf":1.0}}}}},"u":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"61":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":18,"docs":{"106":{"tf":1.0},"110":{"tf":2.0},"111":{"tf":1.0},"112":{"tf":3.1622776601683795},"113":{"tf":1.7320508075688772},"114":{"tf":2.8284271247461903},"115":{"tf":3.0},"116":{"tf":1.7320508075688772},"117":{"tf":1.4142135623730951},"118":{"tf":1.4142135623730951},"119":{"tf":2.449489742783178},"120":{"tf":1.0},"121":{"tf":1.0},"122":{"tf":1.0},"37":{"tf":1.4142135623730951},"38":{"tf":1.4142135623730951},"41":{"tf":1.0},"59":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"0":{"tf":1.0}}}}}}}},"i":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"0":{"tf":1.0}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"61":{"tf":1.4142135623730951}}}},"t":{"df":2,"docs":{"53":{"tf":1.0},"59":{"tf":3.4641016151377544}}}},"o":{"df":0,"docs":{},"t":{"df":6,"docs":{"53":{"tf":1.4142135623730951},"54":{"tf":3.1622776601683795},"56":{"tf":1.7320508075688772},"57":{"tf":2.0},"87":{"tf":1.0},"93":{"tf":1.0}}}},"u":{"df":0,"docs":{},"x":{"df":1,"docs":{"116":{"tf":1.4142135623730951}}}}}},"r":{"\\\\":{"df":0,"docs":{},"n":{"df":1,"docs":{"56":{"tf":1.0}}}},"a":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"61":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":2,"docs":{"116":{"tf":1.0},"59":{"tf":1.0}}}},"p":{"df":0,"docs":{},"i":{"d":{"_":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":1,"docs":{"90":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"w":{"df":1,"docs":{"93":{"tf":1.4142135623730951}}}},"df":10,"docs":{"22":{"tf":1.0},"41":{"tf":1.7320508075688772},"45":{"tf":1.4142135623730951},"48":{"tf":2.0},"49":{"tf":1.0},"52":{"tf":1.4142135623730951},"55":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":2.23606797749979},"61":{"tf":1.7320508075688772}},"e":{"a":{"d":{"df":5,"docs":{"35":{"tf":2.0},"59":{"tf":1.0},"70":{"tf":1.0},"72":{"tf":1.4142135623730951},"75":{"tf":2.23606797749979}},"m":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"m":{"d":{":":{"1":{"df":2,"docs":{"56":{"tf":1.0},"57":{"tf":1.0}}},"df":0,"docs":{}},"df":1,"docs":{"54":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"72":{"tf":1.0}}}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"116":{"tf":1.0}}}}}},"b":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"61":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"94":{"tf":1.0}}},"df":0,"docs":{}}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":3,"docs":{"112":{"tf":1.0},"56":{"tf":1.7320508075688772},"70":{"tf":1.0}}}},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":6,"docs":{"114":{"tf":1.0},"24":{"tf":1.0},"49":{"tf":1.0},"65":{"tf":1.0},"84":{"tf":1.0},"89":{"tf":1.0}}},"df":0,"docs":{}}}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"99":{"tf":1.0}}}}}},"r":{"d":{"_":{"df":0,"docs":{},"m":{"a":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":2,"docs":{"45":{"tf":1.0},"60":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":3,"docs":{"34":{"tf":1.0},"45":{"tf":1.4142135623730951},"60":{"tf":1.0}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":2,"docs":{"56":{"tf":1.0},"75":{"tf":1.0}}}}}},"d":{"df":1,"docs":{"89":{"tf":1.4142135623730951}},"o":{"df":2,"docs":{"45":{"tf":1.4142135623730951},"60":{"tf":1.4142135623730951}}},"r":{"a":{"df":0,"docs":{},"w":{"df":1,"docs":{"59":{"tf":1.0}}}},"df":0,"docs":{}},"u":{"c":{"df":1,"docs":{"82":{"tf":1.0}}},"df":0,"docs":{}}},"df":3,"docs":{"121":{"tf":1.0},"59":{"tf":1.0},"94":{"tf":1.0}},"f":{"df":1,"docs":{"93":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":14,"docs":{"0":{"tf":1.0},"103":{"tf":1.0},"108":{"tf":1.0},"110":{"tf":1.0},"23":{"tf":1.0},"26":{"tf":1.4142135623730951},"37":{"tf":1.0},"38":{"tf":1.0},"48":{"tf":1.7320508075688772},"60":{"tf":1.4142135623730951},"70":{"tf":1.0},"73":{"tf":1.4142135623730951},"89":{"tf":1.0},"93":{"tf":1.0}}}},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"49":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"w":{"df":3,"docs":{"59":{"tf":1.0},"70":{"tf":1.0},"99":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"59":{"tf":1.0}}}}}}},"g":{"a":{"df":0,"docs":{},"r":{"d":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"116":{"tf":1.4142135623730951},"73":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":1,"docs":{"45":{"tf":1.0}},"e":{"df":0,"docs":{},"x":{"df":9,"docs":{"117":{"tf":1.0},"122":{"tf":1.0},"41":{"tf":1.0},"46":{"tf":2.0},"47":{"tf":1.0},"60":{"tf":2.449489742783178},"61":{"tf":1.0},"78":{"tf":1.0},"99":{"tf":1.7320508075688772}},"p":{"df":1,"docs":{"93":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":14,"docs":{"32":{"tf":3.0},"33":{"tf":3.1622776601683795},"34":{"tf":2.6457513110645907},"35":{"tf":3.1622776601683795},"41":{"tf":1.7320508075688772},"45":{"tf":1.7320508075688772},"47":{"tf":1.4142135623730951},"49":{"tf":1.0},"52":{"tf":1.0},"59":{"tf":2.0},"60":{"tf":1.7320508075688772},"63":{"tf":1.0},"70":{"tf":1.4142135623730951},"72":{"tf":1.7320508075688772}}}}},"o":{"df":1,"docs":{"61":{"tf":1.0}},"l":{"df":1,"docs":{"61":{"tf":1.0}}}},"u":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":2,"docs":{"57":{"tf":1.4142135623730951},"93":{"tf":1.0}}}},"df":0,"docs":{}}}},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"48":{"tf":1.0}}}},"df":0,"docs":{}}},"l":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"62":{"tf":1.0},"75":{"tf":1.0}}}},"df":4,"docs":{"56":{"tf":1.0},"68":{"tf":1.0},"70":{"tf":2.0},"99":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"s":{"df":7,"docs":{"12":{"tf":1.0},"2":{"tf":1.0},"25":{"tf":1.7320508075688772},"36":{"tf":1.0},"5":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}}}},"df":0,"docs":{},"v":{"df":3,"docs":{"103":{"tf":1.0},"48":{"tf":1.0},"64":{"tf":1.0}}}},"i":{"df":1,"docs":{"38":{"tf":1.0}}},"o":{"a":{"d":{"/":{":":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"73":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":3,"docs":{"59":{"tf":2.23606797749979},"68":{"tf":1.7320508075688772},"70":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"m":{"a":{"df":0,"docs":{},"p":{"df":6,"docs":{"48":{"tf":2.0},"51":{"tf":1.0},"52":{"tf":1.0},"94":{"tf":2.23606797749979},"95":{"tf":1.0},"96":{"tf":1.0}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":2,"docs":{"104":{"tf":1.0},"59":{"tf":1.0}}},"v":{"df":8,"docs":{"111":{"tf":1.4142135623730951},"41":{"tf":1.0},"46":{"tf":1.4142135623730951},"50":{"tf":1.0},"60":{"tf":1.4142135623730951},"70":{"tf":1.4142135623730951},"76":{"tf":1.0},"81":{"tf":1.0}},"e":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"46":{"tf":1.0},"60":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"46":{"tf":1.0},"60":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"n":{"a":{"df":0,"docs":{},"m":{"df":4,"docs":{"103":{"tf":1.0},"48":{"tf":1.0},"60":{"tf":1.0},"93":{"tf":1.0}},"e":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":6,"docs":{"59":{"tf":1.0},"70":{"tf":1.4142135623730951},"79":{"tf":2.23606797749979},"80":{"tf":2.23606797749979},"84":{"tf":2.449489742783178},"99":{"tf":1.0}}}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":2,"docs":{"44":{"tf":1.0},"60":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":4,"docs":{"44":{"tf":1.0},"45":{"tf":1.0},"60":{"tf":1.0},"93":{"tf":1.0}}}},"df":0,"docs":{}},"l":{"a":{"c":{"df":9,"docs":{"30":{"tf":1.0},"36":{"tf":1.4142135623730951},"45":{"tf":2.0},"48":{"tf":1.4142135623730951},"50":{"tf":1.0},"56":{"tf":1.0},"59":{"tf":2.0},"60":{"tf":2.449489742783178},"70":{"tf":1.4142135623730951}},"e":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"_":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"b":{"df":0,"docs":{},"o":{"a":{"df":0,"docs":{},"r":{"d":{"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"_":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"b":{"df":0,"docs":{},"o":{"a":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"60":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"_":{"df":0,"docs":{},"y":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":2,"docs":{"45":{"tf":1.0},"60":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"m":{"a":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":2,"docs":{"45":{"tf":1.0},"60":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":1,"docs":{"60":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":2,"docs":{"25":{"tf":1.0},"73":{"tf":1.0}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":10,"docs":{"104":{"tf":1.7320508075688772},"112":{"tf":1.0},"21":{"tf":1.4142135623730951},"25":{"tf":1.0},"4":{"tf":1.0},"6":{"tf":1.0},"68":{"tf":1.0},"75":{"tf":1.0},"8":{"tf":1.4142135623730951},"98":{"tf":1.0}}}}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":2,"docs":{"81":{"tf":1.0},"87":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"28":{"tf":1.0},"96":{"tf":1.0}}}}}}},"o":{"d":{"df":0,"docs":{},"u":{"c":{"df":2,"docs":{"21":{"tf":1.0},"9":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":4,"docs":{"102":{"tf":1.4142135623730951},"103":{"tf":1.4142135623730951},"109":{"tf":1.0},"66":{"tf":1.4142135623730951}}}}},"i":{"df":0,"docs":{},"r":{"df":12,"docs":{"102":{"tf":1.0},"112":{"tf":1.0},"114":{"tf":1.0},"116":{"tf":1.0},"118":{"tf":1.0},"21":{"tf":1.0},"22":{"tf":1.0},"38":{"tf":1.0},"42":{"tf":1.4142135623730951},"73":{"tf":1.0},"77":{"tf":1.0},"93":{"tf":1.4142135623730951}}}}}},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"61":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"99":{"tf":1.0}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"v":{"df":2,"docs":{"86":{"tf":1.0},"93":{"tf":1.0}}}},"t":{"df":1,"docs":{"59":{"tf":1.4142135623730951}}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"v":{"df":1,"docs":{"22":{"tf":1.0}}}},"u":{"df":0,"docs":{},"r":{"c":{"df":1,"docs":{"61":{"tf":1.0}}},"df":0,"docs":{}}}},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"96":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":3,"docs":{"59":{"tf":1.4142135623730951},"60":{"tf":1.0},"73":{"tf":1.4142135623730951}}}}},"df":2,"docs":{"114":{"tf":1.0},"57":{"tf":2.0}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":9,"docs":{"103":{"tf":1.0},"116":{"tf":1.4142135623730951},"22":{"tf":1.0},"23":{"tf":1.0},"25":{"tf":1.0},"32":{"tf":1.0},"39":{"tf":1.0},"41":{"tf":1.4142135623730951},"48":{"tf":1.4142135623730951}}}}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"82":{"tf":1.4142135623730951}}}}},"df":4,"docs":{"115":{"tf":1.0},"60":{"tf":1.0},"94":{"tf":1.0},"96":{"tf":1.0}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"/":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"96":{"tf":1.0}}}}}},"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"116":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":7,"docs":{"116":{"tf":2.449489742783178},"35":{"tf":1.0},"43":{"tf":1.0},"45":{"tf":1.0},"56":{"tf":1.0},"60":{"tf":1.0},"93":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"119":{"tf":1.0}}}},"v":{"df":1,"docs":{"104":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":3,"docs":{"55":{"tf":1.4142135623730951},"60":{"tf":1.4142135623730951},"90":{"tf":1.0}},"e":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"60":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"104":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":9,"docs":{"44":{"tf":1.4142135623730951},"46":{"tf":1.0},"48":{"tf":2.0},"49":{"tf":1.4142135623730951},"52":{"tf":1.4142135623730951},"60":{"tf":3.3166247903554},"72":{"tf":2.0},"96":{"tf":1.4142135623730951},"99":{"tf":1.0}}}}}},"l":{"a":{"df":1,"docs":{"59":{"tf":1.0}}},"df":1,"docs":{"59":{"tf":1.0}}},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":1,"docs":{"61":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"o":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"61":{"tf":1.0}},"f":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"_":{"df":0,"docs":{},"l":{"df":1,"docs":{"61":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"n":{"df":1,"docs":{"61":{"tf":1.0}}},"o":{"df":0,"docs":{},"t":{"df":8,"docs":{"102":{"tf":1.0},"104":{"tf":1.0},"115":{"tf":1.0},"48":{"tf":1.0},"60":{"tf":1.0},"70":{"tf":1.7320508075688772},"9":{"tf":1.0},"99":{"tf":2.23606797749979}}}},"t":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"46":{"tf":2.0},"60":{"tf":2.0}},"e":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"s":{"_":{"b":{"a":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":2,"docs":{"46":{"tf":1.0},"60":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":2,"docs":{"46":{"tf":1.0},"60":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"s":{"_":{"b":{"a":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":2,"docs":{"46":{"tf":1.0},"60":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"60":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":2,"docs":{"46":{"tf":1.0},"60":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"l":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"60":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":1,"docs":{"60":{"tf":1.0}}}}}}}}},"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":1,"docs":{"22":{"tf":1.0}}}}},"w":{"df":1,"docs":{"93":{"tf":1.0}}}},"s":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"h":{"df":2,"docs":{"47":{"tf":1.0},"60":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"t":{"df":1,"docs":{"61":{"tf":1.0}}}},"u":{"b":{"df":0,"docs":{},"i":{"df":2,"docs":{"61":{"tf":1.4142135623730951},"93":{"tf":1.0}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":1,"docs":{"61":{"tf":1.0}}}},"l":{"df":0,"docs":{},"e":{"df":5,"docs":{"103":{"tf":1.0},"116":{"tf":1.4142135623730951},"53":{"tf":1.0},"57":{"tf":1.4142135623730951},"75":{"tf":1.0}},"r":{"df":4,"docs":{"57":{"tf":1.0},"70":{"tf":1.7320508075688772},"93":{"tf":1.0},"99":{"tf":1.0}}}}},"n":{"df":17,"docs":{"10":{"tf":1.0},"108":{"tf":1.0},"111":{"tf":1.4142135623730951},"115":{"tf":1.0},"12":{"tf":1.0},"2":{"tf":1.0},"22":{"tf":1.4142135623730951},"23":{"tf":1.0},"45":{"tf":1.4142135623730951},"5":{"tf":1.0},"57":{"tf":1.0},"59":{"tf":2.0},"60":{"tf":1.0},"70":{"tf":1.0},"8":{"tf":1.0},"83":{"tf":1.0},"95":{"tf":1.7320508075688772}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":7,"docs":{"111":{"tf":1.0},"112":{"tf":1.0},"2":{"tf":2.23606797749979},"21":{"tf":2.0},"22":{"tf":4.123105625617661},"25":{"tf":1.0},"85":{"tf":1.0}},"e":{".":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"59":{"tf":1.4142135623730951}}}}}},"/":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"/":{"<":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{">":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":1,"docs":{"111":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"114":{"tf":1.0}},"e":{"df":0,"docs":{},"s":{"/":{"<":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"110":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"{":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"}":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"b":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"m":{"df":1,"docs":{"112":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}}}}},"s":{"df":0,"docs":{},"t":{"d":{"df":0,"docs":{},"o":{"c":{"df":1,"docs":{"61":{"tf":1.0}}},"df":0,"docs":{}}},"df":6,"docs":{"105":{"tf":1.0},"21":{"tf":1.0},"61":{"tf":2.0},"76":{"tf":1.0},"93":{"tf":1.7320508075688772},"98":{"tf":1.4142135623730951}},"f":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"21":{"tf":1.0}}}},"df":0,"docs":{}}}}}}},"s":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":1,"docs":{"61":{"tf":1.0}}}},"m":{"df":0,"docs":{},"e":{"df":13,"docs":{"102":{"tf":1.0},"103":{"tf":1.4142135623730951},"108":{"tf":1.0},"114":{"tf":1.0},"116":{"tf":3.7416573867739413},"117":{"tf":1.7320508075688772},"121":{"tf":1.0},"22":{"tf":1.0},"30":{"tf":1.0},"41":{"tf":1.0},"54":{"tf":1.0},"93":{"tf":1.0},"99":{"tf":1.4142135623730951}}}},"n":{"d":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"36":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"v":{"df":0,"docs":{},"e":{".":{"a":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":1,"docs":{"77":{"tf":1.0}}}}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"44":{"tf":1.0},"60":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":8,"docs":{"44":{"tf":1.0},"49":{"tf":1.0},"60":{"tf":1.0},"69":{"tf":1.0},"70":{"tf":1.7320508075688772},"77":{"tf":2.449489742783178},"94":{"tf":1.0},"99":{"tf":1.4142135623730951}}}}},"c":{"a":{"df":0,"docs":{},"l":{"a":{"df":1,"docs":{"61":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"a":{"df":1,"docs":{"104":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":1,"docs":{"61":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":3,"docs":{"16":{"tf":1.0},"18":{"tf":1.7320508075688772},"3":{"tf":1.0}}}},"p":{"df":0,"docs":{},"e":{"df":7,"docs":{"115":{"tf":1.0},"116":{"tf":2.8284271247461903},"118":{"tf":3.605551275463989},"59":{"tf":1.7320508075688772},"84":{"tf":1.4142135623730951},"93":{"tf":2.6457513110645907},"99":{"tf":1.7320508075688772}}}}},"r":{"a":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"df":3,"docs":{"56":{"tf":1.4142135623730951},"59":{"tf":1.7320508075688772},"60":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":3,"docs":{"48":{"tf":2.449489742783178},"70":{"tf":1.0},"83":{"tf":1.4142135623730951}}}}},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":2,"docs":{"22":{"tf":1.0},"56":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"_":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":3,"docs":{"48":{"tf":1.0},"60":{"tf":1.0},"95":{"tf":1.0}}}}}},"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":3,"docs":{"48":{"tf":1.0},"60":{"tf":1.0},"95":{"tf":1.0}}}}},"b":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"93":{"tf":1.0}}}},"df":0,"docs":{}},"df":3,"docs":{"48":{"tf":2.23606797749979},"60":{"tf":1.4142135623730951},"70":{"tf":2.0}},"o":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":1,"docs":{"70":{"tf":1.0}}}}}}}}},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"61":{"tf":1.0}}}}},"df":15,"docs":{"116":{"tf":1.0},"117":{"tf":1.0},"20":{"tf":1.0},"36":{"tf":1.0},"44":{"tf":1.0},"46":{"tf":1.7320508075688772},"48":{"tf":2.449489742783178},"49":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.0},"60":{"tf":4.58257569495584},"8":{"tf":1.0},"83":{"tf":2.0},"94":{"tf":2.0},"96":{"tf":2.23606797749979}},"e":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"25":{"tf":1.0}}},"r":{"c":{"df":0,"docs":{},"h":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"59":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}},"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":2,"docs":{"47":{"tf":1.0},"60":{"tf":1.0}}}}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":2,"docs":{"47":{"tf":1.0},"60":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"47":{"tf":1.0},"60":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"_":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"47":{"tf":1.0},"60":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"df":16,"docs":{"100":{"tf":1.0},"2":{"tf":1.4142135623730951},"22":{"tf":1.4142135623730951},"32":{"tf":1.0},"34":{"tf":1.0},"36":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":2.6457513110645907},"42":{"tf":1.0},"47":{"tf":3.1622776601683795},"48":{"tf":1.4142135623730951},"50":{"tf":2.0},"59":{"tf":1.4142135623730951},"60":{"tf":3.3166247903554},"75":{"tf":1.7320508075688772},"78":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":8,"docs":{"102":{"tf":1.0},"116":{"tf":1.0},"117":{"tf":1.7320508075688772},"122":{"tf":1.4142135623730951},"29":{"tf":1.0},"35":{"tf":1.0},"57":{"tf":1.0},"63":{"tf":1.0}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":31,"docs":{"0":{"tf":1.7320508075688772},"100":{"tf":1.0},"103":{"tf":1.0},"104":{"tf":1.0},"105":{"tf":1.0},"106":{"tf":1.0},"108":{"tf":1.0},"31":{"tf":1.0},"38":{"tf":1.0},"41":{"tf":1.0},"48":{"tf":1.0},"62":{"tf":1.0},"69":{"tf":4.358898943540674},"70":{"tf":1.4142135623730951},"71":{"tf":1.4142135623730951},"72":{"tf":1.4142135623730951},"73":{"tf":1.4142135623730951},"74":{"tf":1.4142135623730951},"75":{"tf":1.4142135623730951},"76":{"tf":1.4142135623730951},"77":{"tf":1.4142135623730951},"78":{"tf":1.4142135623730951},"79":{"tf":1.4142135623730951},"80":{"tf":1.4142135623730951},"81":{"tf":3.0},"82":{"tf":1.4142135623730951},"83":{"tf":1.4142135623730951},"84":{"tf":1.4142135623730951},"89":{"tf":1.0},"94":{"tf":1.0},"99":{"tf":1.7320508075688772}}}}}}},"d":{"df":1,"docs":{"24":{"tf":1.7320508075688772}}},"df":0,"docs":{},"e":{"df":18,"docs":{"0":{"tf":1.4142135623730951},"1":{"tf":1.0},"114":{"tf":1.4142135623730951},"118":{"tf":1.0},"2":{"tf":1.0},"31":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":1.0},"42":{"tf":1.0},"51":{"tf":1.0},"53":{"tf":1.0},"61":{"tf":1.0},"63":{"tf":1.0},"73":{"tf":1.0},"79":{"tf":1.0},"93":{"tf":1.7320508075688772},"94":{"tf":1.0},"99":{"tf":1.7320508075688772}}},"g":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"111":{"tf":1.0}}}}}},"df":0,"docs":{}}},"l":{"df":2,"docs":{"70":{"tf":1.0},"72":{"tf":1.0}},"e":{"c":{"df":0,"docs":{},"t":{"/":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"_":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"46":{"tf":1.0},"60":{"tf":1.0}},"l":{"_":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":2,"docs":{"46":{"tf":1.0},"60":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"s":{"df":2,"docs":{"46":{"tf":1.0},"60":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"_":{"a":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":1,"docs":{"60":{"tf":1.0}}}}},"df":0,"docs":{}},"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"60":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"m":{"df":0,"docs":{},"o":{"d":{"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"s":{"df":2,"docs":{"46":{"tf":1.0},"60":{"tf":1.0}}}},"df":0,"docs":{}}}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"_":{"df":0,"docs":{},"s":{"df":2,"docs":{"46":{"tf":1.0},"60":{"tf":1.0}}}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":2,"docs":{"46":{"tf":1.0},"60":{"tf":1.0}}}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"45":{"tf":1.0},"60":{"tf":1.0}}}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"b":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"_":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}},"df":33,"docs":{"22":{"tf":1.0},"27":{"tf":1.0},"29":{"tf":2.23606797749979},"30":{"tf":2.23606797749979},"31":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":2.449489742783178},"35":{"tf":2.6457513110645907},"36":{"tf":2.23606797749979},"37":{"tf":2.449489742783178},"39":{"tf":3.605551275463989},"40":{"tf":1.0},"41":{"tf":1.4142135623730951},"42":{"tf":1.4142135623730951},"44":{"tf":1.0},"45":{"tf":5.0990195135927845},"46":{"tf":6.4031242374328485},"47":{"tf":2.0},"48":{"tf":4.58257569495584},"50":{"tf":3.1622776601683795},"51":{"tf":1.4142135623730951},"52":{"tf":2.449489742783178},"56":{"tf":2.0},"59":{"tf":4.242640687119285},"60":{"tf":17.944358444926362},"63":{"tf":1.7320508075688772},"68":{"tf":1.0},"70":{"tf":1.0},"72":{"tf":3.1622776601683795},"74":{"tf":1.4142135623730951},"85":{"tf":1.0},"93":{"tf":2.23606797749979},"94":{"tf":1.4142135623730951}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"56":{"tf":1.0}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"56":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"f":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"116":{"tf":2.449489742783178}}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"116":{"tf":2.449489742783178}}}}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"116":{"tf":2.449489742783178}}}}}}},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"116":{"tf":2.449489742783178}}}}}},"df":0,"docs":{}}}},"df":2,"docs":{"116":{"tf":1.7320508075688772},"93":{"tf":1.0}}}},"m":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"102":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"n":{"d":{"df":1,"docs":{"68":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":1,"docs":{"113":{"tf":1.0}},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"116":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}}}}},"p":{"a":{"df":0,"docs":{},"r":{"df":7,"docs":{"100":{"tf":1.4142135623730951},"102":{"tf":1.0},"54":{"tf":1.0},"59":{"tf":1.7320508075688772},"60":{"tf":1.0},"72":{"tf":2.0},"93":{"tf":1.7320508075688772}}}},"df":0,"docs":{}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":2,"docs":{"36":{"tf":1.0},"94":{"tf":1.7320508075688772}}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"v":{"df":1,"docs":{"61":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"#":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"a":{"c":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"d":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"102":{"tf":1.0}}}}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},".":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"m":{"df":1,"docs":{"102":{"tf":1.4142135623730951}}}}},"m":{"df":0,"docs":{},"y":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":2,"docs":{"102":{"tf":1.0},"98":{"tf":1.0}}}}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"102":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}}},"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"102":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}}},"df":15,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"102":{"tf":3.4641016151377544},"103":{"tf":4.898979485566356},"106":{"tf":1.0},"108":{"tf":2.23606797749979},"41":{"tf":1.0},"42":{"tf":1.0},"59":{"tf":2.23606797749979},"61":{"tf":7.211102550927978},"73":{"tf":1.7320508075688772},"93":{"tf":1.4142135623730951},"97":{"tf":1.0},"98":{"tf":1.0},"99":{"tf":2.449489742783178}}}}}},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":3,"docs":{"35":{"tf":1.0},"59":{"tf":1.4142135623730951},"60":{"tf":1.4142135623730951}}}}}}},"t":{"df":33,"docs":{"0":{"tf":1.0},"111":{"tf":1.0},"114":{"tf":1.0},"117":{"tf":1.0},"118":{"tf":1.7320508075688772},"119":{"tf":1.4142135623730951},"121":{"tf":1.4142135623730951},"2":{"tf":1.4142135623730951},"21":{"tf":1.4142135623730951},"22":{"tf":2.23606797749979},"23":{"tf":1.0},"45":{"tf":1.4142135623730951},"57":{"tf":1.4142135623730951},"59":{"tf":3.0},"68":{"tf":1.0},"70":{"tf":3.1622776601683795},"71":{"tf":1.0},"73":{"tf":1.4142135623730951},"75":{"tf":1.4142135623730951},"76":{"tf":2.0},"79":{"tf":1.0},"81":{"tf":1.7320508075688772},"82":{"tf":1.0},"83":{"tf":1.7320508075688772},"84":{"tf":1.7320508075688772},"9":{"tf":1.0},"90":{"tf":1.0},"92":{"tf":1.0},"93":{"tf":2.23606797749979},"94":{"tf":1.0},"97":{"tf":1.4142135623730951},"98":{"tf":1.0},"99":{"tf":2.8284271247461903}},"x":{"df":1,"docs":{"22":{"tf":1.4142135623730951}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":5,"docs":{"118":{"tf":1.0},"70":{"tf":1.0},"72":{"tf":1.4142135623730951},"84":{"tf":2.0},"99":{"tf":1.4142135623730951}}}}}},"h":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":3,"docs":{"68":{"tf":1.0},"69":{"tf":1.0},"74":{"tf":2.6457513110645907}}}},"r":{"df":0,"docs":{},"p":{"df":1,"docs":{"61":{"tf":1.0}}}}},"df":5,"docs":{"56":{"tf":1.7320508075688772},"57":{"tf":1.0},"59":{"tf":1.0},"70":{"tf":1.0},"99":{"tf":1.0}},"e":{"b":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":2,"docs":{"120":{"tf":1.4142135623730951},"99":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"_":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"45":{"tf":1.0},"60":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"45":{"tf":1.0},"60":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}}}}},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":2,"docs":{"45":{"tf":1.0},"60":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"p":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":2,"docs":{"45":{"tf":1.0},"60":{"tf":1.0}},"e":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":2,"docs":{"45":{"tf":1.0},"60":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"df":12,"docs":{"100":{"tf":1.0},"42":{"tf":1.0},"45":{"tf":2.449489742783178},"54":{"tf":1.0},"56":{"tf":2.6457513110645907},"57":{"tf":2.0},"59":{"tf":2.449489742783178},"60":{"tf":2.449489742783178},"66":{"tf":1.7320508075688772},"70":{"tf":1.4142135623730951},"9":{"tf":1.0},"95":{"tf":1.7320508075688772}}}}},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":8,"docs":{"46":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.0},"83":{"tf":1.0},"94":{"tf":1.4142135623730951},"96":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"21":{"tf":1.0},"24":{"tf":1.4142135623730951}}}}},"df":1,"docs":{"55":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"41":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"116":{"tf":1.0}}}}},"df":0,"docs":{}}},"w":{"df":12,"docs":{"24":{"tf":1.0},"41":{"tf":1.0},"48":{"tf":1.4142135623730951},"55":{"tf":1.0},"59":{"tf":2.449489742783178},"60":{"tf":1.4142135623730951},"70":{"tf":2.0},"72":{"tf":1.4142135623730951},"73":{"tf":1.0},"84":{"tf":1.7320508075688772},"94":{"tf":1.0},"95":{"tf":1.0}},"n":{"df":5,"docs":{"70":{"tf":1.4142135623730951},"72":{"tf":1.7320508075688772},"73":{"tf":1.0},"75":{"tf":1.0},"84":{"tf":2.0}}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"46":{"tf":1.0},"60":{"tf":1.0}}}},"df":0,"docs":{}}}}},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"_":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"46":{"tf":1.0},"60":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":2,"docs":{"46":{"tf":1.4142135623730951},"60":{"tf":2.0}}}}}},"{":{"d":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"56":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":1,"docs":{"56":{"tf":2.0}}}}},"df":0,"docs":{}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":1,"docs":{"54":{"tf":1.4142135623730951}}}}},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"56":{"tf":1.0}}}}}}},"i":{"b":{"df":0,"docs":{},"l":{"df":4,"docs":{"22":{"tf":1.0},"39":{"tf":1.7320508075688772},"46":{"tf":1.7320508075688772},"60":{"tf":1.7320508075688772}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"116":{"tf":1.0},"68":{"tf":1.0}}},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":5,"docs":{"103":{"tf":1.0},"42":{"tf":1.0},"48":{"tf":2.0},"60":{"tf":1.0},"73":{"tf":2.0}},"e":{"_":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"p":{"df":1,"docs":{"60":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":9,"docs":{"106":{"tf":1.0},"117":{"tf":1.0},"32":{"tf":1.4142135623730951},"36":{"tf":1.0},"48":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":1.0},"84":{"tf":1.0},"93":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"39":{"tf":1.0},"57":{"tf":1.0}}}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"l":{"df":6,"docs":{"119":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":2.0},"70":{"tf":1.4142135623730951},"76":{"tf":1.0},"94":{"tf":1.0}},"i":{"c":{"df":1,"docs":{"81":{"tf":1.0}}},"df":4,"docs":{"29":{"tf":1.0},"48":{"tf":1.0},"63":{"tf":1.0},"70":{"tf":1.0}}}}}},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"56":{"tf":1.0}},"l":{"df":10,"docs":{"25":{"tf":1.0},"29":{"tf":1.0},"46":{"tf":1.0},"54":{"tf":1.4142135623730951},"56":{"tf":1.0},"60":{"tf":1.0},"63":{"tf":1.0},"76":{"tf":1.0},"93":{"tf":1.0},"99":{"tf":1.4142135623730951}}}}},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"99":{"tf":1.0}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":20,"docs":{"104":{"tf":2.449489742783178},"106":{"tf":1.0},"109":{"tf":1.0},"110":{"tf":1.0},"111":{"tf":1.0},"112":{"tf":1.7320508075688772},"113":{"tf":1.0},"114":{"tf":2.0},"117":{"tf":1.4142135623730951},"119":{"tf":1.0},"21":{"tf":2.0},"37":{"tf":1.7320508075688772},"38":{"tf":2.23606797749979},"39":{"tf":1.4142135623730951},"42":{"tf":1.0},"57":{"tf":2.0},"59":{"tf":2.449489742783178},"70":{"tf":1.4142135623730951},"93":{"tf":1.0},"99":{"tf":1.0}}}}},"u":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"54":{"tf":1.0}}}},"df":0,"docs":{}}},"x":{"df":1,"docs":{"56":{"tf":1.0}}},"z":{"df":0,"docs":{},"e":{"df":1,"docs":{"82":{"tf":1.0}}}}},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":2,"docs":{"25":{"tf":1.0},"80":{"tf":1.7320508075688772}}}}},"l":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"d":{"df":1,"docs":{"61":{"tf":1.0}}},"df":1,"docs":{"61":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"61":{"tf":1.4142135623730951}}}}},"o":{"df":0,"docs":{},"w":{"_":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":1,"docs":{"90":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"m":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"61":{"tf":1.0}}},"l":{"df":1,"docs":{"116":{"tf":1.0}},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"116":{"tf":1.0},"59":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"t":{"a":{"b":{"df":1,"docs":{"60":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":3,"docs":{"59":{"tf":1.4142135623730951},"78":{"tf":1.4142135623730951},"83":{"tf":2.0}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":1,"docs":{"61":{"tf":1.0}}}}}},"l":{"df":1,"docs":{"61":{"tf":1.0}}},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"49":{"tf":1.0}}}}}}}}}},"n":{"a":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"k":{"df":1,"docs":{"61":{"tf":1.0}}}},"df":0,"docs":{}}}},"p":{"/":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"/":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"df":1,"docs":{"11":{"tf":1.0}}}}}},"x":{"df":1,"docs":{"11":{"tf":1.0}}}}},"df":1,"docs":{"11":{"tf":1.0}}}}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":1,"docs":{"11":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":2,"docs":{"11":{"tf":1.7320508075688772},"3":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":3,"docs":{"60":{"tf":1.4142135623730951},"73":{"tf":1.4142135623730951},"93":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":4,"docs":{"70":{"tf":1.4142135623730951},"82":{"tf":2.23606797749979},"93":{"tf":1.0},"99":{"tf":1.7320508075688772}},"w":{"a":{"df":0,"docs":{},"r":{"df":4,"docs":{"64":{"tf":2.0},"65":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":2.0}}}},"df":0,"docs":{}}}},"l":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":1,"docs":{"61":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"c":{"df":1,"docs":{"61":{"tf":1.0}}},"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"61":{"tf":1.0}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"94":{"tf":1.0}}}}},"m":{"df":0,"docs":{},"e":{"/":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"59":{"tf":2.449489742783178}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"_":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":1,"docs":{"115":{"tf":1.4142135623730951}}}}}},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"117":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"93":{"tf":1.0}}},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"116":{"tf":1.0}}}}}}},"o":{"df":0,"docs":{},"n":{"df":3,"docs":{"115":{"tf":1.4142135623730951},"116":{"tf":2.449489742783178},"84":{"tf":1.0}}}},"r":{"df":0,"docs":{},"t":{"df":2,"docs":{"55":{"tf":1.7320508075688772},"59":{"tf":1.4142135623730951}}}},"u":{"df":0,"docs":{},"r":{"c":{"df":13,"docs":{"1":{"tf":1.0},"104":{"tf":2.0},"112":{"tf":1.0},"21":{"tf":2.0},"22":{"tf":1.7320508075688772},"23":{"tf":1.0},"24":{"tf":1.0},"25":{"tf":1.4142135623730951},"5":{"tf":1.0},"59":{"tf":1.4142135623730951},"94":{"tf":1.4142135623730951},"98":{"tf":1.0},"99":{"tf":1.4142135623730951}},"e":{".":{"<":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"99":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"109":{"tf":1.0}}}}},"j":{"df":1,"docs":{"99":{"tf":1.0}}},"m":{"df":0,"docs":{},"y":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"99":{"tf":1.0}}}}},"df":0,"docs":{}}}},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"109":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"61":{"tf":1.0}}}}},"p":{"a":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":1,"docs":{"61":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"p":{"a":{"c":{"df":0,"docs":{},"e":{".":{"b":{"df":1,"docs":{"56":{"tf":1.0}}},"df":0,"docs":{}},">":{"<":{"a":{"df":1,"docs":{"60":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"a":{"df":1,"docs":{"60":{"tf":1.4142135623730951}}},"b":{"df":1,"docs":{"60":{"tf":1.4142135623730951}}},"c":{"df":1,"docs":{"60":{"tf":2.0}}},"d":{"df":1,"docs":{"60":{"tf":2.0}}},"df":1,"docs":{"60":{"tf":2.8284271247461903}},"f":{"df":1,"docs":{"60":{"tf":2.0}}},"g":{"<":{"c":{"df":1,"docs":{"60":{"tf":2.0}}},"df":0,"docs":{}},"b":{"df":1,"docs":{"60":{"tf":1.4142135623730951}}},"c":{"df":1,"docs":{"60":{"tf":1.4142135623730951}}},"df":1,"docs":{"60":{"tf":2.449489742783178}},"h":{"df":1,"docs":{"60":{"tf":1.4142135623730951}}},"i":{"df":1,"docs":{"60":{"tf":1.4142135623730951}}},"l":{"df":1,"docs":{"60":{"tf":1.4142135623730951}}},"n":{"df":1,"docs":{"60":{"tf":1.4142135623730951}}},"o":{"df":1,"docs":{"60":{"tf":1.4142135623730951}}},"r":{"df":1,"docs":{"60":{"tf":1.4142135623730951}}},"s":{"df":0,"docs":{},"f":{"df":1,"docs":{"60":{"tf":1.4142135623730951}}},"t":{"df":1,"docs":{"60":{"tf":1.4142135623730951}}}},"t":{"df":1,"docs":{"60":{"tf":1.4142135623730951}}},"v":{"df":1,"docs":{"60":{"tf":1.4142135623730951}}}},"h":{"df":1,"docs":{"60":{"tf":1.4142135623730951}}},"i":{"df":1,"docs":{"60":{"tf":2.0}}},"j":{"df":1,"docs":{"60":{"tf":1.4142135623730951}}},"k":{"df":1,"docs":{"60":{"tf":1.4142135623730951}}},"p":{"df":1,"docs":{"60":{"tf":2.0}}},"r":{"df":1,"docs":{"60":{"tf":2.0}}},"w":{"<":{"c":{"df":1,"docs":{"60":{"tf":4.47213595499958}}},"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":1,"docs":{"60":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":1,"docs":{"60":{"tf":1.4142135623730951}}}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":1,"docs":{"60":{"tf":1.4142135623730951}}}}}}},"u":{"df":0,"docs":{},"p":{"df":1,"docs":{"60":{"tf":1.4142135623730951}}}}},"df":1,"docs":{"60":{"tf":1.4142135623730951}},"f":{"df":1,"docs":{"60":{"tf":2.0}}},"h":{"df":1,"docs":{"60":{"tf":2.0}}},"j":{"df":1,"docs":{"60":{"tf":2.0}}},"k":{"df":1,"docs":{"60":{"tf":2.0}}},"l":{"df":1,"docs":{"60":{"tf":2.0}}},"n":{"<":{"c":{"df":1,"docs":{"60":{"tf":2.0}}},"df":0,"docs":{}},"df":1,"docs":{"60":{"tf":1.4142135623730951}},"v":{"df":1,"docs":{"60":{"tf":1.4142135623730951}}}},"o":{"df":1,"docs":{"60":{"tf":1.4142135623730951}}},"q":{"df":1,"docs":{"60":{"tf":1.4142135623730951}}},"t":{"df":1,"docs":{"60":{"tf":1.4142135623730951}}},"v":{"df":1,"docs":{"60":{"tf":1.4142135623730951}}},"w":{"df":1,"docs":{"60":{"tf":1.4142135623730951}}}}},"df":15,"docs":{"40":{"tf":1.0},"41":{"tf":1.0},"42":{"tf":1.0},"46":{"tf":1.0},"48":{"tf":2.6457513110645907},"54":{"tf":2.0},"56":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":3.4641016151377544},"72":{"tf":1.0},"79":{"tf":2.0},"82":{"tf":1.0},"93":{"tf":1.0},"96":{"tf":1.4142135623730951},"99":{"tf":1.4142135623730951}},"r":{"df":3,"docs":{"70":{"tf":1.7320508075688772},"72":{"tf":1.4142135623730951},"81":{"tf":2.0}}}}},"d":{"df":0,"docs":{},"e":{"df":1,"docs":{"61":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"n":{"df":3,"docs":{"116":{"tf":1.4142135623730951},"117":{"tf":1.0},"59":{"tf":1.7320508075688772}}}},"df":1,"docs":{"59":{"tf":1.0}},"e":{"c":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"l":{"df":5,"docs":{"32":{"tf":1.0},"35":{"tf":1.7320508075688772},"37":{"tf":1.0},"93":{"tf":2.23606797749979},"96":{"tf":1.7320508075688772}}}},"df":0,"docs":{},"f":{"df":12,"docs":{"100":{"tf":1.4142135623730951},"112":{"tf":1.4142135623730951},"119":{"tf":1.4142135623730951},"22":{"tf":1.0},"25":{"tf":1.0},"41":{"tf":1.0},"70":{"tf":1.4142135623730951},"75":{"tf":1.0},"76":{"tf":1.0},"78":{"tf":1.0},"81":{"tf":1.0},"97":{"tf":1.0}},"i":{"df":10,"docs":{"103":{"tf":1.0},"104":{"tf":1.0},"34":{"tf":1.0},"37":{"tf":1.0},"55":{"tf":1.0},"59":{"tf":1.4142135623730951},"68":{"tf":1.0},"72":{"tf":1.0},"75":{"tf":1.0},"87":{"tf":1.7320508075688772}}}}}},"df":0,"docs":{}},"i":{"c":{"df":0,"docs":{},"e":{"d":{"b":{"df":1,"docs":{"61":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"n":{"df":1,"docs":{"9":{"tf":1.0}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"72":{"tf":2.0},"73":{"tf":1.0}}}}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"46":{"tf":1.0},"60":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"46":{"tf":1.0},"60":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"df":7,"docs":{"36":{"tf":1.0},"46":{"tf":1.4142135623730951},"48":{"tf":2.8284271247461903},"54":{"tf":1.0},"59":{"tf":2.0},"60":{"tf":3.872983346207417},"93":{"tf":1.0}}}}}},"q":{"df":0,"docs":{},"l":{"df":1,"docs":{"61":{"tf":1.0}}},"u":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"36":{"tf":1.0}}}},"df":0,"docs":{}}},"r":{"c":{"df":1,"docs":{"21":{"tf":1.0}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"h":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":1,"docs":{"61":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}},"t":{"a":{"c":{"df":0,"docs":{},"k":{"df":2,"docs":{"116":{"tf":1.4142135623730951},"60":{"tf":1.0}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":1,"docs":{"64":{"tf":1.0}}}},"n":{"d":{"a":{"df":0,"docs":{},"r":{"d":{"df":7,"docs":{"100":{"tf":1.0},"119":{"tf":1.0},"120":{"tf":1.4142135623730951},"121":{"tf":1.7320508075688772},"122":{"tf":1.7320508075688772},"21":{"tf":1.0},"30":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":1,"docs":{"61":{"tf":1.0}}}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"61":{"tf":1.0}}}},"t":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":1,"docs":{"45":{"tf":1.0}}}}}}},"df":19,"docs":{"100":{"tf":1.0},"102":{"tf":1.4142135623730951},"114":{"tf":1.0},"115":{"tf":2.8284271247461903},"116":{"tf":3.3166247903554},"117":{"tf":1.0},"41":{"tf":1.0},"44":{"tf":2.23606797749979},"45":{"tf":1.0},"46":{"tf":1.0},"48":{"tf":1.7320508075688772},"49":{"tf":1.4142135623730951},"52":{"tf":1.4142135623730951},"56":{"tf":2.6457513110645907},"59":{"tf":1.7320508075688772},"60":{"tf":4.242640687119285},"70":{"tf":1.0},"94":{"tf":1.0},"99":{"tf":1.4142135623730951}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"116":{"tf":1.0}}}}}}},"i":{"c":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"94":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":5,"docs":{"21":{"tf":1.0},"58":{"tf":1.0},"60":{"tf":2.23606797749979},"93":{"tf":1.0},"94":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"u":{"df":3,"docs":{"3":{"tf":1.0},"59":{"tf":1.0},"72":{"tf":1.0}},"s":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":5,"docs":{"56":{"tf":2.23606797749979},"59":{"tf":1.0},"72":{"tf":2.6457513110645907},"73":{"tf":1.7320508075688772},"93":{"tf":2.449489742783178}}}}}}}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"71":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":3,"docs":{"101":{"tf":1.4142135623730951},"102":{"tf":1.0},"99":{"tf":1.4142135623730951}}},"o":{"df":1,"docs":{"102":{"tf":1.0}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"99":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":6,"docs":{"107":{"tf":1.0},"22":{"tf":1.0},"25":{"tf":1.0},"59":{"tf":1.4142135623730951},"60":{"tf":1.7320508075688772},"70":{"tf":1.0}}}},"i":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"df":1,"docs":{"48":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":3,"docs":{"64":{"tf":1.0},"70":{"tf":1.0},"73":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"p":{"df":2,"docs":{"116":{"tf":1.0},"59":{"tf":1.4142135623730951}}},"r":{"a":{"df":0,"docs":{},"g":{"df":2,"docs":{"32":{"tf":1.0},"93":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"e":{"df":4,"docs":{"17":{"tf":1.0},"22":{"tf":1.0},"33":{"tf":2.0},"93":{"tf":1.0}}}}},"r":{"a":{"c":{"df":0,"docs":{},"e":{"df":1,"docs":{"61":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"57":{"tf":1.0}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":1,"docs":{"63":{"tf":1.0}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":1,"docs":{"93":{"tf":1.0}}}}}}}}}}},"n":{"df":0,"docs":{},"g":{".":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"d":{".":{"df":0,"docs":{},"{":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":1,"docs":{"93":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"r":{"a":{"df":0,"docs":{},"w":{"/":{".":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"93":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"119":{"tf":1.0}}}}}}}}},"f":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"119":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":9,"docs":{"100":{"tf":1.4142135623730951},"117":{"tf":2.449489742783178},"119":{"tf":1.0},"122":{"tf":1.7320508075688772},"56":{"tf":1.7320508075688772},"57":{"tf":2.0},"72":{"tf":1.0},"93":{"tf":1.4142135623730951},"99":{"tf":1.0}}}},"v":{"df":0,"docs":{},"e":{"df":1,"docs":{"99":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":2,"docs":{"115":{"tf":1.4142135623730951},"116":{"tf":2.449489742783178}},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"49":{"tf":1.0},"63":{"tf":1.0}}}}}}},"u":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"93":{"tf":1.0}},"u":{"df":0,"docs":{},"r":{"df":2,"docs":{"37":{"tf":1.4142135623730951},"94":{"tf":1.0}}}}}},"df":0,"docs":{}}},"u":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"39":{"tf":1.0}}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":2,"docs":{"61":{"tf":1.0},"65":{"tf":2.0}}}}},"df":0,"docs":{}},"y":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"/":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"87":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":8,"docs":{"100":{"tf":1.0},"48":{"tf":1.0},"59":{"tf":1.4142135623730951},"64":{"tf":1.0},"72":{"tf":1.4142135623730951},"87":{"tf":1.7320508075688772},"91":{"tf":1.4142135623730951},"93":{"tf":3.3166247903554}}}}}},"u":{"b":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":4,"docs":{"100":{"tf":1.0},"104":{"tf":1.0},"22":{"tf":1.4142135623730951},"59":{"tf":1.7320508075688772}}}}}}},"df":0,"docs":{}}}}},"df":7,"docs":{"102":{"tf":1.0},"46":{"tf":1.0},"48":{"tf":1.0},"60":{"tf":2.8284271247461903},"72":{"tf":1.0},"79":{"tf":1.4142135623730951},"99":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"93":{"tf":1.0}}}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"109":{"tf":1.0},"87":{"tf":1.0}}}}},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"104":{"tf":1.0}}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"81":{"tf":1.0}}}},"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":1,"docs":{"116":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":2,"docs":{"39":{"tf":1.0},"59":{"tf":1.7320508075688772}}}}}},"c":{"df":0,"docs":{},"h":{"df":10,"docs":{"112":{"tf":1.0},"116":{"tf":1.4142135623730951},"32":{"tf":1.0},"37":{"tf":1.0},"64":{"tf":1.0},"68":{"tf":1.0},"83":{"tf":1.4142135623730951},"84":{"tf":1.4142135623730951},"94":{"tf":1.0},"96":{"tf":1.0}}}},"d":{"df":0,"docs":{},"o":{"df":4,"docs":{"15":{"tf":1.0},"6":{"tf":1.7320508075688772},"7":{"tf":1.0},"8":{"tf":1.0}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"df":1,"docs":{"100":{"tf":1.0}}}}}},"g":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"93":{"tf":1.0}}}}}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"61":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":2,"docs":{"93":{"tf":1.0},"96":{"tf":1.7320508075688772}},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"61":{"tf":1.4142135623730951}}}}}},"s":{"df":0,"docs":{},"e":{"d":{"df":1,"docs":{"83":{"tf":1.0}}},"df":0,"docs":{},"t":{"df":1,"docs":{"48":{"tf":1.0}}}}}}},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"57":{"tf":1.0},"59":{"tf":1.4142135623730951}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":25,"docs":{"0":{"tf":1.0},"101":{"tf":1.0},"103":{"tf":1.7320508075688772},"108":{"tf":1.0},"112":{"tf":1.0},"117":{"tf":1.4142135623730951},"24":{"tf":1.0},"36":{"tf":1.0},"41":{"tf":1.0},"48":{"tf":2.0},"51":{"tf":1.0},"52":{"tf":1.0},"53":{"tf":1.4142135623730951},"56":{"tf":1.4142135623730951},"57":{"tf":1.0},"61":{"tf":2.23606797749979},"70":{"tf":1.7320508075688772},"75":{"tf":1.0},"77":{"tf":1.0},"81":{"tf":1.0},"83":{"tf":1.4142135623730951},"90":{"tf":1.0},"91":{"tf":1.0},"94":{"tf":1.0},"96":{"tf":1.4142135623730951}}}}}}},"r":{"df":0,"docs":{},"e":{"df":9,"docs":{"108":{"tf":1.0},"109":{"tf":1.0},"11":{"tf":1.0},"111":{"tf":1.0},"115":{"tf":1.4142135623730951},"116":{"tf":2.449489742783178},"12":{"tf":1.0},"17":{"tf":1.0},"23":{"tf":1.0}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"_":{"a":{"d":{"d":{"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}}}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"a":{"c":{"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":8,"docs":{"36":{"tf":3.0},"37":{"tf":1.4142135623730951},"48":{"tf":2.0},"54":{"tf":1.4142135623730951},"56":{"tf":1.0},"60":{"tf":1.7320508075688772},"63":{"tf":1.0},"94":{"tf":1.0}}},"df":0,"docs":{}}}}}},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"60":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"61":{"tf":1.0}},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{"df":1,"docs":{"61":{"tf":1.0}}}}}}}}}},"l":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{"df":1,"docs":{"61":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}},"w":{"a":{"df":0,"docs":{},"p":{"_":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"_":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"p":{"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"df":2,"docs":{"48":{"tf":2.0},"60":{"tf":2.0}}},"t":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"73":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"y":{"df":1,"docs":{"61":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":1,"docs":{"61":{"tf":1.0}}}},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"61":{"tf":1.0}}}},"t":{"c":{"df":0,"docs":{},"h":{"_":{"c":{"a":{"df":0,"docs":{},"s":{"df":2,"docs":{"45":{"tf":1.0},"60":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"c":{"a":{"df":0,"docs":{},"s":{"df":2,"docs":{"45":{"tf":1.0},"60":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"c":{"a":{"df":0,"docs":{},"s":{"df":2,"docs":{"45":{"tf":1.0},"60":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"df":8,"docs":{"109":{"tf":1.0},"111":{"tf":1.0},"28":{"tf":1.0},"45":{"tf":1.0},"48":{"tf":1.4142135623730951},"49":{"tf":1.0},"55":{"tf":1.0},"60":{"tf":2.23606797749979}}}},"df":0,"docs":{}}}},"y":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"k":{"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":6,"docs":{"103":{"tf":2.23606797749979},"22":{"tf":1.4142135623730951},"41":{"tf":1.0},"48":{"tf":2.0},"60":{"tf":2.0},"93":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":2,"docs":{"22":{"tf":1.0},"75":{"tf":1.7320508075688772}}}}}}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"y":{"df":0,"docs":{},"m":{"df":1,"docs":{"96":{"tf":1.0}}}}}},"t":{"a":{"df":0,"docs":{},"x":{"df":14,"docs":{"110":{"tf":1.0},"112":{"tf":1.0},"114":{"tf":1.0},"115":{"tf":1.0},"116":{"tf":1.0},"39":{"tf":2.8284271247461903},"41":{"tf":1.0},"46":{"tf":2.8284271247461903},"48":{"tf":1.0},"53":{"tf":1.0},"60":{"tf":2.0},"61":{"tf":1.0},"70":{"tf":1.0},"93":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"\'":{"df":3,"docs":{"1":{"tf":1.0},"2":{"tf":1.0},"25":{"tf":1.0}}},"d":{"df":1,"docs":{"61":{"tf":1.4142135623730951}}},"df":13,"docs":{"100":{"tf":1.0},"21":{"tf":1.0},"24":{"tf":1.0},"25":{"tf":1.0},"35":{"tf":1.4142135623730951},"48":{"tf":1.4142135623730951},"5":{"tf":1.0},"54":{"tf":1.4142135623730951},"56":{"tf":1.4142135623730951},"59":{"tf":2.8284271247461903},"68":{"tf":1.0},"81":{"tf":1.0},"94":{"tf":1.0}}}}}}},"|":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"e":{"c":{"=":{"df":0,"docs":{},"h":{"df":0,"docs":{},"x":{"df":1,"docs":{"24":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"i":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"=":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"df":0,"docs":{},"|":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"=":{"$":{"(":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":1,"docs":{"24":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"l":{"=":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"|":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"l":{"=":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"|":{"df":0,"docs":{},"g":{"df":1,"docs":{"24":{"tf":1.0}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}}},"t":{"3":{"2":{"df":1,"docs":{"61":{"tf":1.0}}},"df":0,"docs":{}},"a":{"b":{"df":11,"docs":{"48":{"tf":1.4142135623730951},"51":{"tf":1.4142135623730951},"52":{"tf":1.0},"54":{"tf":1.4142135623730951},"59":{"tf":1.0},"60":{"tf":2.449489742783178},"69":{"tf":1.0},"79":{"tf":2.449489742783178},"83":{"tf":4.47213595499958},"96":{"tf":1.4142135623730951},"99":{"tf":2.0}},"l":{"df":9,"docs":{"100":{"tf":1.4142135623730951},"102":{"tf":1.4142135623730951},"103":{"tf":1.0},"104":{"tf":1.4142135623730951},"108":{"tf":1.0},"76":{"tf":1.0},"79":{"tf":1.0},"89":{"tf":1.4142135623730951},"99":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"61":{"tf":1.0}}}}}}},"p":{"a":{"d":{"df":1,"docs":{"79":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":1,"docs":{"93":{"tf":1.0}}}}}}},"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"61":{"tf":1.0}}}},"df":0,"docs":{},"g":{"df":2,"docs":{"104":{"tf":1.0},"93":{"tf":2.23606797749979}}},"i":{"df":0,"docs":{},"l":{"df":2,"docs":{"116":{"tf":1.4142135623730951},"118":{"tf":2.23606797749979}}}},"k":{"df":0,"docs":{},"e":{"df":14,"docs":{"1":{"tf":1.0},"100":{"tf":1.0},"102":{"tf":1.0},"104":{"tf":1.0},"118":{"tf":1.4142135623730951},"56":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.0},"72":{"tf":1.0},"73":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":1.0},"89":{"tf":1.0},"99":{"tf":1.4142135623730951}},"n":{"df":1,"docs":{"103":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":1,"docs":{"61":{"tf":1.0}}}}},"r":{"b":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"2":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"/":{"d":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"25":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"/":{"df":0,"docs":{},"h":{"df":0,"docs":{},"x":{"df":1,"docs":{"22":{"tf":1.0}}}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"/":{"df":0,"docs":{},"h":{"df":0,"docs":{},"x":{"df":1,"docs":{"25":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":3,"docs":{"21":{"tf":1.4142135623730951},"22":{"tf":1.0},"60":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"k":{"df":2,"docs":{"27":{"tf":1.0},"61":{"tf":1.0}}}}},"c":{"df":0,"docs":{},"l":{"df":1,"docs":{"61":{"tf":1.0}}},"p":{"df":1,"docs":{"59":{"tf":1.4142135623730951}}}},"df":10,"docs":{"37":{"tf":1.7320508075688772},"38":{"tf":1.0},"44":{"tf":2.23606797749979},"48":{"tf":2.449489742783178},"51":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":4.0},"93":{"tf":1.0},"95":{"tf":1.0},"99":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"61":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"e":{"df":1,"docs":{"71":{"tf":1.4142135623730951}}},"l":{"df":0,"docs":{},"l":{"df":2,"docs":{"103":{"tf":1.0},"116":{"tf":1.0}}}},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"59":{"tf":1.4142135623730951}}}},"df":1,"docs":{"61":{"tf":1.4142135623730951}}},"o":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"79":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"r":{"a":{"df":1,"docs":{"61":{"tf":1.0}}},"df":0,"docs":{},"m":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"r":{"c":{"/":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"94":{"tf":1.0}}}},"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"d":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"94":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"c":{"df":0,"docs":{},"o":{"d":{"df":2,"docs":{"70":{"tf":1.0},"71":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":5,"docs":{"116":{"tf":1.0},"21":{"tf":1.4142135623730951},"36":{"tf":1.0},"41":{"tf":1.4142135623730951},"50":{"tf":1.4142135623730951}},"i":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"l":{"\'":{"df":2,"docs":{"42":{"tf":1.0},"89":{"tf":1.0}}},"df":0,"docs":{}}},"df":9,"docs":{"24":{"tf":1.0},"42":{"tf":1.0},"70":{"tf":1.4142135623730951},"74":{"tf":1.0},"77":{"tf":1.0},"83":{"tf":1.4142135623730951},"90":{"tf":1.0},"91":{"tf":1.0},"96":{"tf":1.0}}}},"u":{"df":0,"docs":{},"x":{"df":2,"docs":{"61":{"tf":1.0},"70":{"tf":1.0}}}}},"r":{"a":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":1,"docs":{"61":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"t":{".":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"112":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"112":{"tf":1.0}}},"df":0,"docs":{}}}}},"t":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"71":{"tf":1.4142135623730951}}}}}},"df":10,"docs":{"109":{"tf":1.0},"112":{"tf":1.0},"114":{"tf":1.0},"22":{"tf":1.0},"37":{"tf":1.0},"48":{"tf":1.4142135623730951},"60":{"tf":1.4142135623730951},"71":{"tf":1.4142135623730951},"95":{"tf":1.0},"99":{"tf":1.0}}}},"x":{"df":0,"docs":{},"l":{"a":{"b":{"df":1,"docs":{"61":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"t":{".":{"<":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"99":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"d":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"99":{"tf":1.0}}}}}}}}}}}},"df":0,"docs":{}}},"df":20,"docs":{"121":{"tf":1.7320508075688772},"27":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":1.7320508075688772},"33":{"tf":1.4142135623730951},"34":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":2.0},"41":{"tf":1.4142135623730951},"45":{"tf":2.0},"48":{"tf":1.0},"49":{"tf":1.0},"57":{"tf":1.0},"60":{"tf":1.0},"70":{"tf":1.4142135623730951},"72":{"tf":1.7320508075688772},"82":{"tf":1.7320508075688772},"84":{"tf":1.4142135623730951},"93":{"tf":2.6457513110645907},"99":{"tf":1.7320508075688772}},"m":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"93":{"tf":1.0},"99":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"b":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":8,"docs":{"106":{"tf":1.0},"112":{"tf":2.23606797749979},"113":{"tf":1.7320508075688772},"37":{"tf":2.6457513110645907},"38":{"tf":2.23606797749979},"48":{"tf":1.7320508075688772},"61":{"tf":1.0},"63":{"tf":1.0}},"s":{".":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"m":{"df":2,"docs":{"112":{"tf":1.0},"113":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"61":{"tf":1.0}}}}}}},"u":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"48":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}},"f":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"61":{"tf":1.0}}}},"df":0,"docs":{}}},"h":{"a":{"df":0,"docs":{},"t":{"\'":{"df":1,"docs":{"117":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"87":{"tf":1.0}}}}}}},"df":14,"docs":{"0":{"tf":1.0},"110":{"tf":1.0},"59":{"tf":2.0},"68":{"tf":1.0},"81":{"tf":1.0},"85":{"tf":2.449489742783178},"86":{"tf":2.6457513110645907},"87":{"tf":1.7320508075688772},"88":{"tf":1.7320508075688772},"89":{"tf":2.0},"90":{"tf":1.0},"91":{"tf":1.0},"92":{"tf":2.0},"93":{"tf":1.7320508075688772}}}},"y":{"\'":{"df":0,"docs":{},"r":{"df":1,"docs":{"31":{"tf":1.0}}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{".":{"c":{"a":{"df":0,"docs":{},"n":{"_":{"d":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"(":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"116":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"93":{"tf":1.0}},"s":{".":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"|":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"116":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}},"r":{"d":{"df":1,"docs":{"4":{"tf":1.0}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":2,"docs":{"25":{"tf":1.0},"54":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":1,"docs":{"60":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":3,"docs":{"72":{"tf":1.0},"94":{"tf":1.0},"98":{"tf":1.0}}}},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":1,"docs":{"61":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":9,"docs":{"115":{"tf":1.0},"22":{"tf":1.0},"45":{"tf":1.0},"57":{"tf":1.4142135623730951},"60":{"tf":1.0},"83":{"tf":1.4142135623730951},"9":{"tf":1.0},"93":{"tf":1.0},"94":{"tf":1.0}}}}}}},"u":{"d":{"df":1,"docs":{"116":{"tf":1.0}}},"df":0,"docs":{},"m":{"b":{"df":1,"docs":{"93":{"tf":1.0}}},"df":0,"docs":{}}}},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"_":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{"df":2,"docs":{"44":{"tf":1.0},"60":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":2,"docs":{"44":{"tf":1.4142135623730951},"60":{"tf":2.449489742783178}}}},"m":{"df":0,"docs":{},"e":{"df":7,"docs":{"102":{"tf":1.0},"103":{"tf":1.0},"22":{"tf":1.4142135623730951},"30":{"tf":1.0},"59":{"tf":1.4142135623730951},"70":{"tf":1.4142135623730951},"77":{"tf":1.0}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"102":{"tf":1.0},"70":{"tf":1.4142135623730951}}}}},"r":{"df":2,"docs":{"70":{"tf":1.0},"77":{"tf":1.0}}},"—":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"22":{"tf":1.0}}}}}}}},"n":{"df":0,"docs":{},"y":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"61":{"tf":1.0}}}}}}}}},"l":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":1,"docs":{"61":{"tf":1.0}}}}}},"df":0,"docs":{}},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"x":{"df":1,"docs":{"70":{"tf":1.0}}}}},"o":{"d":{"df":0,"docs":{},"o":{"df":4,"docs":{"119":{"tf":1.0},"48":{"tf":1.0},"63":{"tf":1.0},"93":{"tf":1.4142135623730951}},"t":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"61":{"tf":1.0}}}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"103":{"tf":1.0}}}}},"g":{"df":0,"docs":{},"l":{"df":5,"docs":{"50":{"tf":1.4142135623730951},"51":{"tf":1.0},"57":{"tf":3.1622776601683795},"59":{"tf":2.23606797749979},"60":{"tf":1.4142135623730951}},"e":{"_":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"k":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":3,"docs":{"46":{"tf":1.0},"48":{"tf":1.0},"60":{"tf":1.0}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":5,"docs":{"116":{"tf":1.0},"54":{"tf":1.0},"56":{"tf":1.0},"70":{"tf":1.0},"99":{"tf":3.1622776601683795}}}}},"m":{"b":{"df":0,"docs":{},"i":{"df":1,"docs":{"61":{"tf":1.0}}}},"df":0,"docs":{},"l":{"df":5,"docs":{"100":{"tf":1.4142135623730951},"41":{"tf":1.4142135623730951},"61":{"tf":1.0},"76":{"tf":1.0},"94":{"tf":1.0}}}},"o":{"df":0,"docs":{},"l":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"21":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":2,"docs":{"17":{"tf":1.0},"25":{"tf":1.0}}}},"p":{"df":6,"docs":{"105":{"tf":1.0},"48":{"tf":1.4142135623730951},"60":{"tf":1.4142135623730951},"70":{"tf":1.0},"81":{"tf":1.0},"85":{"tf":1.0}}},"t":{"a":{"df":0,"docs":{},"l":{"df":3,"docs":{"114":{"tf":1.4142135623730951},"117":{"tf":1.0},"72":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}},"r":{"a":{"c":{"df":0,"docs":{},"k":{"df":2,"docs":{"93":{"tf":1.0},"99":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"70":{"tf":1.4142135623730951}}}},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":1,"docs":{"60":{"tf":1.0}},"e":{"_":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"60":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":3,"docs":{"114":{"tf":1.0},"115":{"tf":1.7320508075688772},"116":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":5,"docs":{"54":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.0},"70":{"tf":1.0},"99":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":24,"docs":{"104":{"tf":2.449489742783178},"106":{"tf":1.0},"109":{"tf":1.0},"110":{"tf":1.0},"111":{"tf":1.0},"112":{"tf":2.0},"113":{"tf":1.0},"114":{"tf":2.23606797749979},"115":{"tf":1.0},"117":{"tf":1.4142135623730951},"119":{"tf":1.0},"121":{"tf":1.0},"21":{"tf":2.0},"37":{"tf":1.7320508075688772},"38":{"tf":2.23606797749979},"39":{"tf":3.0},"42":{"tf":1.0},"46":{"tf":2.6457513110645907},"57":{"tf":2.0},"59":{"tf":2.449489742783178},"60":{"tf":1.4142135623730951},"70":{"tf":1.7320508075688772},"93":{"tf":1.0},"99":{"tf":1.0}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":1,"docs":{"61":{"tf":1.0}}}}}}}},"i":{"df":3,"docs":{"103":{"tf":1.0},"65":{"tf":1.0},"99":{"tf":1.0}},"g":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"70":{"tf":1.7320508075688772},"77":{"tf":1.0},"83":{"tf":1.4142135623730951}}}}}},"m":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"46":{"tf":1.0},"60":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":3,"docs":{"46":{"tf":1.0},"60":{"tf":1.0},"70":{"tf":1.4142135623730951}}}},"u":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"70":{"tf":1.0}}}}}}},"df":11,"docs":{"102":{"tf":2.0},"115":{"tf":2.8284271247461903},"70":{"tf":4.0},"73":{"tf":2.6457513110645907},"75":{"tf":2.8284271247461903},"76":{"tf":1.0},"78":{"tf":1.4142135623730951},"80":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.7320508075688772},"93":{"tf":1.0}}}}},"s":{"_":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"l":{"df":1,"docs":{"61":{"tf":1.0}}}},"df":0,"docs":{}}}}}}},"df":4,"docs":{"42":{"tf":1.0},"46":{"tf":2.8284271247461903},"48":{"tf":3.3166247903554},"59":{"tf":1.0}},"f":{"df":1,"docs":{"22":{"tf":1.0}}},"p":{"df":1,"docs":{"61":{"tf":1.0}}},"q":{"df":1,"docs":{"61":{"tf":1.0}}},"x":{"df":2,"docs":{"103":{"tf":1.0},"61":{"tf":1.0}}}},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"26":{"tf":1.7320508075688772},"59":{"tf":1.0}},"i":{"df":1,"docs":{"59":{"tf":1.0}}}}}}},"w":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"k":{"df":1,"docs":{"65":{"tf":1.0}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"g":{"df":1,"docs":{"61":{"tf":1.0}}}},"o":{"df":6,"docs":{"116":{"tf":1.0},"41":{"tf":1.0},"54":{"tf":1.0},"56":{"tf":1.0},"60":{"tf":1.7320508075688772},"70":{"tf":1.0}}}},"y":{"df":1,"docs":{"61":{"tf":1.0}},"p":{"a":{"b":{"df":0,"docs":{},"l":{"df":4,"docs":{"53":{"tf":1.4142135623730951},"58":{"tf":1.0},"59":{"tf":2.0},"94":{"tf":1.4142135623730951}},"e":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"94":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"94":{"tf":1.0}}}},"df":0,"docs":{}},"df":24,"docs":{"100":{"tf":3.0},"103":{"tf":1.0},"114":{"tf":1.0},"115":{"tf":1.0},"116":{"tf":1.4142135623730951},"120":{"tf":1.4142135623730951},"27":{"tf":1.7320508075688772},"37":{"tf":1.0},"38":{"tf":1.0},"41":{"tf":1.0},"42":{"tf":1.0},"48":{"tf":3.0},"49":{"tf":1.0},"50":{"tf":1.0},"55":{"tf":1.0},"57":{"tf":1.4142135623730951},"60":{"tf":1.7320508075688772},"68":{"tf":1.0},"70":{"tf":1.0},"72":{"tf":1.7320508075688772},"81":{"tf":1.0},"93":{"tf":2.8284271247461903},"94":{"tf":1.0},"99":{"tf":1.7320508075688772}},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":4,"docs":{"102":{"tf":1.4142135623730951},"103":{"tf":3.0},"104":{"tf":1.0},"61":{"tf":2.6457513110645907}}}}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"c":{"df":1,"docs":{"61":{"tf":1.0}}},"df":0,"docs":{}}}}},"i":{"c":{"df":3,"docs":{"1":{"tf":1.0},"2":{"tf":1.0},"48":{"tf":1.0}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"61":{"tf":1.0}}}}}}},"u":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"/":{"d":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"n":{"df":2,"docs":{"3":{"tf":1.0},"5":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":4,"docs":{"25":{"tf":1.0},"3":{"tf":1.0},"5":{"tf":1.0},"6":{"tf":1.4142135623730951}}}}}}},"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"20":{"tf":1.0}}}}},"df":10,"docs":{"44":{"tf":1.0},"45":{"tf":2.0},"48":{"tf":1.4142135623730951},"49":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.0},"56":{"tf":1.7320508075688772},"57":{"tf":1.4142135623730951},"59":{"tf":1.0},"60":{"tf":3.872983346207417}},"i":{".":{"b":{"a":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"93":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":2,"docs":{"89":{"tf":1.0},"93":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"u":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"93":{"tf":1.0}},"e":{".":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"93":{"tf":1.0}}}},"df":0,"docs":{}},"b":{"a":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"93":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}}}},"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"93":{"tf":1.0}}}}}}}},"m":{"a":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"93":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":1,"docs":{"93":{"tf":1.0}}}}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"93":{"tf":1.0}}},"y":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"93":{"tf":1.0}}}}}}}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":1,"docs":{"93":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"93":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"93":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"n":{".":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"93":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"s":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"93":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}},"df":1,"docs":{"93":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"93":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"s":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"93":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}}}}}},"d":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{".":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"93":{"tf":1.0}}}},"df":0,"docs":{}},"b":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"k":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"93":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":1,"docs":{"93":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"93":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"p":{"df":1,"docs":{"93":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"93":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}},"df":1,"docs":{"93":{"tf":1.0}}}}}}}}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"r":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"93":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":1,"docs":{"93":{"tf":1.0}}}}}}}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{".":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"93":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"93":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":1,"docs":{"93":{"tf":1.0}}}}}},"p":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{".":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"a":{"d":{"df":1,"docs":{"93":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"n":{".":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"93":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"93":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":1,"docs":{"93":{"tf":1.4142135623730951}}}}}}},"df":1,"docs":{"93":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"93":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{".":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"93":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"t":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"93":{"tf":1.0}},"e":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"93":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"93":{"tf":1.0}}}}}}}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":1,"docs":{"93":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"93":{"tf":1.0}}}},"df":0,"docs":{}}},"p":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"93":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{".":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"93":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"u":{"df":1,"docs":{"93":{"tf":1.0}}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"n":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"93":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":1,"docs":{"93":{"tf":1.0}}}}}}},"df":2,"docs":{"89":{"tf":1.0},"93":{"tf":1.4142135623730951}}}}}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"l":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"93":{"tf":1.0}}},"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"y":{"df":1,"docs":{"93":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}}},"j":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":1,"docs":{"93":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"93":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"a":{"c":{"df":1,"docs":{"93":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"r":{"a":{"df":0,"docs":{},"p":{"df":2,"docs":{"82":{"tf":1.0},"93":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"93":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":2,"docs":{"59":{"tf":1.0},"93":{"tf":2.449489742783178}}},"n":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"111":{"tf":1.0}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"116":{"tf":1.0}}}},"df":0,"docs":{}}}}},"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"99":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"93":{"tf":1.0}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"99":{"tf":1.0}}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":1,"docs":{"70":{"tf":1.4142135623730951}}}}}},"df":9,"docs":{"112":{"tf":1.0},"45":{"tf":1.4142135623730951},"48":{"tf":1.4142135623730951},"52":{"tf":1.0},"59":{"tf":1.7320508075688772},"60":{"tf":1.7320508075688772},"68":{"tf":1.0},"70":{"tf":1.0},"73":{"tf":1.4142135623730951}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":5,"docs":{"68":{"tf":1.0},"74":{"tf":1.0},"87":{"tf":2.0},"90":{"tf":1.4142135623730951},"91":{"tf":1.4142135623730951}},"e":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"l":{"df":1,"docs":{"91":{"tf":1.0}},"e":{"=":{"\\"":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"90":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}}},"o":{"df":3,"docs":{"45":{"tf":1.4142135623730951},"49":{"tf":1.4142135623730951},"60":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":2,"docs":{"70":{"tf":1.0},"93":{"tf":1.0}}}}},"df":0,"docs":{}}},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"61":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"i":{"c":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"56":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"75":{"tf":1.4142135623730951}}}}}},"m":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":3,"docs":{"38":{"tf":1.0},"42":{"tf":1.0},"48":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}},"n":{"d":{"df":2,"docs":{"45":{"tf":1.4142135623730951},"60":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"93":{"tf":1.0}}}},"q":{"df":0,"docs":{},"u":{"df":1,"docs":{"93":{"tf":1.4142135623730951}}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"61":{"tf":1.0}}}}},"t":{"df":1,"docs":{"99":{"tf":1.4142135623730951}}},"x":{"df":5,"docs":{"100":{"tf":1.4142135623730951},"54":{"tf":1.4142135623730951},"56":{"tf":1.0},"68":{"tf":1.0},"70":{"tf":1.0}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"76":{"tf":1.0},"78":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"k":{"df":3,"docs":{"44":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.0}}}}},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"121":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"93":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"m":{"b":{"df":1,"docs":{"93":{"tf":1.0}}},"df":0,"docs":{}}}},"s":{"a":{"df":0,"docs":{},"v":{"df":2,"docs":{"59":{"tf":2.449489742783178},"72":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":2,"docs":{"73":{"tf":1.0},"75":{"tf":1.0}}}},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"9":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"115":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"s":{"df":2,"docs":{"81":{"tf":1.4142135623730951},"93":{"tf":1.4142135623730951}}}}},"p":{"d":{"a":{"df":0,"docs":{},"t":{"df":5,"docs":{"108":{"tf":1.7320508075688772},"111":{"tf":1.0},"17":{"tf":1.0},"59":{"tf":1.0},"6":{"tf":1.0}}}},"df":0,"docs":{}},"df":18,"docs":{"115":{"tf":1.0},"116":{"tf":1.0},"118":{"tf":1.0},"2":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":1.0},"39":{"tf":1.0},"44":{"tf":2.0},"46":{"tf":1.0},"48":{"tf":2.8284271247461903},"49":{"tf":1.7320508075688772},"51":{"tf":1.4142135623730951},"52":{"tf":1.0},"56":{"tf":1.0},"60":{"tf":3.7416573867739413},"70":{"tf":1.0},"9":{"tf":1.0},"96":{"tf":1.7320508075688772}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"c":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"60":{"tf":1.0}}}},"df":0,"docs":{}},"df":2,"docs":{"45":{"tf":1.0},"78":{"tf":1.0}}}}},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"48":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"l":{"df":2,"docs":{"104":{"tf":1.0},"93":{"tf":2.23606797749979}}}},"s":{"a":{"df":0,"docs":{},"g":{"df":37,"docs":{"0":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"30":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":1.4142135623730951},"33":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.0},"42":{"tf":1.0},"43":{"tf":1.0},"44":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.0},"53":{"tf":1.0},"54":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.0},"58":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0}}}},"df":65,"docs":{"100":{"tf":2.23606797749979},"102":{"tf":1.4142135623730951},"103":{"tf":2.23606797749979},"104":{"tf":1.7320508075688772},"105":{"tf":2.23606797749979},"109":{"tf":1.4142135623730951},"113":{"tf":1.0},"114":{"tf":2.0},"116":{"tf":1.4142135623730951},"117":{"tf":1.0},"119":{"tf":1.0},"12":{"tf":1.0},"120":{"tf":2.0},"16":{"tf":1.0},"2":{"tf":1.0},"21":{"tf":1.0},"22":{"tf":1.7320508075688772},"24":{"tf":1.4142135623730951},"25":{"tf":2.23606797749979},"26":{"tf":1.4142135623730951},"28":{"tf":1.0},"30":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":1.4142135623730951},"34":{"tf":1.7320508075688772},"36":{"tf":2.0},"38":{"tf":2.23606797749979},"39":{"tf":2.0},"40":{"tf":1.7320508075688772},"41":{"tf":2.449489742783178},"47":{"tf":2.0},"48":{"tf":1.7320508075688772},"51":{"tf":1.0},"52":{"tf":1.0},"53":{"tf":1.0},"54":{"tf":2.449489742783178},"55":{"tf":1.0},"56":{"tf":2.8284271247461903},"57":{"tf":1.7320508075688772},"59":{"tf":2.449489742783178},"60":{"tf":1.4142135623730951},"61":{"tf":1.0},"64":{"tf":2.0},"65":{"tf":1.0},"67":{"tf":1.0},"68":{"tf":1.4142135623730951},"70":{"tf":3.3166247903554},"71":{"tf":2.0},"72":{"tf":1.0},"75":{"tf":1.4142135623730951},"76":{"tf":1.0},"79":{"tf":1.4142135623730951},"80":{"tf":1.0},"81":{"tf":1.7320508075688772},"82":{"tf":1.0},"83":{"tf":2.0},"85":{"tf":1.4142135623730951},"89":{"tf":1.0},"9":{"tf":2.8284271247461903},"90":{"tf":1.0},"91":{"tf":1.0},"93":{"tf":2.6457513110645907},"94":{"tf":2.23606797749979},"96":{"tf":2.0},"99":{"tf":3.3166247903554}},"e":{"df":0,"docs":{},"r":{"\'":{"df":1,"docs":{"21":{"tf":1.0}}},"df":9,"docs":{"120":{"tf":1.4142135623730951},"22":{"tf":2.0},"32":{"tf":1.0},"33":{"tf":1.4142135623730951},"49":{"tf":1.7320508075688772},"59":{"tf":1.4142135623730951},"86":{"tf":1.0},"87":{"tf":1.0},"9":{"tf":1.0}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"22":{"tf":1.0}},"e":{"%":{"\\\\":{"df":0,"docs":{},"s":{"df":0,"docs":{},"r":{"c":{"\\\\":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"\\\\":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"22":{"tf":1.4142135623730951}}}}}}}}},"df":0,"docs":{}}}}}}},"df":1,"docs":{"21":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}}},"i":{"df":0,"docs":{},"z":{"df":1,"docs":{"93":{"tf":1.0}}}},"r":{"/":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"b":{"/":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"22":{"tf":1.4142135623730951}}}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"1":{"df":1,"docs":{"68":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"u":{"a":{"df":0,"docs":{},"l":{"df":6,"docs":{"56":{"tf":1.0},"75":{"tf":1.0},"9":{"tf":1.0},"94":{"tf":1.0},"95":{"tf":1.0},"99":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"f":{"df":1,"docs":{"72":{"tf":1.0}}}},"x":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"61":{"tf":1.0}}}},"df":0,"docs":{}}}},"{":{"2":{"5":{"c":{"df":0,"docs":{},"f":{"df":1,"docs":{"56":{"tf":2.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"v":{"a":{"df":1,"docs":{"37":{"tf":1.0}},"l":{"a":{"df":1,"docs":{"61":{"tf":1.4142135623730951}}},"df":1,"docs":{"116":{"tf":1.4142135623730951}},"i":{"d":{"df":3,"docs":{"21":{"tf":1.0},"23":{"tf":1.4142135623730951},"74":{"tf":1.0}}},"df":0,"docs":{}},"u":{"df":17,"docs":{"100":{"tf":1.0},"116":{"tf":1.0},"35":{"tf":1.4142135623730951},"53":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":2.23606797749979},"59":{"tf":2.23606797749979},"74":{"tf":1.0},"75":{"tf":1.0},"76":{"tf":1.0},"82":{"tf":1.0},"84":{"tf":1.7320508075688772},"89":{"tf":1.0},"90":{"tf":1.0},"91":{"tf":1.4142135623730951},"98":{"tf":1.0},"99":{"tf":1.4142135623730951}},"e":{"1":{"df":1,"docs":{"102":{"tf":1.4142135623730951}}},"2":{"df":1,"docs":{"102":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"r":{"df":1,"docs":{"93":{"tf":1.0}},"i":{"a":{"b":{"df":0,"docs":{},"l":{"df":12,"docs":{"101":{"tf":1.0},"102":{"tf":1.0},"111":{"tf":1.0},"2":{"tf":1.0},"21":{"tf":1.4142135623730951},"22":{"tf":2.23606797749979},"54":{"tf":1.0},"56":{"tf":2.0},"60":{"tf":1.0},"84":{"tf":1.0},"93":{"tf":2.0},"99":{"tf":1.0}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"48":{"tf":1.0},"93":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":2,"docs":{"40":{"tf":1.0},"64":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"u":{"df":3,"docs":{"40":{"tf":1.0},"48":{"tf":1.0},"64":{"tf":1.0}}}}}}},"df":7,"docs":{"27":{"tf":1.0},"48":{"tf":1.7320508075688772},"50":{"tf":1.0},"51":{"tf":1.0},"60":{"tf":3.1622776601683795},"61":{"tf":1.4142135623730951},"93":{"tf":1.0}},"e":{"c":{"<":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"116":{"tf":1.0}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"81":{"tf":1.0}}}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"61":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"25":{"tf":1.0}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":1,"docs":{"61":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":9,"docs":{"1":{"tf":1.0},"17":{"tf":1.4142135623730951},"21":{"tf":1.0},"25":{"tf":1.0},"61":{"tf":1.0},"65":{"tf":1.0},"72":{"tf":1.0},"9":{"tf":1.0},"93":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"i":{"c":{"df":6,"docs":{"48":{"tf":1.7320508075688772},"51":{"tf":1.0},"59":{"tf":1.4142135623730951},"60":{"tf":1.4142135623730951},"80":{"tf":1.0},"93":{"tf":1.0}}},"df":0,"docs":{}}}}},"g":{"df":0,"docs":{},"l":{"df":1,"docs":{"50":{"tf":1.0}}}},"h":{"d":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"l":{"df":1,"docs":{"61":{"tf":1.0}}}},"df":1,"docs":{"61":{"tf":1.0}}}},"df":1,"docs":{"61":{"tf":1.0}}},"i":{"a":{"df":6,"docs":{"1":{"tf":1.0},"114":{"tf":1.0},"26":{"tf":1.0},"40":{"tf":1.0},"65":{"tf":1.0},"94":{"tf":1.0}}},"df":1,"docs":{"37":{"tf":1.0}},"e":{"df":0,"docs":{},"w":{"df":7,"docs":{"39":{"tf":1.0},"42":{"tf":1.0},"48":{"tf":2.6457513110645907},"59":{"tf":3.0},"60":{"tf":2.449489742783178},"82":{"tf":1.0},"95":{"tf":1.0}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"82":{"tf":1.0}}}}}}}},"m":{"df":8,"docs":{"32":{"tf":1.0},"36":{"tf":1.4142135623730951},"37":{"tf":1.4142135623730951},"44":{"tf":1.0},"48":{"tf":1.4142135623730951},"63":{"tf":2.6457513110645907},"64":{"tf":1.0},"65":{"tf":1.0}}},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"93":{"tf":1.0}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"l":{"df":3,"docs":{"75":{"tf":1.0},"79":{"tf":1.4142135623730951},"93":{"tf":1.0}}}},"df":0,"docs":{}},"u":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"48":{"tf":1.4142135623730951},"65":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"59":{"tf":1.0}}}}},"s":{"c":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{"df":1,"docs":{"61":{"tf":3.0}}}},"df":0,"docs":{}}},"df":2,"docs":{"59":{"tf":1.0},"65":{"tf":1.0}},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"60":{"tf":1.0}}}}}},"df":3,"docs":{"48":{"tf":1.0},"59":{"tf":1.4142135623730951},"60":{"tf":1.4142135623730951}}}}}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"65":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"e":{"df":1,"docs":{"61":{"tf":1.4142135623730951}}}}},"w":{"6":{"4":{"df":1,"docs":{"20":{"tf":1.0}}},"df":0,"docs":{}},">":{"<":{"c":{"df":1,"docs":{"60":{"tf":4.47213595499958}}},"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":1,"docs":{"60":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":1,"docs":{"60":{"tf":1.4142135623730951}}}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":1,"docs":{"60":{"tf":1.4142135623730951}}}}}}},"u":{"df":0,"docs":{},"p":{"df":1,"docs":{"60":{"tf":1.4142135623730951}}}}},"df":1,"docs":{"60":{"tf":1.4142135623730951}},"f":{"df":1,"docs":{"60":{"tf":2.0}}},"h":{"df":1,"docs":{"60":{"tf":2.0}}},"j":{"df":1,"docs":{"60":{"tf":2.0}}},"k":{"df":1,"docs":{"60":{"tf":2.0}}},"l":{"df":1,"docs":{"60":{"tf":2.0}}},"n":{"<":{"c":{"df":1,"docs":{"60":{"tf":2.0}}},"df":0,"docs":{}},"df":1,"docs":{"60":{"tf":1.4142135623730951}},"v":{"df":1,"docs":{"60":{"tf":1.4142135623730951}}}},"o":{"df":1,"docs":{"60":{"tf":1.4142135623730951}}},"q":{"df":1,"docs":{"60":{"tf":1.4142135623730951}}},"t":{"df":1,"docs":{"60":{"tf":1.4142135623730951}}},"v":{"df":1,"docs":{"60":{"tf":1.4142135623730951}}},"w":{"df":1,"docs":{"60":{"tf":1.4142135623730951}}}},"a":{"df":1,"docs":{"59":{"tf":1.4142135623730951}},"l":{"d":{"df":0,"docs":{},"o":{"df":1,"docs":{"116":{"tf":1.0}}}},"df":0,"docs":{}},"n":{"df":0,"docs":{},"t":{"df":7,"docs":{"111":{"tf":1.0},"116":{"tf":1.4142135623730951},"118":{"tf":1.0},"21":{"tf":1.0},"22":{"tf":1.0},"49":{"tf":1.0},"87":{"tf":1.0}}}},"r":{"df":0,"docs":{},"n":{"df":5,"docs":{"25":{"tf":1.0},"72":{"tf":2.449489742783178},"84":{"tf":1.7320508075688772},"93":{"tf":1.7320508075688772},"99":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"61":{"tf":1.0}}}},"t":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{"df":1,"docs":{"61":{"tf":1.0}}}}}}},"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"/":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"70":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}},"df":1,"docs":{"61":{"tf":1.0}}},"y":{"df":10,"docs":{"1":{"tf":1.0},"114":{"tf":1.0},"115":{"tf":1.0},"22":{"tf":1.0},"25":{"tf":1.0},"30":{"tf":1.0},"37":{"tf":1.4142135623730951},"53":{"tf":1.0},"54":{"tf":1.0},"94":{"tf":1.4142135623730951}},"l":{"a":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"70":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"b":{"c":{"df":1,"docs":{"59":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}}}}}}},"df":10,"docs":{"31":{"tf":1.0},"37":{"tf":1.4142135623730951},"41":{"tf":1.0},"44":{"tf":1.4142135623730951},"48":{"tf":2.449489742783178},"49":{"tf":1.0},"52":{"tf":1.4142135623730951},"59":{"tf":1.4142135623730951},"60":{"tf":3.0},"94":{"tf":2.0}},"e":{"b":{"c":{"df":1,"docs":{"61":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"110":{"tf":1.0}}}}}},"df":0,"docs":{},"l":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"37":{"tf":1.0}}}}},"df":0,"docs":{},"l":{"df":4,"docs":{"116":{"tf":1.0},"120":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.0}}}},"r":{"df":0,"docs":{},"k":{"df":1,"docs":{"61":{"tf":1.0}}}},"s":{"df":0,"docs":{},"l":{"df":1,"docs":{"61":{"tf":1.0}}}}},"g":{"df":0,"docs":{},"s":{"df":0,"docs":{},"l":{"df":1,"docs":{"61":{"tf":1.4142135623730951}}}}},"h":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":2,"docs":{"29":{"tf":1.0},"63":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"70":{"tf":1.0}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":9,"docs":{"116":{"tf":1.0},"70":{"tf":2.8284271247461903},"72":{"tf":1.0},"78":{"tf":1.0},"79":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0},"99":{"tf":1.4142135623730951}}}}}}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"89":{"tf":1.7320508075688772}},"s":{"df":0,"docs":{},"p":{"a":{"c":{"df":8,"docs":{"116":{"tf":1.0},"46":{"tf":1.0},"48":{"tf":1.0},"60":{"tf":1.4142135623730951},"70":{"tf":1.4142135623730951},"79":{"tf":2.0},"83":{"tf":1.4142135623730951},"93":{"tf":1.0}},"e":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"79":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":5,"docs":{"118":{"tf":1.4142135623730951},"36":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.0},"94":{"tf":1.0}}}},"s":{"df":0,"docs":{},"e":{"df":1,"docs":{"75":{"tf":1.0}}}}}},"i":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"62":{"tf":1.0}}}},"t":{"df":0,"docs":{},"h":{"df":9,"docs":{"29":{"tf":1.0},"59":{"tf":1.0},"63":{"tf":1.0},"70":{"tf":1.7320508075688772},"79":{"tf":1.0},"81":{"tf":1.4142135623730951},"82":{"tf":1.7320508075688772},"93":{"tf":1.0},"99":{"tf":2.23606797749979}}}}},"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"df":4,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"108":{"tf":1.0},"42":{"tf":1.0}}}},"n":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"73":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}}}},"df":17,"docs":{"100":{"tf":1.0},"16":{"tf":1.7320508075688772},"17":{"tf":1.7320508075688772},"20":{"tf":1.0},"21":{"tf":1.4142135623730951},"22":{"tf":1.7320508075688772},"3":{"tf":1.0},"40":{"tf":1.0},"42":{"tf":1.0},"48":{"tf":3.3166247903554},"54":{"tf":1.0},"56":{"tf":1.0},"60":{"tf":2.6457513110645907},"68":{"tf":1.0},"70":{"tf":1.4142135623730951},"75":{"tf":1.0},"86":{"tf":1.0}},"s":{"/":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"x":{"df":1,"docs":{"96":{"tf":1.4142135623730951}}}}}}}},"df":0,"docs":{}}}}},"df":3,"docs":{"100":{"tf":1.0},"70":{"tf":1.0},"96":{"tf":1.7320508075688772}},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":3,"docs":{"16":{"tf":1.0},"17":{"tf":2.0},"3":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"e":{"df":1,"docs":{"46":{"tf":1.4142135623730951}}}},"t":{"df":1,"docs":{"61":{"tf":1.0}},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":11,"docs":{"102":{"tf":1.0},"104":{"tf":1.0},"117":{"tf":1.0},"21":{"tf":1.0},"41":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.0},"54":{"tf":1.4142135623730951},"56":{"tf":1.7320508075688772},"68":{"tf":1.0},"94":{"tf":1.0}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":10,"docs":{"116":{"tf":1.0},"41":{"tf":1.0},"45":{"tf":1.4142135623730951},"48":{"tf":1.0},"51":{"tf":1.0},"57":{"tf":1.0},"59":{"tf":1.4142135623730951},"60":{"tf":1.4142135623730951},"9":{"tf":1.0},"94":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}}}}},"r":{"d":{"df":14,"docs":{"29":{"tf":1.0},"30":{"tf":1.0},"31":{"tf":1.0},"37":{"tf":1.7320508075688772},"44":{"tf":2.449489742783178},"47":{"tf":1.0},"48":{"tf":1.4142135623730951},"49":{"tf":1.4142135623730951},"52":{"tf":2.23606797749979},"60":{"tf":5.291502622129181},"63":{"tf":1.0},"70":{"tf":1.7320508075688772},"82":{"tf":1.0},"94":{"tf":1.0}}},"df":0,"docs":{},"k":{"df":15,"docs":{"102":{"tf":1.0},"103":{"tf":1.0},"112":{"tf":1.0},"113":{"tf":1.0},"117":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"42":{"tf":1.0},"48":{"tf":1.0},"51":{"tf":1.0},"57":{"tf":1.0},"59":{"tf":1.4142135623730951},"60":{"tf":1.4142135623730951},"70":{"tf":1.0},"80":{"tf":1.0}},"s":{"df":0,"docs":{},"p":{"a":{"c":{"df":10,"docs":{"103":{"tf":1.7320508075688772},"41":{"tf":1.0},"48":{"tf":2.0},"57":{"tf":1.4142135623730951},"59":{"tf":2.0},"60":{"tf":2.0},"70":{"tf":1.4142135623730951},"72":{"tf":2.449489742783178},"75":{"tf":1.0},"99":{"tf":1.7320508075688772}},"e":{"_":{"d":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"k":{"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"k":{"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"25":{"tf":1.0}}}}}},"q":{"a":{"df":1,"docs":{"59":{"tf":1.4142135623730951}}},"df":1,"docs":{"59":{"tf":2.0}}},"r":{"a":{"df":0,"docs":{},"p":{".":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"x":{"df":1,"docs":{"84":{"tf":1.0}}}},"df":0,"docs":{}},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":2,"docs":{"70":{"tf":1.0},"99":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":12,"docs":{"39":{"tf":1.0},"47":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.0},"69":{"tf":1.0},"70":{"tf":1.0},"78":{"tf":1.4142135623730951},"82":{"tf":3.872983346207417},"84":{"tf":1.4142135623730951},"93":{"tf":1.4142135623730951},"94":{"tf":1.0},"99":{"tf":1.4142135623730951}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"61":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"61":{"tf":1.0}}}},"i":{"df":0,"docs":{},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"35":{"tf":1.7320508075688772}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":10,"docs":{"110":{"tf":1.0},"112":{"tf":1.0},"118":{"tf":1.0},"119":{"tf":1.0},"53":{"tf":1.7320508075688772},"59":{"tf":5.0},"70":{"tf":2.23606797749979},"94":{"tf":1.4142135623730951},"96":{"tf":2.6457513110645907},"99":{"tf":1.0}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":5,"docs":{"112":{"tf":1.0},"118":{"tf":1.0},"35":{"tf":1.4142135623730951},"72":{"tf":1.0},"96":{"tf":1.0}}}}}}}}},"x":{"8":{"6":{"_":{"6":{"4":{"df":1,"docs":{"20":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"<":{"a":{"df":1,"docs":{"94":{"tf":1.0}}},"df":0,"docs":{}},"a":{"df":1,"docs":{"59":{"tf":1.4142135623730951}}},"d":{"df":0,"docs":{},"g":{"df":1,"docs":{"24":{"tf":1.0}}}},"df":8,"docs":{"12":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.7320508075688772},"49":{"tf":1.0},"59":{"tf":1.4142135623730951},"60":{"tf":3.0},"70":{"tf":1.4142135623730951},"94":{"tf":3.1622776601683795}},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"61":{"tf":1.0}}}},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"61":{"tf":1.0}}}},"t":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"k":{"df":1,"docs":{"108":{"tf":1.0}}}}},"c":{"df":1,"docs":{"61":{"tf":1.0}}},"df":0,"docs":{}},"y":{"df":0,"docs":{},"z":{"df":0,"docs":{},"z":{"df":0,"docs":{},"i":{"df":1,"docs":{"116":{"tf":1.0}}}}}}},"y":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":5,"docs":{"100":{"tf":1.0},"105":{"tf":1.0},"116":{"tf":1.4142135623730951},"61":{"tf":2.0},"99":{"tf":1.0}}}},"n":{"df":0,"docs":{},"k":{"/":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"70":{"tf":1.0},"71":{"tf":1.0}}}}},"df":0,"docs":{}}},"_":{"df":0,"docs":{},"j":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"60":{"tf":1.0}},"e":{"d":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"b":{"df":0,"docs":{},"o":{"a":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"60":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"_":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"b":{"df":0,"docs":{},"o":{"a":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"60":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"m":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"b":{"df":0,"docs":{},"o":{"a":{"df":0,"docs":{},"r":{"d":{"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"_":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"b":{"df":0,"docs":{},"o":{"a":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"60":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"o":{"_":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"b":{"df":0,"docs":{},"o":{"a":{"df":0,"docs":{},"r":{"d":{"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"_":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"b":{"df":0,"docs":{},"o":{"a":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"60":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":12,"docs":{"29":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.4142135623730951},"35":{"tf":2.0},"45":{"tf":2.449489742783178},"48":{"tf":1.4142135623730951},"59":{"tf":3.4641016151377544},"60":{"tf":3.4641016151377544},"63":{"tf":1.0},"70":{"tf":1.4142135623730951},"71":{"tf":1.4142135623730951},"94":{"tf":1.0}}}},"r":{"a":{"df":1,"docs":{"61":{"tf":1.0}}},"df":0,"docs":{},"n":{".":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"99":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":6,"docs":{"34":{"tf":1.0},"45":{"tf":1.0},"48":{"tf":1.7320508075688772},"56":{"tf":1.4142135623730951},"57":{"tf":1.4142135623730951},"60":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"89":{"tf":1.4142135623730951}}}}}}},"l":{"df":1,"docs":{"61":{"tf":1.0}}},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"99":{"tf":1.0}}}},"o":{"df":0,"docs":{},"u":{"\'":{"df":0,"docs":{},"r":{"df":2,"docs":{"111":{"tf":1.0},"48":{"tf":1.0}}}},"df":0,"docs":{}}},"u":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"61":{"tf":1.0}}}},"df":0,"docs":{}}},"z":{"<":{"b":{"a":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"a":{"c":{"df":1,"docs":{"60":{"tf":2.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"c":{"df":1,"docs":{"60":{"tf":4.0}}},"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":1,"docs":{"60":{"tf":2.0}}}}}},"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":1,"docs":{"60":{"tf":2.0}}}}}},"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":1,"docs":{"60":{"tf":2.0}}}}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"p":{"a":{"c":{"df":0,"docs":{},"e":{"df":1,"docs":{"60":{"tf":2.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"p":{"df":1,"docs":{"60":{"tf":2.0}}}}},"b":{"df":1,"docs":{"60":{"tf":2.0}}},"c":{"df":1,"docs":{"60":{"tf":2.0}}},"df":2,"docs":{"48":{"tf":2.23606797749979},"60":{"tf":3.1622776601683795}},"e":{"d":{"df":1,"docs":{"65":{"tf":1.0}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":1,"docs":{"73":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"g":{"df":1,"docs":{"61":{"tf":1.0}}}},"j":{"df":1,"docs":{"60":{"tf":2.0}}},"k":{"df":1,"docs":{"60":{"tf":2.0}}},"l":{"df":1,"docs":{"61":{"tf":1.0}}},"m":{"df":1,"docs":{"60":{"tf":2.0}}},"n":{"df":1,"docs":{"60":{"tf":2.8284271247461903}}},"s":{"df":0,"docs":{},"h":{"df":2,"docs":{"25":{"tf":1.0},"66":{"tf":1.7320508075688772}}}},"t":{"df":1,"docs":{"60":{"tf":2.0}}},"z":{"df":1,"docs":{"60":{"tf":2.0}}}}}},"title":{"root":{"a":{"d":{"df":4,"docs":{"107":{"tf":1.0},"112":{"tf":1.0},"114":{"tf":1.0},"119":{"tf":1.0}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"12":{"tf":1.0}}}},"df":0,"docs":{}}}}},"r":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"8":{"tf":1.0}}}},"df":0,"docs":{}},"w":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"39":{"tf":1.0}}}},"df":0,"docs":{}}},"b":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":1,"docs":{"113":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"2":{"tf":1.0}}}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"28":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"l":{"d":{"df":2,"docs":{"21":{"tf":1.0},"25":{"tf":1.0}}},"df":0,"docs":{},"t":{"df":1,"docs":{"2":{"tf":1.0}}}}}}},"c":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":2,"docs":{"116":{"tf":1.0},"120":{"tf":1.0}}}}}}},"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"45":{"tf":1.0}}}}},"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":1,"docs":{"19":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":1,"docs":{"105":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"89":{"tf":1.0}}}}},"m":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"d":{"df":5,"docs":{"101":{"tf":1.0},"53":{"tf":1.0},"58":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"111":{"tf":1.0}}}}}},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":10,"docs":{"101":{"tf":1.0},"102":{"tf":1.0},"103":{"tf":1.0},"104":{"tf":1.0},"108":{"tf":1.0},"109":{"tf":1.0},"22":{"tf":1.0},"24":{"tf":1.0},"68":{"tf":1.0},"99":{"tf":1.0}}}}}}}},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"14":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"86":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"88":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"d":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"25":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"34":{"tf":1.0}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"33":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"k":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":1,"docs":{"24":{"tf":1.0}}}}}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"88":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"100":{"tf":1.0}}}},"df":0,"docs":{}}}},"i":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"84":{"tf":1.0}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"62":{"tf":1.0}}}}}}}}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"29":{"tf":1.0}},"o":{"df":0,"docs":{},"r":{".":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":2,"docs":{"76":{"tf":1.0},"77":{"tf":1.0}}}}}},"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"b":{"df":0,"docs":{},"o":{"a":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"71":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"74":{"tf":1.0}}}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"75":{"tf":1.0}}}}},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":1,"docs":{"81":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"80":{"tf":1.0}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"84":{"tf":1.0}}}}}}},"l":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":1,"docs":{"73":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"78":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"83":{"tf":1.0}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":1,"docs":{"82":{"tf":1.0}}}}},"t":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"72":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}},"w":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"a":{"c":{"df":1,"docs":{"79":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}},"df":3,"docs":{"65":{"tf":1.0},"69":{"tf":1.0},"70":{"tf":1.0}}}}}}},"df":0,"docs":{},"x":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"57":{"tf":1.0}}}}}},"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":1,"docs":{"56":{"tf":1.0}}}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"50":{"tf":1.0}}},"df":0,"docs":{}}},"r":{"a":{"df":1,"docs":{"8":{"tf":1.0}}},"df":0,"docs":{}}}}},"f":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"a":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"7":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":3,"docs":{"100":{"tf":1.4142135623730951},"22":{"tf":1.0},"98":{"tf":1.0}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"41":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"29":{"tf":1.0}}}}}},"l":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"55":{"tf":1.0}}},"t":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"k":{"df":1,"docs":{"10":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":1,"docs":{"101":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"r":{"df":3,"docs":{"104":{"tf":1.0},"105":{"tf":1.0},"109":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"106":{"tf":1.0},"80":{"tf":1.0}}},"df":0,"docs":{}}}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"\'":{"df":1,"docs":{"22":{"tf":1.0}}},"df":5,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"107":{"tf":1.0},"26":{"tf":1.0},"64":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"14":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"114":{"tf":1.0},"115":{"tf":1.0}}}}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"92":{"tf":1.0}}}}}}},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"119":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"49":{"tf":1.0}}}}},"t":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"1":{"tf":1.0},"23":{"tf":1.0}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":1,"docs":{"111":{"tf":1.0}}}}}},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":3,"docs":{"100":{"tf":1.0},"94":{"tf":1.0},"96":{"tf":1.0}},"m":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"42":{"tf":1.0}}}},"df":0,"docs":{}}}}},"l":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"g":{"df":7,"docs":{"102":{"tf":1.0},"103":{"tf":1.4142135623730951},"107":{"tf":1.0},"108":{"tf":1.0},"61":{"tf":1.0},"97":{"tf":1.0},"99":{"tf":1.0}},"e":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"98":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":1,"docs":{"53":{"tf":1.0}}},"u":{"df":0,"docs":{},"x":{"df":2,"docs":{"4":{"tf":1.0},"8":{"tf":1.0}}}}}}},"m":{"a":{"c":{"df":0,"docs":{},"o":{"df":1,"docs":{"13":{"tf":1.0}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"15":{"tf":1.0}}}}}}},"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"3":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":2,"docs":{"37":{"tf":1.0},"46":{"tf":1.0}}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"63":{"tf":1.0}}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"48":{"tf":1.0},"95":{"tf":1.0}}}}}},"o":{"d":{"df":0,"docs":{},"e":{"df":7,"docs":{"27":{"tf":1.0},"43":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.0},"64":{"tf":1.0},"95":{"tf":1.0}}},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":2,"docs":{"90":{"tf":1.0},"96":{"tf":1.0}}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"31":{"tf":1.0},"39":{"tf":1.0}}}}}},"v":{"df":0,"docs":{},"e":{"df":1,"docs":{"39":{"tf":1.0}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"44":{"tf":1.0}}}}}}}}},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{"2":{"df":1,"docs":{"20":{"tf":1.0}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"30":{"tf":1.0}}}}}}}}},"n":{"a":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":2,"docs":{"113":{"tf":1.0},"38":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"107":{"tf":1.0}}}},"i":{"df":0,"docs":{},"x":{"df":0,"docs":{},"o":{"df":1,"docs":{"9":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"43":{"tf":1.0}}}},"df":0,"docs":{}}}}},"o":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"87":{"tf":1.0}}}}}}}}}},"p":{"a":{"c":{"df":0,"docs":{},"k":{"a":{"df":0,"docs":{},"g":{"df":2,"docs":{"25":{"tf":1.0},"3":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":1,"docs":{"76":{"tf":1.0}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":1,"docs":{"89":{"tf":1.0}}}}}}},"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":4,"docs":{"40":{"tf":1.0},"41":{"tf":1.0},"51":{"tf":1.0},"75":{"tf":1.0}}}}}},"df":0,"docs":{}},"p":{"a":{"df":1,"docs":{"6":{"tf":1.0}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"c":{"df":2,"docs":{"117":{"tf":1.0},"122":{"tf":1.0}}},"df":0,"docs":{}}},"df":1,"docs":{"2":{"tf":1.0}}},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"52":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"71":{"tf":1.0}}},"df":0,"docs":{}}}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":6,"docs":{"110":{"tf":1.0},"112":{"tf":1.0},"113":{"tf":1.0},"114":{"tf":1.0},"115":{"tf":1.0},"119":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"54":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":4,"docs":{"32":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0}}}}}},"m":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"94":{"tf":1.0}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"41":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"22":{"tf":1.0}}}}}}}},"s":{"a":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":1,"docs":{"77":{"tf":1.0}}}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":1,"docs":{"18":{"tf":1.0}}}},"p":{"df":0,"docs":{},"e":{"df":2,"docs":{"118":{"tf":1.0},"93":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"47":{"tf":1.0}}}},"df":0,"docs":{}}},"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":15,"docs":{"70":{"tf":1.0},"71":{"tf":1.0},"72":{"tf":1.0},"73":{"tf":1.0},"74":{"tf":1.0},"75":{"tf":1.0},"76":{"tf":1.0},"77":{"tf":1.0},"78":{"tf":1.0},"79":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":1.0}}}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":6,"docs":{"29":{"tf":1.0},"30":{"tf":1.0},"37":{"tf":1.0},"39":{"tf":1.0},"46":{"tf":1.0},"50":{"tf":1.0}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"102":{"tf":1.0},"103":{"tf":1.0}}}}}},"t":{"df":1,"docs":{"121":{"tf":1.0}}}},"h":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":1,"docs":{"74":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"66":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"24":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"104":{"tf":1.0},"38":{"tf":1.0}}}}}}},"n":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"11":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"r":{"df":2,"docs":{"64":{"tf":1.0},"67":{"tf":1.0}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"r":{"c":{"df":1,"docs":{"21":{"tf":1.0}}},"df":0,"docs":{}}}},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"35":{"tf":1.0},"96":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"t":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"60":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"y":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":1,"docs":{"91":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"61":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"y":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"x":{"df":1,"docs":{"39":{"tf":1.0}}}},"df":0,"docs":{}}}}},"t":{"a":{"b":{"df":1,"docs":{"83":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"37":{"tf":1.0}},"o":{"b":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":4,"docs":{"112":{"tf":1.0},"113":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":3,"docs":{"85":{"tf":1.0},"86":{"tf":1.0},"88":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":2,"docs":{"104":{"tf":1.0},"38":{"tf":1.0}}}}},"y":{"df":0,"docs":{},"p":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"59":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":3,"docs":{"100":{"tf":1.4142135623730951},"116":{"tf":1.0},"120":{"tf":1.0}}}}}},"u":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"/":{"d":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"5":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":1,"docs":{"6":{"tf":1.0}}}}}}},"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"91":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"s":{"df":3,"docs":{"26":{"tf":1.0},"38":{"tf":1.0},"40":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"33":{"tf":1.0}}}}}},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"23":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"63":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"16":{"tf":1.0}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"17":{"tf":1.0}}}}}}},"r":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"82":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"lang":"English","pipeline":["trimmer","stopWordFilter","stemmer"],"ref":"id","version":"0.9.5"},"results_options":{"limit_results":30,"teaser_word_count":30},"search_options":{"bool":"AND","expand":true,"fields":{"body":{"boost":1},"breadcrumbs":{"boost":1},"title":{"boost":2}}}}'));