/*
 * Decompiled with CFR 0.152.
 */
package org.islandoftex.arara.cli.interpreter;

import java.io.IOException;
import java.nio.file.Path;
import java.util.concurrent.TimeoutException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.islandoftex.arara.api.AraraException;
import org.islandoftex.arara.api.configuration.ExecutionMode;
import org.islandoftex.arara.api.localization.Messages;
import org.islandoftex.arara.api.rules.DirectiveConditional;
import org.islandoftex.arara.api.rules.DirectiveConditionalType;
import org.islandoftex.arara.api.session.Command;
import org.islandoftex.arara.cli.ruleset.RuleFormat;
import org.islandoftex.arara.cli.utils.DisplayUtils;
import org.islandoftex.arara.core.files.FileHandling;
import org.islandoftex.arara.core.localization.LanguageController;
import org.islandoftex.arara.core.session.Environment;
import org.islandoftex.arara.core.session.LinearExecutor;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b\u000eJ\u0015\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0000\u00a2\u0006\u0002\b\u0013J\u0015\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0000\u00a2\u0006\u0002\b\u0018R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/islandoftex/arara/cli/interpreter/InterpreterUtils;", "", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "construct", "Ljava/nio/file/Path;", "path", "name", "", "format", "Lorg/islandoftex/arara/cli/ruleset/RuleFormat;", "workingDirectory", "construct$cli", "run", "", "command", "Lorg/islandoftex/arara/api/session/Command;", "run$cli", "runPriorEvaluation", "", "conditional", "Lorg/islandoftex/arara/api/rules/DirectiveConditional;", "runPriorEvaluation$cli", "cli"})
public final class InterpreterUtils {
    @NotNull
    public static final InterpreterUtils INSTANCE = new InterpreterUtils();
    private static final Logger logger = LoggerFactory.getLogger(InterpreterUtils.class);

    private InterpreterUtils() {
    }

    public final boolean runPriorEvaluation$cli(@NotNull DirectiveConditional conditional) {
        boolean bl;
        Intrinsics.checkNotNullParameter(conditional, "conditional");
        if (LinearExecutor.INSTANCE.getExecutionOptions().getExecutionMode() == ExecutionMode.DRY_RUN) {
            bl = false;
        } else {
            switch (WhenMappings.$EnumSwitchMapping$0[conditional.getType().ordinal()]) {
                case 1: 
                case 2: 
                case 3: {
                    bl = true;
                    break;
                }
                default: {
                    bl = false;
                }
            }
        }
        return bl;
    }

    public final int run$cli(@NotNull Command command) throws AraraException {
        Intrinsics.checkNotNullParameter(command, "command");
        Pair<Integer, String> it = Environment.executeSystemCommand-SxA4cEA(command, !LinearExecutor.INSTANCE.getExecutionOptions().getVerbose(), LinearExecutor.INSTANCE.getExecutionOptions().getTimeoutValue-UwyO8pc());
        boolean bl = false;
        int exitCode = ((Number)it.component1()).intValue();
        String output = it.component2();
        if (exitCode == -99) {
            Messages $this$run_u24lambda_u2d1_u24lambda_u2d0 = LanguageController.getMessages();
            boolean bl2 = false;
            Exception exception = new AraraException(output);
            String string = StringsKt.substringBefore$default(output, ":", null, 2, null);
            String string2 = Intrinsics.areEqual(string, IOException.class.getName()) ? $this$run_u24lambda_u2d1_u24lambda_u2d0.getERROR_RUN_IO_EXCEPTION() : (Intrinsics.areEqual(string, TimeoutException.class.getName()) ? $this$run_u24lambda_u2d1_u24lambda_u2d0.getERROR_RUN_TIMEOUT_EXCEPTION() : (Intrinsics.areEqual(string, InterruptedException.class.getName()) ? $this$run_u24lambda_u2d1_u24lambda_u2d0.getERROR_RUN_INTERRUPTED_EXCEPTION() : (Intrinsics.areEqual(string, "org.zeroturnaround.exec.InvalidExitValueException") ? $this$run_u24lambda_u2d1_u24lambda_u2d0.getERROR_RUN_INVALID_EXIT_VALUE_EXCEPTION() : $this$run_u24lambda_u2d1_u24lambda_u2d0.getERROR_RUN_GENERIC_EXCEPTION())));
            throw new AraraException(string2, exception);
        }
        logger.info(DisplayUtils.INSTANCE.displayOutputSeparator(LanguageController.getMessages().getLOG_INFO_BEGIN_BUFFER()));
        logger.info(output);
        logger.info(DisplayUtils.INSTANCE.displayOutputSeparator(LanguageController.getMessages().getLOG_INFO_END_BUFFER()));
        return exitCode;
    }

    @NotNull
    public final Path construct$cli(@NotNull Path path2, @NotNull String name, @NotNull RuleFormat format, @NotNull Path workingDirectory) throws AraraException {
        Path path3;
        Intrinsics.checkNotNullParameter(path2, "path");
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter((Object)format, "format");
        Intrinsics.checkNotNullParameter(workingDirectory, "workingDirectory");
        String fileName = name + '.' + format.getExtension();
        if (path2.isAbsolute()) {
            Path path4 = path2.resolve(fileName);
            Intrinsics.checkNotNullExpressionValue(path4, "this.resolve(other)");
            path3 = path4;
        } else {
            Path path5 = workingDirectory.resolve(path2);
            Intrinsics.checkNotNullExpressionValue(path5, "this.resolve(other)");
            path5 = path5.resolve(fileName);
            Intrinsics.checkNotNullExpressionValue(path5, "this.resolve(other)");
            path3 = path5;
        }
        return FileHandling.normalize(path3);
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DirectiveConditionalType.values().length];
            nArray[DirectiveConditionalType.IF.ordinal()] = 1;
            nArray[DirectiveConditionalType.WHILE.ordinal()] = 2;
            nArray[DirectiveConditionalType.UNLESS.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

