%feature("docstring") OT::RiceFactory
"Rice factory.

Available constructor:
    RiceFactory()

The parameters are estimated by method of moments, according to [koay2006]_.

See also
--------
DistributionFactory, Rice"

// ---------------------------------------------------------------------

%define OT_DistributionFactory_buildAsRice_doc
"Build the Rice distribution.

**Available usages**:

    buildAsRice(*sample*)

    buildAsRice(*param*)

Parameters
----------
sample : 2-d sequence of float
    Sample from which the distribution parameters are estimated.
param : Collection of :class:`~openturns.PointWithDescription`
    A vector of parameters of the distribution.

Returns
-------
dist : :class:`~openturns.Rice`
    The built distribution."
%enddef
%feature("docstring") OT::RiceFactory::buildAsRice
OT_DistributionFactory_buildAsRice_doc

