%feature("docstring") OT::LHSResult
"Summarize the results of an LHS optimization.

Available constructor:
    LHSResult(*bounds, spaceFilling, nRestart*)

Parameters
----------
spaceFilling : :class:`~openturns.SpaceFilling`
    The space filling criteria used by optimization algorithm
nRestart : int
    The number of restarts performed by optimization algorithm

Notes
-----
This class is not intendeted to be built by hand, but returned by optimization algorithms.

Examples
--------
>>> import openturns as ot
>>> lhs = ot.LHSExperiment(ot.ComposedDistribution([ot.Uniform(0.0, 1.0)]*3), 100)
>>> lhs.setAlwaysShuffle(True) # randomized
>>> profile = ot.GeometricProfile()
>>> spaceFilling = ot.SpaceFillingC2()
>>> # Optim algo
>>> algo = ot.SimulatedAnnealingLHS(lhs, spaceFilling, profile)
>>> # first, generate a design
>>> design = algo.generate()
>>> # then, get the result
>>> result = algo.getResult()
"

// ---------------------------------------------------------------------

%feature("docstring") OT::LHSResult::getOptimalDesign
"Accessor to the optimal design.

Returns
-------
design : :class:`~openturns.Sample`
    The design that optimizes the criterion.
"

// ---------------------------------------------------------------------

%feature("docstring") OT::LHSResult::getAlgoHistory
"Accessor to the internal values computed during optimization algorithm.

Returns
-------
history : :class:`~openturns.Point`
    Some internal values computed during optimization algorithm.
    SimulatedAnnealingLHS stores criterion value, temperature
    and probability at each iteration.
"

// ---------------------------------------------------------------------

%feature("docstring") OT::LHSResult::getC2
"Accessor to the C2 criterion evaluated on the optimal design.

Returns
-------
c2 : float
    The C2 criterion.
"

// ---------------------------------------------------------------------

%feature("docstring") OT::LHSResult::getPhiP
"Accessor the PhiP criterion evaluated on the optimal design.

Returns
-------
phiP : float
    The PhiP criterion.
"

// ---------------------------------------------------------------------

%feature("docstring") OT::LHSResult::drawHistoryCriterion
"Draw criterion history.

Parameters
----------
restart : int (optional)
    The restart index.
title : str (optional)
    Graph title.

Returns
-------
graph : :class:`~openturns.Graph`
    The resulting graph."

// ---------------------------------------------------------------------

%feature("docstring") OT::LHSResult::drawHistoryProbability
"Draw probability history.

Parameters
----------
restart : int (optional)
    The restart index.
title : str (optional)
    Graph title.

Returns
-------
graph : :class:`~openturns.Graph`
    The resulting graph."

// ---------------------------------------------------------------------

%feature("docstring") OT::LHSResult::drawHistoryTemperature
"Draw temperature history.

Parameters
----------
restart : int (optional)
    The restart index.
title : str (optional)
    Graph title.

Returns
-------
graph : :class:`~openturns.Graph`
    The resulting graph."

// ---------------------------------------------------------------------

%feature("docstring") OT::LHSResult::getMinDist
"Minimum distance accessor.

Parameters
----------
restart : int (optional)
    The restart index.

Returns
-------
minDist : float
    The minimum distance of sample points."

// ---------------------------------------------------------------------

%feature("docstring") OT::LHSResult::getNumberOfRestarts
"Restart number accessor.

Returns
-------
restart : int (optional)
    The number of restart."

// ---------------------------------------------------------------------

%feature("docstring") OT::LHSResult::getOptimalValue
"Optimal value accessor.

Returns
-------
value : float (optional)
    The optimal value."
