%feature("docstring") OT::KFold
"K-fold.

Parameters
----------
k : positive integer
    Number of folds in which the sample is split. If not provided, default is
    :math:`k = 10`.

See also
--------
FittingAlgorithm, CorrectedLeaveOneOut

Notes
-----
KFold inherits from :class:`~openturns.FittingAlgorithm`.

This class is not usable on its own because it has sense only within the
:class:`~openturns.FunctionalChaosAlgorithm`."

// ---------------------------------------------------------------------

%feature("docstring") OT::KFold::getK
"Accessor to the number of folds.

Returns
-------
k : integer
    Number of folds in which the sample is split."

// ---------------------------------------------------------------------

%feature("docstring") OT::KFold::setK
"Accessor to the number of folds.

Parameters
----------
k : integer
    Number of folds in which the sample is split."
