%define OT_ComplexMatrix_doc
"Complex Matrix.

Available constructors:
    ComplexMatrix(*nr, nc*)

    ComplexMatrix(*nr, nc, values*)

Parameters
----------
nr : integer
    The number of rows of the complex matrix.
nc : integer
    The number of columns of the complex matrix.
values : sequence of complex number
    The sequence must have :math:`n_r \\times n_c` elements. It might be a
    :class:`~openturns.ComplexCollection` or a :class:`~openturns.ScalarCollection`. Default is (0, 0).

See also
--------
ComplexTensor

Examples
--------
>>> import openturns as ot
>>> m = ot.ComplexMatrix(2, 2, [1+2j, 3+4j , 5+6j, 7+8j])
>>> print(m)
[[ (1,2) (5,6) ]
 [ (3,4) (7,8) ]]
>>> m = ot.ComplexMatrix(2, 3, range(2*3))
>>> print(m)
[[ (0,0) (2,0) (4,0) ]
 [ (1,0) (3,0) (5,0) ]]

Create a matrix from a numpy array:

>>> import numpy as np
>>> array = np.array([[1, 2], [3, 4], [5, 6]])
>>> m = ot.ComplexMatrix(array)
>>> print(m)
[[ (1,0) (2,0) ]
 [ (3,0) (4,0) ]
 [ (5,0) (6,0) ]]
"
%enddef
%feature("docstring") OT::ComplexMatrixImplementation
OT_ComplexMatrix_doc

// ---------------------------------------------------------------------

%define OT_ComplexMatrix_clean_doc
"Clean the matrix according to a specific threshold.

Parameters
----------
threshold : positive float
    Numerical sample which is the collection of points stored by the history
    strategy."
%enddef
%feature("docstring") OT::ComplexMatrixImplementation::clean
OT_ComplexMatrix_clean_doc

// ---------------------------------------------------------------------

%define OT_ComplexMatrix_conjugate_doc
"Accessor to the conjugate complex matrix.

Returns
-------
N : :class:`~openturns.ComplexMatrix`
    The conjugate matrix :math:`\\mat{N}` of size :math:`n_r \\times n_c`
    associated with the given complex matrix :math:`\\mat{M}` such as
    :math:`N_{i, j} = \\overline{M}_{i, j}`."
%enddef
%feature("docstring") OT::ComplexMatrixImplementation::conjugate
OT_ComplexMatrix_conjugate_doc

// ---------------------------------------------------------------------

%define OT_ComplexMatrix_conjugateTranspose_doc
"Accessor to the transposed conjugate complex matrix.

Returns
-------
N : :class:`~openturns.ComplexMatrix`
    The transposed conjugate matrix :math:`\\mat{N}` of size :math:`n_c \\times n_r`
    associated with the given complex matrix :math:`\\mat{M}` such as
    :math:`N_{i, j} = \\overline{M}_{j, i}`."
%enddef
%feature("docstring") OT::ComplexMatrixImplementation::conjugateTranspose
OT_ComplexMatrix_conjugateTranspose_doc

// ---------------------------------------------------------------------

%define OT_ComplexMatrix_getNbColumns_doc
"Accessor to the number of columns.

Returns
-------
nc : integer
    The number of columns of :math:`\\mat{M}`."
%enddef
%feature("docstring") OT::ComplexMatrixImplementation::getNbColumns
OT_ComplexMatrix_getNbColumns_doc

// ---------------------------------------------------------------------

%define OT_ComplexMatrix_getNbRows_doc
"Accessor to the number of rows.

Returns
-------
nr : integer
    The number of rows of :math:`\\mat{M}`."
%enddef
%feature("docstring") OT::ComplexMatrixImplementation::getNbRows
OT_ComplexMatrix_getNbRows_doc

// ---------------------------------------------------------------------

%define OT_ComplexMatrix_imag_doc
"Accessor to the imaginary part.

Returns
-------
imat : :class:`~openturns.Matrix`
    A real matix :math:`\\mat{A}` of size :math:`n_r \\times n_c` such 
    :math:`A_{i, j} = \\mathrm{Im} (M_{i, j})`."
%enddef
%feature("docstring") OT::ComplexMatrixImplementation::imag
OT_ComplexMatrix_imag_doc

// ---------------------------------------------------------------------

%define OT_ComplexMatrix_isEmpty_doc
"Test whether the matrix is empty or not.

Returns
-------
isEmpty : bool
    Flag telling whether the dimensions of the matrix is zero."
%enddef
%feature("docstring") OT::ComplexMatrixImplementation::isEmpty
OT_ComplexMatrix_isEmpty_doc

// ---------------------------------------------------------------------

%define OT_ComplexMatrix_real_doc
"Accessor to the real part.

Returns
-------
rmat : :class:`~openturns.Matrix`
    A real matix :math:`\\mat{A}` of size :math:`n_r \\times n_c` such 
    :math:`A_{i, j} = \\mathrm{Re} (M_{i, j})`."
%enddef
%feature("docstring") OT::ComplexMatrixImplementation::real
OT_ComplexMatrix_real_doc

// ---------------------------------------------------------------------

%define OT_ComplexMatrix_transpose_doc
"Accessor to the transposed complex matrix.

Returns
-------
N : :class:`~openturns.ComplexMatrix`
    The transposed matrix :math:`\\mat{N}` of size :math:`n_c \\times n_r`
    associated with the given complex matrix :math:`\\mat{M}` such as
    :math:`N_{i, j} = M_{j, i}`."
%enddef
%feature("docstring") OT::ComplexMatrixImplementation::transpose
OT_ComplexMatrix_transpose_doc