%feature("docstring") OT::ArcsineFactory
"Arcsine factory.

Available constructor:
    ArcsineFactory()

The parameters are estimated by method of moments:

.. math::
    :nowrap:

    \\begin{eqnarray*}
      \\displaystyle \\Hat{a} = \\Hat{\\mu}_x - \\Hat{\\sigma}_x \\sqrt{2}\\\\
      \\displaystyle \\Hat{b} = \\Hat{\\mu}_x + \\Hat{\\sigma}_x \\sqrt{2}
    \\end{eqnarray*}

See also
--------
DistributionFactory, Arcsine"

// ---------------------------------------------------------------------

%define OT_DistributionFactory_buildAsArcsine_doc
"Build the Arcsine distribution.

**Available usages**:

    buildAsArcsine(*sample*)

    buildAsArcsine(*param*)

Parameters
----------
sample : 2-d sequence of float
    Sample from which the distribution parameters are estimated.
param : Collection of :class:`~openturns.PointWithDescription`
    A vector of parameters of the distribution.

Returns
-------
dist : :class:`~openturns.Arcsine`
    The built distribution."
%enddef
%feature("docstring") OT::ArcsineFactory::buildAsArcsine
OT_DistributionFactory_buildAsArcsine_doc

