#ifndef _NANOTIMER_H_INCLUDED_
#define _NANOTIMER_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// NanoTimer.h
// -----------
// NanoTimer class definition
//                                                         
// Design and Implementation by Bjoern Lemke               
// 
// (C)opyright 2000-2016 Bjoern Lemke
//                                                         
// INTERFACE MODULE
//
// Class: NanoTimer 
// 
// Description: NanoTimer class for time measurement
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

#include <sys/time.h>

class NanoTimer {

public:
    
    NanoTimer();
    ~NanoTimer();
    void start();
    void stop();

    unsigned long long getSum() const;
    void reset();
    
private:

    unsigned long long _start, _end, _sum;

};
#endif
