# This file was automatically generated by SWIG (https://www.swig.org).
# Version 4.2.1
#
# Do not make changes to this file unless you know what you are doing - modify
# the SWIG interface file instead.

"""Classification algorithms."""

from sys import version_info as _swig_python_version_info
# Import the low-level C/C++ module
if __package__ or "." in __name__:
    from . import _classification
else:
    import _classification

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "this":
            set(self, name, value)
        elif name == "thisown":
            self.this.own(value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)


class SwigPyIterator(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _classification.delete_SwigPyIterator

    def value(self):
        return _classification.SwigPyIterator_value(self)

    def incr(self, n=1):
        return _classification.SwigPyIterator_incr(self, n)

    def decr(self, n=1):
        return _classification.SwigPyIterator_decr(self, n)

    def distance(self, x):
        return _classification.SwigPyIterator_distance(self, x)

    def equal(self, x):
        return _classification.SwigPyIterator_equal(self, x)

    def copy(self):
        return _classification.SwigPyIterator_copy(self)

    def next(self):
        return _classification.SwigPyIterator_next(self)

    def __next__(self):
        return _classification.SwigPyIterator___next__(self)

    def previous(self):
        return _classification.SwigPyIterator_previous(self)

    def advance(self, n):
        return _classification.SwigPyIterator_advance(self, n)

    def __eq__(self, x):
        return _classification.SwigPyIterator___eq__(self, x)

    def __ne__(self, x):
        return _classification.SwigPyIterator___ne__(self, x)

    def __iadd__(self, n):
        return _classification.SwigPyIterator___iadd__(self, n)

    def __isub__(self, n):
        return _classification.SwigPyIterator___isub__(self, n)

    def __add__(self, n):
        return _classification.SwigPyIterator___add__(self, n)

    def __sub__(self, *args):
        return _classification.SwigPyIterator___sub__(self, *args)
    def __iter__(self):
        return self

# Register SwigPyIterator in _classification:
_classification.SwigPyIterator_swigregister(SwigPyIterator)
import openturns.base
import openturns.common
import openturns.typ
import openturns.statistics
import openturns.graph
import openturns.func
import openturns.geom
import openturns.iterative_statistics
import openturns.diff
import openturns.optim
import openturns.experiment
import openturns.solver
import openturns.algo
import openturns.model_copula
import openturns.dist_bundle1
import openturns.dist_bundle2
class MixtureClassifier(openturns.algo.ClassifierImplementation):
    r"""
    Particular classifier based on a mixture distribution.

    Parameters
    ----------
    mixtDist : :class:`~openturns.Mixture`
        A mixture distribution.

    See also
    --------
    Classifier, ExpertMixture

    Notes
    -----
    This implements a mixture classifier which is a particular classifier based on
    a mixture distribution:

    .. math::

        p( \vect{x} ) = \sum_{i=1}^N w_i p_i ( \vect{x} )

    The classifier proposes :math:`N` classes. The rule to assign a point 
    :math:`\vect{x}` to a class :math:`i` is defined as follows: 

    .. math::

        i = \argmax_k \log w_k p_k( \vect{x} )

    See useful methods :meth:`classify` and :meth:`grade`.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _classification.MixtureClassifier_getClassName(self)

    def __repr__(self):
        return _classification.MixtureClassifier___repr__(self)

    def getNumberOfClasses(self):
        r"""
        Accessor to the number of classes.

        Returns
        -------
        n_classes : int
            The number of classes
        """
        return _classification.MixtureClassifier_getNumberOfClasses(self)

    def classify(self, *args):
        r"""
        Classify points according to the classifier.

        **Available usages**:

            classify(*inputPoint*)

            classify(*inputSample*)

        Parameters
        ----------
        inputPoint : sequence of float
            A point to classify.
        inputSample : 2-d a sequence of float
            A set of point to classify.

        Notes
        -----
        The classifier proposes :math:`N` classes where :math:`N` is the dimension of
        the mixture distribution *mixtDist*. The rule to assign a point :math:`\vect{x}`
        to a class :math:`i` is defined as follows: 

        .. math::

            i = \argmax_k \log w_k p_k( \vect{x} )

        In the first usage, it returns an integer which corresponds to the class where
        *inputPoint* has been assigned.

        In the second usage, it returns an :class:`~openturns.Indices` that collects the
        class of each point of *inputSample*.
        """
        return _classification.MixtureClassifier_classify(self, *args)

    def grade(self, *args):
        r"""
        Grade points according to the classifier.

        **Available usages**:

            grade(*inputPoint, k*)

            grade(*inputSample, classList*)

        Parameters
        ----------
        inputPoint : sequence of float
            A point to grade.
        inputSample : 2-d a sequence of float
            A set of point to grade.
        k : int
            The class number.
        classList : sequence of integer
            The list of class number.

        Notes
        -----
        The grade of :math:`\vect{x}` with respect to the class *k* is
        :math:`log w_k p_k ( \vect{x} )`.

        In the first usage, it returns a real value that grades *inputPoint* with respect to
        the class *k*. The larger, the better.

        In the second usage, it returns a :class:`~openturns.Point` that collects the
        grades of the :math:`i^{th}` element of *inputSample* with respect to the
        :math:`i^{th}` class of *classList*.
        """
        return _classification.MixtureClassifier_grade(self, *args)

    def getMixture(self):
        r"""
        Accessor to the mixture distribution.

        Returns
        -------
        mixtDist : :class:`~openturns.Mixture`
            The mixture distribution.
        """
        return _classification.MixtureClassifier_getMixture(self)

    def setMixture(self, mixture):
        r"""
        Accessor to the mixture distribution.

        Parameters
        ----------
        mixtDist : :class:`~openturns.Mixture`
            The mixture distribution.
        """
        return _classification.MixtureClassifier_setMixture(self, mixture)

    def getDimension(self):
        r"""
        Accessor to the dimension.

        Returns
        -------
        dim : int
            The dimension of the classifier.
        """
        return _classification.MixtureClassifier_getDimension(self)

    def __init__(self, *args):
        _classification.MixtureClassifier_swiginit(self, _classification.new_MixtureClassifier(*args))
    __swig_destroy__ = _classification.delete_MixtureClassifier

# Register MixtureClassifier in _classification:
_classification.MixtureClassifier_swigregister(MixtureClassifier)
class MinimumVolumeClassifier(openturns.algo.ClassifierImplementation):
    r"""
    Classifier define by a minimum volume level set.

    Parameters
    ----------
    mixtDist : :class:`~openturns.Distribution`
        A distribution.
    alpha : sequence of float, unique and sorted
        Confidence levels

    See also
    --------
    Classifier

    Notes
    -----
    This implements a mixture classifier which is a particular classifier based on
    a minimum volume confidence domain.

    The minimum volume confidence domain :math:`A^*_{\alpha_i}` is the set of minimum volume and which measure is at least :math:`\alpha_i`. It is defined by:

    .. math::

        A^*_{\alpha_i} = \argmin_{A \in \Rset^d\, | \, \mu(A) \geq \alpha_i} \lambda(A)


    where :math:`\lambda` is the Lebesgue measure on :math:`\Rset^d`. Under some general conditions on :math:`\mu` (for example, no flat regions), the set  :math:`A^*_{\alpha_i}` is unique and realises the minimum: :math:`\mu(A^*_{\alpha_i}) = \alpha`. We show that :math:`A^*_{\alpha_i}` writes:

    .. math::

        A^*_{\alpha_i} = \{ \vect{x} \in \Rset^d \, | \, p(\vect{x}) \geq p_{\alpha_i} \}

    The classifier proposes 2 classes. The rule to assign a point :math:`\vect{x}`
    to a class *k* is defined as follows: :math:`k = \argmin_i \text{with} p(\vect{x}) > p_{\alpha_i}`

    The grade of :math:`\vect{x}` with respect to the class *k* is :math:`log p(\vect{x})`
    if :math:`\vect{x}` belongs to class *k* else :math:`- log p(\vect{x})`.


    Examples
    --------
    >>> import openturns as ot
    >>> R2 = ot.CorrelationMatrix(2)
    >>> dists = [ot.Normal([-1.0, 2.0], [1.0]*2, R2), ot.Normal([1.0, -2.0], [1.5]*2, R2)]
    >>> mixture = ot.Mixture(dists)
    >>> sample = mixture.getSample(1000)
    >>> distribution = ot.KernelSmoothing().build(sample)
    >>> algo = ot.MinimumVolumeClassifier(distribution, [0.8])
    >>> algo.classify(distribution.getMean())
    0
    >>> algo.classify([100.0]*2)
    1
    >>> sample = distribution.getSample(100)
    >>> graph = algo.drawSample(sample, [0, 1])
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _classification.MinimumVolumeClassifier_getClassName(self)

    def __repr__(self):
        return _classification.MinimumVolumeClassifier___repr__(self)

    def getNumberOfClasses(self):
        r"""
        Accessor to the number of classes.

        Returns
        -------
        n_classes : int
            The number of classes
        """
        return _classification.MinimumVolumeClassifier_getNumberOfClasses(self)

    def classify(self, *args):
        r"""
        Classify points according to the classifier.

        Parameters
        ----------
        input : sequence of float or 2-d a sequence of float
            A point or set of points to classify.

        Returns
        -------
        cls : int or :class:`~openturns.Indices`
            The class index of the input points, or indices of the classes of each points.
        """
        return _classification.MinimumVolumeClassifier_classify(self, *args)

    def getLevelSet(self, j=0):
        r"""
        LevelSet accessor.

        Parameters
        ----------
        i : int
            Index

        Returns
        -------
        levelset : :class:`~openturns.LevelSet`
            The levelset defining the domain.
        """
        return _classification.MinimumVolumeClassifier_getLevelSet(self, j)

    def grade(self, inP, outC):
        r"""
        Grade points according to the classifier.

        Parameters
        ----------
        inputPoint : sequence of float or 2-d a sequence of float
            A point or set of points to grade.
        k : int or sequence of int
            The class index, or class indices.

        Returns
        -------
        grade : float or :class:`~openturns.Point`
            Grade or list of grades of each input point with respect to each class index
        """
        return _classification.MinimumVolumeClassifier_grade(self, inP, outC)

    def getDistribution(self):
        r"""
        Accessor to the distribution.

        Returns
        -------
        dist : :class:`~openturns.Distribution`
            The distribution.
        """
        return _classification.MinimumVolumeClassifier_getDistribution(self)

    def getThreshold(self):
        r"""
        Accessor to the threshold.

        Returns
        -------
        threshold : :class:`~openturns.Point`
            The values :math:`p_{\alpha_i}` of the density function defining the frontier of the domain.
        """
        return _classification.MinimumVolumeClassifier_getThreshold(self)

    def getDimension(self):
        r"""
        Accessor to the dimension.

        Returns
        -------
        dim : int
            The dimension of the classifier.
        """
        return _classification.MinimumVolumeClassifier_getDimension(self)

    def drawContour(self, alpha):
        r"""
        Draw distribution contours.

        Parameters
        ----------
        alpha : sequence of float
            Confidence levels

        Returns
        -------
        graph : :class:`~openturns.Graph`
            The value of the density function defining the frontier of the domain.
        """
        return _classification.MinimumVolumeClassifier_drawContour(self, alpha)

    def drawSample(self, sample, classes):
        r"""
        Draw classified sample.

        Parameters
        ----------
        sample : :class:`~openturns.Sample`
            A sample to classifiy.
        classes : sequence of int
            Classes to select

        Returns
        -------
        graph : :class:`~openturns.Graph`
            The value of the density function defining the frontier of the domain.
        """
        return _classification.MinimumVolumeClassifier_drawSample(self, sample, classes)

    def drawContourAndSample(self, alpha, sample, classes):
        r"""
        Draw distribution contour and classified sample.

        Parameters
        ----------
        alpha : sequence of float
            Confidence levels
        sample : :class:`~openturns.Sample`
            A sample to classifiy.
        classes : sequence of int
            Classes to select

        Returns
        -------
        graph : :class:`~openturns.Graph`
            The value of the density function defining the frontier of the domain.
        """
        return _classification.MinimumVolumeClassifier_drawContourAndSample(self, alpha, sample, classes)

    def __init__(self, *args):
        _classification.MinimumVolumeClassifier_swiginit(self, _classification.new_MinimumVolumeClassifier(*args))
    __swig_destroy__ = _classification.delete_MinimumVolumeClassifier

# Register MinimumVolumeClassifier in _classification:
_classification.MinimumVolumeClassifier_swigregister(MinimumVolumeClassifier)

