// OptimizationAlgorithm docstrings are defined in OptimizationAlgorithmImplementation_doc.i.in

%feature("docstring") OT::OptimizationAlgorithm
OT_OptimizationAlgorithm_doc
%feature("docstring") OT::OptimizationAlgorithm::getMaximumAbsoluteError
OT_OptimizationAlgorithm_getMaximumAbsoluteError_doc
%feature("docstring") OT::OptimizationAlgorithm::getMaximumConstraintError
OT_OptimizationAlgorithm_getMaximumConstraintError_doc
%feature("docstring") OT::OptimizationAlgorithm::getMaximumIterationNumber
OT_OptimizationAlgorithm_getMaximumIterationNumber_doc
%feature("docstring") OT::OptimizationAlgorithm::getMaximumCallsNumber
OT_OptimizationAlgorithm_getMaximumCallsNumber_doc
%feature("docstring") OT::OptimizationAlgorithm::getMaximumRelativeError
OT_OptimizationAlgorithm_getMaximumRelativeError_doc
%feature("docstring") OT::OptimizationAlgorithm::getMaximumResidualError
OT_OptimizationAlgorithm_getMaximumResidualError_doc
%feature("docstring") OT::OptimizationAlgorithm::getProblem
OT_OptimizationAlgorithm_getProblem_doc
%feature("docstring") OT::OptimizationAlgorithm::getResult
OT_OptimizationAlgorithm_getResult_doc
%feature("docstring") OT::OptimizationAlgorithm::getStartingPoint
OT_OptimizationAlgorithm_getStartingPoint_doc
%feature("docstring") OT::OptimizationAlgorithm::run
OT_OptimizationAlgorithm_run_doc
%feature("docstring") OT::OptimizationAlgorithm::setMaximumAbsoluteError
OT_OptimizationAlgorithm_setMaximumAbsoluteError_doc
%feature("docstring") OT::OptimizationAlgorithm::setMaximumConstraintError
OT_OptimizationAlgorithm_setMaximumConstraintError_doc
%feature("docstring") OT::OptimizationAlgorithm::setMaximumIterationNumber
OT_OptimizationAlgorithm_setMaximumIterationNumber_doc
%feature("docstring") OT::OptimizationAlgorithm::setMaximumCallsNumber
OT_OptimizationAlgorithm_setMaximumCallsNumber_doc
%feature("docstring") OT::OptimizationAlgorithm::setMaximumRelativeError
OT_OptimizationAlgorithm_setMaximumRelativeError_doc
%feature("docstring") OT::OptimizationAlgorithm::setMaximumResidualError
OT_OptimizationAlgorithm_setMaximumResidualError_doc
%feature("docstring") OT::OptimizationAlgorithm::setMaximumTimeDuration
OT_OptimizationAlgorithm_setMaximumTimeDuration_doc
%feature("docstring") OT::OptimizationAlgorithm::getMaximumTimeDuration
OT_OptimizationAlgorithm_getMaximumTimeDuration_doc
%feature("docstring") OT::OptimizationAlgorithm::setProblem
OT_OptimizationAlgorithm_setProblem_doc
%feature("docstring") OT::OptimizationAlgorithm::setResult
OT_OptimizationAlgorithm_setResult_doc
%feature("docstring") OT::OptimizationAlgorithm::setStartingPoint
OT_OptimizationAlgorithm_setStartingPoint_doc
%feature("docstring") OT::OptimizationAlgorithm::setProgressCallback
OT_OptimizationAlgorithm_setProgressCallback_doc
%feature("docstring") OT::OptimizationAlgorithm::setStopCallback
OT_OptimizationAlgorithm_setStopCallback_doc
%feature("docstring") OT::OptimizationAlgorithm::setCheckStatus
OT_OptimizationAlgorithm_setCheckStatus_doc
%feature("docstring") OT::OptimizationAlgorithm::getCheckStatus
OT_OptimizationAlgorithm_getCheckStatus_doc

// ---------------------------------------------------------------------

%feature("docstring") OT::OptimizationAlgorithm::Build
"Instantiate an optimization algorithm from name or problem.

Parameters
----------
problem : :class:`~openturns.OptimizationProblem`
    Problem to solve."

// ---------------------------------------------------------------------

%feature("docstring") OT::OptimizationAlgorithm::GetByName
"Instantiate an optimization algorithm from its name.

Parameters
----------
name : str
    Name of the algorithm.
    For example `TNC`, `Cobyla` or one of the :class:`~openturns.NLopt` solver names."

// ---------------------------------------------------------------------

%feature("docstring") OT::OptimizationAlgorithm::GetAlgorithmNames
"Get the list of available solver names.

Parameters
----------
problem : :class:`~openturns.OptimizationProblem`, optional
    Problem to solve.

Returns
-------
names : :class:`~openturns.Description`
    List of available solver names."
