%feature("docstring") OT::MaximumEntropyOrderStatisticsCopula
"MaximumEntropyOrderStatisticsCopula copula.

Parameters
----------
coll : sequence of :class:`~openturns.Distribution`
    The margins, with range verifying :math:`a_i \\leq a_{i+1}` and :math:`b_i \\leq b_{i+1}`.
    
    Default collection is [Unif(-1.0, 0.5), Unif(-0.5, 1.0)].

Notes
-----
Its probability density function is defined as:

.. math::

    f_U(u) = \\prod\\limits_{k=2}^d \\frac{\\exp\\left(-\\int_{\\partial_{k-1}^{-1}(u_{k-1})}^{\\partial_k^{-1}(u_k)} \\phi_k(s)\\di{s}\\right)}{\\partial_{k-1}(\\partial_k^{-1}(u_k))-u_k} \\mathbf{1}_{F_1^{-1}(u_1) \\leq \\dots \\leq F_d^{-1}(u_d)}

    \\text{with } \\partial_k(t) = F_k(G^{-1}(t)) \\text{ and } G(t) = \\frac{1}{t} \\sum\\limits_{k=1}^d F_k(t)

This class is implemented as a :class:`~openturns.SklarCopula` of the underlying :class:`~openturns.MaximumEntropyOrderStatisticsDistribution`. See the documentation of these classes for the numerical details.

Examples
--------
Create a distribution:

>>> import openturns as ot
>>> coll = [ot.Uniform(-1.0, 1.0), ot.LogUniform(1.0, 1.2), ot.Triangular(3.0, 4.0, 5.0)]
>>> copulaOrderStat = ot.MaximumEntropyOrderStatisticsCopula(coll)

Draw a sample:

>>> sample = copulaOrderStat.getSample(5)"

// ---------------------------------------------------------------------

%feature("docstring") OT::MaximumEntropyOrderStatisticsCopula::getDistributionCollection
"Accessor to the distribution's margins collection.

Returns
-------
coll : sequence of :class:`~openturns.Distribution`
    The marginals."

// ---------------------------------------------------------------------

%feature("docstring") OT::MaximumEntropyOrderStatisticsCopula::setDistributionCollection
"Accessor to the distribution's collection.

Parameters
----------
coll : sequence of :class:`~openturns.Distribution`
    The margins."

// ---------------------------------------------------------------------

