%feature("docstring") OT::BipartiteGraph
"Bipartite red/black graph.

Parameters
----------
sequence : sequence of :class:`~openturns.Indices`
    Cliques of the red nodes.

Notes
-----
A bipartite graph is an undirected graph in which the nodes can be colored in two colors such that no edge has its two ends with the same colors. Here we force the :math:`n` red nodes to be numbered in consecutive order from 0 to :math:`n-1` and for each red node we give the list of black nodes that are the other end of the edges starting from this red node.

Examples
--------
>>> import openturns as ot

Create a bipartite graph:

>>> graph = ot.BipartiteGraph([[1, 3], [2, 0], [5, 4]])
>>> graph
[[1,3],[2,0],[5,4]]

Use some functionalities:

>>> graph[1] = [3, 4]
>>> graph
[[1,3],[3,4],[5,4]]"

// ---------------------------------------------------------------------

%feature("docstring") OT::BipartiteGraph::getBlackNodes
"Accessor to the graph black nodes.

Returns
-------
black : sequence of int, :class:`~openturns.Indices`"

// ---------------------------------------------------------------------

%feature("docstring") OT::BipartiteGraph::getRedNodes
"Accessor to the graph red nodes.

Returns
-------
red : sequence of int, :class:`~openturns.Indices`"

// ---------------------------------------------------------------------

%feature("docstring") OT::BipartiteGraph::draw
"Draw the graph.

Returns
-------
graph : a :class:`~openturns.Graph`
    View of the bipartite graph as a set of red nodes linked to black nodes."
