%feature("docstring") OT::ApproximationAlgorithmImplementationFactory
"Approximation algorithm factory base class.

Notes
-----
It represents a generic class (virtual) for different factories like
:class:`~openturns.PenalizedLeastSquaresAlgorithmFactory` or
:class:`~openturns.LeastSquaresMetaModelSelectionFactory`

This class is not usable because it operates only within the class
:class:`~openturns.FunctionalChaosAlgorithm`.

See also
--------
PenalizedLeastSquaresAlgorithmFactory, LeastSquaresMetaModelSelectionFactory"

// ---------------------------------------------------------------------

%feature("docstring") OT::ApproximationAlgorithmImplementationFactory::involvesModelSelection
"Get the model selection flag.

A model selection method can be used to select the coefficients
of the decomposition which enable to best predict the output.
Model selection leads to a sparse functional chaos expansion.

Returns
-------
involvesModelSelection : bool
    True if the method involves a model selection method."

// ---------------------------------------------------------------------

%feature("docstring") OT::ApproximationAlgorithmImplementationFactory::build
"Build the approximation.

Parameters
----------
x : 2-d sequence of float
    The input random observations :math:`\\left\\{\\vect{X}^{(1)}, ..., \\vect{X}^{(n)}\\right\\}` 
    where :math:`\\vect{X}=(X_1, \\dots, X_{n_X})^T` is the input of the physical
    model, :math:`n_X` is the input dimension and :math:`n` is the sample size.
y : 2-d sequence of float
    The output random observations :math:`\\left\\{\\vect{Y}^{(1)}, ..., \\vect{Y}^{(n)}\\right\\}` 
    where :math:`\\vect{Y}=(Y_1, \\dots, Y_{n_Y})^T` is the output of the physical
    model, :math:`n_Y` is the output dimension and :math:`n` is the sample size.
weight : sequence of float
    Weights associated to the input sample points
    such that the corresponding weighted experiment is a good approximation of
    :math:`\\mu`, where :math:`\\mu` is the distribution of the standard
    random vector :math:`\\vect{Z}` associated with the physical input random
    vector :math:`\\vect{X}`. If unspecified, all weights are equal to
    :math:`\\frac{1}{n}`, where :math:`n` is the size of the
    sample.
psi : sequence of :class:`~openturns.Function`
    The functional basis.
indices : sequence of int
    Indices in the basis.

Returns
-------
algorithm: :class:`~openturns.ApproximationAlgorithm`
    The estimation algorithm."

// ---------------------------------------------------------------------
