# Copyright 2023 The Emscripten Authors.  All rights reserved.
# Emscripten is available under two separate licenses, the MIT license and the
# University of Illinois/NCSA Open Source License.  Both these licenses can be
# found in the LICENSE file.
#
# Entry point for running python scripts on Windows systems via PowerShell.
#
# Automatically generated by `create_entry_points.py`; DO NOT EDIT.
#
# To make modifications to this file, edit `tools\run_python.ps1` and then run
# `tools\maint\create_entry_points.py`

$ErrorActionPreference = 'Stop'

$launcher = $env:EMSDK_PYTHON
$launcherArgs = @()
if (!$launcher) {
  # Use the global Python launcher that manages all Python installations.
  $launcher = Get-Command py.exe
  # ...but ask for Python 3
  $launcherArgs += '-3'
}

# Ignore PYTHON* environment variables.
$launcherArgs += '-E'
# -E will not ignore _PYTHON_SYSCONFIGDATA_NAME an internal
# of cpython used in cross compilation via setup.py, so remove it explicitly.
Remove-Item -ErrorAction Ignore Env:\_PYTHON_SYSCONFIGDATA_NAME

$pythonScript = "$PSScriptRoot/tools/emsymbolizer.py"

& $launcher $launcherArgs $pythonScript $MyInvocation.UnboundArguments
