// C++/WinRT v2.0.250303.1

// SPDX-License-Identifier: MIT OR Apache-2.0
// SPDX-FileCopyrightText: Copyright (c) Microsoft Corporation
//
// Generated using .winmd files from https://github.com/microsoft/windows-rs
//

#pragma once
#ifndef WINRT_Windows_Networking_ServiceDiscovery_Dnssd_H
#define WINRT_Windows_Networking_ServiceDiscovery_Dnssd_H
#include "winrt/base.h"
static_assert(winrt::check_version(CPPWINRT_VERSION, "2.0.250303.1"), "Mismatched C++/WinRT headers.");
#define CPPWINRT_VERSION "2.0.250303.1"
#include "winrt/Windows.Networking.h"
#include "winrt/impl/Windows.Foundation.2.h"
#include "winrt/impl/Windows.Foundation.Collections.2.h"
#include "winrt/impl/Windows.Networking.2.h"
#include "winrt/impl/Windows.Networking.Connectivity.2.h"
#include "winrt/impl/Windows.Networking.Sockets.2.h"
#include "winrt/impl/Windows.Networking.ServiceDiscovery.Dnssd.2.h"
namespace winrt::impl
{
    template <typename D> auto consume_Windows_Networking_ServiceDiscovery_Dnssd_IDnssdRegistrationResult<D>::Status() const
    {
        winrt::Windows::Networking::ServiceDiscovery::Dnssd::DnssdRegistrationStatus value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Networking::ServiceDiscovery::Dnssd::IDnssdRegistrationResult>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Networking::ServiceDiscovery::Dnssd::IDnssdRegistrationResult, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::ServiceDiscovery::Dnssd::IDnssdRegistrationResult>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Status(reinterpret_cast<int32_t*>(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::ServiceDiscovery::Dnssd::IDnssdRegistrationResult>**)this;
            check_hresult(_winrt_abi_type->get_Status(reinterpret_cast<int32_t*>(&value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Networking_ServiceDiscovery_Dnssd_IDnssdRegistrationResult<D>::IPAddress() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Networking::ServiceDiscovery::Dnssd::IDnssdRegistrationResult>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Networking::ServiceDiscovery::Dnssd::IDnssdRegistrationResult, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::ServiceDiscovery::Dnssd::IDnssdRegistrationResult>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IPAddress(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::ServiceDiscovery::Dnssd::IDnssdRegistrationResult>**)this;
            check_hresult(_winrt_abi_type->get_IPAddress(&value));
        }
        return winrt::Windows::Networking::HostName{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Networking_ServiceDiscovery_Dnssd_IDnssdRegistrationResult<D>::HasInstanceNameChanged() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Networking::ServiceDiscovery::Dnssd::IDnssdRegistrationResult>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Networking::ServiceDiscovery::Dnssd::IDnssdRegistrationResult, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::ServiceDiscovery::Dnssd::IDnssdRegistrationResult>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_HasInstanceNameChanged(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::ServiceDiscovery::Dnssd::IDnssdRegistrationResult>**)this;
            check_hresult(_winrt_abi_type->get_HasInstanceNameChanged(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Networking_ServiceDiscovery_Dnssd_IDnssdServiceInstance<D>::DnssdServiceInstanceName() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Networking::ServiceDiscovery::Dnssd::IDnssdServiceInstance>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Networking::ServiceDiscovery::Dnssd::IDnssdServiceInstance, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::ServiceDiscovery::Dnssd::IDnssdServiceInstance>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_DnssdServiceInstanceName(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::ServiceDiscovery::Dnssd::IDnssdServiceInstance>**)this;
            check_hresult(_winrt_abi_type->get_DnssdServiceInstanceName(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Networking_ServiceDiscovery_Dnssd_IDnssdServiceInstance<D>::DnssdServiceInstanceName(param::hstring const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Networking::ServiceDiscovery::Dnssd::IDnssdServiceInstance>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Networking::ServiceDiscovery::Dnssd::IDnssdServiceInstance, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::ServiceDiscovery::Dnssd::IDnssdServiceInstance>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_DnssdServiceInstanceName(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::ServiceDiscovery::Dnssd::IDnssdServiceInstance>**)this;
            check_hresult(_winrt_abi_type->put_DnssdServiceInstanceName(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_Networking_ServiceDiscovery_Dnssd_IDnssdServiceInstance<D>::HostName() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Networking::ServiceDiscovery::Dnssd::IDnssdServiceInstance>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Networking::ServiceDiscovery::Dnssd::IDnssdServiceInstance, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::ServiceDiscovery::Dnssd::IDnssdServiceInstance>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_HostName(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::ServiceDiscovery::Dnssd::IDnssdServiceInstance>**)this;
            check_hresult(_winrt_abi_type->get_HostName(&value));
        }
        return winrt::Windows::Networking::HostName{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Networking_ServiceDiscovery_Dnssd_IDnssdServiceInstance<D>::HostName(winrt::Windows::Networking::HostName const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Networking::ServiceDiscovery::Dnssd::IDnssdServiceInstance>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Networking::ServiceDiscovery::Dnssd::IDnssdServiceInstance, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::ServiceDiscovery::Dnssd::IDnssdServiceInstance>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_HostName(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::ServiceDiscovery::Dnssd::IDnssdServiceInstance>**)this;
            check_hresult(_winrt_abi_type->put_HostName(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_Networking_ServiceDiscovery_Dnssd_IDnssdServiceInstance<D>::Port() const
    {
        uint16_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Networking::ServiceDiscovery::Dnssd::IDnssdServiceInstance>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Networking::ServiceDiscovery::Dnssd::IDnssdServiceInstance, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::ServiceDiscovery::Dnssd::IDnssdServiceInstance>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Port(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::ServiceDiscovery::Dnssd::IDnssdServiceInstance>**)this;
            check_hresult(_winrt_abi_type->get_Port(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Networking_ServiceDiscovery_Dnssd_IDnssdServiceInstance<D>::Port(uint16_t value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Networking::ServiceDiscovery::Dnssd::IDnssdServiceInstance>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Networking::ServiceDiscovery::Dnssd::IDnssdServiceInstance, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::ServiceDiscovery::Dnssd::IDnssdServiceInstance>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Port(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::ServiceDiscovery::Dnssd::IDnssdServiceInstance>**)this;
            check_hresult(_winrt_abi_type->put_Port(value));
        }
    }
    template <typename D> auto consume_Windows_Networking_ServiceDiscovery_Dnssd_IDnssdServiceInstance<D>::Priority() const
    {
        uint16_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Networking::ServiceDiscovery::Dnssd::IDnssdServiceInstance>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Networking::ServiceDiscovery::Dnssd::IDnssdServiceInstance, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::ServiceDiscovery::Dnssd::IDnssdServiceInstance>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Priority(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::ServiceDiscovery::Dnssd::IDnssdServiceInstance>**)this;
            check_hresult(_winrt_abi_type->get_Priority(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Networking_ServiceDiscovery_Dnssd_IDnssdServiceInstance<D>::Priority(uint16_t value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Networking::ServiceDiscovery::Dnssd::IDnssdServiceInstance>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Networking::ServiceDiscovery::Dnssd::IDnssdServiceInstance, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::ServiceDiscovery::Dnssd::IDnssdServiceInstance>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Priority(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::ServiceDiscovery::Dnssd::IDnssdServiceInstance>**)this;
            check_hresult(_winrt_abi_type->put_Priority(value));
        }
    }
    template <typename D> auto consume_Windows_Networking_ServiceDiscovery_Dnssd_IDnssdServiceInstance<D>::Weight() const
    {
        uint16_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Networking::ServiceDiscovery::Dnssd::IDnssdServiceInstance>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Networking::ServiceDiscovery::Dnssd::IDnssdServiceInstance, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::ServiceDiscovery::Dnssd::IDnssdServiceInstance>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Weight(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::ServiceDiscovery::Dnssd::IDnssdServiceInstance>**)this;
            check_hresult(_winrt_abi_type->get_Weight(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Networking_ServiceDiscovery_Dnssd_IDnssdServiceInstance<D>::Weight(uint16_t value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Networking::ServiceDiscovery::Dnssd::IDnssdServiceInstance>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Networking::ServiceDiscovery::Dnssd::IDnssdServiceInstance, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::ServiceDiscovery::Dnssd::IDnssdServiceInstance>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Weight(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::ServiceDiscovery::Dnssd::IDnssdServiceInstance>**)this;
            check_hresult(_winrt_abi_type->put_Weight(value));
        }
    }
    template <typename D> auto consume_Windows_Networking_ServiceDiscovery_Dnssd_IDnssdServiceInstance<D>::TextAttributes() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Networking::ServiceDiscovery::Dnssd::IDnssdServiceInstance>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Networking::ServiceDiscovery::Dnssd::IDnssdServiceInstance, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::ServiceDiscovery::Dnssd::IDnssdServiceInstance>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_TextAttributes(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::ServiceDiscovery::Dnssd::IDnssdServiceInstance>**)this;
            check_hresult(_winrt_abi_type->get_TextAttributes(&value));
        }
        return winrt::Windows::Foundation::Collections::IMap<hstring, hstring>{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Networking_ServiceDiscovery_Dnssd_IDnssdServiceInstance<D>::RegisterStreamSocketListenerAsync(winrt::Windows::Networking::Sockets::StreamSocketListener const& socket) const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Networking::ServiceDiscovery::Dnssd::IDnssdServiceInstance>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Networking::ServiceDiscovery::Dnssd::IDnssdServiceInstance, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::ServiceDiscovery::Dnssd::IDnssdServiceInstance>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->RegisterStreamSocketListenerAsync1(*(void**)(&socket), &result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::ServiceDiscovery::Dnssd::IDnssdServiceInstance>**)this;
            check_hresult(_winrt_abi_type->RegisterStreamSocketListenerAsync1(*(void**)(&socket), &result));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Networking::ServiceDiscovery::Dnssd::DnssdRegistrationResult>{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Networking_ServiceDiscovery_Dnssd_IDnssdServiceInstance<D>::RegisterStreamSocketListenerAsync(winrt::Windows::Networking::Sockets::StreamSocketListener const& socket, winrt::Windows::Networking::Connectivity::NetworkAdapter const& adapter) const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Networking::ServiceDiscovery::Dnssd::IDnssdServiceInstance>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Networking::ServiceDiscovery::Dnssd::IDnssdServiceInstance, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::ServiceDiscovery::Dnssd::IDnssdServiceInstance>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->RegisterStreamSocketListenerAsync2(*(void**)(&socket), *(void**)(&adapter), &result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::ServiceDiscovery::Dnssd::IDnssdServiceInstance>**)this;
            check_hresult(_winrt_abi_type->RegisterStreamSocketListenerAsync2(*(void**)(&socket), *(void**)(&adapter), &result));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Networking::ServiceDiscovery::Dnssd::DnssdRegistrationResult>{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Networking_ServiceDiscovery_Dnssd_IDnssdServiceInstance<D>::RegisterDatagramSocketAsync(winrt::Windows::Networking::Sockets::DatagramSocket const& socket) const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Networking::ServiceDiscovery::Dnssd::IDnssdServiceInstance>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Networking::ServiceDiscovery::Dnssd::IDnssdServiceInstance, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::ServiceDiscovery::Dnssd::IDnssdServiceInstance>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->RegisterDatagramSocketAsync1(*(void**)(&socket), &result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::ServiceDiscovery::Dnssd::IDnssdServiceInstance>**)this;
            check_hresult(_winrt_abi_type->RegisterDatagramSocketAsync1(*(void**)(&socket), &result));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Networking::ServiceDiscovery::Dnssd::DnssdRegistrationResult>{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Networking_ServiceDiscovery_Dnssd_IDnssdServiceInstance<D>::RegisterDatagramSocketAsync(winrt::Windows::Networking::Sockets::DatagramSocket const& socket, winrt::Windows::Networking::Connectivity::NetworkAdapter const& adapter) const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Networking::ServiceDiscovery::Dnssd::IDnssdServiceInstance>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Networking::ServiceDiscovery::Dnssd::IDnssdServiceInstance, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::ServiceDiscovery::Dnssd::IDnssdServiceInstance>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->RegisterDatagramSocketAsync2(*(void**)(&socket), *(void**)(&adapter), &result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::ServiceDiscovery::Dnssd::IDnssdServiceInstance>**)this;
            check_hresult(_winrt_abi_type->RegisterDatagramSocketAsync2(*(void**)(&socket), *(void**)(&adapter), &result));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Networking::ServiceDiscovery::Dnssd::DnssdRegistrationResult>{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Networking_ServiceDiscovery_Dnssd_IDnssdServiceInstanceFactory<D>::Create(param::hstring const& dnssdServiceInstanceName, winrt::Windows::Networking::HostName const& hostName, uint16_t port) const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Networking::ServiceDiscovery::Dnssd::IDnssdServiceInstanceFactory>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Networking::ServiceDiscovery::Dnssd::IDnssdServiceInstanceFactory, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::ServiceDiscovery::Dnssd::IDnssdServiceInstanceFactory>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->Create(*(void**)(&dnssdServiceInstanceName), *(void**)(&hostName), port, &result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::ServiceDiscovery::Dnssd::IDnssdServiceInstanceFactory>**)this;
            check_hresult(_winrt_abi_type->Create(*(void**)(&dnssdServiceInstanceName), *(void**)(&hostName), port, &result));
        }
        return winrt::Windows::Networking::ServiceDiscovery::Dnssd::DnssdServiceInstance{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Networking_ServiceDiscovery_Dnssd_IDnssdServiceWatcher<D>::Added(winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::Networking::ServiceDiscovery::Dnssd::DnssdServiceWatcher, winrt::Windows::Networking::ServiceDiscovery::Dnssd::DnssdServiceInstance> const& handler) const
    {
        winrt::event_token token{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Networking::ServiceDiscovery::Dnssd::IDnssdServiceWatcher>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Networking::ServiceDiscovery::Dnssd::IDnssdServiceWatcher, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::ServiceDiscovery::Dnssd::IDnssdServiceWatcher>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->add_Added(*(void**)(&handler), put_abi(token)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::ServiceDiscovery::Dnssd::IDnssdServiceWatcher>**)this;
            check_hresult(_winrt_abi_type->add_Added(*(void**)(&handler), put_abi(token)));
        }
        return token;
    }
    template <typename D> auto consume_Windows_Networking_ServiceDiscovery_Dnssd_IDnssdServiceWatcher<D>::Added(auto_revoke_t, winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::Networking::ServiceDiscovery::Dnssd::DnssdServiceWatcher, winrt::Windows::Networking::ServiceDiscovery::Dnssd::DnssdServiceInstance> const& handler) const
    {
        return impl::make_event_revoker<D, Added_revoker>(this, Added(handler));
    }
    template <typename D> auto consume_Windows_Networking_ServiceDiscovery_Dnssd_IDnssdServiceWatcher<D>::Added(winrt::event_token const& token) const noexcept
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Networking::ServiceDiscovery::Dnssd::IDnssdServiceWatcher>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Networking::ServiceDiscovery::Dnssd::IDnssdServiceWatcher, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::ServiceDiscovery::Dnssd::IDnssdServiceWatcher>**)&_winrt_casted_result;
            _winrt_abi_type->remove_Added(impl::bind_in(token));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::ServiceDiscovery::Dnssd::IDnssdServiceWatcher>**)this;
            _winrt_abi_type->remove_Added(impl::bind_in(token));
        }
    }
    template <typename D> auto consume_Windows_Networking_ServiceDiscovery_Dnssd_IDnssdServiceWatcher<D>::EnumerationCompleted(winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::Networking::ServiceDiscovery::Dnssd::DnssdServiceWatcher, winrt::Windows::Foundation::IInspectable> const& handler) const
    {
        winrt::event_token token{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Networking::ServiceDiscovery::Dnssd::IDnssdServiceWatcher>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Networking::ServiceDiscovery::Dnssd::IDnssdServiceWatcher, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::ServiceDiscovery::Dnssd::IDnssdServiceWatcher>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->add_EnumerationCompleted(*(void**)(&handler), put_abi(token)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::ServiceDiscovery::Dnssd::IDnssdServiceWatcher>**)this;
            check_hresult(_winrt_abi_type->add_EnumerationCompleted(*(void**)(&handler), put_abi(token)));
        }
        return token;
    }
    template <typename D> auto consume_Windows_Networking_ServiceDiscovery_Dnssd_IDnssdServiceWatcher<D>::EnumerationCompleted(auto_revoke_t, winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::Networking::ServiceDiscovery::Dnssd::DnssdServiceWatcher, winrt::Windows::Foundation::IInspectable> const& handler) const
    {
        return impl::make_event_revoker<D, EnumerationCompleted_revoker>(this, EnumerationCompleted(handler));
    }
    template <typename D> auto consume_Windows_Networking_ServiceDiscovery_Dnssd_IDnssdServiceWatcher<D>::EnumerationCompleted(winrt::event_token const& token) const noexcept
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Networking::ServiceDiscovery::Dnssd::IDnssdServiceWatcher>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Networking::ServiceDiscovery::Dnssd::IDnssdServiceWatcher, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::ServiceDiscovery::Dnssd::IDnssdServiceWatcher>**)&_winrt_casted_result;
            _winrt_abi_type->remove_EnumerationCompleted(impl::bind_in(token));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::ServiceDiscovery::Dnssd::IDnssdServiceWatcher>**)this;
            _winrt_abi_type->remove_EnumerationCompleted(impl::bind_in(token));
        }
    }
    template <typename D> auto consume_Windows_Networking_ServiceDiscovery_Dnssd_IDnssdServiceWatcher<D>::Stopped(winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::Networking::ServiceDiscovery::Dnssd::DnssdServiceWatcher, winrt::Windows::Foundation::IInspectable> const& handler) const
    {
        winrt::event_token token{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Networking::ServiceDiscovery::Dnssd::IDnssdServiceWatcher>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Networking::ServiceDiscovery::Dnssd::IDnssdServiceWatcher, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::ServiceDiscovery::Dnssd::IDnssdServiceWatcher>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->add_Stopped(*(void**)(&handler), put_abi(token)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::ServiceDiscovery::Dnssd::IDnssdServiceWatcher>**)this;
            check_hresult(_winrt_abi_type->add_Stopped(*(void**)(&handler), put_abi(token)));
        }
        return token;
    }
    template <typename D> auto consume_Windows_Networking_ServiceDiscovery_Dnssd_IDnssdServiceWatcher<D>::Stopped(auto_revoke_t, winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::Networking::ServiceDiscovery::Dnssd::DnssdServiceWatcher, winrt::Windows::Foundation::IInspectable> const& handler) const
    {
        return impl::make_event_revoker<D, Stopped_revoker>(this, Stopped(handler));
    }
    template <typename D> auto consume_Windows_Networking_ServiceDiscovery_Dnssd_IDnssdServiceWatcher<D>::Stopped(winrt::event_token const& token) const noexcept
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Networking::ServiceDiscovery::Dnssd::IDnssdServiceWatcher>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Networking::ServiceDiscovery::Dnssd::IDnssdServiceWatcher, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::ServiceDiscovery::Dnssd::IDnssdServiceWatcher>**)&_winrt_casted_result;
            _winrt_abi_type->remove_Stopped(impl::bind_in(token));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::ServiceDiscovery::Dnssd::IDnssdServiceWatcher>**)this;
            _winrt_abi_type->remove_Stopped(impl::bind_in(token));
        }
    }
    template <typename D> auto consume_Windows_Networking_ServiceDiscovery_Dnssd_IDnssdServiceWatcher<D>::Status() const
    {
        winrt::Windows::Networking::ServiceDiscovery::Dnssd::DnssdServiceWatcherStatus status{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Networking::ServiceDiscovery::Dnssd::IDnssdServiceWatcher>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Networking::ServiceDiscovery::Dnssd::IDnssdServiceWatcher, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::ServiceDiscovery::Dnssd::IDnssdServiceWatcher>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Status(reinterpret_cast<int32_t*>(&status)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::ServiceDiscovery::Dnssd::IDnssdServiceWatcher>**)this;
            check_hresult(_winrt_abi_type->get_Status(reinterpret_cast<int32_t*>(&status)));
        }
        return status;
    }
    template <typename D> auto consume_Windows_Networking_ServiceDiscovery_Dnssd_IDnssdServiceWatcher<D>::Start() const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Networking::ServiceDiscovery::Dnssd::IDnssdServiceWatcher>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Networking::ServiceDiscovery::Dnssd::IDnssdServiceWatcher, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::ServiceDiscovery::Dnssd::IDnssdServiceWatcher>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->Start());
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::ServiceDiscovery::Dnssd::IDnssdServiceWatcher>**)this;
            check_hresult(_winrt_abi_type->Start());
        }
    }
    template <typename D> auto consume_Windows_Networking_ServiceDiscovery_Dnssd_IDnssdServiceWatcher<D>::Stop() const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Networking::ServiceDiscovery::Dnssd::IDnssdServiceWatcher>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Networking::ServiceDiscovery::Dnssd::IDnssdServiceWatcher, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::ServiceDiscovery::Dnssd::IDnssdServiceWatcher>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->Stop());
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Networking::ServiceDiscovery::Dnssd::IDnssdServiceWatcher>**)this;
            check_hresult(_winrt_abi_type->Stop());
        }
    }
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Networking::ServiceDiscovery::Dnssd::IDnssdRegistrationResult> : produce_base<D, winrt::Windows::Networking::ServiceDiscovery::Dnssd::IDnssdRegistrationResult>
    {
        int32_t __stdcall get_Status(int32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Networking::ServiceDiscovery::Dnssd::DnssdRegistrationStatus>(this->shim().Status());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_IPAddress(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Networking::HostName>(this->shim().IPAddress());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_HasInstanceNameChanged(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().HasInstanceNameChanged());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Networking::ServiceDiscovery::Dnssd::IDnssdServiceInstance> : produce_base<D, winrt::Windows::Networking::ServiceDiscovery::Dnssd::IDnssdServiceInstance>
    {
        int32_t __stdcall get_DnssdServiceInstanceName(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().DnssdServiceInstanceName());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_DnssdServiceInstanceName(void* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().DnssdServiceInstanceName(*reinterpret_cast<hstring const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_HostName(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Networking::HostName>(this->shim().HostName());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_HostName(void* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().HostName(*reinterpret_cast<winrt::Windows::Networking::HostName const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Port(uint16_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint16_t>(this->shim().Port());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_Port(uint16_t value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Port(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Priority(uint16_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint16_t>(this->shim().Priority());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_Priority(uint16_t value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Priority(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Weight(uint16_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint16_t>(this->shim().Weight());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_Weight(uint16_t value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Weight(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_TextAttributes(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::Collections::IMap<hstring, hstring>>(this->shim().TextAttributes());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall RegisterStreamSocketListenerAsync1(void* socket, void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Networking::ServiceDiscovery::Dnssd::DnssdRegistrationResult>>(this->shim().RegisterStreamSocketListenerAsync(*reinterpret_cast<winrt::Windows::Networking::Sockets::StreamSocketListener const*>(&socket)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall RegisterStreamSocketListenerAsync2(void* socket, void* adapter, void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Networking::ServiceDiscovery::Dnssd::DnssdRegistrationResult>>(this->shim().RegisterStreamSocketListenerAsync(*reinterpret_cast<winrt::Windows::Networking::Sockets::StreamSocketListener const*>(&socket), *reinterpret_cast<winrt::Windows::Networking::Connectivity::NetworkAdapter const*>(&adapter)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall RegisterDatagramSocketAsync1(void* socket, void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Networking::ServiceDiscovery::Dnssd::DnssdRegistrationResult>>(this->shim().RegisterDatagramSocketAsync(*reinterpret_cast<winrt::Windows::Networking::Sockets::DatagramSocket const*>(&socket)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall RegisterDatagramSocketAsync2(void* socket, void* adapter, void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Networking::ServiceDiscovery::Dnssd::DnssdRegistrationResult>>(this->shim().RegisterDatagramSocketAsync(*reinterpret_cast<winrt::Windows::Networking::Sockets::DatagramSocket const*>(&socket), *reinterpret_cast<winrt::Windows::Networking::Connectivity::NetworkAdapter const*>(&adapter)));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Networking::ServiceDiscovery::Dnssd::IDnssdServiceInstanceFactory> : produce_base<D, winrt::Windows::Networking::ServiceDiscovery::Dnssd::IDnssdServiceInstanceFactory>
    {
        int32_t __stdcall Create(void* dnssdServiceInstanceName, void* hostName, uint16_t port, void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::Networking::ServiceDiscovery::Dnssd::DnssdServiceInstance>(this->shim().Create(*reinterpret_cast<hstring const*>(&dnssdServiceInstanceName), *reinterpret_cast<winrt::Windows::Networking::HostName const*>(&hostName), port));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Networking::ServiceDiscovery::Dnssd::IDnssdServiceWatcher> : produce_base<D, winrt::Windows::Networking::ServiceDiscovery::Dnssd::IDnssdServiceWatcher>
    {
        int32_t __stdcall add_Added(void* handler, winrt::event_token* token) noexcept final try
        {
            zero_abi<winrt::event_token>(token);
            typename D::abi_guard guard(this->shim());
            *token = detach_from<winrt::event_token>(this->shim().Added(*reinterpret_cast<winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::Networking::ServiceDiscovery::Dnssd::DnssdServiceWatcher, winrt::Windows::Networking::ServiceDiscovery::Dnssd::DnssdServiceInstance> const*>(&handler)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall remove_Added(winrt::event_token token) noexcept final
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Added(*reinterpret_cast<winrt::event_token const*>(&token));
            return 0;
        }
        int32_t __stdcall add_EnumerationCompleted(void* handler, winrt::event_token* token) noexcept final try
        {
            zero_abi<winrt::event_token>(token);
            typename D::abi_guard guard(this->shim());
            *token = detach_from<winrt::event_token>(this->shim().EnumerationCompleted(*reinterpret_cast<winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::Networking::ServiceDiscovery::Dnssd::DnssdServiceWatcher, winrt::Windows::Foundation::IInspectable> const*>(&handler)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall remove_EnumerationCompleted(winrt::event_token token) noexcept final
        {
            typename D::abi_guard guard(this->shim());
            this->shim().EnumerationCompleted(*reinterpret_cast<winrt::event_token const*>(&token));
            return 0;
        }
        int32_t __stdcall add_Stopped(void* handler, winrt::event_token* token) noexcept final try
        {
            zero_abi<winrt::event_token>(token);
            typename D::abi_guard guard(this->shim());
            *token = detach_from<winrt::event_token>(this->shim().Stopped(*reinterpret_cast<winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::Networking::ServiceDiscovery::Dnssd::DnssdServiceWatcher, winrt::Windows::Foundation::IInspectable> const*>(&handler)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall remove_Stopped(winrt::event_token token) noexcept final
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Stopped(*reinterpret_cast<winrt::event_token const*>(&token));
            return 0;
        }
        int32_t __stdcall get_Status(int32_t* status) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *status = detach_from<winrt::Windows::Networking::ServiceDiscovery::Dnssd::DnssdServiceWatcherStatus>(this->shim().Status());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall Start() noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Start();
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall Stop() noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Stop();
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
}
WINRT_EXPORT namespace winrt::Windows::Networking::ServiceDiscovery::Dnssd
{
    inline DnssdRegistrationResult::DnssdRegistrationResult() :
        DnssdRegistrationResult(impl::call_factory_cast<DnssdRegistrationResult(*)(winrt::Windows::Foundation::IActivationFactory const&), DnssdRegistrationResult>([](winrt::Windows::Foundation::IActivationFactory const& f) { return f.template ActivateInstance<DnssdRegistrationResult>(); }))
    {
    }
    inline DnssdServiceInstance::DnssdServiceInstance(param::hstring const& dnssdServiceInstanceName, winrt::Windows::Networking::HostName const& hostName, uint16_t port) :
        DnssdServiceInstance(impl::call_factory<DnssdServiceInstance, IDnssdServiceInstanceFactory>([&](IDnssdServiceInstanceFactory const& f) { return f.Create(dnssdServiceInstanceName, hostName, port); }))
    {
    }
}
namespace std
{
#ifndef WINRT_LEAN_AND_MEAN
    template<> struct hash<winrt::Windows::Networking::ServiceDiscovery::Dnssd::IDnssdRegistrationResult> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Networking::ServiceDiscovery::Dnssd::IDnssdServiceInstance> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Networking::ServiceDiscovery::Dnssd::IDnssdServiceInstanceFactory> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Networking::ServiceDiscovery::Dnssd::IDnssdServiceWatcher> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Networking::ServiceDiscovery::Dnssd::DnssdRegistrationResult> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Networking::ServiceDiscovery::Dnssd::DnssdServiceInstance> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Networking::ServiceDiscovery::Dnssd::DnssdServiceInstanceCollection> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Networking::ServiceDiscovery::Dnssd::DnssdServiceWatcher> : winrt::impl::hash_base {};
#endif
#ifdef __cpp_lib_format
    template<> struct formatter<winrt::Windows::Networking::ServiceDiscovery::Dnssd::DnssdRegistrationResult, wchar_t> : formatter<winrt::Windows::Foundation::IStringable, wchar_t> {};
    template<> struct formatter<winrt::Windows::Networking::ServiceDiscovery::Dnssd::DnssdServiceInstance, wchar_t> : formatter<winrt::Windows::Foundation::IStringable, wchar_t> {};
#endif
}
#endif
