// C++/WinRT v2.0.250303.1

// SPDX-License-Identifier: MIT OR Apache-2.0
// SPDX-FileCopyrightText: Copyright (c) Microsoft Corporation
//
// Generated using .winmd files from https://github.com/microsoft/windows-rs
//

#pragma once
#ifndef WINRT_Windows_Devices_PointOfService_H
#define WINRT_Windows_Devices_PointOfService_H
#include "winrt/base.h"
static_assert(winrt::check_version(CPPWINRT_VERSION, "2.0.250303.1"), "Mismatched C++/WinRT headers.");
#define CPPWINRT_VERSION "2.0.250303.1"
#include "winrt/Windows.Devices.h"
#include "winrt/impl/Windows.Foundation.2.h"
#include "winrt/impl/Windows.Foundation.Collections.2.h"
#include "winrt/impl/Windows.Graphics.Imaging.2.h"
#include "winrt/impl/Windows.Storage.2.h"
#include "winrt/impl/Windows.Storage.Streams.2.h"
#include "winrt/impl/Windows.Devices.PointOfService.2.h"
namespace winrt::impl
{
    template <typename D> auto consume_Windows_Devices_PointOfService_IBarcodeScanner<D>::DeviceId() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IBarcodeScanner>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IBarcodeScanner, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeScanner>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_DeviceId(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeScanner>**)this;
            check_hresult(_winrt_abi_type->get_DeviceId(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IBarcodeScanner<D>::Capabilities() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IBarcodeScanner>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IBarcodeScanner, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeScanner>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Capabilities(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeScanner>**)this;
            check_hresult(_winrt_abi_type->get_Capabilities(&value));
        }
        return winrt::Windows::Devices::PointOfService::BarcodeScannerCapabilities{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IBarcodeScanner<D>::ClaimScannerAsync() const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IBarcodeScanner>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IBarcodeScanner, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeScanner>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->ClaimScannerAsync(&operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeScanner>**)this;
            check_hresult(_winrt_abi_type->ClaimScannerAsync(&operation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Devices::PointOfService::ClaimedBarcodeScanner>{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IBarcodeScanner<D>::CheckHealthAsync(winrt::Windows::Devices::PointOfService::UnifiedPosHealthCheckLevel const& level) const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IBarcodeScanner>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IBarcodeScanner, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeScanner>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CheckHealthAsync(static_cast<int32_t>(level), &operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeScanner>**)this;
            check_hresult(_winrt_abi_type->CheckHealthAsync(static_cast<int32_t>(level), &operation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<hstring>{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IBarcodeScanner<D>::GetSupportedSymbologiesAsync() const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IBarcodeScanner>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IBarcodeScanner, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeScanner>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetSupportedSymbologiesAsync(&operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeScanner>**)this;
            check_hresult(_winrt_abi_type->GetSupportedSymbologiesAsync(&operation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Foundation::Collections::IVectorView<uint32_t>>{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IBarcodeScanner<D>::IsSymbologySupportedAsync(uint32_t barcodeSymbology) const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IBarcodeScanner>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IBarcodeScanner, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeScanner>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->IsSymbologySupportedAsync(barcodeSymbology, &operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeScanner>**)this;
            check_hresult(_winrt_abi_type->IsSymbologySupportedAsync(barcodeSymbology, &operation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<bool>{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IBarcodeScanner<D>::RetrieveStatisticsAsync(param::async_iterable<hstring> const& statisticsCategories) const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IBarcodeScanner>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IBarcodeScanner, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeScanner>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->RetrieveStatisticsAsync(*(void**)(&statisticsCategories), &operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeScanner>**)this;
            check_hresult(_winrt_abi_type->RetrieveStatisticsAsync(*(void**)(&statisticsCategories), &operation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Storage::Streams::IBuffer>{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IBarcodeScanner<D>::GetSupportedProfiles() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IBarcodeScanner>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IBarcodeScanner, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeScanner>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetSupportedProfiles(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeScanner>**)this;
            check_hresult(_winrt_abi_type->GetSupportedProfiles(&value));
        }
        return winrt::Windows::Foundation::Collections::IVectorView<hstring>{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IBarcodeScanner<D>::IsProfileSupported(param::hstring const& profile) const
    {
        bool isSupported{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IBarcodeScanner>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IBarcodeScanner, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeScanner>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->IsProfileSupported(*(void**)(&profile), &isSupported));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeScanner>**)this;
            check_hresult(_winrt_abi_type->IsProfileSupported(*(void**)(&profile), &isSupported));
        }
        return isSupported;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IBarcodeScanner<D>::StatusUpdated(winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::Devices::PointOfService::BarcodeScanner, winrt::Windows::Devices::PointOfService::BarcodeScannerStatusUpdatedEventArgs> const& handler) const
    {
        winrt::event_token token{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IBarcodeScanner>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IBarcodeScanner, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeScanner>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->add_StatusUpdated(*(void**)(&handler), put_abi(token)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeScanner>**)this;
            check_hresult(_winrt_abi_type->add_StatusUpdated(*(void**)(&handler), put_abi(token)));
        }
        return token;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IBarcodeScanner<D>::StatusUpdated(auto_revoke_t, winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::Devices::PointOfService::BarcodeScanner, winrt::Windows::Devices::PointOfService::BarcodeScannerStatusUpdatedEventArgs> const& handler) const
    {
        return impl::make_event_revoker<D, StatusUpdated_revoker>(this, StatusUpdated(handler));
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IBarcodeScanner<D>::StatusUpdated(winrt::event_token const& token) const noexcept
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IBarcodeScanner>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IBarcodeScanner, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeScanner>**)&_winrt_casted_result;
            _winrt_abi_type->remove_StatusUpdated(impl::bind_in(token));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeScanner>**)this;
            _winrt_abi_type->remove_StatusUpdated(impl::bind_in(token));
        }
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IBarcodeScanner2<D>::VideoDeviceId() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IBarcodeScanner2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IBarcodeScanner2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeScanner2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_VideoDeviceId(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeScanner2>**)this;
            check_hresult(_winrt_abi_type->get_VideoDeviceId(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IBarcodeScannerCapabilities<D>::PowerReportingType() const
    {
        winrt::Windows::Devices::PointOfService::UnifiedPosPowerReportingType value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IBarcodeScannerCapabilities>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IBarcodeScannerCapabilities, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeScannerCapabilities>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_PowerReportingType(reinterpret_cast<int32_t*>(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeScannerCapabilities>**)this;
            check_hresult(_winrt_abi_type->get_PowerReportingType(reinterpret_cast<int32_t*>(&value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IBarcodeScannerCapabilities<D>::IsStatisticsReportingSupported() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IBarcodeScannerCapabilities>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IBarcodeScannerCapabilities, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeScannerCapabilities>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsStatisticsReportingSupported(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeScannerCapabilities>**)this;
            check_hresult(_winrt_abi_type->get_IsStatisticsReportingSupported(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IBarcodeScannerCapabilities<D>::IsStatisticsUpdatingSupported() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IBarcodeScannerCapabilities>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IBarcodeScannerCapabilities, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeScannerCapabilities>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsStatisticsUpdatingSupported(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeScannerCapabilities>**)this;
            check_hresult(_winrt_abi_type->get_IsStatisticsUpdatingSupported(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IBarcodeScannerCapabilities<D>::IsImagePreviewSupported() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IBarcodeScannerCapabilities>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IBarcodeScannerCapabilities, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeScannerCapabilities>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsImagePreviewSupported(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeScannerCapabilities>**)this;
            check_hresult(_winrt_abi_type->get_IsImagePreviewSupported(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IBarcodeScannerCapabilities1<D>::IsSoftwareTriggerSupported() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IBarcodeScannerCapabilities1>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IBarcodeScannerCapabilities1, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeScannerCapabilities1>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsSoftwareTriggerSupported(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeScannerCapabilities1>**)this;
            check_hresult(_winrt_abi_type->get_IsSoftwareTriggerSupported(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IBarcodeScannerCapabilities2<D>::IsVideoPreviewSupported() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IBarcodeScannerCapabilities2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IBarcodeScannerCapabilities2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeScannerCapabilities2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsVideoPreviewSupported(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeScannerCapabilities2>**)this;
            check_hresult(_winrt_abi_type->get_IsVideoPreviewSupported(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IBarcodeScannerDataReceivedEventArgs<D>::Report() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IBarcodeScannerDataReceivedEventArgs>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IBarcodeScannerDataReceivedEventArgs, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeScannerDataReceivedEventArgs>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Report(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeScannerDataReceivedEventArgs>**)this;
            check_hresult(_winrt_abi_type->get_Report(&value));
        }
        return winrt::Windows::Devices::PointOfService::BarcodeScannerReport{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IBarcodeScannerErrorOccurredEventArgs<D>::PartialInputData() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IBarcodeScannerErrorOccurredEventArgs>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IBarcodeScannerErrorOccurredEventArgs, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeScannerErrorOccurredEventArgs>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_PartialInputData(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeScannerErrorOccurredEventArgs>**)this;
            check_hresult(_winrt_abi_type->get_PartialInputData(&value));
        }
        return winrt::Windows::Devices::PointOfService::BarcodeScannerReport{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IBarcodeScannerErrorOccurredEventArgs<D>::IsRetriable() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IBarcodeScannerErrorOccurredEventArgs>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IBarcodeScannerErrorOccurredEventArgs, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeScannerErrorOccurredEventArgs>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsRetriable(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeScannerErrorOccurredEventArgs>**)this;
            check_hresult(_winrt_abi_type->get_IsRetriable(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IBarcodeScannerErrorOccurredEventArgs<D>::ErrorData() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IBarcodeScannerErrorOccurredEventArgs>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IBarcodeScannerErrorOccurredEventArgs, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeScannerErrorOccurredEventArgs>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ErrorData(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeScannerErrorOccurredEventArgs>**)this;
            check_hresult(_winrt_abi_type->get_ErrorData(&value));
        }
        return winrt::Windows::Devices::PointOfService::UnifiedPosErrorData{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IBarcodeScannerImagePreviewReceivedEventArgs<D>::Preview() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IBarcodeScannerImagePreviewReceivedEventArgs>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IBarcodeScannerImagePreviewReceivedEventArgs, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeScannerImagePreviewReceivedEventArgs>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Preview(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeScannerImagePreviewReceivedEventArgs>**)this;
            check_hresult(_winrt_abi_type->get_Preview(&value));
        }
        return winrt::Windows::Storage::Streams::IRandomAccessStreamWithContentType{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IBarcodeScannerReport<D>::ScanDataType() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IBarcodeScannerReport>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IBarcodeScannerReport, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeScannerReport>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ScanDataType(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeScannerReport>**)this;
            check_hresult(_winrt_abi_type->get_ScanDataType(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IBarcodeScannerReport<D>::ScanData() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IBarcodeScannerReport>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IBarcodeScannerReport, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeScannerReport>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ScanData(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeScannerReport>**)this;
            check_hresult(_winrt_abi_type->get_ScanData(&value));
        }
        return winrt::Windows::Storage::Streams::IBuffer{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IBarcodeScannerReport<D>::ScanDataLabel() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IBarcodeScannerReport>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IBarcodeScannerReport, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeScannerReport>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ScanDataLabel(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeScannerReport>**)this;
            check_hresult(_winrt_abi_type->get_ScanDataLabel(&value));
        }
        return winrt::Windows::Storage::Streams::IBuffer{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IBarcodeScannerReportFactory<D>::CreateInstance(uint32_t scanDataType, winrt::Windows::Storage::Streams::IBuffer const& scanData, winrt::Windows::Storage::Streams::IBuffer const& scanDataLabel) const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IBarcodeScannerReportFactory>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IBarcodeScannerReportFactory, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeScannerReportFactory>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateInstance(scanDataType, *(void**)(&scanData), *(void**)(&scanDataLabel), &result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeScannerReportFactory>**)this;
            check_hresult(_winrt_abi_type->CreateInstance(scanDataType, *(void**)(&scanData), *(void**)(&scanDataLabel), &result));
        }
        return winrt::Windows::Devices::PointOfService::BarcodeScannerReport{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IBarcodeScannerStatics<D>::GetDefaultAsync() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IBarcodeScannerStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IBarcodeScannerStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeScannerStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetDefaultAsync(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeScannerStatics>**)this;
            check_hresult(_winrt_abi_type->GetDefaultAsync(&result));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Devices::PointOfService::BarcodeScanner>{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IBarcodeScannerStatics<D>::FromIdAsync(param::hstring const& deviceId) const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IBarcodeScannerStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IBarcodeScannerStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeScannerStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->FromIdAsync(*(void**)(&deviceId), &result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeScannerStatics>**)this;
            check_hresult(_winrt_abi_type->FromIdAsync(*(void**)(&deviceId), &result));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Devices::PointOfService::BarcodeScanner>{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IBarcodeScannerStatics<D>::GetDeviceSelector() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IBarcodeScannerStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IBarcodeScannerStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeScannerStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetDeviceSelector(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeScannerStatics>**)this;
            check_hresult(_winrt_abi_type->GetDeviceSelector(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IBarcodeScannerStatics2<D>::GetDeviceSelector(winrt::Windows::Devices::PointOfService::PosConnectionTypes const& connectionTypes) const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IBarcodeScannerStatics2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IBarcodeScannerStatics2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeScannerStatics2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetDeviceSelectorWithConnectionTypes(static_cast<uint32_t>(connectionTypes), &value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeScannerStatics2>**)this;
            check_hresult(_winrt_abi_type->GetDeviceSelectorWithConnectionTypes(static_cast<uint32_t>(connectionTypes), &value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IBarcodeScannerStatusUpdatedEventArgs<D>::Status() const
    {
        winrt::Windows::Devices::PointOfService::BarcodeScannerStatus value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IBarcodeScannerStatusUpdatedEventArgs>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IBarcodeScannerStatusUpdatedEventArgs, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeScannerStatusUpdatedEventArgs>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Status(reinterpret_cast<int32_t*>(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeScannerStatusUpdatedEventArgs>**)this;
            check_hresult(_winrt_abi_type->get_Status(reinterpret_cast<int32_t*>(&value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IBarcodeScannerStatusUpdatedEventArgs<D>::ExtendedStatus() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IBarcodeScannerStatusUpdatedEventArgs>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IBarcodeScannerStatusUpdatedEventArgs, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeScannerStatusUpdatedEventArgs>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ExtendedStatus(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeScannerStatusUpdatedEventArgs>**)this;
            check_hresult(_winrt_abi_type->get_ExtendedStatus(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IBarcodeSymbologiesStatics<D>::Unknown() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Unknown(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)this;
            check_hresult(_winrt_abi_type->get_Unknown(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IBarcodeSymbologiesStatics<D>::Ean8() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Ean8(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)this;
            check_hresult(_winrt_abi_type->get_Ean8(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IBarcodeSymbologiesStatics<D>::Ean8Add2() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Ean8Add2(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)this;
            check_hresult(_winrt_abi_type->get_Ean8Add2(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IBarcodeSymbologiesStatics<D>::Ean8Add5() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Ean8Add5(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)this;
            check_hresult(_winrt_abi_type->get_Ean8Add5(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IBarcodeSymbologiesStatics<D>::Eanv() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Eanv(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)this;
            check_hresult(_winrt_abi_type->get_Eanv(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IBarcodeSymbologiesStatics<D>::EanvAdd2() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_EanvAdd2(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)this;
            check_hresult(_winrt_abi_type->get_EanvAdd2(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IBarcodeSymbologiesStatics<D>::EanvAdd5() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_EanvAdd5(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)this;
            check_hresult(_winrt_abi_type->get_EanvAdd5(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IBarcodeSymbologiesStatics<D>::Ean13() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Ean13(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)this;
            check_hresult(_winrt_abi_type->get_Ean13(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IBarcodeSymbologiesStatics<D>::Ean13Add2() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Ean13Add2(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)this;
            check_hresult(_winrt_abi_type->get_Ean13Add2(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IBarcodeSymbologiesStatics<D>::Ean13Add5() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Ean13Add5(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)this;
            check_hresult(_winrt_abi_type->get_Ean13Add5(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IBarcodeSymbologiesStatics<D>::Isbn() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Isbn(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)this;
            check_hresult(_winrt_abi_type->get_Isbn(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IBarcodeSymbologiesStatics<D>::IsbnAdd5() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsbnAdd5(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)this;
            check_hresult(_winrt_abi_type->get_IsbnAdd5(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IBarcodeSymbologiesStatics<D>::Ismn() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Ismn(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)this;
            check_hresult(_winrt_abi_type->get_Ismn(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IBarcodeSymbologiesStatics<D>::IsmnAdd2() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsmnAdd2(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)this;
            check_hresult(_winrt_abi_type->get_IsmnAdd2(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IBarcodeSymbologiesStatics<D>::IsmnAdd5() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsmnAdd5(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)this;
            check_hresult(_winrt_abi_type->get_IsmnAdd5(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IBarcodeSymbologiesStatics<D>::Issn() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Issn(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)this;
            check_hresult(_winrt_abi_type->get_Issn(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IBarcodeSymbologiesStatics<D>::IssnAdd2() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IssnAdd2(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)this;
            check_hresult(_winrt_abi_type->get_IssnAdd2(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IBarcodeSymbologiesStatics<D>::IssnAdd5() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IssnAdd5(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)this;
            check_hresult(_winrt_abi_type->get_IssnAdd5(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IBarcodeSymbologiesStatics<D>::Ean99() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Ean99(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)this;
            check_hresult(_winrt_abi_type->get_Ean99(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IBarcodeSymbologiesStatics<D>::Ean99Add2() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Ean99Add2(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)this;
            check_hresult(_winrt_abi_type->get_Ean99Add2(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IBarcodeSymbologiesStatics<D>::Ean99Add5() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Ean99Add5(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)this;
            check_hresult(_winrt_abi_type->get_Ean99Add5(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IBarcodeSymbologiesStatics<D>::Upca() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Upca(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)this;
            check_hresult(_winrt_abi_type->get_Upca(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IBarcodeSymbologiesStatics<D>::UpcaAdd2() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_UpcaAdd2(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)this;
            check_hresult(_winrt_abi_type->get_UpcaAdd2(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IBarcodeSymbologiesStatics<D>::UpcaAdd5() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_UpcaAdd5(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)this;
            check_hresult(_winrt_abi_type->get_UpcaAdd5(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IBarcodeSymbologiesStatics<D>::Upce() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Upce(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)this;
            check_hresult(_winrt_abi_type->get_Upce(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IBarcodeSymbologiesStatics<D>::UpceAdd2() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_UpceAdd2(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)this;
            check_hresult(_winrt_abi_type->get_UpceAdd2(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IBarcodeSymbologiesStatics<D>::UpceAdd5() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_UpceAdd5(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)this;
            check_hresult(_winrt_abi_type->get_UpceAdd5(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IBarcodeSymbologiesStatics<D>::UpcCoupon() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_UpcCoupon(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)this;
            check_hresult(_winrt_abi_type->get_UpcCoupon(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IBarcodeSymbologiesStatics<D>::TfStd() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_TfStd(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)this;
            check_hresult(_winrt_abi_type->get_TfStd(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IBarcodeSymbologiesStatics<D>::TfDis() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_TfDis(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)this;
            check_hresult(_winrt_abi_type->get_TfDis(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IBarcodeSymbologiesStatics<D>::TfInt() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_TfInt(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)this;
            check_hresult(_winrt_abi_type->get_TfInt(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IBarcodeSymbologiesStatics<D>::TfInd() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_TfInd(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)this;
            check_hresult(_winrt_abi_type->get_TfInd(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IBarcodeSymbologiesStatics<D>::TfMat() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_TfMat(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)this;
            check_hresult(_winrt_abi_type->get_TfMat(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IBarcodeSymbologiesStatics<D>::TfIata() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_TfIata(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)this;
            check_hresult(_winrt_abi_type->get_TfIata(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IBarcodeSymbologiesStatics<D>::Gs1DatabarType1() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Gs1DatabarType1(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)this;
            check_hresult(_winrt_abi_type->get_Gs1DatabarType1(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IBarcodeSymbologiesStatics<D>::Gs1DatabarType2() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Gs1DatabarType2(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)this;
            check_hresult(_winrt_abi_type->get_Gs1DatabarType2(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IBarcodeSymbologiesStatics<D>::Gs1DatabarType3() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Gs1DatabarType3(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)this;
            check_hresult(_winrt_abi_type->get_Gs1DatabarType3(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IBarcodeSymbologiesStatics<D>::Code39() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Code39(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)this;
            check_hresult(_winrt_abi_type->get_Code39(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IBarcodeSymbologiesStatics<D>::Code39Ex() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Code39Ex(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)this;
            check_hresult(_winrt_abi_type->get_Code39Ex(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IBarcodeSymbologiesStatics<D>::Trioptic39() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Trioptic39(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)this;
            check_hresult(_winrt_abi_type->get_Trioptic39(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IBarcodeSymbologiesStatics<D>::Code32() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Code32(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)this;
            check_hresult(_winrt_abi_type->get_Code32(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IBarcodeSymbologiesStatics<D>::Pzn() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Pzn(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)this;
            check_hresult(_winrt_abi_type->get_Pzn(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IBarcodeSymbologiesStatics<D>::Code93() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Code93(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)this;
            check_hresult(_winrt_abi_type->get_Code93(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IBarcodeSymbologiesStatics<D>::Code93Ex() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Code93Ex(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)this;
            check_hresult(_winrt_abi_type->get_Code93Ex(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IBarcodeSymbologiesStatics<D>::Code128() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Code128(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)this;
            check_hresult(_winrt_abi_type->get_Code128(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IBarcodeSymbologiesStatics<D>::Gs1128() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Gs1128(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)this;
            check_hresult(_winrt_abi_type->get_Gs1128(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IBarcodeSymbologiesStatics<D>::Gs1128Coupon() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Gs1128Coupon(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)this;
            check_hresult(_winrt_abi_type->get_Gs1128Coupon(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IBarcodeSymbologiesStatics<D>::UccEan128() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_UccEan128(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)this;
            check_hresult(_winrt_abi_type->get_UccEan128(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IBarcodeSymbologiesStatics<D>::Sisac() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Sisac(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)this;
            check_hresult(_winrt_abi_type->get_Sisac(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IBarcodeSymbologiesStatics<D>::Isbt() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Isbt(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)this;
            check_hresult(_winrt_abi_type->get_Isbt(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IBarcodeSymbologiesStatics<D>::Codabar() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Codabar(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)this;
            check_hresult(_winrt_abi_type->get_Codabar(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IBarcodeSymbologiesStatics<D>::Code11() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Code11(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)this;
            check_hresult(_winrt_abi_type->get_Code11(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IBarcodeSymbologiesStatics<D>::Msi() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Msi(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)this;
            check_hresult(_winrt_abi_type->get_Msi(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IBarcodeSymbologiesStatics<D>::Plessey() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Plessey(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)this;
            check_hresult(_winrt_abi_type->get_Plessey(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IBarcodeSymbologiesStatics<D>::Telepen() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Telepen(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)this;
            check_hresult(_winrt_abi_type->get_Telepen(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IBarcodeSymbologiesStatics<D>::Code16k() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Code16k(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)this;
            check_hresult(_winrt_abi_type->get_Code16k(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IBarcodeSymbologiesStatics<D>::CodablockA() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_CodablockA(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)this;
            check_hresult(_winrt_abi_type->get_CodablockA(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IBarcodeSymbologiesStatics<D>::CodablockF() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_CodablockF(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)this;
            check_hresult(_winrt_abi_type->get_CodablockF(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IBarcodeSymbologiesStatics<D>::Codablock128() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Codablock128(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)this;
            check_hresult(_winrt_abi_type->get_Codablock128(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IBarcodeSymbologiesStatics<D>::Code49() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Code49(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)this;
            check_hresult(_winrt_abi_type->get_Code49(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IBarcodeSymbologiesStatics<D>::Aztec() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Aztec(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)this;
            check_hresult(_winrt_abi_type->get_Aztec(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IBarcodeSymbologiesStatics<D>::DataCode() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_DataCode(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)this;
            check_hresult(_winrt_abi_type->get_DataCode(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IBarcodeSymbologiesStatics<D>::DataMatrix() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_DataMatrix(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)this;
            check_hresult(_winrt_abi_type->get_DataMatrix(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IBarcodeSymbologiesStatics<D>::HanXin() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_HanXin(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)this;
            check_hresult(_winrt_abi_type->get_HanXin(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IBarcodeSymbologiesStatics<D>::Maxicode() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Maxicode(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)this;
            check_hresult(_winrt_abi_type->get_Maxicode(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IBarcodeSymbologiesStatics<D>::MicroPdf417() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_MicroPdf417(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)this;
            check_hresult(_winrt_abi_type->get_MicroPdf417(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IBarcodeSymbologiesStatics<D>::MicroQr() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_MicroQr(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)this;
            check_hresult(_winrt_abi_type->get_MicroQr(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IBarcodeSymbologiesStatics<D>::Pdf417() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Pdf417(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)this;
            check_hresult(_winrt_abi_type->get_Pdf417(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IBarcodeSymbologiesStatics<D>::Qr() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Qr(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)this;
            check_hresult(_winrt_abi_type->get_Qr(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IBarcodeSymbologiesStatics<D>::MsTag() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_MsTag(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)this;
            check_hresult(_winrt_abi_type->get_MsTag(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IBarcodeSymbologiesStatics<D>::Ccab() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Ccab(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)this;
            check_hresult(_winrt_abi_type->get_Ccab(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IBarcodeSymbologiesStatics<D>::Ccc() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Ccc(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)this;
            check_hresult(_winrt_abi_type->get_Ccc(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IBarcodeSymbologiesStatics<D>::Tlc39() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Tlc39(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)this;
            check_hresult(_winrt_abi_type->get_Tlc39(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IBarcodeSymbologiesStatics<D>::AusPost() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_AusPost(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)this;
            check_hresult(_winrt_abi_type->get_AusPost(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IBarcodeSymbologiesStatics<D>::CanPost() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_CanPost(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)this;
            check_hresult(_winrt_abi_type->get_CanPost(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IBarcodeSymbologiesStatics<D>::ChinaPost() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ChinaPost(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)this;
            check_hresult(_winrt_abi_type->get_ChinaPost(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IBarcodeSymbologiesStatics<D>::DutchKix() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_DutchKix(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)this;
            check_hresult(_winrt_abi_type->get_DutchKix(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IBarcodeSymbologiesStatics<D>::InfoMail() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_InfoMail(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)this;
            check_hresult(_winrt_abi_type->get_InfoMail(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IBarcodeSymbologiesStatics<D>::ItalianPost25() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ItalianPost25(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)this;
            check_hresult(_winrt_abi_type->get_ItalianPost25(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IBarcodeSymbologiesStatics<D>::ItalianPost39() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ItalianPost39(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)this;
            check_hresult(_winrt_abi_type->get_ItalianPost39(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IBarcodeSymbologiesStatics<D>::JapanPost() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_JapanPost(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)this;
            check_hresult(_winrt_abi_type->get_JapanPost(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IBarcodeSymbologiesStatics<D>::KoreanPost() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_KoreanPost(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)this;
            check_hresult(_winrt_abi_type->get_KoreanPost(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IBarcodeSymbologiesStatics<D>::SwedenPost() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_SwedenPost(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)this;
            check_hresult(_winrt_abi_type->get_SwedenPost(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IBarcodeSymbologiesStatics<D>::UkPost() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_UkPost(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)this;
            check_hresult(_winrt_abi_type->get_UkPost(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IBarcodeSymbologiesStatics<D>::UsIntelligent() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_UsIntelligent(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)this;
            check_hresult(_winrt_abi_type->get_UsIntelligent(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IBarcodeSymbologiesStatics<D>::UsIntelligentPkg() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_UsIntelligentPkg(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)this;
            check_hresult(_winrt_abi_type->get_UsIntelligentPkg(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IBarcodeSymbologiesStatics<D>::UsPlanet() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_UsPlanet(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)this;
            check_hresult(_winrt_abi_type->get_UsPlanet(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IBarcodeSymbologiesStatics<D>::UsPostNet() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_UsPostNet(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)this;
            check_hresult(_winrt_abi_type->get_UsPostNet(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IBarcodeSymbologiesStatics<D>::Us4StateFics() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Us4StateFics(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)this;
            check_hresult(_winrt_abi_type->get_Us4StateFics(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IBarcodeSymbologiesStatics<D>::OcrA() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_OcrA(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)this;
            check_hresult(_winrt_abi_type->get_OcrA(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IBarcodeSymbologiesStatics<D>::OcrB() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_OcrB(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)this;
            check_hresult(_winrt_abi_type->get_OcrB(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IBarcodeSymbologiesStatics<D>::Micr() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Micr(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)this;
            check_hresult(_winrt_abi_type->get_Micr(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IBarcodeSymbologiesStatics<D>::ExtendedBase() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ExtendedBase(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)this;
            check_hresult(_winrt_abi_type->get_ExtendedBase(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IBarcodeSymbologiesStatics<D>::GetName(uint32_t scanDataType) const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetName(scanDataType, &value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>**)this;
            check_hresult(_winrt_abi_type->GetName(scanDataType, &value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IBarcodeSymbologiesStatics2<D>::Gs1DWCode() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Gs1DWCode(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics2>**)this;
            check_hresult(_winrt_abi_type->get_Gs1DWCode(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IBarcodeSymbologyAttributes<D>::IsCheckDigitValidationEnabled() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IBarcodeSymbologyAttributes>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IBarcodeSymbologyAttributes, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologyAttributes>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsCheckDigitValidationEnabled(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologyAttributes>**)this;
            check_hresult(_winrt_abi_type->get_IsCheckDigitValidationEnabled(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IBarcodeSymbologyAttributes<D>::IsCheckDigitValidationEnabled(bool value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IBarcodeSymbologyAttributes>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IBarcodeSymbologyAttributes, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologyAttributes>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_IsCheckDigitValidationEnabled(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologyAttributes>**)this;
            check_hresult(_winrt_abi_type->put_IsCheckDigitValidationEnabled(value));
        }
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IBarcodeSymbologyAttributes<D>::IsCheckDigitValidationSupported() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IBarcodeSymbologyAttributes>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IBarcodeSymbologyAttributes, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologyAttributes>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsCheckDigitValidationSupported(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologyAttributes>**)this;
            check_hresult(_winrt_abi_type->get_IsCheckDigitValidationSupported(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IBarcodeSymbologyAttributes<D>::IsCheckDigitTransmissionEnabled() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IBarcodeSymbologyAttributes>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IBarcodeSymbologyAttributes, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologyAttributes>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsCheckDigitTransmissionEnabled(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologyAttributes>**)this;
            check_hresult(_winrt_abi_type->get_IsCheckDigitTransmissionEnabled(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IBarcodeSymbologyAttributes<D>::IsCheckDigitTransmissionEnabled(bool value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IBarcodeSymbologyAttributes>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IBarcodeSymbologyAttributes, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologyAttributes>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_IsCheckDigitTransmissionEnabled(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologyAttributes>**)this;
            check_hresult(_winrt_abi_type->put_IsCheckDigitTransmissionEnabled(value));
        }
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IBarcodeSymbologyAttributes<D>::IsCheckDigitTransmissionSupported() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IBarcodeSymbologyAttributes>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IBarcodeSymbologyAttributes, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologyAttributes>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsCheckDigitTransmissionSupported(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologyAttributes>**)this;
            check_hresult(_winrt_abi_type->get_IsCheckDigitTransmissionSupported(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IBarcodeSymbologyAttributes<D>::DecodeLength1() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IBarcodeSymbologyAttributes>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IBarcodeSymbologyAttributes, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologyAttributes>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_DecodeLength1(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologyAttributes>**)this;
            check_hresult(_winrt_abi_type->get_DecodeLength1(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IBarcodeSymbologyAttributes<D>::DecodeLength1(uint32_t value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IBarcodeSymbologyAttributes>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IBarcodeSymbologyAttributes, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologyAttributes>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_DecodeLength1(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologyAttributes>**)this;
            check_hresult(_winrt_abi_type->put_DecodeLength1(value));
        }
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IBarcodeSymbologyAttributes<D>::DecodeLength2() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IBarcodeSymbologyAttributes>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IBarcodeSymbologyAttributes, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologyAttributes>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_DecodeLength2(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologyAttributes>**)this;
            check_hresult(_winrt_abi_type->get_DecodeLength2(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IBarcodeSymbologyAttributes<D>::DecodeLength2(uint32_t value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IBarcodeSymbologyAttributes>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IBarcodeSymbologyAttributes, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologyAttributes>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_DecodeLength2(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologyAttributes>**)this;
            check_hresult(_winrt_abi_type->put_DecodeLength2(value));
        }
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IBarcodeSymbologyAttributes<D>::DecodeLengthKind() const
    {
        winrt::Windows::Devices::PointOfService::BarcodeSymbologyDecodeLengthKind value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IBarcodeSymbologyAttributes>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IBarcodeSymbologyAttributes, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologyAttributes>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_DecodeLengthKind(reinterpret_cast<int32_t*>(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologyAttributes>**)this;
            check_hresult(_winrt_abi_type->get_DecodeLengthKind(reinterpret_cast<int32_t*>(&value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IBarcodeSymbologyAttributes<D>::DecodeLengthKind(winrt::Windows::Devices::PointOfService::BarcodeSymbologyDecodeLengthKind const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IBarcodeSymbologyAttributes>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IBarcodeSymbologyAttributes, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologyAttributes>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_DecodeLengthKind(static_cast<int32_t>(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologyAttributes>**)this;
            check_hresult(_winrt_abi_type->put_DecodeLengthKind(static_cast<int32_t>(value)));
        }
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IBarcodeSymbologyAttributes<D>::IsDecodeLengthSupported() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IBarcodeSymbologyAttributes>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IBarcodeSymbologyAttributes, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologyAttributes>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsDecodeLengthSupported(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IBarcodeSymbologyAttributes>**)this;
            check_hresult(_winrt_abi_type->get_IsDecodeLengthSupported(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ICashDrawer<D>::DeviceId() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ICashDrawer>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ICashDrawer, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ICashDrawer>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_DeviceId(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ICashDrawer>**)this;
            check_hresult(_winrt_abi_type->get_DeviceId(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ICashDrawer<D>::Capabilities() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ICashDrawer>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ICashDrawer, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ICashDrawer>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Capabilities(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ICashDrawer>**)this;
            check_hresult(_winrt_abi_type->get_Capabilities(&value));
        }
        return winrt::Windows::Devices::PointOfService::CashDrawerCapabilities{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ICashDrawer<D>::Status() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ICashDrawer>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ICashDrawer, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ICashDrawer>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Status(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ICashDrawer>**)this;
            check_hresult(_winrt_abi_type->get_Status(&value));
        }
        return winrt::Windows::Devices::PointOfService::CashDrawerStatus{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ICashDrawer<D>::IsDrawerOpen() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ICashDrawer>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ICashDrawer, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ICashDrawer>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsDrawerOpen(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ICashDrawer>**)this;
            check_hresult(_winrt_abi_type->get_IsDrawerOpen(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ICashDrawer<D>::DrawerEventSource() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ICashDrawer>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ICashDrawer, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ICashDrawer>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_DrawerEventSource(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ICashDrawer>**)this;
            check_hresult(_winrt_abi_type->get_DrawerEventSource(&value));
        }
        return winrt::Windows::Devices::PointOfService::CashDrawerEventSource{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ICashDrawer<D>::ClaimDrawerAsync() const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ICashDrawer>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ICashDrawer, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ICashDrawer>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->ClaimDrawerAsync(&operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ICashDrawer>**)this;
            check_hresult(_winrt_abi_type->ClaimDrawerAsync(&operation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Devices::PointOfService::ClaimedCashDrawer>{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ICashDrawer<D>::CheckHealthAsync(winrt::Windows::Devices::PointOfService::UnifiedPosHealthCheckLevel const& level) const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ICashDrawer>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ICashDrawer, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ICashDrawer>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CheckHealthAsync(static_cast<int32_t>(level), &operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ICashDrawer>**)this;
            check_hresult(_winrt_abi_type->CheckHealthAsync(static_cast<int32_t>(level), &operation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<hstring>{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ICashDrawer<D>::GetStatisticsAsync(param::async_iterable<hstring> const& statisticsCategories) const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ICashDrawer>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ICashDrawer, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ICashDrawer>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetStatisticsAsync(*(void**)(&statisticsCategories), &operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ICashDrawer>**)this;
            check_hresult(_winrt_abi_type->GetStatisticsAsync(*(void**)(&statisticsCategories), &operation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<hstring>{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ICashDrawer<D>::StatusUpdated(winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::Devices::PointOfService::CashDrawer, winrt::Windows::Devices::PointOfService::CashDrawerStatusUpdatedEventArgs> const& handler) const
    {
        winrt::event_token token{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ICashDrawer>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ICashDrawer, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ICashDrawer>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->add_StatusUpdated(*(void**)(&handler), put_abi(token)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ICashDrawer>**)this;
            check_hresult(_winrt_abi_type->add_StatusUpdated(*(void**)(&handler), put_abi(token)));
        }
        return token;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ICashDrawer<D>::StatusUpdated(auto_revoke_t, winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::Devices::PointOfService::CashDrawer, winrt::Windows::Devices::PointOfService::CashDrawerStatusUpdatedEventArgs> const& handler) const
    {
        return impl::make_event_revoker<D, StatusUpdated_revoker>(this, StatusUpdated(handler));
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ICashDrawer<D>::StatusUpdated(winrt::event_token const& token) const noexcept
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ICashDrawer>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ICashDrawer, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ICashDrawer>**)&_winrt_casted_result;
            _winrt_abi_type->remove_StatusUpdated(impl::bind_in(token));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ICashDrawer>**)this;
            _winrt_abi_type->remove_StatusUpdated(impl::bind_in(token));
        }
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ICashDrawerCapabilities<D>::PowerReportingType() const
    {
        winrt::Windows::Devices::PointOfService::UnifiedPosPowerReportingType value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ICashDrawerCapabilities>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ICashDrawerCapabilities, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ICashDrawerCapabilities>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_PowerReportingType(reinterpret_cast<int32_t*>(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ICashDrawerCapabilities>**)this;
            check_hresult(_winrt_abi_type->get_PowerReportingType(reinterpret_cast<int32_t*>(&value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ICashDrawerCapabilities<D>::IsStatisticsReportingSupported() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ICashDrawerCapabilities>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ICashDrawerCapabilities, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ICashDrawerCapabilities>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsStatisticsReportingSupported(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ICashDrawerCapabilities>**)this;
            check_hresult(_winrt_abi_type->get_IsStatisticsReportingSupported(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ICashDrawerCapabilities<D>::IsStatisticsUpdatingSupported() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ICashDrawerCapabilities>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ICashDrawerCapabilities, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ICashDrawerCapabilities>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsStatisticsUpdatingSupported(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ICashDrawerCapabilities>**)this;
            check_hresult(_winrt_abi_type->get_IsStatisticsUpdatingSupported(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ICashDrawerCapabilities<D>::IsStatusReportingSupported() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ICashDrawerCapabilities>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ICashDrawerCapabilities, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ICashDrawerCapabilities>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsStatusReportingSupported(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ICashDrawerCapabilities>**)this;
            check_hresult(_winrt_abi_type->get_IsStatusReportingSupported(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ICashDrawerCapabilities<D>::IsStatusMultiDrawerDetectSupported() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ICashDrawerCapabilities>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ICashDrawerCapabilities, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ICashDrawerCapabilities>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsStatusMultiDrawerDetectSupported(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ICashDrawerCapabilities>**)this;
            check_hresult(_winrt_abi_type->get_IsStatusMultiDrawerDetectSupported(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ICashDrawerCapabilities<D>::IsDrawerOpenSensorAvailable() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ICashDrawerCapabilities>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ICashDrawerCapabilities, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ICashDrawerCapabilities>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsDrawerOpenSensorAvailable(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ICashDrawerCapabilities>**)this;
            check_hresult(_winrt_abi_type->get_IsDrawerOpenSensorAvailable(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ICashDrawerCloseAlarm<D>::AlarmTimeout(winrt::Windows::Foundation::TimeSpan const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ICashDrawerCloseAlarm>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ICashDrawerCloseAlarm, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ICashDrawerCloseAlarm>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_AlarmTimeout(impl::bind_in(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ICashDrawerCloseAlarm>**)this;
            check_hresult(_winrt_abi_type->put_AlarmTimeout(impl::bind_in(value)));
        }
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ICashDrawerCloseAlarm<D>::AlarmTimeout() const
    {
        winrt::Windows::Foundation::TimeSpan value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ICashDrawerCloseAlarm>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ICashDrawerCloseAlarm, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ICashDrawerCloseAlarm>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_AlarmTimeout(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ICashDrawerCloseAlarm>**)this;
            check_hresult(_winrt_abi_type->get_AlarmTimeout(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ICashDrawerCloseAlarm<D>::BeepFrequency(uint32_t value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ICashDrawerCloseAlarm>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ICashDrawerCloseAlarm, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ICashDrawerCloseAlarm>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_BeepFrequency(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ICashDrawerCloseAlarm>**)this;
            check_hresult(_winrt_abi_type->put_BeepFrequency(value));
        }
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ICashDrawerCloseAlarm<D>::BeepFrequency() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ICashDrawerCloseAlarm>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ICashDrawerCloseAlarm, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ICashDrawerCloseAlarm>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_BeepFrequency(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ICashDrawerCloseAlarm>**)this;
            check_hresult(_winrt_abi_type->get_BeepFrequency(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ICashDrawerCloseAlarm<D>::BeepDuration(winrt::Windows::Foundation::TimeSpan const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ICashDrawerCloseAlarm>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ICashDrawerCloseAlarm, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ICashDrawerCloseAlarm>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_BeepDuration(impl::bind_in(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ICashDrawerCloseAlarm>**)this;
            check_hresult(_winrt_abi_type->put_BeepDuration(impl::bind_in(value)));
        }
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ICashDrawerCloseAlarm<D>::BeepDuration() const
    {
        winrt::Windows::Foundation::TimeSpan value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ICashDrawerCloseAlarm>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ICashDrawerCloseAlarm, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ICashDrawerCloseAlarm>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_BeepDuration(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ICashDrawerCloseAlarm>**)this;
            check_hresult(_winrt_abi_type->get_BeepDuration(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ICashDrawerCloseAlarm<D>::BeepDelay(winrt::Windows::Foundation::TimeSpan const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ICashDrawerCloseAlarm>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ICashDrawerCloseAlarm, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ICashDrawerCloseAlarm>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_BeepDelay(impl::bind_in(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ICashDrawerCloseAlarm>**)this;
            check_hresult(_winrt_abi_type->put_BeepDelay(impl::bind_in(value)));
        }
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ICashDrawerCloseAlarm<D>::BeepDelay() const
    {
        winrt::Windows::Foundation::TimeSpan value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ICashDrawerCloseAlarm>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ICashDrawerCloseAlarm, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ICashDrawerCloseAlarm>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_BeepDelay(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ICashDrawerCloseAlarm>**)this;
            check_hresult(_winrt_abi_type->get_BeepDelay(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ICashDrawerCloseAlarm<D>::AlarmTimeoutExpired(winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::Devices::PointOfService::CashDrawerCloseAlarm, winrt::Windows::Foundation::IInspectable> const& handler) const
    {
        winrt::event_token token{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ICashDrawerCloseAlarm>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ICashDrawerCloseAlarm, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ICashDrawerCloseAlarm>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->add_AlarmTimeoutExpired(*(void**)(&handler), put_abi(token)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ICashDrawerCloseAlarm>**)this;
            check_hresult(_winrt_abi_type->add_AlarmTimeoutExpired(*(void**)(&handler), put_abi(token)));
        }
        return token;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ICashDrawerCloseAlarm<D>::AlarmTimeoutExpired(auto_revoke_t, winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::Devices::PointOfService::CashDrawerCloseAlarm, winrt::Windows::Foundation::IInspectable> const& handler) const
    {
        return impl::make_event_revoker<D, AlarmTimeoutExpired_revoker>(this, AlarmTimeoutExpired(handler));
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ICashDrawerCloseAlarm<D>::AlarmTimeoutExpired(winrt::event_token const& token) const noexcept
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ICashDrawerCloseAlarm>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ICashDrawerCloseAlarm, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ICashDrawerCloseAlarm>**)&_winrt_casted_result;
            _winrt_abi_type->remove_AlarmTimeoutExpired(impl::bind_in(token));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ICashDrawerCloseAlarm>**)this;
            _winrt_abi_type->remove_AlarmTimeoutExpired(impl::bind_in(token));
        }
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ICashDrawerCloseAlarm<D>::StartAsync() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ICashDrawerCloseAlarm>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ICashDrawerCloseAlarm, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ICashDrawerCloseAlarm>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->StartAsync(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ICashDrawerCloseAlarm>**)this;
            check_hresult(_winrt_abi_type->StartAsync(&result));
        }
        return winrt::Windows::Foundation::IAsyncOperation<bool>{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ICashDrawerEventSource<D>::DrawerClosed(winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::Devices::PointOfService::CashDrawerEventSource, winrt::Windows::Devices::PointOfService::CashDrawerClosedEventArgs> const& handler) const
    {
        winrt::event_token token{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ICashDrawerEventSource>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ICashDrawerEventSource, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ICashDrawerEventSource>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->add_DrawerClosed(*(void**)(&handler), put_abi(token)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ICashDrawerEventSource>**)this;
            check_hresult(_winrt_abi_type->add_DrawerClosed(*(void**)(&handler), put_abi(token)));
        }
        return token;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ICashDrawerEventSource<D>::DrawerClosed(auto_revoke_t, winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::Devices::PointOfService::CashDrawerEventSource, winrt::Windows::Devices::PointOfService::CashDrawerClosedEventArgs> const& handler) const
    {
        return impl::make_event_revoker<D, DrawerClosed_revoker>(this, DrawerClosed(handler));
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ICashDrawerEventSource<D>::DrawerClosed(winrt::event_token const& token) const noexcept
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ICashDrawerEventSource>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ICashDrawerEventSource, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ICashDrawerEventSource>**)&_winrt_casted_result;
            _winrt_abi_type->remove_DrawerClosed(impl::bind_in(token));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ICashDrawerEventSource>**)this;
            _winrt_abi_type->remove_DrawerClosed(impl::bind_in(token));
        }
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ICashDrawerEventSource<D>::DrawerOpened(winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::Devices::PointOfService::CashDrawerEventSource, winrt::Windows::Devices::PointOfService::CashDrawerOpenedEventArgs> const& handler) const
    {
        winrt::event_token token{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ICashDrawerEventSource>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ICashDrawerEventSource, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ICashDrawerEventSource>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->add_DrawerOpened(*(void**)(&handler), put_abi(token)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ICashDrawerEventSource>**)this;
            check_hresult(_winrt_abi_type->add_DrawerOpened(*(void**)(&handler), put_abi(token)));
        }
        return token;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ICashDrawerEventSource<D>::DrawerOpened(auto_revoke_t, winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::Devices::PointOfService::CashDrawerEventSource, winrt::Windows::Devices::PointOfService::CashDrawerOpenedEventArgs> const& handler) const
    {
        return impl::make_event_revoker<D, DrawerOpened_revoker>(this, DrawerOpened(handler));
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ICashDrawerEventSource<D>::DrawerOpened(winrt::event_token const& token) const noexcept
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ICashDrawerEventSource>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ICashDrawerEventSource, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ICashDrawerEventSource>**)&_winrt_casted_result;
            _winrt_abi_type->remove_DrawerOpened(impl::bind_in(token));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ICashDrawerEventSource>**)this;
            _winrt_abi_type->remove_DrawerOpened(impl::bind_in(token));
        }
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ICashDrawerEventSourceEventArgs<D>::CashDrawer() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ICashDrawerEventSourceEventArgs>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ICashDrawerEventSourceEventArgs, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ICashDrawerEventSourceEventArgs>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_CashDrawer(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ICashDrawerEventSourceEventArgs>**)this;
            check_hresult(_winrt_abi_type->get_CashDrawer(&value));
        }
        return winrt::Windows::Devices::PointOfService::CashDrawer{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ICashDrawerStatics<D>::GetDefaultAsync() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ICashDrawerStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ICashDrawerStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ICashDrawerStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetDefaultAsync(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ICashDrawerStatics>**)this;
            check_hresult(_winrt_abi_type->GetDefaultAsync(&result));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Devices::PointOfService::CashDrawer>{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ICashDrawerStatics<D>::FromIdAsync(param::hstring const& deviceId) const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ICashDrawerStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ICashDrawerStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ICashDrawerStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->FromIdAsync(*(void**)(&deviceId), &result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ICashDrawerStatics>**)this;
            check_hresult(_winrt_abi_type->FromIdAsync(*(void**)(&deviceId), &result));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Devices::PointOfService::CashDrawer>{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ICashDrawerStatics<D>::GetDeviceSelector() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ICashDrawerStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ICashDrawerStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ICashDrawerStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetDeviceSelector(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ICashDrawerStatics>**)this;
            check_hresult(_winrt_abi_type->GetDeviceSelector(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ICashDrawerStatics2<D>::GetDeviceSelector(winrt::Windows::Devices::PointOfService::PosConnectionTypes const& connectionTypes) const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ICashDrawerStatics2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ICashDrawerStatics2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ICashDrawerStatics2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetDeviceSelectorWithConnectionTypes(static_cast<uint32_t>(connectionTypes), &value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ICashDrawerStatics2>**)this;
            check_hresult(_winrt_abi_type->GetDeviceSelectorWithConnectionTypes(static_cast<uint32_t>(connectionTypes), &value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ICashDrawerStatus<D>::StatusKind() const
    {
        winrt::Windows::Devices::PointOfService::CashDrawerStatusKind value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ICashDrawerStatus>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ICashDrawerStatus, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ICashDrawerStatus>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_StatusKind(reinterpret_cast<int32_t*>(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ICashDrawerStatus>**)this;
            check_hresult(_winrt_abi_type->get_StatusKind(reinterpret_cast<int32_t*>(&value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ICashDrawerStatus<D>::ExtendedStatus() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ICashDrawerStatus>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ICashDrawerStatus, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ICashDrawerStatus>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ExtendedStatus(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ICashDrawerStatus>**)this;
            check_hresult(_winrt_abi_type->get_ExtendedStatus(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ICashDrawerStatusUpdatedEventArgs<D>::Status() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ICashDrawerStatusUpdatedEventArgs>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ICashDrawerStatusUpdatedEventArgs, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ICashDrawerStatusUpdatedEventArgs>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Status(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ICashDrawerStatusUpdatedEventArgs>**)this;
            check_hresult(_winrt_abi_type->get_Status(&value));
        }
        return winrt::Windows::Devices::PointOfService::CashDrawerStatus{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedBarcodeScanner<D>::DeviceId() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IClaimedBarcodeScanner>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IClaimedBarcodeScanner, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedBarcodeScanner>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_DeviceId(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedBarcodeScanner>**)this;
            check_hresult(_winrt_abi_type->get_DeviceId(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedBarcodeScanner<D>::IsEnabled() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IClaimedBarcodeScanner>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IClaimedBarcodeScanner, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedBarcodeScanner>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsEnabled(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedBarcodeScanner>**)this;
            check_hresult(_winrt_abi_type->get_IsEnabled(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedBarcodeScanner<D>::IsDisabledOnDataReceived(bool value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IClaimedBarcodeScanner>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IClaimedBarcodeScanner, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedBarcodeScanner>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_IsDisabledOnDataReceived(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedBarcodeScanner>**)this;
            check_hresult(_winrt_abi_type->put_IsDisabledOnDataReceived(value));
        }
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedBarcodeScanner<D>::IsDisabledOnDataReceived() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IClaimedBarcodeScanner>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IClaimedBarcodeScanner, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedBarcodeScanner>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsDisabledOnDataReceived(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedBarcodeScanner>**)this;
            check_hresult(_winrt_abi_type->get_IsDisabledOnDataReceived(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedBarcodeScanner<D>::IsDecodeDataEnabled(bool value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IClaimedBarcodeScanner>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IClaimedBarcodeScanner, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedBarcodeScanner>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_IsDecodeDataEnabled(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedBarcodeScanner>**)this;
            check_hresult(_winrt_abi_type->put_IsDecodeDataEnabled(value));
        }
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedBarcodeScanner<D>::IsDecodeDataEnabled() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IClaimedBarcodeScanner>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IClaimedBarcodeScanner, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedBarcodeScanner>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsDecodeDataEnabled(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedBarcodeScanner>**)this;
            check_hresult(_winrt_abi_type->get_IsDecodeDataEnabled(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedBarcodeScanner<D>::EnableAsync() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IClaimedBarcodeScanner>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IClaimedBarcodeScanner, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedBarcodeScanner>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->EnableAsync(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedBarcodeScanner>**)this;
            check_hresult(_winrt_abi_type->EnableAsync(&result));
        }
        return winrt::Windows::Foundation::IAsyncAction{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedBarcodeScanner<D>::DisableAsync() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IClaimedBarcodeScanner>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IClaimedBarcodeScanner, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedBarcodeScanner>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->DisableAsync(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedBarcodeScanner>**)this;
            check_hresult(_winrt_abi_type->DisableAsync(&result));
        }
        return winrt::Windows::Foundation::IAsyncAction{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedBarcodeScanner<D>::RetainDevice() const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IClaimedBarcodeScanner>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IClaimedBarcodeScanner, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedBarcodeScanner>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->RetainDevice());
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedBarcodeScanner>**)this;
            check_hresult(_winrt_abi_type->RetainDevice());
        }
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedBarcodeScanner<D>::SetActiveSymbologiesAsync(param::async_iterable<uint32_t> const& symbologies) const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IClaimedBarcodeScanner>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IClaimedBarcodeScanner, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedBarcodeScanner>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->SetActiveSymbologiesAsync(*(void**)(&symbologies), &result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedBarcodeScanner>**)this;
            check_hresult(_winrt_abi_type->SetActiveSymbologiesAsync(*(void**)(&symbologies), &result));
        }
        return winrt::Windows::Foundation::IAsyncAction{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedBarcodeScanner<D>::ResetStatisticsAsync(param::async_iterable<hstring> const& statisticsCategories) const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IClaimedBarcodeScanner>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IClaimedBarcodeScanner, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedBarcodeScanner>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->ResetStatisticsAsync(*(void**)(&statisticsCategories), &result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedBarcodeScanner>**)this;
            check_hresult(_winrt_abi_type->ResetStatisticsAsync(*(void**)(&statisticsCategories), &result));
        }
        return winrt::Windows::Foundation::IAsyncAction{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedBarcodeScanner<D>::UpdateStatisticsAsync(param::async_iterable<winrt::Windows::Foundation::Collections::IKeyValuePair<hstring, hstring>> const& statistics) const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IClaimedBarcodeScanner>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IClaimedBarcodeScanner, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedBarcodeScanner>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->UpdateStatisticsAsync(*(void**)(&statistics), &result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedBarcodeScanner>**)this;
            check_hresult(_winrt_abi_type->UpdateStatisticsAsync(*(void**)(&statistics), &result));
        }
        return winrt::Windows::Foundation::IAsyncAction{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedBarcodeScanner<D>::SetActiveProfileAsync(param::hstring const& profile) const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IClaimedBarcodeScanner>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IClaimedBarcodeScanner, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedBarcodeScanner>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->SetActiveProfileAsync(*(void**)(&profile), &result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedBarcodeScanner>**)this;
            check_hresult(_winrt_abi_type->SetActiveProfileAsync(*(void**)(&profile), &result));
        }
        return winrt::Windows::Foundation::IAsyncAction{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedBarcodeScanner<D>::DataReceived(winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::Devices::PointOfService::ClaimedBarcodeScanner, winrt::Windows::Devices::PointOfService::BarcodeScannerDataReceivedEventArgs> const& handler) const
    {
        winrt::event_token token{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IClaimedBarcodeScanner>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IClaimedBarcodeScanner, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedBarcodeScanner>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->add_DataReceived(*(void**)(&handler), put_abi(token)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedBarcodeScanner>**)this;
            check_hresult(_winrt_abi_type->add_DataReceived(*(void**)(&handler), put_abi(token)));
        }
        return token;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedBarcodeScanner<D>::DataReceived(auto_revoke_t, winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::Devices::PointOfService::ClaimedBarcodeScanner, winrt::Windows::Devices::PointOfService::BarcodeScannerDataReceivedEventArgs> const& handler) const
    {
        return impl::make_event_revoker<D, DataReceived_revoker>(this, DataReceived(handler));
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedBarcodeScanner<D>::DataReceived(winrt::event_token const& token) const noexcept
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IClaimedBarcodeScanner>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IClaimedBarcodeScanner, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedBarcodeScanner>**)&_winrt_casted_result;
            _winrt_abi_type->remove_DataReceived(impl::bind_in(token));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedBarcodeScanner>**)this;
            _winrt_abi_type->remove_DataReceived(impl::bind_in(token));
        }
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedBarcodeScanner<D>::TriggerPressed(winrt::Windows::Foundation::EventHandler<winrt::Windows::Devices::PointOfService::ClaimedBarcodeScanner> const& handler) const
    {
        winrt::event_token token{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IClaimedBarcodeScanner>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IClaimedBarcodeScanner, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedBarcodeScanner>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->add_TriggerPressed(*(void**)(&handler), put_abi(token)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedBarcodeScanner>**)this;
            check_hresult(_winrt_abi_type->add_TriggerPressed(*(void**)(&handler), put_abi(token)));
        }
        return token;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedBarcodeScanner<D>::TriggerPressed(auto_revoke_t, winrt::Windows::Foundation::EventHandler<winrt::Windows::Devices::PointOfService::ClaimedBarcodeScanner> const& handler) const
    {
        return impl::make_event_revoker<D, TriggerPressed_revoker>(this, TriggerPressed(handler));
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedBarcodeScanner<D>::TriggerPressed(winrt::event_token const& token) const noexcept
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IClaimedBarcodeScanner>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IClaimedBarcodeScanner, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedBarcodeScanner>**)&_winrt_casted_result;
            _winrt_abi_type->remove_TriggerPressed(impl::bind_in(token));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedBarcodeScanner>**)this;
            _winrt_abi_type->remove_TriggerPressed(impl::bind_in(token));
        }
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedBarcodeScanner<D>::TriggerReleased(winrt::Windows::Foundation::EventHandler<winrt::Windows::Devices::PointOfService::ClaimedBarcodeScanner> const& handler) const
    {
        winrt::event_token token{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IClaimedBarcodeScanner>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IClaimedBarcodeScanner, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedBarcodeScanner>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->add_TriggerReleased(*(void**)(&handler), put_abi(token)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedBarcodeScanner>**)this;
            check_hresult(_winrt_abi_type->add_TriggerReleased(*(void**)(&handler), put_abi(token)));
        }
        return token;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedBarcodeScanner<D>::TriggerReleased(auto_revoke_t, winrt::Windows::Foundation::EventHandler<winrt::Windows::Devices::PointOfService::ClaimedBarcodeScanner> const& handler) const
    {
        return impl::make_event_revoker<D, TriggerReleased_revoker>(this, TriggerReleased(handler));
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedBarcodeScanner<D>::TriggerReleased(winrt::event_token const& token) const noexcept
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IClaimedBarcodeScanner>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IClaimedBarcodeScanner, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedBarcodeScanner>**)&_winrt_casted_result;
            _winrt_abi_type->remove_TriggerReleased(impl::bind_in(token));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedBarcodeScanner>**)this;
            _winrt_abi_type->remove_TriggerReleased(impl::bind_in(token));
        }
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedBarcodeScanner<D>::ReleaseDeviceRequested(winrt::Windows::Foundation::EventHandler<winrt::Windows::Devices::PointOfService::ClaimedBarcodeScanner> const& handler) const
    {
        winrt::event_token token{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IClaimedBarcodeScanner>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IClaimedBarcodeScanner, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedBarcodeScanner>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->add_ReleaseDeviceRequested(*(void**)(&handler), put_abi(token)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedBarcodeScanner>**)this;
            check_hresult(_winrt_abi_type->add_ReleaseDeviceRequested(*(void**)(&handler), put_abi(token)));
        }
        return token;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedBarcodeScanner<D>::ReleaseDeviceRequested(auto_revoke_t, winrt::Windows::Foundation::EventHandler<winrt::Windows::Devices::PointOfService::ClaimedBarcodeScanner> const& handler) const
    {
        return impl::make_event_revoker<D, ReleaseDeviceRequested_revoker>(this, ReleaseDeviceRequested(handler));
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedBarcodeScanner<D>::ReleaseDeviceRequested(winrt::event_token const& token) const noexcept
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IClaimedBarcodeScanner>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IClaimedBarcodeScanner, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedBarcodeScanner>**)&_winrt_casted_result;
            _winrt_abi_type->remove_ReleaseDeviceRequested(impl::bind_in(token));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedBarcodeScanner>**)this;
            _winrt_abi_type->remove_ReleaseDeviceRequested(impl::bind_in(token));
        }
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedBarcodeScanner<D>::ImagePreviewReceived(winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::Devices::PointOfService::ClaimedBarcodeScanner, winrt::Windows::Devices::PointOfService::BarcodeScannerImagePreviewReceivedEventArgs> const& handler) const
    {
        winrt::event_token token{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IClaimedBarcodeScanner>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IClaimedBarcodeScanner, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedBarcodeScanner>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->add_ImagePreviewReceived(*(void**)(&handler), put_abi(token)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedBarcodeScanner>**)this;
            check_hresult(_winrt_abi_type->add_ImagePreviewReceived(*(void**)(&handler), put_abi(token)));
        }
        return token;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedBarcodeScanner<D>::ImagePreviewReceived(auto_revoke_t, winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::Devices::PointOfService::ClaimedBarcodeScanner, winrt::Windows::Devices::PointOfService::BarcodeScannerImagePreviewReceivedEventArgs> const& handler) const
    {
        return impl::make_event_revoker<D, ImagePreviewReceived_revoker>(this, ImagePreviewReceived(handler));
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedBarcodeScanner<D>::ImagePreviewReceived(winrt::event_token const& token) const noexcept
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IClaimedBarcodeScanner>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IClaimedBarcodeScanner, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedBarcodeScanner>**)&_winrt_casted_result;
            _winrt_abi_type->remove_ImagePreviewReceived(impl::bind_in(token));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedBarcodeScanner>**)this;
            _winrt_abi_type->remove_ImagePreviewReceived(impl::bind_in(token));
        }
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedBarcodeScanner<D>::ErrorOccurred(winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::Devices::PointOfService::ClaimedBarcodeScanner, winrt::Windows::Devices::PointOfService::BarcodeScannerErrorOccurredEventArgs> const& handler) const
    {
        winrt::event_token token{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IClaimedBarcodeScanner>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IClaimedBarcodeScanner, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedBarcodeScanner>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->add_ErrorOccurred(*(void**)(&handler), put_abi(token)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedBarcodeScanner>**)this;
            check_hresult(_winrt_abi_type->add_ErrorOccurred(*(void**)(&handler), put_abi(token)));
        }
        return token;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedBarcodeScanner<D>::ErrorOccurred(auto_revoke_t, winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::Devices::PointOfService::ClaimedBarcodeScanner, winrt::Windows::Devices::PointOfService::BarcodeScannerErrorOccurredEventArgs> const& handler) const
    {
        return impl::make_event_revoker<D, ErrorOccurred_revoker>(this, ErrorOccurred(handler));
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedBarcodeScanner<D>::ErrorOccurred(winrt::event_token const& token) const noexcept
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IClaimedBarcodeScanner>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IClaimedBarcodeScanner, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedBarcodeScanner>**)&_winrt_casted_result;
            _winrt_abi_type->remove_ErrorOccurred(impl::bind_in(token));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedBarcodeScanner>**)this;
            _winrt_abi_type->remove_ErrorOccurred(impl::bind_in(token));
        }
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedBarcodeScanner1<D>::StartSoftwareTriggerAsync() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IClaimedBarcodeScanner1>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IClaimedBarcodeScanner1, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedBarcodeScanner1>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->StartSoftwareTriggerAsync(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedBarcodeScanner1>**)this;
            check_hresult(_winrt_abi_type->StartSoftwareTriggerAsync(&result));
        }
        return winrt::Windows::Foundation::IAsyncAction{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedBarcodeScanner1<D>::StopSoftwareTriggerAsync() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IClaimedBarcodeScanner1>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IClaimedBarcodeScanner1, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedBarcodeScanner1>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->StopSoftwareTriggerAsync(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedBarcodeScanner1>**)this;
            check_hresult(_winrt_abi_type->StopSoftwareTriggerAsync(&result));
        }
        return winrt::Windows::Foundation::IAsyncAction{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedBarcodeScanner2<D>::GetSymbologyAttributesAsync(uint32_t barcodeSymbology) const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IClaimedBarcodeScanner2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IClaimedBarcodeScanner2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedBarcodeScanner2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetSymbologyAttributesAsync(barcodeSymbology, &result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedBarcodeScanner2>**)this;
            check_hresult(_winrt_abi_type->GetSymbologyAttributesAsync(barcodeSymbology, &result));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Devices::PointOfService::BarcodeSymbologyAttributes>{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedBarcodeScanner2<D>::SetSymbologyAttributesAsync(uint32_t barcodeSymbology, winrt::Windows::Devices::PointOfService::BarcodeSymbologyAttributes const& attributes) const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IClaimedBarcodeScanner2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IClaimedBarcodeScanner2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedBarcodeScanner2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->SetSymbologyAttributesAsync(barcodeSymbology, *(void**)(&attributes), &result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedBarcodeScanner2>**)this;
            check_hresult(_winrt_abi_type->SetSymbologyAttributesAsync(barcodeSymbology, *(void**)(&attributes), &result));
        }
        return winrt::Windows::Foundation::IAsyncOperation<bool>{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedBarcodeScanner3<D>::ShowVideoPreviewAsync() const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IClaimedBarcodeScanner3>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IClaimedBarcodeScanner3, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedBarcodeScanner3>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->ShowVideoPreviewAsync(&operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedBarcodeScanner3>**)this;
            check_hresult(_winrt_abi_type->ShowVideoPreviewAsync(&operation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<bool>{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedBarcodeScanner3<D>::HideVideoPreview() const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IClaimedBarcodeScanner3>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IClaimedBarcodeScanner3, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedBarcodeScanner3>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->HideVideoPreview());
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedBarcodeScanner3>**)this;
            check_hresult(_winrt_abi_type->HideVideoPreview());
        }
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedBarcodeScanner3<D>::IsVideoPreviewShownOnEnable(bool value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IClaimedBarcodeScanner3>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IClaimedBarcodeScanner3, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedBarcodeScanner3>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_IsVideoPreviewShownOnEnable(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedBarcodeScanner3>**)this;
            check_hresult(_winrt_abi_type->put_IsVideoPreviewShownOnEnable(value));
        }
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedBarcodeScanner3<D>::IsVideoPreviewShownOnEnable() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IClaimedBarcodeScanner3>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IClaimedBarcodeScanner3, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedBarcodeScanner3>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsVideoPreviewShownOnEnable(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedBarcodeScanner3>**)this;
            check_hresult(_winrt_abi_type->get_IsVideoPreviewShownOnEnable(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedBarcodeScanner4<D>::Closed(winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::Devices::PointOfService::ClaimedBarcodeScanner, winrt::Windows::Devices::PointOfService::ClaimedBarcodeScannerClosedEventArgs> const& handler) const
    {
        winrt::event_token token{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IClaimedBarcodeScanner4>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IClaimedBarcodeScanner4, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedBarcodeScanner4>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->add_Closed(*(void**)(&handler), put_abi(token)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedBarcodeScanner4>**)this;
            check_hresult(_winrt_abi_type->add_Closed(*(void**)(&handler), put_abi(token)));
        }
        return token;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedBarcodeScanner4<D>::Closed(auto_revoke_t, winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::Devices::PointOfService::ClaimedBarcodeScanner, winrt::Windows::Devices::PointOfService::ClaimedBarcodeScannerClosedEventArgs> const& handler) const
    {
        return impl::make_event_revoker<D, Closed_revoker>(this, Closed(handler));
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedBarcodeScanner4<D>::Closed(winrt::event_token const& token) const noexcept
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IClaimedBarcodeScanner4>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IClaimedBarcodeScanner4, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedBarcodeScanner4>**)&_winrt_casted_result;
            _winrt_abi_type->remove_Closed(impl::bind_in(token));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedBarcodeScanner4>**)this;
            _winrt_abi_type->remove_Closed(impl::bind_in(token));
        }
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedCashDrawer<D>::DeviceId() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IClaimedCashDrawer>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IClaimedCashDrawer, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedCashDrawer>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_DeviceId(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedCashDrawer>**)this;
            check_hresult(_winrt_abi_type->get_DeviceId(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedCashDrawer<D>::IsEnabled() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IClaimedCashDrawer>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IClaimedCashDrawer, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedCashDrawer>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsEnabled(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedCashDrawer>**)this;
            check_hresult(_winrt_abi_type->get_IsEnabled(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedCashDrawer<D>::IsDrawerOpen() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IClaimedCashDrawer>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IClaimedCashDrawer, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedCashDrawer>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsDrawerOpen(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedCashDrawer>**)this;
            check_hresult(_winrt_abi_type->get_IsDrawerOpen(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedCashDrawer<D>::CloseAlarm() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IClaimedCashDrawer>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IClaimedCashDrawer, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedCashDrawer>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_CloseAlarm(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedCashDrawer>**)this;
            check_hresult(_winrt_abi_type->get_CloseAlarm(&value));
        }
        return winrt::Windows::Devices::PointOfService::CashDrawerCloseAlarm{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedCashDrawer<D>::OpenDrawerAsync() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IClaimedCashDrawer>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IClaimedCashDrawer, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedCashDrawer>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->OpenDrawerAsync(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedCashDrawer>**)this;
            check_hresult(_winrt_abi_type->OpenDrawerAsync(&result));
        }
        return winrt::Windows::Foundation::IAsyncOperation<bool>{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedCashDrawer<D>::EnableAsync() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IClaimedCashDrawer>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IClaimedCashDrawer, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedCashDrawer>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->EnableAsync(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedCashDrawer>**)this;
            check_hresult(_winrt_abi_type->EnableAsync(&result));
        }
        return winrt::Windows::Foundation::IAsyncOperation<bool>{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedCashDrawer<D>::DisableAsync() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IClaimedCashDrawer>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IClaimedCashDrawer, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedCashDrawer>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->DisableAsync(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedCashDrawer>**)this;
            check_hresult(_winrt_abi_type->DisableAsync(&result));
        }
        return winrt::Windows::Foundation::IAsyncOperation<bool>{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedCashDrawer<D>::RetainDeviceAsync() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IClaimedCashDrawer>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IClaimedCashDrawer, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedCashDrawer>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->RetainDeviceAsync(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedCashDrawer>**)this;
            check_hresult(_winrt_abi_type->RetainDeviceAsync(&result));
        }
        return winrt::Windows::Foundation::IAsyncOperation<bool>{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedCashDrawer<D>::ResetStatisticsAsync(param::async_iterable<hstring> const& statisticsCategories) const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IClaimedCashDrawer>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IClaimedCashDrawer, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedCashDrawer>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->ResetStatisticsAsync(*(void**)(&statisticsCategories), &result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedCashDrawer>**)this;
            check_hresult(_winrt_abi_type->ResetStatisticsAsync(*(void**)(&statisticsCategories), &result));
        }
        return winrt::Windows::Foundation::IAsyncOperation<bool>{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedCashDrawer<D>::UpdateStatisticsAsync(param::async_iterable<winrt::Windows::Foundation::Collections::IKeyValuePair<hstring, hstring>> const& statistics) const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IClaimedCashDrawer>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IClaimedCashDrawer, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedCashDrawer>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->UpdateStatisticsAsync(*(void**)(&statistics), &result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedCashDrawer>**)this;
            check_hresult(_winrt_abi_type->UpdateStatisticsAsync(*(void**)(&statistics), &result));
        }
        return winrt::Windows::Foundation::IAsyncOperation<bool>{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedCashDrawer<D>::ReleaseDeviceRequested(winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::Devices::PointOfService::ClaimedCashDrawer, winrt::Windows::Foundation::IInspectable> const& handler) const
    {
        winrt::event_token token{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IClaimedCashDrawer>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IClaimedCashDrawer, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedCashDrawer>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->add_ReleaseDeviceRequested(*(void**)(&handler), put_abi(token)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedCashDrawer>**)this;
            check_hresult(_winrt_abi_type->add_ReleaseDeviceRequested(*(void**)(&handler), put_abi(token)));
        }
        return token;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedCashDrawer<D>::ReleaseDeviceRequested(auto_revoke_t, winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::Devices::PointOfService::ClaimedCashDrawer, winrt::Windows::Foundation::IInspectable> const& handler) const
    {
        return impl::make_event_revoker<D, ReleaseDeviceRequested_revoker>(this, ReleaseDeviceRequested(handler));
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedCashDrawer<D>::ReleaseDeviceRequested(winrt::event_token const& token) const noexcept
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IClaimedCashDrawer>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IClaimedCashDrawer, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedCashDrawer>**)&_winrt_casted_result;
            _winrt_abi_type->remove_ReleaseDeviceRequested(impl::bind_in(token));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedCashDrawer>**)this;
            _winrt_abi_type->remove_ReleaseDeviceRequested(impl::bind_in(token));
        }
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedCashDrawer2<D>::Closed(winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::Devices::PointOfService::ClaimedCashDrawer, winrt::Windows::Devices::PointOfService::ClaimedCashDrawerClosedEventArgs> const& handler) const
    {
        winrt::event_token token{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IClaimedCashDrawer2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IClaimedCashDrawer2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedCashDrawer2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->add_Closed(*(void**)(&handler), put_abi(token)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedCashDrawer2>**)this;
            check_hresult(_winrt_abi_type->add_Closed(*(void**)(&handler), put_abi(token)));
        }
        return token;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedCashDrawer2<D>::Closed(auto_revoke_t, winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::Devices::PointOfService::ClaimedCashDrawer, winrt::Windows::Devices::PointOfService::ClaimedCashDrawerClosedEventArgs> const& handler) const
    {
        return impl::make_event_revoker<D, Closed_revoker>(this, Closed(handler));
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedCashDrawer2<D>::Closed(winrt::event_token const& token) const noexcept
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IClaimedCashDrawer2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IClaimedCashDrawer2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedCashDrawer2>**)&_winrt_casted_result;
            _winrt_abi_type->remove_Closed(impl::bind_in(token));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedCashDrawer2>**)this;
            _winrt_abi_type->remove_Closed(impl::bind_in(token));
        }
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedJournalPrinter<D>::CreateJob() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IClaimedJournalPrinter>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IClaimedJournalPrinter, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedJournalPrinter>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateJob(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedJournalPrinter>**)this;
            check_hresult(_winrt_abi_type->CreateJob(&value));
        }
        return winrt::Windows::Devices::PointOfService::JournalPrintJob{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedLineDisplay<D>::DeviceId() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IClaimedLineDisplay>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IClaimedLineDisplay, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedLineDisplay>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_DeviceId(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedLineDisplay>**)this;
            check_hresult(_winrt_abi_type->get_DeviceId(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedLineDisplay<D>::Capabilities() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IClaimedLineDisplay>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IClaimedLineDisplay, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedLineDisplay>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Capabilities(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedLineDisplay>**)this;
            check_hresult(_winrt_abi_type->get_Capabilities(&value));
        }
        return winrt::Windows::Devices::PointOfService::LineDisplayCapabilities{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedLineDisplay<D>::PhysicalDeviceName() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IClaimedLineDisplay>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IClaimedLineDisplay, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedLineDisplay>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_PhysicalDeviceName(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedLineDisplay>**)this;
            check_hresult(_winrt_abi_type->get_PhysicalDeviceName(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedLineDisplay<D>::PhysicalDeviceDescription() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IClaimedLineDisplay>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IClaimedLineDisplay, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedLineDisplay>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_PhysicalDeviceDescription(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedLineDisplay>**)this;
            check_hresult(_winrt_abi_type->get_PhysicalDeviceDescription(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedLineDisplay<D>::DeviceControlDescription() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IClaimedLineDisplay>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IClaimedLineDisplay, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedLineDisplay>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_DeviceControlDescription(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedLineDisplay>**)this;
            check_hresult(_winrt_abi_type->get_DeviceControlDescription(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedLineDisplay<D>::DeviceControlVersion() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IClaimedLineDisplay>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IClaimedLineDisplay, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedLineDisplay>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_DeviceControlVersion(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedLineDisplay>**)this;
            check_hresult(_winrt_abi_type->get_DeviceControlVersion(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedLineDisplay<D>::DeviceServiceVersion() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IClaimedLineDisplay>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IClaimedLineDisplay, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedLineDisplay>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_DeviceServiceVersion(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedLineDisplay>**)this;
            check_hresult(_winrt_abi_type->get_DeviceServiceVersion(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedLineDisplay<D>::DefaultWindow() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IClaimedLineDisplay>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IClaimedLineDisplay, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedLineDisplay>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_DefaultWindow(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedLineDisplay>**)this;
            check_hresult(_winrt_abi_type->get_DefaultWindow(&value));
        }
        return winrt::Windows::Devices::PointOfService::LineDisplayWindow{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedLineDisplay<D>::RetainDevice() const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IClaimedLineDisplay>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IClaimedLineDisplay, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedLineDisplay>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->RetainDevice());
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedLineDisplay>**)this;
            check_hresult(_winrt_abi_type->RetainDevice());
        }
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedLineDisplay<D>::ReleaseDeviceRequested(winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::Devices::PointOfService::ClaimedLineDisplay, winrt::Windows::Foundation::IInspectable> const& handler) const
    {
        winrt::event_token token{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IClaimedLineDisplay>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IClaimedLineDisplay, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedLineDisplay>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->add_ReleaseDeviceRequested(*(void**)(&handler), put_abi(token)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedLineDisplay>**)this;
            check_hresult(_winrt_abi_type->add_ReleaseDeviceRequested(*(void**)(&handler), put_abi(token)));
        }
        return token;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedLineDisplay<D>::ReleaseDeviceRequested(auto_revoke_t, winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::Devices::PointOfService::ClaimedLineDisplay, winrt::Windows::Foundation::IInspectable> const& handler) const
    {
        return impl::make_event_revoker<D, ReleaseDeviceRequested_revoker>(this, ReleaseDeviceRequested(handler));
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedLineDisplay<D>::ReleaseDeviceRequested(winrt::event_token const& token) const noexcept
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IClaimedLineDisplay>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IClaimedLineDisplay, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedLineDisplay>**)&_winrt_casted_result;
            _winrt_abi_type->remove_ReleaseDeviceRequested(impl::bind_in(token));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedLineDisplay>**)this;
            _winrt_abi_type->remove_ReleaseDeviceRequested(impl::bind_in(token));
        }
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedLineDisplay2<D>::GetStatisticsAsync(param::async_iterable<hstring> const& statisticsCategories) const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IClaimedLineDisplay2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IClaimedLineDisplay2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedLineDisplay2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetStatisticsAsync(*(void**)(&statisticsCategories), &result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedLineDisplay2>**)this;
            check_hresult(_winrt_abi_type->GetStatisticsAsync(*(void**)(&statisticsCategories), &result));
        }
        return winrt::Windows::Foundation::IAsyncOperation<hstring>{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedLineDisplay2<D>::CheckHealthAsync(winrt::Windows::Devices::PointOfService::UnifiedPosHealthCheckLevel const& level) const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IClaimedLineDisplay2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IClaimedLineDisplay2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedLineDisplay2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CheckHealthAsync(static_cast<int32_t>(level), &result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedLineDisplay2>**)this;
            check_hresult(_winrt_abi_type->CheckHealthAsync(static_cast<int32_t>(level), &result));
        }
        return winrt::Windows::Foundation::IAsyncOperation<hstring>{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedLineDisplay2<D>::CheckPowerStatusAsync() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IClaimedLineDisplay2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IClaimedLineDisplay2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedLineDisplay2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CheckPowerStatusAsync(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedLineDisplay2>**)this;
            check_hresult(_winrt_abi_type->CheckPowerStatusAsync(&result));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Devices::PointOfService::LineDisplayPowerStatus>{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedLineDisplay2<D>::StatusUpdated(winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::Devices::PointOfService::ClaimedLineDisplay, winrt::Windows::Devices::PointOfService::LineDisplayStatusUpdatedEventArgs> const& handler) const
    {
        winrt::event_token token{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IClaimedLineDisplay2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IClaimedLineDisplay2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedLineDisplay2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->add_StatusUpdated(*(void**)(&handler), put_abi(token)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedLineDisplay2>**)this;
            check_hresult(_winrt_abi_type->add_StatusUpdated(*(void**)(&handler), put_abi(token)));
        }
        return token;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedLineDisplay2<D>::StatusUpdated(auto_revoke_t, winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::Devices::PointOfService::ClaimedLineDisplay, winrt::Windows::Devices::PointOfService::LineDisplayStatusUpdatedEventArgs> const& handler) const
    {
        return impl::make_event_revoker<D, StatusUpdated_revoker>(this, StatusUpdated(handler));
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedLineDisplay2<D>::StatusUpdated(winrt::event_token const& token) const noexcept
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IClaimedLineDisplay2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IClaimedLineDisplay2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedLineDisplay2>**)&_winrt_casted_result;
            _winrt_abi_type->remove_StatusUpdated(impl::bind_in(token));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedLineDisplay2>**)this;
            _winrt_abi_type->remove_StatusUpdated(impl::bind_in(token));
        }
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedLineDisplay2<D>::SupportedScreenSizesInCharacters() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IClaimedLineDisplay2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IClaimedLineDisplay2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedLineDisplay2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_SupportedScreenSizesInCharacters(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedLineDisplay2>**)this;
            check_hresult(_winrt_abi_type->get_SupportedScreenSizesInCharacters(&value));
        }
        return winrt::Windows::Foundation::Collections::IVectorView<winrt::Windows::Foundation::Size>{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedLineDisplay2<D>::MaxBitmapSizeInPixels() const
    {
        winrt::Windows::Foundation::Size value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IClaimedLineDisplay2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IClaimedLineDisplay2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedLineDisplay2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_MaxBitmapSizeInPixels(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedLineDisplay2>**)this;
            check_hresult(_winrt_abi_type->get_MaxBitmapSizeInPixels(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedLineDisplay2<D>::SupportedCharacterSets() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IClaimedLineDisplay2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IClaimedLineDisplay2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedLineDisplay2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_SupportedCharacterSets(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedLineDisplay2>**)this;
            check_hresult(_winrt_abi_type->get_SupportedCharacterSets(&value));
        }
        return winrt::Windows::Foundation::Collections::IVectorView<int32_t>{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedLineDisplay2<D>::CustomGlyphs() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IClaimedLineDisplay2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IClaimedLineDisplay2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedLineDisplay2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_CustomGlyphs(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedLineDisplay2>**)this;
            check_hresult(_winrt_abi_type->get_CustomGlyphs(&value));
        }
        return winrt::Windows::Devices::PointOfService::LineDisplayCustomGlyphs{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedLineDisplay2<D>::GetAttributes() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IClaimedLineDisplay2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IClaimedLineDisplay2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedLineDisplay2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetAttributes(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedLineDisplay2>**)this;
            check_hresult(_winrt_abi_type->GetAttributes(&value));
        }
        return winrt::Windows::Devices::PointOfService::LineDisplayAttributes{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedLineDisplay2<D>::TryUpdateAttributesAsync(winrt::Windows::Devices::PointOfService::LineDisplayAttributes const& attributes) const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IClaimedLineDisplay2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IClaimedLineDisplay2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedLineDisplay2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->TryUpdateAttributesAsync(*(void**)(&attributes), &operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedLineDisplay2>**)this;
            check_hresult(_winrt_abi_type->TryUpdateAttributesAsync(*(void**)(&attributes), &operation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<bool>{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedLineDisplay2<D>::TrySetDescriptorAsync(uint32_t descriptor, winrt::Windows::Devices::PointOfService::LineDisplayDescriptorState const& descriptorState) const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IClaimedLineDisplay2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IClaimedLineDisplay2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedLineDisplay2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->TrySetDescriptorAsync(descriptor, static_cast<int32_t>(descriptorState), &operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedLineDisplay2>**)this;
            check_hresult(_winrt_abi_type->TrySetDescriptorAsync(descriptor, static_cast<int32_t>(descriptorState), &operation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<bool>{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedLineDisplay2<D>::TryClearDescriptorsAsync() const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IClaimedLineDisplay2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IClaimedLineDisplay2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedLineDisplay2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->TryClearDescriptorsAsync(&operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedLineDisplay2>**)this;
            check_hresult(_winrt_abi_type->TryClearDescriptorsAsync(&operation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<bool>{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedLineDisplay2<D>::TryCreateWindowAsync(winrt::Windows::Foundation::Rect const& viewport, winrt::Windows::Foundation::Size const& windowSize) const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IClaimedLineDisplay2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IClaimedLineDisplay2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedLineDisplay2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->TryCreateWindowAsync(impl::bind_in(viewport), impl::bind_in(windowSize), &result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedLineDisplay2>**)this;
            check_hresult(_winrt_abi_type->TryCreateWindowAsync(impl::bind_in(viewport), impl::bind_in(windowSize), &result));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Devices::PointOfService::LineDisplayWindow>{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedLineDisplay2<D>::TryStoreStorageFileBitmapAsync(winrt::Windows::Storage::StorageFile const& bitmap) const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IClaimedLineDisplay2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IClaimedLineDisplay2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedLineDisplay2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->TryStoreStorageFileBitmapAsync(*(void**)(&bitmap), &result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedLineDisplay2>**)this;
            check_hresult(_winrt_abi_type->TryStoreStorageFileBitmapAsync(*(void**)(&bitmap), &result));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Devices::PointOfService::LineDisplayStoredBitmap>{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedLineDisplay2<D>::TryStoreStorageFileBitmapAsync(winrt::Windows::Storage::StorageFile const& bitmap, winrt::Windows::Devices::PointOfService::LineDisplayHorizontalAlignment const& horizontalAlignment, winrt::Windows::Devices::PointOfService::LineDisplayVerticalAlignment const& verticalAlignment) const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IClaimedLineDisplay2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IClaimedLineDisplay2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedLineDisplay2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->TryStoreStorageFileBitmapWithAlignmentAsync(*(void**)(&bitmap), static_cast<int32_t>(horizontalAlignment), static_cast<int32_t>(verticalAlignment), &result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedLineDisplay2>**)this;
            check_hresult(_winrt_abi_type->TryStoreStorageFileBitmapWithAlignmentAsync(*(void**)(&bitmap), static_cast<int32_t>(horizontalAlignment), static_cast<int32_t>(verticalAlignment), &result));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Devices::PointOfService::LineDisplayStoredBitmap>{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedLineDisplay2<D>::TryStoreStorageFileBitmapAsync(winrt::Windows::Storage::StorageFile const& bitmap, winrt::Windows::Devices::PointOfService::LineDisplayHorizontalAlignment const& horizontalAlignment, winrt::Windows::Devices::PointOfService::LineDisplayVerticalAlignment const& verticalAlignment, int32_t widthInPixels) const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IClaimedLineDisplay2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IClaimedLineDisplay2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedLineDisplay2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->TryStoreStorageFileBitmapWithAlignmentAndWidthAsync(*(void**)(&bitmap), static_cast<int32_t>(horizontalAlignment), static_cast<int32_t>(verticalAlignment), widthInPixels, &result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedLineDisplay2>**)this;
            check_hresult(_winrt_abi_type->TryStoreStorageFileBitmapWithAlignmentAndWidthAsync(*(void**)(&bitmap), static_cast<int32_t>(horizontalAlignment), static_cast<int32_t>(verticalAlignment), widthInPixels, &result));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Devices::PointOfService::LineDisplayStoredBitmap>{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedLineDisplay3<D>::Closed(winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::Devices::PointOfService::ClaimedLineDisplay, winrt::Windows::Devices::PointOfService::ClaimedLineDisplayClosedEventArgs> const& handler) const
    {
        winrt::event_token token{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IClaimedLineDisplay3>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IClaimedLineDisplay3, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedLineDisplay3>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->add_Closed(*(void**)(&handler), put_abi(token)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedLineDisplay3>**)this;
            check_hresult(_winrt_abi_type->add_Closed(*(void**)(&handler), put_abi(token)));
        }
        return token;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedLineDisplay3<D>::Closed(auto_revoke_t, winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::Devices::PointOfService::ClaimedLineDisplay, winrt::Windows::Devices::PointOfService::ClaimedLineDisplayClosedEventArgs> const& handler) const
    {
        return impl::make_event_revoker<D, Closed_revoker>(this, Closed(handler));
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedLineDisplay3<D>::Closed(winrt::event_token const& token) const noexcept
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IClaimedLineDisplay3>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IClaimedLineDisplay3, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedLineDisplay3>**)&_winrt_casted_result;
            _winrt_abi_type->remove_Closed(impl::bind_in(token));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedLineDisplay3>**)this;
            _winrt_abi_type->remove_Closed(impl::bind_in(token));
        }
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedLineDisplayStatics<D>::FromIdAsync(param::hstring const& deviceId) const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IClaimedLineDisplayStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IClaimedLineDisplayStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedLineDisplayStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->FromIdAsync(*(void**)(&deviceId), &operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedLineDisplayStatics>**)this;
            check_hresult(_winrt_abi_type->FromIdAsync(*(void**)(&deviceId), &operation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Devices::PointOfService::ClaimedLineDisplay>{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedLineDisplayStatics<D>::GetDeviceSelector() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IClaimedLineDisplayStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IClaimedLineDisplayStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedLineDisplayStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetDeviceSelector(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedLineDisplayStatics>**)this;
            check_hresult(_winrt_abi_type->GetDeviceSelector(&result));
        }
        return hstring{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedLineDisplayStatics<D>::GetDeviceSelector(winrt::Windows::Devices::PointOfService::PosConnectionTypes const& connectionTypes) const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IClaimedLineDisplayStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IClaimedLineDisplayStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedLineDisplayStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetDeviceSelectorWithConnectionTypes(static_cast<uint32_t>(connectionTypes), &value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedLineDisplayStatics>**)this;
            check_hresult(_winrt_abi_type->GetDeviceSelectorWithConnectionTypes(static_cast<uint32_t>(connectionTypes), &value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedMagneticStripeReader<D>::DeviceId() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IClaimedMagneticStripeReader>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IClaimedMagneticStripeReader, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedMagneticStripeReader>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_DeviceId(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedMagneticStripeReader>**)this;
            check_hresult(_winrt_abi_type->get_DeviceId(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedMagneticStripeReader<D>::IsEnabled() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IClaimedMagneticStripeReader>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IClaimedMagneticStripeReader, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedMagneticStripeReader>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsEnabled(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedMagneticStripeReader>**)this;
            check_hresult(_winrt_abi_type->get_IsEnabled(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedMagneticStripeReader<D>::IsDisabledOnDataReceived(bool value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IClaimedMagneticStripeReader>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IClaimedMagneticStripeReader, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedMagneticStripeReader>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_IsDisabledOnDataReceived(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedMagneticStripeReader>**)this;
            check_hresult(_winrt_abi_type->put_IsDisabledOnDataReceived(value));
        }
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedMagneticStripeReader<D>::IsDisabledOnDataReceived() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IClaimedMagneticStripeReader>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IClaimedMagneticStripeReader, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedMagneticStripeReader>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsDisabledOnDataReceived(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedMagneticStripeReader>**)this;
            check_hresult(_winrt_abi_type->get_IsDisabledOnDataReceived(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedMagneticStripeReader<D>::IsDecodeDataEnabled(bool value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IClaimedMagneticStripeReader>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IClaimedMagneticStripeReader, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedMagneticStripeReader>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_IsDecodeDataEnabled(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedMagneticStripeReader>**)this;
            check_hresult(_winrt_abi_type->put_IsDecodeDataEnabled(value));
        }
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedMagneticStripeReader<D>::IsDecodeDataEnabled() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IClaimedMagneticStripeReader>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IClaimedMagneticStripeReader, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedMagneticStripeReader>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsDecodeDataEnabled(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedMagneticStripeReader>**)this;
            check_hresult(_winrt_abi_type->get_IsDecodeDataEnabled(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedMagneticStripeReader<D>::IsDeviceAuthenticated() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IClaimedMagneticStripeReader>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IClaimedMagneticStripeReader, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedMagneticStripeReader>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsDeviceAuthenticated(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedMagneticStripeReader>**)this;
            check_hresult(_winrt_abi_type->get_IsDeviceAuthenticated(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedMagneticStripeReader<D>::DataEncryptionAlgorithm(uint32_t value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IClaimedMagneticStripeReader>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IClaimedMagneticStripeReader, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedMagneticStripeReader>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_DataEncryptionAlgorithm(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedMagneticStripeReader>**)this;
            check_hresult(_winrt_abi_type->put_DataEncryptionAlgorithm(value));
        }
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedMagneticStripeReader<D>::DataEncryptionAlgorithm() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IClaimedMagneticStripeReader>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IClaimedMagneticStripeReader, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedMagneticStripeReader>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_DataEncryptionAlgorithm(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedMagneticStripeReader>**)this;
            check_hresult(_winrt_abi_type->get_DataEncryptionAlgorithm(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedMagneticStripeReader<D>::TracksToRead(winrt::Windows::Devices::PointOfService::MagneticStripeReaderTrackIds const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IClaimedMagneticStripeReader>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IClaimedMagneticStripeReader, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedMagneticStripeReader>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_TracksToRead(static_cast<int32_t>(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedMagneticStripeReader>**)this;
            check_hresult(_winrt_abi_type->put_TracksToRead(static_cast<int32_t>(value)));
        }
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedMagneticStripeReader<D>::TracksToRead() const
    {
        winrt::Windows::Devices::PointOfService::MagneticStripeReaderTrackIds value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IClaimedMagneticStripeReader>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IClaimedMagneticStripeReader, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedMagneticStripeReader>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_TracksToRead(reinterpret_cast<int32_t*>(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedMagneticStripeReader>**)this;
            check_hresult(_winrt_abi_type->get_TracksToRead(reinterpret_cast<int32_t*>(&value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedMagneticStripeReader<D>::IsTransmitSentinelsEnabled(bool value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IClaimedMagneticStripeReader>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IClaimedMagneticStripeReader, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedMagneticStripeReader>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_IsTransmitSentinelsEnabled(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedMagneticStripeReader>**)this;
            check_hresult(_winrt_abi_type->put_IsTransmitSentinelsEnabled(value));
        }
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedMagneticStripeReader<D>::IsTransmitSentinelsEnabled() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IClaimedMagneticStripeReader>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IClaimedMagneticStripeReader, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedMagneticStripeReader>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsTransmitSentinelsEnabled(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedMagneticStripeReader>**)this;
            check_hresult(_winrt_abi_type->get_IsTransmitSentinelsEnabled(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedMagneticStripeReader<D>::EnableAsync() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IClaimedMagneticStripeReader>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IClaimedMagneticStripeReader, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedMagneticStripeReader>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->EnableAsync(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedMagneticStripeReader>**)this;
            check_hresult(_winrt_abi_type->EnableAsync(&result));
        }
        return winrt::Windows::Foundation::IAsyncAction{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedMagneticStripeReader<D>::DisableAsync() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IClaimedMagneticStripeReader>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IClaimedMagneticStripeReader, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedMagneticStripeReader>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->DisableAsync(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedMagneticStripeReader>**)this;
            check_hresult(_winrt_abi_type->DisableAsync(&result));
        }
        return winrt::Windows::Foundation::IAsyncAction{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedMagneticStripeReader<D>::RetainDevice() const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IClaimedMagneticStripeReader>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IClaimedMagneticStripeReader, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedMagneticStripeReader>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->RetainDevice());
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedMagneticStripeReader>**)this;
            check_hresult(_winrt_abi_type->RetainDevice());
        }
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedMagneticStripeReader<D>::SetErrorReportingType(winrt::Windows::Devices::PointOfService::MagneticStripeReaderErrorReportingType const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IClaimedMagneticStripeReader>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IClaimedMagneticStripeReader, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedMagneticStripeReader>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->SetErrorReportingType(static_cast<int32_t>(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedMagneticStripeReader>**)this;
            check_hresult(_winrt_abi_type->SetErrorReportingType(static_cast<int32_t>(value)));
        }
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedMagneticStripeReader<D>::RetrieveDeviceAuthenticationDataAsync() const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IClaimedMagneticStripeReader>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IClaimedMagneticStripeReader, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedMagneticStripeReader>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->RetrieveDeviceAuthenticationDataAsync(&operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedMagneticStripeReader>**)this;
            check_hresult(_winrt_abi_type->RetrieveDeviceAuthenticationDataAsync(&operation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Storage::Streams::IBuffer>{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedMagneticStripeReader<D>::AuthenticateDeviceAsync(array_view<uint8_t const> responseToken) const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IClaimedMagneticStripeReader>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IClaimedMagneticStripeReader, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedMagneticStripeReader>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->AuthenticateDeviceAsync(responseToken.size(), get_abi(responseToken), &result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedMagneticStripeReader>**)this;
            check_hresult(_winrt_abi_type->AuthenticateDeviceAsync(responseToken.size(), get_abi(responseToken), &result));
        }
        return winrt::Windows::Foundation::IAsyncAction{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedMagneticStripeReader<D>::DeAuthenticateDeviceAsync(array_view<uint8_t const> responseToken) const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IClaimedMagneticStripeReader>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IClaimedMagneticStripeReader, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedMagneticStripeReader>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->DeAuthenticateDeviceAsync(responseToken.size(), get_abi(responseToken), &result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedMagneticStripeReader>**)this;
            check_hresult(_winrt_abi_type->DeAuthenticateDeviceAsync(responseToken.size(), get_abi(responseToken), &result));
        }
        return winrt::Windows::Foundation::IAsyncAction{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedMagneticStripeReader<D>::UpdateKeyAsync(param::hstring const& key, param::hstring const& keyName) const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IClaimedMagneticStripeReader>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IClaimedMagneticStripeReader, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedMagneticStripeReader>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->UpdateKeyAsync(*(void**)(&key), *(void**)(&keyName), &result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedMagneticStripeReader>**)this;
            check_hresult(_winrt_abi_type->UpdateKeyAsync(*(void**)(&key), *(void**)(&keyName), &result));
        }
        return winrt::Windows::Foundation::IAsyncAction{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedMagneticStripeReader<D>::ResetStatisticsAsync(param::async_iterable<hstring> const& statisticsCategories) const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IClaimedMagneticStripeReader>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IClaimedMagneticStripeReader, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedMagneticStripeReader>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->ResetStatisticsAsync(*(void**)(&statisticsCategories), &result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedMagneticStripeReader>**)this;
            check_hresult(_winrt_abi_type->ResetStatisticsAsync(*(void**)(&statisticsCategories), &result));
        }
        return winrt::Windows::Foundation::IAsyncAction{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedMagneticStripeReader<D>::UpdateStatisticsAsync(param::async_iterable<winrt::Windows::Foundation::Collections::IKeyValuePair<hstring, hstring>> const& statistics) const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IClaimedMagneticStripeReader>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IClaimedMagneticStripeReader, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedMagneticStripeReader>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->UpdateStatisticsAsync(*(void**)(&statistics), &result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedMagneticStripeReader>**)this;
            check_hresult(_winrt_abi_type->UpdateStatisticsAsync(*(void**)(&statistics), &result));
        }
        return winrt::Windows::Foundation::IAsyncAction{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedMagneticStripeReader<D>::BankCardDataReceived(winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::Devices::PointOfService::ClaimedMagneticStripeReader, winrt::Windows::Devices::PointOfService::MagneticStripeReaderBankCardDataReceivedEventArgs> const& handler) const
    {
        winrt::event_token token{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IClaimedMagneticStripeReader>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IClaimedMagneticStripeReader, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedMagneticStripeReader>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->add_BankCardDataReceived(*(void**)(&handler), put_abi(token)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedMagneticStripeReader>**)this;
            check_hresult(_winrt_abi_type->add_BankCardDataReceived(*(void**)(&handler), put_abi(token)));
        }
        return token;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedMagneticStripeReader<D>::BankCardDataReceived(auto_revoke_t, winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::Devices::PointOfService::ClaimedMagneticStripeReader, winrt::Windows::Devices::PointOfService::MagneticStripeReaderBankCardDataReceivedEventArgs> const& handler) const
    {
        return impl::make_event_revoker<D, BankCardDataReceived_revoker>(this, BankCardDataReceived(handler));
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedMagneticStripeReader<D>::BankCardDataReceived(winrt::event_token const& token) const noexcept
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IClaimedMagneticStripeReader>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IClaimedMagneticStripeReader, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedMagneticStripeReader>**)&_winrt_casted_result;
            _winrt_abi_type->remove_BankCardDataReceived(impl::bind_in(token));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedMagneticStripeReader>**)this;
            _winrt_abi_type->remove_BankCardDataReceived(impl::bind_in(token));
        }
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedMagneticStripeReader<D>::AamvaCardDataReceived(winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::Devices::PointOfService::ClaimedMagneticStripeReader, winrt::Windows::Devices::PointOfService::MagneticStripeReaderAamvaCardDataReceivedEventArgs> const& handler) const
    {
        winrt::event_token token{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IClaimedMagneticStripeReader>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IClaimedMagneticStripeReader, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedMagneticStripeReader>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->add_AamvaCardDataReceived(*(void**)(&handler), put_abi(token)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedMagneticStripeReader>**)this;
            check_hresult(_winrt_abi_type->add_AamvaCardDataReceived(*(void**)(&handler), put_abi(token)));
        }
        return token;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedMagneticStripeReader<D>::AamvaCardDataReceived(auto_revoke_t, winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::Devices::PointOfService::ClaimedMagneticStripeReader, winrt::Windows::Devices::PointOfService::MagneticStripeReaderAamvaCardDataReceivedEventArgs> const& handler) const
    {
        return impl::make_event_revoker<D, AamvaCardDataReceived_revoker>(this, AamvaCardDataReceived(handler));
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedMagneticStripeReader<D>::AamvaCardDataReceived(winrt::event_token const& token) const noexcept
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IClaimedMagneticStripeReader>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IClaimedMagneticStripeReader, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedMagneticStripeReader>**)&_winrt_casted_result;
            _winrt_abi_type->remove_AamvaCardDataReceived(impl::bind_in(token));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedMagneticStripeReader>**)this;
            _winrt_abi_type->remove_AamvaCardDataReceived(impl::bind_in(token));
        }
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedMagneticStripeReader<D>::VendorSpecificDataReceived(winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::Devices::PointOfService::ClaimedMagneticStripeReader, winrt::Windows::Devices::PointOfService::MagneticStripeReaderVendorSpecificCardDataReceivedEventArgs> const& handler) const
    {
        winrt::event_token token{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IClaimedMagneticStripeReader>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IClaimedMagneticStripeReader, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedMagneticStripeReader>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->add_VendorSpecificDataReceived(*(void**)(&handler), put_abi(token)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedMagneticStripeReader>**)this;
            check_hresult(_winrt_abi_type->add_VendorSpecificDataReceived(*(void**)(&handler), put_abi(token)));
        }
        return token;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedMagneticStripeReader<D>::VendorSpecificDataReceived(auto_revoke_t, winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::Devices::PointOfService::ClaimedMagneticStripeReader, winrt::Windows::Devices::PointOfService::MagneticStripeReaderVendorSpecificCardDataReceivedEventArgs> const& handler) const
    {
        return impl::make_event_revoker<D, VendorSpecificDataReceived_revoker>(this, VendorSpecificDataReceived(handler));
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedMagneticStripeReader<D>::VendorSpecificDataReceived(winrt::event_token const& token) const noexcept
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IClaimedMagneticStripeReader>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IClaimedMagneticStripeReader, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedMagneticStripeReader>**)&_winrt_casted_result;
            _winrt_abi_type->remove_VendorSpecificDataReceived(impl::bind_in(token));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedMagneticStripeReader>**)this;
            _winrt_abi_type->remove_VendorSpecificDataReceived(impl::bind_in(token));
        }
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedMagneticStripeReader<D>::ReleaseDeviceRequested(winrt::Windows::Foundation::EventHandler<winrt::Windows::Devices::PointOfService::ClaimedMagneticStripeReader> const& handler) const
    {
        winrt::event_token token{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IClaimedMagneticStripeReader>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IClaimedMagneticStripeReader, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedMagneticStripeReader>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->add_ReleaseDeviceRequested(*(void**)(&handler), put_abi(token)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedMagneticStripeReader>**)this;
            check_hresult(_winrt_abi_type->add_ReleaseDeviceRequested(*(void**)(&handler), put_abi(token)));
        }
        return token;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedMagneticStripeReader<D>::ReleaseDeviceRequested(auto_revoke_t, winrt::Windows::Foundation::EventHandler<winrt::Windows::Devices::PointOfService::ClaimedMagneticStripeReader> const& handler) const
    {
        return impl::make_event_revoker<D, ReleaseDeviceRequested_revoker>(this, ReleaseDeviceRequested(handler));
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedMagneticStripeReader<D>::ReleaseDeviceRequested(winrt::event_token const& token) const noexcept
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IClaimedMagneticStripeReader>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IClaimedMagneticStripeReader, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedMagneticStripeReader>**)&_winrt_casted_result;
            _winrt_abi_type->remove_ReleaseDeviceRequested(impl::bind_in(token));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedMagneticStripeReader>**)this;
            _winrt_abi_type->remove_ReleaseDeviceRequested(impl::bind_in(token));
        }
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedMagneticStripeReader<D>::ErrorOccurred(winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::Devices::PointOfService::ClaimedMagneticStripeReader, winrt::Windows::Devices::PointOfService::MagneticStripeReaderErrorOccurredEventArgs> const& handler) const
    {
        winrt::event_token token{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IClaimedMagneticStripeReader>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IClaimedMagneticStripeReader, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedMagneticStripeReader>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->add_ErrorOccurred(*(void**)(&handler), put_abi(token)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedMagneticStripeReader>**)this;
            check_hresult(_winrt_abi_type->add_ErrorOccurred(*(void**)(&handler), put_abi(token)));
        }
        return token;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedMagneticStripeReader<D>::ErrorOccurred(auto_revoke_t, winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::Devices::PointOfService::ClaimedMagneticStripeReader, winrt::Windows::Devices::PointOfService::MagneticStripeReaderErrorOccurredEventArgs> const& handler) const
    {
        return impl::make_event_revoker<D, ErrorOccurred_revoker>(this, ErrorOccurred(handler));
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedMagneticStripeReader<D>::ErrorOccurred(winrt::event_token const& token) const noexcept
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IClaimedMagneticStripeReader>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IClaimedMagneticStripeReader, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedMagneticStripeReader>**)&_winrt_casted_result;
            _winrt_abi_type->remove_ErrorOccurred(impl::bind_in(token));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedMagneticStripeReader>**)this;
            _winrt_abi_type->remove_ErrorOccurred(impl::bind_in(token));
        }
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedMagneticStripeReader2<D>::Closed(winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::Devices::PointOfService::ClaimedMagneticStripeReader, winrt::Windows::Devices::PointOfService::ClaimedMagneticStripeReaderClosedEventArgs> const& handler) const
    {
        winrt::event_token token{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IClaimedMagneticStripeReader2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IClaimedMagneticStripeReader2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedMagneticStripeReader2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->add_Closed(*(void**)(&handler), put_abi(token)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedMagneticStripeReader2>**)this;
            check_hresult(_winrt_abi_type->add_Closed(*(void**)(&handler), put_abi(token)));
        }
        return token;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedMagneticStripeReader2<D>::Closed(auto_revoke_t, winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::Devices::PointOfService::ClaimedMagneticStripeReader, winrt::Windows::Devices::PointOfService::ClaimedMagneticStripeReaderClosedEventArgs> const& handler) const
    {
        return impl::make_event_revoker<D, Closed_revoker>(this, Closed(handler));
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedMagneticStripeReader2<D>::Closed(winrt::event_token const& token) const noexcept
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IClaimedMagneticStripeReader2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IClaimedMagneticStripeReader2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedMagneticStripeReader2>**)&_winrt_casted_result;
            _winrt_abi_type->remove_Closed(impl::bind_in(token));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedMagneticStripeReader2>**)this;
            _winrt_abi_type->remove_Closed(impl::bind_in(token));
        }
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedPosPrinter<D>::DeviceId() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IClaimedPosPrinter>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IClaimedPosPrinter, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedPosPrinter>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_DeviceId(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedPosPrinter>**)this;
            check_hresult(_winrt_abi_type->get_DeviceId(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedPosPrinter<D>::IsEnabled() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IClaimedPosPrinter>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IClaimedPosPrinter, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedPosPrinter>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsEnabled(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedPosPrinter>**)this;
            check_hresult(_winrt_abi_type->get_IsEnabled(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedPosPrinter<D>::CharacterSet(uint32_t value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IClaimedPosPrinter>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IClaimedPosPrinter, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedPosPrinter>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_CharacterSet(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedPosPrinter>**)this;
            check_hresult(_winrt_abi_type->put_CharacterSet(value));
        }
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedPosPrinter<D>::CharacterSet() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IClaimedPosPrinter>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IClaimedPosPrinter, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedPosPrinter>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_CharacterSet(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedPosPrinter>**)this;
            check_hresult(_winrt_abi_type->get_CharacterSet(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedPosPrinter<D>::IsCoverOpen() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IClaimedPosPrinter>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IClaimedPosPrinter, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedPosPrinter>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsCoverOpen(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedPosPrinter>**)this;
            check_hresult(_winrt_abi_type->get_IsCoverOpen(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedPosPrinter<D>::IsCharacterSetMappingEnabled(bool value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IClaimedPosPrinter>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IClaimedPosPrinter, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedPosPrinter>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_IsCharacterSetMappingEnabled(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedPosPrinter>**)this;
            check_hresult(_winrt_abi_type->put_IsCharacterSetMappingEnabled(value));
        }
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedPosPrinter<D>::IsCharacterSetMappingEnabled() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IClaimedPosPrinter>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IClaimedPosPrinter, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedPosPrinter>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsCharacterSetMappingEnabled(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedPosPrinter>**)this;
            check_hresult(_winrt_abi_type->get_IsCharacterSetMappingEnabled(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedPosPrinter<D>::MapMode(winrt::Windows::Devices::PointOfService::PosPrinterMapMode const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IClaimedPosPrinter>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IClaimedPosPrinter, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedPosPrinter>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_MapMode(static_cast<int32_t>(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedPosPrinter>**)this;
            check_hresult(_winrt_abi_type->put_MapMode(static_cast<int32_t>(value)));
        }
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedPosPrinter<D>::MapMode() const
    {
        winrt::Windows::Devices::PointOfService::PosPrinterMapMode value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IClaimedPosPrinter>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IClaimedPosPrinter, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedPosPrinter>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_MapMode(reinterpret_cast<int32_t*>(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedPosPrinter>**)this;
            check_hresult(_winrt_abi_type->get_MapMode(reinterpret_cast<int32_t*>(&value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedPosPrinter<D>::Receipt() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IClaimedPosPrinter>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IClaimedPosPrinter, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedPosPrinter>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Receipt(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedPosPrinter>**)this;
            check_hresult(_winrt_abi_type->get_Receipt(&value));
        }
        return winrt::Windows::Devices::PointOfService::ClaimedReceiptPrinter{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedPosPrinter<D>::Slip() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IClaimedPosPrinter>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IClaimedPosPrinter, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedPosPrinter>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Slip(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedPosPrinter>**)this;
            check_hresult(_winrt_abi_type->get_Slip(&value));
        }
        return winrt::Windows::Devices::PointOfService::ClaimedSlipPrinter{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedPosPrinter<D>::Journal() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IClaimedPosPrinter>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IClaimedPosPrinter, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedPosPrinter>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Journal(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedPosPrinter>**)this;
            check_hresult(_winrt_abi_type->get_Journal(&value));
        }
        return winrt::Windows::Devices::PointOfService::ClaimedJournalPrinter{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedPosPrinter<D>::EnableAsync() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IClaimedPosPrinter>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IClaimedPosPrinter, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedPosPrinter>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->EnableAsync(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedPosPrinter>**)this;
            check_hresult(_winrt_abi_type->EnableAsync(&result));
        }
        return winrt::Windows::Foundation::IAsyncOperation<bool>{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedPosPrinter<D>::DisableAsync() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IClaimedPosPrinter>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IClaimedPosPrinter, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedPosPrinter>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->DisableAsync(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedPosPrinter>**)this;
            check_hresult(_winrt_abi_type->DisableAsync(&result));
        }
        return winrt::Windows::Foundation::IAsyncOperation<bool>{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedPosPrinter<D>::RetainDeviceAsync() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IClaimedPosPrinter>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IClaimedPosPrinter, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedPosPrinter>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->RetainDeviceAsync(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedPosPrinter>**)this;
            check_hresult(_winrt_abi_type->RetainDeviceAsync(&result));
        }
        return winrt::Windows::Foundation::IAsyncOperation<bool>{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedPosPrinter<D>::ResetStatisticsAsync(param::async_iterable<hstring> const& statisticsCategories) const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IClaimedPosPrinter>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IClaimedPosPrinter, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedPosPrinter>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->ResetStatisticsAsync(*(void**)(&statisticsCategories), &result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedPosPrinter>**)this;
            check_hresult(_winrt_abi_type->ResetStatisticsAsync(*(void**)(&statisticsCategories), &result));
        }
        return winrt::Windows::Foundation::IAsyncOperation<bool>{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedPosPrinter<D>::UpdateStatisticsAsync(param::async_iterable<winrt::Windows::Foundation::Collections::IKeyValuePair<hstring, hstring>> const& statistics) const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IClaimedPosPrinter>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IClaimedPosPrinter, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedPosPrinter>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->UpdateStatisticsAsync(*(void**)(&statistics), &result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedPosPrinter>**)this;
            check_hresult(_winrt_abi_type->UpdateStatisticsAsync(*(void**)(&statistics), &result));
        }
        return winrt::Windows::Foundation::IAsyncOperation<bool>{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedPosPrinter<D>::ReleaseDeviceRequested(winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::Devices::PointOfService::ClaimedPosPrinter, winrt::Windows::Devices::PointOfService::PosPrinterReleaseDeviceRequestedEventArgs> const& handler) const
    {
        winrt::event_token token{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IClaimedPosPrinter>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IClaimedPosPrinter, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedPosPrinter>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->add_ReleaseDeviceRequested(*(void**)(&handler), put_abi(token)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedPosPrinter>**)this;
            check_hresult(_winrt_abi_type->add_ReleaseDeviceRequested(*(void**)(&handler), put_abi(token)));
        }
        return token;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedPosPrinter<D>::ReleaseDeviceRequested(auto_revoke_t, winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::Devices::PointOfService::ClaimedPosPrinter, winrt::Windows::Devices::PointOfService::PosPrinterReleaseDeviceRequestedEventArgs> const& handler) const
    {
        return impl::make_event_revoker<D, ReleaseDeviceRequested_revoker>(this, ReleaseDeviceRequested(handler));
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedPosPrinter<D>::ReleaseDeviceRequested(winrt::event_token const& token) const noexcept
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IClaimedPosPrinter>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IClaimedPosPrinter, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedPosPrinter>**)&_winrt_casted_result;
            _winrt_abi_type->remove_ReleaseDeviceRequested(impl::bind_in(token));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedPosPrinter>**)this;
            _winrt_abi_type->remove_ReleaseDeviceRequested(impl::bind_in(token));
        }
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedPosPrinter2<D>::Closed(winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::Devices::PointOfService::ClaimedPosPrinter, winrt::Windows::Devices::PointOfService::ClaimedPosPrinterClosedEventArgs> const& handler) const
    {
        winrt::event_token token{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IClaimedPosPrinter2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IClaimedPosPrinter2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedPosPrinter2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->add_Closed(*(void**)(&handler), put_abi(token)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedPosPrinter2>**)this;
            check_hresult(_winrt_abi_type->add_Closed(*(void**)(&handler), put_abi(token)));
        }
        return token;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedPosPrinter2<D>::Closed(auto_revoke_t, winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::Devices::PointOfService::ClaimedPosPrinter, winrt::Windows::Devices::PointOfService::ClaimedPosPrinterClosedEventArgs> const& handler) const
    {
        return impl::make_event_revoker<D, Closed_revoker>(this, Closed(handler));
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedPosPrinter2<D>::Closed(winrt::event_token const& token) const noexcept
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IClaimedPosPrinter2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IClaimedPosPrinter2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedPosPrinter2>**)&_winrt_casted_result;
            _winrt_abi_type->remove_Closed(impl::bind_in(token));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedPosPrinter2>**)this;
            _winrt_abi_type->remove_Closed(impl::bind_in(token));
        }
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedReceiptPrinter<D>::SidewaysMaxLines() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IClaimedReceiptPrinter>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IClaimedReceiptPrinter, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedReceiptPrinter>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_SidewaysMaxLines(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedReceiptPrinter>**)this;
            check_hresult(_winrt_abi_type->get_SidewaysMaxLines(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedReceiptPrinter<D>::SidewaysMaxChars() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IClaimedReceiptPrinter>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IClaimedReceiptPrinter, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedReceiptPrinter>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_SidewaysMaxChars(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedReceiptPrinter>**)this;
            check_hresult(_winrt_abi_type->get_SidewaysMaxChars(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedReceiptPrinter<D>::LinesToPaperCut() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IClaimedReceiptPrinter>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IClaimedReceiptPrinter, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedReceiptPrinter>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_LinesToPaperCut(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedReceiptPrinter>**)this;
            check_hresult(_winrt_abi_type->get_LinesToPaperCut(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedReceiptPrinter<D>::PageSize() const
    {
        winrt::Windows::Foundation::Size value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IClaimedReceiptPrinter>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IClaimedReceiptPrinter, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedReceiptPrinter>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_PageSize(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedReceiptPrinter>**)this;
            check_hresult(_winrt_abi_type->get_PageSize(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedReceiptPrinter<D>::PrintArea() const
    {
        winrt::Windows::Foundation::Rect value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IClaimedReceiptPrinter>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IClaimedReceiptPrinter, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedReceiptPrinter>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_PrintArea(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedReceiptPrinter>**)this;
            check_hresult(_winrt_abi_type->get_PrintArea(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedReceiptPrinter<D>::CreateJob() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IClaimedReceiptPrinter>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IClaimedReceiptPrinter, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedReceiptPrinter>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateJob(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedReceiptPrinter>**)this;
            check_hresult(_winrt_abi_type->CreateJob(&value));
        }
        return winrt::Windows::Devices::PointOfService::ReceiptPrintJob{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedSlipPrinter<D>::SidewaysMaxLines() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IClaimedSlipPrinter>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IClaimedSlipPrinter, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedSlipPrinter>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_SidewaysMaxLines(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedSlipPrinter>**)this;
            check_hresult(_winrt_abi_type->get_SidewaysMaxLines(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedSlipPrinter<D>::SidewaysMaxChars() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IClaimedSlipPrinter>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IClaimedSlipPrinter, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedSlipPrinter>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_SidewaysMaxChars(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedSlipPrinter>**)this;
            check_hresult(_winrt_abi_type->get_SidewaysMaxChars(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedSlipPrinter<D>::MaxLines() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IClaimedSlipPrinter>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IClaimedSlipPrinter, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedSlipPrinter>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_MaxLines(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedSlipPrinter>**)this;
            check_hresult(_winrt_abi_type->get_MaxLines(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedSlipPrinter<D>::LinesNearEndToEnd() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IClaimedSlipPrinter>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IClaimedSlipPrinter, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedSlipPrinter>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_LinesNearEndToEnd(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedSlipPrinter>**)this;
            check_hresult(_winrt_abi_type->get_LinesNearEndToEnd(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedSlipPrinter<D>::PrintSide() const
    {
        winrt::Windows::Devices::PointOfService::PosPrinterPrintSide value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IClaimedSlipPrinter>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IClaimedSlipPrinter, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedSlipPrinter>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_PrintSide(reinterpret_cast<int32_t*>(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedSlipPrinter>**)this;
            check_hresult(_winrt_abi_type->get_PrintSide(reinterpret_cast<int32_t*>(&value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedSlipPrinter<D>::PageSize() const
    {
        winrt::Windows::Foundation::Size value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IClaimedSlipPrinter>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IClaimedSlipPrinter, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedSlipPrinter>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_PageSize(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedSlipPrinter>**)this;
            check_hresult(_winrt_abi_type->get_PageSize(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedSlipPrinter<D>::PrintArea() const
    {
        winrt::Windows::Foundation::Rect value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IClaimedSlipPrinter>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IClaimedSlipPrinter, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedSlipPrinter>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_PrintArea(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedSlipPrinter>**)this;
            check_hresult(_winrt_abi_type->get_PrintArea(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedSlipPrinter<D>::OpenJaws() const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IClaimedSlipPrinter>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IClaimedSlipPrinter, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedSlipPrinter>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->OpenJaws());
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedSlipPrinter>**)this;
            check_hresult(_winrt_abi_type->OpenJaws());
        }
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedSlipPrinter<D>::CloseJaws() const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IClaimedSlipPrinter>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IClaimedSlipPrinter, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedSlipPrinter>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CloseJaws());
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedSlipPrinter>**)this;
            check_hresult(_winrt_abi_type->CloseJaws());
        }
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedSlipPrinter<D>::InsertSlipAsync(winrt::Windows::Foundation::TimeSpan const& timeout) const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IClaimedSlipPrinter>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IClaimedSlipPrinter, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedSlipPrinter>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->InsertSlipAsync(impl::bind_in(timeout), &result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedSlipPrinter>**)this;
            check_hresult(_winrt_abi_type->InsertSlipAsync(impl::bind_in(timeout), &result));
        }
        return winrt::Windows::Foundation::IAsyncOperation<bool>{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedSlipPrinter<D>::RemoveSlipAsync(winrt::Windows::Foundation::TimeSpan const& timeout) const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IClaimedSlipPrinter>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IClaimedSlipPrinter, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedSlipPrinter>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->RemoveSlipAsync(impl::bind_in(timeout), &result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedSlipPrinter>**)this;
            check_hresult(_winrt_abi_type->RemoveSlipAsync(impl::bind_in(timeout), &result));
        }
        return winrt::Windows::Foundation::IAsyncOperation<bool>{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedSlipPrinter<D>::ChangePrintSide(winrt::Windows::Devices::PointOfService::PosPrinterPrintSide const& printSide) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IClaimedSlipPrinter>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IClaimedSlipPrinter, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedSlipPrinter>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->ChangePrintSide(static_cast<int32_t>(printSide)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedSlipPrinter>**)this;
            check_hresult(_winrt_abi_type->ChangePrintSide(static_cast<int32_t>(printSide)));
        }
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IClaimedSlipPrinter<D>::CreateJob() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IClaimedSlipPrinter>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IClaimedSlipPrinter, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedSlipPrinter>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateJob(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IClaimedSlipPrinter>**)this;
            check_hresult(_winrt_abi_type->CreateJob(&value));
        }
        return winrt::Windows::Devices::PointOfService::SlipPrintJob{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ICommonClaimedPosPrinterStation<D>::CharactersPerLine(uint32_t value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ICommonClaimedPosPrinterStation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ICommonClaimedPosPrinterStation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ICommonClaimedPosPrinterStation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_CharactersPerLine(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ICommonClaimedPosPrinterStation>**)this;
            check_hresult(_winrt_abi_type->put_CharactersPerLine(value));
        }
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ICommonClaimedPosPrinterStation<D>::CharactersPerLine() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ICommonClaimedPosPrinterStation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ICommonClaimedPosPrinterStation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ICommonClaimedPosPrinterStation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_CharactersPerLine(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ICommonClaimedPosPrinterStation>**)this;
            check_hresult(_winrt_abi_type->get_CharactersPerLine(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ICommonClaimedPosPrinterStation<D>::LineHeight(uint32_t value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ICommonClaimedPosPrinterStation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ICommonClaimedPosPrinterStation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ICommonClaimedPosPrinterStation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_LineHeight(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ICommonClaimedPosPrinterStation>**)this;
            check_hresult(_winrt_abi_type->put_LineHeight(value));
        }
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ICommonClaimedPosPrinterStation<D>::LineHeight() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ICommonClaimedPosPrinterStation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ICommonClaimedPosPrinterStation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ICommonClaimedPosPrinterStation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_LineHeight(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ICommonClaimedPosPrinterStation>**)this;
            check_hresult(_winrt_abi_type->get_LineHeight(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ICommonClaimedPosPrinterStation<D>::LineSpacing(uint32_t value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ICommonClaimedPosPrinterStation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ICommonClaimedPosPrinterStation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ICommonClaimedPosPrinterStation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_LineSpacing(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ICommonClaimedPosPrinterStation>**)this;
            check_hresult(_winrt_abi_type->put_LineSpacing(value));
        }
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ICommonClaimedPosPrinterStation<D>::LineSpacing() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ICommonClaimedPosPrinterStation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ICommonClaimedPosPrinterStation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ICommonClaimedPosPrinterStation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_LineSpacing(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ICommonClaimedPosPrinterStation>**)this;
            check_hresult(_winrt_abi_type->get_LineSpacing(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ICommonClaimedPosPrinterStation<D>::LineWidth() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ICommonClaimedPosPrinterStation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ICommonClaimedPosPrinterStation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ICommonClaimedPosPrinterStation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_LineWidth(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ICommonClaimedPosPrinterStation>**)this;
            check_hresult(_winrt_abi_type->get_LineWidth(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ICommonClaimedPosPrinterStation<D>::IsLetterQuality(bool value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ICommonClaimedPosPrinterStation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ICommonClaimedPosPrinterStation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ICommonClaimedPosPrinterStation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_IsLetterQuality(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ICommonClaimedPosPrinterStation>**)this;
            check_hresult(_winrt_abi_type->put_IsLetterQuality(value));
        }
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ICommonClaimedPosPrinterStation<D>::IsLetterQuality() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ICommonClaimedPosPrinterStation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ICommonClaimedPosPrinterStation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ICommonClaimedPosPrinterStation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsLetterQuality(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ICommonClaimedPosPrinterStation>**)this;
            check_hresult(_winrt_abi_type->get_IsLetterQuality(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ICommonClaimedPosPrinterStation<D>::IsPaperNearEnd() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ICommonClaimedPosPrinterStation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ICommonClaimedPosPrinterStation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ICommonClaimedPosPrinterStation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsPaperNearEnd(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ICommonClaimedPosPrinterStation>**)this;
            check_hresult(_winrt_abi_type->get_IsPaperNearEnd(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ICommonClaimedPosPrinterStation<D>::ColorCartridge(winrt::Windows::Devices::PointOfService::PosPrinterColorCartridge const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ICommonClaimedPosPrinterStation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ICommonClaimedPosPrinterStation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ICommonClaimedPosPrinterStation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_ColorCartridge(static_cast<int32_t>(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ICommonClaimedPosPrinterStation>**)this;
            check_hresult(_winrt_abi_type->put_ColorCartridge(static_cast<int32_t>(value)));
        }
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ICommonClaimedPosPrinterStation<D>::ColorCartridge() const
    {
        winrt::Windows::Devices::PointOfService::PosPrinterColorCartridge value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ICommonClaimedPosPrinterStation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ICommonClaimedPosPrinterStation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ICommonClaimedPosPrinterStation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ColorCartridge(reinterpret_cast<int32_t*>(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ICommonClaimedPosPrinterStation>**)this;
            check_hresult(_winrt_abi_type->get_ColorCartridge(reinterpret_cast<int32_t*>(&value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ICommonClaimedPosPrinterStation<D>::IsCoverOpen() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ICommonClaimedPosPrinterStation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ICommonClaimedPosPrinterStation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ICommonClaimedPosPrinterStation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsCoverOpen(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ICommonClaimedPosPrinterStation>**)this;
            check_hresult(_winrt_abi_type->get_IsCoverOpen(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ICommonClaimedPosPrinterStation<D>::IsCartridgeRemoved() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ICommonClaimedPosPrinterStation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ICommonClaimedPosPrinterStation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ICommonClaimedPosPrinterStation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsCartridgeRemoved(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ICommonClaimedPosPrinterStation>**)this;
            check_hresult(_winrt_abi_type->get_IsCartridgeRemoved(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ICommonClaimedPosPrinterStation<D>::IsCartridgeEmpty() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ICommonClaimedPosPrinterStation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ICommonClaimedPosPrinterStation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ICommonClaimedPosPrinterStation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsCartridgeEmpty(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ICommonClaimedPosPrinterStation>**)this;
            check_hresult(_winrt_abi_type->get_IsCartridgeEmpty(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ICommonClaimedPosPrinterStation<D>::IsHeadCleaning() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ICommonClaimedPosPrinterStation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ICommonClaimedPosPrinterStation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ICommonClaimedPosPrinterStation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsHeadCleaning(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ICommonClaimedPosPrinterStation>**)this;
            check_hresult(_winrt_abi_type->get_IsHeadCleaning(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ICommonClaimedPosPrinterStation<D>::IsPaperEmpty() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ICommonClaimedPosPrinterStation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ICommonClaimedPosPrinterStation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ICommonClaimedPosPrinterStation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsPaperEmpty(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ICommonClaimedPosPrinterStation>**)this;
            check_hresult(_winrt_abi_type->get_IsPaperEmpty(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ICommonClaimedPosPrinterStation<D>::IsReadyToPrint() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ICommonClaimedPosPrinterStation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ICommonClaimedPosPrinterStation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ICommonClaimedPosPrinterStation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsReadyToPrint(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ICommonClaimedPosPrinterStation>**)this;
            check_hresult(_winrt_abi_type->get_IsReadyToPrint(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ICommonClaimedPosPrinterStation<D>::ValidateData(param::hstring const& data) const
    {
        bool result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ICommonClaimedPosPrinterStation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ICommonClaimedPosPrinterStation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ICommonClaimedPosPrinterStation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->ValidateData(*(void**)(&data), &result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ICommonClaimedPosPrinterStation>**)this;
            check_hresult(_winrt_abi_type->ValidateData(*(void**)(&data), &result));
        }
        return result;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ICommonPosPrintStationCapabilities<D>::IsPrinterPresent() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ICommonPosPrintStationCapabilities>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ICommonPosPrintStationCapabilities, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ICommonPosPrintStationCapabilities>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsPrinterPresent(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ICommonPosPrintStationCapabilities>**)this;
            check_hresult(_winrt_abi_type->get_IsPrinterPresent(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ICommonPosPrintStationCapabilities<D>::IsDualColorSupported() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ICommonPosPrintStationCapabilities>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ICommonPosPrintStationCapabilities, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ICommonPosPrintStationCapabilities>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsDualColorSupported(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ICommonPosPrintStationCapabilities>**)this;
            check_hresult(_winrt_abi_type->get_IsDualColorSupported(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ICommonPosPrintStationCapabilities<D>::ColorCartridgeCapabilities() const
    {
        winrt::Windows::Devices::PointOfService::PosPrinterColorCapabilities value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ICommonPosPrintStationCapabilities>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ICommonPosPrintStationCapabilities, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ICommonPosPrintStationCapabilities>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ColorCartridgeCapabilities(reinterpret_cast<uint32_t*>(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ICommonPosPrintStationCapabilities>**)this;
            check_hresult(_winrt_abi_type->get_ColorCartridgeCapabilities(reinterpret_cast<uint32_t*>(&value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ICommonPosPrintStationCapabilities<D>::CartridgeSensors() const
    {
        winrt::Windows::Devices::PointOfService::PosPrinterCartridgeSensors value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ICommonPosPrintStationCapabilities>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ICommonPosPrintStationCapabilities, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ICommonPosPrintStationCapabilities>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_CartridgeSensors(reinterpret_cast<uint32_t*>(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ICommonPosPrintStationCapabilities>**)this;
            check_hresult(_winrt_abi_type->get_CartridgeSensors(reinterpret_cast<uint32_t*>(&value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ICommonPosPrintStationCapabilities<D>::IsBoldSupported() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ICommonPosPrintStationCapabilities>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ICommonPosPrintStationCapabilities, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ICommonPosPrintStationCapabilities>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsBoldSupported(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ICommonPosPrintStationCapabilities>**)this;
            check_hresult(_winrt_abi_type->get_IsBoldSupported(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ICommonPosPrintStationCapabilities<D>::IsItalicSupported() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ICommonPosPrintStationCapabilities>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ICommonPosPrintStationCapabilities, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ICommonPosPrintStationCapabilities>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsItalicSupported(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ICommonPosPrintStationCapabilities>**)this;
            check_hresult(_winrt_abi_type->get_IsItalicSupported(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ICommonPosPrintStationCapabilities<D>::IsUnderlineSupported() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ICommonPosPrintStationCapabilities>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ICommonPosPrintStationCapabilities, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ICommonPosPrintStationCapabilities>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsUnderlineSupported(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ICommonPosPrintStationCapabilities>**)this;
            check_hresult(_winrt_abi_type->get_IsUnderlineSupported(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ICommonPosPrintStationCapabilities<D>::IsDoubleHighPrintSupported() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ICommonPosPrintStationCapabilities>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ICommonPosPrintStationCapabilities, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ICommonPosPrintStationCapabilities>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsDoubleHighPrintSupported(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ICommonPosPrintStationCapabilities>**)this;
            check_hresult(_winrt_abi_type->get_IsDoubleHighPrintSupported(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ICommonPosPrintStationCapabilities<D>::IsDoubleWidePrintSupported() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ICommonPosPrintStationCapabilities>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ICommonPosPrintStationCapabilities, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ICommonPosPrintStationCapabilities>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsDoubleWidePrintSupported(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ICommonPosPrintStationCapabilities>**)this;
            check_hresult(_winrt_abi_type->get_IsDoubleWidePrintSupported(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ICommonPosPrintStationCapabilities<D>::IsDoubleHighDoubleWidePrintSupported() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ICommonPosPrintStationCapabilities>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ICommonPosPrintStationCapabilities, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ICommonPosPrintStationCapabilities>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsDoubleHighDoubleWidePrintSupported(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ICommonPosPrintStationCapabilities>**)this;
            check_hresult(_winrt_abi_type->get_IsDoubleHighDoubleWidePrintSupported(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ICommonPosPrintStationCapabilities<D>::IsPaperEmptySensorSupported() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ICommonPosPrintStationCapabilities>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ICommonPosPrintStationCapabilities, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ICommonPosPrintStationCapabilities>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsPaperEmptySensorSupported(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ICommonPosPrintStationCapabilities>**)this;
            check_hresult(_winrt_abi_type->get_IsPaperEmptySensorSupported(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ICommonPosPrintStationCapabilities<D>::IsPaperNearEndSensorSupported() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ICommonPosPrintStationCapabilities>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ICommonPosPrintStationCapabilities, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ICommonPosPrintStationCapabilities>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsPaperNearEndSensorSupported(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ICommonPosPrintStationCapabilities>**)this;
            check_hresult(_winrt_abi_type->get_IsPaperNearEndSensorSupported(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ICommonPosPrintStationCapabilities<D>::SupportedCharactersPerLine() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ICommonPosPrintStationCapabilities>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ICommonPosPrintStationCapabilities, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ICommonPosPrintStationCapabilities>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_SupportedCharactersPerLine(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ICommonPosPrintStationCapabilities>**)this;
            check_hresult(_winrt_abi_type->get_SupportedCharactersPerLine(&value));
        }
        return winrt::Windows::Foundation::Collections::IVectorView<uint32_t>{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ICommonReceiptSlipCapabilities<D>::IsBarcodeSupported() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ICommonReceiptSlipCapabilities>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ICommonReceiptSlipCapabilities, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ICommonReceiptSlipCapabilities>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsBarcodeSupported(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ICommonReceiptSlipCapabilities>**)this;
            check_hresult(_winrt_abi_type->get_IsBarcodeSupported(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ICommonReceiptSlipCapabilities<D>::IsBitmapSupported() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ICommonReceiptSlipCapabilities>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ICommonReceiptSlipCapabilities, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ICommonReceiptSlipCapabilities>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsBitmapSupported(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ICommonReceiptSlipCapabilities>**)this;
            check_hresult(_winrt_abi_type->get_IsBitmapSupported(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ICommonReceiptSlipCapabilities<D>::IsLeft90RotationSupported() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ICommonReceiptSlipCapabilities>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ICommonReceiptSlipCapabilities, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ICommonReceiptSlipCapabilities>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsLeft90RotationSupported(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ICommonReceiptSlipCapabilities>**)this;
            check_hresult(_winrt_abi_type->get_IsLeft90RotationSupported(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ICommonReceiptSlipCapabilities<D>::IsRight90RotationSupported() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ICommonReceiptSlipCapabilities>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ICommonReceiptSlipCapabilities, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ICommonReceiptSlipCapabilities>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsRight90RotationSupported(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ICommonReceiptSlipCapabilities>**)this;
            check_hresult(_winrt_abi_type->get_IsRight90RotationSupported(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ICommonReceiptSlipCapabilities<D>::Is180RotationSupported() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ICommonReceiptSlipCapabilities>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ICommonReceiptSlipCapabilities, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ICommonReceiptSlipCapabilities>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Is180RotationSupported(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ICommonReceiptSlipCapabilities>**)this;
            check_hresult(_winrt_abi_type->get_Is180RotationSupported(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ICommonReceiptSlipCapabilities<D>::IsPrintAreaSupported() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ICommonReceiptSlipCapabilities>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ICommonReceiptSlipCapabilities, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ICommonReceiptSlipCapabilities>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsPrintAreaSupported(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ICommonReceiptSlipCapabilities>**)this;
            check_hresult(_winrt_abi_type->get_IsPrintAreaSupported(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ICommonReceiptSlipCapabilities<D>::RuledLineCapabilities() const
    {
        winrt::Windows::Devices::PointOfService::PosPrinterRuledLineCapabilities value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ICommonReceiptSlipCapabilities>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ICommonReceiptSlipCapabilities, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ICommonReceiptSlipCapabilities>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_RuledLineCapabilities(reinterpret_cast<uint32_t*>(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ICommonReceiptSlipCapabilities>**)this;
            check_hresult(_winrt_abi_type->get_RuledLineCapabilities(reinterpret_cast<uint32_t*>(&value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ICommonReceiptSlipCapabilities<D>::SupportedBarcodeRotations() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ICommonReceiptSlipCapabilities>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ICommonReceiptSlipCapabilities, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ICommonReceiptSlipCapabilities>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_SupportedBarcodeRotations(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ICommonReceiptSlipCapabilities>**)this;
            check_hresult(_winrt_abi_type->get_SupportedBarcodeRotations(&value));
        }
        return winrt::Windows::Foundation::Collections::IVectorView<winrt::Windows::Devices::PointOfService::PosPrinterRotation>{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ICommonReceiptSlipCapabilities<D>::SupportedBitmapRotations() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ICommonReceiptSlipCapabilities>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ICommonReceiptSlipCapabilities, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ICommonReceiptSlipCapabilities>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_SupportedBitmapRotations(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ICommonReceiptSlipCapabilities>**)this;
            check_hresult(_winrt_abi_type->get_SupportedBitmapRotations(&value));
        }
        return winrt::Windows::Foundation::Collections::IVectorView<winrt::Windows::Devices::PointOfService::PosPrinterRotation>{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IJournalPrintJob<D>::Print(param::hstring const& data, winrt::Windows::Devices::PointOfService::PosPrinterPrintOptions const& printOptions) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IJournalPrintJob>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IJournalPrintJob, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IJournalPrintJob>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->Print(*(void**)(&data), *(void**)(&printOptions)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IJournalPrintJob>**)this;
            check_hresult(_winrt_abi_type->Print(*(void**)(&data), *(void**)(&printOptions)));
        }
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IJournalPrintJob<D>::FeedPaperByLine(int32_t lineCount) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IJournalPrintJob>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IJournalPrintJob, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IJournalPrintJob>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->FeedPaperByLine(lineCount));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IJournalPrintJob>**)this;
            check_hresult(_winrt_abi_type->FeedPaperByLine(lineCount));
        }
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IJournalPrintJob<D>::FeedPaperByMapModeUnit(int32_t distance) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IJournalPrintJob>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IJournalPrintJob, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IJournalPrintJob>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->FeedPaperByMapModeUnit(distance));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IJournalPrintJob>**)this;
            check_hresult(_winrt_abi_type->FeedPaperByMapModeUnit(distance));
        }
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IJournalPrinterCapabilities2<D>::IsReverseVideoSupported() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IJournalPrinterCapabilities2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IJournalPrinterCapabilities2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IJournalPrinterCapabilities2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsReverseVideoSupported(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IJournalPrinterCapabilities2>**)this;
            check_hresult(_winrt_abi_type->get_IsReverseVideoSupported(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IJournalPrinterCapabilities2<D>::IsStrikethroughSupported() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IJournalPrinterCapabilities2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IJournalPrinterCapabilities2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IJournalPrinterCapabilities2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsStrikethroughSupported(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IJournalPrinterCapabilities2>**)this;
            check_hresult(_winrt_abi_type->get_IsStrikethroughSupported(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IJournalPrinterCapabilities2<D>::IsSuperscriptSupported() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IJournalPrinterCapabilities2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IJournalPrinterCapabilities2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IJournalPrinterCapabilities2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsSuperscriptSupported(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IJournalPrinterCapabilities2>**)this;
            check_hresult(_winrt_abi_type->get_IsSuperscriptSupported(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IJournalPrinterCapabilities2<D>::IsSubscriptSupported() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IJournalPrinterCapabilities2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IJournalPrinterCapabilities2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IJournalPrinterCapabilities2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsSubscriptSupported(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IJournalPrinterCapabilities2>**)this;
            check_hresult(_winrt_abi_type->get_IsSubscriptSupported(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IJournalPrinterCapabilities2<D>::IsReversePaperFeedByLineSupported() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IJournalPrinterCapabilities2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IJournalPrinterCapabilities2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IJournalPrinterCapabilities2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsReversePaperFeedByLineSupported(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IJournalPrinterCapabilities2>**)this;
            check_hresult(_winrt_abi_type->get_IsReversePaperFeedByLineSupported(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IJournalPrinterCapabilities2<D>::IsReversePaperFeedByMapModeUnitSupported() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IJournalPrinterCapabilities2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IJournalPrinterCapabilities2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IJournalPrinterCapabilities2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsReversePaperFeedByMapModeUnitSupported(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IJournalPrinterCapabilities2>**)this;
            check_hresult(_winrt_abi_type->get_IsReversePaperFeedByMapModeUnitSupported(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ILineDisplay<D>::DeviceId() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ILineDisplay>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ILineDisplay, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplay>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_DeviceId(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplay>**)this;
            check_hresult(_winrt_abi_type->get_DeviceId(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ILineDisplay<D>::Capabilities() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ILineDisplay>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ILineDisplay, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplay>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Capabilities(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplay>**)this;
            check_hresult(_winrt_abi_type->get_Capabilities(&value));
        }
        return winrt::Windows::Devices::PointOfService::LineDisplayCapabilities{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ILineDisplay<D>::PhysicalDeviceName() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ILineDisplay>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ILineDisplay, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplay>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_PhysicalDeviceName(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplay>**)this;
            check_hresult(_winrt_abi_type->get_PhysicalDeviceName(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ILineDisplay<D>::PhysicalDeviceDescription() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ILineDisplay>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ILineDisplay, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplay>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_PhysicalDeviceDescription(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplay>**)this;
            check_hresult(_winrt_abi_type->get_PhysicalDeviceDescription(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ILineDisplay<D>::DeviceControlDescription() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ILineDisplay>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ILineDisplay, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplay>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_DeviceControlDescription(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplay>**)this;
            check_hresult(_winrt_abi_type->get_DeviceControlDescription(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ILineDisplay<D>::DeviceControlVersion() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ILineDisplay>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ILineDisplay, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplay>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_DeviceControlVersion(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplay>**)this;
            check_hresult(_winrt_abi_type->get_DeviceControlVersion(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ILineDisplay<D>::DeviceServiceVersion() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ILineDisplay>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ILineDisplay, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplay>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_DeviceServiceVersion(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplay>**)this;
            check_hresult(_winrt_abi_type->get_DeviceServiceVersion(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ILineDisplay<D>::ClaimAsync() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ILineDisplay>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ILineDisplay, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplay>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->ClaimAsync(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplay>**)this;
            check_hresult(_winrt_abi_type->ClaimAsync(&result));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Devices::PointOfService::ClaimedLineDisplay>{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ILineDisplay2<D>::CheckPowerStatusAsync() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ILineDisplay2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ILineDisplay2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplay2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CheckPowerStatusAsync(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplay2>**)this;
            check_hresult(_winrt_abi_type->CheckPowerStatusAsync(&result));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Devices::PointOfService::LineDisplayPowerStatus>{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ILineDisplayAttributes<D>::IsPowerNotifyEnabled() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ILineDisplayAttributes>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ILineDisplayAttributes, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayAttributes>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsPowerNotifyEnabled(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayAttributes>**)this;
            check_hresult(_winrt_abi_type->get_IsPowerNotifyEnabled(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ILineDisplayAttributes<D>::IsPowerNotifyEnabled(bool value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ILineDisplayAttributes>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ILineDisplayAttributes, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayAttributes>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_IsPowerNotifyEnabled(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayAttributes>**)this;
            check_hresult(_winrt_abi_type->put_IsPowerNotifyEnabled(value));
        }
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ILineDisplayAttributes<D>::Brightness() const
    {
        int32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ILineDisplayAttributes>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ILineDisplayAttributes, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayAttributes>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Brightness(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayAttributes>**)this;
            check_hresult(_winrt_abi_type->get_Brightness(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ILineDisplayAttributes<D>::Brightness(int32_t value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ILineDisplayAttributes>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ILineDisplayAttributes, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayAttributes>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Brightness(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayAttributes>**)this;
            check_hresult(_winrt_abi_type->put_Brightness(value));
        }
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ILineDisplayAttributes<D>::BlinkRate() const
    {
        winrt::Windows::Foundation::TimeSpan value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ILineDisplayAttributes>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ILineDisplayAttributes, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayAttributes>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_BlinkRate(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayAttributes>**)this;
            check_hresult(_winrt_abi_type->get_BlinkRate(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ILineDisplayAttributes<D>::BlinkRate(winrt::Windows::Foundation::TimeSpan const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ILineDisplayAttributes>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ILineDisplayAttributes, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayAttributes>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_BlinkRate(impl::bind_in(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayAttributes>**)this;
            check_hresult(_winrt_abi_type->put_BlinkRate(impl::bind_in(value)));
        }
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ILineDisplayAttributes<D>::ScreenSizeInCharacters() const
    {
        winrt::Windows::Foundation::Size value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ILineDisplayAttributes>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ILineDisplayAttributes, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayAttributes>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ScreenSizeInCharacters(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayAttributes>**)this;
            check_hresult(_winrt_abi_type->get_ScreenSizeInCharacters(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ILineDisplayAttributes<D>::ScreenSizeInCharacters(winrt::Windows::Foundation::Size const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ILineDisplayAttributes>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ILineDisplayAttributes, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayAttributes>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_ScreenSizeInCharacters(impl::bind_in(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayAttributes>**)this;
            check_hresult(_winrt_abi_type->put_ScreenSizeInCharacters(impl::bind_in(value)));
        }
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ILineDisplayAttributes<D>::CharacterSet() const
    {
        int32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ILineDisplayAttributes>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ILineDisplayAttributes, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayAttributes>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_CharacterSet(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayAttributes>**)this;
            check_hresult(_winrt_abi_type->get_CharacterSet(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ILineDisplayAttributes<D>::CharacterSet(int32_t value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ILineDisplayAttributes>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ILineDisplayAttributes, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayAttributes>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_CharacterSet(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayAttributes>**)this;
            check_hresult(_winrt_abi_type->put_CharacterSet(value));
        }
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ILineDisplayAttributes<D>::IsCharacterSetMappingEnabled() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ILineDisplayAttributes>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ILineDisplayAttributes, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayAttributes>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsCharacterSetMappingEnabled(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayAttributes>**)this;
            check_hresult(_winrt_abi_type->get_IsCharacterSetMappingEnabled(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ILineDisplayAttributes<D>::IsCharacterSetMappingEnabled(bool value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ILineDisplayAttributes>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ILineDisplayAttributes, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayAttributes>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_IsCharacterSetMappingEnabled(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayAttributes>**)this;
            check_hresult(_winrt_abi_type->put_IsCharacterSetMappingEnabled(value));
        }
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ILineDisplayAttributes<D>::CurrentWindow() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ILineDisplayAttributes>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ILineDisplayAttributes, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayAttributes>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_CurrentWindow(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayAttributes>**)this;
            check_hresult(_winrt_abi_type->get_CurrentWindow(&value));
        }
        return winrt::Windows::Devices::PointOfService::LineDisplayWindow{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ILineDisplayAttributes<D>::CurrentWindow(winrt::Windows::Devices::PointOfService::LineDisplayWindow const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ILineDisplayAttributes>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ILineDisplayAttributes, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayAttributes>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_CurrentWindow(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayAttributes>**)this;
            check_hresult(_winrt_abi_type->put_CurrentWindow(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ILineDisplayCapabilities<D>::IsStatisticsReportingSupported() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ILineDisplayCapabilities>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ILineDisplayCapabilities, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayCapabilities>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsStatisticsReportingSupported(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayCapabilities>**)this;
            check_hresult(_winrt_abi_type->get_IsStatisticsReportingSupported(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ILineDisplayCapabilities<D>::IsStatisticsUpdatingSupported() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ILineDisplayCapabilities>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ILineDisplayCapabilities, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayCapabilities>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsStatisticsUpdatingSupported(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayCapabilities>**)this;
            check_hresult(_winrt_abi_type->get_IsStatisticsUpdatingSupported(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ILineDisplayCapabilities<D>::PowerReportingType() const
    {
        winrt::Windows::Devices::PointOfService::UnifiedPosPowerReportingType value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ILineDisplayCapabilities>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ILineDisplayCapabilities, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayCapabilities>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_PowerReportingType(reinterpret_cast<int32_t*>(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayCapabilities>**)this;
            check_hresult(_winrt_abi_type->get_PowerReportingType(reinterpret_cast<int32_t*>(&value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ILineDisplayCapabilities<D>::CanChangeScreenSize() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ILineDisplayCapabilities>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ILineDisplayCapabilities, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayCapabilities>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_CanChangeScreenSize(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayCapabilities>**)this;
            check_hresult(_winrt_abi_type->get_CanChangeScreenSize(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ILineDisplayCapabilities<D>::CanDisplayBitmaps() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ILineDisplayCapabilities>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ILineDisplayCapabilities, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayCapabilities>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_CanDisplayBitmaps(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayCapabilities>**)this;
            check_hresult(_winrt_abi_type->get_CanDisplayBitmaps(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ILineDisplayCapabilities<D>::CanReadCharacterAtCursor() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ILineDisplayCapabilities>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ILineDisplayCapabilities, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayCapabilities>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_CanReadCharacterAtCursor(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayCapabilities>**)this;
            check_hresult(_winrt_abi_type->get_CanReadCharacterAtCursor(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ILineDisplayCapabilities<D>::CanMapCharacterSets() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ILineDisplayCapabilities>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ILineDisplayCapabilities, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayCapabilities>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_CanMapCharacterSets(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayCapabilities>**)this;
            check_hresult(_winrt_abi_type->get_CanMapCharacterSets(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ILineDisplayCapabilities<D>::CanDisplayCustomGlyphs() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ILineDisplayCapabilities>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ILineDisplayCapabilities, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayCapabilities>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_CanDisplayCustomGlyphs(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayCapabilities>**)this;
            check_hresult(_winrt_abi_type->get_CanDisplayCustomGlyphs(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ILineDisplayCapabilities<D>::CanReverse() const
    {
        winrt::Windows::Devices::PointOfService::LineDisplayTextAttributeGranularity value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ILineDisplayCapabilities>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ILineDisplayCapabilities, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayCapabilities>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_CanReverse(reinterpret_cast<int32_t*>(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayCapabilities>**)this;
            check_hresult(_winrt_abi_type->get_CanReverse(reinterpret_cast<int32_t*>(&value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ILineDisplayCapabilities<D>::CanBlink() const
    {
        winrt::Windows::Devices::PointOfService::LineDisplayTextAttributeGranularity value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ILineDisplayCapabilities>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ILineDisplayCapabilities, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayCapabilities>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_CanBlink(reinterpret_cast<int32_t*>(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayCapabilities>**)this;
            check_hresult(_winrt_abi_type->get_CanBlink(reinterpret_cast<int32_t*>(&value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ILineDisplayCapabilities<D>::CanChangeBlinkRate() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ILineDisplayCapabilities>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ILineDisplayCapabilities, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayCapabilities>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_CanChangeBlinkRate(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayCapabilities>**)this;
            check_hresult(_winrt_abi_type->get_CanChangeBlinkRate(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ILineDisplayCapabilities<D>::IsBrightnessSupported() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ILineDisplayCapabilities>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ILineDisplayCapabilities, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayCapabilities>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsBrightnessSupported(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayCapabilities>**)this;
            check_hresult(_winrt_abi_type->get_IsBrightnessSupported(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ILineDisplayCapabilities<D>::IsCursorSupported() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ILineDisplayCapabilities>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ILineDisplayCapabilities, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayCapabilities>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsCursorSupported(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayCapabilities>**)this;
            check_hresult(_winrt_abi_type->get_IsCursorSupported(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ILineDisplayCapabilities<D>::IsHorizontalMarqueeSupported() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ILineDisplayCapabilities>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ILineDisplayCapabilities, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayCapabilities>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsHorizontalMarqueeSupported(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayCapabilities>**)this;
            check_hresult(_winrt_abi_type->get_IsHorizontalMarqueeSupported(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ILineDisplayCapabilities<D>::IsVerticalMarqueeSupported() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ILineDisplayCapabilities>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ILineDisplayCapabilities, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayCapabilities>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsVerticalMarqueeSupported(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayCapabilities>**)this;
            check_hresult(_winrt_abi_type->get_IsVerticalMarqueeSupported(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ILineDisplayCapabilities<D>::IsInterCharacterWaitSupported() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ILineDisplayCapabilities>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ILineDisplayCapabilities, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayCapabilities>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsInterCharacterWaitSupported(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayCapabilities>**)this;
            check_hresult(_winrt_abi_type->get_IsInterCharacterWaitSupported(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ILineDisplayCapabilities<D>::SupportedDescriptors() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ILineDisplayCapabilities>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ILineDisplayCapabilities, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayCapabilities>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_SupportedDescriptors(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayCapabilities>**)this;
            check_hresult(_winrt_abi_type->get_SupportedDescriptors(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ILineDisplayCapabilities<D>::SupportedWindows() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ILineDisplayCapabilities>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ILineDisplayCapabilities, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayCapabilities>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_SupportedWindows(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayCapabilities>**)this;
            check_hresult(_winrt_abi_type->get_SupportedWindows(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ILineDisplayCursor<D>::CanCustomize() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ILineDisplayCursor>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ILineDisplayCursor, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayCursor>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_CanCustomize(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayCursor>**)this;
            check_hresult(_winrt_abi_type->get_CanCustomize(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ILineDisplayCursor<D>::IsBlinkSupported() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ILineDisplayCursor>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ILineDisplayCursor, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayCursor>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsBlinkSupported(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayCursor>**)this;
            check_hresult(_winrt_abi_type->get_IsBlinkSupported(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ILineDisplayCursor<D>::IsBlockSupported() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ILineDisplayCursor>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ILineDisplayCursor, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayCursor>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsBlockSupported(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayCursor>**)this;
            check_hresult(_winrt_abi_type->get_IsBlockSupported(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ILineDisplayCursor<D>::IsHalfBlockSupported() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ILineDisplayCursor>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ILineDisplayCursor, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayCursor>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsHalfBlockSupported(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayCursor>**)this;
            check_hresult(_winrt_abi_type->get_IsHalfBlockSupported(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ILineDisplayCursor<D>::IsUnderlineSupported() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ILineDisplayCursor>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ILineDisplayCursor, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayCursor>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsUnderlineSupported(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayCursor>**)this;
            check_hresult(_winrt_abi_type->get_IsUnderlineSupported(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ILineDisplayCursor<D>::IsReverseSupported() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ILineDisplayCursor>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ILineDisplayCursor, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayCursor>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsReverseSupported(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayCursor>**)this;
            check_hresult(_winrt_abi_type->get_IsReverseSupported(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ILineDisplayCursor<D>::IsOtherSupported() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ILineDisplayCursor>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ILineDisplayCursor, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayCursor>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsOtherSupported(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayCursor>**)this;
            check_hresult(_winrt_abi_type->get_IsOtherSupported(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ILineDisplayCursor<D>::GetAttributes() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ILineDisplayCursor>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ILineDisplayCursor, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayCursor>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetAttributes(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayCursor>**)this;
            check_hresult(_winrt_abi_type->GetAttributes(&result));
        }
        return winrt::Windows::Devices::PointOfService::LineDisplayCursorAttributes{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ILineDisplayCursor<D>::TryUpdateAttributesAsync(winrt::Windows::Devices::PointOfService::LineDisplayCursorAttributes const& attributes) const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ILineDisplayCursor>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ILineDisplayCursor, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayCursor>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->TryUpdateAttributesAsync(*(void**)(&attributes), &operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayCursor>**)this;
            check_hresult(_winrt_abi_type->TryUpdateAttributesAsync(*(void**)(&attributes), &operation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<bool>{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ILineDisplayCursorAttributes<D>::IsBlinkEnabled() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ILineDisplayCursorAttributes>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ILineDisplayCursorAttributes, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayCursorAttributes>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsBlinkEnabled(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayCursorAttributes>**)this;
            check_hresult(_winrt_abi_type->get_IsBlinkEnabled(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ILineDisplayCursorAttributes<D>::IsBlinkEnabled(bool value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ILineDisplayCursorAttributes>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ILineDisplayCursorAttributes, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayCursorAttributes>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_IsBlinkEnabled(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayCursorAttributes>**)this;
            check_hresult(_winrt_abi_type->put_IsBlinkEnabled(value));
        }
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ILineDisplayCursorAttributes<D>::CursorType() const
    {
        winrt::Windows::Devices::PointOfService::LineDisplayCursorType value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ILineDisplayCursorAttributes>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ILineDisplayCursorAttributes, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayCursorAttributes>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_CursorType(reinterpret_cast<int32_t*>(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayCursorAttributes>**)this;
            check_hresult(_winrt_abi_type->get_CursorType(reinterpret_cast<int32_t*>(&value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ILineDisplayCursorAttributes<D>::CursorType(winrt::Windows::Devices::PointOfService::LineDisplayCursorType const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ILineDisplayCursorAttributes>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ILineDisplayCursorAttributes, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayCursorAttributes>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_CursorType(static_cast<int32_t>(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayCursorAttributes>**)this;
            check_hresult(_winrt_abi_type->put_CursorType(static_cast<int32_t>(value)));
        }
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ILineDisplayCursorAttributes<D>::IsAutoAdvanceEnabled() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ILineDisplayCursorAttributes>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ILineDisplayCursorAttributes, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayCursorAttributes>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsAutoAdvanceEnabled(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayCursorAttributes>**)this;
            check_hresult(_winrt_abi_type->get_IsAutoAdvanceEnabled(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ILineDisplayCursorAttributes<D>::IsAutoAdvanceEnabled(bool value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ILineDisplayCursorAttributes>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ILineDisplayCursorAttributes, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayCursorAttributes>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_IsAutoAdvanceEnabled(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayCursorAttributes>**)this;
            check_hresult(_winrt_abi_type->put_IsAutoAdvanceEnabled(value));
        }
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ILineDisplayCursorAttributes<D>::Position() const
    {
        winrt::Windows::Foundation::Point value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ILineDisplayCursorAttributes>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ILineDisplayCursorAttributes, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayCursorAttributes>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Position(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayCursorAttributes>**)this;
            check_hresult(_winrt_abi_type->get_Position(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ILineDisplayCursorAttributes<D>::Position(winrt::Windows::Foundation::Point const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ILineDisplayCursorAttributes>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ILineDisplayCursorAttributes, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayCursorAttributes>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Position(impl::bind_in(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayCursorAttributes>**)this;
            check_hresult(_winrt_abi_type->put_Position(impl::bind_in(value)));
        }
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ILineDisplayCustomGlyphs<D>::SizeInPixels() const
    {
        winrt::Windows::Foundation::Size value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ILineDisplayCustomGlyphs>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ILineDisplayCustomGlyphs, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayCustomGlyphs>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_SizeInPixels(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayCustomGlyphs>**)this;
            check_hresult(_winrt_abi_type->get_SizeInPixels(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ILineDisplayCustomGlyphs<D>::SupportedGlyphCodes() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ILineDisplayCustomGlyphs>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ILineDisplayCustomGlyphs, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayCustomGlyphs>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_SupportedGlyphCodes(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayCustomGlyphs>**)this;
            check_hresult(_winrt_abi_type->get_SupportedGlyphCodes(&value));
        }
        return winrt::Windows::Foundation::Collections::IVectorView<uint32_t>{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ILineDisplayCustomGlyphs<D>::TryRedefineAsync(uint32_t glyphCode, winrt::Windows::Storage::Streams::IBuffer const& glyphData) const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ILineDisplayCustomGlyphs>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ILineDisplayCustomGlyphs, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayCustomGlyphs>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->TryRedefineAsync(glyphCode, *(void**)(&glyphData), &operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayCustomGlyphs>**)this;
            check_hresult(_winrt_abi_type->TryRedefineAsync(glyphCode, *(void**)(&glyphData), &operation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<bool>{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ILineDisplayMarquee<D>::Format() const
    {
        winrt::Windows::Devices::PointOfService::LineDisplayMarqueeFormat value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ILineDisplayMarquee>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ILineDisplayMarquee, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayMarquee>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Format(reinterpret_cast<int32_t*>(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayMarquee>**)this;
            check_hresult(_winrt_abi_type->get_Format(reinterpret_cast<int32_t*>(&value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ILineDisplayMarquee<D>::Format(winrt::Windows::Devices::PointOfService::LineDisplayMarqueeFormat const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ILineDisplayMarquee>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ILineDisplayMarquee, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayMarquee>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Format(static_cast<int32_t>(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayMarquee>**)this;
            check_hresult(_winrt_abi_type->put_Format(static_cast<int32_t>(value)));
        }
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ILineDisplayMarquee<D>::RepeatWaitInterval() const
    {
        winrt::Windows::Foundation::TimeSpan value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ILineDisplayMarquee>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ILineDisplayMarquee, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayMarquee>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_RepeatWaitInterval(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayMarquee>**)this;
            check_hresult(_winrt_abi_type->get_RepeatWaitInterval(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ILineDisplayMarquee<D>::RepeatWaitInterval(winrt::Windows::Foundation::TimeSpan const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ILineDisplayMarquee>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ILineDisplayMarquee, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayMarquee>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_RepeatWaitInterval(impl::bind_in(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayMarquee>**)this;
            check_hresult(_winrt_abi_type->put_RepeatWaitInterval(impl::bind_in(value)));
        }
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ILineDisplayMarquee<D>::ScrollWaitInterval() const
    {
        winrt::Windows::Foundation::TimeSpan value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ILineDisplayMarquee>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ILineDisplayMarquee, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayMarquee>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ScrollWaitInterval(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayMarquee>**)this;
            check_hresult(_winrt_abi_type->get_ScrollWaitInterval(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ILineDisplayMarquee<D>::ScrollWaitInterval(winrt::Windows::Foundation::TimeSpan const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ILineDisplayMarquee>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ILineDisplayMarquee, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayMarquee>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_ScrollWaitInterval(impl::bind_in(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayMarquee>**)this;
            check_hresult(_winrt_abi_type->put_ScrollWaitInterval(impl::bind_in(value)));
        }
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ILineDisplayMarquee<D>::TryStartScrollingAsync(winrt::Windows::Devices::PointOfService::LineDisplayScrollDirection const& direction) const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ILineDisplayMarquee>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ILineDisplayMarquee, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayMarquee>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->TryStartScrollingAsync(static_cast<int32_t>(direction), &operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayMarquee>**)this;
            check_hresult(_winrt_abi_type->TryStartScrollingAsync(static_cast<int32_t>(direction), &operation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<bool>{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ILineDisplayMarquee<D>::TryStopScrollingAsync() const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ILineDisplayMarquee>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ILineDisplayMarquee, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayMarquee>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->TryStopScrollingAsync(&operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayMarquee>**)this;
            check_hresult(_winrt_abi_type->TryStopScrollingAsync(&operation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<bool>{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ILineDisplayStatics<D>::FromIdAsync(param::hstring const& deviceId) const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ILineDisplayStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ILineDisplayStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->FromIdAsync(*(void**)(&deviceId), &operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayStatics>**)this;
            check_hresult(_winrt_abi_type->FromIdAsync(*(void**)(&deviceId), &operation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Devices::PointOfService::LineDisplay>{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ILineDisplayStatics<D>::GetDefaultAsync() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ILineDisplayStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ILineDisplayStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetDefaultAsync(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayStatics>**)this;
            check_hresult(_winrt_abi_type->GetDefaultAsync(&result));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Devices::PointOfService::LineDisplay>{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ILineDisplayStatics<D>::GetDeviceSelector() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ILineDisplayStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ILineDisplayStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetDeviceSelector(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayStatics>**)this;
            check_hresult(_winrt_abi_type->GetDeviceSelector(&result));
        }
        return hstring{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ILineDisplayStatics<D>::GetDeviceSelector(winrt::Windows::Devices::PointOfService::PosConnectionTypes const& connectionTypes) const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ILineDisplayStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ILineDisplayStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetDeviceSelectorWithConnectionTypes(static_cast<uint32_t>(connectionTypes), &value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayStatics>**)this;
            check_hresult(_winrt_abi_type->GetDeviceSelectorWithConnectionTypes(static_cast<uint32_t>(connectionTypes), &value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ILineDisplayStatics2<D>::StatisticsCategorySelector() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ILineDisplayStatics2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ILineDisplayStatics2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayStatics2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_StatisticsCategorySelector(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayStatics2>**)this;
            check_hresult(_winrt_abi_type->get_StatisticsCategorySelector(&value));
        }
        return winrt::Windows::Devices::PointOfService::LineDisplayStatisticsCategorySelector{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ILineDisplayStatisticsCategorySelector<D>::AllStatistics() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ILineDisplayStatisticsCategorySelector>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ILineDisplayStatisticsCategorySelector, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayStatisticsCategorySelector>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_AllStatistics(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayStatisticsCategorySelector>**)this;
            check_hresult(_winrt_abi_type->get_AllStatistics(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ILineDisplayStatisticsCategorySelector<D>::UnifiedPosStatistics() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ILineDisplayStatisticsCategorySelector>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ILineDisplayStatisticsCategorySelector, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayStatisticsCategorySelector>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_UnifiedPosStatistics(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayStatisticsCategorySelector>**)this;
            check_hresult(_winrt_abi_type->get_UnifiedPosStatistics(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ILineDisplayStatisticsCategorySelector<D>::ManufacturerStatistics() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ILineDisplayStatisticsCategorySelector>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ILineDisplayStatisticsCategorySelector, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayStatisticsCategorySelector>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ManufacturerStatistics(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayStatisticsCategorySelector>**)this;
            check_hresult(_winrt_abi_type->get_ManufacturerStatistics(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ILineDisplayStatusUpdatedEventArgs<D>::Status() const
    {
        winrt::Windows::Devices::PointOfService::LineDisplayPowerStatus value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ILineDisplayStatusUpdatedEventArgs>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ILineDisplayStatusUpdatedEventArgs, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayStatusUpdatedEventArgs>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Status(reinterpret_cast<int32_t*>(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayStatusUpdatedEventArgs>**)this;
            check_hresult(_winrt_abi_type->get_Status(reinterpret_cast<int32_t*>(&value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ILineDisplayStoredBitmap<D>::EscapeSequence() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ILineDisplayStoredBitmap>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ILineDisplayStoredBitmap, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayStoredBitmap>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_EscapeSequence(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayStoredBitmap>**)this;
            check_hresult(_winrt_abi_type->get_EscapeSequence(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ILineDisplayStoredBitmap<D>::TryDeleteAsync() const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ILineDisplayStoredBitmap>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ILineDisplayStoredBitmap, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayStoredBitmap>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->TryDeleteAsync(&operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayStoredBitmap>**)this;
            check_hresult(_winrt_abi_type->TryDeleteAsync(&operation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<bool>{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ILineDisplayWindow<D>::SizeInCharacters() const
    {
        winrt::Windows::Foundation::Size value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ILineDisplayWindow>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ILineDisplayWindow, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayWindow>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_SizeInCharacters(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayWindow>**)this;
            check_hresult(_winrt_abi_type->get_SizeInCharacters(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ILineDisplayWindow<D>::InterCharacterWaitInterval() const
    {
        winrt::Windows::Foundation::TimeSpan value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ILineDisplayWindow>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ILineDisplayWindow, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayWindow>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_InterCharacterWaitInterval(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayWindow>**)this;
            check_hresult(_winrt_abi_type->get_InterCharacterWaitInterval(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ILineDisplayWindow<D>::InterCharacterWaitInterval(winrt::Windows::Foundation::TimeSpan const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ILineDisplayWindow>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ILineDisplayWindow, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayWindow>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_InterCharacterWaitInterval(impl::bind_in(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayWindow>**)this;
            check_hresult(_winrt_abi_type->put_InterCharacterWaitInterval(impl::bind_in(value)));
        }
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ILineDisplayWindow<D>::TryRefreshAsync() const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ILineDisplayWindow>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ILineDisplayWindow, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayWindow>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->TryRefreshAsync(&operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayWindow>**)this;
            check_hresult(_winrt_abi_type->TryRefreshAsync(&operation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<bool>{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ILineDisplayWindow<D>::TryDisplayTextAsync(param::hstring const& text, winrt::Windows::Devices::PointOfService::LineDisplayTextAttribute const& displayAttribute) const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ILineDisplayWindow>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ILineDisplayWindow, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayWindow>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->TryDisplayTextAsync(*(void**)(&text), static_cast<int32_t>(displayAttribute), &operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayWindow>**)this;
            check_hresult(_winrt_abi_type->TryDisplayTextAsync(*(void**)(&text), static_cast<int32_t>(displayAttribute), &operation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<bool>{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ILineDisplayWindow<D>::TryDisplayTextAsync(param::hstring const& text, winrt::Windows::Devices::PointOfService::LineDisplayTextAttribute const& displayAttribute, winrt::Windows::Foundation::Point const& startPosition) const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ILineDisplayWindow>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ILineDisplayWindow, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayWindow>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->TryDisplayTextAtPositionAsync(*(void**)(&text), static_cast<int32_t>(displayAttribute), impl::bind_in(startPosition), &operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayWindow>**)this;
            check_hresult(_winrt_abi_type->TryDisplayTextAtPositionAsync(*(void**)(&text), static_cast<int32_t>(displayAttribute), impl::bind_in(startPosition), &operation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<bool>{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ILineDisplayWindow<D>::TryDisplayTextAsync(param::hstring const& text) const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ILineDisplayWindow>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ILineDisplayWindow, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayWindow>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->TryDisplayTextNormalAsync(*(void**)(&text), &operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayWindow>**)this;
            check_hresult(_winrt_abi_type->TryDisplayTextNormalAsync(*(void**)(&text), &operation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<bool>{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ILineDisplayWindow<D>::TryScrollTextAsync(winrt::Windows::Devices::PointOfService::LineDisplayScrollDirection const& direction, uint32_t numberOfColumnsOrRows) const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ILineDisplayWindow>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ILineDisplayWindow, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayWindow>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->TryScrollTextAsync(static_cast<int32_t>(direction), numberOfColumnsOrRows, &operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayWindow>**)this;
            check_hresult(_winrt_abi_type->TryScrollTextAsync(static_cast<int32_t>(direction), numberOfColumnsOrRows, &operation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<bool>{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ILineDisplayWindow<D>::TryClearTextAsync() const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ILineDisplayWindow>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ILineDisplayWindow, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayWindow>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->TryClearTextAsync(&operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayWindow>**)this;
            check_hresult(_winrt_abi_type->TryClearTextAsync(&operation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<bool>{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ILineDisplayWindow2<D>::Cursor() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ILineDisplayWindow2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ILineDisplayWindow2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayWindow2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Cursor(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayWindow2>**)this;
            check_hresult(_winrt_abi_type->get_Cursor(&value));
        }
        return winrt::Windows::Devices::PointOfService::LineDisplayCursor{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ILineDisplayWindow2<D>::Marquee() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ILineDisplayWindow2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ILineDisplayWindow2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayWindow2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Marquee(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayWindow2>**)this;
            check_hresult(_winrt_abi_type->get_Marquee(&value));
        }
        return winrt::Windows::Devices::PointOfService::LineDisplayMarquee{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ILineDisplayWindow2<D>::ReadCharacterAtCursorAsync() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ILineDisplayWindow2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ILineDisplayWindow2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayWindow2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->ReadCharacterAtCursorAsync(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayWindow2>**)this;
            check_hresult(_winrt_abi_type->ReadCharacterAtCursorAsync(&result));
        }
        return winrt::Windows::Foundation::IAsyncOperation<uint32_t>{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ILineDisplayWindow2<D>::TryDisplayStoredBitmapAtCursorAsync(winrt::Windows::Devices::PointOfService::LineDisplayStoredBitmap const& bitmap) const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ILineDisplayWindow2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ILineDisplayWindow2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayWindow2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->TryDisplayStoredBitmapAtCursorAsync(*(void**)(&bitmap), &operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayWindow2>**)this;
            check_hresult(_winrt_abi_type->TryDisplayStoredBitmapAtCursorAsync(*(void**)(&bitmap), &operation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<bool>{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ILineDisplayWindow2<D>::TryDisplayStorageFileBitmapAtCursorAsync(winrt::Windows::Storage::StorageFile const& bitmap) const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ILineDisplayWindow2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ILineDisplayWindow2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayWindow2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->TryDisplayStorageFileBitmapAtCursorAsync(*(void**)(&bitmap), &operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayWindow2>**)this;
            check_hresult(_winrt_abi_type->TryDisplayStorageFileBitmapAtCursorAsync(*(void**)(&bitmap), &operation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<bool>{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ILineDisplayWindow2<D>::TryDisplayStorageFileBitmapAtCursorAsync(winrt::Windows::Storage::StorageFile const& bitmap, winrt::Windows::Devices::PointOfService::LineDisplayHorizontalAlignment const& horizontalAlignment, winrt::Windows::Devices::PointOfService::LineDisplayVerticalAlignment const& verticalAlignment) const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ILineDisplayWindow2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ILineDisplayWindow2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayWindow2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->TryDisplayStorageFileBitmapAtCursorWithAlignmentAsync(*(void**)(&bitmap), static_cast<int32_t>(horizontalAlignment), static_cast<int32_t>(verticalAlignment), &operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayWindow2>**)this;
            check_hresult(_winrt_abi_type->TryDisplayStorageFileBitmapAtCursorWithAlignmentAsync(*(void**)(&bitmap), static_cast<int32_t>(horizontalAlignment), static_cast<int32_t>(verticalAlignment), &operation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<bool>{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ILineDisplayWindow2<D>::TryDisplayStorageFileBitmapAtCursorAsync(winrt::Windows::Storage::StorageFile const& bitmap, winrt::Windows::Devices::PointOfService::LineDisplayHorizontalAlignment const& horizontalAlignment, winrt::Windows::Devices::PointOfService::LineDisplayVerticalAlignment const& verticalAlignment, int32_t widthInPixels) const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ILineDisplayWindow2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ILineDisplayWindow2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayWindow2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->TryDisplayStorageFileBitmapAtCursorWithAlignmentAndWidthAsync(*(void**)(&bitmap), static_cast<int32_t>(horizontalAlignment), static_cast<int32_t>(verticalAlignment), widthInPixels, &operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayWindow2>**)this;
            check_hresult(_winrt_abi_type->TryDisplayStorageFileBitmapAtCursorWithAlignmentAndWidthAsync(*(void**)(&bitmap), static_cast<int32_t>(horizontalAlignment), static_cast<int32_t>(verticalAlignment), widthInPixels, &operation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<bool>{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ILineDisplayWindow2<D>::TryDisplayStorageFileBitmapAtPointAsync(winrt::Windows::Storage::StorageFile const& bitmap, winrt::Windows::Foundation::Point const& offsetInPixels) const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ILineDisplayWindow2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ILineDisplayWindow2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayWindow2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->TryDisplayStorageFileBitmapAtPointAsync(*(void**)(&bitmap), impl::bind_in(offsetInPixels), &operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayWindow2>**)this;
            check_hresult(_winrt_abi_type->TryDisplayStorageFileBitmapAtPointAsync(*(void**)(&bitmap), impl::bind_in(offsetInPixels), &operation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<bool>{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ILineDisplayWindow2<D>::TryDisplayStorageFileBitmapAtPointAsync(winrt::Windows::Storage::StorageFile const& bitmap, winrt::Windows::Foundation::Point const& offsetInPixels, int32_t widthInPixels) const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ILineDisplayWindow2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ILineDisplayWindow2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayWindow2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->TryDisplayStorageFileBitmapAtPointWithWidthAsync(*(void**)(&bitmap), impl::bind_in(offsetInPixels), widthInPixels, &operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ILineDisplayWindow2>**)this;
            check_hresult(_winrt_abi_type->TryDisplayStorageFileBitmapAtPointWithWidthAsync(*(void**)(&bitmap), impl::bind_in(offsetInPixels), widthInPixels, &operation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<bool>{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IMagneticStripeReader<D>::DeviceId() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IMagneticStripeReader>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IMagneticStripeReader, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IMagneticStripeReader>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_DeviceId(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IMagneticStripeReader>**)this;
            check_hresult(_winrt_abi_type->get_DeviceId(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IMagneticStripeReader<D>::Capabilities() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IMagneticStripeReader>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IMagneticStripeReader, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IMagneticStripeReader>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Capabilities(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IMagneticStripeReader>**)this;
            check_hresult(_winrt_abi_type->get_Capabilities(&value));
        }
        return winrt::Windows::Devices::PointOfService::MagneticStripeReaderCapabilities{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IMagneticStripeReader<D>::SupportedCardTypes() const
    {
        uint32_t value_impl_size{};
        uint32_t* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IMagneticStripeReader>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IMagneticStripeReader, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IMagneticStripeReader>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_SupportedCardTypes(&value_impl_size, &value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IMagneticStripeReader>**)this;
            check_hresult(_winrt_abi_type->get_SupportedCardTypes(&value_impl_size, &value));
        }
        return com_array<uint32_t>{ value, value_impl_size, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IMagneticStripeReader<D>::DeviceAuthenticationProtocol() const
    {
        winrt::Windows::Devices::PointOfService::MagneticStripeReaderAuthenticationProtocol value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IMagneticStripeReader>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IMagneticStripeReader, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IMagneticStripeReader>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_DeviceAuthenticationProtocol(reinterpret_cast<int32_t*>(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IMagneticStripeReader>**)this;
            check_hresult(_winrt_abi_type->get_DeviceAuthenticationProtocol(reinterpret_cast<int32_t*>(&value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IMagneticStripeReader<D>::CheckHealthAsync(winrt::Windows::Devices::PointOfService::UnifiedPosHealthCheckLevel const& level) const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IMagneticStripeReader>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IMagneticStripeReader, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IMagneticStripeReader>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CheckHealthAsync(static_cast<int32_t>(level), &operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IMagneticStripeReader>**)this;
            check_hresult(_winrt_abi_type->CheckHealthAsync(static_cast<int32_t>(level), &operation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<hstring>{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IMagneticStripeReader<D>::ClaimReaderAsync() const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IMagneticStripeReader>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IMagneticStripeReader, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IMagneticStripeReader>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->ClaimReaderAsync(&operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IMagneticStripeReader>**)this;
            check_hresult(_winrt_abi_type->ClaimReaderAsync(&operation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Devices::PointOfService::ClaimedMagneticStripeReader>{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IMagneticStripeReader<D>::RetrieveStatisticsAsync(param::async_iterable<hstring> const& statisticsCategories) const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IMagneticStripeReader>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IMagneticStripeReader, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IMagneticStripeReader>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->RetrieveStatisticsAsync(*(void**)(&statisticsCategories), &operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IMagneticStripeReader>**)this;
            check_hresult(_winrt_abi_type->RetrieveStatisticsAsync(*(void**)(&statisticsCategories), &operation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Storage::Streams::IBuffer>{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IMagneticStripeReader<D>::GetErrorReportingType() const
    {
        winrt::Windows::Devices::PointOfService::MagneticStripeReaderErrorReportingType value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IMagneticStripeReader>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IMagneticStripeReader, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IMagneticStripeReader>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetErrorReportingType(reinterpret_cast<int32_t*>(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IMagneticStripeReader>**)this;
            check_hresult(_winrt_abi_type->GetErrorReportingType(reinterpret_cast<int32_t*>(&value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IMagneticStripeReader<D>::StatusUpdated(winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::Devices::PointOfService::MagneticStripeReader, winrt::Windows::Devices::PointOfService::MagneticStripeReaderStatusUpdatedEventArgs> const& handler) const
    {
        winrt::event_token token{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IMagneticStripeReader>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IMagneticStripeReader, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IMagneticStripeReader>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->add_StatusUpdated(*(void**)(&handler), put_abi(token)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IMagneticStripeReader>**)this;
            check_hresult(_winrt_abi_type->add_StatusUpdated(*(void**)(&handler), put_abi(token)));
        }
        return token;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IMagneticStripeReader<D>::StatusUpdated(auto_revoke_t, winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::Devices::PointOfService::MagneticStripeReader, winrt::Windows::Devices::PointOfService::MagneticStripeReaderStatusUpdatedEventArgs> const& handler) const
    {
        return impl::make_event_revoker<D, StatusUpdated_revoker>(this, StatusUpdated(handler));
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IMagneticStripeReader<D>::StatusUpdated(winrt::event_token const& token) const noexcept
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IMagneticStripeReader>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IMagneticStripeReader, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IMagneticStripeReader>**)&_winrt_casted_result;
            _winrt_abi_type->remove_StatusUpdated(impl::bind_in(token));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IMagneticStripeReader>**)this;
            _winrt_abi_type->remove_StatusUpdated(impl::bind_in(token));
        }
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IMagneticStripeReaderAamvaCardDataReceivedEventArgs<D>::Report() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IMagneticStripeReaderAamvaCardDataReceivedEventArgs>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderAamvaCardDataReceivedEventArgs, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderAamvaCardDataReceivedEventArgs>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Report(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderAamvaCardDataReceivedEventArgs>**)this;
            check_hresult(_winrt_abi_type->get_Report(&value));
        }
        return winrt::Windows::Devices::PointOfService::MagneticStripeReaderReport{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IMagneticStripeReaderAamvaCardDataReceivedEventArgs<D>::LicenseNumber() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IMagneticStripeReaderAamvaCardDataReceivedEventArgs>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderAamvaCardDataReceivedEventArgs, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderAamvaCardDataReceivedEventArgs>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_LicenseNumber(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderAamvaCardDataReceivedEventArgs>**)this;
            check_hresult(_winrt_abi_type->get_LicenseNumber(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IMagneticStripeReaderAamvaCardDataReceivedEventArgs<D>::ExpirationDate() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IMagneticStripeReaderAamvaCardDataReceivedEventArgs>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderAamvaCardDataReceivedEventArgs, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderAamvaCardDataReceivedEventArgs>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ExpirationDate(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderAamvaCardDataReceivedEventArgs>**)this;
            check_hresult(_winrt_abi_type->get_ExpirationDate(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IMagneticStripeReaderAamvaCardDataReceivedEventArgs<D>::Restrictions() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IMagneticStripeReaderAamvaCardDataReceivedEventArgs>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderAamvaCardDataReceivedEventArgs, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderAamvaCardDataReceivedEventArgs>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Restrictions(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderAamvaCardDataReceivedEventArgs>**)this;
            check_hresult(_winrt_abi_type->get_Restrictions(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IMagneticStripeReaderAamvaCardDataReceivedEventArgs<D>::Class() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IMagneticStripeReaderAamvaCardDataReceivedEventArgs>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderAamvaCardDataReceivedEventArgs, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderAamvaCardDataReceivedEventArgs>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Class(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderAamvaCardDataReceivedEventArgs>**)this;
            check_hresult(_winrt_abi_type->get_Class(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IMagneticStripeReaderAamvaCardDataReceivedEventArgs<D>::Endorsements() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IMagneticStripeReaderAamvaCardDataReceivedEventArgs>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderAamvaCardDataReceivedEventArgs, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderAamvaCardDataReceivedEventArgs>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Endorsements(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderAamvaCardDataReceivedEventArgs>**)this;
            check_hresult(_winrt_abi_type->get_Endorsements(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IMagneticStripeReaderAamvaCardDataReceivedEventArgs<D>::BirthDate() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IMagneticStripeReaderAamvaCardDataReceivedEventArgs>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderAamvaCardDataReceivedEventArgs, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderAamvaCardDataReceivedEventArgs>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_BirthDate(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderAamvaCardDataReceivedEventArgs>**)this;
            check_hresult(_winrt_abi_type->get_BirthDate(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IMagneticStripeReaderAamvaCardDataReceivedEventArgs<D>::FirstName() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IMagneticStripeReaderAamvaCardDataReceivedEventArgs>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderAamvaCardDataReceivedEventArgs, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderAamvaCardDataReceivedEventArgs>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_FirstName(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderAamvaCardDataReceivedEventArgs>**)this;
            check_hresult(_winrt_abi_type->get_FirstName(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IMagneticStripeReaderAamvaCardDataReceivedEventArgs<D>::Surname() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IMagneticStripeReaderAamvaCardDataReceivedEventArgs>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderAamvaCardDataReceivedEventArgs, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderAamvaCardDataReceivedEventArgs>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Surname(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderAamvaCardDataReceivedEventArgs>**)this;
            check_hresult(_winrt_abi_type->get_Surname(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IMagneticStripeReaderAamvaCardDataReceivedEventArgs<D>::Suffix() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IMagneticStripeReaderAamvaCardDataReceivedEventArgs>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderAamvaCardDataReceivedEventArgs, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderAamvaCardDataReceivedEventArgs>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Suffix(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderAamvaCardDataReceivedEventArgs>**)this;
            check_hresult(_winrt_abi_type->get_Suffix(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IMagneticStripeReaderAamvaCardDataReceivedEventArgs<D>::Gender() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IMagneticStripeReaderAamvaCardDataReceivedEventArgs>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderAamvaCardDataReceivedEventArgs, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderAamvaCardDataReceivedEventArgs>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Gender(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderAamvaCardDataReceivedEventArgs>**)this;
            check_hresult(_winrt_abi_type->get_Gender(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IMagneticStripeReaderAamvaCardDataReceivedEventArgs<D>::HairColor() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IMagneticStripeReaderAamvaCardDataReceivedEventArgs>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderAamvaCardDataReceivedEventArgs, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderAamvaCardDataReceivedEventArgs>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_HairColor(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderAamvaCardDataReceivedEventArgs>**)this;
            check_hresult(_winrt_abi_type->get_HairColor(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IMagneticStripeReaderAamvaCardDataReceivedEventArgs<D>::EyeColor() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IMagneticStripeReaderAamvaCardDataReceivedEventArgs>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderAamvaCardDataReceivedEventArgs, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderAamvaCardDataReceivedEventArgs>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_EyeColor(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderAamvaCardDataReceivedEventArgs>**)this;
            check_hresult(_winrt_abi_type->get_EyeColor(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IMagneticStripeReaderAamvaCardDataReceivedEventArgs<D>::Height() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IMagneticStripeReaderAamvaCardDataReceivedEventArgs>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderAamvaCardDataReceivedEventArgs, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderAamvaCardDataReceivedEventArgs>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Height(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderAamvaCardDataReceivedEventArgs>**)this;
            check_hresult(_winrt_abi_type->get_Height(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IMagneticStripeReaderAamvaCardDataReceivedEventArgs<D>::Weight() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IMagneticStripeReaderAamvaCardDataReceivedEventArgs>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderAamvaCardDataReceivedEventArgs, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderAamvaCardDataReceivedEventArgs>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Weight(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderAamvaCardDataReceivedEventArgs>**)this;
            check_hresult(_winrt_abi_type->get_Weight(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IMagneticStripeReaderAamvaCardDataReceivedEventArgs<D>::Address() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IMagneticStripeReaderAamvaCardDataReceivedEventArgs>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderAamvaCardDataReceivedEventArgs, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderAamvaCardDataReceivedEventArgs>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Address(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderAamvaCardDataReceivedEventArgs>**)this;
            check_hresult(_winrt_abi_type->get_Address(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IMagneticStripeReaderAamvaCardDataReceivedEventArgs<D>::City() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IMagneticStripeReaderAamvaCardDataReceivedEventArgs>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderAamvaCardDataReceivedEventArgs, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderAamvaCardDataReceivedEventArgs>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_City(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderAamvaCardDataReceivedEventArgs>**)this;
            check_hresult(_winrt_abi_type->get_City(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IMagneticStripeReaderAamvaCardDataReceivedEventArgs<D>::State() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IMagneticStripeReaderAamvaCardDataReceivedEventArgs>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderAamvaCardDataReceivedEventArgs, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderAamvaCardDataReceivedEventArgs>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_State(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderAamvaCardDataReceivedEventArgs>**)this;
            check_hresult(_winrt_abi_type->get_State(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IMagneticStripeReaderAamvaCardDataReceivedEventArgs<D>::PostalCode() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IMagneticStripeReaderAamvaCardDataReceivedEventArgs>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderAamvaCardDataReceivedEventArgs, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderAamvaCardDataReceivedEventArgs>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_PostalCode(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderAamvaCardDataReceivedEventArgs>**)this;
            check_hresult(_winrt_abi_type->get_PostalCode(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IMagneticStripeReaderBankCardDataReceivedEventArgs<D>::Report() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IMagneticStripeReaderBankCardDataReceivedEventArgs>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderBankCardDataReceivedEventArgs, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderBankCardDataReceivedEventArgs>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Report(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderBankCardDataReceivedEventArgs>**)this;
            check_hresult(_winrt_abi_type->get_Report(&value));
        }
        return winrt::Windows::Devices::PointOfService::MagneticStripeReaderReport{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IMagneticStripeReaderBankCardDataReceivedEventArgs<D>::AccountNumber() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IMagneticStripeReaderBankCardDataReceivedEventArgs>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderBankCardDataReceivedEventArgs, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderBankCardDataReceivedEventArgs>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_AccountNumber(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderBankCardDataReceivedEventArgs>**)this;
            check_hresult(_winrt_abi_type->get_AccountNumber(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IMagneticStripeReaderBankCardDataReceivedEventArgs<D>::ExpirationDate() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IMagneticStripeReaderBankCardDataReceivedEventArgs>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderBankCardDataReceivedEventArgs, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderBankCardDataReceivedEventArgs>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ExpirationDate(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderBankCardDataReceivedEventArgs>**)this;
            check_hresult(_winrt_abi_type->get_ExpirationDate(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IMagneticStripeReaderBankCardDataReceivedEventArgs<D>::ServiceCode() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IMagneticStripeReaderBankCardDataReceivedEventArgs>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderBankCardDataReceivedEventArgs, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderBankCardDataReceivedEventArgs>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ServiceCode(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderBankCardDataReceivedEventArgs>**)this;
            check_hresult(_winrt_abi_type->get_ServiceCode(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IMagneticStripeReaderBankCardDataReceivedEventArgs<D>::Title() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IMagneticStripeReaderBankCardDataReceivedEventArgs>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderBankCardDataReceivedEventArgs, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderBankCardDataReceivedEventArgs>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Title(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderBankCardDataReceivedEventArgs>**)this;
            check_hresult(_winrt_abi_type->get_Title(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IMagneticStripeReaderBankCardDataReceivedEventArgs<D>::FirstName() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IMagneticStripeReaderBankCardDataReceivedEventArgs>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderBankCardDataReceivedEventArgs, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderBankCardDataReceivedEventArgs>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_FirstName(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderBankCardDataReceivedEventArgs>**)this;
            check_hresult(_winrt_abi_type->get_FirstName(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IMagneticStripeReaderBankCardDataReceivedEventArgs<D>::MiddleInitial() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IMagneticStripeReaderBankCardDataReceivedEventArgs>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderBankCardDataReceivedEventArgs, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderBankCardDataReceivedEventArgs>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_MiddleInitial(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderBankCardDataReceivedEventArgs>**)this;
            check_hresult(_winrt_abi_type->get_MiddleInitial(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IMagneticStripeReaderBankCardDataReceivedEventArgs<D>::Surname() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IMagneticStripeReaderBankCardDataReceivedEventArgs>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderBankCardDataReceivedEventArgs, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderBankCardDataReceivedEventArgs>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Surname(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderBankCardDataReceivedEventArgs>**)this;
            check_hresult(_winrt_abi_type->get_Surname(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IMagneticStripeReaderBankCardDataReceivedEventArgs<D>::Suffix() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IMagneticStripeReaderBankCardDataReceivedEventArgs>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderBankCardDataReceivedEventArgs, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderBankCardDataReceivedEventArgs>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Suffix(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderBankCardDataReceivedEventArgs>**)this;
            check_hresult(_winrt_abi_type->get_Suffix(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IMagneticStripeReaderCapabilities<D>::CardAuthentication() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IMagneticStripeReaderCapabilities>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderCapabilities, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderCapabilities>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_CardAuthentication(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderCapabilities>**)this;
            check_hresult(_winrt_abi_type->get_CardAuthentication(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IMagneticStripeReaderCapabilities<D>::SupportedEncryptionAlgorithms() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IMagneticStripeReaderCapabilities>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderCapabilities, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderCapabilities>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_SupportedEncryptionAlgorithms(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderCapabilities>**)this;
            check_hresult(_winrt_abi_type->get_SupportedEncryptionAlgorithms(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IMagneticStripeReaderCapabilities<D>::AuthenticationLevel() const
    {
        winrt::Windows::Devices::PointOfService::MagneticStripeReaderAuthenticationLevel value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IMagneticStripeReaderCapabilities>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderCapabilities, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderCapabilities>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_AuthenticationLevel(reinterpret_cast<int32_t*>(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderCapabilities>**)this;
            check_hresult(_winrt_abi_type->get_AuthenticationLevel(reinterpret_cast<int32_t*>(&value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IMagneticStripeReaderCapabilities<D>::IsIsoSupported() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IMagneticStripeReaderCapabilities>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderCapabilities, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderCapabilities>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsIsoSupported(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderCapabilities>**)this;
            check_hresult(_winrt_abi_type->get_IsIsoSupported(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IMagneticStripeReaderCapabilities<D>::IsJisOneSupported() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IMagneticStripeReaderCapabilities>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderCapabilities, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderCapabilities>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsJisOneSupported(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderCapabilities>**)this;
            check_hresult(_winrt_abi_type->get_IsJisOneSupported(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IMagneticStripeReaderCapabilities<D>::IsJisTwoSupported() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IMagneticStripeReaderCapabilities>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderCapabilities, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderCapabilities>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsJisTwoSupported(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderCapabilities>**)this;
            check_hresult(_winrt_abi_type->get_IsJisTwoSupported(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IMagneticStripeReaderCapabilities<D>::PowerReportingType() const
    {
        winrt::Windows::Devices::PointOfService::UnifiedPosPowerReportingType value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IMagneticStripeReaderCapabilities>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderCapabilities, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderCapabilities>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_PowerReportingType(reinterpret_cast<int32_t*>(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderCapabilities>**)this;
            check_hresult(_winrt_abi_type->get_PowerReportingType(reinterpret_cast<int32_t*>(&value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IMagneticStripeReaderCapabilities<D>::IsStatisticsReportingSupported() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IMagneticStripeReaderCapabilities>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderCapabilities, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderCapabilities>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsStatisticsReportingSupported(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderCapabilities>**)this;
            check_hresult(_winrt_abi_type->get_IsStatisticsReportingSupported(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IMagneticStripeReaderCapabilities<D>::IsStatisticsUpdatingSupported() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IMagneticStripeReaderCapabilities>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderCapabilities, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderCapabilities>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsStatisticsUpdatingSupported(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderCapabilities>**)this;
            check_hresult(_winrt_abi_type->get_IsStatisticsUpdatingSupported(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IMagneticStripeReaderCapabilities<D>::IsTrackDataMaskingSupported() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IMagneticStripeReaderCapabilities>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderCapabilities, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderCapabilities>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsTrackDataMaskingSupported(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderCapabilities>**)this;
            check_hresult(_winrt_abi_type->get_IsTrackDataMaskingSupported(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IMagneticStripeReaderCapabilities<D>::IsTransmitSentinelsSupported() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IMagneticStripeReaderCapabilities>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderCapabilities, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderCapabilities>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsTransmitSentinelsSupported(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderCapabilities>**)this;
            check_hresult(_winrt_abi_type->get_IsTransmitSentinelsSupported(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IMagneticStripeReaderCardTypesStatics<D>::Unknown() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IMagneticStripeReaderCardTypesStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderCardTypesStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderCardTypesStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Unknown(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderCardTypesStatics>**)this;
            check_hresult(_winrt_abi_type->get_Unknown(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IMagneticStripeReaderCardTypesStatics<D>::Bank() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IMagneticStripeReaderCardTypesStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderCardTypesStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderCardTypesStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Bank(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderCardTypesStatics>**)this;
            check_hresult(_winrt_abi_type->get_Bank(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IMagneticStripeReaderCardTypesStatics<D>::Aamva() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IMagneticStripeReaderCardTypesStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderCardTypesStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderCardTypesStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Aamva(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderCardTypesStatics>**)this;
            check_hresult(_winrt_abi_type->get_Aamva(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IMagneticStripeReaderCardTypesStatics<D>::ExtendedBase() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IMagneticStripeReaderCardTypesStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderCardTypesStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderCardTypesStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ExtendedBase(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderCardTypesStatics>**)this;
            check_hresult(_winrt_abi_type->get_ExtendedBase(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IMagneticStripeReaderEncryptionAlgorithmsStatics<D>::None() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IMagneticStripeReaderEncryptionAlgorithmsStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderEncryptionAlgorithmsStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderEncryptionAlgorithmsStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_None(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderEncryptionAlgorithmsStatics>**)this;
            check_hresult(_winrt_abi_type->get_None(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IMagneticStripeReaderEncryptionAlgorithmsStatics<D>::TripleDesDukpt() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IMagneticStripeReaderEncryptionAlgorithmsStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderEncryptionAlgorithmsStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderEncryptionAlgorithmsStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_TripleDesDukpt(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderEncryptionAlgorithmsStatics>**)this;
            check_hresult(_winrt_abi_type->get_TripleDesDukpt(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IMagneticStripeReaderEncryptionAlgorithmsStatics<D>::ExtendedBase() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IMagneticStripeReaderEncryptionAlgorithmsStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderEncryptionAlgorithmsStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderEncryptionAlgorithmsStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ExtendedBase(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderEncryptionAlgorithmsStatics>**)this;
            check_hresult(_winrt_abi_type->get_ExtendedBase(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IMagneticStripeReaderErrorOccurredEventArgs<D>::Track1Status() const
    {
        winrt::Windows::Devices::PointOfService::MagneticStripeReaderTrackErrorType value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IMagneticStripeReaderErrorOccurredEventArgs>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderErrorOccurredEventArgs, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderErrorOccurredEventArgs>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Track1Status(reinterpret_cast<int32_t*>(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderErrorOccurredEventArgs>**)this;
            check_hresult(_winrt_abi_type->get_Track1Status(reinterpret_cast<int32_t*>(&value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IMagneticStripeReaderErrorOccurredEventArgs<D>::Track2Status() const
    {
        winrt::Windows::Devices::PointOfService::MagneticStripeReaderTrackErrorType value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IMagneticStripeReaderErrorOccurredEventArgs>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderErrorOccurredEventArgs, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderErrorOccurredEventArgs>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Track2Status(reinterpret_cast<int32_t*>(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderErrorOccurredEventArgs>**)this;
            check_hresult(_winrt_abi_type->get_Track2Status(reinterpret_cast<int32_t*>(&value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IMagneticStripeReaderErrorOccurredEventArgs<D>::Track3Status() const
    {
        winrt::Windows::Devices::PointOfService::MagneticStripeReaderTrackErrorType value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IMagneticStripeReaderErrorOccurredEventArgs>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderErrorOccurredEventArgs, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderErrorOccurredEventArgs>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Track3Status(reinterpret_cast<int32_t*>(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderErrorOccurredEventArgs>**)this;
            check_hresult(_winrt_abi_type->get_Track3Status(reinterpret_cast<int32_t*>(&value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IMagneticStripeReaderErrorOccurredEventArgs<D>::Track4Status() const
    {
        winrt::Windows::Devices::PointOfService::MagneticStripeReaderTrackErrorType value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IMagneticStripeReaderErrorOccurredEventArgs>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderErrorOccurredEventArgs, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderErrorOccurredEventArgs>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Track4Status(reinterpret_cast<int32_t*>(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderErrorOccurredEventArgs>**)this;
            check_hresult(_winrt_abi_type->get_Track4Status(reinterpret_cast<int32_t*>(&value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IMagneticStripeReaderErrorOccurredEventArgs<D>::ErrorData() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IMagneticStripeReaderErrorOccurredEventArgs>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderErrorOccurredEventArgs, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderErrorOccurredEventArgs>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ErrorData(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderErrorOccurredEventArgs>**)this;
            check_hresult(_winrt_abi_type->get_ErrorData(&value));
        }
        return winrt::Windows::Devices::PointOfService::UnifiedPosErrorData{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IMagneticStripeReaderErrorOccurredEventArgs<D>::PartialInputData() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IMagneticStripeReaderErrorOccurredEventArgs>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderErrorOccurredEventArgs, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderErrorOccurredEventArgs>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_PartialInputData(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderErrorOccurredEventArgs>**)this;
            check_hresult(_winrt_abi_type->get_PartialInputData(&value));
        }
        return winrt::Windows::Devices::PointOfService::MagneticStripeReaderReport{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IMagneticStripeReaderReport<D>::CardType() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IMagneticStripeReaderReport>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderReport, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderReport>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_CardType(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderReport>**)this;
            check_hresult(_winrt_abi_type->get_CardType(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IMagneticStripeReaderReport<D>::Track1() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IMagneticStripeReaderReport>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderReport, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderReport>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Track1(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderReport>**)this;
            check_hresult(_winrt_abi_type->get_Track1(&value));
        }
        return winrt::Windows::Devices::PointOfService::MagneticStripeReaderTrackData{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IMagneticStripeReaderReport<D>::Track2() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IMagneticStripeReaderReport>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderReport, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderReport>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Track2(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderReport>**)this;
            check_hresult(_winrt_abi_type->get_Track2(&value));
        }
        return winrt::Windows::Devices::PointOfService::MagneticStripeReaderTrackData{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IMagneticStripeReaderReport<D>::Track3() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IMagneticStripeReaderReport>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderReport, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderReport>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Track3(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderReport>**)this;
            check_hresult(_winrt_abi_type->get_Track3(&value));
        }
        return winrt::Windows::Devices::PointOfService::MagneticStripeReaderTrackData{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IMagneticStripeReaderReport<D>::Track4() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IMagneticStripeReaderReport>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderReport, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderReport>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Track4(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderReport>**)this;
            check_hresult(_winrt_abi_type->get_Track4(&value));
        }
        return winrt::Windows::Devices::PointOfService::MagneticStripeReaderTrackData{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IMagneticStripeReaderReport<D>::Properties() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IMagneticStripeReaderReport>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderReport, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderReport>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Properties(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderReport>**)this;
            check_hresult(_winrt_abi_type->get_Properties(&value));
        }
        return winrt::Windows::Foundation::Collections::IMapView<hstring, hstring>{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IMagneticStripeReaderReport<D>::CardAuthenticationData() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IMagneticStripeReaderReport>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderReport, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderReport>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_CardAuthenticationData(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderReport>**)this;
            check_hresult(_winrt_abi_type->get_CardAuthenticationData(&value));
        }
        return winrt::Windows::Storage::Streams::IBuffer{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IMagneticStripeReaderReport<D>::CardAuthenticationDataLength() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IMagneticStripeReaderReport>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderReport, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderReport>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_CardAuthenticationDataLength(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderReport>**)this;
            check_hresult(_winrt_abi_type->get_CardAuthenticationDataLength(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IMagneticStripeReaderReport<D>::AdditionalSecurityInformation() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IMagneticStripeReaderReport>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderReport, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderReport>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_AdditionalSecurityInformation(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderReport>**)this;
            check_hresult(_winrt_abi_type->get_AdditionalSecurityInformation(&value));
        }
        return winrt::Windows::Storage::Streams::IBuffer{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IMagneticStripeReaderStatics<D>::GetDefaultAsync() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IMagneticStripeReaderStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetDefaultAsync(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderStatics>**)this;
            check_hresult(_winrt_abi_type->GetDefaultAsync(&result));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Devices::PointOfService::MagneticStripeReader>{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IMagneticStripeReaderStatics<D>::FromIdAsync(param::hstring const& deviceId) const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IMagneticStripeReaderStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->FromIdAsync(*(void**)(&deviceId), &result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderStatics>**)this;
            check_hresult(_winrt_abi_type->FromIdAsync(*(void**)(&deviceId), &result));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Devices::PointOfService::MagneticStripeReader>{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IMagneticStripeReaderStatics<D>::GetDeviceSelector() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IMagneticStripeReaderStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetDeviceSelector(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderStatics>**)this;
            check_hresult(_winrt_abi_type->GetDeviceSelector(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IMagneticStripeReaderStatics2<D>::GetDeviceSelector(winrt::Windows::Devices::PointOfService::PosConnectionTypes const& connectionTypes) const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IMagneticStripeReaderStatics2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderStatics2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderStatics2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetDeviceSelectorWithConnectionTypes(static_cast<uint32_t>(connectionTypes), &value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderStatics2>**)this;
            check_hresult(_winrt_abi_type->GetDeviceSelectorWithConnectionTypes(static_cast<uint32_t>(connectionTypes), &value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IMagneticStripeReaderStatusUpdatedEventArgs<D>::Status() const
    {
        winrt::Windows::Devices::PointOfService::MagneticStripeReaderStatus value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IMagneticStripeReaderStatusUpdatedEventArgs>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderStatusUpdatedEventArgs, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderStatusUpdatedEventArgs>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Status(reinterpret_cast<int32_t*>(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderStatusUpdatedEventArgs>**)this;
            check_hresult(_winrt_abi_type->get_Status(reinterpret_cast<int32_t*>(&value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IMagneticStripeReaderStatusUpdatedEventArgs<D>::ExtendedStatus() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IMagneticStripeReaderStatusUpdatedEventArgs>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderStatusUpdatedEventArgs, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderStatusUpdatedEventArgs>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ExtendedStatus(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderStatusUpdatedEventArgs>**)this;
            check_hresult(_winrt_abi_type->get_ExtendedStatus(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IMagneticStripeReaderTrackData<D>::Data() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IMagneticStripeReaderTrackData>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderTrackData, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderTrackData>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Data(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderTrackData>**)this;
            check_hresult(_winrt_abi_type->get_Data(&value));
        }
        return winrt::Windows::Storage::Streams::IBuffer{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IMagneticStripeReaderTrackData<D>::DiscretionaryData() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IMagneticStripeReaderTrackData>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderTrackData, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderTrackData>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_DiscretionaryData(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderTrackData>**)this;
            check_hresult(_winrt_abi_type->get_DiscretionaryData(&value));
        }
        return winrt::Windows::Storage::Streams::IBuffer{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IMagneticStripeReaderTrackData<D>::EncryptedData() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IMagneticStripeReaderTrackData>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderTrackData, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderTrackData>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_EncryptedData(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderTrackData>**)this;
            check_hresult(_winrt_abi_type->get_EncryptedData(&value));
        }
        return winrt::Windows::Storage::Streams::IBuffer{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IMagneticStripeReaderVendorSpecificCardDataReceivedEventArgs<D>::Report() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IMagneticStripeReaderVendorSpecificCardDataReceivedEventArgs>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderVendorSpecificCardDataReceivedEventArgs, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderVendorSpecificCardDataReceivedEventArgs>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Report(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IMagneticStripeReaderVendorSpecificCardDataReceivedEventArgs>**)this;
            check_hresult(_winrt_abi_type->get_Report(&value));
        }
        return winrt::Windows::Devices::PointOfService::MagneticStripeReaderReport{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IPosPrinter<D>::DeviceId() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IPosPrinter>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IPosPrinter, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IPosPrinter>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_DeviceId(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IPosPrinter>**)this;
            check_hresult(_winrt_abi_type->get_DeviceId(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IPosPrinter<D>::Capabilities() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IPosPrinter>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IPosPrinter, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IPosPrinter>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Capabilities(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IPosPrinter>**)this;
            check_hresult(_winrt_abi_type->get_Capabilities(&value));
        }
        return winrt::Windows::Devices::PointOfService::PosPrinterCapabilities{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IPosPrinter<D>::SupportedCharacterSets() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IPosPrinter>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IPosPrinter, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IPosPrinter>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_SupportedCharacterSets(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IPosPrinter>**)this;
            check_hresult(_winrt_abi_type->get_SupportedCharacterSets(&value));
        }
        return winrt::Windows::Foundation::Collections::IVectorView<uint32_t>{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IPosPrinter<D>::SupportedTypeFaces() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IPosPrinter>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IPosPrinter, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IPosPrinter>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_SupportedTypeFaces(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IPosPrinter>**)this;
            check_hresult(_winrt_abi_type->get_SupportedTypeFaces(&value));
        }
        return winrt::Windows::Foundation::Collections::IVectorView<hstring>{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IPosPrinter<D>::Status() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IPosPrinter>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IPosPrinter, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IPosPrinter>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Status(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IPosPrinter>**)this;
            check_hresult(_winrt_abi_type->get_Status(&value));
        }
        return winrt::Windows::Devices::PointOfService::PosPrinterStatus{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IPosPrinter<D>::ClaimPrinterAsync() const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IPosPrinter>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IPosPrinter, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IPosPrinter>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->ClaimPrinterAsync(&operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IPosPrinter>**)this;
            check_hresult(_winrt_abi_type->ClaimPrinterAsync(&operation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Devices::PointOfService::ClaimedPosPrinter>{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IPosPrinter<D>::CheckHealthAsync(winrt::Windows::Devices::PointOfService::UnifiedPosHealthCheckLevel const& level) const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IPosPrinter>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IPosPrinter, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IPosPrinter>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CheckHealthAsync(static_cast<int32_t>(level), &operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IPosPrinter>**)this;
            check_hresult(_winrt_abi_type->CheckHealthAsync(static_cast<int32_t>(level), &operation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<hstring>{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IPosPrinter<D>::GetStatisticsAsync(param::async_iterable<hstring> const& statisticsCategories) const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IPosPrinter>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IPosPrinter, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IPosPrinter>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetStatisticsAsync(*(void**)(&statisticsCategories), &operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IPosPrinter>**)this;
            check_hresult(_winrt_abi_type->GetStatisticsAsync(*(void**)(&statisticsCategories), &operation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<hstring>{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IPosPrinter<D>::StatusUpdated(winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::Devices::PointOfService::PosPrinter, winrt::Windows::Devices::PointOfService::PosPrinterStatusUpdatedEventArgs> const& handler) const
    {
        winrt::event_token token{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IPosPrinter>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IPosPrinter, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IPosPrinter>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->add_StatusUpdated(*(void**)(&handler), put_abi(token)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IPosPrinter>**)this;
            check_hresult(_winrt_abi_type->add_StatusUpdated(*(void**)(&handler), put_abi(token)));
        }
        return token;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IPosPrinter<D>::StatusUpdated(auto_revoke_t, winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::Devices::PointOfService::PosPrinter, winrt::Windows::Devices::PointOfService::PosPrinterStatusUpdatedEventArgs> const& handler) const
    {
        return impl::make_event_revoker<D, StatusUpdated_revoker>(this, StatusUpdated(handler));
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IPosPrinter<D>::StatusUpdated(winrt::event_token const& token) const noexcept
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IPosPrinter>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IPosPrinter, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IPosPrinter>**)&_winrt_casted_result;
            _winrt_abi_type->remove_StatusUpdated(impl::bind_in(token));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IPosPrinter>**)this;
            _winrt_abi_type->remove_StatusUpdated(impl::bind_in(token));
        }
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IPosPrinter2<D>::SupportedBarcodeSymbologies() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IPosPrinter2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IPosPrinter2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IPosPrinter2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_SupportedBarcodeSymbologies(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IPosPrinter2>**)this;
            check_hresult(_winrt_abi_type->get_SupportedBarcodeSymbologies(&value));
        }
        return winrt::Windows::Foundation::Collections::IVectorView<uint32_t>{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IPosPrinter2<D>::GetFontProperty(param::hstring const& typeface) const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IPosPrinter2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IPosPrinter2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IPosPrinter2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetFontProperty(*(void**)(&typeface), &result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IPosPrinter2>**)this;
            check_hresult(_winrt_abi_type->GetFontProperty(*(void**)(&typeface), &result));
        }
        return winrt::Windows::Devices::PointOfService::PosPrinterFontProperty{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IPosPrinterCapabilities<D>::PowerReportingType() const
    {
        winrt::Windows::Devices::PointOfService::UnifiedPosPowerReportingType value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IPosPrinterCapabilities>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IPosPrinterCapabilities, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IPosPrinterCapabilities>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_PowerReportingType(reinterpret_cast<int32_t*>(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IPosPrinterCapabilities>**)this;
            check_hresult(_winrt_abi_type->get_PowerReportingType(reinterpret_cast<int32_t*>(&value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IPosPrinterCapabilities<D>::IsStatisticsReportingSupported() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IPosPrinterCapabilities>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IPosPrinterCapabilities, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IPosPrinterCapabilities>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsStatisticsReportingSupported(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IPosPrinterCapabilities>**)this;
            check_hresult(_winrt_abi_type->get_IsStatisticsReportingSupported(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IPosPrinterCapabilities<D>::IsStatisticsUpdatingSupported() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IPosPrinterCapabilities>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IPosPrinterCapabilities, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IPosPrinterCapabilities>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsStatisticsUpdatingSupported(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IPosPrinterCapabilities>**)this;
            check_hresult(_winrt_abi_type->get_IsStatisticsUpdatingSupported(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IPosPrinterCapabilities<D>::DefaultCharacterSet() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IPosPrinterCapabilities>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IPosPrinterCapabilities, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IPosPrinterCapabilities>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_DefaultCharacterSet(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IPosPrinterCapabilities>**)this;
            check_hresult(_winrt_abi_type->get_DefaultCharacterSet(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IPosPrinterCapabilities<D>::HasCoverSensor() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IPosPrinterCapabilities>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IPosPrinterCapabilities, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IPosPrinterCapabilities>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_HasCoverSensor(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IPosPrinterCapabilities>**)this;
            check_hresult(_winrt_abi_type->get_HasCoverSensor(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IPosPrinterCapabilities<D>::CanMapCharacterSet() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IPosPrinterCapabilities>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IPosPrinterCapabilities, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IPosPrinterCapabilities>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_CanMapCharacterSet(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IPosPrinterCapabilities>**)this;
            check_hresult(_winrt_abi_type->get_CanMapCharacterSet(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IPosPrinterCapabilities<D>::IsTransactionSupported() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IPosPrinterCapabilities>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IPosPrinterCapabilities, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IPosPrinterCapabilities>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsTransactionSupported(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IPosPrinterCapabilities>**)this;
            check_hresult(_winrt_abi_type->get_IsTransactionSupported(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IPosPrinterCapabilities<D>::Receipt() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IPosPrinterCapabilities>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IPosPrinterCapabilities, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IPosPrinterCapabilities>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Receipt(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IPosPrinterCapabilities>**)this;
            check_hresult(_winrt_abi_type->get_Receipt(&value));
        }
        return winrt::Windows::Devices::PointOfService::ReceiptPrinterCapabilities{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IPosPrinterCapabilities<D>::Slip() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IPosPrinterCapabilities>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IPosPrinterCapabilities, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IPosPrinterCapabilities>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Slip(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IPosPrinterCapabilities>**)this;
            check_hresult(_winrt_abi_type->get_Slip(&value));
        }
        return winrt::Windows::Devices::PointOfService::SlipPrinterCapabilities{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IPosPrinterCapabilities<D>::Journal() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IPosPrinterCapabilities>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IPosPrinterCapabilities, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IPosPrinterCapabilities>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Journal(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IPosPrinterCapabilities>**)this;
            check_hresult(_winrt_abi_type->get_Journal(&value));
        }
        return winrt::Windows::Devices::PointOfService::JournalPrinterCapabilities{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IPosPrinterCharacterSetIdsStatics<D>::Utf16LE() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IPosPrinterCharacterSetIdsStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IPosPrinterCharacterSetIdsStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IPosPrinterCharacterSetIdsStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Utf16LE(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IPosPrinterCharacterSetIdsStatics>**)this;
            check_hresult(_winrt_abi_type->get_Utf16LE(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IPosPrinterCharacterSetIdsStatics<D>::Ascii() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IPosPrinterCharacterSetIdsStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IPosPrinterCharacterSetIdsStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IPosPrinterCharacterSetIdsStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Ascii(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IPosPrinterCharacterSetIdsStatics>**)this;
            check_hresult(_winrt_abi_type->get_Ascii(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IPosPrinterCharacterSetIdsStatics<D>::Ansi() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IPosPrinterCharacterSetIdsStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IPosPrinterCharacterSetIdsStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IPosPrinterCharacterSetIdsStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Ansi(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IPosPrinterCharacterSetIdsStatics>**)this;
            check_hresult(_winrt_abi_type->get_Ansi(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IPosPrinterFontProperty<D>::TypeFace() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IPosPrinterFontProperty>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IPosPrinterFontProperty, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IPosPrinterFontProperty>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_TypeFace(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IPosPrinterFontProperty>**)this;
            check_hresult(_winrt_abi_type->get_TypeFace(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IPosPrinterFontProperty<D>::IsScalableToAnySize() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IPosPrinterFontProperty>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IPosPrinterFontProperty, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IPosPrinterFontProperty>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsScalableToAnySize(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IPosPrinterFontProperty>**)this;
            check_hresult(_winrt_abi_type->get_IsScalableToAnySize(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IPosPrinterFontProperty<D>::CharacterSizes() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IPosPrinterFontProperty>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IPosPrinterFontProperty, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IPosPrinterFontProperty>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_CharacterSizes(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IPosPrinterFontProperty>**)this;
            check_hresult(_winrt_abi_type->get_CharacterSizes(&value));
        }
        return winrt::Windows::Foundation::Collections::IVectorView<winrt::Windows::Devices::PointOfService::SizeUInt32>{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IPosPrinterJob<D>::Print(param::hstring const& data) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IPosPrinterJob>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IPosPrinterJob, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IPosPrinterJob>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->Print(*(void**)(&data)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IPosPrinterJob>**)this;
            check_hresult(_winrt_abi_type->Print(*(void**)(&data)));
        }
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IPosPrinterJob<D>::PrintLine(param::hstring const& data) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IPosPrinterJob>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IPosPrinterJob, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IPosPrinterJob>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->PrintLine(*(void**)(&data)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IPosPrinterJob>**)this;
            check_hresult(_winrt_abi_type->PrintLine(*(void**)(&data)));
        }
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IPosPrinterJob<D>::PrintLine() const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IPosPrinterJob>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IPosPrinterJob, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IPosPrinterJob>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->PrintNewline());
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IPosPrinterJob>**)this;
            check_hresult(_winrt_abi_type->PrintNewline());
        }
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IPosPrinterJob<D>::ExecuteAsync() const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IPosPrinterJob>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IPosPrinterJob, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IPosPrinterJob>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->ExecuteAsync(&operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IPosPrinterJob>**)this;
            check_hresult(_winrt_abi_type->ExecuteAsync(&operation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<bool>{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IPosPrinterPrintOptions<D>::TypeFace() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IPosPrinterPrintOptions>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IPosPrinterPrintOptions, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IPosPrinterPrintOptions>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_TypeFace(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IPosPrinterPrintOptions>**)this;
            check_hresult(_winrt_abi_type->get_TypeFace(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IPosPrinterPrintOptions<D>::TypeFace(param::hstring const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IPosPrinterPrintOptions>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IPosPrinterPrintOptions, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IPosPrinterPrintOptions>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_TypeFace(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IPosPrinterPrintOptions>**)this;
            check_hresult(_winrt_abi_type->put_TypeFace(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IPosPrinterPrintOptions<D>::CharacterHeight() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IPosPrinterPrintOptions>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IPosPrinterPrintOptions, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IPosPrinterPrintOptions>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_CharacterHeight(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IPosPrinterPrintOptions>**)this;
            check_hresult(_winrt_abi_type->get_CharacterHeight(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IPosPrinterPrintOptions<D>::CharacterHeight(uint32_t value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IPosPrinterPrintOptions>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IPosPrinterPrintOptions, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IPosPrinterPrintOptions>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_CharacterHeight(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IPosPrinterPrintOptions>**)this;
            check_hresult(_winrt_abi_type->put_CharacterHeight(value));
        }
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IPosPrinterPrintOptions<D>::Bold() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IPosPrinterPrintOptions>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IPosPrinterPrintOptions, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IPosPrinterPrintOptions>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Bold(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IPosPrinterPrintOptions>**)this;
            check_hresult(_winrt_abi_type->get_Bold(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IPosPrinterPrintOptions<D>::Bold(bool value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IPosPrinterPrintOptions>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IPosPrinterPrintOptions, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IPosPrinterPrintOptions>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Bold(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IPosPrinterPrintOptions>**)this;
            check_hresult(_winrt_abi_type->put_Bold(value));
        }
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IPosPrinterPrintOptions<D>::Italic() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IPosPrinterPrintOptions>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IPosPrinterPrintOptions, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IPosPrinterPrintOptions>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Italic(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IPosPrinterPrintOptions>**)this;
            check_hresult(_winrt_abi_type->get_Italic(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IPosPrinterPrintOptions<D>::Italic(bool value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IPosPrinterPrintOptions>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IPosPrinterPrintOptions, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IPosPrinterPrintOptions>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Italic(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IPosPrinterPrintOptions>**)this;
            check_hresult(_winrt_abi_type->put_Italic(value));
        }
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IPosPrinterPrintOptions<D>::Underline() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IPosPrinterPrintOptions>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IPosPrinterPrintOptions, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IPosPrinterPrintOptions>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Underline(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IPosPrinterPrintOptions>**)this;
            check_hresult(_winrt_abi_type->get_Underline(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IPosPrinterPrintOptions<D>::Underline(bool value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IPosPrinterPrintOptions>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IPosPrinterPrintOptions, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IPosPrinterPrintOptions>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Underline(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IPosPrinterPrintOptions>**)this;
            check_hresult(_winrt_abi_type->put_Underline(value));
        }
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IPosPrinterPrintOptions<D>::ReverseVideo() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IPosPrinterPrintOptions>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IPosPrinterPrintOptions, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IPosPrinterPrintOptions>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ReverseVideo(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IPosPrinterPrintOptions>**)this;
            check_hresult(_winrt_abi_type->get_ReverseVideo(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IPosPrinterPrintOptions<D>::ReverseVideo(bool value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IPosPrinterPrintOptions>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IPosPrinterPrintOptions, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IPosPrinterPrintOptions>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_ReverseVideo(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IPosPrinterPrintOptions>**)this;
            check_hresult(_winrt_abi_type->put_ReverseVideo(value));
        }
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IPosPrinterPrintOptions<D>::Strikethrough() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IPosPrinterPrintOptions>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IPosPrinterPrintOptions, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IPosPrinterPrintOptions>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Strikethrough(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IPosPrinterPrintOptions>**)this;
            check_hresult(_winrt_abi_type->get_Strikethrough(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IPosPrinterPrintOptions<D>::Strikethrough(bool value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IPosPrinterPrintOptions>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IPosPrinterPrintOptions, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IPosPrinterPrintOptions>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Strikethrough(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IPosPrinterPrintOptions>**)this;
            check_hresult(_winrt_abi_type->put_Strikethrough(value));
        }
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IPosPrinterPrintOptions<D>::Superscript() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IPosPrinterPrintOptions>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IPosPrinterPrintOptions, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IPosPrinterPrintOptions>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Superscript(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IPosPrinterPrintOptions>**)this;
            check_hresult(_winrt_abi_type->get_Superscript(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IPosPrinterPrintOptions<D>::Superscript(bool value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IPosPrinterPrintOptions>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IPosPrinterPrintOptions, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IPosPrinterPrintOptions>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Superscript(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IPosPrinterPrintOptions>**)this;
            check_hresult(_winrt_abi_type->put_Superscript(value));
        }
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IPosPrinterPrintOptions<D>::Subscript() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IPosPrinterPrintOptions>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IPosPrinterPrintOptions, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IPosPrinterPrintOptions>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Subscript(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IPosPrinterPrintOptions>**)this;
            check_hresult(_winrt_abi_type->get_Subscript(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IPosPrinterPrintOptions<D>::Subscript(bool value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IPosPrinterPrintOptions>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IPosPrinterPrintOptions, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IPosPrinterPrintOptions>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Subscript(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IPosPrinterPrintOptions>**)this;
            check_hresult(_winrt_abi_type->put_Subscript(value));
        }
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IPosPrinterPrintOptions<D>::DoubleWide() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IPosPrinterPrintOptions>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IPosPrinterPrintOptions, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IPosPrinterPrintOptions>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_DoubleWide(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IPosPrinterPrintOptions>**)this;
            check_hresult(_winrt_abi_type->get_DoubleWide(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IPosPrinterPrintOptions<D>::DoubleWide(bool value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IPosPrinterPrintOptions>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IPosPrinterPrintOptions, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IPosPrinterPrintOptions>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_DoubleWide(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IPosPrinterPrintOptions>**)this;
            check_hresult(_winrt_abi_type->put_DoubleWide(value));
        }
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IPosPrinterPrintOptions<D>::DoubleHigh() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IPosPrinterPrintOptions>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IPosPrinterPrintOptions, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IPosPrinterPrintOptions>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_DoubleHigh(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IPosPrinterPrintOptions>**)this;
            check_hresult(_winrt_abi_type->get_DoubleHigh(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IPosPrinterPrintOptions<D>::DoubleHigh(bool value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IPosPrinterPrintOptions>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IPosPrinterPrintOptions, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IPosPrinterPrintOptions>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_DoubleHigh(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IPosPrinterPrintOptions>**)this;
            check_hresult(_winrt_abi_type->put_DoubleHigh(value));
        }
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IPosPrinterPrintOptions<D>::Alignment() const
    {
        winrt::Windows::Devices::PointOfService::PosPrinterAlignment value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IPosPrinterPrintOptions>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IPosPrinterPrintOptions, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IPosPrinterPrintOptions>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Alignment(reinterpret_cast<int32_t*>(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IPosPrinterPrintOptions>**)this;
            check_hresult(_winrt_abi_type->get_Alignment(reinterpret_cast<int32_t*>(&value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IPosPrinterPrintOptions<D>::Alignment(winrt::Windows::Devices::PointOfService::PosPrinterAlignment const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IPosPrinterPrintOptions>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IPosPrinterPrintOptions, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IPosPrinterPrintOptions>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Alignment(static_cast<int32_t>(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IPosPrinterPrintOptions>**)this;
            check_hresult(_winrt_abi_type->put_Alignment(static_cast<int32_t>(value)));
        }
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IPosPrinterPrintOptions<D>::CharacterSet() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IPosPrinterPrintOptions>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IPosPrinterPrintOptions, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IPosPrinterPrintOptions>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_CharacterSet(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IPosPrinterPrintOptions>**)this;
            check_hresult(_winrt_abi_type->get_CharacterSet(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IPosPrinterPrintOptions<D>::CharacterSet(uint32_t value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IPosPrinterPrintOptions>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IPosPrinterPrintOptions, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IPosPrinterPrintOptions>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_CharacterSet(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IPosPrinterPrintOptions>**)this;
            check_hresult(_winrt_abi_type->put_CharacterSet(value));
        }
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IPosPrinterStatics<D>::GetDefaultAsync() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IPosPrinterStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IPosPrinterStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IPosPrinterStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetDefaultAsync(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IPosPrinterStatics>**)this;
            check_hresult(_winrt_abi_type->GetDefaultAsync(&result));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Devices::PointOfService::PosPrinter>{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IPosPrinterStatics<D>::FromIdAsync(param::hstring const& deviceId) const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IPosPrinterStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IPosPrinterStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IPosPrinterStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->FromIdAsync(*(void**)(&deviceId), &result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IPosPrinterStatics>**)this;
            check_hresult(_winrt_abi_type->FromIdAsync(*(void**)(&deviceId), &result));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Devices::PointOfService::PosPrinter>{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IPosPrinterStatics<D>::GetDeviceSelector() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IPosPrinterStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IPosPrinterStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IPosPrinterStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetDeviceSelector(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IPosPrinterStatics>**)this;
            check_hresult(_winrt_abi_type->GetDeviceSelector(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IPosPrinterStatics2<D>::GetDeviceSelector(winrt::Windows::Devices::PointOfService::PosConnectionTypes const& connectionTypes) const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IPosPrinterStatics2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IPosPrinterStatics2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IPosPrinterStatics2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetDeviceSelectorWithConnectionTypes(static_cast<uint32_t>(connectionTypes), &value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IPosPrinterStatics2>**)this;
            check_hresult(_winrt_abi_type->GetDeviceSelectorWithConnectionTypes(static_cast<uint32_t>(connectionTypes), &value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IPosPrinterStatus<D>::StatusKind() const
    {
        winrt::Windows::Devices::PointOfService::PosPrinterStatusKind value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IPosPrinterStatus>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IPosPrinterStatus, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IPosPrinterStatus>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_StatusKind(reinterpret_cast<int32_t*>(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IPosPrinterStatus>**)this;
            check_hresult(_winrt_abi_type->get_StatusKind(reinterpret_cast<int32_t*>(&value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IPosPrinterStatus<D>::ExtendedStatus() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IPosPrinterStatus>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IPosPrinterStatus, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IPosPrinterStatus>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ExtendedStatus(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IPosPrinterStatus>**)this;
            check_hresult(_winrt_abi_type->get_ExtendedStatus(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IPosPrinterStatusUpdatedEventArgs<D>::Status() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IPosPrinterStatusUpdatedEventArgs>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IPosPrinterStatusUpdatedEventArgs, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IPosPrinterStatusUpdatedEventArgs>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Status(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IPosPrinterStatusUpdatedEventArgs>**)this;
            check_hresult(_winrt_abi_type->get_Status(&value));
        }
        return winrt::Windows::Devices::PointOfService::PosPrinterStatus{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IReceiptOrSlipJob<D>::SetBarcodeRotation(winrt::Windows::Devices::PointOfService::PosPrinterRotation const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IReceiptOrSlipJob>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IReceiptOrSlipJob, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IReceiptOrSlipJob>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->SetBarcodeRotation(static_cast<int32_t>(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IReceiptOrSlipJob>**)this;
            check_hresult(_winrt_abi_type->SetBarcodeRotation(static_cast<int32_t>(value)));
        }
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IReceiptOrSlipJob<D>::SetPrintRotation(winrt::Windows::Devices::PointOfService::PosPrinterRotation const& value, bool includeBitmaps) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IReceiptOrSlipJob>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IReceiptOrSlipJob, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IReceiptOrSlipJob>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->SetPrintRotation(static_cast<int32_t>(value), includeBitmaps));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IReceiptOrSlipJob>**)this;
            check_hresult(_winrt_abi_type->SetPrintRotation(static_cast<int32_t>(value), includeBitmaps));
        }
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IReceiptOrSlipJob<D>::SetPrintArea(winrt::Windows::Foundation::Rect const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IReceiptOrSlipJob>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IReceiptOrSlipJob, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IReceiptOrSlipJob>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->SetPrintArea(impl::bind_in(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IReceiptOrSlipJob>**)this;
            check_hresult(_winrt_abi_type->SetPrintArea(impl::bind_in(value)));
        }
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IReceiptOrSlipJob<D>::SetBitmap(uint32_t bitmapNumber, winrt::Windows::Graphics::Imaging::BitmapFrame const& bitmap, winrt::Windows::Devices::PointOfService::PosPrinterAlignment const& alignment) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IReceiptOrSlipJob>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IReceiptOrSlipJob, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IReceiptOrSlipJob>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->SetBitmap(bitmapNumber, *(void**)(&bitmap), static_cast<int32_t>(alignment)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IReceiptOrSlipJob>**)this;
            check_hresult(_winrt_abi_type->SetBitmap(bitmapNumber, *(void**)(&bitmap), static_cast<int32_t>(alignment)));
        }
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IReceiptOrSlipJob<D>::SetBitmap(uint32_t bitmapNumber, winrt::Windows::Graphics::Imaging::BitmapFrame const& bitmap, winrt::Windows::Devices::PointOfService::PosPrinterAlignment const& alignment, uint32_t width) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IReceiptOrSlipJob>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IReceiptOrSlipJob, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IReceiptOrSlipJob>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->SetBitmapCustomWidthStandardAlign(bitmapNumber, *(void**)(&bitmap), static_cast<int32_t>(alignment), width));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IReceiptOrSlipJob>**)this;
            check_hresult(_winrt_abi_type->SetBitmapCustomWidthStandardAlign(bitmapNumber, *(void**)(&bitmap), static_cast<int32_t>(alignment), width));
        }
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IReceiptOrSlipJob<D>::SetCustomAlignedBitmap(uint32_t bitmapNumber, winrt::Windows::Graphics::Imaging::BitmapFrame const& bitmap, uint32_t alignmentDistance) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IReceiptOrSlipJob>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IReceiptOrSlipJob, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IReceiptOrSlipJob>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->SetCustomAlignedBitmap(bitmapNumber, *(void**)(&bitmap), alignmentDistance));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IReceiptOrSlipJob>**)this;
            check_hresult(_winrt_abi_type->SetCustomAlignedBitmap(bitmapNumber, *(void**)(&bitmap), alignmentDistance));
        }
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IReceiptOrSlipJob<D>::SetCustomAlignedBitmap(uint32_t bitmapNumber, winrt::Windows::Graphics::Imaging::BitmapFrame const& bitmap, uint32_t alignmentDistance, uint32_t width) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IReceiptOrSlipJob>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IReceiptOrSlipJob, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IReceiptOrSlipJob>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->SetBitmapCustomWidthCustomAlign(bitmapNumber, *(void**)(&bitmap), alignmentDistance, width));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IReceiptOrSlipJob>**)this;
            check_hresult(_winrt_abi_type->SetBitmapCustomWidthCustomAlign(bitmapNumber, *(void**)(&bitmap), alignmentDistance, width));
        }
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IReceiptOrSlipJob<D>::PrintSavedBitmap(uint32_t bitmapNumber) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IReceiptOrSlipJob>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IReceiptOrSlipJob, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IReceiptOrSlipJob>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->PrintSavedBitmap(bitmapNumber));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IReceiptOrSlipJob>**)this;
            check_hresult(_winrt_abi_type->PrintSavedBitmap(bitmapNumber));
        }
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IReceiptOrSlipJob<D>::DrawRuledLine(param::hstring const& positionList, winrt::Windows::Devices::PointOfService::PosPrinterLineDirection const& lineDirection, uint32_t lineWidth, winrt::Windows::Devices::PointOfService::PosPrinterLineStyle const& lineStyle, uint32_t lineColor) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IReceiptOrSlipJob>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IReceiptOrSlipJob, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IReceiptOrSlipJob>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->DrawRuledLine(*(void**)(&positionList), static_cast<int32_t>(lineDirection), lineWidth, static_cast<int32_t>(lineStyle), lineColor));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IReceiptOrSlipJob>**)this;
            check_hresult(_winrt_abi_type->DrawRuledLine(*(void**)(&positionList), static_cast<int32_t>(lineDirection), lineWidth, static_cast<int32_t>(lineStyle), lineColor));
        }
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IReceiptOrSlipJob<D>::PrintBarcode(param::hstring const& data, uint32_t symbology, uint32_t height, uint32_t width, winrt::Windows::Devices::PointOfService::PosPrinterBarcodeTextPosition const& textPosition, winrt::Windows::Devices::PointOfService::PosPrinterAlignment const& alignment) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IReceiptOrSlipJob>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IReceiptOrSlipJob, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IReceiptOrSlipJob>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->PrintBarcode(*(void**)(&data), symbology, height, width, static_cast<int32_t>(textPosition), static_cast<int32_t>(alignment)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IReceiptOrSlipJob>**)this;
            check_hresult(_winrt_abi_type->PrintBarcode(*(void**)(&data), symbology, height, width, static_cast<int32_t>(textPosition), static_cast<int32_t>(alignment)));
        }
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IReceiptOrSlipJob<D>::PrintBarcodeCustomAlign(param::hstring const& data, uint32_t symbology, uint32_t height, uint32_t width, winrt::Windows::Devices::PointOfService::PosPrinterBarcodeTextPosition const& textPosition, uint32_t alignmentDistance) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IReceiptOrSlipJob>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IReceiptOrSlipJob, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IReceiptOrSlipJob>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->PrintBarcodeCustomAlign(*(void**)(&data), symbology, height, width, static_cast<int32_t>(textPosition), alignmentDistance));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IReceiptOrSlipJob>**)this;
            check_hresult(_winrt_abi_type->PrintBarcodeCustomAlign(*(void**)(&data), symbology, height, width, static_cast<int32_t>(textPosition), alignmentDistance));
        }
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IReceiptOrSlipJob<D>::PrintBitmap(winrt::Windows::Graphics::Imaging::BitmapFrame const& bitmap, winrt::Windows::Devices::PointOfService::PosPrinterAlignment const& alignment) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IReceiptOrSlipJob>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IReceiptOrSlipJob, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IReceiptOrSlipJob>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->PrintBitmap(*(void**)(&bitmap), static_cast<int32_t>(alignment)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IReceiptOrSlipJob>**)this;
            check_hresult(_winrt_abi_type->PrintBitmap(*(void**)(&bitmap), static_cast<int32_t>(alignment)));
        }
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IReceiptOrSlipJob<D>::PrintBitmap(winrt::Windows::Graphics::Imaging::BitmapFrame const& bitmap, winrt::Windows::Devices::PointOfService::PosPrinterAlignment const& alignment, uint32_t width) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IReceiptOrSlipJob>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IReceiptOrSlipJob, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IReceiptOrSlipJob>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->PrintBitmapCustomWidthStandardAlign(*(void**)(&bitmap), static_cast<int32_t>(alignment), width));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IReceiptOrSlipJob>**)this;
            check_hresult(_winrt_abi_type->PrintBitmapCustomWidthStandardAlign(*(void**)(&bitmap), static_cast<int32_t>(alignment), width));
        }
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IReceiptOrSlipJob<D>::PrintCustomAlignedBitmap(winrt::Windows::Graphics::Imaging::BitmapFrame const& bitmap, uint32_t alignmentDistance) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IReceiptOrSlipJob>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IReceiptOrSlipJob, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IReceiptOrSlipJob>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->PrintCustomAlignedBitmap(*(void**)(&bitmap), alignmentDistance));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IReceiptOrSlipJob>**)this;
            check_hresult(_winrt_abi_type->PrintCustomAlignedBitmap(*(void**)(&bitmap), alignmentDistance));
        }
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IReceiptOrSlipJob<D>::PrintCustomAlignedBitmap(winrt::Windows::Graphics::Imaging::BitmapFrame const& bitmap, uint32_t alignmentDistance, uint32_t width) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IReceiptOrSlipJob>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IReceiptOrSlipJob, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IReceiptOrSlipJob>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->PrintBitmapCustomWidthCustomAlign(*(void**)(&bitmap), alignmentDistance, width));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IReceiptOrSlipJob>**)this;
            check_hresult(_winrt_abi_type->PrintBitmapCustomWidthCustomAlign(*(void**)(&bitmap), alignmentDistance, width));
        }
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IReceiptPrintJob<D>::MarkFeed(winrt::Windows::Devices::PointOfService::PosPrinterMarkFeedKind const& kind) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IReceiptPrintJob>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IReceiptPrintJob, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IReceiptPrintJob>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->MarkFeed(static_cast<int32_t>(kind)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IReceiptPrintJob>**)this;
            check_hresult(_winrt_abi_type->MarkFeed(static_cast<int32_t>(kind)));
        }
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IReceiptPrintJob<D>::CutPaper(double percentage) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IReceiptPrintJob>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IReceiptPrintJob, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IReceiptPrintJob>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CutPaper(percentage));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IReceiptPrintJob>**)this;
            check_hresult(_winrt_abi_type->CutPaper(percentage));
        }
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IReceiptPrintJob<D>::CutPaper() const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IReceiptPrintJob>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IReceiptPrintJob, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IReceiptPrintJob>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CutPaperDefault());
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IReceiptPrintJob>**)this;
            check_hresult(_winrt_abi_type->CutPaperDefault());
        }
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IReceiptPrintJob2<D>::StampPaper() const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IReceiptPrintJob2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IReceiptPrintJob2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IReceiptPrintJob2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->StampPaper());
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IReceiptPrintJob2>**)this;
            check_hresult(_winrt_abi_type->StampPaper());
        }
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IReceiptPrintJob2<D>::Print(param::hstring const& data, winrt::Windows::Devices::PointOfService::PosPrinterPrintOptions const& printOptions) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IReceiptPrintJob2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IReceiptPrintJob2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IReceiptPrintJob2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->Print(*(void**)(&data), *(void**)(&printOptions)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IReceiptPrintJob2>**)this;
            check_hresult(_winrt_abi_type->Print(*(void**)(&data), *(void**)(&printOptions)));
        }
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IReceiptPrintJob2<D>::FeedPaperByLine(int32_t lineCount) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IReceiptPrintJob2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IReceiptPrintJob2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IReceiptPrintJob2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->FeedPaperByLine(lineCount));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IReceiptPrintJob2>**)this;
            check_hresult(_winrt_abi_type->FeedPaperByLine(lineCount));
        }
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IReceiptPrintJob2<D>::FeedPaperByMapModeUnit(int32_t distance) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IReceiptPrintJob2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IReceiptPrintJob2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IReceiptPrintJob2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->FeedPaperByMapModeUnit(distance));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IReceiptPrintJob2>**)this;
            check_hresult(_winrt_abi_type->FeedPaperByMapModeUnit(distance));
        }
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IReceiptPrinterCapabilities<D>::CanCutPaper() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IReceiptPrinterCapabilities>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IReceiptPrinterCapabilities, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IReceiptPrinterCapabilities>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_CanCutPaper(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IReceiptPrinterCapabilities>**)this;
            check_hresult(_winrt_abi_type->get_CanCutPaper(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IReceiptPrinterCapabilities<D>::IsStampSupported() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IReceiptPrinterCapabilities>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IReceiptPrinterCapabilities, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IReceiptPrinterCapabilities>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsStampSupported(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IReceiptPrinterCapabilities>**)this;
            check_hresult(_winrt_abi_type->get_IsStampSupported(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IReceiptPrinterCapabilities<D>::MarkFeedCapabilities() const
    {
        winrt::Windows::Devices::PointOfService::PosPrinterMarkFeedCapabilities value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IReceiptPrinterCapabilities>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IReceiptPrinterCapabilities, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IReceiptPrinterCapabilities>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_MarkFeedCapabilities(reinterpret_cast<uint32_t*>(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IReceiptPrinterCapabilities>**)this;
            check_hresult(_winrt_abi_type->get_MarkFeedCapabilities(reinterpret_cast<uint32_t*>(&value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IReceiptPrinterCapabilities2<D>::IsReverseVideoSupported() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IReceiptPrinterCapabilities2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IReceiptPrinterCapabilities2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IReceiptPrinterCapabilities2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsReverseVideoSupported(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IReceiptPrinterCapabilities2>**)this;
            check_hresult(_winrt_abi_type->get_IsReverseVideoSupported(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IReceiptPrinterCapabilities2<D>::IsStrikethroughSupported() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IReceiptPrinterCapabilities2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IReceiptPrinterCapabilities2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IReceiptPrinterCapabilities2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsStrikethroughSupported(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IReceiptPrinterCapabilities2>**)this;
            check_hresult(_winrt_abi_type->get_IsStrikethroughSupported(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IReceiptPrinterCapabilities2<D>::IsSuperscriptSupported() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IReceiptPrinterCapabilities2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IReceiptPrinterCapabilities2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IReceiptPrinterCapabilities2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsSuperscriptSupported(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IReceiptPrinterCapabilities2>**)this;
            check_hresult(_winrt_abi_type->get_IsSuperscriptSupported(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IReceiptPrinterCapabilities2<D>::IsSubscriptSupported() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IReceiptPrinterCapabilities2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IReceiptPrinterCapabilities2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IReceiptPrinterCapabilities2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsSubscriptSupported(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IReceiptPrinterCapabilities2>**)this;
            check_hresult(_winrt_abi_type->get_IsSubscriptSupported(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IReceiptPrinterCapabilities2<D>::IsReversePaperFeedByLineSupported() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IReceiptPrinterCapabilities2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IReceiptPrinterCapabilities2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IReceiptPrinterCapabilities2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsReversePaperFeedByLineSupported(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IReceiptPrinterCapabilities2>**)this;
            check_hresult(_winrt_abi_type->get_IsReversePaperFeedByLineSupported(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IReceiptPrinterCapabilities2<D>::IsReversePaperFeedByMapModeUnitSupported() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IReceiptPrinterCapabilities2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IReceiptPrinterCapabilities2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IReceiptPrinterCapabilities2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsReversePaperFeedByMapModeUnitSupported(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IReceiptPrinterCapabilities2>**)this;
            check_hresult(_winrt_abi_type->get_IsReversePaperFeedByMapModeUnitSupported(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ISlipPrintJob<D>::Print(param::hstring const& data, winrt::Windows::Devices::PointOfService::PosPrinterPrintOptions const& printOptions) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ISlipPrintJob>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ISlipPrintJob, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ISlipPrintJob>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->Print(*(void**)(&data), *(void**)(&printOptions)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ISlipPrintJob>**)this;
            check_hresult(_winrt_abi_type->Print(*(void**)(&data), *(void**)(&printOptions)));
        }
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ISlipPrintJob<D>::FeedPaperByLine(int32_t lineCount) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ISlipPrintJob>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ISlipPrintJob, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ISlipPrintJob>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->FeedPaperByLine(lineCount));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ISlipPrintJob>**)this;
            check_hresult(_winrt_abi_type->FeedPaperByLine(lineCount));
        }
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ISlipPrintJob<D>::FeedPaperByMapModeUnit(int32_t distance) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ISlipPrintJob>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ISlipPrintJob, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ISlipPrintJob>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->FeedPaperByMapModeUnit(distance));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ISlipPrintJob>**)this;
            check_hresult(_winrt_abi_type->FeedPaperByMapModeUnit(distance));
        }
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ISlipPrinterCapabilities<D>::IsFullLengthSupported() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ISlipPrinterCapabilities>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ISlipPrinterCapabilities, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ISlipPrinterCapabilities>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsFullLengthSupported(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ISlipPrinterCapabilities>**)this;
            check_hresult(_winrt_abi_type->get_IsFullLengthSupported(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ISlipPrinterCapabilities<D>::IsBothSidesPrintingSupported() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ISlipPrinterCapabilities>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ISlipPrinterCapabilities, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ISlipPrinterCapabilities>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsBothSidesPrintingSupported(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ISlipPrinterCapabilities>**)this;
            check_hresult(_winrt_abi_type->get_IsBothSidesPrintingSupported(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ISlipPrinterCapabilities2<D>::IsReverseVideoSupported() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ISlipPrinterCapabilities2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ISlipPrinterCapabilities2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ISlipPrinterCapabilities2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsReverseVideoSupported(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ISlipPrinterCapabilities2>**)this;
            check_hresult(_winrt_abi_type->get_IsReverseVideoSupported(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ISlipPrinterCapabilities2<D>::IsStrikethroughSupported() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ISlipPrinterCapabilities2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ISlipPrinterCapabilities2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ISlipPrinterCapabilities2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsStrikethroughSupported(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ISlipPrinterCapabilities2>**)this;
            check_hresult(_winrt_abi_type->get_IsStrikethroughSupported(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ISlipPrinterCapabilities2<D>::IsSuperscriptSupported() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ISlipPrinterCapabilities2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ISlipPrinterCapabilities2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ISlipPrinterCapabilities2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsSuperscriptSupported(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ISlipPrinterCapabilities2>**)this;
            check_hresult(_winrt_abi_type->get_IsSuperscriptSupported(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ISlipPrinterCapabilities2<D>::IsSubscriptSupported() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ISlipPrinterCapabilities2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ISlipPrinterCapabilities2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ISlipPrinterCapabilities2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsSubscriptSupported(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ISlipPrinterCapabilities2>**)this;
            check_hresult(_winrt_abi_type->get_IsSubscriptSupported(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ISlipPrinterCapabilities2<D>::IsReversePaperFeedByLineSupported() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ISlipPrinterCapabilities2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ISlipPrinterCapabilities2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ISlipPrinterCapabilities2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsReversePaperFeedByLineSupported(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ISlipPrinterCapabilities2>**)this;
            check_hresult(_winrt_abi_type->get_IsReversePaperFeedByLineSupported(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_ISlipPrinterCapabilities2<D>::IsReversePaperFeedByMapModeUnitSupported() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::ISlipPrinterCapabilities2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::ISlipPrinterCapabilities2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ISlipPrinterCapabilities2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsReversePaperFeedByMapModeUnitSupported(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::ISlipPrinterCapabilities2>**)this;
            check_hresult(_winrt_abi_type->get_IsReversePaperFeedByMapModeUnitSupported(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IUnifiedPosErrorData<D>::Message() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IUnifiedPosErrorData>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IUnifiedPosErrorData, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IUnifiedPosErrorData>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Message(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IUnifiedPosErrorData>**)this;
            check_hresult(_winrt_abi_type->get_Message(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IUnifiedPosErrorData<D>::Severity() const
    {
        winrt::Windows::Devices::PointOfService::UnifiedPosErrorSeverity value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IUnifiedPosErrorData>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IUnifiedPosErrorData, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IUnifiedPosErrorData>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Severity(reinterpret_cast<int32_t*>(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IUnifiedPosErrorData>**)this;
            check_hresult(_winrt_abi_type->get_Severity(reinterpret_cast<int32_t*>(&value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IUnifiedPosErrorData<D>::Reason() const
    {
        winrt::Windows::Devices::PointOfService::UnifiedPosErrorReason value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IUnifiedPosErrorData>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IUnifiedPosErrorData, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IUnifiedPosErrorData>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Reason(reinterpret_cast<int32_t*>(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IUnifiedPosErrorData>**)this;
            check_hresult(_winrt_abi_type->get_Reason(reinterpret_cast<int32_t*>(&value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IUnifiedPosErrorData<D>::ExtendedReason() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IUnifiedPosErrorData>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IUnifiedPosErrorData, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IUnifiedPosErrorData>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ExtendedReason(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IUnifiedPosErrorData>**)this;
            check_hresult(_winrt_abi_type->get_ExtendedReason(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_PointOfService_IUnifiedPosErrorDataFactory<D>::CreateInstance(param::hstring const& message, winrt::Windows::Devices::PointOfService::UnifiedPosErrorSeverity const& severity, winrt::Windows::Devices::PointOfService::UnifiedPosErrorReason const& reason, uint32_t extendedReason) const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::PointOfService::IUnifiedPosErrorDataFactory>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::PointOfService::IUnifiedPosErrorDataFactory, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IUnifiedPosErrorDataFactory>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateInstance(*(void**)(&message), static_cast<int32_t>(severity), static_cast<int32_t>(reason), extendedReason, &result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::PointOfService::IUnifiedPosErrorDataFactory>**)this;
            check_hresult(_winrt_abi_type->CreateInstance(*(void**)(&message), static_cast<int32_t>(severity), static_cast<int32_t>(reason), extendedReason, &result));
        }
        return winrt::Windows::Devices::PointOfService::UnifiedPosErrorData{ result, take_ownership_from_abi };
    }
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Devices::PointOfService::IBarcodeScanner> : produce_base<D, winrt::Windows::Devices::PointOfService::IBarcodeScanner>
    {
        int32_t __stdcall get_DeviceId(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().DeviceId());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Capabilities(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Devices::PointOfService::BarcodeScannerCapabilities>(this->shim().Capabilities());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall ClaimScannerAsync(void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Devices::PointOfService::ClaimedBarcodeScanner>>(this->shim().ClaimScannerAsync());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall CheckHealthAsync(int32_t level, void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncOperation<hstring>>(this->shim().CheckHealthAsync(*reinterpret_cast<winrt::Windows::Devices::PointOfService::UnifiedPosHealthCheckLevel const*>(&level)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall GetSupportedSymbologiesAsync(void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Foundation::Collections::IVectorView<uint32_t>>>(this->shim().GetSupportedSymbologiesAsync());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall IsSymbologySupportedAsync(uint32_t barcodeSymbology, void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncOperation<bool>>(this->shim().IsSymbologySupportedAsync(barcodeSymbology));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall RetrieveStatisticsAsync(void* statisticsCategories, void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Storage::Streams::IBuffer>>(this->shim().RetrieveStatisticsAsync(*reinterpret_cast<winrt::Windows::Foundation::Collections::IIterable<hstring> const*>(&statisticsCategories)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall GetSupportedProfiles(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::Collections::IVectorView<hstring>>(this->shim().GetSupportedProfiles());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall IsProfileSupported(void* profile, bool* isSupported) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *isSupported = detach_from<bool>(this->shim().IsProfileSupported(*reinterpret_cast<hstring const*>(&profile)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall add_StatusUpdated(void* handler, winrt::event_token* token) noexcept final try
        {
            zero_abi<winrt::event_token>(token);
            typename D::abi_guard guard(this->shim());
            *token = detach_from<winrt::event_token>(this->shim().StatusUpdated(*reinterpret_cast<winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::Devices::PointOfService::BarcodeScanner, winrt::Windows::Devices::PointOfService::BarcodeScannerStatusUpdatedEventArgs> const*>(&handler)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall remove_StatusUpdated(winrt::event_token token) noexcept final
        {
            typename D::abi_guard guard(this->shim());
            this->shim().StatusUpdated(*reinterpret_cast<winrt::event_token const*>(&token));
            return 0;
        }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Devices::PointOfService::IBarcodeScanner2> : produce_base<D, winrt::Windows::Devices::PointOfService::IBarcodeScanner2>
    {
        int32_t __stdcall get_VideoDeviceId(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().VideoDeviceId());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Devices::PointOfService::IBarcodeScannerCapabilities> : produce_base<D, winrt::Windows::Devices::PointOfService::IBarcodeScannerCapabilities>
    {
        int32_t __stdcall get_PowerReportingType(int32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Devices::PointOfService::UnifiedPosPowerReportingType>(this->shim().PowerReportingType());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_IsStatisticsReportingSupported(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().IsStatisticsReportingSupported());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_IsStatisticsUpdatingSupported(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().IsStatisticsUpdatingSupported());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_IsImagePreviewSupported(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().IsImagePreviewSupported());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Devices::PointOfService::IBarcodeScannerCapabilities1> : produce_base<D, winrt::Windows::Devices::PointOfService::IBarcodeScannerCapabilities1>
    {
        int32_t __stdcall get_IsSoftwareTriggerSupported(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().IsSoftwareTriggerSupported());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Devices::PointOfService::IBarcodeScannerCapabilities2> : produce_base<D, winrt::Windows::Devices::PointOfService::IBarcodeScannerCapabilities2>
    {
        int32_t __stdcall get_IsVideoPreviewSupported(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().IsVideoPreviewSupported());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Devices::PointOfService::IBarcodeScannerDataReceivedEventArgs> : produce_base<D, winrt::Windows::Devices::PointOfService::IBarcodeScannerDataReceivedEventArgs>
    {
        int32_t __stdcall get_Report(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Devices::PointOfService::BarcodeScannerReport>(this->shim().Report());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Devices::PointOfService::IBarcodeScannerErrorOccurredEventArgs> : produce_base<D, winrt::Windows::Devices::PointOfService::IBarcodeScannerErrorOccurredEventArgs>
    {
        int32_t __stdcall get_PartialInputData(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Devices::PointOfService::BarcodeScannerReport>(this->shim().PartialInputData());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_IsRetriable(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().IsRetriable());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_ErrorData(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Devices::PointOfService::UnifiedPosErrorData>(this->shim().ErrorData());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Devices::PointOfService::IBarcodeScannerImagePreviewReceivedEventArgs> : produce_base<D, winrt::Windows::Devices::PointOfService::IBarcodeScannerImagePreviewReceivedEventArgs>
    {
        int32_t __stdcall get_Preview(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Storage::Streams::IRandomAccessStreamWithContentType>(this->shim().Preview());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Devices::PointOfService::IBarcodeScannerReport> : produce_base<D, winrt::Windows::Devices::PointOfService::IBarcodeScannerReport>
    {
        int32_t __stdcall get_ScanDataType(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint32_t>(this->shim().ScanDataType());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_ScanData(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Storage::Streams::IBuffer>(this->shim().ScanData());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_ScanDataLabel(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Storage::Streams::IBuffer>(this->shim().ScanDataLabel());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Devices::PointOfService::IBarcodeScannerReportFactory> : produce_base<D, winrt::Windows::Devices::PointOfService::IBarcodeScannerReportFactory>
    {
        int32_t __stdcall CreateInstance(uint32_t scanDataType, void* scanData, void* scanDataLabel, void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::Devices::PointOfService::BarcodeScannerReport>(this->shim().CreateInstance(scanDataType, *reinterpret_cast<winrt::Windows::Storage::Streams::IBuffer const*>(&scanData), *reinterpret_cast<winrt::Windows::Storage::Streams::IBuffer const*>(&scanDataLabel)));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Devices::PointOfService::IBarcodeScannerStatics> : produce_base<D, winrt::Windows::Devices::PointOfService::IBarcodeScannerStatics>
    {
        int32_t __stdcall GetDefaultAsync(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Devices::PointOfService::BarcodeScanner>>(this->shim().GetDefaultAsync());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall FromIdAsync(void* deviceId, void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Devices::PointOfService::BarcodeScanner>>(this->shim().FromIdAsync(*reinterpret_cast<hstring const*>(&deviceId)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall GetDeviceSelector(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().GetDeviceSelector());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Devices::PointOfService::IBarcodeScannerStatics2> : produce_base<D, winrt::Windows::Devices::PointOfService::IBarcodeScannerStatics2>
    {
        int32_t __stdcall GetDeviceSelectorWithConnectionTypes(uint32_t connectionTypes, void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().GetDeviceSelector(*reinterpret_cast<winrt::Windows::Devices::PointOfService::PosConnectionTypes const*>(&connectionTypes)));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Devices::PointOfService::IBarcodeScannerStatusUpdatedEventArgs> : produce_base<D, winrt::Windows::Devices::PointOfService::IBarcodeScannerStatusUpdatedEventArgs>
    {
        int32_t __stdcall get_Status(int32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Devices::PointOfService::BarcodeScannerStatus>(this->shim().Status());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_ExtendedStatus(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint32_t>(this->shim().ExtendedStatus());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics> : produce_base<D, winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics>
    {
        int32_t __stdcall get_Unknown(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint32_t>(this->shim().Unknown());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Ean8(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint32_t>(this->shim().Ean8());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Ean8Add2(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint32_t>(this->shim().Ean8Add2());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Ean8Add5(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint32_t>(this->shim().Ean8Add5());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Eanv(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint32_t>(this->shim().Eanv());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_EanvAdd2(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint32_t>(this->shim().EanvAdd2());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_EanvAdd5(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint32_t>(this->shim().EanvAdd5());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Ean13(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint32_t>(this->shim().Ean13());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Ean13Add2(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint32_t>(this->shim().Ean13Add2());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Ean13Add5(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint32_t>(this->shim().Ean13Add5());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Isbn(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint32_t>(this->shim().Isbn());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_IsbnAdd5(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint32_t>(this->shim().IsbnAdd5());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Ismn(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint32_t>(this->shim().Ismn());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_IsmnAdd2(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint32_t>(this->shim().IsmnAdd2());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_IsmnAdd5(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint32_t>(this->shim().IsmnAdd5());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Issn(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint32_t>(this->shim().Issn());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_IssnAdd2(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint32_t>(this->shim().IssnAdd2());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_IssnAdd5(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint32_t>(this->shim().IssnAdd5());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Ean99(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint32_t>(this->shim().Ean99());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Ean99Add2(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint32_t>(this->shim().Ean99Add2());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Ean99Add5(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint32_t>(this->shim().Ean99Add5());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Upca(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint32_t>(this->shim().Upca());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_UpcaAdd2(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint32_t>(this->shim().UpcaAdd2());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_UpcaAdd5(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint32_t>(this->shim().UpcaAdd5());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Upce(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint32_t>(this->shim().Upce());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_UpceAdd2(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint32_t>(this->shim().UpceAdd2());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_UpceAdd5(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint32_t>(this->shim().UpceAdd5());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_UpcCoupon(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint32_t>(this->shim().UpcCoupon());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_TfStd(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint32_t>(this->shim().TfStd());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_TfDis(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint32_t>(this->shim().TfDis());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_TfInt(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint32_t>(this->shim().TfInt());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_TfInd(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint32_t>(this->shim().TfInd());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_TfMat(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint32_t>(this->shim().TfMat());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_TfIata(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint32_t>(this->shim().TfIata());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Gs1DatabarType1(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint32_t>(this->shim().Gs1DatabarType1());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Gs1DatabarType2(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint32_t>(this->shim().Gs1DatabarType2());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Gs1DatabarType3(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint32_t>(this->shim().Gs1DatabarType3());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Code39(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint32_t>(this->shim().Code39());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Code39Ex(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint32_t>(this->shim().Code39Ex());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Trioptic39(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint32_t>(this->shim().Trioptic39());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Code32(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint32_t>(this->shim().Code32());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Pzn(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint32_t>(this->shim().Pzn());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Code93(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint32_t>(this->shim().Code93());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Code93Ex(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint32_t>(this->shim().Code93Ex());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Code128(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint32_t>(this->shim().Code128());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Gs1128(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint32_t>(this->shim().Gs1128());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Gs1128Coupon(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint32_t>(this->shim().Gs1128Coupon());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_UccEan128(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint32_t>(this->shim().UccEan128());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Sisac(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint32_t>(this->shim().Sisac());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Isbt(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint32_t>(this->shim().Isbt());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Codabar(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint32_t>(this->shim().Codabar());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Code11(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint32_t>(this->shim().Code11());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Msi(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint32_t>(this->shim().Msi());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Plessey(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint32_t>(this->shim().Plessey());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Telepen(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint32_t>(this->shim().Telepen());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Code16k(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint32_t>(this->shim().Code16k());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_CodablockA(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint32_t>(this->shim().CodablockA());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_CodablockF(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint32_t>(this->shim().CodablockF());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Codablock128(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint32_t>(this->shim().Codablock128());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Code49(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint32_t>(this->shim().Code49());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Aztec(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint32_t>(this->shim().Aztec());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_DataCode(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint32_t>(this->shim().DataCode());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_DataMatrix(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint32_t>(this->shim().DataMatrix());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_HanXin(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint32_t>(this->shim().HanXin());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Maxicode(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint32_t>(this->shim().Maxicode());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_MicroPdf417(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint32_t>(this->shim().MicroPdf417());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_MicroQr(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint32_t>(this->shim().MicroQr());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Pdf417(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint32_t>(this->shim().Pdf417());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Qr(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint32_t>(this->shim().Qr());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_MsTag(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint32_t>(this->shim().MsTag());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Ccab(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint32_t>(this->shim().Ccab());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Ccc(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint32_t>(this->shim().Ccc());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Tlc39(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint32_t>(this->shim().Tlc39());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_AusPost(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint32_t>(this->shim().AusPost());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_CanPost(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint32_t>(this->shim().CanPost());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_ChinaPost(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint32_t>(this->shim().ChinaPost());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_DutchKix(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint32_t>(this->shim().DutchKix());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_InfoMail(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint32_t>(this->shim().InfoMail());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_ItalianPost25(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint32_t>(this->shim().ItalianPost25());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_ItalianPost39(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint32_t>(this->shim().ItalianPost39());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_JapanPost(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint32_t>(this->shim().JapanPost());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_KoreanPost(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint32_t>(this->shim().KoreanPost());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_SwedenPost(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint32_t>(this->shim().SwedenPost());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_UkPost(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint32_t>(this->shim().UkPost());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_UsIntelligent(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint32_t>(this->shim().UsIntelligent());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_UsIntelligentPkg(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint32_t>(this->shim().UsIntelligentPkg());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_UsPlanet(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint32_t>(this->shim().UsPlanet());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_UsPostNet(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint32_t>(this->shim().UsPostNet());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Us4StateFics(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint32_t>(this->shim().Us4StateFics());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_OcrA(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint32_t>(this->shim().OcrA());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_OcrB(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint32_t>(this->shim().OcrB());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Micr(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint32_t>(this->shim().Micr());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_ExtendedBase(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint32_t>(this->shim().ExtendedBase());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall GetName(uint32_t scanDataType, void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().GetName(scanDataType));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics2> : produce_base<D, winrt::Windows::Devices::PointOfService::IBarcodeSymbologiesStatics2>
    {
        int32_t __stdcall get_Gs1DWCode(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint32_t>(this->shim().Gs1DWCode());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Devices::PointOfService::IBarcodeSymbologyAttributes> : produce_base<D, winrt::Windows::Devices::PointOfService::IBarcodeSymbologyAttributes>
    {
        int32_t __stdcall get_IsCheckDigitValidationEnabled(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().IsCheckDigitValidationEnabled());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_IsCheckDigitValidationEnabled(bool value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().IsCheckDigitValidationEnabled(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_IsCheckDigitValidationSupported(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().IsCheckDigitValidationSupported());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_IsCheckDigitTransmissionEnabled(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().IsCheckDigitTransmissionEnabled());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_IsCheckDigitTransmissionEnabled(bool value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().IsCheckDigitTransmissionEnabled(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_IsCheckDigitTransmissionSupported(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().IsCheckDigitTransmissionSupported());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_DecodeLength1(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint32_t>(this->shim().DecodeLength1());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_DecodeLength1(uint32_t value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().DecodeLength1(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_DecodeLength2(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint32_t>(this->shim().DecodeLength2());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_DecodeLength2(uint32_t value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().DecodeLength2(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_DecodeLengthKind(int32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Devices::PointOfService::BarcodeSymbologyDecodeLengthKind>(this->shim().DecodeLengthKind());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_DecodeLengthKind(int32_t value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().DecodeLengthKind(*reinterpret_cast<winrt::Windows::Devices::PointOfService::BarcodeSymbologyDecodeLengthKind const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_IsDecodeLengthSupported(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().IsDecodeLengthSupported());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Devices::PointOfService::ICashDrawer> : produce_base<D, winrt::Windows::Devices::PointOfService::ICashDrawer>
    {
        int32_t __stdcall get_DeviceId(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().DeviceId());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Capabilities(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Devices::PointOfService::CashDrawerCapabilities>(this->shim().Capabilities());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Status(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Devices::PointOfService::CashDrawerStatus>(this->shim().Status());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_IsDrawerOpen(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().IsDrawerOpen());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_DrawerEventSource(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Devices::PointOfService::CashDrawerEventSource>(this->shim().DrawerEventSource());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall ClaimDrawerAsync(void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Devices::PointOfService::ClaimedCashDrawer>>(this->shim().ClaimDrawerAsync());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall CheckHealthAsync(int32_t level, void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncOperation<hstring>>(this->shim().CheckHealthAsync(*reinterpret_cast<winrt::Windows::Devices::PointOfService::UnifiedPosHealthCheckLevel const*>(&level)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall GetStatisticsAsync(void* statisticsCategories, void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncOperation<hstring>>(this->shim().GetStatisticsAsync(*reinterpret_cast<winrt::Windows::Foundation::Collections::IIterable<hstring> const*>(&statisticsCategories)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall add_StatusUpdated(void* handler, winrt::event_token* token) noexcept final try
        {
            zero_abi<winrt::event_token>(token);
            typename D::abi_guard guard(this->shim());
            *token = detach_from<winrt::event_token>(this->shim().StatusUpdated(*reinterpret_cast<winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::Devices::PointOfService::CashDrawer, winrt::Windows::Devices::PointOfService::CashDrawerStatusUpdatedEventArgs> const*>(&handler)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall remove_StatusUpdated(winrt::event_token token) noexcept final
        {
            typename D::abi_guard guard(this->shim());
            this->shim().StatusUpdated(*reinterpret_cast<winrt::event_token const*>(&token));
            return 0;
        }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Devices::PointOfService::ICashDrawerCapabilities> : produce_base<D, winrt::Windows::Devices::PointOfService::ICashDrawerCapabilities>
    {
        int32_t __stdcall get_PowerReportingType(int32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Devices::PointOfService::UnifiedPosPowerReportingType>(this->shim().PowerReportingType());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_IsStatisticsReportingSupported(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().IsStatisticsReportingSupported());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_IsStatisticsUpdatingSupported(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().IsStatisticsUpdatingSupported());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_IsStatusReportingSupported(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().IsStatusReportingSupported());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_IsStatusMultiDrawerDetectSupported(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().IsStatusMultiDrawerDetectSupported());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_IsDrawerOpenSensorAvailable(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().IsDrawerOpenSensorAvailable());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Devices::PointOfService::ICashDrawerCloseAlarm> : produce_base<D, winrt::Windows::Devices::PointOfService::ICashDrawerCloseAlarm>
    {
        int32_t __stdcall put_AlarmTimeout(int64_t value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().AlarmTimeout(*reinterpret_cast<winrt::Windows::Foundation::TimeSpan const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_AlarmTimeout(int64_t* value) noexcept final try
        {
            zero_abi<winrt::Windows::Foundation::TimeSpan>(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::TimeSpan>(this->shim().AlarmTimeout());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_BeepFrequency(uint32_t value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().BeepFrequency(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_BeepFrequency(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint32_t>(this->shim().BeepFrequency());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_BeepDuration(int64_t value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().BeepDuration(*reinterpret_cast<winrt::Windows::Foundation::TimeSpan const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_BeepDuration(int64_t* value) noexcept final try
        {
            zero_abi<winrt::Windows::Foundation::TimeSpan>(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::TimeSpan>(this->shim().BeepDuration());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_BeepDelay(int64_t value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().BeepDelay(*reinterpret_cast<winrt::Windows::Foundation::TimeSpan const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_BeepDelay(int64_t* value) noexcept final try
        {
            zero_abi<winrt::Windows::Foundation::TimeSpan>(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::TimeSpan>(this->shim().BeepDelay());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall add_AlarmTimeoutExpired(void* handler, winrt::event_token* token) noexcept final try
        {
            zero_abi<winrt::event_token>(token);
            typename D::abi_guard guard(this->shim());
            *token = detach_from<winrt::event_token>(this->shim().AlarmTimeoutExpired(*reinterpret_cast<winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::Devices::PointOfService::CashDrawerCloseAlarm, winrt::Windows::Foundation::IInspectable> const*>(&handler)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall remove_AlarmTimeoutExpired(winrt::event_token token) noexcept final
        {
            typename D::abi_guard guard(this->shim());
            this->shim().AlarmTimeoutExpired(*reinterpret_cast<winrt::event_token const*>(&token));
            return 0;
        }
        int32_t __stdcall StartAsync(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::Foundation::IAsyncOperation<bool>>(this->shim().StartAsync());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Devices::PointOfService::ICashDrawerEventSource> : produce_base<D, winrt::Windows::Devices::PointOfService::ICashDrawerEventSource>
    {
        int32_t __stdcall add_DrawerClosed(void* handler, winrt::event_token* token) noexcept final try
        {
            zero_abi<winrt::event_token>(token);
            typename D::abi_guard guard(this->shim());
            *token = detach_from<winrt::event_token>(this->shim().DrawerClosed(*reinterpret_cast<winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::Devices::PointOfService::CashDrawerEventSource, winrt::Windows::Devices::PointOfService::CashDrawerClosedEventArgs> const*>(&handler)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall remove_DrawerClosed(winrt::event_token token) noexcept final
        {
            typename D::abi_guard guard(this->shim());
            this->shim().DrawerClosed(*reinterpret_cast<winrt::event_token const*>(&token));
            return 0;
        }
        int32_t __stdcall add_DrawerOpened(void* handler, winrt::event_token* token) noexcept final try
        {
            zero_abi<winrt::event_token>(token);
            typename D::abi_guard guard(this->shim());
            *token = detach_from<winrt::event_token>(this->shim().DrawerOpened(*reinterpret_cast<winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::Devices::PointOfService::CashDrawerEventSource, winrt::Windows::Devices::PointOfService::CashDrawerOpenedEventArgs> const*>(&handler)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall remove_DrawerOpened(winrt::event_token token) noexcept final
        {
            typename D::abi_guard guard(this->shim());
            this->shim().DrawerOpened(*reinterpret_cast<winrt::event_token const*>(&token));
            return 0;
        }
    };
#endif
    template <typename D>
    struct produce<D, winrt::Windows::Devices::PointOfService::ICashDrawerEventSourceEventArgs> : produce_base<D, winrt::Windows::Devices::PointOfService::ICashDrawerEventSourceEventArgs>
    {
        int32_t __stdcall get_CashDrawer(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Devices::PointOfService::CashDrawer>(this->shim().CashDrawer());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Devices::PointOfService::ICashDrawerStatics> : produce_base<D, winrt::Windows::Devices::PointOfService::ICashDrawerStatics>
    {
        int32_t __stdcall GetDefaultAsync(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Devices::PointOfService::CashDrawer>>(this->shim().GetDefaultAsync());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall FromIdAsync(void* deviceId, void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Devices::PointOfService::CashDrawer>>(this->shim().FromIdAsync(*reinterpret_cast<hstring const*>(&deviceId)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall GetDeviceSelector(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().GetDeviceSelector());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Devices::PointOfService::ICashDrawerStatics2> : produce_base<D, winrt::Windows::Devices::PointOfService::ICashDrawerStatics2>
    {
        int32_t __stdcall GetDeviceSelectorWithConnectionTypes(uint32_t connectionTypes, void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().GetDeviceSelector(*reinterpret_cast<winrt::Windows::Devices::PointOfService::PosConnectionTypes const*>(&connectionTypes)));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Devices::PointOfService::ICashDrawerStatus> : produce_base<D, winrt::Windows::Devices::PointOfService::ICashDrawerStatus>
    {
        int32_t __stdcall get_StatusKind(int32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Devices::PointOfService::CashDrawerStatusKind>(this->shim().StatusKind());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_ExtendedStatus(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint32_t>(this->shim().ExtendedStatus());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Devices::PointOfService::ICashDrawerStatusUpdatedEventArgs> : produce_base<D, winrt::Windows::Devices::PointOfService::ICashDrawerStatusUpdatedEventArgs>
    {
        int32_t __stdcall get_Status(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Devices::PointOfService::CashDrawerStatus>(this->shim().Status());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Devices::PointOfService::IClaimedBarcodeScanner> : produce_base<D, winrt::Windows::Devices::PointOfService::IClaimedBarcodeScanner>
    {
        int32_t __stdcall get_DeviceId(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().DeviceId());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_IsEnabled(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().IsEnabled());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_IsDisabledOnDataReceived(bool value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().IsDisabledOnDataReceived(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_IsDisabledOnDataReceived(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().IsDisabledOnDataReceived());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_IsDecodeDataEnabled(bool value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().IsDecodeDataEnabled(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_IsDecodeDataEnabled(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().IsDecodeDataEnabled());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall EnableAsync(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::Foundation::IAsyncAction>(this->shim().EnableAsync());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall DisableAsync(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::Foundation::IAsyncAction>(this->shim().DisableAsync());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall RetainDevice() noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().RetainDevice();
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall SetActiveSymbologiesAsync(void* symbologies, void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::Foundation::IAsyncAction>(this->shim().SetActiveSymbologiesAsync(*reinterpret_cast<winrt::Windows::Foundation::Collections::IIterable<uint32_t> const*>(&symbologies)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall ResetStatisticsAsync(void* statisticsCategories, void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::Foundation::IAsyncAction>(this->shim().ResetStatisticsAsync(*reinterpret_cast<winrt::Windows::Foundation::Collections::IIterable<hstring> const*>(&statisticsCategories)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall UpdateStatisticsAsync(void* statistics, void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::Foundation::IAsyncAction>(this->shim().UpdateStatisticsAsync(*reinterpret_cast<winrt::Windows::Foundation::Collections::IIterable<winrt::Windows::Foundation::Collections::IKeyValuePair<hstring, hstring>> const*>(&statistics)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall SetActiveProfileAsync(void* profile, void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::Foundation::IAsyncAction>(this->shim().SetActiveProfileAsync(*reinterpret_cast<hstring const*>(&profile)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall add_DataReceived(void* handler, winrt::event_token* token) noexcept final try
        {
            zero_abi<winrt::event_token>(token);
            typename D::abi_guard guard(this->shim());
            *token = detach_from<winrt::event_token>(this->shim().DataReceived(*reinterpret_cast<winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::Devices::PointOfService::ClaimedBarcodeScanner, winrt::Windows::Devices::PointOfService::BarcodeScannerDataReceivedEventArgs> const*>(&handler)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall remove_DataReceived(winrt::event_token token) noexcept final
        {
            typename D::abi_guard guard(this->shim());
            this->shim().DataReceived(*reinterpret_cast<winrt::event_token const*>(&token));
            return 0;
        }
        int32_t __stdcall add_TriggerPressed(void* handler, winrt::event_token* token) noexcept final try
        {
            zero_abi<winrt::event_token>(token);
            typename D::abi_guard guard(this->shim());
            *token = detach_from<winrt::event_token>(this->shim().TriggerPressed(*reinterpret_cast<winrt::Windows::Foundation::EventHandler<winrt::Windows::Devices::PointOfService::ClaimedBarcodeScanner> const*>(&handler)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall remove_TriggerPressed(winrt::event_token token) noexcept final
        {
            typename D::abi_guard guard(this->shim());
            this->shim().TriggerPressed(*reinterpret_cast<winrt::event_token const*>(&token));
            return 0;
        }
        int32_t __stdcall add_TriggerReleased(void* handler, winrt::event_token* token) noexcept final try
        {
            zero_abi<winrt::event_token>(token);
            typename D::abi_guard guard(this->shim());
            *token = detach_from<winrt::event_token>(this->shim().TriggerReleased(*reinterpret_cast<winrt::Windows::Foundation::EventHandler<winrt::Windows::Devices::PointOfService::ClaimedBarcodeScanner> const*>(&handler)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall remove_TriggerReleased(winrt::event_token token) noexcept final
        {
            typename D::abi_guard guard(this->shim());
            this->shim().TriggerReleased(*reinterpret_cast<winrt::event_token const*>(&token));
            return 0;
        }
        int32_t __stdcall add_ReleaseDeviceRequested(void* handler, winrt::event_token* token) noexcept final try
        {
            zero_abi<winrt::event_token>(token);
            typename D::abi_guard guard(this->shim());
            *token = detach_from<winrt::event_token>(this->shim().ReleaseDeviceRequested(*reinterpret_cast<winrt::Windows::Foundation::EventHandler<winrt::Windows::Devices::PointOfService::ClaimedBarcodeScanner> const*>(&handler)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall remove_ReleaseDeviceRequested(winrt::event_token token) noexcept final
        {
            typename D::abi_guard guard(this->shim());
            this->shim().ReleaseDeviceRequested(*reinterpret_cast<winrt::event_token const*>(&token));
            return 0;
        }
        int32_t __stdcall add_ImagePreviewReceived(void* handler, winrt::event_token* token) noexcept final try
        {
            zero_abi<winrt::event_token>(token);
            typename D::abi_guard guard(this->shim());
            *token = detach_from<winrt::event_token>(this->shim().ImagePreviewReceived(*reinterpret_cast<winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::Devices::PointOfService::ClaimedBarcodeScanner, winrt::Windows::Devices::PointOfService::BarcodeScannerImagePreviewReceivedEventArgs> const*>(&handler)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall remove_ImagePreviewReceived(winrt::event_token token) noexcept final
        {
            typename D::abi_guard guard(this->shim());
            this->shim().ImagePreviewReceived(*reinterpret_cast<winrt::event_token const*>(&token));
            return 0;
        }
        int32_t __stdcall add_ErrorOccurred(void* handler, winrt::event_token* token) noexcept final try
        {
            zero_abi<winrt::event_token>(token);
            typename D::abi_guard guard(this->shim());
            *token = detach_from<winrt::event_token>(this->shim().ErrorOccurred(*reinterpret_cast<winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::Devices::PointOfService::ClaimedBarcodeScanner, winrt::Windows::Devices::PointOfService::BarcodeScannerErrorOccurredEventArgs> const*>(&handler)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall remove_ErrorOccurred(winrt::event_token token) noexcept final
        {
            typename D::abi_guard guard(this->shim());
            this->shim().ErrorOccurred(*reinterpret_cast<winrt::event_token const*>(&token));
            return 0;
        }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Devices::PointOfService::IClaimedBarcodeScanner1> : produce_base<D, winrt::Windows::Devices::PointOfService::IClaimedBarcodeScanner1>
    {
        int32_t __stdcall StartSoftwareTriggerAsync(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::Foundation::IAsyncAction>(this->shim().StartSoftwareTriggerAsync());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall StopSoftwareTriggerAsync(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::Foundation::IAsyncAction>(this->shim().StopSoftwareTriggerAsync());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Devices::PointOfService::IClaimedBarcodeScanner2> : produce_base<D, winrt::Windows::Devices::PointOfService::IClaimedBarcodeScanner2>
    {
        int32_t __stdcall GetSymbologyAttributesAsync(uint32_t barcodeSymbology, void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Devices::PointOfService::BarcodeSymbologyAttributes>>(this->shim().GetSymbologyAttributesAsync(barcodeSymbology));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall SetSymbologyAttributesAsync(uint32_t barcodeSymbology, void* attributes, void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::Foundation::IAsyncOperation<bool>>(this->shim().SetSymbologyAttributesAsync(barcodeSymbology, *reinterpret_cast<winrt::Windows::Devices::PointOfService::BarcodeSymbologyAttributes const*>(&attributes)));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Devices::PointOfService::IClaimedBarcodeScanner3> : produce_base<D, winrt::Windows::Devices::PointOfService::IClaimedBarcodeScanner3>
    {
        int32_t __stdcall ShowVideoPreviewAsync(void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncOperation<bool>>(this->shim().ShowVideoPreviewAsync());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall HideVideoPreview() noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().HideVideoPreview();
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_IsVideoPreviewShownOnEnable(bool value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().IsVideoPreviewShownOnEnable(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_IsVideoPreviewShownOnEnable(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().IsVideoPreviewShownOnEnable());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Devices::PointOfService::IClaimedBarcodeScanner4> : produce_base<D, winrt::Windows::Devices::PointOfService::IClaimedBarcodeScanner4>
    {
        int32_t __stdcall add_Closed(void* handler, winrt::event_token* token) noexcept final try
        {
            zero_abi<winrt::event_token>(token);
            typename D::abi_guard guard(this->shim());
            *token = detach_from<winrt::event_token>(this->shim().Closed(*reinterpret_cast<winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::Devices::PointOfService::ClaimedBarcodeScanner, winrt::Windows::Devices::PointOfService::ClaimedBarcodeScannerClosedEventArgs> const*>(&handler)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall remove_Closed(winrt::event_token token) noexcept final
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Closed(*reinterpret_cast<winrt::event_token const*>(&token));
            return 0;
        }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Devices::PointOfService::IClaimedBarcodeScannerClosedEventArgs> : produce_base<D, winrt::Windows::Devices::PointOfService::IClaimedBarcodeScannerClosedEventArgs>
    {
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Devices::PointOfService::IClaimedCashDrawer> : produce_base<D, winrt::Windows::Devices::PointOfService::IClaimedCashDrawer>
    {
        int32_t __stdcall get_DeviceId(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().DeviceId());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_IsEnabled(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().IsEnabled());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_IsDrawerOpen(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().IsDrawerOpen());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_CloseAlarm(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Devices::PointOfService::CashDrawerCloseAlarm>(this->shim().CloseAlarm());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall OpenDrawerAsync(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::Foundation::IAsyncOperation<bool>>(this->shim().OpenDrawerAsync());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall EnableAsync(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::Foundation::IAsyncOperation<bool>>(this->shim().EnableAsync());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall DisableAsync(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::Foundation::IAsyncOperation<bool>>(this->shim().DisableAsync());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall RetainDeviceAsync(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::Foundation::IAsyncOperation<bool>>(this->shim().RetainDeviceAsync());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall ResetStatisticsAsync(void* statisticsCategories, void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::Foundation::IAsyncOperation<bool>>(this->shim().ResetStatisticsAsync(*reinterpret_cast<winrt::Windows::Foundation::Collections::IIterable<hstring> const*>(&statisticsCategories)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall UpdateStatisticsAsync(void* statistics, void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::Foundation::IAsyncOperation<bool>>(this->shim().UpdateStatisticsAsync(*reinterpret_cast<winrt::Windows::Foundation::Collections::IIterable<winrt::Windows::Foundation::Collections::IKeyValuePair<hstring, hstring>> const*>(&statistics)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall add_ReleaseDeviceRequested(void* handler, winrt::event_token* token) noexcept final try
        {
            zero_abi<winrt::event_token>(token);
            typename D::abi_guard guard(this->shim());
            *token = detach_from<winrt::event_token>(this->shim().ReleaseDeviceRequested(*reinterpret_cast<winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::Devices::PointOfService::ClaimedCashDrawer, winrt::Windows::Foundation::IInspectable> const*>(&handler)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall remove_ReleaseDeviceRequested(winrt::event_token token) noexcept final
        {
            typename D::abi_guard guard(this->shim());
            this->shim().ReleaseDeviceRequested(*reinterpret_cast<winrt::event_token const*>(&token));
            return 0;
        }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Devices::PointOfService::IClaimedCashDrawer2> : produce_base<D, winrt::Windows::Devices::PointOfService::IClaimedCashDrawer2>
    {
        int32_t __stdcall add_Closed(void* handler, winrt::event_token* token) noexcept final try
        {
            zero_abi<winrt::event_token>(token);
            typename D::abi_guard guard(this->shim());
            *token = detach_from<winrt::event_token>(this->shim().Closed(*reinterpret_cast<winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::Devices::PointOfService::ClaimedCashDrawer, winrt::Windows::Devices::PointOfService::ClaimedCashDrawerClosedEventArgs> const*>(&handler)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall remove_Closed(winrt::event_token token) noexcept final
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Closed(*reinterpret_cast<winrt::event_token const*>(&token));
            return 0;
        }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Devices::PointOfService::IClaimedCashDrawerClosedEventArgs> : produce_base<D, winrt::Windows::Devices::PointOfService::IClaimedCashDrawerClosedEventArgs>
    {
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Devices::PointOfService::IClaimedJournalPrinter> : produce_base<D, winrt::Windows::Devices::PointOfService::IClaimedJournalPrinter>
    {
        int32_t __stdcall CreateJob(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Devices::PointOfService::JournalPrintJob>(this->shim().CreateJob());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Devices::PointOfService::IClaimedLineDisplay> : produce_base<D, winrt::Windows::Devices::PointOfService::IClaimedLineDisplay>
    {
        int32_t __stdcall get_DeviceId(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().DeviceId());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Capabilities(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Devices::PointOfService::LineDisplayCapabilities>(this->shim().Capabilities());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_PhysicalDeviceName(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().PhysicalDeviceName());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_PhysicalDeviceDescription(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().PhysicalDeviceDescription());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_DeviceControlDescription(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().DeviceControlDescription());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_DeviceControlVersion(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().DeviceControlVersion());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_DeviceServiceVersion(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().DeviceServiceVersion());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_DefaultWindow(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Devices::PointOfService::LineDisplayWindow>(this->shim().DefaultWindow());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall RetainDevice() noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().RetainDevice();
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall add_ReleaseDeviceRequested(void* handler, winrt::event_token* token) noexcept final try
        {
            zero_abi<winrt::event_token>(token);
            typename D::abi_guard guard(this->shim());
            *token = detach_from<winrt::event_token>(this->shim().ReleaseDeviceRequested(*reinterpret_cast<winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::Devices::PointOfService::ClaimedLineDisplay, winrt::Windows::Foundation::IInspectable> const*>(&handler)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall remove_ReleaseDeviceRequested(winrt::event_token token) noexcept final
        {
            typename D::abi_guard guard(this->shim());
            this->shim().ReleaseDeviceRequested(*reinterpret_cast<winrt::event_token const*>(&token));
            return 0;
        }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Devices::PointOfService::IClaimedLineDisplay2> : produce_base<D, winrt::Windows::Devices::PointOfService::IClaimedLineDisplay2>
    {
        int32_t __stdcall GetStatisticsAsync(void* statisticsCategories, void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::Foundation::IAsyncOperation<hstring>>(this->shim().GetStatisticsAsync(*reinterpret_cast<winrt::Windows::Foundation::Collections::IIterable<hstring> const*>(&statisticsCategories)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall CheckHealthAsync(int32_t level, void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::Foundation::IAsyncOperation<hstring>>(this->shim().CheckHealthAsync(*reinterpret_cast<winrt::Windows::Devices::PointOfService::UnifiedPosHealthCheckLevel const*>(&level)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall CheckPowerStatusAsync(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Devices::PointOfService::LineDisplayPowerStatus>>(this->shim().CheckPowerStatusAsync());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall add_StatusUpdated(void* handler, winrt::event_token* token) noexcept final try
        {
            zero_abi<winrt::event_token>(token);
            typename D::abi_guard guard(this->shim());
            *token = detach_from<winrt::event_token>(this->shim().StatusUpdated(*reinterpret_cast<winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::Devices::PointOfService::ClaimedLineDisplay, winrt::Windows::Devices::PointOfService::LineDisplayStatusUpdatedEventArgs> const*>(&handler)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall remove_StatusUpdated(winrt::event_token token) noexcept final
        {
            typename D::abi_guard guard(this->shim());
            this->shim().StatusUpdated(*reinterpret_cast<winrt::event_token const*>(&token));
            return 0;
        }
        int32_t __stdcall get_SupportedScreenSizesInCharacters(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::Collections::IVectorView<winrt::Windows::Foundation::Size>>(this->shim().SupportedScreenSizesInCharacters());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_MaxBitmapSizeInPixels(winrt::Windows::Foundation::Size* value) noexcept final try
        {
            zero_abi<winrt::Windows::Foundation::Size>(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::Size>(this->shim().MaxBitmapSizeInPixels());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_SupportedCharacterSets(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::Collections::IVectorView<int32_t>>(this->shim().SupportedCharacterSets());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_CustomGlyphs(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Devices::PointOfService::LineDisplayCustomGlyphs>(this->shim().CustomGlyphs());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall GetAttributes(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Devices::PointOfService::LineDisplayAttributes>(this->shim().GetAttributes());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall TryUpdateAttributesAsync(void* attributes, void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncOperation<bool>>(this->shim().TryUpdateAttributesAsync(*reinterpret_cast<winrt::Windows::Devices::PointOfService::LineDisplayAttributes const*>(&attributes)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall TrySetDescriptorAsync(uint32_t descriptor, int32_t descriptorState, void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncOperation<bool>>(this->shim().TrySetDescriptorAsync(descriptor, *reinterpret_cast<winrt::Windows::Devices::PointOfService::LineDisplayDescriptorState const*>(&descriptorState)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall TryClearDescriptorsAsync(void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncOperation<bool>>(this->shim().TryClearDescriptorsAsync());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall TryCreateWindowAsync(winrt::Windows::Foundation::Rect viewport, winrt::Windows::Foundation::Size windowSize, void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Devices::PointOfService::LineDisplayWindow>>(this->shim().TryCreateWindowAsync(*reinterpret_cast<winrt::Windows::Foundation::Rect const*>(&viewport), *reinterpret_cast<winrt::Windows::Foundation::Size const*>(&windowSize)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall TryStoreStorageFileBitmapAsync(void* bitmap, void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Devices::PointOfService::LineDisplayStoredBitmap>>(this->shim().TryStoreStorageFileBitmapAsync(*reinterpret_cast<winrt::Windows::Storage::StorageFile const*>(&bitmap)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall TryStoreStorageFileBitmapWithAlignmentAsync(void* bitmap, int32_t horizontalAlignment, int32_t verticalAlignment, void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Devices::PointOfService::LineDisplayStoredBitmap>>(this->shim().TryStoreStorageFileBitmapAsync(*reinterpret_cast<winrt::Windows::Storage::StorageFile const*>(&bitmap), *reinterpret_cast<winrt::Windows::Devices::PointOfService::LineDisplayHorizontalAlignment const*>(&horizontalAlignment), *reinterpret_cast<winrt::Windows::Devices::PointOfService::LineDisplayVerticalAlignment const*>(&verticalAlignment)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall TryStoreStorageFileBitmapWithAlignmentAndWidthAsync(void* bitmap, int32_t horizontalAlignment, int32_t verticalAlignment, int32_t widthInPixels, void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Devices::PointOfService::LineDisplayStoredBitmap>>(this->shim().TryStoreStorageFileBitmapAsync(*reinterpret_cast<winrt::Windows::Storage::StorageFile const*>(&bitmap), *reinterpret_cast<winrt::Windows::Devices::PointOfService::LineDisplayHorizontalAlignment const*>(&horizontalAlignment), *reinterpret_cast<winrt::Windows::Devices::PointOfService::LineDisplayVerticalAlignment const*>(&verticalAlignment), widthInPixels));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Devices::PointOfService::IClaimedLineDisplay3> : produce_base<D, winrt::Windows::Devices::PointOfService::IClaimedLineDisplay3>
    {
        int32_t __stdcall add_Closed(void* handler, winrt::event_token* token) noexcept final try
        {
            zero_abi<winrt::event_token>(token);
            typename D::abi_guard guard(this->shim());
            *token = detach_from<winrt::event_token>(this->shim().Closed(*reinterpret_cast<winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::Devices::PointOfService::ClaimedLineDisplay, winrt::Windows::Devices::PointOfService::ClaimedLineDisplayClosedEventArgs> const*>(&handler)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall remove_Closed(winrt::event_token token) noexcept final
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Closed(*reinterpret_cast<winrt::event_token const*>(&token));
            return 0;
        }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Devices::PointOfService::IClaimedLineDisplayClosedEventArgs> : produce_base<D, winrt::Windows::Devices::PointOfService::IClaimedLineDisplayClosedEventArgs>
    {
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Devices::PointOfService::IClaimedLineDisplayStatics> : produce_base<D, winrt::Windows::Devices::PointOfService::IClaimedLineDisplayStatics>
    {
        int32_t __stdcall FromIdAsync(void* deviceId, void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Devices::PointOfService::ClaimedLineDisplay>>(this->shim().FromIdAsync(*reinterpret_cast<hstring const*>(&deviceId)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall GetDeviceSelector(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<hstring>(this->shim().GetDeviceSelector());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall GetDeviceSelectorWithConnectionTypes(uint32_t connectionTypes, void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().GetDeviceSelector(*reinterpret_cast<winrt::Windows::Devices::PointOfService::PosConnectionTypes const*>(&connectionTypes)));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Devices::PointOfService::IClaimedMagneticStripeReader> : produce_base<D, winrt::Windows::Devices::PointOfService::IClaimedMagneticStripeReader>
    {
        int32_t __stdcall get_DeviceId(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().DeviceId());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_IsEnabled(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().IsEnabled());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_IsDisabledOnDataReceived(bool value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().IsDisabledOnDataReceived(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_IsDisabledOnDataReceived(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().IsDisabledOnDataReceived());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_IsDecodeDataEnabled(bool value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().IsDecodeDataEnabled(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_IsDecodeDataEnabled(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().IsDecodeDataEnabled());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_IsDeviceAuthenticated(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().IsDeviceAuthenticated());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_DataEncryptionAlgorithm(uint32_t value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().DataEncryptionAlgorithm(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_DataEncryptionAlgorithm(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint32_t>(this->shim().DataEncryptionAlgorithm());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_TracksToRead(int32_t value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().TracksToRead(*reinterpret_cast<winrt::Windows::Devices::PointOfService::MagneticStripeReaderTrackIds const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_TracksToRead(int32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Devices::PointOfService::MagneticStripeReaderTrackIds>(this->shim().TracksToRead());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_IsTransmitSentinelsEnabled(bool value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().IsTransmitSentinelsEnabled(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_IsTransmitSentinelsEnabled(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().IsTransmitSentinelsEnabled());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall EnableAsync(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::Foundation::IAsyncAction>(this->shim().EnableAsync());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall DisableAsync(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::Foundation::IAsyncAction>(this->shim().DisableAsync());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall RetainDevice() noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().RetainDevice();
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall SetErrorReportingType(int32_t value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().SetErrorReportingType(*reinterpret_cast<winrt::Windows::Devices::PointOfService::MagneticStripeReaderErrorReportingType const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall RetrieveDeviceAuthenticationDataAsync(void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Storage::Streams::IBuffer>>(this->shim().RetrieveDeviceAuthenticationDataAsync());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall AuthenticateDeviceAsync(uint32_t __responseTokenSize, uint8_t* responseToken, void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::Foundation::IAsyncAction>(this->shim().AuthenticateDeviceAsync(array_view<uint8_t const>(reinterpret_cast<uint8_t const *>(responseToken), reinterpret_cast<uint8_t const *>(responseToken) + __responseTokenSize)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall DeAuthenticateDeviceAsync(uint32_t __responseTokenSize, uint8_t* responseToken, void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::Foundation::IAsyncAction>(this->shim().DeAuthenticateDeviceAsync(array_view<uint8_t const>(reinterpret_cast<uint8_t const *>(responseToken), reinterpret_cast<uint8_t const *>(responseToken) + __responseTokenSize)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall UpdateKeyAsync(void* key, void* keyName, void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::Foundation::IAsyncAction>(this->shim().UpdateKeyAsync(*reinterpret_cast<hstring const*>(&key), *reinterpret_cast<hstring const*>(&keyName)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall ResetStatisticsAsync(void* statisticsCategories, void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::Foundation::IAsyncAction>(this->shim().ResetStatisticsAsync(*reinterpret_cast<winrt::Windows::Foundation::Collections::IIterable<hstring> const*>(&statisticsCategories)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall UpdateStatisticsAsync(void* statistics, void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::Foundation::IAsyncAction>(this->shim().UpdateStatisticsAsync(*reinterpret_cast<winrt::Windows::Foundation::Collections::IIterable<winrt::Windows::Foundation::Collections::IKeyValuePair<hstring, hstring>> const*>(&statistics)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall add_BankCardDataReceived(void* handler, winrt::event_token* token) noexcept final try
        {
            zero_abi<winrt::event_token>(token);
            typename D::abi_guard guard(this->shim());
            *token = detach_from<winrt::event_token>(this->shim().BankCardDataReceived(*reinterpret_cast<winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::Devices::PointOfService::ClaimedMagneticStripeReader, winrt::Windows::Devices::PointOfService::MagneticStripeReaderBankCardDataReceivedEventArgs> const*>(&handler)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall remove_BankCardDataReceived(winrt::event_token token) noexcept final
        {
            typename D::abi_guard guard(this->shim());
            this->shim().BankCardDataReceived(*reinterpret_cast<winrt::event_token const*>(&token));
            return 0;
        }
        int32_t __stdcall add_AamvaCardDataReceived(void* handler, winrt::event_token* token) noexcept final try
        {
            zero_abi<winrt::event_token>(token);
            typename D::abi_guard guard(this->shim());
            *token = detach_from<winrt::event_token>(this->shim().AamvaCardDataReceived(*reinterpret_cast<winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::Devices::PointOfService::ClaimedMagneticStripeReader, winrt::Windows::Devices::PointOfService::MagneticStripeReaderAamvaCardDataReceivedEventArgs> const*>(&handler)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall remove_AamvaCardDataReceived(winrt::event_token token) noexcept final
        {
            typename D::abi_guard guard(this->shim());
            this->shim().AamvaCardDataReceived(*reinterpret_cast<winrt::event_token const*>(&token));
            return 0;
        }
        int32_t __stdcall add_VendorSpecificDataReceived(void* handler, winrt::event_token* token) noexcept final try
        {
            zero_abi<winrt::event_token>(token);
            typename D::abi_guard guard(this->shim());
            *token = detach_from<winrt::event_token>(this->shim().VendorSpecificDataReceived(*reinterpret_cast<winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::Devices::PointOfService::ClaimedMagneticStripeReader, winrt::Windows::Devices::PointOfService::MagneticStripeReaderVendorSpecificCardDataReceivedEventArgs> const*>(&handler)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall remove_VendorSpecificDataReceived(winrt::event_token token) noexcept final
        {
            typename D::abi_guard guard(this->shim());
            this->shim().VendorSpecificDataReceived(*reinterpret_cast<winrt::event_token const*>(&token));
            return 0;
        }
        int32_t __stdcall add_ReleaseDeviceRequested(void* handler, winrt::event_token* token) noexcept final try
        {
            zero_abi<winrt::event_token>(token);
            typename D::abi_guard guard(this->shim());
            *token = detach_from<winrt::event_token>(this->shim().ReleaseDeviceRequested(*reinterpret_cast<winrt::Windows::Foundation::EventHandler<winrt::Windows::Devices::PointOfService::ClaimedMagneticStripeReader> const*>(&handler)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall remove_ReleaseDeviceRequested(winrt::event_token token) noexcept final
        {
            typename D::abi_guard guard(this->shim());
            this->shim().ReleaseDeviceRequested(*reinterpret_cast<winrt::event_token const*>(&token));
            return 0;
        }
        int32_t __stdcall add_ErrorOccurred(void* handler, winrt::event_token* token) noexcept final try
        {
            zero_abi<winrt::event_token>(token);
            typename D::abi_guard guard(this->shim());
            *token = detach_from<winrt::event_token>(this->shim().ErrorOccurred(*reinterpret_cast<winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::Devices::PointOfService::ClaimedMagneticStripeReader, winrt::Windows::Devices::PointOfService::MagneticStripeReaderErrorOccurredEventArgs> const*>(&handler)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall remove_ErrorOccurred(winrt::event_token token) noexcept final
        {
            typename D::abi_guard guard(this->shim());
            this->shim().ErrorOccurred(*reinterpret_cast<winrt::event_token const*>(&token));
            return 0;
        }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Devices::PointOfService::IClaimedMagneticStripeReader2> : produce_base<D, winrt::Windows::Devices::PointOfService::IClaimedMagneticStripeReader2>
    {
        int32_t __stdcall add_Closed(void* handler, winrt::event_token* token) noexcept final try
        {
            zero_abi<winrt::event_token>(token);
            typename D::abi_guard guard(this->shim());
            *token = detach_from<winrt::event_token>(this->shim().Closed(*reinterpret_cast<winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::Devices::PointOfService::ClaimedMagneticStripeReader, winrt::Windows::Devices::PointOfService::ClaimedMagneticStripeReaderClosedEventArgs> const*>(&handler)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall remove_Closed(winrt::event_token token) noexcept final
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Closed(*reinterpret_cast<winrt::event_token const*>(&token));
            return 0;
        }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Devices::PointOfService::IClaimedMagneticStripeReaderClosedEventArgs> : produce_base<D, winrt::Windows::Devices::PointOfService::IClaimedMagneticStripeReaderClosedEventArgs>
    {
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Devices::PointOfService::IClaimedPosPrinter> : produce_base<D, winrt::Windows::Devices::PointOfService::IClaimedPosPrinter>
    {
        int32_t __stdcall get_DeviceId(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().DeviceId());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_IsEnabled(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().IsEnabled());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_CharacterSet(uint32_t value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().CharacterSet(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_CharacterSet(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint32_t>(this->shim().CharacterSet());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_IsCoverOpen(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().IsCoverOpen());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_IsCharacterSetMappingEnabled(bool value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().IsCharacterSetMappingEnabled(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_IsCharacterSetMappingEnabled(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().IsCharacterSetMappingEnabled());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_MapMode(int32_t value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().MapMode(*reinterpret_cast<winrt::Windows::Devices::PointOfService::PosPrinterMapMode const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_MapMode(int32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Devices::PointOfService::PosPrinterMapMode>(this->shim().MapMode());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Receipt(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Devices::PointOfService::ClaimedReceiptPrinter>(this->shim().Receipt());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Slip(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Devices::PointOfService::ClaimedSlipPrinter>(this->shim().Slip());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Journal(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Devices::PointOfService::ClaimedJournalPrinter>(this->shim().Journal());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall EnableAsync(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::Foundation::IAsyncOperation<bool>>(this->shim().EnableAsync());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall DisableAsync(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::Foundation::IAsyncOperation<bool>>(this->shim().DisableAsync());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall RetainDeviceAsync(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::Foundation::IAsyncOperation<bool>>(this->shim().RetainDeviceAsync());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall ResetStatisticsAsync(void* statisticsCategories, void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::Foundation::IAsyncOperation<bool>>(this->shim().ResetStatisticsAsync(*reinterpret_cast<winrt::Windows::Foundation::Collections::IIterable<hstring> const*>(&statisticsCategories)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall UpdateStatisticsAsync(void* statistics, void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::Foundation::IAsyncOperation<bool>>(this->shim().UpdateStatisticsAsync(*reinterpret_cast<winrt::Windows::Foundation::Collections::IIterable<winrt::Windows::Foundation::Collections::IKeyValuePair<hstring, hstring>> const*>(&statistics)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall add_ReleaseDeviceRequested(void* handler, winrt::event_token* token) noexcept final try
        {
            zero_abi<winrt::event_token>(token);
            typename D::abi_guard guard(this->shim());
            *token = detach_from<winrt::event_token>(this->shim().ReleaseDeviceRequested(*reinterpret_cast<winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::Devices::PointOfService::ClaimedPosPrinter, winrt::Windows::Devices::PointOfService::PosPrinterReleaseDeviceRequestedEventArgs> const*>(&handler)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall remove_ReleaseDeviceRequested(winrt::event_token token) noexcept final
        {
            typename D::abi_guard guard(this->shim());
            this->shim().ReleaseDeviceRequested(*reinterpret_cast<winrt::event_token const*>(&token));
            return 0;
        }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Devices::PointOfService::IClaimedPosPrinter2> : produce_base<D, winrt::Windows::Devices::PointOfService::IClaimedPosPrinter2>
    {
        int32_t __stdcall add_Closed(void* handler, winrt::event_token* token) noexcept final try
        {
            zero_abi<winrt::event_token>(token);
            typename D::abi_guard guard(this->shim());
            *token = detach_from<winrt::event_token>(this->shim().Closed(*reinterpret_cast<winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::Devices::PointOfService::ClaimedPosPrinter, winrt::Windows::Devices::PointOfService::ClaimedPosPrinterClosedEventArgs> const*>(&handler)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall remove_Closed(winrt::event_token token) noexcept final
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Closed(*reinterpret_cast<winrt::event_token const*>(&token));
            return 0;
        }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Devices::PointOfService::IClaimedPosPrinterClosedEventArgs> : produce_base<D, winrt::Windows::Devices::PointOfService::IClaimedPosPrinterClosedEventArgs>
    {
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Devices::PointOfService::IClaimedReceiptPrinter> : produce_base<D, winrt::Windows::Devices::PointOfService::IClaimedReceiptPrinter>
    {
        int32_t __stdcall get_SidewaysMaxLines(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint32_t>(this->shim().SidewaysMaxLines());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_SidewaysMaxChars(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint32_t>(this->shim().SidewaysMaxChars());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_LinesToPaperCut(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint32_t>(this->shim().LinesToPaperCut());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_PageSize(winrt::Windows::Foundation::Size* value) noexcept final try
        {
            zero_abi<winrt::Windows::Foundation::Size>(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::Size>(this->shim().PageSize());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_PrintArea(winrt::Windows::Foundation::Rect* value) noexcept final try
        {
            zero_abi<winrt::Windows::Foundation::Rect>(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::Rect>(this->shim().PrintArea());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall CreateJob(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Devices::PointOfService::ReceiptPrintJob>(this->shim().CreateJob());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Devices::PointOfService::IClaimedSlipPrinter> : produce_base<D, winrt::Windows::Devices::PointOfService::IClaimedSlipPrinter>
    {
        int32_t __stdcall get_SidewaysMaxLines(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint32_t>(this->shim().SidewaysMaxLines());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_SidewaysMaxChars(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint32_t>(this->shim().SidewaysMaxChars());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_MaxLines(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint32_t>(this->shim().MaxLines());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_LinesNearEndToEnd(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint32_t>(this->shim().LinesNearEndToEnd());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_PrintSide(int32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Devices::PointOfService::PosPrinterPrintSide>(this->shim().PrintSide());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_PageSize(winrt::Windows::Foundation::Size* value) noexcept final try
        {
            zero_abi<winrt::Windows::Foundation::Size>(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::Size>(this->shim().PageSize());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_PrintArea(winrt::Windows::Foundation::Rect* value) noexcept final try
        {
            zero_abi<winrt::Windows::Foundation::Rect>(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::Rect>(this->shim().PrintArea());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall OpenJaws() noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().OpenJaws();
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall CloseJaws() noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().CloseJaws();
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall InsertSlipAsync(int64_t timeout, void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::Foundation::IAsyncOperation<bool>>(this->shim().InsertSlipAsync(*reinterpret_cast<winrt::Windows::Foundation::TimeSpan const*>(&timeout)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall RemoveSlipAsync(int64_t timeout, void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::Foundation::IAsyncOperation<bool>>(this->shim().RemoveSlipAsync(*reinterpret_cast<winrt::Windows::Foundation::TimeSpan const*>(&timeout)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall ChangePrintSide(int32_t printSide) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().ChangePrintSide(*reinterpret_cast<winrt::Windows::Devices::PointOfService::PosPrinterPrintSide const*>(&printSide));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall CreateJob(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Devices::PointOfService::SlipPrintJob>(this->shim().CreateJob());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
    template <typename D>
    struct produce<D, winrt::Windows::Devices::PointOfService::ICommonClaimedPosPrinterStation> : produce_base<D, winrt::Windows::Devices::PointOfService::ICommonClaimedPosPrinterStation>
    {
        int32_t __stdcall put_CharactersPerLine(uint32_t value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().CharactersPerLine(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_CharactersPerLine(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint32_t>(this->shim().CharactersPerLine());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_LineHeight(uint32_t value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().LineHeight(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_LineHeight(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint32_t>(this->shim().LineHeight());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_LineSpacing(uint32_t value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().LineSpacing(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_LineSpacing(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint32_t>(this->shim().LineSpacing());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_LineWidth(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint32_t>(this->shim().LineWidth());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_IsLetterQuality(bool value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().IsLetterQuality(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_IsLetterQuality(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().IsLetterQuality());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_IsPaperNearEnd(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().IsPaperNearEnd());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_ColorCartridge(int32_t value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().ColorCartridge(*reinterpret_cast<winrt::Windows::Devices::PointOfService::PosPrinterColorCartridge const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_ColorCartridge(int32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Devices::PointOfService::PosPrinterColorCartridge>(this->shim().ColorCartridge());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_IsCoverOpen(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().IsCoverOpen());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_IsCartridgeRemoved(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().IsCartridgeRemoved());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_IsCartridgeEmpty(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().IsCartridgeEmpty());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_IsHeadCleaning(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().IsHeadCleaning());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_IsPaperEmpty(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().IsPaperEmpty());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_IsReadyToPrint(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().IsReadyToPrint());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall ValidateData(void* data, bool* result) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *result = detach_from<bool>(this->shim().ValidateData(*reinterpret_cast<hstring const*>(&data)));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
    template <typename D>
    struct produce<D, winrt::Windows::Devices::PointOfService::ICommonPosPrintStationCapabilities> : produce_base<D, winrt::Windows::Devices::PointOfService::ICommonPosPrintStationCapabilities>
    {
        int32_t __stdcall get_IsPrinterPresent(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().IsPrinterPresent());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_IsDualColorSupported(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().IsDualColorSupported());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_ColorCartridgeCapabilities(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Devices::PointOfService::PosPrinterColorCapabilities>(this->shim().ColorCartridgeCapabilities());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_CartridgeSensors(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Devices::PointOfService::PosPrinterCartridgeSensors>(this->shim().CartridgeSensors());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_IsBoldSupported(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().IsBoldSupported());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_IsItalicSupported(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().IsItalicSupported());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_IsUnderlineSupported(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().IsUnderlineSupported());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_IsDoubleHighPrintSupported(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().IsDoubleHighPrintSupported());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_IsDoubleWidePrintSupported(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().IsDoubleWidePrintSupported());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_IsDoubleHighDoubleWidePrintSupported(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().IsDoubleHighDoubleWidePrintSupported());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_IsPaperEmptySensorSupported(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().IsPaperEmptySensorSupported());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_IsPaperNearEndSensorSupported(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().IsPaperNearEndSensorSupported());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_SupportedCharactersPerLine(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::Collections::IVectorView<uint32_t>>(this->shim().SupportedCharactersPerLine());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
    template <typename D>
    struct produce<D, winrt::Windows::Devices::PointOfService::ICommonReceiptSlipCapabilities> : produce_base<D, winrt::Windows::Devices::PointOfService::ICommonReceiptSlipCapabilities>
    {
        int32_t __stdcall get_IsBarcodeSupported(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().IsBarcodeSupported());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_IsBitmapSupported(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().IsBitmapSupported());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_IsLeft90RotationSupported(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().IsLeft90RotationSupported());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_IsRight90RotationSupported(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().IsRight90RotationSupported());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Is180RotationSupported(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().Is180RotationSupported());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_IsPrintAreaSupported(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().IsPrintAreaSupported());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_RuledLineCapabilities(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Devices::PointOfService::PosPrinterRuledLineCapabilities>(this->shim().RuledLineCapabilities());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_SupportedBarcodeRotations(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::Collections::IVectorView<winrt::Windows::Devices::PointOfService::PosPrinterRotation>>(this->shim().SupportedBarcodeRotations());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_SupportedBitmapRotations(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::Collections::IVectorView<winrt::Windows::Devices::PointOfService::PosPrinterRotation>>(this->shim().SupportedBitmapRotations());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Devices::PointOfService::IJournalPrintJob> : produce_base<D, winrt::Windows::Devices::PointOfService::IJournalPrintJob>
    {
        int32_t __stdcall Print(void* data, void* printOptions) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Print(*reinterpret_cast<hstring const*>(&data), *reinterpret_cast<winrt::Windows::Devices::PointOfService::PosPrinterPrintOptions const*>(&printOptions));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall FeedPaperByLine(int32_t lineCount) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().FeedPaperByLine(lineCount);
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall FeedPaperByMapModeUnit(int32_t distance) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().FeedPaperByMapModeUnit(distance);
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Devices::PointOfService::IJournalPrinterCapabilities> : produce_base<D, winrt::Windows::Devices::PointOfService::IJournalPrinterCapabilities>
    {
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Devices::PointOfService::IJournalPrinterCapabilities2> : produce_base<D, winrt::Windows::Devices::PointOfService::IJournalPrinterCapabilities2>
    {
        int32_t __stdcall get_IsReverseVideoSupported(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().IsReverseVideoSupported());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_IsStrikethroughSupported(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().IsStrikethroughSupported());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_IsSuperscriptSupported(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().IsSuperscriptSupported());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_IsSubscriptSupported(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().IsSubscriptSupported());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_IsReversePaperFeedByLineSupported(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().IsReversePaperFeedByLineSupported());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_IsReversePaperFeedByMapModeUnitSupported(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().IsReversePaperFeedByMapModeUnitSupported());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Devices::PointOfService::ILineDisplay> : produce_base<D, winrt::Windows::Devices::PointOfService::ILineDisplay>
    {
        int32_t __stdcall get_DeviceId(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().DeviceId());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Capabilities(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Devices::PointOfService::LineDisplayCapabilities>(this->shim().Capabilities());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_PhysicalDeviceName(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().PhysicalDeviceName());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_PhysicalDeviceDescription(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().PhysicalDeviceDescription());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_DeviceControlDescription(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().DeviceControlDescription());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_DeviceControlVersion(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().DeviceControlVersion());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_DeviceServiceVersion(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().DeviceServiceVersion());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall ClaimAsync(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Devices::PointOfService::ClaimedLineDisplay>>(this->shim().ClaimAsync());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Devices::PointOfService::ILineDisplay2> : produce_base<D, winrt::Windows::Devices::PointOfService::ILineDisplay2>
    {
        int32_t __stdcall CheckPowerStatusAsync(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Devices::PointOfService::LineDisplayPowerStatus>>(this->shim().CheckPowerStatusAsync());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Devices::PointOfService::ILineDisplayAttributes> : produce_base<D, winrt::Windows::Devices::PointOfService::ILineDisplayAttributes>
    {
        int32_t __stdcall get_IsPowerNotifyEnabled(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().IsPowerNotifyEnabled());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_IsPowerNotifyEnabled(bool value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().IsPowerNotifyEnabled(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Brightness(int32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<int32_t>(this->shim().Brightness());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_Brightness(int32_t value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Brightness(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_BlinkRate(int64_t* value) noexcept final try
        {
            zero_abi<winrt::Windows::Foundation::TimeSpan>(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::TimeSpan>(this->shim().BlinkRate());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_BlinkRate(int64_t value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().BlinkRate(*reinterpret_cast<winrt::Windows::Foundation::TimeSpan const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_ScreenSizeInCharacters(winrt::Windows::Foundation::Size* value) noexcept final try
        {
            zero_abi<winrt::Windows::Foundation::Size>(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::Size>(this->shim().ScreenSizeInCharacters());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_ScreenSizeInCharacters(winrt::Windows::Foundation::Size value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().ScreenSizeInCharacters(*reinterpret_cast<winrt::Windows::Foundation::Size const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_CharacterSet(int32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<int32_t>(this->shim().CharacterSet());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_CharacterSet(int32_t value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().CharacterSet(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_IsCharacterSetMappingEnabled(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().IsCharacterSetMappingEnabled());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_IsCharacterSetMappingEnabled(bool value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().IsCharacterSetMappingEnabled(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_CurrentWindow(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Devices::PointOfService::LineDisplayWindow>(this->shim().CurrentWindow());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_CurrentWindow(void* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().CurrentWindow(*reinterpret_cast<winrt::Windows::Devices::PointOfService::LineDisplayWindow const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Devices::PointOfService::ILineDisplayCapabilities> : produce_base<D, winrt::Windows::Devices::PointOfService::ILineDisplayCapabilities>
    {
        int32_t __stdcall get_IsStatisticsReportingSupported(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().IsStatisticsReportingSupported());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_IsStatisticsUpdatingSupported(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().IsStatisticsUpdatingSupported());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_PowerReportingType(int32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Devices::PointOfService::UnifiedPosPowerReportingType>(this->shim().PowerReportingType());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_CanChangeScreenSize(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().CanChangeScreenSize());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_CanDisplayBitmaps(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().CanDisplayBitmaps());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_CanReadCharacterAtCursor(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().CanReadCharacterAtCursor());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_CanMapCharacterSets(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().CanMapCharacterSets());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_CanDisplayCustomGlyphs(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().CanDisplayCustomGlyphs());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_CanReverse(int32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Devices::PointOfService::LineDisplayTextAttributeGranularity>(this->shim().CanReverse());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_CanBlink(int32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Devices::PointOfService::LineDisplayTextAttributeGranularity>(this->shim().CanBlink());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_CanChangeBlinkRate(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().CanChangeBlinkRate());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_IsBrightnessSupported(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().IsBrightnessSupported());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_IsCursorSupported(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().IsCursorSupported());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_IsHorizontalMarqueeSupported(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().IsHorizontalMarqueeSupported());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_IsVerticalMarqueeSupported(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().IsVerticalMarqueeSupported());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_IsInterCharacterWaitSupported(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().IsInterCharacterWaitSupported());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_SupportedDescriptors(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint32_t>(this->shim().SupportedDescriptors());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_SupportedWindows(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint32_t>(this->shim().SupportedWindows());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Devices::PointOfService::ILineDisplayCursor> : produce_base<D, winrt::Windows::Devices::PointOfService::ILineDisplayCursor>
    {
        int32_t __stdcall get_CanCustomize(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().CanCustomize());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_IsBlinkSupported(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().IsBlinkSupported());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_IsBlockSupported(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().IsBlockSupported());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_IsHalfBlockSupported(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().IsHalfBlockSupported());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_IsUnderlineSupported(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().IsUnderlineSupported());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_IsReverseSupported(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().IsReverseSupported());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_IsOtherSupported(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().IsOtherSupported());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall GetAttributes(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::Devices::PointOfService::LineDisplayCursorAttributes>(this->shim().GetAttributes());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall TryUpdateAttributesAsync(void* attributes, void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncOperation<bool>>(this->shim().TryUpdateAttributesAsync(*reinterpret_cast<winrt::Windows::Devices::PointOfService::LineDisplayCursorAttributes const*>(&attributes)));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Devices::PointOfService::ILineDisplayCursorAttributes> : produce_base<D, winrt::Windows::Devices::PointOfService::ILineDisplayCursorAttributes>
    {
        int32_t __stdcall get_IsBlinkEnabled(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().IsBlinkEnabled());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_IsBlinkEnabled(bool value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().IsBlinkEnabled(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_CursorType(int32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Devices::PointOfService::LineDisplayCursorType>(this->shim().CursorType());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_CursorType(int32_t value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().CursorType(*reinterpret_cast<winrt::Windows::Devices::PointOfService::LineDisplayCursorType const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_IsAutoAdvanceEnabled(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().IsAutoAdvanceEnabled());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_IsAutoAdvanceEnabled(bool value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().IsAutoAdvanceEnabled(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Position(winrt::Windows::Foundation::Point* value) noexcept final try
        {
            zero_abi<winrt::Windows::Foundation::Point>(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::Point>(this->shim().Position());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_Position(winrt::Windows::Foundation::Point value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Position(*reinterpret_cast<winrt::Windows::Foundation::Point const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Devices::PointOfService::ILineDisplayCustomGlyphs> : produce_base<D, winrt::Windows::Devices::PointOfService::ILineDisplayCustomGlyphs>
    {
        int32_t __stdcall get_SizeInPixels(winrt::Windows::Foundation::Size* value) noexcept final try
        {
            zero_abi<winrt::Windows::Foundation::Size>(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::Size>(this->shim().SizeInPixels());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_SupportedGlyphCodes(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::Collections::IVectorView<uint32_t>>(this->shim().SupportedGlyphCodes());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall TryRedefineAsync(uint32_t glyphCode, void* glyphData, void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncOperation<bool>>(this->shim().TryRedefineAsync(glyphCode, *reinterpret_cast<winrt::Windows::Storage::Streams::IBuffer const*>(&glyphData)));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Devices::PointOfService::ILineDisplayMarquee> : produce_base<D, winrt::Windows::Devices::PointOfService::ILineDisplayMarquee>
    {
        int32_t __stdcall get_Format(int32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Devices::PointOfService::LineDisplayMarqueeFormat>(this->shim().Format());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_Format(int32_t value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Format(*reinterpret_cast<winrt::Windows::Devices::PointOfService::LineDisplayMarqueeFormat const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_RepeatWaitInterval(int64_t* value) noexcept final try
        {
            zero_abi<winrt::Windows::Foundation::TimeSpan>(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::TimeSpan>(this->shim().RepeatWaitInterval());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_RepeatWaitInterval(int64_t value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().RepeatWaitInterval(*reinterpret_cast<winrt::Windows::Foundation::TimeSpan const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_ScrollWaitInterval(int64_t* value) noexcept final try
        {
            zero_abi<winrt::Windows::Foundation::TimeSpan>(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::TimeSpan>(this->shim().ScrollWaitInterval());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_ScrollWaitInterval(int64_t value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().ScrollWaitInterval(*reinterpret_cast<winrt::Windows::Foundation::TimeSpan const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall TryStartScrollingAsync(int32_t direction, void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncOperation<bool>>(this->shim().TryStartScrollingAsync(*reinterpret_cast<winrt::Windows::Devices::PointOfService::LineDisplayScrollDirection const*>(&direction)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall TryStopScrollingAsync(void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncOperation<bool>>(this->shim().TryStopScrollingAsync());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Devices::PointOfService::ILineDisplayStatics> : produce_base<D, winrt::Windows::Devices::PointOfService::ILineDisplayStatics>
    {
        int32_t __stdcall FromIdAsync(void* deviceId, void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Devices::PointOfService::LineDisplay>>(this->shim().FromIdAsync(*reinterpret_cast<hstring const*>(&deviceId)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall GetDefaultAsync(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Devices::PointOfService::LineDisplay>>(this->shim().GetDefaultAsync());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall GetDeviceSelector(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<hstring>(this->shim().GetDeviceSelector());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall GetDeviceSelectorWithConnectionTypes(uint32_t connectionTypes, void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().GetDeviceSelector(*reinterpret_cast<winrt::Windows::Devices::PointOfService::PosConnectionTypes const*>(&connectionTypes)));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Devices::PointOfService::ILineDisplayStatics2> : produce_base<D, winrt::Windows::Devices::PointOfService::ILineDisplayStatics2>
    {
        int32_t __stdcall get_StatisticsCategorySelector(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Devices::PointOfService::LineDisplayStatisticsCategorySelector>(this->shim().StatisticsCategorySelector());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Devices::PointOfService::ILineDisplayStatisticsCategorySelector> : produce_base<D, winrt::Windows::Devices::PointOfService::ILineDisplayStatisticsCategorySelector>
    {
        int32_t __stdcall get_AllStatistics(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().AllStatistics());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_UnifiedPosStatistics(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().UnifiedPosStatistics());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_ManufacturerStatistics(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().ManufacturerStatistics());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Devices::PointOfService::ILineDisplayStatusUpdatedEventArgs> : produce_base<D, winrt::Windows::Devices::PointOfService::ILineDisplayStatusUpdatedEventArgs>
    {
        int32_t __stdcall get_Status(int32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Devices::PointOfService::LineDisplayPowerStatus>(this->shim().Status());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Devices::PointOfService::ILineDisplayStoredBitmap> : produce_base<D, winrt::Windows::Devices::PointOfService::ILineDisplayStoredBitmap>
    {
        int32_t __stdcall get_EscapeSequence(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().EscapeSequence());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall TryDeleteAsync(void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncOperation<bool>>(this->shim().TryDeleteAsync());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Devices::PointOfService::ILineDisplayWindow> : produce_base<D, winrt::Windows::Devices::PointOfService::ILineDisplayWindow>
    {
        int32_t __stdcall get_SizeInCharacters(winrt::Windows::Foundation::Size* value) noexcept final try
        {
            zero_abi<winrt::Windows::Foundation::Size>(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::Size>(this->shim().SizeInCharacters());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_InterCharacterWaitInterval(int64_t* value) noexcept final try
        {
            zero_abi<winrt::Windows::Foundation::TimeSpan>(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::TimeSpan>(this->shim().InterCharacterWaitInterval());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_InterCharacterWaitInterval(int64_t value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().InterCharacterWaitInterval(*reinterpret_cast<winrt::Windows::Foundation::TimeSpan const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall TryRefreshAsync(void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncOperation<bool>>(this->shim().TryRefreshAsync());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall TryDisplayTextAsync(void* text, int32_t displayAttribute, void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncOperation<bool>>(this->shim().TryDisplayTextAsync(*reinterpret_cast<hstring const*>(&text), *reinterpret_cast<winrt::Windows::Devices::PointOfService::LineDisplayTextAttribute const*>(&displayAttribute)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall TryDisplayTextAtPositionAsync(void* text, int32_t displayAttribute, winrt::Windows::Foundation::Point startPosition, void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncOperation<bool>>(this->shim().TryDisplayTextAsync(*reinterpret_cast<hstring const*>(&text), *reinterpret_cast<winrt::Windows::Devices::PointOfService::LineDisplayTextAttribute const*>(&displayAttribute), *reinterpret_cast<winrt::Windows::Foundation::Point const*>(&startPosition)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall TryDisplayTextNormalAsync(void* text, void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncOperation<bool>>(this->shim().TryDisplayTextAsync(*reinterpret_cast<hstring const*>(&text)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall TryScrollTextAsync(int32_t direction, uint32_t numberOfColumnsOrRows, void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncOperation<bool>>(this->shim().TryScrollTextAsync(*reinterpret_cast<winrt::Windows::Devices::PointOfService::LineDisplayScrollDirection const*>(&direction), numberOfColumnsOrRows));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall TryClearTextAsync(void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncOperation<bool>>(this->shim().TryClearTextAsync());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Devices::PointOfService::ILineDisplayWindow2> : produce_base<D, winrt::Windows::Devices::PointOfService::ILineDisplayWindow2>
    {
        int32_t __stdcall get_Cursor(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Devices::PointOfService::LineDisplayCursor>(this->shim().Cursor());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Marquee(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Devices::PointOfService::LineDisplayMarquee>(this->shim().Marquee());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall ReadCharacterAtCursorAsync(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::Foundation::IAsyncOperation<uint32_t>>(this->shim().ReadCharacterAtCursorAsync());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall TryDisplayStoredBitmapAtCursorAsync(void* bitmap, void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncOperation<bool>>(this->shim().TryDisplayStoredBitmapAtCursorAsync(*reinterpret_cast<winrt::Windows::Devices::PointOfService::LineDisplayStoredBitmap const*>(&bitmap)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall TryDisplayStorageFileBitmapAtCursorAsync(void* bitmap, void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncOperation<bool>>(this->shim().TryDisplayStorageFileBitmapAtCursorAsync(*reinterpret_cast<winrt::Windows::Storage::StorageFile const*>(&bitmap)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall TryDisplayStorageFileBitmapAtCursorWithAlignmentAsync(void* bitmap, int32_t horizontalAlignment, int32_t verticalAlignment, void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncOperation<bool>>(this->shim().TryDisplayStorageFileBitmapAtCursorAsync(*reinterpret_cast<winrt::Windows::Storage::StorageFile const*>(&bitmap), *reinterpret_cast<winrt::Windows::Devices::PointOfService::LineDisplayHorizontalAlignment const*>(&horizontalAlignment), *reinterpret_cast<winrt::Windows::Devices::PointOfService::LineDisplayVerticalAlignment const*>(&verticalAlignment)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall TryDisplayStorageFileBitmapAtCursorWithAlignmentAndWidthAsync(void* bitmap, int32_t horizontalAlignment, int32_t verticalAlignment, int32_t widthInPixels, void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncOperation<bool>>(this->shim().TryDisplayStorageFileBitmapAtCursorAsync(*reinterpret_cast<winrt::Windows::Storage::StorageFile const*>(&bitmap), *reinterpret_cast<winrt::Windows::Devices::PointOfService::LineDisplayHorizontalAlignment const*>(&horizontalAlignment), *reinterpret_cast<winrt::Windows::Devices::PointOfService::LineDisplayVerticalAlignment const*>(&verticalAlignment), widthInPixels));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall TryDisplayStorageFileBitmapAtPointAsync(void* bitmap, winrt::Windows::Foundation::Point offsetInPixels, void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncOperation<bool>>(this->shim().TryDisplayStorageFileBitmapAtPointAsync(*reinterpret_cast<winrt::Windows::Storage::StorageFile const*>(&bitmap), *reinterpret_cast<winrt::Windows::Foundation::Point const*>(&offsetInPixels)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall TryDisplayStorageFileBitmapAtPointWithWidthAsync(void* bitmap, winrt::Windows::Foundation::Point offsetInPixels, int32_t widthInPixels, void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncOperation<bool>>(this->shim().TryDisplayStorageFileBitmapAtPointAsync(*reinterpret_cast<winrt::Windows::Storage::StorageFile const*>(&bitmap), *reinterpret_cast<winrt::Windows::Foundation::Point const*>(&offsetInPixels), widthInPixels));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Devices::PointOfService::IMagneticStripeReader> : produce_base<D, winrt::Windows::Devices::PointOfService::IMagneticStripeReader>
    {
        int32_t __stdcall get_DeviceId(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().DeviceId());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Capabilities(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Devices::PointOfService::MagneticStripeReaderCapabilities>(this->shim().Capabilities());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_SupportedCardTypes(uint32_t* __valueSize, uint32_t** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            std::tie(*__valueSize, *value) = detach_abi(this->shim().SupportedCardTypes());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_DeviceAuthenticationProtocol(int32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Devices::PointOfService::MagneticStripeReaderAuthenticationProtocol>(this->shim().DeviceAuthenticationProtocol());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall CheckHealthAsync(int32_t level, void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncOperation<hstring>>(this->shim().CheckHealthAsync(*reinterpret_cast<winrt::Windows::Devices::PointOfService::UnifiedPosHealthCheckLevel const*>(&level)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall ClaimReaderAsync(void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Devices::PointOfService::ClaimedMagneticStripeReader>>(this->shim().ClaimReaderAsync());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall RetrieveStatisticsAsync(void* statisticsCategories, void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Storage::Streams::IBuffer>>(this->shim().RetrieveStatisticsAsync(*reinterpret_cast<winrt::Windows::Foundation::Collections::IIterable<hstring> const*>(&statisticsCategories)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall GetErrorReportingType(int32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Devices::PointOfService::MagneticStripeReaderErrorReportingType>(this->shim().GetErrorReportingType());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall add_StatusUpdated(void* handler, winrt::event_token* token) noexcept final try
        {
            zero_abi<winrt::event_token>(token);
            typename D::abi_guard guard(this->shim());
            *token = detach_from<winrt::event_token>(this->shim().StatusUpdated(*reinterpret_cast<winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::Devices::PointOfService::MagneticStripeReader, winrt::Windows::Devices::PointOfService::MagneticStripeReaderStatusUpdatedEventArgs> const*>(&handler)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall remove_StatusUpdated(winrt::event_token token) noexcept final
        {
            typename D::abi_guard guard(this->shim());
            this->shim().StatusUpdated(*reinterpret_cast<winrt::event_token const*>(&token));
            return 0;
        }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Devices::PointOfService::IMagneticStripeReaderAamvaCardDataReceivedEventArgs> : produce_base<D, winrt::Windows::Devices::PointOfService::IMagneticStripeReaderAamvaCardDataReceivedEventArgs>
    {
        int32_t __stdcall get_Report(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Devices::PointOfService::MagneticStripeReaderReport>(this->shim().Report());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_LicenseNumber(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().LicenseNumber());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_ExpirationDate(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().ExpirationDate());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Restrictions(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().Restrictions());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Class(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().Class());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Endorsements(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().Endorsements());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_BirthDate(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().BirthDate());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_FirstName(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().FirstName());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Surname(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().Surname());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Suffix(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().Suffix());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Gender(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().Gender());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_HairColor(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().HairColor());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_EyeColor(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().EyeColor());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Height(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().Height());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Weight(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().Weight());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Address(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().Address());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_City(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().City());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_State(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().State());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_PostalCode(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().PostalCode());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Devices::PointOfService::IMagneticStripeReaderBankCardDataReceivedEventArgs> : produce_base<D, winrt::Windows::Devices::PointOfService::IMagneticStripeReaderBankCardDataReceivedEventArgs>
    {
        int32_t __stdcall get_Report(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Devices::PointOfService::MagneticStripeReaderReport>(this->shim().Report());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_AccountNumber(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().AccountNumber());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_ExpirationDate(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().ExpirationDate());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_ServiceCode(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().ServiceCode());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Title(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().Title());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_FirstName(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().FirstName());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_MiddleInitial(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().MiddleInitial());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Surname(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().Surname());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Suffix(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().Suffix());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Devices::PointOfService::IMagneticStripeReaderCapabilities> : produce_base<D, winrt::Windows::Devices::PointOfService::IMagneticStripeReaderCapabilities>
    {
        int32_t __stdcall get_CardAuthentication(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().CardAuthentication());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_SupportedEncryptionAlgorithms(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint32_t>(this->shim().SupportedEncryptionAlgorithms());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_AuthenticationLevel(int32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Devices::PointOfService::MagneticStripeReaderAuthenticationLevel>(this->shim().AuthenticationLevel());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_IsIsoSupported(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().IsIsoSupported());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_IsJisOneSupported(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().IsJisOneSupported());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_IsJisTwoSupported(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().IsJisTwoSupported());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_PowerReportingType(int32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Devices::PointOfService::UnifiedPosPowerReportingType>(this->shim().PowerReportingType());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_IsStatisticsReportingSupported(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().IsStatisticsReportingSupported());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_IsStatisticsUpdatingSupported(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().IsStatisticsUpdatingSupported());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_IsTrackDataMaskingSupported(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().IsTrackDataMaskingSupported());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_IsTransmitSentinelsSupported(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().IsTransmitSentinelsSupported());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Devices::PointOfService::IMagneticStripeReaderCardTypesStatics> : produce_base<D, winrt::Windows::Devices::PointOfService::IMagneticStripeReaderCardTypesStatics>
    {
        int32_t __stdcall get_Unknown(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint32_t>(this->shim().Unknown());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Bank(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint32_t>(this->shim().Bank());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Aamva(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint32_t>(this->shim().Aamva());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_ExtendedBase(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint32_t>(this->shim().ExtendedBase());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Devices::PointOfService::IMagneticStripeReaderEncryptionAlgorithmsStatics> : produce_base<D, winrt::Windows::Devices::PointOfService::IMagneticStripeReaderEncryptionAlgorithmsStatics>
    {
        int32_t __stdcall get_None(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint32_t>(this->shim().None());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_TripleDesDukpt(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint32_t>(this->shim().TripleDesDukpt());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_ExtendedBase(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint32_t>(this->shim().ExtendedBase());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Devices::PointOfService::IMagneticStripeReaderErrorOccurredEventArgs> : produce_base<D, winrt::Windows::Devices::PointOfService::IMagneticStripeReaderErrorOccurredEventArgs>
    {
        int32_t __stdcall get_Track1Status(int32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Devices::PointOfService::MagneticStripeReaderTrackErrorType>(this->shim().Track1Status());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Track2Status(int32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Devices::PointOfService::MagneticStripeReaderTrackErrorType>(this->shim().Track2Status());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Track3Status(int32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Devices::PointOfService::MagneticStripeReaderTrackErrorType>(this->shim().Track3Status());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Track4Status(int32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Devices::PointOfService::MagneticStripeReaderTrackErrorType>(this->shim().Track4Status());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_ErrorData(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Devices::PointOfService::UnifiedPosErrorData>(this->shim().ErrorData());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_PartialInputData(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Devices::PointOfService::MagneticStripeReaderReport>(this->shim().PartialInputData());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Devices::PointOfService::IMagneticStripeReaderReport> : produce_base<D, winrt::Windows::Devices::PointOfService::IMagneticStripeReaderReport>
    {
        int32_t __stdcall get_CardType(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint32_t>(this->shim().CardType());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Track1(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Devices::PointOfService::MagneticStripeReaderTrackData>(this->shim().Track1());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Track2(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Devices::PointOfService::MagneticStripeReaderTrackData>(this->shim().Track2());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Track3(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Devices::PointOfService::MagneticStripeReaderTrackData>(this->shim().Track3());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Track4(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Devices::PointOfService::MagneticStripeReaderTrackData>(this->shim().Track4());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Properties(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::Collections::IMapView<hstring, hstring>>(this->shim().Properties());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_CardAuthenticationData(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Storage::Streams::IBuffer>(this->shim().CardAuthenticationData());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_CardAuthenticationDataLength(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint32_t>(this->shim().CardAuthenticationDataLength());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_AdditionalSecurityInformation(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Storage::Streams::IBuffer>(this->shim().AdditionalSecurityInformation());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Devices::PointOfService::IMagneticStripeReaderStatics> : produce_base<D, winrt::Windows::Devices::PointOfService::IMagneticStripeReaderStatics>
    {
        int32_t __stdcall GetDefaultAsync(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Devices::PointOfService::MagneticStripeReader>>(this->shim().GetDefaultAsync());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall FromIdAsync(void* deviceId, void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Devices::PointOfService::MagneticStripeReader>>(this->shim().FromIdAsync(*reinterpret_cast<hstring const*>(&deviceId)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall GetDeviceSelector(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().GetDeviceSelector());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Devices::PointOfService::IMagneticStripeReaderStatics2> : produce_base<D, winrt::Windows::Devices::PointOfService::IMagneticStripeReaderStatics2>
    {
        int32_t __stdcall GetDeviceSelectorWithConnectionTypes(uint32_t connectionTypes, void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().GetDeviceSelector(*reinterpret_cast<winrt::Windows::Devices::PointOfService::PosConnectionTypes const*>(&connectionTypes)));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Devices::PointOfService::IMagneticStripeReaderStatusUpdatedEventArgs> : produce_base<D, winrt::Windows::Devices::PointOfService::IMagneticStripeReaderStatusUpdatedEventArgs>
    {
        int32_t __stdcall get_Status(int32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Devices::PointOfService::MagneticStripeReaderStatus>(this->shim().Status());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_ExtendedStatus(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint32_t>(this->shim().ExtendedStatus());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Devices::PointOfService::IMagneticStripeReaderTrackData> : produce_base<D, winrt::Windows::Devices::PointOfService::IMagneticStripeReaderTrackData>
    {
        int32_t __stdcall get_Data(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Storage::Streams::IBuffer>(this->shim().Data());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_DiscretionaryData(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Storage::Streams::IBuffer>(this->shim().DiscretionaryData());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_EncryptedData(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Storage::Streams::IBuffer>(this->shim().EncryptedData());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Devices::PointOfService::IMagneticStripeReaderVendorSpecificCardDataReceivedEventArgs> : produce_base<D, winrt::Windows::Devices::PointOfService::IMagneticStripeReaderVendorSpecificCardDataReceivedEventArgs>
    {
        int32_t __stdcall get_Report(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Devices::PointOfService::MagneticStripeReaderReport>(this->shim().Report());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Devices::PointOfService::IPosPrinter> : produce_base<D, winrt::Windows::Devices::PointOfService::IPosPrinter>
    {
        int32_t __stdcall get_DeviceId(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().DeviceId());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Capabilities(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Devices::PointOfService::PosPrinterCapabilities>(this->shim().Capabilities());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_SupportedCharacterSets(void** value) noexc