// C++/WinRT v2.0.250303.1

// SPDX-License-Identifier: MIT OR Apache-2.0
// SPDX-FileCopyrightText: Copyright (c) Microsoft Corporation
//
// Generated using .winmd files from https://github.com/microsoft/windows-rs
//

#pragma once
#ifndef WINRT_Windows_ApplicationModel_AppExtensions_H
#define WINRT_Windows_ApplicationModel_AppExtensions_H
#include "winrt/base.h"
static_assert(winrt::check_version(CPPWINRT_VERSION, "2.0.250303.1"), "Mismatched C++/WinRT headers.");
#define CPPWINRT_VERSION "2.0.250303.1"
#include "winrt/Windows.ApplicationModel.h"
#include "winrt/impl/Windows.ApplicationModel.2.h"
#include "winrt/impl/Windows.Foundation.2.h"
#include "winrt/impl/Windows.Foundation.Collections.2.h"
#include "winrt/impl/Windows.Storage.2.h"
#include "winrt/impl/Windows.ApplicationModel.AppExtensions.2.h"
namespace winrt::impl
{
    template <typename D> auto consume_Windows_ApplicationModel_AppExtensions_IAppExtension<D>::Id() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::AppExtensions::IAppExtension>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::AppExtensions::IAppExtension, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::AppExtensions::IAppExtension>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Id(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::AppExtensions::IAppExtension>**)this;
            check_hresult(_winrt_abi_type->get_Id(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_AppExtensions_IAppExtension<D>::DisplayName() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::AppExtensions::IAppExtension>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::AppExtensions::IAppExtension, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::AppExtensions::IAppExtension>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_DisplayName(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::AppExtensions::IAppExtension>**)this;
            check_hresult(_winrt_abi_type->get_DisplayName(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_AppExtensions_IAppExtension<D>::Description() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::AppExtensions::IAppExtension>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::AppExtensions::IAppExtension, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::AppExtensions::IAppExtension>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Description(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::AppExtensions::IAppExtension>**)this;
            check_hresult(_winrt_abi_type->get_Description(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_AppExtensions_IAppExtension<D>::Package() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::AppExtensions::IAppExtension>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::AppExtensions::IAppExtension, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::AppExtensions::IAppExtension>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Package(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::AppExtensions::IAppExtension>**)this;
            check_hresult(_winrt_abi_type->get_Package(&value));
        }
        return winrt::Windows::ApplicationModel::Package{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_AppExtensions_IAppExtension<D>::AppInfo() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::AppExtensions::IAppExtension>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::AppExtensions::IAppExtension, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::AppExtensions::IAppExtension>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_AppInfo(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::AppExtensions::IAppExtension>**)this;
            check_hresult(_winrt_abi_type->get_AppInfo(&value));
        }
        return winrt::Windows::ApplicationModel::AppInfo{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_AppExtensions_IAppExtension<D>::GetExtensionPropertiesAsync() const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::AppExtensions::IAppExtension>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::AppExtensions::IAppExtension, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::AppExtensions::IAppExtension>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetExtensionPropertiesAsync(&operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::AppExtensions::IAppExtension>**)this;
            check_hresult(_winrt_abi_type->GetExtensionPropertiesAsync(&operation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Foundation::Collections::IPropertySet>{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_AppExtensions_IAppExtension<D>::GetPublicFolderAsync() const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::AppExtensions::IAppExtension>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::AppExtensions::IAppExtension, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::AppExtensions::IAppExtension>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetPublicFolderAsync(&operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::AppExtensions::IAppExtension>**)this;
            check_hresult(_winrt_abi_type->GetPublicFolderAsync(&operation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Storage::StorageFolder>{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_AppExtensions_IAppExtension2<D>::AppUserModelId() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::AppExtensions::IAppExtension2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::AppExtensions::IAppExtension2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::AppExtensions::IAppExtension2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_AppUserModelId(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::AppExtensions::IAppExtension2>**)this;
            check_hresult(_winrt_abi_type->get_AppUserModelId(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_AppExtensions_IAppExtension3<D>::GetExtensionProperties() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::AppExtensions::IAppExtension3>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::AppExtensions::IAppExtension3, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::AppExtensions::IAppExtension3>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetExtensionProperties(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::AppExtensions::IAppExtension3>**)this;
            check_hresult(_winrt_abi_type->GetExtensionProperties(&result));
        }
        return winrt::Windows::Foundation::Collections::IPropertySet{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_AppExtensions_IAppExtension3<D>::GetPublicPath() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::AppExtensions::IAppExtension3>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::AppExtensions::IAppExtension3, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::AppExtensions::IAppExtension3>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetPublicPath(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::AppExtensions::IAppExtension3>**)this;
            check_hresult(_winrt_abi_type->GetPublicPath(&result));
        }
        return hstring{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_AppExtensions_IAppExtension3<D>::GetPublicFolder() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::AppExtensions::IAppExtension3>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::AppExtensions::IAppExtension3, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::AppExtensions::IAppExtension3>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetPublicFolder(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::AppExtensions::IAppExtension3>**)this;
            check_hresult(_winrt_abi_type->GetPublicFolder(&result));
        }
        return winrt::Windows::Storage::StorageFolder{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_AppExtensions_IAppExtensionCatalog<D>::FindAllAsync() const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::AppExtensions::IAppExtensionCatalog>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::AppExtensions::IAppExtensionCatalog, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::AppExtensions::IAppExtensionCatalog>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->FindAllAsync(&operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::AppExtensions::IAppExtensionCatalog>**)this;
            check_hresult(_winrt_abi_type->FindAllAsync(&operation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Foundation::Collections::IVectorView<winrt::Windows::ApplicationModel::AppExtensions::AppExtension>>{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_AppExtensions_IAppExtensionCatalog<D>::RequestRemovePackageAsync(param::hstring const& packageFullName) const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::AppExtensions::IAppExtensionCatalog>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::AppExtensions::IAppExtensionCatalog, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::AppExtensions::IAppExtensionCatalog>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->RequestRemovePackageAsync(*(void**)(&packageFullName), &operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::AppExtensions::IAppExtensionCatalog>**)this;
            check_hresult(_winrt_abi_type->RequestRemovePackageAsync(*(void**)(&packageFullName), &operation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<bool>{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_AppExtensions_IAppExtensionCatalog<D>::PackageInstalled(winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::ApplicationModel::AppExtensions::AppExtensionCatalog, winrt::Windows::ApplicationModel::AppExtensions::AppExtensionPackageInstalledEventArgs> const& handler) const
    {
        winrt::event_token token{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::AppExtensions::IAppExtensionCatalog>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::AppExtensions::IAppExtensionCatalog, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::AppExtensions::IAppExtensionCatalog>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->add_PackageInstalled(*(void**)(&handler), put_abi(token)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::AppExtensions::IAppExtensionCatalog>**)this;
            check_hresult(_winrt_abi_type->add_PackageInstalled(*(void**)(&handler), put_abi(token)));
        }
        return token;
    }
    template <typename D> auto consume_Windows_ApplicationModel_AppExtensions_IAppExtensionCatalog<D>::PackageInstalled(auto_revoke_t, winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::ApplicationModel::AppExtensions::AppExtensionCatalog, winrt::Windows::ApplicationModel::AppExtensions::AppExtensionPackageInstalledEventArgs> const& handler) const
    {
        return impl::make_event_revoker<D, PackageInstalled_revoker>(this, PackageInstalled(handler));
    }
    template <typename D> auto consume_Windows_ApplicationModel_AppExtensions_IAppExtensionCatalog<D>::PackageInstalled(winrt::event_token const& token) const noexcept
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::AppExtensions::IAppExtensionCatalog>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::AppExtensions::IAppExtensionCatalog, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::AppExtensions::IAppExtensionCatalog>**)&_winrt_casted_result;
            _winrt_abi_type->remove_PackageInstalled(impl::bind_in(token));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::AppExtensions::IAppExtensionCatalog>**)this;
            _winrt_abi_type->remove_PackageInstalled(impl::bind_in(token));
        }
    }
    template <typename D> auto consume_Windows_ApplicationModel_AppExtensions_IAppExtensionCatalog<D>::PackageUpdating(winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::ApplicationModel::AppExtensions::AppExtensionCatalog, winrt::Windows::ApplicationModel::AppExtensions::AppExtensionPackageUpdatingEventArgs> const& handler) const
    {
        winrt::event_token token{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::AppExtensions::IAppExtensionCatalog>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::AppExtensions::IAppExtensionCatalog, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::AppExtensions::IAppExtensionCatalog>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->add_PackageUpdating(*(void**)(&handler), put_abi(token)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::AppExtensions::IAppExtensionCatalog>**)this;
            check_hresult(_winrt_abi_type->add_PackageUpdating(*(void**)(&handler), put_abi(token)));
        }
        return token;
    }
    template <typename D> auto consume_Windows_ApplicationModel_AppExtensions_IAppExtensionCatalog<D>::PackageUpdating(auto_revoke_t, winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::ApplicationModel::AppExtensions::AppExtensionCatalog, winrt::Windows::ApplicationModel::AppExtensions::AppExtensionPackageUpdatingEventArgs> const& handler) const
    {
        return impl::make_event_revoker<D, PackageUpdating_revoker>(this, PackageUpdating(handler));
    }
    template <typename D> auto consume_Windows_ApplicationModel_AppExtensions_IAppExtensionCatalog<D>::PackageUpdating(winrt::event_token const& token) const noexcept
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::AppExtensions::IAppExtensionCatalog>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::AppExtensions::IAppExtensionCatalog, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::AppExtensions::IAppExtensionCatalog>**)&_winrt_casted_result;
            _winrt_abi_type->remove_PackageUpdating(impl::bind_in(token));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::AppExtensions::IAppExtensionCatalog>**)this;
            _winrt_abi_type->remove_PackageUpdating(impl::bind_in(token));
        }
    }
    template <typename D> auto consume_Windows_ApplicationModel_AppExtensions_IAppExtensionCatalog<D>::PackageUpdated(winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::ApplicationModel::AppExtensions::AppExtensionCatalog, winrt::Windows::ApplicationModel::AppExtensions::AppExtensionPackageUpdatedEventArgs> const& handler) const
    {
        winrt::event_token token{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::AppExtensions::IAppExtensionCatalog>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::AppExtensions::IAppExtensionCatalog, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::AppExtensions::IAppExtensionCatalog>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->add_PackageUpdated(*(void**)(&handler), put_abi(token)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::AppExtensions::IAppExtensionCatalog>**)this;
            check_hresult(_winrt_abi_type->add_PackageUpdated(*(void**)(&handler), put_abi(token)));
        }
        return token;
    }
    template <typename D> auto consume_Windows_ApplicationModel_AppExtensions_IAppExtensionCatalog<D>::PackageUpdated(auto_revoke_t, winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::ApplicationModel::AppExtensions::AppExtensionCatalog, winrt::Windows::ApplicationModel::AppExtensions::AppExtensionPackageUpdatedEventArgs> const& handler) const
    {
        return impl::make_event_revoker<D, PackageUpdated_revoker>(this, PackageUpdated(handler));
    }
    template <typename D> auto consume_Windows_ApplicationModel_AppExtensions_IAppExtensionCatalog<D>::PackageUpdated(winrt::event_token const& token) const noexcept
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::AppExtensions::IAppExtensionCatalog>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::AppExtensions::IAppExtensionCatalog, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::AppExtensions::IAppExtensionCatalog>**)&_winrt_casted_result;
            _winrt_abi_type->remove_PackageUpdated(impl::bind_in(token));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::AppExtensions::IAppExtensionCatalog>**)this;
            _winrt_abi_type->remove_PackageUpdated(impl::bind_in(token));
        }
    }
    template <typename D> auto consume_Windows_ApplicationModel_AppExtensions_IAppExtensionCatalog<D>::PackageUninstalling(winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::ApplicationModel::AppExtensions::AppExtensionCatalog, winrt::Windows::ApplicationModel::AppExtensions::AppExtensionPackageUninstallingEventArgs> const& handler) const
    {
        winrt::event_token token{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::AppExtensions::IAppExtensionCatalog>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::AppExtensions::IAppExtensionCatalog, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::AppExtensions::IAppExtensionCatalog>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->add_PackageUninstalling(*(void**)(&handler), put_abi(token)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::AppExtensions::IAppExtensionCatalog>**)this;
            check_hresult(_winrt_abi_type->add_PackageUninstalling(*(void**)(&handler), put_abi(token)));
        }
        return token;
    }
    template <typename D> auto consume_Windows_ApplicationModel_AppExtensions_IAppExtensionCatalog<D>::PackageUninstalling(auto_revoke_t, winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::ApplicationModel::AppExtensions::AppExtensionCatalog, winrt::Windows::ApplicationModel::AppExtensions::AppExtensionPackageUninstallingEventArgs> const& handler) const
    {
        return impl::make_event_revoker<D, PackageUninstalling_revoker>(this, PackageUninstalling(handler));
    }
    template <typename D> auto consume_Windows_ApplicationModel_AppExtensions_IAppExtensionCatalog<D>::PackageUninstalling(winrt::event_token const& token) const noexcept
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::AppExtensions::IAppExtensionCatalog>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::AppExtensions::IAppExtensionCatalog, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::AppExtensions::IAppExtensionCatalog>**)&_winrt_casted_result;
            _winrt_abi_type->remove_PackageUninstalling(impl::bind_in(token));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::AppExtensions::IAppExtensionCatalog>**)this;
            _winrt_abi_type->remove_PackageUninstalling(impl::bind_in(token));
        }
    }
    template <typename D> auto consume_Windows_ApplicationModel_AppExtensions_IAppExtensionCatalog<D>::PackageStatusChanged(winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::ApplicationModel::AppExtensions::AppExtensionCatalog, winrt::Windows::ApplicationModel::AppExtensions::AppExtensionPackageStatusChangedEventArgs> const& handler) const
    {
        winrt::event_token token{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::AppExtensions::IAppExtensionCatalog>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::AppExtensions::IAppExtensionCatalog, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::AppExtensions::IAppExtensionCatalog>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->add_PackageStatusChanged(*(void**)(&handler), put_abi(token)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::AppExtensions::IAppExtensionCatalog>**)this;
            check_hresult(_winrt_abi_type->add_PackageStatusChanged(*(void**)(&handler), put_abi(token)));
        }
        return token;
    }
    template <typename D> auto consume_Windows_ApplicationModel_AppExtensions_IAppExtensionCatalog<D>::PackageStatusChanged(auto_revoke_t, winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::ApplicationModel::AppExtensions::AppExtensionCatalog, winrt::Windows::ApplicationModel::AppExtensions::AppExtensionPackageStatusChangedEventArgs> const& handler) const
    {
        return impl::make_event_revoker<D, PackageStatusChanged_revoker>(this, PackageStatusChanged(handler));
    }
    template <typename D> auto consume_Windows_ApplicationModel_AppExtensions_IAppExtensionCatalog<D>::PackageStatusChanged(winrt::event_token const& token) const noexcept
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::AppExtensions::IAppExtensionCatalog>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::AppExtensions::IAppExtensionCatalog, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::AppExtensions::IAppExtensionCatalog>**)&_winrt_casted_result;
            _winrt_abi_type->remove_PackageStatusChanged(impl::bind_in(token));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::AppExtensions::IAppExtensionCatalog>**)this;
            _winrt_abi_type->remove_PackageStatusChanged(impl::bind_in(token));
        }
    }
    template <typename D> auto consume_Windows_ApplicationModel_AppExtensions_IAppExtensionCatalog2<D>::FindAll() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::AppExtensions::IAppExtensionCatalog2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::AppExtensions::IAppExtensionCatalog2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::AppExtensions::IAppExtensionCatalog2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->FindAll(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::AppExtensions::IAppExtensionCatalog2>**)this;
            check_hresult(_winrt_abi_type->FindAll(&result));
        }
        return winrt::Windows::Foundation::Collections::IVectorView<winrt::Windows::ApplicationModel::AppExtensions::AppExtension>{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_AppExtensions_IAppExtensionCatalogStatics<D>::Open(param::hstring const& appExtensionName) const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::AppExtensions::IAppExtensionCatalogStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::AppExtensions::IAppExtensionCatalogStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::AppExtensions::IAppExtensionCatalogStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->Open(*(void**)(&appExtensionName), &value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::AppExtensions::IAppExtensionCatalogStatics>**)this;
            check_hresult(_winrt_abi_type->Open(*(void**)(&appExtensionName), &value));
        }
        return winrt::Windows::ApplicationModel::AppExtensions::AppExtensionCatalog{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_AppExtensions_IAppExtensionPackageInstalledEventArgs<D>::AppExtensionName() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::AppExtensions::IAppExtensionPackageInstalledEventArgs>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::AppExtensions::IAppExtensionPackageInstalledEventArgs, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::AppExtensions::IAppExtensionPackageInstalledEventArgs>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_AppExtensionName(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::AppExtensions::IAppExtensionPackageInstalledEventArgs>**)this;
            check_hresult(_winrt_abi_type->get_AppExtensionName(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_AppExtensions_IAppExtensionPackageInstalledEventArgs<D>::Package() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::AppExtensions::IAppExtensionPackageInstalledEventArgs>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::AppExtensions::IAppExtensionPackageInstalledEventArgs, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::AppExtensions::IAppExtensionPackageInstalledEventArgs>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Package(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::AppExtensions::IAppExtensionPackageInstalledEventArgs>**)this;
            check_hresult(_winrt_abi_type->get_Package(&value));
        }
        return winrt::Windows::ApplicationModel::Package{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_AppExtensions_IAppExtensionPackageInstalledEventArgs<D>::Extensions() const
    {
        void* values{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::AppExtensions::IAppExtensionPackageInstalledEventArgs>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::AppExtensions::IAppExtensionPackageInstalledEventArgs, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::AppExtensions::IAppExtensionPackageInstalledEventArgs>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Extensions(&values));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::AppExtensions::IAppExtensionPackageInstalledEventArgs>**)this;
            check_hresult(_winrt_abi_type->get_Extensions(&values));
        }
        return winrt::Windows::Foundation::Collections::IVectorView<winrt::Windows::ApplicationModel::AppExtensions::AppExtension>{ values, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_AppExtensions_IAppExtensionPackageStatusChangedEventArgs<D>::AppExtensionName() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::AppExtensions::IAppExtensionPackageStatusChangedEventArgs>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::AppExtensions::IAppExtensionPackageStatusChangedEventArgs, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::AppExtensions::IAppExtensionPackageStatusChangedEventArgs>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_AppExtensionName(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::AppExtensions::IAppExtensionPackageStatusChangedEventArgs>**)this;
            check_hresult(_winrt_abi_type->get_AppExtensionName(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_AppExtensions_IAppExtensionPackageStatusChangedEventArgs<D>::Package() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::AppExtensions::IAppExtensionPackageStatusChangedEventArgs>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::AppExtensions::IAppExtensionPackageStatusChangedEventArgs, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::AppExtensions::IAppExtensionPackageStatusChangedEventArgs>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Package(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::AppExtensions::IAppExtensionPackageStatusChangedEventArgs>**)this;
            check_hresult(_winrt_abi_type->get_Package(&value));
        }
        return winrt::Windows::ApplicationModel::Package{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_AppExtensions_IAppExtensionPackageUninstallingEventArgs<D>::AppExtensionName() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::AppExtensions::IAppExtensionPackageUninstallingEventArgs>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::AppExtensions::IAppExtensionPackageUninstallingEventArgs, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::AppExtensions::IAppExtensionPackageUninstallingEventArgs>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_AppExtensionName(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::AppExtensions::IAppExtensionPackageUninstallingEventArgs>**)this;
            check_hresult(_winrt_abi_type->get_AppExtensionName(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_AppExtensions_IAppExtensionPackageUninstallingEventArgs<D>::Package() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::AppExtensions::IAppExtensionPackageUninstallingEventArgs>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::AppExtensions::IAppExtensionPackageUninstallingEventArgs, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::AppExtensions::IAppExtensionPackageUninstallingEventArgs>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Package(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::AppExtensions::IAppExtensionPackageUninstallingEventArgs>**)this;
            check_hresult(_winrt_abi_type->get_Package(&value));
        }
        return winrt::Windows::ApplicationModel::Package{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_AppExtensions_IAppExtensionPackageUpdatedEventArgs<D>::AppExtensionName() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::AppExtensions::IAppExtensionPackageUpdatedEventArgs>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::AppExtensions::IAppExtensionPackageUpdatedEventArgs, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::AppExtensions::IAppExtensionPackageUpdatedEventArgs>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_AppExtensionName(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::AppExtensions::IAppExtensionPackageUpdatedEventArgs>**)this;
            check_hresult(_winrt_abi_type->get_AppExtensionName(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_AppExtensions_IAppExtensionPackageUpdatedEventArgs<D>::Package() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::AppExtensions::IAppExtensionPackageUpdatedEventArgs>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::AppExtensions::IAppExtensionPackageUpdatedEventArgs, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::AppExtensions::IAppExtensionPackageUpdatedEventArgs>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Package(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::AppExtensions::IAppExtensionPackageUpdatedEventArgs>**)this;
            check_hresult(_winrt_abi_type->get_Package(&value));
        }
        return winrt::Windows::ApplicationModel::Package{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_AppExtensions_IAppExtensionPackageUpdatedEventArgs<D>::Extensions() const
    {
        void* values{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::AppExtensions::IAppExtensionPackageUpdatedEventArgs>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::AppExtensions::IAppExtensionPackageUpdatedEventArgs, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::AppExtensions::IAppExtensionPackageUpdatedEventArgs>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Extensions(&values));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::AppExtensions::IAppExtensionPackageUpdatedEventArgs>**)this;
            check_hresult(_winrt_abi_type->get_Extensions(&values));
        }
        return winrt::Windows::Foundation::Collections::IVectorView<winrt::Windows::ApplicationModel::AppExtensions::AppExtension>{ values, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_AppExtensions_IAppExtensionPackageUpdatingEventArgs<D>::AppExtensionName() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::AppExtensions::IAppExtensionPackageUpdatingEventArgs>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::AppExtensions::IAppExtensionPackageUpdatingEventArgs, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::AppExtensions::IAppExtensionPackageUpdatingEventArgs>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_AppExtensionName(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::AppExtensions::IAppExtensionPackageUpdatingEventArgs>**)this;
            check_hresult(_winrt_abi_type->get_AppExtensionName(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_AppExtensions_IAppExtensionPackageUpdatingEventArgs<D>::Package() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::AppExtensions::IAppExtensionPackageUpdatingEventArgs>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::AppExtensions::IAppExtensionPackageUpdatingEventArgs, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::AppExtensions::IAppExtensionPackageUpdatingEventArgs>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Package(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::AppExtensions::IAppExtensionPackageUpdatingEventArgs>**)this;
            check_hresult(_winrt_abi_type->get_Package(&value));
        }
        return winrt::Windows::ApplicationModel::Package{ value, take_ownership_from_abi };
    }
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::ApplicationModel::AppExtensions::IAppExtension> : produce_base<D, winrt::Windows::ApplicationModel::AppExtensions::IAppExtension>
    {
        int32_t __stdcall get_Id(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().Id());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_DisplayName(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().DisplayName());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Description(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().Description());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Package(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::ApplicationModel::Package>(this->shim().Package());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_AppInfo(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::ApplicationModel::AppInfo>(this->shim().AppInfo());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall GetExtensionPropertiesAsync(void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Foundation::Collections::IPropertySet>>(this->shim().GetExtensionPropertiesAsync());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall GetPublicFolderAsync(void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Storage::StorageFolder>>(this->shim().GetPublicFolderAsync());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::ApplicationModel::AppExtensions::IAppExtension2> : produce_base<D, winrt::Windows::ApplicationModel::AppExtensions::IAppExtension2>
    {
        int32_t __stdcall get_AppUserModelId(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().AppUserModelId());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::ApplicationModel::AppExtensions::IAppExtension3> : produce_base<D, winrt::Windows::ApplicationModel::AppExtensions::IAppExtension3>
    {
        int32_t __stdcall GetExtensionProperties(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::Foundation::Collections::IPropertySet>(this->shim().GetExtensionProperties());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall GetPublicPath(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<hstring>(this->shim().GetPublicPath());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall GetPublicFolder(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::Storage::StorageFolder>(this->shim().GetPublicFolder());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::ApplicationModel::AppExtensions::IAppExtensionCatalog> : produce_base<D, winrt::Windows::ApplicationModel::AppExtensions::IAppExtensionCatalog>
    {
        int32_t __stdcall FindAllAsync(void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Foundation::Collections::IVectorView<winrt::Windows::ApplicationModel::AppExtensions::AppExtension>>>(this->shim().FindAllAsync());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall RequestRemovePackageAsync(void* packageFullName, void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncOperation<bool>>(this->shim().RequestRemovePackageAsync(*reinterpret_cast<hstring const*>(&packageFullName)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall add_PackageInstalled(void* handler, winrt::event_token* token) noexcept final try
        {
            zero_abi<winrt::event_token>(token);
            typename D::abi_guard guard(this->shim());
            *token = detach_from<winrt::event_token>(this->shim().PackageInstalled(*reinterpret_cast<winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::ApplicationModel::AppExtensions::AppExtensionCatalog, winrt::Windows::ApplicationModel::AppExtensions::AppExtensionPackageInstalledEventArgs> const*>(&handler)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall remove_PackageInstalled(winrt::event_token token) noexcept final
        {
            typename D::abi_guard guard(this->shim());
            this->shim().PackageInstalled(*reinterpret_cast<winrt::event_token const*>(&token));
            return 0;
        }
        int32_t __stdcall add_PackageUpdating(void* handler, winrt::event_token* token) noexcept final try
        {
            zero_abi<winrt::event_token>(token);
            typename D::abi_guard guard(this->shim());
            *token = detach_from<winrt::event_token>(this->shim().PackageUpdating(*reinterpret_cast<winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::ApplicationModel::AppExtensions::AppExtensionCatalog, winrt::Windows::ApplicationModel::AppExtensions::AppExtensionPackageUpdatingEventArgs> const*>(&handler)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall remove_PackageUpdating(winrt::event_token token) noexcept final
        {
            typename D::abi_guard guard(this->shim());
            this->shim().PackageUpdating(*reinterpret_cast<winrt::event_token const*>(&token));
            return 0;
        }
        int32_t __stdcall add_PackageUpdated(void* handler, winrt::event_token* token) noexcept final try
        {
            zero_abi<winrt::event_token>(token);
            typename D::abi_guard guard(this->shim());
            *token = detach_from<winrt::event_token>(this->shim().PackageUpdated(*reinterpret_cast<winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::ApplicationModel::AppExtensions::AppExtensionCatalog, winrt::Windows::ApplicationModel::AppExtensions::AppExtensionPackageUpdatedEventArgs> const*>(&handler)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall remove_PackageUpdated(winrt::event_token token) noexcept final
        {
            typename D::abi_guard guard(this->shim());
            this->shim().PackageUpdated(*reinterpret_cast<winrt::event_token const*>(&token));
            return 0;
        }
        int32_t __stdcall add_PackageUninstalling(void* handler, winrt::event_token* token) noexcept final try
        {
            zero_abi<winrt::event_token>(token);
            typename D::abi_guard guard(this->shim());
            *token = detach_from<winrt::event_token>(this->shim().PackageUninstalling(*reinterpret_cast<winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::ApplicationModel::AppExtensions::AppExtensionCatalog, winrt::Windows::ApplicationModel::AppExtensions::AppExtensionPackageUninstallingEventArgs> const*>(&handler)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall remove_PackageUninstalling(winrt::event_token token) noexcept final
        {
            typename D::abi_guard guard(this->shim());
            this->shim().PackageUninstalling(*reinterpret_cast<winrt::event_token const*>(&token));
            return 0;
        }
        int32_t __stdcall add_PackageStatusChanged(void* handler, winrt::event_token* token) noexcept final try
        {
            zero_abi<winrt::event_token>(token);
            typename D::abi_guard guard(this->shim());
            *token = detach_from<winrt::event_token>(this->shim().PackageStatusChanged(*reinterpret_cast<winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::ApplicationModel::AppExtensions::AppExtensionCatalog, winrt::Windows::ApplicationModel::AppExtensions::AppExtensionPackageStatusChangedEventArgs> const*>(&handler)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall remove_PackageStatusChanged(winrt::event_token token) noexcept final
        {
            typename D::abi_guard guard(this->shim());
            this->shim().PackageStatusChanged(*reinterpret_cast<winrt::event_token const*>(&token));
            return 0;
        }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::ApplicationModel::AppExtensions::IAppExtensionCatalog2> : produce_base<D, winrt::Windows::ApplicationModel::AppExtensions::IAppExtensionCatalog2>
    {
        int32_t __stdcall FindAll(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::Foundation::Collections::IVectorView<winrt::Windows::ApplicationModel::AppExtensions::AppExtension>>(this->shim().FindAll());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::ApplicationModel::AppExtensions::IAppExtensionCatalogStatics> : produce_base<D, winrt::Windows::ApplicationModel::AppExtensions::IAppExtensionCatalogStatics>
    {
        int32_t __stdcall Open(void* appExtensionName, void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::ApplicationModel::AppExtensions::AppExtensionCatalog>(this->shim().Open(*reinterpret_cast<hstring const*>(&appExtensionName)));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::ApplicationModel::AppExtensions::IAppExtensionPackageInstalledEventArgs> : produce_base<D, winrt::Windows::ApplicationModel::AppExtensions::IAppExtensionPackageInstalledEventArgs>
    {
        int32_t __stdcall get_AppExtensionName(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().AppExtensionName());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Package(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::ApplicationModel::Package>(this->shim().Package());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Extensions(void** values) noexcept final try
        {
            clear_abi(values);
            typename D::abi_guard guard(this->shim());
            *values = detach_from<winrt::Windows::Foundation::Collections::IVectorView<winrt::Windows::ApplicationModel::AppExtensions::AppExtension>>(this->shim().Extensions());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::ApplicationModel::AppExtensions::IAppExtensionPackageStatusChangedEventArgs> : produce_base<D, winrt::Windows::ApplicationModel::AppExtensions::IAppExtensionPackageStatusChangedEventArgs>
    {
        int32_t __stdcall get_AppExtensionName(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().AppExtensionName());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Package(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::ApplicationModel::Package>(this->shim().Package());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::ApplicationModel::AppExtensions::IAppExtensionPackageUninstallingEventArgs> : produce_base<D, winrt::Windows::ApplicationModel::AppExtensions::IAppExtensionPackageUninstallingEventArgs>
    {
        int32_t __stdcall get_AppExtensionName(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().AppExtensionName());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Package(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::ApplicationModel::Package>(this->shim().Package());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::ApplicationModel::AppExtensions::IAppExtensionPackageUpdatedEventArgs> : produce_base<D, winrt::Windows::ApplicationModel::AppExtensions::IAppExtensionPackageUpdatedEventArgs>
    {
        int32_t __stdcall get_AppExtensionName(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().AppExtensionName());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Package(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::ApplicationModel::Package>(this->shim().Package());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Extensions(void** values) noexcept final try
        {
            clear_abi(values);
            typename D::abi_guard guard(this->shim());
            *values = detach_from<winrt::Windows::Foundation::Collections::IVectorView<winrt::Windows::ApplicationModel::AppExtensions::AppExtension>>(this->shim().Extensions());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::ApplicationModel::AppExtensions::IAppExtensionPackageUpdatingEventArgs> : produce_base<D, winrt::Windows::ApplicationModel::AppExtensions::IAppExtensionPackageUpdatingEventArgs>
    {
        int32_t __stdcall get_AppExtensionName(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().AppExtensionName());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Package(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::ApplicationModel::Package>(this->shim().Package());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
}
WINRT_EXPORT namespace winrt::Windows::ApplicationModel::AppExtensions
{
    inline auto AppExtensionCatalog::Open(param::hstring const& appExtensionName)
    {
        return impl::call_factory<AppExtensionCatalog, IAppExtensionCatalogStatics>([&](IAppExtensionCatalogStatics const& f) { return f.Open(appExtensionName); });
    }
}
namespace std
{
#ifndef WINRT_LEAN_AND_MEAN
    template<> struct hash<winrt::Windows::ApplicationModel::AppExtensions::IAppExtension> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::AppExtensions::IAppExtension2> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::AppExtensions::IAppExtension3> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::AppExtensions::IAppExtensionCatalog> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::AppExtensions::IAppExtensionCatalog2> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::AppExtensions::IAppExtensionCatalogStatics> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::AppExtensions::IAppExtensionPackageInstalledEventArgs> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::AppExtensions::IAppExtensionPackageStatusChangedEventArgs> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::AppExtensions::IAppExtensionPackageUninstallingEventArgs> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::AppExtensions::IAppExtensionPackageUpdatedEventArgs> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::AppExtensions::IAppExtensionPackageUpdatingEventArgs> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::AppExtensions::AppExtension> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::AppExtensions::AppExtensionCatalog> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::AppExtensions::AppExtensionPackageInstalledEventArgs> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::AppExtensions::AppExtensionPackageStatusChangedEventArgs> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::AppExtensions::AppExtensionPackageUninstallingEventArgs> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::AppExtensions::AppExtensionPackageUpdatedEventArgs> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::AppExtensions::AppExtensionPackageUpdatingEventArgs> : winrt::impl::hash_base {};
#endif
#ifdef __cpp_lib_format
#endif
}
#endif
