from typing import Final, Literal
from typing_extensions import deprecated

MON: Final = 0
TUE: Final = 1
WED: Final = 2
THU: Final = 3
FRI: Final = 4
SAT: Final = 5
SUN: Final = 6
JAN: Final = 1
FEB: Final = 2
MAR: Final = 3
APR: Final = 4
MAY: Final = 5
JUN: Final = 6
JUL: Final = 7
AUG: Final = 8
SEP: Final = 9
OCT: Final = 10
NOV: Final = 11
DEC: Final = 12

def new_years(year: int, observed: bool | None = None) -> tuple[int, int, int]: ...
def martin_luther_king_day(year: int) -> tuple[int, int, int]: ...
def lincolns_birthday(year: int) -> tuple[int, int, int]: ...
def valentines_day(year: int) -> tuple[int, int, int]: ...
def washingtons_birthday(year: int, observed: bool | None = None) -> tuple[int, int, int]: ...
def presidents_day(year: int) -> tuple[int, int, int]: ...
def pulaski_day(year: int) -> tuple[int, int, int]: ...
def easter(year: int, church: Literal["western", "orthodox", "eastern"] | None = None) -> tuple[int, int, int]: ...
def may_day(year: int) -> tuple[int, int, int]: ...
def mothers_day(year: int) -> tuple[int, int, int]: ...
def memorial_day(year: int) -> tuple[int, int, int]: ...
def fathers_day(year: int) -> tuple[int, int, int]: ...
def juneteenth(year: int) -> tuple[int, int, int]: ...
def flag_day(year: int) -> tuple[int, int, int]: ...
def independence_day(year: int, observed: bool | None = None) -> tuple[int, int, int]: ...
def labor_day(year: int) -> tuple[int, int, int]: ...
def indigenous_peoples_day(year: int, country: str = "usa") -> tuple[int, int, int]: ...
@deprecated("The `columbus_day` function will be removed in a future release. Use `indigenous_peoples_day` instead.")
def columbus_day(year: int, country: str = "usa") -> tuple[int, int, int]: ...
def halloween(year: int) -> tuple[int, int, int]: ...
def election_day(year: int) -> tuple[int, int, int]: ...
def veterans_day(year: int, observed: bool | None = None) -> tuple[int, int, int]: ...
def rememberance_day(year: int) -> tuple[int, int, int]: ...
def armistice_day(year: int) -> tuple[int, int, int]: ...
def thanksgiving(year: int, country: Literal["usa", "canada"] = "usa") -> tuple[int, int, int]: ...
def christmas_eve(year: int) -> tuple[int, int, int]: ...
def christmas(year: int, observed: bool | None = None) -> tuple[int, int, int]: ...
def new_years_eve(year: int) -> tuple[int, int, int]: ...
def hanukkah(year: int, eve: bool | None = None) -> tuple[int, int, int]: ...
def purim(year: int, eve: bool | None = None) -> tuple[int, int, int]: ...
def rosh_hashanah(year: int, eve: bool | None = None) -> tuple[int, int, int]: ...
def yom_kippur(year: int, eve: bool | None = None) -> tuple[int, int, int]: ...
def passover(year: int, eve: bool | None = None) -> tuple[int, int, int]: ...
def shavuot(year: int, eve: bool | None = None) -> tuple[int, int, int]: ...
def sukkot(year: int, eve: bool | None = None) -> tuple[int, int, int]: ...
def shemini_azeret(year: int, eve: bool | None = None) -> tuple[int, int, int]: ...
def lag_baomer(year: int, eve: bool | None = None) -> tuple[int, int, int]: ...
def tu_beshvat(year: int, eve: bool | None = None) -> tuple[int, int, int]: ...
def tisha_bav(year: int, eve: bool | None = None) -> tuple[int, int, int]: ...
def dia_constitucion(year: int, observed: bool | None = True) -> tuple[int, int, int]: ...
def natalicio_benito_juarez(year: int, observed: bool | None = True) -> tuple[int, int, int]: ...
def dia_independencia(year: int) -> tuple[int, int, int]: ...
def dia_revolucion(year: int) -> tuple[int, int, int]: ...
def ramadan(year: int, eve: bool | None = None) -> tuple[int, int, int]: ...
def ashura(year: int, eve: bool | None = None) -> tuple[int, int, int]: ...
def eid_alfitr(year: int, eve: bool | None = None) -> tuple[int, int, int]: ...
def eid_aladha(year: int, eve: bool | None = None) -> tuple[int, int, int]: ...

class Holidays:
    year: int
    def __init__(self, year: int | None = None) -> None: ...
    def set_year(self, year: int) -> None: ...
    @property
    def christmas(self) -> tuple[int, int, int]: ...
    @property
    def christmas_eve(self) -> tuple[int, int, int]: ...
    @property
    def thanksgiving(self) -> tuple[int, int, int]: ...
    @property
    def new_years(self) -> tuple[int, int, int]: ...
    @property
    def new_years_eve(self) -> tuple[int, int, int]: ...
    @property
    def independence_day(self) -> tuple[int, int, int]: ...
    @property
    def flag_day(self) -> tuple[int, int, int]: ...
    @property
    def election_day(self) -> tuple[int, int, int]: ...
    @property
    def presidents_day(self) -> tuple[int, int, int]: ...
    @property
    def washingtons_birthday(self) -> tuple[int, int, int]: ...
    @property
    def lincolns_birthday(self) -> tuple[int, int, int]: ...
    @property
    def memorial_day(self) -> tuple[int, int, int]: ...
    @property
    def juneteenth(self) -> tuple[int, int, int]: ...
    @property
    def labor_day(self) -> tuple[int, int, int]: ...
    @property
    def indigenous_peoples_day(self) -> tuple[int, int, int]: ...
    @property
    def columbus_day(self) -> tuple[int, int, int]: ...
    @property
    def veterans_day(self) -> tuple[int, int, int]: ...
    @property
    def valentines_day(self) -> tuple[int, int, int]: ...
    @property
    def halloween(self) -> tuple[int, int, int]: ...
    @property
    def mothers_day(self) -> tuple[int, int, int]: ...
    @property
    def fathers_day(self) -> tuple[int, int, int]: ...
    @property
    def pulaski_day(self) -> tuple[int, int, int]: ...
    @property
    def easter(self) -> tuple[int, int, int]: ...
    @property
    def martin_luther_king_day(self) -> tuple[int, int, int]: ...
    @property
    def hanukkah(self) -> tuple[int, int, int]: ...
    @property
    def purim(self) -> tuple[int, int, int]: ...
    @property
    def rosh_hashanah(self) -> tuple[int, int, int]: ...
    @property
    def yom_kippur(self) -> tuple[int, int, int]: ...
    @property
    def passover(self) -> tuple[int, int, int]: ...
    @property
    def shavuot(self) -> tuple[int, int, int]: ...
    @property
    def sukkot(self) -> tuple[int, int, int]: ...
    @property
    def tu_beshvat(self) -> tuple[int, int, int]: ...
    @property
    def shemini_azeret(self) -> tuple[int, int, int]: ...
    @property
    def lag_baomer(self) -> tuple[int, int, int]: ...
    @property
    def tisha_bav(self) -> tuple[int, int, int]: ...
    @property
    def dia_constitucion(self) -> tuple[int, int, int]: ...
    @property
    def natalicio_benito_juarez(self) -> tuple[int, int, int]: ...
    @property
    def dia_independencia(self) -> tuple[int, int, int]: ...
    @property
    def dia_revolucion(self) -> tuple[int, int, int]: ...
    @property
    def ramadan(self) -> tuple[int, int, int]: ...
    @property
    def ashura(self) -> tuple[int, int, int]: ...
    @property
    def eid_alfitr(self) -> tuple[int, int, int]: ...
    @property
    def eid_aladha(self) -> tuple[int, int, int]: ...
