%feature("docstring") OT::LaguerreFactory
"Laguerre specific orthonormal univariate polynomial family.

For the :class:`~openturns.Gamma` distribution.

Parameters
----------
k : float
    If `parameters_set == ot.JacobiFactory.PROBABILITY`: default shape
    parameter :math:`k > 0` of the :class:`~openturns.Gamma` distribution.

    If `parameters_set == ot.JacobiFactory.ANALYSIS`: alternative shape
    parameter :math:`k_a = k - 1 > -1` of the :class:`~openturns.Gamma`
    distribution.
parameters_set : int, optional
    Integer telling which parameters set is used for defining the distribution
    (amongst `ot.LaguerreFactory.ANALYSIS, ot.LaguerreFactory.PROBABILITY`).

Notes
-----
Any sequence of orthogonal polynomials has a recurrence formula relating any
three consecutive polynomials as follows:

.. math::

    P_{i + 1} = (a_i x + b_i) P_i + c_i P_{i - 1}, \\quad 1 < i

The recurrence coefficients for the Laguerre polynomials come analytically and
read:

.. math::

    \\begin{array}{rcl}
        a_i & = & \\omega_i \\\\
        b_i & = & - (2 i + k_a + 1) \\omega_i \\\\
        c_i & = & - \\sqrt{(i + k_a) i} \\omega_i
    \\end{array}, \\quad 1 < i

where :math:`k_a` is the alternative shape parameter of the
:class:`~openturns.Gamma` distribution, and:

.. math::

    \\omega_i = \\frac{1}{\\sqrt{(i + 1) (i + k_a + 1)}} , \\quad 1 < i

See also
--------
StandardDistributionPolynomialFactory

Examples
--------
>>> import openturns as ot
>>> polynomial_factory = ot.LaguerreFactory()
>>> for i in range(3):
...     print(polynomial_factory.build(i))
1
-1 + X
1 - 2 * X + 0.5 * X^2"

// ---------------------------------------------------------------------

%feature("docstring") OT::LaguerreFactory::getK
"Accessor to the alternative shape parameter :math:`k_a`.

Of the :class:`~openturns.Gamma` distribution.

Returns
-------
k_a : float
    Alternative shape parameter :math:`k_a = k - 1` of the
    :class:`~openturns.Gamma` distribution."
