/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.change;

import java.util.ArrayList;
import java.util.Set;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.change.AbstractCompositeOntologyChange;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.util.CollectionFactory;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;

public class MakeClassesMutuallyDisjoint
extends AbstractCompositeOntologyChange {
    private static final long serialVersionUID = 40000L;

    public MakeClassesMutuallyDisjoint(@Nonnull OWLDataFactory dataFactory, @Nonnull Set<? extends OWLClassExpression> classExpressions, boolean usePairwiseDisjointAxioms, @Nonnull OWLOntology targetOntology) {
        super(dataFactory);
        this.generateChanges(OWLAPIPreconditions.checkNotNull(classExpressions, "classExpressions cannot be null"), usePairwiseDisjointAxioms, OWLAPIPreconditions.checkNotNull(targetOntology, "targetOntology cannot be null"));
    }

    private void generateChanges(@Nonnull Set<? extends OWLClassExpression> classExpressions, boolean usePairwiseDisjointAxioms, @Nonnull OWLOntology targetOntology) {
        if (usePairwiseDisjointAxioms) {
            ArrayList<? extends OWLClassExpression> descList = new ArrayList<OWLClassExpression>(classExpressions);
            for (int i = 0; i < descList.size(); ++i) {
                for (int j = i + 1; j < descList.size(); ++j) {
                    this.addChange(new AddAxiom(targetOntology, this.getDataFactory().getOWLDisjointClassesAxiom(CollectionFactory.createSet(new OWLClassExpression[]{(OWLClassExpression)descList.get(i), (OWLClassExpression)descList.get(j)}))));
                }
            }
        } else {
            this.addChange(new AddAxiom(targetOntology, this.getDataFactory().getOWLDisjointClassesAxiom(classExpressions)));
        }
    }
}

