/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.eclipse.sisu.launch;

import org.jetbrains.kotlin.com.google.inject.Guice;
import org.jetbrains.kotlin.com.google.inject.Injector;
import org.jetbrains.kotlin.com.google.inject.Module;
import org.jetbrains.kotlin.org.eclipse.sisu.inject.BindingPublisher;
import org.jetbrains.kotlin.org.eclipse.sisu.inject.InjectorBindings;
import org.jetbrains.kotlin.org.eclipse.sisu.inject.MutableBeanLocator;
import org.jetbrains.kotlin.org.eclipse.sisu.launch.BundleModule;
import org.jetbrains.kotlin.org.eclipse.sisu.launch.BundlePlan;
import org.osgi.framework.Bundle;

public class SisuBundlePlan
implements BundlePlan {
    protected final MutableBeanLocator locator;

    public SisuBundlePlan(MutableBeanLocator locator) {
        this.locator = locator;
    }

    @Override
    public BindingPublisher prepare(Bundle bundle) {
        return this.appliesTo(bundle) ? new InjectorBindings(this.inject(this.compose(bundle))) : null;
    }

    protected boolean appliesTo(Bundle bundle) {
        if (bundle.getHeaders().get("Bundle-Blueprint") != null) {
            return false;
        }
        String imports = (String)bundle.getHeaders().get("Import-Package");
        return imports != null && (imports.contains("javax.inject") || imports.contains("org.jetbrains.kotlin.com.google.inject"));
    }

    protected Injector inject(Module module) {
        return Guice.createInjector(module);
    }

    protected Module compose(Bundle bundle) {
        return new BundleModule(bundle, this.locator);
    }
}

