/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.operands;

import java.util.List;
import org.jruby.Ruby;
import org.jruby.RubyLocalJumpError;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.OperandType;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.persistence.IRReaderDecoder;
import org.jruby.ir.persistence.IRWriterEncoder;
import org.jruby.ir.transformations.inlining.CloneInfo;
import org.jruby.runtime.Helpers;

public class IRException
extends Operand {
    private final RubyLocalJumpError.Reason type;
    public static final IRException RETRY_LocalJumpError = new IRException(RubyLocalJumpError.Reason.RETRY);
    public static final IRException NEXT_LocalJumpError = new IRException(RubyLocalJumpError.Reason.NEXT);
    public static final IRException BREAK_LocalJumpError = new IRException(RubyLocalJumpError.Reason.BREAK);
    public static final IRException RETURN_LocalJumpError = new IRException(RubyLocalJumpError.Reason.RETURN);
    public static final IRException REDO_LocalJumpError = new IRException(RubyLocalJumpError.Reason.REDO);

    protected IRException(RubyLocalJumpError.Reason type2) {
        this.type = type2;
    }

    @Override
    public OperandType getOperandType() {
        return OperandType.IR_EXCEPTION;
    }

    public RubyLocalJumpError.Reason getType() {
        return this.type;
    }

    public static IRException getExceptionFromOrdinal(int ordinal2) {
        if (ordinal2 < 0 || ordinal2 > RubyLocalJumpError.Reason.values().length) {
            throw new IllegalArgumentException("Invalid ordinal value for jump error: " + ordinal2);
        }
        switch (RubyLocalJumpError.Reason.values()[ordinal2]) {
            case RETRY: {
                return RETRY_LocalJumpError;
            }
            case NEXT: {
                return NEXT_LocalJumpError;
            }
            case BREAK: {
                return BREAK_LocalJumpError;
            }
            case RETURN: {
                return RETURN_LocalJumpError;
            }
            case REDO: {
                return REDO_LocalJumpError;
            }
        }
        return null;
    }

    @Override
    public void addUsedVariables(List<Variable> l) {
    }

    @Override
    public Operand cloneForInlining(CloneInfo ii) {
        return this;
    }

    @Override
    public boolean canCopyPropagate() {
        return true;
    }

    public RuntimeException getException(Ruby runtime2) {
        switch (this.getType()) {
            case NEXT: {
                return runtime2.newLocalJumpError(this.getType(), null, "unexpected next");
            }
            case BREAK: {
                return Helpers.newLocalJumpErrorForBreak(runtime2, null);
            }
            case RETURN: {
                return runtime2.newLocalJumpError(this.getType(), null, "unexpected return");
            }
            case REDO: {
                return runtime2.newLocalJumpError(this.getType(), null, "unexpected redo");
            }
            case RETRY: {
                return runtime2.newLocalJumpError(this.getType(), null, "retry outside of rescue not supported");
            }
        }
        throw new RuntimeException("Unhandled case in operands/IRException.java");
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.IRException(this);
    }

    @Override
    public void encode(IRWriterEncoder e) {
        super.encode(e);
        e.encode((byte)this.getType().ordinal());
    }

    public static IRException decode(IRReaderDecoder d) {
        return IRException.getExceptionFromOrdinal(d.decodeByte());
    }

    public String toString() {
        return "LocalJumpError:" + String.valueOf((Object)this.getType());
    }
}

