\name{BSplineTransformInitializerFilter}
\alias{BSplineTransformInitializerFilter}
\title{BSplineTransformInitializerFilter}
\Rdversion{1.1}
\docType{class}
\description{
BSplineTransformInitializerFilter is a helper class intended to initialize the control point grid such
that it has a physically consistent definition. It sets the transform
domain origin, physical dimensions and direction from information
obtained from the image. It also sets the mesh size if asked to do so
by calling SetTransformDomainMeshSize()before calling InitializeTransform().
BSplineTransformInitializerFilter}
\details{
Luis Ibanez Nick Tustison
See:
BSplineTransformInitializer for the procedural interface
itk::BSplineTransformInitializer for the Doxygen on the original ITK class.
BSplineTransformInitializerFilter}
%C++ includes: sitkBSplineTransformInitializerFilter.h
\section{Methods}{
\describe{
\item{ BSplineTransformInitializerFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{BSplineTransform Execute(const Image &image1):}{
Execute the filter on the input image
}
\item{std::string GetName() const override:}{
Name of this class
}
\item{unsigned int GetOrder() const:}{}
\item{std::vector< uint32_t > GetTransformDomainMeshSize() const:}{}
\item{Self SetOrder(unsigned int order):}{
The order of the bspline in the output BSplineTransform. This value effects the number of control points.
}
\item{Self SetTransformDomainMeshSize(const std::vector< uint32_t > &TransformDomainMeshSize):}{
Allow the user to set the mesh size of the transform via the
initializer even though the initializer does not do anything with that
information. Default = 1^ImageDimension.
}
\item{std::string ToString() const override:}{
Print ourselves out
}
\item{ ~BSplineTransformInitializerFilter() override:}{
Destructor
}
}
}
