/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.decompiler.languages.java.ast;

import com.strobel.assembler.metadata.Flags;
import com.strobel.decompiler.languages.java.ast.AstNodeCollection;
import com.strobel.decompiler.languages.java.ast.AstType;
import com.strobel.decompiler.languages.java.ast.EntityDeclaration;
import com.strobel.decompiler.languages.java.ast.Expression;
import com.strobel.decompiler.languages.java.ast.IAstVisitor;
import com.strobel.decompiler.languages.java.ast.Identifier;
import com.strobel.decompiler.languages.java.ast.JavaModifierToken;
import com.strobel.decompiler.languages.java.ast.JavaTokenNode;
import com.strobel.decompiler.languages.java.ast.PatternExpression;
import com.strobel.decompiler.languages.java.ast.Roles;
import com.strobel.decompiler.languages.java.ast.TokenRole;
import com.strobel.decompiler.patterns.INode;
import com.strobel.decompiler.patterns.Match;
import com.strobel.decompiler.patterns.Role;
import java.util.List;

public class InstanceOfExpression
extends PatternExpression {
    public static final Role<JavaModifierToken> MODIFIER_ROLE = EntityDeclaration.MODIFIER_ROLE;
    public static final TokenRole INSTANCE_OF_KEYWORD_ROLE = new TokenRole("instanceof", 3);
    private boolean _anyModifiers;

    public InstanceOfExpression(Expression expression, AstType type) {
        this(-34, expression, type);
    }

    public InstanceOfExpression(int offset, Expression expression, AstType type) {
        super(offset);
        this.setExpression(expression);
        this.setType(type);
    }

    public final AstType getType() {
        return this.getChildByRole(Roles.TYPE);
    }

    public final void setType(AstType type) {
        this.setChildByRole(Roles.TYPE, type);
    }

    public final JavaTokenNode getInstanceOfToken() {
        return this.getChildByRole(INSTANCE_OF_KEYWORD_ROLE);
    }

    public final Expression getExpression() {
        return this.getChildByRole(Roles.EXPRESSION);
    }

    public final void setExpression(Expression value) {
        this.setChildByRole(Roles.EXPRESSION, value);
    }

    public final Identifier getIdentifier() {
        return this.getChildByRole(Roles.IDENTIFIER);
    }

    public final void setIdentifier(Identifier value) {
        this.setChildByRole(Roles.IDENTIFIER, value);
    }

    public final boolean isAnyModifiers() {
        return this._anyModifiers;
    }

    public final void setAnyModifiers(boolean value) {
        this.verifyNotFrozen();
        this._anyModifiers = value;
    }

    public final AstNodeCollection<JavaModifierToken> getModifiers() {
        return this.getChildrenByRole(MODIFIER_ROLE);
    }

    public final void addModifier(Flags.Flag modifier) {
        EntityDeclaration.addModifier(this, modifier);
    }

    public final void removeModifier(Flags.Flag modifier) {
        EntityDeclaration.removeModifier(this, modifier);
    }

    public final void setModifiers(List<Flags.Flag> modifiers) {
        EntityDeclaration.setModifiers(this, modifiers);
    }

    @Override
    public <T, R> R acceptVisitor(IAstVisitor<? super T, ? extends R> visitor, T data) {
        return visitor.visitInstanceOfExpression(this, data);
    }

    @Override
    public boolean matches(INode other, Match match) {
        if (other instanceof InstanceOfExpression) {
            InstanceOfExpression otherExpression = (InstanceOfExpression)other;
            return !otherExpression.isNull() && this.getExpression().matches(otherExpression.getExpression(), match) && this.getType().matches(otherExpression.getType(), match) && (this.getIdentifier().isNull() && otherExpression.getIdentifier().isNull() || this.getIdentifier().matches(otherExpression.getIdentifier())) && (this.isAnyModifiers() || otherExpression.isAnyModifiers() || this.getChildrenByRole(MODIFIER_ROLE).matches(otherExpression.getChildrenByRole(MODIFIER_ROLE), match));
        }
        return false;
    }
}

