/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.mapper.dto;

import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.index.mapper.MapperParsingException;
import org.opensearch.neuralsearch.processor.chunker.ChunkerFactory;
import org.opensearch.neuralsearch.processor.chunker.ChunkerValidatorFactory;
import org.opensearch.neuralsearch.processor.chunker.Validator;

public class ChunkingConfig {
    public static final String ALGORITHM_FIELD = "algorithm";
    public static final String PARAMETERS_FIELD = "parameters";
    private List<Map<String, Object>> configs;
    private boolean enabled;

    public ChunkingConfig(@NonNull String name, Object value, @NonNull ChunkerValidatorFactory chunkerValidatorFactory) {
        List configList;
        Objects.requireNonNull(name, "name is marked non-null but is null");
        Objects.requireNonNull(chunkerValidatorFactory, "chunkerValidatorFactory is marked non-null but is null");
        if (value instanceof Boolean) {
            this.enabled = (Boolean)value;
            return;
        }
        if (value instanceof List && (configList = (List)value).stream().allMatch(item -> item instanceof Map)) {
            List parsedConfigs = configList.stream().map(item -> {
                this.validate((Map)item, chunkerValidatorFactory);
                return (Map)item;
            }).collect(Collectors.toList());
            this.enabled = true;
            this.configs = parsedConfigs;
            return;
        }
        throw new MapperParsingException(String.format(Locale.ROOT, "[%s] must be either a List of Maps or a Boolean", name));
    }

    public ChunkingConfig(@NonNull Map<String, Object> fieldConfig) {
        Objects.requireNonNull(fieldConfig, "fieldConfig is marked non-null but is null");
        if (!fieldConfig.containsKey("chunking")) {
            return;
        }
        Object chunkingConfig = fieldConfig.get("chunking");
        if (chunkingConfig instanceof Boolean) {
            this.enabled = (Boolean)chunkingConfig;
            return;
        }
        if (chunkingConfig instanceof List) {
            List configList;
            this.configs = configList = (List)chunkingConfig;
            this.enabled = true;
            return;
        }
        throw new IllegalStateException(String.format(Locale.ROOT, "Invalid %s in the semantic field config. It is neither a Boolean nor a List of Maps.", "chunking"));
    }

    private void validate(@NonNull Map<String, Object> item, @NonNull ChunkerValidatorFactory chunkerValidatorFactory) {
        Objects.requireNonNull(item, "item is marked non-null but is null");
        Objects.requireNonNull(chunkerValidatorFactory, "chunkerValidatorFactory is marked non-null but is null");
        this.validateUnsupportedParameters(item);
        String algorithm = this.readAlgorithm(item);
        if (item.get(PARAMETERS_FIELD) instanceof Map) {
            Validator validator = chunkerValidatorFactory.getValidator(algorithm);
            if (validator == null) {
                throw new MapperParsingException(String.format(Locale.ROOT, "[%s] is not a valid chunking algorithm. A valid algorithm should be %s.", algorithm, ChunkerFactory.CHUNKER_ALGORITHMS));
            }
            validator.validate((Map)item.get(PARAMETERS_FIELD));
        } else if (item.get(PARAMETERS_FIELD) != null) {
            throw new MapperParsingException(String.format(Locale.ROOT, "%s in %s should be a Map.", PARAMETERS_FIELD, "chunking"));
        }
    }

    private void validateUnsupportedParameters(@NonNull Map<String, Object> item) {
        Objects.requireNonNull(item, "item is marked non-null but is null");
        HashSet<String> keys = new HashSet<String>(item.keySet());
        keys.remove(ALGORITHM_FIELD);
        keys.remove(PARAMETERS_FIELD);
        if (!keys.isEmpty()) {
            throw new MapperParsingException(String.format(Locale.ROOT, "[%s] does not support parameters [%s]", "chunking", keys));
        }
    }

    private String readAlgorithm(Map<String, Object> config) {
        if (config.containsKey(ALGORITHM_FIELD)) {
            String algorithm;
            Object object = config.get(ALGORITHM_FIELD);
            if (object instanceof String && ChunkerFactory.CHUNKER_ALGORITHMS.contains(algorithm = (String)object)) {
                return algorithm;
            }
            throw new MapperParsingException(String.format(Locale.ROOT, "[%s] must be %s", ALGORITHM_FIELD, ChunkerFactory.CHUNKER_ALGORITHMS));
        }
        throw new MapperParsingException(String.format(Locale.ROOT, "[%s] is required to configure the chunking strategy.", ALGORITHM_FIELD));
    }

    public void toXContent(@NonNull XContentBuilder builder, String name) throws IOException {
        Objects.requireNonNull(builder, "builder is marked non-null but is null");
        if (this.configs == null) {
            builder.field(name, this.enabled);
        } else {
            builder.startArray(name);
            for (Map<String, Object> config : this.configs) {
                builder.map(config);
            }
            builder.endArray();
        }
    }

    public String toString() {
        if (this.configs == null) {
            return String.valueOf(this.enabled);
        }
        return this.configs.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ChunkingConfig other = (ChunkingConfig)obj;
        return new EqualsBuilder().append(this.enabled, other.enabled).append(this.configs, other.configs).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.enabled).append(this.configs).toHashCode();
    }

    @Generated
    public static ChunkingConfigBuilder builder() {
        return new ChunkingConfigBuilder();
    }

    @Generated
    public ChunkingConfig(List<Map<String, Object>> configs, boolean enabled) {
        this.configs = configs;
        this.enabled = enabled;
    }

    @Generated
    public List<Map<String, Object>> getConfigs() {
        return this.configs;
    }

    @Generated
    public boolean isEnabled() {
        return this.enabled;
    }

    @Generated
    public static class ChunkingConfigBuilder {
        @Generated
        private List<Map<String, Object>> configs;
        @Generated
        private boolean enabled;

        @Generated
        ChunkingConfigBuilder() {
        }

        @Generated
        public ChunkingConfigBuilder configs(List<Map<String, Object>> configs) {
            this.configs = configs;
            return this;
        }

        @Generated
        public ChunkingConfigBuilder enabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        @Generated
        public ChunkingConfig build() {
            return new ChunkingConfig(this.configs, this.enabled);
        }

        @Generated
        public String toString() {
            return "ChunkingConfig.ChunkingConfigBuilder(configs=" + String.valueOf(this.configs) + ", enabled=" + this.enabled + ")";
        }
    }
}

