/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ja;

import org.apache.lucene.analysis.ja.dict.JaMorphData;
import org.apache.lucene.analysis.morph.TokenType;

public class Token
extends org.apache.lucene.analysis.morph.Token {
    private final JaMorphData morphData;
    private final int morphId;

    public Token(char[] surfaceForm, int offset, int length, int startOffset, int endOffset, int morphId, TokenType type, JaMorphData morphData) {
        super(surfaceForm, offset, length, startOffset, endOffset, type);
        this.morphId = morphId;
        this.morphData = morphData;
    }

    public String toString() {
        return "Token(\"" + new String(this.surfaceForm, this.offset, this.length) + "\" offset=" + this.startOffset + " length=" + this.length + " posLen=" + this.posLen + " type=" + String.valueOf(this.type) + " morphId=" + this.morphId + " leftID=" + this.morphData.getLeftId(this.morphId) + ")";
    }

    public String getReading() {
        return this.morphData.getReading(this.morphId, this.surfaceForm, this.offset, this.length);
    }

    public String getPronunciation() {
        return this.morphData.getPronunciation(this.morphId, this.surfaceForm, this.offset, this.length);
    }

    public String getPartOfSpeech() {
        return this.morphData.getPartOfSpeech(this.morphId);
    }

    public String getInflectionType() {
        return this.morphData.getInflectionType(this.morphId);
    }

    public String getInflectionForm() {
        return this.morphData.getInflectionForm(this.morphId);
    }

    public String getBaseForm() {
        return this.morphData.getBaseForm(this.morphId, this.surfaceForm, this.offset, this.length);
    }

    public boolean isKnown() {
        return this.type == TokenType.KNOWN;
    }

    public boolean isUnknown() {
        return this.type == TokenType.UNKNOWN;
    }

    public boolean isUser() {
        return this.type == TokenType.USER;
    }
}

