/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.pki.internal.cert;

import java.io.ByteArrayInputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.security.cert.CRLReason;
import java.util.ArrayList;
import oracle.security.pki.internal.asn1.ASN1BitString;
import oracle.security.pki.internal.asn1.ASN1ConstructedInputStream;
import oracle.security.pki.internal.asn1.ASN1FormatException;
import oracle.security.pki.internal.asn1.ASN1GenericConstructed;
import oracle.security.pki.internal.asn1.ASN1GenericPrimitive;
import oracle.security.pki.internal.asn1.ASN1Object;
import oracle.security.pki.internal.asn1.ASN1Sequence;
import oracle.security.pki.internal.asn1.ASN1SequenceInputStream;
import oracle.security.pki.internal.cert.CRLDistPointName;
import oracle.security.pki.internal.cert.GeneralName;
import oracle.security.pki.util.Utils;

public class CRLDistPoint
implements Externalizable,
ASN1Object {
    private CRLDistPointName b = null;
    private boolean[] c;
    private int d;
    private ArrayList<GeneralName> e = null;
    int a;
    private transient ASN1Object f = null;

    public CRLDistPoint() {
    }

    public CRLDistPoint(CRLDistPointName cRLDistPointName) {
        this.b = cRLDistPointName;
    }

    public CRLDistPoint(GeneralName generalName) {
        this.e = new ArrayList();
        this.e.add(generalName);
    }

    public CRLDistPoint(InputStream inputStream) throws IOException {
        this.input(inputStream);
    }

    public void a(CRLDistPointName cRLDistPointName) {
        this.b = cRLDistPointName;
        this.e();
    }

    public CRLDistPointName a() {
        return this.b;
    }

    public boolean a(CRLReason cRLReason) {
        int n = this.a;
        return this.c != null && n < this.c.length ? this.c[n] : false;
    }

    public void b(CRLReason cRLReason) {
        this.d(cRLReason);
        this.e();
    }

    public void a(CRLReason[] cRLReasonArray) {
        int n = cRLReasonArray.length;
        for (int i = 0; i < n; ++i) {
            this.d(cRLReasonArray[i]);
        }
        this.e();
    }

    public void c(CRLReason cRLReason) {
        int n = this.a;
        if (this.c != null && n < this.c.length) {
            this.c[n] = false;
        }
        this.e();
    }

    public void b() {
        if (this.c != null) {
            int n = this.c.length;
            for (int i = 0; i < n; ++i) {
                this.c[i] = false;
            }
            this.e();
        }
    }

    private void d(CRLReason cRLReason) {
        if (this.c == null || this.c.length < CRLReason.values().length) {
            boolean[] blArray = new boolean[CRLReason.values().length];
            if (this.c != null) {
                System.arraycopy(this.c, 0, blArray, 0, this.c.length);
            }
            this.c = blArray;
        }
        this.c[this.a] = true;
        ++this.d;
    }

    public void a(GeneralName generalName) {
        if (this.e == null) {
            this.e = new ArrayList();
        }
        this.e.add(generalName);
        this.e();
    }

    public ArrayList<GeneralName> c() {
        return this.e;
    }

    @Override
    public void input(InputStream inputStream) throws IOException {
        Object object;
        this.e();
        ASN1SequenceInputStream aSN1SequenceInputStream = new ASN1SequenceInputStream(inputStream);
        if (aSN1SequenceInputStream.a() && aSN1SequenceInputStream.d() == 0) {
            object = new ASN1ConstructedInputStream((InputStream)aSN1SequenceInputStream, 0);
            this.b = new CRLDistPointName((InputStream)object);
            ((ASN1ConstructedInputStream)object).b();
        } else {
            this.b = null;
        }
        if (aSN1SequenceInputStream.a() && aSN1SequenceInputStream.d() == 1) {
            int n;
            aSN1SequenceInputStream.a(3);
            object = new ASN1BitString(aSN1SequenceInputStream);
            this.c = new boolean[((ASN1BitString)object).e()];
            try {
                for (n = 0; n < this.c.length; ++n) {
                    this.c[n] = ((ASN1BitString)object).a(n);
                    ++this.d;
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new ASN1FormatException("Unknown reasons flag: " + n);
            }
        } else {
            this.c = null;
            this.d = 0;
        }
        if (aSN1SequenceInputStream.a() && aSN1SequenceInputStream.d() == 2) {
            aSN1SequenceInputStream.a(16);
            this.e = new ArrayList();
            object = new ASN1SequenceInputStream(aSN1SequenceInputStream);
            while (((ASN1ConstructedInputStream)object).a()) {
                this.e.add(new GeneralName((InputStream)object));
            }
            ((ASN1ConstructedInputStream)object).b();
        } else {
            this.e = null;
        }
        aSN1SequenceInputStream.b();
        if (this.b == null && this.c == null && this.e == null) {
            throw new ASN1FormatException("Empty DRLDistPoint input");
        }
    }

    private ASN1Object d() {
        if (this.f == null) {
            if (this.b == null && this.c == null && this.e == null) {
                throw new IllegalStateException("Invalid CRLDistPoint, all fields missing");
            }
            ASN1Sequence aSN1Sequence = new ASN1Sequence();
            if (this.b != null) {
                aSN1Sequence.a(new ASN1GenericConstructed(this.b, 0));
            }
            if (this.c != null && this.d > 0) {
                ASN1BitString aSN1BitString = new ASN1BitString(this.c.length);
                for (int i = 0; i < this.c.length; ++i) {
                    if (!this.c[i]) continue;
                    aSN1BitString.b(i);
                }
                aSN1Sequence.a(new ASN1GenericPrimitive(aSN1BitString, 1));
            }
            if (this.e != null) {
                aSN1Sequence.a(new ASN1GenericConstructed(this.e, 2));
            }
            this.f = aSN1Sequence;
        }
        return this.f;
    }

    @Override
    public void output(OutputStream outputStream) throws IOException {
        this.d().output(outputStream);
    }

    @Override
    public int length() {
        return this.d().length();
    }

    private void e() {
        this.f = null;
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(Utils.toBytes(this));
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        byte[] byArray;
        try {
            byArray = (byte[])objectInput.readObject();
        }
        catch (ClassCastException classCastException) {
            throw new IOException(classCastException);
        }
        this.input(new ByteArrayInputStream(byArray));
    }
}

