/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.wizard;

import com.ejt.internal.gui.LookAndFeelChangeUtil;
import com.ejt.internal.gui.ScreenSizeUtil;
import com.install4j.api.UiUtil;
import com.install4j.runtime.installer.frontend.GUIHelper;
import java.awt.Color;
import java.awt.GraphicsDevice;
import java.awt.Rectangle;
import javax.swing.JFrame;
import javax.swing.UIManager;

public abstract class CustomFrame
extends JFrame {
    public CustomFrame() {
        UiUtil.getLookAndFeelEnhancer().prepareWindow(this);
        LookAndFeelChangeUtil.registerWindow(this);
        LookAndFeelChangeUtil.onLookAndFeelChangeAndNow(this, CustomFrame::updateTitleBar);
    }

    private void updateTitleBar() {
        this.getRootPane().putClientProperty("JRootPane.titleBarBackground", this.getTitlePaneBackgroundColor());
    }

    protected Color getTitlePaneBackgroundColor() {
        return UIManager.getColor("Panel.background");
    }

    protected abstract int getFrameHeight();

    protected abstract int getFrameWidth();

    protected Rectangle getNewFrameBounds() {
        int frameWidth = this.getFrameWidth();
        int frameHeight = this.getFrameHeight();
        if (frameWidth == -1) {
            frameWidth = this.getWidth();
        }
        if (frameHeight == -1) {
            frameHeight = this.getHeight();
        }
        return this.getNewFrameBounds(frameWidth, frameHeight);
    }

    protected Rectangle getNewFrameBounds(int frameWidth, int frameHeight) {
        GraphicsDevice screenDevice = ScreenSizeUtil.getScreenDevice();
        Rectangle screenBounds = screenDevice.getDefaultConfiguration().getBounds();
        int newX = screenBounds.x + (screenBounds.width - frameWidth) / 2;
        int newY = screenBounds.y + (screenBounds.height - frameHeight) / 2;
        return new Rectangle(newX, newY, frameWidth, frameHeight);
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            GUIHelper.applyComponentOrientation(this);
        }
        super.setVisible(visible);
    }
}

