/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.collection.trie.datrie;

import com.hankcs.hanlp.collection.trie.datrie.MutableDoubleArrayTrieInteger;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;

public class MutableDoubleArrayTrie<V>
implements SortedMap<String, V>,
Iterable<Map.Entry<String, V>> {
    MutableDoubleArrayTrieInteger trie = new MutableDoubleArrayTrieInteger();
    ArrayList<V> values = new ArrayList();

    public MutableDoubleArrayTrie() {
    }

    public MutableDoubleArrayTrie(Map<String, V> map) {
        this();
        this.putAll(map);
    }

    public void loseWeight() {
        this.trie.loseWeight();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("MutableDoubleArrayTrie{");
        sb.append("size=").append(this.size()).append(',');
        sb.append("allocated=").append(this.trie.getBaseArraySize()).append(',');
        sb.append('}');
        return sb.toString();
    }

    @Override
    public Comparator<? super String> comparator() {
        return new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareTo(o2);
            }
        };
    }

    @Override
    public SortedMap<String, V> subMap(String fromKey, String toKey) {
        throw new UnsupportedOperationException();
    }

    @Override
    public SortedMap<String, V> headMap(String toKey) {
        throw new UnsupportedOperationException();
    }

    @Override
    public SortedMap<String, V> tailMap(String fromKey) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String firstKey() {
        return this.trie.iterator().key();
    }

    @Override
    public String lastKey() {
        MutableDoubleArrayTrieInteger.KeyValuePair iterator = this.trie.iterator();
        while (iterator.hasNext()) {
            iterator.next();
        }
        return iterator.key();
    }

    @Override
    public int size() {
        return this.trie.size();
    }

    @Override
    public boolean isEmpty() {
        return this.trie.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        if (key == null || !(key instanceof String)) {
            return false;
        }
        return this.trie.containsKey((String)key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.values.contains(value);
    }

    @Override
    public V get(Object key) {
        if (key == null) {
            return null;
        }
        int id = key instanceof String ? this.trie.get((String)key) : this.trie.get(key.toString());
        if (id == -1) {
            return null;
        }
        return this.values.get(id);
    }

    @Override
    public V put(String key, V value) {
        int id = this.trie.get(key);
        if (id == -1) {
            this.trie.set(key, this.values.size());
            this.values.add(value);
            return null;
        }
        V v = this.values.get(id);
        this.values.set(id, value);
        return v;
    }

    @Override
    public V remove(Object key) {
        if (key == null) {
            return null;
        }
        int id = this.trie.remove(key instanceof String ? (String)key : key.toString());
        if (id == -1) {
            return null;
        }
        this.trie.decreaseValues(id);
        return this.values.remove(id);
    }

    @Override
    public void putAll(Map<? extends String, ? extends V> m) {
        for (Map.Entry<String, V> entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        this.trie.clear();
        this.values.clear();
    }

    @Override
    public Set<String> keySet() {
        return new Set<String>(){
            MutableDoubleArrayTrieInteger.KeyValuePair iterator;
            {
                this.iterator = MutableDoubleArrayTrie.this.trie.iterator();
            }

            @Override
            public int size() {
                return MutableDoubleArrayTrie.this.trie.size();
            }

            @Override
            public boolean isEmpty() {
                return MutableDoubleArrayTrie.this.trie.isEmpty();
            }

            @Override
            public boolean contains(Object o) {
                throw new UnsupportedOperationException();
            }

            @Override
            public Iterator<String> iterator() {
                return new Iterator<String>(){

                    @Override
                    public boolean hasNext() {
                        return iterator.hasNext();
                    }

                    @Override
                    public String next() {
                        return iterator.next().key();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            @Override
            public Object[] toArray() {
                return MutableDoubleArrayTrie.this.values.toArray();
            }

            @Override
            public <T> T[] toArray(T[] a) {
                return MutableDoubleArrayTrie.this.values.toArray(a);
            }

            @Override
            public boolean add(String s) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean remove(Object o) {
                return MutableDoubleArrayTrie.this.trie.remove((String)o) != -1;
            }

            @Override
            public boolean containsAll(Collection<?> c) {
                for (Object o : c) {
                    if (MutableDoubleArrayTrie.this.trie.containsKey((String)o)) continue;
                    return false;
                }
                return true;
            }

            @Override
            public boolean addAll(Collection<? extends String> c) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean retainAll(Collection<?> c) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean removeAll(Collection<?> c) {
                boolean changed = false;
                for (Object o : c) {
                    if (changed) continue;
                    changed = MutableDoubleArrayTrie.this.remove(o) != null;
                }
                return changed;
            }

            @Override
            public void clear() {
                MutableDoubleArrayTrie.this.clear();
            }
        };
    }

    @Override
    public Collection<V> values() {
        return this.values;
    }

    @Override
    public Set<Map.Entry<String, V>> entrySet() {
        return new Set<Map.Entry<String, V>>(){

            @Override
            public int size() {
                return MutableDoubleArrayTrie.this.trie.size();
            }

            @Override
            public boolean isEmpty() {
                return MutableDoubleArrayTrie.this.trie.isEmpty();
            }

            @Override
            public boolean contains(Object o) {
                throw new UnsupportedOperationException();
            }

            @Override
            public Iterator<Map.Entry<String, V>> iterator() {
                return new Iterator<Map.Entry<String, V>>(){
                    MutableDoubleArrayTrieInteger.KeyValuePair iterator;
                    {
                        this.iterator = MutableDoubleArrayTrie.this.trie.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.iterator.hasNext();
                    }

                    @Override
                    public Map.Entry<String, V> next() {
                        this.iterator.next();
                        return new AbstractMap.SimpleEntry(this.iterator.key(), MutableDoubleArrayTrie.this.values.get(this.iterator.value()));
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            @Override
            public Object[] toArray() {
                throw new UnsupportedOperationException();
            }

            @Override
            public <T> T[] toArray(T[] a) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean add(Map.Entry<String, V> stringVEntry) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean remove(Object o) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean containsAll(Collection<?> c) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean addAll(Collection<? extends Map.Entry<String, V>> c) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean retainAll(Collection<?> c) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean removeAll(Collection<?> c) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void clear() {
                MutableDoubleArrayTrie.this.clear();
            }
        };
    }

    @Override
    public Iterator<Map.Entry<String, V>> iterator() {
        return this.entrySet().iterator();
    }
}

