/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.util;

import com.intellij.ide.ui.UISettings;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import javax.swing.Icon;
import javax.swing.JLabel;
import org.jetbrains.annotations.NotNull;

public class TextIcon
implements Icon {
    @NotNull
    private final String myText;
    private final int myControlWidth;
    private final int myControlHeight;
    private int myTextHeight;

    public TextIcon(@NotNull String text) {
        if (text == null) {
            TextIcon.$$$reportNull$$$0(0);
        }
        this.myText = text;
        JLabel label = new JLabel("");
        Font font = label.getFont();
        FontMetrics metrics = label.getFontMetrics(font);
        this.myControlWidth = metrics.stringWidth(text) + 4;
        this.myControlHeight = font.getSize();
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        UISettings.setupAntialiasing((Graphics)g);
        if (this.myTextHeight <= 0) {
            this.myTextHeight = g.getFont().createGlyphVector((FontRenderContext)((Graphics2D)g).getFontRenderContext(), (String)this.myText).getPixelBounds(null, (float)0.0f, (float)0.0f).height;
        }
        g.setColor(UIUtil.getLabelForeground());
        g.drawString(this.myText, x + 2, y + this.myControlHeight - (this.myControlHeight - this.myTextHeight) / 2);
    }

    @Override
    public int getIconWidth() {
        return this.myControlWidth;
    }

    @Override
    public int getIconHeight() {
        return this.myControlHeight;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/plugins/gradle/util/TextIcon", "<init>"));
    }
}

