/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.maven.server.m40.compat;

import com.intellij.util.text.VersionComparatorUtil;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Optional;
import org.apache.maven.api.cli.InvokerRequest;
import org.apache.maven.api.cli.mvn.MavenOptions;
import org.apache.maven.cling.invoker.mvn.MavenContext;
import org.jetbrains.annotations.Nullable;

public class MavenContextFactory {
    public static MavenContext createMavenContext(InvokerRequest invokerRequest) {
        String mavenVersion = System.getProperty("idea.maven.embedder.version");
        if (VersionComparatorUtil.compare((String)mavenVersion, (String)"4.0.0-rc-3") == 0) {
            return new MavenContext(invokerRequest, false);
        }
        Constructor<?>[] constructors = MavenContext.class.getConstructors();
        if (constructors.length != 1) {
            throw new UnsupportedOperationException("MavenContext incompatibility with current IDEA version");
        }
        try {
            MavenOptions options = MavenContextFactory.getOptions(invokerRequest);
            return (MavenContext)constructors[0].newInstance(invokerRequest, false, options);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new UnsupportedOperationException("MavenContext incompatibility with current IDEA version", e);
        }
    }

    @Nullable
    private static MavenOptions getOptions(InvokerRequest invokerRequest) {
        try {
            Method method = InvokerRequest.class.getMethod("options", new Class[0]);
            Optional options = (Optional)method.invoke((Object)invokerRequest, new Object[0]);
            return options.orElse(null);
        }
        catch (Exception e) {
            throw new UnsupportedOperationException("MavenContext incompatibility with current IDEA version", e);
        }
    }
}

